//========================================================================================
//  VideoController.java
//    en:Video controller
//    ja:ビデオコントローラ
//  Copyright (C) 2003-2025 Makoto Kamada
//
//  This file is part of the XEiJ (X68000 Emulator in Java).
//  You can use, modify and redistribute the XEiJ if the conditions are met.
//  Read the XEiJ License for more details.
//  https://stdkmd.net/xeij/
//========================================================================================

//----------------------------------------------------------------------------------------
//
//  ビデオコントローラのレジスタ
//    アドレスのbit7-1はデコードされない
//    0x00e82400  REG1
//    0x00e82402  REG1
//         :       :
//    0x00e824fe  REG1
//    0x00e82500  REG2
//    0x00e82502  REG2
//         :       :
//    0x00e825fe  REG2
//    0x00e82600  REG3
//    0x00e82602  REG3
//         :       :
//    0x00e826fe  REG3
//
//  0x00e82400 REG1
//      bit2-0  GrMM  メモリモード
//                      0  512ドット16色
//                      1  512ドット256色
//                      3  512ドット65536色
//                      4  1024ドット16色
//                      5  1024ドット256色(XEiJ拡張)
//                      7  1024ドット65536色(XEiJ拡張)
//
//  0x00e82500 REG2
//    bit13-12  SpPr  スプライト画面の優先順位。0=高,1=中,2=低
//    bit11-10  TxPr  テキスト画面の優先順位。0=高,1=中,2=低
//      bit9-8  GrPr  グラフィック画面の優先順位。0=手前,1=間,2=奥,3=単独
//      bit7-6  G4th  (512ドット16色のとき)4番目のパレットの4bitページ番号
//                    (512ドット256色のとき)2番目のパレットのbit7-4の4bitページ番号
//                    (512ドット65536色のとき)1番目のパレットのbit15-12の4bitページ番号
//                    (1024ドットのとき)右下512×512の4bitページ番号
//      bit5-4  G3rd  (512ドット16色のとき)3番目のパレットの4bitページ番号
//                    (512ドット256色のとき)2番目のパレットのbit3-0の4bitページ番号
//                    (512ドット65536色のとき)1番目のパレットのbit11-8の4bitページ番号
//                    (1024ドットのとき)左下512×512の4bitページ番号
//      bit3-2  G2nd  (512ドット16色のとき)2番目のパレットの4bitページ番号
//                    (512ドット256色のとき)1番目のパレットのbit7-4の4bitページ番号
//                    (512ドット65536色のとき)1番目のパレットのbit7-4の4bitページ番号
//                    (1024ドットのとき)右上512×512の4bitページ番号
//      bit1-0  G1st  (512ドット16色のとき)1番目のパレットの4bitページ番号
//                    (512ドット256色のとき)1番目のパレットのbit3-0の4bitページ番号
//                    (512ドット65536色のとき)1番目のパレットのbit3-0の4bitページ番号
//                    (1024ドットのとき)左上512×512の4bitページ番号
//
//  0x00e82600 REG3
//       bit15  Ys    (非対応)1=スーパーインポーズのときコンピュータ画面のみ表示
//       bit14  AHOn  1=グラフィックカラーとテキストパレット0のカラーを混ぜる(A)
//       bit13  VHT   (非対応)1=1番目とTVを半透明
//       bit12  ExOn  0=拡張なし,1=拡張あり(X)
//       bit11  Half  拡張モードの選択。0=特殊プライオリティ(W),1=半透明(H)
//       bit10  PLSB  領域指定。0=カラー(パレットテーブルの内容)が奇数(C),1=パレット(GVRAMの内容)が奇数(P)
//        bit9  GrGr  (半透明のとき)1=1番目と2番目を半透明(G)
//        bit8  GrST  (半透明のとき)1=1番目と奥のスプライト・テキスト画面を半透明(T)
//        bit7  BCOn  (非対応)1=ボーダーカラーを表示
//        bit6  SpOn  1=スプライト画面を表示(S)
//        bit5  TxOn  1=テキスト画面を表示(T)
//        bit4  GxOn  (1024ドット16色のとき)1=1番目を表示
//                    (1024ドット256色のとき)1=1番目を表示
//                    (1024ドット65536色のとき)1=1番目を表示
//        bit3  G4On  (512ドット16色のとき)1=4番目を表示
//                    (512ドット256色のとき)1=2番目を表示
//                    (512ドット65536色のとき)1=1番目を表示
//        bit2  G3On  (512ドット16色のとき)1=3番目を表示
//                    (512ドット256色のとき)1=2番目を表示
//                    (512ドット65536色のとき)1=1番目を表示
//        bit1  G2On  (512ドット16色のとき)1=2番目を表示
//                    (512ドット256色のとき)1=1番目を表示
//                    (512ドット65536色のとき)1=1番目を表示
//        bit0  G1On  (512ドット16色のとき)1=1番目を表示
//                    (512ドット256色のとき)1=1番目を表示
//                    (512ドット65536色のとき)1=1番目を表示
//
//  スプライト画面とテキスト画面の優先順位
//    スプライト画面とテキスト画面は優先順位が小さい方が手前で大きい方が奥。優先順位が同じときはテキスト画面が手前
//      (スプライト画面の優先順位)<(テキスト画面の優先順位)のとき
//        スプライト＞テキスト
//      (テキスト画面の優先順位)<=(スプライト画面の優先順位)のとき
//        テキスト＞スプライト
//                          TxPr
//                   0     1     2     3
//                 -----+
//              0   T>S | S>T   S>T   S>T
//                      +-----+
//              1   T>S   T>S | S>T   S>T
//        SpPr                +-----+
//              2   T>S   T>S   T>S | S>T
//                                  +-----
//              3   T>S   T>S   T>S   T>S
//    X68030の実機で確認済み
//    参考
//      https://twitter.com/kugimoto0715/status/622435791705214976
//
//  スプライトプレーン
//    スプライトプレーン1  スプライトスクロールレジスタの優先順位が1のスプライトを配置するプレーン
//    スプライトプレーン2  スプライトスクロールレジスタの優先順位が2のスプライトを配置するプレーン
//    スプライトプレーン3  スプライトスクロールレジスタの優先順位が3のスプライトを配置するプレーン
//    スプライトスクロールレジスタの優先順位が0のスプライトは表示されない
//
//  4bitパレット
//    スプライト画面の8bitパレットの下位4bit
//    テキスト画面のパレット
//
//  8bitパレット
//    上位4bitがパレットブロック、下位4bitが4bitパレット
//    テキスト画面のパレットブロックは常に$0
//
//  スプライトプレーンとバックグラウンドプレーンの重ね合わせ
//    表示されていないバックグラウンドプレーンの8bitパレットは$00とみなす
//    スプライト画面から出力する8bitパレットを以下の手順で決定する
//      スプライトプレーン3の4bitパレットが$0でないとき
//        スプライトプレーン3の8bitパレット
//      スプライトプレーン3の4bitパレットが$0のとき
//        バックグラウンドプレーン0の4bitパレットが$0でないとき
//          バックグラウンドプレーン0の8bitパレット
//        バックグラウンドプレーン0の4bitパレットが$0のとき
//          スプライトプレーン2の4bitパレットが$0でないとき
//            スプライトプレーン2の8bitパレット
//          スプライトプレーン2の4bitパレットが$0のとき
//            バックグラウンドプレーン1の4bitパレットが$0でないとき
//              バックグラウンドプレーン1の8bitパレット
//            バックグラウンドプレーン1の4bitパレットが$0のとき
//              スプライトプレーン1の4bitパレットが$0でないとき
//                スプライトプレーン1の8bitパレット
//              スプライトプレーン1の4bitパレットが$0のとき
//                バックグラウンドプレーン1の8bitパレットが$00でないとき
//                  バックグラウンドプレーン1の8bitパレット
//                バックグラウンドプレーン1の8bitパレットが$00のとき
//                  バックグラウンドプレーン0の8bitパレット($00を含む)
//
//  スプライト画面とテキスト画面を代表する画面
//    スプライト画面とテキスト画面とグラフィック画面を3枚同時に重ね合わせることはしない
//    スプライト画面とテキスト画面のどちらかを代表する画面として残し、他方をグラフィック画面と重ね合わせる前に除外する
//    スプライト画面とテキスト画面を代表する画面は以下の手順で決定する
//      スプライト画面とテキスト画面のどちらかの4bitパレットが$0でないとき
//        4bitパレットが$0でない手前にある方
//      スプライト画面とテキスト画面の4bitパレットが両方$0のとき
//        スプライト画面の8bitパレットが$00でないとき
//          スプライト画面
//        スプライト画面の8bitパレットが$00のとき
//          奥にある方(表示されているとは限らない)
//    まとめ
//      $+は$0以外、$?は任意
//      スプライト(OFF)はスプライト$00、テキスト(OFF)はテキスト$0とみなす
//         優先順位とパレット      代表する画面
//      スプライト$00＞テキスト$0    テキスト$0   すべて$00ならば奥にある方
//      スプライト$00＞テキスト$+    テキスト$+   $?+で手前にある方
//      スプライト$+0＞テキスト$0  スプライト$+0  すべて$?0でスプライトが$00でなければスプライト
//      スプライト$+0＞テキスト$+    テキスト$+   $?+で手前にある方
//      スプライト$?+＞テキスト$0  スプライト$?+  $?+で手前にある方
//      スプライト$?+＞テキスト$+  スプライト$?+  $?+で手前にある方
//      テキスト$0＞スプライト$00  スプライト$00  すべて$00ならば奥にある方
//      テキスト$+＞スプライト$00    テキスト$+   $?+で手前にある方
//      テキスト$0＞スプライト$+0  スプライト$+0  すべて$?0でスプライトが$00でなければスプライト
//      テキスト$+＞スプライト$+0    テキスト$+   $?+で手前にある方
//      テキスト$0＞スプライト$?+  スプライト$?+  $?+で手前にある方
//      テキスト$+＞スプライト$?+    テキスト$+   $?+で手前にある方
//    スプライト＞テキストのとき
//      スプライトが$?+または(スプライトが$00以外かつテキストが$0)ならばスプライトが代表する画面
//      スプライトが$00または(スプライトが$?0かつテキストが$+)ならばテキストが代表する画面
//    スプライト(OFF)＞テキストのとき
//      スプライトが$00
//      テキストが代表する画面
//    スプライト＞テキスト(OFF)のとき
//      テキストが$0
//      スプライトが$00以外ならばスプライトが代表する画面
//      スプライトが$00ならばテキスト(OFF)が代表する画面
//    スプライト→テキストのとき
//      スプライトとテキストが連続しているときテキスト$0をスプライト$00として出力しても問題ない
//      スプライトが$?+またはテキストが$0ならばスプライトが代表する画面
//      スプライトが$?0かつテキストが$+ならばテキストが代表する画面
//    スプライト(OFF)→テキストのとき
//      スプライトが$00
//      テキストが代表する画面
//    スプライト→テキスト(OFF)のとき
//      テキストが$0
//      スプライトとテキストが連続しているときテキスト$0をスプライト$00として出力しても問題ない
//      スプライトが代表する画面
//    テキスト＞スプライトのとき
//      テキストが$+ならばテキストが代表する画面
//      テキストが$0ならばスプライトが代表する画面
//    テキスト(OFF)＞スプライトのとき
//      テキストが$0
//      スプライトが代表する画面
//    テキスト＞スプライト(OFF)のとき
//      スプライトが$00
//      テキストが$+ならばテキストが代表する画面
//      テキストが$0ならばスプライト(OFF)が代表する画面
//
//  スプライト・バックグラウンド・テキストのゼロプライオリティ
//    グラフィック画面と同じ要領でスプライトでバックグラウンドやテキストに穴を開けるといったことができる
//    グラフィック画面のゼロプライオリティと異なるのはスプライト・バックグラウンドとテキストの間にグラフィック画面が挟まっている
//    場合があることだが、グラフィック画面よりも手前にあるスプライト・バックグラウンドまたはテキストによるゼロプライオリティで
//    グラフィック画面よりも奥にあるスプライト・バックグラウンドまたはテキストにも穴が空くことに変わりはない
//    そのときグラフィック画面のカラーが0ならは画面は黒になる
//
//  4bitページ
//    GVRAMに格納されている512×512個のパレットコードの一部(4bit)の配列
//    1個あたり16bit(2バイト)の領域が割り当てられる。通常は下位4bitのみ有効で上位12bitは常に0
//    4bitページ0  512ドット16色のとき0x00c00000-0x00c7ffffに配置される4bitページ
//    4bitページ1  512ドット16色のとき0x00c80000-0x00cfffffに配置される4bitページ
//    4bitページ2  512ドット16色のとき0x00d00000-0x00d7ffffに配置される4bitページ
//    4bitページ3  512ドット16色のとき0x00d80000-0x00dfffffに配置される4bitページ
//
//  1番目
//    グラフィック画面で最も手前に表示されるプレーンまたはそこに割り当てられているページまたはそれを構成するパレットコードの配列
//    G1On=1のときだけ表示される
//    512ドット16色のとき
//      4bitパレットコードのbit3-0はG1stの4bitページから供給される
//    512ドット256色のとき
//      8bitパレットコードのbit7-4はG2ndの4bitページから供給される
//      8bitパレットコードのbit3-0はG1stの4bitページから供給される
//    512ドット65536色のとき
//      16bitパレットコードのbit15-12はG4thの4bitページから供給される
//      16bitパレットコードのbit11-8はG3rdの4bitページから供給される
//      16bitパレットコードのbit7-4はG2ndの4bitページから供給される
//      16bitパレットコードのbit3-0はG1stの4bitページから供給される
//    1024ドット16色のとき
//      左上512×512の4bitパレットコードのbit3-0はG1stの4bitページから供給される
//      右上512×512の4bitパレットコードのbit3-0はG2ndの4bitページから供給される
//      左下512×512の4bitパレットコードのbit3-0はG3rdの4bitページから供給される
//      右下512×512の4bitパレットコードのbit3-0はG4thの4bitページから供給される
//
//  2番目
//    グラフィック画面で手前から2番目に表示されるプレーンまたはそこに割り当てられているページまたはそれを構成するパレットコードの配列
//    G2On=1のときだけ表示される。ただし、1番目と2番目の半透明を行うとG2On=0でも2番目の内容が反映される
//    512ドット16色のとき
//      4bitパレットコードのbit3-0はG2ndの4bitページから供給される
//    512ドット256色のとき
//      8bitパレットコードのbit7-4はG4thの4bitページから供給される
//      8bitパレットコードのbit3-0はG3rdの4bitページから供給される
//
//  3番目
//    グラフィック画面で手前から3番目に表示されるプレーンまたはそこに割り当てられているページまたはそれを構成するパレットコードの配列
//    G3On=1のときだけ表示される
//    512ドット16色のとき
//      4bitパレットコードのbit3-0はG3rdの4bitページから供給される
//
//  4番目
//    グラフィック画面で手前から4番目に表示されるプレーンまたはそこに割り当てられているページまたはそれを構成するパレットコードの配列
//    G4On=1のときだけ表示される
//    512ドット16色のとき
//      4bitパレットコードのbit3-0はG4thの4bitページから供給される
//
//  0でない1番目
//    1番目のパレットが0でないとき
//      1番目
//    1番目のパレットが0のとき
//      2番目のパレットが0でないとき
//        2番目
//      2番目のパレットが0のとき
//        3番目のパレットが0でないとき
//          3番目
//        3番目のパレットが0のとき
//          4番目のパレットが0でないとき
//            4番目
//          4番目のパレットが0のとき
//            なし
//
//  グラフィック画面のプレーンの重ね合わせ
//    0でない1番目のパレット(なければ0)に対応するカラーがグラフィック画面のカラーとして出力される
//    カラーが0ならばグラフィック画面は透明になり、奥にあるスプライト画面またはテキスト画面が見える。奥に何もなければ画面は黒
//
//  グラフィック画面のゼロプライオリティ
//    重ね合わせの仕組みから明らかなように、グラフィック画面の中で手前にあるプレーンにパレットが0以外でカラーが0のピクセルを配置すると、
//    奥にあるパレットもカラーも0でない普通ならば透明にならないプレーンに穴が空いて、さらに奥にあるスプライト画面またはテキスト画面が見える
//
//  スプライト画面とテキスト画面とグラフィック画面の優先順位
//    GrPr=0のとき
//      グラフィック画面はスプライト画面とテキスト画面の手前
//                              TxPr
//                    0       1       2       3
//                 -------+
//              0   G>T>S | G>S>T   G>S>T   G>S>T
//                        +-------+
//              1   G>T>S   G>T>S | G>S>T   G>S>T
//        SpPr                    +-------+
//              2   G>T>S   G>T>S   G>T>S | G>S>T
//                                        +-------
//              3   G>T>S   G>T>S   G>T>S   G>T>S
//    GrPr=1のとき
//      グラフィック画面はスプライト画面とテキスト画面の間
//                              TxPr
//                    0       1       2       3
//                 -------+
//              0   T>G>S | S>G>T   S>G>T   S>G>T
//                        +-------+
//              1   T>G>S   T>G>S | S>G>T   S>G>T
//        SpPr                    +-------+
//              2   T>G>S   T>G>S   T>G>S | S>G>T
//                                        +-------
//              3   T>G>S   T>G>S   T>G>S   T>G>S
//    GrPr=2のとき
//      グラフィック画面はスプライト画面とテキスト画面の奥
//                              TxPr
//                    0       1       2       3
//                 -------+
//              0   T>S>G | S>T>G   S>T>G   S>T>G
//                        +-------+
//              1   T>S>G   T>S>G | S>T>G   S>T>G
//        SpPr                    +-------+
//              2   T>S>G   T>S>G   T>S>G | S>T>G
//                                        +-------
//              3   T>S>G   T>S>G   T>S>G   T>S>G
//    GrPr=3のとき
//      グラフィック画面はスプライト画面とテキスト画面の手前で、スプライト画面とテキスト画面はOFF
//        グラフィック画面とスプライト・テキスト画面の半透明を行うとテキストパレット0のカラーが反映されることから、
//        グラフィック画面の奥にスプライト画面とテキスト画面があると解釈できる
//        スプライト画面とテキスト画面のどちらが手前かは結果に影響しない
//                              TxPr
//                    0       1       2       3
//                 -------+
//              0   G>t>s | G>s>t   G>s>t   G>s>t
//                        +-------+
//              1   G>t>s   G>t>s | G>s>t   G>s>t
//        SpPr                    +-------+
//              2   G>t>s   G>t>s   G>t>s | G>s>t
//                                        +-------
//              3   G>t>s   G>t>s   G>t>s   G>t>s
//    X68030の実機で確認済み
//    参考
//      https://twitter.com/kugimoto0715/status/622436279439921152
//      https://twitter.com/kugimoto0715/status/622436573343145984
//
//  スプライト画面とテキスト画面とグラフィック画面の重ね合わせ
//    手前の画面のカラーが0以外(不透明)ならば手前の画面が表示される
//    手前の画面のカラーが0(透明)ならば奥の画面が表示される
//    例1
//      「テキスト＞グラフィック」でテキスト画面のパレットが$0で不透明、グラフィック画面も不透明のとき、
//       表示されていないスプライト画面の優先順位がグラフィック画面よりも手前にあるか奥にあるかで表示が異なる
//       テキスト画面のパレットが$0で、表示されていないスプライト画面のパレットも$00なので、奥にある方が代表する画面になる
//      「テキスト＞スプライト＞グラフィック」ならばスプライト画面のパレット$00(不透明)が表示され、
//      「テキスト＞グラフィック＞スプライト」ならばグラフィック画面(不透明)が表示される
//    例2
//      「バックグラウンド$30黄＞グラフィック2赤＞テキスト0黒⇒黄」
//      「バックグラウンド$30黄＞グラフィック2赤＞テキスト1灰⇒赤」
//      バックグラウンド(タイル張り最大15色)とグラフィック(不透明であること以外に制約なし)のどちらを表示するか
//      テキストでドット毎に選択できる
//    例3
//      「バックグラウンド$00灰＞テキスト0灰＞グラフィクス2赤⇒灰」
//      「テキスト0灰＞バックグラウンド$00灰＞グラフィクス2赤⇒灰」
//      「バックグラウンド$00灰＞グラフィクス2赤＞テキスト0灰⇒赤」
//      「テキスト0灰＞グラフィクス2赤＞バックグラウンド$00灰⇒赤」
//
//  特殊プライオリティ(XWC)
//    概要
//      優先順位に関わらず0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のパレットのカラーだけ表示する
//    SE4T_XWCの手順
//      1番目のパレットが0でないとき
//        1番目のパレットを偶数化したパレットのカラーが奇数のとき
//          1番目のカラー(0は黒)
//        さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//          スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//            スプライトカラーが0でないとき
//              スプライトカラー
//            さもなくば(スプライトカラーが0のとき)
//              1番目のカラー(0は黒)
//          さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//            1番目のカラーが0でないとき
//              1番目のカラー
//            さもなくば(1番目のカラーが0のとき)
//              テキストカラー(0は黒)
//      さもなくば(1番目のパレットが0のとき)
//        2番目のパレットが0でないとき
//          2番目のパレットを偶数化したパレットのカラーが奇数のとき
//            2番目のカラー(0は黒)
//          さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//            スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//              スプライトカラーが0でないとき
//                スプライトカラー
//              さもなくば(スプライトカラーが0のとき)
//                2番目のカラー(0は黒)
//            さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//              2番目のカラーが0でないとき
//                2番目のカラー
//              さもなくば(2番目のカラーが0のとき)
//                テキストカラー(0は黒)
//        さもなくば(2番目のパレットが0のとき)
//          3番目のパレットが0でないとき
//            3番目のパレットを偶数化したパレットのカラーが奇数のとき
//              3番目のカラー(0は黒)
//            さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//                スプライトカラーが0でないとき
//                  スプライトカラー
//                さもなくば(スプライトカラーが0のとき)
//                  3番目のカラー(0は黒)
//              さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//                3番目のカラーが0でないとき
//                  3番目のカラー
//                さもなくば(3番目のカラーが0のとき)
//                  テキストカラー(0は黒)
//          さもなくば(3番目のパレットが0のとき)
//            4番目のパレットを偶数化したパレットのカラーが奇数のとき
//              4番目のカラー(0は黒)
//            さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//                スプライトカラーが0でないとき
//                  スプライトカラー
//                さもなくば(スプライトカラーが0のとき)
//                  4番目のカラー(0は黒)
//              さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//                4番目のカラーが0でないとき
//                  4番目のカラー
//                さもなくば(4番目のカラーが0のとき)
//                  テキストカラー(0は黒)
//
//  特殊プライオリティ(XWP)
//    概要
//      優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
//    SE4T_XWPの手順
//      1番目のパレットが0のとき
//        スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//          スプライトカラーが0でないとき
//            スプライトカラー
//          さもなくば(スプライトカラーが0のとき)
//            2番目のパレットを偶数化したパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//              3番目のパレットを偶数化したパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラー(0は黒)
//        さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//          2番目のパレットを偶数化したパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが0でないとき
//              2番目のパレットを偶数化したパレットのカラー
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
//              テキストカラー(0は黒)
//          さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//            3番目のパレットを偶数化したパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが0でないとき
//                3番目のパレットを偶数化したパレットのカラー
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//            さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが0でないとき
//                4番目のパレットを偶数化したパレットのカラー
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//      1番目のパレットが1のとき
//        スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//          スプライトカラーが0でないとき
//            スプライトカラー
//          さもなくば(スプライトカラーが0のとき)
//            グラフィックパレット0のカラー(0は黒)
//        さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//          グラフィックパレット0のカラーが0でないとき
//            グラフィックパレット0のカラー
//          さもなくば(グラフィックパレット0のカラーが0のとき)
//            テキストカラー(0は黒)
//      1番目のパレットが2以上の偶数のとき
//        スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//          スプライトカラーが0でないとき
//            スプライトカラー
//          さもなくば(スプライトカラーが0のとき)
//            1番目のカラー(0は黒)
//        さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//          1番目のカラーが0でないとき
//            1番目のカラー
//          さもなくば(1番目のカラーが0のとき)
//            テキストカラー(0は黒)
//      さもなくば(1番目のパレットが3以上の奇数のとき)
//        1番目のパレットを偶数化したパレットのカラー(0は黒)
//
//  半透明(XHCT)
//    概要
//      0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
//    65536色の場合
//      IOCSの65536色の標準パレットテーブルはパレットとカラーが同じなのでそのまま使うと領域指定なしの半透明モードになる
//      参考
//        http://www.geocities.jp/winx68khighspeed/nisshi.html
//    SE4T_XHCTの手順
//      スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//        スプライトカラーが0でないとき
//          スプライトカラー
//        さもなくば(スプライトカラーが0のとき)
//          1番目のパレットが0でないとき
//            1番目のパレットを偶数化したパレットのカラーが奇数のとき
//              1番目のカラーとカラー0を混ぜたカラー(0は黒)
//            さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              1番目のカラー(0は黒)
//          さもなくば(1番目のパレットが0のとき)
//            2番目のパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラーが奇数のとき
//                2番目のカラーとカラー0を混ぜたカラー(0は黒)
//              さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                2番目のカラー(0は黒)
//            さもなくば(2番目のパレットが0のとき)
//              3番目のパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラーが奇数のとき
//                  3番目のカラーとカラー0を混ぜたカラー(0は黒)
//                さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                  3番目のカラー(0は黒)
//              さもなくば(3番目のパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラーが奇数のとき
//                  4番目のカラーとカラー0を混ぜたカラー(0は黒)
//                さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                  4番目のカラー(0は黒)
//      さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//        1番目のパレットが0でないとき
//          1番目のパレットを偶数化したパレットのカラーが奇数のとき
//            1番目のカラーと
//              テキストカラー(0は黒)
//            を混ぜたカラー(0は黒)
//          さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//            1番目のカラーが0でないとき
//              1番目のカラー
//            さもなくば(1番目のカラーが0のとき)
//              テキストカラー(0は黒)
//        さもなくば(1番目のパレットが0のとき)
//          2番目のパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが奇数のとき
//              2番目のカラーと
//                テキストカラー(0は黒)
//              を混ぜたカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              2番目のカラーが0でないとき
//                2番目のカラー
//              さもなくば(2番目のカラーが0のとき)
//                テキストカラー(0は黒)
//          さもなくば(2番目のパレットが0のとき)
//            3番目のパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが奇数のとき
//                3番目のカラーと
//                  テキストカラー(0は黒)
//                を混ぜたカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                3番目のカラーが0でないとき
//                  3番目のカラー
//                さもなくば(3番目のカラーが0のとき)
//                  テキストカラー(0は黒)
//            さもなくば(3番目のパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが奇数のとき
//                4番目のカラーと
//                  テキストカラー(0は黒)
//                を混ぜたカラー(0は黒)
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                4番目のカラーが0でないとき
//                  4番目のカラー
//                さもなくば(4番目のカラーが0のとき)
//                  テキストカラー(0は黒)
//
//  半透明(XHCG)
//    概要
//      0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
//    例
//      パレット2=赤(偶数)、3=青、4=赤紫、5=水色のとき
//        ----------  ----------  ----------
//        1番目       2番目       出力
//        ----------  ----------  ----------
//        2=赤(偶数)  2=赤(偶数)  赤
//        2=赤(偶数)  3=青        赤
//        2=赤(偶数)  4=赤紫      赤
//        2=赤(偶数)  5=水色      赤
//        3=青        2=赤(偶数)  青
//        3=青        3=青        青
//        3=青        4=赤紫      水色
//        3=青        5=水色      水色
//        ----------  ----------  ----------
//      パレット2=赤(奇数)、3=青、4=赤紫、5=水色のとき
//        ----------  ----------  ----------
//        1番目       2番目       出力
//        ----------  ----------  ----------
//        2=赤(奇数)  2=赤(奇数)  紫
//        2=赤(奇数)  3=青        紫
//        2=赤(奇数)  4=赤紫      灰色
//        2=赤(奇数)  5=水色      灰色
//        3=青        2=赤(奇数)  紫
//        3=青        3=青        紫
//        3=青        4=赤紫      灰色
//        3=青        5=水色      灰色
//        ----------  ----------  ----------
//    SE4T_XHCGの手順
//      スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//        スプライトカラーが0でないとき
//          スプライトカラー
//        さもなくば(スプライトカラーが0のとき)
//          1番目のパレットが0でないとき
//            1番目のパレットを偶数化したパレットのカラーが奇数のとき
//              1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
//            さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              1番目のパレットが奇数のとき
//                2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
//              さもなくば(1番目のパレットが偶数のとき)
//                1番目のカラー(0は黒)
//          さもなくば(1番目のパレットが0のとき)
//            2番目のパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラーが奇数のとき
//                2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
//              さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                2番目のカラー(0は黒)
//            さもなくば(2番目のパレットが0のとき)
//              3番目のパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラーが奇数のとき
//                  3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
//                さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                  3番目のパレットが奇数のとき
//                    パレット1のカラー(0は黒)
//                  さもなくば(3番目のパレットが偶数のとき)
//                    3番目のカラー(0は黒)
//              さもなくば(3番目のパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラーが奇数のとき
//                  4番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
//                さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                  4番目のパレットが奇数のとき
//                    パレット1のカラー(0は黒)
//                  さもなくば(4番目のパレットが偶数のとき)
//                    4番目のカラー(0は黒)
//      さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//        1番目のパレットが0でないとき
//          1番目のパレットを偶数化したパレットのカラーが奇数のとき
//            1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
//          さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//            1番目のパレットが奇数のとき
//              2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0でないとき
//                2番目(ONとみなす)のパレットを奇数化したパレットのカラー
//              さもなくば(2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//            さもなくば(1番目のパレットが偶数のとき)
//              1番目のカラーが0でないとき
//                1番目のカラー
//              さもなくば(1番目のカラーが0のとき)
//                テキストカラー(0は黒)
//        さもなくば(1番目のパレットが0のとき)
//          2番目のパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが奇数のとき
//              2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              2番目のカラーが0でないとき
//                2番目のカラー
//              さもなくば(2番目のカラーが0のとき)
//                テキストカラー(0は黒)
//          さもなくば(2番目のパレットが0のとき)
//            3番目のパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが奇数のとき
//                3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                3番目のパレットが奇数のとき
//                  パレット1のカラーが0でないとき
//                    パレット1のカラー
//                  さもなくば(パレット1のカラーが0のとき)
//                    テキストカラー(0は黒)
//                さもなくば(3番目のパレットが偶数のとき)
//                  3番目のカラーが0でないとき
//                    3番目のカラー
//                  さもなくば(3番目のカラーが0のとき)
//                    テキストカラー(0は黒)
//            さもなくば(3番目のパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが奇数のとき
//                4番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                4番目のパレットが奇数のとき
//                  パレット1のカラーが0でないとき
//                    パレット1のカラー
//                  さもなくば(パレット1のカラーが0のとき)
//                    テキストカラー(0は黒)
//                さもなくば(4番目のパレットが偶数のとき)
//                  4番目のカラーが0でないとき
//                    4番目のカラー
//                  さもなくば(4番目のカラーが0のとき)
//                    テキストカラー(0は黒)
//
//  半透明(XHCGT)
//    概要
//      0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
//    SE4T_XHCGTの手順
//      スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//        スプライトカラーが0でないとき
//          スプライトカラー
//        さもなくば(スプライトカラーが0のとき)
//          1番目のパレットが0でないとき
//            1番目のパレットを偶数化したパレットのカラーが奇数のとき
//              1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
//            さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              1番目のパレットが奇数のとき
//                2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
//              さもなくば(1番目のパレットが偶数のとき)
//                1番目のカラー(0は黒)
//          さもなくば(1番目のパレットが0のとき)
//            2番目のパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラーが奇数のとき
//                2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
//              さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                2番目のカラー(0は黒)
//            さもなくば(2番目のパレットが0のとき)
//              3番目のパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラーが奇数のとき
//                  3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
//                さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                  3番目のパレットが奇数のとき
//                    パレット1のカラー(0は黒)
//                  さもなくば(3番目のパレットが偶数のとき)
//                    3番目のカラー(0は黒)
//              さもなくば(3番目のパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラーが奇数のとき
//                  4番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
//                さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                  4番目のパレットが奇数のとき
//                    パレット1のカラー(0は黒)
//                  さもなくば(4番目のパレットが偶数のとき)
//                    4番目のカラー(0は黒)
//      さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//        1番目のパレットが0でないとき
//          1番目のパレットを偶数化したパレットのカラーが奇数のとき
//            1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
//              テキストカラー(0は黒)
//            を混ぜたカラー(0は黒)
//          さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
//            1番目のパレットが奇数のとき
//              2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0でないとき
//                2番目(ONとみなす)のパレットを奇数化したパレットのカラー
//              さもなくば(2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//            さもなくば(1番目のパレットが偶数のとき)
//              1番目のカラーが0でないとき
//                1番目のカラー
//              さもなくば(1番目のカラーが0のとき)
//                テキストカラー(0は黒)
//        さもなくば(1番目のパレットが0のとき)
//          2番目のパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが奇数のとき
//              2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
//                テキストカラー(0は黒)
//              を混ぜたカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
//              2番目のカラーが0でないとき
//                2番目のカラー
//              さもなくば(2番目のカラーが0のとき)
//                テキストカラー(0は黒)
//          さもなくば(2番目のパレットが0のとき)
//            3番目のパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが奇数のとき
//                3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらに
//                  テキストカラー(0は黒)
//                を混ぜたカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                3番目のパレットが奇数のとき
//                  パレット1のカラーが0でないとき
//                    パレット1のカラー
//                  さもなくば(パレット1のカラーが0のとき)
//                    テキストカラー(0は黒)
//                さもなくば(3番目のパレットが偶数のとき)
//                  3番目のカラーが0でないとき
//                    3番目のカラー
//                  さもなくば(3番目のカラーが0のとき)
//                    テキストカラー(0は黒)
//            さもなくば(3番目のパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが奇数のとき
//                4番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらに
//                  テキストカラー(0は黒)
//                を混ぜたカラー(0は黒)
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
//                4番目のパレットが奇数のとき
//                  パレット1のカラーが0でないとき
//                    パレット1のカラー
//                  さもなくば(パレット1のカラーが0のとき)
//                    テキストカラー(0は黒)
//                さもなくば(4番目のパレットが偶数のとき)
//                  4番目のカラーが0でないとき
//                    4番目のカラー
//                  さもなくば(4番目のカラーが0のとき)
//                    テキストカラー(0は黒)
//
//  半透明(XHPT)
//    概要
//      1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
//    SE4T_XHPTの手順
//      スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//        スプライトカラーが0でないとき
//          スプライトカラー
//        さもなくば(スプライトカラーが0のとき)
//          1番目のパレットが0のとき
//            2番目のパレットを偶数化したパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//              3番目のパレットを偶数化したパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラー(0は黒)
//          1番目のパレットが1のとき
//            グラフィックパレット0のカラー(0は黒)
//          1番目のパレットが2以上の偶数のとき
//            1番目のカラー(0は黒)
//          さもなくば(1番目のパレットが3以上の奇数のとき)
//            1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
//      さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//        1番目のパレットが0のとき
//          2番目のパレットを偶数化したパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが0でないとき
//              2番目のパレットを偶数化したパレットのカラー
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
//              テキストカラー(0は黒)
//          さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//            3番目のパレットを偶数化したパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが0でないとき
//                3番目のパレットを偶数化したパレットのカラー
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//            さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが0でないとき
//                4番目のパレットを偶数化したパレットのカラー
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//        1番目のパレットが1のとき
//          グラフィックパレット0のカラーが0でないとき
//            グラフィックパレット0のカラー
//          さもなくば(グラフィックパレット0のカラーが0のとき)
//            テキストカラー(0は黒)
//        1番目のパレットが2以上の偶数のとき
//          1番目のカラーが0でないとき
//            1番目のカラー
//          さもなくば(1番目のカラーが0のとき)
//            テキストカラー(0は黒)
//        さもなくば(1番目のパレットが3以上の奇数のとき)
//          1番目のパレットを偶数化したパレットのカラーと
//            テキストカラー(0は黒)
//          を混ぜたカラー(0は黒)
//    グラフィック画面よりも奥にスプライト画面とテキスト画面が両方あるときはそれらを重ね合わせてから混ぜる
//    グラフィック画面よりも手前にあるスプライト画面またはテキスト画面は通常通り出力される
//
//  半透明(XHPG)
//    概要
//      1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
//    SE4T_XHPGの手順
//      スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//        スプライトカラーが0でないとき
//          スプライトカラー
//        さもなくば(スプライトカラーが0のとき)
//          1番目のパレットが0のとき
//            2番目のパレットを偶数化したパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//              3番目のパレットを偶数化したパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラー(0は黒)
//          1番目のパレットが1のとき
//            グラフィックパレット0のカラー(0は黒)
//          1番目のパレットが2以上の偶数のとき
//            1番目のカラー(0は黒)
//          さもなくば(1番目のパレットが3以上の奇数のとき)
//            1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
//      さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//        1番目のパレットが0のとき
//          2番目のパレットを偶数化したパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが0でないとき
//              2番目のパレットを偶数化したパレットのカラー
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
//              テキストカラー(0は黒)
//          さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//            3番目のパレットを偶数化したパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが0でないとき
//                3番目のパレットを偶数化したパレットのカラー
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//            さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが0でないとき
//                4番目のパレットを偶数化したパレットのカラー
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//        1番目のパレットが1のとき
//          グラフィックパレット0のカラーが0でないとき
//            グラフィックパレット0のカラー
//          さもなくば(グラフィックパレット0のカラーが0のとき)
//            テキストカラー(0は黒)
//        1番目のパレットが2以上の偶数のとき
//          1番目のカラーが0でないとき
//            1番目のカラー
//          さもなくば(1番目のカラーが0のとき)
//            テキストカラー(0は黒)
//        さもなくば(1番目のパレットが3以上の奇数のとき)
//          1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーが0でないとき
//            1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー
//          さもなくば(1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーが0のとき)
//            テキストカラー(0は黒)
//    混ぜないときもグラフィックパレットはすべて偶数化される
//      1は偶数化されて0(透明)になり奥のプレーンが見える
//      0>1>1>1は0、0>1>1>3は2
//    例
//      1番目が2=赤、2番目が2=赤のとき
//        1番目の2=赤が偶数なので半透明にならない
//        2番目の2=赤を偶数化した2=赤になる
//      1番目が2=赤、2番目が3=青のとき
//        1番目の2=赤が偶数なので半透明にならない
//        2番目の3=青を偶数化した2=赤になる
//      1番目が3=青、2番目が2=赤のとき
//        1番目の3=青が奇数なので半透明になる
//        1番目の3=青を偶数化した2=赤と2番目の2=赤を奇数化した3=青が混ざって紫になる
//      1番目が3=青、2番目が3=青のとき
//        1番目の3=青が奇数なので半透明になる
//        1番目の3=青を偶数化した2=赤と2番目の3=青を奇数化した3=青が混ざって紫になる
//
//  半透明(XHPGT)
//    概要
//      1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
//    SE4T_XHPGTの手順
//      スプライトパレットの下位4bitが0でないまたは(スプライトパレットが0でないかつテキストパレットが0)のとき
//        スプライトカラーが0でないとき
//          スプライトカラー
//        さもなくば(スプライトカラーが0のとき)
//          1番目のパレットが0のとき
//            2番目のパレットを偶数化したパレットが0でないとき
//              2番目のパレットを偶数化したパレットのカラー(0は黒)
//            さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//              3番目のパレットを偶数化したパレットが0でないとき
//                3番目のパレットを偶数化したパレットのカラー(0は黒)
//              さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//                4番目のパレットを偶数化したパレットのカラー(0は黒)
//          1番目のパレットが1のとき
//            グラフィックパレット0のカラー(0は黒)
//          1番目のパレットが2以上の偶数のとき
//            1番目のカラー(0は黒)
//          さもなくば(1番目のパレットが3以上の奇数のとき)
//            1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
//      さもなくば(スプライトパレットが0または(スプライトパレットの下位4bitが0かつテキストパレットが0でない)のとき)
//        1番目のパレットが0のとき
//          2番目のパレットを偶数化したパレットが0でないとき
//            2番目のパレットを偶数化したパレットのカラーが0でないとき
//              2番目のパレットを偶数化したパレットのカラー
//            さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
//              テキストカラー(0は黒)
//          さもなくば(2番目のパレットを偶数化したパレットが0のとき)
//            3番目のパレットを偶数化したパレットが0でないとき
//              3番目のパレットを偶数化したパレットのカラーが0でないとき
//                3番目のパレットを偶数化したパレットのカラー
//              さもなくば(3番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//            さもなくば(3番目のパレットを偶数化したパレットが0のとき)
//              4番目のパレットを偶数化したパレットのカラーが0でないとき
//                4番目のパレットを偶数化したパレットのカラー
//              さもなくば(4番目のパレットを偶数化したパレットのカラーが0のとき)
//                テキストカラー(0は黒)
//        1番目のパレットが1のとき
//          グラフィックパレット0のカラーが0でないとき
//            グラフィックパレット0のカラー
//          さもなくば(グラフィックパレット0のカラーが0のとき)
//            テキストカラー(0は黒)
//        1番目のパレットが2以上の偶数のとき
//          1番目のカラーが0でないとき
//            1番目のカラー
//          さもなくば(1番目のカラーが0のとき)
//            テキストカラー(0は黒)
//        さもなくば(1番目のパレットが3以上の奇数のとき)
//          1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
//            テキストカラー(0は黒)
//          を混ぜたカラー(0は黒)
//
//----------------------------------------------------------------------------------------

package xeij;

import java.lang.*;  //Boolean,Character,Class,Comparable,Double,Exception,Float,IllegalArgumentException,Integer,Long,Math,Number,Object,Runnable,SecurityException,String,StringBuilder,System
import java.util.*;  //ArrayList,Arrays,Calendar,GregorianCalendar,HashMap,Map,Map.Entry,Timer,TimerTask,TreeMap

public class VideoController {

  public static final boolean VCN_LOG_TRANSITION = false;  //true=ビデオコントローラの画面モードの遷移を報告する。ゲームによっては頻繁に切り替わるので停止させる手段がないと困る

  //レジスタ
  public static final int VCN_REG1 = 0x00e82400;
  public static final int VCN_REG2 = 0x00e82500;
  public static final int VCN_REG3 = 0x00e82600;
  public static int vcnReg1Port;  //ポートの読み書きに使われる値
  public static int vcnReg1Mask;  //マスク。0=ポート,1=テスト
  public static int vcnReg1Test;  //テストデータ
  public static int vcnReg1Curr;  //使用されている値。vcnReg1Port & ~vcnReg1Mask | vcnReg1Test & vcnReg1Mask
  public static int vcnReg2Port;  //ポートの読み書きに使われる値
  public static int vcnReg2Mask;  //マスク。0=ポート,1=テスト
  public static int vcnReg2Test;  //テストデータ
  public static int vcnReg2Curr;  //使用されている値。vcnReg2Port & ~vcnReg2Mask | vcnReg2Test & vcnReg2Mask
  public static int vcnReg3Port;  //ポートの読み書きに使われる値
  public static int vcnReg3Mask;  //マスク。0=ポート,1=テスト
  public static int vcnReg3Test;  //テストデータ
  public static int vcnReg3Curr;  //使用されている値。vcnReg3Port & ~vcnReg3Mask | vcnReg3Test & vcnReg3Mask

  //コントラスト
  public static final int VCN_CONTRAST_SCALE = 3;  //コントラストの1段階を何分割するか
  public static final long VCN_CONTRAST_DELAY = XEiJ.TMR_FREQ / (20 * VCN_CONTRAST_SCALE);  //コントラストが1段階変化するのにかかる時間(XEiJ.TMR_FREQ単位)=0.05秒
  public static final int[][] vcnPalBase = new int[VCN_CONTRAST_SCALE * 15 + 1][];  //コントラストに応じた16ビット→32ビット変換テーブルのテーブル
  public static int[] vcnPalTbl;  //現在の16ビット→32ビット変換テーブル
  public static int vcnCurrentScaledContrast;  //VCN_CONTRAST_SCALE*現在のコントラスト
  public static int vcnTargetContrastPort;  //指定されたコントラスト
  public static int vcnTargetContrastMask;
  public static int vcnTargetContrastTest;
  public static int vcnTargetContrastCurr;
  public static int vcnTargetScaledContrast;  //VCN_CONTRAST_SCALE*vcnTargetContrastCurr

  //パレット
  //  ゼロ拡張
  public static final int[] vcnPal16G8 = new int[256];  //グラフィックパレット
  public static final int[] vcnPal16TSPort = new int[256];  //テキストスプライトパレット。ポート
  public static final int[] vcnPal16TSTest = new int[256];  //テキストスプライトパレット。パターンテスト
  public static int[] vcnPal16TS;  //vcnPal16TSPortまたはvcnPal16TSTest
  public static final int[] vcnPal32G8 = new int[256];  //グラフィックパレット。変換後
  public static final int[] vcnPal32TS = new int[256];  //テキストスプライトパレット。変換後
  //  65536色モードのパレット
  //    パレットコードが
  //      PH<<8|PL
  //    カラーコードが
  //      CHPH<<8|CLPL
  //    のとき
  //      CHPH = [$00E82002+((PH&$FE)<<1)+(PH&$01)].B
  //      CLPL = [$00E82000+((PL&$FE)<<1)+(PL&$01)].B
  //  $00E82000  CL00 CL01 CH00 CH01 CL02 CL03 CH02 CH03 CL04 CL05 CH04 CH05 CL06 CL07 CH06 CH07
  //  $00E82010  CL08 CL09 CH08 CH09 CL0A CL0B CH0A CH0B CL0C CL0D CH0C CH0D CL0E CL0F CH0E CH0F
  //  $00E82020  CL10 CL11 CH10 CH11 CL12 CL13 CH12 CH13 CL14 CL15 CH14 CH15 CL16 CL17 CH16 CH17
  //  $00E82030  CL18 CL19 CH18 CH19 CL1A CL1B CH1A CH1B CL1C CL1D CH1C CH1D CL1E CL1F CH1E CH1F
  //      :
  //  $00E821C0  CLE0 CLE1 CHE0 CHE1 CLE2 CLE3 CHE2 CHE3 CLE4 CLE5 CHE4 CHE5 CLE6 CLE7 CHE6 CHE7
  //  $00E821D0  CLE8 CLE9 CHE8 CHE9 CLEA CLEB CHEA CHEB CLEC CLED CHEC CHED CLEE CLEF CHEE CHEF
  //  $00E821E0  CLF0 CLF1 CHF0 CHF1 CLF2 CLF3 CHF2 CHF3 CLF4 CLF5 CHF4 CHF5 CLF6 CLF7 CHF6 CHF7
  //  $00E821F0  CLF8 CLF9 CHF8 CHF9 CLFA CLFB CHFA CHFB CLFC CLFD CHFC CHFD CLFE CLFF CHFE CHFF
  public static final int[] vcnPal8G16L = new int[256];  //65536色パレット下位。0x00??
  public static final int[] vcnPal8G16H = new int[256];  //65536色パレット上位。0x??00

  //ラスタ描画ルーチン
  //  vcnMode = vcnModeTable[-(vcnReg3Curr & 0x5000) & 0x10000 | (char) (vcnReg3Curr << 9) | vcnReg1Curr << 6 | vcnReg2Curr >> 8];
  public static final int AHEX = 0x10000;  //AHOn|ExOn
  public static final int SPON = 0x08000;  //SpOn
  public static final int TXON = 0x04000;  //TxOn
  public static final int GXON = 0x02000;  //GxOn
  public static final int G4ON = 0x01000;  //G4On
  public static final int G3ON = 0x00800;  //G3On
  public static final int G2ON = 0x00400;  //G2On
  public static final int G1ON = 0x00200;  //G1On
  //                             0x001c0     GrMM
  //                             0x00030     SpPr
  //                             0x0000c     TxPr
  //                             0x00003     GrPr
  public static final DrawingMode[] vcnModeTable = new DrawingMode[0x20000];
  public static DrawingMode vcnMode;

  //(512ドット)4bitページ開始位置
  //  OFFのプレーンをダミー4bitページに接続する
  //  すべてのプレーンがOFFのときはグラフィック画面がOFFなので4bitページは参照されない
  public static int vcnHidden1st;  //1番目のプレーンの4bitページ開始位置
  public static int vcnHidden2nd;  //2番目のプレーンの4bitページ開始位置
  public static int vcnHidden3rd;  //3番目のプレーンの4bitページ開始位置
  public static int vcnHidden4th;  //4番目のプレーンの4bitページ開始位置
  public static int vcnVisible1st;  //1番目のプレーンの4bitページ開始位置。OFFのとき0x400000
  public static int vcnVisible2nd;  //2番目のプレーンの4bitページ開始位置。OFFのとき0x400000
  public static int vcnVisible3rd;  //3番目のプレーンの4bitページ開始位置。OFFのとき0x400000
  public static int vcnVisible4th;  //4番目のプレーンの4bitページ開始位置。OFFのとき0x400000

  //TVRAMの1プレーン水平8ピクセルのデータを32bitに引き伸ばすテーブル
  //  4プレーンのデータをそれぞれ引き伸ばして3,2,1,0の順にずらしてORすると4bitのパレットコードが8個並んだデータができる
  //  これを4bitずつ切り出してパレットテーブルを参照する
  //  Javaでは配列参照のオーバーヘッドが加わるが、それでも1bitずつ集めるよりも速い
  //  コードの長さも大幅に短縮できる
  //    VCN_TXP3[0bABCDEFGH] = 0bA000B000C000D000E000F000G000H000
  //    VCN_TXP2[0bABCDEFGH] = 0b0A000B000C000D000E000F000G000H00
  //    VCN_TXP1[0bABCDEFGH] = 0b00A000B000C000D000E000F000G000H0
  //    VCN_TXP0[0bABCDEFGH] = 0b000A000B000C000D000E000F000G000H
  //                           0bAAAABBBBCCCCDDDDEEEEFFFFGGGGHHHH
  public static final int[] VCN_TXP0 = new int[256];
  public static final int[] VCN_TXP1 = new int[256];
  public static final int[] VCN_TXP2 = new int[256];
  public static final int[] VCN_TXP3 = new int[256];

  //未実装画面モード
  public static final HashSet<String> vcnUnimplementedSet = new HashSet<String> ();  //報告済みの画面モード

  //vcnInit ()
  //  ビデオコントローラを初期化する
  public static void vcnInit () {
    //TVRAMの1プレーン水平8ピクセルのデータを32bitに引き伸ばすテーブル
    for (int i = 0; i < 256; i++) {
      VCN_TXP3[i] = (VCN_TXP2[i] = (VCN_TXP1[i] = (VCN_TXP0[i] = (i << 28 - 7 & 0x10000000 |
                                                                  i << 24 - 6 & 0x01000000 |
                                                                  i << 20 - 5 & 0x00100000 |
                                                                  i << 16 - 4 & 0x00010000 |
                                                                  i << 12 - 3 & 0x00001000 |
                                                                  i <<  8 - 2 & 0x00000100 |
                                                                  i <<  4 - 1 & 0x00000010 |
                                                                  i           & 0x00000001)) << 1) << 1) << 1;
    }
    //パレット変換テーブル
    //vcnPalBase = new int[VCN_CONTRAST_SCALE * 15 + 1][];
    for (int c = 0; c <= VCN_CONTRAST_SCALE * 15; c++) {  //スケーリングされたコントラスト
      int max = Math.round (c * 255.0F / (VCN_CONTRAST_SCALE * 15));  //0～255
      int[] t = vcnPalBase[c] = new int[65536];
      for (int p = 0; p <= 0b11111_11111_11111_0; p += 2) {  //パレット65536色
        //perl optdiv.pl 16065 63
        //  x/63==x*16645>>>20 (0<=x<=17827) [16065*16645==267401925]
        t[p] = (255 << 24 |  //Alpha
                (p >> 5 & 0b11111_0) * max * 16645 >>> 20 << 16 |  //Red
                (p >> 10 & 0b11111_0) * max * 16645 >>> 20 << 8 |  //Green
                (p & 0b11111_0) * max * 16645 >>> 20);  //Blue
        t[p + 1] = (255 << 24 |  //Alpha
                    (p >> 5 & 0b11111_0 | 1) * max * 16645 >>> 20 << 16 |  //Red
                    (p >> 10 & 0b11111_0 | 1) * max * 16645 >>> 20 << 8 |  //Green
                    (p & 0b11111_0 | 1) * max * 16645 >>> 20);  //Blue
      }
    }
    //vcnPal16G8 = new int[256];
    //Arrays.fill (vcnPal16G8, 0);
    //vcnPal16TSPort = new int[256];
    //Arrays.fill (vcnPal16TSPort, 0);
    if (SpriteScreen.SPR_PATTEST_ON) {
      //vcnPal16TSTest = new int[256];
      //Arrays.fill (vcnPal16TSTest, 0);
      for (int i = 0; i < 256; i++) {
        //int v = 31 - (i >> 4);  //明るさ。0-15 → 31-16
        int v = 31 - (i >> 4) * 3 / 2;  //明るさ。0-15 → 31-9
        //int v = 31 - (i >> 4) * 7 / 4;  //明るさ。0-15 → 31-5
        //int v = 31 - (i >> 4) * 15 / 8;  //明るさ。0-15 → 31-3
        //int v = 31 - (i >> 4) * 2;  //明るさ。0-15 → 31-1
        int g = ((i >> 2) & 3) * v / 3;  //緑。0-3 → 0-v
        int r = ((i >> 1) & 1) * v;  //赤。0-1 → 0-v
        int b = (i & 1) * v;  //青。0-1 → 0-v
        vcnPal16TSTest[i] = g << 11 | r << 6 | b << 1;
      }
    }
    vcnPal16TS = vcnPal16TSPort;
    //vcnPal32G8 = new int[256];
    Arrays.fill (vcnPal32G8, 0xff000000);
    //vcnPal32TS = new int[256];
    Arrays.fill (vcnPal32TS, 0xff000000);
    //vcnPal8G16L = new int[256];
    //Arrays.fill (vcnPal8G16L, 0);
    //vcnPal8G16H = new int[256];
    //Arrays.fill (vcnPal8G16H, 0);

    vcnMakeTable0 (0);
    vcnMakeTable1 (1);
    vcnMakeTable3 (2);
    vcnMakeTable3 (3);
    vcnMakeTable4 (4);
    if (CRTC.CRT_EXTENDED_GRAPHIC && CRTC.crtExtendedGraphicRequest) {
      vcnMakeTable5 (5);
      vcnMakeTable7 (6);
      vcnMakeTable7 (7);
    } else {
      vcnMakeTable4 (5);
      vcnMakeTable4 (6);
      vcnMakeTable4 (7);
    }

    if (false) {
      for (int i = 0; i < 0x20000; i++) {
        if ((i & 63) == 0) {
          System.out.println ();
          System.out.println (" index   ............GrMM  ..SpTxGr........  .A.XHPGT.STx4321  prwMode");
          System.out.println ("-------  ----------------  ----------------  ----------------  -------");
        }
        System.out.printf ("0x%05x  .............%o%o%o  ..%o%o%o%o%o%o........  .%c.%c.....%o%o%o%o%o%o%o  %s\n",
                           i,  //index
                           i >>  8 & 1,  //GrMM
                           i >>  7 & 1,  //GrMM
                           i >>  6 & 1,  //GrMM
                           i >>  5 & 1, i >>  4 & 1,  //SpPr
                           i >>  3 & 1, i >>  2 & 1,  //TxPr
                           i >>  1 & 1, i       & 1,  //GrPr
                           i >> 16 == 0 ? '0' : '*',  //AH
                           i >> 16 == 0 ? '0' : '*',  //ExOn
                           i >> 15 & 1,  //SpOn
                           i >> 14 & 1,  //TxOn
                           i >> 13 & 1,  //GxOn
                           i >> 12 & 1,  //G4On
                           i >> 11 & 1,  //G3On
                           i >> 10 & 1,  //G2On
                           i >>  9 & 1,  //G1On
                           vcnModeTable[i]);
      }
    }

    vcnReset ();

  }  //vcnInit

  //vcnMakeTable0 (grmm)
  //  描画モード0のテーブルを作る
  public static void vcnMakeTable0 (int grmm) {
    //----------------------------------------------------------------------------------------
    //E  512ドット16色
    //              SpTx_GxOn       SpTx_GxOn
    for (int ii = 0b0000_0; ii <= 0b1111_1; ii++) {
      //                               GxOn               SpTx
      int i = grmm << 6 | (ii & 0b0000_1) << 13 | (ii & 0b1111_0) << 1;
      int s = i >> 4 & 3;
      int t = i >> 2 & 3;
      //----------------------------------------------------------------------------------------
      //GrPr==0
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[                                                       i] = DrawingMode.N;
      vcnModeTable[      AHEX +                                           i] = DrawingMode.XN;
      //E1st 512ドット16色1プレーン＞スプライト(OFF)＞テキスト(OFF) → E1t 512ドット16色1プレーン＞テキスト(OFF)
      //E1ts 512ドット16色1プレーン＞テキスト(OFF)＞スプライト(OFF) → E1t 512ドット16色1プレーン＞テキスト(OFF)
      vcnModeTable[                                                G1ON + i] = DrawingMode.E1t;
      vcnModeTable[      AHEX +                                    G1ON + i] = DrawingMode.XE1t;
      //E2st 512ドット16色2プレーン＞スプライト(OFF)＞テキスト(OFF) → E2t 512ドット16色2プレーン＞テキスト(OFF)
      //E2ts 512ドット16色2プレーン＞テキスト(OFF)＞スプライト(OFF) → E2t 512ドット16色2プレーン＞テキスト(OFF)
      vcnModeTable[                                         G2ON +        i] = (
        vcnModeTable[                                       G2ON + G1ON + i] = DrawingMode.E2t);
      vcnModeTable[      AHEX +                             G2ON +        i] = (
        vcnModeTable[    AHEX +                             G2ON + G1ON + i] = DrawingMode.XE2t);
      //E3st 512ドット16色3プレーン＞スプライト(OFF)＞テキスト(OFF) → E3t 512ドット16色3プレーン＞テキスト(OFF)
      //E3ts 512ドット16色3プレーン＞テキスト(OFF)＞スプライト(OFF) → E3t 512ドット16色3プレーン＞テキスト(OFF)
      vcnModeTable[                                  G3ON +               i] = (
        vcnModeTable[                                G3ON +        G1ON + i] =
        vcnModeTable[                                G3ON + G2ON +        i] =
        vcnModeTable[                                G3ON + G2ON + G1ON + i] = DrawingMode.E3t);
      vcnModeTable[      AHEX +                      G3ON +               i] = (
        vcnModeTable[    AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +                      G3ON + G2ON + G1ON + i] = DrawingMode.XE3t);
      //E4st 512ドット16色4プレーン＞スプライト(OFF)＞テキスト(OFF) → E4t 512ドット16色4プレーン＞テキスト(OFF)
      //E4ts 512ドット16色4プレーン＞テキスト(OFF)＞スプライト(OFF) → E4t 512ドット16色4プレーン＞テキスト(OFF)
      vcnModeTable[                           G4ON +                      i] = (
        vcnModeTable[                         G4ON +               G1ON + i] =
        vcnModeTable[                         G4ON +        G2ON +        i] =
        vcnModeTable[                         G4ON +        G2ON + G1ON + i] =
        vcnModeTable[                         G4ON + G3ON +               i] =
        vcnModeTable[                         G4ON + G3ON +        G1ON + i] =
        vcnModeTable[                         G4ON + G3ON + G2ON +        i] =
        vcnModeTable[                         G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.E4t);
      vcnModeTable[      AHEX +               G4ON +                      i] = (
        vcnModeTable[    AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[    AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[    AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XE4t);
      //T テキスト
      vcnModeTable[                    TXON +                             i] = DrawingMode.T;
      vcnModeTable[      AHEX +        TXON +                             i] = DrawingMode.XT;
      //E1sT 512ドット16色1プレーン＞スプライト(OFF)＞テキスト → E1T 512ドット16色1プレーン＞テキスト
      //E1Ts 512ドット16色1プレーン＞テキスト＞スプライト(OFF) → E1T 512ドット16色1プレーン＞テキスト
      vcnModeTable[                    TXON +                      G1ON + i] = DrawingMode.E1T;
      vcnModeTable[      AHEX +        TXON +                      G1ON + i] = DrawingMode.XE1T;
      //E2sT 512ドット16色2プレーン＞スプライト(OFF)＞テキスト → E2T 512ドット16色2プレーン＞テキスト
      //E2Ts 512ドット16色2プレーン＞テキスト＞スプライト(OFF) → E2T 512ドット16色2プレーン＞テキスト
      vcnModeTable[                    TXON +               G2ON +        i] = (
        vcnModeTable[                  TXON +               G2ON + G1ON + i] = DrawingMode.E2T);
      vcnModeTable[      AHEX +        TXON +               G2ON +        i] = (
        vcnModeTable[    AHEX +        TXON +               G2ON + G1ON + i] = DrawingMode.XE2T);
      //E3sT 512ドット16色3プレーン＞スプライト(OFF)＞テキスト → E3T 512ドット16色3プレーン＞テキスト
      //E3Ts 512ドット16色3プレーン＞テキスト＞スプライト(OFF) → E3T 512ドット16色3プレーン＞テキスト
      vcnModeTable[                    TXON +        G3ON +               i] = (
        vcnModeTable[                  TXON +        G3ON +        G1ON + i] =
        vcnModeTable[                  TXON +        G3ON + G2ON +        i] =
        vcnModeTable[                  TXON +        G3ON + G2ON + G1ON + i] = DrawingMode.E3T);
      vcnModeTable[      AHEX +        TXON +        G3ON +               i] = (
        vcnModeTable[    AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +        TXON +        G3ON + G2ON + G1ON + i] = DrawingMode.XE3T);
      //E4sT 512ドット16色4プレーン＞スプライト(OFF)＞テキスト → E4T 512ドット16色4プレーン＞テキスト
      //E4Ts 512ドット16色4プレーン＞テキスト＞スプライト(OFF) → E4T 512ドット16色4プレーン＞テキスト
      vcnModeTable[                    TXON + G4ON +                      i] = (
        vcnModeTable[                  TXON + G4ON +               G1ON + i] =
        vcnModeTable[                  TXON + G4ON +        G2ON +        i] =
        vcnModeTable[                  TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[                  TXON + G4ON + G3ON +               i] =
        vcnModeTable[                  TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[                  TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[                  TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.E4T);
      vcnModeTable[      AHEX +        TXON + G4ON +                      i] = (
        vcnModeTable[    AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XE4T);
      //S スプライト
      vcnModeTable[             SPON +                                    i] = DrawingMode.S;
      vcnModeTable[      AHEX + SPON +                                    i] = DrawingMode.XS;
      //E1St 512ドット16色1プレーン＞スプライト＞テキスト(OFF) → E1S 512ドット16色1プレーン＞スプライト
      //E1tS 512ドット16色1プレーン＞テキスト(OFF)＞スプライト → E1S 512ドット16色1プレーン＞スプライト
      vcnModeTable[             SPON +                             G1ON + i] = DrawingMode.E1S;
      vcnModeTable[      AHEX + SPON +                             G1ON + i] = DrawingMode.XE1S;
      //E2St 512ドット16色2プレーン＞スプライト＞テキスト(OFF) → E2S 512ドット16色2プレーン＞スプライト
      //E2tS 512ドット16色2プレーン＞テキスト(OFF)＞スプライト → E2S 512ドット16色2プレーン＞スプライト
      vcnModeTable[             SPON +                      G2ON +        i] = (
        vcnModeTable[           SPON +                      G2ON + G1ON + i] = DrawingMode.E2S);
      vcnModeTable[      AHEX + SPON +                      G2ON +        i] = (
        vcnModeTable[    AHEX + SPON +                      G2ON + G1ON + i] = DrawingMode.XE2S);
      //E3St 512ドット16色3プレーン＞スプライト＞テキスト(OFF) → E3S 512ドット16色3プレーン＞スプライト
      //E3tS 512ドット16色3プレーン＞テキスト(OFF)＞スプライト → E3S 512ドット16色3プレーン＞スプライト
      vcnModeTable[             SPON +               G3ON +               i] = (
        vcnModeTable[           SPON +               G3ON +        G1ON + i] =
        vcnModeTable[           SPON +               G3ON + G2ON +        i] =
        vcnModeTable[           SPON +               G3ON + G2ON + G1ON + i] = DrawingMode.E3S);
      vcnModeTable[      AHEX + SPON +               G3ON +               i] = (
        vcnModeTable[    AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON +               G3ON + G2ON + G1ON + i] = DrawingMode.XE3S);
      //E4St 512ドット16色4プレーン＞スプライト＞テキスト(OFF) → E4S 512ドット16色4プレーン＞スプライト
      //E4tS 512ドット16色4プレーン＞テキスト(OFF)＞スプライト → E4S 512ドット16色4プレーン＞スプライト
      vcnModeTable[             SPON +        G4ON +                      i] = (
        vcnModeTable[           SPON +        G4ON +               G1ON + i] =
        vcnModeTable[           SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[           SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[           SPON +        G4ON + G3ON +               i] =
        vcnModeTable[           SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[           SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[           SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.E4S);
      vcnModeTable[      AHEX + SPON +        G4ON +                      i] = (
        vcnModeTable[    AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XE4S);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[             SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[      AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //E1ST 512ドット16色1プレーン＞スプライト＞テキスト
      //E1TS 512ドット16色1プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON +                      G1ON + i] = s < t ? DrawingMode.E1ST : DrawingMode.E1TS;
      vcnModeTable[      AHEX + SPON + TXON +                      G1ON + i] = s < t ? DrawingMode.XE1ST : DrawingMode.XE1TS;
      //E2ST 512ドット16色2プレーン＞スプライト＞テキスト
      //E2TS 512ドット16色2プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON +               G2ON +        i] = (
        vcnModeTable[           SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.E2ST : DrawingMode.E2TS);
      vcnModeTable[      AHEX + SPON + TXON +               G2ON +        i] = (
        vcnModeTable[    AHEX + SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XE2ST : DrawingMode.XE2TS);
      //E3ST 512ドット16色3プレーン＞スプライト＞テキスト
      //E3TS 512ドット16色3プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON +        G3ON +               i] = (
        vcnModeTable[           SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[           SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[           SPON + TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.E3ST : DrawingMode.E3TS);
      vcnModeTable[      AHEX + SPON + TXON +        G3ON +               i] = (
        vcnModeTable[    AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XE3ST : DrawingMode.XE3TS);
      //E4ST 512ドット16色4プレーン＞スプライト＞テキスト
      //E4TS 512ドット16色4プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON + G4ON +                      i] = (
        vcnModeTable[           SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[           SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.E4ST : DrawingMode.E4TS);
      vcnModeTable[      AHEX + SPON + TXON + G4ON +                      i] = (
        vcnModeTable[    AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XE4ST : DrawingMode.XE4TS);
      //----------------------------------------------------------------------------------------
      //GrPr==1
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  1 +                                                  i] = DrawingMode.N;
      vcnModeTable[  1 + AHEX +                                           i] = DrawingMode.XN;
      //sE1t スプライト(OFF)＞512ドット16色1プレーン＞テキスト(OFF) → E1t 512ドット16色1プレーン＞テキスト(OFF)
      //tE1s テキスト(OFF)＞512ドット16色1プレーン＞スプライト(OFF) → E1t 512ドット16色1プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                                           G1ON + i] = DrawingMode.E1t;
      vcnModeTable[  1 + AHEX +                                    G1ON + i] = DrawingMode.XE1t;
      //sE2t スプライト(OFF)＞512ドット16色2プレーン＞テキスト(OFF) → E2t 512ドット16色2プレーン＞テキスト(OFF)
      //tE2s テキスト(OFF)＞512ドット16色2プレーン＞スプライト(OFF) → E2t 512ドット16色2プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                                    G2ON +        i] = (
        vcnModeTable[1 +                                    G2ON + G1ON + i] = DrawingMode.E2t);
      vcnModeTable[  1 + AHEX +                             G2ON +        i] = (
        vcnModeTable[1 + AHEX +                             G2ON + G1ON + i] = DrawingMode.XE2t);
      //sE3t スプライト(OFF)＞512ドット16色3プレーン＞テキスト(OFF) → E3t 512ドット16色3プレーン＞テキスト(OFF)
      //tE3s テキスト(OFF)＞512ドット16色3プレーン＞スプライト(OFF) → E3t 512ドット16色3プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                             G3ON +               i] = (
        vcnModeTable[1 +                             G3ON +        G1ON + i] =
        vcnModeTable[1 +                             G3ON + G2ON +        i] =
        vcnModeTable[1 +                             G3ON + G2ON + G1ON + i] = DrawingMode.E3t);
      vcnModeTable[  1 + AHEX +                      G3ON +               i] = (
        vcnModeTable[1 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +                      G3ON + G2ON + G1ON + i] = DrawingMode.XE3t);
      //sE4t スプライト(OFF)＞512ドット16色4プレーン＞テキスト(OFF) → E4t 512ドット16色4プレーン＞テキスト(OFF)
      //tE4s テキスト(OFF)＞512ドット16色4プレーン＞スプライト(OFF) → E4t 512ドット16色4プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                      G4ON +                      i] = (
        vcnModeTable[1 +                      G4ON +               G1ON + i] =
        vcnModeTable[1 +                      G4ON +        G2ON +        i] =
        vcnModeTable[1 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +                      G4ON + G3ON +               i] =
        vcnModeTable[1 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +                      G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.E4t);
      vcnModeTable[  1 + AHEX +               G4ON +                      i] = (
        vcnModeTable[1 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XE4t);
      //T テキスト
      vcnModeTable[  1 +               TXON +                             i] = DrawingMode.T;
      vcnModeTable[  1 + AHEX +        TXON +                             i] = DrawingMode.XT;
      //sE1T スプライト(OFF)＞512ドット16色1プレーン＞テキスト → E1T 512ドット16色1プレーン＞テキスト
      //TE1s テキスト＞512ドット16色1プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON +                      G1ON + i] = s < t ? DrawingMode.E1T : DrawingMode.TE1s;
      vcnModeTable[  1 + AHEX +        TXON +                      G1ON + i] = s < t ? DrawingMode.XE1T : DrawingMode.XTE1s;
      //sE2T スプライト(OFF)＞512ドット16色2プレーン＞テキスト → E2T 512ドット16色2プレーン＞テキスト
      //TE2s テキスト＞512ドット16色2プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON +               G2ON +        i] = (
        vcnModeTable[1 +               TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.E2T : DrawingMode.TE2s);
      vcnModeTable[  1 + AHEX +        TXON +               G2ON +        i] = (
        vcnModeTable[1 + AHEX +        TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XE2T : DrawingMode.XTE2s);
      //sE3T スプライト(OFF)＞512ドット16色3プレーン＞テキスト → E3T 512ドット16色3プレーン＞テキスト
      //TE3s テキスト＞512ドット16色3プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON +        G3ON +               i] = (
        vcnModeTable[1 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 +               TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.E3T : DrawingMode.TE3s);
      vcnModeTable[  1 + AHEX +        TXON +        G3ON +               i] = (
        vcnModeTable[1 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XE3T : DrawingMode.XTE3s);
      //sE4T スプライト(OFF)＞512ドット16色4プレーン＞テキスト → E4T 512ドット16色4プレーン＞テキスト
      //TE4s テキスト＞512ドット16色4プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON + G4ON +                      i] = (
        vcnModeTable[1 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.E4T : DrawingMode.TE4s);
      vcnModeTable[  1 + AHEX +        TXON + G4ON +                      i] = (
        vcnModeTable[1 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XE4T : DrawingMode.XTE4s);
      //S スプライト
      vcnModeTable[  1 +        SPON +                                    i] = DrawingMode.S;
      vcnModeTable[  1 + AHEX + SPON +                                    i] = DrawingMode.XS;
      //SE1t スプライト＞512ドット16色1プレーン＞テキスト(OFF)
      //tE1S テキスト(OFF)＞512ドット16色1プレーン＞スプライト → E1S 512ドット16色1プレーン＞スプライト
      vcnModeTable[  1 +        SPON +                             G1ON + i] = s < t ? DrawingMode.SE1t : DrawingMode.E1S;
      vcnModeTable[  1 + AHEX + SPON +                             G1ON + i] = s < t ? DrawingMode.XSE1t : DrawingMode.XE1S;
      //SE2t スプライト＞512ドット16色2プレーン＞テキスト(OFF)
      //tE2S テキスト(OFF)＞512ドット16色2プレーン＞スプライト → E2S 512ドット16色2プレーン＞スプライト
      vcnModeTable[  1 +        SPON +                      G2ON +        i] = (
        vcnModeTable[1 +        SPON +                      G2ON + G1ON + i] = s < t ? DrawingMode.SE2t : DrawingMode.E2S);
      vcnModeTable[  1 + AHEX + SPON +                      G2ON +        i] = (
        vcnModeTable[1 + AHEX + SPON +                      G2ON + G1ON + i] = s < t ? DrawingMode.XSE2t : DrawingMode.XE2S);
      //SE3t スプライト＞512ドット16色3プレーン＞テキスト(OFF)
      //tE3S テキスト(OFF)＞512ドット16色3プレーン＞スプライト → E3S 512ドット16色3プレーン＞スプライト
      vcnModeTable[  1 +        SPON +               G3ON +               i] = (
        vcnModeTable[1 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON +               G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SE3t : DrawingMode.E3S);
      vcnModeTable[  1 + AHEX + SPON +               G3ON +               i] = (
        vcnModeTable[1 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSE3t : DrawingMode.XE3S);
      //SE4t スプライト＞512ドット16色4プレーン＞テキスト(OFF)
      //tE4S テキスト(OFF)＞512ドット16色4プレーン＞スプライト → E4S 512ドット16色4プレーン＞スプライト
      vcnModeTable[  1 +        SPON +        G4ON +                      i] = (
        vcnModeTable[1 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[1 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SE4t : DrawingMode.E4S);
      vcnModeTable[  1 + AHEX + SPON +        G4ON +                      i] = (
        vcnModeTable[1 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSE4t : DrawingMode.XE4S);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[  1 +        SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[  1 + AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //SE1T スプライト＞512ドット16色1プレーン＞テキスト
      //TE1S テキスト＞512ドット16色1プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON +                      G1ON + i] = s < t ? DrawingMode.SE1T : DrawingMode.TE1S;
      vcnModeTable[  1 + AHEX + SPON + TXON +                      G1ON + i] = s < t ? DrawingMode.XSE1T : DrawingMode.XTE1S;
      //SE2T スプライト＞512ドット16色2プレーン＞テキスト
      //TE2S テキスト＞512ドット16色2プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON +               G2ON +        i] = (
        vcnModeTable[1 +        SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.SE2T : DrawingMode.TE2S);
      vcnModeTable[  1 + AHEX + SPON + TXON +               G2ON +        i] = (
        vcnModeTable[1 + AHEX + SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XSE2T : DrawingMode.XTE2S);
      //SE3T スプライト＞512ドット16色3プレーン＞テキスト
      //TE3S テキスト＞512ドット16色3プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON +        G3ON +               i] = (
        vcnModeTable[1 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SE3T : DrawingMode.TE3S);
      vcnModeTable[  1 + AHEX + SPON + TXON +        G3ON +               i] = (
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSE3T : DrawingMode.XTE3S);
      //SE4T スプライト＞512ドット16色4プレーン＞テキスト
      //TE4S テキスト＞512ドット16色4プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON + G4ON +                      i] = (
        vcnModeTable[1 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SE4T : DrawingMode.TE4S);
      vcnModeTable[  1 + AHEX + SPON + TXON + G4ON +                      i] = (
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSE4T : DrawingMode.XTE4S);
      //----------------------------------------------------------------------------------------
      //GrPr==2
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  2 +                                                  i] = DrawingMode.N;
      vcnModeTable[  2 + AHEX +                                           i] = DrawingMode.XN;
      //stE1 スプライト(OFF)＞テキスト(OFF)＞512ドット16色1プレーン → E1 512ドット16色1プレーン
      //tsE1 テキスト(OFF)＞スプライト(OFF)＞512ドット16色1プレーン → E1 512ドット16色1プレーン
      vcnModeTable[  2 +                                           G1ON + i] = DrawingMode.E1;
      vcnModeTable[  2 + AHEX +                                    G1ON + i] = DrawingMode.XE1;
      //stE2 スプライト(OFF)＞テキスト(OFF)＞512ドット16色2プレーン → E2 512ドット16色2プレーン
      //tsE2 テキスト(OFF)＞スプライト(OFF)＞512ドット16色2プレーン → E2 512ドット16色2プレーン
      vcnModeTable[  2 +                                    G2ON +        i] = (
        vcnModeTable[2 +                                    G2ON + G1ON + i] = DrawingMode.E2);
      vcnModeTable[  2 + AHEX +                             G2ON +        i] = (
        vcnModeTable[2 + AHEX +                             G2ON + G1ON + i] = DrawingMode.XE2);
      //stE3 スプライト(OFF)＞テキスト(OFF)＞512ドット16色3プレーン → E3 512ドット16色3プレーン
      //tsE3 テキスト(OFF)＞スプライト(OFF)＞512ドット16色3プレーン → E3 512ドット16色3プレーン
      vcnModeTable[  2 +                             G3ON +               i] = (
        vcnModeTable[2 +                             G3ON +        G1ON + i] =
        vcnModeTable[2 +                             G3ON + G2ON +        i] =
        vcnModeTable[2 +                             G3ON + G2ON + G1ON + i] = DrawingMode.E3);
      vcnModeTable[  2 + AHEX +                      G3ON +               i] = (
        vcnModeTable[2 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +                      G3ON + G2ON + G1ON + i] = DrawingMode.XE3);
      //stE4 スプライト(OFF)＞テキスト(OFF)＞512ドット16色4プレーン → E4 512ドット16色4プレーン
      //tsE4 テキスト(OFF)＞スプライト(OFF)＞512ドット16色4プレーン → E4 512ドット16色4プレーン
      vcnModeTable[  2 +                      G4ON +                      i] = (
        vcnModeTable[2 +                      G4ON +               G1ON + i] =
        vcnModeTable[2 +                      G4ON +        G2ON +        i] =
        vcnModeTable[2 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +                      G4ON + G3ON +               i] =
        vcnModeTable[2 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +                      G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.E4);
      vcnModeTable[  2 + AHEX +               G4ON +                      i] = (
        vcnModeTable[2 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XE4);
      //T テキスト
      vcnModeTable[  2 +               TXON +                             i] = DrawingMode.T;
      vcnModeTable[  2 + AHEX +        TXON +                             i] = DrawingMode.XT;
      //sTE1 スプライト(OFF)＞テキスト＞512ドット16色1プレーン → TE1 テキスト＞512ドット16色1プレーン
      //TsE1 テキスト＞スプライト(OFF)＞512ドット16色1プレーン → TE1 テキスト＞512ドット16色1プレーン
      vcnModeTable[  2 +               TXON +                      G1ON + i] = DrawingMode.TE1;
      vcnModeTable[  2 + AHEX +        TXON +                      G1ON + i] = DrawingMode.XTE1;
      //sTE2 スプライト(OFF)＞テキスト＞512ドット16色2プレーン → TE2 テキスト＞512ドット16色2プレーン
      //TsE2 テキスト＞スプライト(OFF)＞512ドット16色2プレーン → TE2 テキスト＞512ドット16色2プレーン
      vcnModeTable[  2 +               TXON +               G2ON +        i] = (
        vcnModeTable[2 +               TXON +               G2ON + G1ON + i] = DrawingMode.TE2);
      vcnModeTable[  2 + AHEX +        TXON +               G2ON +        i] = (
        vcnModeTable[2 + AHEX +        TXON +               G2ON + G1ON + i] = DrawingMode.XTE2);
      //sTE3 スプライト(OFF)＞テキスト＞512ドット16色3プレーン → TE3 テキスト＞512ドット16色3プレーン
      //TsE3 テキスト＞スプライト(OFF)＞512ドット16色3プレーン → TE3 テキスト＞512ドット16色3プレーン
      vcnModeTable[  2 +               TXON +        G3ON +               i] = (
        vcnModeTable[2 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 +               TXON +        G3ON + G2ON + G1ON + i] = DrawingMode.TE3);
      vcnModeTable[  2 + AHEX +        TXON +        G3ON +               i] = (
        vcnModeTable[2 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] = DrawingMode.XTE3);
      //sTE4 スプライト(OFF)＞テキスト＞512ドット16色4プレーン → TE4 テキスト＞512ドット16色4プレーン
      //TsE4 テキスト＞スプライト(OFF)＞512ドット16色4プレーン → TE4 テキスト＞512ドット16色4プレーン
      vcnModeTable[  2 +               TXON + G4ON +                      i] = (
        vcnModeTable[2 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.TE4);
      vcnModeTable[  2 + AHEX +        TXON + G4ON +                      i] = (
        vcnModeTable[2 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XTE4);
      //S スプライト
      vcnModeTable[  2 +        SPON +                                    i] = DrawingMode.S;
      vcnModeTable[  2 + AHEX + SPON +                                    i] = DrawingMode.XS;
      //StE1 スプライト＞テキスト(OFF)＞512ドット16色1プレーン → SE1 スプライト＞512ドット16色1プレーン
      //tSE1 テキスト(OFF)＞スプライト＞512ドット16色1プレーン → SE1 スプライト＞512ドット16色1プレーン
      vcnModeTable[  2 +        SPON +                             G1ON + i] = DrawingMode.SE1;
      vcnModeTable[  2 + AHEX + SPON +                             G1ON + i] = DrawingMode.XSE1;
      //StE2 スプライト＞テキスト(OFF)＞512ドット16色2プレーン → SE2 スプライト＞512ドット16色2プレーン
      //tSE2 テキスト(OFF)＞スプライト＞512ドット16色2プレーン → SE2 スプライト＞512ドット16色2プレーン
      vcnModeTable[  2 +        SPON +                      G2ON +        i] = (
        vcnModeTable[2 +        SPON +                      G2ON + G1ON + i] = DrawingMode.SE2);
      vcnModeTable[  2 + AHEX + SPON +                      G2ON +        i] = (
        vcnModeTable[2 + AHEX + SPON +                      G2ON + G1ON + i] = DrawingMode.XSE2);
      //StE3 スプライト＞テキスト(OFF)＞512ドット16色3プレーン → SE3 スプライト＞512ドット16色3プレーン
      //tSE3 テキスト(OFF)＞スプライト＞512ドット16色3プレーン → SE3 スプライト＞512ドット16色3プレーン
      vcnModeTable[  2 +        SPON +               G3ON +               i] = (
        vcnModeTable[2 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON +               G3ON + G2ON + G1ON + i] = DrawingMode.SE3);
      vcnModeTable[  2 + AHEX + SPON +               G3ON +               i] = (
        vcnModeTable[2 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON + G2ON + G1ON + i] = DrawingMode.XSE3);
      //StE4 スプライト＞テキスト(OFF)＞512ドット16色4プレーン → SE4 スプライト＞512ドット16色4プレーン
      //tSE4 テキスト(OFF)＞スプライト＞512ドット16色4プレーン → SE4 スプライト＞512ドット16色4プレーン
      vcnModeTable[  2 +        SPON +        G4ON +                      i] = (
        vcnModeTable[2 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[2 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.SE4);
      vcnModeTable[  2 + AHEX + SPON +        G4ON +                      i] = (
        vcnModeTable[2 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XSE4);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[  2 +        SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[  2 + AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //STE1 スプライト＞テキスト＞512ドット16色1プレーン
      //TSE1 テキスト＞スプライト＞512ドット16色1プレーン
      vcnModeTable[  2 +        SPON + TXON +                      G1ON + i] = s < t ? DrawingMode.STE1 : DrawingMode.TSE1;
      vcnModeTable[  2 + AHEX + SPON + TXON +                      G1ON + i] = s < t ? DrawingMode.XSTE1 : DrawingMode.XTSE1;
      //STE2 スプライト＞テキスト＞512ドット16色2プレーン
      //TSE2 テキスト＞スプライト＞512ドット16色2プレーン
      vcnModeTable[  2 +        SPON + TXON +               G2ON +        i] = (
        vcnModeTable[2 +        SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.STE2 : DrawingMode.TSE2);
      vcnModeTable[  2 + AHEX + SPON + TXON +               G2ON +        i] = (
        vcnModeTable[2 + AHEX + SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XSTE2 : DrawingMode.XTSE2);
      //STE3 スプライト＞テキスト＞512ドット16色3プレーン
      //TSE3 テキスト＞スプライト＞512ドット16色3プレーン
      vcnModeTable[  2 +        SPON + TXON +        G3ON +               i] = (
        vcnModeTable[2 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.STE3 : DrawingMode.TSE3);
      vcnModeTable[  2 + AHEX + SPON + TXON +        G3ON +               i] = (
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSTE3 : DrawingMode.XTSE3);
      //STE4 スプライト＞テキスト＞512ドット16色4プレーン
      //TSE4 テキスト＞スプライト＞512ドット16色4プレーン
      vcnModeTable[  2 +        SPON + TXON + G4ON +                      i] = (
        vcnModeTable[2 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.STE4 : DrawingMode.TSE4);
      vcnModeTable[  2 + AHEX + SPON + TXON + G4ON +                      i] = (
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSTE4 : DrawingMode.XTSE4);
      //----------------------------------------------------------------------------------------
      //GrPr==3
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  3 +                                                  i] = (
        vcnModeTable[3 +               TXON +                             i] =
        vcnModeTable[3 +        SPON +                                    i] =
        vcnModeTable[3 +        SPON + TXON +                             i] = DrawingMode.N);
      vcnModeTable[  3 + AHEX +                                           i] = (
        vcnModeTable[3 + AHEX +        TXON +                             i] =
        vcnModeTable[3 + AHEX + SPON +                                    i] =
        vcnModeTable[3 + AHEX + SPON + TXON +                             i] = DrawingMode.XN);
      //E1st 512ドット16色1プレーン＞スプライト(OFF)＞テキスト(OFF) → E1t 512ドット16色1プレーン＞テキスト(OFF)
      //E1ts 512ドット16色1プレーン＞テキスト(OFF)＞スプライト(OFF) → E1t 512ドット16色1プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                                           G1ON + i] = (
        vcnModeTable[3 +               TXON +                      G1ON + i] =
        vcnModeTable[3 +        SPON +                             G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +                      G1ON + i] = DrawingMode.E1t);
      vcnModeTable[  3 + AHEX +                                    G1ON + i] = (
        vcnModeTable[3 + AHEX +        TXON +                      G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +                             G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +                      G1ON + i] = DrawingMode.XE1t);
      //E2st 512ドット16色2プレーン＞スプライト(OFF)＞テキスト(OFF) → E2t 512ドット16色2プレーン＞テキスト(OFF)
      //E2ts 512ドット16色2プレーン＞テキスト(OFF)＞スプライト(OFF) → E2t 512ドット16色2プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                                    G2ON +        i] = (
        vcnModeTable[3 +                                    G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON +               G2ON +        i] =
        vcnModeTable[3 +               TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +                      G2ON +        i] =
        vcnModeTable[3 +        SPON +                      G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON +               G2ON + G1ON + i] = DrawingMode.E2t);
      vcnModeTable[  3 + AHEX +                             G2ON +        i] = (
        vcnModeTable[3 + AHEX +                             G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +                      G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON +               G2ON + G1ON + i] = DrawingMode.XE2t);
      //E3st 512ドット16色3プレーン＞スプライト(OFF)＞テキスト(OFF) → E3t 512ドット16色3プレーン＞テキスト(OFF)
      //E3ts 512ドット16色3プレーン＞テキスト(OFF)＞スプライト(OFF) → E3t 512ドット16色3プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                             G3ON +               i] = (
        vcnModeTable[3 +                             G3ON +        G1ON + i] =
        vcnModeTable[3 +                             G3ON + G2ON +        i] =
        vcnModeTable[3 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON +        G3ON +               i] =
        vcnModeTable[3 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +               G3ON +               i] =
        vcnModeTable[3 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON +               i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON + G2ON + G1ON + i] = DrawingMode.E3t);
      vcnModeTable[  3 + AHEX +                      G3ON +               i] = (
        vcnModeTable[3 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON +               i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] = DrawingMode.XE3t);
      //E4st 512ドット16色4プレーン＞スプライト(OFF)＞テキスト(OFF) → E4t 512ドット16色4プレーン＞テキスト(OFF)
      //E4ts 512ドット16色4プレーン＞テキスト(OFF)＞スプライト(OFF) → E4t 512ドット16色4プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                      G4ON +                      i] = (
        vcnModeTable[3 +                      G4ON +               G1ON + i] =
        vcnModeTable[3 +                      G4ON +        G2ON +        i] =
        vcnModeTable[3 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +                      G4ON + G3ON +               i] =
        vcnModeTable[3 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +                      G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON +                      i] =
        vcnModeTable[3 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON +                      i] =
        vcnModeTable[3 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[3 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.E4t);
      vcnModeTable[  3 + AHEX +               G4ON +                      i] = (
        vcnModeTable[3 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XE4t);
    }
  }  //vcnMakeTable0(int)

  //vcnMakeTable1 (grmm)
  //  描画モード1のテーブルを作る
  public static void vcnMakeTable1 (int grmm) {
    //----------------------------------------------------------------------------------------
    //F  512ドット256色
    //              SpTx_GxOn       SpTx_GxOn
    for (int ii = 0b0000_0; ii <= 0b1111_1; ii++) {
      //                               GxOn               SpTx
      int i = grmm << 6 | (ii & 0b0000_1) << 13 | (ii & 0b1111_0) << 1;
      int s = i >> 4 & 3;
      int t = i >> 2 & 3;
      //----------------------------------------------------------------------------------------
      //GrPr==0
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[                                                       i] = DrawingMode.N;
      vcnModeTable[      AHEX +                                           i] = DrawingMode.XN;
      //F1st 512ドット256色1プレーン＞スプライト(OFF)＞テキスト(OFF) → F1t 512ドット256色1プレーン＞テキスト(OFF)
      //F1ts 512ドット256色1プレーン＞テキスト(OFF)＞スプライト(OFF) → F1t 512ドット256色1プレーン＞テキスト(OFF)
      vcnModeTable[                                                G1ON + i] = (
        vcnModeTable[                                       G2ON +        i] =
        vcnModeTable[                                       G2ON + G1ON + i] = DrawingMode.F1t);
      vcnModeTable[      AHEX +                                    G1ON + i] = (
        vcnModeTable[    AHEX +                             G2ON +        i] =
        vcnModeTable[    AHEX +                             G2ON + G1ON + i] = DrawingMode.XF1t);
      //F2st 512ドット256色2プレーン＞スプライト(OFF)＞テキスト(OFF) → F2t 512ドット256色2プレーン＞テキスト(OFF)
      //F2ts 512ドット256色2プレーン＞テキスト(OFF)＞スプライト(OFF) → F2t 512ドット256色2プレーン＞テキスト(OFF)
      vcnModeTable[                                  G3ON +               i] = (
        vcnModeTable[                                G3ON +        G1ON + i] =
        vcnModeTable[                                G3ON + G2ON +        i] =
        vcnModeTable[                                G3ON + G2ON + G1ON + i] =
        vcnModeTable[                         G4ON +                      i] =
        vcnModeTable[                         G4ON +               G1ON + i] =
        vcnModeTable[                         G4ON +        G2ON +        i] =
        vcnModeTable[                         G4ON +        G2ON + G1ON + i] =
        vcnModeTable[                         G4ON + G3ON +               i] =
        vcnModeTable[                         G4ON + G3ON +        G1ON + i] =
        vcnModeTable[                         G4ON + G3ON + G2ON +        i] =
        vcnModeTable[                         G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.F2t);
      vcnModeTable[      AHEX +                      G3ON +               i] = (
        vcnModeTable[    AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX +               G4ON +                      i] =
        vcnModeTable[    AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[    AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[    AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XF2t);
      //T テキスト
      vcnModeTable[                    TXON +                             i] = DrawingMode.T;
      vcnModeTable[      AHEX +        TXON +                             i] = DrawingMode.XT;
      //F1sT 512ドット256色1プレーン＞スプライト(OFF)＞テキスト → F1T 512ドット256色1プレーン＞テキスト
      //F1Ts 512ドット256色1プレーン＞テキスト＞スプライト(OFF) → F1T 512ドット256色1プレーン＞テキスト
      vcnModeTable[                    TXON +                      G1ON + i] = (
        vcnModeTable[                  TXON +               G2ON +        i] =
        vcnModeTable[                  TXON +               G2ON + G1ON + i] = DrawingMode.F1T);
      vcnModeTable[      AHEX +        TXON +                      G1ON + i] = (
        vcnModeTable[    AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[    AHEX +        TXON +               G2ON + G1ON + i] = DrawingMode.XF1T);
      //F2sT 512ドット256色2プレーン＞スプライト(OFF)＞テキスト → F2T 512ドット256色2プレーン＞テキスト
      //F2Ts 512ドット256色2プレーン＞テキスト＞スプライト(OFF) → F2T 512ドット256色2プレーン＞テキスト
      vcnModeTable[                    TXON +        G3ON +               i] = (
        vcnModeTable[                  TXON +        G3ON +        G1ON + i] =
        vcnModeTable[                  TXON +        G3ON + G2ON +        i] =
        vcnModeTable[                  TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[                  TXON + G4ON +                      i] =
        vcnModeTable[                  TXON + G4ON +               G1ON + i] =
        vcnModeTable[                  TXON + G4ON +        G2ON +        i] =
        vcnModeTable[                  TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[                  TXON + G4ON + G3ON +               i] =
        vcnModeTable[                  TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[                  TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[                  TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.F2T);
      vcnModeTable[      AHEX +        TXON +        G3ON +               i] = (
        vcnModeTable[    AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[    AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XF2T);
      //S スプライト
      vcnModeTable[             SPON +                                    i] = DrawingMode.S;
      vcnModeTable[      AHEX + SPON +                                    i] = DrawingMode.XS;
      //F1St 512ドット256色1プレーン＞スプライト＞テキスト(OFF) → F1S 512ドット256色1プレーン＞スプライト
      //F1tS 512ドット256色1プレーン＞テキスト(OFF)＞スプライト → F1S 512ドット256色1プレーン＞スプライト
      vcnModeTable[             SPON +                             G1ON + i] = (
        vcnModeTable[           SPON +                      G2ON +        i] =
        vcnModeTable[           SPON +                      G2ON + G1ON + i] = DrawingMode.F1S);
      vcnModeTable[      AHEX + SPON +                             G1ON + i] = (
        vcnModeTable[    AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[    AHEX + SPON +                      G2ON + G1ON + i] = DrawingMode.XF1S);
      //F2St 512ドット256色2プレーン＞スプライト＞テキスト(OFF) → F2S 512ドット256色2プレーン＞スプライト
      //F2tS 512ドット256色2プレーン＞テキスト(OFF)＞スプライト → F2S 512ドット256色2プレーン＞スプライト
      vcnModeTable[             SPON +               G3ON +               i] = (
        vcnModeTable[           SPON +               G3ON +        G1ON + i] =
        vcnModeTable[           SPON +               G3ON + G2ON +        i] =
        vcnModeTable[           SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[           SPON +        G4ON +                      i] =
        vcnModeTable[           SPON +        G4ON +               G1ON + i] =
        vcnModeTable[           SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[           SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[           SPON +        G4ON + G3ON +               i] =
        vcnModeTable[           SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[           SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[           SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.F2S);
      vcnModeTable[      AHEX + SPON +               G3ON +               i] = (
        vcnModeTable[    AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[    AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XF2S);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[             SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[      AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //F1ST 512ドット256色1プレーン＞スプライト＞テキスト
      //F1TS 512ドット256色1プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON +                      G1ON + i] = (
        vcnModeTable[           SPON + TXON +               G2ON +        i] =
        vcnModeTable[           SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.F1ST : DrawingMode.F1TS);
      vcnModeTable[      AHEX + SPON + TXON +                      G1ON + i] = (
        vcnModeTable[    AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XF1ST : DrawingMode.XF1TS);
      //F2ST 512ドット256色2プレーン＞スプライト＞テキスト
      //F2TS 512ドット256色2プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON +        G3ON +               i] = (
        vcnModeTable[           SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[           SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[           SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON +                      i] =
        vcnModeTable[           SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[           SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.F2ST : DrawingMode.F2TS);
      vcnModeTable[      AHEX + SPON + TXON +        G3ON +               i] = (
        vcnModeTable[    AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XF2ST : DrawingMode.XF2TS);
      //----------------------------------------------------------------------------------------
      //GrPr==1
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  1 +                                                  i] = DrawingMode.N;
      vcnModeTable[  1 + AHEX +                                           i] = DrawingMode.XN;
      //sF1t スプライト(OFF)＞512ドット256色1プレーン＞テキスト(OFF) → F1t 512ドット256色1プレーン＞テキスト(OFF)
      //tF1s テキスト(OFF)＞512ドット256色1プレーン＞スプライト(OFF) → F1t 512ドット256色1プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                                           G1ON + i] = (
        vcnModeTable[1 +                                    G2ON +        i] =
        vcnModeTable[1 +                                    G2ON + G1ON + i] = DrawingMode.F1t);
      vcnModeTable[  1 + AHEX +                                    G1ON + i] = (
        vcnModeTable[1 + AHEX +                             G2ON +        i] =
        vcnModeTable[1 + AHEX +                             G2ON + G1ON + i] = DrawingMode.XF1t);
      //sF2t スプライト(OFF)＞512ドット256色2プレーン＞テキスト(OFF) → F2t 512ドット256色2プレーン＞テキスト(OFF)
      //tF2s テキスト(OFF)＞512ドット256色2プレーン＞スプライト(OFF) → F2t 512ドット256色2プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                             G3ON +               i] = (
        vcnModeTable[1 +                             G3ON +        G1ON + i] =
        vcnModeTable[1 +                             G3ON + G2ON +        i] =
        vcnModeTable[1 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +                      G4ON +                      i] =
        vcnModeTable[1 +                      G4ON +               G1ON + i] =
        vcnModeTable[1 +                      G4ON +        G2ON +        i] =
        vcnModeTable[1 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +                      G4ON + G3ON +               i] =
        vcnModeTable[1 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +                      G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.F2t);
      vcnModeTable[  1 + AHEX +                      G3ON +               i] = (
        vcnModeTable[1 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON +                      i] =
        vcnModeTable[1 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XF2t);
      //T テキスト
      vcnModeTable[  1 +               TXON +                             i] = DrawingMode.T;
      vcnModeTable[  1 + AHEX +        TXON +                             i] = DrawingMode.XT;
      //sF1T スプライト(OFF)＞512ドット256色1プレーン＞テキスト → F1T 512ドット256色1プレーン＞テキスト
      //TF1s テキスト＞512ドット256色1プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON +                      G1ON + i] = (
        vcnModeTable[1 +               TXON +               G2ON +        i] =
        vcnModeTable[1 +               TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.F1T : DrawingMode.TF1s);
      vcnModeTable[  1 + AHEX +        TXON +                      G1ON + i] = (
        vcnModeTable[1 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XF1T : DrawingMode.XTF1s);
      //sF2T スプライト(OFF)＞512ドット256色2プレーン＞テキスト → F2T 512ドット256色2プレーン＞テキスト
      //TF2s テキスト＞512ドット256色2プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON +        G3ON +               i] = (
        vcnModeTable[1 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON +                      i] =
        vcnModeTable[1 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.F2T : DrawingMode.TF2s);
      vcnModeTable[  1 + AHEX +        TXON +        G3ON +               i] = (
        vcnModeTable[1 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XF2T : DrawingMode.XTF2s);
      //S スプライト
      vcnModeTable[  1 +        SPON +                                    i] = DrawingMode.S;
      vcnModeTable[  1 + AHEX + SPON +                                    i] = DrawingMode.XS;
      //SF1t スプライト＞512ドット256色1プレーン＞テキスト(OFF)
      //tF1S テキスト(OFF)＞512ドット256色1プレーン＞スプライト → F1S 512ドット256色1プレーン＞スプライト
      vcnModeTable[  1 +        SPON +                             G1ON + i] = (
        vcnModeTable[1 +        SPON +                      G2ON +        i] =
        vcnModeTable[1 +        SPON +                      G2ON + G1ON + i] = s < t ? DrawingMode.SF1t : DrawingMode.F1S);
      vcnModeTable[  1 + AHEX + SPON +                             G1ON + i] = (
        vcnModeTable[1 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +                      G2ON + G1ON + i] = s < t ? DrawingMode.XSF1t : DrawingMode.XF1S);
      //SF2t スプライト＞512ドット256色2プレーン＞テキスト(OFF)
      //tF2S テキスト(OFF)＞512ドット256色2プレーン＞スプライト → F2S 512ドット256色2プレーン＞スプライト
      vcnModeTable[  1 +        SPON +               G3ON +               i] = (
        vcnModeTable[1 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON +                      i] =
        vcnModeTable[1 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[1 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SF2t : DrawingMode.F2S);
      vcnModeTable[  1 + AHEX + SPON +               G3ON +               i] = (
        vcnModeTable[1 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSF2t : DrawingMode.XF2S);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[  1 +        SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[  1 + AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //SF1T スプライト＞512ドット256色1プレーン＞テキスト
      //TF1S テキスト＞512ドット256色1プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON +                      G1ON + i] = (
        vcnModeTable[1 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.SF1T : DrawingMode.TF1S);
      vcnModeTable[  1 + AHEX + SPON + TXON +                      G1ON + i] = (
        vcnModeTable[1 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XSF1T : DrawingMode.XTF1S);
      //SF2T スプライト＞512ドット256色2プレーン＞テキスト
      //TF2S テキスト＞512ドット256色2プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON +        G3ON +               i] = (
        vcnModeTable[1 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SF2T : DrawingMode.TF2S);
      vcnModeTable[  1 + AHEX + SPON + TXON +        G3ON +               i] = (
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSF2T : DrawingMode.XTF2S);
      //----------------------------------------------------------------------------------------
      //GrPr==2
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  2 +                                                  i] = DrawingMode.N;
      vcnModeTable[  2 + AHEX +                                           i] = DrawingMode.XN;
      //stF1 スプライト(OFF)＞テキスト(OFF)＞512ドット256色1プレーン → F1 512ドット256色1プレーン
      //tsF1 テキスト(OFF)＞スプライト(OFF)＞512ドット256色1プレーン → F1 512ドット256色1プレーン
      vcnModeTable[  2 +                                           G1ON + i] = (
        vcnModeTable[2 +                                    G2ON +        i] =
        vcnModeTable[2 +                                    G2ON + G1ON + i] = DrawingMode.F1);
      vcnModeTable[  2 + AHEX +                                    G1ON + i] = (
        vcnModeTable[2 + AHEX +                             G2ON +        i] =
        vcnModeTable[2 + AHEX +                             G2ON + G1ON + i] = DrawingMode.XF1);
      //stF2 スプライト(OFF)＞テキスト(OFF)＞512ドット256色2プレーン → F2 512ドット256色2プレーン
      //tsF2 テキスト(OFF)＞スプライト(OFF)＞512ドット256色2プレーン → F2 512ドット256色2プレーン
      vcnModeTable[  2 +                             G3ON +               i] = (
        vcnModeTable[2 +                             G3ON +        G1ON + i] =
        vcnModeTable[2 +                             G3ON + G2ON +        i] =
        vcnModeTable[2 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +                      G4ON +                      i] =
        vcnModeTable[2 +                      G4ON +               G1ON + i] =
        vcnModeTable[2 +                      G4ON +        G2ON +        i] =
        vcnModeTable[2 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +                      G4ON + G3ON +               i] =
        vcnModeTable[2 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +                      G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.F2);
      vcnModeTable[  2 + AHEX +                      G3ON +               i] = (
        vcnModeTable[2 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON +                      i] =
        vcnModeTable[2 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XF2);
      //T テキスト
      vcnModeTable[  2 +               TXON +                             i] = DrawingMode.T;
      vcnModeTable[  2 + AHEX +        TXON +                             i] = DrawingMode.XT;
      //sTF1 スプライト(OFF)＞テキスト＞512ドット256色1プレーン → TF1 テキスト＞512ドット256色1プレーン
      //TsF1 テキスト＞スプライト(OFF)＞512ドット256色1プレーン → TF1 テキスト＞512ドット256色1プレーン
      vcnModeTable[  2 +               TXON +                      G1ON + i] = (
        vcnModeTable[2 +               TXON +               G2ON +        i] =
        vcnModeTable[2 +               TXON +               G2ON + G1ON + i] = DrawingMode.TF1);
      vcnModeTable[  2 + AHEX +        TXON +                      G1ON + i] = (
        vcnModeTable[2 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON +               G2ON + G1ON + i] = DrawingMode.XTF1);
      //sTF2 スプライト(OFF)＞テキスト＞512ドット256色2プレーン → TF2 テキスト＞512ドット256色2プレーン
      //TsF2 テキスト＞スプライト(OFF)＞512ドット256色2プレーン → TF2 テキスト＞512ドット256色2プレーン
      vcnModeTable[  2 +               TXON +        G3ON +               i] = (
        vcnModeTable[2 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON +                      i] =
        vcnModeTable[2 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.TF2);
      vcnModeTable[  2 + AHEX +        TXON +        G3ON +               i] = (
        vcnModeTable[2 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XTF2);
      //S スプライト
      vcnModeTable[  2 +        SPON +                                    i] = DrawingMode.S;
      vcnModeTable[  2 + AHEX + SPON +                                    i] = DrawingMode.XS;
      //StF1 スプライト＞テキスト(OFF)＞512ドット256色1プレーン → SF1 スプライト＞512ドット256色1プレーン
      //tSF1 テキスト(OFF)＞スプライト＞512ドット256色1プレーン → SF1 スプライト＞512ドット256色1プレーン
      vcnModeTable[  2 +        SPON +                             G1ON + i] = (
        vcnModeTable[2 +        SPON +                      G2ON +        i] =
        vcnModeTable[2 +        SPON +                      G2ON + G1ON + i] = DrawingMode.SF1);
      vcnModeTable[  2 + AHEX + SPON +                             G1ON + i] = (
        vcnModeTable[2 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +                      G2ON + G1ON + i] = DrawingMode.XSF1);
      //StF2 スプライト＞テキスト(OFF)＞512ドット256色2プレーン → SF2 スプライト＞512ドット256色2プレーン
      //tSF2 テキスト(OFF)＞スプライト＞512ドット256色2プレーン → SF2 スプライト＞512ドット256色2プレーン
      vcnModeTable[  2 +        SPON +               G3ON +               i] = (
        vcnModeTable[2 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON +                      i] =
        vcnModeTable[2 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[2 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.SF2);
      vcnModeTable[  2 + AHEX + SPON +               G3ON +               i] = (
        vcnModeTable[2 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XSF2);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[  2 +        SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[  2 + AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //STF1 スプライト＞テキスト＞512ドット256色1プレーン
      //TSF1 テキスト＞スプライト＞512ドット256色1プレーン
      vcnModeTable[  2 +        SPON + TXON +                      G1ON + i] = (
        vcnModeTable[2 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.STF1 : DrawingMode.TSF1);
      vcnModeTable[  2 + AHEX + SPON + TXON +                      G1ON + i] = (
        vcnModeTable[2 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON +               G2ON + G1ON + i] = s < t ? DrawingMode.XSTF1 : DrawingMode.XTSF1);
      //STF2 スプライト＞テキスト＞512ドット256色2プレーン
      //TSF2 テキスト＞スプライト＞512ドット256色2プレーン
      vcnModeTable[  2 +        SPON + TXON +        G3ON +               i] = (
        vcnModeTable[2 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.STF2 : DrawingMode.TSF2);
      vcnModeTable[  2 + AHEX + SPON + TXON +        G3ON +               i] = (
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSTF2 : DrawingMode.XTSF2);
      //----------------------------------------------------------------------------------------
      //GrPr==3
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  3 +                                                  i] = (
        vcnModeTable[3 +               TXON +                             i] =
        vcnModeTable[3 +        SPON +                                    i] =
        vcnModeTable[3 +        SPON + TXON +                             i] = DrawingMode.N);
      vcnModeTable[  3 + AHEX +                                           i] = (
        vcnModeTable[3 + AHEX +        TXON +                             i] =
        vcnModeTable[3 + AHEX + SPON +                                    i] =
        vcnModeTable[3 + AHEX + SPON + TXON +                             i] = DrawingMode.XN);
      //F1st 512ドット256色1プレーン＞スプライト(OFF)＞テキスト(OFF) → F1t 512ドット256色1プレーン＞テキスト(OFF)
      //F1ts 512ドット256色1プレーン＞テキスト(OFF)＞スプライト(OFF) → F1t 512ドット256色1プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                                           G1ON + i] = (
        vcnModeTable[3 +               TXON +                      G1ON + i] =
        vcnModeTable[3 +        SPON +                             G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +                      G1ON + i] =
        vcnModeTable[3 +                                    G2ON +        i] =
        vcnModeTable[3 +               TXON +               G2ON +        i] =
        vcnModeTable[3 +        SPON +                      G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[3 +                                    G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +                      G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +               G2ON + G1ON + i] = DrawingMode.F1t);
      vcnModeTable[  3 + AHEX +                                    G1ON + i] = (
        vcnModeTable[3 + AHEX +        TXON +                      G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +                             G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +                      G1ON + i] =
        vcnModeTable[3 + AHEX +                             G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[3 + AHEX +                             G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +                      G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +               G2ON + G1ON + i] = DrawingMode.XF1t);
      //F2st 512ドット256色2プレーン＞スプライト(OFF)＞テキスト(OFF) → F2t 512ドット256色2プレーン＞テキスト(OFF)
      //F2ts 512ドット256色2プレーン＞テキスト(OFF)＞スプライト(OFF) → F2t 512ドット256色2プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                             G3ON +               i] = (
        vcnModeTable[3 +                             G3ON +        G1ON + i] =
        vcnModeTable[3 +                             G3ON + G2ON +        i] =
        vcnModeTable[3 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON +        G3ON +               i] =
        vcnModeTable[3 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +               G3ON +               i] =
        vcnModeTable[3 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON +               i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +                      G4ON +                      i] =
        vcnModeTable[3 +                      G4ON +               G1ON + i] =
        vcnModeTable[3 +                      G4ON +        G2ON +        i] =
        vcnModeTable[3 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON +                      i] =
        vcnModeTable[3 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON +                      i] =
        vcnModeTable[3 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[3 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +                      G4ON + G3ON +               i] =
        vcnModeTable[3 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +                      G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.F2t);
      vcnModeTable[  3 + AHEX +                      G3ON +               i] = (
        vcnModeTable[3 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON +               i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON +                      i] =
        vcnModeTable[3 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XF2t);
    }
  }  //vcnMakeTable1(int)

  //vcnMakeTable3 (grmm)
  //  描画モード3のテーブルを作る
  public static void vcnMakeTable3 (int grmm) {
    //----------------------------------------------------------------------------------------
    //G  512ドット65536色
    //              SpTx_GxOn       SpTx_GxOn
    for (int ii = 0b0000_0; ii <= 0b1111_1; ii++) {
      //                               GxOn               SpTx
      int i = grmm << 6 | (ii & 0b0000_1) << 13 | (ii & 0b1111_0) << 1;
      int s = i >> 4 & 3;
      int t = i >> 2 & 3;
      //----------------------------------------------------------------------------------------
      //GrPr==0
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[                                                       i] = DrawingMode.N;
      vcnModeTable[      AHEX +                                           i] = DrawingMode.XN;
      //Gst 512ドット65536色1プレーン＞スプライト(OFF)＞テキスト(OFF) → Gt 512ドット65536色1プレーン＞テキスト(OFF)
      //Gts 512ドット65536色1プレーン＞テキスト(OFF)＞スプライト(OFF) → Gt 512ドット65536色1プレーン＞テキスト(OFF)
      vcnModeTable[                                                G1ON + i] = (
        vcnModeTable[                                       G2ON +        i] =
        vcnModeTable[                                       G2ON + G1ON + i] =
        vcnModeTable[                                G3ON +               i] =
        vcnModeTable[                                G3ON +        G1ON + i] =
        vcnModeTable[                                G3ON + G2ON +        i] =
        vcnModeTable[                                G3ON + G2ON + G1ON + i] =
        vcnModeTable[                         G4ON +                      i] =
        vcnModeTable[                         G4ON +               G1ON + i] =
        vcnModeTable[                         G4ON +        G2ON +        i] =
        vcnModeTable[                         G4ON +        G2ON + G1ON + i] =
        vcnModeTable[                         G4ON + G3ON +               i] =
        vcnModeTable[                         G4ON + G3ON +        G1ON + i] =
        vcnModeTable[                         G4ON + G3ON + G2ON +        i] =
        vcnModeTable[                         G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.Gt);
      vcnModeTable[      AHEX +                                    G1ON + i] = (
        vcnModeTable[    AHEX +                             G2ON +        i] =
        vcnModeTable[    AHEX +                             G2ON + G1ON + i] =
        vcnModeTable[    AHEX +                      G3ON +               i] =
        vcnModeTable[    AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX +               G4ON +                      i] =
        vcnModeTable[    AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[    AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[    AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XGt);
      //T テキスト
      vcnModeTable[                    TXON +                             i] = DrawingMode.T;
      vcnModeTable[      AHEX +        TXON +                             i] = DrawingMode.XT;
      //GsT 512ドット65536色1プレーン＞スプライト(OFF)＞テキスト → GT 512ドット65536色1プレーン＞テキスト
      //GTs 512ドット65536色1プレーン＞テキスト＞スプライト(OFF) → GT 512ドット65536色1プレーン＞テキスト
      vcnModeTable[                    TXON +                      G1ON + i] = (
        vcnModeTable[                  TXON +               G2ON +        i] =
        vcnModeTable[                  TXON +               G2ON + G1ON + i] =
        vcnModeTable[                  TXON +        G3ON +               i] =
        vcnModeTable[                  TXON +        G3ON +        G1ON + i] =
        vcnModeTable[                  TXON +        G3ON + G2ON +        i] =
        vcnModeTable[                  TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[                  TXON + G4ON +                      i] =
        vcnModeTable[                  TXON + G4ON +               G1ON + i] =
        vcnModeTable[                  TXON + G4ON +        G2ON +        i] =
        vcnModeTable[                  TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[                  TXON + G4ON + G3ON +               i] =
        vcnModeTable[                  TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[                  TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[                  TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.GT);
      vcnModeTable[      AHEX +        TXON +                      G1ON + i] = (
        vcnModeTable[    AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[    AHEX +        TXON +               G2ON + G1ON + i] =
        vcnModeTable[    AHEX +        TXON +        G3ON +               i] =
        vcnModeTable[    AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[    AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XGT);
      //S スプライト
      vcnModeTable[             SPON +                                    i] = DrawingMode.S;
      vcnModeTable[      AHEX + SPON +                                    i] = DrawingMode.XS;
      //GSt 512ドット65536色1プレーン＞スプライト＞テキスト(OFF) → GS 512ドット65536色1プレーン＞スプライト
      //GtS 512ドット65536色1プレーン＞テキスト(OFF)＞スプライト → GS 512ドット65536色1プレーン＞スプライト
      vcnModeTable[             SPON +                             G1ON + i] = (
        vcnModeTable[           SPON +                      G2ON +        i] =
        vcnModeTable[           SPON +                      G2ON + G1ON + i] =
        vcnModeTable[           SPON +               G3ON +               i] =
        vcnModeTable[           SPON +               G3ON +        G1ON + i] =
        vcnModeTable[           SPON +               G3ON + G2ON +        i] =
        vcnModeTable[           SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[           SPON +        G4ON +                      i] =
        vcnModeTable[           SPON +        G4ON +               G1ON + i] =
        vcnModeTable[           SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[           SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[           SPON +        G4ON + G3ON +               i] =
        vcnModeTable[           SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[           SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[           SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.GS);
      vcnModeTable[      AHEX + SPON +                             G1ON + i] = (
        vcnModeTable[    AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[    AHEX + SPON +                      G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON +               G3ON +               i] =
        vcnModeTable[    AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[    AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XGS);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[             SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[      AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //GST 512ドット65536色1プレーン＞スプライト＞テキスト
      //GTS 512ドット65536色1プレーン＞テキスト＞スプライト
      vcnModeTable[             SPON + TXON +                      G1ON + i] = (
        vcnModeTable[           SPON + TXON +               G2ON +        i] =
        vcnModeTable[           SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[           SPON + TXON +        G3ON +               i] =
        vcnModeTable[           SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[           SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[           SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON +                      i] =
        vcnModeTable[           SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[           SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[           SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.GST : DrawingMode.GTS);
      vcnModeTable[      AHEX + SPON + TXON +                      G1ON + i] = (
        vcnModeTable[    AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON +               i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[    AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XGST : DrawingMode.XGTS);
      //----------------------------------------------------------------------------------------
      //GrPr==1
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  1 +                                                  i] = DrawingMode.N;
      vcnModeTable[  1 + AHEX +                                           i] = DrawingMode.XN;
      //sGt スプライト(OFF)＞512ドット65536色1プレーン＞テキスト(OFF) → Gt 512ドット65536色1プレーン＞テキスト(OFF)
      //tGs テキスト(OFF)＞512ドット65536色1プレーン＞スプライト(OFF) → Gt 512ドット65536色1プレーン＞テキスト(OFF)
      vcnModeTable[  1 +                                           G1ON + i] = (
        vcnModeTable[1 +                                    G2ON +        i] =
        vcnModeTable[1 +                                    G2ON + G1ON + i] =
        vcnModeTable[1 +                             G3ON +               i] =
        vcnModeTable[1 +                             G3ON +        G1ON + i] =
        vcnModeTable[1 +                             G3ON + G2ON +        i] =
        vcnModeTable[1 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +                      G4ON +                      i] =
        vcnModeTable[1 +                      G4ON +               G1ON + i] =
        vcnModeTable[1 +                      G4ON +        G2ON +        i] =
        vcnModeTable[1 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +                      G4ON + G3ON +               i] =
        vcnModeTable[1 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +                      G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.Gt);
      vcnModeTable[  1 + AHEX +                                    G1ON + i] = (
        vcnModeTable[1 + AHEX +                             G2ON +        i] =
        vcnModeTable[1 + AHEX +                             G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +                      G3ON +               i] =
        vcnModeTable[1 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON +                      i] =
        vcnModeTable[1 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XGt);
      //T テキスト
      vcnModeTable[  1 +               TXON +                             i] = DrawingMode.T;
      vcnModeTable[  1 + AHEX +        TXON +                             i] = DrawingMode.XT;
      //sGT スプライト(OFF)＞512ドット65536色1プレーン＞テキスト → GT 512ドット65536色1プレーン＞テキスト
      //TGs テキスト＞512ドット65536色1プレーン＞スプライト(OFF)
      vcnModeTable[  1 +               TXON +                      G1ON + i] = (
        vcnModeTable[1 +               TXON +               G2ON +        i] =
        vcnModeTable[1 +               TXON +               G2ON + G1ON + i] =
        vcnModeTable[1 +               TXON +        G3ON +               i] =
        vcnModeTable[1 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON +                      i] =
        vcnModeTable[1 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +               TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.GT : DrawingMode.TGs);
      vcnModeTable[  1 + AHEX +        TXON +                      G1ON + i] = (
        vcnModeTable[1 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON +               G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON +               i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XGT : DrawingMode.XTGs);
      //S スプライト
      vcnModeTable[  1 +        SPON +                                    i] = DrawingMode.S;
      vcnModeTable[  1 + AHEX + SPON +                                    i] = DrawingMode.XS;
      //SGt スプライト＞512ドット65536色1プレーン＞テキスト(OFF)
      //tGS テキスト(OFF)＞512ドット65536色1プレーン＞スプライト → GS 512ドット65536色1プレーン＞スプライト
      vcnModeTable[  1 +        SPON +                             G1ON + i] = (
        vcnModeTable[1 +        SPON +                      G2ON +        i] =
        vcnModeTable[1 +        SPON +                      G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON +               G3ON +               i] =
        vcnModeTable[1 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON +                      i] =
        vcnModeTable[1 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[1 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SGt : DrawingMode.GS);
      vcnModeTable[  1 + AHEX + SPON +                             G1ON + i] = (
        vcnModeTable[1 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +                      G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSGt : DrawingMode.XGS);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[  1 +        SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[  1 + AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //SGT スプライト＞512ドット65536色1プレーン＞テキスト
      //TGS テキスト＞512ドット65536色1プレーン＞スプライト
      vcnModeTable[  1 +        SPON + TXON +                      G1ON + i] = (
        vcnModeTable[1 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON +               i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.SGT : DrawingMode.TGS);
      vcnModeTable[  1 + AHEX + SPON + TXON +                      G1ON + i] = (
        vcnModeTable[1 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[1 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSGT : DrawingMode.XTGS);
      //----------------------------------------------------------------------------------------
      //GrPr==2
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  2 +                                                  i] = DrawingMode.N;
      vcnModeTable[  2 + AHEX +                                           i] = DrawingMode.XN;
      //stG スプライト(OFF)＞テキスト(OFF)＞512ドット65536色1プレーン → G 512ドット65536色1プレーン
      //tsG テキスト(OFF)＞スプライト(OFF)＞512ドット65536色1プレーン → G 512ドット65536色1プレーン
      vcnModeTable[  2 +                                           G1ON + i] = (
        vcnModeTable[2 +                                    G2ON +        i] =
        vcnModeTable[2 +                                    G2ON + G1ON + i] =
        vcnModeTable[2 +                             G3ON +               i] =
        vcnModeTable[2 +                             G3ON +        G1ON + i] =
        vcnModeTable[2 +                             G3ON + G2ON +        i] =
        vcnModeTable[2 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +                      G4ON +                      i] =
        vcnModeTable[2 +                      G4ON +               G1ON + i] =
        vcnModeTable[2 +                      G4ON +        G2ON +        i] =
        vcnModeTable[2 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +                      G4ON + G3ON +               i] =
        vcnModeTable[2 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +                      G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.G);
      vcnModeTable[  2 + AHEX +                                    G1ON + i] = (
        vcnModeTable[2 + AHEX +                             G2ON +        i] =
        vcnModeTable[2 + AHEX +                             G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +                      G3ON +               i] =
        vcnModeTable[2 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON +                      i] =
        vcnModeTable[2 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XG);
      //T テキスト
      vcnModeTable[  2 +               TXON +                             i] = DrawingMode.T;
      vcnModeTable[  2 + AHEX +        TXON +                             i] = DrawingMode.XT;
      //sTG スプライト(OFF)＞テキスト＞512ドット65536色1プレーン → TG テキスト＞512ドット65536色1プレーン
      //TsG テキスト＞スプライト(OFF)＞512ドット65536色1プレーン → TG テキスト＞512ドット65536色1プレーン
      vcnModeTable[  2 +               TXON +                      G1ON + i] = (
        vcnModeTable[2 +               TXON +               G2ON +        i] =
        vcnModeTable[2 +               TXON +               G2ON + G1ON + i] =
        vcnModeTable[2 +               TXON +        G3ON +               i] =
        vcnModeTable[2 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON +                      i] =
        vcnModeTable[2 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +               TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.TG);
      vcnModeTable[  2 + AHEX +        TXON +                      G1ON + i] = (
        vcnModeTable[2 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON +               G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON +               i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XTG);
      //S スプライト
      vcnModeTable[  2 +        SPON +                                    i] = DrawingMode.S;
      vcnModeTable[  2 + AHEX + SPON +                                    i] = DrawingMode.XS;
      //StG スプライト＞テキスト(OFF)＞512ドット65536色1プレーン → SG スプライト＞512ドット65536色1プレーン
      //tSG テキスト(OFF)＞スプライト＞512ドット65536色1プレーン → SG スプライト＞512ドット65536色1プレーン
      vcnModeTable[  2 +        SPON +                             G1ON + i] = (
        vcnModeTable[2 +        SPON +                      G2ON +        i] =
        vcnModeTable[2 +        SPON +                      G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON +               G3ON +               i] =
        vcnModeTable[2 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON +                      i] =
        vcnModeTable[2 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[2 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.SG);
      vcnModeTable[  2 + AHEX + SPON +                             G1ON + i] = (
        vcnModeTable[2 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +                      G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XSG);
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[  2 +        SPON + TXON +                             i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[  2 + AHEX + SPON + TXON +                             i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //STG スプライト＞テキスト＞512ドット65536色1プレーン
      //TSG テキスト＞スプライト＞512ドット65536色1プレーン
      vcnModeTable[  2 +        SPON + TXON +                      G1ON + i] = (
        vcnModeTable[2 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON +               i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.STG : DrawingMode.TSG);
      vcnModeTable[  2 + AHEX + SPON + TXON +                      G1ON + i] = (
        vcnModeTable[2 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[2 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = s < t ? DrawingMode.XSTG : DrawingMode.XTSG);
      //----------------------------------------------------------------------------------------
      //GrPr==3
      //          GrPr   AHEx   SpOn   TxOn   G4On   G3On   G2On   G1On   SpPr|TxPr|GxOn
      //N 表示画面なし
      vcnModeTable[  3 +                                                  i] = (
        vcnModeTable[3 +               TXON +                             i] =
        vcnModeTable[3 +        SPON +                                    i] =
        vcnModeTable[3 +        SPON + TXON +                             i] = DrawingMode.N);
      vcnModeTable[  3 + AHEX +                                           i] = (
        vcnModeTable[3 + AHEX +        TXON +                             i] =
        vcnModeTable[3 + AHEX + SPON +                                    i] =
        vcnModeTable[3 + AHEX + SPON + TXON +                             i] = DrawingMode.XN);
      //Gst 512ドット65536色1プレーン＞スプライト(OFF)＞テキスト(OFF) → Gt 512ドット65536色1プレーン＞テキスト(OFF)
      //Gts 512ドット65536色1プレーン＞テキスト(OFF)＞スプライト(OFF) → Gt 512ドット65536色1プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                                           G1ON + i] = (
        vcnModeTable[3 +                                    G2ON +        i] =
        vcnModeTable[3 +                                    G2ON + G1ON + i] =
        vcnModeTable[3 +                             G3ON +               i] =
        vcnModeTable[3 +                             G3ON +        G1ON + i] =
        vcnModeTable[3 +                             G3ON + G2ON +        i] =
        vcnModeTable[3 +                             G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +                      G4ON +                      i] =
        vcnModeTable[3 +                      G4ON +               G1ON + i] =
        vcnModeTable[3 +                      G4ON +        G2ON +        i] =
        vcnModeTable[3 +                      G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +                      G4ON + G3ON +               i] =
        vcnModeTable[3 +                      G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +                      G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +                      G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON +                      G1ON + i] =
        vcnModeTable[3 +               TXON +               G2ON +        i] =
        vcnModeTable[3 +               TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON +        G3ON +               i] =
        vcnModeTable[3 +               TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 +               TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 +               TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON +                      i] =
        vcnModeTable[3 +               TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 +               TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +               TXON + G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +                             G1ON + i] =
        vcnModeTable[3 +        SPON +                      G2ON +        i] =
        vcnModeTable[3 +        SPON +                      G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +               G3ON +               i] =
        vcnModeTable[3 +        SPON +               G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON +               G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON +                      i] =
        vcnModeTable[3 +        SPON +        G4ON +               G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[3 +        SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON +               i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON +        G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +                      G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +               G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON +               i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +                      i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 +        SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.Gt);
      vcnModeTable[  3 + AHEX +                                    G1ON + i] = (
        vcnModeTable[3 + AHEX +                             G2ON +        i] =
        vcnModeTable[3 + AHEX +                             G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +                      G3ON +               i] =
        vcnModeTable[3 + AHEX +                      G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +                      G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +                      G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON +                      i] =
        vcnModeTable[3 + AHEX +               G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX +               G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +               G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +                      G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +               G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON +               i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +                      i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX +        TXON + G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +                             G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +                      G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +                      G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +               G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +                      i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON +        G4ON + G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +                      G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +               G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON +               G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        G3ON + G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +                      i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +               G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +        G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON +        G2ON + G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON +        G1ON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON + G2ON +        i] =
        vcnModeTable[3 + AHEX + SPON + TXON + G4ON + G3ON + G2ON + G1ON + i] = DrawingMode.XGt);
    }  //for ii
  }  //vcnMakeTable3(int)

  //vcnMakeTable4 (grmm)
  //  描画モード4のテーブルを作る
  public static void vcnMakeTable4 (int grmm) {
    //----------------------------------------------------------------------------------------
    //H  1024ドット16色
    //              SpTx_3210          SpTx_3210
    for (int ii = 0b0000_0000; ii <= 0b1111_1111; ii++) {
      //                               3210                 SpTx
      int i = grmm << 6 | (ii & 0b0000_1111) << 9 | (ii & 0b1111_0000) >> 2;
      int s = i >> 4 & 3;
      int t = i >> 2 & 3;
      //----------------------------------------------------------------------------------------
      //GrPr==0
      //        GrPr   AHEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[                                i] = DrawingMode.N;
      vcnModeTable[    AHEX +                      i] = DrawingMode.XN;
      //Hst 1024ドット16色1プレーン＞スプライト(OFF)＞テキスト(OFF) → Ht 1024ドット16色1プレーン＞テキスト(OFF)
      //Hts 1024ドット16色1プレーン＞テキスト(OFF)＞スプライト(OFF) → Ht 1024ドット16色1プレーン＞テキスト(OFF)
      vcnModeTable[                         GXON + i] = DrawingMode.Ht;
      vcnModeTable[    AHEX +               GXON + i] = DrawingMode.XHt;
      //T テキスト
      vcnModeTable[                  TXON +        i] = DrawingMode.T;
      vcnModeTable[    AHEX +        TXON +        i] = DrawingMode.XT;
      //HsT 1024ドット16色1プレーン＞スプライト(OFF)＞テキスト → HT 1024ドット16色1プレーン＞テキスト
      //HTs 1024ドット16色1プレーン＞テキスト＞スプライト(OFF) → HT 1024ドット16色1プレーン＞テキスト
      vcnModeTable[                  TXON + GXON + i] = DrawingMode.HT;
      vcnModeTable[    AHEX +        TXON + GXON + i] = DrawingMode.XHT;
      //S スプライト
      vcnModeTable[           SPON +               i] = DrawingMode.S;
      vcnModeTable[    AHEX + SPON +               i] = DrawingMode.XS;
      //HSt 1024ドット16色1プレーン＞スプライト＞テキスト(OFF) → HS 1024ドット16色1プレーン＞スプライト
      //HtS 1024ドット16色1プレーン＞テキスト(OFF)＞スプライト → HS 1024ドット16色1プレーン＞スプライト
      vcnModeTable[           SPON +        GXON + i] = DrawingMode.HS;
      vcnModeTable[    AHEX + SPON +        GXON + i] = DrawingMode.XHS;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[           SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[    AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //HST 1024ドット16色1プレーン＞スプライト＞テキスト
      //HTS 1024ドット16色1プレーン＞テキスト＞スプライト
      vcnModeTable[           SPON + TXON + GXON + i] = s < t ? DrawingMode.HST : DrawingMode.HTS;
      vcnModeTable[    AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XHST : DrawingMode.XHTS;
      //----------------------------------------------------------------------------------------
      //GrPr==1
      //        GrPr   AHEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[1 +                             i] = DrawingMode.N;
      vcnModeTable[1 + AHEX +                      i] = DrawingMode.XN;
      //sHt スプライト(OFF)＞1024ドット16色1プレーン＞テキスト(OFF) → Ht 1024ドット16色1プレーン＞テキスト(OFF)
      //tHs テキスト(OFF)＞1024ドット16色1プレーン＞スプライト(OFF) → Ht 1024ドット16色1プレーン＞テキスト(OFF)
      vcnModeTable[1 +                      GXON + i] = DrawingMode.Ht;
      vcnModeTable[1 + AHEX +               GXON + i] = DrawingMode.XHt;
      //T テキスト
      vcnModeTable[1 +               TXON +        i] = DrawingMode.T;
      vcnModeTable[1 + AHEX +        TXON +        i] = DrawingMode.XT;
      //sHT スプライト(OFF)＞1024ドット16色1プレーン＞テキスト → HT 1024ドット16色1プレーン＞テキスト
      //THs テキスト＞1024ドット16色1プレーン＞スプライト(OFF)
      vcnModeTable[1 +               TXON + GXON + i] = s < t ? DrawingMode.HT : DrawingMode.THs;
      vcnModeTable[1 + AHEX +        TXON + GXON + i] = s < t ? DrawingMode.XHT : DrawingMode.XTHs;
      //S スプライト
      vcnModeTable[1 +        SPON +               i] = DrawingMode.S;
      vcnModeTable[1 + AHEX + SPON +               i] = DrawingMode.XS;
      //SHt スプライト＞1024ドット16色1プレーン＞テキスト(OFF)
      //tHS テキスト(OFF)＞1024ドット16色1プレーン＞スプライト → HS 1024ドット16色1プレーン＞スプライト
      vcnModeTable[1 +        SPON +        GXON + i] = s < t ? DrawingMode.SHt : DrawingMode.HS;
      vcnModeTable[1 + AHEX + SPON +        GXON + i] = s < t ? DrawingMode.XSHt : DrawingMode.XHS;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[1 +        SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[1 + AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //SHT スプライト＞1024ドット16色1プレーン＞テキスト
      //THS テキスト＞1024ドット16色1プレーン＞スプライト
      vcnModeTable[1 +        SPON + TXON + GXON + i] = s < t ? DrawingMode.SHT : DrawingMode.THS;
      vcnModeTable[1 + AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XSHT : DrawingMode.XTHS;
      //----------------------------------------------------------------------------------------
      //GrPr==2
      //        GrPr   AHEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[2 +                             i] = DrawingMode.N;
      vcnModeTable[2 + AHEX +                      i] = DrawingMode.XN;
      //stH スプライト(OFF)＞テキスト(OFF)＞1024ドット16色1プレーン → H 1024ドット16色1プレーン
      //tsH テキスト(OFF)＞スプライト(OFF)＞1024ドット16色1プレーン → H 1024ドット16色1プレーン
      vcnModeTable[2 +                      GXON + i] = DrawingMode.H;
      vcnModeTable[2 + AHEX +               GXON + i] = DrawingMode.XH;
      //T テキスト
      vcnModeTable[2 +               TXON +        i] = DrawingMode.T;
      vcnModeTable[2 + AHEX +        TXON +        i] = DrawingMode.XT;
      //sTH スプライト(OFF)＞テキスト＞1024ドット16色1プレーン → TH テキスト＞1024ドット16色1プレーン
      //TsH テキスト＞スプライト(OFF)＞1024ドット16色1プレーン → TH テキスト＞1024ドット16色1プレーン
      vcnModeTable[2 +               TXON + GXON + i] = DrawingMode.TH;
      vcnModeTable[2 + AHEX +        TXON + GXON + i] = DrawingMode.XTH;
      //S スプライト
      vcnModeTable[2 +        SPON +               i] = DrawingMode.S;
      vcnModeTable[2 + AHEX + SPON +               i] = DrawingMode.XS;
      //StH スプライト＞テキスト(OFF)＞1024ドット16色1プレーン → SH スプライト＞1024ドット16色1プレーン
      //tSH テキスト(OFF)＞スプライト＞1024ドット16色1プレーン → SH スプライト＞1024ドット16色1プレーン
      vcnModeTable[2 +        SPON +        GXON + i] = DrawingMode.SH;
      vcnModeTable[2 + AHEX + SPON +        GXON + i] = DrawingMode.XSH;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[2 +        SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[2 + AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //STH スプライト＞テキスト＞1024ドット16色1プレーン
      //TSH テキスト＞スプライト＞1024ドット16色1プレーン
      vcnModeTable[2 +        SPON + TXON + GXON + i] = s < t ? DrawingMode.STH : DrawingMode.TSH;
      vcnModeTable[2 + AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XSTH : DrawingMode.XTSH;
      //----------------------------------------------------------------------------------------
      //GrPr==3
      //          GrPr   AHEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[  3 +                             i] = (
        vcnModeTable[3 +               TXON +        i] =
        vcnModeTable[3 +        SPON +               i] =
        vcnModeTable[3 +        SPON + TXON +        i] = DrawingMode.N);
      vcnModeTable[  3 + AHEX +                      i] = (
        vcnModeTable[3 + AHEX +        TXON +        i] =
        vcnModeTable[3 + AHEX + SPON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        i] = DrawingMode.XN);
      //Hst 1024ドット16色1プレーン＞スプライト(OFF)＞テキスト(OFF) → Ht 1024ドット16色1プレーン＞テキスト(OFF)
      //Hts 1024ドット16色1プレーン＞テキスト(OFF)＞スプライト(OFF) → Ht 1024ドット16色1プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                      GXON + i] = (
        vcnModeTable[3 +               TXON + GXON + i] =
        vcnModeTable[3 +        SPON +        GXON + i] =
        vcnModeTable[3 +        SPON + TXON + GXON + i] = DrawingMode.Ht);
      vcnModeTable[  3 + AHEX +               GXON + i] = (
        vcnModeTable[3 + AHEX +        TXON + GXON + i] =
        vcnModeTable[3 + AHEX + SPON +        GXON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + GXON + i] = DrawingMode.XHt);
    }  //for ii
  }  //vcnMakeTable4(int)

  //vcnMakeTable5 (grmm)
  //  描画モード5のテーブルを作る
  public static void vcnMakeTable5 (int grmm) {
    //----------------------------------------------------------------------------------------
    //I  1024ドット256色
    //              SpTx_3210          SpTx_3210
    for (int ii = 0b0000_0000; ii <= 0b1111_1111; ii++) {
      //                               3210                 SpTx
      int i = grmm << 6 | (ii & 0b0000_1111) << 9 | (ii & 0b1111_0000) >> 2;
      int s = i >> 4 & 3;
      int t = i >> 2 & 3;
      //----------------------------------------------------------------------------------------
      //GrPr==0
      //        GrPr   AHEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[                                i] = DrawingMode.N;
      vcnModeTable[    AHEX +                      i] = DrawingMode.XN;
      //Ist 1024ドット256色1プレーン＞スプライト(OFF)＞テキスト(OFF) → It 1024ドット256色1プレーン＞テキスト(OFF)
      //Its 1024ドット256色1プレーン＞テキスト(OFF)＞スプライト(OFF) → It 1024ドット256色1プレーン＞テキスト(OFF)
      vcnModeTable[                         GXON + i] = DrawingMode.It;
      vcnModeTable[    AHEX +               GXON + i] = DrawingMode.XIt;
      //T テキスト
      vcnModeTable[                  TXON +        i] = DrawingMode.T;
      vcnModeTable[    AHEX +        TXON +        i] = DrawingMode.XT;
      //IsT 1024ドット256色1プレーン＞スプライト(OFF)＞テキスト → IT 1024ドット256色1プレーン＞テキスト
      //ITs 1024ドット256色1プレーン＞テキスト＞スプライト(OFF) → IT 1024ドット256色1プレーン＞テキスト
      vcnModeTable[                  TXON + GXON + i] = DrawingMode.IT;
      vcnModeTable[    AHEX +        TXON + GXON + i] = DrawingMode.XIT;
      //S スプライト
      vcnModeTable[           SPON +               i] = DrawingMode.S;
      vcnModeTable[    AHEX + SPON +               i] = DrawingMode.XS;
      //ISt 1024ドット256色1プレーン＞スプライト＞テキスト(OFF) → IS 1024ドット256色1プレーン＞スプライト
      //ItS 1024ドット256色1プレーン＞テキスト(OFF)＞スプライト → IS 1024ドット256色1プレーン＞スプライト
      vcnModeTable[           SPON +        GXON + i] = DrawingMode.IS;
      vcnModeTable[    AHEX + SPON +        GXON + i] = DrawingMode.XIS;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[           SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[    AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //IST 1024ドット256色1プレーン＞スプライト＞テキスト
      //ITS 1024ドット256色1プレーン＞テキスト＞スプライト
      vcnModeTable[           SPON + TXON + GXON + i] = s < t ? DrawingMode.IST : DrawingMode.ITS;
      vcnModeTable[    AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XIST : DrawingMode.XITS;
      //----------------------------------------------------------------------------------------
      //GrPr==1
      //        GrPr   AIEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[1 +                             i] = DrawingMode.N;
      vcnModeTable[1 + AHEX +                      i] = DrawingMode.XN;
      //sIt スプライト(OFF)＞1024ドット256色1プレーン＞テキスト(OFF) → It 1024ドット256色1プレーン＞テキスト(OFF)
      //tIs テキスト(OFF)＞1024ドット256色1プレーン＞スプライト(OFF) → It 1024ドット256色1プレーン＞テキスト(OFF)
      vcnModeTable[1 +                      GXON + i] = DrawingMode.It;
      vcnModeTable[1 + AHEX +               GXON + i] = DrawingMode.XIt;
      //T テキスト
      vcnModeTable[1 +               TXON +        i] = DrawingMode.T;
      vcnModeTable[1 + AHEX +        TXON +        i] = DrawingMode.XT;
      //sIT スプライト(OFF)＞1024ドット256色1プレーン＞テキスト → IT 1024ドット256色1プレーン＞テキスト
      //TIs テキスト＞1024ドット256色1プレーン＞スプライト(OFF)
      vcnModeTable[1 +               TXON + GXON + i] = s < t ? DrawingMode.IT : DrawingMode.TIs;
      vcnModeTable[1 + AHEX +        TXON + GXON + i] = s < t ? DrawingMode.XIT : DrawingMode.XTIs;
      //S スプライト
      vcnModeTable[1 +        SPON +               i] = DrawingMode.S;
      vcnModeTable[1 + AHEX + SPON +               i] = DrawingMode.XS;
      //SIt スプライト＞1024ドット256色1プレーン＞テキスト(OFF)
      //tIS テキスト(OFF)＞1024ドット256色1プレーン＞スプライト → IS 1024ドット256色1プレーン＞スプライト
      vcnModeTable[1 +        SPON +        GXON + i] = s < t ? DrawingMode.SIt : DrawingMode.IS;
      vcnModeTable[1 + AHEX + SPON +        GXON + i] = s < t ? DrawingMode.XSIt : DrawingMode.XIS;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[1 +        SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[1 + AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //SIT スプライト＞1024ドット256色1プレーン＞テキスト
      //TIS テキスト＞1024ドット256色1プレーン＞スプライト
      vcnModeTable[1 +        SPON + TXON + GXON + i] = s < t ? DrawingMode.SIT : DrawingMode.TIS;
      vcnModeTable[1 + AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XSIT : DrawingMode.XTIS;
      //----------------------------------------------------------------------------------------
      //GrPr==2
      //        GrPr   AIEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[2 +                             i] = DrawingMode.N;
      vcnModeTable[2 + AHEX +                      i] = DrawingMode.XN;
      //stI スプライト(OFF)＞テキスト(OFF)＞1024ドット256色1プレーン → I 1024ドット256色1プレーン
      //tsI テキスト(OFF)＞スプライト(OFF)＞1024ドット256色1プレーン → I 1024ドット256色1プレーン
      vcnModeTable[2 +                      GXON + i] = DrawingMode.I;
      vcnModeTable[2 + AHEX +               GXON + i] = DrawingMode.XI;
      //T テキスト
      vcnModeTable[2 +               TXON +        i] = DrawingMode.T;
      vcnModeTable[2 + AHEX +        TXON +        i] = DrawingMode.XT;
      //sTI スプライト(OFF)＞テキスト＞1024ドット256色1プレーン → TI テキスト＞1024ドット256色1プレーン
      //TsI テキスト＞スプライト(OFF)＞1024ドット256色1プレーン → TI テキスト＞1024ドット256色1プレーン
      vcnModeTable[2 +               TXON + GXON + i] = DrawingMode.TI;
      vcnModeTable[2 + AHEX +        TXON + GXON + i] = DrawingMode.XTI;
      //S スプライト
      vcnModeTable[2 +        SPON +               i] = DrawingMode.S;
      vcnModeTable[2 + AHEX + SPON +               i] = DrawingMode.XS;
      //StI スプライト＞テキスト(OFF)＞1024ドット256色1プレーン → SI スプライト＞1024ドット256色1プレーン
      //tSI テキスト(OFF)＞スプライト＞1024ドット256色1プレーン → SI スプライト＞1024ドット256色1プレーン
      vcnModeTable[2 +        SPON +        GXON + i] = DrawingMode.SI;
      vcnModeTable[2 + AHEX + SPON +        GXON + i] = DrawingMode.XSI;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[2 +        SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[2 + AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //STI スプライト＞テキスト＞1024ドット256色1プレーン
      //TSI テキスト＞スプライト＞1024ドット256色1プレーン
      vcnModeTable[2 +        SPON + TXON + GXON + i] = s < t ? DrawingMode.STI : DrawingMode.TSI;
      vcnModeTable[2 + AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XSTI : DrawingMode.XTSI;
      //----------------------------------------------------------------------------------------
      //GrPr==3
      //          GrPr   AIEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[  3 +                             i] = (
        vcnModeTable[3 +               TXON +        i] =
        vcnModeTable[3 +        SPON +               i] =
        vcnModeTable[3 +        SPON + TXON +        i] = DrawingMode.N);
      vcnModeTable[  3 + AHEX +                      i] = (
        vcnModeTable[3 + AHEX +        TXON +        i] =
        vcnModeTable[3 + AHEX + SPON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        i] = DrawingMode.XN);
      //Ist 1024ドット256色1プレーン＞スプライト(OFF)＞テキスト(OFF) → It 1024ドット256色1プレーン＞テキスト(OFF)
      //Its 1024ドット256色1プレーン＞テキスト(OFF)＞スプライト(OFF) → It 1024ドット256色1プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                      GXON + i] = (
        vcnModeTable[3 +               TXON + GXON + i] =
        vcnModeTable[3 +        SPON +        GXON + i] =
        vcnModeTable[3 +        SPON + TXON + GXON + i] = DrawingMode.It);
      vcnModeTable[  3 + AHEX +               GXON + i] = (
        vcnModeTable[3 + AHEX +        TXON + GXON + i] =
        vcnModeTable[3 + AHEX + SPON +        GXON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + GXON + i] = DrawingMode.XIt);
    }  //for ii
  }  //vcnMakeTable5(int)

  //vcnMakeTable7 (grmm)
  //  描画モード7のテーブルを作る
  public static void vcnMakeTable7 (int grmm) {
    //----------------------------------------------------------------------------------------
    //J  1024ドット65536色
    //              SpTx_3210          SpTx_3210
    for (int ii = 0b0000_0000; ii <= 0b1111_1111; ii++) {
      //                               3210                 SpTx
      int i = grmm << 6 | (ii & 0b0000_1111) << 9 | (ii & 0b1111_0000) >> 2;
      int s = i >> 4 & 3;
      int t = i >> 2 & 3;
      //----------------------------------------------------------------------------------------
      //GrPr==0
      //        GrPr   AHEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[                                i] = DrawingMode.N;
      vcnModeTable[    AHEX +                      i] = DrawingMode.XN;
      //Jst 1024ドット65536色1プレーン＞スプライト(OFF)＞テキスト(OFF) → Jt 1024ドット65536色1プレーン＞テキスト(OFF)
      //Jts 1024ドット65536色1プレーン＞テキスト(OFF)＞スプライト(OFF) → Jt 1024ドット65536色1プレーン＞テキスト(OFF)
      vcnModeTable[                         GXON + i] = DrawingMode.Jt;
      vcnModeTable[    AHEX +               GXON + i] = DrawingMode.XJt;
      //T テキスト
      vcnModeTable[                  TXON +        i] = DrawingMode.T;
      vcnModeTable[    AHEX +        TXON +        i] = DrawingMode.XT;
      //JsT 1024ドット65536色1プレーン＞スプライト(OFF)＞テキスト → JT 1024ドット65536色1プレーン＞テキスト
      //JTs 1024ドット65536色1プレーン＞テキスト＞スプライト(OFF) → JT 1024ドット65536色1プレーン＞テキスト
      vcnModeTable[                  TXON + GXON + i] = DrawingMode.JT;
      vcnModeTable[    AHEX +        TXON + GXON + i] = DrawingMode.XJT;
      //S スプライト
      vcnModeTable[           SPON +               i] = DrawingMode.S;
      vcnModeTable[    AHEX + SPON +               i] = DrawingMode.XS;
      //JSt 1024ドット65536色1プレーン＞スプライト＞テキスト(OFF) → JS 1024ドット65536色1プレーン＞スプライト
      //JtS 1024ドット65536色1プレーン＞テキスト(OFF)＞スプライト → JS 1024ドット65536色1プレーン＞スプライト
      vcnModeTable[           SPON +        GXON + i] = DrawingMode.JS;
      vcnModeTable[    AHEX + SPON +        GXON + i] = DrawingMode.XJS;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[           SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[    AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //JST 1024ドット65536色1プレーン＞スプライト＞テキスト
      //JTS 1024ドット65536色1プレーン＞テキスト＞スプライト
      vcnModeTable[           SPON + TXON + GXON + i] = s < t ? DrawingMode.JST : DrawingMode.JTS;
      vcnModeTable[    AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XJST : DrawingMode.XJTS;
      //----------------------------------------------------------------------------------------
      //GrPr==1
      //        GrPr   AJEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[1 +                             i] = DrawingMode.N;
      vcnModeTable[1 + AHEX +                      i] = DrawingMode.XN;
      //sJt スプライト(OFF)＞1024ドット65536色1プレーン＞テキスト(OFF) → Jt 1024ドット65536色1プレーン＞テキスト(OFF)
      //tJs テキスト(OFF)＞1024ドット65536色1プレーン＞スプライト(OFF) → Jt 1024ドット65536色1プレーン＞テキスト(OFF)
      vcnModeTable[1 +                      GXON + i] = DrawingMode.Jt;
      vcnModeTable[1 + AHEX +               GXON + i] = DrawingMode.XJt;
      //T テキスト
      vcnModeTable[1 +               TXON +        i] = DrawingMode.T;
      vcnModeTable[1 + AHEX +        TXON +        i] = DrawingMode.XT;
      //sJT スプライト(OFF)＞1024ドット65536色1プレーン＞テキスト → JT 1024ドット65536色1プレーン＞テキスト
      //TJs テキスト＞1024ドット65536色1プレーン＞スプライト(OFF)
      vcnModeTable[1 +               TXON + GXON + i] = s < t ? DrawingMode.JT : DrawingMode.TJs;
      vcnModeTable[1 + AHEX +        TXON + GXON + i] = s < t ? DrawingMode.XJT : DrawingMode.XTJs;
      //S スプライト
      vcnModeTable[1 +        SPON +               i] = DrawingMode.S;
      vcnModeTable[1 + AHEX + SPON +               i] = DrawingMode.XS;
      //SJt スプライト＞1024ドット65536色1プレーン＞テキスト(OFF)
      //tJS テキスト(OFF)＞1024ドット65536色1プレーン＞スプライト → JS 1024ドット65536色1プレーン＞スプライト
      vcnModeTable[1 +        SPON +        GXON + i] = s < t ? DrawingMode.SJt : DrawingMode.JS;
      vcnModeTable[1 + AHEX + SPON +        GXON + i] = s < t ? DrawingMode.XSJt : DrawingMode.XJS;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[1 +        SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[1 + AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //SJT スプライト＞1024ドット65536色1プレーン＞テキスト
      //TJS テキスト＞1024ドット65536色1プレーン＞スプライト
      vcnModeTable[1 +        SPON + TXON + GXON + i] = s < t ? DrawingMode.SJT : DrawingMode.TJS;
      vcnModeTable[1 + AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XSJT : DrawingMode.XTJS;
      //----------------------------------------------------------------------------------------
      //GrPr==2
      //        GrPr   AJEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[2 +                             i] = DrawingMode.N;
      vcnModeTable[2 + AHEX +                      i] = DrawingMode.XN;
      //stJ スプライト(OFF)＞テキスト(OFF)＞1024ドット65536色1プレーン → J 1024ドット65536色1プレーン
      //tsJ テキスト(OFF)＞スプライト(OFF)＞1024ドット65536色1プレーン → J 1024ドット65536色1プレーン
      vcnModeTable[2 +                      GXON + i] = DrawingMode.J;
      vcnModeTable[2 + AHEX +               GXON + i] = DrawingMode.XJ;
      //T テキスト
      vcnModeTable[2 +               TXON +        i] = DrawingMode.T;
      vcnModeTable[2 + AHEX +        TXON +        i] = DrawingMode.XT;
      //sTJ スプライト(OFF)＞テキスト＞1024ドット65536色1プレーン → TJ テキスト＞1024ドット65536色1プレーン
      //TsJ テキスト＞スプライト(OFF)＞1024ドット65536色1プレーン → TJ テキスト＞1024ドット65536色1プレーン
      vcnModeTable[2 +               TXON + GXON + i] = DrawingMode.TJ;
      vcnModeTable[2 + AHEX +        TXON + GXON + i] = DrawingMode.XTJ;
      //S スプライト
      vcnModeTable[2 +        SPON +               i] = DrawingMode.S;
      vcnModeTable[2 + AHEX + SPON +               i] = DrawingMode.XS;
      //StJ スプライト＞テキスト(OFF)＞1024ドット65536色1プレーン → SJ スプライト＞1024ドット65536色1プレーン
      //tSJ テキスト(OFF)＞スプライト＞1024ドット65536色1プレーン → SJ スプライト＞1024ドット65536色1プレーン
      vcnModeTable[2 +        SPON +        GXON + i] = DrawingMode.SJ;
      vcnModeTable[2 + AHEX + SPON +        GXON + i] = DrawingMode.XSJ;
      //ST スプライト＞テキスト
      //TS テキスト＞スプライト
      vcnModeTable[2 +        SPON + TXON +        i] = s < t ? DrawingMode.ST : DrawingMode.TS;
      vcnModeTable[2 + AHEX + SPON + TXON +        i] = s < t ? DrawingMode.XST : DrawingMode.XTS;
      //STJ スプライト＞テキスト＞1024ドット65536色1プレーン
      //TSJ テキスト＞スプライト＞1024ドット65536色1プレーン
      vcnModeTable[2 +        SPON + TXON + GXON + i] = s < t ? DrawingMode.STJ : DrawingMode.TSJ;
      vcnModeTable[2 + AHEX + SPON + TXON + GXON + i] = s < t ? DrawingMode.XSTJ : DrawingMode.XTSJ;
      //----------------------------------------------------------------------------------------
      //GrPr==3
      //          GrPr   AJEx   SpOn   TxOn   GxOn   SpPr|TxPr
      //N 表示画面なし
      vcnModeTable[  3 +                             i] = (
        vcnModeTable[3 +               TXON +        i] =
        vcnModeTable[3 +        SPON +               i] =
        vcnModeTable[3 +        SPON + TXON +        i] = DrawingMode.N);
      vcnModeTable[  3 + AHEX +                      i] = (
        vcnModeTable[3 + AHEX +        TXON +        i] =
        vcnModeTable[3 + AHEX + SPON +               i] =
        vcnModeTable[3 + AHEX + SPON + TXON +        i] = DrawingMode.XN);
      //Jst 1024ドット65536色1プレーン＞スプライト(OFF)＞テキスト(OFF) → Jt 1024ドット65536色1プレーン＞テキスト(OFF)
      //Jts 1024ドット65536色1プレーン＞テキスト(OFF)＞スプライト(OFF) → Jt 1024ドット65536色1プレーン＞テキスト(OFF)
      vcnModeTable[  3 +                      GXON + i] = (
        vcnModeTable[3 +               TXON + GXON + i] =
        vcnModeTable[3 +        SPON +        GXON + i] =
        vcnModeTable[3 +        SPON + TXON + GXON + i] = DrawingMode.Jt);
      vcnModeTable[  3 + AHEX +               GXON + i] = (
        vcnModeTable[3 + AHEX +        TXON + GXON + i] =
        vcnModeTable[3 + AHEX + SPON +        GXON + i] =
        vcnModeTable[3 + AHEX + SPON + TXON + GXON + i] = DrawingMode.XJt);
    }  //for ii
  }  //vcnMakeTable7()

  //vcnReset ()
  //  ビデオコントローラをリセットする
  public static void vcnReset () {
    vcnReg1Port = 0;
    vcnReg1Mask = 0;
    vcnReg1Test = 0;
    vcnReg1Curr = 0;
    vcnReg2Port = 0;
    vcnReg2Mask = 0;
    vcnReg2Test = 0;
    vcnReg2Curr = 0;
    vcnReg3Port = 0;
    vcnReg3Mask = 0;
    vcnReg3Test = 0;
    vcnReg3Curr = 0;
    vcnPalTbl = vcnPalBase[VCN_CONTRAST_SCALE * 15];
    vcnCurrentScaledContrast = VCN_CONTRAST_SCALE * 15;
    vcnTargetContrastPort = 15;
    vcnTargetContrastMask = 0;
    vcnTargetContrastTest = 15;
    vcnTargetContrastCurr = 15;
    vcnTargetScaledContrast = VCN_CONTRAST_SCALE * 15;
    vcnMode = DrawingMode.N;
    vcnHidden1st = 0;
    vcnHidden2nd = 0;
    vcnHidden3rd = 0;
    vcnHidden4th = 0;
    vcnVisible1st = 0x400000;
    vcnVisible2nd = 0x400000;
    vcnVisible3rd = 0x400000;
    vcnVisible4th = 0x400000;

    if (CRTC.CRT_EXTENDED_GRAPHIC) {
      if (CRTC.crtExtendedGraphicRequest) {
        vcnMakeTable5 (5);
        vcnMakeTable7 (6);
        vcnMakeTable7 (7);
      } else {
        vcnMakeTable4 (5);
        vcnMakeTable4 (6);
        vcnMakeTable4 (7);
      }
    }

  }  //vcnReset()

  //vcnUpdateMode ()
  //  描画モードを更新する
  public static void vcnUpdateMode () {
    DrawingMode newMode = vcnModeTable[-(vcnReg3Curr & 0x5000) & 0x10000 | (char) (vcnReg3Curr << 9) | vcnReg1Curr << 6 | vcnReg2Curr >> 8];
    if (vcnMode != newMode) {
      if (VCN_LOG_TRANSITION) {
        vcnLogTransition (vcnMode, newMode);
      }
      vcnMode = newMode;
    }
    //グラフィックプレーンのON/OFFと組み換え
    if (vcnReg1Curr < 4) {  //512ドット
      boolean on1st, on2nd, on3rd, on4th;
      if (vcnReg1Curr == 0) {  //512ドット16色
        on1st =                         (vcnReg3Curr &             1) != 0;
        on2nd =                         (vcnReg3Curr &         2    ) != 0;
        on3rd =                         (vcnReg3Curr &     4        ) != 0;
        on4th =                         (vcnReg3Curr & 8            ) != 0;
      } else if (vcnReg1Curr == 1) {  //512ドット256色
        on2nd = on1st =                 (vcnReg3Curr &         2 + 1) != 0;
        on4th = on3rd =                 (vcnReg3Curr & 8 + 4        ) != 0;
      } else {  //512ドット65536色
        on4th = on3rd = on2nd = on1st = (vcnReg3Curr & 8 + 4 + 2 + 1) != 0;
      }
      vcnHidden1st = ((vcnReg2Curr & 3     ) << 18    );
      vcnHidden2nd = ((vcnReg2Curr & 3 << 2) << 18 - 2);
      vcnHidden3rd = ((vcnReg2Curr & 3 << 4) << 18 - 4);
      vcnHidden4th = ((vcnReg2Curr & 3 << 6) << 18 - 6);
      vcnVisible1st = on1st ? vcnHidden1st : 0x400000;
      vcnVisible2nd = on2nd ? vcnHidden2nd : 0x400000;
      vcnVisible3rd = on3rd ? vcnHidden3rd : 0x400000;
      vcnVisible4th = on4th ? vcnHidden4th : 0x400000;
    }
    CRTC.crtAllStamp += 2;
  }  //vcnUpdateMode()

  //vcnSetContrast (contrast)
  //  コントラストを設定する
  public static void vcnSetContrast (int contrast) {
    vcnPalTbl = vcnPalBase[contrast];
    for (int i = 0; i < 256; i++) {
      vcnPal32G8[i] = vcnPalTbl[vcnPal16G8[i]];
      vcnPal32TS[i] = vcnPalTbl[vcnPal16TS[i]];
    }
    CRTC.crtAllStamp += 2;
  }  //vcnSetContrast(int)

  public static void vcnLogTransition (DrawingMode oldMode, DrawingMode newMode) {
    if (VCN_LOG_TRANSITION) {
      StringBuilder sb = new StringBuilder ();
      sb.append (oldMode.name ());
      sb.append (" → ");
      sb.append (newMode.name ());
      System.out.println (sb.toString ());
    }
  }  //vcnLogTransition(DrawingMode,DrawingMode)

  //vcnReportUnimplemented (mode)
  //  未実装画面モードを報告する
  public static void vcnReportUnimplemented (DrawingMode mode) {
    String name = vcnGetName (new StringBuilder ().append (mode.name ()).append ('(')).append (')').toString ();
    if (!vcnUnimplementedSet.contains (name)) {  //未報告
      System.out.println (new StringBuilder ().append (Multilingual.mlnJapanese ? "未実装 " : "Unimplemented ").append (name).toString ());
      vcnUnimplementedSet.add (name);
    }
  }  //vcnReportUnimplemented(DrawingMode)

  //sb = vcnGetName (StringBuilder sb)
  //  現在の画面モードの文字列を作る
  //  優先順位は表示されていない画面も書く
  //  拡張モードはONの拡張だけ書く
  public static StringBuilder vcnGetName (StringBuilder sb) {
    //スプライト画面
    String sprite = (vcnReg3Curr & 1 << 6) != 0 ? "S" : "s";
    //テキスト画面
    String text = (vcnReg3Curr & 1 << 5) != 0 ? "T" : "t";
    //スプライト画面とテキスト画面の優先順位
    String spriteText1 = "";
    String spriteText2 = "";
    if ((vcnReg2Curr & 3 << 12) < (vcnReg2Curr << 12 - 10 & 3 << 12)) {  //スプライト＞テキスト
      spriteText1 = sprite;
      spriteText2 = text;
    } else {  //テキスト＞スプライト
      spriteText1 = text;
      spriteText2 = sprite;
    }
    //グラフィック画面
    String graphic = ((vcnReg1Curr & 0b100) != 0 ?  //1024ドット
                      (vcnReg1Curr & 0b010) != 0 ?  //1024ドット65536色
                      (vcnReg3Curr & 0b10000) != 0 ? "J" :  //1024ドット65536色1プレーン
                      "j" :  //1024ドット65536色0プレーン
                      (vcnReg1Curr & 0b001) != 0 ?  //1024ドット256色
                      (vcnReg3Curr & 0b10000) != 0 ? "I" :  //1024ドット256色1プレーン
                      "i" :  //1024ドット256色0プレーン
                      //1024ドット16色
                      (vcnReg3Curr & 0b10000) != 0 ? "H" :  //1024ドット16色1プレーン
                      "h" :  //1024ドット16色0プレーン
                      //512ドット
                      (vcnReg1Curr & 0b010) != 0 ?  //512ドット65536色
                      (vcnReg3Curr & 0b1111) != 0 ? "G" :  //512ドット65536色1プレーン
                      "g" :  //512ドット65536色0プレーン
                      (vcnReg1Curr & 0b001) != 0 ?  //512ドット256色
                      (vcnReg3Curr & 0b1100) != 0 ? "F2" :  //512ドット256色2プレーン
                      (vcnReg3Curr & 0b1111) != 0 ? "F1" :  //512ドット256色1プレーン
                      "f" :  //512ドット256色0プレーン
                      //512ドット16色
                      (vcnReg3Curr & 0b1000) != 0 ? "E4" :  //512ドット16色4プレーン
                      (vcnReg3Curr & 0b1100) != 0 ? "E3" :  //512ドット16色3プレーン
                      (vcnReg3Curr & 0b1110) != 0 ? "E2" :  //512ドット16色2プレーン
                      (vcnReg3Curr & 0b1111) != 0 ? "E1" :  //512ドット16色1プレーン
                      "e");  //512ドット16色0プレーン
    //グラフィック画面の優先順位
    int grpr = vcnReg2Curr >> 8 & 3;
    if (grpr == 0) {  //グラフィック＞スプライトまたはテキスト＞スプライトまたはテキスト
      sb.append (graphic).append (spriteText1).append (spriteText2);
    } else if (grpr == 1) {  //スプライトまたはテキスト＞グラフィック＞スプライトまたはテキスト
      sb.append (spriteText1).append (graphic).append (spriteText2);
    } else if (grpr == 2) {  //スプライトまたはテキスト＞スプライトまたはテキスト＞グラフィック
      sb.append (spriteText1).append (spriteText2).append (graphic);
    } else {  //グラフィック＞スプライトまたはテキスト(OFF)＞スプライトまたはテキスト(OFF)
      sb.append (graphic).append (spriteText1).append (spriteText2);
    }
    int i = sb.length ();
    if ((vcnReg3Curr & 1 << 14) != 0) {  //AHOn
      sb.append ('A');
    }
    if ((vcnReg3Curr & 1 << 12) != 0) {  //ExOn
      sb.append ('X');
    }
    if ((vcnReg3Curr & (1 << 12 | 1 << 11)) != 0) {  //ExOn,Half
      sb.append ((vcnReg3Curr & 1 << 11) != 0 ? 'H' : 'W');  //Half
    }
    if ((vcnReg3Curr & (1 << 12 | 1 << 10)) != 0) {  //ExOn,PLSB
      sb.append ((vcnReg3Curr & 1 << 10) != 0 ? 'P' : 'C');  //PLSB
    }
    if ((vcnReg3Curr & 1 << 9) != 0) {  //GrGr
      sb.append ('G');
    }
    if ((vcnReg3Curr & 1 << 8) != 0) {  //GrST
      sb.append ('T');
    }
    if (i < sb.length ()) {
      sb.insert (i, '_');
    }
    return sb;
  }  //vcnGetName()


  //vcnMix1 (x)
  //vcnMix2 (x, y)
  //  半透明合成
  //  x=G<<11|R<<6|B<<1|I  手前のグラフィック画面の色
  //  y=g<<11|r<<6|b<<1|i  奥のテキスト・スプライト画面の色
  //  z=G+g>>1<<11|R+r>>1<<6|B+b>>1<<1|i  合成された色。グラフィック画面のIは使用しない
  public static int vcnMix1 (int x) {
    return x >> 1 & 0b01111_01111_01111_0;
  }  //vcnMix1(int)
  public static int vcnMix2 (int x, int y) {
    return ((x & 0b11111_00000_11111_0    ) + (y & 0b11111_00000_11111_0) >> 1 & 0b11111_00000_11111_0 |
            (x & 0b00000_11111_00000_0 | 1) + (y & 0b00000_11111_00000_1) >> 1 & 0b00000_11111_00000_1);
  }  //vcnMix2(int,int)

}  //class VideoController



