;========================================================================================
;  isHFS.s
;  Copyright (C) 2003-2024 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;
;	isHFS.x
;		JghCu܂͎w肳ꂽhCuHFSׂ܂B
;
;	ŏIXV
;		2024-08-08
;
;	
;		has060 -i include -o isHFS.o -w isHFS.s
;		lk -o isHFS.x isHFS.o
;
;	g
;		>isHFS [hCu]
;		A: c Z:
;		a: c z:
;			hCu
;		@:
;			JghCu
;		ȗ̓JghCu
;
;	IR[h
;		0	HFSł͂Ȃ
;		1	HFS
;
;----------------------------------------------------------------

	.include	doscall.mac
	.include	iocscall.mac

;hCuHFSׂ
;<(sp).l:hCuԍB0=Jg,1=A:,c,26=Z:
;>d0.l:0=HFSł͂Ȃ,1=HFS
_isHFS::
	move.l	a1,-(sp)
	lea.l	-94(sp),sp		;DPBe[ü̗mۂ
;DPBe[uo
	move.l	sp,-(sp)		;DPBe[ũAhX
	move.w	4+94+4+4+2(sp),-(sp)	;hCuԍB0=Jg,1=A:,c,26=Z:
	DOS	_GETDPB
	addq.l	#6,sp
	tst.l	d0
	bmi	10f			;oȂ
;foCXhCo֐i
	lea.l	18(sp),a1		;foCXhCõAhX̃AhX
	IOCS	_B_LPEEK
	movea.l	d0,a1			;foCXhCõAhX
;foCXmF
	lea.l	14(a1),a1		;foCX̃AhX
	IOCS	_B_LPEEK
	cmp.l	#$01_000000+'XEI',d0
	bne	10f			;Ⴄ
	IOCS	_B_LPEEK
	cmp.l	#'JHFS',d0
	bne	10f			;Ⴄ
;ʂԂ
	moveq.l	#1,d0			;HFS
	bra	20f

10:	moveq.l	#0,d0			;HFSł͂Ȃ
20:	lea.l	94(sp),sp
	movea.l	(sp)+,a1
	rts

;Jnʒu
start:
;󔒂ǂݔ΂
	addq.l	#1,a2			;a2=R}hC
	moveq.l	#0,d0
10:	move.b	(a2)+,d0
	beq	20f			;ȂBJghCu𒲂ׂ
	cmpi.b	#' ',d0
	beq	10b			;󔒂ǂݔ΂
	cmpi.b	#9,d0
	beq	10b			;󔒂ǂݔ΂
;hCuǂݎ
	cmp.b	#'@',d0
	beq	20f			;@:BJghCu𒲂ׂ
	and.b	#$DF,d0			;啶
	sub.b	#'A',d0			;'A',c,'Z'0=A:,c,25=Z:ɂ
	blo	50f			;@G[Bgp@\ďI
	cmp.b	#'Z'-'A',d0
	bhi	50f			;@G[Bgp@\ďI
	move.l	d0,d1			;d1=hCuԍB0=A:,c,25=Z:
	bra	30f			;hCuHFSׂ

;JghCu𒲂ׂ
20:	DOS	_CURDRV			;JghCuo
	move.l	d0,d1			;d1=hCuԍB0=A:,c,25=Z:
;hCuHFSׂ
30:	addq.b	#1,d1			;d1=hCuԍB1=A:,c,26=Z:
	move.l	d1,-(sp)
	bsr	_isHFS			;hCuHFSׂ
	addq.l	#4,sp
;ʂ\ďIR[hŕԂ
	move.w	d0,-(sp)		;0=HFSł͂Ȃ,1=HFS
	lea.l	no(pc),a0		;:HFSł͂܂
	beq	40f
	lea.l	yes(pc),a0		;:HFSł
40:	pea.l	drive(pc)		;hCu
	DOS	_PRINT
	moveq.l	#'A'-1,d0
	add.b	d1,d0			;hCuB'A',c,'Z'
	move.w	d0,(sp)
	DOS	_PUTCHAR
	move.l	a0,(sp)			;:HFSł͂܂/:HFSł
	DOS	_PRINT
	addq.l	#4,sp
	DOS	_EXIT2

;gp@\ďI
50:	pea.l	usage(pc)		;gp@
	DOS	_PRINT
	move.w	#-1,(sp)
	DOS	_EXIT2

usage:	.dc.b	'isHFS.x',13,10
	.dc.b	'  hCuHFSׂ܂',13,10
	.dc.b	'  gp@: isHFS [hCu]',13,10
	.dc.b	'  IR[h: 0=HFSł͂Ȃ 1=HFS',13,10,0
drive:	.dc.b	'hCu',0
no:	.dc.b	':HFSł͂܂',13,10,0
yes:	.dc.b	':HFSł',13,10,0

	.end	start
