/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;

public class RotaryButton
extends JButton
implements ActionListener {
    protected int index;
    protected String[] texts;
    protected Icon[] icons;
    protected ArrayList<ActionListener> listeners;

    public RotaryButton(int n, String ... stringArray) {
        super(stringArray[n]);
        this.texts = stringArray;
        this.index = n;
        this.listeners = new ArrayList();
        super.addActionListener(this);
    }

    public RotaryButton(int n, Icon ... iconArray) {
        super(iconArray[n]);
        this.icons = iconArray;
        this.index = n;
        this.listeners = new ArrayList();
        super.addActionListener(this);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        if (this.index != n) {
            this.index = n;
            if (this.texts != null) {
                this.setText(this.texts[n]);
            } else if (this.icons != null) {
                this.setIcon(this.icons[n]);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.texts != null) {
            this.index = this.index + 1 < this.texts.length ? this.index + 1 : 0;
            this.setText(this.texts[this.index]);
        } else if (this.icons != null) {
            this.index = this.index + 1 < this.icons.length ? this.index + 1 : 0;
            this.setIcon(this.icons[this.index]);
        }
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    @Override
    public ActionListener[] getActionListeners() {
        return this.listeners.toArray(new ActionListener[this.listeners.size()]);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }
}

