/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class RootPointerList {
    public static final boolean RTL_ON = true;
    public static final long RTL_SPAN = 3000000000000L;
    public static final int RTL_HASH_BITS = 6;
    public static final int RTL_HASH_SIZE = 64;
    public static final int RTL_HASH_COEFF = 1593577535;
    public static boolean rtlCurrentSupervisorTaskIsStoppable;
    public static boolean rtlCurrentUserTaskIsStoppable;
    public static final RootPointerRecord[] rtlHashTable;
    public static RootPointerRecord rtlFreeRecordList;
    public static JFrame rtlFrame;
    public static ScrollTextArea rtlBoard;
    public static JTextArea rtlTextArea;
    public static final int RTL_INTERVAL = 10;
    public static int rtlTimer;

    public static void rtlInit() {
        rtlCurrentSupervisorTaskIsStoppable = true;
        rtlCurrentUserTaskIsStoppable = true;
        for (int i = 0; i < 64; ++i) {
            RootPointerList.rtlHashTable[i] = null;
        }
        rtlFreeRecordList = null;
        rtlFrame = null;
        rtlTimer = 0;
    }

    public static void rtlStart() {
        if (RestorableFrame.rfmGetOpened("rtl")) {
            RootPointerList.rtlOpen();
        }
    }

    public static void rtlOpen() {
        if (rtlFrame == null) {
            RootPointerList.rtlMakeFrame();
        } else {
            RootPointerList.rtlUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x400;
        XEiJ.pnlExitFullScreen(false);
        rtlFrame.setVisible(true);
    }

    public static void rtlMakeFrame() {
        rtlBoard = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new ScrollTextArea(), LnF.lnfMonospacedFont), 300, 200);
        rtlBoard.setMargin(new Insets(2, 4, 2, 4));
        rtlTextArea = rtlBoard.getTextArea();
        rtlTextArea.setEditable(false);
        ComponentFactory.addListener(rtlTextArea, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                String string = rtlTextArea.getText();
                int n = rtlTextArea.viewToModel2D(new Point(0, mouseEvent.getY()));
                if (n < 0 || string.length() <= n) {
                    return;
                }
                if (0 < n) {
                    n = string.lastIndexOf("\n", n - 1) + 1;
                }
                if (Character.digit(string.charAt(n), 16) < 0) {
                    return;
                }
                int n2 = Integer.parseInt(string.substring(n, n + 8), 16);
                int n3 = n2 * 1593577535 >>> -6;
                RootPointerRecord rootPointerRecord = rtlHashTable[n3];
                while (rootPointerRecord != null) {
                    if (rootPointerRecord.rbrRootPointer == n2) {
                        boolean bl = rootPointerRecord.rbrThisTaskIsStoppable = !rootPointerRecord.rbrThisTaskIsStoppable;
                        if (rootPointerRecord.rbrRootPointer == MC68060.mmuSRP) {
                            rtlCurrentSupervisorTaskIsStoppable = rootPointerRecord.rbrThisTaskIsStoppable;
                        }
                        if (rootPointerRecord.rbrRootPointer == MC68060.mmuURP) {
                            rtlCurrentUserTaskIsStoppable = rootPointerRecord.rbrThisTaskIsStoppable;
                        }
                        return;
                    }
                    rootPointerRecord = rootPointerRecord.rbrNextRecord;
                }
            }
        });
        rtlFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("rtl", "Root pointer list", null, ComponentFactory.createVerticalBox(rtlBoard)), "ja", "\u30eb\u30fc\u30c8\u30dd\u30a4\u30f3\u30bf\u30ea\u30b9\u30c8");
        ComponentFactory.addListener(rtlFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFBFF;
            }
        });
    }

    public static void rtlUpdateFrame() {
        if (rtlFrame == null) {
            return;
        }
        RootPointerList.rtlSetRootPointer(MC68060.mmuURP, false);
        RootPointerList.rtlSetRootPointer(MC68060.mmuSRP, true);
        StringBuilder stringBuilder = new StringBuilder();
        block0: for (int i = 0; i < 64; ++i) {
            RootPointerRecord rootPointerRecord = null;
            RootPointerRecord rootPointerRecord2 = rtlHashTable[i];
            while (rootPointerRecord2 != null) {
                if (rootPointerRecord2.rbrTimeLimit <= XEiJ.mpuClockTime) {
                    if (rootPointerRecord != null) {
                        rootPointerRecord.rbrNextRecord = null;
                    } else {
                        RootPointerList.rtlHashTable[i] = null;
                    }
                    RootPointerRecord rootPointerRecord3 = rootPointerRecord2;
                    while (rootPointerRecord3.rbrNextRecord != null) {
                        rootPointerRecord3 = rootPointerRecord3.rbrNextRecord;
                    }
                    rootPointerRecord3.rbrNextRecord = rtlFreeRecordList;
                    rtlFreeRecordList = rootPointerRecord2;
                    continue block0;
                }
                XEiJ.fmtHex8(stringBuilder, rootPointerRecord2.rbrRootPointer).append(rootPointerRecord2.rbrThisTaskIsStoppable ? (Multilingual.mlnJapanese ? "\t\u505c\u6b62\u8a31\u53ef" : "\tstoppable") : (Multilingual.mlnJapanese ? "\t\u505c\u6b62\u7981\u6b62" : "\tunstoppable")).append('\n');
                rootPointerRecord = rootPointerRecord2;
                rootPointerRecord2 = rootPointerRecord2.rbrNextRecord;
            }
        }
        if (rtlTextArea != null) {
            rtlTextArea.setText(stringBuilder.toString());
        }
    }

    public static void rtlSetRootPointer(int n, boolean bl) {
        int n2 = n * 1593577535 >>> -6;
        RootPointerRecord rootPointerRecord = null;
        RootPointerRecord rootPointerRecord2 = rtlHashTable[n2];
        while (rootPointerRecord2 != null) {
            if (rootPointerRecord2.rbrRootPointer == n) {
                if (rootPointerRecord != null) {
                    rootPointerRecord.rbrNextRecord = rootPointerRecord2.rbrNextRecord;
                    rootPointerRecord2.rbrNextRecord = rtlHashTable[n2];
                    RootPointerList.rtlHashTable[n2] = rootPointerRecord2;
                }
                rootPointerRecord2.rbrTimeLimit = XEiJ.mpuClockTime + 3000000000000L;
                if (bl) {
                    rtlCurrentSupervisorTaskIsStoppable = rootPointerRecord2.rbrThisTaskIsStoppable;
                } else {
                    rtlCurrentUserTaskIsStoppable = rootPointerRecord2.rbrThisTaskIsStoppable;
                }
                return;
            }
            rootPointerRecord = rootPointerRecord2;
            rootPointerRecord2 = rootPointerRecord2.rbrNextRecord;
        }
        if (rtlFreeRecordList == null) {
            rootPointerRecord2 = new RootPointerRecord();
        } else {
            rootPointerRecord2 = rtlFreeRecordList;
            rtlFreeRecordList = rootPointerRecord2.rbrNextRecord;
        }
        rootPointerRecord2.rbrRootPointer = n;
        rootPointerRecord2.rbrNextRecord = rtlHashTable[n2];
        RootPointerList.rtlHashTable[n2] = rootPointerRecord2;
        rootPointerRecord2.rbrTimeLimit = XEiJ.mpuClockTime + 3000000000000L;
        rootPointerRecord2.rbrThisTaskIsStoppable = true;
        if (bl) {
            rtlCurrentSupervisorTaskIsStoppable = rootPointerRecord2.rbrThisTaskIsStoppable;
        } else {
            rtlCurrentUserTaskIsStoppable = rootPointerRecord2.rbrThisTaskIsStoppable;
        }
    }

    static {
        rtlHashTable = new RootPointerRecord[64];
    }

    public static class RootPointerRecord {
        public int rbrRootPointer;
        public RootPointerRecord rbrNextRecord;
        public long rbrTimeLimit;
        public boolean rbrThisTaskIsStoppable;
    }
}

