/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.CRTC;
import xeij.ComponentFactory;
import xeij.DisassembleList;
import xeij.MC68901;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.XEiJ;

public class RasterBreakPoint {
    public static final boolean RBP_ON = true;
    public static boolean rbpBreakEnabled;
    public static int rbpBreakRaster;
    public static int rbpActiveBreakRaster;
    public static boolean rbpIRQBreakEnabled;
    public static int rbpCountValue;
    public static int rbpThresholdValue;
    public static JFrame rbpFrame;
    public static JCheckBox rbpEnabledCheckBox;
    public static JCheckBox rbpIRQEnabledCheckBox;
    public static JLabel rbpStatusLabel;
    public static JTextField rbpCurrentRasterTextField;
    public static JTextField rbpIRQRasterTextField;
    public static SpinnerNumberModel rbpBreakModel;
    public static SpinnerNumberModel rbpCountModel;
    public static SpinnerNumberModel rbpThresholdModel;
    public static final int RBP_INTERVAL = 10;
    public static int rbpTimer;

    public static void rbpInit() {
        rbpBreakEnabled = false;
        rbpBreakRaster = 0;
        rbpActiveBreakRaster = -1;
        rbpIRQBreakEnabled = false;
        rbpCountValue = 0;
        rbpThresholdValue = 0;
        rbpFrame = null;
        rbpTimer = 0;
    }

    public static void rbpStart() {
        if (RestorableFrame.rfmGetOpened("rbp")) {
            RasterBreakPoint.rbpOpen();
        }
    }

    public static void rbpOpen() {
        if (rbpFrame == null) {
            RasterBreakPoint.rbpMakeFrame();
        } else {
            RasterBreakPoint.rbpUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x20;
        XEiJ.pnlExitFullScreen(false);
        rbpFrame.setVisible(true);
    }

    public static void rbpMakeFrame() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Fixed raster ": {
                        RasterBreakPoint.rbpSetBreakEnabled(((JCheckBox)object).isSelected());
                        break;
                    }
                    case "IRQ raster ": {
                        RasterBreakPoint.rbpSetIRQEnabled(((JCheckBox)object).isSelected());
                        break;
                    }
                    case "Run to next raster": {
                        if (XEiJ.mpuTask != null) break;
                        RasterBreakPoint.rbpSetBreakEnabled(false);
                        RasterBreakPoint.rbpSetBreakRaster(CRTC.crtRasterNumber < CRTC.crtR04VFrontEndCurr ? CRTC.crtRasterNumber + 1 : 0);
                        rbpBreakModel.setValue(rbpBreakRaster);
                        RasterBreakPoint.rbpSetBreakEnabled(true);
                        rbpEnabledCheckBox.setSelected(true);
                        RasterBreakPoint.rbpUpdateFrame();
                        XEiJ.mpuStart();
                        break;
                    }
                    case "Run": {
                        if (XEiJ.mpuTask != null) break;
                        XEiJ.mpuStart();
                    }
                }
            }
        };
        Component[] componentArray = new Component[7];
        componentArray[0] = Box.createVerticalStrut(4);
        Component[] componentArray2 = new Component[5];
        componentArray2[0] = Box.createHorizontalStrut(12);
        componentArray2[1] = Box.createHorizontalGlue();
        rbpStatusLabel = ComponentFactory.createLabel(RasterBreakPoint.rbpMakeStatusText());
        componentArray2[2] = rbpStatusLabel;
        componentArray2[3] = Box.createHorizontalGlue();
        componentArray2[4] = Box.createHorizontalStrut(12);
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
        componentArray[2] = Box.createVerticalStrut(4);
        Component[] componentArray3 = new Component[14];
        componentArray3[0] = Box.createHorizontalStrut(12);
        componentArray3[1] = Box.createHorizontalGlue();
        componentArray3[2] = Multilingual.mlnText(ComponentFactory.createLabel("Current raster "), "ja", "\u73fe\u5728\u306e\u30e9\u30b9\u30bf ");
        rbpCurrentRasterTextField = ComponentFactory.setEditable(ComponentFactory.createNumberField(String.valueOf(CRTC.crtRasterNumber), 5), false);
        componentArray3[3] = rbpCurrentRasterTextField;
        componentArray3[4] = Box.createHorizontalStrut(12);
        componentArray3[5] = Box.createHorizontalGlue();
        rbpEnabledCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(rbpBreakEnabled, "Fixed raster ", actionListener), "ja", "\u56fa\u5b9a\u30e9\u30b9\u30bf ");
        componentArray3[6] = rbpEnabledCheckBox;
        rbpBreakModel = new SpinnerNumberModel(rbpBreakRaster, 0, 1023, 1);
        componentArray3[7] = ComponentFactory.createNumberSpinner(rbpBreakModel, 5, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                RasterBreakPoint.rbpSetBreakRaster(rbpBreakModel.getNumber().intValue());
            }
        });
        componentArray3[8] = Box.createHorizontalStrut(12);
        componentArray3[9] = Box.createHorizontalGlue();
        rbpIRQEnabledCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(rbpIRQBreakEnabled, "IRQ raster ", actionListener), "ja", "IRQ \u30e9\u30b9\u30bf ");
        componentArray3[10] = rbpIRQEnabledCheckBox;
        rbpIRQRasterTextField = ComponentFactory.setEditable(ComponentFactory.createNumberField(String.valueOf(CRTC.crtR09IRQRasterCurr), 5), false);
        componentArray3[11] = rbpIRQRasterTextField;
        componentArray3[12] = Box.createHorizontalGlue();
        componentArray3[13] = Box.createHorizontalStrut(12);
        componentArray[3] = ComponentFactory.createHorizontalBox(componentArray3);
        componentArray[4] = Box.createVerticalStrut(4);
        Component[] componentArray4 = new Component[14];
        componentArray4[0] = Box.createHorizontalStrut(12);
        componentArray4[1] = Box.createHorizontalGlue();
        componentArray4[2] = Multilingual.mlnText(ComponentFactory.createLabel("Count "), "ja", "\u56de\u6570 ");
        rbpCountModel = new SpinnerNumberModel(rbpCountValue, 0, 99999999, 1);
        componentArray4[3] = ComponentFactory.createNumberSpinner(rbpCountModel, 8, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                rbpCountValue = rbpCountModel.getNumber().intValue();
            }
        });
        componentArray4[4] = Box.createHorizontalStrut(12);
        componentArray4[5] = Multilingual.mlnText(ComponentFactory.createLabel("Threshold "), "ja", "\u95be\u5024 ");
        rbpThresholdModel = new SpinnerNumberModel(rbpThresholdValue, 0, 99999999, 1);
        componentArray4[6] = ComponentFactory.createNumberSpinner(rbpThresholdModel, 8, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                rbpThresholdValue = rbpThresholdModel.getNumber().intValue();
            }
        });
        componentArray4[7] = Box.createHorizontalStrut(12);
        componentArray4[8] = Box.createHorizontalGlue();
        componentArray4[9] = XEiJ.mpuAddButtonStopped(Multilingual.mlnText(ComponentFactory.createButton("Run to next raster", actionListener), "ja", "\u6b21\u306e\u30e9\u30b9\u30bf\u307e\u3067\u5b9f\u884c"));
        componentArray4[10] = Box.createHorizontalStrut(12);
        componentArray4[11] = XEiJ.mpuAddButtonStopped(Multilingual.mlnText(ComponentFactory.createButton("Run", actionListener), "ja", "\u5b9f\u884c"));
        componentArray4[12] = Box.createHorizontalGlue();
        componentArray4[13] = Box.createHorizontalStrut(12);
        componentArray[5] = ComponentFactory.createHorizontalBox(componentArray4);
        componentArray[6] = Box.createVerticalStrut(4);
        rbpFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("rbp", "Raster break point", null, ComponentFactory.createVerticalBox(componentArray)), "ja", "\u30e9\u30b9\u30bf\u30d6\u30ec\u30fc\u30af\u30dd\u30a4\u30f3\u30c8");
        ComponentFactory.addListener(rbpFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFDF;
            }
        });
    }

    public static String rbpMakeStatusText() {
        StringBuilder stringBuilder = new StringBuilder();
        return (Multilingual.mlnJapanese ? stringBuilder.append("\u5e30\u7dda\u671f\u9593 0-").append(CRTC.crtR05VSyncEndCurr).append("    \u30d0\u30c3\u30af\u30dd\u30fc\u30c1 ").append(CRTC.crtR05VSyncEndCurr + 1).append("-").append(CRTC.crtR06VBackEndCurr).append("    \u6620\u50cf\u671f\u9593 ").append(CRTC.crtR06VBackEndCurr + 1).append("-").append(CRTC.crtR07VDispEndCurr).append("    \u30d5\u30ed\u30f3\u30c8\u30dd\u30fc\u30c1 ").append(CRTC.crtR07VDispEndCurr + 1).append("-").append(CRTC.crtR04VFrontEndCurr) : stringBuilder.append("Blanking period 0-").append(CRTC.crtR05VSyncEndCurr).append("    Back porch ").append(CRTC.crtR05VSyncEndCurr + 1).append("-").append(CRTC.crtR06VBackEndCurr).append("    Video period ").append(CRTC.crtR06VBackEndCurr + 1).append("-").append(CRTC.crtR07VDispEndCurr).append("    Front porch ").append(CRTC.crtR07VDispEndCurr + 1).append("-").append(CRTC.crtR04VFrontEndCurr)).toString();
    }

    public static void rbpUpdateFrame() {
        rbpStatusLabel.setText(RasterBreakPoint.rbpMakeStatusText());
        rbpCurrentRasterTextField.setText(String.valueOf(CRTC.crtRasterNumber));
        rbpIRQRasterTextField.setText(String.valueOf(CRTC.crtR09IRQRasterCurr));
        rbpTimer = 10;
    }

    public static void rbpSetBreakEnabled(boolean bl) {
        rbpBreakEnabled = bl;
        rbpActiveBreakRaster = rbpBreakEnabled ? rbpBreakRaster : -1;
        CRTC.crtUpdateRasterHash();
    }

    public static void rbpSetBreakRaster(int n) {
        rbpBreakRaster = n;
        rbpActiveBreakRaster = rbpBreakEnabled ? rbpBreakRaster : -1;
        CRTC.crtUpdateRasterHash();
    }

    public static void rbpSetIRQEnabled(boolean bl) {
        rbpIRQBreakEnabled = bl;
    }

    public static void rbpCheckIRQ() {
        int n;
        int n2 = n = CRTC.crtRasterNumber == CRTC.crtR09IRQRasterCurr ? 0 : 64;
        if (n != MC68901.mfpGpipRint) {
            if (n == 0) {
                if (rbpIRQBreakEnabled) {
                    RasterBreakPoint.rbpFire();
                }
                MC68901.mfpRintFall();
            } else {
                MC68901.mfpRintRise();
            }
        }
    }

    public static void rbpFire() {
        if (XEiJ.mpuTask == null) {
            return;
        }
        ++rbpCountValue;
        if ((XEiJ.dbgVisibleMask & 0x20) != 0) {
            RasterBreakPoint.rbpUpdateFrame();
            rbpCountModel.setValue(rbpCountValue);
        }
        if (rbpThresholdValue <= rbpCountValue) {
            if ((XEiJ.dbgVisibleMask & 2) == 0) {
                DisassembleList.ddpOpen(-1, -1, false);
            }
            XEiJ.mpuStop(null);
        }
    }

    public static void rbpTrace() {
        System.out.println("backEnd=" + CRTC.crtR06VBackEndCurr + "," + "dispEnd=" + CRTC.crtR07VDispEndCurr + "," + "frontEnd=" + CRTC.crtR04VFrontEndCurr + "," + "IRQ=" + CRTC.crtR09IRQRasterCurr + "," + "break=" + rbpBreakRaster + "," + "raster=" + CRTC.crtRasterNumber);
    }
}

