/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.TimeZone;
import java.util.TimerTask;
import xeij.DnT;
import xeij.MemoryMappedDevice;
import xeij.XEiJ;

public class RP5C15 {
    public static final boolean RTC_DEBUG_TRACE = false;
    public static final boolean RTC_DEBUG_WRITE = false;
    public static final boolean RTC_DEBUG_GAP = false;
    public static final int RTC_0_SECO0 = 1;
    public static final int RTC_0_SECO1 = 3;
    public static final int RTC_0_MINU0 = 5;
    public static final int RTC_0_MINU1 = 7;
    public static final int RTC_0_HOUR0 = 9;
    public static final int RTC_0_HOUR1 = 11;
    public static final int RTC_0_WDAY = 13;
    public static final int RTC_0_MDAY0 = 15;
    public static final int RTC_0_MDAY1 = 17;
    public static final int RTC_0_MONT0 = 19;
    public static final int RTC_0_MONT1 = 21;
    public static final int RTC_0_YEAR0 = 23;
    public static final int RTC_0_YEAR1 = 25;
    public static final int RTC_1_CLKOUT = 1;
    public static final int RTC_1_ADJUST = 3;
    public static final int RTC_1_MINU0 = 5;
    public static final int RTC_1_MINU1 = 7;
    public static final int RTC_1_HOUR0 = 9;
    public static final int RTC_1_HOUR1 = 11;
    public static final int RTC_1_WDAY = 13;
    public static final int RTC_1_MDAY0 = 15;
    public static final int RTC_1_MDAY1 = 17;
    public static final int RTC_1_RULE = 21;
    public static final int RTC_1_LEAP = 23;
    public static final int RTC_MODE = 27;
    public static final int RTC_TEST = 29;
    public static final int RTC_RESET = 31;
    public static int rtcRule;
    public static int rtcMove;
    public static int rtcAlarm;
    public static int rtcBank;
    public static final byte[] rtcRegBank0;
    public static final byte[] rtcRegBank1;
    public static byte[] rtcRegCurrent;
    public static int rtcTest;
    public static MemoryMappedDevice rtcFirst;
    public static long rtcTestStartCmil;
    public static long rtcTestStartTime;
    public static int rtcWeekGap;
    public static long rtcInitialCmilGap;
    public static long rtcCmilGap;
    public static long rtcCmil;
    public static int rtcCday;
    public static int rtcDsec;
    public static final long[] RTC_TEST_FREQ;
    public static final long[] RTC_TEST_SCALE;
    public static final String[] RTC_REG_NAME;

    public static void rtcInit() {
        rtcRule = 1;
        rtcMove = 8;
        rtcAlarm = 0;
        rtcBank = 0;
        rtcRegCurrent = rtcBank == 0 ? rtcRegBank0 : rtcRegBank1;
        rtcTest = 0;
        rtcFirst = rtcTest == 0 ? MemoryMappedDevice.MMD_RTC_FIRST : MemoryMappedDevice.MMD_RTC_TEST;
        rtcTestStartCmil = 0L;
        rtcTestStartTime = 0L;
        RP5C15.rtcRegBank0[1] = 0;
        RP5C15.rtcRegBank0[3] = 0;
        RP5C15.rtcRegBank0[5] = 0;
        RP5C15.rtcRegBank0[7] = 0;
        RP5C15.rtcRegBank0[9] = 0;
        RP5C15.rtcRegBank0[11] = 0;
        RP5C15.rtcRegBank0[13] = 2;
        RP5C15.rtcRegBank0[15] = 1;
        RP5C15.rtcRegBank0[17] = 0;
        RP5C15.rtcRegBank0[19] = 1;
        RP5C15.rtcRegBank0[21] = 0;
        RP5C15.rtcRegBank0[23] = 0;
        RP5C15.rtcRegBank0[25] = 0;
        RP5C15.rtcRegBank1[1] = 0;
        RP5C15.rtcRegBank1[3] = 0;
        RP5C15.rtcRegBank1[5] = 16;
        RP5C15.rtcRegBank1[7] = 16;
        RP5C15.rtcRegBank1[9] = 16;
        RP5C15.rtcRegBank1[11] = 16;
        RP5C15.rtcRegBank1[13] = 16;
        RP5C15.rtcRegBank1[15] = 16;
        RP5C15.rtcRegBank1[17] = 16;
        RP5C15.rtcRegBank1[21] = (byte)rtcRule;
        RP5C15.rtcRegBank1[23] = 0;
        RP5C15.rtcRegBank1[27] = (byte)(rtcMove + rtcBank);
        RP5C15.rtcRegBank1[29] = (byte)rtcTest;
        RP5C15.rtcRegBank1[31] = 0;
        rtcWeekGap = 4;
        rtcCmilGap = rtcInitialCmilGap = (long)TimeZone.getDefault().getOffset(System.currentTimeMillis());
        rtcCmil = 315532800000L;
        rtcCday = 3652;
        rtcDsec = 0;
    }

    public static void rtcReset() {
    }

    public static void rtcSetByHost() {
        XEiJ.tmrTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (rtcTest != 0) {
                    XEiJ.busSuper(MemoryMappedDevice.MMD_RTC_FIRST, 15245312, 15253504);
                    rtcTest = 0;
                    rtcFirst = MemoryMappedDevice.MMD_RTC_FIRST;
                }
                if (rtcMove == 0) {
                    rtcMove = 8;
                }
                rtcCmilGap = rtcInitialCmilGap;
                RP5C15.rtcUpdate();
            }
        }, 10L);
    }

    public static void rtcTestUpdate() {
        if (rtcMove != 0) {
            RP5C15.rtcSetCmil(rtcTestStartCmil + (XEiJ.mpuClockTime - rtcTestStartTime) / RTC_TEST_FREQ[rtcTest] * RTC_TEST_SCALE[rtcTest]);
        }
    }

    public static void rtcUpdate() {
        if (rtcMove != 0) {
            RP5C15.rtcSetCmil(System.currentTimeMillis() + rtcCmilGap);
        }
    }

    public static void rtcSetCmil(long l) {
        long l2 = DnT.dntFdiv(l - 315532800000L, 3155760000000L) * 3155760000000L;
        if (l2 != 0L) {
            l -= l2;
            rtcCmilGap -= l2;
        }
        if (rtcCmil != l) {
            int n;
            int n2;
            rtcCmil = l;
            int n3 = DnT.dntCdayCmil(l);
            int n4 = DnT.dntDsecCmil(l);
            if (rtcCday != n3) {
                rtcCday = n3;
                n2 = DnT.dntDateCday(n3);
                n = XEiJ.FMT_BCD4[DnT.dntYearDate(n2) - 1980];
                RP5C15.rtcRegBank0[25] = (byte)(n >> 4);
                RP5C15.rtcRegBank0[23] = (byte)(n & 0xF);
                RP5C15.rtcRegBank1[23] = (byte)(n & 3);
                n = XEiJ.FMT_BCD4[DnT.dntMontDate(n2)];
                RP5C15.rtcRegBank0[21] = (byte)(n >> 4);
                RP5C15.rtcRegBank0[19] = (byte)(n & 0xF);
                n = XEiJ.FMT_BCD4[DnT.dntMdayDate(n2)];
                RP5C15.rtcRegBank0[17] = (byte)(n >> 4);
                RP5C15.rtcRegBank0[15] = (byte)(n & 0xF);
                RP5C15.rtcRegBank0[13] = (byte)DnT.dntFrem(n3 + rtcWeekGap, 7);
            }
            if (rtcDsec != n4) {
                rtcDsec = n4;
                n2 = DnT.dntTimeDsec(n4);
                n = DnT.dntHourTime(n2);
                n = XEiJ.FMT_BCD4[rtcRule == 0 && 12 <= n ? n + 8 : n];
                RP5C15.rtcRegBank0[11] = (byte)(n >> 4);
                RP5C15.rtcRegBank0[9] = (byte)(n & 0xF);
                n = XEiJ.FMT_BCD4[DnT.dntMinuTime(n2)];
                RP5C15.rtcRegBank0[7] = (byte)(n >> 4);
                RP5C15.rtcRegBank0[5] = (byte)(n & 0xF);
                n = XEiJ.FMT_BCD4[DnT.dntSecoTime(n2)];
                RP5C15.rtcRegBank0[3] = (byte)(n >> 4);
                RP5C15.rtcRegBank0[1] = (byte)(n & 0xF);
            }
        }
    }

    public static void rtcDumpReg() {
        System.out.printf("  L YY-MM-DD W  R HH:MM:SS\n  %01X %01X%01X-%01X%01X-%01X%01X %01X  %01X %01X%01X:%01X%01X:%01X%01X\n", rtcRegBank1[23], rtcRegBank0[25], rtcRegBank0[23], rtcRegBank0[21], rtcRegBank0[19], rtcRegBank0[17], rtcRegBank0[15], rtcRegBank0[13], rtcRegBank1[21], rtcRegBank0[11], rtcRegBank0[9], rtcRegBank0[7], rtcRegBank0[5], rtcRegBank0[3], rtcRegBank0[1]);
    }

    public static void rtcAddSeco(int n) {
        long l = (long)n * 1000L;
        rtcCmilGap += l;
        rtcCday = DnT.dntCdayCmil(rtcCmil += l);
        rtcDsec = DnT.dntDsecCmil(rtcCmil);
        if (rtcTest != 0) {
            rtcTestStartCmil = rtcCmil;
            rtcTestStartTime = XEiJ.mpuClockTime;
        }
    }

    public static void rtcAddMday(int n) {
        RP5C15.rtcAddSeco(n * 86400);
        rtcWeekGap = DnT.dntFrem(rtcWeekGap - n, 7);
    }

    public static int rtcPeekByte(int n) {
        int n2 = rtcRegCurrent[n & 0x1F] & 0xF;
        return n2;
    }

    public static int rtcReadByte(int n) {
        int n2 = rtcRegCurrent[n & 0x1F] & 0xF;
        return n2;
    }

    public static void rtcWriteByte(int n, int n2) {
        switch (rtcBank << 5 | n & 0x1F) {
            case 1: {
                RP5C15.rtcAddSeco((n2 &= 0xF) - rtcRegBank0[1]);
                RP5C15.rtcRegBank0[1] = (byte)n2;
                return;
            }
            case 3: {
                RP5C15.rtcAddSeco(((n2 &= 7) - rtcRegBank0[3]) * 10);
                RP5C15.rtcRegBank0[3] = (byte)n2;
                return;
            }
            case 5: {
                RP5C15.rtcAddSeco(((n2 &= 0xF) - rtcRegBank0[5]) * 60);
                RP5C15.rtcRegBank0[5] = (byte)n2;
                return;
            }
            case 7: {
                RP5C15.rtcAddSeco(((n2 &= 7) - rtcRegBank0[7]) * 600);
                RP5C15.rtcRegBank0[7] = (byte)n2;
                return;
            }
            case 9: {
                RP5C15.rtcAddSeco(((n2 &= 0xF) - rtcRegBank0[9]) * 3600);
                RP5C15.rtcRegBank0[9] = (byte)n2;
                return;
            }
            case 11: {
                RP5C15.rtcAddSeco((((n2 &= 3) >> 1) - (rtcRegBank0[11] >> 1)) * (rtcRule == 0 ? 43200 : 72000) + ((n2 & 1) - (rtcRegBank0[11] & 1)) * 36000);
                RP5C15.rtcRegBank0[11] = (byte)n2;
                return;
            }
            case 13: {
                int n3 = rtcWeekGap + (n2 &= 7) - rtcRegBank0[13] + 7;
                rtcWeekGap = n3 - (n3 * 19 >>> 7) * 7;
                RP5C15.rtcRegBank0[13] = (byte)n2;
                return;
            }
            case 15: {
                RP5C15.rtcAddMday((n2 &= 0xF) - rtcRegBank0[15]);
                RP5C15.rtcRegBank0[15] = (byte)n2;
                return;
            }
            case 17: {
                RP5C15.rtcAddMday(((n2 &= 3) - rtcRegBank0[17]) * 10);
                RP5C15.rtcRegBank0[17] = (byte)n2;
                return;
            }
            case 19: {
                RP5C15.rtcAddMday(DnT.dntCdayYearMontMday(1980 + rtcRegBank0[25] * 10 + rtcRegBank0[23], rtcRegBank0[21] * 10 + (n2 &= 0xF), rtcRegBank0[17] * 10 + rtcRegBank0[15]) - rtcCday);
                RP5C15.rtcRegBank0[19] = (byte)n2;
                return;
            }
            case 21: {
                RP5C15.rtcAddMday(DnT.dntCdayYearMontMday(1980 + rtcRegBank0[25] * 10 + rtcRegBank0[23], (n2 &= 1) * 10 + rtcRegBank0[19], rtcRegBank0[17] * 10 + rtcRegBank0[15]) - rtcCday);
                RP5C15.rtcRegBank0[21] = (byte)n2;
                return;
            }
            case 23: {
                RP5C15.rtcAddMday(DnT.dntCdayYearMontMday(1980 + rtcRegBank0[25] * 10 + (n2 &= 0xF), rtcRegBank0[21] * 10 + rtcRegBank0[19], rtcRegBank0[17] * 10 + rtcRegBank0[15]) - rtcCday);
                RP5C15.rtcRegBank0[23] = (byte)n2;
                RP5C15.rtcRegBank1[23] = (byte)(rtcRegBank0[25] * 10 + n2 & 3);
                return;
            }
            case 25: {
                RP5C15.rtcAddMday(DnT.dntCdayYearMontMday(1980 + (n2 &= 0xF) * 10 + rtcRegBank0[23], rtcRegBank0[21] * 10 + rtcRegBank0[19], rtcRegBank0[17] * 10 + rtcRegBank0[15]) - rtcCday);
                RP5C15.rtcRegBank0[25] = (byte)n2;
                RP5C15.rtcRegBank1[23] = (byte)(n2 * 10 + rtcRegBank0[23] & 3);
                return;
            }
            case 33: {
                return;
            }
            case 35: {
                return;
            }
            case 53: {
                if (rtcRule != (n2 &= 1)) {
                    RP5C15.rtcAddSeco((rtcRegBank0[11] >> 1) * ((n2 == 0 ? 43200 : 72000) - (rtcRule == 0 ? 43200 : 72000)));
                    RP5C15.rtcRegBank1[21] = (byte)n2;
                    rtcRule = n2;
                }
                return;
            }
            case 55: {
                return;
            }
            case 27: 
            case 59: {
                rtcBank = (n2 &= 0xD) & 1;
                byte[] byArray = rtcRegCurrent = rtcBank == 0 ? rtcRegBank0 : rtcRegBank1;
                if (rtcMove < (n2 & 8)) {
                    if (rtcTest == 0) {
                        rtcCmilGap = rtcCmil - System.currentTimeMillis();
                        rtcCmilGap = rtcCmilGap < 0L ? -((-rtcCmilGap + 500L) / 1000L * 1000L) : (rtcCmilGap + 500L) / 1000L * 1000L;
                    } else {
                        rtcTestStartCmil = rtcCmil;
                        rtcTestStartTime = XEiJ.mpuClockTime;
                    }
                }
                rtcAlarm = n2 & 4;
                rtcMove = n2 & 8;
                RP5C15.rtcRegBank0[27] = RP5C15.rtcRegBank1[27] = (byte)n2;
                return;
            }
            case 29: 
            case 61: {
                if (rtcTest != (n2 &= 0xF)) {
                    if (n2 == 0) {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_RTC_FIRST, 15245312, 15253504);
                        if (rtcMove != 0) {
                            rtcCmilGap = rtcCmil - System.currentTimeMillis();
                            rtcCmilGap = rtcCmilGap < 0L ? -((-rtcCmilGap + 500L) / 1000L * 1000L) : (rtcCmilGap + 500L) / 1000L * 1000L;
                        }
                    } else if (rtcTest == 0) {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_RTC_TEST, 15245312, 15253504);
                        if (rtcMove != 0) {
                            rtcTestStartCmil = rtcCmil;
                            rtcTestStartTime = XEiJ.mpuClockTime;
                        }
                    } else if (rtcMove != 0) {
                        rtcTestStartCmil = rtcCmil;
                        rtcTestStartTime = XEiJ.mpuClockTime;
                    }
                    rtcFirst = (rtcTest = n2) == 0 ? MemoryMappedDevice.MMD_RTC_FIRST : MemoryMappedDevice.MMD_RTC_TEST;
                    RP5C15.rtcRegBank0[29] = RP5C15.rtcRegBank1[29] = (byte)n2;
                }
                return;
            }
        }
    }

    static {
        rtcRegBank0 = new byte[32];
        rtcRegBank1 = new byte[32];
        RTC_TEST_FREQ = new long[]{0L, 61035156L, 61035156L, 1000576L, 61035156L, 706L, 42356L, 705L, 61035156L, 1L, 116L, 1L, 166648L, 1L, 115L, 1L};
        RTC_TEST_SCALE = new long[]{0L, 1000L, 60000L, 1000L, 86400000L, 1000L, 60000L, 1000L, 31557600000L, 1000L, 60000L, 1000L, 86400000L, 1000L, 60000L, 1000L};
        RTC_REG_NAME = "one second,ten seconds,one minute,ten minutes,one hour,ten hours,day of week,one day,ten days,one month,ten months,one year,ten years,mode,test,reset,clkout,adjust,alarm one minute,alarm ten minutes,alarm one hour,alarm ten hours,alarm day of week,alarm one day,alarm ten days,,twenty four,leap year,,mode,test,reset".split(",");
    }
}

