/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import xeij.ComponentFactory;
import xeij.MouseEvent2D;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollCanvas;
import xeij.Settings;
import xeij.VideoController;
import xeij.XEiJ;

public class PaletteViewer {
    public static final boolean PLV_ON = true;
    static final int PLV_CELL_WIDTH = 18;
    static final int PLV_CELL_HEIGHT = 18;
    static final int PLV_GROUP_GAP = 2;
    static final String PLV_FONT_NAME = "Dialog";
    static final int PLV_FONT_STYLE = 1;
    static final int PLV_FONT_SIZE = 16;
    static final int PLV_HEADER_WIDTH = 32;
    static final int PLV_HEADER_HEIGHT = 32;
    static int plvImageWidth;
    static int plvImageHeight;
    static BufferedImage plvBufferedImage;
    static int[] plvBitmap;
    static ScrollCanvas plvCanvas;
    static final int PLV_BACKGROUND_RGB = -13421773;
    static final int PLV_FOREGROUND_RGB = -3355444;
    static int plvCellOffset;
    static int plvColsBit;
    static int plvRowsBit;
    static int plvColsMask;
    static int plvRowsMask;
    static int plvWidth;
    static int plvHeight;
    static final int PLV_DEF_ARRGT = 2;
    static final int PLV_MIN_ARRGT = 0;
    static final int PLV_MAX_ARRGT = 3;
    static int plvArrgtNumber;
    static JComboBox<String> plvArrgtComboBox;
    static int plvArrgtLand;
    static int plvArrgtPort;
    static int plvArrgtCols;
    static int plvArrgtRows;
    static int plvArrgtWidth;
    static int plvArrgtHeight;
    static final int PLV_DEF_SCALE = 0;
    static final int PLV_MIN_SCALE = -1;
    static final int PLV_MAX_SCALE = 4;
    static int plvScaleNumber;
    static JComboBox<String> plvScaleComboBox;
    static final boolean PLV_DEF_HEX = false;
    static boolean plvHex;
    static boolean plvStopped;
    static boolean plvStoppedRequest;
    static final int[] plvCopiedPalTbl;
    static final int[] plvCopiedPal16G8;
    static final int[] plvCopiedPal16TS;
    static final int[] plvCopiedPal8G16L;
    static final int[] plvCopiedPal8G16H;
    static int[] plvPalTbl;
    static int[] plvPal16G8;
    static int[] plvPal16TS;
    static int[] plvPal8G16L;
    static int[] plvPal8G16H;
    static boolean plvG65536On;
    static JTextField plvTextField;
    static boolean plvTextLocked;
    static JFrame plvFrame;
    static JPopupMenu plvPopupMenu;
    static int plvPageToCopy;
    static int plvRowToCopy;
    public static final int PLV_INTERVAL = 10;
    public static int plvTimer;

    public static void plvInit() {
        plvArrgtNumber = Settings.sgsGetInt("plvarrgt", 2, 0, 3);
        plvHex = Settings.sgsGetOnOff("plvhex", false);
        plvScaleNumber = Settings.sgsGetInt("plvscale", 0, -1, 4);
        plvCellOffset = 0;
        plvRowsBit = 4;
        plvColsBit = 4;
        plvColsMask = (1 << plvColsBit) - 1;
        plvRowsMask = (1 << plvRowsBit) - 1;
        plvWidth = 32 + (18 << plvColsBit) + (2 << plvColsBit - 2) - 2;
        plvHeight = 32 + (18 << plvRowsBit) + (2 << plvRowsBit - 2) - 2;
        plvImageWidth = plvWidth * 2;
        plvImageHeight = plvHeight * 2;
        PaletteViewer.plvSetArrgt(plvArrgtNumber);
        PaletteViewer.plvSetStoppedOff();
        plvFrame = null;
        plvTimer = 0;
    }

    public static void plvTini() {
        Settings.sgsPutInt("plvarrgt", plvArrgtNumber);
        Settings.sgsPutOnOff("plvhex", plvHex);
        Settings.sgsPutInt("plvscale", plvScaleNumber);
    }

    static void plvSetArrgt(int n) {
        plvArrgtNumber = n;
        plvArrgtLand = plvArrgtNumber == 2 ? 2 : 1;
        plvArrgtPort = plvArrgtNumber == 3 ? 2 : 1;
        plvArrgtCols = plvArrgtLand << plvColsBit;
        plvArrgtRows = plvArrgtPort << plvRowsBit;
        plvArrgtWidth = plvWidth * plvArrgtLand;
        plvArrgtHeight = plvHeight * plvArrgtPort;
        if (plvCanvas != null) {
            PaletteViewer.plvDrawHeader();
            plvCanvas.setImage(plvArrgtWidth, plvArrgtHeight);
        }
    }

    static int plvColToX(int n) {
        int n2 = n >> plvColsBit;
        int n3 = (n &= plvColsMask) >> 2;
        return plvWidth * n2 + 32 + 74 * n3 + 18 * (n &= 3);
    }

    static int plvRowToY(int n) {
        int n2 = n >> plvRowsBit;
        int n3 = (n &= plvRowsMask) >> 2;
        return plvHeight * n2 + 32 + 74 * n3 + 18 * (n &= 3);
    }

    static int plvXToXCol(int n) {
        int n2;
        int n3;
        if (n < 0 || plvArrgtWidth <= n) {
            return -1;
        }
        if ((n -= plvWidth * (n3 = n / plvWidth)) < 32) {
            return -1;
        }
        n -= 32;
        if (72 <= (n -= 74 * (n2 = n / 74))) {
            return -1;
        }
        int n4 = n / 18;
        return (n -= 18 * n4) << 16 | (n3 << plvColsBit) + (n2 << 2) + n4;
    }

    static int plvYToYRow(int n) {
        int n2;
        int n3;
        if (n < 0 || plvArrgtHeight <= n) {
            return -1;
        }
        if ((n -= plvHeight * (n3 = n / plvHeight)) < 32) {
            return -1;
        }
        n -= 32;
        if (72 <= (n -= 74 * (n2 = n / 74))) {
            return -1;
        }
        int n4 = n / 18;
        return (n -= 18 * n4) << 16 | (n3 << plvRowsBit) + (n2 << 2) + n4;
    }

    public static void plvStart() {
        if (RestorableFrame.rfmGetOpened("plv")) {
            PaletteViewer.plvOpen();
        }
    }

    public static void plvOpen() {
        if (plvFrame == null) {
            PaletteViewer.plvMakeFrame();
        } else {
            PaletteViewer.plvUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x1000;
        XEiJ.pnlExitFullScreen(false);
        plvFrame.setVisible(true);
    }

    static void plvMakeFrame() {
        plvBufferedImage = new BufferedImage(plvImageWidth, plvImageHeight, 2);
        PaletteViewer.plvDrawHeader();
        plvBitmap = ((DataBufferInt)plvBufferedImage.getRaster().getDataBuffer()).getData();
        plvCanvas = new ScrollCanvas(plvBufferedImage, plvArrgtWidth, plvArrgtHeight);
        plvCanvas.setMatColor(new Color(-13421773));
        plvCanvas.setMinScaleShift(-1);
        plvCanvas.setMaxScaleShift(4);
        plvCanvas.setScaleShift(plvScaleNumber);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Arrgt": {
                        PaletteViewer.plvSetArrgt(plvArrgtComboBox.getSelectedIndex() + 0);
                        if (XEiJ.mpuTask != null) break;
                        PaletteViewer.plvUpdateFrame();
                        break;
                    }
                    case "Scale": {
                        plvScaleNumber = plvScaleComboBox.getSelectedIndex() + -1;
                        plvCanvas.setScaleShift(plvScaleNumber);
                        break;
                    }
                    case "Hex": {
                        plvHex = ((JCheckBox)object).isSelected();
                        PaletteViewer.plvDrawHeader();
                        PaletteViewer.plvUpdateFrame();
                        break;
                    }
                    case "Stop": {
                        plvStoppedRequest = ((JCheckBox)object).isSelected();
                        if (XEiJ.mpuTask != null) break;
                        PaletteViewer.plvUpdateFrame();
                        break;
                    }
                    case "Copy as hexadecimal": {
                        if (0 > plvPageToCopy) break;
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i <= plvColsMask; ++i) {
                            if (i != 0) {
                                stringBuilder.append(' ');
                            }
                            int n = i + (plvRowToCopy << plvColsBit);
                            int n2 = (plvPageToCopy == 0 ? plvPal16G8 : plvPal16TS)[n];
                            stringBuilder.append(String.format("%04X", n2));
                        }
                        XEiJ.clpCopy(stringBuilder.toString());
                        plvPageToCopy = -1;
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        plvTextField = new JTextField();
        plvTextField.setEditable(false);
        plvTextField.setHorizontalAlignment(0);
        JComponent[] jComponentArray = new JComponent[2];
        jComponentArray[0] = plvCanvas;
        Component[] componentArray = new Component[2];
        Component[] componentArray2 = new Component[8];
        componentArray2[0] = Box.createHorizontalGlue();
        componentArray2[1] = Multilingual.mlnText(ComponentFactory.createLabel("Arrgt"), "ja", "\u914d\u7f6e");
        plvArrgtComboBox = ComponentFactory.createComboBox(plvArrgtNumber - 0, "Arrgt", actionListener, "G", "TS", "H", "V");
        componentArray2[2] = plvArrgtComboBox;
        componentArray2[3] = Multilingual.mlnText(ComponentFactory.createLabel("Scale"), "ja", "\u500d\u7387");
        plvScaleComboBox = ComponentFactory.createComboBox(plvScaleNumber - -1, "Scale", actionListener, "1/2", "1", "2", "4", "8", "16");
        componentArray2[4] = plvScaleComboBox;
        componentArray2[5] = Box.createHorizontalStrut(5);
        componentArray2[6] = ComponentFactory.createCheckBox(plvHex, "Hex", actionListener);
        componentArray2[7] = Box.createHorizontalGlue();
        componentArray[0] = ComponentFactory.createHorizontalBox(componentArray2);
        componentArray[1] = ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), plvTextField, Box.createHorizontalStrut(5), Multilingual.mlnText(ComponentFactory.createCheckBox(plvStoppedRequest, "Stop", actionListener), "ja", "\u505c\u6b62"), Box.createHorizontalGlue());
        jComponentArray[1] = ComponentFactory.createVerticalBox(componentArray);
        plvFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("plv", "Palette Viewer", null, ComponentFactory.createBorderPanel(0, 0, jComponentArray)), "ja", "\u30d1\u30ec\u30c3\u30c8\u30d3\u30e5\u30a2");
        plvCanvas.addScaleShiftListener(new ScrollCanvas.ScaleShiftListener(){

            @Override
            public void scaleShiftChanged(int n) {
                plvScaleNumber = n;
                plvScaleComboBox.setSelectedIndex(plvScaleNumber - -1);
            }
        });
        ComponentFactory.addListener(plvFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFEFFF;
            }
        });
        plvPopupMenu = ComponentFactory.createPopupMenu(Multilingual.mlnText(ComponentFactory.createMenuItem("Copy as hexadecimal", 67, actionListener), "ja", "16\u9032\u6570\u3067\u30b3\u30d4\u30fc"));
        plvPageToCopy = -1;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                plvTextLocked = !plvTextLocked;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!plvTextLocked) {
                    int n;
                    MouseEvent2D mouseEvent2D = (MouseEvent2D)mouseEvent;
                    int n2 = (int)mouseEvent2D.getX2D();
                    String string = PaletteViewer.plvGetPixel(n2, n = (int)mouseEvent2D.getY2D());
                    plvTextField.setText(string == null ? "" : string);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PaletteViewer.plvShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PaletteViewer.plvShowPopup(mouseEvent);
            }
        };
        plvCanvas.addMouseListener(mouseAdapter);
        plvCanvas.addMouseMotionListener(mouseAdapter);
    }

    static void plvShowPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        MouseEvent2D mouseEvent2D = (MouseEvent2D)mouseEvent;
        int n = (int)mouseEvent2D.getX2D();
        int n2 = (int)mouseEvent2D.getY2D();
        int n3 = PaletteViewer.plvXToXCol(n);
        int n4 = PaletteViewer.plvYToYRow(n2);
        if (n3 < 0 || n4 < 0) {
            return;
        }
        n3 = (char)n3;
        n4 = (char)n4;
        plvPageToCopy = n3 <= plvColsMask && n4 <= plvRowsMask && plvArrgtNumber != 1 ? 0 : 1;
        plvRowToCopy = n4 & plvRowsMask;
        Point point = plvCanvas.getPopupPoint(mouseEvent2D);
        plvPopupMenu.show(plvCanvas, point.x, point.y);
    }

    static void plvDrawHeader() {
        int n;
        int n2;
        Graphics2D graphics2D = plvBufferedImage.createGraphics();
        graphics2D.setColor(new Color(-13421773));
        graphics2D.fillRect(0, 0, plvArrgtWidth, plvArrgtHeight);
        graphics2D.setColor(new Color(-3355444));
        graphics2D.setFont(new Font(PLV_FONT_NAME, 1, 16));
        if (plvArrgtNumber != 1) {
            PaletteViewer.plvDrawString(graphics2D, (32 + plvWidth) / 2, PaletteViewer.plvRowToY(0) - 17, "Graphic Palette", 5);
        }
        if (plvArrgtNumber != 0) {
            PaletteViewer.plvDrawString(graphics2D, plvArrgtWidth - plvWidth + (32 + plvWidth) / 2, plvArrgtHeight - plvHeight + PaletteViewer.plvRowToY(0) - 17, "Text and Sprite Palette", 5);
        }
        for (n2 = 0; n2 < plvArrgtRows; n2 += plvRowsMask + 1) {
            for (n = 0; n < plvArrgtCols; ++n) {
                PaletteViewer.plvDrawString(graphics2D, PaletteViewer.plvColToX(n) + 9, PaletteViewer.plvRowToY(n2) - 1, String.format(plvHex ? "%X" : "%d", n & plvColsMask), 5);
            }
        }
        for (n2 = 0; n2 < plvArrgtCols; n2 += plvColsMask + 1) {
            for (n = 0; n < plvArrgtRows; ++n) {
                PaletteViewer.plvDrawString(graphics2D, PaletteViewer.plvColToX(n2) - 2, PaletteViewer.plvRowToY(n) + 9, String.format(plvHex ? "%X" : "%d", plvCellOffset + ((n & plvRowsMask) << plvColsBit)), 3);
            }
        }
    }

    static void plvDrawString(Graphics2D graphics2D, int n, int n2, String string, int n3) {
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n4 = (int)Math.round(rectangle2D.getX());
        int n5 = (int)Math.round(rectangle2D.getY());
        int n6 = (int)Math.round(rectangle2D.getWidth());
        int n7 = (int)Math.round(rectangle2D.getHeight());
        switch (n3) {
            case 8: {
                graphics2D.drawString(string, n - n4, n2 - n5);
                break;
            }
            case 1: {
                graphics2D.drawString(string, n - (n4 + (n6 >> 1)), n2 - n5);
                break;
            }
            case 2: {
                graphics2D.drawString(string, n - (n4 + n6), n2 - n5);
                break;
            }
            case 7: {
                graphics2D.drawString(string, n - n4, n2 - (n5 + (n7 >> 1)));
                break;
            }
            case 0: {
                graphics2D.drawString(string, n - (n4 + (n6 >> 1)), n2 - (n5 + (n7 >> 1)));
                break;
            }
            case 3: {
                graphics2D.drawString(string, n - (n4 + n6), n2 - (n5 + (n7 >> 1)));
                break;
            }
            case 6: {
                graphics2D.drawString(string, n - n4, n2 - (n5 + n7));
                break;
            }
            case 5: {
                graphics2D.drawString(string, n - (n4 + (n6 >> 1)), n2 - (n5 + n7));
                break;
            }
            case 4: {
                graphics2D.drawString(string, n - (n4 + n6), n2 - (n5 + n7));
            }
        }
    }

    static String plvGetPixel(int n, int n2) {
        int n3 = PaletteViewer.plvXToXCol(n);
        int n4 = PaletteViewer.plvYToYRow(n2);
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        n = n3 >> 16;
        n2 = n4 >> 16;
        n3 = (char)n3;
        n4 = (char)n4;
        int n5 = (n3 & plvColsMask) + ((n4 & plvRowsMask) << plvColsBit);
        if (n3 <= plvColsMask && n4 <= plvRowsMask && plvArrgtNumber != 1) {
            if (plvG65536On) {
                int n6;
                if (n == 0 || n == 17 || n2 == 0 || n2 == 17 || n == 8 || n == 9) {
                    return null;
                }
                int n7 = n6 = n < 9 ? 0 : 1;
                if ((n5 & 1) == 0) {
                    int n8 = plvPal8G16L[n5 += n6];
                    return String.format("G p=0x??%02X c=0x??%02X(%d,%d,%d,%d)", n5, n8, n8 >> 11, n8 >> 6 & 0x1F, n8 >> 1 & 0x1F, n8 & 1);
                }
                n5 = (n5 & 0xFFFFFFFE) + n6;
                int n9 = plvPal8G16H[n5];
                return String.format("G p=0x%02X?? c=0x%02X??(%d,%d,%d,%d)", n5, n9 >> 8, n9 >> 11, n9 >> 6 & 0x1F, n9 >> 1 & 0x1F, n9 & 1);
            }
            if (n == 0 || n == 17 || n2 == 0 || n2 == 17) {
                return null;
            }
            int n10 = plvPal16G8[n5];
            return String.format("G p=0x%02X c=0x%04X(%d,%d,%d,%d)", n5, n10, n10 >> 11, n10 >> 6 & 0x1F, n10 >> 1 & 0x1F, n10 & 1);
        }
        if (n == 0 || n == 17 || n2 == 0 || n2 == 17) {
            return null;
        }
        int n11 = plvPal16TS[n5];
        return String.format("TS p=0x%02X c=0x%04X(%d,%d,%d,%d)", n5, n11, n11 >> 11, n11 >> 6 & 0x1F, n11 >> 1 & 0x1F, n11 & 1);
    }

    static void plvUpdateFrame() {
        if (plvFrame == null) {
            return;
        }
        if (plvStopped != plvStoppedRequest) {
            if (plvStoppedRequest) {
                PaletteViewer.plvSetStoppedOn();
            } else {
                PaletteViewer.plvSetStoppedOff();
            }
        }
        if (!plvStopped) {
            plvG65536On = (VideoController.vcnReg1Port & 2) != 0 && (VideoController.vcnReg3Port & 0xF) != 0;
        }
        for (int i = 0; i < plvArrgtRows; ++i) {
            int n = PaletteViewer.plvRowToY(i) + 1;
            for (int j = 0; j < plvArrgtCols; ++j) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6 = PaletteViewer.plvColToX(j) + 1;
                int n7 = n6 + plvImageWidth * n;
                int n8 = (j & plvColsMask) + ((i & plvRowsMask) << plvColsBit);
                if (j <= plvColsMask && i <= plvRowsMask && plvArrgtNumber != 1) {
                    if (plvG65536On) {
                        for (n5 = 0; n5 < 16; ++n5) {
                            PaletteViewer.plvBitmap[n7 + 9 - 2] = -13421773;
                            PaletteViewer.plvBitmap[n7 + 9 - 1] = -13421773;
                            n7 += plvImageWidth;
                        }
                        n7 += -plvImageWidth * 16;
                        for (n5 = 0; n5 < 2; ++n5) {
                            n4 = ((n8 & 1) == 0 ? plvPal8G16L : plvPal8G16H)[(n8 & 0xFFFFFFFE) + n5];
                            n3 = plvPalTbl[n4];
                            for (n2 = 0; n2 < 16; ++n2) {
                                for (int k = 0; k < 7; ++k) {
                                    PaletteViewer.plvBitmap[n7 + k] = n3;
                                }
                                n7 += plvImageWidth;
                            }
                            n7 += 9 - plvImageWidth * 16;
                        }
                        continue;
                    }
                    n5 = plvPal16G8[n8];
                    n4 = plvPalTbl[n5];
                    for (n3 = 0; n3 < 16; ++n3) {
                        for (n2 = 0; n2 < 16; ++n2) {
                            PaletteViewer.plvBitmap[n7 + n2] = n4;
                        }
                        n7 += plvImageWidth;
                    }
                    continue;
                }
                n5 = plvPal16TS[n8];
                n4 = plvPalTbl[n5];
                for (n3 = 0; n3 < 16; ++n3) {
                    for (n2 = 0; n2 < 16; ++n2) {
                        PaletteViewer.plvBitmap[n7 + n2] = n4;
                    }
                    n7 += plvImageWidth;
                }
            }
        }
        plvCanvas.repaint();
    }

    static void plvSetStoppedOn() {
        plvStopped = true;
        plvStoppedRequest = true;
        System.arraycopy(VideoController.vcnPalBase[45], 0, plvCopiedPalTbl, 0, 65536);
        System.arraycopy(VideoController.vcnPal16G8, 0, plvCopiedPal16G8, 0, 256);
        System.arraycopy(VideoController.vcnPal16TSPort, 0, plvCopiedPal16TS, 0, 256);
        System.arraycopy(VideoController.vcnPal8G16L, 0, plvCopiedPal8G16L, 0, 256);
        System.arraycopy(VideoController.vcnPal8G16H, 0, plvCopiedPal8G16H, 0, 256);
        plvPalTbl = plvCopiedPalTbl;
        plvPal16G8 = plvCopiedPal16G8;
        plvPal16TS = plvCopiedPal16TS;
        plvPal8G16L = plvCopiedPal8G16L;
        plvPal8G16H = plvCopiedPal8G16H;
    }

    static void plvSetStoppedOff() {
        plvStopped = false;
        plvPalTbl = VideoController.vcnPalBase[45];
        plvPal16G8 = VideoController.vcnPal16G8;
        plvPal16TS = VideoController.vcnPal16TSPort;
        plvPal8G16L = VideoController.vcnPal8G16L;
        plvPal8G16H = VideoController.vcnPal8G16H;
    }

    static {
        plvCopiedPalTbl = new int[65536];
        plvCopiedPal16G8 = new int[256];
        plvCopiedPal16TS = new int[256];
        plvCopiedPal8G16L = new int[256];
        plvCopiedPal8G16H = new int[256];
    }
}

