/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.filechooser.FileFilter;
import xeij.ComponentFactory;
import xeij.FontPage;
import xeij.JFileChooser2;
import xeij.LnF;
import xeij.MMLCompiler;
import xeij.MouseEvent2D;
import xeij.Multilingual;
import xeij.OPM;
import xeij.RestorableFrame;
import xeij.ScrollCanvas;
import xeij.ScrollTextArea;
import xeij.XEiJ;
import xeij.YM2151;

public class OPMLog {
    public static final boolean OLG_ON = true;
    public static final double LOG2_358_400 = -0.16004041251046827;
    public static final int OLG_BUFFER_SIZE = 0x100000;
    public static final long OLG_UNIT = 1000000L;
    public static final int[] olgBuffer = new int[0x100000];
    public static final int OLG_LIMIT_S = 900;
    public static boolean olgRecording;
    public static int olgLength;
    public static long olgStartTimePS;
    public static int olgCounter;
    public static final int[] OLG_US_PER_PX;
    public static final int OLG_RANGE_COUNT;
    public static int olgRangeIndex;
    public static int olgUsPerPx;
    public static int olgRangeUs;
    public static int olgStartUs;
    public static int olgEndUs;
    public static final boolean[] olgChannelMask;
    public static int olgCaretPx;
    public static int olgCaretUs;
    public static int olgMaskLeftUs;
    public static int olgMaskRightUs;
    public static Timer olgTimer;
    public static TimerTask olgForcedTerminationTask;
    public static File olgLastMMLFile;
    public static FileFilter olgMMLFilter;
    public static File olgLastFile;
    public static FileFilter olgFilter;
    public static BasicStroke olgSolidStroke;
    public static BasicStroke olgDashStroke;
    public static BasicStroke olgWaveStroke;
    public static TexturePaint olgMaskPaint;
    public static final int OLG_SCORE_WIDTH = 1200;
    public static final int OLG_SCORE_HEIGHT = 388;
    public static final int OLG_SCORE_H_MARGIN = 10;
    public static final int OLG_SCORE_V_MARGIN = 6;
    public static final int OLG_SCORE_IMAGE_WIDTH = 1220;
    public static final int OLG_WAVE_RADIUS = 48;
    public static final int OLG_WAVE_Y1 = 394;
    public static final int OLG_WAVE_Y0 = 442;
    public static final int OLG_WAVE_YM1 = 490;
    public static final int OLG_SCORE_IMAGE_HEIGHT = 496;
    public static final int OLG_KON1ST_HEIGHT = 9;
    public static final int OLG_KON2ND_HEIGHT = 7;
    public static final int OLG_BAR_HEIGHT = 3;
    public static final Color[] OLG_KON_COLOR;
    public static final Color[] OLG_BAR_COLOR;
    public static BufferedImage olgCanvasImage;
    public static int[] olgCanvasBitmap;
    public static ScrollCanvas olgCanvas;
    public static int olgScaleShift;
    public static final char[] OLG_TONE_BASE;
    public static final int OLG_TONE_CHAR_WIDTH = 6;
    public static final int OLG_TONE_LINE_HEIGHT = 10;
    public static final int OLG_TONE_COLS = 35;
    public static final int OLG_TONE_ROWS = 9;
    public static final int OLG_TONE_H_SPACE = 6;
    public static final int OLG_TONE_V_SPACE = 10;
    public static final int OLG_TONE_WIDTH = 858;
    public static final int OLG_TONE_HEIGHT = 190;
    public static final int OLG_TONE_H_MARGIN = 6;
    public static final int OLG_TONE_V_MARGIN = 10;
    public static final int OLG_TONE_IMAGE_WIDTH = 870;
    public static final int OLG_TONE_IMAGE_HEIGHT = 210;
    public static BufferedImage olgToneImage;
    public static int[] olgToneBitmap;
    public static JPanel olgTonePanel;
    public static final int OLG_DUMP_TEXT_AREA_WIDTH = 340;
    public static final int OLG_DUMP_TEXT_AREA_HEIGHT = 180;
    public static ScrollTextArea olgDumpTextArea;
    public static JRadioButtonMenuItem[] olgScaleMenuItem;
    public static JFrame olgFrame;
    public static JButton olgStartButton;
    public static JButton olgEndButton;
    public static JButton olgPlusButton;
    public static JButton olgMinusButton;
    public static final int OPM_CHANNELS = 2;
    public static YM2151 olgYM2151;
    public static int[] opmBuffer;
    private static final int[] addressToData;
    private static final int[] addressToUs;
    private static final int[] channelToKindex;
    private static final int[] channelToKonUs;
    private static final int[] caretAddressToData;
    private static final int[] caretAddressToUs;
    private static final int[] lastCaretAddressToUs;
    private static final boolean[] strong;
    private static final int[] TONE_MAP;
    private static final int VOLUME = 1024;
    private static int samples62500;
    private static int samples48000;
    private static byte[] sampleBuffer;
    private static SourceDataLine sourceDataLine;
    private static int totalBytes;
    private static volatile int writtenBytes;
    private static volatile TimerTask playTask;

    public static int olgPxToUs(int n) {
        return olgStartUs + olgUsPerPx * n;
    }

    public static int olgUsToPx(int n) {
        return (n - olgStartUs) / olgUsPerPx;
    }

    public static void olgInit() {
        olgRecording = false;
        OPMLog.olgBuffer[0] = 0;
        OPMLog.olgBuffer[1] = -1;
        olgLength = 2;
        olgStartTimePS = 0L;
        olgCounter = 0;
        olgRangeIndex = OLG_RANGE_COUNT - 1;
        olgUsPerPx = OLG_US_PER_PX[olgRangeIndex];
        olgRangeUs = olgUsPerPx * 1200;
        olgStartUs = 0;
        olgEndUs = olgRangeUs;
        Arrays.fill(olgChannelMask, true);
        olgCaretPx = 0;
        olgCaretUs = 0;
        olgMaskLeftUs = -1;
        olgMaskRightUs = -1;
        olgTimer = new Timer();
        olgForcedTerminationTask = null;
        olgLastFile = new File(System.getProperty("user.dir") + File.separator + "opmlog.dat");
        olgFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                String string2 = string.toLowerCase();
                return file.isDirectory() || file.isFile() && string2.endsWith(".dat");
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb (*.dat)" : "Data files (*.dat)";
            }
        };
        olgLastMMLFile = new File(System.getProperty("user.dir") + File.separator + "a.opm");
        olgMMLFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                String string2 = string.toLowerCase();
                return file.isDirectory() || file.isFile() && (string2.endsWith(".opm") || string2.endsWith(".zms"));
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "MML \u30d5\u30a1\u30a4\u30eb (*.opm *.zms)" : "MML files (*.opm *.zms)";
            }
        };
        olgYM2151 = new YM2151();
        opmBuffer = null;
        olgYM2151.setListener(new YM2151.Listener(){

            @Override
            public void timerA(int n) {
            }

            @Override
            public void timerB(int n) {
            }

            @Override
            public void busy(int n) {
            }

            @Override
            public boolean isBusy() {
                return false;
            }

            @Override
            public void irq(boolean bl) {
            }

            @Override
            public void control(int n) {
            }

            @Override
            public void written(int n, int n2, int n3) {
            }
        });
        olgYM2151.reset();
    }

    public static void olgTini() {
        olgTimer.cancel();
    }

    public static void olgStart() {
        if (RestorableFrame.rfmGetOpened("olg")) {
            OPMLog.olgOpen();
        }
    }

    public static void olgOpen() {
        if (olgFrame == null) {
            OPMLog.olgMakeFrame();
        }
        XEiJ.pnlExitFullScreen(false);
        olgFrame.setVisible(true);
    }

    public static void olgMakeFrame() {
        olgSolidStroke = new BasicStroke(1.0f, 0, 0, 10.0f);
        olgDashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);
        olgWaveStroke = new BasicStroke(1.0f, 1, 1, 10.0f);
        Object object = new BufferedImage(4, 4, 2);
        Object object2 = ((DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer()).getData();
        Arrays.fill(object2, 0);
        object2[3] = -2139062144;
        object2[6] = -2139062144;
        object2[9] = -2139062144;
        object2[12] = -2139062144;
        olgMaskPaint = new TexturePaint((BufferedImage)object, new Rectangle2D.Float(0.0f, 0.0f, 4.0f, 4.0f));
        olgCanvasImage = new BufferedImage(1220, 496, 1);
        olgCanvasBitmap = ((DataBufferInt)olgCanvasImage.getRaster().getDataBuffer()).getData();
        olgCanvas = new ScrollCanvas(olgCanvasImage);
        olgCanvas.setMargin(10, 10);
        olgCanvas.setMatColor(new Color(LnF.lnfRGB[4]));
        olgScaleShift = 0;
        ComponentFactory.setPreferredSize(olgCanvas, 1270, 556);
        object = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Load MML": {
                        OPMLog.olgLoadMML();
                        break;
                    }
                    case "Load Log": {
                        OPMLog.olgLoadLog();
                        break;
                    }
                    case "Save Log": {
                        OPMLog.olgSaveLog();
                        break;
                    }
                    case "Quit": {
                        olgFrame.setVisible(false);
                        break;
                    }
                    case "Adjust": {
                        OPMLog.olgAdjust();
                        break;
                    }
                    case "6.25%": {
                        if (olgScaleShift == -4) break;
                        olgCanvas.setScaleShift(-4);
                        break;
                    }
                    case "12.5%": {
                        if (olgScaleShift == -3) break;
                        olgCanvas.setScaleShift(-3);
                        break;
                    }
                    case "25%": {
                        if (olgScaleShift == -2) break;
                        olgCanvas.setScaleShift(-2);
                        break;
                    }
                    case "50%": {
                        if (olgScaleShift == -1) break;
                        olgCanvas.setScaleShift(-1);
                        break;
                    }
                    case "100%": {
                        if (olgScaleShift == 0) break;
                        olgCanvas.setScaleShift(0);
                        break;
                    }
                    case "200%": {
                        if (olgScaleShift == 1) break;
                        olgCanvas.setScaleShift(1);
                        break;
                    }
                    case "400%": {
                        if (olgScaleShift == 2) break;
                        olgCanvas.setScaleShift(2);
                        break;
                    }
                    case "800%": {
                        if (olgScaleShift == 3) break;
                        olgCanvas.setScaleShift(3);
                        break;
                    }
                    case "1600%": {
                        if (olgScaleShift == 4) break;
                        olgCanvas.setScaleShift(4);
                        break;
                    }
                    case "\u25cf": {
                        OPMLog.olgRecordStart();
                        break;
                    }
                    case "\u25a0": {
                        OPMLog.olgRecordEnd();
                        break;
                    }
                    case "\uff0b": {
                        olgRangeIndex = Math.max(0, olgRangeIndex - 1);
                        ComponentFactory.setEnabled(olgPlusButton, 0 < olgRangeIndex);
                        ComponentFactory.setEnabled(olgMinusButton, olgRangeIndex < OLG_RANGE_COUNT - 1);
                        olgUsPerPx = OLG_US_PER_PX[olgRangeIndex];
                        olgRangeUs = olgUsPerPx * 1200;
                        olgCaretUs = olgCaretUs / olgUsPerPx * olgUsPerPx;
                        olgStartUs = Math.max(0, olgCaretUs - olgUsPerPx * olgCaretPx);
                        olgCaretPx = (olgCaretUs - olgStartUs) / olgUsPerPx;
                        olgEndUs = olgStartUs + olgRangeUs;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "\uff0d": {
                        olgRangeIndex = Math.min(OLG_RANGE_COUNT - 1, olgRangeIndex + 1);
                        ComponentFactory.setEnabled(olgPlusButton, 0 < olgRangeIndex);
                        ComponentFactory.setEnabled(olgMinusButton, olgRangeIndex < OLG_RANGE_COUNT - 1);
                        olgUsPerPx = OLG_US_PER_PX[olgRangeIndex];
                        olgRangeUs = olgUsPerPx * 1200;
                        olgCaretUs = olgCaretUs / olgUsPerPx * olgUsPerPx;
                        olgStartUs = Math.max(0, olgCaretUs - olgUsPerPx * olgCaretPx);
                        olgCaretPx = (olgCaretUs - olgStartUs) / olgUsPerPx;
                        olgEndUs = olgStartUs + olgRangeUs;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "\u4e28\uff1c": {
                        olgCaretUs = 0;
                        olgStartUs = 0;
                        olgCaretPx = 0;
                        olgEndUs = olgStartUs + olgRangeUs;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "\u226a\u226a": {
                        OPMLog.olgMoveCaret(-400);
                        break;
                    }
                    case "\u226a": {
                        OPMLog.olgMoveCaret(-20);
                        break;
                    }
                    case "\uff1c": {
                        OPMLog.olgMoveCaret(-1);
                        break;
                    }
                    case "\uff1e": {
                        OPMLog.olgMoveCaret(1);
                        break;
                    }
                    case "\u226b": {
                        OPMLog.olgMoveCaret(20);
                        break;
                    }
                    case "\u226b\u226b": {
                        OPMLog.olgMoveCaret(400);
                        break;
                    }
                    case "\uff1e\u4e28": {
                        olgCaretUs = Math.max(0, olgBuffer[olgLength - 2] - 1) / olgUsPerPx * olgUsPerPx;
                        olgStartUs = Math.max(0, olgCaretUs - olgUsPerPx * olgCaretPx);
                        olgCaretPx = (olgCaretUs - olgStartUs) / olgUsPerPx;
                        olgEndUs = olgStartUs + olgRangeUs;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "0": {
                        OPMLog.olgChannelMask[0] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "1": {
                        OPMLog.olgChannelMask[1] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "2": {
                        OPMLog.olgChannelMask[2] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "3": {
                        OPMLog.olgChannelMask[3] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "4": {
                        OPMLog.olgChannelMask[4] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "5": {
                        OPMLog.olgChannelMask[5] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "6": {
                        OPMLog.olgChannelMask[6] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "7": {
                        OPMLog.olgChannelMask[7] = ((JCheckBox)object).isSelected();
                        OPMLog.olgMakeWaveData();
                        OPMLog.olgPaint();
                        break;
                    }
                    case "From": {
                        if (olgMaskRightUs != -1 && olgCaretUs >= olgMaskRightUs) break;
                        olgMaskLeftUs = olgCaretUs;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "To": {
                        if (olgMaskLeftUs != -1 && olgMaskLeftUs >= olgCaretUs) break;
                        olgMaskRightUs = olgCaretUs;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "All": {
                        olgMaskLeftUs = -1;
                        olgMaskRightUs = -1;
                        OPMLog.olgPaint();
                        break;
                    }
                    case "\u25b7": {
                        OPMLog.olgPlayStart();
                        break;
                    }
                    case "\u25a1": {
                        OPMLog.olgPlayEnd();
                    }
                }
            }
        };
        object2 = new ButtonGroup();
        olgScaleMenuItem = new JRadioButtonMenuItem[9];
        Component[] componentArray = new Component[3];
        componentArray[0] = Multilingual.mlnText(ComponentFactory.createMenu("File", 70, Multilingual.mlnText(ComponentFactory.createMenuItem("Load MML", 77, (ActionListener)object), "ja", "\u30ed\u30fc\u30c9 MML"), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createMenuItem("Load Log", 76, (ActionListener)object), "ja", "\u30ed\u30fc\u30c9 \u30ed\u30b0"), Multilingual.mlnText(ComponentFactory.createMenuItem("Save Log", 83, (ActionListener)object), "ja", "\u30bb\u30fc\u30d6 \u30ed\u30b0"), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createMenuItem("Quit", 81, (ActionListener)object), "ja", "\u7d42\u4e86")), "ja", "\u30d5\u30a1\u30a4\u30eb");
        componentArray[1] = Multilingual.mlnText(ComponentFactory.createMenu("Edit", 69, Multilingual.mlnText(ComponentFactory.createMenuItem("Adjust", 65, (ActionListener)object), "ja", "\u30a2\u30b8\u30e3\u30b9\u30c8")), "ja", "\u7de8\u96c6");
        JComponent[] jComponentArray = new JComponent[9];
        OPMLog.olgScaleMenuItem[0] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == -4, "6.25%", 49, (ActionListener)object);
        jComponentArray[0] = OPMLog.olgScaleMenuItem[0];
        OPMLog.olgScaleMenuItem[1] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == -3, "12.5%", 50, (ActionListener)object);
        jComponentArray[1] = OPMLog.olgScaleMenuItem[1];
        OPMLog.olgScaleMenuItem[2] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == -2, "25%", 51, (ActionListener)object);
        jComponentArray[2] = OPMLog.olgScaleMenuItem[2];
        OPMLog.olgScaleMenuItem[3] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == -1, "50%", 52, (ActionListener)object);
        jComponentArray[3] = OPMLog.olgScaleMenuItem[3];
        OPMLog.olgScaleMenuItem[4] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == 0, "100%", 53, (ActionListener)object);
        jComponentArray[4] = OPMLog.olgScaleMenuItem[4];
        OPMLog.olgScaleMenuItem[5] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == 1, "200%", 54, (ActionListener)object);
        jComponentArray[5] = OPMLog.olgScaleMenuItem[5];
        OPMLog.olgScaleMenuItem[6] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == 2, "400%", 55, (ActionListener)object);
        jComponentArray[6] = OPMLog.olgScaleMenuItem[6];
        OPMLog.olgScaleMenuItem[7] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == 3, "800%", 56, (ActionListener)object);
        jComponentArray[7] = OPMLog.olgScaleMenuItem[7];
        OPMLog.olgScaleMenuItem[8] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object2, olgScaleShift == 4, "1600%", 57, (ActionListener)object);
        jComponentArray[8] = OPMLog.olgScaleMenuItem[8];
        componentArray[2] = Multilingual.mlnText(ComponentFactory.createMenu("Display", 68, jComponentArray), "ja", "\u8868\u793a");
        JMenuBar jMenuBar = ComponentFactory.createMenuBar(componentArray);
        olgCanvas.addScaleShiftListener(new ScrollCanvas.ScaleShiftListener(){

            @Override
            public void scaleShiftChanged(int n) {
                if (-4 <= n && n <= 4) {
                    olgScaleShift = n;
                    olgScaleMenuItem[4 + n].setSelected(true);
                }
            }
        });
        olgCanvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MouseEvent2D mouseEvent2D = (MouseEvent2D)mouseEvent;
                int n = (int)mouseEvent2D.getX2D();
                int n2 = (int)mouseEvent2D.getY2D();
                if (10 <= n && n < 1210 && 6 <= n2 && n2 < 490) {
                    n2 -= 6;
                    olgCaretUs = Math.min(Math.max(0, olgBuffer[olgLength - 2] - 1) / olgUsPerPx * olgUsPerPx, OPMLog.olgPxToUs(n -= 10));
                    olgCaretPx = OPMLog.olgUsToPx(olgCaretUs);
                    if (mouseEvent.getClickCount() == 2) {
                        olgStartUs = Math.max(0, olgStartUs + olgUsPerPx * (olgCaretPx - 600));
                        olgCaretPx = (olgCaretUs - olgStartUs) / olgUsPerPx;
                        olgEndUs = olgStartUs + olgRangeUs;
                    }
                    OPMLog.olgPaint();
                }
            }
        });
        olgCanvas.setFocusable(true);
        olgCanvas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                int n2 = keyEvent.getModifiersEx();
                boolean bl = (n2 & 0x40) == 64;
                boolean bl2 = (n2 & 0x80) == 128;
                int n3 = 0;
                switch (n) {
                    case 37: {
                        n3 = bl2 ? -100 : (bl ? -10 : -1);
                        break;
                    }
                    case 39: {
                        int n4 = bl2 ? 100 : (n3 = bl ? 10 : 1);
                    }
                }
                if (n3 != 0) {
                    OPMLog.olgMoveCaret(n3);
                    keyEvent.consume();
                }
            }
        });
        Component[] componentArray2 = new Component[2];
        olgStartButton = ComponentFactory.setEnabled(ComponentFactory.createButton("\u25cf", (ActionListener)object), true);
        componentArray2[0] = olgStartButton;
        olgEndButton = ComponentFactory.setEnabled(ComponentFactory.createButton("\u25a0", (ActionListener)object), false);
        componentArray2[1] = olgEndButton;
        Box box = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(componentArray2), "Record"), "ja", "\u9332\u97f3");
        Component[] componentArray3 = new Component[2];
        olgPlusButton = ComponentFactory.setEnabled(ComponentFactory.createButton("\uff0b", (ActionListener)object), 0 < olgRangeIndex);
        componentArray3[0] = olgPlusButton;
        olgMinusButton = ComponentFactory.setEnabled(ComponentFactory.createButton("\uff0d", (ActionListener)object), olgRangeIndex < OLG_RANGE_COUNT - 1);
        componentArray3[1] = olgMinusButton;
        Box box2 = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(componentArray3), "Zoom"), "ja", "\u62e1\u5927");
        Box box3 = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(ComponentFactory.createButton("\u4e28\uff1c", (ActionListener)object), ComponentFactory.createButton("\u226a\u226a", (ActionListener)object), ComponentFactory.createButton("\u226a", (ActionListener)object), ComponentFactory.createButton("\uff1c", (ActionListener)object), ComponentFactory.createButton("\uff1e", (ActionListener)object), ComponentFactory.createButton("\u226b", (ActionListener)object), ComponentFactory.createButton("\u226b\u226b", (ActionListener)object), ComponentFactory.createButton("\uff1e\u4e28", (ActionListener)object)), "Move"), "ja", "\u79fb\u52d5");
        Box box4 = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[0], "0", (ActionListener)object), Color.black, OLG_KON_COLOR[0]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[1], "1", (ActionListener)object), Color.black, OLG_KON_COLOR[1]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[2], "2", (ActionListener)object), Color.black, OLG_KON_COLOR[2]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[3], "3", (ActionListener)object), Color.black, OLG_KON_COLOR[3]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[4], "4", (ActionListener)object), Color.black, OLG_KON_COLOR[4]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[5], "5", (ActionListener)object), Color.black, OLG_KON_COLOR[5]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[6], "6", (ActionListener)object), Color.black, OLG_KON_COLOR[6]), 4, 4, 4, 4), ComponentFactory.setEmptyBorder(ComponentFactory.setColor(ComponentFactory.createCheckBox(olgChannelMask[7], "7", (ActionListener)object), Color.black, OLG_KON_COLOR[7]), 4, 4, 4, 4)), "Channel"), "ja", "\u30c1\u30e3\u30f3\u30cd\u30eb");
        Box box5 = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createButton("From", (ActionListener)object), "ja", "\u3053\u3053\u304b\u3089"), Multilingual.mlnText(ComponentFactory.createButton("To", (ActionListener)object), "ja", "\u3053\u3053\u307e\u3067"), Multilingual.mlnText(ComponentFactory.createButton("All", (ActionListener)object), "ja", "\u5168\u90e8")), "Range"), "ja", "\u7bc4\u56f2");
        Box box6 = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(ComponentFactory.createButton("\u25b7", (ActionListener)object), ComponentFactory.createButton("\u25a1", (ActionListener)object)), "Play"), "ja", "\u518d\u751f");
        Box box7 = ComponentFactory.createHorizontalBox(box, box2, box3, box4, box5, box6, Box.createHorizontalGlue());
        olgToneImage = new BufferedImage(870, 210, 1);
        olgToneBitmap = ((DataBufferInt)olgToneImage.getRaster().getDataBuffer()).getData();
        olgTonePanel = ComponentFactory.setPreferredSize(new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawImage(olgToneImage, 0, 0, null);
            }
        }, 870, 210);
        olgDumpTextArea = ComponentFactory.createScrollTextArea("", 340, 180);
        olgDumpTextArea.setLineWrap(true);
        olgFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("olg", "OPM log", jMenuBar, ComponentFactory.createVerticalBox(box7, Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(olgCanvas, "Score and wave"), "ja", "\u697d\u8b5c\u3068\u6ce2\u5f62"), ComponentFactory.createHorizontalBox(Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(olgDumpTextArea, "Log"), "ja", "\u30ed\u30b0"), Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(olgTonePanel), "Tone"), "ja", "\u97f3\u8272")))), "ja", "OPM \u30ed\u30b0");
        OPMLog.olgPaint();
    }

    public static void olgMoveCaret(int n) {
        olgCaretUs = Math.max(0, Math.min(Math.max(0, olgBuffer[olgLength - 2] - 1) / olgUsPerPx * olgUsPerPx, olgCaretUs + olgUsPerPx * n));
        olgCaretPx = (olgCaretUs - olgStartUs) / olgUsPerPx;
        if (olgCaretPx < 0) {
            olgStartUs = Math.max(0, olgStartUs - olgRangeUs);
            olgCaretPx = (olgCaretUs - olgStartUs) / olgUsPerPx;
            olgEndUs = olgStartUs + olgRangeUs;
        } else if (1200 <= olgCaretPx) {
            olgCaretPx = (olgCaretUs - (olgStartUs += olgRangeUs)) / olgUsPerPx;
            olgEndUs = olgStartUs + olgRangeUs;
        }
        OPMLog.olgPaint();
    }

    public static void olgRecordStart() {
        int n;
        if (olgRecording) {
            return;
        }
        olgRecording = true;
        olgLength = 0;
        olgStartTimePS = XEiJ.mpuClockTime;
        olgCounter = 0;
        olgStartButton.setEnabled(false);
        olgEndButton.setEnabled(true);
        olgForcedTerminationTask = new TimerTask(){

            @Override
            public void run() {
                OPMLog.olgRecordEnd();
            }
        };
        olgTimer.schedule(olgForcedTerminationTask, 900000L);
        for (n = 0; n <= 255; ++n) {
            if (n == 8) continue;
            if (n == 25) {
                for (int i = 0; i < 2; ++i) {
                    OPMLog.olgBuffer[OPMLog.olgCounter++] = 0;
                    OPMLog.olgBuffer[OPMLog.olgCounter++] = n << 8 | (i << 7 | OPM.opmRegister[264 + i]);
                }
                continue;
            }
            OPMLog.olgBuffer[OPMLog.olgCounter++] = 0;
            OPMLog.olgBuffer[OPMLog.olgCounter++] = n << 8 | OPM.opmRegister[n];
        }
        for (n = 0; n < 8; ++n) {
            OPMLog.olgBuffer[OPMLog.olgCounter++] = 0;
            OPMLog.olgBuffer[OPMLog.olgCounter++] = 0x800 | (OPM.opmRegister[256 + n] << 3 | n);
        }
    }

    public static void olgRecordEnd() {
        if (!olgRecording) {
            return;
        }
        OPMLog.olgBuffer[OPMLog.olgCounter++] = (int)((XEiJ.mpuClockTime - olgStartTimePS) / 1000000L);
        OPMLog.olgBuffer[OPMLog.olgCounter++] = -1;
        olgRecording = false;
        olgLength = olgCounter;
        olgStartTimePS = 0L;
        olgCounter = 0;
        if (olgForcedTerminationTask != null) {
            olgForcedTerminationTask.cancel();
            olgForcedTerminationTask = null;
        }
        olgEndButton.setEnabled(false);
        olgTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                OPMLog.olgMakeWaveData();
                OPMLog.olgPaint();
                olgStartButton.setEnabled(true);
            }
        }, 0L);
    }

    public static void olgSetData(int n, int n2) {
        if (olgRecording) {
            if (1048574 <= olgCounter) {
                OPMLog.olgRecordEnd();
            } else {
                OPMLog.olgBuffer[OPMLog.olgCounter++] = (int)((XEiJ.mpuClockTime - olgStartTimePS) / 1000000L);
                OPMLog.olgBuffer[OPMLog.olgCounter++] = n << 8 | n2;
            }
        }
    }

    public static void olgSetCSMKON() {
        if (olgRecording) {
            if (1048574 <= olgCounter) {
                OPMLog.olgRecordEnd();
            } else {
                OPMLog.olgBuffer[OPMLog.olgCounter++] = (int)((XEiJ.mpuClockTime - olgStartTimePS) / 1000000L);
                OPMLog.olgBuffer[OPMLog.olgCounter++] = 65536;
            }
        }
    }

    public static void olgPaint() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Graphics2D graphics2D = olgCanvasImage.createGraphics();
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(0, 0, 1220, 496);
        graphics2D.setColor(Color.darkGray);
        graphics2D.setStroke(olgSolidStroke);
        int n10 = 10;
        int n11 = olgUsPerPx * n10;
        int n12 = (olgStartUs + (n11 - 1)) / n11 * n11;
        for (n9 = n8 = OPMLog.olgUsToPx(n12); n9 < 1200; n9 += n10) {
            n7 = OPMLog.olgPxToUs(n9);
            if (n7 % (n11 * 10) == 0) continue;
            graphics2D.drawLine(10 + n9, 6, 10 + n9, 490);
        }
        graphics2D.setColor(Color.darkGray);
        graphics2D.setStroke(olgSolidStroke);
        for (n10 = -6; n10 < 90; ++n10) {
            if ((1 << (n10 + 12) % 12 & 0x5AC) == 0) continue;
            double d = (double)n10 / 12.0;
            n8 = (int)Math.floor(3584.5 + 768.0 * (d - 4.0 + -0.16004041251046827));
            n9 = 388 * (6207 - n8) / 6208;
            graphics2D.drawLine(10, 6 + n9, 1209, 6 + n9);
        }
        graphics2D.setFont(LnF.lnfMonospacedFont12);
        graphics2D.setStroke(olgSolidStroke);
        n10 = 100;
        n11 = olgUsPerPx * n10;
        n12 = (olgStartUs + (n11 - 1)) / n11 * n11;
        for (n9 = n8 = OPMLog.olgUsToPx(n12); n9 < 1200; n9 += n10) {
            n7 = OPMLog.olgPxToUs(n9);
            graphics2D.setColor(Color.gray);
            graphics2D.drawLine(10 + n9, 6, 10 + n9, 490);
            graphics2D.setColor(Color.white);
            graphics2D.drawString(String.valueOf((double)n7 / 1000000.0) + "s", 10 + n9 + 3, 392);
        }
        graphics2D.setFont(LnF.lnfMonospacedFont12);
        graphics2D.setStroke(olgSolidStroke);
        for (n10 = 0; n10 < 8; ++n10) {
            n11 = (int)Math.floor(3584.5 + 768.0 * ((double)(n10 - 4) + -0.16004041251046827));
            n12 = 388 * (6207 - n11) / 6208;
            graphics2D.setColor(Color.gray);
            graphics2D.drawLine(10, 6 + n12, 1209, 6 + n12);
            graphics2D.setColor(Color.white);
            graphics2D.drawString("o" + n10 + "a", 13, 6 + n12 - 2);
        }
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(10, 394, 1209, 394);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(10, 442, 1209, 442);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(10, 490, 1209, 490);
        if (opmBuffer != null) {
            Path2D.Float float_ = new Path2D.Float();
            Path2D.Float float_2 = new Path2D.Float();
            for (n12 = 0; n12 < 1200 && opmBuffer.length > (n9 = 2 * ((n8 = OPMLog.olgPxToUs(n12)) >> 4)); ++n12) {
                n7 = 48 * opmBuffer[n9] >> 15;
                n6 = 48 * opmBuffer[n9 + 1] >> 15;
                if (n12 == 0) {
                    ((Path2D)float_).moveTo(10 + n12, 442 - n7);
                    ((Path2D)float_2).moveTo(10 + n12, 442 - n6);
                    continue;
                }
                ((Path2D)float_).lineTo(10 + n12, 442 - n7);
                ((Path2D)float_2).lineTo(10 + n12, 442 - n6);
            }
            graphics2D.setStroke(olgWaveStroke);
            graphics2D.setColor(Color.yellow);
            graphics2D.draw(float_);
            graphics2D.setColor(Color.cyan);
            graphics2D.draw(float_2);
        }
        Arrays.fill(addressToData, 0);
        Arrays.fill(addressToUs, -1);
        Arrays.fill(channelToKindex, 0);
        Arrays.fill(channelToKonUs, -1);
        Arrays.fill(caretAddressToData, 0);
        Arrays.fill(caretAddressToUs, -1);
        int n13 = -1;
        graphics2D.setStroke(olgSolidStroke);
        for (n5 = 0; n5 < olgLength; n5 += 2) {
            n12 = olgBuffer[n5];
            n8 = olgBuffer[n5 + 1];
            if (olgEndUs <= n12 || n8 == -1) break;
            if (n8 == 65536) continue;
            if (n13 == -1 && olgCaretUs <= n12) {
                n13 = n5;
                System.arraycopy(addressToData, 0, caretAddressToData, 0, addressToData.length);
                System.arraycopy(addressToUs, 0, caretAddressToUs, 0, addressToUs.length);
            }
            n9 = n8 >> 8;
            OPMLog.addressToData[n9] = n7 = n8 & 0xFF;
            OPMLog.addressToUs[n9] = n12;
            if (!(n9 == 8 && !olgChannelMask[n7 & 7] || 16 <= n9 && n9 <= 18 || 32 <= n9 && !olgChannelMask[n9 & 7])) {
                graphics2D.setColor(n9 == 8 ? OLG_KON_COLOR[n7 & 7] : (32 <= n9 ? OLG_KON_COLOR[n9 & 7] : Color.white));
                n6 = OPMLog.olgUsToPx(n12);
                graphics2D.drawLine(10 + n6, 372, 10 + n6, 380);
            }
            if (n9 == 8) {
                n6 = n7 & 7;
                if (channelToKonUs[n6] != -1) {
                    OPMLog.olgDrawKoff(graphics2D, n6, channelToKindex[n6], channelToKonUs[n6], n12);
                    OPMLog.channelToKonUs[n6] = -1;
                }
                OPMLog.addressToData[256 + n6] = n4 = n7 >> 3 & 0xF;
                OPMLog.addressToUs[256 + n6] = n12;
                if (n4 == 0) continue;
                OPMLog.olgDrawKon1st(graphics2D, n6, channelToKindex[n6], n12);
                OPMLog.channelToKonUs[n6] = n12;
                continue;
            }
            if (n9 == 25) {
                n6 = (n7 & 0x80) == 0 ? 264 : 265;
                OPMLog.addressToData[n6] = n7 & 0x7F;
                OPMLog.addressToUs[n6] = n12;
                continue;
            }
            if (40 <= n9 && n9 < 48) {
                n6 = n9 & 7;
                n4 = n7 & 0x7F;
                n3 = addressToData[48 + n6] >> 2 & 0x3F;
                n2 = n4 - (n4 >> 2) << 6 | n3;
                if (channelToKonUs[n6] != -1) {
                    OPMLog.olgDrawKoff(graphics2D, n6, channelToKindex[n6], channelToKonUs[n6], n12);
                    OPMLog.olgDrawKon2nd(graphics2D, n6, n2, n12);
                    OPMLog.channelToKonUs[n6] = n12;
                }
                OPMLog.channelToKindex[n6] = n2;
                continue;
            }
            if (48 > n9 || n9 >= 56) continue;
            n6 = n9 & 7;
            n4 = addressToData[40 + n6] & 0x7F;
            n3 = n7 >> 2 & 0x3F;
            n2 = n4 - (n4 >> 2) << 6 | n3;
            if (channelToKonUs[n6] != -1) {
                OPMLog.olgDrawKoff(graphics2D, n6, channelToKindex[n6], channelToKonUs[n6], n12);
                OPMLog.olgDrawKon2nd(graphics2D, n6, n2, n12);
                OPMLog.channelToKonUs[n6] = n12;
            }
            OPMLog.channelToKindex[n6] = n2;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            if (channelToKonUs[n5] == -1) continue;
            OPMLog.olgDrawKoff(graphics2D, n5, channelToKindex[n5], channelToKonUs[n5], Math.min(olgBuffer[olgLength - 2], olgEndUs));
            OPMLog.channelToKonUs[n5] = -1;
        }
        if (olgMaskLeftUs != -1 && olgStartUs < olgMaskLeftUs) {
            n5 = 0;
            n12 = OPMLog.olgUsToPx(Math.min(olgEndUs, olgMaskLeftUs));
            graphics2D.setPaint(olgMaskPaint);
            graphics2D.fillRect(10 + n5, 6, n12 - n5, 388);
        }
        if (olgMaskRightUs != -1 && olgMaskRightUs < olgEndUs) {
            n5 = OPMLog.olgUsToPx(Math.max(olgStartUs, olgMaskRightUs));
            n12 = 1200;
            graphics2D.setPaint(olgMaskPaint);
            graphics2D.fillRect(10 + n5, 6, n12 - n5, 388);
        }
        graphics2D.setColor(Color.green);
        graphics2D.setStroke(olgDashStroke);
        graphics2D.drawLine(10 + olgCaretPx, 6, 10 + olgCaretPx, 490);
        olgCanvas.repaint();
        Arrays.fill(olgToneBitmap, -16777216);
        for (n5 = 0; n5 < 8; ++n5) {
            Arrays.fill(strong, false);
            for (n12 = 0; n12 < TONE_MAP.length; n12 += 6) {
                n8 = TONE_MAP[n12];
                n9 = TONE_MAP[n12 + 1];
                n7 = TONE_MAP[n12 + 2];
                n6 = TONE_MAP[n12 + 3];
                n4 = TONE_MAP[n12 + 4];
                n3 = TONE_MAP[n12 + 5];
                n2 = n8 + n5;
                XEiJ.fmtHex2(OLG_TONE_BASE, 35 * n9 + n6, (caretAddressToData[n2] & n7) >> Integer.numberOfTrailingZeros(n7));
                if (n4 != 0) {
                    XEiJ.fmtHex2(OLG_TONE_BASE, 35 * n9 + n3, (caretAddressToData[n2] & n4) >> Integer.numberOfTrailingZeros(n4));
                }
                if (lastCaretAddressToUs[n2] == caretAddressToUs[n2]) continue;
                OPMLog.strong[35 * n9 + n6] = true;
                OPMLog.strong[35 * n9 + n6 + 1] = true;
                if (n4 == 0) continue;
                OPMLog.strong[35 * n9 + n3] = true;
                OPMLog.strong[35 * n9 + n3 + 1] = true;
            }
            n12 = 24;
            n8 = caretAddressToData[n12];
            n9 = 1;
            n7 = 15;
            XEiJ.fmtHex2(OLG_TONE_BASE, 35 * n9 + n7, n8 & 0xFF);
            if (lastCaretAddressToUs[n12] != caretAddressToUs[n12]) {
                OPMLog.strong[35 * n9 + n7] = true;
                OPMLog.strong[35 * n9 + n7 + 1] = true;
            }
            n12 = 27;
            n8 = caretAddressToData[n12];
            n9 = 1;
            n7 = 9;
            XEiJ.fmtHex2(OLG_TONE_BASE, 35 * n9 + n7, n8 & 3);
            if (lastCaretAddressToUs[n12] != caretAddressToUs[n12]) {
                OPMLog.strong[35 * n9 + n7] = true;
                OPMLog.strong[35 * n9 + n7 + 1] = true;
            }
            n12 = 264;
            n8 = caretAddressToData[n12];
            n9 = 1;
            n7 = 21;
            XEiJ.fmtHex2(OLG_TONE_BASE, 35 * n9 + n7, n8);
            if (lastCaretAddressToUs[n12] != caretAddressToUs[n12]) {
                OPMLog.strong[35 * n9 + n7] = true;
                OPMLog.strong[35 * n9 + n7 + 1] = true;
            }
            n12 = 265;
            n8 = caretAddressToData[n12];
            n9 = 1;
            n7 = 18;
            XEiJ.fmtHex2(OLG_TONE_BASE, 35 * n9 + n7, n8);
            if (lastCaretAddressToUs[n12] != caretAddressToUs[n12]) {
                OPMLog.strong[35 * n9 + n7] = true;
                OPMLog.strong[35 * n9 + n7 + 1] = true;
            }
            n12 = n5 & 3;
            n8 = n5 >> 2;
            n9 = 6 + 216 * n12;
            n7 = 10 + 100 * n8;
            n6 = (olgChannelMask[n5] ? (caretAddressToData[256 + n5] != 0 ? OLG_KON_COLOR : OLG_BAR_COLOR)[n5] : Color.darkGray).getRGB();
            for (n4 = 0; n4 < 9; ++n4) {
                for (n3 = 0; n3 < 35; ++n3) {
                    n2 = OLG_TONE_BASE[n3 + 35 * n4];
                    for (n = 0; n < 8; ++n) {
                        int n14 = FontPage.Lcd.LCD6X8_FONT[8 * n2 + n] << 24;
                        for (int i = 0; i < 6; ++i) {
                            OPMLog.olgToneBitmap[n9 + 6 * n3 + i + 870 * (n7 + 10 * n4 + n)] = n14 < 0 ? n6 : -16777216;
                            n14 <<= 1;
                        }
                    }
                    if (!strong[n3 + 35 * n4]) continue;
                    for (n = 0; n < 6; ++n) {
                        OPMLog.olgToneBitmap[n9 + 6 * n3 + n + 870 * (n7 + 10 * n4 + 8)] = n6;
                    }
                }
            }
        }
        System.arraycopy(caretAddressToUs, 0, lastCaretAddressToUs, 0, caretAddressToUs.length);
        olgTonePanel.repaint();
        if (n13 == -1) {
            n13 = Math.max(0, olgLength - 2);
        }
        n5 = olgCaretUs;
        n12 = n13;
        while (Math.max(0, n13 - 20) < n12) {
            n5 = Math.max(0, n5 - olgUsPerPx);
            while (0 < n12 && n5 <= olgBuffer[n12 - 2]) {
                n12 -= 2;
            }
        }
        n8 = olgCaretUs;
        n9 = n13;
        while (n9 < Math.min(olgLength - 2, n13 + 20)) {
            n8 = Math.min(olgBuffer[olgLength - 2], n8 + olgUsPerPx);
            while (n9 < olgLength - 2 && olgBuffer[n9 + 2] <= n8) {
                n9 += 2;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n6 = n12; n6 <= n9; n6 += 2) {
            if (n6 == n13) {
                stringBuilder.append("--------------------\n");
            }
            n4 = olgBuffer[n6];
            n3 = olgBuffer[n6 + 1];
            stringBuilder.append(String.valueOf((double)n4 / 1000000.0)).append("s");
            if (n3 == -1) {
                stringBuilder.append(" -1 END\n");
                break;
            }
            stringBuilder.append(" 0x");
            XEiJ.fmtHex4(stringBuilder, n3);
            if (n3 == 65536) {
                stringBuilder.append(" CSMKON\n");
                continue;
            }
            n2 = n3 >> 8 & 0xFF;
            n = n3 & 0xFF;
            if (n2 < 32) {
                switch (n2) {
                    case 1: {
                        stringBuilder.append(" LFORESET=").append(n >> 1 & 1);
                        break;
                    }
                    case 8: {
                        stringBuilder.append(" KON[").append(n & 7).append("]=").append(n >> 3 & 0xF);
                        break;
                    }
                    case 15: {
                        stringBuilder.append(" NE=").append(n >> 7 & 1);
                        stringBuilder.append(" NFRQ=").append(n & 0x1F);
                        break;
                    }
                    case 16: {
                        stringBuilder.append(" CLKA1=").append(n & 0xFF);
                        break;
                    }
                    case 17: {
                        stringBuilder.append(" CLKA2=").append(n & 3);
                        break;
                    }
                    case 18: {
                        stringBuilder.append(" CLKB=").append(n & 0xFF);
                        break;
                    }
                    case 20: {
                        stringBuilder.append(" CSM=").append(n >> 7 & 1);
                        stringBuilder.append(" RESETB=").append(n >> 5 & 1);
                        stringBuilder.append(" RESETA=").append(n >> 4 & 1);
                        stringBuilder.append(" IRQENB=").append(n >> 3 & 1);
                        stringBuilder.append(" IRQENA=").append(n >> 2 & 1);
                        stringBuilder.append(" LOADB=").append(n >> 1 & 1);
                        stringBuilder.append(" LOADA=").append(n & 1);
                        break;
                    }
                    case 24: {
                        stringBuilder.append(" LFRQ=").append(n & 0xFF);
                        break;
                    }
                    case 25: {
                        if ((n >> 7 & 1) == 0) {
                            stringBuilder.append(" AMD=").append(n & 0x7F);
                            break;
                        }
                        stringBuilder.append(" PMD=").append(n & 0x7F);
                        break;
                    }
                    case 27: {
                        stringBuilder.append(" CT1=").append(n >> 7 & 1);
                        stringBuilder.append(" CT2=").append(n >> 6 & 1);
                        stringBuilder.append(" W=").append(n & 3);
                    }
                }
            } else if (n2 < 64) {
                stringBuilder.append(" CH").append(n2 & 7);
                switch (n2 >> 3) {
                    case 4: {
                        stringBuilder.append(" R=").append(n >> 7 & 1);
                        stringBuilder.append(" L=").append(n >> 6 & 1);
                        stringBuilder.append(" FL=").append(n >> 3 & 7);
                        stringBuilder.append(" CON=").append(n & 7);
                        break;
                    }
                    case 5: {
                        stringBuilder.append(" KC=").append(n & 0x7F);
                        break;
                    }
                    case 6: {
                        stringBuilder.append(" KF=").append(n >> 2 & 0x3F);
                        break;
                    }
                    case 7: {
                        stringBuilder.append(" PMS=").append(n >> 4 & 7);
                        stringBuilder.append(" AMS=").append(n & 3);
                    }
                }
            } else {
                stringBuilder.append(" CH").append(n2 & 7);
                stringBuilder.append((n2 >> 3 & 3) == 0 ? " M1" : ((n2 >> 3 & 3) == 1 ? " M2" : ((n2 >> 3 & 3) == 2 ? " C1" : " C2")));
                switch (n2 >> 5) {
                    case 2: {
                        stringBuilder.append(" DT1=").append(n >> 4 & 7);
                        stringBuilder.append(" MUL=").append(n & 0xF);
                        break;
                    }
                    case 3: {
                        stringBuilder.append(" TL=").append(n & 0x7F);
                        break;
                    }
                    case 4: {
                        stringBuilder.append(" KS=").append(n >> 6 & 3);
                        stringBuilder.append(" AR=").append(n & 0x1F);
                        break;
                    }
                    case 5: {
                        stringBuilder.append(" AMSEN=").append(n >> 7 & 1);
                        stringBuilder.append(" D1R=").append(n & 0x1F);
                        break;
                    }
                    case 6: {
                        stringBuilder.append(" DT2=").append(n >> 6 & 3);
                        stringBuilder.append(" D2R=").append(n & 0x1F);
                        break;
                    }
                    case 7: {
                        stringBuilder.append(" D1L=").append(n >> 4 & 0xF);
                        stringBuilder.append(" RR=").append(n & 0xF);
                    }
                }
            }
            stringBuilder.append("\n");
        }
        String string = stringBuilder.toString();
        olgDumpTextArea.setText(string);
        olgDumpTextArea.setCaretPosition(string.length());
        olgDumpTextArea.setCaretPosition(string.indexOf("----"));
    }

    public static void olgDrawKon1st(Graphics2D graphics2D, int n, int n2, int n3) {
        if (olgStartUs <= n3 && n3 < olgEndUs && olgChannelMask[n]) {
            int n4 = 388 * (6207 - n2) / 6208;
            int n5 = Math.max(0, n3 - olgStartUs) / olgUsPerPx;
            graphics2D.setColor(OLG_KON_COLOR[n]);
            graphics2D.drawLine(10 + n5, 6 + n4 - 4, 10 + n5, 6 + n4 + 4);
        }
    }

    public static void olgDrawKon2nd(Graphics2D graphics2D, int n, int n2, int n3) {
        if (olgStartUs <= n3 && n3 < olgEndUs && olgChannelMask[n]) {
            int n4 = 388 * (6207 - n2) / 6208;
            int n5 = Math.max(0, n3 - olgStartUs) / olgUsPerPx;
            graphics2D.setColor(OLG_BAR_COLOR[n]);
            graphics2D.drawLine(10 + n5, 6 + n4 - 3, 10 + n5, 6 + n4 + 3);
        }
    }

    public static void olgDrawKoff(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (olgStartUs < n4 && n3 < olgEndUs && olgChannelMask[n]) {
            int n5;
            int n6 = 388 * (6207 - n2) / 6208;
            int n7 = Math.max(0, n3 - olgStartUs) / olgUsPerPx;
            if (n7 + 1 < (n5 = (n4 - olgStartUs) / olgUsPerPx)) {
                graphics2D.setColor(OLG_BAR_COLOR[n]);
                graphics2D.fillRect(10 + n7 + 1, 6 + n6 - 1, n5 - (n7 + 1), 3);
            }
        }
    }

    public static void olgLoadMML() {
        JFileChooser2 jFileChooser2 = new JFileChooser2(olgLastMMLFile);
        jFileChooser2.setFileFilter(olgMMLFilter);
        if (jFileChooser2.showOpenDialog(null) != 0) {
            return;
        }
        MMLCompiler mMLCompiler = new MMLCompiler();
        File file = jFileChooser2.getSelectedFile();
        String string = XEiJ.rscGetTextFile(file.getPath());
        int[] nArray = mMLCompiler.compile(string);
        if (nArray == null) {
            JOptionPane.showMessageDialog(null, mMLCompiler.getError());
            return;
        }
        olgLastMMLFile = file;
        System.arraycopy(nArray, 0, olgBuffer, 0, nArray.length);
        olgLength = nArray.length;
        OPMLog.olgMakeWaveData();
        OPMLog.olgPaint();
    }

    public static void olgLoadLog() {
        boolean bl;
        JFileChooser2 jFileChooser2 = new JFileChooser2(olgLastFile);
        jFileChooser2.setFileFilter(olgFilter);
        if (jFileChooser2.showOpenDialog(null) != 0) {
            return;
        }
        File file = jFileChooser2.getSelectedFile();
        byte[] byArray = XEiJ.rscGetFile(file.getPath(), new int[0]);
        boolean bl2 = bl = 8 > byArray.length || byArray.length > 0x400000 || byArray.length % 8 != 0;
        if (!bl) {
            int n;
            olgLength = byArray.length >> 2;
            for (n = 0; n < olgLength; ++n) {
                OPMLog.olgBuffer[n] = byArray[4 * n] << 24 | (byArray[4 * n + 1] & 0xFF) << 16 | (byArray[4 * n + 2] & 0xFF) << 8 | byArray[4 * n + 3] & 0xFF;
            }
            n = 0;
            for (int i = 0; i < olgLength; i += 2) {
                int n2 = olgBuffer[i];
                int n3 = olgBuffer[i + 1];
                if (0 > n2 || n2 > 999999999 || n > n2 || !(i >= olgLength - 2 ? n3 == -1 : 0 <= n3 && n3 <= 65536)) {
                    bl = true;
                    break;
                }
                n = n2;
            }
            if (!bl) {
                olgLastFile = file;
            }
        }
        if (bl) {
            OPMLog.olgBuffer[0] = 0;
            OPMLog.olgBuffer[1] = -1;
            olgLength = 2;
        }
        OPMLog.olgMakeWaveData();
        OPMLog.olgPaint();
    }

    public static void olgSaveLog() {
        byte[] byArray = new byte[4 * olgLength];
        for (int i = 0; i < olgLength; ++i) {
            int n = olgBuffer[i];
            byArray[4 * i] = (byte)(n >> 24);
            byArray[4 * i + 1] = (byte)(n >> 16);
            byArray[4 * i + 2] = (byte)(n >> 8);
            byArray[4 * i + 3] = (byte)n;
        }
        JFileChooser2 jFileChooser2 = new JFileChooser2(olgLastFile);
        jFileChooser2.setFileFilter(olgFilter);
        if (jFileChooser2.showSaveDialog(null) != 0) {
            return;
        }
        File file = jFileChooser2.getSelectedFile();
        if (XEiJ.rscPutFile(file.getPath(), byArray, 0, 4 * olgLength)) {
            olgLastFile = file;
        }
    }

    public static void olgAdjust() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < olgLength; n3 += 2) {
            int n6;
            n2 = olgBuffer[n3];
            if (n2 == 0) continue;
            n = olgBuffer[n3 + 1];
            if (n4 == 0) {
                n4 = n2;
            }
            if (n == 65536) {
                n5 = n2;
                break;
            }
            if (n == -1) continue;
            int n7 = n >> 8;
            int n8 = n & 0xFF;
            if (n7 != 8 || (n6 = n8 >> 3 & 0xF) == 0) continue;
            n5 = n2;
            break;
        }
        if (n5 == 0) {
            return;
        }
        n3 = (n5 - n4 + 1 + 999999) / 1000000 * 1000000;
        for (n2 = 0; n2 < olgLength; n2 += 2) {
            n = olgBuffer[n2];
            if (n == 0) continue;
            int n9 = n2;
            olgBuffer[n9] = olgBuffer[n9] + (n3 - n5);
        }
        OPMLog.olgPaint();
    }

    public static void olgMakeWaveData() {
        int n;
        int n2;
        int n3;
        int n4;
        olgYM2151.reset();
        olgYM2151.setChannelMask((olgChannelMask[0] ? 1 : 0) | (olgChannelMask[1] ? 2 : 0) | (olgChannelMask[2] ? 4 : 0) | (olgChannelMask[3] ? 8 : 0) | (olgChannelMask[4] ? 16 : 0) | (olgChannelMask[5] ? 32 : 0) | (olgChannelMask[6] ? 64 : 0) | (olgChannelMask[7] ? 128 : 0));
        samples62500 = 0;
        samples48000 = 0;
        int n5 = olgBuffer[olgLength - 2];
        if (n5 == 0) {
            return;
        }
        samples62500 = n5 >> 4;
        olgYM2151.allocate(2 * samples62500);
        opmBuffer = olgYM2151.getBuffer();
        int n6 = 0;
        for (n4 = 0; n4 < olgLength; n4 += 2) {
            n3 = olgBuffer[n4];
            n2 = olgBuffer[n4 + 1];
            if (n2 == -1 || 2 * samples62500 <= (n = 2 * ((n3 = Math.max(n6, n3)) >> 4))) break;
            n6 = n3 + 16;
            olgYM2151.generate(n);
            if (n2 == 65536) {
                olgYM2151.timerAExpired();
                continue;
            }
            olgYM2151.writeAddress(n2 >> 8);
            olgYM2151.writeData(n2);
        }
        olgYM2151.fill();
        samples48000 = (int)((long)samples62500 * 48000L / 62500L);
        sampleBuffer = new byte[4 * samples48000];
        for (n4 = 0; n4 < samples48000; ++n4) {
            n3 = (int)((long)n4 * 62500L / 48000L);
            n2 = opmBuffer[2 * n3] * 1024 >> 10;
            n = opmBuffer[2 * n3 + 1] * 1024 >> 10;
            n2 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n2));
            n = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n));
            OPMLog.sampleBuffer[4 * n4] = (byte)n2;
            OPMLog.sampleBuffer[4 * n4 + 1] = (byte)(n2 >> 8);
            OPMLog.sampleBuffer[4 * n4 + 2] = (byte)n;
            OPMLog.sampleBuffer[4 * n4 + 3] = (byte)(n >> 8);
        }
    }

    public static void olgPlayStart() {
        int n;
        if (playTask != null) {
            writtenBytes = 0;
            return;
        }
        int n2 = olgMaskLeftUs != -1 ? olgMaskLeftUs : 0;
        int n3 = olgMaskRightUs != -1 ? olgMaskRightUs : olgBuffer[olgLength - 2];
        int n4 = n2 >> 4;
        int n5 = n3 >> 4;
        int n6 = (int)((long)n4 * 48000L / 62500L);
        int n7 = (int)((long)n5 * 48000L / 62500L);
        int n8 = 4 * n6;
        totalBytes = n = 4 * n7;
        writtenBytes = n8;
        try {
            AudioFormat audioFormat = new AudioFormat(48000.0f, 16, 2, true, false);
            sourceDataLine = AudioSystem.getSourceDataLine(audioFormat);
            sourceDataLine.open(audioFormat, 96000);
            sourceDataLine.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        playTask = new TimerTask(){

            @Override
            public void run() {
                if (writtenBytes < totalBytes) {
                    int n = Math.min(38400, totalBytes - writtenBytes);
                    if (n <= sourceDataLine.available()) {
                        try {
                            sourceDataLine.write(sampleBuffer, writtenBytes, n);
                            writtenBytes += n;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            writtenBytes = totalBytes;
                        }
                    }
                } else {
                    try {
                        sourceDataLine.stop();
                        sourceDataLine.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    sourceDataLine = null;
                    if (playTask != null) {
                        playTask.cancel();
                        playTask = null;
                    }
                }
            }
        };
        olgTimer.scheduleAtFixedRate(playTask, 0L, 100L);
    }

    public static void olgPlayEnd() {
        writtenBytes = totalBytes;
    }

    static {
        OLG_US_PER_PX = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000};
        OLG_RANGE_COUNT = OLG_US_PER_PX.length;
        olgChannelMask = new boolean[8];
        OLG_KON_COLOR = new Color[]{Color.getHSBColor(0.0f, 0.5f, 1.0f), Color.getHSBColor(0.125f, 0.5f, 1.0f), Color.getHSBColor(0.25f, 0.5f, 1.0f), Color.getHSBColor(0.375f, 0.5f, 1.0f), Color.getHSBColor(0.5f, 0.5f, 1.0f), Color.getHSBColor(0.625f, 0.5f, 1.0f), Color.getHSBColor(0.75f, 0.5f, 1.0f), Color.getHSBColor(0.875f, 0.5f, 1.0f)};
        OLG_BAR_COLOR = new Color[]{Color.getHSBColor(0.0f, 0.5f, 0.5f), Color.getHSBColor(0.125f, 0.5f, 0.5f), Color.getHSBColor(0.25f, 0.5f, 0.5f), Color.getHSBColor(0.375f, 0.5f, 0.5f), Color.getHSBColor(0.5f, 0.5f, 0.5f), Color.getHSBColor(0.625f, 0.5f, 0.5f), Color.getHSBColor(0.75f, 0.5f, 0.5f), Color.getHSBColor(0.875f, 0.5f, 0.5f)};
        OLG_TONE_BASE = "   FC SL WA SY SP PD AD PS AS PN      -- -- -- -- -- -- -- -- -- -- --   AR 1R 2R RR 1L TL KS ML T1 T2 AEM1 -- -- -- -- -- -- -- -- -- -- --C1 -- -- -- -- -- -- -- -- -- -- --M2 -- -- -- -- -- -- -- -- -- -- --C2 -- -- -- -- -- -- -- -- -- -- --   KC KF                              -- --                           ".toCharArray();
        addressToData = new int[266];
        addressToUs = new int[266];
        channelToKindex = new int[8];
        channelToKonUs = new int[8];
        caretAddressToData = new int[266];
        caretAddressToUs = new int[266];
        lastCaretAddressToUs = new int[266];
        strong = new boolean[OLG_TONE_BASE.length];
        TONE_MAP = new int[]{32, 1, 192, 30, 63, 3, 40, 8, 127, 3, 0, 0, 48, 8, 252, 6, 0, 0, 56, 1, 112, 24, 3, 27, 64, 3, 112, 27, 15, 24, 72, 5, 112, 27, 15, 24, 80, 4, 112, 27, 15, 24, 88, 6, 112, 27, 15, 24, 96, 3, 127, 18, 0, 0, 104, 5, 127, 18, 0, 0, 112, 4, 127, 18, 0, 0, 120, 6, 127, 18, 0, 0, 128, 3, 192, 21, 31, 3, 136, 5, 192, 21, 31, 3, 144, 4, 192, 21, 31, 3, 152, 6, 192, 21, 31, 3, 160, 3, 128, 33, 31, 6, 168, 5, 128, 33, 31, 6, 176, 4, 128, 33, 31, 6, 184, 6, 128, 33, 31, 6, 192, 3, 192, 30, 31, 9, 200, 5, 192, 30, 31, 9, 208, 4, 192, 30, 31, 9, 216, 6, 192, 30, 31, 9, 224, 3, 240, 15, 15, 12, 232, 5, 240, 15, 15, 12, 240, 4, 240, 15, 15, 12, 248, 6, 240, 15, 15, 12, 256, 1, 15, 6, 0, 0};
    }
}

