/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.NoSuchElementException;
import java.util.Objects;
import xeij.ByteQueue;

public abstract class NamedPipeInputStream
extends InputStream {
    protected String path;
    protected volatile boolean closed;
    protected volatile boolean connecting;
    protected volatile boolean reading;
    protected Thread thread;
    protected ByteQueue queue;

    public static NamedPipeInputStream create(String string) throws IOException {
        return System.getProperty("os.name").indexOf("Windows") < 0 ? new Gen(string) : new Win(string);
    }

    private NamedPipeInputStream(String string) throws IOException {
        this.osStart(string);
        this.queue = new ByteQueue();
        this.thread = new Thread(this){
            byte[] b;
            final /* synthetic */ NamedPipeInputStream this$0;
            {
                NamedPipeInputStream namedPipeInputStream2 = namedPipeInputStream;
                Objects.requireNonNull(namedPipeInputStream2);
                this.this$0 = namedPipeInputStream2;
                this.b = new byte[1024];
            }

            @Override
            public void run() {
                try {
                    this.this$0.connecting = true;
                    this.this$0.osOpenAndConnect();
                    this.this$0.connecting = false;
                    while (!this.this$0.closed) {
                        this.this$0.reading = true;
                        int n = this.this$0.osRead(this.b);
                        this.this$0.reading = false;
                        if (!this.this$0.closed) {
                            if (n == -1) {
                                this.this$0.osClose();
                                this.this$0.connecting = true;
                                this.this$0.osOpenAndConnect();
                                this.this$0.connecting = false;
                                continue;
                            }
                            this.this$0.queue.write(this.b, 0, n);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.this$0.connecting = false;
                    this.this$0.reading = false;
                }
                this.this$0.osClose();
            }
        };
        this.thread.start();
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("named pipe " + this.path + " closed");
        }
        return this.queue.used();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.osUnblock();
        this.osClose();
        try {
            this.thread.join(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.osEnd();
        this.queue.cancel();
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("named pipe " + this.path + " closed");
        }
        return this.queue.waitAndRead();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("named pipe " + this.path + " closed");
        }
        return this.queue.waitAndRead(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("named pipe " + this.path + " closed");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("b.length=" + byArray.length + ", o=" + n + ", n=" + n2);
        }
        return this.queue.waitAndRead(byArray, n, n2);
    }

    @Override
    public int readNBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.closed) {
            throw new IOException("named pipe " + this.path + " closed");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("b.length=" + byArray.length + ", o=" + n + ", n=" + n2);
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.queue.waitAndRead(byArray, n + n3, n2 - n3);
            if (n4 != -1) continue;
            return -1;
        }
        return n3;
    }

    protected abstract void osStart(String var1) throws IOException;

    protected abstract void osOpenAndConnect() throws IOException;

    protected abstract int osRead(byte[] var1) throws IOException;

    protected abstract void osUnblock();

    protected abstract void osClose();

    protected abstract void osEnd();

    private static class Gen
    extends NamedPipeInputStream {
        private File file;
        private FileInputStream stream;

        protected Gen(String string) throws IOException {
            super(string);
        }

        @Override
        protected void osStart(String string) throws IOException {
            Process process;
            this.path = System.getProperty("java.io.tmpdir") + "/" + string;
            this.file = new File(this.path);
            this.file.delete();
            try {
                process = new ProcessBuilder("mkfifo", this.path).inheritIO().start();
            }
            catch (IOException iOException) {
                throw new IOException("mkfifo " + this.path + " not started");
            }
            try {
                int n = process.waitFor();
                if (n != 0) {
                    this.file.delete();
                    throw new IOException("mkfifo " + this.path + " terminated with exit code " + n);
                }
            }
            catch (InterruptedException interruptedException) {
                this.file.delete();
                throw new IOException("mkfifo " + this.path + " interrupted");
            }
        }

        @Override
        protected void osOpenAndConnect() throws IOException {
            if (this.stream == null) {
                this.stream = new FileInputStream(this.file);
            }
        }

        @Override
        protected int osRead(byte[] byArray) throws IOException {
            return this.stream.read(byArray);
        }

        @Override
        protected void osUnblock() {
            if (this.connecting) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.connecting) {
                    try {
                        new FileOutputStream(this.file).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (int i = 0; i < 100 && this.connecting; ++i) {
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.connecting) {
                        System.out.println("named pipe " + this.path + " unblocking timeout");
                    }
                }
            }
            if (this.reading) {
                for (int i = 0; i < 100 && this.reading; ++i) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.reading) {
                    System.out.println("user operation required to unblock named pipe " + this.path);
                    while (this.reading) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        @Override
        protected void osClose() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
        }

        @Override
        protected void osEnd() {
            this.file.delete();
        }
    }

    private static class Win
    extends NamedPipeInputStream {
        private static final int ERROR_BROKEN_PIPE = 109;
        private static final int ERROR_BAD_PIPE = 230;
        private static final int ERROR_NO_DATA = 232;
        private static final int ERROR_PIPE_CONNECTED = 535;
        private static final int ERROR_PIPE_LISTENING = 536;
        private static final int ERROR_OPERATION_ABORTED = 995;
        private static final int ERROR_NOT_FOUND = 1168;
        private static final long INVALID_HANDLE_VALUE = -1L;
        private Linker linker;
        private Arena arena;
        private MethodHandle CancelIoEx;
        private MethodHandle CloseHandle;
        private MethodHandle ConnectNamedPipe;
        private static final int PIPE_ACCESS_INBOUND = 1;
        private static final int PIPE_TYPE_BYTE = 0;
        private static final int PIPE_WAIT = 0;
        private static final int PIPE_UNLIMITED_INSTANCES = 255;
        private static final int BUFFER_SIZE = 8192;
        private MethodHandle CreateNamedPipeA;
        private MethodHandle GetLastError;
        private MethodHandle ReadFile;
        private MemorySegment handle;

        private MethodHandle downcallHandle(MemorySegment memorySegment, FunctionDescriptor functionDescriptor) {
            return this.linker.downcallHandle(memorySegment, functionDescriptor, new Linker.Option[0]);
        }

        protected Win(String string) throws IOException {
            super(string);
        }

        @Override
        protected void osStart(String string) throws IOException {
            this.linker = Linker.nativeLinker();
            this.arena = Arena.ofAuto();
            SymbolLookup symbolLookup = SymbolLookup.libraryLookup("kernel32", this.arena);
            try {
                this.CancelIoEx = this.downcallHandle(symbolLookup.findOrThrow("CancelIoEx"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                this.CloseHandle = this.downcallHandle(symbolLookup.findOrThrow("CloseHandle"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
                this.ConnectNamedPipe = this.downcallHandle(symbolLookup.findOrThrow("ConnectNamedPipe"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
                this.CreateNamedPipeA = this.downcallHandle(symbolLookup.findOrThrow("CreateNamedPipeA"), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
                this.GetLastError = this.downcallHandle(symbolLookup.findOrThrow("GetLastError"), FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]));
                this.ReadFile = this.downcallHandle(symbolLookup.findOrThrow("ReadFile"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            this.path = "\\\\.\\pipe\\" + string;
        }

        @Override
        protected void osOpenAndConnect() throws IOException {
            int n;
            if (this.handle == null) {
                try {
                    this.handle = this.CreateNamedPipeA.invoke(this.arena.allocateFrom(this.path), 1, 0, 255, 0, 8192, 0, MemorySegment.NULL);
                    if (this.handle.address() == -1L && (n = this.GetLastError.invoke()) != -1) {
                        this.handle = null;
                        throw new IOException("CreateNamedPipeA returned error code " + n);
                    }
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new IOException("CreateNamedPipeA invocation failed");
                }
            }
            try {
                if (this.ConnectNamedPipe.invoke(this.handle, MemorySegment.NULL) == 0 && (n = this.GetLastError.invoke()) != -1 && n != 0 && n != 232 && n != 535) {
                    if (n == 995) {
                        throw new InterruptedIOException("ConnectNamedPipe aborted");
                    }
                    throw new IOException("ConnectNamedPipe returned error code " + n);
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new IOException("ConnectNamedPipe invocation failed");
            }
        }

        @Override
        protected int osRead(byte[] byArray) throws IOException {
            int n;
            int n2 = byArray.length;
            MemorySegment memorySegment = this.arena.allocate(n2);
            MemorySegment memorySegment2 = this.arena.allocate(ValueLayout.JAVA_INT);
            memorySegment2.set(ValueLayout.JAVA_INT, 0L, 0);
            try {
                for (n = 0; n < 1; n += memorySegment2.get(ValueLayout.JAVA_INT, 0L)) {
                    int n3;
                    memorySegment2.set(ValueLayout.JAVA_INT, 0L, 0);
                    if (this.ReadFile.invoke(this.handle, memorySegment.asSlice(n), n2 - n, memorySegment2, MemorySegment.NULL) == 0 && (n3 = this.GetLastError.invoke()) != -1) {
                        if (this.closed) {
                            throw new IOException("named pipe " + this.path + " closed");
                        }
                        if (n3 == 0 || n3 == 109 || n3 == 536) {
                            return -1;
                        }
                        if (n3 == 995) {
                            throw new InterruptedIOException("ReadFile aborted");
                        }
                        throw new IOException("ReadFile returned error code " + n3);
                    }
                    if (!this.closed) continue;
                    throw new IOException("named pipe " + this.path + " closed");
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new IOException("ReadFile invocation failed");
            }
            System.arraycopy(memorySegment.toArray(ValueLayout.JAVA_BYTE), 0, byArray, 0, n);
            return n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void osUnblock() {
            if (this.connecting || this.reading) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.connecting) {
                    try {
                        int n;
                        if (this.CancelIoEx.invoke(this.handle, MemorySegment.NULL) == 0 && (n = this.GetLastError.invoke()) == -1) {
                            // empty if block
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    for (int i = 0; i < 100 && (this.connecting || this.reading); ++i) {
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.connecting || this.reading) {
                        System.out.println("named pipe " + this.path + " unblocking timeout");
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void osClose() {
            if (this.handle != null) {
                try {
                    int n;
                    if (this.CloseHandle.invoke(this.handle) == 0 && (n = this.GetLastError.invoke()) == -1) {
                        // empty if block
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.handle = null;
            }
        }

        @Override
        protected void osEnd() {
        }
    }
}

