/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ButtonFunction;
import xeij.CRTC;
import xeij.ComponentFactory;
import xeij.Keyboard;
import xeij.LnF;
import xeij.MC68060;
import xeij.MainMemory;
import xeij.Multilingual;
import xeij.Settings;
import xeij.TextCopy;
import xeij.XEiJ;
import xeij.Z8530;

public class Mouse {
    public static final int[] MUS_DEACCELERATION_TABLE = new int[1025];
    public static final String[][] MUS_CURSOR_PATTERN = new String[][]{new String[0], {"00.........", "010........", "0110.......", "01110......", "011110.....", "0111110....", "01111110...", "011111110..", "0111111110.", "01111100000", "0110110....", "010.0110...", "00..0110...", ".....0110..", ".....0110..", "......00..."}};
    public static boolean musSeamlessOn;
    public static boolean musFollowScrollOn;
    public static boolean musExclusiveStart;
    public static boolean musEdgeAccelerationOn;
    public static boolean musHostsPixelUnitsOn;
    public static boolean musButtonLeft;
    public static boolean musButtonRight;
    public static int musData;
    public static int musExtraData;
    public static int musPanelX;
    public static int musPanelY;
    public static int musScreenX;
    public static int musScreenY;
    public static boolean musOnScreen;
    public static boolean musOnKeyboard;
    public static final int MUS_WHEEL_TRACE = 0;
    public static final int MUS_WHEEL_CLICK = 1;
    public static final int MUS_WHEEL_DO_NOTHING = 2;
    public static int musWheelButton;
    public static long musWheelReleaseTime;
    public static boolean musCursorAvailable;
    public static int musCursorNumber;
    public static Cursor[] musCursorArray;
    public static boolean musOutputButtonStatus;
    public static int musNumberOfButtons;
    public static int musLastModifiersEx;
    public static boolean musCtrlRightOn;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int BUTTON3_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON1_MASK = 16;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    public static final int BUTTON4_DOWN_MASK = 16384;
    public static final int BUTTON5_DOWN_MASK = 32768;
    public static final int MUS_SPEED_SCALE_MIN = 0;
    public static final int MUS_SPEED_SCALE_MAX = 40;
    public static final int MUS_SPEED_SCALE_MID = 20;
    public static int musSpeedScaleIndex;
    public static int musSpeedRatioX;
    public static int musSpeedRatioY;
    public static final String[] musSpeedTexts;
    public static JLabel musSpeedLabel;
    public static JSlider musSpeedSlider;
    public static JCheckBoxMenuItem musSeamlessMouseCheckBox;
    public static JCheckBoxMenuItem musFollowScrollCheckBox;
    public static JCheckBoxMenuItem musCtrlRightCheckBox;
    public static JCheckBoxMenuItem musEdgeAccelerationCheckBox;
    public static Box musMouseCursorSpeedBox;
    public static JCheckBoxMenuItem musHostsPixelUnitsCheckBox;

    public static void musInit() {
        int n;
        musSeamlessOn = Settings.sgsGetOnOff("seamless");
        musFollowScrollOn = Settings.sgsGetOnOff("followscroll");
        musCtrlRightOn = Settings.sgsGetOnOff("ctrlright");
        musEdgeAccelerationOn = Settings.sgsGetOnOff("edgeaccel");
        musHostsPixelUnitsOn = Settings.sgsGetOnOff("hostspixelunits");
        musSpeedScaleIndex = Math.max(0, Math.min(40, Settings.sgsGetInt("mousespeed", 20)));
        musExclusiveStart = false;
        musButtonLeft = false;
        musButtonRight = false;
        musData = 0;
        musExtraData = 0;
        musPanelX = 0;
        musPanelY = 0;
        musScreenX = 0;
        musScreenY = 0;
        musOnScreen = false;
        musOnKeyboard = false;
        musWheelButton = 0;
        musWheelReleaseTime = 0L;
        int n2 = 0;
        for (int i = 0; i <= 81; ++i) {
            n = i + 1;
            if (n >= 8) {
                n *= n >> 3;
            }
            n += n >> 2;
            while (n2 < n) {
                Mouse.MUS_DEACCELERATION_TABLE[n2++] = i;
            }
        }
        musCursorAvailable = false;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getBestCursorSize(16, 16);
            n = dimension.width;
            int n3 = dimension.height;
            if (n >= 16 && n3 >= 16) {
                BufferedImage bufferedImage = new BufferedImage(n, n3, 2);
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                Point point = new Point(0, 0);
                musCursorArray = new Cursor[MUS_CURSOR_PATTERN.length];
                for (int i = 0; i < MUS_CURSOR_PATTERN.length; ++i) {
                    String[] stringArray = MUS_CURSOR_PATTERN[i];
                    int n4 = stringArray.length;
                    for (int j = 0; j < n3; ++j) {
                        String string = j < n4 ? stringArray[j] : "";
                        int n5 = string.length();
                        for (int k = 0; k < n; ++k) {
                            int n6 = k < n5 ? (int)string.charAt(k) : 46;
                            nArray[k + n * j] = 0xFF000000 & 46 - n6 | -(n6 & 1);
                        }
                    }
                    Mouse.musCursorArray[i] = toolkit.createCustomCursor(bufferedImage, point, "XEiJ_" + i);
                }
                musCursorAvailable = true;
                musCursorNumber = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        musOutputButtonStatus = false;
        musNumberOfButtons = -1;
        try {
            musNumberOfButtons = MouseInfo.getNumberOfButtons();
        }
        catch (Exception exception) {
            // empty catch block
        }
        musLastModifiersEx = 0;
        for (int i = 0; i <= 40; ++i) {
            Mouse.musSpeedTexts[i - 0] = String.format("%4.2f", Math.pow(4.0, (double)(i - 20) / 20.0));
        }
        musSpeedLabel = ComponentFactory.createLabel(musSpeedTexts[20]);
        musSpeedSlider = ComponentFactory.setEnabled(ComponentFactory.setPreferredSize(ComponentFactory.createHorizontalSlider(0, 40, musSpeedScaleIndex, 10, 1, musSpeedTexts, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Mouse.musSetSpeedScaleIndex(((JSlider)changeEvent.getSource()).getValue());
            }
        }), LnF.lnfFontSize * 18, LnF.lnfFontSize * 2 + 28), XEiJ.rbtRobot != null);
        Mouse.musSetSpeedScaleIndex(musSpeedScaleIndex);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Seamless mouse": {
                        Mouse.musSetSeamlessOn(((JCheckBoxMenuItem)object).isSelected());
                        break;
                    }
                    case "Follow scroll": {
                        musFollowScrollOn = ((JCheckBoxMenuItem)object).isSelected();
                        break;
                    }
                    case "Ctrl-key + left-button = right-button": {
                        musCtrlRightOn = ((JCheckBoxMenuItem)object).isSelected();
                        break;
                    }
                    case "Edge acceleration": {
                        Mouse.musSetEdgeAccelerationOn(((JCheckBoxMenuItem)object).isSelected());
                        break;
                    }
                    case "Use host's pixel units": {
                        Mouse.musSetHostsPixelUnitsOn(((JCheckBoxMenuItem)object).isSelected());
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        musSeamlessMouseCheckBox = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(musSeamlessOn, "Seamless mouse", actionListener), "ja", "\u30b7\u30fc\u30e0\u30ec\u30b9\u30de\u30a6\u30b9"), XEiJ.rbtRobot != null);
        musFollowScrollCheckBox = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(musFollowScrollOn, "Follow scroll", actionListener), "ja", "\u30b9\u30af\u30ed\u30fc\u30eb\u306b\u8ffd\u5f93\u3059\u308b"), XEiJ.rbtRobot != null);
        musCtrlRightCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(musCtrlRightOn, "Ctrl-key + left-button = right-button", actionListener), "ja", "Ctrl \u30ad\u30fc\uff0b\u5de6\u30dc\u30bf\u30f3\uff1d\u53f3\u30dc\u30bf\u30f3");
        musEdgeAccelerationCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(musEdgeAccelerationOn, "Edge acceleration", actionListener), "ja", "\u7e01\u90e8\u52a0\u901f");
        musMouseCursorSpeedBox = ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel("Mouse cursor speed "), "ja", "\u30de\u30a6\u30b9\u30ab\u30fc\u30bd\u30eb\u306e\u901f\u5ea6 "), musSpeedLabel, Box.createHorizontalGlue());
        musHostsPixelUnitsCheckBox = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(musHostsPixelUnitsOn, "Use host's pixel units", actionListener), "ja", "\u30db\u30b9\u30c8\u306e\u753b\u7d20\u5358\u4f4d\u3092\u4f7f\u3046"), XEiJ.rbtRobot != null);
    }

    public static void musTini() {
        Settings.sgsPutOnOff("seamless", musSeamlessOn);
        Settings.sgsPutOnOff("followscroll", musFollowScrollOn);
        Settings.sgsPutOnOff("ctrlright", musCtrlRightOn);
        Settings.sgsPutOnOff("edgeaccel", musEdgeAccelerationOn);
        Settings.sgsPutOnOff("hostspixelunits", musHostsPixelUnitsOn);
        Settings.sgsPutInt("mousespeed", musSpeedScaleIndex, 20);
    }

    public static void musSetSpeedScaleIndex(int n) {
        musSpeedScaleIndex = n;
        musSpeedLabel.setText(musSpeedTexts[n]);
        Mouse.musUpdateSpeedRatio();
    }

    public static void musUpdateSpeedRatio() {
        double d = Math.pow(4.0, (double)(musSpeedScaleIndex - 20) / 20.0);
        if (musHostsPixelUnitsOn) {
            musSpeedRatioX = (int)(65536.0 * d * (double)XEiJ.pnlScreenWidth / (double)XEiJ.pnlZoomWidth);
            musSpeedRatioY = (int)(65536.0 * d * (double)XEiJ.pnlScreenHeight / (double)XEiJ.pnlZoomHeight);
        } else {
            musSpeedRatioX = (int)(65536.0 * d);
            musSpeedRatioY = (int)(65536.0 * d);
        }
    }

    public static void musStart() {
        ComponentFactory.addListener(XEiJ.pnlCanvasOrPanel, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (musOutputButtonStatus) {
                    int n = mouseEvent.getModifiersEx();
                    if ((n & 0x400) != 0) {
                        System.out.println(String.format("mouse button %d/%d was clicked. (0x%08x)", 1, musNumberOfButtons, n));
                    }
                    if ((n & 0x800) != 0) {
                        System.out.println(String.format("mouse button %d/%d was clicked. (0x%08x)", 2, musNumberOfButtons, n));
                    }
                    if ((n & 0x1000) != 0) {
                        System.out.println(String.format("mouse button %d/%d was clicked. (0x%08x)", 3, musNumberOfButtons, n));
                    }
                    if ((n & 0x4000) != 0) {
                        System.out.println(String.format("mouse button %d/%d was clicked. (0x%08x)", 4, musNumberOfButtons, n));
                    }
                    if ((n & 0x8000) != 0) {
                        System.out.println(String.format("mouse button %d/%d was clicked. (0x%08x)", 5, musNumberOfButtons, n));
                    }
                    if ((n & 0xDC00) == 0) {
                        System.out.println(String.format("mouse button ?/%d was clicked. (0x%08x)", musNumberOfButtons, n));
                    }
                }
                if (!XEiJ.pnlCanvasOrPanel.isFocusOwner()) {
                    XEiJ.pnlCanvasOrPanel.requestFocusInWindow();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (musOnScreen) {
                    musOnScreen = false;
                }
                if (musOnKeyboard) {
                    musOnKeyboard = false;
                    if (Keyboard.kbdPointedIndex >= 0) {
                        Keyboard.kbdHover(0, 0);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Mouse.musPressedOrReleased(mouseEvent, true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Mouse.musPressedOrReleased(mouseEvent, false);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Mouse.musDraggedOrMoved(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Mouse.musDraggedOrMoved(mouseEvent);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2 = mouseWheelEvent.getModifiersEx();
                if (musOutputButtonStatus) {
                    double d = mouseWheelEvent.getPreciseWheelRotation();
                    int n3 = mouseWheelEvent.getScrollAmount();
                    int n4 = mouseWheelEvent.getScrollType();
                    int n5 = mouseWheelEvent.getUnitsToScroll();
                    int n6 = mouseWheelEvent.getWheelRotation();
                    System.out.println(String.format("mouse wheel moved (0x%08x)", n2));
                    System.out.println(String.format("  preciseWheelRotation = %f", d));
                    System.out.println(String.format("  scrollAmount = %d", n3));
                    System.out.println(String.format("  scrollType = %d", n4));
                    System.out.println(String.format("  unitsToScroll = %d", n5));
                    System.out.println(String.format("  wheelRotation = %d", n6));
                }
                if (0 < (n = mouseWheelEvent.getWheelRotation())) {
                    ButtonFunction.bfnExecute(ButtonFunction.Button.WHEELUP, n2, true, null);
                } else if (n < 0) {
                    ButtonFunction.bfnExecute(ButtonFunction.Button.WHEELDOWN, n2, true, null);
                }
                mouseWheelEvent.consume();
            }
        });
    }

    public static void musPressedOrReleased(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getModifiersEx();
        int n2 = ~musLastModifiersEx & n;
        int n3 = musLastModifiersEx & ~n;
        musLastModifiersEx = n;
        if (musOutputButtonStatus) {
            if ((n2 & 0x400) != 0) {
                System.out.println(String.format("mouse button %d/%d was pressed. (0x%08x)", 1, musNumberOfButtons, n));
            } else if ((n3 & 0x400) != 0) {
                System.out.println(String.format("mouse button %d/%d was released. (0x%08x)", 1, musNumberOfButtons, n));
            }
            if ((n2 & 0x800) != 0) {
                System.out.println(String.format("mouse button %d/%d was pressed. (0x%08x)", 2, musNumberOfButtons, n));
            } else if ((n3 & 0x800) != 0) {
                System.out.println(String.format("mouse button %d/%d was released. (0x%08x)", 2, musNumberOfButtons, n));
            }
            if ((n2 & 0x1000) != 0) {
                System.out.println(String.format("mouse button %d/%d was pressed. (0x%08x)", 3, musNumberOfButtons, n));
            } else if ((n3 & 0x1000) != 0) {
                System.out.println(String.format("mouse button %d/%d was released. (0x%08x)", 3, musNumberOfButtons, n));
            }
            if ((n2 & 0x4000) != 0) {
                System.out.println(String.format("mouse button %d/%d was pressed. (0x%08x)", 4, musNumberOfButtons, n));
            } else if ((n3 & 0x4000) != 0) {
                System.out.println(String.format("mouse button %d/%d was released. (0x%08x)", 4, musNumberOfButtons, n));
            }
            if ((n2 & 0x8000) != 0) {
                System.out.println(String.format("mouse button %d/%d was pressed. (0x%08x)", 5, musNumberOfButtons, n));
            } else if ((n3 & 0x8000) != 0) {
                System.out.println(String.format("mouse button %d/%d was released. (0x%08x)", 5, musNumberOfButtons, n));
            }
            if (((n2 | n3) & 0xDC00) == 0) {
                System.out.println(String.format("mouse button ?/%d was %s. (0x%08x)", musNumberOfButtons, bl ? "pressed" : "released", n));
            }
        }
        if (musCtrlRightOn && (n & 0x80) != 0) {
            if ((n2 & 0x400) != 0) {
                n2 = n2 & 0xFFFFFBFF | 0x1000;
            }
            if ((n3 & 0x400) != 0) {
                n3 = n3 & 0xFFFFFBFF | 0x1000;
            }
        }
        if ((n2 & 0x400) != 0) {
            musButtonLeft = true;
            if (musOnScreen && (musSeamlessOn || XEiJ.frmIsActive)) {
                musData |= 1;
                musExtraData |= 1;
            } else {
                musData &= 0xFFFFFFFE;
            }
        } else if ((n3 & 0x400) != 0) {
            musButtonLeft = false;
            musData &= 0xFFFFFFFE;
        }
        if (musNumberOfButtons < 3) {
            if ((n2 & 0x1800) != 0) {
                if ((n & 0x200) != 0) {
                    Mouse.musSetSeamlessOn(!musSeamlessOn);
                } else {
                    musButtonRight = true;
                    if (musOnScreen && (musSeamlessOn || XEiJ.frmIsActive)) {
                        musData |= 2;
                        musExtraData |= 2;
                    } else {
                        musData &= 0xFFFFFFFD;
                    }
                }
            } else if ((n3 & 0x1800) != 0) {
                musButtonRight = false;
                musData &= 0xFFFFFFFD;
            }
        } else {
            if ((n2 & 0x800) != 0) {
                ButtonFunction.bfnExecute(ButtonFunction.Button.WHEEL, n, true, null);
            } else if ((n3 & 0x800) != 0) {
                ButtonFunction.bfnExecute(ButtonFunction.Button.WHEEL, n, false, null);
            }
            if ((n2 & 0x1000) != 0) {
                musButtonRight = true;
                if (musOnScreen && (musSeamlessOn || XEiJ.frmIsActive)) {
                    musData |= 2;
                    musExtraData |= 2;
                } else {
                    musData &= 0xFFFFFFFD;
                }
            } else if ((n3 & 0x1000) != 0) {
                musButtonRight = false;
                musData &= 0xFFFFFFFD;
            }
            if (4 <= musNumberOfButtons) {
                if ((n2 & 0x4000) != 0) {
                    ButtonFunction.bfnExecute(ButtonFunction.Button.BUTTON4, n, true, null);
                } else if ((n3 & 0x4000) != 0) {
                    ButtonFunction.bfnExecute(ButtonFunction.Button.BUTTON4, n, false, null);
                }
                if (5 <= musNumberOfButtons) {
                    if ((n2 & 0x8000) != 0) {
                        ButtonFunction.bfnExecute(ButtonFunction.Button.BUTTON5, n, true, null);
                    } else if ((n3 & 0x8000) != 0) {
                        ButtonFunction.bfnExecute(ButtonFunction.Button.BUTTON5, n, false, null);
                    }
                }
            }
        }
        Mouse.musDraggedOrMovedSub(mouseEvent);
        if (TextCopy.txcEncloseEachTime && musOnScreen) {
            if ((n2 & 0x400) != 0) {
                TextCopy.txcMousePressed(musScreenX, musScreenY);
            } else if ((n3 & 0x400) != 0) {
                TextCopy.txcMouseReleased(musScreenX, musScreenY);
            }
        }
    }

    public static void musDraggedOrMoved(MouseEvent mouseEvent) {
        Mouse.musDraggedOrMovedSub(mouseEvent);
        if (TextCopy.txcEncloseEachTime && musOnScreen) {
            TextCopy.txcMouseMoved(musScreenX, musScreenY);
        }
    }

    public static void musDraggedOrMovedSub(MouseEvent mouseEvent) {
        int n = musPanelX = mouseEvent.getX();
        int n2 = musPanelY = mouseEvent.getY();
        if (XEiJ.PNL_ROTATION_ON) {
            if (XEiJ.pnlScreenX1 <= n && n < XEiJ.pnlScreenX2 && XEiJ.pnlScreenY1 <= n2 && n2 < XEiJ.pnlScreenY2) {
                musOnScreen = true;
                musScreenX = (int)Math.round(XEiJ.pnlInverseL00 * (double)n + XEiJ.pnlInverseL01 * (double)n2 + XEiJ.pnlInverseL02);
                musScreenY = (int)Math.round(XEiJ.pnlInverseL10 * (double)n + XEiJ.pnlInverseL11 * (double)n2 + XEiJ.pnlInverseL12);
            } else if (XEiJ.pnlScreenX3 <= n && n < XEiJ.pnlScreenX4 && XEiJ.pnlScreenY3 <= n2 && n2 < XEiJ.pnlScreenY4) {
                musOnScreen = true;
                musScreenX = (int)Math.round(XEiJ.pnlInverseR00 * (double)n + XEiJ.pnlInverseR01 * (double)n2 + XEiJ.pnlInverseR02);
                musScreenY = (int)Math.round(XEiJ.pnlInverseR10 * (double)n + XEiJ.pnlInverseR11 * (double)n2 + XEiJ.pnlInverseR12);
            } else {
                musOnScreen = false;
            }
        } else if (XEiJ.pnlScreenX1 <= n && n < XEiJ.pnlScreenX1 + XEiJ.pnlZoomWidth && XEiJ.pnlScreenY1 <= n2 && n2 < XEiJ.pnlScreenY1 + XEiJ.pnlZoomHeight) {
            musOnScreen = true;
            musScreenX = (n - XEiJ.pnlScreenX1) * XEiJ.pnlZoomRatioInX >> 16;
            musScreenY = (n2 - XEiJ.pnlScreenY1) * XEiJ.pnlZoomRatioInY >> 16;
            if (CRTC.crtDuplication) {
                musScreenY >>= 1;
            }
        } else {
            musOnScreen = false;
        }
        if (XEiJ.pnlKeyboardX <= n && n < XEiJ.pnlKeyboardX + Keyboard.kbdWidth && XEiJ.pnlKeyboardY <= n2 && n2 < XEiJ.pnlKeyboardY + Keyboard.kbdHeight) {
            musOnKeyboard = true;
            Keyboard.kbdHover(n - XEiJ.pnlKeyboardX, n2 - XEiJ.pnlKeyboardY);
        } else if (musOnKeyboard) {
            musOnKeyboard = false;
            if (Keyboard.kbdPointedIndex >= 0) {
                Keyboard.kbdHover(0, 0);
            }
        }
    }

    public static void musSetSeamlessOn(boolean bl) {
        if (XEiJ.rbtRobot == null) {
            return;
        }
        if (musSeamlessOn != bl) {
            musSeamlessOn = bl;
            if (bl) {
                int n;
                int n2;
                Mouse.musShow();
                if (XEiJ.currentMPU < 6) {
                    if (Z8530.sccFSXMouseHook != 0 && MainMemory.mmrRls(2360) == Z8530.sccFSXMouseHook) {
                        int n3 = MainMemory.mmrRls(Z8530.sccFSXMouseWork + 10);
                        n2 = (n3 >> 16) - CRTC.crtR10TxXPort;
                        n = (short)n3 - CRTC.crtR11TxYPort;
                    } else {
                        int n4 = MainMemory.mmrRls(2766);
                        n2 = n4 >> 16;
                        n = n4;
                        if (musFollowScrollOn) {
                            n2 -= CRTC.crtR10TxXPort;
                            n -= CRTC.crtR11TxYPort;
                        }
                    }
                } else if (Z8530.sccFSXMouseHook != 0 && MC68060.mmuPeekLongData(2360, 1) == Z8530.sccFSXMouseHook) {
                    int n5 = MC68060.mmuPeekLongData(Z8530.sccFSXMouseWork + 10, 1);
                    n2 = (n5 >> 16) - CRTC.crtR10TxXPort;
                    n = (short)n5 - CRTC.crtR11TxYPort;
                } else {
                    int n6 = MC68060.mmuPeekLongData(2766, 1);
                    n2 = n6 >> 16;
                    n = (short)n6;
                    if (musFollowScrollOn) {
                        n2 -= CRTC.crtR10TxXPort;
                        n -= CRTC.crtR11TxYPort;
                    }
                }
                if (XEiJ.PNL_ROTATION_ON) {
                    XEiJ.rbtRobot.mouseMove(XEiJ.pnlGlobalX + (int)Math.round(XEiJ.pnlMatrixL00 * (double)n2 + XEiJ.pnlMatrixL01 * (double)n + XEiJ.pnlMatrixL02), XEiJ.pnlGlobalY + (int)Math.round(XEiJ.pnlMatrixL10 * (double)n2 + XEiJ.pnlMatrixL11 * (double)n + XEiJ.pnlMatrixL12));
                } else {
                    XEiJ.rbtRobot.mouseMove(n2 * XEiJ.pnlZoomWidth / XEiJ.pnlScreenWidth + XEiJ.pnlScreenX1 + XEiJ.pnlGlobalX, n * XEiJ.pnlZoomHeight / XEiJ.pnlScreenHeight + XEiJ.pnlScreenY1 + XEiJ.pnlGlobalY);
                }
            } else {
                Mouse.musHide();
                Point point = XEiJ.pnlCanvasOrPanel.getLocationOnScreen();
                XEiJ.pnlGlobalX = point.x;
                XEiJ.pnlGlobalY = point.y;
                musExclusiveStart = true;
            }
        }
        if (musSeamlessMouseCheckBox.isSelected() != bl) {
            musSeamlessMouseCheckBox.setSelected(bl);
        }
    }

    public static void musHide() {
        if (musCursorNumber != 0 && musCursorAvailable) {
            musCursorNumber = 0;
            XEiJ.pnlPanel.setCursor(musCursorArray[0]);
        }
    }

    public static void musShow() {
        if (musCursorNumber != 1 && musCursorAvailable) {
            musCursorNumber = 1;
            XEiJ.pnlPanel.setCursor(musCursorArray[1]);
        }
    }

    public static void musSetEdgeAccelerationOn(boolean bl) {
        musEdgeAccelerationOn = bl;
    }

    public static void musSetHostsPixelUnitsOn(boolean bl) {
        musHostsPixelUnitsOn = bl;
        Mouse.musUpdateSpeedRatio();
    }

    static {
        musSpeedTexts = new String[41];
    }
}

