/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import xeij.HD63450;
import xeij.Settings;
import xeij.SoundSource;
import xeij.TickerQueue;
import xeij.XEiJ;

public class MercuryUnit {
    public static final boolean MU4_ON = true;
    public static boolean mu4OnRequest;
    public static boolean mu4On;
    public static boolean mu4OnPositive;
    public static boolean mu4OnNegative;
    public static boolean mu4OutputEnable;
    public static final boolean MU4_DEBUG = false;
    public static final int[] mu4Buffer;
    static final int MU4_U_RESERVED = 57344;
    static final int MU4_U12_TERR = 4096;
    static final int MU4_U11_EXPCL = 2048;
    static final int MU4_U10_EXREQ = 1024;
    static final int MU4_U9_M256 = 512;
    static final int MU4_U8_ACKIG = 256;
    static final int MU4_U7_CLKRATE = 128;
    static final int MU4_U6_INSEL = 64;
    static final int MU4_U54_CLKSEL = 48;
    static final int MU4_U54_32K = 16;
    static final int MU4_U54_48K = 48;
    static final int MU4_C3_RG = 8;
    static final int MU4_C2_LG = 4;
    static final int MU4_C1_STEREO = 2;
    static final int MU4_C0_OUT = 1;
    static final int MU4_S3_N32K = 8;
    static final int MU4_S2_N44K = 4;
    static final int MU4_S1_N48K = 2;
    static final int MU4_S0_ERR = 1;
    static int mu4PortUpper;
    static int mu4PortCommand;
    static int mu4PortStatus;
    static final int MU4_MODE_M256 = 0;
    static final int MU4_MODE_OUT = 1;
    static final int MU4_MODE_IN = 2;
    static int mu4Mode;
    static boolean mu4EnablePclReq;
    static int mu4DataFrequency;
    static int mu4DataCycles;
    static int mu4DataRate;
    static int mu4DataChannels;
    static final int MU4_BLOCK_RATE = 25;
    static int mu4DataFrames;
    static final int MU4_LINE_RATE = 62500;
    static final int MU4_LINE_CHANNELS = 2;
    static final int MU4_LINE_FRAMES = 2500;
    static final int MU4_LINE_ELEMENTS = 5000;
    static final int MU4_FALL_EXPCL = 0;
    static final int MU4_RISE_EXPCL = 1;
    static final int MU4_FALL_EXREQ = 2;
    static final int MU4_RISE_EXREQ = 3;
    static final int[] MU4_M256_LOW_MONO;
    static final int[] MU4_M256_LOW_STEREO;
    static final int[] MU4_M256_HIGH_MONO;
    static final int[] MU4_M256_HIGH_STEREO;
    static final int[] MU4_OUT_LOW_MONO;
    static final int[] MU4_OUT_LOW_STEREO;
    static final int[] MU4_OUT_HIGH_MONO;
    static final int[] MU4_OUT_HIGH_STEREO;
    static int[] mu4SequenceArray;
    static final long MU4_BLOCK_TIME = 40000000000L;
    static long mu4BlockTime;
    static int mu4FrameNumber;
    static int mu4SequenceIndex;
    static int mu4LRCounter;
    static int mu4WritePointer;
    static final int[] mu4DataArray;
    static boolean mu4DataWritten;
    static long mu4SequenceTime;
    static final TickerQueue.Ticker mu4SequenceTicker;
    static Hermite mu4Hermite640;
    static Hermite mu4Hermite882;
    static Hermite mu4Hermite960;
    static Hermite mu4Hermite1280;
    static Hermite mu4Hermite1764;
    static Hermite mu4Hermite1920;
    static final float MU4_DECAY_RATIO = 0.97f;
    static final int MU4_ATTACK_FRAMES = 300;
    static final float[] mu4AttackArray;
    static int mu4AttackIndexLeft;
    static int mu4AttackIndexRight;
    static boolean mu4NaiKamoLeft;
    static boolean mu4NaiKamoRight;
    static boolean mu4NaiDesuLeft;
    static boolean mu4NaiDesuRight;

    public static void mu4Init() {
        mu4OnRequest = Settings.sgsGetOnOff("mercury");
        mu4OutputEnable = Settings.sgsGetOnOff("mercuryoe");
        mu4Hermite640 = new Hermite(640, 2500);
        mu4Hermite882 = new Hermite(882, 2500);
        mu4Hermite960 = new Hermite(960, 2500);
        mu4Hermite1280 = new Hermite(1280, 2500);
        mu4Hermite1764 = new Hermite(1764, 2500);
        mu4Hermite1920 = new Hermite(1920, 2500);
        for (int i = 0; i <= 300; ++i) {
            MercuryUnit.mu4AttackArray[i] = (float)((1.0 + Math.sin(Math.PI * (double)(i - 150) / 300.0)) / 2.0);
        }
    }

    public static void mu4Tini() {
        Settings.sgsPutOnOff("mercury", mu4OnRequest);
        Settings.sgsPutOnOff("mercuryoe", mu4OutputEnable);
    }

    public static void mu4Reset() {
        mu4On = mu4OnRequest;
        mu4OnPositive = mu4On && !XEiJ.specifiedModel.isShodai();
        mu4OnNegative = mu4On && XEiJ.specifiedModel.isShodai();
        mu4PortUpper = 61504;
        mu4PortCommand = 0;
        mu4PortStatus = 14;
        mu4EnablePclReq = true;
        MercuryUnit.mu4RiseExpcl();
        MercuryUnit.mu4RiseExreq();
        mu4EnablePclReq = false;
        mu4SequenceArray = null;
        Arrays.fill(mu4Buffer, 0);
        TickerQueue.tkqRemove(mu4SequenceTicker);
        mu4PortCommand = -1;
        MercuryUnit.mu4SetCommand(64576);
    }

    public static int mu4ReadByte(int n) {
        int n2 = n & 0x70;
        int n3 = 0;
        if (n2 == 16) {
            n3 = (n & 1) == 0 ? mu4PortUpper >> 8 : (mu4PortUpper | mu4PortCommand) & 0xFF;
        } else if (n2 == 32) {
            n3 = (n & 1) == 0 ? mu4PortUpper >> 8 : (mu4PortUpper | mu4PortStatus) & 0xFF;
        }
        return n3;
    }

    public static int mu4ReadWord(int n) {
        int n2 = n & 0x70;
        int n3 = 0;
        if (n2 == 16) {
            n3 = mu4PortUpper | mu4PortCommand;
        } else if (n2 == 32) {
            n3 = mu4PortUpper | mu4PortStatus;
        }
        return n3;
    }

    public static void mu4WriteByte(int n, int n2) {
        n2 &= 0xFF;
        int n3 = n & 0x70;
        if (n3 == 16) {
            int n4 = mu4PortUpper | mu4PortCommand;
            if ((n & 1) == 0) {
                MercuryUnit.mu4SetCommand(n2 << 8 | n4 & 0xFF);
            } else {
                MercuryUnit.mu4SetCommand(n4 & 0xFF00 | n2);
            }
        }
    }

    public static void mu4WriteWord(int n, int n2) {
        n2 &= 0xFFFF;
        int n3 = n & 0x70;
        if (n3 == 0 && mu4Mode == 1 && mu4OutputEnable && 0 <= mu4WritePointer) {
            if ((mu4DataChannels == 1 || (mu4WritePointer & 1) == 0) && (mu4PortCommand & 4) != 0) {
                mu4NaiKamoLeft = false;
                if (mu4NaiDesuLeft) {
                    mu4NaiDesuLeft = false;
                    mu4AttackIndexLeft = 1;
                }
                MercuryUnit.mu4DataArray[MercuryUnit.mu4WritePointer] = Math.round(mu4AttackArray[mu4AttackIndexLeft] * (float)((short)n2));
                mu4AttackIndexLeft = Math.min(300, mu4AttackIndexLeft + 1);
            }
            if ((mu4DataChannels == 1 || (mu4WritePointer & 1) != 0) && (mu4PortCommand & 8) != 0) {
                mu4NaiKamoRight = false;
                if (mu4NaiDesuRight) {
                    mu4NaiDesuRight = false;
                    mu4AttackIndexRight = 1;
                }
                MercuryUnit.mu4DataArray[MercuryUnit.mu4WritePointer + (2 - MercuryUnit.mu4DataChannels)] = Math.round(mu4AttackArray[mu4AttackIndexRight] * (float)((short)n2));
                mu4AttackIndexRight = Math.min(300, mu4AttackIndexRight + 1);
            }
            mu4DataWritten = true;
        } else if (n3 == 16) {
            MercuryUnit.mu4SetCommand(n2);
        }
    }

    public static void mu4HsyncStart(long l) {
        if (mu4Mode != 0) {
            return;
        }
        int[] nArray = mu4DataChannels == 1 ? (mu4DataRate < 32000 ? MU4_M256_LOW_MONO : MU4_M256_HIGH_MONO) : (mu4SequenceArray = mu4DataRate < 32000 ? MU4_M256_LOW_STEREO : MU4_M256_HIGH_STEREO);
        if (mu4SequenceArray == MU4_M256_LOW_STEREO && (mu4PortUpper & 0x30) == 16) {
            mu4SequenceArray = MU4_M256_LOW_MONO;
        }
        mu4BlockTime = l;
        mu4FrameNumber = 0;
        mu4SequenceIndex = 0;
        mu4SequenceTime = mu4BlockTime + (long)mu4SequenceArray[mu4SequenceIndex++] * 1000000000000L / (long)mu4DataFrequency;
        TickerQueue.tkqAdd(mu4SequenceTicker, mu4SequenceTime);
    }

    public static void mu4ExackStart() {
        if ((mu4PortUpper & 0x100) != 0) {
            MercuryUnit.mu4RiseExreq();
        }
    }

    public static void mu4FillBuffer() {
        if (mu4Mode != 1) {
            return;
        }
        mu4SequenceTime = (mu4BlockTime += 40000000000L) + (long)(mu4DataCycles * (mu4FrameNumber -= mu4DataFrames) + mu4SequenceArray[mu4SequenceIndex - 1]) * 1000000000000L / (long)mu4DataFrequency;
        TickerQueue.tkqAdd(mu4SequenceTicker, mu4SequenceTime);
        if (!mu4DataWritten) {
            Arrays.fill(mu4Buffer, 0);
            return;
        }
        mu4DataWritten = false;
        switch (mu4DataFrames) {
            case 640: {
                mu4Hermite640.convert();
                break;
            }
            case 882: {
                mu4Hermite882.convert();
                break;
            }
            case 960: {
                mu4Hermite960.convert();
                break;
            }
            case 1280: {
                mu4Hermite1280.convert();
                break;
            }
            case 1764: {
                mu4Hermite1764.convert();
                break;
            }
            case 1920: {
                mu4Hermite1920.convert();
            }
        }
        for (int i = 0; i < 8; ++i) {
            MercuryUnit.mu4DataArray[i] = mu4DataArray[2 * mu4DataFrames + i];
            mu4DataWritten = mu4DataWritten || mu4DataArray[i] != 0;
        }
        Arrays.fill(mu4DataArray, 8, 2 * (mu4DataFrames + 4), 0);
    }

    static void mu4DumpVars() {
        System.out.printf("mu4Mode=%d\n", mu4Mode);
        System.out.printf("mu4EnablePclReq=%b\n", mu4EnablePclReq);
        System.out.printf("mu4DataFrequency=%d\n", mu4DataFrequency);
        System.out.printf("mu4DataCycles=%d\n", mu4DataCycles);
        System.out.printf("mu4DataRate=%d\n", mu4DataRate);
        System.out.printf("mu4DataChannels=%d\n", mu4DataChannels);
        System.out.printf("mu4DataFrames=%d\n", mu4DataFrames);
        System.out.printf("mu4BlockTime=%d\n", mu4BlockTime);
        System.out.printf("mu4FrameNumber=%d\n", mu4FrameNumber);
        System.out.printf("mu4SequenceIndex=%d\n", mu4SequenceIndex);
        System.out.printf("mu4LRCounter=%d\n", mu4LRCounter);
        System.out.printf("mu4WritePointer=%d\n", mu4WritePointer);
        System.out.printf("mu4DataWritten=%b\n", mu4DataWritten);
    }

    static void mu4SetCommand(int n) {
        int n2 = mu4Mode;
        int n3 = mu4DataRate;
        int n4 = mu4DataChannels;
        int n5 = mu4PortUpper;
        int n6 = mu4PortCommand;
        mu4PortUpper = mu4PortUpper & 0xFC00 | n & 0x3F0;
        mu4PortCommand = n & 0xF;
        boolean bl = mu4EnablePclReq = (mu4PortUpper & 0x300) != 0;
        if ((((mu4PortUpper | mu4PortCommand) ^ (n5 | n6)) & 0xFF) == 0) {
            return;
        }
        int n7 = (mu4PortUpper & 0x200) == 0 ? 0 : (mu4Mode = (mu4PortCommand & 1) != 0 ? 1 : 2);
        mu4DataFrequency = (mu4PortUpper & 0x30) == 16 ? 0xBB8000 : ((mu4PortUpper & 0x30) != 48 ? 16934400 : 18432000);
        mu4DataCycles = (mu4PortUpper & 0x80) == 0 ? 768 : 384;
        mu4DataRate = mu4DataFrequency / mu4DataCycles;
        int n8 = mu4DataChannels = (mu4PortCommand & 2) == 0 ? 1 : 2;
        if (mu4Mode != n2 || mu4DataRate != n3 || mu4DataChannels != n4) {
            if (mu4Mode == 0) {
                mu4SequenceArray = null;
            } else if (mu4Mode == 1) {
                mu4DataFrames = mu4DataRate / 25;
                mu4SequenceArray = mu4DataChannels == 1 ? (mu4DataRate < 32000 ? MU4_OUT_LOW_MONO : MU4_OUT_HIGH_MONO) : (mu4DataRate < 32000 ? MU4_OUT_LOW_STEREO : MU4_OUT_HIGH_STEREO);
                mu4BlockTime = SoundSource.sndBlockClock - 40000000000L;
                mu4FrameNumber = Math.max(0, Math.min(mu4DataFrames, (int)(((XEiJ.mpuClockTime - mu4BlockTime) * (long)mu4DataFrames + 39999999999L) / 40000000000L)));
                mu4SequenceIndex = 0;
                mu4LRCounter = 0;
                mu4WritePointer = -1;
                if (mu4DataRate != n3 || mu4DataChannels != n4) {
                    Arrays.fill(mu4DataArray, 0, 2 * (mu4DataFrames + 4), 0);
                }
                mu4DataWritten = false;
                mu4AttackIndexLeft = 1;
                mu4AttackIndexRight = 1;
                mu4NaiKamoLeft = true;
                mu4NaiKamoRight = true;
                mu4NaiDesuLeft = true;
                mu4NaiDesuRight = true;
                mu4SequenceTime = mu4BlockTime + (long)(mu4DataCycles * mu4FrameNumber + mu4SequenceArray[mu4SequenceIndex++]) * 1000000000000L / (long)mu4DataFrequency;
                TickerQueue.tkqAdd(mu4SequenceTicker, mu4SequenceTime);
            } else {
                mu4SequenceArray = null;
            }
        }
    }

    static void mu4FallExpcl() {
        if ((mu4PortUpper & 0x800) != 0) {
            mu4PortUpper &= 0xFFFFF7FF;
            if (mu4EnablePclReq) {
                HD63450.dmaFallPCL(2);
            }
        }
    }

    static void mu4RiseExpcl() {
        if ((mu4PortUpper & 0x800) == 0) {
            mu4PortUpper |= 0x800;
            if (mu4EnablePclReq) {
                HD63450.dmaRisePCL(2);
            }
        }
    }

    static void mu4FallExreq(long l) {
        if ((mu4PortUpper & 0x400) != 0) {
            mu4PortUpper &= 0xFFFFFBFF;
            if (mu4EnablePclReq) {
                HD63450.dmaFallREQ(2, l);
            }
        }
    }

    static void mu4RiseExreq() {
        if ((mu4PortUpper & 0x400) == 0) {
            mu4PortUpper |= 0x400;
            if (mu4EnablePclReq) {
                HD63450.dmaRiseREQ(2);
            }
        }
    }

    static {
        mu4Buffer = new int[5000];
        MU4_M256_LOW_MONO = new int[]{2, 0, 20, 2, 283, 3, 385, 1};
        MU4_M256_LOW_STEREO = new int[]{2, 0, 283, 3, 385, 1, 404, 2};
        MU4_M256_HIGH_MONO = new int[]{2, 0, 10, 2, 142, 3, 193, 1};
        MU4_M256_HIGH_STEREO = new int[]{2, 0, 10, 2, 142, 3, 193, 1, 202, 2, 334, 3};
        MU4_OUT_LOW_MONO = new int[]{0, 0, 379, 2, 384, 1, 667, 3};
        MU4_OUT_LOW_STEREO = new int[]{0, 0, 283, 3, 379, 2, 384, 1, 667, 3, 763, 2};
        MU4_OUT_HIGH_MONO = new int[]{0, 0, 190, 2, 192, 1, 334, 3};
        MU4_OUT_HIGH_STEREO = new int[]{0, 0, 142, 3, 190, 2, 192, 1, 334, 3, 382, 2};
        mu4DataArray = new int[3848];
        mu4SequenceTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (mu4SequenceArray == null) {
                    return;
                }
                switch (mu4SequenceArray[mu4SequenceIndex++]) {
                    case 0: {
                        MercuryUnit.mu4FallExpcl();
                        break;
                    }
                    case 1: {
                        MercuryUnit.mu4RiseExpcl();
                        break;
                    }
                    case 2: {
                        if (mu4Mode == 1) {
                            mu4WritePointer = 2 * (mu4FrameNumber + 3) + mu4LRCounter;
                            mu4LRCounter ^= 1;
                            MercuryUnit.mu4DataArray[MercuryUnit.mu4WritePointer] = (int)((float)mu4DataArray[mu4WritePointer - 2] * 0.97f);
                            if (mu4DataChannels == 1 || (mu4WritePointer & 1) == 0) {
                                mu4NaiDesuLeft = mu4NaiDesuLeft || mu4NaiKamoLeft;
                                mu4NaiKamoLeft = true;
                            }
                            if (mu4DataChannels == 1 || (mu4WritePointer & 1) != 0) {
                                mu4NaiDesuRight = mu4NaiDesuRight || mu4NaiKamoRight;
                                mu4NaiKamoRight = true;
                            }
                        }
                        MercuryUnit.mu4FallExreq(mu4SequenceTime);
                        break;
                    }
                    case 3: {
                        MercuryUnit.mu4RiseExreq();
                    }
                }
                if (mu4SequenceArray.length <= mu4SequenceIndex) {
                    if (mu4Mode == 0) {
                        mu4SequenceArray = null;
                        return;
                    }
                    ++mu4FrameNumber;
                    mu4SequenceIndex = 0;
                    mu4LRCounter = 0;
                }
                mu4SequenceTime = mu4BlockTime + (long)(mu4DataCycles * mu4FrameNumber + mu4SequenceArray[mu4SequenceIndex++]) * 1000000000000L / (long)mu4DataFrequency;
                TickerQueue.tkqAdd(mu4SequenceTicker, mu4SequenceTime);
            }
        };
        mu4AttackArray = new float[301];
    }

    static class Hermite {
        int inputFrames;
        int outputFrames;
        int inputFactor;
        int outputFactor;
        float[] coeffArray;
        int[] indexArray;

        Hermite(int n, int n2) {
            this.inputFrames = n;
            this.outputFrames = n2;
            int n3 = this.gcd(n, n2);
            this.inputFactor = n / n3;
            this.outputFactor = n2 / n3;
            this.coeffArray = new float[4 * this.outputFactor];
            this.indexArray = new int[this.outputFactor];
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.outputFactor; ++i) {
                int n6 = n4;
                int n7 = n5;
                n5 += this.inputFactor;
                while (this.outputFactor <= n5) {
                    n5 -= this.outputFactor;
                    ++n4;
                }
                double d = (double)n7 / (double)this.outputFactor;
                this.coeffArray[4 * i] = (float)(((-0.5 * d + 1.0) * d - 0.5) * d);
                this.coeffArray[4 * i + 1] = (float)((1.5 * d - 2.5) * d * d + 1.0);
                this.coeffArray[4 * i + 2] = (float)(((-1.5 * d + 2.0) * d + 0.5) * d);
                this.coeffArray[4 * i + 3] = (float)((0.5 * d - 0.5) * d * d);
                this.indexArray[i] = n6;
            }
        }

        void convert() {
            int n = 0;
            int n2 = 0;
            while (n < this.inputFrames) {
                for (int i = 0; i < this.outputFactor; ++i) {
                    int n3 = n + this.indexArray[i];
                    int n4 = n2 + i;
                    float f = this.coeffArray[4 * i];
                    float f2 = this.coeffArray[4 * i + 1];
                    float f3 = this.coeffArray[4 * i + 2];
                    float f4 = this.coeffArray[4 * i + 3];
                    MercuryUnit.mu4Buffer[2 * n4 + 0] = Math.round(f * (float)mu4DataArray[2 * n3 + 0] + f2 * (float)mu4DataArray[2 * n3 + 2] + f3 * (float)mu4DataArray[2 * n3 + 4] + f4 * (float)mu4DataArray[2 * n3 + 6]);
                    MercuryUnit.mu4Buffer[2 * n4 + 1] = Math.round(f * (float)mu4DataArray[2 * n3 + 1] + f2 * (float)mu4DataArray[2 * n3 + 3] + f3 * (float)mu4DataArray[2 * n3 + 5] + f4 * (float)mu4DataArray[2 * n3 + 7]);
                }
                n += this.inputFactor;
                n2 += this.outputFactor;
            }
        }

        int gcd(int n, int n2) {
            while (n2 != 0) {
                int n3 = n % n2;
                n = n2;
                n2 = n3;
            }
            return n;
        }
    }
}

