/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ComponentFactory;
import xeij.Joystick;
import xeij.LnF;
import xeij.Multilingual;
import xeij.PPI;
import xeij.Settings;
import xeij.XEiJ;
import xeij.XInput;

public class MegaDrive3ButtonPad
extends Joystick
implements ActionListener,
ChangeListener,
FocusListener,
XInput.GamepadListener,
KeyListener {
    protected static final int UP_BIT = 0;
    protected static final int DOWN_BIT = 1;
    protected static final int LEFT_BIT = 2;
    protected static final int RIGHT_BIT = 3;
    protected static final int A_BIT = 4;
    protected static final int B_BIT = 5;
    protected static final int C_BIT = 6;
    protected static final int START_BIT = 7;
    protected static final int BUTTONS = 8;
    protected static final int UP_MASK = 1;
    protected static final int DOWN_MASK = 2;
    protected static final int LEFT_MASK = 4;
    protected static final int RIGHT_MASK = 8;
    protected static final int A_MASK = 16;
    protected static final int B_MASK = 32;
    protected static final int C_MASK = 64;
    protected static final int START_MASK = 128;
    protected static final String[] BIT_TO_TEXT = new String[]{"\u2191", "\u2193", "\u2190", "\u2192", "A", "B", "C", "START"};
    protected static final boolean[] BIT_TO_REPEATABLE = new boolean[]{false, false, false, false, true, true, true, false};
    protected static final int MAP_CODE = 0;
    protected static final int MAP_REPEAT = 8;
    protected static final int MAP_DELAY = 16;
    protected static final int MAP_INTERVAL = 24;
    protected static final int MAP_LENGTH = 32;
    protected int[] map;
    protected int xinputFocusedButton;
    protected long[] startTimeOf;
    protected int lastButtons;
    protected int keyButtons;
    protected int page;
    protected JTextField[] xinputTextFieldOf = new JTextField[8];
    protected JTextField[] keyTextFieldOf = new JTextField[8];
    protected JCheckBox[] repeatCheckBoxOf = new JCheckBox[8];
    protected SpinnerNumberModel[] delayModelOf = new SpinnerNumberModel[8];
    protected JSpinner[] delaySpinnerOf = new JSpinner[8];
    protected SpinnerNumberModel[] intervalModelOf = new SpinnerNumberModel[8];
    protected JSpinner[] intervalSpinnerOf = new JSpinner[8];
    protected final int[][] defaultMaps = new int[][]{{8388646, 8454184, 8519717, 8585255, 9175130, 9240664, 8912963, 8650834, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 0, 0, 0, 0, 0, 100, 100, 100, 0}, {0xA00000, 0xA10000, 0xA20000, 0xA30000, 0xAC0000, 0xAD0000, 0xA80000, 0xA40000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 0, 0, 0, 0, 0, 100, 100, 100, 0}};

    public MegaDrive3ButtonPad(int n) {
        this.number = n;
        this.id = "megadrive3button" + n;
        this.nameEn = "MEGA DRIVE 3 button pad #" + n;
        this.nameJa = "\u30e1\u30ac\u30c9\u30e9 3 \u30dc\u30bf\u30f3\u30d1\u30c3\u30c9 #" + n;
        this.map = new int[32];
        int[] nArray = Settings.sgsGetIntArray(this.id);
        if (0 < nArray.length && 0 <= nArray[0]) {
            int n2;
            for (n2 = 0; n2 < 32; ++n2) {
                this.map[n2] = n2 < nArray.length ? nArray[n2] : 0;
            }
            for (n2 = 0; n2 < 8; ++n2) {
                this.map[24 + n2] = Math.min(2000, this.map[24 + n2] << 1);
            }
        } else if (0 < nArray.length && nArray[0] == -2) {
            for (int i = 0; i < 32; ++i) {
                this.map[i] = i + 1 < nArray.length ? nArray[i + 1] : 0;
            }
        } else {
            System.arraycopy(this.defaultMaps[n - 1], 0, this.map, 0, 32);
        }
        this.xinputFocusedButton = -1;
        this.startTimeOf = new long[8];
        this.reset();
        this.configurationPanel = null;
    }

    @Override
    public void tini() {
        if (Arrays.equals(this.map, this.defaultMaps[this.number - 1])) {
            Settings.sgsPutIntArray(this.id, new int[0]);
        } else {
            int[] nArray = new int[33];
            nArray[0] = -2;
            for (int i = 0; i < 32; ++i) {
                nArray[1 + i] = this.map[i];
            }
            Settings.sgsPutIntArray(this.id, nArray);
        }
    }

    @Override
    public final void reset() {
        this.lastButtons = 0;
        this.keyButtons = 0;
        this.page = 0;
    }

    private void updateText() {
        for (int i = 0; i < 8; ++i) {
            int n;
            Object object;
            int n2 = this.map[0 + i] >>> 16;
            if (n2 == 0) {
                object = Multilingual.mlnJapanese ? "\u306a\u3057" : "none";
            } else {
                n = n2 >> 5 & 3;
                int n3 = n2 & 0x1F;
                object = "#" + n + " " + XInput.BIT_TO_TEXT[n3];
            }
            this.xinputTextFieldOf[i].setText((String)object);
            n = this.map[0 + i] & 0xFFFF;
            object = n == 0 ? (Multilingual.mlnJapanese ? "\u306a\u3057" : "none") : KeyEvent.getKeyText(n);
            this.keyTextFieldOf[i].setText((String)object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Reset to default values")) {
            if (Arrays.equals(this.map, this.defaultMaps[this.number - 1])) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? this.nameJa + " \u306e\u8a2d\u5b9a\u306f\u521d\u671f\u5024\u3068\u540c\u3058\u3067\u3059" : this.nameEn + " settings are equals to default values", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", -1);
                return;
            }
            if (JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? this.nameJa + " \u306e\u8a2d\u5b9a\u3092\u521d\u671f\u5024\u306b\u623b\u3057\u307e\u3059\u304b\uff1f" : "Do you want to reset " + this.nameEn + " settings to default values?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) != 0) {
                return;
            }
            System.arraycopy(this.defaultMaps[this.number - 1], 0, this.map, 0, 32);
            this.updateText();
            for (int i = 0; i < 8; ++i) {
                if (!BIT_TO_REPEATABLE[i]) continue;
                this.repeatCheckBoxOf[i].setSelected(this.map[8 + i] != 0);
                this.delayModelOf[i].setValue(Math.max(10, Math.min(1000, this.map[16 + i])));
                this.intervalModelOf[i].setValue(Math.max(10, Math.min(2000, this.map[24 + i])));
            }
        } else if (string.startsWith("Repeat ")) {
            int n = Integer.parseInt(string.substring(7));
            int n2 = this.repeatCheckBoxOf[n].isSelected() ? 1 : 0;
            this.map[8 + n] = n2;
        } else {
            System.out.println("unknown action command " + string);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        String string = jSpinner.getName();
        if (string.startsWith("Delay ")) {
            int n = Integer.parseInt(string.substring(6));
            this.map[16 + n] = this.delayModelOf[n].getNumber().intValue();
        } else if (string.startsWith("Interval ")) {
            int n = Integer.parseInt(string.substring(9));
            this.map[24 + n] = this.intervalModelOf[n].getNumber().intValue();
        } else {
            System.out.println("unknown spinner name " + string);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        component.setBackground(new Color(LnF.lnfRGB[6]));
        if (c == 'x') {
            this.xinputFocusedButton = n;
            if (PPI.ppiXInput != null) {
                PPI.ppiXInput.addGamepadListener(this);
            }
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        component.setBackground(null);
        if (c == 'x') {
            if (PPI.ppiXInput != null) {
                PPI.ppiXInput.removeGamepadListeners();
            }
            this.xinputFocusedButton = -1;
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
    }

    @Override
    public void connected(XInput.Gamepad gamepad) {
    }

    @Override
    public void disconnected(XInput.Gamepad gamepad) {
    }

    @Override
    public void buttonPressed(XInput.Gamepad gamepad, int n) {
        if (n == 0) {
            return;
        }
        if (0 <= this.xinputFocusedButton) {
            int n2 = gamepad.getIndex();
            int n3 = Integer.numberOfTrailingZeros(n);
            int n4 = 0x80 | n2 << 5 | n3;
            int n5 = this.map[0 + this.xinputFocusedButton] & 0xFFFF;
            this.map[0 + this.xinputFocusedButton] = n4 << 16 | n5;
            for (int i = 0; i < 8; ++i) {
                int n6 = this.map[0 + i] >>> 16;
                if (n6 == 0) continue;
                int n7 = this.map[0 + i] & 0xFFFF;
                this.map[0 + i] = (n6 & 0xFFFFFF9F | n2 << 5) << 16 | n7;
            }
            this.updateText();
        }
    }

    @Override
    public void buttonReleased(XInput.Gamepad gamepad, int n) {
    }

    @Override
    public void leftStickMovedX(XInput.Gamepad gamepad) {
    }

    @Override
    public void leftStickMovedY(XInput.Gamepad gamepad) {
    }

    @Override
    public void leftTriggerMoved(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightStickMovedX(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightStickMovedY(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightTriggerMoved(XInput.Gamepad gamepad) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        int n2 = this.map[0 + n] >>> 16;
        int n3 = this.map[0 + n] & 0xFFFF;
        if (c == 'x') {
            if (keyEvent.getKeyCode() == 27) {
                n2 = 0;
            }
        } else if (c == 'k') {
            n3 = keyEvent.getKeyCode() == 27 ? 0 : keyEvent.getKeyCode();
        } else {
            System.out.println("unknown component name " + string);
        }
        this.map[0 + n] = n2 << 16 | n3;
        this.updateText();
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public JComponent getConfigurationPanel() {
        if (this.configurationPanel != null) {
            return this.configurationPanel;
        }
        for (int i = 0; i < 8; ++i) {
            this.xinputTextFieldOf[i] = ComponentFactory.setEnabled(ComponentFactory.addListener(ComponentFactory.addListener(ComponentFactory.setHorizontalAlignment(ComponentFactory.setName(ComponentFactory.createTextField("", 8), "x" + i), 0), this), this), XEiJ.prgIsWindows);
            this.keyTextFieldOf[i] = ComponentFactory.addListener(ComponentFactory.addListener(ComponentFactory.setHorizontalAlignment(ComponentFactory.setName(ComponentFactory.createTextField("", 8), "k" + i), 0), this), this);
            if (!BIT_TO_REPEATABLE[i]) continue;
            this.repeatCheckBoxOf[i] = ComponentFactory.setText(ComponentFactory.createCheckBox(this.map[8 + i] != 0, "Repeat " + i, this), "");
            this.delayModelOf[i] = new SpinnerNumberModel(Math.max(10, Math.min(1000, this.map[16 + i])), 10, 1000, 10);
            this.delaySpinnerOf[i] = ComponentFactory.setName(ComponentFactory.createNumberSpinner(this.delayModelOf[i], 4, this), "Delay " + i);
            this.intervalModelOf[i] = new SpinnerNumberModel(Math.max(10, Math.min(2000, this.map[24 + i])), 10, 2000, 10);
            this.intervalSpinnerOf[i] = ComponentFactory.setName(ComponentFactory.createNumberSpinner(this.intervalModelOf[i], 4, this), "Interval " + i);
        }
        this.updateText();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Button"), "ja", "\u30dc\u30bf\u30f3"));
        arrayList.add(ComponentFactory.createLabel("XInput"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Keyboard"), "ja", "\u30ad\u30fc\u30dc\u30fc\u30c9"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Burst"), "ja", "\u9023\u5c04"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Delay (ms)"), "ja", "\u958b\u59cb (ms)"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Interval (ms)"), "ja", "\u9593\u9694 (ms)"));
        arrayList.add(ComponentFactory.createHorizontalSeparator());
        for (int i = 0; i < 8; ++i) {
            arrayList.add(String.valueOf(1 + i));
            arrayList.add(BIT_TO_TEXT[i]);
            arrayList.add(this.xinputTextFieldOf[i]);
            arrayList.add(this.keyTextFieldOf[i]);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.repeatCheckBoxOf[i] : null);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.delaySpinnerOf[i] : null);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.intervalSpinnerOf[i] : null);
        }
        this.configurationPanel = ComponentFactory.createVerticalBox(Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel(this.getNameEn()), "ja", this.getNameJa()), Box.createHorizontalGlue()), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(ComponentFactory.createGridPanel(7, 10, "paddingLeft=3,paddingRight=3,center", "", "italic;colSpan=7,widen", "", arrayList.toArray(new Object[0]))), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createButton("Reset to default values", this), "ja", "\u521d\u671f\u5024\u306b\u623b\u3059"), Box.createHorizontalGlue()), Box.createVerticalStrut(5));
        return this.configurationPanel;
    }

    @Override
    public boolean input(KeyEvent keyEvent, boolean bl) {
        int n = keyEvent.getKeyCode();
        for (int i = 0; i < 8; ++i) {
            if (n != (this.map[0 + i] & 0xFFFF)) continue;
            this.keyButtons = bl ? (this.keyButtons |= 1 << i) : (this.keyButtons &= ~(1 << i));
            return true;
        }
        return false;
    }

    @Override
    public void setPin8(int n) {
        this.page = n;
    }

    @Override
    public int readByte() {
        int n;
        int n2;
        int n3;
        int n4 = this.keyButtons;
        int n5 = -1;
        int n6 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            n2 = this.map[0 + n3] >>> 16;
            if (n2 == 0) continue;
            n = n2 >> 5 & 3;
            int n7 = n2 & 0x1F;
            if (n5 != n) {
                n5 = n;
                int n8 = n6 = PPI.ppiXInput == null ? 0 : PPI.ppiXInput.getButtonMasks(n5);
            }
            if ((n6 & 1 << n7) == 0) continue;
            n4 |= 1 << n3;
        }
        n3 = ~this.lastButtons & n4;
        this.lastButtons = n4;
        n2 = 0;
        for (n = 0; n < 8; ++n) {
            if ((n3 & 1 << n) != 0 && this.map[8 + n] != 0) {
                this.startTimeOf[n] = XEiJ.mpuClockTime + (long)this.map[16 + n] * 1000000000L;
            }
            if ((n4 & 1 << n) == 0 || this.map[8 + n] != 0 && XEiJ.mpuClockTime >= this.startTimeOf[n] && ((int)((XEiJ.mpuClockTime - this.startTimeOf[n]) / ((long)(this.map[24 + n] >> 1) * 1000000000L)) & 1) == 0) continue;
            n2 |= 1 << n;
        }
        return this.page == 0 ? 0xF3 & ((n2 & 3) == 1 ? -2 : -1) & ((n2 & 3) == 2 ? -3 : -1) & ((n2 & 0x10) != 0 ? -33 : -1) & ((n2 & 0x80) != 0 ? -65 : -1) : 0xFF & ((n2 & 3) == 1 ? -2 : -1) & ((n2 & 3) == 2 ? -3 : -1) & ((n2 & 0xC) == 4 ? -5 : -1) & ((n2 & 0xC) == 8 ? -9 : -1) & ((n2 & 0x20) != 0 ? -33 : -1) & ((n2 & 0x40) != 0 ? -65 : -1);
    }
}

