/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.DataBreakPoint;
import xeij.IRBEnum;
import xeij.InstructionBreakPoint;
import xeij.M68kException;
import xeij.MainMemory;
import xeij.XEiJ;

public class InstructionBenchmark {
    public static final int IRB_N = 100000000;
    public static final int IRB_M = 5;

    public static void irbBench(String string) {
        XEiJ.mpuInit();
        InstructionBreakPoint.ibpInit();
        DataBreakPoint.dbpInit();
        XEiJ.busInit();
        MainMemory.mmrInit();
        boolean bl = string.equals("all");
        try {
            for (IRBEnum iRBEnum : IRBEnum.values()) {
                String string2 = iRBEnum.name();
                if (!bl && !string2.equals(string)) continue;
                int n = 0;
                long l = Long.MAX_VALUE;
                for (int i = 0; i < 5; ++i) {
                    long l2 = System.nanoTime();
                    n = iRBEnum.bench(false);
                    long l3 = System.nanoTime();
                    n = iRBEnum.bench(true);
                    l2 = System.nanoTime();
                    n = iRBEnum.bench(false);
                    l3 = System.nanoTime();
                    n = iRBEnum.bench(true);
                    long l4 = System.nanoTime();
                    l = Math.min(l, l4 - l3 - (l3 - l2));
                }
                System.out.printf("%-20s  %6.2fns  0x%08x\n", string2, (double)l / 1.0E8, n);
            }
        }
        catch (M68kException m68kException) {
            // empty catch block
        }
    }
}

