/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Node;
import xeij.CRTC;
import xeij.ComponentFactory;
import xeij.Multilingual;
import xeij.Settings;
import xeij.XEiJ;

public class GIFAnimation {
    public static final int GIF_WAITING_TIME_MIN = 0;
    public static final int GIF_WAITING_TIME_MAX = 30;
    public static final int GIF_RECORDING_TIME_MIN = 1;
    public static final int GIF_RECORDING_TIME_MAX = 30;
    public static final int GIF_MAGNIFICATION_MIN = 10;
    public static final int GIF_MAGNIFICATION_MAX = 200;
    public static int gifWaitingTime;
    public static int gifRecordingTime;
    public static int gifMagnification;
    public static Object gifInterpolation;
    public static SpinnerNumberModel gifWaitingTimeModel;
    public static SpinnerNumberModel gifRecordingTimeModel;
    public static SpinnerNumberModel gifMagnificationModel;
    public static JMenuItem gifStartRecordingMenuItem;
    public static JMenu gifSettingsMenu;
    public static Timer gifTimer;
    public static int gifScreenWidth;
    public static int gifScreenHeight;
    public static int gifStretchWidth;
    public static int gifStereoscopicFactor;
    public static boolean gifStereoscopicOn;
    public static int gifStereoscopicMethod;
    public static double gifDelayTime;
    public static int gifWaitingFrames;
    public static int gifRecordingFrames;
    public static int[] gifBuffer;
    public static int gifPointer;
    public static int gifWaitingCounter;
    public static int gifRecordingCounter;
    public static boolean gifNowRecording;

    public static void gifInit() {
        gifWaitingTime = Math.max(0, Math.min(30, Settings.sgsGetInt("gifwaitingtime")));
        gifRecordingTime = Math.max(1, Math.min(30, Settings.sgsGetInt("gifrecordingtime")));
        gifMagnification = Math.max(10, Math.min(200, Settings.sgsGetInt("gifmagnification")));
        switch (Settings.sgsGetString("gifinterpolation").toLowerCase()) {
            case "nearest": {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case "bilinear": {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case "bicubic": {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                break;
            }
            default: {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            }
        }
        gifWaitingTimeModel = new SpinnerNumberModel(gifWaitingTime, 0, 30, 1);
        gifRecordingTimeModel = new SpinnerNumberModel(gifRecordingTime, 1, 30, 1);
        gifMagnificationModel = new SpinnerNumberModel(gifMagnification, 10, 200, 1);
        Object object = new ButtonGroup();
        gifStartRecordingMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Start recording", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GIFAnimation.gifStartRecording();
            }
        }), "ja", "\u9332\u753b\u958b\u59cb");
        gifSettingsMenu = Multilingual.mlnText(ComponentFactory.createMenu("GIF animation recording settings", ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Waiting time"), "ja", "\u5f85\u3061\u6642\u9593"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(20), ComponentFactory.createNumberSpinner(gifWaitingTimeModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                gifWaitingTime = gifWaitingTimeModel.getNumber().intValue();
            }
        }), Multilingual.mlnText(ComponentFactory.createLabel("seconds"), "ja", "\u79d2"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Recording time"), "ja", "\u9332\u753b\u6642\u9593"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(20), ComponentFactory.createNumberSpinner(gifRecordingTimeModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                gifRecordingTime = gifRecordingTimeModel.getNumber().intValue();
            }
        }), Multilingual.mlnText(ComponentFactory.createLabel("seconds"), "ja", "\u79d2"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Magnification"), "ja", "\u500d\u7387"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(20), ComponentFactory.createNumberSpinner(gifMagnificationModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                gifMagnification = gifMagnificationModel.getNumber().intValue();
            }
        }), ComponentFactory.createLabel("%"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, gifInterpolation == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, "Nearest neighbor", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
        }), "ja", "\u6700\u8fd1\u508d\u88dc\u9593"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, gifInterpolation == RenderingHints.VALUE_INTERPOLATION_BILINEAR, "Bilinear", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            }
        }), "ja", "\u7dda\u5f62\u88dc\u9593"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, gifInterpolation == RenderingHints.VALUE_INTERPOLATION_BICUBIC, "Bicubic", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                gifInterpolation = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            }
        }), "ja", "\u4e09\u6b21\u88dc\u9593")), "ja", "GIF \u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3\u9332\u753b\u8a2d\u5b9a");
        gifTimer = new Timer();
    }

    public static void gifTini() {
        Settings.sgsPutInt("gifwaitingtime", gifWaitingTime);
        Settings.sgsPutInt("gifrecordingtime", gifRecordingTime);
        Settings.sgsPutInt("gifmagnification", gifMagnification);
        Settings.sgsPutString("gifinterpolation", gifInterpolation == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR ? "nearest" : (gifInterpolation == RenderingHints.VALUE_INTERPOLATION_BILINEAR ? "bilinear" : (gifInterpolation == RenderingHints.VALUE_INTERPOLATION_BICUBIC ? "bicubic" : "bilinear")));
    }

    public static void gifStartRecording() {
        if (gifNowRecording) {
            return;
        }
        gifScreenWidth = XEiJ.pnlScreenWidth;
        gifScreenHeight = XEiJ.pnlScreenHeight;
        gifStretchWidth = XEiJ.pnlStretchWidth;
        gifStereoscopicFactor = XEiJ.pnlStereoscopicFactor;
        gifStereoscopicOn = XEiJ.pnlStereoscopicOn;
        gifStereoscopicMethod = XEiJ.pnlStereoscopicMethod;
        gifDelayTime = Math.max(2.0, (double)CRTC.crtTotalLength * 0.1 + (double)CRTC.crtTotalLengthMNP * 1.0E-10);
        gifWaitingFrames = (int)Math.floor((double)gifWaitingTime * 100.0 / gifDelayTime + 0.5);
        int n = gifScreenWidth * gifScreenHeight * gifStereoscopicFactor;
        int n2 = Integer.MAX_VALUE / n;
        gifRecordingFrames = (int)Math.floor((double)gifRecordingTime * 100.0 / gifDelayTime + 0.5);
        if (n2 < gifRecordingFrames) {
            return;
        }
        int n3 = n * gifRecordingFrames;
        try {
            gifBuffer = new int[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            return;
        }
        gifStartRecordingMenuItem.setEnabled(false);
        gifPointer = 0;
        gifWaitingCounter = 0;
        gifRecordingCounter = 0;
        gifNowRecording = true;
        CRTC.crtCaptureClock = XEiJ.mpuClockTime;
        CRTC.crtFrameTaskClock = Math.min(CRTC.crtContrastClock, CRTC.crtCaptureClock);
    }

    public static void gifCaptureFrame() {
        int n;
        if (gifWaitingCounter < gifWaitingFrames) {
            ++gifWaitingCounter;
            return;
        }
        int[] nArray = XEiJ.pnlBMLeftArray[XEiJ.pnlBMWrite & 3];
        for (n = 0; n < gifScreenHeight; ++n) {
            System.arraycopy(nArray, 1024 * n, gifBuffer, gifPointer, gifScreenWidth);
            gifPointer += gifScreenWidth;
        }
        if (gifStereoscopicFactor == 2) {
            nArray = XEiJ.pnlBMRightArray[XEiJ.pnlBMWrite & 3];
            for (n = 0; n < gifScreenHeight; ++n) {
                System.arraycopy(nArray, 1024 * n, gifBuffer, gifPointer, gifScreenWidth);
                gifPointer += gifScreenWidth;
            }
        }
        if (++gifRecordingCounter == gifRecordingFrames) {
            CRTC.crtCaptureClock = Long.MAX_VALUE;
            CRTC.crtFrameTaskClock = Math.min(CRTC.crtContrastClock, CRTC.crtCaptureClock);
            gifTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    GIFAnimation.gifOutput();
                }
            }, 0L);
        }
    }

    public static void gifOutput() {
        System.out.println(Multilingual.mlnJapanese ? "\u753b\u50cf\u3092\u5727\u7e2e\u3057\u3066\u3044\u307e\u3059" : "Compressing images");
        double d = (double)gifMagnification / 100.0;
        int n = (int)Math.floor((double)gifStretchWidth * d + 0.5);
        int n2 = (int)Math.floor((double)gifScreenHeight * d + 0.5);
        BufferedImage bufferedImage = new BufferedImage(1024, gifScreenHeight, 1);
        BufferedImage bufferedImage2 = new BufferedImage(1024, gifScreenHeight, 1);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        BufferedImage bufferedImage3 = new BufferedImage(n * gifStereoscopicFactor, n2, 1);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, gifInterpolation);
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("gif").next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        try {
            String string;
            String string2 = "capture";
            File file = new File(string2);
            if (file.exists() ? !file.isDirectory() : !file.mkdir()) {
                gifBuffer = null;
                gifNowRecording = false;
                gifStartRecordingMenuItem.setEnabled(true);
                return;
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            for (String object2 : file.list()) {
                hashSet.add(object2);
            }
            int n3 = 0;
            while (!hashSet.add(string = ++n3 + ".gif")) {
            }
            File file2 = new File(string = string2 + "/" + string);
            if (file2.exists()) {
                file2.delete();
            }
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.prepareWriteSequence(null);
            int n4 = gifScreenWidth * gifScreenHeight;
            int n5 = n4 * gifStereoscopicFactor;
            double d2 = 0.0;
            double d3 = 0.0;
            int n6 = 0;
            while (n6 < gifRecordingFrames) {
                int n7;
                int n8 = n5 * n6;
                int n9 = 1;
                while (n6 + n9 < gifRecordingFrames && Arrays.equals(gifBuffer, n8, n8 + n5, gifBuffer, n8 + n5 * n9, n8 + n5 * (n9 + 1))) {
                    ++n9;
                }
                n6 += n9;
                double d4 = d2 + gifDelayTime * (double)n9;
                double d5 = Math.floor(d4 + 0.5);
                IIOMetadata iIOMetadata = GIFAnimation.makeMetadata(imageWriter, imageWriteParam, bufferedImage3, String.valueOf((int)(d5 - d3)));
                d2 = d4;
                d3 = d5;
                for (n7 = 0; n7 < gifScreenHeight; ++n7) {
                    System.arraycopy(gifBuffer, n8, nArray, 1024 * n7, gifScreenWidth);
                    n8 += gifScreenWidth;
                }
                if (gifStereoscopicFactor == 2) {
                    for (n7 = 0; n7 < gifScreenHeight; ++n7) {
                        System.arraycopy(gifBuffer, n8, nArray2, 1024 * n7, gifScreenWidth);
                        n8 += gifScreenWidth;
                    }
                }
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, 0, n * gifStereoscopicFactor, n2);
                if (gifStereoscopicOn) {
                    if (gifStereoscopicMethod == 0) {
                        graphics2D.drawImage(bufferedImage2, 0, 0, n, n2, 0, 0, gifScreenWidth, gifScreenHeight, null);
                        graphics2D.drawImage(bufferedImage, n, 0, n * 2, n2, 0, 0, gifScreenWidth, gifScreenHeight, null);
                    } else if (gifStereoscopicMethod == 1 || gifStereoscopicMethod == 2) {
                        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, gifScreenWidth, gifScreenHeight, null);
                        graphics2D.drawImage(bufferedImage2, n, 0, n * 2, n2, 0, 0, gifScreenWidth, gifScreenHeight, null);
                    } else {
                        graphics2D.drawImage(bufferedImage, 0, 0, n, n2 >> 1, 0, 0, gifScreenWidth, gifScreenHeight, null);
                        graphics2D.drawImage(bufferedImage2, 0, n2 >> 1, n, n2, 0, 0, gifScreenWidth, gifScreenHeight, null);
                    }
                } else {
                    graphics2D.drawImage(bufferedImage, 0, 0, n, n2, 0, 0, gifScreenWidth, gifScreenHeight, null);
                }
                imageWriter.writeToSequence(new IIOImage(bufferedImage3, null, iIOMetadata), imageWriteParam);
            }
            imageWriter.endWriteSequence();
            imageOutputStream.close();
            System.out.println(Multilingual.mlnJapanese ? string + " \u3092\u66f4\u65b0\u3057\u307e\u3057\u305f" : string + " was updated");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        gifBuffer = null;
        gifNowRecording = false;
        gifStartRecordingMenuItem.setEnabled(true);
    }

    public static IIOMetadata makeMetadata(ImageWriter imageWriter, ImageWriteParam imageWriteParam, BufferedImage bufferedImage, String string) {
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), imageWriteParam);
        String string2 = iIOMetadata.getNativeMetadataFormatName();
        Node node = iIOMetadata.getAsTree(string2);
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("GraphicControlExtension");
        iIOMetadataNode.setAttribute("delayTime", string);
        iIOMetadataNode.setAttribute("disposalMethod", "none");
        iIOMetadataNode.setAttribute("transparentColorFlag", "FALSE");
        iIOMetadataNode.setAttribute("transparentColorIndex", "0");
        iIOMetadataNode.setAttribute("userInputFlag", "FALSE");
        node.appendChild(iIOMetadataNode);
        try {
            iIOMetadata.setFromTree(string2, node);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            iIOInvalidTreeException.printStackTrace();
        }
        return iIOMetadata;
    }
}

