;========================================================================================
;  optime.s
;  Copyright (C) 2003-2023 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;
;	optime.x
;		ߗ̎sԂv܂B
;
;	ŏIXV
;		2023-09-17
;
;	
;		has060 -i include -o optime.o -w optime.s
;		lk -o optime.x optime.o
;
;	g
;		-a AZu
;			AZuw肵܂B
;			w肪Ȃhas060g܂B
;		-f t@C
;			sԂvߗt@Cw肵܂B
;			sŖ߂؂܂B
;		-i "ߗ"
;			sԂvߗ"`"ň͂Ŏw肵܂B
;			Z~RŖ߂؂܂B
;			߂ӖZ~R͏܂B
;		-s
;			ߗSRAMɏŌv܂B
;			DRAM̃tbVɂ덷oɂȂ܂B
;			X68000ł1[h1TCÑEFCgǉ܂B
;			SRAMgp̂Ƃv邩₢킹܂B
;		-sn
;			-sƓlłSRAMgp̂Ƃ͌v܂B
;		-sy
;			-sƓlłSRAMgp̂Ƃv܂B
;		-t fBNg
;			e|fBNgw肵܂B
;			w肪ȂΊϐtempǂݏo܂B
;			ϐtempȂ΃JgfBNgg܂B
;		-v
;			璷ɏo͂܂B
;		ߗ
;			vłsԂ̏12.799msłB
;			ߗ̒̏32766oCgłB
;			ZNV̕ύX͂ł܂B
;			򖽗߂܂o͖ߗ̖ɂȂ΂Ȃ܂B
;			d7/a5-a7ύXƂ͕ۑƕsĂB
;			-268(a5)`-1(a5)268oCg͓ǂݏR̋󂫗̈łB
;			ߗ̓X[p[oCU[hŌĂяo܂B
;			ߗ͊荞݂֎~ꂽԂŌĂяo܂B
;
;	XV
;		2023-01-19
;			JB
;		2023-01-21
;			-v̂Ƃ^Cgƃo[W\B
;			G[bZ[W̕\ɕWG[o͂gȂB
;			e|fBNg̖':'̂Ƃ'\'ǉȂB
;			AZũp[^-ww肵Čx}B
;			AZũbZ[WBȂB
;			-v̂ƂAZȕIR[h\B
;		2023-09-17
;			"`"܂'`'ĂȂƔooOCB
;
;----------------------------------------------------------------

	.include	control2.mac
	.include	doscall.mac
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	sram.equ

TITLE_STRING	reg	'optime.x (2023-09-17)'

ERROR_OUTPUT	equ	0		;1=G[bZ[W̕\ɕWG[o͂g
WARNING_OPTION	equ	1		;1=AZũp[^-ww肵Čx}
HIDE_ASSEMBLER	equ	0		;1=AZũbZ[WB

	.text

;----------------------------------------------------------------
;vOJn
program_start::

;----------------------------------------------------------------
;X^bNGAݒ肷
	lea.l	stack_area_end,sp	;X^bNGA̖

	.stack
	.even
		.ds.b	65536		;X^bNGA
stack_area_end::
	.text

;----------------------------------------------------------------
;ubNZ
;	qvZXN邽
;	*.r`͔Ή
;<a0.l:Ǘ|C^
;<a1.l:gp̖
	lea.l	16(a0),a0		;ubN̐擪
	suba.l	a0,a1			;gp̒
	move.l	a1,-(sp)
	move.l	a0,-(sp)
	DOS	_SETBLOCK
	addq.l	#8,sp

;----------------------------------------------------------------
;IvVmF
;<a2.l:R}hCBLASCIIZ
	clr.b	assembler_arg		;-a AZu
	clr.b	file_arg		;-f t@C
	clr.b	inst_arg		;-i ߗ
	clr.b	sram_flag		;-s SRAMtOB1=-s,2=-sn,3=-sy
	clr.b	temp_arg		;-t fBNg
	clr.b	verbose_flag		;-v 璷tO
	lea.l	1(a2),a1
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,usage_exit	;-,/ȊO
		addq.l	#1,a1
		move.b	(a1)+,d0
		goto	eq,usage_exit		;-,/̌ɕȂ
		bsr	tolower
		if	<cmp.b #'a',d0>,eq	;-a
			lea.l	assembler_arg,a0	;-a AZu
			bsr	argcpy
			goto	eq,usage_exit		;-ǎɕȂ
		elif	<cmp.b #'f',d0>,eq	;-f
			lea.l	file_arg,a0		;-f t@C
			bsr	argcpy
			goto	eq,usage_exit		;-f̌ɕȂ
		elif	<cmp.b #'i',d0>,eq	;-i
			lea.l	inst_arg,a0		;-i ߗ
			bsr	argcpy
			goto	eq,usage_exit		;-ǐɕȂ
		elif	<cmp.b #'s',d0>,eq
			move.b	(a1)+,d0
			bsr	tolower
			if	<cmpi.b #'n',d0>,eq	;-sn
				move.b	#2,sram_flag		;-s SRAMtOB1=-s,2=-sn,3=-sy
			elif	<cmpi.b #'y',d0>,eq	;-sy
				move.b	#3,sram_flag		;-s SRAMtOB1=-s,2=-sn,3=-sy
			else
				subq.l	#1,a1
				move.b	#1,sram_flag		;-s SRAMtOB1=-s,2=-sn,3=-sy
			endif
		elif	<cmp.b #'t',d0>,eq	;-t
			lea.l	temp_arg,a0		;-t fBNg
			bsr	argcpy
			goto	eq,usage_exit		;-ťɕȂ
		elif	<cmp.b #'v',d0>,eq	;-v
			st.b	verbose_flag		;-v 璷tO
		else				;̑
			goto	usage_exit
		endif
	start
		exg.l	a0,a1
		bsr	nonspace
		exg.l	a0,a1
	while	ne
	gotoand	<tst.b file_arg>,eq,<tst.b inst_arg>,eq,usage_exit	;-f-iȂ
	gotoand	<tst.b file_arg>,ne,<tst.b inst_arg>,ne,usage_exit	;-f-i
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'> optime.x',a1
		bsr	strcpy
		if	<tst.b assembler_arg>,ne
			leastrdata	' -a ',a1
			bsr	strcpy
			lea.l	assembler_arg,a1	;-a AZu
			bsr	strcpy
		endif
		if	<tst.b file_arg>,ne
			leastrdata	' -f ',a1
			bsr	strcpy
			lea.l	file_arg,a1		;-f t@C
			bsr	strcpy
		endif
		if	<tst.b inst_arg>,ne
			leastrdata	' -i ',a1
			bsr	strcpy
			move.b	#'"',(a0)+
			lea.l	inst_arg,a1		;-i ߗ
			bsr	strcpy
			move.b	#'"',(a0)+
		endif
		if	<tst.b sram_flag>,ne
			if	<cmpi.b #2,sram_flag>,lo	;-s SRAMtO
				leastrdata	' -s',a1
			elif	eq
				leastrdata	' -sn',a1
			else
				leastrdata	' -sy',a1
			endif
			bsr	strcpy
		endif
		if	<tst.b temp_arg>,ne
			leastrdata	' -t ',a1
			bsr	strcpy
			lea.l	temp_arg,a1		;-t fBNg
			bsr	strcpy
		endif
	;	if	<tst.b verbose_flag>,ne
			leastrdata	' -v',a1
			bsr	strcpy
	;	endif
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif

	.bss
assembler_arg::
	.ds.b	1024			;-a AZu
file_arg::
	.ds.b	1024			;-f t@C
inst_arg::
	.ds.b	1024			;-i ߗ
sram_flag::
	.ds.b	1			;-s SRAMtO
temp_arg::
	.ds.b	1024			;-t fBNg
verbose_flag::
	.ds.b	1			;-v 璷tO
string_buffer::
	.ds.b	4096			;obt@
	.text

;----------------------------------------------------------------
;ߗ\[XR[hɕϊ
	if	<tst.b inst_arg>,ne
		lea.l	inst_arg,a1		;-i ߗ
		lea.l	source_code,a0		;\[XR[h
		dostart
			if	<cmpi.b #'@',(a1)>,ne
				move.b	#9,(a0)+
			endif
			docontinue
				move.b	(a1)+,(a0)+
			whileand	<tst.b (a1)>,ne,<cmpi.b #';',(a1)>,ne
			move.b	#13,(a0)+
			move.b	#10,(a0)+
		start
			docontinue
				addq.l	#1,a1
			whileor	<cmpi.b #' ',(a1)>,eq,<cmpi.b #9,(a1)>,eq,<cmpi.b #';',(a1)>,eq
		while	<tst.b (a1)>,ne
		clr.b	(a0)
		if	<tst.b verbose_flag>,ne
			leastrdata	<'source code:',13,10>,a0
			bsr	print
			lea.l	source_code,a0		;\[XR[h
			bsr	print
		endif
	endif

	.bss
source_code::
	.ds.b	1024			;\[XR[h
	.text

;----------------------------------------------------------------
;e|fBNg擾
;	':''/''\'̂łȂƂ'\'ǉ
;	'.'2oCg2oCgڂłȂƂ̊mF͏ȗ
	if	<tst.b temp_arg>,ne
		lea.l	temp_directory,a0	;e|fBNg
		lea.l	temp_arg,a1		;-t fBNg
		bsr	strcpy
	else
		clr.b	temp_directory		;e|fBNg
		pea.l	temp_directory		;e|fBNg
		clr.l	-(sp)
		peastrdata	'temp'		;ϐtempǂݏo
		DOS	_GETENV
		lea.l	12(sp),sp
	endif
	lea.l	temp_directory,a0	;e|fBNg
	if	<tst.b (a0)>,ne
		bsr	strchr0
		ifand	<cmpi.b #':',-1(a0)>,ne,<cmpi.b #'/',-1(a0)>,ne,<cmpi.b #'\',-1(a0)>,ne
			move.b	#'\',(a0)+
			clr.b	(a0)
		endif
	endif
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'temporary directory: ',a1
		bsr	strcpy
		lea.l	temp_directory,a1	;e|fBNg
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif

	.bss
temp_directory::
	.ds.b	1024			;e|fBNg
	.text

;----------------------------------------------------------------
;X[p[oCU[hֈڍs
	supervisormode

;----------------------------------------------------------------
;sspuspۑ
	move.l	sp,saved_ssp		;ۑꂽssp
	move.l	usp,a0
	move.l	a0,saved_usp		;ۑꂽusp

	.data
	.even
saved_ssp::
	.dc.l	0			;ۑꂽssp
saved_usp::
	.dc.l	0			;ۑꂽusp
	.text

;----------------------------------------------------------------
;A{[gxN^ۑ
	move.w	#_CTRLVC,-(sp)
	DOS	_INTVCG
	addq.l	#2,sp
	move.l	d0,saved_ctrlvc		;ۑꂽ_CTRLVC
	move.w	#_ERRJVC,-(sp)
	DOS	_INTVCG
	addq.l	#2,sp
	move.l	d0,saved_errjvc		;ۑꂽ_ERRJVC

	.data
	.even
saved_ctrlvc::
	.dc.l	0			;ۑꂽ_CTRLVC
saved_errjvc::
	.dc.l	0			;ۑꂽ_ERRJVC
	.text

;----------------------------------------------------------------
;A{[gxN^ύX
	pea.l	abort			;~
	move.w	#_CTRLVC,-(sp)
	DOS	_INTVCS
	addq.l	#6,sp
	pea.l	abort			;~
	move.w	#_ERRJVC,-(sp)
	DOS	_INTVCS
	addq.l	#6,sp

;----------------------------------------------------------------
;SRAM̎gpԂmF
	if	<tst.b sram_flag>,ne
		if	<tst.b SRAM_SRAM_USAGE>,ne
			if	<cmp.b #2,sram_flag>,lo
				leastrdata	'SRAM in use. Continue? (y/n) ',a0
				bsr	yesno
			elif	eq
				moveq.l	#'n',d0
			else
				moveq.l	#'y',d0
			endif
			goto	<cmp.b #'y',d0>,ne,abort	;~
		endif
	endif

;----------------------------------------------------------------
;\[Xt@C
	bsr	create_source		;\[Xt@C

;----------------------------------------------------------------
;IuWFNgt@C
;	\[Xt@C̐擪Ō'.'̈ʒuȂΖ'.o'
;	'.'2oCg2oCgڂłȂƂ̊mF͏ȗ
	lea.l	object_file,a0		;IuWFNgt@C
	lea.l	source_file,a1		;\[Xt@C
	bsr	strcpy
	movea.l	a0,a2			;
	lea.l	object_file,a1		;擪
	dostart
		if	<cmpi.b #'.',(a0)>,eq
			movea.l	a0,a2			;Ō'.'̈ʒu
			break
		endif
	start
		subq.l	#1,a0
	while	<cmpa.l a1,a0>,hi	;擪
	move.b	#'.',(a2)+
	move.b	#'o',(a2)+
	clr.b	(a2)
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'object file: ',a1
		bsr	strcpy
		lea.l	object_file,a1		;IuWFNgt@C
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif

	.bss
object_file::
	.ds.b	1024			;IuWFNgt@C
	.text

;----------------------------------------------------------------
;R}hC
	lea.l	command_line,a0		;R}hCAR}h
	lea.l	assembler_arg,a1	;AZu
	if	<tst.b (a1)>,eq
		leastrdata	'has060',a1
	endif
	bsr	strcpy
  .if WARNING_OPTION
	leastrdata	' -w -o ',a1
  .else
	leastrdata	' -o ',a1
  .endif
	bsr	strcpy
	lea.l	object_file,a1		;IuWFNgt@C
	bsr	strcpy
	move.b	#' ',(a0)+
	lea.l	source_file,a1		;\[Xt@C
	bsr	strcpy
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'command line: ',a1
		bsr	strcpy
		lea.l	command_line,a1		;R}hCAR}h
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif

	.bss
command_line::
	.ds.b	1024			;R}hCAR}h
	.text

;----------------------------------------------------------------
;R}hCR}hƈɕ
	clr.l	-(sp)
	pea.l	command_args		;
	pea.l	command_line		;R}hCAR}h
	move.w	#2,-(sp)
	DOS	_EXEC
	lea.l	14(sp),sp
	if	<tst.l d0>,mi
		lea.l	string_buffer,a0	;obt@
		leastrdata	'cannot find ',a1
		bsr	strcpy
		lea.l	command_line,a1		;R}hCAR}h
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
  .if ERROR_OUTPUT
		bsr	eprint
  .else
		bsr	print
  .endif
		goto	abort			;~
	endif
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'command: ',a1
		bsr	strcpy
		lea.l	command_line,a1		;R}hCAR}h
		bsr	strcpy
		bsr	crlf
		leastrdata	'arguments: ',a1
		bsr	strcpy
		lea.l	command_args+1,a1	;
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif

	.bss
command_args::
	.ds.b	1024			;
	.text

  .if HIDE_ASSEMBLER

;----------------------------------------------------------------
;NULJ
	bsr	open_nul		;NULJ

;----------------------------------------------------------------
;Wnhۑ
	bsr	save_std		;Wnhۑ

;----------------------------------------------------------------
;WnhNULփ_CNg
;	AZu̕\B
	clr.w	-(sp)			;W̓nh
	move.w	nul_in_handle,-(sp)	;NUL̓nh
	DOS	_DUP2
	addq.l	#4,sp
	move.w	#1,-(sp)		;Wo̓nh
	move.w	nul_out_handle,-(sp)	;NULo̓nh
	DOS	_DUP2
	addq.l	#4,sp
	move.w	#2,-(sp)		;WG[o̓nh
	move.w	nul_out_handle,-(sp)	;NULo̓nh
	DOS	_DUP2
	addq.l	#4,sp

  .endif ;HIDE_ASSEMBLER

;----------------------------------------------------------------
;R}hs
	clr.l	-(sp)
	pea.l	command_args		;
	pea.l	command_line		;R}hCAR}h
	clr.w	-(sp)
	DOS	_EXEC
	lea.l	14(sp),sp
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'exit code: ',a1
		bsr	strcpy
		bsr	utos
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif
	if	<tst.l d0>,mi
		lea.l	string_buffer,a0	;obt@
		leastrdata	'cannot execute ',a1
		bsr	strcpy
		lea.l	command_line,a1		;R}hCAR}h
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
  .if ERROR_OUTPUT
		bsr	eprint
  .else
		bsr	print
  .endif
		goto	abort			;~
	endif
	st.b	object_created		;-1=IuWFNgt@C쐬ς

	.data
object_created::
	.dc.b	0			;-1=IuWFNgt@C쐬ς
	.text

  .if HIDE_ASSEMBLER

;----------------------------------------------------------------
;Wnh𕜌
	bsr	restore_std		;Wnh𕜌

;----------------------------------------------------------------
;NUL
	bsr	close_nul		;NUL

  .endif ;HIDE_ASSEMBLER

;----------------------------------------------------------------
;\[Xt@C
	bsr	delete_source		;\[Xt@C

;----------------------------------------------------------------
;IuWFNgt@CJ
	bsr	open_object		;IuWFNgt@CJ

;----------------------------------------------------------------
;SRAM̓eۑ
	bsr	save_sram		;SRAM̓eۑ

;----------------------------------------------------------------
;R[h̐擪AhX߂
	if	<tst.b sram_flag>,ne
		lea.l	SRAM_PROGRAM_START,a0	;SRAM풓vO̐擪
	else
		lea.l	code_buffer,a0		;R[hobt@
	endif
	move.l	a0,d0
	add.l	#256-1,d0		;256̔{ɐ؂グ
	and.w	#-256,d0
	movea.l	d0,a0
	move.l	a0,free_start		;󂫗̈̐擪AhX
	lea.l	268(a0),a0
	move.l	a0,code_start		;R[h̐擪AhX
	addq.l	#4,a0
	move.l	a0,loop_start		;[v̐擪AhX
	lea.l	32766(a0),a0
	if	<tst.b sram_flag>,ne
		if	<cmpa.l #SRAM_END-6,a0>,hi
			lea.l	SRAM_END-6,a0		;SRAM̖-6
		endif
	endif
	move.l	a0,loop_end_limit	;[v̖AhX̏
;	addq.l	#6,a0
;	move.l	a0,code_end_limit	;R[h̖AhX̏


	.bss
	.even
free_start::
	.ds.l	1			;󂫗̈̐擪AhX
code_start::
	.ds.l	1			;R[h̐擪AhX
loop_start::
	.ds.l	1			;[v̐擪AhX
loop_end_limit::
	.ds.l	1			;[v̖AhX̏
;code_end_limit::
;	.ds.l	1			;R[h̖AhX̏
code_buffer::
	.ds.b	256+268+4+32766+6	;R[hobt@
	.text

;----------------------------------------------------------------
;󂫗̈[NA
	if	<tst.b sram_flag>,ne
		unlocksram			;SRAM݋
	endif
	movea.l	free_start,a0		;󂫗̈̐擪AhX
	movea.l	code_start,a1		;R[h̐擪AhX
	moveq.l	#0,d0
	do
		move.l	d0,(a0)+
	while	<cmpa.l a1,a0>,lo
;	if	<tst.b sram_flag>,ne
;		locksram			;SRAM݋֎~
;	endif

;----------------------------------------------------------------
;IuWFNgt@CǂݍŖߗ񃋁[v
;	if	<tst.b sram_flag>,ne
;		unlocksram			;SRAM݋
;	endif
	movea.l	code_start,a0		;R[h̐擪AhX
	move.l	#$3E3C0000,(a0)+	;move.w #1-1,d7
	movea.l	a0,a3			;loop_start
	moveq.l	#0,d3			;0=s,1=
	do
		bsr	object_word
		break	mi
		if	eq			;I
			move.w	#$51CF,(a0)+		;dbra d7,(loop_start)
			move.w	a3,d0
			sub.w	a0,d0
			move.w	d0,(a0)+
			move.w	#$4E75,(a0)+		;rts
		;	bsr	cache_flush		;LbVtbV
			move.l	a0,code_end		;R[h̖AhX
			moveq.l	#1,d3			;
			break
		elifand	<cmp.w #$1000,d0>,hs,<cmp.w #$10FF,d0>,ls	;.dc܂͖
			and.w	#$00FF,d0
			addq.w	#1,d0			;
			lea.l	(a0,d0.w),a1		;
			break	<cmpa.l loop_end_limit,a1>,hi	;textZNVꂽBs
			do
				bsr	object_byte
				break2	mi
				move.b	d0,(a0)+
			while	<cmpa.l a1,a0>,lo
			move.w	a1,d0
			if	<btst.l #0,d0>,ne	;
				bsr	object_byte
				break	mi
			endif
		elif	<cmp.w #$2001,d0>,eq	;textZNV
			bsr	object_long
			break	mi
		elif	<cmp.w #$2002,d0>,eq	;dataZNV
			break	t			;dataZNVBs
		elif	<cmp.w #$2003,d0>,eq	;bssZNV
			break	t			;bssZNVBs
		elif	<cmp.w #$2004,d0>,eq	;stackZNV
			break	t			;stackZNVBs
		elif	<cmp.w #$3000,d0>,eq	;.ds
			bsr	object_long		;
			break	mi
			lea.l	(a0,d0.l),a1		;
			break	<cmpa.l loop_end_limit,a1>,hi	;textZNVꂽBs
			do
				clr.b	(a0)+
			while	<cmpa.l a1,a0>,lo
		elif	<cmp.w #$4201,d0>,eq	;textZNV̐擪̃ItZbg
			bsr	object_long		;ItZbg
			break	mi
			lea.l	4(a0),a1		;
			break	<cmpa.l loop_end_limit,a1>,hi	;textZNVꂽBs
			add.l	a3,d0			;P[gAhX
			moveq.l	#4-1,d1
			for	d1
				rol.l	#8,d0
				move.b	d0,(a0)+
			next
		elif	<cmp.w #$C001,d0>,eq	;textZNV̏
			bsr	object_long		;textZNV̒
			break	mi
			break	eq			;textZNVȂBs
			bsr	object_string
			break	mi
		elif	<cmp.w #$C002,d0>,eq	;.datȁ
			bsr	object_long		;.data̒
			break	mi
			break	ne			;.dataBs
			bsr	object_string
			break	mi
		elif	<cmp.w #$C003,d0>,eq	;.bss̏
			bsr	object_long		;.bss̒
			break	mi
			break	ne			;.bssBs
			bsr	object_string
			break	mi
		elif	<cmp.w #$C004,d0>,eq	;.stack̏
			bsr	object_long		;.stack̒
			break	mi
			break	ne			;.stackBs
			bsr	object_string
			break	mi
		elif	<cmp.w #$D000,d0>,eq	;t@C
			bsr	object_long
			break	mi
			bsr	object_string
			break	mi
		else				;̑
			break	t			;s
		endif
	while	t
	if	<tst.b sram_flag>,ne
		locksram			;SRAM݋֎~
	endif
	if	<tst.l d3>,eq		;s
		lea.l	string_buffer,a0	;obt@
		leastrdata	'cannot process ',a1
		bsr	strcpy
	;	lea.l	object_file,a1		;IuWFNgt@C
		if	<tst.b inst_arg>,ne
			move.b	#'"',(a0)+
			lea.l	inst_arg,a1		;-i ߗ
			bsr	strcpy
			move.b	#'"',(a0)+
		else
			lea.l	file_arg,a1		;-f t@C
			bsr	strcpy
		endif
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
  .if ERROR_OUTPUT
		bsr	eprint
  .else
		bsr	print
  .endif
		goto	abort			;~
	endif

	.bss
	.even
code_end::
	.ds.l	1			;R[h̖AhX
	.text

;----------------------------------------------------------------
;IuWFNgt@C
	bsr	close_object		;IuWFNgt@C

;----------------------------------------------------------------
;IuWFNgt@C
	bsr	delete_object		;IuWFNgt@C

;----------------------------------------------------------------
;ߗ񃋁[vv
	move.l	#1,repeat_count		;JԂ
	do
		if	<tst.b verbose_flag>,ne
			lea.l	string_buffer,a0	;obt@
			leastrdata	'repeat count: ',a1
			bsr	strcpy
			move.l	repeat_count,d0		;JԂ
			bsr	utos
			bsr	crlf
			lea.l	string_buffer,a0	;obt@
			bsr	print
		endif
		if	<tst.b sram_flag>,ne
			unlocksram			;SRAM݋
		endif
		move.l	repeat_count,d0		;JԂ
		subq.w	#1,d0			;JԂ-1
		movea.l	code_start,a0		;R[h̐擪AhX
		move.w	d0,2(a0)		;DBRA
		bsr	cache_flush		;LbVtbV
		if	<tst.b sram_flag>,ne
			locksram			;SRAM݋֎~
		endif
		if	<tst.b verbose_flag>,ne
			leastrdata	<'instructions loop:',13,10>,a0
			bsr	print
			bsr	dump_code		;R[h_v
		endif
		if	<tst.b sram_flag>,ne
			unlocksram			;SRAM݋
		endif
		movea.l	code_start,a0		;R[h̐擪AhX
		bsr	optime			;v
		move.l	d0,inst_loop_time	;ߗ񃋁[v̏v
		if	<tst.b sram_flag>,ne
			locksram			;SRAM݋֎~
		endif
		if	<tst.b verbose_flag>,ne
			lea.l	string_buffer,a0	;obt@
			leastrdata	'instructions loop time: ',a1
			bsr	strcpy
			move.l	inst_loop_time,d0	;ߗ񃋁[v̏v
			moveq.l	#1,d1
			bsr	time_to_string
			bsr	crlf
			lea.l	string_buffer,a0	;obt@
			bsr	print
		endif
		break	<cmpi.l #1200,inst_loop_time>,hs	;1200usȏȂΏI
		break	<cmpi.l #10000,repeat_count>,eq	;10000ȂΏI
		move.l	repeat_count,d0
		mulu.w	#10,d0			;񐔂10{ɂ
		move.l	d0,repeat_count
	while	t

	.bss
	.even
repeat_count::
	.ds.l	1			;JԂ
inst_loop_time::
	.ds.l	1			;ߗ񃋁[v̏v
	.text

;----------------------------------------------------------------
;󃋁[v
	if	<tst.b sram_flag>,ne
		unlocksram			;SRAM݋
	endif
	movea.l	code_start,a0		;R[h̐擪AhX
	move.w	#$3E3C,(a0)+		;move.w #-1,d7
	move.l	repeat_count,d0
	subq.w	#1,d0
	move.w	d0,(a0)+
	move.l	#$51CFFFFE,(a0)+	;dbra d7,(loop_start)
	move.w	#$4E75,(a0)+		;rts
	bsr	cache_flush		;LbVtbV
	move.l	a0,code_end
	if	<tst.b sram_flag>,ne
		locksram			;SRAM݋֎~
	endif
	if	<tst.b verbose_flag>,ne
		leastrdata	<'null loop:',13,10>,a0
		bsr	print
		bsr	dump_code		;R[h_v
	endif

;----------------------------------------------------------------
;󃋁[vv
	movea.l	code_start,a0		;R[h̐擪AhX
	bsr	optime			;v
	move.l	d0,null_loop_time	;󃋁[v̏v
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'null loop time: ',a1
		bsr	strcpy
		move.l	null_loop_time,d0	;󃋁[v̏v
		moveq.l	#1,d1
		bsr	time_to_string
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif

	.bss
	.even
null_loop_time::
	.ds.l	1			;󃋁[v̏v
	.text

;----------------------------------------------------------------
;SRAM̓e𕜌
	bsr	restore_sram		;SRAM̓e𕜌

;----------------------------------------------------------------
;R[h̏vԂ\
	lea.l	string_buffer,a0	;obt@
	if	<tst.b inst_arg>,ne
		move.b	#'"',(a0)+
		lea.l	inst_arg,a1		;-i ߗ
		bsr	strcpy
		move.b	#'"',(a0)+
	else
		lea.l	file_arg,a1		;-f t@C
		bsr	strcpy
	endif
	move.b	#9,(a0)+
	move.l	inst_loop_time,d0	;ߗ񃋁[v̏v
	sub.l	null_loop_time,d0	;ߗ񃋁[v̏v-󃋁[v̏v=ߗ̏v
	if	lt
		moveq.l	#0,d0
	endif
	move.l	repeat_count,d1
	bsr	time_to_string
	bsr	crlf
	lea.l	string_buffer,a0	;obt@
	bsr	print

;----------------------------------------------------------------
;I
	clr.w	exit_code		;IR[h

	.data
	.even
exit_code::
	.dc.w	1			;IR[h
	.text

;----------------------------------------------------------------
;~
abort::

;----------------------------------------------------------------
;sspusp𕜌
	if	<tst.l saved_ssp>,ne
		movea.l	saved_ssp,sp		;ۑꂽssp
		clr.l	saved_ssp		;ۑꂽssp
	endif
	if	<tst.l saved_usp>,ne
		move.l	saved_usp,a0		;ۑꂽusp
		move.l	a0,usp
		clr.l	saved_usp		;ۑꂽusp
	endif

;----------------------------------------------------------------
;A{[gxN^𕜌
	if	<tst.l saved_ctrlvc>,ne
		move.l	saved_ctrlvc,-(sp)	;ۑꂽ_CTRLVC
		move.w	#_CTRLVC,-(sp)
		DOS	_INTVCS
		addq.l	#6,sp
		clr.l	saved_ctrlvc		;ۑꂽ_CTRLVC
	endif
	if	<tst.l saved_errjvc>,ne
		move.l	saved_errjvc,-(sp)	;ۑꂽ_ERRJVC
		move.w	#_ERRJVC,-(sp)
		DOS	_INTVCS
		addq.l	#6,sp
		clr.l	saved_errjvc		;ۑꂽ_ERRJVC
	endif

;----------------------------------------------------------------
;^C}𕜌
	bsr	restore_timer		;^C}𕜌

  .if HIDE_ASSEMBLER

;----------------------------------------------------------------
;Wnh𕜌
	bsr	restore_std		;Wnh𕜌

;----------------------------------------------------------------
;NUL
	bsr	close_nul		;NUL

  .endif ;HIDE_ASSEMBLER

;----------------------------------------------------------------
;\[Xt@C
	bsr	delete_source		;\[Xt@C

;----------------------------------------------------------------
;IuWFNgt@C
	bsr	close_object		;IuWFNgt@C

;----------------------------------------------------------------
;IuWFNgt@C
	bsr	delete_object		;IuWFNgt@C

;----------------------------------------------------------------
;SRAM̓e𕜌
	bsr	restore_sram		;SRAM̓e𕜌

;----------------------------------------------------------------
;[U[h֕A
	usermode

;----------------------------------------------------------------
;I
	move.w	exit_code,-(sp)		;IR[h
	DOS	_EXIT2


;----------------------------------------------------------------
;^CgƎgp@\ďI
usage_exit::
	lea.l	title_usage,a0		;^CgƎgp@
  .if ERROR_OUTPUT
	bsr	eprint
  .else
	bsr	print
  .endif
	move.w	#1,-(sp)
	DOS	_EXIT2

	.data
title_usage::
	.dc.b	TITLE_STRING,13,10
	.dc.b	'Measure the execution time of instructions',13,10
	.dc.b	'  -a has060  Assembler',13,10
	.dc.b	'  -f nop.s   File containing instructions',13,10
	.dc.b	'  -i "nop"   Semicolon-delimited instructions',13,10
	.dc.b	'  -s         Measure in SRAM. Ask when SRAM in use',13,10
	.dc.b	'  -sn        Same as -s but not measure when SRAM in use',13,10
	.dc.b	'  -sy        Same as -s but measure even when SRAM in use',13,10
	.dc.b	'  -t %temp%  Temporary directory',13,10
	.dc.b	'  -v         Output verbose messages',13,10
	.dc.b	0			;^CgƎgp@
	.text


;----------------------------------------------------------------
;1̎Ԃ𕶎ɕϊ
;<d0.l:(us)B0`12799
;<d1.w:񐔁B1,10,100,1000,10000̂ꂩ
;<a0.l:obt@
;>a0.l:̖0̈ʒu
time_to_string::
	push	d0-d3/a1-a2
	movea.l	a0,a1
;<a1.l:擪
	bsr	utos
;<a0.l:
	move.w	a0,d0
	sub.w	a1,d0
;<d0.w:Ŝ̌B0us1
	moveq.l	#0,d2
	moveq.l	#1,d3
	docontinue
		addq.w	#1,d2
		mulu.w	#10,d3
	while	<cmp.w d3,d1>,hi
;<d2.w:̌B0ȏ
	move.w	d0,d1
	sub.w	d2,d1
;<d1.w:̌
	moveq.l	#'u',d3
	if	<cmp.w #3,d1>,gt	;us̐4ȏ゠Bmsɂ
		addq.w	#3,d2
		subq.w	#3,d1
		moveq.l	#'m',d3
	endif
;<d3.b:PʁB'u'܂'m'
	if	<tst.w	d1>,le		;ȂB(a1)'0.''0'-d1}
		neg.w	d1
		lea.l	2(a1,d1.w),a2		;(a1)̈ړ
		lea.l	(a2,d0.w),a0		;V
		for	d0
			move.b	(a1,d0.w),(a2,d0.w)	;0ƑŜ炷
		next
		move.b	#'0',(a1)+
		move.b	#'.',(a1)+
		forcontinue	d1
			move.b	#'0',(a1)+
		next
	elif	<tst.w	d2>,gt		;B(a1,d1.w)'.'}
		adda.w	d1,a1			;'.'}ʒu
		lea.l	1(a1),a2		;(a1)̈ړ
		addq.l	#1,a0			;V
		for	d2
			move.b	(a1,d2.w),(a2,d2.w)	;0Ə炷
		next
		move.b	#'.',(a1)+
	endif
	move.b	#' ',(a0)+
	move.b	d3,(a0)+
	move.b	#'s',(a0)+
	clr.b	(a0)
	pop
	rts


  .if HIDE_ASSEMBLER

;----------------------------------------------------------------
;Wnhۑ
save_std::
	clr.w	-(sp)			;W̓nh
	DOS	_DUP
	addq.l	#2,sp
	move.w	d0,saved_stdin		;ۑꂽW̓nh
	move.w	#1,-(sp)		;Wo̓nh
	DOS	_DUP
	addq.l	#2,sp
	move.w	d0,saved_stdout		;ۑꂽWo̓nh
	move.w	#2,-(sp)		;WG[o̓nh
	DOS	_DUP
	addq.l	#2,sp
	move.w	d0,saved_stderr		;ۑꂽWG[o̓nh
	rts

	.data
	.even
saved_stdin::
	.dc.w	-1			;ۑꂽW̓nh
saved_stdout::
	.dc.w	-1			;ۑꂽWo̓nh
saved_stderr::
	.dc.w	-1			;ۑꂽWG[o̓nh
	.text

;----------------------------------------------------------------
;Wnh𕜌
restore_std::
	if	<cmpi.w #-1,saved_stdin>,ne
		clr.w	-(sp)			;W̓nh
		move.w	saved_stdin,-(sp)	;ۑꂽW̓nh
		DOS	_DUP2
		DOS	_CLOSE
		addq.l	#4,sp
		move.w	#-1,saved_stdin		;ۑꂽW̓nh
	endif
	if	<cmpi.w #-1,saved_stdout>,ne
		move.w	#1,-(sp)		;Wo̓nh
		move.w	saved_stdout,-(sp)	;ۑꂽWo̓nh
		DOS	_DUP2
		DOS	_CLOSE
		addq.l	#4,sp
		move.w	#-1,saved_stdout	;ۑꂽWo̓nh
	endif
	if	<cmpi.w #-1,saved_stderr>,ne
		move.w	#2,-(sp)		;WG[o̓nh
		move.w	saved_stderr,-(sp)	;ۑꂽWG[o̓nh
		DOS	_DUP2
		DOS	_CLOSE
		addq.l	#4,sp
		move.w	#-1,saved_stderr	;ۑꂽWG[o̓nh
	endif
	rts

;----------------------------------------------------------------
;NULJ
open_nul::
	clr.w	-(sp)			;
	peastrdata	'nul'
	DOS	_OPEN
	addq.l	#6,sp
	move.w	d0,nul_in_handle	;NUL̓nh
	move.w	#1,-(sp)		;o
	peastrdata	'nul'
	DOS	_OPEN
	addq.l	#6,sp
	move.w	d0,nul_out_handle	;NULo̓nh
	rts

	.data
	.even
nul_in_handle::
	.dc.w	-1			;NUL̓nh
nul_out_handle::
	.dc.w	-1			;NULo̓nh
	.text

;----------------------------------------------------------------
;NUL
close_nul::
	if	<cmpi.w #-1,nul_in_handle>,ne
		move.w	nul_in_handle,-(sp)		;NUL̓nh
		DOS	_CLOSE
		addq.l	#2,sp
		move.w	#-1,nul_in_handle		;NUL̓nh
	endif
	if	<cmpi.w #-1,nul_out_handle>,ne
		move.w	nul_out_handle,-(sp)		;NULo̓nh
		DOS	_CLOSE
		addq.l	#2,sp
		move.w	#-1,nul_out_handle		;NULo̓nh
	endif
	rts

  .endif ;HIDE_ASSEMBLER

;----------------------------------------------------------------
;\[Xt@C
create_source::
	if	<tst.b inst_arg>,ne
		lea.l	source_file,a0		;\[Xt@C
		lea.l	temp_directory,a1	;e|fBNg
		bsr	strcpy
		leastrdata	'opti????.s',a1
		bsr	strcpy
		move.w	#$0020,-(sp)
		pea.l	source_file		;\[Xt@C
		DOS	_MAKETMP
		addq.l	#6,sp
		move.l	d0,d1
		if	mi
			lea.l	string_buffer,a0	;obt@
			leastrdata	'cannot create ',a1
			bsr	strcpy
			lea.l	source_file,a1		;\[Xt@C
			bsr	strcpy
			bsr	crlf
			lea.l	string_buffer,a0	;obt@
  .if ERROR_OUTPUT
			bsr	eprint
  .else
			bsr	print
  .endif
			goto	abort			;~
		endif
		st.b	source_created		;\[Xt@C쐬ς݃tO
		move.w	d1,-(sp)
		pea.l	source_code		;\[XR[h
		DOS	_FPUTS
		addq.l	#6,sp
		move.w	d1,-(sp)
		DOS	_CLOSE
		addq.l	#2,sp
	else
		lea.l	source_file,a0		;\[Xt@C
		lea.l	file_arg,a1		;-f t@C
		bsr	strcpy
	endif
	if	<tst.b verbose_flag>,ne
		lea.l	string_buffer,a0	;obt@
		leastrdata	'source file: ',a1
		bsr	strcpy
		lea.l	source_file,a1		;\[Xt@C
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
		bsr	print
	endif
	rts

	.data
source_created::
	.dc.b	0			;\[Xt@C쐬ς݃tO
	.bss
source_file::
	.ds.b	1024			;\[Xt@C
	.text

;----------------------------------------------------------------
;\[Xt@C
delete_source::
	if	<tst.b source_created>,ne
		pea.l	source_file		;\[Xt@C
		DOS	_DELETE
		addq.l	#4,sp
		sf.b	source_created		;\[Xt@C쐬ς݃tO
	endif
	rts

;----------------------------------------------------------------
;IuWFNgt@CJ
open_object::
	clr.w	-(sp)
	pea.l	object_file		;IuWFNgt@C
	DOS	_OPEN
	addq.l	#6,sp
	if	<tst.l d0>,mi
		lea.l	string_buffer,a0	;obt@
		leastrdata	'cannot open ',a1
		bsr	strcpy
		lea.l	object_file,a1		;IuWFNgt@C
		bsr	strcpy
		bsr	crlf
		lea.l	string_buffer,a0	;obt@
  .if ERROR_OUTPUT
		bsr	eprint
  .else
		bsr	print
  .endif
		goto	abort			;~
	endif
	move.w	d0,object_handle
	rts

	.data
	.even
object_handle::
	.dc.w	-1			;IuWFNgt@Cnh
	.text

;----------------------------------------------------------------
;IuWFNgt@C
close_object::
	if	<cmpi.w #-1,object_handle>,ne
		move.w	object_handle,-(sp)	;IuWFNgt@Cnh
		DOS	_CLOSE
		addq.l	#2,sp
		move.w	#-1,object_handle	;IuWFNgt@Cnh
	endif
	rts

;----------------------------------------------------------------
;IuWFNgt@C
delete_object::
	if	<tst.b object_created>,ne
		pea.l	object_file		;IuWFNgt@C
		DOS	_DELETE
		addq.l	#4,sp
		sf.b	object_created		;-1=IuWFNgt@C쐬ς
	endif
	rts

;----------------------------------------------------------------
;SRAM̓eۑ
save_sram::
	if	<tst.b sram_flag>,ne
		lea.l	sram_data,a0		;ۑꂽSRAMf[^
		lea.l	$00ED0100,a1
		move.w	#$3F00/4-1,d0
		for	d0
			move.l	(a1)+,(a0)+
		next
		st.b	sram_saved		;SRAMۑς݃tO
	endif
	rts

	.data
sram_saved::
	.dc.b	0			;SRAMۑς݃tO
	.bss
	.even
sram_data::
	.ds.l	$3F00/4			;ۑꂽSRAMf[^
	.text

;----------------------------------------------------------------
;SRAM̓e𕜌
restore_sram::
	if	<tst.b sram_saved>,ne
		unlocksram			;SRAM݋
		lea.l	$00ED0100,a0
		lea.l	sram_data,a1		;ۑꂽSRAMf[^
		move.w	#$3F00/4-1,d0
		for	d0
			move.l	(a1)+,(a0)+
		next
		locksram			;SRAM݋֎~
		sf.b	sram_saved		;SRAMۑς݃tO
	endif
	rts


;----------------------------------------------------------------
;R[h_v
dump_code::
	push	d0/a0-a4
	movea.l	code_start,a3		;R[h̐擪AhX
	move.l	a3,d0
	and.w	#-16,d0			;16̔{ɐ؂̂Ă
	movea.l	d0,a1			;\JnAhX
	movea.l	code_end,a4		;R[h̖AhX
	move.l	a4,d0
	add.l	#16-1,d0		;16̔{ɐ؂グ
	and.w	#-16,d0
	movea.l	d0,a2			;\IAhX
	docontinue
		move.l	a1,d0
		and.w	#16-1,d0
		if	eq
			lea.l	string_buffer,a0	;obt@
			move.l	a1,d0
			bsr	h8tos
			move.b	#' ',(a0)+
		endif
		move.b	#' ',(a0)+
		ifand	<cmpa.l a3,a1>,hs,<cmpa.l a4,a1>,lo	;R[h͈͓̔
			move.w	(a1),d0
			bsr	h4tos
		else				;R[h͈̔͊O
			move.b	#'.',(a0)+
			move.b	#'.',(a0)+
			move.b	#'.',(a0)+
			move.b	#'.',(a0)+
		endif
		addq.l	#2,a1
		move.l	a1,d0
		and.w	#16-1,d0
		if	eq
			bsr	crlf
			lea.l	string_buffer,a0	;obt@
			bsr	print
		endif
	while	<cmpa.l a2,a1>,lo
	pop
	rts


;----------------------------------------------------------------
;vTu[`
;	X[p[oCU[hŌĂяo
;<a0.l:vTu[`Bd0-d7/a0-a4RɎg
;>d0.l:v(us)B0`12799
optime::
	push	d1-d7/a0-a6
	movea.l	a0,a5
aTCDCR	reg	a6
	lea.l	MFP_TCDCR,aTCDCR
;荞݋֎~
	di
;^C}ۑ
	lea.l	timer_ierb(pc),a0
	move.b	MFP_IERB-MFP_TCDCR(aTCDCR),(a0)	;timer_ierb
	move.b	MFP_IMRB-MFP_TCDCR(aTCDCR),-(a0)	;timer_imrb
	move.b	MFP_TCDCR-MFP_TCDCR(aTCDCR),-(a0)	;timer_tcdcr
	st.b	-(a0)			;timer_saved
;^C}ݒ
	andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IERB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞ݒ~
	andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IMRB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞݋֎~
	move.b	#0,(aTCDCR)		;Timer-C/DJEg~
	do
	while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂
;n[TƖ{
	clr.b	-(sp)			;$00=n[T,$FF={
	do
	;JEgJn
		move.b	#0,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^NA
		move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
		move.b	#MFP_50US<<4|MFP_1US,(aTCDCR)	;Timer-C/DJEgJn
						;Timer-C1/200vXP[(50us)
						;Timer-D1/4vXP[(1us)
	;v
		jsr	(a5)
	;JEg~
		move.b	#0,(aTCDCR)		;Timer-C/DJEg~
		do
		while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂
		not.b	(sp)
	while	ne
	tst.b	(sp)+
;^C}擾
	moveq.l	#0,d0
	moveq.l	#0,d1
	sub.b	MFP_TCDR-MFP_TCDCR(aTCDCR),d0	;Timer-CJEg
	sub.b	MFP_TDDR-MFP_TCDCR(aTCDCR),d1	;Timer-DJEg(I[o[t[)
;^C}
	lea.l	timer_saved(pc),a0
	move.b	#200,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^
	move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
	sf.b	(a0)+				;timer_saved
	move.b	(a0)+,(aTCDCR)			;timer_tcdcr
	move.b	(a0)+,MFP_IMRB-MFP_TCDCR(aTCDCR)	;timer_imrb
	move.b	(a0),MFP_IERB-MFP_TCDCR(aTCDCR)	;timer_ierb
;荞݋
	ei
;JE^
	mulu.w	#50,d0
	if	<cmp.b d1,d0>,hi
		add.w	#256,d0
	endif
	move.b	d1,d0
	move.l	d0,d1
;I
	move.l	d1,d0
	pop
	rts

;^C}𕜌
restore_timer::
	push	a0/a6
	lea.l	MFP_TCDCR,aTCDCR
	lea.l	timer_saved(pc),a0
	if	<tst.b (a0)>,ne
		di
		move.b	#200,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^
		move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
		sf.b	(a0)+				;timer_saved
		move.b	(a0)+,(aTCDCR)			;timer_tcdcr
		move.b	(a0)+,MFP_IMRB-MFP_TCDCR(aTCDCR)	;timer_imrb
		move.b	(a0),MFP_IERB-MFP_TCDCR(aTCDCR)	;timer_ierb
		ei
	endif
	pop
	rts

	.data
timer_saved::
	.dc.b	0			;-1=ȉۑς
timer_tcdcr::
	.dc.b	0			;ۑꂽTCDCR
timer_imrb::
	.dc.b	0			;ۑꂽIMRB
timer_ierb::
	.dc.b	0			;ۑꂽIERB
	.text


;----------------------------------------------------------------
;IuWFNgt@C̕ǂݔ΂
;>d0.l:ǂݔ΂oCgB0܂ށB
object_string::
	push	d1
	moveq.l	#0,d1
	do
		do
			addq.l	#1,d1
			bsr	object_byte
			break2	mi
		while	ne
		if	<btst.l #0,d1>,ne
			addq.l	#1,d1
			bsr	object_byte
			break	mi
		endif
		move.l	d1,d0
	while	f
	pop
	tst.l	d0
	rts

;----------------------------------------------------------------
;IuWFNgt@C1O[hǂݏo
;>d0.l:ǂݏof[^
object_long::
	clr.l	-(sp)
	do
		bsr	object_byte
		break	mi
		move.b	d0,(sp)
		bsr	object_byte
		break	mi
		move.b	d0,1(sp)
		bsr	object_byte
		break	mi
		move.b	d0,2(sp)
		bsr	object_byte
		break	mi
		move.b	d0,3(sp)
		move.l	(sp),d0
	while	f
	addq.l	#4,sp
	rts

;----------------------------------------------------------------
;IuWFNgt@C1[hǂݏo
;>d0.l:ǂݏof[^
object_word::
	clr.l	-(sp)
	do
		bsr	object_byte
		break	mi
		move.b	d0,2(sp)
		bsr	object_byte
		break	mi
		move.b	d0,3(sp)
		move.l	(sp),d0
	while	f
	addq.l	#4,sp
	rts

;----------------------------------------------------------------
;IuWFNgt@C1oCgǂݏo
;>d0.l:ǂݏof[^
object_byte::
	move.w	object_handle,-(sp)
	DOS	_FGETC
	addq.l	#2,sp
	if	<tst.l d0>,pl
		and.l	#$000000FF,d0
	endif
	rts


;----------------------------------------------------------------
;Rs[
;	󔒂ǂݔ΂Ă玟̋󔒂̎O܂ŃRs[
;	"`"܂'`'ň͂ނƈɋ󔒂܂߂邱Ƃł
;	""܂''Əƒ0̈^邱Ƃł
;<a0.l:Rs[̃obt@̐擪
;<a1.l:Rs[̐̕擪
;>d0.l:0=Ȃ,1=
;>a0.l:Rs[̖̕0̈ʒu
;>a1.l:Rs[̈̒BȂ΃Rs[̖̕0̈ʒu
;>eq=Ȃ,ne=
argcpy::
	exg.l	a0,a1
	bsr	nonspace		;󔒂ǂݔ΂
	exg.l	a0,a1
	if	eq			;Ȃ
		clr.b	(a0)
		moveq.l	#0,d0
		rts
	endif
	dostart
		if	<cmp.b #'"',d0>,eq	;"`"
			dostart
				move.b	d0,(a0)+		;
			start
				move.b	(a1)+,d0		;̕
				break2	eq			;I
			while	<cmp.b #'"',d0>,ne
		elif	<cmp.b #39,d0>,eq	;'`'
			dostart
				move.b	d0,(a0)+		;
			start
				move.b	(a1)+,d0		;̕
				break2	eq			;I
			while	<cmp.b #$39,d0>,ne
		else
			move.b	d0,(a0)+		;
		endif
	start
		move.b	(a1)+,d0		;̕
		break	eq			;I
		breakand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΏI
	while	<cmp.b #' ',d0>,ne	;󔒂łȂΌJԂ
	subq.l	#1,a1			;i݉߂߂
	clr.b	(a0)
	moveq.l	#1,d0
	rts

;----------------------------------------------------------------
;LbVtbV
cache_flush::
	push	d0-d1
	if	<is68000 d0>,ne
		moveq.l	#3,d1
		IOCS	_SYS_STAT
	endif
	pop
	rts

;----------------------------------------------------------------
;sRs[
;<a0.l:Rs[
;>a0.l:Rs[0̈ʒu
crlf::
	move.b	#13,(a0)+
	move.b	#10,(a0)+
	clr.b	(a0)
	rts

  .if ERROR_OUTPUT
;----------------------------------------------------------------
;G[\
;<a0.l:̐擪
;>a0.l:̐擪
eprint::
	push	d0
	bsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#2,-(sp)
	DOS	_WRITE
	lea.l	(10,sp),sp
	pop
	rts
  .endif

;----------------------------------------------------------------
;Ȃ16i4̕ɕϊ
;<d0.w:Ȃ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
h4tos::
	push	d1-d2
	moveq.l	#4-1,d1
	for	d1
		rol.w	#4,d0
		moveq.l	#15,d2
		and.w	d0,d2
		move.b	h8tos_hex(pc,d2.w),(a0)+
	next
	clr.b	(a0)
	pop
	rts

;----------------------------------------------------------------
;Ȃ16i8̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
h8tos::
	push	d1-d2
	moveq.l	#8-1,d1
	for	d1
		rol.l	#4,d0
		moveq.l	#15,d2
		and.w	d0,d2
		move.b	h8tos_hex(pc,d2.w),(a0)+
	next
	clr.b	(a0)
	pop
	rts

h8tos_hex:
	.dc.b	'0123456789ABCDEF'
	.even

;----------------------------------------------------------------
;󔒈ȊO̕܂œǂݔ΂
;<a0.l:
;>d0.l:󔒈ȊO̕܂0
;>a0.l:󔒈ȊO̕܂0̈ʒu
;>z:eq=0
nonspace::
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		redoand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΌJԂ
	while	<cmp.b #' ',d0>,eq	;󔒂ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

;----------------------------------------------------------------
;\
;<a0.l:̐擪
;>a0.l:̐擪
print::
	push	d0
	bsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	(10,sp),sp
	pop
	rts

;----------------------------------------------------------------
;𖖔܂œǂݔ΂
;<a0.l:̐擪
;>a0.l:̖0̈ʒu
strchr0::
	do
		tst.b	(a0)+
	while	ne
	subq.l	#1,a0
	rts

;----------------------------------------------------------------
;Rs[
;<a0.l:Rs[
;<a1.l:Rs[
;>a0.l:Rs[0̈ʒu
;>a1.l:Rs[0̎̈ʒu
strcpy::
	do
		move.b	(a1)+,(a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	rts

;----------------------------------------------------------------
;̒𐔂
;<a0.l:
;>d0.l:
strlen::
	move.l	a0,d0			;d0=擪
	do
		tst.b (a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂Ba0=
	exg.l	d0,a0			;d0=,a0=擪
	sub.l	a0,d0			;d0=-擪=
	rts

;----------------------------------------------------------------
;ɂ
;<d0.b:
;>d0.b:
tolower::
	ifand	<cmp.b #'A',d0>,hs,<cmp.b #'Z',d0>,ls	;啶
		add.b	#'a'-'A',d0		;ɂ
	endif
	rts

;----------------------------------------------------------------
;Ȃ10i̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
utos::
	push	d0-d2/a1
	if	<tst.l d0>,eq
		move.b	#'0',(a0)+
	else
		lea.l	utos_table(pc),a1
		do
			move.l	(a1)+,d1
		while	<cmp.l d1,d0>,lo	;Ƃ܂Ői
		do
			moveq.l	#'0'-1,d2
			do
				addq.b	#1,d2
				sub.l	d1,d0
			while	hs			;񐔂𐔂
			move.b	d2,(a0)+
			add.l	d1,d0			;߂
			move.l	(a1)+,d1
		while	ne
	endif
	clr.b	(a0)
	pop
	rts

utos_table::
	.dc.l	1000000000
	.dc.l	100000000
	.dc.l	10000000
	.dc.l	1000000
	.dc.l	100000
	.dc.l	10000
	.dc.l	1000
	.dc.l	100
	.dc.l	10
	.dc.l	1
	.dc.l	0

;----------------------------------------------------------------
;y/n͑҂
;	bZ[W\y܂n͂܂ő҂ĉs
;	^CŒfł
;<a0.l:bZ[W
;>d0.l:'y'=yes,'n'=no
yesno::
	push	a0
	bsr	print
	do
		DOS	_GETCHAR		;W͂1oCg(Wo͂ɃGR[obN)
		bsr	tolower
	whileand	<cmp.b #'y',d0>,ne,<cmp.b #'n',d0>,ne
	leastrdata	<13,10>,a0
	bsr	print
	pop
	rts

;----------------------------------------------------------------
;vOI
	.end	program_start
