;========================================================================================
;  crtcmmtest.s
;  Copyright (C) 2003-2021 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	doscall.mac


;--------------------------------------------------------------------------------
;macros

leastr	.macro	s0,an
	.data
@str:
	.dc.b	s0,0
	.text
	lea.l	@str,an
	.endm

peastr	.macro	s0,s1,s2,s3,s4,s5,s6,s7,s8,s9
	.data
@str:
	.dc.b	s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,0
	.text
	pea.l	@str
	.endm

print	.macro	s0,s1,s2,s3,s4,s5,s6,s7,s8,s9
	peastr	s0,s1,s2,s3,s4,s5,s6,s7,s8,s9
	jbsr	print_by_write
	addq.l	#4,sp
	.endm

putchar	.macro	c0
	move.w	c0,-(sp)
	jbsr	putchar_by_write
	addq.l	#2,sp
	.endm


;--------------------------------------------------------------------------------
;main

	.text
	.even

main:

;start
	bsr	test_start

	clr.l	-(sp)
	DOS	_SUPER
	move.l	d0,(sp)
;supervisor mode

	lea.l	$00e80028,a4		;CRTC R20
	move.b	(a4),-(sp)		;save memory mode

	move.w	$00e82600,-(sp)
	andi.w	#$ffe0,$00e82600	;disable graphic screen

	bsr	area_check
	tst.l	test_failed
	bne	finish

;fill graphic screen
	move.b	#3,(a4)			;memory mode 3
	lea.l	$00c00000,a0
	moveq.l	#$ffffffff,d0
	move.l	d0,d1
	move.l	d0,d2
	move.l	d0,d3
	move.l	d0,d4
	move.l	d0,d5
	move.l	d0,d6
	movea.l	d0,a1
	move.w	#2048-1,d7		;4*8*8*2048=524288
@@:
  .irp i,0,1,2,3,4,5,6,7
	movem.l	d0-d6/a1,4*8*i(a0)
  .endm
	lea.l	4*8*8(a0),a0
	dbra	d7,@b

;loop
	cmpi.b	#6,$0CBC.w
	beq	1f
	lea.l	data_table_030,a5
	bra	2f
1:	lea.l	data_table_060,a5
2:
	bra	209f

201:
	movea.l	(a5)+,a3
	bra	109f

101:
	move.b	(a3)+,d1		;memory mode
	move.b	(a3)+,d2		;access mode
	move.w	(a3)+,d3		;vram content before access
	movea.l	(a3)+,a1		;address
	movea.l	(a3)+,a2		;even address in memory mode 3
	move.w	(a3)+,d4		;expected read data or written data
	move.w	(a3)+,d5		;expected vram content after access

	move.b	#3,(a4)			;memory mode 3
	move.w	(a2),-(sp)		;save vram content
	move.w	d3,(a2)			;vram content before access

	move.b	d1,(a4)			;memory mode

	tst.b	d2			;access mode
	bne	11f
;read byte
	clr.w	d6
	move.b	(a1),d6			;actual read data
	bra	14f

11:
	cmp.b	#2,d2
	bcc	12f
;read word
	move.w	(a1),d6			;actual read data
	bra	14f

12:
	bne	13f
;write byte
	move.w	d4,d6
	move.b	d4,(a1)			;written data
	bra	14f

13:
;write word
	move.w	d4,d6
	move.w	d4,(a1)			;written data
14:

	move.b	#3,(a4)			;memory mode 3
	move.w	(a2),d7			;actual vram content after access
	move.w	(sp)+,(a2)		;restore vram content

;check
	bsr	test_check

109:
	tst.l	(a3)
	bpl	101b

209:
	tst.l	(a5)
	bne	201b

;clear graphic screen
	move.b	#3,(a4)			;memory mode 3
	lea.l	$00c00000,a0
	moveq.l	#$00000000,d0
	move.l	d0,d1
	move.l	d0,d2
	move.l	d0,d3
	move.l	d0,d4
	move.l	d0,d5
	move.l	d0,d6
	movea.l	d0,a1
	move.w	#2048-1,d7		;4*8*8*2048=524288
@@:
  .irp i,0,1,2,3,4,5,6,7
	movem.l	d0-d6/a1,4*8*i(a0)
  .endm
	lea.l	4*8*8(a0),a0
	dbra	d7,@b

finish:
	move.w	(sp)+,$00e82600

	move.b	(sp)+,(a4)		;restore memory mode

	DOS	_SUPER
	addq.l	#4,sp
;user mode

;end
	bsr	test_end

exit:
	DOS	_EXIT


;--------------------------------------------------------------------------------
;area check

	.text
	.even

area_check:
	movem.l	d0-d1/a0-a1,-(sp)
	moveq.l	#0,d0			;bus error status

	move.w	sr,-(sp)
	ori.w	#$0700,sr

	move.l	$0008.w,-(sp)
	move.l	#buserr,$0008.w

	movea.l	sp,a1
	moveq.l	#0,d1			;memory mode
1:
	move.b	d1,$00e80028
  .irp addr,$00c00000,$00c80000,$00d00000,$00d80000
	add.l	d0,d0
	lea.l	@f(pc),a0
	tst.w	addr
@@:
  .endm
	addq.b	#1,d1
	cmp.b	#8,d1
	blo	1b

	move.l	(sp)+,$0008.w

	move.w	(sp)+,sr

	addq.l	#1,test_tested
	move.l	d0,d1
	move.l	bus_error_status,d0
	cmp.l	d0,d1
	beq	9f
	addq.l	#1,test_failed
;expected
	print	9,'.dc.l',9
	bsr	print_hex8
	print	9,';expected',13,10
;actual
	print	9,'.dc.l',9
	move.l	d1,d0
	bsr	print_hex8
	print	9,';actual',13,10
9:

	movem.l	(sp)+,d0-d1/a0-a1
	rts

buserr:
	addq.b	#1,d0
	movea.l	a1,sp
	jmp	(a0)


;--------------------------------------------------------------------------------
;data

	.text

;bus error status
;	bit31	memory mode 0	$00c00000	0=exists,1=not exists
;	bit30			$00c80000
;	bit29			$00d00000
;	bit28			$00d80000
;	bit27	memory mode 1	$00c00000
;			:
;	bit4	memory mode 6	$00d80000
;	bit3	memory mode 7	$00c00000
;	bit2			$00c80000
;	bit1			$00d00000
;	bit0			$00d80000
	.align	4
bus_error_status:
	.dc.l	$03070000

	.align	4
data_table_030:
	.dc.l	memory_mode_0
	.dc.l	memory_mode_1
	.dc.l	memory_mode_2_030
	.dc.l	memory_mode_3
	.dc.l	memory_mode_4
	.dc.l	memory_mode_5
	.dc.l	memory_mode_6
	.dc.l	memory_mode_7
	.dc.l	0
data_table_060:
	.dc.l	memory_mode_0
	.dc.l	memory_mode_1
	.dc.l	memory_mode_2_060
	.dc.l	memory_mode_3
	.dc.l	memory_mode_4
	.dc.l	memory_mode_5
	.dc.l	memory_mode_6
	.dc.l	memory_mode_7
	.dc.l	0

;	+0	memory mode<<24|access mode<<16|vram content before access
;			access mode	0=read byte,1=read word,2=write byte,3=write word
;	+4	address
;	+8	even address in memory mode 3
;	+12	expected read data or written data<<16|expected vram content after access

memory_mode_0:
;	+--------------------------+
;	| 0x00c00000 .. 0x00c003ff |
;	| 0x00c00400    0x00c007ff |
;	|      :             :     |
;	| 0x00c7f800    0x00c7fbff |
;	| 0x00c7fc00 .. 0x00c7ffff |
;	+--------------------------+
;read byte
	.dc.l	$00001234,$00c00000,$00c00000,$00001234
	.dc.l	$00001234,$00c00001,$00c00000,$00041234
	.dc.l	$00001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$00001234,$00c003ff,$00c003fe,$00041234
	.dc.l	$00001234,$00c00400,$00c00400,$00001234
	.dc.l	$00001234,$00c00401,$00c00400,$00041234
	.dc.l	$00001234,$00c007fe,$00c007fe,$00001234
	.dc.l	$00001234,$00c007ff,$00c007fe,$00041234
	.dc.l	$00001234,$00c7f800,$00c7f800,$00001234
	.dc.l	$00001234,$00c7f801,$00c7f800,$00041234
	.dc.l	$00001234,$00c7fbfe,$00c7fbfe,$00001234
	.dc.l	$00001234,$00c7fbff,$00c7fbfe,$00041234
	.dc.l	$00001234,$00c7fc00,$00c7fc00,$00001234
	.dc.l	$00001234,$00c7fc01,$00c7fc00,$00041234
	.dc.l	$00001234,$00c7fffe,$00c7fffe,$00001234
	.dc.l	$00001234,$00c7ffff,$00c7fffe,$00041234
	.dc.l	$00001234,$00c80000,$00c00000,$00001234
	.dc.l	$00001234,$00c80001,$00c00000,$00031234
	.dc.l	$00001234,$00c803fe,$00c003fe,$00001234
	.dc.l	$00001234,$00c803ff,$00c003fe,$00031234
	.dc.l	$00001234,$00c80400,$00c00400,$00001234
	.dc.l	$00001234,$00c80401,$00c00400,$00031234
	.dc.l	$00001234,$00c807fe,$00c007fe,$00001234
	.dc.l	$00001234,$00c807ff,$00c007fe,$00031234
	.dc.l	$00001234,$00cff800,$00c7f800,$00001234
	.dc.l	$00001234,$00cff801,$00c7f800,$00031234
	.dc.l	$00001234,$00cffbfe,$00c7fbfe,$00001234
	.dc.l	$00001234,$00cffbff,$00c7fbfe,$00031234
	.dc.l	$00001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$00001234,$00cffc01,$00c7fc00,$00031234
	.dc.l	$00001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$00001234,$00cfffff,$00c7fffe,$00031234
	.dc.l	$00001234,$00d00000,$00c00000,$00001234
	.dc.l	$00001234,$00d00001,$00c00000,$00021234
	.dc.l	$00001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$00001234,$00d003ff,$00c003fe,$00021234
	.dc.l	$00001234,$00d00400,$00c00400,$00001234
	.dc.l	$00001234,$00d00401,$00c00400,$00021234
	.dc.l	$00001234,$00d007fe,$00c007fe,$00001234
	.dc.l	$00001234,$00d007ff,$00c007fe,$00021234
	.dc.l	$00001234,$00d7f800,$00c7f800,$00001234
	.dc.l	$00001234,$00d7f801,$00c7f800,$00021234
	.dc.l	$00001234,$00d7fbfe,$00c7fbfe,$00001234
	.dc.l	$00001234,$00d7fbff,$00c7fbfe,$00021234
	.dc.l	$00001234,$00d7fc00,$00c7fc00,$00001234
	.dc.l	$00001234,$00d7fc01,$00c7fc00,$00021234
	.dc.l	$00001234,$00d7fffe,$00c7fffe,$00001234
	.dc.l	$00001234,$00d7ffff,$00c7fffe,$00021234
	.dc.l	$00001234,$00d80000,$00c00000,$00001234
	.dc.l	$00001234,$00d80001,$00c00000,$00011234
	.dc.l	$00001234,$00d803fe,$00c003fe,$00001234
	.dc.l	$00001234,$00d803ff,$00c003fe,$00011234
	.dc.l	$00001234,$00d80400,$00c00400,$00001234
	.dc.l	$00001234,$00d80401,$00c00400,$00011234
	.dc.l	$00001234,$00d807fe,$00c007fe,$00001234
	.dc.l	$00001234,$00d807ff,$00c007fe,$00011234
	.dc.l	$00001234,$00dff800,$00c7f800,$00001234
	.dc.l	$00001234,$00dff801,$00c7f800,$00011234
	.dc.l	$00001234,$00dffbfe,$00c7fbfe,$00001234
	.dc.l	$00001234,$00dffbff,$00c7fbfe,$00011234
	.dc.l	$00001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$00001234,$00dffc01,$00c7fc00,$00011234
	.dc.l	$00001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$00001234,$00dfffff,$00c7fffe,$00011234
;read word
	.dc.l	$00011234,$00c00000,$00c00000,$00041234
	.dc.l	$00011234,$00c003fe,$00c003fe,$00041234
	.dc.l	$00011234,$00c00400,$00c00400,$00041234
	.dc.l	$00011234,$00c007fe,$00c007fe,$00041234
	.dc.l	$00011234,$00c7f800,$00c7f800,$00041234
	.dc.l	$00011234,$00c7fbfe,$00c7fbfe,$00041234
	.dc.l	$00011234,$00c7fc00,$00c7fc00,$00041234
	.dc.l	$00011234,$00c7fffe,$00c7fffe,$00041234
	.dc.l	$00011234,$00c80000,$00c00000,$00031234
	.dc.l	$00011234,$00c803fe,$00c003fe,$00031234
	.dc.l	$00011234,$00c80400,$00c00400,$00031234
	.dc.l	$00011234,$00c807fe,$00c007fe,$00031234
	.dc.l	$00011234,$00cff800,$00c7f800,$00031234
	.dc.l	$00011234,$00cffbfe,$00c7fbfe,$00031234
	.dc.l	$00011234,$00cffc00,$00c7fc00,$00031234
	.dc.l	$00011234,$00cffffe,$00c7fffe,$00031234
	.dc.l	$00011234,$00d00000,$00c00000,$00021234
	.dc.l	$00011234,$00d003fe,$00c003fe,$00021234
	.dc.l	$00011234,$00d00400,$00c00400,$00021234
	.dc.l	$00011234,$00d007fe,$00c007fe,$00021234
	.dc.l	$00011234,$00d7f800,$00c7f800,$00021234
	.dc.l	$00011234,$00d7fbfe,$00c7fbfe,$00021234
	.dc.l	$00011234,$00d7fc00,$00c7fc00,$00021234
	.dc.l	$00011234,$00d7fffe,$00c7fffe,$00021234
	.dc.l	$00011234,$00d80000,$00c00000,$00011234
	.dc.l	$00011234,$00d803fe,$00c003fe,$00011234
	.dc.l	$00011234,$00d80400,$00c00400,$00011234
	.dc.l	$00011234,$00d807fe,$00c007fe,$00011234
	.dc.l	$00011234,$00dff800,$00c7f800,$00011234
	.dc.l	$00011234,$00dffbfe,$00c7fbfe,$00011234
	.dc.l	$00011234,$00dffc00,$00c7fc00,$00011234
	.dc.l	$00011234,$00dffffe,$00c7fffe,$00011234
;write byte
	.dc.l	$00021234,$00c00000,$00c00000,$56781234
	.dc.l	$00021234,$00c00001,$00c00000,$56781238
	.dc.l	$00021234,$00c003fe,$00c003fe,$56781234
	.dc.l	$00021234,$00c003ff,$00c003fe,$56781238
	.dc.l	$00021234,$00c00400,$00c00400,$56781234
	.dc.l	$00021234,$00c00401,$00c00400,$56781238
	.dc.l	$00021234,$00c007fe,$00c007fe,$56781234
	.dc.l	$00021234,$00c007ff,$00c007fe,$56781238
	.dc.l	$00021234,$00c7f800,$00c7f800,$56781234
	.dc.l	$00021234,$00c7f801,$00c7f800,$56781238
	.dc.l	$00021234,$00c7fbfe,$00c7fbfe,$56781234
	.dc.l	$00021234,$00c7fbff,$00c7fbfe,$56781238
	.dc.l	$00021234,$00c7fc00,$00c7fc00,$56781234
	.dc.l	$00021234,$00c7fc01,$00c7fc00,$56781238
	.dc.l	$00021234,$00c7fffe,$00c7fffe,$56781234
	.dc.l	$00021234,$00c7ffff,$00c7fffe,$56781238
	.dc.l	$00021234,$00c80000,$00c00000,$56781234
	.dc.l	$00021234,$00c80001,$00c00000,$56781284
	.dc.l	$00021234,$00c803fe,$00c003fe,$56781234
	.dc.l	$00021234,$00c803ff,$00c003fe,$56781284
	.dc.l	$00021234,$00c80400,$00c00400,$56781234
	.dc.l	$00021234,$00c80401,$00c00400,$56781284
	.dc.l	$00021234,$00c807fe,$00c007fe,$56781234
	.dc.l	$00021234,$00c807ff,$00c007fe,$56781284
	.dc.l	$00021234,$00cff800,$00c7f800,$56781234
	.dc.l	$00021234,$00cff801,$00c7f800,$56781284
	.dc.l	$00021234,$00cffbfe,$00c7fbfe,$56781234
	.dc.l	$00021234,$00cffbff,$00c7fbfe,$56781284
	.dc.l	$00021234,$00cffc00,$00c7fc00,$56781234
	.dc.l	$00021234,$00cffc01,$00c7fc00,$56781284
	.dc.l	$00021234,$00cffffe,$00c7fffe,$56781234
	.dc.l	$00021234,$00cfffff,$00c7fffe,$56781284
	.dc.l	$00021234,$00d00000,$00c00000,$56781234
	.dc.l	$00021234,$00d00001,$00c00000,$56781834
	.dc.l	$00021234,$00d003fe,$00c003fe,$56781234
	.dc.l	$00021234,$00d003ff,$00c003fe,$56781834
	.dc.l	$00021234,$00d00400,$00c00400,$56781234
	.dc.l	$00021234,$00d00401,$00c00400,$56781834
	.dc.l	$00021234,$00d007fe,$00c007fe,$56781234
	.dc.l	$00021234,$00d007ff,$00c007fe,$56781834
	.dc.l	$00021234,$00d7f800,$00c7f800,$56781234
	.dc.l	$00021234,$00d7f801,$00c7f800,$56781834
	.dc.l	$00021234,$00d7fbfe,$00c7fbfe,$56781234
	.dc.l	$00021234,$00d7fbff,$00c7fbfe,$56781834
	.dc.l	$00021234,$00d7fc00,$00c7fc00,$56781234
	.dc.l	$00021234,$00d7fc01,$00c7fc00,$56781834
	.dc.l	$00021234,$00d7fffe,$00c7fffe,$56781234
	.dc.l	$00021234,$00d7ffff,$00c7fffe,$56781834
	.dc.l	$00021234,$00d80000,$00c00000,$56781234
	.dc.l	$00021234,$00d80001,$00c00000,$56788234
	.dc.l	$00021234,$00d803fe,$00c003fe,$56781234
	.dc.l	$00021234,$00d803ff,$00c003fe,$56788234
	.dc.l	$00021234,$00d80400,$00c00400,$56781234
	.dc.l	$00021234,$00d80401,$00c00400,$56788234
	.dc.l	$00021234,$00d807fe,$00c007fe,$56781234
	.dc.l	$00021234,$00d807ff,$00c007fe,$56788234
	.dc.l	$00021234,$00dff800,$00c7f800,$56781234
	.dc.l	$00021234,$00dff801,$00c7f800,$56788234
	.dc.l	$00021234,$00dffbfe,$00c7fbfe,$56781234
	.dc.l	$00021234,$00dffbff,$00c7fbfe,$56788234
	.dc.l	$00021234,$00dffc00,$00c7fc00,$56781234
	.dc.l	$00021234,$00dffc01,$00c7fc00,$56788234
	.dc.l	$00021234,$00dffffe,$00c7fffe,$56781234
	.dc.l	$00021234,$00dfffff,$00c7fffe,$56788234
;write word
	.dc.l	$00031234,$00c00000,$00c00000,$56781238
	.dc.l	$00031234,$00c003fe,$00c003fe,$56781238
	.dc.l	$00031234,$00c00400,$00c00400,$56781238
	.dc.l	$00031234,$00c007fe,$00c007fe,$56781238
	.dc.l	$00031234,$00c7f800,$00c7f800,$56781238
	.dc.l	$00031234,$00c7fbfe,$00c7fbfe,$56781238
	.dc.l	$00031234,$00c7fc00,$00c7fc00,$56781238
	.dc.l	$00031234,$00c7fffe,$00c7fffe,$56781238
	.dc.l	$00031234,$00c80000,$00c00000,$56781284
	.dc.l	$00031234,$00c803fe,$00c003fe,$56781284
	.dc.l	$00031234,$00c80400,$00c00400,$56781284
	.dc.l	$00031234,$00c807fe,$00c007fe,$56781284
	.dc.l	$00031234,$00cff800,$00c7f800,$56781284
	.dc.l	$00031234,$00cffbfe,$00c7fbfe,$56781284
	.dc.l	$00031234,$00cffc00,$00c7fc00,$56781284
	.dc.l	$00031234,$00cffffe,$00c7fffe,$56781284
	.dc.l	$00031234,$00d00000,$00c00000,$56781834
	.dc.l	$00031234,$00d003fe,$00c003fe,$56781834
	.dc.l	$00031234,$00d00400,$00c00400,$56781834
	.dc.l	$00031234,$00d007fe,$00c007fe,$56781834
	.dc.l	$00031234,$00d7f800,$00c7f800,$56781834
	.dc.l	$00031234,$00d7fbfe,$00c7fbfe,$56781834
	.dc.l	$00031234,$00d7fc00,$00c7fc00,$56781834
	.dc.l	$00031234,$00d7fffe,$00c7fffe,$56781834
	.dc.l	$00031234,$00d80000,$00c00000,$56788234
	.dc.l	$00031234,$00d803fe,$00c003fe,$56788234
	.dc.l	$00031234,$00d80400,$00c00400,$56788234
	.dc.l	$00031234,$00d807fe,$00c007fe,$56788234
	.dc.l	$00031234,$00dff800,$00c7f800,$56788234
	.dc.l	$00031234,$00dffbfe,$00c7fbfe,$56788234
	.dc.l	$00031234,$00dffc00,$00c7fc00,$56788234
	.dc.l	$00031234,$00dffffe,$00c7fffe,$56788234
;
	.dc.l	-1

memory_mode_1:
;	+--------------------------+
;	| 0x00c00000 .. 0x00c003ff |
;	| 0x00c00400    0x00c007ff |
;	|      :             :     |
;	| 0x00c7f800    0x00c7fbff |
;	| 0x00c7fc00 .. 0x00c7ffff |
;	+--------------------------+
;read byte
	.dc.l	$01001234,$00c00000,$00c00000,$00001234
	.dc.l	$01001234,$00c00001,$00c00000,$00341234
	.dc.l	$01001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$01001234,$00c003ff,$00c003fe,$00341234
	.dc.l	$01001234,$00c00400,$00c00400,$00001234
	.dc.l	$01001234,$00c00401,$00c00400,$00341234
	.dc.l	$01001234,$00c007fe,$00c007fe,$00001234
	.dc.l	$01001234,$00c007ff,$00c007fe,$00341234
	.dc.l	$01001234,$00c7f800,$00c7f800,$00001234
	.dc.l	$01001234,$00c7f801,$00c7f800,$00341234
	.dc.l	$01001234,$00c7fbfe,$00c7fbfe,$00001234
	.dc.l	$01001234,$00c7fbff,$00c7fbfe,$00341234
	.dc.l	$01001234,$00c7fc00,$00c7fc00,$00001234
	.dc.l	$01001234,$00c7fc01,$00c7fc00,$00341234
	.dc.l	$01001234,$00c7fffe,$00c7fffe,$00001234
	.dc.l	$01001234,$00c7ffff,$00c7fffe,$00341234
	.dc.l	$01001234,$00c80000,$00c00000,$00001234
	.dc.l	$01001234,$00c80001,$00c00000,$00121234
	.dc.l	$01001234,$00c803fe,$00c003fe,$00001234
	.dc.l	$01001234,$00c803ff,$00c003fe,$00121234
	.dc.l	$01001234,$00c80400,$00c00400,$00001234
	.dc.l	$01001234,$00c80401,$00c00400,$00121234
	.dc.l	$01001234,$00c807fe,$00c007fe,$00001234
	.dc.l	$01001234,$00c807ff,$00c007fe,$00121234
	.dc.l	$01001234,$00cff800,$00c7f800,$00001234
	.dc.l	$01001234,$00cff801,$00c7f800,$00121234
	.dc.l	$01001234,$00cffbfe,$00c7fbfe,$00001234
	.dc.l	$01001234,$00cffbff,$00c7fbfe,$00121234
	.dc.l	$01001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$01001234,$00cffc01,$00c7fc00,$00121234
	.dc.l	$01001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$01001234,$00cfffff,$00c7fffe,$00121234
;read word
	.dc.l	$01011234,$00c00000,$00c00000,$00341234
	.dc.l	$01011234,$00c003fe,$00c003fe,$00341234
	.dc.l	$01011234,$00c00400,$00c00400,$00341234
	.dc.l	$01011234,$00c007fe,$00c007fe,$00341234
	.dc.l	$01011234,$00c7f800,$00c7f800,$00341234
	.dc.l	$01011234,$00c7fbfe,$00c7fbfe,$00341234
	.dc.l	$01011234,$00c7fc00,$00c7fc00,$00341234
	.dc.l	$01011234,$00c7fffe,$00c7fffe,$00341234
	.dc.l	$01011234,$00c80000,$00c00000,$00121234
	.dc.l	$01011234,$00c803fe,$00c003fe,$00121234
	.dc.l	$01011234,$00c80400,$00c00400,$00121234
	.dc.l	$01011234,$00c807fe,$00c007fe,$00121234
	.dc.l	$01011234,$00cff800,$00c7f800,$00121234
	.dc.l	$01011234,$00cffbfe,$00c7fbfe,$00121234
	.dc.l	$01011234,$00cffc00,$00c7fc00,$00121234
	.dc.l	$01011234,$00cffffe,$00c7fffe,$00121234
;write byte
	.dc.l	$01021234,$00c00000,$00c00000,$56781234
	.dc.l	$01021234,$00c00001,$00c00000,$56781278
	.dc.l	$01021234,$00c003fe,$00c003fe,$56781234
	.dc.l	$01021234,$00c003ff,$00c003fe,$56781278
	.dc.l	$01021234,$00c00400,$00c00400,$56781234
	.dc.l	$01021234,$00c00401,$00c00400,$56781278
	.dc.l	$01021234,$00c007fe,$00c007fe,$56781234
	.dc.l	$01021234,$00c007ff,$00c007fe,$56781278
	.dc.l	$01021234,$00c7f800,$00c7f800,$56781234
	.dc.l	$01021234,$00c7f801,$00c7f800,$56781278
	.dc.l	$01021234,$00c7fbfe,$00c7fbfe,$56781234
	.dc.l	$01021234,$00c7fbff,$00c7fbfe,$56781278
	.dc.l	$01021234,$00c7fc00,$00c7fc00,$56781234
	.dc.l	$01021234,$00c7fc01,$00c7fc00,$56781278
	.dc.l	$01021234,$00c7fffe,$00c7fffe,$56781234
	.dc.l	$01021234,$00c7ffff,$00c7fffe,$56781278
	.dc.l	$01021234,$00c80000,$00c00000,$56781234
	.dc.l	$01021234,$00c80001,$00c00000,$56787834
	.dc.l	$01021234,$00c803fe,$00c003fe,$56781234
	.dc.l	$01021234,$00c803ff,$00c003fe,$56787834
	.dc.l	$01021234,$00c80400,$00c00400,$56781234
	.dc.l	$01021234,$00c80401,$00c00400,$56787834
	.dc.l	$01021234,$00c807fe,$00c007fe,$56781234
	.dc.l	$01021234,$00c807ff,$00c007fe,$56787834
	.dc.l	$01021234,$00cff800,$00c7f800,$56781234
	.dc.l	$01021234,$00cff801,$00c7f800,$56787834
	.dc.l	$01021234,$00cffbfe,$00c7fbfe,$56781234
	.dc.l	$01021234,$00cffbff,$00c7fbfe,$56787834
	.dc.l	$01021234,$00cffc00,$00c7fc00,$56781234
	.dc.l	$01021234,$00cffc01,$00c7fc00,$56787834
	.dc.l	$01021234,$00cffffe,$00c7fffe,$56781234
	.dc.l	$01021234,$00cfffff,$00c7fffe,$56787834
;write word
	.dc.l	$01031234,$00c00000,$00c00000,$56781278
	.dc.l	$01031234,$00c003fe,$00c003fe,$56781278
	.dc.l	$01031234,$00c00400,$00c00400,$56781278
	.dc.l	$01031234,$00c007fe,$00c007fe,$56781278
	.dc.l	$01031234,$00c7f800,$00c7f800,$56781278
	.dc.l	$01031234,$00c7fbfe,$00c7fbfe,$56781278
	.dc.l	$01031234,$00c7fc00,$00c7fc00,$56781278
	.dc.l	$01031234,$00c7fffe,$00c7fffe,$56781278
	.dc.l	$01031234,$00c80000,$00c00000,$56787834
	.dc.l	$01031234,$00c803fe,$00c003fe,$56787834
	.dc.l	$01031234,$00c80400,$00c00400,$56787834
	.dc.l	$01031234,$00c807fe,$00c007fe,$56787834
	.dc.l	$01031234,$00cff800,$00c7f800,$56787834
	.dc.l	$01031234,$00cffbfe,$00c7fbfe,$56787834
	.dc.l	$01031234,$00cffc00,$00c7fc00,$56787834
	.dc.l	$01031234,$00cffffe,$00c7fffe,$56787834
;
	.dc.l	-1

memory_mode_2_030:
;	+--------------------------+
;	| 0x00c00000 .. 0x00c003ff |
;	| 0x00c00400    0x00c007ff |
;	|      :             :     |
;	| 0x00c7f800    0x00c7fbff |
;	| 0x00c7fc00 .. 0x00c7ffff |
;	+--------------------------+
;read byte
	.dc.l	$02001234,$00c00000,$00c00000,$00001234
	.dc.l	$02001234,$00c00001,$00c00000,$00341234
	.dc.l	$02001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$02001234,$00c003ff,$00c003fe,$00341234
	.dc.l	$02001234,$00c00400,$00c00400,$00001234
	.dc.l	$02001234,$00c00401,$00c00400,$00341234
	.dc.l	$02001234,$00c007fe,$00c007fe,$00001234
	.dc.l	$02001234,$00c007ff,$00c007fe,$00341234
	.dc.l	$02001234,$00c7f800,$00c7f800,$00001234
	.dc.l	$02001234,$00c7f801,$00c7f800,$00341234
	.dc.l	$02001234,$00c7fbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00c7fbff,$00c7fbfe,$00341234
	.dc.l	$02001234,$00c7fc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00c7fc01,$00c7fc00,$00341234
	.dc.l	$02001234,$00c7fffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00c7ffff,$00c7fffe,$00341234
	.dc.l	$02001234,$00c80000,$00c00000,$00001234
	.dc.l	$02001234,$00c80001,$00c00000,$00001234
	.dc.l	$02001234,$00c803fe,$00c003fe,$00001234
	.dc.l	$02001234,$00c803ff,$00c003fe,$00001234
	.dc.l	$02001234,$00c80400,$00c00400,$00001234
	.dc.l	$02001234,$00c80401,$00c00400,$00001234
	.dc.l	$02001234,$00c807fe,$00c007fe,$00001234
	.dc.l	$02001234,$00c807ff,$00c007fe,$00001234
	.dc.l	$02001234,$00cff800,$00c7f800,$00001234
	.dc.l	$02001234,$00cff801,$00c7f800,$00001234
	.dc.l	$02001234,$00cffbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00cffbff,$00c7fbfe,$00001234
	.dc.l	$02001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00cffc01,$00c7fc00,$00001234
	.dc.l	$02001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00cfffff,$00c7fffe,$00001234
	.dc.l	$02001234,$00d00000,$00c00000,$00001234
	.dc.l	$02001234,$00d00001,$00c00000,$00341234
	.dc.l	$02001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$02001234,$00d003ff,$00c003fe,$00341234
	.dc.l	$02001234,$00d00400,$00c00400,$00001234
	.dc.l	$02001234,$00d00401,$00c00400,$00341234
	.dc.l	$02001234,$00d007fe,$00c007fe,$00001234
	.dc.l	$02001234,$00d007ff,$00c007fe,$00341234
	.dc.l	$02001234,$00d7f800,$00c7f800,$00001234
	.dc.l	$02001234,$00d7f801,$00c7f800,$00341234
	.dc.l	$02001234,$00d7fbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00d7fbff,$00c7fbfe,$00341234
	.dc.l	$02001234,$00d7fc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00d7fc01,$00c7fc00,$00341234
	.dc.l	$02001234,$00d7fffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00d7ffff,$00c7fffe,$00341234
	.dc.l	$02001234,$00d80000,$00c00000,$00001234
	.dc.l	$02001234,$00d80001,$00c00000,$00001234
	.dc.l	$02001234,$00d803fe,$00c003fe,$00001234
	.dc.l	$02001234,$00d803ff,$00c003fe,$00001234
	.dc.l	$02001234,$00d80400,$00c00400,$00001234
	.dc.l	$02001234,$00d80401,$00c00400,$00001234
	.dc.l	$02001234,$00d807fe,$00c007fe,$00001234
	.dc.l	$02001234,$00d807ff,$00c007fe,$00001234
	.dc.l	$02001234,$00dff800,$00c7f800,$00001234
	.dc.l	$02001234,$00dff801,$00c7f800,$00001234
	.dc.l	$02001234,$00dffbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00dffbff,$00c7fbfe,$00001234
	.dc.l	$02001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00dffc01,$00c7fc00,$00001234
	.dc.l	$02001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00dfffff,$00c7fffe,$00001234
;read word
	.dc.l	$02011234,$00c00000,$00c00000,$00341234
	.dc.l	$02011234,$00c003fe,$00c003fe,$00341234
	.dc.l	$02011234,$00c00400,$00c00400,$00341234
	.dc.l	$02011234,$00c007fe,$00c007fe,$00341234
	.dc.l	$02011234,$00c7f800,$00c7f800,$00341234
	.dc.l	$02011234,$00c7fbfe,$00c7fbfe,$00341234
	.dc.l	$02011234,$00c7fc00,$00c7fc00,$00341234
	.dc.l	$02011234,$00c7fffe,$00c7fffe,$00341234
	.dc.l	$02011234,$00c80000,$00c00000,$00121234
	.dc.l	$02011234,$00c803fe,$00c003fe,$00121234
	.dc.l	$02011234,$00c80400,$00c00400,$00121234
	.dc.l	$02011234,$00c807fe,$00c007fe,$00121234
	.dc.l	$02011234,$00cff800,$00c7f800,$00121234
	.dc.l	$02011234,$00cffbfe,$00c7fbfe,$00121234
	.dc.l	$02011234,$00cffc00,$00c7fc00,$00121234
	.dc.l	$02011234,$00cffffe,$00c7fffe,$00121234
	.dc.l	$02011234,$00d00000,$00c00000,$00341234
	.dc.l	$02011234,$00d003fe,$00c003fe,$00341234
	.dc.l	$02011234,$00d00400,$00c00400,$00341234
	.dc.l	$02011234,$00d007fe,$00c007fe,$00341234
	.dc.l	$02011234,$00d7f800,$00c7f800,$00341234
	.dc.l	$02011234,$00d7fbfe,$00c7fbfe,$00341234
	.dc.l	$02011234,$00d7fc00,$00c7fc00,$00341234
	.dc.l	$02011234,$00d7fffe,$00c7fffe,$00341234
	.dc.l	$02011234,$00d80000,$00c00000,$00121234
	.dc.l	$02011234,$00d803fe,$00c003fe,$00121234
	.dc.l	$02011234,$00d80400,$00c00400,$00121234
	.dc.l	$02011234,$00d807fe,$00c007fe,$00121234
	.dc.l	$02011234,$00dff800,$00c7f800,$00121234
	.dc.l	$02011234,$00dffbfe,$00c7fbfe,$00121234
	.dc.l	$02011234,$00dffc00,$00c7fc00,$00121234
	.dc.l	$02011234,$00dffffe,$00c7fffe,$00121234
;write byte
	.dc.l	$02021234,$00c00000,$00c00000,$56787834
	.dc.l	$02021234,$00c00001,$00c00000,$56781278
	.dc.l	$02021234,$00c003fe,$00c003fe,$56787834
	.dc.l	$02021234,$00c003ff,$00c003fe,$56781278
	.dc.l	$02021234,$00c00400,$00c00400,$56787834
	.dc.l	$02021234,$00c00401,$00c00400,$56781278
	.dc.l	$02021234,$00c007fe,$00c007fe,$56787834
	.dc.l	$02021234,$00c007ff,$00c007fe,$56781278
	.dc.l	$02021234,$00c7f800,$00c7f800,$56787834
	.dc.l	$02021234,$00c7f801,$00c7f800,$56781278
	.dc.l	$02021234,$00c7fbfe,$00c7fbfe,$56787834
	.dc.l	$02021234,$00c7fbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00c7fc00,$00c7fc00,$56787834
	.dc.l	$02021234,$00c7fc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00c7fffe,$00c7fffe,$56787834
	.dc.l	$02021234,$00c7ffff,$00c7fffe,$56781278
	.dc.l	$02021234,$00c80000,$00c00000,$56787834
	.dc.l	$02021234,$00c80001,$00c00000,$56781278
	.dc.l	$02021234,$00c803fe,$00c003fe,$56787834
	.dc.l	$02021234,$00c803ff,$00c003fe,$56781278
	.dc.l	$02021234,$00c80400,$00c00400,$56787834
	.dc.l	$02021234,$00c80401,$00c00400,$56781278
	.dc.l	$02021234,$00c807fe,$00c007fe,$56787834
	.dc.l	$02021234,$00c807ff,$00c007fe,$56781278
	.dc.l	$02021234,$00cff800,$00c7f800,$56787834
	.dc.l	$02021234,$00cff801,$00c7f800,$56781278
	.dc.l	$02021234,$00cffbfe,$00c7fbfe,$56787834
	.dc.l	$02021234,$00cffbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00cffc00,$00c7fc00,$56787834
	.dc.l	$02021234,$00cffc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00cffffe,$00c7fffe,$56787834
	.dc.l	$02021234,$00cfffff,$00c7fffe,$56781278
	.dc.l	$02021234,$00d00000,$00c00000,$56787834
	.dc.l	$02021234,$00d00001,$00c00000,$56781278
	.dc.l	$02021234,$00d003fe,$00c003fe,$56787834
	.dc.l	$02021234,$00d003ff,$00c003fe,$56781278
	.dc.l	$02021234,$00d00400,$00c00400,$56787834
	.dc.l	$02021234,$00d00401,$00c00400,$56781278
	.dc.l	$02021234,$00d007fe,$00c007fe,$56787834
	.dc.l	$02021234,$00d007ff,$00c007fe,$56781278
	.dc.l	$02021234,$00d7f800,$00c7f800,$56787834
	.dc.l	$02021234,$00d7f801,$00c7f800,$56781278
	.dc.l	$02021234,$00d7fbfe,$00c7fbfe,$56787834
	.dc.l	$02021234,$00d7fbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00d7fc00,$00c7fc00,$56787834
	.dc.l	$02021234,$00d7fc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00d7fffe,$00c7fffe,$56787834
	.dc.l	$02021234,$00d7ffff,$00c7fffe,$56781278
	.dc.l	$02021234,$00d80000,$00c00000,$56787834
	.dc.l	$02021234,$00d80001,$00c00000,$56781278
	.dc.l	$02021234,$00d803fe,$00c003fe,$56787834
	.dc.l	$02021234,$00d803ff,$00c003fe,$56781278
	.dc.l	$02021234,$00d80400,$00c00400,$56787834
	.dc.l	$02021234,$00d80401,$00c00400,$56781278
	.dc.l	$02021234,$00d807fe,$00c007fe,$56787834
	.dc.l	$02021234,$00d807ff,$00c007fe,$56781278
	.dc.l	$02021234,$00dff800,$00c7f800,$56787834
	.dc.l	$02021234,$00dff801,$00c7f800,$56781278
	.dc.l	$02021234,$00dffbfe,$00c7fbfe,$56787834
	.dc.l	$02021234,$00dffbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00dffc00,$00c7fc00,$56787834
	.dc.l	$02021234,$00dffc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00dffffe,$00c7fffe,$56787834
	.dc.l	$02021234,$00dfffff,$00c7fffe,$56781278
;write word
	.dc.l	$02031234,$00c00000,$00c00000,$56787878
	.dc.l	$02031234,$00c003fe,$00c003fe,$56787878
	.dc.l	$02031234,$00c00400,$00c00400,$56787878
	.dc.l	$02031234,$00c007fe,$00c007fe,$56787878
	.dc.l	$02031234,$00c7f800,$00c7f800,$56787878
	.dc.l	$02031234,$00c7fbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00c7fc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00c7fffe,$00c7fffe,$56787878
	.dc.l	$02031234,$00c80000,$00c00000,$56787878
	.dc.l	$02031234,$00c803fe,$00c003fe,$56787878
	.dc.l	$02031234,$00c80400,$00c00400,$56787878
	.dc.l	$02031234,$00c807fe,$00c007fe,$56787878
	.dc.l	$02031234,$00cff800,$00c7f800,$56787878
	.dc.l	$02031234,$00cffbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00cffc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00cffffe,$00c7fffe,$56787878
	.dc.l	$02031234,$00d00000,$00c00000,$56787878
	.dc.l	$02031234,$00d003fe,$00c003fe,$56787878
	.dc.l	$02031234,$00d00400,$00c00400,$56787878
	.dc.l	$02031234,$00d007fe,$00c007fe,$56787878
	.dc.l	$02031234,$00d7f800,$00c7f800,$56787878
	.dc.l	$02031234,$00d7fbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00d7fc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00d7fffe,$00c7fffe,$56787878
	.dc.l	$02031234,$00d80000,$00c00000,$56787878
	.dc.l	$02031234,$00d803fe,$00c003fe,$56787878
	.dc.l	$02031234,$00d80400,$00c00400,$56787878
	.dc.l	$02031234,$00d807fe,$00c007fe,$56787878
	.dc.l	$02031234,$00dff800,$00c7f800,$56787878
	.dc.l	$02031234,$00dffbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00dffc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00dffffe,$00c7fffe,$56787878
;
	.dc.l	-1

memory_mode_2_060:
;	+--------------------------+
;	| 0x00c00000 .. 0x00c003ff |
;	| 0x00c00400    0x00c007ff |
;	|      :             :     |
;	| 0x00c7f800    0x00c7fbff |
;	| 0x00c7fc00 .. 0x00c7ffff |
;	+--------------------------+
;read byte
	.dc.l	$02001234,$00c00000,$00c00000,$00001234
	.dc.l	$02001234,$00c00001,$00c00000,$00341234
	.dc.l	$02001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$02001234,$00c003ff,$00c003fe,$00341234
	.dc.l	$02001234,$00c00400,$00c00400,$00001234
	.dc.l	$02001234,$00c00401,$00c00400,$00341234
	.dc.l	$02001234,$00c007fe,$00c007fe,$00001234
	.dc.l	$02001234,$00c007ff,$00c007fe,$00341234
	.dc.l	$02001234,$00c7f800,$00c7f800,$00001234
	.dc.l	$02001234,$00c7f801,$00c7f800,$00341234
	.dc.l	$02001234,$00c7fbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00c7fbff,$00c7fbfe,$00341234
	.dc.l	$02001234,$00c7fc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00c7fc01,$00c7fc00,$00341234
	.dc.l	$02001234,$00c7fffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00c7ffff,$00c7fffe,$00341234
	.dc.l	$02001234,$00c80000,$00c00000,$00001234
	.dc.l	$02001234,$00c80001,$00c00000,$00001234
	.dc.l	$02001234,$00c803fe,$00c003fe,$00001234
	.dc.l	$02001234,$00c803ff,$00c003fe,$00001234
	.dc.l	$02001234,$00c80400,$00c00400,$00001234
	.dc.l	$02001234,$00c80401,$00c00400,$00001234
	.dc.l	$02001234,$00c807fe,$00c007fe,$00001234
	.dc.l	$02001234,$00c807ff,$00c007fe,$00001234
	.dc.l	$02001234,$00cff800,$00c7f800,$00001234
	.dc.l	$02001234,$00cff801,$00c7f800,$00001234
	.dc.l	$02001234,$00cffbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00cffbff,$00c7fbfe,$00001234
	.dc.l	$02001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00cffc01,$00c7fc00,$00001234
	.dc.l	$02001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00cfffff,$00c7fffe,$00001234
	.dc.l	$02001234,$00d00000,$00c00000,$00001234
	.dc.l	$02001234,$00d00001,$00c00000,$00341234
	.dc.l	$02001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$02001234,$00d003ff,$00c003fe,$00341234
	.dc.l	$02001234,$00d00400,$00c00400,$00001234
	.dc.l	$02001234,$00d00401,$00c00400,$00341234
	.dc.l	$02001234,$00d007fe,$00c007fe,$00001234
	.dc.l	$02001234,$00d007ff,$00c007fe,$00341234
	.dc.l	$02001234,$00d7f800,$00c7f800,$00001234
	.dc.l	$02001234,$00d7f801,$00c7f800,$00341234
	.dc.l	$02001234,$00d7fbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00d7fbff,$00c7fbfe,$00341234
	.dc.l	$02001234,$00d7fc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00d7fc01,$00c7fc00,$00341234
	.dc.l	$02001234,$00d7fffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00d7ffff,$00c7fffe,$00341234
	.dc.l	$02001234,$00d80000,$00c00000,$00001234
	.dc.l	$02001234,$00d80001,$00c00000,$00001234
	.dc.l	$02001234,$00d803fe,$00c003fe,$00001234
	.dc.l	$02001234,$00d803ff,$00c003fe,$00001234
	.dc.l	$02001234,$00d80400,$00c00400,$00001234
	.dc.l	$02001234,$00d80401,$00c00400,$00001234
	.dc.l	$02001234,$00d807fe,$00c007fe,$00001234
	.dc.l	$02001234,$00d807ff,$00c007fe,$00001234
	.dc.l	$02001234,$00dff800,$00c7f800,$00001234
	.dc.l	$02001234,$00dff801,$00c7f800,$00001234
	.dc.l	$02001234,$00dffbfe,$00c7fbfe,$00001234
	.dc.l	$02001234,$00dffbff,$00c7fbfe,$00001234
	.dc.l	$02001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$02001234,$00dffc01,$00c7fc00,$00001234
	.dc.l	$02001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$02001234,$00dfffff,$00c7fffe,$00001234
;read word
	.dc.l	$02011234,$00c00000,$00c00000,$00341234
	.dc.l	$02011234,$00c003fe,$00c003fe,$00341234
	.dc.l	$02011234,$00c00400,$00c00400,$00341234
	.dc.l	$02011234,$00c007fe,$00c007fe,$00341234
	.dc.l	$02011234,$00c7f800,$00c7f800,$00341234
	.dc.l	$02011234,$00c7fbfe,$00c7fbfe,$00341234
	.dc.l	$02011234,$00c7fc00,$00c7fc00,$00341234
	.dc.l	$02011234,$00c7fffe,$00c7fffe,$00341234
	.dc.l	$02011234,$00c80000,$00c00000,$00121234
	.dc.l	$02011234,$00c803fe,$00c003fe,$00121234
	.dc.l	$02011234,$00c80400,$00c00400,$00121234
	.dc.l	$02011234,$00c807fe,$00c007fe,$00121234
	.dc.l	$02011234,$00cff800,$00c7f800,$00121234
	.dc.l	$02011234,$00cffbfe,$00c7fbfe,$00121234
	.dc.l	$02011234,$00cffc00,$00c7fc00,$00121234
	.dc.l	$02011234,$00cffffe,$00c7fffe,$00121234
	.dc.l	$02011234,$00d00000,$00c00000,$00341234
	.dc.l	$02011234,$00d003fe,$00c003fe,$00341234
	.dc.l	$02011234,$00d00400,$00c00400,$00341234
	.dc.l	$02011234,$00d007fe,$00c007fe,$00341234
	.dc.l	$02011234,$00d7f800,$00c7f800,$00341234
	.dc.l	$02011234,$00d7fbfe,$00c7fbfe,$00341234
	.dc.l	$02011234,$00d7fc00,$00c7fc00,$00341234
	.dc.l	$02011234,$00d7fffe,$00c7fffe,$00341234
	.dc.l	$02011234,$00d80000,$00c00000,$00121234
	.dc.l	$02011234,$00d803fe,$00c003fe,$00121234
	.dc.l	$02011234,$00d80400,$00c00400,$00121234
	.dc.l	$02011234,$00d807fe,$00c007fe,$00121234
	.dc.l	$02011234,$00dff800,$00c7f800,$00121234
	.dc.l	$02011234,$00dffbfe,$00c7fbfe,$00121234
	.dc.l	$02011234,$00dffc00,$00c7fc00,$00121234
	.dc.l	$02011234,$00dffffe,$00c7fffe,$00121234
;write byte
	.dc.l	$02021234,$00c00000,$00c00000,$56780034
	.dc.l	$02021234,$00c00001,$00c00000,$56781278
	.dc.l	$02021234,$00c003fe,$00c003fe,$56780034
	.dc.l	$02021234,$00c003ff,$00c003fe,$56781278
	.dc.l	$02021234,$00c00400,$00c00400,$56780034
	.dc.l	$02021234,$00c00401,$00c00400,$56781278
	.dc.l	$02021234,$00c007fe,$00c007fe,$56780034
	.dc.l	$02021234,$00c007ff,$00c007fe,$56781278
	.dc.l	$02021234,$00c7f800,$00c7f800,$56780034
	.dc.l	$02021234,$00c7f801,$00c7f800,$56781278
	.dc.l	$02021234,$00c7fbfe,$00c7fbfe,$56780034
	.dc.l	$02021234,$00c7fbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00c7fc00,$00c7fc00,$56780034
	.dc.l	$02021234,$00c7fc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00c7fffe,$00c7fffe,$56780034
	.dc.l	$02021234,$00c7ffff,$00c7fffe,$56781278
	.dc.l	$02021234,$00c80000,$00c00000,$56780034
	.dc.l	$02021234,$00c80001,$00c00000,$56781278
	.dc.l	$02021234,$00c803fe,$00c003fe,$56780034
	.dc.l	$02021234,$00c803ff,$00c003fe,$56781278
	.dc.l	$02021234,$00c80400,$00c00400,$56780034
	.dc.l	$02021234,$00c80401,$00c00400,$56781278
	.dc.l	$02021234,$00c807fe,$00c007fe,$56780034
	.dc.l	$02021234,$00c807ff,$00c007fe,$56781278
	.dc.l	$02021234,$00cff800,$00c7f800,$56780034
	.dc.l	$02021234,$00cff801,$00c7f800,$56781278
	.dc.l	$02021234,$00cffbfe,$00c7fbfe,$56780034
	.dc.l	$02021234,$00cffbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00cffc00,$00c7fc00,$56780034
	.dc.l	$02021234,$00cffc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00cffffe,$00c7fffe,$56780034
	.dc.l	$02021234,$00cfffff,$00c7fffe,$56781278
	.dc.l	$02021234,$00d00000,$00c00000,$56780034
	.dc.l	$02021234,$00d00001,$00c00000,$56781278
	.dc.l	$02021234,$00d003fe,$00c003fe,$56780034
	.dc.l	$02021234,$00d003ff,$00c003fe,$56781278
	.dc.l	$02021234,$00d00400,$00c00400,$56780034
	.dc.l	$02021234,$00d00401,$00c00400,$56781278
	.dc.l	$02021234,$00d007fe,$00c007fe,$56780034
	.dc.l	$02021234,$00d007ff,$00c007fe,$56781278
	.dc.l	$02021234,$00d7f800,$00c7f800,$56780034
	.dc.l	$02021234,$00d7f801,$00c7f800,$56781278
	.dc.l	$02021234,$00d7fbfe,$00c7fbfe,$56780034
	.dc.l	$02021234,$00d7fbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00d7fc00,$00c7fc00,$56780034
	.dc.l	$02021234,$00d7fc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00d7fffe,$00c7fffe,$56780034
	.dc.l	$02021234,$00d7ffff,$00c7fffe,$56781278
	.dc.l	$02021234,$00d80000,$00c00000,$56780034
	.dc.l	$02021234,$00d80001,$00c00000,$56781278
	.dc.l	$02021234,$00d803fe,$00c003fe,$56780034
	.dc.l	$02021234,$00d803ff,$00c003fe,$56781278
	.dc.l	$02021234,$00d80400,$00c00400,$56780034
	.dc.l	$02021234,$00d80401,$00c00400,$56781278
	.dc.l	$02021234,$00d807fe,$00c007fe,$56780034
	.dc.l	$02021234,$00d807ff,$00c007fe,$56781278
	.dc.l	$02021234,$00dff800,$00c7f800,$56780034
	.dc.l	$02021234,$00dff801,$00c7f800,$56781278
	.dc.l	$02021234,$00dffbfe,$00c7fbfe,$56780034
	.dc.l	$02021234,$00dffbff,$00c7fbfe,$56781278
	.dc.l	$02021234,$00dffc00,$00c7fc00,$56780034
	.dc.l	$02021234,$00dffc01,$00c7fc00,$56781278
	.dc.l	$02021234,$00dffffe,$00c7fffe,$56780034
	.dc.l	$02021234,$00dfffff,$00c7fffe,$56781278
;write word
	.dc.l	$02031234,$00c00000,$00c00000,$56787878
	.dc.l	$02031234,$00c003fe,$00c003fe,$56787878
	.dc.l	$02031234,$00c00400,$00c00400,$56787878
	.dc.l	$02031234,$00c007fe,$00c007fe,$56787878
	.dc.l	$02031234,$00c7f800,$00c7f800,$56787878
	.dc.l	$02031234,$00c7fbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00c7fc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00c7fffe,$00c7fffe,$56787878
	.dc.l	$02031234,$00c80000,$00c00000,$56787878
	.dc.l	$02031234,$00c803fe,$00c003fe,$56787878
	.dc.l	$02031234,$00c80400,$00c00400,$56787878
	.dc.l	$02031234,$00c807fe,$00c007fe,$56787878
	.dc.l	$02031234,$00cff800,$00c7f800,$56787878
	.dc.l	$02031234,$00cffbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00cffc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00cffffe,$00c7fffe,$56787878
	.dc.l	$02031234,$00d00000,$00c00000,$56787878
	.dc.l	$02031234,$00d003fe,$00c003fe,$56787878
	.dc.l	$02031234,$00d00400,$00c00400,$56787878
	.dc.l	$02031234,$00d007fe,$00c007fe,$56787878
	.dc.l	$02031234,$00d7f800,$00c7f800,$56787878
	.dc.l	$02031234,$00d7fbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00d7fc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00d7fffe,$00c7fffe,$56787878
	.dc.l	$02031234,$00d80000,$00c00000,$56787878
	.dc.l	$02031234,$00d803fe,$00c003fe,$56787878
	.dc.l	$02031234,$00d80400,$00c00400,$56787878
	.dc.l	$02031234,$00d807fe,$00c007fe,$56787878
	.dc.l	$02031234,$00dff800,$00c7f800,$56787878
	.dc.l	$02031234,$00dffbfe,$00c7fbfe,$56787878
	.dc.l	$02031234,$00dffc00,$00c7fc00,$56787878
	.dc.l	$02031234,$00dffffe,$00c7fffe,$56787878
;
	.dc.l	-1

memory_mode_3:
;	+--------------------------+
;	| 0x00c00000 .. 0x00c003ff |
;	| 0x00c00400    0x00c007ff |
;	|      :             :     |
;	| 0x00c7f800    0x00c7fbff |
;	| 0x00c7fc00 .. 0x00c7ffff |
;	+--------------------------+
;read byte
	.dc.l	$03001234,$00c00000,$00c00000,$00121234
	.dc.l	$03001234,$00c00001,$00c00000,$00341234
	.dc.l	$03001234,$00c003fe,$00c003fe,$00121234
	.dc.l	$03001234,$00c003ff,$00c003fe,$00341234
	.dc.l	$03001234,$00c00400,$00c00400,$00121234
	.dc.l	$03001234,$00c00401,$00c00400,$00341234
	.dc.l	$03001234,$00c007fe,$00c007fe,$00121234
	.dc.l	$03001234,$00c007ff,$00c007fe,$00341234
	.dc.l	$03001234,$00c7f800,$00c7f800,$00121234
	.dc.l	$03001234,$00c7f801,$00c7f800,$00341234
	.dc.l	$03001234,$00c7fbfe,$00c7fbfe,$00121234
	.dc.l	$03001234,$00c7fbff,$00c7fbfe,$00341234
	.dc.l	$03001234,$00c7fc00,$00c7fc00,$00121234
	.dc.l	$03001234,$00c7fc01,$00c7fc00,$00341234
	.dc.l	$03001234,$00c7fffe,$00c7fffe,$00121234
	.dc.l	$03001234,$00c7ffff,$00c7fffe,$00341234
;read word
	.dc.l	$03011234,$00c00000,$00c00000,$12341234
	.dc.l	$03011234,$00c003fe,$00c003fe,$12341234
	.dc.l	$03011234,$00c00400,$00c00400,$12341234
	.dc.l	$03011234,$00c007fe,$00c007fe,$12341234
	.dc.l	$03011234,$00c7f800,$00c7f800,$12341234
	.dc.l	$03011234,$00c7fbfe,$00c7fbfe,$12341234
	.dc.l	$03011234,$00c7fc00,$00c7fc00,$12341234
	.dc.l	$03011234,$00c7fffe,$00c7fffe,$12341234
;write byte
	.dc.l	$03021234,$00c00000,$00c00000,$56787834
	.dc.l	$03021234,$00c00001,$00c00000,$56781278
	.dc.l	$03021234,$00c003fe,$00c003fe,$56787834
	.dc.l	$03021234,$00c003ff,$00c003fe,$56781278
	.dc.l	$03021234,$00c00400,$00c00400,$56787834
	.dc.l	$03021234,$00c00401,$00c00400,$56781278
	.dc.l	$03021234,$00c007fe,$00c007fe,$56787834
	.dc.l	$03021234,$00c007ff,$00c007fe,$56781278
	.dc.l	$03021234,$00c7f800,$00c7f800,$56787834
	.dc.l	$03021234,$00c7f801,$00c7f800,$56781278
	.dc.l	$03021234,$00c7fbfe,$00c7fbfe,$56787834
	.dc.l	$03021234,$00c7fbff,$00c7fbfe,$56781278
	.dc.l	$03021234,$00c7fc00,$00c7fc00,$56787834
	.dc.l	$03021234,$00c7fc01,$00c7fc00,$56781278
	.dc.l	$03021234,$00c7fffe,$00c7fffe,$56787834
	.dc.l	$03021234,$00c7ffff,$00c7fffe,$56781278
;write word
	.dc.l	$03031234,$00c00000,$00c00000,$56785678
	.dc.l	$03031234,$00c003fe,$00c003fe,$56785678
	.dc.l	$03031234,$00c00400,$00c00400,$56785678
	.dc.l	$03031234,$00c007fe,$00c007fe,$56785678
	.dc.l	$03031234,$00c7f800,$00c7f800,$56785678
	.dc.l	$03031234,$00c7fbfe,$00c7fbfe,$56785678
	.dc.l	$03031234,$00c7fc00,$00c7fc00,$56785678
	.dc.l	$03031234,$00c7fffe,$00c7fffe,$56785678
;
	.dc.l	-1

memory_mode_4:
;referenced address
;	0b00000000_110Yyyyy_yyyyyXxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c00400 .. 0x00c007ff |
;	| 0x00c00800    0x00c00bff | 0x00c00c00    0x00c00fff |
;	|      :             :     |      :             :     |
;	| 0x00cff000    0x00cff3ff | 0x00cff400    0x00cff7ff |
;	| 0x00cff800 .. 0x00cffbff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d00400 .. 0x00d007ff |
;	| 0x00d00800    0x00d00bff | 0x00d00c00    0x00d00fff |
;	|      :             :     |      :             :     |
;	| 0x00dff000    0x00dff3ff | 0x00dff400    0x00dff7ff |
;	| 0x00dff800 .. 0x00dffbff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;stored address
;	0b00000000_110YXyyy_yyyyyyxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c80000 .. 0x00c803ff |
;	| 0x00c00400    0x00c007ff | 0x00c80400    0x00c807ff |
;	|      :     G0      :     |      :     G1      :     |
;	| 0x00c7f800    0x00c7fbff | 0x00cff800    0x00cffbff |
;	| 0x00c7fc00 .. 0x00c7ffff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d80000 .. 0x00d803ff |
;	| 0x00d00400    0x00d007ff | 0x00d80400    0x00d807ff |
;	|      :     G2      :     |      :     G3      :     |
;	| 0x00d7f800    0x00d7fbff | 0x00dff800    0x00dffbff |
;	| 0x00d7fc00 .. 0x00d7ffff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;read byte
	.dc.l	$04001234,$00c00000,$00c00000,$00001234
	.dc.l	$04001234,$00c00001,$00c00000,$00041234
	.dc.l	$04001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$04001234,$00c003ff,$00c003fe,$00041234
	.dc.l	$04001234,$00c00400,$00c00000,$00001234
	.dc.l	$04001234,$00c00401,$00c00000,$00031234
	.dc.l	$04001234,$00c007fe,$00c003fe,$00001234
	.dc.l	$04001234,$00c007ff,$00c003fe,$00031234
	.dc.l	$04001234,$00c00800,$00c00400,$00001234
	.dc.l	$04001234,$00c00801,$00c00400,$00041234
	.dc.l	$04001234,$00c00bfe,$00c007fe,$00001234
	.dc.l	$04001234,$00c00bff,$00c007fe,$00041234
	.dc.l	$04001234,$00c00c00,$00c00400,$00001234
	.dc.l	$04001234,$00c00c01,$00c00400,$00031234
	.dc.l	$04001234,$00c00ffe,$00c007fe,$00001234
	.dc.l	$04001234,$00c00fff,$00c007fe,$00031234
	.dc.l	$04001234,$00cff000,$00c7f800,$00001234
	.dc.l	$04001234,$00cff001,$00c7f800,$00041234
	.dc.l	$04001234,$00cff3fe,$00c7fbfe,$00001234
	.dc.l	$04001234,$00cff3ff,$00c7fbfe,$00041234
	.dc.l	$04001234,$00cff400,$00c7f800,$00001234
	.dc.l	$04001234,$00cff401,$00c7f800,$00031234
	.dc.l	$04001234,$00cff7fe,$00c7fbfe,$00001234
	.dc.l	$04001234,$00cff7ff,$00c7fbfe,$00031234
	.dc.l	$04001234,$00cff800,$00c7fc00,$00001234
	.dc.l	$04001234,$00cff801,$00c7fc00,$00041234
	.dc.l	$04001234,$00cffbfe,$00c7fffe,$00001234
	.dc.l	$04001234,$00cffbff,$00c7fffe,$00041234
	.dc.l	$04001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$04001234,$00cffc01,$00c7fc00,$00031234
	.dc.l	$04001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$04001234,$00cfffff,$00c7fffe,$00031234
	.dc.l	$04001234,$00d00000,$00c00000,$00001234
	.dc.l	$04001234,$00d00001,$00c00000,$00021234
	.dc.l	$04001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$04001234,$00d003ff,$00c003fe,$00021234
	.dc.l	$04001234,$00d00400,$00c00000,$00001234
	.dc.l	$04001234,$00d00401,$00c00000,$00011234
	.dc.l	$04001234,$00d007fe,$00c003fe,$00001234
	.dc.l	$04001234,$00d007ff,$00c003fe,$00011234
	.dc.l	$04001234,$00d00800,$00c00400,$00001234
	.dc.l	$04001234,$00d00801,$00c00400,$00021234
	.dc.l	$04001234,$00d00bfe,$00c007fe,$00001234
	.dc.l	$04001234,$00d00bff,$00c007fe,$00021234
	.dc.l	$04001234,$00d00c00,$00c00400,$00001234
	.dc.l	$04001234,$00d00c01,$00c00400,$00011234
	.dc.l	$04001234,$00d00ffe,$00c007fe,$00001234
	.dc.l	$04001234,$00d00fff,$00c007fe,$00011234
	.dc.l	$04001234,$00dff000,$00c7f800,$00001234
	.dc.l	$04001234,$00dff001,$00c7f800,$00021234
	.dc.l	$04001234,$00dff3fe,$00c7fbfe,$00001234
	.dc.l	$04001234,$00dff3ff,$00c7fbfe,$00021234
	.dc.l	$04001234,$00dff400,$00c7f800,$00001234
	.dc.l	$04001234,$00dff401,$00c7f800,$00011234
	.dc.l	$04001234,$00dff7fe,$00c7fbfe,$00001234
	.dc.l	$04001234,$00dff7ff,$00c7fbfe,$00011234
	.dc.l	$04001234,$00dff800,$00c7fc00,$00001234
	.dc.l	$04001234,$00dff801,$00c7fc00,$00021234
	.dc.l	$04001234,$00dffbfe,$00c7fffe,$00001234
	.dc.l	$04001234,$00dffbff,$00c7fffe,$00021234
	.dc.l	$04001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$04001234,$00dffc01,$00c7fc00,$00011234
	.dc.l	$04001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$04001234,$00dfffff,$00c7fffe,$00011234
;read word
	.dc.l	$04011234,$00c00000,$00c00000,$00041234
	.dc.l	$04011234,$00c003fe,$00c003fe,$00041234
	.dc.l	$04011234,$00c00400,$00c00000,$00031234
	.dc.l	$04011234,$00c007fe,$00c003fe,$00031234
	.dc.l	$04011234,$00c00800,$00c00400,$00041234
	.dc.l	$04011234,$00c00bfe,$00c007fe,$00041234
	.dc.l	$04011234,$00c00c00,$00c00400,$00031234
	.dc.l	$04011234,$00c00ffe,$00c007fe,$00031234
	.dc.l	$04011234,$00cff000,$00c7f800,$00041234
	.dc.l	$04011234,$00cff3fe,$00c7fbfe,$00041234
	.dc.l	$04011234,$00cff400,$00c7f800,$00031234
	.dc.l	$04011234,$00cff7fe,$00c7fbfe,$00031234
	.dc.l	$04011234,$00cff800,$00c7fc00,$00041234
	.dc.l	$04011234,$00cffbfe,$00c7fffe,$00041234
	.dc.l	$04011234,$00cffc00,$00c7fc00,$00031234
	.dc.l	$04011234,$00cffffe,$00c7fffe,$00031234
	.dc.l	$04011234,$00d00000,$00c00000,$00021234
	.dc.l	$04011234,$00d003fe,$00c003fe,$00021234
	.dc.l	$04011234,$00d00400,$00c00000,$00011234
	.dc.l	$04011234,$00d007fe,$00c003fe,$00011234
	.dc.l	$04011234,$00d00800,$00c00400,$00021234
	.dc.l	$04011234,$00d00bfe,$00c007fe,$00021234
	.dc.l	$04011234,$00d00c00,$00c00400,$00011234
	.dc.l	$04011234,$00d00ffe,$00c007fe,$00011234
	.dc.l	$04011234,$00dff000,$00c7f800,$00021234
	.dc.l	$04011234,$00dff3fe,$00c7fbfe,$00021234
	.dc.l	$04011234,$00dff400,$00c7f800,$00011234
	.dc.l	$04011234,$00dff7fe,$00c7fbfe,$00011234
	.dc.l	$04011234,$00dff800,$00c7fc00,$00021234
	.dc.l	$04011234,$00dffbfe,$00c7fffe,$00021234
	.dc.l	$04011234,$00dffc00,$00c7fc00,$00011234
	.dc.l	$04011234,$00dffffe,$00c7fffe,$00011234
;write byte
	.dc.l	$04021234,$00c00000,$00c00000,$56781234
	.dc.l	$04021234,$00c00001,$00c00000,$56781238
	.dc.l	$04021234,$00c003fe,$00c003fe,$56781234
	.dc.l	$04021234,$00c003ff,$00c003fe,$56781238
	.dc.l	$04021234,$00c00400,$00c00000,$56781234
	.dc.l	$04021234,$00c00401,$00c00000,$56781284
	.dc.l	$04021234,$00c007fe,$00c003fe,$56781234
	.dc.l	$04021234,$00c007ff,$00c003fe,$56781284
	.dc.l	$04021234,$00c00800,$00c00400,$56781234
	.dc.l	$04021234,$00c00801,$00c00400,$56781238
	.dc.l	$04021234,$00c00bfe,$00c007fe,$56781234
	.dc.l	$04021234,$00c00bff,$00c007fe,$56781238
	.dc.l	$04021234,$00c00c00,$00c00400,$56781234
	.dc.l	$04021234,$00c00c01,$00c00400,$56781284
	.dc.l	$04021234,$00c00ffe,$00c007fe,$56781234
	.dc.l	$04021234,$00c00fff,$00c007fe,$56781284
	.dc.l	$04021234,$00cff000,$00c7f800,$56781234
	.dc.l	$04021234,$00cff001,$00c7f800,$56781238
	.dc.l	$04021234,$00cff3fe,$00c7fbfe,$56781234
	.dc.l	$04021234,$00cff3ff,$00c7fbfe,$56781238
	.dc.l	$04021234,$00cff400,$00c7f800,$56781234
	.dc.l	$04021234,$00cff401,$00c7f800,$56781284
	.dc.l	$04021234,$00cff7fe,$00c7fbfe,$56781234
	.dc.l	$04021234,$00cff7ff,$00c7fbfe,$56781284
	.dc.l	$04021234,$00cff800,$00c7fc00,$56781234
	.dc.l	$04021234,$00cff801,$00c7fc00,$56781238
	.dc.l	$04021234,$00cffbfe,$00c7fffe,$56781234
	.dc.l	$04021234,$00cffbff,$00c7fffe,$56781238
	.dc.l	$04021234,$00cffc00,$00c7fc00,$56781234
	.dc.l	$04021234,$00cffc01,$00c7fc00,$56781284
	.dc.l	$04021234,$00cffffe,$00c7fffe,$56781234
	.dc.l	$04021234,$00cfffff,$00c7fffe,$56781284
	.dc.l	$04021234,$00d00000,$00c00000,$56781234
	.dc.l	$04021234,$00d00001,$00c00000,$56781834
	.dc.l	$04021234,$00d003fe,$00c003fe,$56781234
	.dc.l	$04021234,$00d003ff,$00c003fe,$56781834
	.dc.l	$04021234,$00d00400,$00c00000,$56781234
	.dc.l	$04021234,$00d00401,$00c00000,$56788234
	.dc.l	$04021234,$00d007fe,$00c003fe,$56781234
	.dc.l	$04021234,$00d007ff,$00c003fe,$56788234
	.dc.l	$04021234,$00d00800,$00c00400,$56781234
	.dc.l	$04021234,$00d00801,$00c00400,$56781834
	.dc.l	$04021234,$00d00bfe,$00c007fe,$56781234
	.dc.l	$04021234,$00d00bff,$00c007fe,$56781834
	.dc.l	$04021234,$00d00c00,$00c00400,$56781234
	.dc.l	$04021234,$00d00c01,$00c00400,$56788234
	.dc.l	$04021234,$00d00ffe,$00c007fe,$56781234
	.dc.l	$04021234,$00d00fff,$00c007fe,$56788234
	.dc.l	$04021234,$00dff000,$00c7f800,$56781234
	.dc.l	$04021234,$00dff001,$00c7f800,$56781834
	.dc.l	$04021234,$00dff3fe,$00c7fbfe,$56781234
	.dc.l	$04021234,$00dff3ff,$00c7fbfe,$56781834
	.dc.l	$04021234,$00dff400,$00c7f800,$56781234
	.dc.l	$04021234,$00dff401,$00c7f800,$56788234
	.dc.l	$04021234,$00dff7fe,$00c7fbfe,$56781234
	.dc.l	$04021234,$00dff7ff,$00c7fbfe,$56788234
	.dc.l	$04021234,$00dff800,$00c7fc00,$56781234
	.dc.l	$04021234,$00dff801,$00c7fc00,$56781834
	.dc.l	$04021234,$00dffbfe,$00c7fffe,$56781234
	.dc.l	$04021234,$00dffbff,$00c7fffe,$56781834
	.dc.l	$04021234,$00dffc00,$00c7fc00,$56781234
	.dc.l	$04021234,$00dffc01,$00c7fc00,$56788234
	.dc.l	$04021234,$00dffffe,$00c7fffe,$56781234
	.dc.l	$04021234,$00dfffff,$00c7fffe,$56788234
;write word
	.dc.l	$04031234,$00c00000,$00c00000,$56781238
	.dc.l	$04031234,$00c003fe,$00c003fe,$56781238
	.dc.l	$04031234,$00c00400,$00c00000,$56781284
	.dc.l	$04031234,$00c007fe,$00c003fe,$56781284
	.dc.l	$04031234,$00c00800,$00c00400,$56781238
	.dc.l	$04031234,$00c00bfe,$00c007fe,$56781238
	.dc.l	$04031234,$00c00c00,$00c00400,$56781284
	.dc.l	$04031234,$00c00ffe,$00c007fe,$56781284
	.dc.l	$04031234,$00cff000,$00c7f800,$56781238
	.dc.l	$04031234,$00cff3fe,$00c7fbfe,$56781238
	.dc.l	$04031234,$00cff400,$00c7f800,$56781284
	.dc.l	$04031234,$00cff7fe,$00c7fbfe,$56781284
	.dc.l	$04031234,$00cff800,$00c7fc00,$56781238
	.dc.l	$04031234,$00cffbfe,$00c7fffe,$56781238
	.dc.l	$04031234,$00cffc00,$00c7fc00,$56781284
	.dc.l	$04031234,$00cffffe,$00c7fffe,$56781284
	.dc.l	$04031234,$00d00000,$00c00000,$56781834
	.dc.l	$04031234,$00d003fe,$00c003fe,$56781834
	.dc.l	$04031234,$00d00400,$00c00000,$56788234
	.dc.l	$04031234,$00d007fe,$00c003fe,$56788234
	.dc.l	$04031234,$00d00800,$00c00400,$56781834
	.dc.l	$04031234,$00d00bfe,$00c007fe,$56781834
	.dc.l	$04031234,$00d00c00,$00c00400,$56788234
	.dc.l	$04031234,$00d00ffe,$00c007fe,$56788234
	.dc.l	$04031234,$00dff000,$00c7f800,$56781834
	.dc.l	$04031234,$00dff3fe,$00c7fbfe,$56781834
	.dc.l	$04031234,$00dff400,$00c7f800,$56788234
	.dc.l	$04031234,$00dff7fe,$00c7fbfe,$56788234
	.dc.l	$04031234,$00dff800,$00c7fc00,$56781834
	.dc.l	$04031234,$00dffbfe,$00c7fffe,$56781834
	.dc.l	$04031234,$00dffc00,$00c7fc00,$56788234
	.dc.l	$04031234,$00dffffe,$00c7fffe,$56788234
;
	.dc.l	-1

memory_mode_5:
;referenced address
;	0b00000000_110Yyyyy_yyyyyXxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c00400 .. 0x00c007ff |
;	| 0x00c00800    0x00c00bff | 0x00c00c00    0x00c00fff |
;	|      :             :     |      :             :     |
;	| 0x00cff000    0x00cff3ff | 0x00cff400    0x00cff7ff |
;	| 0x00cff800 .. 0x00cffbff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d00400 .. 0x00d007ff |
;	| 0x00d00800    0x00d00bff | 0x00d00c00    0x00d00fff |
;	|      :             :     |      :             :     |
;	| 0x00dff000    0x00dff3ff | 0x00dff400    0x00dff7ff |
;	| 0x00dff800 .. 0x00dffbff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;stored address
;	0b00000000_110YXyyy_yyyyyyxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c80000 .. 0x00c803ff |
;	| 0x00c00400    0x00c007ff | 0x00c80400    0x00c807ff |
;	|      :     G0      :     |      :     G1      :     |
;	| 0x00c7f800    0x00c7fbff | 0x00cff800    0x00cffbff |
;	| 0x00c7fc00 .. 0x00c7ffff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d80000 .. 0x00d803ff |
;	| 0x00d00400    0x00d007ff | 0x00d80400    0x00d807ff |
;	|      :     G2      :     |      :     G3      :     |
;	| 0x00d7f800    0x00d7fbff | 0x00dff800    0x00dffbff |
;	| 0x00d7fc00 .. 0x00d7ffff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;read byte
	.dc.l	$05001234,$00c00000,$00c00000,$00001234
	.dc.l	$05001234,$00c00001,$00c00000,$00041234
	.dc.l	$05001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$05001234,$00c003ff,$00c003fe,$00041234
	.dc.l	$05001234,$00c00400,$00c00000,$00001234
	.dc.l	$05001234,$00c00401,$00c00000,$00031234
	.dc.l	$05001234,$00c007fe,$00c003fe,$00001234
	.dc.l	$05001234,$00c007ff,$00c003fe,$00031234
	.dc.l	$05001234,$00c00800,$00c00400,$00001234
	.dc.l	$05001234,$00c00801,$00c00400,$00041234
	.dc.l	$05001234,$00c00bfe,$00c007fe,$00001234
	.dc.l	$05001234,$00c00bff,$00c007fe,$00041234
	.dc.l	$05001234,$00c00c00,$00c00400,$00001234
	.dc.l	$05001234,$00c00c01,$00c00400,$00031234
	.dc.l	$05001234,$00c00ffe,$00c007fe,$00001234
	.dc.l	$05001234,$00c00fff,$00c007fe,$00031234
	.dc.l	$05001234,$00cff000,$00c7f800,$00001234
	.dc.l	$05001234,$00cff001,$00c7f800,$00041234
	.dc.l	$05001234,$00cff3fe,$00c7fbfe,$00001234
	.dc.l	$05001234,$00cff3ff,$00c7fbfe,$00041234
	.dc.l	$05001234,$00cff400,$00c7f800,$00001234
	.dc.l	$05001234,$00cff401,$00c7f800,$00031234
	.dc.l	$05001234,$00cff7fe,$00c7fbfe,$00001234
	.dc.l	$05001234,$00cff7ff,$00c7fbfe,$00031234
	.dc.l	$05001234,$00cff800,$00c7fc00,$00001234
	.dc.l	$05001234,$00cff801,$00c7fc00,$00041234
	.dc.l	$05001234,$00cffbfe,$00c7fffe,$00001234
	.dc.l	$05001234,$00cffbff,$00c7fffe,$00041234
	.dc.l	$05001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$05001234,$00cffc01,$00c7fc00,$00031234
	.dc.l	$05001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$05001234,$00cfffff,$00c7fffe,$00031234
	.dc.l	$05001234,$00d00000,$00c00000,$00001234
	.dc.l	$05001234,$00d00001,$00c00000,$00021234
	.dc.l	$05001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$05001234,$00d003ff,$00c003fe,$00021234
	.dc.l	$05001234,$00d00400,$00c00000,$00001234
	.dc.l	$05001234,$00d00401,$00c00000,$00011234
	.dc.l	$05001234,$00d007fe,$00c003fe,$00001234
	.dc.l	$05001234,$00d007ff,$00c003fe,$00011234
	.dc.l	$05001234,$00d00800,$00c00400,$00001234
	.dc.l	$05001234,$00d00801,$00c00400,$00021234
	.dc.l	$05001234,$00d00bfe,$00c007fe,$00001234
	.dc.l	$05001234,$00d00bff,$00c007fe,$00021234
	.dc.l	$05001234,$00d00c00,$00c00400,$00001234
	.dc.l	$05001234,$00d00c01,$00c00400,$00011234
	.dc.l	$05001234,$00d00ffe,$00c007fe,$00001234
	.dc.l	$05001234,$00d00fff,$00c007fe,$00011234
	.dc.l	$05001234,$00dff000,$00c7f800,$00001234
	.dc.l	$05001234,$00dff001,$00c7f800,$00021234
	.dc.l	$05001234,$00dff3fe,$00c7fbfe,$00001234
	.dc.l	$05001234,$00dff3ff,$00c7fbfe,$00021234
	.dc.l	$05001234,$00dff400,$00c7f800,$00001234
	.dc.l	$05001234,$00dff401,$00c7f800,$00011234
	.dc.l	$05001234,$00dff7fe,$00c7fbfe,$00001234
	.dc.l	$05001234,$00dff7ff,$00c7fbfe,$00011234
	.dc.l	$05001234,$00dff800,$00c7fc00,$00001234
	.dc.l	$05001234,$00dff801,$00c7fc00,$00021234
	.dc.l	$05001234,$00dffbfe,$00c7fffe,$00001234
	.dc.l	$05001234,$00dffbff,$00c7fffe,$00021234
	.dc.l	$05001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$05001234,$00dffc01,$00c7fc00,$00011234
	.dc.l	$05001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$05001234,$00dfffff,$00c7fffe,$00011234
;read word
	.dc.l	$05011234,$00c00000,$00c00000,$00041234
	.dc.l	$05011234,$00c003fe,$00c003fe,$00041234
	.dc.l	$05011234,$00c00400,$00c00000,$00031234
	.dc.l	$05011234,$00c007fe,$00c003fe,$00031234
	.dc.l	$05011234,$00c00800,$00c00400,$00041234
	.dc.l	$05011234,$00c00bfe,$00c007fe,$00041234
	.dc.l	$05011234,$00c00c00,$00c00400,$00031234
	.dc.l	$05011234,$00c00ffe,$00c007fe,$00031234
	.dc.l	$05011234,$00cff000,$00c7f800,$00041234
	.dc.l	$05011234,$00cff3fe,$00c7fbfe,$00041234
	.dc.l	$05011234,$00cff400,$00c7f800,$00031234
	.dc.l	$05011234,$00cff7fe,$00c7fbfe,$00031234
	.dc.l	$05011234,$00cff800,$00c7fc00,$00041234
	.dc.l	$05011234,$00cffbfe,$00c7fffe,$00041234
	.dc.l	$05011234,$00cffc00,$00c7fc00,$00031234
	.dc.l	$05011234,$00cffffe,$00c7fffe,$00031234
	.dc.l	$05011234,$00d00000,$00c00000,$00021234
	.dc.l	$05011234,$00d003fe,$00c003fe,$00021234
	.dc.l	$05011234,$00d00400,$00c00000,$00011234
	.dc.l	$05011234,$00d007fe,$00c003fe,$00011234
	.dc.l	$05011234,$00d00800,$00c00400,$00021234
	.dc.l	$05011234,$00d00bfe,$00c007fe,$00021234
	.dc.l	$05011234,$00d00c00,$00c00400,$00011234
	.dc.l	$05011234,$00d00ffe,$00c007fe,$00011234
	.dc.l	$05011234,$00dff000,$00c7f800,$00021234
	.dc.l	$05011234,$00dff3fe,$00c7fbfe,$00021234
	.dc.l	$05011234,$00dff400,$00c7f800,$00011234
	.dc.l	$05011234,$00dff7fe,$00c7fbfe,$00011234
	.dc.l	$05011234,$00dff800,$00c7fc00,$00021234
	.dc.l	$05011234,$00dffbfe,$00c7fffe,$00021234
	.dc.l	$05011234,$00dffc00,$00c7fc00,$00011234
	.dc.l	$05011234,$00dffffe,$00c7fffe,$00011234
;write byte
	.dc.l	$05021234,$00c00000,$00c00000,$56781234
	.dc.l	$05021234,$00c00001,$00c00000,$56781238
	.dc.l	$05021234,$00c003fe,$00c003fe,$56781234
	.dc.l	$05021234,$00c003ff,$00c003fe,$56781238
	.dc.l	$05021234,$00c00400,$00c00000,$56781234
	.dc.l	$05021234,$00c00401,$00c00000,$56781284
	.dc.l	$05021234,$00c007fe,$00c003fe,$56781234
	.dc.l	$05021234,$00c007ff,$00c003fe,$56781284
	.dc.l	$05021234,$00c00800,$00c00400,$56781234
	.dc.l	$05021234,$00c00801,$00c00400,$56781238
	.dc.l	$05021234,$00c00bfe,$00c007fe,$56781234
	.dc.l	$05021234,$00c00bff,$00c007fe,$56781238
	.dc.l	$05021234,$00c00c00,$00c00400,$56781234
	.dc.l	$05021234,$00c00c01,$00c00400,$56781284
	.dc.l	$05021234,$00c00ffe,$00c007fe,$56781234
	.dc.l	$05021234,$00c00fff,$00c007fe,$56781284
	.dc.l	$05021234,$00cff000,$00c7f800,$56781234
	.dc.l	$05021234,$00cff001,$00c7f800,$56781238
	.dc.l	$05021234,$00cff3fe,$00c7fbfe,$56781234
	.dc.l	$05021234,$00cff3ff,$00c7fbfe,$56781238
	.dc.l	$05021234,$00cff400,$00c7f800,$56781234
	.dc.l	$05021234,$00cff401,$00c7f800,$56781284
	.dc.l	$05021234,$00cff7fe,$00c7fbfe,$56781234
	.dc.l	$05021234,$00cff7ff,$00c7fbfe,$56781284
	.dc.l	$05021234,$00cff800,$00c7fc00,$56781234
	.dc.l	$05021234,$00cff801,$00c7fc00,$56781238
	.dc.l	$05021234,$00cffbfe,$00c7fffe,$56781234
	.dc.l	$05021234,$00cffbff,$00c7fffe,$56781238
	.dc.l	$05021234,$00cffc00,$00c7fc00,$56781234
	.dc.l	$05021234,$00cffc01,$00c7fc00,$56781284
	.dc.l	$05021234,$00cffffe,$00c7fffe,$56781234
	.dc.l	$05021234,$00cfffff,$00c7fffe,$56781284
	.dc.l	$05021234,$00d00000,$00c00000,$56781234
	.dc.l	$05021234,$00d00001,$00c00000,$56781834
	.dc.l	$05021234,$00d003fe,$00c003fe,$56781234
	.dc.l	$05021234,$00d003ff,$00c003fe,$56781834
	.dc.l	$05021234,$00d00400,$00c00000,$56781234
	.dc.l	$05021234,$00d00401,$00c00000,$56788234
	.dc.l	$05021234,$00d007fe,$00c003fe,$56781234
	.dc.l	$05021234,$00d007ff,$00c003fe,$56788234
	.dc.l	$05021234,$00d00800,$00c00400,$56781234
	.dc.l	$05021234,$00d00801,$00c00400,$56781834
	.dc.l	$05021234,$00d00bfe,$00c007fe,$56781234
	.dc.l	$05021234,$00d00bff,$00c007fe,$56781834
	.dc.l	$05021234,$00d00c00,$00c00400,$56781234
	.dc.l	$05021234,$00d00c01,$00c00400,$56788234
	.dc.l	$05021234,$00d00ffe,$00c007fe,$56781234
	.dc.l	$05021234,$00d00fff,$00c007fe,$56788234
	.dc.l	$05021234,$00dff000,$00c7f800,$56781234
	.dc.l	$05021234,$00dff001,$00c7f800,$56781834
	.dc.l	$05021234,$00dff3fe,$00c7fbfe,$56781234
	.dc.l	$05021234,$00dff3ff,$00c7fbfe,$56781834
	.dc.l	$05021234,$00dff400,$00c7f800,$56781234
	.dc.l	$05021234,$00dff401,$00c7f800,$56788234
	.dc.l	$05021234,$00dff7fe,$00c7fbfe,$56781234
	.dc.l	$05021234,$00dff7ff,$00c7fbfe,$56788234
	.dc.l	$05021234,$00dff800,$00c7fc00,$56781234
	.dc.l	$05021234,$00dff801,$00c7fc00,$56781834
	.dc.l	$05021234,$00dffbfe,$00c7fffe,$56781234
	.dc.l	$05021234,$00dffbff,$00c7fffe,$56781834
	.dc.l	$05021234,$00dffc00,$00c7fc00,$56781234
	.dc.l	$05021234,$00dffc01,$00c7fc00,$56788234
	.dc.l	$05021234,$00dffffe,$00c7fffe,$56781234
	.dc.l	$05021234,$00dfffff,$00c7fffe,$56788234
;write word
	.dc.l	$05031234,$00c00000,$00c00000,$56781238
	.dc.l	$05031234,$00c003fe,$00c003fe,$56781238
	.dc.l	$05031234,$00c00400,$00c00000,$56781284
	.dc.l	$05031234,$00c007fe,$00c003fe,$56781284
	.dc.l	$05031234,$00c00800,$00c00400,$56781238
	.dc.l	$05031234,$00c00bfe,$00c007fe,$56781238
	.dc.l	$05031234,$00c00c00,$00c00400,$56781284
	.dc.l	$05031234,$00c00ffe,$00c007fe,$56781284
	.dc.l	$05031234,$00cff000,$00c7f800,$56781238
	.dc.l	$05031234,$00cff3fe,$00c7fbfe,$56781238
	.dc.l	$05031234,$00cff400,$00c7f800,$56781284
	.dc.l	$05031234,$00cff7fe,$00c7fbfe,$56781284
	.dc.l	$05031234,$00cff800,$00c7fc00,$56781238
	.dc.l	$05031234,$00cffbfe,$00c7fffe,$56781238
	.dc.l	$05031234,$00cffc00,$00c7fc00,$56781284
	.dc.l	$05031234,$00cffffe,$00c7fffe,$56781284
	.dc.l	$05031234,$00d00000,$00c00000,$56781834
	.dc.l	$05031234,$00d003fe,$00c003fe,$56781834
	.dc.l	$05031234,$00d00400,$00c00000,$56788234
	.dc.l	$05031234,$00d007fe,$00c003fe,$56788234
	.dc.l	$05031234,$00d00800,$00c00400,$56781834
	.dc.l	$05031234,$00d00bfe,$00c007fe,$56781834
	.dc.l	$05031234,$00d00c00,$00c00400,$56788234
	.dc.l	$05031234,$00d00ffe,$00c007fe,$56788234
	.dc.l	$05031234,$00dff000,$00c7f800,$56781834
	.dc.l	$05031234,$00dff3fe,$00c7fbfe,$56781834
	.dc.l	$05031234,$00dff400,$00c7f800,$56788234
	.dc.l	$05031234,$00dff7fe,$00c7fbfe,$56788234
	.dc.l	$05031234,$00dff800,$00c7fc00,$56781834
	.dc.l	$05031234,$00dffbfe,$00c7fffe,$56781834
	.dc.l	$05031234,$00dffc00,$00c7fc00,$56788234
	.dc.l	$05031234,$00dffffe,$00c7fffe,$56788234
;
	.dc.l	-1

memory_mode_6:
;referenced address
;	0b00000000_110Yyyyy_yyyyyXxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c00400 .. 0x00c007ff |
;	| 0x00c00800    0x00c00bff | 0x00c00c00    0x00c00fff |
;	|      :             :     |      :             :     |
;	| 0x00cff000    0x00cff3ff | 0x00cff400    0x00cff7ff |
;	| 0x00cff800 .. 0x00cffbff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d00400 .. 0x00d007ff |
;	| 0x00d00800    0x00d00bff | 0x00d00c00    0x00d00fff |
;	|      :             :     |      :             :     |
;	| 0x00dff000    0x00dff3ff | 0x00dff400    0x00dff7ff |
;	| 0x00dff800 .. 0x00dffbff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;stored address
;	0b00000000_110YXyyy_yyyyyyxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c80000 .. 0x00c803ff |
;	| 0x00c00400    0x00c007ff | 0x00c80400    0x00c807ff |
;	|      :     G0      :     |      :     G1      :     |
;	| 0x00c7f800    0x00c7fbff | 0x00cff800    0x00cffbff |
;	| 0x00c7fc00 .. 0x00c7ffff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d80000 .. 0x00d803ff |
;	| 0x00d00400    0x00d007ff | 0x00d80400    0x00d807ff |
;	|      :     G2      :     |      :     G3      :     |
;	| 0x00d7f800    0x00d7fbff | 0x00dff800    0x00dffbff |
;	| 0x00d7fc00 .. 0x00d7ffff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;read byte
	.dc.l	$06001234,$00c00000,$00c00000,$00001234
	.dc.l	$06001234,$00c00001,$00c00000,$00041234
	.dc.l	$06001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$06001234,$00c003ff,$00c003fe,$00041234
	.dc.l	$06001234,$00c00400,$00c00000,$00001234
	.dc.l	$06001234,$00c00401,$00c00000,$00031234
	.dc.l	$06001234,$00c007fe,$00c003fe,$00001234
	.dc.l	$06001234,$00c007ff,$00c003fe,$00031234
	.dc.l	$06001234,$00c00800,$00c00400,$00001234
	.dc.l	$06001234,$00c00801,$00c00400,$00041234
	.dc.l	$06001234,$00c00bfe,$00c007fe,$00001234
	.dc.l	$06001234,$00c00bff,$00c007fe,$00041234
	.dc.l	$06001234,$00c00c00,$00c00400,$00001234
	.dc.l	$06001234,$00c00c01,$00c00400,$00031234
	.dc.l	$06001234,$00c00ffe,$00c007fe,$00001234
	.dc.l	$06001234,$00c00fff,$00c007fe,$00031234
	.dc.l	$06001234,$00cff000,$00c7f800,$00001234
	.dc.l	$06001234,$00cff001,$00c7f800,$00041234
	.dc.l	$06001234,$00cff3fe,$00c7fbfe,$00001234
	.dc.l	$06001234,$00cff3ff,$00c7fbfe,$00041234
	.dc.l	$06001234,$00cff400,$00c7f800,$00001234
	.dc.l	$06001234,$00cff401,$00c7f800,$00031234
	.dc.l	$06001234,$00cff7fe,$00c7fbfe,$00001234
	.dc.l	$06001234,$00cff7ff,$00c7fbfe,$00031234
	.dc.l	$06001234,$00cff800,$00c7fc00,$00001234
	.dc.l	$06001234,$00cff801,$00c7fc00,$00041234
	.dc.l	$06001234,$00cffbfe,$00c7fffe,$00001234
	.dc.l	$06001234,$00cffbff,$00c7fffe,$00041234
	.dc.l	$06001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$06001234,$00cffc01,$00c7fc00,$00031234
	.dc.l	$06001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$06001234,$00cfffff,$00c7fffe,$00031234
	.dc.l	$06001234,$00d00000,$00c00000,$00001234
	.dc.l	$06001234,$00d00001,$00c00000,$00021234
	.dc.l	$06001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$06001234,$00d003ff,$00c003fe,$00021234
	.dc.l	$06001234,$00d00400,$00c00000,$00001234
	.dc.l	$06001234,$00d00401,$00c00000,$00011234
	.dc.l	$06001234,$00d007fe,$00c003fe,$00001234
	.dc.l	$06001234,$00d007ff,$00c003fe,$00011234
	.dc.l	$06001234,$00d00800,$00c00400,$00001234
	.dc.l	$06001234,$00d00801,$00c00400,$00021234
	.dc.l	$06001234,$00d00bfe,$00c007fe,$00001234
	.dc.l	$06001234,$00d00bff,$00c007fe,$00021234
	.dc.l	$06001234,$00d00c00,$00c00400,$00001234
	.dc.l	$06001234,$00d00c01,$00c00400,$00011234
	.dc.l	$06001234,$00d00ffe,$00c007fe,$00001234
	.dc.l	$06001234,$00d00fff,$00c007fe,$00011234
	.dc.l	$06001234,$00dff000,$00c7f800,$00001234
	.dc.l	$06001234,$00dff001,$00c7f800,$00021234
	.dc.l	$06001234,$00dff3fe,$00c7fbfe,$00001234
	.dc.l	$06001234,$00dff3ff,$00c7fbfe,$00021234
	.dc.l	$06001234,$00dff400,$00c7f800,$00001234
	.dc.l	$06001234,$00dff401,$00c7f800,$00011234
	.dc.l	$06001234,$00dff7fe,$00c7fbfe,$00001234
	.dc.l	$06001234,$00dff7ff,$00c7fbfe,$00011234
	.dc.l	$06001234,$00dff800,$00c7fc00,$00001234
	.dc.l	$06001234,$00dff801,$00c7fc00,$00021234
	.dc.l	$06001234,$00dffbfe,$00c7fffe,$00001234
	.dc.l	$06001234,$00dffbff,$00c7fffe,$00021234
	.dc.l	$06001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$06001234,$00dffc01,$00c7fc00,$00011234
	.dc.l	$06001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$06001234,$00dfffff,$00c7fffe,$00011234
;read word
	.dc.l	$06011234,$00c00000,$00c00000,$00041234
	.dc.l	$06011234,$00c003fe,$00c003fe,$00041234
	.dc.l	$06011234,$00c00400,$00c00000,$00031234
	.dc.l	$06011234,$00c007fe,$00c003fe,$00031234
	.dc.l	$06011234,$00c00800,$00c00400,$00041234
	.dc.l	$06011234,$00c00bfe,$00c007fe,$00041234
	.dc.l	$06011234,$00c00c00,$00c00400,$00031234
	.dc.l	$06011234,$00c00ffe,$00c007fe,$00031234
	.dc.l	$06011234,$00cff000,$00c7f800,$00041234
	.dc.l	$06011234,$00cff3fe,$00c7fbfe,$00041234
	.dc.l	$06011234,$00cff400,$00c7f800,$00031234
	.dc.l	$06011234,$00cff7fe,$00c7fbfe,$00031234
	.dc.l	$06011234,$00cff800,$00c7fc00,$00041234
	.dc.l	$06011234,$00cffbfe,$00c7fffe,$00041234
	.dc.l	$06011234,$00cffc00,$00c7fc00,$00031234
	.dc.l	$06011234,$00cffffe,$00c7fffe,$00031234
	.dc.l	$06011234,$00d00000,$00c00000,$00021234
	.dc.l	$06011234,$00d003fe,$00c003fe,$00021234
	.dc.l	$06011234,$00d00400,$00c00000,$00011234
	.dc.l	$06011234,$00d007fe,$00c003fe,$00011234
	.dc.l	$06011234,$00d00800,$00c00400,$00021234
	.dc.l	$06011234,$00d00bfe,$00c007fe,$00021234
	.dc.l	$06011234,$00d00c00,$00c00400,$00011234
	.dc.l	$06011234,$00d00ffe,$00c007fe,$00011234
	.dc.l	$06011234,$00dff000,$00c7f800,$00021234
	.dc.l	$06011234,$00dff3fe,$00c7fbfe,$00021234
	.dc.l	$06011234,$00dff400,$00c7f800,$00011234
	.dc.l	$06011234,$00dff7fe,$00c7fbfe,$00011234
	.dc.l	$06011234,$00dff800,$00c7fc00,$00021234
	.dc.l	$06011234,$00dffbfe,$00c7fffe,$00021234
	.dc.l	$06011234,$00dffc00,$00c7fc00,$00011234
	.dc.l	$06011234,$00dffffe,$00c7fffe,$00011234
;write byte
	.dc.l	$06021234,$00c00000,$00c00000,$56781234
	.dc.l	$06021234,$00c00001,$00c00000,$56781238
	.dc.l	$06021234,$00c003fe,$00c003fe,$56781234
	.dc.l	$06021234,$00c003ff,$00c003fe,$56781238
	.dc.l	$06021234,$00c00400,$00c00000,$56781234
	.dc.l	$06021234,$00c00401,$00c00000,$56781284
	.dc.l	$06021234,$00c007fe,$00c003fe,$56781234
	.dc.l	$06021234,$00c007ff,$00c003fe,$56781284
	.dc.l	$06021234,$00c00800,$00c00400,$56781234
	.dc.l	$06021234,$00c00801,$00c00400,$56781238
	.dc.l	$06021234,$00c00bfe,$00c007fe,$56781234
	.dc.l	$06021234,$00c00bff,$00c007fe,$56781238
	.dc.l	$06021234,$00c00c00,$00c00400,$56781234
	.dc.l	$06021234,$00c00c01,$00c00400,$56781284
	.dc.l	$06021234,$00c00ffe,$00c007fe,$56781234
	.dc.l	$06021234,$00c00fff,$00c007fe,$56781284
	.dc.l	$06021234,$00cff000,$00c7f800,$56781234
	.dc.l	$06021234,$00cff001,$00c7f800,$56781238
	.dc.l	$06021234,$00cff3fe,$00c7fbfe,$56781234
	.dc.l	$06021234,$00cff3ff,$00c7fbfe,$56781238
	.dc.l	$06021234,$00cff400,$00c7f800,$56781234
	.dc.l	$06021234,$00cff401,$00c7f800,$56781284
	.dc.l	$06021234,$00cff7fe,$00c7fbfe,$56781234
	.dc.l	$06021234,$00cff7ff,$00c7fbfe,$56781284
	.dc.l	$06021234,$00cff800,$00c7fc00,$56781234
	.dc.l	$06021234,$00cff801,$00c7fc00,$56781238
	.dc.l	$06021234,$00cffbfe,$00c7fffe,$56781234
	.dc.l	$06021234,$00cffbff,$00c7fffe,$56781238
	.dc.l	$06021234,$00cffc00,$00c7fc00,$56781234
	.dc.l	$06021234,$00cffc01,$00c7fc00,$56781284
	.dc.l	$06021234,$00cffffe,$00c7fffe,$56781234
	.dc.l	$06021234,$00cfffff,$00c7fffe,$56781284
	.dc.l	$06021234,$00d00000,$00c00000,$56781234
	.dc.l	$06021234,$00d00001,$00c00000,$56781834
	.dc.l	$06021234,$00d003fe,$00c003fe,$56781234
	.dc.l	$06021234,$00d003ff,$00c003fe,$56781834
	.dc.l	$06021234,$00d00400,$00c00000,$56781234
	.dc.l	$06021234,$00d00401,$00c00000,$56788234
	.dc.l	$06021234,$00d007fe,$00c003fe,$56781234
	.dc.l	$06021234,$00d007ff,$00c003fe,$56788234
	.dc.l	$06021234,$00d00800,$00c00400,$56781234
	.dc.l	$06021234,$00d00801,$00c00400,$56781834
	.dc.l	$06021234,$00d00bfe,$00c007fe,$56781234
	.dc.l	$06021234,$00d00bff,$00c007fe,$56781834
	.dc.l	$06021234,$00d00c00,$00c00400,$56781234
	.dc.l	$06021234,$00d00c01,$00c00400,$56788234
	.dc.l	$06021234,$00d00ffe,$00c007fe,$56781234
	.dc.l	$06021234,$00d00fff,$00c007fe,$56788234
	.dc.l	$06021234,$00dff000,$00c7f800,$56781234
	.dc.l	$06021234,$00dff001,$00c7f800,$56781834
	.dc.l	$06021234,$00dff3fe,$00c7fbfe,$56781234
	.dc.l	$06021234,$00dff3ff,$00c7fbfe,$56781834
	.dc.l	$06021234,$00dff400,$00c7f800,$56781234
	.dc.l	$06021234,$00dff401,$00c7f800,$56788234
	.dc.l	$06021234,$00dff7fe,$00c7fbfe,$56781234
	.dc.l	$06021234,$00dff7ff,$00c7fbfe,$56788234
	.dc.l	$06021234,$00dff800,$00c7fc00,$56781234
	.dc.l	$06021234,$00dff801,$00c7fc00,$56781834
	.dc.l	$06021234,$00dffbfe,$00c7fffe,$56781234
	.dc.l	$06021234,$00dffbff,$00c7fffe,$56781834
	.dc.l	$06021234,$00dffc00,$00c7fc00,$56781234
	.dc.l	$06021234,$00dffc01,$00c7fc00,$56788234
	.dc.l	$06021234,$00dffffe,$00c7fffe,$56781234
	.dc.l	$06021234,$00dfffff,$00c7fffe,$56788234
;write word
	.dc.l	$06031234,$00c00000,$00c00000,$56781238
	.dc.l	$06031234,$00c003fe,$00c003fe,$56781238
	.dc.l	$06031234,$00c00400,$00c00000,$56781284
	.dc.l	$06031234,$00c007fe,$00c003fe,$56781284
	.dc.l	$06031234,$00c00800,$00c00400,$56781238
	.dc.l	$06031234,$00c00bfe,$00c007fe,$56781238
	.dc.l	$06031234,$00c00c00,$00c00400,$56781284
	.dc.l	$06031234,$00c00ffe,$00c007fe,$56781284
	.dc.l	$06031234,$00cff000,$00c7f800,$56781238
	.dc.l	$06031234,$00cff3fe,$00c7fbfe,$56781238
	.dc.l	$06031234,$00cff400,$00c7f800,$56781284
	.dc.l	$06031234,$00cff7fe,$00c7fbfe,$56781284
	.dc.l	$06031234,$00cff800,$00c7fc00,$56781238
	.dc.l	$06031234,$00cffbfe,$00c7fffe,$56781238
	.dc.l	$06031234,$00cffc00,$00c7fc00,$56781284
	.dc.l	$06031234,$00cffffe,$00c7fffe,$56781284
	.dc.l	$06031234,$00d00000,$00c00000,$56781834
	.dc.l	$06031234,$00d003fe,$00c003fe,$56781834
	.dc.l	$06031234,$00d00400,$00c00000,$56788234
	.dc.l	$06031234,$00d007fe,$00c003fe,$56788234
	.dc.l	$06031234,$00d00800,$00c00400,$56781834
	.dc.l	$06031234,$00d00bfe,$00c007fe,$56781834
	.dc.l	$06031234,$00d00c00,$00c00400,$56788234
	.dc.l	$06031234,$00d00ffe,$00c007fe,$56788234
	.dc.l	$06031234,$00dff000,$00c7f800,$56781834
	.dc.l	$06031234,$00dff3fe,$00c7fbfe,$56781834
	.dc.l	$06031234,$00dff400,$00c7f800,$56788234
	.dc.l	$06031234,$00dff7fe,$00c7fbfe,$56788234
	.dc.l	$06031234,$00dff800,$00c7fc00,$56781834
	.dc.l	$06031234,$00dffbfe,$00c7fffe,$56781834
	.dc.l	$06031234,$00dffc00,$00c7fc00,$56788234
	.dc.l	$06031234,$00dffffe,$00c7fffe,$56788234
;
	.dc.l	-1

memory_mode_7:
;referenced address
;	0b00000000_110Yyyyy_yyyyyXxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c00400 .. 0x00c007ff |
;	| 0x00c00800    0x00c00bff | 0x00c00c00    0x00c00fff |
;	|      :             :     |      :             :     |
;	| 0x00cff000    0x00cff3ff | 0x00cff400    0x00cff7ff |
;	| 0x00cff800 .. 0x00cffbff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d00400 .. 0x00d007ff |
;	| 0x00d00800    0x00d00bff | 0x00d00c00    0x00d00fff |
;	|      :             :     |      :             :     |
;	| 0x00dff000    0x00dff3ff | 0x00dff400    0x00dff7ff |
;	| 0x00dff800 .. 0x00dffbff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;stored address
;	0b00000000_110YXyyy_yyyyyyxx_xxxxxxx?
;	+--------------------------+--------------------------+
;	| 0x00c00000 .. 0x00c003ff | 0x00c80000 .. 0x00c803ff |
;	| 0x00c00400    0x00c007ff | 0x00c80400    0x00c807ff |
;	|      :     G0      :     |      :     G1      :     |
;	| 0x00c7f800    0x00c7fbff | 0x00cff800    0x00cffbff |
;	| 0x00c7fc00 .. 0x00c7ffff | 0x00cffc00 .. 0x00cfffff |
;	+--------------------------+--------------------------+
;	| 0x00d00000 .. 0x00d003ff | 0x00d80000 .. 0x00d803ff |
;	| 0x00d00400    0x00d007ff | 0x00d80400    0x00d807ff |
;	|      :     G2      :     |      :     G3      :     |
;	| 0x00d7f800    0x00d7fbff | 0x00dff800    0x00dffbff |
;	| 0x00d7fc00 .. 0x00d7ffff | 0x00dffc00 .. 0x00dfffff |
;	+--------------------------+--------------------------+
;read byte
	.dc.l	$07001234,$00c00000,$00c00000,$00001234
	.dc.l	$07001234,$00c00001,$00c00000,$00041234
	.dc.l	$07001234,$00c003fe,$00c003fe,$00001234
	.dc.l	$07001234,$00c003ff,$00c003fe,$00041234
	.dc.l	$07001234,$00c00400,$00c00000,$00001234
	.dc.l	$07001234,$00c00401,$00c00000,$00031234
	.dc.l	$07001234,$00c007fe,$00c003fe,$00001234
	.dc.l	$07001234,$00c007ff,$00c003fe,$00031234
	.dc.l	$07001234,$00c00800,$00c00400,$00001234
	.dc.l	$07001234,$00c00801,$00c00400,$00041234
	.dc.l	$07001234,$00c00bfe,$00c007fe,$00001234
	.dc.l	$07001234,$00c00bff,$00c007fe,$00041234
	.dc.l	$07001234,$00c00c00,$00c00400,$00001234
	.dc.l	$07001234,$00c00c01,$00c00400,$00031234
	.dc.l	$07001234,$00c00ffe,$00c007fe,$00001234
	.dc.l	$07001234,$00c00fff,$00c007fe,$00031234
	.dc.l	$07001234,$00cff000,$00c7f800,$00001234
	.dc.l	$07001234,$00cff001,$00c7f800,$00041234
	.dc.l	$07001234,$00cff3fe,$00c7fbfe,$00001234
	.dc.l	$07001234,$00cff3ff,$00c7fbfe,$00041234
	.dc.l	$07001234,$00cff400,$00c7f800,$00001234
	.dc.l	$07001234,$00cff401,$00c7f800,$00031234
	.dc.l	$07001234,$00cff7fe,$00c7fbfe,$00001234
	.dc.l	$07001234,$00cff7ff,$00c7fbfe,$00031234
	.dc.l	$07001234,$00cff800,$00c7fc00,$00001234
	.dc.l	$07001234,$00cff801,$00c7fc00,$00041234
	.dc.l	$07001234,$00cffbfe,$00c7fffe,$00001234
	.dc.l	$07001234,$00cffbff,$00c7fffe,$00041234
	.dc.l	$07001234,$00cffc00,$00c7fc00,$00001234
	.dc.l	$07001234,$00cffc01,$00c7fc00,$00031234
	.dc.l	$07001234,$00cffffe,$00c7fffe,$00001234
	.dc.l	$07001234,$00cfffff,$00c7fffe,$00031234
	.dc.l	$07001234,$00d00000,$00c00000,$00001234
	.dc.l	$07001234,$00d00001,$00c00000,$00021234
	.dc.l	$07001234,$00d003fe,$00c003fe,$00001234
	.dc.l	$07001234,$00d003ff,$00c003fe,$00021234
	.dc.l	$07001234,$00d00400,$00c00000,$00001234
	.dc.l	$07001234,$00d00401,$00c00000,$00011234
	.dc.l	$07001234,$00d007fe,$00c003fe,$00001234
	.dc.l	$07001234,$00d007ff,$00c003fe,$00011234
	.dc.l	$07001234,$00d00800,$00c00400,$00001234
	.dc.l	$07001234,$00d00801,$00c00400,$00021234
	.dc.l	$07001234,$00d00bfe,$00c007fe,$00001234
	.dc.l	$07001234,$00d00bff,$00c007fe,$00021234
	.dc.l	$07001234,$00d00c00,$00c00400,$00001234
	.dc.l	$07001234,$00d00c01,$00c00400,$00011234
	.dc.l	$07001234,$00d00ffe,$00c007fe,$00001234
	.dc.l	$07001234,$00d00fff,$00c007fe,$00011234
	.dc.l	$07001234,$00dff000,$00c7f800,$00001234
	.dc.l	$07001234,$00dff001,$00c7f800,$00021234
	.dc.l	$07001234,$00dff3fe,$00c7fbfe,$00001234
	.dc.l	$07001234,$00dff3ff,$00c7fbfe,$00021234
	.dc.l	$07001234,$00dff400,$00c7f800,$00001234
	.dc.l	$07001234,$00dff401,$00c7f800,$00011234
	.dc.l	$07001234,$00dff7fe,$00c7fbfe,$00001234
	.dc.l	$07001234,$00dff7ff,$00c7fbfe,$00011234
	.dc.l	$07001234,$00dff800,$00c7fc00,$00001234
	.dc.l	$07001234,$00dff801,$00c7fc00,$00021234
	.dc.l	$07001234,$00dffbfe,$00c7fffe,$00001234
	.dc.l	$07001234,$00dffbff,$00c7fffe,$00021234
	.dc.l	$07001234,$00dffc00,$00c7fc00,$00001234
	.dc.l	$07001234,$00dffc01,$00c7fc00,$00011234
	.dc.l	$07001234,$00dffffe,$00c7fffe,$00001234
	.dc.l	$07001234,$00dfffff,$00c7fffe,$00011234
;read word
	.dc.l	$07011234,$00c00000,$00c00000,$00041234
	.dc.l	$07011234,$00c003fe,$00c003fe,$00041234
	.dc.l	$07011234,$00c00400,$00c00000,$00031234
	.dc.l	$07011234,$00c007fe,$00c003fe,$00031234
	.dc.l	$07011234,$00c00800,$00c00400,$00041234
	.dc.l	$07011234,$00c00bfe,$00c007fe,$00041234
	.dc.l	$07011234,$00c00c00,$00c00400,$00031234
	.dc.l	$07011234,$00c00ffe,$00c007fe,$00031234
	.dc.l	$07011234,$00cff000,$00c7f800,$00041234
	.dc.l	$07011234,$00cff3fe,$00c7fbfe,$00041234
	.dc.l	$07011234,$00cff400,$00c7f800,$00031234
	.dc.l	$07011234,$00cff7fe,$00c7fbfe,$00031234
	.dc.l	$07011234,$00cff800,$00c7fc00,$00041234
	.dc.l	$07011234,$00cffbfe,$00c7fffe,$00041234
	.dc.l	$07011234,$00cffc00,$00c7fc00,$00031234
	.dc.l	$07011234,$00cffffe,$00c7fffe,$00031234
	.dc.l	$07011234,$00d00000,$00c00000,$00021234
	.dc.l	$07011234,$00d003fe,$00c003fe,$00021234
	.dc.l	$07011234,$00d00400,$00c00000,$00011234
	.dc.l	$07011234,$00d007fe,$00c003fe,$00011234
	.dc.l	$07011234,$00d00800,$00c00400,$00021234
	.dc.l	$07011234,$00d00bfe,$00c007fe,$00021234
	.dc.l	$07011234,$00d00c00,$00c00400,$00011234
	.dc.l	$07011234,$00d00ffe,$00c007fe,$00011234
	.dc.l	$07011234,$00dff000,$00c7f800,$00021234
	.dc.l	$07011234,$00dff3fe,$00c7fbfe,$00021234
	.dc.l	$07011234,$00dff400,$00c7f800,$00011234
	.dc.l	$07011234,$00dff7fe,$00c7fbfe,$00011234
	.dc.l	$07011234,$00dff800,$00c7fc00,$00021234
	.dc.l	$07011234,$00dffbfe,$00c7fffe,$00021234
	.dc.l	$07011234,$00dffc00,$00c7fc00,$00011234
	.dc.l	$07011234,$00dffffe,$00c7fffe,$00011234
;write byte
	.dc.l	$07021234,$00c00000,$00c00000,$56781234
	.dc.l	$07021234,$00c00001,$00c00000,$56781238
	.dc.l	$07021234,$00c003fe,$00c003fe,$56781234
	.dc.l	$07021234,$00c003ff,$00c003fe,$56781238
	.dc.l	$07021234,$00c00400,$00c00000,$56781234
	.dc.l	$07021234,$00c00401,$00c00000,$56781284
	.dc.l	$07021234,$00c007fe,$00c003fe,$56781234
	.dc.l	$07021234,$00c007ff,$00c003fe,$56781284
	.dc.l	$07021234,$00c00800,$00c00400,$56781234
	.dc.l	$07021234,$00c00801,$00c00400,$56781238
	.dc.l	$07021234,$00c00bfe,$00c007fe,$56781234
	.dc.l	$07021234,$00c00bff,$00c007fe,$56781238
	.dc.l	$07021234,$00c00c00,$00c00400,$56781234
	.dc.l	$07021234,$00c00c01,$00c00400,$56781284
	.dc.l	$07021234,$00c00ffe,$00c007fe,$56781234
	.dc.l	$07021234,$00c00fff,$00c007fe,$56781284
	.dc.l	$07021234,$00cff000,$00c7f800,$56781234
	.dc.l	$07021234,$00cff001,$00c7f800,$56781238
	.dc.l	$07021234,$00cff3fe,$00c7fbfe,$56781234
	.dc.l	$07021234,$00cff3ff,$00c7fbfe,$56781238
	.dc.l	$07021234,$00cff400,$00c7f800,$56781234
	.dc.l	$07021234,$00cff401,$00c7f800,$56781284
	.dc.l	$07021234,$00cff7fe,$00c7fbfe,$56781234
	.dc.l	$07021234,$00cff7ff,$00c7fbfe,$56781284
	.dc.l	$07021234,$00cff800,$00c7fc00,$56781234
	.dc.l	$07021234,$00cff801,$00c7fc00,$56781238
	.dc.l	$07021234,$00cffbfe,$00c7fffe,$56781234
	.dc.l	$07021234,$00cffbff,$00c7fffe,$56781238
	.dc.l	$07021234,$00cffc00,$00c7fc00,$56781234
	.dc.l	$07021234,$00cffc01,$00c7fc00,$56781284
	.dc.l	$07021234,$00cffffe,$00c7fffe,$56781234
	.dc.l	$07021234,$00cfffff,$00c7fffe,$56781284
	.dc.l	$07021234,$00d00000,$00c00000,$56781234
	.dc.l	$07021234,$00d00001,$00c00000,$56781834
	.dc.l	$07021234,$00d003fe,$00c003fe,$56781234
	.dc.l	$07021234,$00d003ff,$00c003fe,$56781834
	.dc.l	$07021234,$00d00400,$00c00000,$56781234
	.dc.l	$07021234,$00d00401,$00c00000,$56788234
	.dc.l	$07021234,$00d007fe,$00c003fe,$56781234
	.dc.l	$07021234,$00d007ff,$00c003fe,$56788234
	.dc.l	$07021234,$00d00800,$00c00400,$56781234
	.dc.l	$07021234,$00d00801,$00c00400,$56781834
	.dc.l	$07021234,$00d00bfe,$00c007fe,$56781234
	.dc.l	$07021234,$00d00bff,$00c007fe,$56781834
	.dc.l	$07021234,$00d00c00,$00c00400,$56781234
	.dc.l	$07021234,$00d00c01,$00c00400,$56788234
	.dc.l	$07021234,$00d00ffe,$00c007fe,$56781234
	.dc.l	$07021234,$00d00fff,$00c007fe,$56788234
	.dc.l	$07021234,$00dff000,$00c7f800,$56781234
	.dc.l	$07021234,$00dff001,$00c7f800,$56781834
	.dc.l	$07021234,$00dff3fe,$00c7fbfe,$56781234
	.dc.l	$07021234,$00dff3ff,$00c7fbfe,$56781834
	.dc.l	$07021234,$00dff400,$00c7f800,$56781234
	.dc.l	$07021234,$00dff401,$00c7f800,$56788234
	.dc.l	$07021234,$00dff7fe,$00c7fbfe,$56781234
	.dc.l	$07021234,$00dff7ff,$00c7fbfe,$56788234
	.dc.l	$07021234,$00dff800,$00c7fc00,$56781234
	.dc.l	$07021234,$00dff801,$00c7fc00,$56781834
	.dc.l	$07021234,$00dffbfe,$00c7fffe,$56781234
	.dc.l	$07021234,$00dffbff,$00c7fffe,$56781834
	.dc.l	$07021234,$00dffc00,$00c7fc00,$56781234
	.dc.l	$07021234,$00dffc01,$00c7fc00,$56788234
	.dc.l	$07021234,$00dffffe,$00c7fffe,$56781234
	.dc.l	$07021234,$00dfffff,$00c7fffe,$56788234
;write word
	.dc.l	$07031234,$00c00000,$00c00000,$56781238
	.dc.l	$07031234,$00c003fe,$00c003fe,$56781238
	.dc.l	$07031234,$00c00400,$00c00000,$56781284
	.dc.l	$07031234,$00c007fe,$00c003fe,$56781284
	.dc.l	$07031234,$00c00800,$00c00400,$56781238
	.dc.l	$07031234,$00c00bfe,$00c007fe,$56781238
	.dc.l	$07031234,$00c00c00,$00c00400,$56781284
	.dc.l	$07031234,$00c00ffe,$00c007fe,$56781284
	.dc.l	$07031234,$00cff000,$00c7f800,$56781238
	.dc.l	$07031234,$00cff3fe,$00c7fbfe,$56781238
	.dc.l	$07031234,$00cff400,$00c7f800,$56781284
	.dc.l	$07031234,$00cff7fe,$00c7fbfe,$56781284
	.dc.l	$07031234,$00cff800,$00c7fc00,$56781238
	.dc.l	$07031234,$00cffbfe,$00c7fffe,$56781238
	.dc.l	$07031234,$00cffc00,$00c7fc00,$56781284
	.dc.l	$07031234,$00cffffe,$00c7fffe,$56781284
	.dc.l	$07031234,$00d00000,$00c00000,$56781834
	.dc.l	$07031234,$00d003fe,$00c003fe,$56781834
	.dc.l	$07031234,$00d00400,$00c00000,$56788234
	.dc.l	$07031234,$00d007fe,$00c003fe,$56788234
	.dc.l	$07031234,$00d00800,$00c00400,$56781834
	.dc.l	$07031234,$00d00bfe,$00c007fe,$56781834
	.dc.l	$07031234,$00d00c00,$00c00400,$56788234
	.dc.l	$07031234,$00d00ffe,$00c007fe,$56788234
	.dc.l	$07031234,$00dff000,$00c7f800,$56781834
	.dc.l	$07031234,$00dff3fe,$00c7fbfe,$56781834
	.dc.l	$07031234,$00dff400,$00c7f800,$56788234
	.dc.l	$07031234,$00dff7fe,$00c7fbfe,$56788234
	.dc.l	$07031234,$00dff800,$00c7fc00,$56781834
	.dc.l	$07031234,$00dffbfe,$00c7fffe,$56781834
	.dc.l	$07031234,$00dffc00,$00c7fc00,$56788234
	.dc.l	$07031234,$00dffffe,$00c7fffe,$56788234
;
	.dc.l	-1


;--------------------------------------------------------------------------------
;test

	.text
	.even

test_start:
	clr.l	test_failed
	clr.l	test_tested
	rts

;<d1.b:memory mode
;<d2.b:access mode
;<d4.w:expected read data or written data
;<d5.w:expected vram content after access
;<d6.w:actual read data
;<d7.w:actual vram content after access
;?d0
test_check:
	addq.l	#1,test_tested
	cmp.w	d4,d6			;compare read data
	bne	21f
	cmp.w	d5,d7			;compare vram content after access
	beq	29f
21:
	addq.l	#1,test_failed
;expected
	print	9,'.dc.l',9
	move.b	d1,d0			;memory mode
	lsl.w	#8,d0
	move.b	d2,d0			;access mode
	swap.w	d0
	move.w	d3,d0			;vram content before access
	bsr	print_hex8
	putchar	#','
	move.l	a1,d0			;address
	bsr	print_hex8
	putchar	#','
	move.l	a2,d0			;even address in memory mode 3
	bsr	print_hex8
	putchar	#','
	move.w	d4,d0			;expected read data
	swap.w	d0
	move.w	d5,d0			;expected conten after access
	bsr	print_hex8
	print	9,';expected',13,10
;actual
	print	9,'.dc.l',9
	move.b	d1,d0			;memory mode
	lsl.w	#8,d0
	move.b	d2,d0			;access mode
	swap.w	d0
	move.w	d3,d0			;vram content before access
	bsr	print_hex8
	putchar	#','
	move.l	a1,d0			;address
	bsr	print_hex8
	putchar	#','
	move.l	a2,d0			;even address in memory mode 3
	bsr	print_hex8
	putchar	#','
	move.w	d6,d0			;actual read data
	swap.w	d0
	move.w	d7,d0			;actual conten after access
	bsr	print_hex8
	print	9,';actual',13,10
;
29:
	rts

test_end:
	movem.l	d0-d4,-(sp)
	move.l	test_failed,d2
;<d2.lfailed
	move.l	test_tested,d3
;<d3.l:tested
	move.l	d3,d4
	sub.l	d2,d4
;<d4.l:passed
	print	'tested:'
	move.l	d3,d0			;tested
	jbsr	print_dec
	tst.l	d3
	beq	38f			;no tests were performed
	print	', passed:'
	move.l	d4,d0			;passed
	jbsr	print_dec
	print	'('
	mulu.w	#10000,d0
	divu.w	d3,d0			;10000*passed/tested
	and.l	#$0000ffff,d0
	move.l	#10000,d4
	sub.w	d0,d4			;100-100*passed/tested
	moveq.l	#2,d1
	jbsr	print_fix
	print	'%), failed:'
	move.l	d2,d0			;failed
	jbsr	print_dec
	print	'('
	move.l	d4,d0			;100-100*passed/tested
	jbsr	print_fix
	print	'%)'
38:
	jbsr	print_crlf
	movem.l	(sp)+,d0-d4
	rts

	.bss

	.align	4
test_failed:
	.ds.l	1
test_tested:
	.ds.l	1


;--------------------------------------------------------------------------------
;print decimal number
;<d0.l:number

	.text
	.even

print_dec:
	movem.l	d0-d2/a0-a1,-(sp)
	lea.l	-12(sp),sp
	movea.l	sp,a0
	tst.l	d0
	bne	1f
	move.b	#'0',(a0)+
	bra	5f
1:
	lea.l	base_ten(pc),a1
2:
	move.l	(a1)+,d1
	cmp.l	d1,d0
	blo	2b
3:
	moveq.l	#'0'-1,d2
4:
	addq.b	#1,d2
	sub.l	d1,d0
	bcc	4b
	add.l	d1,d0
	move.b	d2,(a0)+
	move.l	(a1)+,d1
	bne	3b
5:
	suba.l	sp,a0
	move.l	a0,-(sp)
	pea.l	4(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	10+12(sp),sp
	movem.l	(sp)+,d0-d2/a0-a1
	rts


;--------------------------------------------------------------------------------
;print fixed point decimal number
;<d0.l:fixed point decimal number * 10^d1
;<d1.b:number of digits after decimal point (>=1)

	.text
	.even

print_fix:
	movem.l	d0-d4/a0-a1,-(sp)
	moveq.l	#0,d3
	move.b	d1,d3
;<d3.l:number of digits after decimal point (>=1)
	move.l	d3,d4
	addq.w	#3,d4
	and.w	#-4,d4		;round up to multiples of four
	add.w	#12,d4		;12 bytes for integer part and decimal point
;<d4.l:buffer size
	suba.l	d4,sp
;<sp.l:buffer
	movea.l	sp,a0
	tst.l	d0
	bne	20f
;zero
	move.b	#'0',(a0)+
	move.b	#'.',(a0)+
	move.w	d3,d2		;number of digits after decimal point (>=1)
	bra	12f

11:
	move.b	#'0',(a0)+
12:
	dbra	d2,11b
	bra	80f		;print

;non-zero
20:
	lea.l	base_ten(pc),a1
;zero suppression
21:
	move.l	(a1)+,d1
	cmp.l	d1,d0
	blo	21b
;convert to decimal number
22:
	moveq.l	#'0'-1,d2
23:
	addq.b	#1,d2
	sub.l	d1,d0
	bcc	23b
	add.l	d1,d0
	move.b	d2,(a0)+
	move.l	(a1)+,d1
	bne	22b
;
	move.l	a0,d2
	sub.l	sp,d2
;<d2.l:number of digits
	cmp.w	d3,d2
	bls	40f
;number of digits > number of digits after decimal point
;insert '.'
	move.w	d3,d2		;number of digits after decimal point (>=1)
	movea.l	a0,a1
	addq.l	#1,a0
	bra	32f

31:
	move.b	-(a1),1(a1)
32:
	dbra	d2,31b
	move.b	#'.',(a1)
	bra	80f

40:
;number of digits after decimal point >= number of digits
;insert '0.00...'
	move.w	d3,d0		;number of digits after decimal point (>=1)
	sub.w	d2,d0		;number of zeros after decimal point (>=0)
	movea.l	a0,a1
	lea.l	2(a0,d0.w),a0
	bra	42f

41:
	move.b	-(a1),2(a1,d0.w)
42:
	dbra	d2,41b
	movea.l	sp,a1
	move.b	#'0',(a1)+
	move.b	#'.',(a1)+
	bra	44f

43:
	move.b	#'0',(a1)+
44:
	dbra	d0,43b

;print
80:
	suba.l	sp,a0
	move.l	a0,-(sp)	;length
	pea.l	4(sp)		;buffer
	move.w	#1,-(sp)	;stdout
	DOS	_WRITE
	lea.l	10(sp),sp
	adda.l	d4,sp
	movem.l	(sp)+,d0-d4/a0-a1
	rts

base_ten:
	.dc.l	1000000000
	.dc.l	100000000
	.dc.l	10000000
	.dc.l	1000000
	.dc.l	100000
	.dc.l	10000
	.dc.l	1000
	.dc.l	100
	.dc.l	10
	.dc.l	1
	.dc.l	0


;--------------------------------------------------------------------------------
;print hexadecimal number
;<d0.l:number

	.text
	.even

print_hex8:
	movem.l	d0-d2/a0,-(sp)
	lea.l	-10(sp),sp
	movea.l	sp,a0
	move.b	#'$',(a0)+
	moveq.l	#8-1,d2
2:
	rol.l	#4,d0
	moveq.l	#15,d1
	and.w	d0,d1
	move.b	10f(pc,d1.w),(a0)+
	dbra	d2,2b
	pea.l	1+8.w
	pea.l	4(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	10+10(sp),sp
	movem.l	(sp)+,d0-d2/a0
	rts

10:
	.dc.b	'0123456789abcdef'


;--------------------------------------------------------------------------------
;print crlf

	.text
	.even

print_crlf:
	move.l	d0,-(sp)
	pea.l	2.w
	pea.l	10f(pc)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	10(sp),sp
	move.l	(sp)+,d0
	rts

10:
	.dc.b	13,10


;--------------------------------------------------------------------------------
;print character
;<4(sp).w:character

	.text
	.even

putchar_by_write:
	move.l	d0,-(sp)
	pea.l	1.w
	pea.l	12+1(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	10(sp),sp
	move.l	(sp)+,d0
	rts


;--------------------------------------------------------------------------------
;print string
;<4(sp).l:string

	.text
	.even

print_by_write:
	movem.l	d0/a0-a1,-(sp)
	movea.l	16(sp),a1
	movea.l	a1,a0
@@:
	tst.b	(a1)+
	bne	@b
	subq.l	#1,a1
	suba.l	a0,a1
	movem.l	a0-a1,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	10(sp),sp
	movem.l	(sp)+,d0/a0-a1
	rts


;--------------------------------------------------------------------------------
;end

	.end	main
