;----------------------------------------------------------------
;
;	SCSI
;
;----------------------------------------------------------------

	.include	t00iocs.equ
	.include	t02const.equ
	.include	t08debug.equ

;__DEBUG__	equ	1

	.cpu	68060

;----------------------------------------------------------------
;
;	IOCS _SCSIDRV
;
;----------------------------------------------------------------
;----------------------------------------------------------------
;IOCS _SCSIDRV
;	obt@DMA]łȂƂ(obt@̕AhX_AhX
;	قȂꍇѕAhX[JwĂꍇ)̓\tg
;	]ɕύXB
;	_S_REVISION̕ԋpl$000Aȏ̂Ƃ(SHARPgSCSI{[h,X68030
;	SCSI-BIOSMach-2SCSI-BIOS)SRAM̃\tg]tOg
;	\tg]ɕύXB
;	_S_REVISION̕ԋpl$000ÂƂ(SUPERXVICompact܂łX68000
;	SCSI-BIOS)͍x̓]R}h(_S_READ,_S_READEXTȂ)O
;	WJĒ჌x̃\tg]R}hpB
	.text
	.align	4,$2048
iocsScsidrv::
	tst.b	patchIocsScsi
	beq	scsicall
	cmp.l	#(scsidrvJumpTableEnd-scsidrvJumpTable)/4,d1
	bcc	scsicall
	jmp	([scsidrvJumpTable,pc,d1.l*4])

	.align	4,$2048
scsidrvJumpTable:
	.dc.l	scsicall		;$00 _S_RESET
	.dc.l	scsicall		;$01 _S_SELECT
	.dc.l	scsicall		;$02 _S_SELECTA
	.dc.l	scsicall		;$03 _S_CMDOUT
	.dc.l	scsidrvDatain		;$04 _S_DATAIN
	.dc.l	scsidrvDataout		;$05 _S_DATAOUT
	.dc.l	scsicall		;$06 _S_STSIN
	.dc.l	scsicall		;$07 _S_MSGIN
	.dc.l	scsicall		;$08 _S_MSGOUT
	.dc.l	scsicall		;$09 _S_PHASE
	.dc.l	scsicall		;$0A _S_REVISION
	.dc.l	scsicall		;$0B _S_DATAIN_P
	.dc.l	scsicall		;$0C _S_DATAOUT_P
	.dc.l	scsicall		;$0D _S_MSGOUTEXT
	.dc.l	scsicall		;$0E 
	.dc.l	scsicall		;$0F 
	.dc.l	scsicall		;$10 
	.dc.l	scsicall		;$11 
	.dc.l	scsicall		;$12 
	.dc.l	scsicall		;$13 
	.dc.l	scsicall		;$14 
	.dc.l	scsicall		;$15 
	.dc.l	scsicall		;$16 
	.dc.l	scsicall		;$17 
	.dc.l	scsicall		;$18 
	.dc.l	scsicall		;$19 
	.dc.l	scsicall		;$1A 
	.dc.l	scsicall		;$1B 
	.dc.l	scsicall		;$1C 
	.dc.l	scsicall		;$1D 
	.dc.l	scsicall		;$1E 
	.dc.l	scsicall		;$1F 
	.dc.l	scsidrvInquiry		;$20 _S_INQUIRY
	.dc.l	scsidrvRead		;$21 _S_READ
	.dc.l	scsidrvWrite		;$22 _S_WRITE
	.dc.l	scsicall		;$23 _S_FORMAT
	.dc.l	scsicall		;$24 _S_TESTUNIT
	.dc.l	scsidrvReadcap		;$25 _S_READCAP
	.dc.l	scsidrvReadext		;$26 _S_READEXT
	.dc.l	scsidrvWriteext		;$27 _S_WRITEEXT
	.dc.l	scsidrvVerifyext	;$28 _S_VERIFYEXT
	.dc.l	scsidrvModesense	;$29 _S_MODESENSE
	.dc.l	scsidrvModeselect	;$2A _S_MODESELECT
	.dc.l	scsicall		;$2B _S_REZEROUNIT
	.dc.l	scsidrvRequest		;$2C _S_REQUEST
	.dc.l	scsicall		;$2D _S_SEEK
	.dc.l	scsidrvReaddma		;$2E _S_READDMA
	.dc.l	scsicall		;$2F _S_STARTSTOP
	.dc.l	scsicall		;$30 _S_SEJECT
	.dc.l	scsidrvReassign		;$31 _S_REASSIGN
	.dc.l	scsicall		;$32 _S_PAMEDIUM
	.dc.l	scsicall		;$33 
	.dc.l	scsicall		;$34 
	.dc.l	scsicall		;$35 
	.dc.l	scsicall		;$36 _S_DSKINI
	.dc.l	scsicall		;$37 _S_FORMATB
	.dc.l	scsicall		;$38 _S_BADFMT
	.dc.l	scsicall		;$39 _S_ASSIGN
scsidrvJumpTableEnd:

;----------------------------------------------------------------
;_SCSIDRVĂяo
;	Mach-2ɂv^fB[荞݃xN^̕ύXubNB
;<d1.l:R}h
	.text
	.align	4,$2048
scsicall::
	move.l	PRNINT.w,-(sp)		;v^fB[荞݃xN^ۑ
	pea.l	(@f,pc)
	move.l	vectorOldIocsScsidrv,-(sp)
	rts
@@:	move.l	(sp)+,PRNINT.w		;v^fB[荞݃xN^𕜌
	rts

;----------------------------------------------------------------
;SRAM̃\tg]tOZbgԂŌ_SCSIDRVĂяo
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ł̂܂܌ĂяoB
;<d1.l:R}h
	.text
	.align	4,$2048
scsicallSoft::
	cmpi.w	#$000A,scsiRevisionCode
	blo	scsicall		;SRAM̃\tg]tOɑΉĂȂ
	btst.b	#4,$00ED0070
	bne	scsicall		;Ƀ\tg]ɂȂĂ
					;ȍ~͏I疳OFF̂ŐɊmF
	move.b	#$31,$00E8E00D
	bset.b	#4,$00ED0070		;\tg]ON
	move.b	#$00,$00E8E00D
	bsr	scsicall		;_SCSIDRVĂяo
	move.b	#$31,$00E8E00D
	bclr.b	#4,$00ED0070		;\tg]OFF
	move.b	#$00,$00E8E00D
	rts

;----------------------------------------------------------------
;obt@DMA]\ǂׂ(foCX烁֓])
;	ȉ̏̂ꂩ1łƂDMA]s
;		\tg]w肳Ă
;		obt@̕AhX_AhXƈقȂ
;		obt@̕AhX[JwĂ
;<d3.l:oCg
;<a1.l:obt@̐擪AhX
;>n-flag:mi=DMA]s,pl=DMA]\
	.text
	.align	4,$2048
scsiDmaCheckIn::
	tst.b	forceSoftScsi
	bmi	@f
	movem.l	d0-d2,-(sp)
	moveq.l	#0,d0			;foCX烁֓]
	move.l	a1,d1
	move.l	a1,d2
	add.l	d3,d2
	bsr	dmaAccessCheck
	movem.l	(sp)+,d0-d2
@@:	rts

;----------------------------------------------------------------
;obt@DMA]\ǂׂ(foCX֓])
;	ȉ̏̂ꂩ1łƂDMA]s
;		\tg]w肳Ă
;		obt@̕AhX_AhXƈقȂ
;		obt@̕AhX[JwĂ
;<d3.l:oCg
;<a1.l:obt@̐擪AhX
;>n-flag:mi=DMA]s,pl=DMA]\
	.text
	.align	4,$2048
scsiDmaCheckOut::
	tst.b	forceSoftScsi
	bmi	@f
	movem.l	d0-d2,-(sp)
	moveq.l	#1,d0			;foCX֓]
	move.l	a1,d1
	move.l	a1,d2
	add.l	d3,d2
	bsr	dmaAccessCheck
	movem.l	(sp)+,d0-d2
@@:	rts

;----------------------------------------------------------------
;_S_DATAIN
;	f[^CtF[Y̎s(DMA])
;	DMA]s̂Ƃ_S_DATAIN_PɕύX
;<d3.l:oCg
;<a1.l:obt@̐擪AhX
	.text
	.align	4,$2048
scsidrvDatain::
	bsr	scsiDmaCheckIn
	bpl	scsicall		;DMA]\Ȃ̂ł̂܂܎s
	move.l	d1,-(sp)
	moveq.l	#_S_DATAIN_P,d1		;DMA]sȂ̂_S_DATAIN_PɕύX
	bsr	scsicall
	move.l	(sp)+,d1
	rts

;----------------------------------------------------------------
;_S_DATAOUT
;	f[^AEgtF[Y̎s(DMA])
;	DMA]s̂Ƃ_S_DATAOUT_PɕύX
;<d3.l:oCg
;<a1.l:obt@̐擪AhX
	.text
	.align	4,$2048
scsidrvDataout::
	bsr	scsiDmaCheckOut
	bpl	scsicall		;DMA]\Ȃ̂ł̂܂܎s
	move.l	d1,-(sp)
	moveq.l	#_S_DATAOUT_P,d1	;DMA]sȂ̂_S_DATAOUT_PɕύX
	bsr	scsicall
	move.l	(sp)+,d1
	rts

;----------------------------------------------------------------
;_S_INQUIRY
;	SCSI-BIOS͖ȂMach-2DMA]gƂ̂Ńpb`Kv
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂDMA]gĂȂ̂ł̂܂܂ł悢
;<d3.l:oCg
;<d4.l:^[Qbg
;<a1.l:obt@̐擪AhX
	.text
	.align	4,$2048
scsidrvInquiry::
	bsr	scsiDmaCheckIn
	bpl	scsicall		;DMA]\
	bra	scsicallSoft

;----------------------------------------------------------------
;_S_READ
;	DMA]s̂Ƃ\tg]ɕύX
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ŎOœWJ
;<d2.l:ubNԍ($001FFFFF=2097151ȉ)
;<d3.l:ubN($0001=1`$0100=256)
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;>d0.l:
;	-1		G[
;	-2		G[(f[^CtF[YɂDMA])
;	ʃ[h	Xe[^XCtF[Y̌
;	ʃ[h	bZ[WCtF[Y̌
	.text
	.align	4,$2048
scsidrvRead::
	move.l	d3,-(sp)
	lsl.l	#8,d3
	lsl.l	d5,d3			;oCg
	bsr	scsiDmaCheckIn
	movem.l	(sp)+,d3		;tOۑ
	bpl	scsicall		;obt@DMA]\
	cmpi.w	#$000A,scsiRevisionCode
	bhs	scsicallSoft		;SRAM̃\tg]tOg
	movem.l	d1-d4/a1,-(sp)		;X^bN
	moveq.l	#_S_SELECT,d1		;ZNVtF[Y
	bsr	scsicall
	tst.l	d0
	beq	1f
	moveq.l	#_S_SELECT,d1		;gC
	bsr	scsicall
	tst.l	d0
	bne	8f
1:	lsl.l	#8,d3			;ubN<<8
	and.l	#$001FFFFF,d2		;ubNԍ
	and.l	#$00070000,d4		;LUN<<16
	lsl.l	#5,d4			;LUN<<21
	or.l	d4,d2			;(LUN<<21)|ubNԍ
	or.l	#$08000000,d2		;($08<<24)|(LUN<<21)|ubNԍ
	move.w	d3,-(sp)		;ubN 0(256̂Ƃ0 0)
	move.l	d2,-(sp)		;$08 LUN|ubNԍH M L
	movea.l	sp,a1
	moveq.l	#_S_CMDOUT,d1		;R}hAEgtF[Y
	bsr	scsicall
	addq.l	#6,sp
	tst.l	d0
	bne	8f
	lsl.l	d5,d3			;oCg
	movea.l	(4*4,sp),a1		;obt@̐擪AhX(X^bN)
	moveq.l	#_S_DATAIN_P,d1		;f[^CtF[Y
	bsr	scsicall
	cmp.l	#-1,d0			;f[^CtF[Y-1ԂƂ͑ss
	beq	9f
	move.l	d0,d2
	clr.l	-(sp)
	moveq.l	#_S_STSIN,d1		;Xe[^XCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	moveq.l	#_S_MSGIN,d1		;bZ[WCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	move.l	(sp)+,d0
	bne	9f
	cmp.l	#-2,d2			;f[^CtF[Y]̂Ƃ-2Ԃ
	bne	9f
	moveq.l	#-2,d0
9:	movem.l	(sp)+,d1-d4/a1
	rts

7:	addq.l	#4,sp
8:	moveq.l	#-1,d0
	bra	9b

;----------------------------------------------------------------
;_S_WRITE
;	DMA]s̂Ƃ\tg]ɕύX
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ŎOœWJ
;<d2.l:ubNԍ($001FFFFF=2097151ȉ)
;<d3.l:ubN($0001=1`$0100=256)
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;>d0.l:
;	-1		G[
;	-2		G[(f[^AEgtF[YɂDMA])
;	ʃ[h	Xe[^XCtF[Y̌
;	ʃ[h	bZ[WCtF[Y̌
	.text
	.align	4,$2048
scsidrvWrite::
	move.l	d3,-(sp)
	lsl.l	#8,d3
	lsl.l	d5,d3			;oCg
	bsr	scsiDmaCheckOut
	movem.l	(sp)+,d3		;tOۑ
	bpl	scsicall		;obt@DMA]\
	cmpi.w	#$000A,scsiRevisionCode
	bhs	scsicallSoft		;SRAM̃\tg]tOg
	movem.l	d1-d4/a1,-(sp)		;X^bN
	moveq.l	#_S_SELECT,d1		;ZNVtF[Y
	bsr	scsicall
	tst.l	d0
	beq	1f
	moveq.l	#_S_SELECT,d1		;gC
	bsr	scsicall
	tst.l	d0
	bne	8f
1:	lsl.l	#8,d3			;ubN<<8
	and.l	#$001FFFFF,d2		;ubNԍ
	and.l	#$00070000,d4		;LUN<<16
	lsl.l	#5,d4			;LUN<<21
	or.l	d4,d2			;(LUN<<21)|ubNԍ
	or.l	#$0A000000,d2		;($0A<<24)|(LUN<<21)|ubNԍ
	move.w	d3,-(sp)		;ubN 0(256̂Ƃ0 0)
	move.l	d2,-(sp)		;$0A LUN|ubNԍH M L
	movea.l	sp,a1
	moveq.l	#_S_CMDOUT,d1		;R}hAEgtF[Y
	bsr	scsicall
	addq.l	#6,sp
	tst.l	d0
	bne	8f
	lsl.l	d5,d3			;oCg
	movea.l	(4*4,sp),a1		;obt@̐擪AhX(X^bN)
	moveq.l	#_S_DATAOUT_P,d1	;f[^AEgtF[Y
	bsr	scsicall
	cmp.l	#-1,d0			;f[^AEgtF[Y-1ԂƂ͑ss
	beq	9f
	move.l	d0,d2
	clr.l	-(sp)
	moveq.l	#_S_STSIN,d1		;Xe[^XCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	moveq.l	#_S_MSGIN,d1		;bZ[WCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	move.l	(sp)+,d0
	bne	9f
	cmp.l	#-2,d2			;f[^AEgtF[Y]̂Ƃ-2Ԃ
	bne	9f
	moveq.l	#-2,d0
9:	movem.l	(sp)+,d1-d4/a1
	rts

7:	addq.l	#4,sp
8:	moveq.l	#-1,d0
	bra	9b

;----------------------------------------------------------------
;_S_READCAP
;	SCSI-BIOS͖ȂMach-2DMA]gƂ̂Ńpb`Kv
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂDMA]gĂȂ̂ł̂܂܂ł悢
;<d4.l:^[Qbg
;<a1.l:obt@̐擪AhX
	.text
	.align	4,$2048
scsidrvReadcap::
	move.l	d3,-(sp)
	moveq.l	#8,d3			;8oCgŒ
	bsr	scsiDmaCheckIn
	movem.l	(sp)+,d3		;ccrۑ
	bpl	scsicall		;DMA]\
	bra	scsicallSoft

;----------------------------------------------------------------
;_S_READEXT,_S_WRITEEXT,_S_VERIFYEXT̕[`
;	16MBȏ̃f[^𕪊B
;	_S_READEXT,_S_WRITEEXT,_S_VERIFYEXT̓ubN65535܂Ŏwł邪
;	ۂɂ16MBȏxɓ]邱ƂłȂBȂ킿ubÑTCY
;	512oCgȂ32767ubNƂȂĂB
;	̓\tgEFA̓sł͂ȂSPC̓]oCgJE^24rbg
;	Ȃ߁B
;<d2.l:ubNԍ
;<d3.l:ubN
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;<(4,sp).l:][`̃AhX
;<(8,sp).l:AAhX
	.text
	.align	4,$2048
scsiCommandSplitter::
	movem.l	d1-d5/a1,-(sp)
	lsl.l	d5,d3			;oCg>>8
	cmp.l	#$00FFFFFF>>8,d3	;TCY΂̂܂ܓ]s
	bls	9f
	lsr.l	d5,d3			;ubN
	movem.l	d2-d3/a1,-(sp)
;<(sp):̃ubNԍ
;<(4,sp):̎cubN
;<(8,sp):̃obt@̐擪AhX
1:	movem.l	(12+12,sp),d4-d5	;X^bN
	move.l	#$00FFFFFF>>8,d3
	lsr.l	d5,d3			;̃ubN
	sub.l	d3,(4,sp)		;̎cubN
	bpl	2f
	add.l	(4,sp),d3		;Ō̃ubN
	clr.l	(4,sp)			;cȂ
2:	move.l	(sp),d2			;̃ubNԍ
	add.l	d3,(sp)			;̃ubNԍ
	movea.l	(8,sp),a1		;̃obt@̐擪AhX
	lsl.l	#8,d3
	lsl.l	d5,d3
	add.l	d3,(8,sp)		;̃obt@̐擪AhX
	lsr.l	#8,d3
	lsr.l	d5,d3
;<d2.l:̃ubNԍ
;<d3.l:̃ubN
;<a1.l:̃obt@̐擪AhX
;<(sp).l:̃ubNԍ
;<(4,sp).l:̎cubN
;<(8,sp).l:̃obt@̐擪AhX
  debug 'splitted(d2,d3,d4,d5,a1)=',5,d2,d3,d4,d5,a1
	jsr	([12+24,sp])		;]s,X^bN
	tst.l	d0
	bne	3f			;G[I
	tst.l	(4,sp)			;c]ubN
	bne	1b			;c肠
3:	lea.l	(12,sp),sp
	movem.l	(sp)+,d1-d5/a1
	addq.l	#4,sp			;][`XLbv
					;WX^𕜌邽ߍŌ܂Ń[v̒ōs
	rts

9:	movem.l	(sp)+,d1-d5/a1
	rts

;----------------------------------------------------------------
;_S_READEXT
;	DMA]s̂Ƃ\tg]ɕύX
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ŎOœWJ
;<d2.l:ubNԍ
;<d3.l:ubN($0000=0`$FFFF=65535)
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;>d0.l:
;	-1		G[
;	-2		G[(f[^CtF[YɂDMA])
;	ʃ[h	Xe[^XCtF[Y̌
;	ʃ[h	bZ[WCtF[Y̌
	.text
	.align	4,$2048
scsidrvReadext::
	bsr	scsiCommandSplitter	;
;[`ɂĈȍ~͕̏ɕčs邱Ƃ
	move.l	d3,-(sp)
	lsl.l	#8,d3
	lsl.l	d5,d3			;oCg
	bsr	scsiDmaCheckIn
	movem.l	(sp)+,d3		;ccrۑ
	bpl	scsicall		;obt@DMA]\
	cmpi.w	#$000A,scsiRevisionCode
	bhs	scsicallSoft		;SRAM̃\tg]tOg
	movem.l	d1-d4/a1,-(sp)		;X^bN
	and.l	#$0000FFFF,d3
	beq	8f
	moveq.l	#_S_SELECT,d1		;ZNVtF[Y
	bsr	scsicall
	tst.l	d0
	beq	1f
	moveq.l	#_S_SELECT,d1		;gC
	bsr	scsicall
	tst.l	d0
	bne	8f
1:	lsl.l	#8,d3			;ubN<<8
	swap.w	d4
	and.w	#$0007,d4		;LUN
	lsl.w	#5,d4			;LUN<<5
	or.w	#$2800,d4		;($28<<8)|(LUN<<5)
	move.l	d3,-(sp)		;0 ubNH L 0
	move.l	d2,-(sp)		;ubNԍHH HL LH LL
	move.w	d4,-(sp)		;($28<<8)|(LUN<<5)
	movea.l	sp,a1
	moveq.l	#_S_CMDOUT,d1		;R}hAEgtF[Y
	bsr	scsicall
	lea.l	(10,sp),sp
	tst.l	d0
	bne	8f
	lsl.l	d5,d3			;oCg
	movea.l	(4*4,sp),a1		;obt@̐擪AhX(X^bN)
	moveq.l	#_S_DATAIN_P,d1		;f[^CtF[Y
	bsr	scsicall
	cmp.l	#-1,d0			;f[^CtF[Y-1ԂƂ͑ss
	beq	9f
	move.l	d0,d2
	clr.l	-(sp)
	moveq.l	#_S_STSIN,d1		;Xe[^XCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	moveq.l	#_S_MSGIN,d1		;bZ[WCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	move.l	(sp)+,d0
	bne	9f
	cmp.l	#-2,d2			;f[^CtF[Y]̂Ƃ-2Ԃ
	bne	9f
	moveq.l	#-2,d0
9:	movem.l	(sp)+,d1-d4/a1
	rts

7:	addq.l	#4,sp
8:	moveq.l	#-1,d0
	bra	9b

;----------------------------------------------------------------
;_S_WRITEEXT
;	DMA]s̂Ƃ\tg]ɕύX
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ŎOœWJ
;<d2.l:ubNԍ
;<d3.l:ubN($0000=0`$FFFF=65535)
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;>d0.l:
;	-1		G[
;	-2		G[(f[^AEgtF[YɂDMA])
;	ʃ[h	Xe[^XCtF[Y̌
;	ʃ[h	bZ[WCtF[Y̌
	.text
	.align	4,$2048
scsidrvWriteext::
	bsr	scsiCommandSplitter	;
;[`ɂĈȍ~͕̏ɕčs邱Ƃ
	move.l	d3,-(sp)
	lsl.l	#8,d3
	lsl.l	d5,d3			;oCg
	bsr	scsiDmaCheckOut
	movem.l	(sp)+,d3		;ccrۑ
	bpl	scsicall		;obt@DMA]\
	cmpi.w	#$000A,scsiRevisionCode
	bhs	scsicallSoft		;SRAM̃\tg]tOg
	movem.l	d1-d4/a1,-(sp)		;X^bN
	and.l	#$0000FFFF,d3
	beq	8f
	moveq.l	#_S_SELECT,d1		;ZNVtF[Y
	bsr	scsicall
	tst.l	d0
	beq	1f
	moveq.l	#_S_SELECT,d1		;gC
	bsr	scsicall
	tst.l	d0
	bne	8f
1:	lsl.l	#8,d3			;ubN<<8
	swap.w	d4
	and.w	#$0007,d4		;LUN
	lsl.w	#5,d4			;LUN<<5
	or.w	#$2A00,d4		;($2A<<8)|(LUN<<5)
	move.l	d3,-(sp)		;0 ubNH L 0
	move.l	d2,-(sp)		;ubNԍHH HL LH LL
	move.w	d4,-(sp)		;($2A<<8)|(LUN<<5)
	movea.l	sp,a1
	moveq.l	#_S_CMDOUT,d1		;R}hAEgtF[Y
	bsr	scsicall
	lea.l	(10,sp),sp
	tst.l	d0
	bne	8f
	lsl.l	d5,d3			;oCg
	movea.l	(4*4,sp),a1		;obt@̐擪AhX(X^bN)
	moveq.l	#_S_DATAOUT_P,d1	;f[^AEgtF[Y
	bsr	scsicall
	cmp.l	#-1,d0			;f[^AEgtF[Y-1ԂƂ͑ss
	beq	9f
	move.l	d0,d2
	clr.l	-(sp)
	moveq.l	#_S_STSIN,d1		;Xe[^XCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	moveq.l	#_S_MSGIN,d1		;bZ[WCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	move.l	(sp)+,d0
	bne	9f
	cmp.l	#-2,d2			;f[^AEgtF[Y]̂Ƃ-2Ԃ
	bne	9f
	moveq.l	#-2,d0
9:	movem.l	(sp)+,d1-d4/a1
	rts

7:	addq.l	#4,sp
8:	moveq.l	#-1,d0
	bra	9b

;----------------------------------------------------------------
;_S_VERIFYEXT
;	DMA]s̂Ƃ\tg]ɕύX
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ŎOœWJ
;<d2.l:ubNԍ
;<d3.l:ubN($0000=0`$FFFF=65535)
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;>d0.l:
;	-1		G[
;	-2		G[(f[^AEgtF[YɂDMA])
;	ʃ[h	Xe[^XCtF[Y̌
;	ʃ[h	bZ[WCtF[Y̌
	.text
	.align	4,$2048
scsidrvVerifyext::
	bsr	scsiCommandSplitter	;
;[`ɂĈȍ~͕̏ɕčs邱Ƃ
	move.l	d3,-(sp)
	lsl.l	#8,d3
	lsl.l	d5,d3			;oCg
	bsr	scsiDmaCheckOut
	movem.l	(sp)+,d3		;ccrۑ
	bpl	scsicall		;obt@DMA]\
	cmpi.w	#$000A,scsiRevisionCode
	bhs	scsicallSoft		;SRAM̃\tg]tOg
	movem.l	d1-d4/a1,-(sp)		;X^bN
	and.l	#$0000FFFF,d3
	beq	8f
	moveq.l	#_S_SELECT,d1		;ZNVtF[Y
	bsr	scsicall
	tst.l	d0
	beq	1f
	moveq.l	#_S_SELECT,d1		;gC
	bsr	scsicall
	tst.l	d0
	bne	8f
1:	lsl.l	#8,d3			;ubN<<8
	swap.w	d4
	and.w	#$0007,d4		;LUN
	lsl.w	#5,d4			;LUN<<5
	or.w	#$2F00,d4		;($2F<<8)|(LUN<<5)
	move.l	d3,-(sp)		;0 ubNH L 0
	move.l	d2,-(sp)		;ubNԍHH HL LH LL
	move.w	d4,-(sp)		;($2F<<8)|(LUN<<5)
	movea.l	sp,a1
	moveq.l	#_S_CMDOUT,d1		;R}hAEgtF[Y
	bsr	scsicall
	lea.l	(10,sp),sp
	tst.l	d0
	bne	8f
	lsl.l	d5,d3			;oCg
	movea.l	(4*4,sp),a1		;obt@̐擪AhX(X^bN)
	moveq.l	#_S_DATAOUT_P,d1	;f[^AEgtF[Y
	bsr	scsicall
	cmp.l	#-1,d0			;f[^AEgtF[Y-1ԂƂ͑ss
	beq	9f
	move.l	d0,d2
	clr.l	-(sp)
	moveq.l	#_S_STSIN,d1		;Xe[^XCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	moveq.l	#_S_MSGIN,d1		;bZ[WCtF[Y
	lea.l	(1,sp),a1
	bsr	scsicall
	tst.l	d0
	bne	7f
	move.l	(sp)+,d0
	bne	9f
	cmp.l	#-2,d2			;f[^AEgtF[Y]̂Ƃ-2Ԃ
	bne	9f
	moveq.l	#-2,d0
9:	movem.l	(sp)+,d1-d4/a1
	rts

7:	addq.l	#4,sp
8:	moveq.l	#-1,d0
	bra	9b

;----------------------------------------------------------------
;_S_MODESENSE
;	SCSI-BIOS͖ȂMach-2DMA]gƂ̂Ńpb`Kv
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂDMA]gĂȂ̂ł̂܂܂ł悢
;<d2.l:bit0-5=y[WR[h
;	bit6-7=y[WRg[(0=Jg,1=ύX\,2=ftHg,3=Z[u)
;<d3.l:oCg($00=0`$FF=255)
;<d4.l:^[Qbg
;<a1.l:obt@̐擪AhX
scsidrvModesense	equ	scsidrvInquiry

;----------------------------------------------------------------
;_S_MODESELECT
;	SCSI-BIOS͖ȂMach-2DMA]gƂ̂Ńpb`Kv
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂDMA]gĂȂ̂ł̂܂܂ł悢
;<d2.l:bit0=SP(0=ۑȂ,1=ۑ),bit4=PF(0=SCSI-1,1=SCSI-2)
;<d3.l:oCg($00=0`$FF=255)
;<d4.l:^[Qbg
;<a1.l:obt@̐擪AhX
	.text
	.align	4,$2048
scsidrvModeselect::
	bsr	scsiDmaCheckOut
	bpl	scsicall		;DMA]\
	bra	scsicallSoft

;----------------------------------------------------------------
;_S_REQUEST
;	SCSI-BIOS͖ȂMach-2DMA]gƂ̂Ńpb`Kv
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂDMA]gĂȂ̂ł̂܂܂ł悢
;<d3.l:oCg($00=0`$FF=255,0̂Ƃ̋SCSI-1SCSI-2ňقȂ)
;<d4.l:^[Qbg
;<a1.l:obt@̐擪AhX
scsidrvRequest	equ	scsidrvInquiry

;----------------------------------------------------------------
;_S_REASSIGN
;	SCSI-BIOS͖ȂMach-2DMA]gƂ̂Ńpb`Kv
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂDMA]gĂȂ̂ł̂܂܂ł悢
;<d3.l:oCg($00=0`$FF=255)
;<d4.l:^[Qbg
;<a1.l:obt@̐擪AhX
scsidrvReassign	equ	scsidrvModeselect

;----------------------------------------------------------------
;_S_READDMA
;	DMA]s̂Ƃ\tg]ɕύX
;	SUPERXVICompact܂łX68000̓SCSI-BIOSSRAM̃\tg]tO
;	ΉĂȂ̂ŎOœWJ
;<d2.l:ubNԍ($001FFFFF=2097151ȉ)
;<d3.l:ubN($0001=1`$0100=256)
;<d4.l:^[Qbg
;<d5.l:ubÑTCY(0=256,1=512,2=1024)
;<a1.l:obt@̐擪AhX
;>d0.l:
;	-1		G[
;	-2		G[(f[^CtF[YɂDMA])
;	ʃ[h	Xe[^XCtF[Y̌
;	ʃ[h	bZ[WCtF[Y̌
scsidrvReaddma	equ	scsidrvRead



;----------------------------------------------------------------
;
;	IOCS _PRNINTST(Mach-2΍)
;
;----------------------------------------------------------------
;----------------------------------------------------------------
;IOCS _PRNINTST
;	SCSIC^tFCXMB89352̃ZbgRfBV荞݂Ȃ
;	$6Cł͂Ȃ$63œĂ邱ƂAMach-2ƓSCSI|[gqԂ
;	SCSIoXZbgƔтoĂ܂BŁAMach-2SCSI-BIOS
;	SCSIoXZbg̍ۂɃv^fB[荞݃xN^ύXĔтoȂ
;	悤ɍ׍HĂBύXꂽxN^$63EAxxxxƂȂāÂ悤ȃR[h
;	wB
;		move.b	$00E96029,$00E96029	;13F9 00E9 6029 00E9 6029
;		rte				;4E73
;	̃R[h͓SCSIC^tFCXMB89352INTS(Interrupt Sense)WX^
;	NAĂ邾ŁASCSI-BIOSSCSI荞݃[`ƓłB
;
;	X68030ROM̓v^fB[荞݃xN^̎gpԂŏʃoCg0
;	ǂŔʂ̂ŁAꂽxN^𖢎gpƔFBA
;	060turboROMł͊荞݃[`nC̈ɔzuł悤ɂ邽߂
;	xN^̎gpԂ32rbgŜŃ`FbN悤ɕύXĂ邽߁A
;	ꂽxN^gpƔFĂ܂B̌ʁA060turboMach-2
;	pƃv^fB[荞݃xN^ύXłȂȂATeXVXe
;	print.xȂǂ삵ȂȂB
;
;	$63̓nC̃AhX̍ŏʃoCgƈvȂ̂ŁAxN^̍ŏʃoCg
;	$63ǂŎgpԂ𔻕ʂ悤ɕύX邱ƂMath-2𕹗pꍇ
;	_PRNINTST@\ȂȂB
;	ꂾł͊Ƀv^fB[荞݂gpĂԂSCSIoXZbg
;	sƃv^fB[荞݃xN^j󂳂Ă܂A_SCSIDRV
;	őΏB
;
;<a1.l:v^̃fB[荞ݏ[`̃AhX(0=)
;>d0.l:
;	0	I
;	̑	gpȂ̂ŐݒłȂ(݂̏[`̃AhX)
	.text
	.align	4,$2048
iocsPrnintst::
	move.l	a0,-(sp)
	move.w	sr,-(sp)
	ori.w	#$0700,sr		;荞݋֎~
	moveq.l	#PRNINT>>2,d0
	lea.l	PRNINT.w,a0
	cmpa.w	#0,a1			;tst.l a1
	beq	1f			;
	cmp.b	(a0),d0			;ŏʃoCgr
	bne	2f			;gpȂ̂ŐݒłȂ
;gpȂ̂Őݒ肷
	move.l	a1,(a0)			;ݒ肷
	bset.b	#0,$00E9C001		;v^荞݋
8:	moveq.l	#0,d0
9:	move.w	(sp)+,sr
	movea.l	(sp)+,a0
	rts

;
1:	bclr.b	#0,$00E9C001		;v^荞݋֎~
	move.l	#((PRNINT>>2)<<24)+defaultPrnint,(a0)	;
	bra	8b

;gpȂ̂ŐݒłȂ
2:	move.l	(a0),d0			;擾
	bra	9b

;----------------------------------------------------------------
;ftHg̃v^fB[荞ݏ[`
;	$00xxxxxx̃AhXɔzu$63000000xN^ݒ肷
	.text
	.align	4,$2048
defaultPrnint::
	rte				;Ȃ

;тoƂ
;	moveq.l	#$63,d7			;xN^ԍ
;	movea.l	sp,a6
;	trap	#14
;@@:	IOCS	_ABORTJOB
;	bra	@b
