/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import xeij.ByteArray;
import xeij.HDC;
import xeij.HumanMedia;
import xeij.Multilingual;
import xeij.XEiJ;

public class HDMedia
extends HumanMedia {
    public static final HDMedia[] HDM_ARRAY = new HDMedia[]{new HDMedia(0, "SASI HDD (10MB)", 256, 33, 40783, 40788, 44880), new HDMedia(1, "SASI HDD (20MB)", 256, 33, 81033, 81048, 87648), new HDMedia(2, "SASI HDD (40MB)", 256, 33, 162073, 162096, 175296)};
    public static final HDMedia HDM_10MB = HDM_ARRAY[0];
    public static final HDMedia HDM_20MB = HDM_ARRAY[1];
    public static final HDMedia HDM_40MB = HDM_ARRAY[2];
    public static final int HDM_MAX_BYTES_PER_DISK = (int)HDMedia.HDM_40MB.humDiskEndByte;
    public int hdmNumber;
    public String hdmName;
    public int hdmBytesShiftRecord;
    public int hdmBytesPerRecord;
    public int hdmPartitionStartRecord;
    public int hdmPartitionEndRecord;
    public int hdmDiskEndRecord;
    public int hdmRampRecord;

    public static HDMedia hdmLengthToMedia(long l) {
        for (HDMedia hDMedia : HDM_ARRAY) {
            if (hDMedia.humDiskEndByte != l) continue;
            return hDMedia;
        }
        return null;
    }

    public static HDMedia hdmPathToMedia(String string, byte[] byArray) {
        byte[] byArray2 = XEiJ.rscGetFile(string, new int[0]);
        if (byArray2 == null) {
            return null;
        }
        HDMedia hDMedia = HDMedia.hdmLengthToMedia(byArray2.length);
        if (hDMedia == null) {
            System.out.println(Multilingual.mlnJapanese ? string + " \u306f SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093" : string + " is not a SASI hard disk image file");
            return null;
        }
        System.out.println(Multilingual.mlnJapanese ? string + " \u306f " + hDMedia.hdmName + " \u3067\u3059" : string + " is " + hDMedia.hdmName);
        if (byArray != null) {
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        return hDMedia;
    }

    public HDMedia(int n, String string, int n2, int n3, int n4, int n5, int n6) {
        super(1024, -1, 2, 1, 512, 248, 248, -1, (long)n2 * (long)n5, (long)n2 * (long)n3, (long)n2 * (long)n4);
        this.hdmNumber = n;
        this.hdmName = string;
        this.hdmBytesPerRecord = n2;
        this.hdmPartitionStartRecord = n3;
        this.hdmPartitionEndRecord = n4;
        this.hdmDiskEndRecord = n5;
        this.hdmRampRecord = n6;
        this.hdmBytesShiftRecord = Integer.numberOfTrailingZeros(this.hdmBytesPerRecord);
    }

    public boolean hdmMakeFormatData(byte[] byArray, boolean bl) {
        Arrays.fill(byArray, (byte)0);
        System.arraycopy(HDC.HDC_DISK_IPL, 0, byArray, 0, HDC.HDC_DISK_IPL.length);
        ByteArray.byaWl(byArray, 1024, 1479948363);
        ByteArray.byaWl(byArray, 1028, this.hdmDiskEndRecord);
        ByteArray.byaWl(byArray, 1032, this.hdmDiskEndRecord);
        ByteArray.byaWl(byArray, 1036, this.hdmRampRecord);
        ByteArray.byaWl(byArray, 1040, 1215655265);
        ByteArray.byaWl(byArray, 1044, 1849047147);
        ByteArray.byaWl(byArray, 1048, this.hdmPartitionStartRecord);
        ByteArray.byaWl(byArray, 1052, this.hdmPartitionEndRecord - this.hdmPartitionStartRecord);
        System.arraycopy(HDC.HDC_PARTITION_IPL, 0, byArray, 8448, HDC.HDC_PARTITION_IPL.length);
        ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 18, this.humBytesPerSector);
        ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 20, this.humSectorsPerCluster);
        ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 21, this.humFatCount);
        ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 22, this.humReservedSectors);
        ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 24, this.humRootEntries);
        ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 26, this.humPartitionSectors);
        ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 28, this.humFatID);
        ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 29, this.humFatSectors);
        ByteArray.byaWl(byArray, (int)this.humPartitionStartByte + 30, this.hdmPartitionStartRecord);
        this.humWriteFatMarker(byArray);
        return !bl || this.humCopyHumanSys(byArray) && this.humCopyCommandX(byArray);
    }
}

