/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.filechooser.FileFilter;
import xeij.AbstractOpenDialog;
import xeij.AbstractUnit;
import xeij.ComponentFactory;
import xeij.HD63450;
import xeij.HDMedia;
import xeij.IOInterrupt;
import xeij.JFileChooser2;
import xeij.Multilingual;
import xeij.Settings;
import xeij.XEiJ;

public class HDC {
    public static final boolean HDC_DEBUG_TRACE = false;
    public static final boolean HDC_DEBUG_COMMAND = false;
    public static final boolean HDC_DEBUG_UNIMPLEMENTED_COMMAND = true;
    public static final int HDC_BASE = 15294464;
    public static final int HDC_DATA_PORT = 15294465;
    public static final int HDC_STATUS_PORT = 15294467;
    public static final int HDC_RESET_PORT = 15294469;
    public static final int HDC_SELECTION_PORT = 15294471;
    public static final int HDC_STATUS_MESSAGE = 16;
    public static final int HDC_STATUS_C_D = 8;
    public static final int HDC_STATUS_COMMAND = 8;
    public static final int HDC_STATUS_DATA = 0;
    public static final int HDC_STATUS_I_O = 4;
    public static final int HDC_STATUS_OUTPUT = 0;
    public static final int HDC_STATUS_INPUT = 4;
    public static final int HDC_STATUS_BUSY = 2;
    public static final int HDC_STATUS_FREE = 0;
    public static final int HDC_STATUS_REQUEST = 1;
    public static final String[] HDC_COMMAND_NAME = "TestDriveReady,Recalibrate,,RequestSenseStatus,FormatDrive,CheckTrackFormat,FormatBlock,BadTrackFormat,Read,,Write,Seek,InitializeDriveCharacteristic,LastCorrectedBurstLength,AssignTrack,WriteSectorBuffer,ReadSectorBuffer,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,AssignDrive,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,".split(",", 256);
    public static JMenu hdcMenu;
    public static FileFilter hdcFileFilter;
    public static OpenDialog hdcOpenDialog;
    public static int hdcOpenUnit;
    public static ArrayList<File[]> hdcOpenHistory;
    public static JDialog hdcFormatDialog;
    public static JFileChooser2 hdcFormatFileChooser;
    public static HDMedia hdcFormatMedia;
    public static boolean hdcFormatCopySystemFiles;
    public static final HDUnit[] hdcUnitArray;
    public static int hdcHDMax;
    public static int hdcSelectedID;
    public static int hdcSelectedLUN;
    public static HDUnit hdcTargetUnit;
    public static int hdcBusStatus;
    public static byte[] hdcReadHandle;
    public static byte[] hdcWriteHandle;
    public static int hdcIndex;
    public static int hdcLimit;
    public static final byte[] hdcCommandBuffer;
    public static final byte[] hdcStatusBuffer;
    public static final byte[] hdcMessageBuffer;
    public static final byte[] hdcSenseBuffer;
    public static final byte[] hdcAssignDriveBuffer;
    public static int hdcLastFormatBlodkEnd;
    public static JCheckBoxMenuItem hdcSASIMenuItem;
    public static final byte[] HDC_DISK_IPL;
    public static final byte[] HDC_PARTITION_IPL;

    public static void hdcInit() {
        int n;
        hdcFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (!file.isFile()) {
                    return false;
                }
                String string = file.getPath();
                if (HDC.hdcIsInserted(string)) {
                    return false;
                }
                long l = file.length();
                for (HDMedia hDMedia : HDMedia.HDM_ARRAY) {
                    if (hDMedia.humDiskEndByte != l) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb (*.HDF)" : "SASI hard disk image files (*.HDF)";
            }
        };
        hdcOpenDialog = null;
        hdcOpenUnit = 0;
        hdcOpenHistory = new ArrayList();
        for (n = 99; 0 <= n; --n) {
            HDC.hdcAddHistory(JFileChooser2.pathsToFiles(Settings.sgsGetString("sahistory" + n)));
        }
        hdcHDMax = 0;
        for (n = 0; n < 16; ++n) {
            int n2;
            HDUnit hDUnit = HDC.hdcUnitArray[n] = new HDUnit(n);
            if (n == 0) {
                hDUnit.connect(false);
            }
            String string = Settings.sgsGetString("sa" + n);
            String string2 = Settings.sgsGetString("hd" + n);
            if (!string2.equals("") && !string2.equals("none")) {
                String string3;
                String string4 = string2.endsWith(":R") || string2.endsWith(":r") ? string2.substring(0, string2.length() - 2) : string2;
                n2 = string4.lastIndexOf(46);
                String string5 = string3 = n2 < 0 ? "" : string4.substring(n2 + 1);
                if (string3.equalsIgnoreCase("HDF") || HDMedia.hdmPathToMedia(string4, null) != null) {
                    string = string2;
                    Settings.sgsPutString("hd" + n, "");
                }
            }
            boolean bl = false;
            if (string.toUpperCase().endsWith(":R")) {
                string = string.substring(0, string.length() - 2);
                bl = true;
            }
            int n3 = n2 = !new File(string).canWrite() ? 1 : 0;
            if (string.length() == 0) continue;
            hDUnit.connect(true);
            if (!hDUnit.insert(string, bl || n2 != 0)) continue;
            HDC.hdcAddHistory(new File(string).getAbsoluteFile());
        }
        hdcFormatDialog = null;
        hdcFormatFileChooser = null;
        hdcFormatMedia = HDMedia.HDM_40MB;
        hdcFormatCopySystemFiles = true;
        hdcSelectedID = -1;
        hdcSelectedLUN = -1;
        hdcTargetUnit = null;
        hdcBusStatus = 0;
        hdcReadHandle = null;
        hdcWriteHandle = null;
        hdcIndex = 0;
        hdcLimit = 0;
        hdcLastFormatBlodkEnd = -1;
    }

    public static void hdcTini() {
        for (HDUnit hDUnit : hdcUnitArray) {
            hDUnit.hduTini();
        }
        if (hdcOpenDialog != null) {
            int n;
            Settings.sgsPutOnOff("sareadonly", hdcOpenDialog.getReadOnly());
            Settings.sgsPutOnOff("saappreboot", hdcOpenDialog.getReboot());
            ArrayList<String> arrayList = hdcOpenDialog.getHistory();
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                Settings.sgsPutString("sahistory" + n, (String)arrayList.get(n));
            }
            for (n = n2; n < 16; ++n) {
                Settings.sgsPutString("sahistory" + n, "");
            }
        }
        for (int i = 0; i < 16; ++i) {
            HDUnit hDUnit = hdcUnitArray[i];
            Settings.sgsPutString("sa" + i, (String)(hDUnit.abuConnected && hDUnit.abuInserted ? (hDUnit.abuWriteProtected ? hDUnit.abuPath + ":R" : hDUnit.abuPath) : ""));
        }
    }

    public static void hdcMakeMenu() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Create new SASI hard disk image files": {
                        HDC.hdcOpenFormatDialog();
                    }
                }
            }
        };
        hdcMenu = ComponentFactory.createMenu("SASI", new JComponent[0]);
        ComponentFactory.addComponents(hdcMenu, ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("SASI hard disk"), "ja", "SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af")), ComponentFactory.createHorizontalSeparator());
        for (int i = 0; i < 16; ++i) {
            hdcMenu.add(hdcUnitArray[i].getMenuBox());
        }
        Component[] componentArray = new Component[4];
        componentArray[0] = ComponentFactory.createHorizontalSeparator();
        hdcSASIMenuItem = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(!XEiJ.currentModel.isSCSI(), "Built-in SASI port", actionListener), "ja", "\u5185\u8535 SASI \u30dd\u30fc\u30c8"), false);
        componentArray[1] = hdcSASIMenuItem;
        componentArray[2] = ComponentFactory.createHorizontalSeparator();
        componentArray[3] = Multilingual.mlnText(ComponentFactory.createMenuItem("Create new SASI hard disk image files", actionListener), "ja", "SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210");
        ComponentFactory.addComponents(hdcMenu, componentArray);
    }

    public static boolean hdcIsInserted(String string) {
        for (HDUnit hDUnit : hdcUnitArray) {
            if (hDUnit == null || !hDUnit.abuConnected || !hDUnit.abuInserted || !hDUnit.abuPath.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void hdcOpenFiles(File[] fileArray, boolean bl) {
        boolean bl2 = true;
        int n = hdcOpenUnit;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file;
            if (16 <= n) {
                bl2 = false;
                break;
            }
            HDUnit hDUnit = hdcUnitArray[n];
            if (!hDUnit.abuConnected) {
                ++n;
                continue;
            }
            if (!(file = fileArray[n2++]).isFile()) {
                bl2 = false;
                continue;
            }
            if (!hDUnit.insert(file.getPath(), hdcOpenDialog.getReadOnly() || !file.canWrite())) {
                bl2 = false;
                continue;
            }
            ++n;
        }
        if (bl2) {
            HDC.hdcAddHistory(fileArray);
            if (bl) {
                XEiJ.mpuReset(0x8000 | hdcOpenUnit << 8, -1);
            }
        }
    }

    public static void hdcMakeFormatDialog() {
        ActionListener actionListener = new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (actionEvent.getActionCommand()) {
                    case "ApproveSelection": 
                    case "Start formatting": {
                        File[] fileArray = hdcFormatFileChooser.getSelectedFiles();
                        if (fileArray.length <= 0) return;
                        hdcFormatDialog.setVisible(false);
                        if (HDC.hdcFormatFiles(fileArray)) return;
                    }
                    case "CancelSelection": 
                    case "Cancel": {
                        hdcFormatDialog.setVisible(false);
                        return;
                    }
                    case "10MB": {
                        hdcFormatMedia = HDMedia.HDM_10MB;
                        return;
                    }
                    case "20MB": {
                        hdcFormatMedia = HDMedia.HDM_20MB;
                        return;
                    }
                    case "40MB": {
                        hdcFormatMedia = HDMedia.HDM_40MB;
                        return;
                    }
                    case "Copy system files": {
                        hdcFormatCopySystemFiles = ((JCheckBox)actionEvent.getSource()).isSelected();
                    }
                }
            }
        };
        HDC.hdcMakeFormatFileChooser();
        hdcFormatFileChooser.setFileFilter(hdcFileFilter);
        hdcFormatFileChooser.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        hdcFormatDialog = Multilingual.mlnTitle(ComponentFactory.createModalDialog(XEiJ.frmFrame, "Create new SASI hard disk image files", ComponentFactory.createBorderPanel(0, 0, ComponentFactory.createVerticalBox(hdcFormatFileChooser, ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(12), Box.createHorizontalGlue(), ComponentFactory.createRadioButtonMenuItem(buttonGroup, hdcFormatMedia == HDMedia.HDM_10MB, "10MB", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup, hdcFormatMedia == HDMedia.HDM_20MB, "20MB", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup, hdcFormatMedia == HDMedia.HDM_40MB, "40MB", actionListener), Box.createHorizontalGlue(), Box.createHorizontalStrut(12)), Box.createVerticalStrut(12), ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(12), Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createCheckBox(hdcFormatCopySystemFiles, "Copy system files", actionListener), "ja", "\u30b7\u30b9\u30c6\u30e0\u30d5\u30a1\u30a4\u30eb\u3092\u8ee2\u9001\u3059\u308b"), Box.createHorizontalGlue(), Box.createHorizontalStrut(12), Multilingual.mlnText(ComponentFactory.createButton("Start formatting", 70, actionListener), "ja", "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3092\u958b\u59cb\u3059\u308b"), Box.createHorizontalStrut(12), Multilingual.mlnText(ComponentFactory.createButton("Cancel", 67, actionListener), "ja", "\u30ad\u30e3\u30f3\u30bb\u30eb"), Box.createHorizontalStrut(12)), Box.createVerticalStrut(12)))), "ja", "SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u65b0\u898f\u4f5c\u6210");
    }

    public static void hdcMakeFormatFileChooser() {
        if (hdcFormatFileChooser == null) {
            hdcFormatFileChooser = new JFileChooser2();
            hdcFormatFileChooser.setControlButtonsAreShown(false);
        }
    }

    public static void hdcOpenFormatDialog() {
        if (hdcFormatDialog == null) {
            HDC.hdcMakeFormatDialog();
        }
        XEiJ.pnlExitFullScreen(true);
        hdcFormatDialog.setVisible(true);
    }

    public static boolean hdcFormatFiles(File[] fileArray) {
        boolean bl = true;
        byte[] byArray = new byte[(int)HDC.hdcFormatMedia.humDiskEndByte];
        if (!hdcFormatMedia.hdmMakeFormatData(byArray, hdcFormatCopySystemFiles)) {
            bl = false;
        } else {
            int n = 0;
            block0: for (File file : fileArray) {
                Object object = file.getPath();
                if (!((String)object).toUpperCase().endsWith(".HDF")) {
                    object = (String)object + (((String)object).endsWith(".") ? "hdf" : ".hdf");
                    file = new File((String)object);
                }
                if (HDC.hdcIsInserted((String)object)) {
                    bl = false;
                    break;
                }
                if (!XEiJ.rscPutFile((String)object, byArray, 0, byArray.length)) {
                    bl = false;
                    break;
                }
                while (n < 16) {
                    HDUnit hDUnit = hdcUnitArray[n++];
                    if (!hDUnit.abuConnected || hDUnit.abuInserted || !hDUnit.insert((String)object, false)) continue;
                    continue block0;
                }
            }
        }
        if (bl) {
            HDC.hdcAddHistory(fileArray);
        }
        return bl;
    }

    public static void hdcAddHistory(File file) {
        HDC.hdcAddHistory(new File[]{file});
    }

    public static void hdcAddHistory(File[] fileArray) {
        if (hdcOpenDialog == null) {
            hdcOpenHistory.add(fileArray);
        } else {
            hdcOpenDialog.addHistory(fileArray);
        }
        HDC.hdcMakeFormatFileChooser();
        hdcFormatFileChooser.addHistory(fileArray);
        hdcFormatFileChooser.selectLastFiles();
    }

    public static int hdcPeekStatus() {
        return hdcBusStatus;
    }

    public static int hdcReadStatus() {
        int n = hdcBusStatus;
        return n;
    }

    public static void hdcWriteSelect(int n) {
        if ((n &= 0xFF) == 0) {
            return;
        }
        hdcSelectedID = Integer.numberOfTrailingZeros(n);
        hdcSelectedLUN = -1;
        hdcBusStatus = 2;
    }

    public static void hdcWriteCommand(int n) {
        n &= 0xFF;
        hdcWriteHandle = hdcCommandBuffer;
        hdcIndex = 0;
        hdcLimit = 6;
        hdcBusStatus = 11;
        HD63450.dmaFallREQ(1);
    }

    public static void hdcWriteReset(int n) {
        n &= 0xFF;
        HDC.hdcBusFreePhase();
    }

    public static int hdcPeekData() {
        return hdcReadHandle == null ? 0 : hdcReadHandle[hdcIndex] & 0xFF;
    }

    public static int hdcReadData() {
        if (hdcReadHandle == null) {
            return 0;
        }
        int n = hdcReadHandle[hdcIndex++] & 0xFF;
        if (hdcIndex < hdcLimit) {
            HD63450.dmaFallREQ(1);
        } else if (hdcBusStatus == 7) {
            HDC.hdcStatusPhase(0, 0);
        } else if (hdcBusStatus == 15) {
            hdcReadHandle = hdcMessageBuffer;
            hdcWriteHandle = null;
            hdcIndex = 0;
            hdcLimit = 1;
            hdcBusStatus = 31;
            HD63450.dmaFallREQ(1);
        } else {
            HDC.hdcBusFreePhase();
            IOInterrupt.ioiHdcFall();
            IOInterrupt.ioiHdcRise();
        }
        return n;
    }

    public static void hdcWriteData(int n) {
        n &= 0xFF;
        if (hdcWriteHandle == null) {
            return;
        }
        HDC.hdcWriteHandle[HDC.hdcIndex++] = (byte)n;
        if (hdcIndex < hdcLimit) {
            HD63450.dmaFallREQ(1);
        } else if (hdcBusStatus == 3) {
            if (hdcWriteHandle == hdcAssignDriveBuffer) {
                // empty if block
            }
            HDC.hdcStatusPhase(0, 0);
        } else {
            Object object;
            int n2 = hdcCommandBuffer[0] & 0xFF;
            hdcSelectedLUN = hdcCommandBuffer[1] >> 5 & 7;
            if (hdcSelectedLUN > 1) {
                HDC.hdcSenseBuffer[0] = 32;
                HDC.hdcStatusPhase(2, 0);
                return;
            }
            hdcTargetUnit = hdcUnitArray[hdcSelectedID << 1 | hdcSelectedLUN];
            if (!HDC.hdcTargetUnit.abuInserted) {
                HDC.hdcSenseBuffer[0] = 32;
                HDC.hdcStatusPhase(2, 0);
                return;
            }
            if (hdcLastFormatBlodkEnd >= 0 && n2 != 6) {
                object = HDMedia.hdmLengthToMedia(hdcLastFormatBlodkEnd);
                if (object != null) {
                    HDC.hdcTargetUnit.hduMedia = object;
                }
                hdcLastFormatBlodkEnd = -1;
            }
            switch (n2) {
                case 0: {
                    HDC.hdcDoTestDriveReady();
                    break;
                }
                case 1: {
                    HDC.hdcDoRecalibrate();
                    break;
                }
                case 3: {
                    HDC.hdcDoRequestSenseStatus();
                    break;
                }
                case 4: {
                    HDC.hdcDoFormatDrive();
                    break;
                }
                case 6: {
                    HDC.hdcDoFormatBlock();
                    break;
                }
                case 8: {
                    HDC.hdcDoRead();
                    break;
                }
                case 10: {
                    HDC.hdcDoWrite();
                    break;
                }
                case 11: {
                    HDC.hdcDoSeek();
                    break;
                }
                case 194: {
                    HDC.hdcDoAssignDrive();
                    break;
                }
                default: {
                    String string;
                    object = new StringBuilder();
                    String string2 = string = n2 < HDC_COMMAND_NAME.length ? HDC_COMMAND_NAME[n2] : "";
                    if (string.length() == 0) {
                        string = "???";
                    }
                    ((StringBuilder)object).append(String.format("%08x SASI %s(", XEiJ.regPC0, string));
                    for (int i = 0; i < hdcLimit; ++i) {
                        if (i > 0) {
                            ((StringBuilder)object).append(',');
                        }
                        ((StringBuilder)object).append(String.format("0x%02x", hdcCommandBuffer[i] & 0xFF));
                    }
                    ((StringBuilder)object).append(')');
                    System.out.println(((StringBuilder)object).toString());
                    HDC.hdcSenseBuffer[0] = 32;
                    HDC.hdcStatusPhase(2, 0);
                }
            }
        }
    }

    public static void hdcDoTestDriveReady() {
        HDC.hdcStatusPhase(0, 0);
    }

    public static void hdcDoRecalibrate() {
        HDC.hdcStatusPhase(0, 0);
    }

    public static void hdcDoRequestSenseStatus() {
        hdcReadHandle = hdcSenseBuffer;
        hdcIndex = 0;
        hdcLimit = 4;
        hdcBusStatus = 7;
        HD63450.dmaFallREQ(1);
    }

    public static void hdcDoFormatDrive() {
        if (!HDC.hdcTargetUnit.abuInserted || HDC.hdcTargetUnit.hduMedia == null || HDC.hdcTargetUnit.abuWriteProtected) {
            HDC.hdcSenseBuffer[0] = 32;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        HDC.hdcTargetUnit.hduWritten = true;
        Arrays.fill(HDC.hdcTargetUnit.hduImage, 0, (int)HDC.hdcTargetUnit.hduMedia.humDiskEndByte, (byte)0);
        HDC.hdcStatusPhase(0, 0);
    }

    public static void hdcDoFormatBlock() {
        int n;
        int n2 = (hdcCommandBuffer[1] & 0x1F) << 16 | (char)(hdcCommandBuffer[2] << 8 | hdcCommandBuffer[3] & 0xFF);
        int n3 = 33;
        if (!HDC.hdcTargetUnit.abuInserted || HDC.hdcTargetUnit.hduMedia == null || HDC.hdcTargetUnit.abuWriteProtected) {
            HDC.hdcSenseBuffer[0] = 32;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        int n4 = n2 + n3;
        if (HDC.hdcTargetUnit.hduMedia.hdmDiskEndRecord < n4) {
            HDC.hdcSenseBuffer[0] = 33;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        int n5 = HDC.hdcTargetUnit.hduMedia.hdmBytesPerRecord * n2;
        hdcLastFormatBlodkEnd = n = HDC.hdcTargetUnit.hduMedia.hdmBytesPerRecord * n4;
        HDC.hdcTargetUnit.hduWritten = true;
        Arrays.fill(HDC.hdcTargetUnit.hduImage, n5, n, (byte)0);
        HDC.hdcStatusPhase(0, 0);
    }

    public static void hdcDoRead() {
        int n = (hdcCommandBuffer[1] & 0x1F) << 16 | (char)(hdcCommandBuffer[2] << 8 | hdcCommandBuffer[3] & 0xFF);
        int n2 = hdcCommandBuffer[4] & 0xFF;
        if (n2 == 0) {
            n2 = 256;
        }
        if (!HDC.hdcTargetUnit.abuInserted || HDC.hdcTargetUnit.hduMedia == null) {
            HDC.hdcSenseBuffer[0] = 32;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        int n3 = n + n2;
        if (HDC.hdcTargetUnit.hduMedia.hdmDiskEndRecord < n3) {
            HDC.hdcSenseBuffer[0] = 33;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        hdcReadHandle = HDC.hdcTargetUnit.hduImage;
        hdcIndex = HDC.hdcTargetUnit.hduMedia.hdmBytesPerRecord * n;
        hdcLimit = HDC.hdcTargetUnit.hduMedia.hdmBytesPerRecord * n3;
        hdcBusStatus = 7;
        HD63450.dmaFallREQ(1);
    }

    public static void hdcDoWrite() {
        int n = (hdcCommandBuffer[1] & 0x1F) << 16 | (char)(hdcCommandBuffer[2] << 8 | hdcCommandBuffer[3] & 0xFF);
        int n2 = hdcCommandBuffer[4] & 0xFF;
        if (n2 == 0) {
            n2 = 256;
        }
        if (!HDC.hdcTargetUnit.abuInserted || HDC.hdcTargetUnit.hduMedia == null || HDC.hdcTargetUnit.abuWriteProtected) {
            HDC.hdcSenseBuffer[0] = 32;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        int n3 = n + n2;
        if (HDC.hdcTargetUnit.hduMedia.hdmDiskEndRecord < n3) {
            HDC.hdcSenseBuffer[0] = 33;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        HDC.hdcTargetUnit.hduWritten = true;
        hdcWriteHandle = HDC.hdcTargetUnit.hduImage;
        hdcIndex = HDC.hdcTargetUnit.hduMedia.hdmBytesPerRecord * n;
        hdcLimit = HDC.hdcTargetUnit.hduMedia.hdmBytesPerRecord * n3;
        hdcBusStatus = 3;
        HD63450.dmaFallREQ(1);
    }

    public static void hdcDoSeek() {
        int n = (hdcCommandBuffer[1] & 0x1F) << 16 | (char)(hdcCommandBuffer[2] << 8 | hdcCommandBuffer[3] & 0xFF);
        if (!HDC.hdcTargetUnit.abuInserted || HDC.hdcTargetUnit.hduMedia == null) {
            HDC.hdcSenseBuffer[0] = 32;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        if (HDC.hdcTargetUnit.hduMedia.hdmDiskEndRecord <= n) {
            HDC.hdcSenseBuffer[0] = 33;
            HDC.hdcStatusPhase(2, 0);
            return;
        }
        HDC.hdcStatusPhase(0, 0);
    }

    public static void hdcDoAssignDrive() {
        hdcWriteHandle = hdcAssignDriveBuffer;
        hdcIndex = 0;
        hdcLimit = 10;
        hdcBusStatus = 3;
        HD63450.dmaFallREQ(1);
    }

    public static void hdcStatusPhase(int n, int n2) {
        HDC.hdcStatusBuffer[0] = (byte)n;
        HDC.hdcMessageBuffer[0] = (byte)n2;
        hdcReadHandle = hdcStatusBuffer;
        hdcWriteHandle = null;
        hdcIndex = 0;
        hdcLimit = 1;
        hdcBusStatus = 15;
        HD63450.dmaFallREQ(1);
    }

    public static void hdcBusFreePhase() {
        hdcSelectedID = -1;
        hdcSelectedLUN = -1;
        hdcTargetUnit = null;
        hdcBusStatus = 0;
        hdcReadHandle = null;
        hdcWriteHandle = null;
        hdcIndex = 0;
        hdcLimit = 0;
        HD63450.dmaRiseREQ(1);
    }

    static {
        hdcUnitArray = new HDUnit[16];
        hdcCommandBuffer = new byte[6];
        hdcStatusBuffer = new byte[1];
        hdcMessageBuffer = new byte[1];
        hdcSenseBuffer = new byte[4];
        hdcAssignDriveBuffer = new byte[10];
        HDC_DISK_IPL = "`\u0000\u0000\u00ca\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u001a\u001b[6;32HX68000 HARD DISK IPL MENU\u001b[25;22H\u0083J\u0081[\u0083\\\u0083\u008b\u0083L\u0081[\u0082\u00c5\u0091I\u0091\u00f0\u0082\u00b5\u0082\u00c4\u0083\u008a\u0083^\u0081[\u0083\u0093\u0083L\u0081[\u0082\u00f0\u0089\u009f\u0082\u00b5\u0082\u00c4\u0082\u00ad\u0082\u00be\u0082\u00b3\u0082\u00a2\u0000\u001b[26;28H\u0091I\u0091\u00f0\u0082\u00b5\u0082\u00bd\u0082\u00e0\u0082\u00cc\u0082\u00f0\u008e\u00a9\u0093\u00ae\u008bN\u0093\u00ae\u0082\u00c6\u0082\u00b5\u0082\u00c4\u0093o\u0098^\u0082\u00b5\u0082\u00dc\u0082\u00b7\u0000\u0000O\u00fa\u00ff2B\u0085 <\u0000\u0000\u0000\u008eNO\u001e\u0000\u00e1Gt\u0004&<\u0000\u0000\u0001\u0000C\u00fa\u0002\u00c6a\u0000\u00022J\u0000f\u0000\u0001jC\u00fa\u0002\u00b8G\u00fa\u00ff\n\f\u0091X68Kf\u0000\u0001lt\u000eBCBDB\u0086C\u00e9\u0000\u0010J\u0011g\u0016RF&\u00c9\u0010)\u0000\b\b\u0000\u0000\u0000f\bRCJ\u0000f\u0002RDQ\u00ca\u00ff\u00e0JCg\u0000\u0001Br\np\u0004NO\b\u0000\u0000\u0004f\u0012JDg\u000eSDg\u001cC\u00fa\u00fe\u00f4a\u0000\u0001\u00c4`(C\u00fa\u00fe\u00eaa\u0000\u0001\u00baC\u00fa\u00ff>a\u0000\u0001\u00b2`\u0014G\u00fa\u00fe\u009c [$(\u0000\bJ(\u0000\bf\u00f4`\u0000\u0000\u00bez\u0002BCE\u00fa\u00fe\u0084\"R\u0010)\u0000\bg\n\u00b0\u0005g\u0006r\u0002a\u0000\u0001va\u0000\u0001\u0016X\u008aRC\u00b6Fe\u00e2`*a\u0000\u0001\u0006a\u0000\u0000\u00f2\u00b0<\u0000\u001dg:\u00b0<\u00005g\f\u00b0<\u0000<g\u001a\u00b0<\u0000>f\u00e4a\u0000\u0000\u00e8RC\u00b6Fe\u0002BCa\u0000\u0000\u00b2f\u00f2`\u00cca\u0000\u0000\u00d4SCj\u00046\u0006SCa\u0000\u0000\u009ef\u00f2`\u00b8G\u00fa\u00fe\u0018\u00e5C s0\u0000$(\u0000\bJ\u0005g:C\u00fa\u0001\u00b8r\u000eC\u00e9\u0000\u0010J)\u00ff\u00f8g\u0012 \u0011\b\u0000\u0000\u0018f\nB\u0011\u00b4\u0080g\u0004\u0012\u00bc\u0000\u0002Q\u00c9\u00ff\u00e2/\u0002t\u0004&<\u0000\u0000\u0001\u0000C\u00fa\u0001\u0080a\u0000\u0000\u00e8$\u001f\u00c4\u00bc\u0000\u00ff\u00ff\u00ff&<\u0000\u0000\u0004\u0000C\u00fa\u00fd\u00bc\u00d3\u00fc\u0000\u0000\u0004\u0000a\u0000\u0000\u00d0J\u0000f\b\f\u0011\u0000`f\"N\u00d1E\u00fa\u0000\u00daC\u00fa\u0000\u00cca\u0000\u0000\u00ae\"Ja\u0000\u0000\u00a8`\u00feE\u00fa\u0000\u00e3`\u00eaE\u00fa\u0000\u00fa`\u00e4E\u00fa\u0001\u0011`\u00deA\u00fa\u00fd\u0080 \u0003\u00e5@ p\u0000\u0000\u0010(\u0000\b\u00b0\u0005g\u0002J\u0000NuB\u0080NO\u00e0H\u00b0<\u0000Nf\u0002p\u001dNuaZC\u00fa\u00fdV0\u0003\u00e5@C\u00f1\u0000\u0000r$t\t\u00d4Cp#NO\"Qr(aF$\tA\u00fa\u0000\u00e2\u0094\u0088\u00e8\u008a\u0084\u00fc\u0000\n\u00d4\u00bc\u00000\u00000r \u00b4|\u00000g\u00022\u0002a&HB2\u0002a r)a\u001cr a\u0018t\u0007BA\u0012\u0019a\u0010Q\u00ca\u00ff\u00f8r\u0003`\u0002r\u000bp\"NONup NONup!NONupE`\u0002pFH\u00e7x@2\u0007NOL\u00df\u0002\u001eNu\u001a\u001b[16;33H\u0000  \u0083n\u0081[\u0083h\u0083f\u0083B\u0083X\u0083N\u0082\u00aa\u0093\u00c7\u0082\u00df\u0082\u00dc\u0082\u00b9\u0082\u00f1\u0000  \u008a\u00c7\u0097\u009d\u0083u\u0083\u008d\u0083b\u0083N\u0082\u00aa\u0089\u00f3\u0082\u00ea\u0082\u00c4\u0082\u00a2\u0082\u00dc\u0082\u00b7\u0000  \u008bN\u0093\u00ae\u0089\u00c2\u0094\\\u0082\u00c8\u0097\u00cc\u0088\u00e6\u0082\u00aa\u0082\u00a0\u0082\u00e8\u0082\u00dc\u0082\u00b9\u0082\u00f1\u0000\u0082h\u0082o\u0082k\u0083u\u0083\u008d\u0083b\u0083N\u0082\u00cc\u0093\u00e0\u0097e\u0082\u00aa\u0088\u00d9\u008f\u00ed\u0082\u00c5\u0082\u00b7\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
        HDC_PARTITION_IPL = "` Hudson soft 2.00\u0004\u0000\u0001\u0002\u0000\u0001\u0002\u0000'r\u00f8\u0014\u0000\u0000\u0000\u0000O\u00fa\u00ff\u00dcC\u00fa\u00014a\u0000\u0001* <\u0000\u0000\u0000\u008eNO\u0012\u0000\u00e1AB\u0082\u0014:\u00ff\u00dfB\u0080\u0010:\u00ff\u00d1\u00c4\u00c0B\u00800:\u00ff\u00ca\u00d4\u0080\u00e5\u0082\u00d4\u00ba\u00ff\u00ca&<\u0000\u0000\u0004\u0000C\u00fa\u0001\u009aa\u0000\u0000\u00c8J\u0000f\u0000\u0000\u00d0C\u00fa\u0001\u008c<<\u0000\u001f$IG\u00fa\u0001u~\n\u0010\u001a\u0080<\u0000 \u00b0\u001bf\u0006Q\u00cf\u00ff\u00f4`\u0014\u00d3\u00fc\u0000\u0000\u0000 Q\u00ce\u00ff\u00e0C\u00fa\u0000\u00c8a\u0000\u0000\u00bc`\u00feB\u00800)\u0000\u001a\u00e1XU@B\u0087\u001e:\u00ffh\u00c0\u00c7\u00e5\u0080\u00d4\u0080B\u00800:\u00ff`\u00eb\u0080\u00d0\u00bc\u0000\u0000\u0003\u00ff\u00e0\u0088\u00e4\u0088\u00e5\u0080\u00d4\u0080H\u00e7`\u0000C\u00fa\u0001(&<\u0000\u0000\u0001\u0000aPL\u00df\u0000\u0006J\u0000fVC\u00fa\u0001\u0014\fYHUfVT\u0089\f\u0099\u0000\u0000h\u0000fV/\u0019&\u0019\u00d6\u0099/\u0003/\u0019\"|\u0000\u0000g\u00c0\u00d6\u00bc\u0000\u0000\u0000@a\u001c\"\u001f$\u001f\"_J\u0000f A\u00f9\u0000\u0000h\u0000\u00d1\u00c2S\u0081e\u0004B\u0018`\u00f8N\u00d1H\u00e7x@pFNOL\u00df\u0002\u001eNuC\u00fa\u0000Ha\u0018`\u0000\u00ff\\C\u00fa\u0000]a\u000e`\u0000\u00ffRC\u00fa\u0000ua\u0004`\u0000\u00ffHp!NONu\u001a\u0000\u001b[16;35HHuman.sys \u0082\u00aa \u008c\u00a9\u0082\u00c2\u0082\u00a9\u0082\u00e8\u0082\u00dc\u0082\u00b9\u0082\u00f1\u0000\u001b[16;38H\u0083f\u0083B\u0083X\u0083N\u0082\u00aa\u0081@\u0093\u00c7\u0082\u00df\u0082\u00dc\u0082\u00b9\u0082\u00f1\u0000\u001b[16;36HHuman.sys \u0082\u00aa \u0089\u00f3\u0082\u00ea\u0082\u00c4\u0082\u00a2\u0082\u00dc\u0082\u00b7\u0000\u001b[16;33HHuman.sys \u0082\u00cc \u0083A\u0083h\u0083\u008c\u0083X\u0082\u00aa\u0088\u00d9\u008f\u00ed\u0082\u00c5\u0082\u00b7\u0000human   sys\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
    }

    static class OpenDialog
    extends AbstractOpenDialog {
        public OpenDialog() {
            super(XEiJ.frmFrame, "Open SASI hard disk image files", "SASI \u30cf\u30fc\u30c9\u30c7\u30a3\u30b9\u30af\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", false, hdcFileFilter);
        }

        @Override
        public void openFiles(File[] fileArray, boolean bl) {
            HDC.hdcOpenFiles(fileArray, bl);
        }
    }

    public static class HDUnit
    extends AbstractUnit {
        public HDMedia hduMedia;
        public byte[] hduImage = null;
        public boolean hduWritten = false;

        public HDUnit(int n) {
            super(n);
        }

        public void hduTini() {
            if (this.abuInserted) {
                this.hduFlush();
            }
        }

        public boolean hduFlush() {
            if (!this.hduWritten) {
                return true;
            }
            if (this.abuWriteProtected) {
                return false;
            }
            if (!XEiJ.rscPutFile(this.abuPath, this.hduImage, 0, (int)this.hduMedia.humDiskEndByte)) {
                return false;
            }
            this.hduWritten = false;
            return true;
        }

        @Override
        protected void connect(boolean bl) {
            super.connect(bl);
            this.hduImage = new byte[HDMedia.HDM_MAX_BYTES_PER_DISK];
            this.hduWritten = false;
        }

        @Override
        protected void disconnect() {
            super.disconnect();
            this.hduImage = null;
        }

        @Override
        protected boolean eject() {
            if (!this.hduFlush()) {
                return false;
            }
            String string = this.abuPath;
            if (!super.eject()) {
                return false;
            }
            if (this.hduMedia != null) {
                HDC.hdcAddHistory(new File(string).getAbsoluteFile());
                System.out.println(Multilingual.mlnJapanese ? string + " \u3092 sa" + this.abuNumber + " \u304b\u3089\u5207\u308a\u96e2\u3057\u307e\u3057\u305f" : string + " was removed from sa" + this.abuNumber);
            }
            this.hduMedia = null;
            if (hdcHDMax == this.abuNumber - 1) {
                int n;
                for (n = this.abuNumber - 1; n >= 0 && !HDC.hdcUnitArray[n].abuInserted; --n) {
                }
                hdcHDMax = n + 1;
            }
            return true;
        }

        @Override
        protected boolean open() {
            if (!super.open()) {
                return false;
            }
            hdcOpenUnit = this.abuNumber;
            if (hdcOpenDialog == null) {
                hdcOpenDialog = new OpenDialog();
                hdcOpenDialog.setReadOnly(Settings.sgsGetOnOff("sareadonly"));
                hdcOpenDialog.setReboot(Settings.sgsGetOnOff("saappreboot"));
                for (File[] fileArray : hdcOpenHistory) {
                    hdcOpenDialog.addHistory(fileArray);
                }
                hdcOpenHistory.clear();
            }
            hdcOpenDialog.rescanCurrentDirectory();
            XEiJ.pnlExitFullScreen(true);
            hdcOpenDialog.setVisible(true);
            return true;
        }

        @Override
        protected boolean insert(String string, boolean bl) {
            if (HDC.hdcIsInserted(string)) {
                return false;
            }
            if (!super.insert(string, bl)) {
                return false;
            }
            if (hdcHDMax <= this.abuNumber) {
                hdcHDMax = this.abuNumber + 1;
            }
            return true;
        }

        @Override
        protected boolean load(String string) {
            this.hduMedia = HDMedia.hdmPathToMedia(string, this.hduImage);
            if (this.hduMedia == null) {
                return false;
            }
            this.hduWritten = false;
            HDC.hdcAddHistory(new File(string).getAbsoluteFile());
            System.out.println(Multilingual.mlnJapanese ? string + " \u3092 sa" + this.abuNumber + " \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f" : string + " was connected to sa" + this.abuNumber);
            return true;
        }
    }
}

