/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.NumberSpinner;

public class DecimalSpinner
extends NumberSpinner {
    protected int minimum;
    protected int maximum;
    protected int option;

    public DecimalSpinner(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public DecimalSpinner(int n, int n2, int n3, int n4, int n5) {
        super(new SpinnerNumberModel(n, n2, n3, n4));
        this.minimum = n2;
        this.maximum = n3;
        this.option = n5;
        this.setBorder(new LineBorder(new Color(LnF.lnfRGB[10]), 1));
        int n6 = String.valueOf(n3).length();
        ComponentFactory.setFixedSize(this, 24 + LnF.lnfFontSize * 2 / 3 * n6, LnF.lnfFontSize + 4);
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        numberEditor.getFormat().setGroupingUsed(false);
        JFormattedTextField jFormattedTextField = numberEditor.getTextField();
        jFormattedTextField.setText(String.valueOf(n));
        jFormattedTextField.setHorizontalAlignment(0);
    }

    public int getIntValue() {
        return this.model.getNumber().intValue();
    }

    public void setIntValue(int n) {
        if (n < this.minimum || this.maximum < n) {
            throw new IllegalArgumentException();
        }
        this.model.setValue(n);
    }

    public int getOption() {
        return this.option;
    }

    public void setOption(int n) {
        this.option = n;
    }
}

