/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import xeij.ComponentFactory;
import xeij.Indicator;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.XEiJ;

public class ATCMonitor {
    public static final boolean ACM_ON = true;
    public static int[][] acmCaches;
    public static final int ACM_WIDTH = 400;
    public static final int ACM_HEIGHT = 438;
    public static final int ACM_OFFSET = 100;
    public static IndexColorModel acmColorModel;
    public static BufferedImage acmImage;
    public static byte[] acmBitmap;
    public static JPanel acmPanel;
    public static JFrame acmFrame;
    public static final int ACM_INTERVAL = 10;
    public static int acmTimer;
    public static final byte[] ACM_FONT_1;
    public static final byte[] ACM_FONT_2;
    public static final byte[] ACM_FONT_3;

    public static void acmInit() {
        acmCaches = new int[][]{MC68060.mmuUserDataCache, MC68060.mmuUserCodeCache, MC68060.mmuSuperDataCache, MC68060.mmuSuperCodeCache};
        int n = 0;
        for (int i = 0; i < 127; ++i) {
            char c = Indicator.IND_ASCII_3X5[i];
            int n2 = (int)(6075430939327988736L >>> (c >>> 9 & 0x38)) & 0xFF;
            ATCMonitor.ACM_FONT_1[n] = (byte)n2;
            ATCMonitor.ACM_FONT_2[n] = (byte)(n2 * 2);
            ATCMonitor.ACM_FONT_3[n] = (byte)(n2 * 3);
            n2 = (int)(6075430939327988736L >>> (c >>> 6 & 0x38)) & 0xFF;
            ATCMonitor.ACM_FONT_1[++n] = (byte)n2;
            ATCMonitor.ACM_FONT_2[n] = (byte)(n2 * 2);
            ATCMonitor.ACM_FONT_3[n] = (byte)(n2 * 3);
            n2 = (int)(6075430939327988736L >>> (c >>> 3 & 0x38)) & 0xFF;
            ATCMonitor.ACM_FONT_1[++n] = (byte)n2;
            ATCMonitor.ACM_FONT_2[n] = (byte)(n2 * 2);
            ATCMonitor.ACM_FONT_3[n] = (byte)(n2 * 3);
            n2 = (int)(6075430939327988736L >>> (c & 0x38)) & 0xFF;
            ATCMonitor.ACM_FONT_1[++n] = (byte)n2;
            ATCMonitor.ACM_FONT_2[n] = (byte)(n2 * 2);
            ATCMonitor.ACM_FONT_3[n] = (byte)(n2 * 3);
            n2 = (int)(6075430939327988736L >>> (c << 3 & 0x38)) & 0xFF;
            ATCMonitor.ACM_FONT_1[++n] = (byte)n2;
            ATCMonitor.ACM_FONT_2[n] = (byte)(n2 * 2);
            ATCMonitor.ACM_FONT_3[n] = (byte)(n2 * 3);
            ++n;
        }
        acmFrame = null;
        acmTimer = 0;
    }

    public static void acmStart() {
        if (RestorableFrame.rfmGetOpened("acm")) {
            ATCMonitor.acmOpen();
        }
    }

    public static void acmOpen() {
        if (acmFrame == null) {
            ATCMonitor.acmMakeFrame();
        } else {
            ATCMonitor.acmUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x2000;
        XEiJ.pnlExitFullScreen(false);
        acmFrame.setVisible(true);
    }

    public static void acmMakeFrame() {
        acmColorModel = new IndexColorModel(2, 4, new byte[]{0, 32, -1, -1}, new byte[]{0, 32, -121, -1}, new byte[]{0, -1, 64, -1});
        acmImage = new BufferedImage(400, 438, 12, acmColorModel);
        acmBitmap = ((DataBufferByte)acmImage.getRaster().getDataBuffer()).getData();
        ATCMonitor.acmDrawString3(37, 1, "ADDRESS TRANSLATION CACHES");
        ATCMonitor.acmDrawString2(8, 3, "USER DATA");
        ATCMonitor.acmDrawString2(33, 3, "USER CODE");
        ATCMonitor.acmDrawString2(55, 3, "SUPERVISOR DATA");
        ATCMonitor.acmDrawString2(80, 3, "SUPERVISOR CODE");
        for (int i = 0; i < 4; ++i) {
            int n = 25 * i;
            ATCMonitor.acmDrawString3(n + 6, 4, "/64=");
            ATCMonitor.acmDrawString3(n + 13, 4, "% IN USE");
            ATCMonitor.acmDrawString2(n + 4, 6, "LOGICAL  PHYSICAL");
        }
        ATCMonitor.acmDrawString2(37, 71, "G:GLOBAL W:WRITE-PROTECTED");
        acmPanel = ComponentFactory.setFixedSize(new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics.drawImage(acmImage, 0, 0, null);
            }

            @Override
            protected void paintBorder(Graphics graphics) {
            }

            @Override
            protected void paintChildren(Graphics graphics) {
            }

            @Override
            public void update(Graphics graphics) {
            }
        }, 400, 438);
        acmPanel.setBackground(Color.black);
        acmPanel.setOpaque(true);
        acmFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("acm", "Address translation caches monitor", null, acmPanel), "ja", "\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u30ad\u30e3\u30c3\u30b7\u30e5\u30e2\u30cb\u30bf");
        ComponentFactory.addListener(acmFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFDFFF;
            }
        });
    }

    public static void acmUpdateFrame() {
        if (acmFrame == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            int n;
            int[] nArray = acmCaches[i];
            int n2 = 25 * i;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n4 < 64) {
                n = XEiJ.FMT_BCD4[n4];
                int n6 = 7 + n4;
                int n7 = nArray[n5];
                if (!MC68060.mmuEnabled || n7 == 1) {
                    ATCMonitor.acmDrawChar1(n2 + 1, n6, n >> 4 == 0 ? 32 : (n >> 4) + 48);
                    ATCMonitor.acmDrawChar1(n2 + 2, n6, (n & 0xF) + 48);
                    ATCMonitor.acmDrawString1(n2 + 4, n6, "-------- -------- --");
                } else {
                    ++n3;
                    int n8 = nArray[n5 + 1];
                    int n9 = nArray[n5 + 2];
                    int n10 = nArray[n5 + 3];
                    ATCMonitor.acmDrawChar3(n2 + 1, n6, n >> 4 == 0 ? 32 : (n >> 4) + 48);
                    ATCMonitor.acmDrawChar3(n2 + 2, n6, (n & 0xF) + 48);
                    n = n7 >>> 28;
                    ATCMonitor.acmDrawChar3(n2 + 4, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n7 >>> 24 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 5, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n7 >>> 20 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 6, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n7 >>> 16 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 7, n6, (9 - n >> 4 & 7) + n + 48);
                    n = (char)n7 >>> 12;
                    ATCMonitor.acmDrawChar3(n2 + 8, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n7 >>> 8 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 9, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n7 >>> 4 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 10, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n7 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 11, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 >>> 28;
                    ATCMonitor.acmDrawChar3(n2 + 13, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 >>> 24 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 14, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 >>> 20 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 15, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 >>> 16 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 16, n6, (9 - n >> 4 & 7) + n + 48);
                    n = (char)n9 >>> 12;
                    ATCMonitor.acmDrawChar3(n2 + 17, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 >>> 8 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 18, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 >>> 4 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 19, n6, (9 - n >> 4 & 7) + n + 48);
                    n = n9 & 0xF;
                    ATCMonitor.acmDrawChar3(n2 + 20, n6, (9 - n >> 4 & 7) + n + 48);
                    ATCMonitor.acmDrawChar3(n2 + 22, n6, n10 != 0 ? 71 : 45);
                    ATCMonitor.acmDrawChar3(n2 + 23, n6, n8 == 1 ? 87 : 45);
                }
                ++n4;
                n5 += 4;
            }
            n = XEiJ.FMT_BCD4[n3];
            ATCMonitor.acmDrawChar3(n2 + 4, 4, n >> 4 == 0 ? 32 : (n >> 4) + 48);
            ATCMonitor.acmDrawChar3(n2 + 5, 4, (n & 0xF) + 48);
            n = XEiJ.FMT_BCD4[100 * n3 + 32 >> 6];
            ATCMonitor.acmDrawChar3(n2 + 10, 4, n >> 8 == 0 ? 32 : (n >> 8) + 48);
            ATCMonitor.acmDrawChar3(n2 + 11, 4, n >> 4 == 0 ? 32 : (n >> 4 & 0xF) + 48);
            ATCMonitor.acmDrawChar3(n2 + 12, 4, (n & 0xF) + 48);
        }
        acmPanel.repaint();
    }

    public static void acmDrawChar1(int n, int n2, int n3) {
        byte[] byArray = acmBitmap;
        byArray[n += 600 * n2] = ACM_FONT_1[n3 *= 5];
        byArray[n + 100] = ACM_FONT_1[n3 + 1];
        byArray[n + 200] = ACM_FONT_1[n3 + 2];
        byArray[n + 300] = ACM_FONT_1[n3 + 3];
        byArray[n + 400] = ACM_FONT_1[n3 + 4];
    }

    public static void acmDrawChar2(int n, int n2, int n3) {
        byte[] byArray = acmBitmap;
        byArray[n += 600 * n2] = ACM_FONT_2[n3 *= 5];
        byArray[n + 100] = ACM_FONT_2[n3 + 1];
        byArray[n + 200] = ACM_FONT_2[n3 + 2];
        byArray[n + 300] = ACM_FONT_2[n3 + 3];
        byArray[n + 400] = ACM_FONT_2[n3 + 4];
    }

    public static void acmDrawChar3(int n, int n2, int n3) {
        byte[] byArray = acmBitmap;
        byArray[n += 600 * n2] = ACM_FONT_3[n3 *= 5];
        byArray[n + 100] = ACM_FONT_3[n3 + 1];
        byArray[n + 200] = ACM_FONT_3[n3 + 2];
        byArray[n + 300] = ACM_FONT_3[n3 + 3];
        byArray[n + 400] = ACM_FONT_3[n3 + 4];
    }

    public static void acmDrawString1(int n, int n2, String string) {
        ATCMonitor.acmDrawString1(n, n2, string.toCharArray());
    }

    public static void acmDrawString1(int n, int n2, char[] cArray) {
        byte[] byArray = acmBitmap;
        n += 600 * n2;
        for (char c : cArray) {
            c = (char)(c * 5);
            byArray[n] = ACM_FONT_1[c];
            byArray[n + 100] = ACM_FONT_1[c + '\u0001'];
            byArray[n + 200] = ACM_FONT_1[c + 2];
            byArray[n + 300] = ACM_FONT_1[c + 3];
            byArray[n + 400] = ACM_FONT_1[c + 4];
            ++n;
        }
    }

    public static void acmDrawString2(int n, int n2, String string) {
        ATCMonitor.acmDrawString2(n, n2, string.toCharArray());
    }

    public static void acmDrawString2(int n, int n2, char[] cArray) {
        byte[] byArray = acmBitmap;
        n += 600 * n2;
        for (char c : cArray) {
            c = (char)(c * 5);
            byArray[n] = ACM_FONT_2[c];
            byArray[n + 100] = ACM_FONT_2[c + '\u0001'];
            byArray[n + 200] = ACM_FONT_2[c + 2];
            byArray[n + 300] = ACM_FONT_2[c + 3];
            byArray[n + 400] = ACM_FONT_2[c + 4];
            ++n;
        }
    }

    public static void acmDrawString3(int n, int n2, String string) {
        ATCMonitor.acmDrawString3(n, n2, string.toCharArray());
    }

    public static void acmDrawString3(int n, int n2, char[] cArray) {
        byte[] byArray = acmBitmap;
        n += 600 * n2;
        for (char c : cArray) {
            c = (char)(c * 5);
            byArray[n] = ACM_FONT_3[c];
            byArray[n + 100] = ACM_FONT_3[c + '\u0001'];
            byArray[n + 200] = ACM_FONT_3[c + 2];
            byArray[n + 300] = ACM_FONT_3[c + 3];
            byArray[n + 400] = ACM_FONT_3[c + 4];
            ++n;
        }
    }

    static {
        ACM_FONT_1 = new byte[635];
        ACM_FONT_2 = new byte[635];
        ACM_FONT_3 = new byte[635];
    }
}

