;========================================================================================
;  sprdrv.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;^Cg
;	gXvCgEobNOEhhCo
;O
;	sprdrv.x
;o[W
;	(2025-06-28)
;@\
;	XvCgEobNOEh֘AIOCSR[XEiJ̊g@\gpł悤ɂ܂B
;	_SP_INITŊg@\LɂvZXIƂg@\𖳌ɂ܂B
;XEiJ̐ݒ
;	4096̃p^[ONɂăZbgĂB
;	XvCg̖128/256/504/1016̂ꂩA768x512ŃXvCg\A512x512BG1\ɑΉ܂B
;	X^̃XvCg̖1016ɂĂƂ悢ł傤B
;gp@
;	device=sprdrv.x <IvV>
;	  ܂
;	A>sprdrv.x <IvV>
;IvV
;	-c	풓mF
;		풓mFsAʂbZ[WƏIR[hŕԂ܂B
;	-d	nȂ
;		݂̃vZX̏IV[PXɌn̏ǉ܂B
;		̃vZXĂꍇɎw肵܂B
;		IV[PX̕ύX̃vOOS̃pb`ƏՓ˂ꍇɂw肵܂B
;	-e	n(ftHg)
;		g@\gpƂÃ݂vZX̏IV[PXɌn̏ǉ܂B
;	-q	Ïl
;		IvVႤƂȊOAbZ[W\܂B
;	-r	풓
;		풓foCXhCôƂAxN^𕜌ăfoCXhCo؂藣܂B
;		풓ubN̂ƂAxN^𕜌ăubNJ܂B
;		풓ɃxN^ύXď풓wĂȂƂ͉ł܂B
;	-v	o[WmF
;		^Cgƃo[W\ĐI܂B
;IR[h
;	0	܂
;	1	IvVႢ܂
;	2	풓Ă܂
;	3	풓Ă܂
;	4	xN^ύXĂ܂Bł܂
;	65536	풓܂
;XV
;	2025-04-07
;		ŁB
;	2025-04-10
;		_SP_REGST/_SP_REGGT̃XvCg̔ԍAԂɕύX܂B
;		_BGTEXTSTC܂B
;	2025-06-28
;		_SP_INITɏ풓mFǉ܂B
;		_BGSCRLST/_BGSCRLGTɍsXN[܂͗XN[̐ݒ/擾ǉ܂B
;		_SP_INITI0ԂȂꍇsC܂B
;----------------------------------------------------------------
;oN
;	  15   14   13   12   11   10    9    8    7    6    5    4    3    2    1    0
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	|                                                                | [h  |ړ|
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	ړ
;		ړ	eLXgGÄړ
;		0	Ȃ
;		1	
;	[h
;		[h	p^[	XvCg]	eLXg]
;		0	256				
;		1	1024				
;		2	4096		s		s
;		3	4096				s
;		]s₤߁A_SP_DEFCGɃp^[𔽓]@\ǉĂ܂B
;LN^
;	  15   14   13   12   11   10    9    8    7    6    5    4    3    2    1    0
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	|㉺|E|         | pbgubN  |             p^[ԍ              |  [h0
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	|㉺|E|ԍ | pbgubN  |           p^[ԍ            |  [h1
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	| p^[ԍ  | pbgubN  |           p^[ԍ            |  [h2,3
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;vCIeB
;	  15   14   13   12   11   10    9    8    7    6    5    4    3    2    1    0
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	|                                                                ||D揇 |  [h0,1,2
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	|㉺|E|                                                      ||D揇 |  [h3
;	+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
;	D揇
;	0	\Ȃ
;	1	obNOEh0obNOEh1XvCg
;	2	obNOEh0XvCgobNOEh1
;	3	XvCgobNOEh0obNOEh1
;----------------------------------------------------------------
;IOCS $C0 _SP_INIT
;	@\	XvCgEobNOEh܂B
;		_SP_INITŊg@\LɂvZXIƂg@\𖳌ɂ܂B
;		WX^	l
;		d1.l		'SPRD'$53505244	g@\gp
;		d2.l		0`7		oN
;				-1		풓mF(͍sȂ)
;	o	WX^	l
;		d0.l		-3		g@\gpłȂ
;				-1		XvCgʂgpłȂ
;				0		I
;		풓mF̂Ƃ
;		d0.l		$53xxxxxx	o[W
;----------------------------------------------------------------
;IOCS $C1 _SP_ON
;	@\	XvCgʂ\܂B
;		Ȃ
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $C2 _SP_OFF
;	@\	XvCgʂ\܂B
;		Ȃ
;	o	WX^	l
;		d0.l		0		I
;----------------------------------------------------------------
;IOCS $C3 _SP_CGCLR
;	@\	p^[[NA܂B
;		WX^	l
;		d1.w		0`4095		p^[ԍ
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $C4 _SP_DEFCG
;	@\	p^[ݒ肵܂B
;		p^[𔽓]@\ǉĂ܂B
;		WX^	l
;		d1.w		0`4095		p^[ԍ
;		d2.w[15]	0`1		㉺]
;		d2.w[14]	0`1		E]
;		d2.b		0`1		TCYB0=8x8,1=16x16
;		a1.l				obt@̃AhX
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $C5 _SP_GTPCG
;	@\	p^[擾܂B
;		WX^	l
;		d1.w		0`4095		p^[ԍ
;		d2.b		0`1		TCYB0=8x8,1=16x16
;		a1.l				obt@̃AhX
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $C6 _SP_REGST
;	@\	XvCgXN[WX^ݒ肵܂B
;		rbgNA܂B
;		WX^	l
;		d1.l[31]	1		VDISP̗҂Ȃ
;		d1.w		0`1015		XvCgԍ(A)
;		d2.l[31]	1		XWݒ肵Ȃ
;		d2.w		0`1023		XW
;		d3.l[31]	1		YWݒ肵Ȃ
;		d3.w		0`1023		YW
;		d4.l[31]	1		LN^ݒ肵Ȃ
;		d4.w		0`65535	LN^
;		d5.l[31]	1		vCIeBݒ肵Ȃ
;		d5.w		0`65535	vCIeB
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $C7 _SP_REGGT
;	@\	XvCgXN[WX^擾܂B
;		WX^	l
;		d1.w		0`1015		XvCgԍ(A)
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;		d2.l		0`1023		XW
;		d3.l		0`1023		YW
;		d4.l		0`65535	LN^
;		d5.l		0`65535	vCIeB
;----------------------------------------------------------------
;IOCS $C8 _BGSCRLST
;	@\	obNOEhXN[WX^ݒ肵܂B
;		sXN[܂͗XN[̐ݒ肪ǉĂ܂B
;		WX^	l
;		
;		d1.l[31]	1		VDISP̗҂Ȃ
;		d1.w[15`8]	0`2		0=obNOEh,1=sXN[,2=XN[
;		d1.b		0`1		obNOEhԍ
;		obNOEh
;		d2.l[31]	1		XWݒ肵Ȃ
;		d2.w		0`1023		XW
;		d3.l[31]	1		YWݒ肵Ȃ
;		d3.w		0`1023		YW
;		sXN[
;		d2.w		0`63		sԍ
;		d3.w		0`1023		XW
;		XN[
;		d2.w		0`63		ԍ
;		d3.w		0`1023		YW
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $C9 _BGSCRLGT
;	@\	obNOEhXN[WX^擾܂B
;		sXN[܂͗XN[̎擾ǉĂ܂B
;		WX^	l
;		
;		d1.w[15`8]	0`2		0=obNOEh,1=sXN[,2=XN[
;		d1.b		0`1		obNOEhԍ
;		sXN[
;		d2.w		0`63		sԍ
;		XN[
;		d2.w		0`63		ԍ
;	o	WX^	l
;		
;		d0.l		-1		XvCgʂgpłȂ
;		obNOEh
;		d0.l		0		I
;		d2.l		0`1023		XW
;		d3.l		0`1023		YW
;		sXN[
;		d0.l		0`1023		XW
;		XN[
;		d0.l		0`1023		YW
;----------------------------------------------------------------
;IOCS $CA _BGCTRLST
;	@\	obNOEh䃌WX^ݒ肵܂B
;		WX^	l
;		d1.b		0`1		obNOEhԍ
;		d2.l[31]	1		eLXgGAԍݒ肵Ȃ
;		d2.b		0`1		eLXgGAԍ
;		d3.l[31]	1		\̗Lݒ肵Ȃ
;		d3.b		0`1		\̗L
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $CB _BGCTRLGT
;	@\	obNOEh䃌WX^擾܂
;		WX^	l
;		d1.b		0`1		obNOEhԍ
;	o	WX^	l
;		d0.l		-1		XvCgʂgpłȂ
;				0`7		eLXgGAԍ<<1|\̗L
;----------------------------------------------------------------
;IOCS $CC _BGTEXTCL
;	@\	obNOEheLXgLN^Ŗߐs܂B
;		^OtBbNʂ@\ǉĂ܂B
;		WX^	l
;		d1.w[15`8]	$00		LN^Ŗߐs
;				$10		^OtBbNʂ
;		d1.b		0`1		eLXgGAԍ
;		d2.w		0`65535	LN^^pbgubN
;	o	WX^	l
;		d0.l		-3		g@\gpłȂ
;				-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $CD _BGTEXTST
;	@\	obNOEheLXgɃLN^݂܂B
;		^OtBbNʂɏދ@\ǉĂ܂B
;		WX^	l
;		d1.w[15`8]	$00		LN^
;				$10		^OtBbNʂ1hbg
;		d1.b		0`1		eLXgGAԍ
;		d2.w		0`1023		XW
;		d3.w		0`1023		YW
;		d4.w		0`65535	LN^^pbgR[h
;	o	WX^	l
;		d0		-3		g@\gpłȂ
;				-1		XvCgʂgpłȂ
;				0		I
;----------------------------------------------------------------
;IOCS $CE _BGTEXTGT
;	@\	obNOEheLXgLN^ǂݏo܂B
;		^OtBbNʂǂݏo@\ǉĂ܂B
;		WX^	l
;		d1.w[15`8]	$00		LN^ǂݏo
;				$10		^OtBbNʂ1hbgǂݏo
;		d1.b		0`1		eLXgGAԍ
;		d2.w		0`1023		XW
;		d3.w		0`1023		YW
;	o	WX^	l
;		d0.l		-3		g@\gpłȂ
;				-1		XvCgʂgpłȂ
;				0`65535	LN^^pbgR[h
;----------------------------------------------------------------
;IOCS $CF _SPALET
;	@\	XvCgpbgݒ܂͎擾܂B
;		pbgubN0͎wł܂B
;		WX^	l
;		d1.l[31]	1		VDISP̗҂Ȃ
;		d1.b		0`255		pbgubN<<4|pbgR[h
;		d2.b		0`15		pbgubN(D)
;		d3.l[31]	0		ݒ
;				1		擾
;		d3.w		0`65535	J[R[h
;	o	WX^	l
;		d0.l		-2		pbgubN0w肳ꂽ
;				0`65535	ݒÕJ[R[h
;----------------------------------------------------------------

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	dosconst.equ
	.include	doswork.equ
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	sprc.equ
	.include	vector.equ
	.include	vicon.equ

DEVICE_NAME	reg	'/*SPRD*/'
JAPANESE_TITLE	reg	'gXvCgEobNOEhhCo'
ENGLISH_TITLE	reg	'Extended sprite and background driver'
VERSION_STRING	reg	'(2025-06-28)'
VERSION_NUMBER	equ	$53250628
PROGRAM_NAME	reg	'sprdrv.x'
PROGRAMEN_NAME	reg	'sprdrven.x'

  .ifndef ENGLISH
ENGLISH		equ	0
  .endif

;----------------------------------------------------------------
;vO̐擪
	.text
program_head:

;foCXwb_
	.dc.l	-1			;̃foCXwb_B-1=foCXwb_̃Xg̖
	.dc.w	$8000			;foCX^CvBLN^foCX
	.dc.l	strategy_routine	;XgeW[`
	.dc.l	interrupt_routine	;C^vg[`
	.dc.b	DEVICE_NAME		;foCX

;xN^e[u
vector_table:
	.dc.w	4*($100+_SP_INIT)	;ItZbg
	.dc.l	iocs_C0_SP_INIT		;VxN^
	.dc.l	0			;ÂxN^
	.dc.w	4*($100+_SP_ON)
	.dc.l	iocs_C1_SP_ON
	.dc.l	0
	.dc.w	4*($100+_SP_OFF)
	.dc.l	iocs_C2_SP_OFF
	.dc.l	0
	.dc.w	4*($100+_SP_CGCLR)
	.dc.l	iocs_C3_SP_CGCLR
	.dc.l	0
	.dc.w	4*($100+_SP_DEFCG)
	.dc.l	iocs_C4_SP_DEFCG
	.dc.l	0
	.dc.w	4*($100+_SP_GTPCG)
	.dc.l	iocs_C5_SP_GTPCG
	.dc.l	0
	.dc.w	4*($100+_SP_REGST)
	.dc.l	iocs_C6_SP_REGST
	.dc.l	0
	.dc.w	4*($100+_SP_REGGT)
	.dc.l	iocs_C7_SP_REGGT
	.dc.l	0
	.dc.w	4*($100+_BGSCRLST)
	.dc.l	iocs_C8_BGSCRLST
	.dc.l	0
	.dc.w	4*($100+_BGSCRLGT)
	.dc.l	iocs_C9_BGSCRLGT
	.dc.l	0
	.dc.w	4*($100+_BGCTRLST)
	.dc.l	iocs_CA_BGCTRLST
	.dc.l	0
	.dc.w	4*($100+_BGCTRLGT)
	.dc.l	iocs_CB_BGCTRLGT
	.dc.l	0
	.dc.w	4*($100+_BGTEXTCL)
	.dc.l	iocs_CC_BGTEXTCL
	.dc.l	0
	.dc.w	4*($100+_BGTEXTST)
	.dc.l	iocs_CD_BGTEXTST
	.dc.l	0
	.dc.w	4*($100+_BGTEXTGT)
	.dc.l	iocs_CE_BGTEXTGT
	.dc.l	0
	.dc.w	4*($100+_SPALET)
	.dc.l	iocs_CF_SPALET
	.dc.l	0
	.dc.w	0

;tO
cleanup_flag:
	.dc.b	-1			;-1=n,0=nȂ
	.even

;NGXgwb_̃AhX
request_header:
	.dc.l	0

;XgeW[`
strategy_routine:
	move.l	a5,request_header
	rts

;C^vg[`
interrupt_routine:
	push	d0-d7/a0-a6
	movea.l	request_header(pc),a5
	moveq.l	#0,d0
	move.b	2(a5),d0		;R}hԍ
	if	<cmp.w #(jump_table_end-jump_table)/2,d0>,hs	;͈͊O
		moveq.l	#(jump_table_end-jump_table)/2,d0
	endif
	add.w	d0,d0
	move.w	jump_table(pc,d0.w),d0
	jsr	jump_table(pc,d0.w)
	move.b	d0,3(a5)		;G[R[h
	lsr.w	#8,d0
	move.b	d0,4(a5)		;G[R[h
	pop
	rts

;foCXR}h̃Wve[u
jump_table:
	.dc.w	initialize-jump_table		;foCXR}h0 
	.dc.w	command_error-jump_table	;foCXR}h1 fBXN`FbN
	.dc.w	command_error-jump_table	;foCXR}h2 BPBe[u̍č\z
	.dc.w	ioctrl_input-jump_table		;foCXR}h3 _IOCTRLɂ
	.dc.w	input-jump_table		;foCXR}h4 
	.dc.w	control_sense-jump_table	;foCXR}h5 Rg[/ZX
	.dc.w	input_status-jump_table		;foCXR}h6 ̓Xe[^X
	.dc.w	input_flush-jump_table		;foCXR}h7 ̓obt@tbV
	.dc.w	output-jump_table		;foCXR}h8 o(xt@CȂ)
	.dc.w	output-jump_table		;foCXR}h9 o(xt@C)
	.dc.w	output_status-jump_table	;foCXR}h10 o̓Xe[^X
	.dc.w	no_error-jump_table		;foCXR}h11 I
	.dc.w	ioctrl_output-jump_table	;foCXR}h12 _IOCTRLɂo
jump_table_end:
	.dc.w	command_error-jump_table	;͈͊O R}hG[

;foCXR}h1 fBXN`FbN
;foCXR}h2 BPBe[u̍č\z
;R}hG[
command_error:
	move.w	#IGNORE|ABORT|UNKNOWN_COMMAND,d0	;(I) ~(A) foCXhCoɖȃR}hw肵܂
	rts

;foCXR}h3 _IOCTRLɂ
ioctrl_input:
;	movea.l	14(a5),a1		;AhX
	goto	command_error

;foCXR}h4 
input:
	movea.l	14(a5),a1		;AhX
	move.l	18(a5),d3		;
	docontinue
		clr.b	(a1)+
	while	<subq.l #1,d3>,cc
	moveq.l	#0,d0			;ɐ(I܂ŕAȂ)
	rts

;foCXR}h5 Rg[/ZX
control_sense:
	clr.b	13(a5)			;f[^
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h6 ̓Xe[^X
input_status:
	moveq.l	#1,d0			;0=̓obt@ł͂Ȃ̂œ͂ł,1=̓obt@Ȃ̂œ͂łȂ
	rts

;foCXR}h7 ̓obt@tbV
input_flush:
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h8 o(xt@CȂ)
;foCXR}h9 o(xt@C)
output:
;	movea.l	14(a5),a1		;AhX
;	move.l	18(a5),d3		;
	moveq.l	#0,d0			;ɐ(I܂ŕAȂ)
	rts

;foCXR}h10 o̓Xe[^X
output_status:
	moveq.l	#1,d0			;0=o̓obt@tł͂Ȃ̂ŏo͂ł,1=o̓obt@tȂ̂ŏo͂łȂ
	rts

;foCXR}h11 I
no_error:
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h12 _IOCTRLɂo
ioctrl_output:
;	movea.l	14(a5),a1		;AhX
	goto	command_error



;----------------------------------------------------------------
;[NGA
original_exitvc:
	.dc.l	0			;ύXO_EXITVCB0=ύXĂȂ
original_sr:
	.dc.w	0			;ύXOsr
text_area:
	.dc.l	SPRC_TEXT_0		;݂̃eLXgGA0
sprite_max:
	.dc.w	127			;XvCgԍ̍őlB127,255,511,1023
bank_available:
	.dc.b	0			;-1=oN,0=oNȂ
extended_1xx1x:
	.dc.b	1			;%1xx1x̂ƂXvCgʂgpł邩B-1=g,0=gȂ,1=mF
	.even

;----------------------------------------------------------------
;_EXITVC[`
;	_EXITVCpĐevZX_EXEC̒ɏǉ
;	̂܂܂ƐevZX[U[ĥƂX[p[oCÜɂ(foCXhCo̒ɂ)R[hsłȂ
;	evZXsrύXăX[p[pCU[hŒǉ̏sĂύXOsr𕜌
exitvc_routine:
;n
	push	d0-d1/a0
	move.b	cleanup_flag(pc),d0
	if	ne			;n
		moveq.l	#0,d1
		bsr	iocs_C0_SP_INIT
	endif
	pop
;ύXOsr𕜌āAύXO_EXITVC(_EXITVCɒǉꂽȂΐevZX_EXEC̒)փWv
	if	<tst.b BIOS_MPU_TYPE.w>,ne
		clr.w	-(sp)
	endif
	move.l	original_exitvc(pc),-(sp)	;ύXO_EXITVC
	clr.l	original_exitvc
	move.w	original_sr(pc),-(sp)	;ύXOsr
	clr.w	original_sr
	rte

;----------------------------------------------------------------
;XvCgʂgpł邩mF
;	IOCSR[̐擪ŌĂяo
;	XvCgʂgpłƂȂ
;	XvCgʂgpłȂƂd0.l=-1IOCSR[I
;?d0/a0
check_sprite:
	moveq.l	#.not.%10010,d0
	or.b	CRTC_RESOLUTION_BYTE,d0	;R20LB%1xx1x̂Ƃ%11111111
	not.b	d0			;%1xx1x̂Ƃ%00000000
	do
		break	ne			;%1xx1xł͂ȂBgpł
		move.b	extended_1xx1x(pc),d0	;%1xx1x̂ƂXvCgʂgpł邩
		break	mi			;-1=gpł
		if	ne			;1=mF
		;%1xx1x̂ƂXvCgʂgpł邩mF
			moveq.l	#-1,d0
			move.l	OFFSET_BUS_ERROR.w,-(sp)
			movea.l	sp,a0
			move.l	#@f,OFFSET_BUS_ERROR.w
			nop
			move.w	SPRC_SCROLL,d0		;XvCgXN[WX^[hĂ݂
			nop
		@@:	movea.l	a0,sp
			move.l	(sp)+,OFFSET_BUS_ERROR.w
			tst.w	d0			;oXG[XŴƂmiAȂpl
			spl.b	extended_1xx1x		;-1=gpł,0=gpłȂ
			break	pl			;gpł
		endif
		moveq.l	#-1,d0			;XvCgʂgpłȂ
		addq.l	#4,sp			;IOCSR[I
	while	f
	rts

;----------------------------------------------------------------
;VDISP̗҂
vdisp_falling_edge:
	do
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,eq
	do
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,ne
	rts

;----------------------------------------------------------------
;IOCS $C0 _SP_INIT
;	XvCgEobNOEh܂B
;	_SP_INITŊg@\LɂvZXIƂg@\𖳌ɂ܂B
;<d1.l:'SPRD'$53505244=g@\gp
;<d2.l:oN,-1=풓mF
;>d0.l:-3=g@\gpłȂ,-1=XvCgʂgpłȂ,0=I,풓mF̂Ƃ$53xxxxxx
;?a0
iocs_C0_SP_INIT:
	ifand	<cmp.l #'SPRD',d1>,eq,<cmp.l #-1,d2>,eq	;풓mF
		move.l	#VERSION_NUMBER,d0	;o[W
		rts
	endif
	bsr	check_sprite		;XvCgʂgpł邩mF
	push	d1-d7/a1-a4/a6
	lea.l	$00EB8000,a6
EB	reg	-$00EB8000(a6)
;g@\gp^gpȂ
	moveq.l	#-1,d6
	if	<cmp.l #'SPRD',d1>,eq	;g@\gp
		moveq.l	#7,d6
		and.w	d2,d6			;oN
	endif
;<d6.l:-1=g@\gpȂ,0`7=oN
;XvCg̔ԍ̍ől߂
	lea.l	(SPRC_SCROLL)EB,a0	;XvCgXN[WX^XW
	move.w	#1024-1,d7
	do
		move.w	d7,d0			;ԍ
		lsl.w	#3,d0			;8*ԍ
		break	<tst.w (a0,d0.w)>,pl	;ΏI
		lsr.w	#1,d7			;ȂΔɂ
	while	<tst.b d7>,mi		;128-1ŏI
;<d7.w:XvCg̔ԍ̍ől
;d1-d4/a1-a4[ɂ
	moveq.l	#0,d1
  .irp rn,d2,d3,d4,a1,a2,a3,a4
	move.l	d1,rn
  .endm
;XvCgRg[WX^[NA
	move.w	d1,(SPRC_CONTROL)EB
;obNOEhXN[WX^[NA
	movem.l	d1-d2,(SPRC_BG_0_X)EB
;XvCgXN[WX^[NA
	lea.l	(SPRC_SCROLL)EB,a0
	move.w	d7,d0			;XvCg̔ԍ̍őlB127,255,511,1023
	lsr.w	#5-3,d0			;8*Ԃ܂ޖ/32-1B31,63,127,255
	moveq.l	#8*256/32-1,d5
	if	<cmp.w d5,d0>,hi	;256葽Ƃ
		for	d5
			movem.l	d1-d4/a1-a4,(a0)	;256NA
			lea.l	32(a0),a0
		next
		lea.l	8*8(a0),a0		;8΂
		sub.w	#8*(256+8)/32,d0
	endif
	for	d0
		movem.l	d1-d4/a1-a4,(a0)
		lea.l	32(a0),a0
	next
;p^[ƃeLXgGA[NA
	move.w	(SPRC_BANK_NUMBER)EB,d0
	if	mi			;oNȂ
	;p^[ƃeLXgGA[NA
		lea.l	(SPRC_PATTERN)EB,a0
		move.w	#128*256/32-1,d0
		for	d0
			movem.l	d1-d4/a1-a4,(a0)
			lea.l	32(a0),a0
		next
	else				;oN
		lsr.w	#1,d0
		if	cs			;eLXgGAړ
		;eLXgGA[NA
			lea.l	(SPRC_BANK_TEXT_0)EB,a0
			move.w	#2*64*64*2/32-1,d0
			for	d0
				movem.l	d1-d4/a1-a4,(a0)
				lea.l	32(a0),a0
			next
		endif
	;p^[[NA
		moveq.l	#15,d5			;oNԍB15`0BoN0IꂽԂŏI
		for	d5
			move.b	d5,(SPRC_BANK_NUMBER)EB	;oNԍ
			lea.l	(SPRC_PATTERN)EB,a0
			move.w	#128*256/32-1,d0
			for	d0
				movem.l	d1-d4/a1-a4,(a0)
				lea.l	32(a0),a0
			next
		next
	endif
;XvCgpbg
	lea.l	VICON_TSPALET+2*16,a0	;pbgubN1`15
	movem.l	100f(pc),d1-d4/a1-a4	;J[R[h̏l
	bsr	vdisp_falling_edge	;VDISP̗҂
	moveq.l	#15-1,d0
	for	d0
		movem.l	d1-d4/a1-a4,(a0)
		lea.l	32(a0),a0
	next
;g@\gp^gpȂ
	if	<tst.l d6>,mi		;g@\gpȂ
		if	<tst.w (SPRC_BANK_NUMBER)EB>,pl	;oNԍWX^
			clr.l	(SPRC_BANK_CONTROL)EB	;oN䃌WX^ƃoNԍWX^[NA
		endif
		move.l	#SPRC_TEXT_0,text_area	;ړÕeLXgGA
		move.w	#127,sprite_max		;XvCg̔ԍ̍ől
		sf.b	bank_available		;oNȂ
		moveq.l	#0,d0			;I
	elif	<tst.w (SPRC_BANK_NUMBER)EB>,mi	;oNԍWX^Ȃ
		moveq.l	#-3,d0			;g@\gpłȂ
	else				;g@\gp
	;n̏
		move.b	cleanup_flag(pc),d0
		if	ne			;n
			movea.l	DOS_PROCESS_HANDLE.w,a0	;vZXnh
			movea.l	(a0),a0			;s̃vZX̃Ǘ|C^
			lea.l	original_exitvc(pc),a1	;ύXO_EXITVC̃nh
			lea.l	original_sr(pc),a2	;ύXOsr̃nh
			lea.l	exitvc_routine(pc),a3	;ύX_EXITVC
			lea.l	OFFSET_DOS+4*(_EXITVC&$FF).w,a4	;_EXITVC̃nh
			if	<tst.l (a1)>,eq		;o^ĂȂ
				move.l	(a4),(a1)		;_EXITVCۑ
				move.l	a3,(a4)			;_EXITVCύX
				move.l	a3,MM_EXITVC(a0)	;s̃vZX_EXITVCύX
				move.w	MM_SR(a0),(a2)		;s̃vZX̐evZXsrۑ
				ori.w	#$2000,MM_SR(a0)	;s̃vZX̐evZXsrύX
			endif
		endif
	;g@\Lɂ
		move.w	d6,(SPRC_BANK_CONTROL)EB	;oN
		lea.l	(SPRC_TEXT_0)EB,a0	;ړÕeLXgGA
		if	<btst.l #0,d6>,ne
			lea.l	(SPRC_BANK_TEXT_0)EB,a0	;ړ̃eLXgGA
		endif
		move.l	a0,text_area
		move.w	d7,sprite_max		;XvCg̔ԍ̍ől
		st.b	bank_available		;oN
		moveq.l	#0,d0			;I
	endif
	pop
	rts

;J[R[h̏l
100:	dcrgb	0,0,0			;0=
	dcrgb	10,10,10		;1=ÂDF
	dcrgb	0,0,16			;2=Â
	dcrgb	0,0,31			;3=
	dcrgb	16,0,0			;4=Â
	dcrgb	31,0,0			;5=
	dcrgb	16,0,16			;6=Â
	dcrgb	31,0,31			;7=
	dcrgb	0,16,0			;8=Â
	dcrgb	0,31,0			;9=
	dcrgb	0,16,16			;10=ÂF
	dcrgb	0,31,31			;11=F
	dcrgb	16,16,0			;12=ÂF
	dcrgb	31,31,0			;13=F
	dcrgb	21,21,21		;14=邢DF
	dcrgb	31,31,31		;15=

;----------------------------------------------------------------
;IOCS $C1 _SP_ON
;	XvCgʂ\܂B
;>d0.l:-1=XvCgʂgpłȂ,0=I
;?a0
iocs_C1_SP_ON:
	bsr	check_sprite		;XvCgʂgpł邩mF
	ori.w	#VICON_SPON_MASK,VICON_VISIBLE
	ori.w	#SPRC_SPRITE_ON,SPRC_CONTROL
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $C2 _SP_OFF
;	XvCgʂ\܂B
;>d0.l:0=I
iocs_C2_SP_OFF:
	andi.w	#.notw.VICON_SPON_MASK,VICON_VISIBLE
	andi.w	#.notw.SPRC_SPRITE_ON,SPRC_CONTROL
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $C3 _SP_CGCLR
;	p^[[NA܂B
;<d1.w:p^[ԍ
;>d0.l:-1=XvCgʂgpłȂ,0=I
;?a0
iocs_C3_SP_CGCLR:
	bsr	check_sprite		;XvCgʂgpł邩mF
	push	d1
	lea.l	SPRC_PATTERN,a0
	move.b	bank_available(pc),d0
	if	ne			;oN
		move.w	d1,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;oNԍ
	endif
	and.w	#$00FF,d1		;oNp^[ԍ
	lsl.w	#7,d1
	adda.w	d1,a0
	moveq.l	#0,d0
	moveq.l	#128/4-1,d1
	for	d1
		move.l	d0,(a0)+
	next
;	moveq.l	#0,d0			;I
	pop
	rts

;----------------------------------------------------------------
;IOCS $C4 _SP_DEFCG
;	p^[ݒ肵܂B
;	p^[𔽓]@\ǉĂ܂B
;<d1.w:p^[ԍ
;<d2.w[15]:㉺]
;<d2.w[14]:E]
;<d2.b:TCYB0=8x8,1=16x16
;<a1.l:obt@̃AhXB
;>d0.l:-1=XvCgʂgpłȂ,0=I
;?a0
iocs_C4_SP_DEFCG:
	bsr	check_sprite		;XvCgʂgpł邩mF
	push	d1-d2/a1
	lea.l	SPRC_PATTERN,a0
	do
		if	<tst.b d2>,eq		;8x8
			move.b	bank_available(pc),d0
			if	ne			;oN
				move.w	d1,d0
				lsr.w	#2,d0
				move.w	d0,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;oNԍ
			endif
			and.w	#$03FF,d1		;oN8x8p^[ԍ
			lsl.w	#5,d1
			adda.w	d1,a0
			add.w	d2,d2
			if	cc			;㉺]Ȃ
				if	pl			;E]Ȃ
					moveq.l	#8-1,d2
					for	d2
						move.l	(a1)+,(a0)+		;と
					next
					break
				else				;E]
					moveq.l	#8-1,d2
					for	d2
						move.l	(a1)+,d0		;と
						bsr	hexrev
						move.l	d0,(a0)+		;と
					next
					break
				endif
			else				;㉺]
				lea.l	32(a1),a1		;と
				if	pl			;E]Ȃ
					moveq.l	#8-1,d2
					for	d2
						move.l	-(a1),(a0)+		;^と
					next
					break
				else				;E]
					moveq.l	#8-1,d2
					for	d2
						move.l	-(a1),d0		;
						bsr	hexrev
						move.l	d0,(a0)+		;と
					next
					break
				endif
			endif
		else				;16x16
			move.b	bank_available(pc),d0
			if	ne			;oN
				move.w	d1,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;oNԍ
			endif
			and.w	#$00FF,d1		;oN16x16p^[ԍ
			lsl.w	#7,d1
			adda.w	d1,a0
			add.w	d2,d2
			if	cc			;㉺]Ȃ
				if	pl			;E]Ȃ
					moveq.l	#32-1,d2
					for	d2
						move.l	(a1)+,(a0)+		;と=EとE
					next
					break
				else				;E]
					lea.l	64(a1),a1		;とE
					moveq.l	#16-1,d2
					for	d2
						move.l	(a1)+,d0		;EとE
						bsr	hexrev
						move.l	d0,(a0)+		;と=E
					next
					lea.l	-128(a1),a1		;E
					moveq.l	#16-1,d2
					for	d2
						move.l	(a1)+,d0		;と
						bsr	hexrev
						move.l	d0,(a0)+		;=EとE
					next
					break
				endif
			else				;㉺]
				if	pl			;E]Ȃ
					lea.l	64(a1),a1		;と
					moveq.l	#16-1,d2
					for	d2
						move.l	-(a1),(a0)+		;^と=E
					next
					lea.l	128(a1),a1		;とE
					moveq.l	#16-1,d2
					for	d2
						move.l	-(a1),(a0)+		;EE^=EとE
					next
					break
				else				;E]
					lea.l	128(a1),a1		;とE
					moveq.l	#32-1,d2
					for	d2
						move.l	-(a1),d0		;EE=
						bsr	hexrev
						move.l	d0,(a0)+		;と=EとE
					next
				;	break
				endif
			endif
		endif
	while	f
	moveq.l	#0,d0			;I
	pop
	rts

;E]
;<d0.l:p^[
;>d0.l:E]p^[
;?d1
hexrev:
					;d0=ABCDEFGH
	move.l	d0,d1			;d1=ABCDEFGH
	and.l	#$00FF00FF,d1		;d1=00CD00GH
	eor.l	d1,d0			;d0=AB00EF00
	swap.w	d1			;d1=00GH00CD
	or.l	d1,d0			;d0=ABGHEFCD
	move.l	d0,d1			;d1=ABGHEFCD
	and.l	#$0F0F0F0F,d1		;d1=0B0H0F0D
	eor.l	d1,d0			;d0=A0G0E0C0
	rol.l	#8,d1			;d1=0H0F0D0B
	or.l	d1,d0			;d0=AHGFEDCB
	rol.l	#4,d0			;d0=HGFEDCBA
	rts

;----------------------------------------------------------------
;IOCS $C5 _SP_GTPCG
;	p^[擾܂B
;<d1.w:p^[ԍ
;<d2.b:TCYB0=8x8,1=16x16
;<a1.l:obt@̃AhXB
;>d0.l:-1=XvCgʂgpłȂ,0=I
;?a0
iocs_C5_SP_GTPCG:
	bsr	check_sprite		;XvCgʂgpł邩mF
	push	d1-d2/a1
	lea.l	SPRC_PATTERN,a0
	if	<tst.b d2>,eq		;8x8
		move.b	bank_available(pc),d0
		if	ne			;oN
			move.w	d1,d0
			lsr.w	#2,d0
			move.w	d0,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;oNԍ
		endif
		and.w	#$03FF,d1		;oN8x8p^[ԍ
		lsl.w	#5,d1
		moveq.l	#8-1,d2
	else				;16x16
		move.b	bank_available(pc),d0
		if	ne			;oN
			move.w	d1,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;oNԍ
		endif
		and.w	#$00FF,d1		;oN16x16p^[ԍ
		lsl.w	#7,d1
		moveq.l	#32-1,d2
	endif
	adda.w	d1,a0
	for	d2
		move.l	(a0)+,(a1)+
	next
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;IOCS $C6 _SP_REGST
;	XvCgXN[WX^ݒ肵܂B
;	rbgNA܂B
;<d1.l[31]:1=VDISP̗҂Ȃ
;<d1.w:XvCgԍ(A)
;<d2.l[31]:1=XWݒ肵Ȃ
;<d2.w:XW
;<d3.l[31]:1=YWݒ肵Ȃ
;<d3.w:YW
;<d4.l[31]:1=LN^ݒ肵Ȃ
;<d4.w:LN^
;<d5.l[31]:1=vCIeBݒ肵Ȃ
;<d5.w:vCIeB
;>d0.l:-1=XvCgʂgpłȂ,0=I
;?a0
iocs_C6_SP_REGST:
	bsr	check_sprite		;XvCgʂgpł邩mF
	move.w	d1,d0
	and.w	sprite_max(pc),d0	;0`1015/1016`1023
	do
		if	<cmp.w #256,d0>,hs	;256`1015/1016`1023
			addq.w	#8,d0			;264`1023/1024`1031
			break	<cmp.w sprite_max(pc),d0>,hi	;1024`1031
		endif
		lea.l	SPRC_SCROLL,a0
		lsl.w	#3,d0
		adda.w	d0,a0
		if	<tst.l d1>,pl
			bsr	vdisp_falling_edge	;VDISP̗҂
		endif
		if	<tst.l d2>,pl
			move.w	d2,(a0)			;XW
		endif
		if	<tst.l d3>,pl
			move.w	d3,2(a0)		;YW
		endif
		if	<tst.l d4>,pl
			move.w	d4,4(a0)		;LN^
		endif
		if	<tst.l d5>,pl
			moveq.l	#.not.4,d0		;rbgNA
			and.w	d5,d0
			move.w	d0,6(a0)		;vCIeB
		endif
	while	f
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $C7 _SP_REGGT
;	XvCgXN[WX^擾܂B
;<d1.w:XvCgԍ(A)
;>d0.l:-1=XvCgʂgpłȂ,0=I
;>d2.l:XW
;>d3.l:YW
;>d4.l:LN^
;>d5.l:vCIeB
;?a0
iocs_C7_SP_REGGT:
	bsr	check_sprite		;XvCgʂgpł邩mF
	moveq.l	#0,d2
	moveq.l	#0,d3
	moveq.l	#0,d4
	moveq.l	#0,d5
	move.w	d1,d0
	and.w	sprite_max(pc),d0	;0`1015/1016`1023
	do
		if	<cmp.w #256,d0>,hs	;256`1015/1016`1023
			addq.w	#8,d0			;264`1023/1024`1031
			break	<cmp.w sprite_max(pc),d0>,hi	;1024`1031
		endif
		lea.l	SPRC_SCROLL,a0
		lsl.w	#3,d0
		adda.w	d0,a0
		move.w	(a0)+,d2		;XW
		move.w	(a0)+,d3		;YW
		move.w	(a0)+,d4		;LN^
		move.w	(a0)+,d5		;vCIeB
	while	f
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $C8 _BGSCRLST
;	obNOEhXN[WX^ݒ肵܂B
;	sXN[܂͗XN[̐ݒ肪ǉĂ܂B
;
;	<d1.l[31]:1=VDISP̗҂Ȃ
;	<d1.b:obNOEhԍ
;	>d0.l:-1=XvCgʂgpłȂ,0=I
;	?a0
;obNOEh
;	<d1.w[15`8]:0
;	<d2.l[31]:1=XWݒ肵Ȃ
;	<d2.w:XW
;	<d3.l[31]:1=YWݒ肵Ȃ
;	<d3.w:YW
;sXN[
;	<d1.w[15`8]:1
;	<d2.w:sԍ
;	<d3.w:XW
;XN[
;	<d1.w[15`8]:2
;	<d2.w:ԍ
;	<d3.w:YW
iocs_C8_BGSCRLST:
	bsr	check_sprite		;XvCgʂgpł邩mF
	if	<tst.l d1>,pl
		bsr	vdisp_falling_edge	;VDISP̗҂
	endif
	if	<cmp.w #$0100,d1>,lo	;obNOEh
		lea.l	SPRC_BG_0_X,a0
		if	<tst.b d1>,ne
			addq.l	#SPRC_BG_1_X-SPRC_BG_0_X,a0
		endif
		if	<tst.l d2>,pl
			move.w	d2,(a0)			;XW
		endif
		if	<tst.l d3>,pl
			move.w	d3,2(a0)		;YW
		endif
	else				;sXN[܂͗XN[
		lea.l	$00EB2000,a0		;sXN[WX^
		if	<cmp.w #$0200,d1>,hs
			lea.l	$00EB2200-$00EB2000(a0),a0	;XN[WX^
		endif
		if	<tst.b d1>,ne
			lea.l	2*64(a0),a0
		endif
		move.w	d2,d0			;sԍ܂͗ԍ
		add.w	d0,d0
		move.w	d3,(a0,d0.w)		;XW܂YW
	endif
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $C9 _BGSCRLGT
;	obNOEhXN[WX^擾܂B
;	sXN[܂͗XN[̎擾ǉĂ܂B
;
;	<d1.b:obNOEhԍ
;	?a0
;obNOEh
;	<d1.w[15`8]:0
;	>d2.l:XW
;	>d3.l:YW
;	>d0.l:-1=XvCgʂgpłȂ,0=I
;sXN[
;	<d1.w[15`8]:1
;	<d2.w:sԍ
;	>d0.l:-1=XvCgʂgpłȂ,0`1023=XW
;XN[
;	<d1.w[15`8]:2
;	<d2.w:ԍ
;	>d0.l:-1=XvCgʂgpłȂ,0`1023=YW
iocs_C9_BGSCRLGT:
	bsr	check_sprite		;XvCgʂgpł邩mF
	if	<cmp.w #$0100,d1>,lo	;obNOEh
		lea.l	SPRC_BG_0_X,a0
		if	<tst.b d1>,ne
			addq.l	#SPRC_BG_1_X-SPRC_BG_0_X,a0
		endif
		moveq.l	#0,d2
		moveq.l	#0,d3
		move.w	(a0)+,d2		;XW
		move.w	(a0)+,d3		;YW
		moveq.l	#0,d0			;I
	else				;sXN[܂͗XN[
		lea.l	$00EB2000,a0		;sXN[WX^
		if	<cmp.w #$0200,d1>,hs
			lea.l	$00EB2200-$00EB2000(a0),a0	;XN[WX^
		endif
		if	<tst.b d1>,ne
			lea.l	2*64(a0),a0
		endif
		move.w	d2,d0			;sԍ܂͗ԍ
		add.w	d0,d0
		movea.w	(a0,d0.w),a0		;XW܂YW
		move.l	a0,d0
	endif
	rts

;----------------------------------------------------------------
;IOCS $CA _BGCTRLST
;	obNOEh䃌WX^ݒ肵܂B
;<d1.b:obNOEhԍ
;<d2.l[31]:1=eLXgGAԍݒ肵Ȃ
;<d2.b:eLXgGAԍ
;<d3.l[31]:1=\̗Lݒ肵Ȃ
;<d3.b:\̗L
;>d0.l:-1=XvCgʂgpłȂ,0=I
;?a0
iocs_CA_BGCTRLST:
	bsr	check_sprite		;XvCgʂgpł邩mF
	move.w	SPRC_CONTROL,d0
	if	<tst.b d1>,eq		;obNOEh0
		if	<tst.l d2>,pl		;eLXgGAԍݒ肷
			and.w	#.notw.%000_110,d0
			if	<tst.b d2>,ne		;eLXgGA1
				addq.w	#%000_010,d0
			endif
		endif
		if	<tst.l d3>,pl		;\̗Lݒ肷
			and.w	#.notw.%000_001,d0
			if	<tst.b d3>,ne		;\
				addq.w	#%000_001,d0
			endif
		endif
	else				;obNOEh1
		if	<tst.l d2>,pl		;eLXgGAԍݒ肷
			and.w	#.notw.%110_000,d0
			if	<tst.b d2>,ne		;eLXgGA1
				add.w	#%010_000,d0
			endif
		endif
		if	<tst.l d3>,pl		;\̗Lݒ肷
			and.w	#.notw.%001_000,d0
			if	<tst.b d3>,ne		;\
				addq.w	#%001_000,d0
			endif
		endif
	endif
	move.w	d0,SPRC_CONTROL
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $CB _BGCTRLGT
;	obNOEh䃌WX^擾܂
;<d1.b:obNOEhԍ
;>d0.l:-1=XvCgʂgpłȂ,0`7=eLXgGAԍ<<1|\̗L
;?a0
iocs_CB_BGCTRLGT:
	bsr	check_sprite		;XvCgʂgpł邩mF
	moveq.l	#0,d0
	move.w	SPRC_CONTROL,d0
	if	<tst.b d1>,ne
		lsr.w	#3,d0
	endif
	and.w	#%111,d0
	rts

;----------------------------------------------------------------
;IOCS $CC _BGTEXTCL
;	obNOEheLXgLN^Ŗߐs܂B
;	^OtBbNʂ@\ǉĂ܂B
;<d1.w[15`8]:$00=LN^Ŗߐs,$10=^OtBbNʂ
;<d1.b:eLXgGAԍ
;<d2.w:LN^^pbgubN
;>d0.l:-3=g@\gpłȂ,-1=XvCgʂgpłȂ,0=I
;?a0
iocs_CC_BGTEXTCL:
	bsr	check_sprite		;XvCgʂgpł邩mF
	if	<cmp.w #$0FFF,d1>,ls	;LN^
		push	d1-d4/a1-a4
		movea.l	text_area,a0
		if	<tst.b d1>,ne
			lea.l	2*64*64(a0),a0
		endif
		move.w	d2,d0
		swap.w	d2
		move.w	d0,d2
	  .irp rn,d1,d3,d4,a1,a2,a3,a4
		move.l	d2,rn
	  .endm
		move.w	#2*64*64/32-1,d0
		for	d0
			movem.l	d1-d4/a1-a4,(a0)
			lea.l	32(a0),a0
		next
		pop
	else				;^OtBbNʂ
		move.b	bank_available(pc),d0
		if	eq			;oNȂ
			moveq.l	#-3,d0			;g@\gpłȂ
			rts
		endif
		movea.l	text_area,a0
		if	<tst.b d1>,ne
			lea.l	2*64*64(a0),a0
		endif
		moveq.l	#$0F,d0
		and.w	d2,d0			;pbgubN
		lsl.w	#8,d0			;p^[ԍ4bit<<12|pbgubN<<8|p^[ԍ8bit
		do
			do
			  .rept 8
				move.w	d0,(a0)+
				addq.b	#1,d0
			  .endm
			while	cc
			add.w	#1<<12,d0
		while	cc
	endif
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $CD _BGTEXTST
;	obNOEheLXgɃLN^݂܂B
;	^OtBbNʂɏދ@\ǉĂ܂B
;<d1.w[15`8]:$00=LN^,$10=^OtBbNʂ1hbg
;<d1.b:eLXgGAԍ
;<d2.w:XW
;<d3.w:YW
;<d4.w:LN^^pbgR[h
;>d0.l:-3=g@\gpłȂ,-1=XvCgʂgpłȂ,0=I
;?a0
iocs_CD_BGTEXTST:
	bsr	check_sprite		;XvCgʂgpł邩mF
	if	<cmp.w #$0FFF,d1>,ls	;LN^
		movea.l	text_area,a0
		if	<tst.b d1>,ne
			lea.l	2*64*64(a0),a0
		endif
		moveq.l	#63,d0			;00111111
		and.b	d3,d0			;00YYYYYY
		move.b	d0,-(sp)		;00YYYYYY
		move.w	(sp)+,d0		;00YYYYYY........
		move.b	d2,d0			;00YYYYYY..XXXXXX
		add.b	d0,d0			;00YYYYYY.XXXXXX0
		add.b	d0,d0			;00YYYYYYXXXXXX00
		lsr.w	#1,d0			;000YYYYYYXXXXXX0
		move.w	d4,(a0,d0.w)
	else				;^OtBbNʂ1hbg
		move.b	bank_available(pc),d0
		if	eq			;oNȂ
			moveq.l	#-3,d0			;g@\gpłȂ
			rts
		endif
		push	d1-d3
		lea.l	SPRC_PATTERN,a0
		moveq.l	#%00011,d1
		and.w	SPRC_RESOLUTION-SPRC_PATTERN(a0),d1	;TCY
		if	eq			;8x8
			ifand	<cmp.w #511,d2>,ls,<cmp.w #511,d3>,ls	;͈͓
			;512x512hbg̉ʂ64x648x8hbg(32oCg)̃p^[ɕĂ
			;ʍW(%LLLLLLTXX,%BBHHHHYYY)
			;8x8p^[W(%LLLLLL,%BBHHHH) 8x8p^[W(%TXX,%YYY)
			;8x8p^[ԍ%BBHHHHLLLLLL oNԍ%BB oN8x8p^[ԍ%HHHHLLLLLL
			;[hAhX$00EB8000+%HHHHLLLLLLYYYT0 [hrbgԍ%XX00^%1100
				moveq.l	#%111,d0		;d2.w=%LLLLLLTXX
				moveq.l	#%111,d1		;d3.w=%BBHHHHYYY
				and.w	d2,d0			;d0.l=%TXX
				and.w	d3,d1			;d1.l=%YYY
				lsr.w	#3,d2			;d2.w=%LLLLLL
				eor.w	d1,d3			;d3.w=%BBHHHH000
				add.w	d3,d3			;d3.w=%BBHHHH0000
				move.w	d3,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;%BB oNԍ
				and.w	#$00FF,d3		;d3.w=%HHHH0000
				add.w	d3,d3			;d3.w=%HHHH00000
				add.w	d3,d3			;d3.w=%HHHH000000
				or.w	d3,d2			;d2.w=%HHHHLLLLLL oN8x8p^[ԍ
				lsl.w	#3,d2			;d2.w=%HHHHLLLLLL000,x=0
				or.w	d2,d1			;d1.w=%HHHHLLLLLLYYY
				roxr.b	#3,d0			;d0.b=%XX000000,x=T
				addx.w	d1,d1			;d1.w=%HHHHLLLLLLYYYT
				add.w	d1,d1			;d1.w=%HHHHLLLLLLYYYT0
				adda.w	d1,a0			;a0=$00EB8000+%HHHHLLLLLLYYYT0 [hAhX
				lsr.b	#4,d0			;d0.b=%XX00
				eori.b	#%1100,d0		;d0.b=%XX00^%1100 [hrbgԍ
				moveq.l	#%1111,d1
				and.w	d4,d1			;d1.w=%PPPP pbgR[h
				move.w	(a0),d3			;[hǂݏo
				ror.w	d0,d3			;ړÏʒu4bitֈړ
				and.w	#$FFF0,d3		;4bit
				or.w	d1,d3			;4bitɃpbgR[h
				rol.w	d0,d3			;̈ʒuɖ߂
				move.w	d3,(a0)			;[h߂
			endif
		else				;16x16
			ifand	<cmp.w #1023,d2>,ls,<cmp.w #1023,d3>,ls	;͈͓
			;1024x1024hbg̉ʂ64x6416x16hbg(128oCg)̃p^[ɕĂ
			;ʍW(%LLLLLLSTXX,%BBBBHHYYYY)
			;p^[W(%LLLLLL,%BBBBHH) p^[W(%STXX,%YYYY)
			;p^[ԍ%BBBBHHLLLLLL oNԍ%BBBB oNp^[ԍ%HHLLLLLL
			;[hAhX$00EB8000+%HHLLLLLLSYYYYT0 [hrbgԍ%XX00^%1100
				moveq.l	#%1111,d0		;d2.w=%LLLLLLSTXX
				moveq.l	#%1111,d1		;d3.w=%BBBBHHYYYY
				and.w	d2,d0			;d0.l=%STXX
				and.w	d3,d1			;d1.l=%YYYY
				lsr.w	#4,d2			;d2.w=%LLLLLL
				eor.w	d1,d3			;d3.w=%BBBBHH0000
				add.w	d3,d3			;d3.w=%BBBBHH00000
				add.w	d3,d3			;d3.w=%BBBBHH000000,x=0
				move.w	d3,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;%BBBB oNԍ
				and.w	#$00FF,d3		;d3.w=%HH000000
				or.w	d3,d2			;d2.w=%HHLLLLLL oNp^[ԍ
				roxr.b	#4,d0			;d0.b=%TXX00000,x=S
				addx.w	d2,d2			;d2.w=%HHLLLLLLS
				lsl.w	#4,d2			;d2.w=%HHLLLLLLS0000
				or.w	d2,d1			;d1.w=%HHLLLLLLSYYYY
				add.b	d0,d0			;d0.b=%XX000000,x=T
				addx.w	d1,d1			;d1.w=%HHLLLLLLSYYYYT
				add.w	d1,d1			;d1.w=%HHLLLLLLSYYYYT0
				adda.w	d1,a0			;a0=$00EB8000+%HHLLLLLLSYYYYT0 [hAhX
				lsr.b	#4,d0			;d0.b=%XX00
				eori.b	#%1100,d0		;d0.b=%XX00^%1100 [hrbgԍ
				moveq.l	#%1111,d1
				and.w	d4,d1			;d1.w=%PPPP pbgR[h
				move.w	(a0),d3			;[hǂݏo
				ror.w	d0,d3			;ړÏʒu4bitֈړ
				and.w	#$FFF0,d3		;4bit
				or.w	d1,d3			;4bitɃpbgR[h
				rol.w	d0,d3			;̈ʒuɖ߂
				move.w	d3,(a0)			;[h߂
			endif
		endif
		pop
	endif
	moveq.l	#0,d0			;I
	rts

;----------------------------------------------------------------
;IOCS $CE _BGTEXTGT
;	obNOEheLXgLN^ǂݏo܂B
;	^OtBbNʂǂݏo@\ǉĂ܂B
;<d1.w[15`8]:$00=LN^ǂݏo,$10=^OtBbNʂ1hbgǂݏo
;<d1.b:eLXgGAԍ
;<d2.w:XW
;<d3.w:YW
;>d0.l:-3=g@\gpłȂ,-1=XvCgʂgpłȂ,0`65535=LN^^pbgR[h
;?a0
iocs_CE_BGTEXTGT:
	bsr	check_sprite		;XvCgʂgpł邩mF
	if	<cmp.w #$0FFF,d1>,ls	;LN^ǂݏo
		movea.l	text_area,a0
		if	<tst.b d1>,ne
			lea.l	2*64*64(a0),a0
		endif
		moveq.l	#63,d0			;00111111 ŏʃ[hNA
		and.b	d3,d0			;00YYYYYY
		move.b	d0,-(sp)		;00YYYYYY
		move.w	(sp)+,d0		;00YYYYYY........
		move.b	d2,d0			;00YYYYYY..XXXXXX
		add.b	d0,d0			;00YYYYYY.XXXXXX0
		add.b	d0,d0			;00YYYYYYXXXXXX00
		lsr.w	#1,d0			;000YYYYYYXXXXXX0
		move.w	(a0,d0.w),d0
	else				;^OtBbNʂ1hbgǂݏo
		move.b	bank_available(pc),d0
		if	eq			;oNȂ
			moveq.l	#-3,d0			;g@\gpłȂ
			rts
		endif
		push	d1-d3
		lea.l	SPRC_PATTERN,a0
		moveq.l	#0,d0			;͈͊O
		moveq.l	#%00011,d1
		and.w	SPRC_RESOLUTION-SPRC_PATTERN(a0),d1	;TCY
		if	eq			;8x8
			ifand	<cmp.w #511,d2>,ls,<cmp.w #511,d3>,ls	;͈͓
			;512x512hbg̉ʂ64x648x8hbg(32oCg)̃p^[ɕĂ
			;ʍW(%LLLLLLTXX,%BBHHHHYYY)
			;8x8p^[W(%LLLLLL,%BBHHHH) 8x8p^[W(%TXX,%YYY)
			;8x8p^[ԍ%BBHHHHLLLLLL oNԍ%BB oN8x8p^[ԍ%HHHHLLLLLL
			;[hAhX$00EB8000+%HHHHLLLLLLYYYT0 [hrbgԍ%XX00^%1100
				moveq.l	#%111,d0		;d2.w=%LLLLLLTXX
				moveq.l	#%111,d1		;d3.w=%BBHHHHYYY
				and.w	d2,d0			;d0.l=%TXX
				and.w	d3,d1			;d1.l=%YYY
				lsr.w	#3,d2			;d2.w=%LLLLLL
				eor.w	d1,d3			;d3.w=%BBHHHH000
				add.w	d3,d3			;d3.w=%BBHHHH0000
				move.w	d3,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;%BB oNԍ
				and.w	#$00FF,d3		;d3.w=%HHHH0000
				add.w	d3,d3			;d3.w=%HHHH00000
				add.w	d3,d3			;d3.w=%HHHH000000
				or.w	d3,d2			;d2.w=%HHHHLLLLLL oN8x8p^[ԍ
				lsl.w	#3,d2			;d2.w=%HHHHLLLLLL000,x=0
				or.w	d2,d1			;d1.w=%HHHHLLLLLLYYY
				roxr.b	#3,d0			;d0.b=%XX000000,x=T
				addx.w	d1,d1			;d1.w=%HHHHLLLLLLYYYT
				add.w	d1,d1			;d1.w=%HHHHLLLLLLYYYT0
				adda.w	d1,a0			;a0=$00EB8000+%HHHHLLLLLLYYYT0 [hAhX
				lsr.b	#4,d0			;d0.b=%XX00
				eori.b	#%1100,d0		;d0.b=%XX00^%1100 [hrbgԍ
				moveq.l	#%1111,d1
				and.w	d4,d1			;d1.w=%PPPP pbgR[h
				move.w	(a0),d3			;[hǂݏo
				ror.w	d0,d3			;ړÏʒu4bitֈړ
				moveq.l	#$0F,d0
				and.w	d3,d0			;4bitǂݏo
			endif
		else				;16x16
			ifand	<cmp.w #1023,d2>,ls,<cmp.w #1023,d3>,ls	;͈͓
			;1024x1024hbg̉ʂ64x6416x16hbg(128oCg)̃p^[ɕĂ
			;ʍW(%LLLLLLSTXX,%BBBBHHYYYY)
			;p^[W(%LLLLLL,%BBBBHH) p^[W(%STXX,%YYYY)
			;p^[ԍ%BBBBHHLLLLLL oNԍ%BBBB oNp^[ԍ%HHLLLLLL
			;[hAhX$00EB8000+%HHLLLLLLSYYYYT0 [hrbgԍ%XX00^%1100
				moveq.l	#%1111,d0		;d2.w=%LLLLLLSTXX
				moveq.l	#%1111,d1		;d3.w=%BBBBHHYYYY
				and.w	d2,d0			;d0.l=%STXX
				and.w	d3,d1			;d1.l=%YYYY
				lsr.w	#4,d2			;d2.w=%LLLLLL
				eor.w	d1,d3			;d3.w=%BBBBHH0000
				add.w	d3,d3			;d3.w=%BBBBHH00000
				add.w	d3,d3			;d3.w=%BBBBHH000000,x=0
				move.w	d3,SPRC_BANK_NUMBER-SPRC_PATTERN(a0)	;%BBBB oNԍ
				and.w	#$00FF,d3		;d3.w=%HH000000
				or.w	d3,d2			;d2.w=%HHLLLLLL oNp^[ԍ
				roxr.b	#4,d0			;d0.b=%TXX00000,x=S
				addx.w	d2,d2			;d2.w=%HHLLLLLLS
				lsl.w	#4,d2			;d2.w=%HHLLLLLLS0000
				or.w	d2,d1			;d1.w=%HHLLLLLLSYYYY
				add.b	d0,d0			;d0.b=%XX000000,x=T
				addx.w	d1,d1			;d1.w=%HHLLLLLLSYYYYT
				add.w	d1,d1			;d1.w=%HHLLLLLLSYYYYT0
				adda.w	d1,a0			;a0=$00EB8000+%HHLLLLLLSYYYYT0 [hAhX
				lsr.b	#4,d0			;d0.b=%XX00
				eori.b	#%1100,d0		;d0.b=%XX00^%1100 [hrbgԍ
				moveq.l	#%1111,d1
				and.w	d4,d1			;d1.w=%PPPP pbgR[h
				move.w	(a0),d3			;[hǂݏo
				ror.w	d0,d3			;ړÏʒu4bitֈړ
				moveq.l	#$0F,d0
				and.w	d3,d0			;4bitǂݏo
			endif
		endif
		pop
	endif
	rts

;----------------------------------------------------------------
;IOCS $CF _SPALET
;	XvCgpbgݒ܂͎擾܂B
;	pbgubN0͎wł܂B
;<d1.l[31]:1=VDISP̗҂Ȃ
;<d1.b:pbgubN<<4|pbgR[h
;<d2.b:pbgubN(D)
;<d3.l[31]:0=ݒ,1=擾
;<d3.w:J[R[h
;>d0.l:-2=pbgubN0w肳ꂽ,0`65535=ݒÕJ[R[h
;?a0
iocs_CF_SPALET:
	move.b	d2,-(sp)
	moveq.l	#$0F,d0			;ŏʃ[hNA
	and.b	d1,d0			;0<<4|pbgR[h
	lsl.b	#4,d2			;d2̃pbgubN<<4|0
	if	ne			;d2ɃpbgubN
		or.b	d2,d0			;d2̃pbgubN<<4|pbgR[h
	else
		goto	<cmp.b d1,d0>,eq,20f	;d2d1̂ǂɂpbgubNȂ
		move.b	d1,d0		;d1̃pbgubN<<4|pbgR[h
	endif
	lea.l	VICON_TSPALET,a0
	add.w	d0,d0
	adda.w	d0,a0
	if	<tst.l d1>,pl
		bsr	vdisp_falling_edge	;VDISP̗҂
	endif
	move.w	(a0),d0			;擾
	if	<tst.l d3>,pl
		move.w	d3,(a0)			;ݒ
	endif
10:	move.b	(sp)+,d2
	rts

20:	moveq.l	#-2,d0			;pbgubN0w肳ꂽ
	goto	10b

;----------------------------------------------------------------
;foCXhCo̖
device_tail:



dFLAG	reg	d4			;-1=풓ĂȂ,0=풓̓foCXhCo,1=풓̓ubN
aRESI	reg	a2			;풓̃vO̐擪B0=풓ĂȂ
aPREV	reg	a3			;foCXhCoƂď풓ĂƂÕfoCXhCoBȂ΍Ō̃foCXhCo
aSELF	reg	a4			;̃vO̐擪
r	reg	-program_head(aSELF)

;----------------------------------------------------------------
;foCXR}h0 
initialize:
	lea.l	program_head(pc),aSELF	;̃vO̐擪

;IvVmF
	movea.l	18(a5),a0		;̕сB؂0A0,0B擪̓foCXt@C
	do
	while	<tst.b (a0)+>,ne	;foCXt@Cǂݔ΂
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,option_error	;1ڂ-,/łȂ
		move.b	(a0)+,d0		;2
		goto	eq,option_error		;-,/̌ɕȂ
		jbsr	tolower
		if	<cmp.b #'d',d0>,eq	;-d nȂ
			goto	<tst.b (enable_flag)r>,ne,option_error	;-d -e͓ɎwłȂ
			st.b	(disable_flag)r
		elif	<cmp.b #'e',d0>,eq	;-e n
			goto	<tst.b (disable_flag)r>,ne,option_error	;-d -e͓ɎwłȂ
			st.b	(enable_flag)r
		elif	<cmp.b #'q',d0>,eq	;-q Ïl
			st.b	(quiet_flag)r
		else
			goto	option_error
		endif
		tst.b	(a0)+			;̋؂
		goto	ne,option_error		;]ȕ
	start
		move.b	(a0)+,d0		;̈1
	while	ne

;n̐ݒ
	if	<tst.b (disable_flag)r>,ne	;nȂ
		sf.b	(cleanup_flag)r
	elif	<tst.b (enable_flag)r>,ne	;n
		st.b	(cleanup_flag)r
	endif

;xN^ύX
	lea.l	vector_table(pc),a0	;xN^e[u
	bsr	set_vector		;xN^ύX

;sƃ^Cg\
	if	<tst.b (quiet_flag)r>,eq
		jbsr	printcrlf
		lea.l	title_message(pc),a0
		jbsr	print
	endif

;foCXhCo̖ݒ肵ĐI
	move.l	#device_tail,14(a5)	;foCXhCo̖
	moveq.l	#0,d0			;I
	rts

;IvVG[
option_error:

;sƃG[bZ[W\B-q͖
	jbsr	printcrlf
	lea.l	program_colon(pc),a0
	jbsr	print
	lea.l	wrong_message(pc),a0
	jbsr	print

;foCXhCogݍ܂Ȃ
	move.w	#ABORT|MISCELLANEOUS_ERROR,d0	;~(A) G[܂
	rts

;----------------------------------------------------------------
;sJn
execution_start:
	lea.l	program_head(pc),aSELF	;̃vO̐擪

;IvVmF
	lea.l	1(a2),a0		;R}hC
	dostart
		addq.l	#1,a0
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,usage_exit	;1ڂ-,/łȂ
		move.b	(a0)+,d0		;2
		goto	eq,usage_exit		;-,/̌ɕȂ
		jbsr	tolower
		if	<cmp.b #'c',d0>,eq	;-c 풓mF
			gotoor	<tst.b (release_flag)r>,ne,<tst.b (version_flag)r>,ne,usage_exit	;-c -r -v͓ɎwłȂ
			st.b	(check_flag)r
		elif	<cmp.b #'d',d0>,eq	;-d nȂ
			gotoor	<tst.b (enable_flag)r>,ne,<tst.b (release_flag)r>,ne,usage_exit	;-d -e -r͓ɎwłȂ
			st.b	(disable_flag)r
		elif	<cmp.b #'e',d0>,eq	;-e n
			gotoor	<tst.b (disable_flag)r>,ne,<tst.b (release_flag)r>,ne,usage_exit	;-d -e -r͓ɎwłȂ
			st.b	(enable_flag)r
		elif	<cmp.b #'q',d0>,eq	;-q Ïl
			st.b	(quiet_flag)r
		elif	<cmp.b #'r',d0>,eq	;-r 풓
			gotoor	<tst.b (check_flag)r>,ne,<tst.b (version_flag)r>,ne,usage_exit	;-c -r -v͓ɎwłȂ
			gotoor	<tst.b (disable_flag)r>,ne,<tst.b (enable_flag)r>,ne,usage_exit	;-d -e -r͓ɎwłȂ
			st.b	(release_flag)r
		elif	<cmp.b #'v',d0>,eq	;-v o[WmF
			gotoor	<tst.b (check_flag)r>,ne,<tst.b (release_flag)r>,ne,usage_exit	;-c -r -v͓ɎwłȂ
			st.b	(version_flag)r
		else
			goto	usage_exit
		endif
		move.b	(a0),d0			;̕
		break	eq
		jbsr	isspace
		goto	ne,usage_exit		;]ȕ
	start
		jbsr	nextword		;󔒂ǂݔ΂
	while	ne

;X[p[oCU[hֈڍs
	supervisormode
;풓T
	do
	;foCXhCoT
		moveq.l	#0,dFLAG		;풓̓foCXhCo
		movea.l	DOS_HUMAN_MEMORY.w,a0	;Human68k̐擪BO̓X[p[oCUX^bNGA
		move.w	#'NU',d0		;NULfoCXhCo=foCXhCõXg̐擪TBK
		lea.l	DH_NAME(a0),a0
		do
			do
			while	<cmp.w (a0)+,d0>,ne
		whileor	<cmpi.l #'L   ',2-2(a0)>,ne,<cmpi.w #'  ',6-2(a0)>,ne,<cmpi.w #$8024,DH_TYPE-(DH_NAME+2)(a0)>,ne
		lea.l	-(DH_NAME+2)(a0),aRESI	;NULfoCXhCo
		movem.l	DH_NAME(aSELF),d0-d1	;̃foCX
		do
			break2and	<cmp.l DH_NAME(aRESI),d0>,eq,<cmp.l DH_NAME+4(aRESI),d1>,eq	;foCX
			movea.l	aRESI,aPREV		;foCXhCoÕfoCXhCo
			movea.l	DH_NEXT(aRESI),aRESI	;̃foCXhCo
		while	<cmpa.w #-1,aRESI>,ne
	;ubNT
		moveq.l	#1,dFLAG		;풓̓ubN
		movea.l	DOS_HUMAN_MEMORY.w,aRESI	;ubÑXg̐擪
		dostart
			if	<cmpi.b #-1,MM_PARENT(aRESI)>,eq	;풓ĂB͂Ŏ菜
				lea.l	MM_PROGRAM+DH_NAME+8(aRESI),a0	;풓̃foCX̒
				ifand	<cmpa.l MM_TAIL(aRESI),a0>,ls,<cmp.l -(a0),d1>,eq,<cmp.l -(a0),d0>,eq	;ĂăfoCX
					lea.l	MM_PROGRAM(aRESI),aRESI	;풓̃vO̐擪
					break2
				endif
			endif
		start
			movea.l MM_NEXT(aRESI),aRESI	;̃Ǘe[u
		while	<cmpa.w #0,aRESI>,ne
		moveq.l	#-1,dFLAG		;풓ĂȂ
	while	f
;<dFLAG.l:-1=풓ĂȂ,0=풓̓foCXhCo,1=풓̓ubN
;<aRESI.l:풓̃vO̐擪B0=풓ĂȂ
;<aPREV.l:foCXhCoƂď풓ĂƂÕfoCXhCoBȂ΍Ō̃foCXhCo

;o[WmF
	if	<tst.b (version_flag)r>,ne	;o[WmF
		moveq.l	#1,d1			;^Cg
		moveq.l	#0,d2			;I
		goto	message_exit
	endif

;풓mF
	if	<tst.b (check_flag)r>,ne	;풓mF
		moveq.l	#2+4,d1			;vOƃbZ[W
		moveq.l	#2,d2			;G[IB풓Ă܂
		lea.l	already_message(pc),a1	;풓Ă܂
		if	<tst.l dFLAG>,mi	;풓ĂȂ
			moveq.l	#3,d2			;G[IB풓Ă܂
			lea.l	not_yet_message(pc),a1	;풓Ă܂
		endif
		goto	message_exit
	endif

;n̐ݒ
	if	<tst.b (disable_flag)r>,ne	;nȂ
		sf.b	(cleanup_flag)r
	elif	<tst.b (enable_flag)r>,ne	;n
		st.b	(cleanup_flag)r
	endif

;
	if	<tst.b (release_flag)r>,ne	;

	;풓ĂȂ̂ɉ悤ƂG[
		if	<tst.l dFLAG>,mi	;풓ĂȂ
			moveq.l	#2+4,d1			;vOƃbZ[W
			moveq.l	#3,d2			;G[IB풓Ă܂
			lea.l	not_yet_message(pc),a1	;풓Ă܂
			goto	message_exit
		endif

	;xN^ύXĂG[
		lea.l	(vector_table-program_head)(aRESI),a0	;풓̃xN^e[u
		bsr	check_vector		;xN^mF
		if	ne			;xN^ύXĂ
			moveq.l	#2+4,d1			;vOƃbZ[W
			moveq.l	#4,d2			;G[IBxN^ύXĂ܂Bł܂
			lea.l	vector_message(pc),a1	;xN^ύXĂ܂Bł܂
			goto	message_exit
		endif

	;
		moveq.l	#0,d1
		bsr	iocs_C0_SP_INIT

	;xN^𕜌
		lea.l	(vector_table-program_head)(aRESI),a0	;풓̃xN^e[u
		bsr	release_vector		;xN^𕜌

	;foCXhCo؂藣^ubNJ
		if	<tst.l dFLAG>,eq	;풓̓foCXhCo
			move.l	DH_NEXT(aRESI),DH_NEXT(aPREV)	;ÕfoCXhCo̎̃foCXhCõ͎foCXhCo(-1܂)
		else				;풓̓ubN
			pea.l	MM_SIZE-MM_PROGRAM(aRESI)	;풓̃ubN̐擪
			DOS	_MFREE
			addq.l	#4,sp
		endif

	;I
		moveq.l	#2+4,d1			;vOƃbZ[W
		moveq.l	#0,d2			;I
		lea.l	released_message(pc),a1	;܂
		goto	message_exit

	endif

;풓Ă̂ɏ풓悤ƂG[
	if	<tst.l dFLAG>,pl	;풓Ă
	;ݒύX
		ifor	<tst.b (disable_flag)r>,ne,<tst.b (enable_flag)r>,ne
			move.b	(cleanup_flag)r,cleanup_flag-program_head(aRESI)
			lea.l	disabled_message(pc),a0	;nȂ
			if	ne			;n
				lea.l	enabled_message(pc),a0	;n
			endif
			moveq.l	#2+4,d1			;vOƃbZ[W
			moveq.l	#0,d2			;I
			goto	message_exit
		endif
		moveq.l	#2+4,d1			;vOƃbZ[W
		moveq.l	#2,d2			;G[IB풓Ă܂
		lea.l	already_message(pc),a1	;풓Ă܂
		goto	message_exit
	endif

;xN^ύX
	lea.l	vector_table(pc),a0	;xN^e[u
	bsr	set_vector		;xN^ύX

;foCXhCoڑ
;	move.l	aSELF,(aPREV)		;Ō̃foCXhCo̎̃foCXhCoɂ

;
	moveq.l	#0,d1
	bsr	iocs_C0_SP_INIT

;풓I
	moveq.l	#1+2+4,d1		;^CgƃvOƃbZ[W
	moveq.l	#-1,d2			;풓I
	lea.l	resident_message(pc),a1	;풓܂
	goto	message_exit

;[U[h֕AďI
;<d1.l:1=^Cg\,2=vO\,4=bZ[W\
;<d2.w:IR[hB-1=풓I,0=I,1`=G[I
;<a1.l:bZ[W
message_exit:
;[U[h֕A
	usermode
	if	<tst.b (quiet_flag)r>,eq
		if	<btst.l #0,d1>,ne	;^Cg\
			lea.l	title_message(pc),a0
			jbsr	print
		endif
		if	<btst.l #1,d1>,ne	;vO\
			lea.l	program_colon(pc),a0
			jbsr	print
		endif
		if	<btst.l #2,d1>,ne	;bZ[W\
			movea.l	a1,a0
			jbsr	print
		endif
	endif
;I
	if	<tst.w d2>,mi		;풓I
		clr.w	-(sp)
		move.l	#device_tail-program_head,-(sp)
		DOS	_KEEPPR
	endif
	move.w	d2,-(sp)
	DOS	_EXIT2

;^CgƎgp@\ďI
usage_exit:
;^CgƎgp@\B-q͖
	lea.l	title_message(pc),a0
	jbsr	print
	lea.l	usage_message(pc),a0
	jbsr	print
;I
	move.w	#1,-(sp)
	DOS	_EXIT2

;----------------------------------------------------------------
;xN^ύX
;	X[p[oCU[hŌĂяo
;<a0.l:xN^e[u
set_vector:
	push	d0/a0-a1
	dostart
		movea.w	d0,a1			;ItZbg
		move.l	(a1),d0
		move.l	(a0)+,(a1)		;VxN^
		move.l	d0,(a0)+		;ÂxN^
	start
		move.w	(a0)+,d0
	while	ne
	pop
	rts

;----------------------------------------------------------------
;xN^mF
;	X[p[oCU[hŌĂяo
;<a0.l:풓̃xN^e[u
;>ccr:eq=xN^͕ύXĂȂ,ne=xN^ύXĂ
check_vector:
	push	d0/a0-a1
	dostart
		movea.w	d0,a1			;ItZbg
		move.l	(a1),d0
		break	<cmp.l (a0)+,d0>,ne	;VxN^݂̃xN^ƈvȂΎs
		addq.l	#4,a0			;ÂxN^ǂݔ΂
	start
		move.w	(a0)+,d0
	while	ne
	pop
	rts

;----------------------------------------------------------------
;xN^𕜌
;	X[p[oCU[hŌĂяo
;<a0.l:풓̃xN^e[u
release_vector:
	push	d0/a0-a1
	dostart
		movea.w	d0,a1			;ItZbg
		addq.l	#4,a0			;VxN^ǂݔ΂
		move.l	(a0)+,(a1)		;ÂxN^
	start
		move.w	(a0)+,d0
	while	ne
	pop
	rts

;----------------------------------------------------------------
;
  .if ENGLISH
title_message:
	.dc.b	ENGLISH_TITLE,' ',VERSION_STRING,13,10,0
program_colon:
	.dc.b	PROGRAMEN_NAME,': ',0
usage_message:
	.dc.b	'  device = ',PROGRAM_NAME,' <option>',13,10
	.dc.b	'    or',13,10
	.dc.b	'  A>',PROGRAM_NAME,' <option>',13,10
	.dc.b	'    -c    Resident check',10
	.dc.b	'    -d    Disable cleanup',10
	.dc.b	'    -e    Enable cleanup',10
	.dc.b	'    -q    Quiet',13,10
	.dc.b	'    -r    Release',13,10
	.dc.b	'    -v    Version check',13,10,0
wrong_message:
	.dc.b	'Wrong option',13,10,0
already_message:
	.dc.b	'Already resident',13,10,0
resident_message:
	.dc.b	'Resident',13,10,0
not_yet_message:
	.dc.b	'Not yet resident',13,10,0
vector_message:
	.dc.b	'Vector has been changed, unable to release',13,10,0
released_message:
	.dc.b	'Released',13,10,0
disabled_message:
	.dc.b	'Cleanup is disabled',13,10,0
enabled_message:
	.dc.b	'Cleanup is enabled',13,10,0
  .else
title_message:
	.dc.b	JAPANESE_TITLE,' ',VERSION_STRING,13,10,0
program_colon:
	.dc.b	PROGRAM_NAME,': ',0
usage_message:
	.dc.b	'  device = ',PROGRAM_NAME,' <IvV>',13,10
	.dc.b	'    ܂',13,10
	.dc.b	'  A>',PROGRAM_NAME,' <IvV>',13,10
	.dc.b	'    -c    풓mF',13,10
	.dc.b	'    -d    nȂ',10
	.dc.b	'    -e    n',10
	.dc.b	'    -q    Ïl',13,10
	.dc.b	'    -r    풓',13,10
	.dc.b	'    -v    o[WmF',13,10,0
wrong_message:
	.dc.b	'IvVႢ܂',13,10,0
already_message:
	.dc.b	'풓Ă܂',13,10,0
resident_message:
	.dc.b	'풓܂',13,10,0
not_yet_message:
	.dc.b	'풓Ă܂',13,10,0
vector_message:
	.dc.b	'xN^ύXĂ܂Bł܂',13,10,0
released_message:
	.dc.b	'܂',13,10,0
disabled_message:
	.dc.b	'nȂ',13,10,0
enabled_message:
	.dc.b	'n',13,10,0
  .endif
	.even

	.data

;----------------------------------------------------------------
;tO
check_flag:
	.dc.b	0			;-c 풓mF
disable_flag:
	.dc.b	0			;-d nȂ
enable_flag:
	.dc.b	0			;-e n
quiet_flag:
	.dc.b	0			;-q Ïl
release_flag:
	.dc.b	0			;-r 풓
version_flag:
	.dc.b	0			;-v o[WmF
	.even



	.text
	.even

;----------------------------------------------------------------
;󔒕 \s
;<d0.b:
;>z:eq=󔒕,ne=󔒕ł͂Ȃ(0܂)
isspace::
	if	<cmp.b #' ',d0>,ne
		ifand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\r
			cmp.b	d0,d0
		endif
	endif
	rts

;----------------------------------------------------------------
;󔒂ǂݔ΂
;<a0.l:
;>d0.l:ŏ̋󔒈ȊO̕܂0
;>a0.l:ŏ̋󔒈ȊO̕܂0̈ʒu
;>z:ne=󔒈ȊO̕,eq=󔒈ȊO̕Ȃ
nextword::
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		break	eq			;0ȂΏI
		jbsr	isspace			;󔒂
	while	eq			;󔒂ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

;----------------------------------------------------------------
;\
;<a0.l:
print::
	push	d0
	jbsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	(10,sp),sp
	pop
	rts

;----------------------------------------------------------------
;s\
printcrlf::
	move.l	a0,-(sp)
	lea.l	100f(pc),a0		;13,10
	jbsr	print
	movea.l	(sp)+,a0
	rts

100:	.dc.b	13,10,0
	.even

;----------------------------------------------------------------
;r
;<a0.l:0
;<a1.l:1
;>ccr:eq=0==1,lo=0<1,hi=1<0
strcmp::
	push	d0/a0-a1
	do
		move.b	(a0)+,d0
		if	eq
			cmp.b	(a1)+,d0
			break
		endif
		cmp.b	(a1)+,d0
	while	eq
	pop
	rts

;----------------------------------------------------------------
;̒𐔂
;<a0.l:
;>d0.l:
strlen::
	move.l	a0,d0			;d0=擪
	do
	while	<tst.b (a0)+>,ne		;0̎̈ʒu܂Ői
	subq.l	#1,a0			;i݉߂߂Ba0=0̈ʒu
	exg.l	d0,a0			;d0=,a0=擪
	sub.l	a0,d0			;d0=-擪=
	rts

;----------------------------------------------------------------
;ɂ
;<d0.b:
;>d0.b:
tolower::
	ifand	<cmp.b #'A',d0>,hs,<cmp.b #'Z',d0>,ls	;啶
		add.b	#'a'-'A',d0		;ɂ
	endif
	rts



;----------------------------------------------------------------
;vO̖
	.bss
	.even
program_end:

	.end	execution_start
