/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import xeij.ADPCM;
import xeij.ComponentFactory;
import xeij.CyberStickAnalog;
import xeij.CyberStickDigital;
import xeij.DummyPad;
import xeij.Joystick;
import xeij.MegaDrive3ButtonPad;
import xeij.MegaDrive6ButtonPad;
import xeij.Multilingual;
import xeij.Normal2ButtonPad;
import xeij.RestorableFrame;
import xeij.Settings;
import xeij.Shiromadokun;
import xeij.XEiJ;
import xeij.XInput;

public class PPI {
    public static final int PPI_PORT_A = 15310849;
    public static final int PPI_PORT_B = 15310851;
    public static final int PPI_PORT_C = 15310853;
    public static final int PPI_CONTROL = 15310855;
    public static Joystick[] ppiJoysticks;
    public static Joystick ppiJoystick1;
    public static Joystick ppiJoystick2;
    public static boolean ppiJoyKey;
    public static boolean ppiJoyAuto;
    public static boolean ppiJoyBlock;
    public static int ppiPortCData;
    public static final long PPI_CONTINUOUS_ACCESS_SPAN = 100000000000L;
    public static long ppiLastAccessTime;
    public static final boolean PPI_XINPUT_ON = true;
    public static boolean ppiXInputOn;
    public static XInput ppiXInput;
    public static int ppiXInputLastButtons;
    public static JFrame ppiFrame;
    public static JScrollPane ppiConfigurationScrollPane;

    public static void ppiInit() {
        ppiJoyKey = Settings.sgsGetOnOff("joykey");
        ppiJoyAuto = Settings.sgsGetOnOff("joyauto");
        ppiJoyBlock = Settings.sgsGetOnOff("joyblock");
        ppiJoysticks = new Joystick[]{new DummyPad(), new Normal2ButtonPad(1), new Normal2ButtonPad(2), new MegaDrive3ButtonPad(1), new MegaDrive3ButtonPad(2), new MegaDrive6ButtonPad(1), new MegaDrive6ButtonPad(2), new CyberStickAnalog(1), new CyberStickAnalog(2), new CyberStickDigital(1), new CyberStickDigital(2), new Shiromadokun(1), new Shiromadokun(2)};
        String string = Settings.sgsGetString("joystick1");
        ppiJoystick1 = ppiJoysticks[0];
        for (Joystick joystick : ppiJoysticks) {
            if (!joystick.getId().equalsIgnoreCase(string)) continue;
            ppiJoystick1 = joystick;
        }
        String string2 = Settings.sgsGetString("joystick2");
        ppiJoystick2 = ppiJoysticks[0];
        for (Joystick joystick : ppiJoysticks) {
            if (!joystick.getId().equalsIgnoreCase(string2)) continue;
            ppiJoystick2 = joystick;
        }
        boolean bl = ppiXInputOn = XEiJ.prgIsWindows && Settings.sgsGetOnOff("xinput");
        if (ppiXInputOn) {
            PPI.ppiXInputStart();
        }
        ppiXInputLastButtons = 0;
        PPI.ppiReset();
    }

    public static void ppiTini() {
        Settings.sgsPutOnOff("joykey", ppiJoyKey);
        Settings.sgsPutOnOff("joyauto", ppiJoyAuto);
        Settings.sgsPutOnOff("joyblock", ppiJoyBlock);
        for (Joystick joystick : ppiJoysticks) {
            joystick.tini();
        }
        Settings.sgsPutString("joystick1", ppiJoystick1.getId());
        Settings.sgsPutString("joystick2", ppiJoystick2.getId());
        Settings.sgsPutOnOff("xinput", ppiXInputOn);
        if (ppiXInputOn) {
            ppiXInputOn = false;
            PPI.ppiXInputEnd();
        }
    }

    public static void ppiReset() {
        ppiPortCData = 0;
        ppiLastAccessTime = 0L;
    }

    public static void ppiXInputStart() {
        if (ppiXInput == null) {
            System.out.println(Multilingual.mlnJapanese ? "XInput \u306e\u30dd\u30fc\u30ea\u30f3\u30b0\u3092\u958b\u59cb\u3057\u307e\u3059" : "Starts polling XInput");
            ppiXInput = new XInput();
        }
    }

    public static void ppiXInputEnd() {
        if (ppiXInput != null) {
            System.out.println(Multilingual.mlnJapanese ? "XInput \u306e\u30dd\u30fc\u30ea\u30f3\u30b0\u3092\u7d42\u4e86\u3057\u307e\u3059" : "Ends polling XInput");
            ppiXInput.end();
            ppiXInput = null;
        }
    }

    public static void ppiStart() {
        if (RestorableFrame.rfmGetOpened("ppi")) {
            PPI.ppiOpen();
        }
    }

    public static void ppiOpen() {
        if (ppiFrame == null) {
            PPI.ppiMakeFrame();
        }
        XEiJ.pnlExitFullScreen(false);
        ppiFrame.setVisible(true);
    }

    public static void ppiMakeFrame() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Consider part of keyboard as joystick": {
                        ppiJoyKey = ((JCheckBox)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Enabled only while the port is read repeatedly": {
                        ppiJoyAuto = ((JCheckBox)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "Remove key input data processed as a joystick operation": {
                        ppiJoyBlock = ((JCheckBox)actionEvent.getSource()).isSelected();
                        break;
                    }
                    case "XInput": {
                        if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                            if (ppiXInputOn) break;
                            ppiXInputOn = true;
                            PPI.ppiXInputStart();
                            break;
                        }
                        if (!ppiXInputOn) break;
                        ppiXInputOn = false;
                        PPI.ppiXInputEnd();
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Joystick joystick = ppiJoysticks[Integer.parseInt(actionEvent.getActionCommand())];
                if (ppiJoystick1 != joystick) {
                    ppiJoystick1.reset();
                    ppiJoystick1 = joystick;
                }
                ppiConfigurationScrollPane.setViewportView(joystick.getConfigurationPanel());
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Joystick joystick = ppiJoysticks[Integer.parseInt(actionEvent.getActionCommand())];
                if (ppiJoystick2 != joystick) {
                    ppiJoystick2.reset();
                    ppiJoystick2 = joystick;
                }
                ppiConfigurationScrollPane.setViewportView(joystick.getConfigurationPanel());
            }
        };
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Port"), "ja", "\u30dd\u30fc\u30c8"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Connect to"), "ja", "\u63a5\u7d9a"));
        arrayList.add("1");
        arrayList.add("2");
        arrayList.add(ComponentFactory.createHorizontalSeparator());
        for (int i = 0; i < ppiJoysticks.length; ++i) {
            Joystick joystick = ppiJoysticks[i];
            arrayList.add(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroup, joystick == ppiJoystick1, String.valueOf(i), actionListener2), ""));
            arrayList.add(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroup2, joystick == ppiJoystick2, String.valueOf(i), actionListener3), ""));
            arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel(joystick.getNameEn()), "ja", joystick.getNameJa()));
        }
        JScrollPane jScrollPane = new JScrollPane(ComponentFactory.createGridPanel(3, 3 + ppiJoysticks.length, "paddingLeft=3,paddingRight=3,center", "", "italic;italic;colSpan=3,widen", "colSpan=2;rowSpan=2", arrayList.toArray(new Object[0])));
        ppiConfigurationScrollPane = new JScrollPane((ppiJoystick1 instanceof DummyPad && !(ppiJoystick2 instanceof DummyPad) || !(ppiJoystick1 instanceof Shiromadokun) && ppiJoystick2 instanceof Shiromadokun ? ppiJoystick2 : ppiJoystick1).getConfigurationPanel());
        ppiFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("ppi", "Joystick port settings", null, ComponentFactory.setEmptyBorder(ComponentFactory.createVerticalBox(!XEiJ.prgIsWindows ? null : ComponentFactory.createFlowPanel(ComponentFactory.createCheckBox(ppiXInputOn, "XInput", actionListener)), !XEiJ.prgIsWindows ? null : ComponentFactory.createHorizontalSeparator(), ComponentFactory.createFlowPanel(Multilingual.mlnText(ComponentFactory.createCheckBox(ppiJoyKey, "Consider part of keyboard as joystick", actionListener), "ja", "\u30ad\u30fc\u30dc\u30fc\u30c9\u306e\u4e00\u90e8\u3092\u30b8\u30e7\u30a4\u30b9\u30c6\u30a3\u30c3\u30af\u3068\u307f\u306a\u3059")), ComponentFactory.createFlowPanel(Multilingual.mlnText(ComponentFactory.createCheckBox(ppiJoyAuto, "Enabled only while the port is read repeatedly", actionListener), "ja", "\u30dd\u30fc\u30c8\u304c\u7e70\u308a\u8fd4\u3057\u8aad\u307f\u51fa\u3055\u308c\u3066\u3044\u308b\u9593\u3060\u3051\u6709\u52b9")), ComponentFactory.createFlowPanel(Multilingual.mlnText(ComponentFactory.createCheckBox(ppiJoyBlock, "Remove key input data processed as a joystick operation", actionListener), "ja", "\u30b8\u30e7\u30a4\u30b9\u30c6\u30a3\u30c3\u30af\u64cd\u4f5c\u3068\u3057\u3066\u51e6\u7406\u3055\u308c\u305f\u30ad\u30fc\u5165\u529b\u30c7\u30fc\u30bf\u3092\u53d6\u308a\u9664\u304f")), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(ComponentFactory.createHorizontalSplitPane(jScrollPane, ppiConfigurationScrollPane))), 5, 5, 5, 5)), "ja", "\u30b8\u30e7\u30a4\u30b9\u30c6\u30a3\u30c3\u30af\u30dd\u30fc\u30c8\u8a2d\u5b9a");
    }

    public static boolean ppiInput(KeyEvent keyEvent, boolean bl) {
        boolean bl2 = false;
        if (ppiJoyKey && (!ppiJoyAuto || XEiJ.mpuClockTime < ppiLastAccessTime + 100000000000L) && (ppiJoystick1.input(keyEvent, bl) || ppiJoystick2.input(keyEvent, bl))) {
            bl2 = bl && ppiJoyBlock;
        }
        return bl2;
    }

    public static int ppiReadByte(int n) {
        return switch (n & 7) {
            case 1 -> {
                if (XEiJ.regOC >> 6 != 296) {
                    ppiLastAccessTime = XEiJ.mpuClockTime;
                }
                yield ppiJoystick1.readByte() & 0xFF;
            }
            case 3 -> {
                if (XEiJ.regOC >> 6 != 296) {
                    ppiLastAccessTime = XEiJ.mpuClockTime;
                }
                yield ppiJoystick2.readByte() & 0xFF;
            }
            case 5 -> ppiPortCData;
            default -> 255;
        };
    }

    public static void ppiWriteByte(int n, int n2) {
        n2 &= 0xFF;
        switch (n & 7) {
            case 1: {
                ppiJoystick1.writeByte(n2);
                break;
            }
            case 3: {
                ppiJoystick2.writeByte(n2);
                break;
            }
            case 5: {
                ppiPortCData = n2;
                ADPCM.pcmSetPan(n2);
                ADPCM.pcmDivider = n2 >> 2 & 3;
                ADPCM.pcmUpdateRepeatInterval();
                ppiJoystick1.setPin8(n2 >> 4 & 1);
                ppiJoystick2.setPin8(n2 >> 5 & 1);
                ppiJoystick1.setPin6(n2 >> 6 & 1 ^ 1);
                ppiJoystick1.setPin7(n2 >> 7 & 1 ^ 1);
                break;
            }
            case 7: {
                if ((n2 & 0x80) == 0) {
                    int n3 = n2 >> 1 & 7;
                    int n4 = n2 & 1;
                    ppiPortCData = ppiPortCData & ~(1 << n3) | n4 << n3;
                    if (n3 < 4) {
                        switch (n3) {
                            case 0: 
                            case 1: {
                                ADPCM.pcmSetPan(ppiPortCData & 3);
                                break;
                            }
                            case 2: 
                            case 3: {
                                ADPCM.pcmDivider = ppiPortCData >> 2 & 3;
                                ADPCM.pcmUpdateRepeatInterval();
                            }
                        }
                        break;
                    }
                    switch (n3) {
                        case 4: {
                            ppiJoystick1.setPin8(n4);
                            break;
                        }
                        case 5: {
                            ppiJoystick2.setPin8(n4);
                            break;
                        }
                        case 6: {
                            ppiJoystick1.setPin6(n4 ^ 1);
                            break;
                        }
                        case 7: {
                            ppiJoystick1.setPin7(n4 ^ 1);
                        }
                    }
                    break;
                }
                if ((n2 & 0x84) != 128) break;
            }
        }
    }
}

