/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.util.Arrays;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.XEiJ;

public class Hex8Spinner
extends JSpinner
implements ChangeListener,
DocumentListener {
    public Hex8SpinnerModel model;
    public JTextField editor;

    public Hex8Spinner(int n, int n2, boolean bl) {
        this.model = new Hex8SpinnerModel(n, n2, bl);
        this.editor = new JTextField(XEiJ.fmtHex8(n & n2), 8);
        this.editor.setHorizontalAlignment(4);
        AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
        abstractDocument.setDocumentFilter(new Hex8DocumentFilter(n2));
        this.setBorder(new LineBorder(new Color(LnF.lnfRGB[10]), 1));
        ComponentFactory.setFixedSize(this, 32 + LnF.lnfFontSize * 2 / 3 * 8, LnF.lnfFontSize + 4);
        this.setModel(this.model);
        this.setEditor(this.editor);
        this.model.addChangeListener(this);
        abstractDocument.addDocumentListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.editor.setText(XEiJ.fmtHex8(this.model.getIntValue()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.model.setIntValue((int)Long.parseLong(this.editor.getText(), 16));
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public int getIntValue() {
        return this.model.getIntValue();
    }

    public void setIntValue(int n) {
        this.model.setIntValue(n);
    }

    public int getAbsoluteValue() {
        return this.model.getAbsoluteValue();
    }

    public void setAbsoluteValue(int n) {
        this.model.setAbsoluteValue(n);
    }

    public void setHintArray(int[] nArray, int n) {
        this.model.setHintArray(nArray, n);
    }

    public int getHintIndex() {
        return this.model.getHintIndex();
    }

    public void setHintIndex(int n) {
        this.model.setHintIndex(n);
    }

    public void setOffset(int n) {
        this.model.setOffset(n);
    }

    public static class Hex8SpinnerModel
    extends AbstractSpinnerModel {
        public int value;
        public int mask;
        public boolean reverse;
        public int[] hintArray;
        public int hintCount;
        public int hintIndex;
        public int offset;

        public Hex8SpinnerModel(int n, int n2, boolean bl) {
            this.value = n & n2;
            this.mask = n2;
            this.reverse = bl;
            this.hintArray = new int[0];
            this.hintCount = 0;
            this.hintIndex = -1;
            this.offset = 0;
        }

        @Override
        public Object getNextValue() {
            if (this.reverse) {
                return this.hintCount < 0 || this.hintIndex < 0 ? (this.value & this.mask) - 1 & this.mask : (this.hintIndex == 0 ? this.value : this.hintArray[this.hintIndex - 1] - this.offset);
            }
            return this.hintCount < 0 || this.hintIndex < 0 ? (this.value | ~this.mask) + 1 & this.mask : (this.hintIndex == this.hintCount - 1 ? this.value : this.hintArray[this.hintIndex + 1] - this.offset);
        }

        @Override
        public Object getPreviousValue() {
            if (this.reverse) {
                return this.hintCount < 0 || this.hintIndex < 0 ? (this.value | ~this.mask) + 1 & this.mask : (this.hintIndex == this.hintCount - 1 ? this.value : this.hintArray[this.hintIndex + 1] - this.offset);
            }
            return this.hintCount < 0 || this.hintIndex < 0 ? (this.value & this.mask) - 1 & this.mask : (this.hintIndex == 0 ? this.value : this.hintArray[this.hintIndex - 1] - this.offset);
        }

        @Override
        public Object getValue() {
            return XEiJ.fmtHex8(this.getIntValue());
        }

        @Override
        public void setValue(Object object) {
            this.setIntValue(object instanceof Integer ? (Integer)object : (object instanceof String ? (int)Long.parseLong((String)object, 16) : 0));
        }

        public int getIntValue() {
            return this.value;
        }

        public void setIntValue(int n) {
            if (this.value != (n &= this.mask)) {
                this.value = n;
                this.hintIndex = Arrays.binarySearch(this.hintArray, 0, this.hintCount, this.value + this.offset);
                this.fireStateChanged();
            }
        }

        public int getAbsoluteValue() {
            return this.getIntValue() + this.offset;
        }

        public void setAbsoluteValue(int n) {
            this.setIntValue(n - this.offset);
        }

        public void setHintArray(int[] nArray, int n) {
            if (this.hintArray == null || this.hintArray.length < n) {
                this.hintArray = new int[n];
            }
            System.arraycopy(nArray, 0, this.hintArray, 0, n);
            this.hintCount = n;
            this.hintIndex = Arrays.binarySearch(this.hintArray, 0, this.hintCount, this.value + this.offset);
        }

        public int getHintIndex() {
            return this.hintIndex;
        }

        public void setHintIndex(int n) {
            if (0 <= n && n < this.hintCount && this.hintIndex != n) {
                this.hintIndex = n;
                int n2 = this.hintArray[n] - this.offset;
                if (this.value != n2) {
                    this.value = n2;
                    this.fireStateChanged();
                }
            }
        }

        public void setOffset(int n) {
            if (this.offset != (n &= this.mask)) {
                this.value += this.offset - n;
                this.offset = n;
                this.fireStateChanged();
            }
        }
    }

    public static class Hex8DocumentFilter
    extends DocumentFilter {
        public int mask;
        public char[] buffer;

        public Hex8DocumentFilter(int n) {
            this.mask = n;
            this.buffer = new char[8];
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            this.replace(filterBypass, n, 0, string, attributeSet);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            n2 = string.length();
            int n3 = n;
            for (int i = 0; n < 8 && i < n2; ++i) {
                int n4 = Character.digit(string.charAt(i), 16);
                if (n4 < 0) continue;
                this.buffer[n] = XEiJ.fmtHexc(this.mask >>> (7 - n) * 4 & n4);
                ++n;
            }
            filterBypass.replace(n3, n - n3, String.valueOf(this.buffer, n3, n - n3), attributeSet);
        }
    }
}

