/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ComponentFactory;
import xeij.Joystick;
import xeij.LnF;
import xeij.Multilingual;
import xeij.PPI;
import xeij.Settings;
import xeij.XEiJ;
import xeij.XInput;

public class CyberStickAnalog
extends Joystick
implements ActionListener,
ChangeListener,
FocusListener,
XInput.GamepadListener,
KeyListener {
    protected static final int SUP_BIT = 0;
    protected static final int SLEFT_BIT = 1;
    protected static final int TUP_BIT = 2;
    protected static final int OLEFT_BIT = 3;
    protected static final int STICKS = 4;
    protected static final int A_BIT = 4;
    protected static final int APRIME_BIT = 5;
    protected static final int B_BIT = 6;
    protected static final int BPRIME_BIT = 7;
    protected static final int C_BIT = 8;
    protected static final int D_BIT = 9;
    protected static final int E1_BIT = 10;
    protected static final int E2_BIT = 11;
    protected static final int SELECT_BIT = 12;
    protected static final int START_BIT = 13;
    protected static final int STICK_AND_BUTTONS = 14;
    protected static final int SUP_MASK = 1;
    protected static final int SLEFT_MASK = 2;
    protected static final int TUP_MASK = 4;
    protected static final int OLEFT_MASK = 8;
    protected static final int A_MASK = 16;
    protected static final int APRIME_MASK = 32;
    protected static final int B_MASK = 64;
    protected static final int BPRIME_MASK = 128;
    protected static final int C_MASK = 256;
    protected static final int D_MASK = 512;
    protected static final int E1_MASK = 1024;
    protected static final int E2_MASK = 2048;
    protected static final int SELECT_MASK = 4096;
    protected static final int START_MASK = 8192;
    protected static final String[] BIT_TO_TEXT = new String[]{"STICK \u2191", "STICK \u2190", "THROTTLE \u2191", "OPTION \u2190", "A", "A'", "B", "B'", "C", "D", "E1", "E2", "SELECT", "START"};
    protected static final boolean[] BIT_TO_REPEATABLE = new boolean[]{false, false, false, false, true, true, true, true, true, true, true, true, false, false};
    protected static final int MAP_CODE = 0;
    protected static final int MAP_REPEAT = 14;
    protected static final int MAP_DELAY = 28;
    protected static final int MAP_INTERVAL = 42;
    protected static final int MAP_LENGTH = 56;
    protected int[] map;
    protected int xinputFocusedButton;
    protected long[] startTimeOf;
    protected int lastButtons;
    protected int req;
    protected long transferStartTime;
    protected static final int TRANSFER_STEPS = 12;
    protected int[] transferData;
    protected JTextField[] xinputTextFieldOf = new JTextField[14];
    protected JCheckBox[] repeatCheckBoxOf = new JCheckBox[14];
    protected SpinnerNumberModel[] delayModelOf = new SpinnerNumberModel[14];
    protected JSpinner[] delaySpinnerOf = new JSpinner[14];
    protected SpinnerNumberModel[] intervalModelOf = new SpinnerNumberModel[14];
    protected JSpinner[] intervalSpinnerOf = new JSpinner[14];
    protected final int[][] defaultMaps = new int[][]{{0x940000, 0x960000, 0x900000, 0x920000, 0x870000, 0x8C0000, 0x8E0000, 0x8D0000, 0x8F0000, 0x860000, 0x880000, 0x890000, 0x850000, 0x840000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 50, 50, 50, 50, 50, 0, 0, 0, 0, 0, 0, 100, 100, 100, 100, 100, 100, 100, 100, 0, 0}, {0xB40000, 0xB60000, 0xB00000, 0xB20000, 0xA70000, 0xAC0000, 0xAE0000, 0xAD0000, 0xAF0000, 0xA60000, 0xA80000, 0xA90000, 0xA50000, 0xA40000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 50, 50, 50, 50, 50, 0, 0, 0, 0, 0, 0, 100, 100, 100, 100, 100, 100, 100, 100, 0, 0}};

    public CyberStickAnalog(int n) {
        this.number = n;
        this.id = "cyberstickanalog" + n;
        this.nameEn = "CYBER STICK (analog) #" + n;
        this.nameJa = "\u30b5\u30a4\u30d0\u30fc\u30b9\u30c6\u30a3\u30c3\u30af (\u30a2\u30ca\u30ed\u30b0) #" + n;
        this.map = new int[56];
        int[] nArray = Settings.sgsGetIntArray(this.id);
        if (0 < nArray.length && nArray[0] == -2) {
            for (int i = 0; i < 56; ++i) {
                this.map[i] = i + 1 < nArray.length ? nArray[i + 1] : 0;
            }
        } else {
            System.arraycopy(this.defaultMaps[n - 1], 0, this.map, 0, 56);
        }
        this.xinputFocusedButton = -1;
        this.startTimeOf = new long[14];
        this.transferData = new int[13];
        Arrays.fill(this.transferData, 255);
        this.reset();
        this.configurationPanel = null;
    }

    @Override
    public void tini() {
        if (Arrays.equals(this.map, this.defaultMaps[this.number - 1])) {
            Settings.sgsPutIntArray(this.id, new int[0]);
        } else {
            int[] nArray = new int[57];
            nArray[0] = -2;
            for (int i = 0; i < 56; ++i) {
                nArray[1 + i] = this.map[i];
            }
            Settings.sgsPutIntArray(this.id, nArray);
        }
    }

    @Override
    public final void reset() {
        this.lastButtons = 0;
        this.req = 0;
        this.transferStartTime = 0L;
    }

    private void updateText() {
        for (int i = 0; i < 14; ++i) {
            Object object;
            int n = this.map[0 + i] >>> 16;
            if (n == 0) {
                object = Multilingual.mlnJapanese ? "\u306a\u3057" : "none";
            } else {
                int n2 = n >> 5 & 3;
                int n3 = n & 0x1F;
                object = "#" + n2 + " " + XInput.BIT_TO_TEXT[n3];
            }
            this.xinputTextFieldOf[i].setText((String)object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Reset to default values")) {
            if (Arrays.equals(this.map, this.defaultMaps[this.number - 1])) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? this.nameJa + " \u306e\u8a2d\u5b9a\u306f\u521d\u671f\u5024\u3068\u540c\u3058\u3067\u3059" : this.nameEn + " settings are equals to default values", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", -1);
                return;
            }
            if (JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? this.nameJa + " \u306e\u8a2d\u5b9a\u3092\u521d\u671f\u5024\u306b\u623b\u3057\u307e\u3059\u304b\uff1f" : "Do you want to reset " + this.nameEn + " settings to default values?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) != 0) {
                return;
            }
            System.arraycopy(this.defaultMaps[this.number - 1], 0, this.map, 0, 56);
            this.updateText();
            for (int i = 0; i < 14; ++i) {
                if (!BIT_TO_REPEATABLE[i]) continue;
                this.repeatCheckBoxOf[i].setSelected(this.map[14 + i] != 0);
                this.delayModelOf[i].setValue(Math.max(10, Math.min(1000, this.map[28 + i])));
                this.intervalModelOf[i].setValue(Math.max(10, Math.min(2000, this.map[42 + i])));
            }
        } else if (string.startsWith("Repeat ")) {
            int n = Integer.parseInt(string.substring(7));
            int n2 = this.repeatCheckBoxOf[n].isSelected() ? 1 : 0;
            this.map[14 + n] = n2;
        } else {
            System.out.println("unknown action command " + string);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        String string = jSpinner.getName();
        if (string.startsWith("Delay ")) {
            int n = Integer.parseInt(string.substring(6));
            this.map[28 + n] = this.delayModelOf[n].getNumber().intValue();
        } else if (string.startsWith("Interval ")) {
            int n = Integer.parseInt(string.substring(9));
            this.map[42 + n] = this.intervalModelOf[n].getNumber().intValue();
        } else {
            System.out.println("unknown spinner name " + string);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        component.setBackground(new Color(LnF.lnfRGB[6]));
        if (c == 'x') {
            this.xinputFocusedButton = n;
            if (PPI.ppiXInput != null) {
                PPI.ppiXInput.addGamepadListener(this);
            }
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        component.setBackground(null);
        if (c == 'x') {
            if (PPI.ppiXInput != null) {
                PPI.ppiXInput.removeGamepadListeners();
            }
            this.xinputFocusedButton = -1;
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
    }

    @Override
    public void connected(XInput.Gamepad gamepad) {
    }

    @Override
    public void disconnected(XInput.Gamepad gamepad) {
    }

    @Override
    public void buttonPressed(XInput.Gamepad gamepad, int n) {
        if (n == 0) {
            return;
        }
        if (0 <= this.xinputFocusedButton) {
            int n2 = gamepad.getIndex();
            int n3 = Integer.numberOfTrailingZeros(n);
            int n4 = 0x80 | n2 << 5 | n3;
            if (4 <= this.xinputFocusedButton || (1 << n3 & 0xFF0000) != 0) {
                this.map[0 + this.xinputFocusedButton] = n4 << 16;
                for (int i = 0; i < 14; ++i) {
                    int n5 = this.map[0 + i] >>> 16;
                    if (n5 == 0) continue;
                    this.map[0 + i] = (n5 & 0xFFFFFF9F | n2 << 5) << 16;
                }
                this.updateText();
            }
        }
    }

    @Override
    public void buttonReleased(XInput.Gamepad gamepad, int n) {
    }

    @Override
    public void leftStickMovedX(XInput.Gamepad gamepad) {
    }

    @Override
    public void leftStickMovedY(XInput.Gamepad gamepad) {
    }

    @Override
    public void leftTriggerMoved(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightStickMovedX(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightStickMovedY(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightTriggerMoved(XInput.Gamepad gamepad) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        int n2 = this.map[0 + n] >>> 16;
        int n3 = this.map[0 + n] & 0xFFFF;
        if (c == 'x') {
            if (keyEvent.getKeyCode() == 27) {
                n2 = 0;
            }
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
        this.map[0 + n] = n2 << 16 | n3;
        this.updateText();
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public JComponent getConfigurationPanel() {
        if (this.configurationPanel != null) {
            return this.configurationPanel;
        }
        for (int i = 0; i < 14; ++i) {
            this.xinputTextFieldOf[i] = ComponentFactory.setEnabled(ComponentFactory.addListener(ComponentFactory.addListener(ComponentFactory.setHorizontalAlignment(ComponentFactory.setName(ComponentFactory.createTextField("", 8), "x" + i), 0), this), this), XEiJ.prgIsWindows);
            if (!BIT_TO_REPEATABLE[i]) continue;
            this.repeatCheckBoxOf[i] = ComponentFactory.setText(ComponentFactory.createCheckBox(this.map[14 + i] != 0, "Repeat " + i, this), "");
            this.delayModelOf[i] = new SpinnerNumberModel(Math.max(10, Math.min(1000, this.map[28 + i])), 10, 1000, 10);
            this.delaySpinnerOf[i] = ComponentFactory.setName(ComponentFactory.createNumberSpinner(this.delayModelOf[i], 4, this), "Delay " + i);
            this.intervalModelOf[i] = new SpinnerNumberModel(Math.max(10, Math.min(2000, this.map[42 + i])), 10, 2000, 10);
            this.intervalSpinnerOf[i] = ComponentFactory.setName(ComponentFactory.createNumberSpinner(this.intervalModelOf[i], 4, this), "Interval " + i);
        }
        this.updateText();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Stick/Button"), "ja", "\u30b9\u30c6\u30a3\u30c3\u30af/\u30dc\u30bf\u30f3"));
        arrayList.add(ComponentFactory.createLabel("XInput"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Burst"), "ja", "\u9023\u5c04"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Delay (ms)"), "ja", "\u958b\u59cb (ms)"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Interval (ms)"), "ja", "\u9593\u9694 (ms)"));
        arrayList.add(ComponentFactory.createHorizontalSeparator());
        for (int i = 0; i < 14; ++i) {
            arrayList.add(String.valueOf(1 + i));
            arrayList.add(BIT_TO_TEXT[i]);
            arrayList.add(this.xinputTextFieldOf[i]);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.repeatCheckBoxOf[i] : null);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.delaySpinnerOf[i] : null);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.intervalSpinnerOf[i] : null);
        }
        this.configurationPanel = ComponentFactory.createVerticalBox(Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel(this.getNameEn()), "ja", this.getNameJa()), Box.createHorizontalGlue()), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(ComponentFactory.createGridPanel(6, 16, "paddingLeft=3,paddingRight=3,center", "", "italic;colSpan=6,widen", "", arrayList.toArray(new Object[0]))), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createButton("Reset to default values", this), "ja", "\u521d\u671f\u5024\u306b\u623b\u3059"), Box.createHorizontalGlue()), Box.createVerticalStrut(5));
        return this.configurationPanel;
    }

    @Override
    public boolean input(KeyEvent keyEvent, boolean bl) {
        return false;
    }

    @Override
    public void setPin8(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (!XEiJ.prgIsWindows) {
            this.req = n;
            return;
        }
        if ((this.req & ~n) == 0) {
            this.req = n;
            return;
        }
        this.req = 0;
        this.transferStartTime = XEiJ.mpuClockTime;
        int n8 = 0;
        if (PPI.ppiXInput != null) {
            for (n7 = 0; n7 < 4; ++n7) {
                n6 = this.map[0 + n7] >>> 16;
                if (n6 == 0) continue;
                n5 = n6 >> 5 & 3;
                n4 = n6 & 0x1F;
                n3 = n4 == 16 ? -PPI.ppiXInput.getLeftStickY(n5) : (n4 == 17 ? PPI.ppiXInput.getLeftStickY(n5) : (n4 == 18 ? PPI.ppiXInput.getLeftStickX(n5) : (n4 == 19 ? -PPI.ppiXInput.getLeftStickX(n5) : (n4 == 20 ? -PPI.ppiXInput.getRightStickY(n5) : (n4 == 21 ? PPI.ppiXInput.getRightStickY(n5) : (n4 == 22 ? PPI.ppiXInput.getRightStickX(n5) : (n4 == 23 ? -PPI.ppiXInput.getRightStickX(n5) : 0)))))));
                n3 >>= 8;
                n3 = Math.max(0, Math.min(255, 128 + n3));
                n8 |= n3 << 8 * n7;
            }
        }
        n7 = 0;
        n6 = -1;
        n5 = 0;
        for (n4 = 4; n4 < 14; ++n4) {
            n3 = this.map[0 + n4] >>> 16;
            if (n3 == 0) continue;
            n2 = n3 >> 5 & 3;
            int n9 = n3 & 0x1F;
            if (n6 != n2) {
                n6 = n2;
                int n10 = n5 = PPI.ppiXInput == null ? 0 : PPI.ppiXInput.getButtonMasks(n6);
            }
            if ((n5 & 1 << n9) == 0) continue;
            n7 |= 1 << n4;
        }
        n4 = ~this.lastButtons & n7;
        this.lastButtons = n7;
        n3 = 0;
        for (n2 = 4; n2 < 14; ++n2) {
            if ((n4 & 1 << n2) != 0 && this.map[14 + n2] != 0) {
                this.startTimeOf[n2] = XEiJ.mpuClockTime + (long)this.map[28 + n2] * 1000000000L;
            }
            if ((n7 & 1 << n2) == 0 || this.map[14 + n2] != 0 && XEiJ.mpuClockTime >= this.startTimeOf[n2] && ((int)((XEiJ.mpuClockTime - this.startTimeOf[n2]) / ((long)(this.map[42 + n2] >> 1) * 1000000000L)) & 1) == 0) continue;
            n3 |= 1 << n2;
        }
        this.transferData[0] = 0x90 | ((n3 & 0x30) != 0 ? 0 : 8) | ((n3 & 0xC0) != 0 ? 0 : 4) | ((n3 & 0x100) != 0 ? 0 : 2) | ((n3 & 0x200) != 0 ? 0 : 1);
        this.transferData[1] = 0xB0 | ((n3 & 0x400) != 0 ? 0 : 8) | ((n3 & 0x800) != 0 ? 0 : 4) | ((n3 & 0x2000) != 0 ? 0 : 2) | ((n3 & 0x1000) != 0 ? 0 : 1);
        this.transferData[2] = 0x90 | n8 >>> 4 & 0xF;
        this.transferData[3] = 0xB0 | n8 >>> 12 & 0xF;
        this.transferData[4] = 0x90 | n8 >>> 20 & 0xF;
        this.transferData[5] = 0xB0 | n8 >>> 28 & 0xF;
        this.transferData[6] = 0x90 | n8 >>> 0 & 0xF;
        this.transferData[7] = 0xB0 | n8 >>> 8 & 0xF;
        this.transferData[8] = 0x90 | n8 >>> 16 & 0xF;
        this.transferData[9] = 0xB0 | n8 >>> 24 & 0xF;
        this.transferData[10] = 0x90 | ((n3 & 0x10) != 0 ? 0 : 8) | ((n3 & 0x40) != 0 ? 0 : 4) | ((n3 & 0x20) != 0 ? 0 : 2) | ((n3 & 0x80) != 0 ? 0 : 1);
        this.transferData[11] = 191;
    }

    @Override
    public int readByte() {
        long l = XEiJ.mpuClockTime - this.transferStartTime;
        int n = (int)Math.max(0L, Math.min(12L, l /= 50000000L));
        return this.transferData[n];
    }
}

