;========================================================================================
;  crtmod16.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	dosconst.equ
	.include	doswork.equ
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	sprc.equ
	.include	sram.equ
	.include	sysport.equ
	.include	vicon.equ

;----------------------------------------------------------------
;	crtmod16.x (2025-06-29)
;
;	
;		crtmod16.xIPLROM 1.6Ɋ܂܂CRTMOD/G_CLR_ON풓vOɂ̂łB
;		ʓIȉtj^768x512hbg̉ʂ͂ݏoȂ悤ɕ\ł܂B
;		384x256hbgA512x512hbg(`)Ȃǂ̉ʃ[hǉ܂B
;
;	⑫
;		IPLROM 1.0`1.3ɂOtBbNpbgɊւoOC܂B
;		oOɈˑĂ\tgEFA듮삷ꍇcrtmrb16.xgݍłB
;
;	IvV
;		-e         풓܂B
;		-l 0`1    0CRT̓gA1LCD̓gI܂B
;		-m 0`73   ʃ[hI܂Bcrtmodtest.xQƂĂB
;		-r         풓܂B
;
;	XV
;		2022-02-19
;			IPLROM 1.6_CRTMOD_G_CLR_ON𔲂o
;			IPLROM 1.0`1.3̃oOC
;			CRTLCDIł
;			28`39ǉB384x256A512x512(`)A256x256(`)
;		2022-02-21
;			crtmod16.xJ
;		2022-06-08
;		2023-01-10
;		2023-10-12
;			$56FFǉBo[WԂ
;		2023-11-15
;			$16FFǉBCRTorLCDƃo[WԂ
;		2024-03-13
;			crtmrb16.xǉBIPLROM 1.0`1.3̃oOČBoOɈˑĂ\tgEFACłȂƂ̋~ύ
;		2024-08-25
;			40`47ǉB512x256A512x256(XvCg512x512)
;		2025-03-23
;			$00ED0095$6xłȂƂ$60ށB@SRAMĂƂ\LCD[hɂȂĂ܂Ƃ̑΍
;		2025-04-19
;			stouCBThanks TcbnErik
;		2025-06-29
;			48`73ǉBgOtBbNʂɑΉ
;			$76FFǉB$16000000+ʃ[h̍őlԂ
;			$xxFFĐݒ̉ʃ[h͈͊ÔƂ-1Ԃ
;			gOtBbNʂȂ̂ɊgOtBbNʂKvȉʃ[hw肳ꂽƂ-2Ԃ
;
;----------------------------------------------------------------
;IOCSR[$10 _CRTMOD ʃ[h̎擾Ɛݒ
;<d1.w:ݒ̉ʃ[h
;	$16FF	o[W̊mFB$16xxxxxx(CRT)܂$96xxxxxx(LCD)Ԃ
;	$56FF	o[W̊mFB$16xxxxxxԂ
;	$76FF	ʃ[h̍ől̊mFB$160000xxԂ
;	$43xx	CRTBSRAMɕۑB$43FFSRAM̕ύX̂
;	$4Cxx	LCDBSRAMɕۑB$4CFFSRAM̕ύX̂
;	$xxFF	擾̂
;	$01xx	Ȃ
;>d0.l:ݒỎʃ[hB-1=ݒ̉ʃ[h͈͊O,-2=gOtBbNʂȂ
;	o[W̊mF̂Ƃ$16xxxxxx܂$96xxxxxx
;	ʃ[h̍ől̊mF̂Ƃ$160000xx
;----------------------------------------------------------------
;IOCSR[$90 _G_CLR_ON OtBbNʂ̏ƃpbgƕ\ON
;>d0.l:0
;----------------------------------------------------------------

DEVICE_NAME	reg	'CRTM16*/'
  .ifdef CRTMOD_REPRODUCE_BUG		;oOČ
TITLE_STRING	reg	'crtmrb16.x (2025-06-29)'
  .else
TITLE_STRING	reg	'crtmod16.x (2025-06-29)'
  .endif
CRTMOD_VERSION	equ	$16250629	;_CRTMOD̃o[W

PATCH_jsr	.macro	name,label
	bsr	label
	.endm

;----------------------------------------------------------------
;vO̐擪
	.text
program_head:

;foCXwb_
	.dc.l	-1			;̃foCXwb_B-1=foCXwb_̃Xg̖
	.dc.w	$8000			;foCX^CvBLN^foCX
	.dc.l	strategy_routine	;XgeW[`
	.dc.l	interrupt_routine	;C^vg[`
	.dc.b	DEVICE_NAME		;foCX

;----------------------------------------------------------------
;NGXgwb_̃AhX
request_header:
	.dc.l	0

;xN^e[u
vector_table:
	.dc.w	4*($100+_CRTMOD)	;ItZbg
	.dc.l	iocs_10_CRTMOD		;VxN^
	.dc.l	0			;ÂxN^
	.dc.w	4*($100+_G_CLR_ON)
	.dc.l	iocs_90_G_CLR_ON
	.dc.l	0
	.dc.w	0

;----------------------------------------------------------------
;XgeW[`
strategy_routine:
	move.l	a5,request_header
	rts

;C^vg[`
interrupt_routine:
	push	d0-d7/a0-a6
	movea.l	request_header(pc),a5
	moveq.l	#0,d0
	move.b	2(a5),d0		;R}hԍ
	if	<cmp.w #(jump_table_end-jump_table)/2,d0>,hs	;͈͊O
		moveq.l	#(jump_table_end-jump_table)/2,d0
	endif
	add.w	d0,d0
	move.w	jump_table(pc,d0.w),d0
	jsr	jump_table(pc,d0.w)
	move.b	d0,3(a5)		;G[R[h
	lsr.w	#8,d0
	move.b	d0,4(a5)		;G[R[h
	pop
	rts

;foCXR}h̃Wve[u
jump_table:
	.dc.w	initialize-jump_table		;foCXR}h0 
	.dc.w	command_error-jump_table	;foCXR}h1 fBXN`FbN
	.dc.w	command_error-jump_table	;foCXR}h2 BPBe[u̍č\z
	.dc.w	ioctrl_input-jump_table		;foCXR}h3 _IOCTRLɂ
	.dc.w	input-jump_table		;foCXR}h4 
	.dc.w	control_sense-jump_table	;foCXR}h5 Rg[/ZX
	.dc.w	input_status-jump_table		;foCXR}h6 ̓Xe[^X
	.dc.w	input_flush-jump_table		;foCXR}h7 ̓obt@tbV
	.dc.w	output-jump_table		;foCXR}h8 o(xt@CȂ)
	.dc.w	output-jump_table		;foCXR}h9 o(xt@C)
	.dc.w	output_status-jump_table	;foCXR}h10 o̓Xe[^X
	.dc.w	no_error-jump_table		;foCXR}h11 I
	.dc.w	ioctrl_output-jump_table	;foCXR}h12 _IOCTRLɂo
jump_table_end:
	.dc.w	command_error-jump_table	;͈͊O R}hG[

;foCXR}h1 fBXN`FbN
;foCXR}h2 BPBe[u̍č\z
;R}hG[
command_error:
	move.w	#IGNORE|ABORT|UNKNOWN_COMMAND,d0	;(I) ~(A) foCXhCoɖȃR}hw肵܂
	rts

;foCXR}h3 _IOCTRLɂ
ioctrl_input:
;	movea.l	14(a5),a1		;AhX
	goto	command_error

;foCXR}h4 
input:
	movea.l	14(a5),a1		;AhX
	move.l	18(a5),d3		;
	docontinue
		clr.b	(a1)+
	while	<subq.l #1,d3>,cc
	moveq.l	#0,d0			;ɐ(I܂ŕAȂ)
	rts

;foCXR}h5 Rg[/ZX
control_sense:
	clr.b	13(a5)			;f[^
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h6 ̓Xe[^X
input_status:
	moveq.l	#1,d0			;0=̓obt@ł͂Ȃ̂œ͂ł,1=̓obt@Ȃ̂œ͂łȂ
	rts

;foCXR}h7 ̓obt@tbV
input_flush:
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h8 o(xt@CȂ)
;foCXR}h9 o(xt@C)
output:
;	movea.l	14(a5),a1		;AhX
;	move.l	18(a5),d3		;
	moveq.l	#0,d0			;ɐ(I܂ŕAȂ)
	rts

;foCXR}h10 o̓Xe[^X
output_status:
	moveq.l	#1,d0			;0=o̓obt@tł͂Ȃ̂ŏo͂ł,1=o̓obt@tȂ̂ŏo͂łȂ
	rts

;foCXR}h11 I
no_error:
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h12 _IOCTRLɂo
ioctrl_output:
;	movea.l	14(a5),a1		;AhX
	goto	command_error



;----------------------------------------------------------------
;IOCSR[$10 _CRTMOD ʃ[h̎擾Ɛݒ
;<d1.w:ݒ̉ʃ[h
;	$16FF	o[W̊mFB$16xxxxxx(CRT)܂$96xxxxxx(LCD)Ԃ
;	$56FF	o[W̊mFB$16xxxxxxԂ
;	$76FF	ʃ[h̍ől̊mFB$160000xxԂ
;	$43xx	CRTBSRAMɕۑB$43FFSRAM̕ύX̂
;	$4Cxx	LCDBSRAMɕۑB$4CFFSRAM̕ύX̂
;	$xxFF	擾̂
;	$01xx	Ȃ
;>d0.l:ݒỎʃ[hB-1=ݒ̉ʃ[h͈͊O,-2=gOtBbNʂȂ
;	o[W̊mF̂Ƃ$16xxxxxx܂$96xxxxxx
;	ʃ[h̍ől̊mF̂Ƃ$160000xx
;----------------------------------------------------------------
;	ʃ[h
;
;	ʃ[h	𑜓x	ʃTCY	ʃTCY	F	y[W
;	0			512x512		1024x1024	16	1
;	1			512x512		1024x1024	16	1
;	2			256x256		1024x1024	16	1
;	3			256x256		1024x1024	16	1
;	4			512x512		512x512		16	4
;	5			512x512		512x512		16	4
;	6			256x256		512x512		16	4
;	7			256x256		512x512		16	4
;	8			512x512		512x512		256	2
;	9			512x512		512x512		256	2
;	10			256x256		512x512		256	2
;	11			256x256		512x512		256	2
;	12			512x512		512x512		65536	1
;	13			512x512		512x512		65536	1
;	14			256x256		512x512		65536	1
;	15			256x256		512x512		65536	1
;	16			768x512		1024x1024	16	1
;	17			1024x424	1024x1024	16	1
;	18			1024x848	1024x1024	16	1
;	19		VGA	640x480		1024x1024	16	1
;	20			768x512		512x512		256	2
;	21			1024x424	512x512		256	2
;	22			1024x848	512x512		256	2
;	23		VGA	640x480		512x512		256	2
;	24			768x512		512x512		65536	1
;	25			1024x424	512x512		65536	1
;	26			1024x848	512x512		65536	1
;	27		VGA	640x480		512x512		65536	1
;	$100+(0`27)	Ȃ
;	-1	擾̂
;
;	ȉ͊g
;	28			384x256		1024x1024	16	1
;	29			384x256		512x512		16	4
;	30			384x256		512x512		256	2
;	31			384x256		512x512		65536	1
;	32			512x512(`)	1024x1024	16	1
;	33			512x512(`)	512x512		16	4
;	34			512x512(`)	512x512		256	2
;	35			512x512(`)	512x512		65536	1
;	36			256x256(`)	1024x1024	16	1
;	37			256x256(`)	512x512		16	4
;	38			256x256(`)	512x512		256	2
;	39			256x256(`)	512x512		65536	1
;	40			512x256		1024x1024	16	1
;	41			512x256		512x512		16	4
;	42			512x256		512x512		256	2
;	43			512x256		512x512		65536	1
;	44			512x256()	1024x1024	16	1
;	45			512x256()	512x512		16	4
;	46			512x256()	512x512		256	2
;	47			512x256()	512x512		65536	1
;	XvCg512x512
;
;	ȉ͊gOtBbNʂKv
;	0,1,2,3,16,17,18,19,28,32,36,40,44256Fɂ
;	48			512x512		1024x1024	256	1
;	49			512x512		1024x1024	256	1
;	50			256x256		1024x1024	256	1
;	51			256x256		1024x1024	256	1
;	52			768x512		1024x1024	256	1
;	53			1024x424	1024x1024	256	1
;	54			1024x848	1024x1024	256	1
;	55		VGA	640x480		1024x1024	256	1
;	56			384x256		1024x1024	256	1
;	57			512x512(`)	1024x1024	256	1
;	58			256x256(`)	1024x1024	256	1
;	59			512x256		1024x1024	256	1
;	60			512x256()	1024x1024	256	1
;	0,1,2,3,16,17,18,19,28,32,36,40,4465536Fɂ
;	61			512x512		1024x1024	65536	1
;	62			512x512		1024x1024	65536	1
;	63			256x256		1024x1024	65536	1
;	64			256x256		1024x1024	65536	1
;	65			768x512		1024x1024	65536	1
;	66			1024x424	1024x1024	65536	1
;	67			1024x848	1024x1024	65536	1
;	68		VGA	640x480		1024x1024	65536	1
;	69			384x256		1024x1024	65536	1
;	70			512x512(`)	1024x1024	65536	1
;	71			256x256(`)	1024x1024	65536	1
;	72			512x256		1024x1024	65536	1
;	73			512x256()	1024x1024	65536	1
;
;----------------------------------------------------------------
;	낢
;
;	CRTLCD
;		eʃ[h̓gꂼCRTLCDɕ
;		SRAM_XEIJSRAM_XEIJ_LCD_BIT0̂ƂCRTA1̂ƂLCD̓gŏo͂
;
;	ʃ[h17
;		24.699kHzA53.116HzA1024x424A1024x1024A16F
;		X68000ォ炠邪J
;		LCD̂Ƃ͉ʃ[h16̏㉺
;
;	ʃ[h18
;		24.699kHzA53.116HzA1024x848(C^[[X)A1024x1024A16F
;		X68000ォ炠邪J
;		LCD̂Ƃ͉ʃ[h16̏㉺ăC^[[Xɂ
;
;	ʃ[h19(VGA[h)
;		31.469kHzA59.940HzA640x480A1024x1024A16F
;		X68000 CompactŒǉꂽ
;		CRT̂Ƃ͉ʃ[h16̎͂
;		LCD̂Ƃ͂̂܂
;
;	ʃ[h20`23
;		ʃ[h16`19512x512A256FɕύX
;		X68030ŒǉꂽBJ
;
;	ʃ[h24`27
;		ʃ[h16`19512x512A65536FɕύX
;		X68030ŒǉꂽBJ
;
;	OtBbNpbg̃oO(IPLROM 1.0`1.3)
;		_CRTMODw肳ꂽʃ[hƈقȂFŃOtBbNpbg
;			https://stdkmd.net/bugsx68k/#rom_crtmod_gpalet
;		256x25616FA512x512256FAȊO65536FɂȂ
;
;	ʃ[h20`27̃oO(IPLROM 1.3)
;		ʃ[h20`27w肳ꂽƂʃ[h16`19ɂĂ256F܂65536FɕύXĂ邪A
;		̂ƂBIOS[NGẢʃ[h16`19̂܂ܕuĂ
;		_G_CLR_ONĂяoƉʃ[h16`19Ȃ̂16Fɖ߂Ă܂
;
;	NbsOGÃoO(IPLROM 1.3)
;		_CRTMODŉʃ[h22܂26ɂƃNbsOGA512x848ɂȂ
;
;	VGAIV[^̖
;		`XVIɂVGAIV[^Ȃ̂VGA[hgŏo͂Ȃ
;		VGAIV[^ꍇ
;			(50.350MHz/2)/(8*100)=31.469kHz
;			(50.350MHz/2)/(8*100*525)=59.940Hz
;		VGAIV[^Ȃꍇ
;			(69.552MHz/3)/(8*100)=28.980kHz
;			(69.552MHz/3)/(8*100*525)=55.200Hz
;		傫O킯ł͂Ȃ̂Ń}`XLj^͒Ǐ]ł邪C
;
;	VGAIV[^̗L̔
;		VGA[h̐VGAIV[^Ƃ16.683msAȂƂ18.116ms
;		荞݂̊ԂTimer-C110ms7.5msi񂾂ǂVGAIV[^̗L𔻕ʂł͂
;		ŎH
;
;----------------------------------------------------------------
;	MCRTCݒl̊֌W
;
;	HT	J
;	HS	pXJ
;	HB	obN|[`J
;	HD	fԃJ
;	HF	tg|[`J
;	VT	X^
;	VS	pXX^
;	VB	obN|[`X^
;	VD	fԃX^
;	VF	tg|[`X^
;
;	R00	HT-1=HS+HB+HD+HF-1	tg|[`IJ
;	R01	HS-1			pXIJ
;	R02	HS+HB-5			obN|[`IJ-4
;	R03	HS+HB+HD-5		fԏIJ-4
;	R04	VT-1=VS+VB+VD+VF-1	tg|[`IX^
;	R05	VS-1			pXIX^
;	R06	VS+VB-1			obN|[`IX^
;	R07	VS+VB+VD-1		fԏIX^
;
;----------------------------------------------------------------
;	IV[^ƕR20LHRL̊֌W
;
;	OSC/DIV	R20L	HRL
;	38/8	%0**00	*
;	38/4	%0**01	*
;	38/8	%0**1*	*
;	69/6	%1**00	0
;	69/8	%1**00	1
;	69/3	%1**01	0
;	69/4	%1**01	1
;	69/2	%1**10	*	XvCgs
;	50/2	%1**11	*	XvCgsBCompact
;
;----------------------------------------------------------------
;	CRTCݒl(CRT)
;
;	CRT 0/4/8/12/48/61: 512x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   91   9  17  81      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   92  10  12  64   6  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*92)=31.500kHz (69.552MHz/3)/(8*92*568)=55.458Hz
;	  64/92=0.696 512/568=0.901 (0.696/0.901)/(512/512)=0.772
;	  31k
;
;	CRT 1/5/9/13/49/62: 512x512 15.980kHz 61.463Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %00101   0   75   3   5  69      259   2  16 256     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 38.864   4   76   4   6  64   2  260   3  14 240   3 |
;	  +------------------------------------------------------+
;	  (38.864MHz/4)/(8*76)=15.980kHz (38.864MHz/4)/(8*76*260)=61.463Hz
;	  64/76=0.842 240/260=0.923 (0.842/0.923)/(512/512)=0.912
;	  15k C^[[X
;
;	CRT 2/6/10/14/50/63: 256x256 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   45   4   6  38      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   46   5   6  32   3  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*46)=31.500kHz (69.552MHz/6)/(8*46*568)=55.458Hz
;	  32/46=0.696 512/568=0.901 (0.696/0.901)/(256/256)=0.772
;	  31k X^2xǂ
;
;	CRT 3/7/11/15/51/64: 256x256 15.980kHz 61.463Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %00000   0   37   1   0  32      259   2  16 256     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 38.864   8   38   2   3  32   1  260   3  14 240   3 |
;	  +------------------------------------------------------+
;	  (38.864MHz/8)/(8*38)=15.980kHz (38.864MHz/8)/(8*38*260)=61.463Hz
;	  32/38=0.842 240/260=0.923 (0.842/0.923)/(256/256)=0.912
;	  15k
;
;	CRT 16/20/24/52/65: 768x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  28 124      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  18  96   9  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  96/138=0.696 512/568=0.901 (0.696/0.901)/(768/512)=0.514
;	  31k
;
;	CRT 17/21/25/53/66: 1024x424 24.699kHz 53.116Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  175  15  31 159      464   7  32 456     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  176  16  20 128  12  465   8  25 424   8 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*176)=24.699kHz (69.552MHz/2)/(8*176*465)=53.116Hz
;	  128/176=0.727 424/465=0.912 (0.727/0.912)/(1024/424)=0.330
;	  24k
;
;	CRT 18/22/26/54/67: 1024x848 24.699kHz 53.116Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %11010   0  175  15  31 159      464   7  32 456     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  176  16  20 128  12  465   8  25 424   8 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*176)=24.699kHz (69.552MHz/2)/(8*176*465)=53.116Hz
;	  128/176=0.727 424/465=0.912 (0.727/0.912)/(1024/848)=0.661
;	  24k C^[[X
;
;	CRT 19/23/27/55/68: 640x480 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  36 116      567   5  56 536     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  26  80  17  568   6  51 480  31 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  80/138=0.580 480/568=0.845 (0.580/0.845)/(640/480)=0.514
;	  31k
;
;	CRT 28/29/30/31/56/69: 384x256 31.963kHz 56.273Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  11  59      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7   9  48   4  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*568)=56.273Hz
;	  48/68=0.706 512/568=0.901 (0.706/0.901)/(384/256)=0.522
;	  31k X^2xǂ
;
;	CRT 32/33/34/35/57/70: 512x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  44 108      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  34  64  25  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  64/138=0.464 512/568=0.901 (0.464/0.901)/(512/512)=0.514
;	  31k
;
;	CRT 36/37/38/39/58/71: 256x256 31.963kHz 56.273Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  19  51      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7  17  32  12  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*568)=56.273Hz
;	  32/68=0.471 512/568=0.901 (0.471/0.901)/(256/256)=0.522
;	  31k X^2xǂ
;
;	CRT 40/41/42/43/44/45/46/47/59/60/72/73: 512x256 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   0   91   9  17  81      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   92  10  12  64   6  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*92)=31.500kHz (69.552MHz/3)/(8*92*568)=55.458Hz
;	  64/92=0.696 512/568=0.901 (0.696/0.901)/(512/256)=0.386
;	  31k
;
;----------------------------------------------------------------
;	CRTCݒl(LCD)
;
;	LCD 0/4/8/12/48/61: 512x512 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   81   5  11  75      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 512/625=0.819 (0.780/0.819)/(512/512)=0.953
;	  SVGA
;
;	LCD 1/5/9/13/49/62: 512x512 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   81   5  11  75      624   1  83 563     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  82 480  61 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 480/625=0.768 (0.780/0.768)/(512/512)=1.016
;	  SVGA
;
;	LCD 2/6/10/14/50/63: 256x256 34.500kHz 55.200Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   41   2   3  35      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   42   3   5  32   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*42)=34.500kHz (69.552MHz/6)/(8*42*625)=55.200Hz
;	  32/42=0.762 512/625=0.819 (0.762/0.819)/(256/256)=0.930
;	  SVGA X^2xǂ
;
;	LCD 3/7/11/15/51/64: 256x256 34.500kHz 55.200Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   41   2   3  35      624   1  83 563     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   42   3   5  32   2  625   2  82 480  61 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*42)=34.500kHz (69.552MHz/6)/(8*42*625)=55.200Hz
;	  32/42=0.762 480/625=0.768 (0.762/0.768)/(256/256)=0.992
;	  SVGA X^2xǂ
;
;	LCD 16/20/24/52/65: 768x512 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  19 115      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 512/625=0.819 (0.774/0.819)/(768/512)=0.630
;	  SVGA
;
;	LCD 17/21/25/53/66: 768x600 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  19 115      624   1  23 623     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  22 600   1 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 600/625=0.960 (0.774/0.960)/(768/600)=0.630
;	  SVGA
;
;	LCD 18/22/26/54/67: 768x1024 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %11010   0  123   8  19 115      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 512/625=0.819 (0.774/0.819)/(768/1024)=1.260
;	  SVGA C^[[X
;
;	LCD 19/23/27/55/68: 640x480 31.469kHz 59.940Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10111   0   99  11  13  93      524   1  34 514     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 50.350   2  100  12   6  80   2  525   2  33 480  10 |
;	  +------------------------------------------------------+
;	  (50.350MHz/2)/(8*100)=31.469kHz (50.350MHz/2)/(8*100*525)=59.940Hz
;	  80/100=0.800 480/525=0.914 (0.800/0.914)/(640/480)=0.656
;	  VGA
;
;	LCD 28/29/30/31/56/69: 384x256 31.963kHz 51.141Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  11  59      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7   9  48   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*625)=51.141Hz
;	  48/68=0.706 512/625=0.819 (0.706/0.819)/(384/256)=0.574
;	  X^2xǂ
;
;	LCD 32/33/34/35/57/70: 512x512 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  35  99      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  31  64  20  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  64/124=0.516 512/625=0.819 (0.516/0.819)/(512/512)=0.630
;	  SVGA
;
;	LCD 36/37/38/39/58/71: 256x256 31.963kHz 51.141Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  19  51      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7  17  32  12  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*625)=51.141Hz
;	  32/68=0.471 512/625=0.819 (0.471/0.819)/(256/256)=0.574
;	  X^2xǂ
;
;	LCD 40/41/42/43/44/45/46/47/59/60/72/73: 512x256 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   0   81   5  11  75      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 512/625=0.819 (0.780/0.819)/(512/256)=0.476
;	  SVGA
;
;	yQlzVGA: 640x480 31.469kHz 59.940Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 25.175      100  12   6  80   2  525   2  33 480  10 |
;	  +------------------------------------------------------+
;	  25.175MHz/(8*100)=31.469kHz (25.175MHz/1)/(8*100*525)=59.940Hz
;	  80/100=0.800 480/525=0.914 (0.800/0.914)/(640/480)=0.656
;
;	yQlzSVGA: 800x600 35.156kHz 56.250Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 36.000      128   9  16 100   3  625   2  22 600   1 |
;	  +------------------------------------------------------+
;	  36.000MHz/(8*128)=35.156kHz (36.000MHz/1)/(8*128*625)=56.250Hz
;	  100/128=0.781 600/625=0.960 (0.781/0.960)/(800/600)=0.610
;
;	yQlzSVGA: 800x600 37.879kHz 60.317Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 40.000      132  16  11 100   5  628   4  23 600   1 |
;	  +------------------------------------------------------+
;	  40.000MHz/(8*132)=37.879kHz (40.000MHz/1)/(8*132*628)=60.317Hz
;	  100/132=0.758 600/628=0.955 (0.758/0.955)/(800/600)=0.595
;
;	yQlzSVGA: 800x600 46.875kHz 75.000Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 49.500      132  10  20 100   2  625   3  21 600   1 |
;	  +------------------------------------------------------+
;	  49.500MHz/(8*132)=46.875kHz (49.500MHz/1)/(8*132*625)=75.000Hz
;	  100/132=0.758 600/625=0.960 (0.758/0.960)/(800/600)=0.592
;
;----------------------------------------------------------------

;p[^1
	.offset	0
crtmod_param_1_width:	.ds.w	1
crtmod_param_1_height:	.ds.w	1
crtmod_param_1_r20h:	.ds.b	1
			.ds.b	1
crtmod_param_1_2nd:	.ds.w	1
crtmod_param_1_size:
	.text

;p[^2
	.offset	0
crtmod_param_2_r20l:	.ds.b	1
crtmod_param_2_hrl:	.ds.b	1
crtmod_param_2_r00:	.ds.w	1
crtmod_param_2_r01:	.ds.w	1
crtmod_param_2_r02:	.ds.w	1
crtmod_param_2_r03:	.ds.w	1
crtmod_param_2_r04:	.ds.w	1
crtmod_param_2_r05:	.ds.w	1
crtmod_param_2_r06:	.ds.w	1
crtmod_param_2_r07:	.ds.w	1
crtmod_param_2_r08:	.ds.w	1
crtmod_param_2_size:
	.text

crtmod_param_1	.macro	width,height,r20h,offset2nd
	.dc.w	width
	.dc.w	height
	.dc.b	r20h			;R20H
	.dc.b	0
	.dc.w	crtmod_param_2_size*offset2nd
	.endm

crtmod_param_2	.macro	r20l,hrl,ht,hs,hb,hd,hf,vt,vs,vb,vd,vf,r08
	.fail	(ht.and.1)!=0
	.fail	ht!=hs+hb+hd+hf
	.fail	vt!=vs+vb+vd+vf
	.dc.b	r20l			;R20L
	.dc.b	hrl			;HRL
	.dc.w	hs+hb+hd+hf-1		;R00
	.dc.w	hs-1			;R01
	.dc.w	hs+hb-5			;R02
	.dc.w	hs+hb+hd-5		;R03
	.dc.w	vs+vb+vd+vf-1		;R04
	.dc.w	vs-1			;R05
	.dc.w	vs+vb-1			;R06
	.dc.w	vs+vb+vd-1		;R07
	.dc.w	r08			;R08
	.endm

crtmod_modes	equ	(crtmod_table_1_crt_end-crtmod_table_1_crt)/crtmod_param_1_size	;ʃ[h̐

iocs_10_CRTMOD:
dMM	reg	d3			;[h
dPM	reg	d4			;ݒỎʃ[h
dGVRAM	reg	d5			;$00C00000
aE8	reg	a2			;(`)E8̃x[XAhX
aEB	reg	a3			;(`)EB̃x[XAhX
aED	reg	a4			;(`)ED̃x[XAhX
aP1	reg	a5			;p[^1̃AhX
aP2	reg	a6			;p[^2̃AhX
	push	d1-d2/dMM/dPM/dGVRAM/a0-a1/aE8/aEB/aED/aP1/aP2
	move.l	#$00C00000,dGVRAM

;(`)E8ŃANZX
;	$00E80000	CRTC
;	$00E82000	VICON
;	$00E84000	DMAC
;	$00E86000	SUPERAREA
;	$00E88000	MFP
;	$00E8A000	RTC
;	$00E8C000	PRNPORT
;	$00E8E000	SYSPORT
	lea.l	$00E88000,aE8
E8	reg	-$00E88000(aE8)

;(`)EBŃANZX
;	$00EB0000	SPRC
	lea.l	$00EB8000,aEB
EB	reg	-$00EB8000(aEB)

;(`)EDŃANZX
;	$00ED0000	SRAM
	lea.l	$00ED8000,aED
ED	reg	-$00ED8000(aED)

;SRAM
	moveq.l	#$60,d0
	moveq.l	#$F0,d2
	and.b	(SRAM_XEIJ)ED,d2
	if	<cmp.b d0,d2>,ne	;ĂȂ
		move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
		move.b	d0,(SRAM_XEIJ)ED	;
		clr.b	(SYSPORT_SRAM)E8	;locksram
	endif

;o[W̊mF
	move.l	#CRTMOD_VERSION,d0
	goto	<cmp.w #$56FF,d1>,eq,@f
	if	<cmp.w #$16FF,d1>,eq
		if	<btst.b #SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED>,ne
			bset.l	#31,d0
		endif
@@:		goto	crtmod_pop
	endif

;ʃ[h̍ől̊mF
	if	<cmp.w #$76FF,d1>,eq
		move.l	#$16000000+crtmod_modes-1,d0
	;	goto	crtmod_pop
		goto	@b
	endif

;ݒỎʃ[hmF
	moveq.l	#0,dPM
	move.b	BIOS_CRTMOD.w,dPM	;ݒỎʃ[h
	swap.w	dPM
;<dPM.l:ݒỎʃ[h<<16

;邩
	move.w	d1,dPM
	clr.b	dPM
	sub.w	dPM,d1
;<d1.w:ʃ[h
;<dPM.w:$0000=,$0100=Ȃ,$4300=CRT,$4C00=LCD

;CRTLCD̃XCb`̐؂ւ
	if	<cmp.w #$4300,dPM>,eq	;CRT
		move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
		bclr.b	#SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED
		clr.b	(SYSPORT_SRAM)E8	;locksram
		clr.w	dPM			;
	elif	<cmp.w #$4C00,dPM>,eq	;LCD
		move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
		bset.b	#SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED
		clr.b	(SYSPORT_SRAM)E8	;locksram
		clr.w	dPM			;
	endif
;<dPM.w:$0000=,$0100=Ȃ

;擾݂̂
;	IPLROM 1.0`1.3$FFFF擾̂
;	ł$xxFF擾݂̂Ƃ
;	$43FF$4CFFCRTLCD̃XCb`̐؂ւs
	goto	<cmp.w #$00FF,d1>,eq,crtmod_end	;擾̂

;ݒ̉ʃ[h͈͊O
;	IPLROM 1.0`1.3$FFFFĐݒ̉ʃ[h͈͊ÔƂԂȂ
;	ł$xxFFĐݒ̉ʃ[h͈͊ÔƂ-1Ԃ
	if	<cmp.w #crtmod_modes,d1>,hs
		moveq.l	#-1,d0		;ݒ̉ʃ[h͈͊O
		goto	crtmod_pop
	endif

;ݒ肷

;p[^1̃AhX߂
	lea.l	crtmod_table_1_crt(pc),aP1
	if	<btst.b #SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED>,ne	;LCD
		lea.l	crtmod_table_1_lcd(pc),aP1
	endif
	move.w	d1,d0
  .if crtmod_param_1_size=8
	lsl.w	#3,d0
  .else
	mulu.w	#crtmod_param_1_size,d0
  .endif
	adda.w	d0,aP1
;<aP1.l:p[^1̃AhX

;p[^2̃AhX߂
	lea.l	crtmod_table_2(pc),aP2
	adda.w	crtmod_param_1_2nd(aP1),aP2
;<aP2.l:p[^2̃AhX

;[hmF
	moveq.l	#7,dMM
	and.b	crtmod_param_1_r20h(aP1),dMM	;[hB0`7
;<dMM.w:[hB0`7

;gOtBbNʂmF
;	gOtBbNʂȂ̂ɊgOtBbNʂKvȉʃ[hw肳ꂽƂ-2Ԃ
;		              76543210
	if	<btst.b dMM,#%10100000>,ne	;[h5,7BgOtBbNʂKv
		move.b	(CRTC_MODE_BYTE)E8,-(sp)	;[hۑ
		move.b	#7,(CRTC_MODE_BYTE)E8	;[h7ɕύX
		movea.l	dGVRAM,a0
		move.w	(a0),d2			;ۑ
		not.w	(a0)			;]
		move.w	(a0),d0			;d0=]Ăǂݏo
		move.w	d2,(a0)			;
		move.b	(sp)+,(CRTC_MODE_BYTE)E8	;[h𕜌
		not.w	d2			;d2=ǂݏoĂ甽]
		if	<cmp.w d2,d0>,ne	;]łĂȂ
			moveq.l	#-2,d0			;gOtBbNʂȂ
			goto	crtmod_pop
		endif
	endif

;邩
	if	<tst.w dPM>,eq

	;

	;ݒ̉ʃ[hۑ
		move.b	d1,BIOS_CRTMOD.w	;ݒ̉ʃ[h

	;OtBbNOFFAeLXgOFFAXvCgOFF
		clr.w	(VICON_VISIBLE)E8

	;eLXgJ[\OFF
		IOCS	_B_CUROFF

	;eLXgv[0`1NA
	;	X^Rs[gƑR[hȂ
	;	CRTCĂȂ̂ŃX^Rs[IȂ
		move.w	#$0133,(CRTC_ACCESS)E8	;ANZXJn
		moveq.l	#0,d0
		lea.l	$00E00000,a0		;eLXgVRAM
		move.w	#($00E20000-$00E00000)/(4*2)-1,d1	;16384
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
		move.w	#$0033,(CRTC_ACCESS)E8	;ANZXI

	;OtBbNʎgps
		clr.w	BIOS_GRAPHIC_PALETS.w	;OtBbNʂ̐F-1B0=OtBbNʎgps

	;/Ȃ
		bsr	crtmod_common

	;CRTCR}h~
		clr.w	(CRTC_ACTION)E8

	;OtBbNpbg
  .ifdef CRTMOD_REPRODUCE_BUG		;oOČ
		moveq.l	#3,d0
		and.b	crtmod_param_2_r20l(aP2),d0	;𑜓xB256x256=256F,512x512=512F,768x512=65536F
  .else
		move.w	dMM,d0			;[hB0`7
  .endif
		PATCH_jsr	g_clr_on,initialize_gpalet	;OtBbNpbg

	;OtBbNXg[WON
	;	IPLROM 1.0`1.3_CRTMOD̓OtBbNXg[WON̏ԂŕA
		bset.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)E8	;OtBbNXg[WON

	;eLXgJ[\ON
		IOCS	_B_CURON

	;eLXgpbg
		lea.l	(SRAM_TEXT_PALET_0)ED,a0
		lea.l	(VICON_TSPALET)E8,a1
		move.l	(a0)+,(a1)+		;0,1
		move.l	(a0)+,(a1)+		;2,3
		move.l	(a0),d0			;d0=4|8
		move.l	d0,d1			;d1=4|8
		swap.w	d0			;d0=8|4
		move.w	d0,(a1)+		;4
		move.w	d0,(a1)+		;5
		move.w	d0,(a1)+		;6
		move.w	d0,(a1)+		;7
		move.w	d1,d0			;d0=8|8
		move.l	d0,(a1)+		;8,9
		move.l	d0,(a1)+		;10,11
		move.l	d0,(a1)+		;12,13
		move.l	d0,(a1)+		;14,15

	;RgXg
		move.b	(SRAM_CONTRAST)ED,(SYSPORT_CONTRAST)E8

	;XvCgRg[ݒ肷
~i = SPRC_SPRITE_OFF|SPRC_BG_1_TEXT_1|SPRC_BG_1_OFF|SPRC_BG_0_TEXT_0|SPRC_BG_0_OFF
		move.w	#~i,(SPRC_CONTROL)EB

	;eLXgON
		move.w	#VICON_TXON_MASK,(VICON_VISIBLE)E8

	;D揇ʂݒ肷
~i = 0<<VICON_SPPR_BIT|1<<VICON_TXPR_BIT|2<<VICON_GRPR_BIT			;SP>TX>GR
~j = 3<<VICON_G4TH_BIT|2<<VICON_G3RD_BIT|1<<VICON_G2ND_BIT|0<<VICON_G1ST_BIT	;G1>G2>G3>G4
		move.w	#~i|~j,(VICON_PRIORITY)E8

	else

	;Ȃ

	;ݒ̉ʃ[hۑ
		move.b	d1,BIOS_CRTMOD.w	;ݒ̉ʃ[h

	;OtBbNʎgps
		clr.w	BIOS_GRAPHIC_PALETS.w	;OtBbNʂ̐F-1B0=OtBbNʎgps

	;/Ȃ
		bsr	crtmod_common

	;OtBbNʂ\Ă邩
		moveq.l	#VICON_GXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,d0
		and.w	(VICON_VISIBLE)E8,d0
		if	ne			;OtBbNʂ\ĂƂ

		;[hݒ肷
		;	Xg[W͕ωȂ
			moveq.l	#.not.7,d0
			and.b	(CRTC_MODE_BYTE)E8,d0
			or.b	dMM,d0
			move.b	d0,(CRTC_MODE_BYTE)E8
			move.w	dMM,(VICON_MEMORY_MODE)E8

		;BIOS[NGA
			lea.l	BIOS_GRAPHIC_PAGE.w,a0	;BIOS_GRAPHIC_Y_OFFSET,BIOS_GRAPHIC_PALETS
			move.l	dGVRAM,(a0)+		;`y[W擪AhX
			move.l	#2*512,d0
			if	<cmp.w #4,dMM>,hs	;4`7
				add.w	d0,d0			;2*1024
			endif
			move.l	d0,(a0)+		;YItZbg
			moveq.l	#16-1,d0
		;		              76543210
			if	<btst.b dMM,#%00100010>,ne	;1,5
				st.b	d0			;256-1
		;		              76543210
			elif	<btst.b dMM,#%10001100>,ne	;2,3,7
				moveq.l	#-1,d0			;65536-1
			endif
			move.w	d0,(a0)			;F-1

		endif

	endif

;I
;<dPM.l:ݒỎʃ[h<<16
crtmod_end:
	clr.w	dPM
	swap.w	dPM			;ݒỎʃ[h
	move.l	dPM,d0
crtmod_pop:
	pop
	rts

;/Ȃ
crtmod_common:

;CRTCƃVXe|[gR20,HRL,R00`R07ݒ肷
;	ׂẲʃ[h[h3ɂȂ
;	Xg[WOFFɂȂ
	move.w	#3<<8,d2		;R20H(V)
	move.b	crtmod_param_2_r20l(aP2),d2	;R20L(V)
;<d2.w:R20(V)
	lea.l	dot_clock_rank(pc),a0
	moveq.l	#%00011111,d0
	and.b	(CRTC_RESOLUTION_BYTE)E8,d0	;R20L()
	moveq.l	#SYSPORT_HRL,d1
	and.b	(SYSPORT_MISC)E8,d1
	neg.b	d1
	addx.b	d0,d0				;R20L<<1|HRL()
	move.b	(a0,d0.w),d0			;ÂhbgNbÑN
	moveq.l	#%00011111,d1
	and.b	d2,d1				;R20L(V)
	add.b	d1,d1
	add.b	crtmod_param_2_hrl(aP2),d1	;R20L<<1|HRL(V)
	move.b	(a0,d1.w),d1			;VhbgNbÑN
	if	<cmp.b d0,d1>,lo	;hbgNbN
		move.w	d2,(CRTC_MODE_RESOLUTION)E8	;R20
		tst.b	crtmod_param_2_hrl(aP2)
		bsne.b	#SYSPORT_HRL_BIT,(SYSPORT_MISC)E8	;HRL
		lea.l	(CRTC_H_SYNC_END)E8,a0	;R01
		lea.l	crtmod_param_2_r01(aP2),a1
		move.w	(a1)+,(a0)+		;R01
		move.l	(a1)+,(a0)+		;R02,R03
		move.l	(a1)+,(a0)+		;R04,R05
		move.l	(a1)+,(a0)+		;R06,R07
		move.w	crtmod_param_2_r00(aP2),(CRTC_H_FRONT_END)E8	;R00
	else				;hbgNbNオ
		lea.l	(CRTC_H_FRONT_END)E8,a0	;R00
		lea.l	crtmod_param_2_r00(aP2),a1
		move.l	(a1)+,(a0)+		;R00,R01
		move.l	(a1)+,(a0)+		;R02,R03
		move.l	(a1)+,(a0)+		;R04,R05
		move.l	(a1)+,(a0)+		;R06,R07
		move.w	d2,(CRTC_MODE_RESOLUTION)E8	;R20
		tst.b	crtmod_param_2_hrl(aP2)
		bsne.b	#SYSPORT_HRL_BIT,(SYSPORT_MISC)E8	;HRL
	endif

;CRTCR08ݒ肷
;	OAWXg
;	X[p[C|[YƂrfỈfX68000̉fd˂邽߂ɁA
;	rfIX68000̐pX̐擪̎ԍ38.863632MHz̃TCNŎw肷
;	𑜓x512x512̂Ƃ
;		pX4LN^BR01=4-1=3
;		obN|[`6LN^BR02=4+6-5=5
;		OAWXg44
;		perl -e "print((4.7+4.7)*38.863632-(4*8*(4+6))-1)"
;		44.3181408
;	𑜓x256x256̂ƂB1hbgǉ
;		pX2LN^BR01=2-1=1
;		obN|[`3LN^BR02=2+3-5=0
;		OAWXg36
;		perl -e "print((4.7+4.7)*38.863632-(8*(8*(2+3)+1))-1)"
;		36.3181408
	move.w	crtmod_param_2_r08(aP2),(CRTC_ADJUST)E8	;R08

;CRTCR09`R19,R21`R24
	moveq.l	#0,d0
	lea.l	(CRTC_RASTER)E8,a0	;R09
	move.w	d0,(a0)+		;R09
	move.l	d0,(a0)+		;R10,R11
	move.l	d0,(a0)+		;R12,R13
	move.l	d0,(a0)+		;R14,R15
	move.l	d0,(a0)+		;R16,R17
	move.l	d0,(a0)+		;R18,R19
	addq.l	#2,a0
	move.w	#$0033,(a0)+		;R21
	move.l	d0,(a0)+		;R22,R23
	move.w	d0,(a0)+		;R24

;rfIRg[̃[hݒ肷
;	ׂẲʃ[h[h3ɂȂ
	move.w	#3,(VICON_MEMORY_MODE)E8

;XvCgRg[
;𑜓x
	moveq.l	#%1_11_11,d1
	and.b	crtmod_param_2_r20l(aP2),d1	;R20L
;<d1.w:𑜓x
;obN|[`IJ
	moveq.l	#4,d0
	add.w	crtmod_param_2_r02(aP2),d0
	move.w	d0,(SPRC_H_BACK_END)EB	;XvCgobN|[`IJBR02+4
;tg|[`IJ
;	obN|[`IJݒ130us҂Ă琅tg|[`IJݒ肷
;	tg|[`IJ͐256hbĝƂR00ƓlAȊO255
;		Inside X68000ɒ𑜓x256x256̂ƂR00ƓlAȊO255ݒ肷ƏĂ邪A
;		𑜓x256x256̂Ƃ255ɂƃXvCgꍇ
;		512hbĝƂ255ɂȂƐ256hbg琅512hbgɐ؂ւƂXvCg̐̈ʒu邱Ƃ
;	IPLROM 1.3dbraX68030 25MHẑƂ500us҂ĂB060turbôƂEGCgs
	moveq.l	#500/50,d0		;500us
	bsr	wait_50us		;50usPʂ̃EFCg
	moveq.l	#%0_00_11,d0
	and.b	d1,d0
	if	eq			;256hbg
		move.w	crtmod_param_2_r00(aP2),(SPRC_H_FRONT_END)EB	;XvCgtg|[`IJBR00
	else				;256hbgȊO
		move.w	#255,(SPRC_H_FRONT_END)EB	;XvCgtg|[`IJB255
	endif
;obN|[`IX^
	move.w	crtmod_param_2_r06(aP2),(SPRC_V_BACK_END)EB	;XvCgobN|[`IX^BR06
;𑜓x
	move.b	BIOS_CRTMOD.w,d0
	if	<cmp.b #36,d0>,hs	;36`
		if	<cmp.b #40,d0>,lo	;36/37/38/39 256x256(`)
			moveq.l	#%10000,d1		;XvCg256x256
		elif	<cmp.b #44,d0>,hs	;44`
			ifor	<cmp.b #48,d0>,lo,<cmp.b #60,d0>,eq,<cmp.b #73,d0>,eq	;44/45/46/47/60/73 512x256()
				moveq.l	#%10101,d1		;XvCg512x512
			endif
		endif
	endif
	move.w	d1,(SPRC_RESOLUTION)EB	;XvCg𑜓xB--------|---|𑜓x|TCY##|TCY##

;OtBbNʂ̃NbsOGA
;	ʃ[h20`27͕\ʂʂ傫Ƃɒӂ
	move.w	crtmod_param_1_width(aP1),d0	;
	move.w	crtmod_param_1_height(aP1),d1	;
	if	<cmp.w #4,dMM>,lo	;[h0`3B512x512܂
		move.w	#512,d2
		if	<cmp.w d2,d0>,hi
			move.w	d2,d0
		endif
		if	<cmp.w d2,d1>,hi
			move.w	d2,d1
		endif
	endif
	subq.w	#1,d0			;Xő
	subq.w	#1,d1			;Yő
	clr.l	BIOS_GRAPHIC_LEFT.w	;BIOS_GRAPHIC_TOP
	move.w	d0,BIOS_GRAPHIC_RIGHT.w
	move.w	d1,BIOS_GRAPHIC_BOTTOM.w

;OtBbNVRAMỸItZbg
					;dMM=   0    1    2    3    4    5    6    7
	moveq.l	#4,d0			; d0=   4    4    4    4    4    4    4    4
	and.w	dMM,d0			; d0=   0    0    0    0    4    4    4    4
	addq.w	#4,d0			; d0=   4    4    4    4    8    8    8    8
	lsl.w	#8,d0			; d0=1024 1024 1024 1024 2048 2048 2048 2048
	move.l	d0,BIOS_GRAPHIC_Y_OFFSET.w

;OtBbNʂ̃y[W
					;dMM=0 1 2  3  4  5  6  7
	moveq.l	#4,d0			; d0=4 4 4  4  4  4  4  4
	lsr.b	dMM,d0			; d0=4 2 1  0  0  0  0  0
	seq.b	d1			; d1=0 0 0 -1 -1 -1 -1 -1
	sub.b	d1,d0			; d0=4 2 1  1  1  1  1  1
	move.b	d0,BIOS_GRAPHIC_PAGES.w

;eLXgʂ̈ʒu
	move.l	#$00E00000,BIOS_TEXT_PLANE.w
	clr.l	BIOS_CONSOLE_OFFSET.w

;eLXgʂ̑傫
	move.w	crtmod_param_1_width(aP1),d0	;
	move.w	crtmod_param_1_height(aP1),d1	;
	lsr.w	#3,d0			;/8
	lsr.w	#4,d1			;/16B42416Ŋ؂ȂƂɒ
	subq.w	#1,d0			;/8-1
	subq.w	#1,d1			;/16-1
	move.w	d0,BIOS_CONSOLE_RIGHT.w
	move.w	d1,BIOS_CONSOLE_BOTTOM.w

;eLXgJ[\̈ʒu
	clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW

;}EXJ[\̈ړ͈
	clr.l	d1
	move.l	BIOS_GRAPHIC_RIGHT,d2	;BIOS_GRAPHIC_BOTTOM
	IOCS	_MS_LIMIT		;IOCSR[$77 _MS_LIMIT }EXJ[\̈ړ͈͂ݒ肷

	rts

;p[^1(CRT)
crtmod_table_1_crt:
;			 WIDTH HEIGHT R20H  2ND    1ST
	crtmod_param_1	   512,   512,   4,   0  ; CRT 0
	crtmod_param_1	   512,   512,   4,   1  ; CRT 1
	crtmod_param_1	   256,   256,   4,   2  ; CRT 2
	crtmod_param_1	   256,   256,   4,   3  ; CRT 3
	crtmod_param_1	   512,   512,   0,   0  ; CRT 4
	crtmod_param_1	   512,   512,   0,   1  ; CRT 5
	crtmod_param_1	   256,   256,   0,   2  ; CRT 6
	crtmod_param_1	   256,   256,   0,   3  ; CRT 7
	crtmod_param_1	   512,   512,   1,   0  ; CRT 8
	crtmod_param_1	   512,   512,   1,   1  ; CRT 9
	crtmod_param_1	   256,   256,   1,   2  ; CRT 10
	crtmod_param_1	   256,   256,   1,   3  ; CRT 11
	crtmod_param_1	   512,   512,   3,   0  ; CRT 12
	crtmod_param_1	   512,   512,   3,   1  ; CRT 13
	crtmod_param_1	   256,   256,   3,   2  ; CRT 14
	crtmod_param_1	   256,   256,   3,   3  ; CRT 15
	crtmod_param_1	   768,   512,   4,   4  ; CRT 16
	crtmod_param_1	  1024,   424,   4,   5  ; CRT 17
	crtmod_param_1	  1024,   848,   4,   6  ; CRT 18
	crtmod_param_1	   640,   480,   4,   7  ; CRT 19
	crtmod_param_1	   768,   512,   1,   4  ; CRT 20
	crtmod_param_1	  1024,   424,   1,   5  ; CRT 21
	crtmod_param_1	  1024,   848,   1,   6  ; CRT 22
	crtmod_param_1	   640,   480,   1,   7  ; CRT 23
	crtmod_param_1	   768,   512,   3,   4  ; CRT 24
	crtmod_param_1	  1024,   424,   3,   5  ; CRT 25
	crtmod_param_1	  1024,   848,   3,   6  ; CRT 26
	crtmod_param_1	   640,   480,   3,   7  ; CRT 27
	crtmod_param_1	   384,   256,   4,   8  ; CRT 28
	crtmod_param_1	   384,   256,   0,   8  ; CRT 29
	crtmod_param_1	   384,   256,   1,   8  ; CRT 30
	crtmod_param_1	   384,   256,   3,   8  ; CRT 31
	crtmod_param_1	   512,   512,   4,   9  ; CRT 32
	crtmod_param_1	   512,   512,   0,   9  ; CRT 33
	crtmod_param_1	   512,   512,   1,   9  ; CRT 34
	crtmod_param_1	   512,   512,   3,   9  ; CRT 35
	crtmod_param_1	   256,   256,   4,  10  ; CRT 36
	crtmod_param_1	   256,   256,   0,  10  ; CRT 37
	crtmod_param_1	   256,   256,   1,  10  ; CRT 38
	crtmod_param_1	   256,   256,   3,  10  ; CRT 39
	crtmod_param_1	   512,   256,   4,  22  ; CRT 40
	crtmod_param_1	   512,   256,   0,  22  ; CRT 41
	crtmod_param_1	   512,   256,   1,  22  ; CRT 42
	crtmod_param_1	   512,   256,   3,  22  ; CRT 43
	crtmod_param_1	   512,   256,   4,  22  ; CRT 44
	crtmod_param_1	   512,   256,   0,  22  ; CRT 45
	crtmod_param_1	   512,   256,   1,  22  ; CRT 46
	crtmod_param_1	   512,   256,   3,  22  ; CRT 47
	crtmod_param_1	   512,   512,   5,   0  ; CRT 48
	crtmod_param_1	   512,   512,   5,   1  ; CRT 49
	crtmod_param_1	   256,   256,   5,   2  ; CRT 50
	crtmod_param_1	   256,   256,   5,   3  ; CRT 51
	crtmod_param_1	   768,   512,   5,   4  ; CRT 52
	crtmod_param_1	  1024,   424,   5,   5  ; CRT 53
	crtmod_param_1	  1024,   848,   5,   6  ; CRT 54
	crtmod_param_1	   640,   480,   5,   7  ; CRT 55
	crtmod_param_1	   384,   256,   5,   8  ; CRT 56
	crtmod_param_1	   512,   512,   5,   9  ; CRT 57
	crtmod_param_1	   256,   256,   5,  10  ; CRT 58
	crtmod_param_1	   512,   256,   5,  22  ; CRT 59
	crtmod_param_1	   512,   256,   5,  22  ; CRT 60
	crtmod_param_1	   512,   512,   7,   0  ; CRT 61
	crtmod_param_1	   512,   512,   7,   1  ; CRT 62
	crtmod_param_1	   256,   256,   7,   2  ; CRT 63
	crtmod_param_1	   256,   256,   7,   3  ; CRT 64
	crtmod_param_1	   768,   512,   7,   4  ; CRT 65
	crtmod_param_1	  1024,   424,   7,   5  ; CRT 66
	crtmod_param_1	  1024,   848,   7,   6  ; CRT 67
	crtmod_param_1	   640,   480,   7,   7  ; CRT 68
	crtmod_param_1	   384,   256,   7,   8  ; CRT 69
	crtmod_param_1	   512,   512,   7,   9  ; CRT 70
	crtmod_param_1	   256,   256,   7,  10  ; CRT 71
	crtmod_param_1	   512,   256,   7,  22  ; CRT 72
	crtmod_param_1	   512,   256,   7,  22  ; CRT 73
crtmod_table_1_crt_end:

;p[^1(LCD)
crtmod_table_1_lcd:
;			 WIDTH HEIGHT R20H  2ND    1ST
	crtmod_param_1	   512,   512,   4,  11  ; LCD 0
	crtmod_param_1	   512,   512,   4,  12  ; LCD 1
	crtmod_param_1	   256,   256,   4,  13  ; LCD 2
	crtmod_param_1	   256,   256,   4,  14  ; LCD 3
	crtmod_param_1	   512,   512,   0,  11  ; LCD 4
	crtmod_param_1	   512,   512,   0,  12  ; LCD 5
	crtmod_param_1	   256,   256,   0,  13  ; LCD 6
	crtmod_param_1	   256,   256,   0,  14  ; LCD 7
	crtmod_param_1	   512,   512,   1,  11  ; LCD 8
	crtmod_param_1	   512,   512,   1,  12  ; LCD 9
	crtmod_param_1	   256,   256,   1,  13  ; LCD 10
	crtmod_param_1	   256,   256,   1,  14  ; LCD 11
	crtmod_param_1	   512,   512,   3,  11  ; LCD 12
	crtmod_param_1	   512,   512,   3,  12  ; LCD 13
	crtmod_param_1	   256,   256,   3,  13  ; LCD 14
	crtmod_param_1	   256,   256,   3,  14  ; LCD 15
	crtmod_param_1	   768,   512,   4,  15  ; LCD 16
	crtmod_param_1	   768,   600,   4,  16  ; LCD 17
	crtmod_param_1	   768,  1024,   4,  17  ; LCD 18
	crtmod_param_1	   640,   480,   4,  18  ; LCD 19
	crtmod_param_1	   768,   512,   1,  15  ; LCD 20
	crtmod_param_1	   768,   600,   1,  16  ; LCD 21
	crtmod_param_1	   768,  1024,   1,  17  ; LCD 22
	crtmod_param_1	   640,   480,   1,  18  ; LCD 23
	crtmod_param_1	   768,   512,   3,  15  ; LCD 24
	crtmod_param_1	   768,   600,   3,  16  ; LCD 25
	crtmod_param_1	   768,  1024,   3,  17  ; LCD 26
	crtmod_param_1	   640,   480,   3,  18  ; LCD 27
	crtmod_param_1	   384,   256,   4,  19  ; LCD 28
	crtmod_param_1	   384,   256,   0,  19  ; LCD 29
	crtmod_param_1	   384,   256,   1,  19  ; LCD 30
	crtmod_param_1	   384,   256,   3,  19  ; LCD 31
	crtmod_param_1	   512,   512,   4,  20  ; LCD 32
	crtmod_param_1	   512,   512,   0,  20  ; LCD 33
	crtmod_param_1	   512,   512,   1,  20  ; LCD 34
	crtmod_param_1	   512,   512,   3,  20  ; LCD 35
	crtmod_param_1	   256,   256,   4,  21  ; LCD 36
	crtmod_param_1	   256,   256,   0,  21  ; LCD 37
	crtmod_param_1	   256,   256,   1,  21  ; LCD 38
	crtmod_param_1	   256,   256,   3,  21  ; LCD 39
	crtmod_param_1	   512,   256,   4,  23  ; LCD 40
	crtmod_param_1	   512,   256,   0,  23  ; LCD 41
	crtmod_param_1	   512,   256,   1,  23  ; LCD 42
	crtmod_param_1	   512,   256,   3,  23  ; LCD 43
	crtmod_param_1	   512,   256,   4,  23  ; LCD 44
	crtmod_param_1	   512,   256,   0,  23  ; LCD 45
	crtmod_param_1	   512,   256,   1,  23  ; LCD 46
	crtmod_param_1	   512,   256,   3,  23  ; LCD 47
	crtmod_param_1	   512,   512,   5,  11  ; LCD 48
	crtmod_param_1	   512,   512,   5,  12  ; LCD 49
	crtmod_param_1	   256,   256,   5,  13  ; LCD 50
	crtmod_param_1	   256,   256,   5,  14  ; LCD 51
	crtmod_param_1	   768,   512,   5,  15  ; LCD 52
	crtmod_param_1	   768,   600,   5,  16  ; LCD 53
	crtmod_param_1	   768,  1024,   5,  17  ; LCD 54
	crtmod_param_1	   640,   480,   5,  18  ; LCD 55
	crtmod_param_1	   384,   256,   5,  19  ; LCD 56
	crtmod_param_1	   512,   512,   5,  20  ; LCD 57
	crtmod_param_1	   256,   256,   5,  21  ; LCD 58
	crtmod_param_1	   512,   256,   5,  23  ; LCD 59
	crtmod_param_1	   512,   256,   5,  23  ; LCD 60
	crtmod_param_1	   512,   512,   7,  11  ; LCD 61
	crtmod_param_1	   512,   512,   7,  12  ; LCD 62
	crtmod_param_1	   256,   256,   7,  13  ; LCD 63
	crtmod_param_1	   256,   256,   7,  14  ; LCD 64
	crtmod_param_1	   768,   512,   7,  15  ; LCD 65
	crtmod_param_1	   768,   600,   7,  16  ; LCD 66
	crtmod_param_1	   768,  1024,   7,  17  ; LCD 67
	crtmod_param_1	   640,   480,   7,  18  ; LCD 68
	crtmod_param_1	   384,   256,   7,  19  ; LCD 69
	crtmod_param_1	   512,   512,   7,  20  ; LCD 70
	crtmod_param_1	   256,   256,   7,  21  ; LCD 71
	crtmod_param_1	   512,   256,   7,  23  ; LCD 72
	crtmod_param_1	   512,   256,   7,  23  ; LCD 73

;p[^2
crtmod_table_2:
;			   R20L  HRL    HT   HS   HB   HD   HF    VT   VS   VB   VD   VF   R08    2ND  1ST
	crtmod_param_2	 %10101,   0,   92,  10,  12,  64,   6,  568,   6,  35, 512,  15,   27  ;   0  CRT 0/4/8/12/48/61
	crtmod_param_2	 %00101,   0,   76,   4,   6,  64,   2,  260,   3,  14, 240,   3,   44  ;   1  CRT 1/5/9/13/49/62
	crtmod_param_2	 %10000,   0,   46,   5,   6,  32,   3,  568,   6,  35, 512,  15,   27  ;   2  CRT 2/6/10/14/50/63
	crtmod_param_2	 %00000,   0,   38,   2,   3,  32,   1,  260,   3,  14, 240,   3,   36  ;   3  CRT 3/7/11/15/51/64
	crtmod_param_2	 %10110,   0,  138,  15,  18,  96,   9,  568,   6,  35, 512,  15,   27  ;   4  CRT 16/20/24/52/65
	crtmod_param_2	 %10110,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   5  CRT 17/21/25/53/66
	crtmod_param_2	 %11010,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   6  CRT 18/22/26/54/67
	crtmod_param_2	 %10110,   0,  138,  15,  26,  80,  17,  568,   6,  51, 480,  31,   27  ;   7  CRT 19/23/27/55/68
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31/56/69
	crtmod_param_2	 %10110,   0,  138,  15,  34,  64,  25,  568,   6,  35, 512,  15,   27  ;   9  CRT 32/33/34/35/57/70
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  568,   6,  35, 512,  15,   27  ;  10  CRT 36/37/38/39/58/71
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  66, 512,  45,   27  ;  11  LCD 0/4/8/12/48/61
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  82, 480,  61,   27  ;  12  LCD 1/5/9/13/49/62
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  66, 512,  45,   27  ;  13  LCD 2/6/10/14/50/63
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  82, 480,  61,   27  ;  14  LCD 3/7/11/15/51/64
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  15  LCD 16/20/24/52/65
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  22, 600,   1,   27  ;  16  LCD 17/21/25/53/66
	crtmod_param_2	 %11010,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  17  LCD 18/22/26/54/67
	crtmod_param_2	 %10111,   0,  100,  12,   6,  80,   2,  525,   2,  33, 480,  10,   27  ;  18  LCD 19/23/27/55/68
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  625,   2,  66, 512,  45,   27  ;  19  LCD 28/29/30/31/56/69
	crtmod_param_2	 %10110,   0,  124,   9,  31,  64,  20,  625,   2,  66, 512,  45,   27  ;  20  LCD 32/33/34/35/57/70
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  625,   2,  66, 512,  45,   27  ;  21  LCD 36/37/38/39/58/71
	crtmod_param_2	 %10001,   0,   92,  10,  12,  64,   6,  568,   6,  35, 512,  15,   27  ;  22  CRT 40/41/42/43/44/45/46/47/59/60/72/73
	crtmod_param_2	 %10001,   0,   82,   6,  10,  64,   2,  625,   2,  66, 512,  45,   27  ;  23  LCD 40/41/42/43/44/45/46/47/59/60/72/73

;R20L<<1|HRLhbgNbÑN
;	rank	R20L	HRL	osc	div	dotclk	mode
;	7	1**10	*	69.552	2	34.776	768x512()
;	6	1**11	*	50.350	2	25.175	640x480
;	5	1**01	0	69.552	3	23.184	512x512()
;	4	1**01	1	69.552	4	17.388	384x256
;	3	1**00	0	69.552	6	11.592	256x256()
;	2	0**01	*	38.864	4	9.716	512x512()
;	1	1**00	1	69.552	8	8.694
;	0	0**00	*	38.864	8	4.858	256x256()
;	0	0**1*	*	38.864	8	4.858
dot_clock_rank:
  .rept 4
	.dc.b	0	;0**00 0
	.dc.b	0	;0**00 1
	.dc.b	2	;0**01 0
	.dc.b	2	;0**01 1
	.dc.b	0	;0**10 0
	.dc.b	0	;0**10 1
	.dc.b	0	;0**11 0
	.dc.b	0	;0**11 1
  .endm
  .rept 4
	.dc.b	3	;1**00 0
	.dc.b	1	;1**00 1
	.dc.b	5	;1**01 0
	.dc.b	4	;1**01 1
	.dc.b	7	;1**10 0
	.dc.b	7	;1**10 1
	.dc.b	6	;1**11 0
	.dc.b	6	;1**11 1
  .endm



;----------------------------------------------------------------
;IOCSR[$90 _G_CLR_ON OtBbNʂ̏ƃpbgƕ\ON
;>d0.l:0
;----------------------------------------------------------------
iocs_90_G_CLR_ON:
dMM	reg	d3			;[h
dGVRAM	reg	d5			;$00C00000
aE8	reg	a2			;(`)E8̃x[XAhX
aED	reg	a4			;(`)ED̃x[XAhX
aP1	reg	a5			;p[^1̃AhX
	push	d0-d2/dMM/dGVRAM/a0/aE8/aED/aP1
	move.l	#$00C00000,dGVRAM

;(`)E8ŃANZX
;	$00E80000	CRTC
;	$00E82000	VICON
;	$00E84000	DMAC
;	$00E86000	SUPERAREA
;	$00E88000	MFP
;	$00E8A000	RTC
;	$00E8C000	PRNPORT
;	$00E8E000	SYSPORT
	lea.l	$00E88000,aE8
E8	reg	-$00E88000(aE8)

;(`)EDŃANZX
;	$00ED0000	SRAM
	lea.l	$00ED8000,aED
ED	reg	-$00ED8000(aED)

;݂̉ʃ[hmF
	moveq.l	#0,d1
	move.b	BIOS_CRTMOD.w,d1	;݂̉ʃ[h
	if	<cmp.w #crtmod_modes,d1>,hs	;݂̉ʃ[h͈͊ÔƂ
		move.b	(SRAM_CRTMOD)ED,d1		;N̉ʃ[hg
		if	<cmp.w #crtmod_modes,d1>,hs	;N̉ʃ[h͈͊ÔƂ
			moveq.l	#16,d1			;16g
  .if 0
			move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
			move.b	d1,(SRAM_CRTMOD)ED
			clr.b	(SYSPORT_SRAM)E8	;locksram
  .endif
		endif
	endif

;<d1.l:ʃ[h

;p[^1̃AhX߂
	lea.l	crtmod_table_1_crt,aP1
	if	<btst.b #SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED>,ne	;LCD
		lea.l	crtmod_table_1_lcd,aP1
	endif
	move.w	d1,d0
  .if crtmod_param_1_size=8
	lsl.w	#3,d0
  .else
	mulu.w	#crtmod_param_1_size,d0
  .endif
	adda.w	d0,aP1
;<aP1.l:p[^1̃AhX

;[hmF
	moveq.l	#7,dMM
	and.b	crtmod_param_1_r20h(aP1),dMM	;[hB0`7
;<dMM.w:[hB0`7

;eLXgʂ̂ON
	move.w	#VICON_TXON_MASK,(VICON_VISIBLE)E8

;[hݒ肷
	move.b	dMM,(CRTC_MODE_BYTE)E8
	move.w	dMM,(VICON_MEMORY_MODE)E8

;OtBbNVRAMNA
	bset.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)E8	;OtBbNXg[WON
	movea.l	dGVRAM,a0
	moveq.l	#0,d0
	moveq.l	#1-1,d2
;		              76543210
	if	<btst.b dMM,#%10100000>,ne	;5,7
	;[hŃNA͈͂߂Ă
	;gOtBbNʂȂƂgOtBbNʂKvȉʃ[hCRTMODêłʂ邱Ƃ͂Ȃ͂
		moveq.l	#4-1,d2
	endif
	for	d2
		moveq.l	#-1,d1			;2*512*512/8=65536
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
	next
	bclr.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)E8	;OtBbNXg[WOFF

;BIOS[NGA
	lea.l	BIOS_GRAPHIC_PAGE.w,a0	;BIOS_GRAPHIC_Y_OFFSET,BIOS_GRAPHIC_PALETS
	move.l	dGVRAM,(a0)+		;`y[W擪AhX
	move.l	#2*512,d0
	if	<cmp.w #4,dMM>,hs	;4`7
		add.w	d0,d0			;2*1024
	endif
	move.l	d0,(a0)+		;YItZbg
	moveq.l	#16-1,d0
;		              76543210
	if	<btst.b dMM,#%00100010>,ne	;1,5
		st.b	d0			;256-1
;		              76543210
	elif	<btst.b dMM,#%10001100>,ne	;2,3,7
		moveq.l	#-1,d0			;65536-1
	endif
	move.w	d0,(a0)			;F-1

;OtBbNpbg
	move.w	dMM,d0
	bsr	initialize_gpalet

;eLXgONAOtBbNON
;	if	<cmp.w #4,dMM>,lo	;[h0`3B512x512hbg
;		move.w	#VICON_TXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,(VICON_VISIBLE)E8
;	else				;[h4`7B1024x1024hbg
;		move.w	#VICON_TXON_MASK|VICON_GXON_MASK,(VICON_VISIBLE)E8
;	endif
;	IPLROM 1.0`1.31024x1024hbg512x512hbg𗼕ONɂĂ
	move.w	#VICON_TXON_MASK|VICON_GXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,(VICON_VISIBLE)E8

	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;OtBbNpbg
;<d0.w:[hB0`7
initialize_gpalet:
	push	d0-d4/a0-a1
	lea.l	VICON_GPALET,a0
	ifor	<tst.w d0>,eq,<cmp.w #4,d0>,eq,<cmp.w #6,d0>,eq	;[h0,4,6B16F
		lea.l	gpalet_16_array(pc),a1
		moveq.l	#16/2-1,d0
		for	d0
			move.l	(a1)+,(a0)+
		next
	elifor	<cmp.w #1,d0>,eq,<cmp.w #5,d0>,eq	;[h1,5B256F
	;green͑10.54K(10.5*3=31.5)Aredblue͑4.58K(4.5*7=31.5)A[͐؂̂
		move.l	#((9<<1)<<16)|(9<<1),d1	;bluȇ4.5+4.5
		moveq.l	#0,d3			;green=0
		do
			moveq.l	#(4<<1),d2		;red=0,blue=(0,4.5)
			moveq.l	#8-1,d4
			for	d4
				move.l	d3,d0			;green
				and.l	#.not.(((1<<10)<<16)|(1<<10)),d0	;green̒[؂̂Ă
				add.l	d2,d0			;red,blue=(0,4.5)
				and.l	#.not.(((1<<5)<<16)|(1<<5)),d0	;red̒[؂̂Ă
				move.l	d0,(a0)+
				add.l	d1,d0			;blue+=4.5+4.5
				move.l	d0,(a0)+
				add.l	d1,d0			;blue+=4.5+4.5
				move.l	d0,(a0)+
				add.l	d1,d0			;blue+=4.5+4.5
				move.l	d0,(a0)+
				add.l	#((9<<5)<<16)|(9<<5),d2	;red+=4.5
			next
			add.l	#((21<<10)<<16)|(21<<10),d3	;green+=10.5
		while	cc
	else				;[h2,3,7B65536F
		move.l	#$00_01_00_01,d0	;(L00,L01,H00,H01),(L02,L03,H02,H03),c,(LFE,LFF,HFE,HFF)
		move.l	#$02_02_02_02,d2
		moveq.l	#256/2-1,d1
		for	d1
			move.l	d0,(a0)+
			add.l	d2,d0
		next
	endif
	pop
	rts

;OtBbN16Fpbg
gpalet_16_array:
	dcrgb	0,0,0
	dcrgb	10,10,10
	dcrgb	0,0,16
	dcrgb	0,0,31
	dcrgb	16,0,0
	dcrgb	31,0,0
	dcrgb	16,0,16
	dcrgb	31,0,31
	dcrgb	0,16,0
	dcrgb	0,31,0
	dcrgb	0,16,16
	dcrgb	0,31,31
	dcrgb	16,16,0
	dcrgb	31,31,0
	dcrgb	21,21,21
	dcrgb	31,31,31

;----------------------------------------------------------------
;50usPʂ̃EFCg
;<d0.l:(50usP)
	.text
	.even
wait_50us:
  .if 0
;Timer-Cg
;	Timer-C1/200vXP[(50us)œ삵ĂȂ΂ȂȂ
aTCDR	reg	a0
	push	d0-d2/aTCDR
	lea.l	MFP_TCDR,aTCDR
	moveq.l	#0,d1
	move.b	(aTCDR),d1
	move.b	(aTCDR),d1
	do
		moveq.l	#0,d2
		move.b	(aTCDR),d2
		redo	<cmp.b (aTCDR),d2>,cs
		sub.w	d2,d1
		if	cs
			add.w	#200,d1
		endif
		exg.l	d1,d2
		sub.l	d2,d0
	while	hi
	pop
	rts
  .else
;dbra󃋁[vg
;	BIOS_MPU_SPEED_ROM.wBIOS_MPU_TYPE.wݒ肳ĂȂ΂ȂȂ
	push	d0-d3
	subq.l	#1,d0
	if	cc
		move.l	BIOS_MPU_SPEED_ROM_LONG.w,d1
		if	eq
			move.w	BIOS_MPU_SPEED_ROM.w,d1
		endif
	;	20bitƂ50usdbrả񐔂߂
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;000/010/020/030
			move.w	#205,d2			;2**12*50/1000=204.8
		elif	eq			;040
			move.w	#307,d2			;2**12*50/1000*6/4=307.2
		else				;060
			move.w	#1229,d2		;2**12*50/1000*6/1=1228.8
		endif
		move.l	d1,d3			;d3=H|L
		swap.w	d3			;d3=L|H
		mulu.w	d2,d3			;d3=c*H
		mulu.w	d2,d1			;d1=c*L
		swap.w	d3
		clr.w	d3			;d3=c*H|0
		add.l	d3,d1			;d1=c*(H|L)
		and.w	#$F000,d1		;43210___
		rol.l	#4,d1			;3210___4
		swap.w	d1			;___43210  50usdbrả
		subq.l	#1,d1
		move.l	d1,d2
		forlong	d0
			move.l	d2,d1
			.align	16,$2048
			forlong	d1
			next
		next
	endif
	pop
	rts
  .endif



;----------------------------------------------------------------
;foCXhCo̖
device_tail:

;----------------------------------------------------------------
;foCXR}h0 
initialize:

;p[^mF
	moveq.l	#-1,d6			;CRT/LCD͎w肳ĂȂ
	moveq.l	#-1,d7			;ʃ[h͎w肳ĂȂ
	movea.l	18(a5),a0		;p[^B؂0A0,0B擪̓foCXt@C
	do
	while	<tst.b (a0)+>,ne	;foCXt@Cǂݔ΂
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,parameter_error	;-,/ȊO
		move.b	(a0)+,d0
		goto	eq,parameter_error	;-,/̌ɕȂ
		bsr	tolower
		if	<cmp.b #'l',d0>,eq	;-l
			goto	<tst.l d6>,pl,parameter_error	;CRT/LCD͊Ɏw肳Ă
			ifand	<tst.b (a0)>,eq,<tst.b 1(a0)>,ne	;10iĂ
				addq.l	#1,a0
			endif
			bsr	nonspace
			bsr	stou
			gotoor	<>,cs,<cmp.l #1,d0>,hi,parameter_error	;10iȂ͈͊O
			move.l	d0,d6			;CRT/LCDw肳ꂽ
		elif	<cmp.b #'m',d0>,eq	;-m
			goto	<tst.l d7>,pl,parameter_error	;ʃ[h͊Ɏw肳Ă
			ifand	<tst.b (a0)>,eq,<tst.b 1(a0)>,ne	;10iĂ
				addq.l	#1,a0
			endif
			bsr	nonspace
			bsr	stou
			gotoor	<>,cs,<cmp.l #47,d0>,hi,parameter_error	;10iȂ͈͊O
			move.l	d0,d7			;ʃ[hw肳ꂽ
		else				;-l,-mȊO
			goto	parameter_error
			noreturn
		endif
		goto	<tst.b (a0)+>,ne,parameter_error	;]ȕ
	start
		move.b	(a0)+,d0
	while	ne
;<d6.l:0=CRT,1=LCD,-1=w肳ĂȂ
;<d7.l:ʃ[h,-1=w肳ĂȂ

;xN^ύX
	lea.l	vector_table(pc),a0	;xN^e[u
	bsr	set_vector		;xN^ύX

;ʃ[hݒ肷
	bsr	set_screen_mode

;^Cg\
	pea.l	crlf_title(pc)
	DOS	_PRINT
	peastrdata	<'CRTMOD/G_CLR_ONg܂',13,10>
	DOS	_PRINT
	addq.l	#8,sp

;foCXhCo̖ݒ肷
	move.l	#device_tail,14(a5)	;foCXhCo̖

;foCXhCogݍ
	moveq.l	#0,d0
	rts

;p[^G[
parameter_error:

;^CgƃG[bZ[W\
	pea.l	crlf_title(pc)
	DOS	_PRINT
	peastrdata	<'włȂp[^ł',13,10>
	DOS	_PRINT
	addq.l	#8,sp

;foCXhCogݍ܂Ȃ
	move.w	#ABORT|MISCELLANEOUS_ERROR,d0	;~(A) G[܂
	rts

;----------------------------------------------------------------
;sJn
execution_start:

;IvVmF
	moveq.l	#-1,d5			;풓/͎w肳ĂȂ
	moveq.l	#-1,d6			;CRT/LCD͎w肳ĂȂ
	moveq.l	#-1,d7			;ʃ[h͎w肳ĂȂ
	lea.l	1(a2),a0
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,usage_exit	;-,/ȊO
		addq.l	#1,a0
		move.b	(a0)+,d0
		goto	eq,usage_exit		;-,/̌ɕȂ
		bsr	tolower
		if	<cmp.b #'e',d0>,eq	;-e
			goto	<tst.l d5>,pl,usage_exit	;풓/͊Ɏw肳Ă
			moveq.l	#0,d5			;풓
		elif	<cmp.b #'l',d0>,eq	;-l
			goto	<tst.l d6>,pl,usage_exit	;CRT/LCD͊Ɏw肳Ă
			bsr	nonspace
			bsr	stou
			gotoor	<>,cs,<cmp.l #1,d0>,hi,usage_exit	;10iȂ͈͊O
			move.l	d0,d6			;CRT/LCDw肳ꂽ
		elif	<cmp.b #'m',d0>,eq	;-m
			goto	<tst.l d7>,pl,usage_exit	;ʃ[h͊Ɏw肳Ă
			bsr	nonspace
			bsr	stou
			gotoor	<>,cs,<cmp.l #47,d0>,hi,usage_exit	;10iȂ͈͊O
			move.l	d0,d7			;ʃ[hw肳ꂽ
		elif	<cmp.b #'r',d0>,eq	;-r
			goto	<tst.l d5>,pl,usage_exit	;풓/͊Ɏw肳Ă
			moveq.l	#1,d5			;
		else				;-e,-l,-m,-rȊO
			goto	usage_exit
			noreturn
		endif
	start
		bsr	nonspace
	while	ne
;<d5.l:0=풓,1=,-1=w肳ĂȂ
;<d6.l:0=CRT,1=LCD,-1=w肳ĂȂ
;<d7.l:ʃ[h,-1=w肳ĂȂ

;풓/w肳ĂȂƂ͉ʃ[hݒ肷
	if	<tst.l d5>,mi	;풓/w肳ĂȂ
		gotoand	<tst.l d6>,mi,<tst.l d7>,mi,usage_exit	;CRT/LCDƉʃ[hw肳ĂȂ
		bsr	set_screen_mode		;ʃ[hݒ肷
		goto	exit			;I
		noreturn
	endif

;X[p[oCU[hֈڍs
	supervisormode

;풓T

;foCXhCoT
	movea.l	DOS_HUMAN_MEMORY.w,a2	;Human68k̐擪
	do
		addq.l	#2,a2
	whileor	<cmpi.l #'NUL ',DH_NAME(a2)>,ne,<cmpi.l #'    ',DH_NAME+4(a2)>,ne,<cmpi.w #$8024,DH_TYPE(a2)>,ne	;NULfoCX܂ŐiށBK
	while	<movea.l a2,a3>,<movea.l DH_NEXT(a2),a2>,<cmpa.l #-1,a2>,ne	;̃foCXhCo
		lea.l	DH_NAME(a2),a0		;풓̃foCX
		lea.l	program_head+DH_NAME(pc),a1	;̃foCX
		gotoand	<cmpm.l (a0)+,(a1)+>,eq,<cmpm.l (a0)+,(a1)+>,eq,end_of_search	;vI
	endwhile
	suba.l	a3,a3			;풓̓foCXhCoł͂Ȃ

;Oɂ풓vOT
	lea.l	program_head(pc),a2	;풓̐擪
	while	<movea.l MM_PREV-MM_PROGRAM(a2),a2>,<move.l a2,d0>,ne	;ÕǗe[u
		lea.l	MM_PROGRAM(a2),a2	;풓̐擪
		lea.l	DH_SIZE(a2),a0		;풓̃foCXwb_̖
		continue	<cmpa.l MM_TAIL-MM_PROGRAM(a2),a0>,hi	;ubNZ
		lea.l	DH_NAME(a2),a0		;풓̃foCX
		lea.l	program_head+DH_NAME(pc),a1	;̃foCX
		gotoand	<cmpm.l (a0)+,(a1)+>,eq,<cmpm.l (a0)+,(a1)+>,eq,end_of_search	;vI
	endwhile

;ɂ풓vOT
	lea.l	program_head(pc),a2	;풓̐擪
	while	<movea.l MM_NEXT-MM_PROGRAM(a2),a2>,<move.l a2,d0>,ne	;̃Ǘe[u
		lea.l	MM_PROGRAM(a2),a2	;풓̐擪
		lea.l	DH_SIZE(a2),a0		;풓̃foCXwb_̖
		continue	<cmpa.l MM_TAIL-MM_PROGRAM(a2),a0>,hi	;ubNZ
		lea.l	DH_NAME(a2),a0		;풓̃foCX
		lea.l	program_head+DH_NAME(pc),a1	;̃foCX
		gotoand	<cmpm.l (a0)+,(a1)+>,eq,<cmpm.l (a0)+,(a1)+>,eq,end_of_search	;vI
	endwhile

end_of_search:
;<a2.l:풓̐擪,0=풓Ȃ
;<a3.l:(풓Ƃ)풓̑ÕfoCXhCoB0=풓̓foCXhCoł͂Ȃ

	if	<move.l a2,d0>,eq	;풓ĂȂ

		if	<tst.l d5>,ne		;

		;[U[h֕A
			usermode

		;G[bZ[W\
			move.w	#2,-(sp)
			peastrdata	<'풓Ă܂',13,10>
			DOS	_FPUTS
			addq.l	#6,sp

		;G[I
			move.w	#1,-(sp)
			DOS	_EXIT2
			noreturn

		endif

	;풓

	;xN^ύX
		lea.l	vector_table(pc),a0	;xN^e[u
		bsr	set_vector		;xN^ύX

	;[U[h֕A
		usermode

	;ʃ[hݒ肷
		bsr	set_screen_mode

	;풓bZ[W\
		pea.l	title(pc)
		DOS	_PRINT
		peastrdata	<'풓܂',13,10>
		DOS	_PRINT
		addq.l	#8,sp

	;풓I
		clr.w	-(sp)
		move.l	#device_tail-program_head,-(sp)
		DOS	_KEEPPR
		noreturn

	else				;풓Ă

		if	<tst.l d5>,eq		;풓

		;[U[hɕA
			usermode

		;G[bZ[W\
			move.w	#2,-(sp)
			peastrdata	<'풓Ă܂',13,10>
			DOS	_FPUTS
			addq.l	#6,sp

		;G[I
			move.w	#1,-(sp)
			DOS	_EXIT2
			noreturn

		endif

	;

	;xN^mF
		lea.l	(vector_table-program_head)(a2),a0	;풓̃xN^e[u
		bsr	check_vector		;xN^mF

		if	ne			;xN^ύXĂ

		;[U[hɕA
			usermode

		;G[bZ[W\
			move.w	#2,-(sp)
			peastrdata	<'xN^ύXĂ܂Bł܂',13,10>
			DOS	_FPUTS
			addq.l	#6,sp

		;G[I
			move.w	#1,-(sp)
			DOS	_EXIT2
			noreturn

		endif

	;xN^ύXĂȂ

	;xN^𕜌
		lea.l	(vector_table-program_head)(a2),a0	;풓̃xN^e[u
		bsr	release_vector		;xN^𕜌

		if	<move.l a3,d0>,ne	;풓̓foCXhCo

			;foCXhCo؂藣
			move.l	(a2),(a3)		;ÕfoCXhCoɎ̃foCXhCoq

		else				;풓͏풓vO

			;풓J
			pea.l	MM_SIZE-MM_PROGRAM(a2)	;풓̃ubN̐擪
			DOS	_MFREE
			addq.l	#4,sp

		endif

	;[U[hɕA
		usermode

	;bZ[W\
		peastrdata	<'܂',13,10>
		DOS	_PRINT
		addq.l	#4,sp

	;I
		DOS	_EXIT
		noreturn

	endif

;^CgƎgp@\
usage_exit:
	pea.l	title(pc)
	DOS	_PRINT
	pea.l	usage(pc)
	DOS	_PRINT
	addq.l	#8,sp

;I
exit:
	DOS	_EXIT

;----------------------------------------------------------------
;xN^ύX
;<a0.l:xN^e[u
set_vector:
	push	d0/a0-a1
	docontinue
		movea.w	d0,a1			;ItZbg
		move.l	(a1),d0
		move.l	(a0)+,(a1)		;VxN^
		move.l	d0,(a0)+		;ÂxN^
	while	<move.w (a0)+,d0>,ne
	pop
	rts

;----------------------------------------------------------------
;xN^mF
;<a0.l:풓̃xN^e[u
;>ccr:eq=xN^͕ύXĂȂ,ne=xN^ύXĂ
check_vector:
	push	d0/a0-a1
	docontinue
		movea.w	d0,a1			;ItZbg
		move.l	(a1),d0
		break	<cmp.l (a0)+,d0>,ne	;VxN^݂̃xN^ƈvȂΎs
		addq.l	#4,a0			;ÂxN^ǂݔ΂
	while	<move.w (a0)+,d0>,ne
	pop
	rts

;----------------------------------------------------------------
;xN^𕜌
;<a0.l:풓̃xN^e[u
release_vector:
	push	d0/a0-a1
	docontinue
		movea.w	d0,a1			;ItZbg
		addq.l	#4,a0			;VxN^ǂݔ΂
		move.l	(a0)+,(a1)		;ÂxN^
	while	<move.w (a0)+,d0>,ne
	pop
	rts

;----------------------------------------------------------------
;ʃ[hݒ肷
;<d6.l:0=CRT,1=LCD,-1=w肳ĂȂ
;<d7.l:ʃ[h,-1=w肳ĂȂ
set_screen_mode:
	if	<tst.l d7>,pl		;ʃ[hw肳Ă
		move.l	#(14<<16)|3,-(sp)	;t@NV\Ȃ
		DOS	_CONCTRL
		addq.l	#4,sp
		move.l	d7,d1			;ʃ[h
		if	<tst.l d6>,pl		;LCD[hw肳Ă
			if	eq			;CRT
				or.w	#$4300,d1
			else				;LCD
				or.w	#$4C00,d1
			endif
		endif
		IOCS	_CRTMOD
	;	IOCS	_G_CLR_ON
	elif	<tst.l d6>,pl		;LCD[hw肳Ă
		if	eq			;CRT
			move.w	#$43FF,d1
		else				;LCD
			move.w	#$4CFF,d1
		endif
		IOCS	_CRTMOD
		move.l	#(16<<16)|$FFFF,-(sp)	;DOSx̉ʃ[hĐݒ肷
		DOS	_CONCTRL
		move.w	d0,2(sp)
		DOS	_CONCTRL
		addq.l	#4,sp
		move.l	#(14<<16)|0,-(sp)	;t@NV\
		DOS	_CONCTRL
		addq.l	#4,sp
	endif
	rts

;----------------------------------------------------------------
;󔒈ȊO̕܂œǂݔ΂
;<a0.l:
;>d0.l:󔒈ȊO̕܂0
;>a0.l:󔒈ȊO̕܂0̈ʒu
;>z:eq=0
nonspace:
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		redoand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΌJԂ
	while	<cmp.b #' ',d0>,eq		;󔒂ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

;----------------------------------------------------------------
;10i̕𕄍Ȃɕϊ
;<a0.l:10i̕B擪̋󔒂͔F߂Ȃ
;>d0.l:(cĉƂ)ȂB(cŝƂ)0=10i̕Ȃ,-1=I[o[t[
;>a0.l:(cĉƂ)10i̎̈̕ʒuB(cŝƂ)ωȂ
;>z:(cĉƂ)eq=Ȃ0
;>v:(cŝƂ)vc=10i̕Ȃ,vs=I[o[t[
;>c:cs=10i̕Ȃ܂̓I[o[t[
stou::
	push	d1-d2/a1
	moveq.l	#0,d0			;Ȃ
	moveq.l	#0,d1			;
	movea.l	a0,a1			;Jnʒu
	dostart
		goto	<cmp.l #$1999999A,d0>,hs,20f	;10{I[o[t[
		move.l	d0,d2			;1{
		lsl.l	#2,d0			;4{
		add.l	d2,d0			;5{
		add.l	d0,d0			;10{
		add.l	d1,d0			;1
		goto	cs,20f			;I[o[t[
	start
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	goto	<cmpa.l a1,a0>,eq,30f	;iłȂB10i̕Ȃ
	tst.l	d0			;ne/eq,vc,cc
10:	pop
	rts

;I[o[t[
20:
  .if 0
	do
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ǂݔ΂
	subq.l	#1,a0			;i݉߂߂
  .else
	movea.l	a1,a0			;Jnʒuɖ߂
  .endif
	moveq.l	#-1,d0			;I[o[t[
	move.w	#%00011,ccr		;ne,vs,cs
	goto	10b

;10i̕Ȃ
30:
;	moveq.l	#0,d0			;10i̕Ȃ
	move.w	#%00101,ccr		;eq,vc,cs
	goto	10b

;----------------------------------------------------------------
;ɂ
;<d0.b:
;>d0.b:
tolower:
	ifand	<cmp.b #'A',d0>,hs,<cmp.b #'Z',d0>,ls	;啶
		add.b	#'a'-'A',d0		;ɂ
	endif
	rts

	.data

;----------------------------------------------------------------
;^Cg
crlf_title:
	.dc.b	13,10
title:
	.dc.b	TITLE_STRING,13,10,0
	.even

;gp@
usage:
	.dc.b	13,10
	.dc.b	'',13,10
	.dc.b	'  crtmod16.xIPLROM 1.6Ɋ܂܂CRTMOD/G_CLR_ON풓vOɂ̂łB',13,10
	.dc.b	'  ʓIȉtj^768x512hbg̉ʂ͂ݏoȂ悤ɕ\ł܂B',13,10
	.dc.b	'  384x256hbgA512x512hbg(`)Ȃǂ̉ʃ[hǉ܂B',13,10
	.dc.b	13,10
	.dc.b	'⑫',13,10
	.dc.b	'  IPLROM 1.0`1.3ɂOtBbNpbgɊւoOC܂B',13,10
	.dc.b	'  oOɈˑĂ\tgEFA듮삷ꍇcrtmrb16.xgݍłB',13,10
	.dc.b	13,10
	.dc.b	'IvV',13,10
	.dc.b	'  -e         풓܂B',13,10
	.dc.b	'  -l 0`1    0CRT̓gA1LCD̓gI܂B',13,10
	.dc.b	'  -m 0`73   ʃ[hI܂Bcrtmodtest.x̐QƂĂB',13,10
	.dc.b	'  -r         풓܂B',13,10
	.dc.b	13,10
	.dc.b	0
	.even

	.end	execution_start
