/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Objects;

public final class XInput
extends Thread {
    public static final int UP_BIT = 0;
    public static final int DOWN_BIT = 1;
    public static final int LEFT_BIT = 2;
    public static final int RIGHT_BIT = 3;
    public static final int START_BIT = 4;
    public static final int BACK_BIT = 5;
    public static final int LSTICK_BIT = 6;
    public static final int RSTICK_BIT = 7;
    public static final int LB_BIT = 8;
    public static final int RB_BIT = 9;
    public static final int A_BIT = 12;
    public static final int B_BIT = 13;
    public static final int X_BIT = 14;
    public static final int Y_BIT = 15;
    public static final int LSUP_BIT = 16;
    public static final int LSDOWN_BIT = 17;
    public static final int LSLEFT_BIT = 18;
    public static final int LSRIGHT_BIT = 19;
    public static final int RSUP_BIT = 20;
    public static final int RSDOWN_BIT = 21;
    public static final int RSLEFT_BIT = 22;
    public static final int RSRIGHT_BIT = 23;
    public static final int LTRIGGER_BIT = 24;
    public static final int RTRIGGER_BIT = 25;
    public static final int BUTTONS = 26;
    public static final int UP_MASK = 1;
    public static final int DOWN_MASK = 2;
    public static final int LEFT_MASK = 4;
    public static final int RIGHT_MASK = 8;
    public static final int START_MASK = 16;
    public static final int BACK_MASK = 32;
    public static final int LSTICK_MASK = 64;
    public static final int RSTICK_MASK = 128;
    public static final int LB_MASK = 256;
    public static final int RB_MASK = 512;
    public static final int A_MASK = 4096;
    public static final int B_MASK = 8192;
    public static final int X_MASK = 16384;
    public static final int Y_MASK = 32768;
    public static final int LSUP_MASK = 65536;
    public static final int LSDOWN_MASK = 131072;
    public static final int LSLEFT_MASK = 262144;
    public static final int LSRIGHT_MASK = 524288;
    public static final int RSUP_MASK = 0x100000;
    public static final int RSDOWN_MASK = 0x200000;
    public static final int RSLEFT_MASK = 0x400000;
    public static final int RSRIGHT_MASK = 0x800000;
    public static final int LTRIGGER_MASK = 0x1000000;
    public static final int RTRIGGER_MASK = 0x2000000;
    public static final String[] BIT_TO_TEXT = new String[]{"UP", "DOWN", "LEFT", "RIGHT", "START", "BACK", "LSTICK", "RSTICK", "LB", "RB", "(10)", "(11)", "A", "B", "X", "Y", "LSUP", "LSDOWN", "LSLEFT", "LSRIGHT", "RSUP", "RSDOWN", "RSLEFT", "RSRIGHT", "LTRIGGER", "RTRIGGER"};
    protected static final ValueLayout.OfInt DWORD = ValueLayout.JAVA_INT;
    protected static final ValueLayout.OfShort WORD = ValueLayout.JAVA_SHORT;
    protected static final ValueLayout.OfByte BYTE = ValueLayout.JAVA_BYTE;
    protected static final ValueLayout.OfShort SHORT = ValueLayout.JAVA_SHORT;
    protected static final int ERROR_SUCCESS = 0;
    protected static final MemoryLayout GAMEPAD_LAYOUT = MemoryLayout.structLayout(WORD.withName("wButtons"), BYTE.withName("bLeftTrigger"), BYTE.withName("bRightTrigger"), SHORT.withName("sThumbLX"), SHORT.withName("sThumbLY"), SHORT.withName("sThumbRX"), SHORT.withName("sThumbRY"));
    protected static final long OFFSET_wButtons = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("wButtons"));
    protected static final long OFFSET_bLeftTrigger = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("bLeftTrigger"));
    protected static final long OFFSET_bRightTrigger = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("bRightTrigger"));
    protected static final long OFFSET_sThumbLX = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("sThumbLX"));
    protected static final long OFFSET_sThumbLY = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("sThumbLY"));
    protected static final long OFFSET_sThumbRX = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("sThumbRX"));
    protected static final long OFFSET_sThumbRY = GAMEPAD_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("sThumbRY"));
    protected static final MemoryLayout STATE_LAYOUT = MemoryLayout.structLayout(DWORD.withName("dwPacketNumber"), GAMEPAD_LAYOUT.withName("Gamepad"));
    protected static final long OFFSET_dwPacketNumber = STATE_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("dwPacketNumber"));
    protected Gamepad[] gamepads = new Gamepad[4];
    protected ArrayList<GamepadListener> gamepadListeners;
    protected boolean polling;
    protected MethodHandle XInputGetState;
    protected MemorySegment state;
    protected MemorySegment gamepad;

    public XInput() {
        for (int i = 0; i < 4; ++i) {
            this.gamepads[i] = new Gamepad(this, i);
        }
        this.gamepadListeners = new ArrayList();
        this.polling = true;
        this.start();
    }

    @Override
    public void run() {
        try (Arena arena = Arena.ofConfined();){
            SymbolLookup symbolLookup = SymbolLookup.libraryLookup("XInput1_4.dll", arena);
            Linker linker = Linker.nativeLinker();
            this.XInputGetState = linker.downcallHandle(symbolLookup.findOrThrow("XInputGetState"), FunctionDescriptor.of(DWORD, DWORD, ValueLayout.ADDRESS), new Linker.Option[0]);
            this.state = arena.allocate(STATE_LAYOUT);
            this.gamepad = this.state.asSlice(STATE_LAYOUT.byteOffset(MemoryLayout.PathElement.groupElement("Gamepad")));
            while (this.polling) {
                boolean bl = false;
                int n = 0;
                for (int i = 0; i < 4; ++i) {
                    Gamepad gamepad = this.gamepads[i];
                    if (n != 0 && !gamepad.isAvailable()) continue;
                    boolean bl2 = bl = bl || gamepad.isAvailable();
                    if (!gamepad.getState() || this.gamepadListeners.size() == 0) continue;
                    if (gamepad.isConnected()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.connected(gamepad);
                        }
                    } else if (gamepad.isDisconnected()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.disconnected(gamepad);
                        }
                    }
                    if (!gamepad.isAvailable()) continue;
                    int n2 = gamepad.getPressedButtonMasks();
                    if (n2 != 0) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.buttonPressed(gamepad, n2);
                        }
                    }
                    if ((n2 = gamepad.getReleasedButtonMasks()) != 0) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.buttonReleased(gamepad, n2);
                        }
                    }
                    if (gamepad.isLeftStickMovedX()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.leftStickMovedX(gamepad);
                        }
                    }
                    if (gamepad.isLeftStickMovedY()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.leftStickMovedY(gamepad);
                        }
                    }
                    if (gamepad.isLeftTriggerMoved()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.leftTriggerMoved(gamepad);
                        }
                    }
                    if (gamepad.isRightStickMovedX()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.rightStickMovedX(gamepad);
                        }
                    }
                    if (gamepad.isRightStickMovedY()) {
                        for (GamepadListener gamepadListener : this.gamepadListeners) {
                            gamepadListener.rightStickMovedY(gamepad);
                        }
                    }
                    if (!gamepad.isRightTriggerMoved()) continue;
                    for (GamepadListener gamepadListener : this.gamepadListeners) {
                        gamepadListener.rightTriggerMoved(gamepad);
                    }
                }
                try {
                    if (bl) {
                        n = n + 1 & 0x1F;
                        Thread.sleep(10L);
                        continue;
                    }
                    n = 0;
                    Thread.sleep(320L);
                }
                catch (InterruptedException interruptedException) {
                    if (arena != null) {
                        arena.close();
                    }
                    return;
                }
            }
        }
    }

    public void end() {
        if (this.polling) {
            this.polling = false;
            if (this.isAlive()) {
                this.interrupt();
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.gamepads[i].close();
        }
    }

    public int getButtonMasks(int n) {
        return this.gamepads[n].getButtonMasks();
    }

    public int getLeftStickX(int n) {
        return this.gamepads[n].getLeftStickX();
    }

    public int getLeftStickY(int n) {
        return this.gamepads[n].getLeftStickY();
    }

    public int getLeftTrigger(int n) {
        return this.gamepads[n].getLeftTrigger();
    }

    public int getRightStickX(int n) {
        return this.gamepads[n].getRightStickX();
    }

    public int getRightStickY(int n) {
        return this.gamepads[n].getRightStickY();
    }

    public int getRightTrigger(int n) {
        return this.gamepads[n].getRightTrigger();
    }

    public boolean isAvailable(int n) {
        return this.gamepads[n].isAvailable();
    }

    public void setThresholdOfLeftStick(int n, int n2) {
        this.gamepads[n].setThresholdOfLeftStick(n2);
    }

    public void setThresholdOfRightStick(int n, int n2) {
        this.gamepads[n].setThresholdOfRightStick(n2);
    }

    public void setThresholdOfLeftTrigger(int n, int n2) {
        this.gamepads[n].setThresholdOfLeftTrigger(n2);
    }

    public void setThresholdOfRightTrigger(int n, int n2) {
        this.gamepads[n].setThresholdOfRightTrigger(n2);
    }

    public void addGamepadListener(GamepadListener gamepadListener) {
        if (gamepadListener != null && !this.gamepadListeners.contains(gamepadListener)) {
            this.gamepadListeners.add(gamepadListener);
        }
    }

    public void removeGamepadListener(GamepadListener gamepadListener) {
        this.gamepadListeners.remove(gamepadListener);
    }

    public void removeGamepadListeners() {
        this.gamepadListeners.clear();
    }

    public GamepadListener[] getGamepadListeners() {
        return this.gamepadListeners.toArray(new GamepadListener[this.gamepadListeners.size()]);
    }

    public class Gamepad
    implements AutoCloseable {
        static final int THRESHOLD_OF_STICK = 16384;
        static final int THRESHOLD_OF_TRIGGER = 64;
        int index;
        boolean available;
        int dwPacketNumber;
        int wButtons;
        int bLeftTrigger;
        int bRightTrigger;
        int sThumbLX;
        int sThumbLY;
        int sThumbRX;
        int sThumbRY;
        int buttonMasks;
        boolean previous_available;
        int previous_dwPacketNumber;
        int previous_wButtons;
        int previous_bLeftTrigger;
        int previous_bRightTrigger;
        int previous_sThumbLX;
        int previous_sThumbLY;
        int previous_sThumbRX;
        int previous_sThumbRY;
        int previous_buttonMasks;
        long thresholdOfLeftStick2;
        long thresholdOfRightStick2;
        int thresholdOfLeftTrigger;
        int thresholdOfRightTrigger;
        final /* synthetic */ XInput this$0;

        public Gamepad(XInput xInput, int n) {
            XInput xInput2 = xInput;
            Objects.requireNonNull(xInput2);
            this.this$0 = xInput2;
            this.open(n);
        }

        @Override
        public void close() {
            this.available = false;
            this.dwPacketNumber = 0;
            this.wButtons = 0;
            this.bLeftTrigger = 0;
            this.bRightTrigger = 0;
            this.sThumbLX = 0;
            this.sThumbLY = 0;
            this.sThumbRX = 0;
            this.sThumbRY = 0;
            this.buttonMasks = 0;
            this.previous_available = false;
            this.previous_dwPacketNumber = 0;
            this.previous_wButtons = 0;
            this.previous_bLeftTrigger = 0;
            this.previous_bRightTrigger = 0;
            this.previous_sThumbLX = 0;
            this.previous_sThumbLY = 0;
            this.previous_sThumbRX = 0;
            this.previous_sThumbRY = 0;
            this.previous_buttonMasks = 0;
        }

        public int getButtonMasks() {
            return this.buttonMasks;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLeftStickX() {
            return this.sThumbLX;
        }

        public int getLeftStickY() {
            return this.sThumbLY;
        }

        public int getLeftTrigger() {
            return this.bLeftTrigger;
        }

        public int getPressedButtonMasks() {
            return this.buttonMasks & ~this.previous_buttonMasks;
        }

        public int getReleasedButtonMasks() {
            return ~this.buttonMasks & this.previous_buttonMasks;
        }

        public int getRightStickX() {
            return this.sThumbRX;
        }

        public int getRightStickY() {
            return this.sThumbRY;
        }

        public int getRightTrigger() {
            return this.bRightTrigger;
        }

        public boolean getState() {
            int n;
            int n2;
            int n3;
            int n4;
            this.previous_available = this.available;
            this.previous_wButtons = this.wButtons;
            this.previous_bLeftTrigger = this.bLeftTrigger;
            this.previous_bRightTrigger = this.bRightTrigger;
            this.previous_sThumbLX = this.sThumbLX;
            this.previous_sThumbLY = this.sThumbLY;
            this.previous_sThumbRX = this.sThumbRX;
            this.previous_sThumbRY = this.sThumbRY;
            this.previous_buttonMasks = this.buttonMasks;
            boolean bl = this.available = this.this$0.XInputGetState != null;
            if (this.available) {
                try {
                    this.available = this.this$0.XInputGetState.invoke(this.index, this.this$0.state) == 0;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.available) {
                this.dwPacketNumber = this.this$0.state.get(DWORD, OFFSET_dwPacketNumber);
                this.wButtons = (char)this.this$0.gamepad.get(WORD, OFFSET_wButtons);
                this.bLeftTrigger = 0xFF & this.this$0.gamepad.get(BYTE, OFFSET_bLeftTrigger);
                this.bRightTrigger = 0xFF & this.this$0.gamepad.get(BYTE, OFFSET_bRightTrigger);
                this.sThumbLX = this.this$0.gamepad.get(SHORT, OFFSET_sThumbLX);
                this.sThumbLY = this.this$0.gamepad.get(SHORT, OFFSET_sThumbLY);
                this.sThumbRX = this.this$0.gamepad.get(SHORT, OFFSET_sThumbRX);
                this.sThumbRY = this.this$0.gamepad.get(SHORT, OFFSET_sThumbRY);
            } else {
                this.dwPacketNumber = 0;
                this.wButtons = 0;
                this.bLeftTrigger = 0;
                this.bRightTrigger = 0;
                this.sThumbLX = 0;
                this.sThumbLY = 0;
                this.sThumbRX = 0;
                this.sThumbRY = 0;
            }
            int n5 = this.wButtons;
            int n6 = this.sThumbLX;
            int n7 = this.sThumbLY;
            if (this.thresholdOfLeftStick2 < (long)n6 * (long)n6 + (long)n7 * (long)n7) {
                n4 = 5741 * n6 - 2378 * n7;
                n3 = 2378 * n6 + 5741 * n7;
                n2 = 5741 * n6 + 2378 * n7;
                n = -2378 * n6 + 5741 * n7;
                n5 |= (0 <= (-n4 | -n2) ? 262144 : (0 <= (n4 | n2) ? 524288 : 0)) | (0 <= (-n3 | -n) ? 131072 : (0 <= (n3 | n) ? 65536 : 0));
            }
            if (this.thresholdOfRightStick2 < (long)(n6 = this.sThumbRX) * (long)n6 + (long)(n7 = this.sThumbRY) * (long)n7) {
                n4 = 5741 * n6 - 2378 * n7;
                n3 = 2378 * n6 + 5741 * n7;
                n2 = 5741 * n6 + 2378 * n7;
                n = -2378 * n6 + 5741 * n7;
                n5 |= (0 <= (-n4 | -n2) ? 0x400000 : (0 <= (n4 | n2) ? 0x800000 : 0)) | (0 <= (-n3 | -n) ? 0x200000 : (0 <= (n3 | n) ? 0x100000 : 0));
            }
            if (this.thresholdOfLeftTrigger < this.bLeftTrigger) {
                n5 |= 0x1000000;
            }
            if (this.thresholdOfRightTrigger < this.bRightTrigger) {
                n5 |= 0x2000000;
            }
            this.buttonMasks = n5;
            return this.available != this.previous_available || this.available && this.dwPacketNumber != this.previous_dwPacketNumber;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public boolean isConnected() {
            return this.available && !this.previous_available;
        }

        public boolean isDisconnected() {
            return !this.available && this.previous_available;
        }

        public boolean isLeftStickMovedX() {
            return this.sThumbLX != this.previous_sThumbLX;
        }

        public boolean isLeftStickMovedY() {
            return this.sThumbLY != this.previous_sThumbLY;
        }

        public boolean isLeftTriggerMoved() {
            return this.bLeftTrigger != this.previous_bLeftTrigger;
        }

        public boolean isRightStickMovedX() {
            return this.sThumbRX != this.previous_sThumbRX;
        }

        public boolean isRightStickMovedY() {
            return this.sThumbRY != this.previous_sThumbRY;
        }

        public boolean isRightTriggerMoved() {
            return this.bRightTrigger != this.previous_bRightTrigger;
        }

        private void open(int n) {
            if (n < 0 || 3 < n) {
                throw new IllegalArgumentException(String.format("Controller %d cannot be specified", n));
            }
            this.index = n;
            this.available = false;
            this.dwPacketNumber = 0;
            this.wButtons = 0;
            this.bLeftTrigger = 0;
            this.bRightTrigger = 0;
            this.sThumbLX = 0;
            this.sThumbLY = 0;
            this.sThumbRX = 0;
            this.sThumbRY = 0;
            this.buttonMasks = 0;
            this.previous_available = false;
            this.previous_dwPacketNumber = 0;
            this.previous_wButtons = 0;
            this.previous_bLeftTrigger = 0;
            this.previous_bRightTrigger = 0;
            this.previous_sThumbLX = 0;
            this.previous_sThumbLY = 0;
            this.previous_sThumbRX = 0;
            this.previous_sThumbRY = 0;
            this.previous_buttonMasks = 0;
            this.thresholdOfLeftStick2 = 0x10000000L;
            this.thresholdOfRightStick2 = 0x10000000L;
            this.thresholdOfLeftTrigger = 64;
            this.thresholdOfRightTrigger = 64;
        }

        public void setThresholdOfLeftStick(int n) {
            this.thresholdOfLeftStick2 = (long)n * (long)n;
        }

        public void setThresholdOfRightStick(int n) {
            this.thresholdOfRightStick2 = (long)n * (long)n;
        }

        public void setThresholdOfLeftTrigger(int n) {
            this.thresholdOfLeftTrigger = n;
        }

        public void setThresholdOfRightTrigger(int n) {
            this.thresholdOfRightTrigger = n;
        }
    }

    public static interface GamepadListener {
        public void connected(Gamepad var1);

        public void disconnected(Gamepad var1);

        public void buttonPressed(Gamepad var1, int var2);

        public void buttonReleased(Gamepad var1, int var2);

        public void leftStickMovedX(Gamepad var1);

        public void leftStickMovedY(Gamepad var1);

        public void leftTriggerMoved(Gamepad var1);

        public void rightStickMovedX(Gamepad var1);

        public void rightStickMovedY(Gamepad var1);

        public void rightTriggerMoved(Gamepad var1);
    }

    public static class GamepadAdapter
    implements GamepadListener {
        @Override
        public void connected(Gamepad gamepad) {
        }

        @Override
        public void disconnected(Gamepad gamepad) {
        }

        @Override
        public void buttonPressed(Gamepad gamepad, int n) {
        }

        @Override
        public void buttonReleased(Gamepad gamepad, int n) {
        }

        @Override
        public void leftStickMovedX(Gamepad gamepad) {
        }

        @Override
        public void leftStickMovedY(Gamepad gamepad) {
        }

        @Override
        public void leftTriggerMoved(Gamepad gamepad) {
        }

        @Override
        public void rightStickMovedX(Gamepad gamepad) {
        }

        @Override
        public void rightStickMovedY(Gamepad gamepad) {
        }

        @Override
        public void rightTriggerMoved(Gamepad gamepad) {
        }
    }
}

