/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import xeij.CharacterCode;
import xeij.XEiJ;

public class ByteArray {
    public static final char[] BYA_BASE64_ENCODE_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    public static final char[] BYA_BASE64_DECODE_TABLE = "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@>@@@?456789:;<=@@@@@@@\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019@@@@@@\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123@@@@@".toCharArray();

    public static byte byaRbs(byte[] byArray, int n) {
        return byArray[n];
    }

    public static int byaRbz(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static int byaRws(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    public static int byaRiws(byte[] byArray, int n) {
        return byArray[n + 1] << 8 | byArray[n] & 0xFF;
    }

    public static int byaRwz(byte[] byArray, int n) {
        return (char)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    public static int byaRiwz(byte[] byArray, int n) {
        return (char)(byArray[n + 1] << 8 | byArray[n] & 0xFF);
    }

    public static int byaRls(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (char)(byArray[n + 2] << 8 | byArray[n + 3] & 0xFF);
    }

    public static int byaRils(byte[] byArray, int n) {
        return byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (char)(byArray[n + 1] << 8 | byArray[n] & 0xFF);
    }

    public static long byaRqs(byte[] byArray, int n) {
        return (long)ByteArray.byaRls(byArray, n) << 32 | (long)ByteArray.byaRls(byArray, n + 4) & 0xFFFFFFFFL;
    }

    public static StringBuilder byaRstr(StringBuilder stringBuilder, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = byArray[n + i] & 0xFF;
            if (129 <= n4 && n4 <= 159 || 224 <= n4 && n4 <= 239) {
                int n5;
                int n6 = n5 = n + 1 < n2 ? byArray[n + 1] & 0xFF : 0;
                if (64 <= n5 && n5 != 127 && n5 <= 252) {
                    n3 = CharacterCode.chrSJISToChar[n4 << 8 | n5];
                    if (n3 == 0) {
                        n3 = 65533;
                    }
                    ++n;
                } else {
                    n3 = 46;
                }
            } else {
                n3 = CharacterCode.chrSJISToChar[n4];
                if (n3 == 0) {
                    n3 = 65533;
                }
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder;
    }

    public static void byaWb(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
    }

    public static void byaWw(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8);
        byArray[n + 1] = (byte)n2;
    }

    public static void byaWwArray(byte[] byArray, int n, int[] nArray) {
        for (int n2 : nArray) {
            byArray[n] = (byte)(n2 >> 8);
            byArray[n + 1] = (byte)n2;
            n += 2;
        }
    }

    public static void byaWiw(byte[] byArray, int n, int n2) {
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    public static void byaWl(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static void byaWil(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >> 24);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    public static int byaWstr(byte[] byArray, int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = CharacterCode.chrCharToSJIS[string.charAt(i)];
            if (n3 == 0 && string.charAt(i) != '\u0000') {
                n3 = 33190;
            }
            if (n3 >> 8 != 0) {
                byArray[n++] = (byte)(n3 >> 8);
            }
            byArray[n++] = (byte)n3;
        }
        return n;
    }

    public static int byaCmp(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        for (int i = 0; i < n2 && i < n4; ++i) {
            int n5 = 0xFF & byArray[n + i];
            int n6 = 0xFF & byArray2[n3 + i];
            if (n5 == n6) continue;
            return n5 - n6;
        }
        return n2 - n4;
    }

    public static void byaDump(byte[] byArray, int n, int n2) {
        int n3 = n2 + 15 & 0xFFFFFFF0;
        for (int i = n & 0xFFFFFFF0; i < n3; i += 1024) {
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = Math.min(i + 1024, n3);
            for (int j = i; j < n4; j += 16) {
                int n5;
                XEiJ.fmtHex8(stringBuilder, j).append(' ');
                int n6 = j + 16;
                for (n5 = j; n5 < n6; ++n5) {
                    if (n <= n5 && n5 < n2) {
                        XEiJ.fmtHex2(stringBuilder.append(' '), byArray[n5]);
                        continue;
                    }
                    stringBuilder.append(' ').append(' ').append(' ');
                }
                stringBuilder.append(' ').append(' ');
                n5 = 0;
                int n7 = j + 16;
                for (n6 = j; n6 < n7 || n6 == n7 && n5 != 0; ++n6) {
                    char c;
                    int n8;
                    int n9 = n8 = n <= n6 && n6 < n2 ? byArray[n6] & 0xFF : 32;
                    if ((129 <= n5 && n5 <= 159 || 224 <= n5 && n5 <= 239) && 64 <= n8 && n8 != 127 && n8 <= 252) {
                        c = CharacterCode.chrSJISToChar[n8 |= n5 << 8];
                        if (c != '\u0000') {
                            stringBuilder.append(c);
                        } else {
                            stringBuilder.append('\u203b');
                        }
                        n5 = 0;
                        continue;
                    }
                    if (n5 != 0) {
                        stringBuilder.append('.');
                        n5 = 0;
                    }
                    if (129 <= n8 && n8 <= 159 || 224 <= n8 && n8 <= 239) {
                        n5 = n8;
                        continue;
                    }
                    c = CharacterCode.chrSJISToChar[n8];
                    if (' ' <= c && c != '\u007f') {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append('.');
                }
                stringBuilder.append('\n');
            }
            System.out.print(stringBuilder.toString());
        }
    }

    public static String byaEncodeBase64(byte[] byArray) {
        return ByteArray.byaEncodeBase64(byArray, 0, byArray.length);
    }

    public static String byaEncodeBase64(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        char[] cArray = new char[(n2 + 2) / 3 << 2];
        n2 += n - 2;
        int n6 = n;
        int n7 = 0;
        while (n6 < n2) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray[n6 + 1] & 0xFF;
            n3 = byArray[n6 + 2] & 0xFF;
            cArray[n7] = BYA_BASE64_ENCODE_TABLE[n5 >> 2];
            cArray[n7 + 1] = BYA_BASE64_ENCODE_TABLE[(n5 & 3) << 4 | n4 >> 4];
            cArray[n7 + 2] = BYA_BASE64_ENCODE_TABLE[(n4 & 0xF) << 2 | n3 >> 6];
            cArray[n7 + 3] = BYA_BASE64_ENCODE_TABLE[n3 & 0x3F];
            n6 += 3;
            n7 += 4;
        }
        if (n6 < (n2 += 2)) {
            n5 = byArray[n6] & 0xFF;
            n4 = n6 + 1 < n2 ? byArray[n6 + 1] & 0xFF : 0;
            n3 = n6 + 2 < n2 ? byArray[n6 + 2] & 0xFF : 0;
            cArray[n7] = BYA_BASE64_ENCODE_TABLE[n5 >> 2];
            cArray[n7 + 1] = BYA_BASE64_ENCODE_TABLE[(n5 & 3) << 4 | n4 >> 4];
            cArray[n7 + 2] = n6 + 1 < n2 ? BYA_BASE64_ENCODE_TABLE[(n4 & 0xF) << 2 | n3 >> 6] : 61;
            cArray[n7 + 3] = n6 + 2 < n2 ? BYA_BASE64_ENCODE_TABLE[n3 & 0x3F] : 61;
        }
        return new String(cArray);
    }

    public static byte[] byaDecodeBase64(String string) {
        char c;
        char c2;
        char c3;
        int n;
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            char c4 = cArray[n];
            if (c4 > '\u007f' || (c4 = BYA_BASE64_DECODE_TABLE[c4]) > '?') continue;
            cArray[n3++] = c4;
        }
        n = n3 & 3;
        byte[] byArray = new byte[((n3 -= n) >> 2) * 3 + (n <= 1 ? 0 : n - 1)];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            c3 = cArray[n4];
            c2 = cArray[n4 + 1];
            c = cArray[n4 + 2];
            char c5 = cArray[n4 + 3];
            byArray[n5] = (byte)(c3 << 2 | c2 >> 4);
            byArray[n5 + 1] = (byte)(c2 << 4 | c >> 2);
            byArray[n5 + 2] = (byte)(c << 6 | c5);
            n4 += 4;
            n5 += 3;
        }
        if (n >= 2) {
            c3 = cArray[n4];
            c2 = cArray[n4 + 1];
            byArray[n5] = (byte)(c3 << 2 | c2 >> 4);
            if (n >= 3) {
                c = cArray[n4 + 2];
                byArray[n5 + 1] = (byte)(c2 << 4 | c >> 2);
            }
        }
        return byArray;
    }

    public static byte[] byaEncodeGzip(byte[] byArray) {
        return ByteArray.byaEncodeGzip(byArray, 0, byArray.length);
    }

    public static byte[] byaEncodeGzip(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(-1);
            }
        };){
            gZIPOutputStream.write(byArray, n, n2);
            gZIPOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] byaDecodeGzip(byte[] byArray) {
        return ByteArray.byaDecodeGzip(byArray, 0, byArray.length);
    }

    public static byte[] byaDecodeGzip(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray, n, n2));){
            int n3 = 4096;
            byte[] byArray2 = new byte[n3];
            int n4 = gZIPInputStream.read(byArray2, 0, n3);
            while (n4 >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n4);
                n4 = gZIPInputStream.read(byArray2, 0, n3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int crc32(byte[] byArray) {
        return ByteArray.crc32(byArray, 0, byArray.length);
    }

    public static int crc32(byte[] byArray, int n, int n2) {
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(byArray, n, n2);
        return (int)cRC32.getValue();
    }
}

