/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import xeij.SoundSource;
import xeij.TickerQueue;

public class ADPCM {
    public static final boolean PCM_ON = true;
    public static final int PCM_SAMPLE_FREQ = 62500;
    public static final long PCM_SAMPLE_TIME = 16000000L;
    public static final int PCM_BLOCK_SAMPLES = 2500;
    public static final int PCM_MAX_REPEAT = 16;
    public static final int[] PCM_SAMPLE_REPEAT = new int[]{8, 6, 4, 6, 16, 12, 8, 12, 8, 6, 4, 6, 4, 3, 2, 3};
    public static int pcmOSCFreqRequest;
    public static int pcmOSCFreqMode;
    public static int pcmOscillator;
    public static int pcmDivider;
    public static int pcmRepeat;
    public static long pcmInterval;
    public static final int[] pcmDecoderTable;
    public static int pcmDecoderPointer;
    public static final int[] pcmBuffer;
    public static int pcmPointer;
    public static long pcmClock;
    public static boolean pcmOutputOn;
    public static boolean pcmActive;
    public static int pcmEncodedData;
    public static int pcmDecodedData1;
    public static int pcmDecodedData2;
    public static int pcmDecodedData3;
    public static final boolean PCM_MODIFY_ZERO_ZERO = true;
    public static final boolean PCM_MODIFY_ZERO_TWICE = false;
    public static final int[] pcmDecoderTableP;
    public static final int[] pcmDecoderTableM;
    public static int pcmZeroPreviousData;
    public static final boolean PCM_DECAY_ON = true;
    public static final int PCM_INTERPOLATION_CONSTANT = 0;
    public static final int PCM_INTERPOLATION_LINEAR = 1;
    public static final int PCM_INTERPOLATION_HERMITE = 2;
    public static int pcmInterpolationAlgorithm;
    public static final PIP[][] PCM_INTERPOLATION_MONO;
    public static final PIP[][] PCM_INTERPOLATION_STEREO;
    public static PIP pcmInterpolationEngine;
    public static final int PCM_ATTACK_RATE = 10;
    public static final int PCM_ATTACK_SPAN = 1024;
    public static final int PCM_ATTACK_MASK = 1023;
    public static final int PCM_ATTACK_SHIFT = 14;
    public static final int[] pcmAttackCurve;
    public static int pcmPanLeft;
    public static int pcmPanRight;
    public static int pcmLastPan;

    public static void pcmInit() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        pcmActive = false;
        pcmEncodedData = -1;
        pcmDecodedData1 = 0;
        pcmDecodedData2 = 0;
        pcmDecodedData3 = 0;
        int[] nArray = new int[784];
        int[] nArray2 = new int[784];
        int[] nArray3 = new int[]{-1, -1, -1, -1, 2, 4, 6, 8};
        for (n5 = 0; n5 < 49; ++n5) {
            n4 = (int)Math.floor(16.0 * Math.pow(1.1, n5));
            for (n3 = 0; n3 < 16; ++n3) {
                n2 = n5 << 4 | n3;
                n = ((n3 & 7) << 1 | 1) * n4 >> 3;
                nArray[n2] = (n3 & 8) == 0 ? n : -n;
                nArray2[n2] = Math.max(0, Math.min(48, n5 + nArray3[n3 & 7]));
            }
        }
        for (n5 = 0; n5 < 49; ++n5) {
            for (n4 = 0; n4 < 16; ++n4) {
                n3 = n5 << 8 | n4 << 4;
                for (n2 = 0; n2 < 16; ++n2) {
                    int n6;
                    n = n5 << 4 | n2;
                    int n7 = nArray[n];
                    n = nArray2[n] << 4 | n4;
                    int n8 = nArray[n];
                    int n9 = nArray2[n];
                    ADPCM.pcmDecoderTable[n3 | n2] = n6 = n7 << 19 | (n8 & 0x1FFF) << 6 | n9;
                    ADPCM.pcmDecoderTableP[n3 | n2] = n2 == 0 && n4 == 0 ? (n6 ^ 0xFFF80000) + 524288 : n6;
                    ADPCM.pcmDecoderTableM[n3 | n2] = n2 == 8 && n4 == 8 ? (n6 ^ 0xFFF80000) + 524288 : n6;
                }
            }
        }
        for (n5 = 0; n5 < 1024; ++n5) {
            ADPCM.pcmAttackCurve[n5] = (int)Math.round(8192.0 * (1.0 + Math.cos(0.0030679615757712823 * (double)n5)));
            ADPCM.pcmAttackCurve[2048 + n5] = (int)Math.round(8192.0 * (1.0 + Math.cos(0.0030679615757712823 * (double)n5)));
        }
        Arrays.fill(pcmAttackCurve, 1024, 2048, 0);
        Arrays.fill(pcmAttackCurve, 3072, 4096, 16384);
        pcmPanLeft = 0;
        pcmPanRight = 0;
        ADPCM.pcmReset();
    }

    public static void pcmReset() {
        pcmOSCFreqMode = 0;
        pcmOscillator = 0;
        pcmDivider = 2;
        ADPCM.pcmUpdateRepeatInterval();
        pcmLastPan = 0;
        ADPCM.pcmSetPan(pcmLastPan);
        pcmDecoderPointer = 0;
        Arrays.fill(pcmBuffer, 0);
        pcmPointer = 0;
        pcmClock = Long.MAX_VALUE;
        TickerQueue.tkqRemove(SoundSource.sndPcmTicker);
        pcmActive = false;
        pcmEncodedData = -1;
    }

    public static void pcmUpdateRepeatInterval() {
        pcmRepeat = PCM_SAMPLE_REPEAT[pcmOSCFreqMode << 3 | pcmOscillator << 2 | pcmDivider];
        pcmInterval = 32000000L * (long)pcmRepeat;
        ADPCM.pcmSetInterpolationAlgorithm(pcmInterpolationAlgorithm);
    }

    public static void pcmSetInterpolationAlgorithm(int n) {
        pcmInterpolationAlgorithm = n;
        pcmInterpolationEngine = PCM_INTERPOLATION_STEREO[n][pcmOSCFreqMode << 3 | pcmOscillator << 2 | pcmDivider];
    }

    public static void pcmSetOutputOn(boolean bl) {
        pcmOutputOn = bl;
        ADPCM.pcmSetPan(pcmLastPan);
    }

    public static void pcmSetPan(int n) {
        boolean bl;
        pcmLastPan = n;
        boolean bl2 = pcmPanLeft != 0 && pcmPanLeft >= -2147481600;
        boolean bl3 = bl = pcmOutputOn && (n & 2) == 0;
        if (bl2 != bl) {
            pcmPanLeft = bl ? (pcmPanLeft < -2147482624 ? (pcmPanLeft ^= 0xBFF) : -2147481600) : (pcmPanLeft < -2147480576 ? (pcmPanLeft ^= 0xBFF) : Integer.MIN_VALUE);
        }
        bl2 = pcmPanRight != 0 && pcmPanRight >= -2147481600;
        boolean bl4 = bl = pcmOutputOn && (n & 1) == 0;
        if (bl2 != bl) {
            pcmPanRight = bl ? (pcmPanRight < -2147482624 ? (pcmPanRight ^= 0xBFF) : -2147481600) : (pcmPanRight < -2147480576 ? (pcmPanRight ^= 0xBFF) : Integer.MIN_VALUE);
        }
    }

    public static void pcmFillBuffer(int n) {
        while (pcmPointer < n && (pcmDecodedData1 | pcmDecodedData2 | pcmDecodedData3) != 0) {
            int n2 = pcmDecodedData1;
            pcmInterpolationEngine.write(n2 + (n2 >>> 31) - (-n2 >>> 31));
        }
        if (pcmPointer < n) {
            Arrays.fill(pcmBuffer, pcmPointer, n, 0);
            pcmPointer = n;
        } else if (n < pcmPointer) {
            Arrays.fill(pcmBuffer, n, pcmPointer, 0);
            pcmPointer = n;
        }
    }

    static {
        pcmDecoderTable = new int[12544];
        pcmBuffer = new int[5064];
        pcmDecoderTableP = new int[12544];
        pcmDecoderTableM = new int[12544];
        PCM_INTERPOLATION_MONO = new PIP[][]{{PIP.PIP_MONO_CONSTANT_8, PIP.PIP_MONO_CONSTANT_6, PIP.PIP_MONO_CONSTANT_4, PIP.PIP_MONO_CONSTANT_6, PIP.PIP_MONO_CONSTANT_16, PIP.PIP_MONO_CONSTANT_12, PIP.PIP_MONO_CONSTANT_8, PIP.PIP_MONO_CONSTANT_12, PIP.PIP_MONO_CONSTANT_8, PIP.PIP_MONO_CONSTANT_6, PIP.PIP_MONO_CONSTANT_4, PIP.PIP_MONO_CONSTANT_6, PIP.PIP_MONO_CONSTANT_4, PIP.PIP_MONO_CONSTANT_3, PIP.PIP_MONO_CONSTANT_2, PIP.PIP_MONO_CONSTANT_3}, {PIP.PIP_MONO_LINEAR_8, PIP.PIP_MONO_LINEAR_6, PIP.PIP_MONO_LINEAR_4, PIP.PIP_MONO_LINEAR_6, PIP.PIP_MONO_LINEAR_16, PIP.PIP_MONO_LINEAR_12, PIP.PIP_MONO_LINEAR_8, PIP.PIP_MONO_LINEAR_12, PIP.PIP_MONO_LINEAR_8, PIP.PIP_MONO_LINEAR_6, PIP.PIP_MONO_LINEAR_4, PIP.PIP_MONO_LINEAR_6, PIP.PIP_MONO_LINEAR_4, PIP.PIP_MONO_LINEAR_3, PIP.PIP_MONO_LINEAR_2, PIP.PIP_MONO_LINEAR_3}, {PIP.PIP_MONO_HERMITE_8, PIP.PIP_MONO_HERMITE_6, PIP.PIP_MONO_HERMITE_4, PIP.PIP_MONO_HERMITE_6, PIP.PIP_MONO_HERMITE_16, PIP.PIP_MONO_HERMITE_12, PIP.PIP_MONO_HERMITE_8, PIP.PIP_MONO_HERMITE_12, PIP.PIP_MONO_HERMITE_8, PIP.PIP_MONO_HERMITE_6, PIP.PIP_MONO_HERMITE_4, PIP.PIP_MONO_HERMITE_6, PIP.PIP_MONO_HERMITE_4, PIP.PIP_MONO_HERMITE_3, PIP.PIP_MONO_HERMITE_2, PIP.PIP_MONO_HERMITE_3}};
        PCM_INTERPOLATION_STEREO = new PIP[][]{{PIP.PIP_STEREO_CONSTANT_8, PIP.PIP_STEREO_CONSTANT_6, PIP.PIP_STEREO_CONSTANT_4, PIP.PIP_STEREO_CONSTANT_6, PIP.PIP_STEREO_CONSTANT_16, PIP.PIP_STEREO_CONSTANT_12, PIP.PIP_STEREO_CONSTANT_8, PIP.PIP_STEREO_CONSTANT_12, PIP.PIP_STEREO_CONSTANT_8, PIP.PIP_STEREO_CONSTANT_6, PIP.PIP_STEREO_CONSTANT_4, PIP.PIP_STEREO_CONSTANT_6, PIP.PIP_STEREO_CONSTANT_4, PIP.PIP_STEREO_CONSTANT_3, PIP.PIP_STEREO_CONSTANT_2, PIP.PIP_STEREO_CONSTANT_3}, {PIP.PIP_STEREO_LINEAR_8, PIP.PIP_STEREO_LINEAR_6, PIP.PIP_STEREO_LINEAR_4, PIP.PIP_STEREO_LINEAR_6, PIP.PIP_STEREO_LINEAR_16, PIP.PIP_STEREO_LINEAR_12, PIP.PIP_STEREO_LINEAR_8, PIP.PIP_STEREO_LINEAR_12, PIP.PIP_STEREO_LINEAR_8, PIP.PIP_STEREO_LINEAR_6, PIP.PIP_STEREO_LINEAR_4, PIP.PIP_STEREO_LINEAR_6, PIP.PIP_STEREO_LINEAR_4, PIP.PIP_STEREO_LINEAR_3, PIP.PIP_STEREO_LINEAR_2, PIP.PIP_STEREO_LINEAR_3}, {PIP.PIP_STEREO_HERMITE_8, PIP.PIP_STEREO_HERMITE_6, PIP.PIP_STEREO_HERMITE_4, PIP.PIP_STEREO_HERMITE_6, PIP.PIP_STEREO_HERMITE_16, PIP.PIP_STEREO_HERMITE_12, PIP.PIP_STEREO_HERMITE_8, PIP.PIP_STEREO_HERMITE_12, PIP.PIP_STEREO_HERMITE_8, PIP.PIP_STEREO_HERMITE_6, PIP.PIP_STEREO_HERMITE_4, PIP.PIP_STEREO_HERMITE_6, PIP.PIP_STEREO_HERMITE_4, PIP.PIP_STEREO_HERMITE_3, PIP.PIP_STEREO_HERMITE_2, PIP.PIP_STEREO_HERMITE_3}};
        pcmAttackCurve = new int[4096];
    }

    public static enum PIP {
        PIP_MONO_CONSTANT_16{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 15] = n4;
                    ADPCM.pcmBuffer[n2 + 14] = n4;
                    ADPCM.pcmBuffer[n2 + 13] = n4;
                    ADPCM.pcmBuffer[n2 + 12] = n4;
                    ADPCM.pcmBuffer[n2 + 11] = n4;
                    ADPCM.pcmBuffer[n2 + 10] = n4;
                    ADPCM.pcmBuffer[n2 + 9] = n4;
                    ADPCM.pcmBuffer[n2 + 8] = n4;
                    ADPCM.pcmBuffer[n2 + 7] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 5] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 3] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = n * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = n * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = n * pcmAttackCurve[n3 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = n * pcmAttackCurve[n3 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = n * pcmAttackCurve[n3 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n * pcmAttackCurve[n3 + 15] >> 14;
                    pcmPanLeft = (n3 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 16;
            }
        }
        ,
        PIP_MONO_CONSTANT_12{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 11] = n4;
                    ADPCM.pcmBuffer[n2 + 10] = n4;
                    ADPCM.pcmBuffer[n2 + 9] = n4;
                    ADPCM.pcmBuffer[n2 + 8] = n4;
                    ADPCM.pcmBuffer[n2 + 7] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 5] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 3] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = n * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = n * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 11] >> 14;
                    pcmPanLeft = (n3 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 12;
            }
        }
        ,
        PIP_MONO_CONSTANT_8{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 7] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 5] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 3] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 7] >> 14;
                    pcmPanLeft = (n3 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 8;
            }
        }
        ,
        PIP_MONO_CONSTANT_6{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 5] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 3] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 5] >> 14;
                    pcmPanLeft = (n3 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 6;
            }
        }
        ,
        PIP_MONO_CONSTANT_4{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 3] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 3] >> 14;
                    pcmPanLeft = (n3 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 4;
            }
        }
        ,
        PIP_MONO_CONSTANT_3{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    pcmPanLeft = (n3 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 3;
            }
        }
        ,
        PIP_MONO_CONSTANT_2{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 1] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    pcmPanLeft = (n3 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 2;
            }
        }
        ,
        PIP_MONO_LINEAR_16{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = 15 * n4 + n >> 4;
                    ADPCM.pcmBuffer[n2 + 1] = 7 * n4 + n >> 3;
                    ADPCM.pcmBuffer[n2 + 2] = 13 * n4 + 3 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 3] = 3 * n4 + n >> 2;
                    ADPCM.pcmBuffer[n2 + 4] = 11 * n4 + 5 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 5] = 5 * n4 + 3 * n >> 3;
                    ADPCM.pcmBuffer[n2 + 6] = 9 * n4 + 7 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 7] = n4 + n >> 1;
                    ADPCM.pcmBuffer[n2 + 8] = 7 * n4 + 9 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 9] = 3 * n4 + 5 * n >> 3;
                    ADPCM.pcmBuffer[n2 + 10] = 5 * n4 + 11 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 11] = n4 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n2 + 12] = 3 * n4 + 13 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 13] = n4 + 7 * n >> 3;
                    ADPCM.pcmBuffer[n2 + 14] = n4 + 15 * n >> 4;
                    ADPCM.pcmBuffer[n2 + 15] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (15 * n5 + n >> 4) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (7 * n5 + n >> 3) * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (13 * n5 + 3 * n >> 4) * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (3 * n5 + n >> 2) * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (11 * n5 + 5 * n >> 4) * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (5 * n5 + 3 * n >> 3) * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (9 * n5 + 7 * n >> 4) * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (n5 + n >> 1) * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (7 * n5 + 9 * n >> 4) * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (3 * n5 + 5 * n >> 3) * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (5 * n5 + 11 * n >> 4) * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = (n5 + 3 * n >> 2) * pcmAttackCurve[n3 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = (3 * n5 + 13 * n >> 4) * pcmAttackCurve[n3 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = (n5 + 7 * n >> 3) * pcmAttackCurve[n3 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = (n5 + 15 * n >> 4) * pcmAttackCurve[n3 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n * pcmAttackCurve[n3 + 15] >> 14;
                    pcmPanLeft = (n3 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 16;
            }
        }
        ,
        PIP_MONO_LINEAR_12{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = 60074 * n4 + 5461 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 1] = 54613 * n4 + 10922 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 2] = 3 * n4 + n >> 2;
                    ADPCM.pcmBuffer[n2 + 3] = 43690 * n4 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 4] = 38229 * n4 + 27306 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 5] = n4 + n >> 1;
                    ADPCM.pcmBuffer[n2 + 6] = 27306 * n4 + 38229 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 7] = 21845 * n4 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 8] = n4 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n2 + 9] = 10922 * n4 + 54613 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 10] = 5461 * n4 + 60074 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 11] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (60074 * n5 + 5461 * n >> 16) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (54613 * n5 + 10922 * n >> 16) * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (3 * n5 + n >> 2) * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (43690 * n5 + 21845 * n >> 16) * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (38229 * n5 + 27306 * n >> 16) * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (n5 + n >> 1) * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (27306 * n5 + 38229 * n >> 16) * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (21845 * n5 + 43690 * n >> 16) * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (n5 + 3 * n >> 2) * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (10922 * n5 + 54613 * n >> 16) * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (5461 * n5 + 60074 * n >> 16) * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 11] >> 14;
                    pcmPanLeft = (n3 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 12;
            }
        }
        ,
        PIP_MONO_LINEAR_8{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = 7 * n4 + n >> 3;
                    ADPCM.pcmBuffer[n2 + 1] = 3 * n4 + n >> 2;
                    ADPCM.pcmBuffer[n2 + 2] = 5 * n4 + 3 * n >> 3;
                    ADPCM.pcmBuffer[n2 + 3] = n4 + n >> 1;
                    ADPCM.pcmBuffer[n2 + 4] = 3 * n4 + 5 * n >> 3;
                    ADPCM.pcmBuffer[n2 + 5] = n4 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n2 + 6] = n4 + 7 * n >> 3;
                    ADPCM.pcmBuffer[n2 + 7] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (7 * n5 + n >> 3) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (3 * n5 + n >> 2) * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (5 * n5 + 3 * n >> 3) * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (n5 + n >> 1) * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (3 * n5 + 5 * n >> 3) * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (n5 + 3 * n >> 2) * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (n5 + 7 * n >> 3) * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 7] >> 14;
                    pcmPanLeft = (n3 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 8;
            }
        }
        ,
        PIP_MONO_LINEAR_6{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = 54613 * n4 + 10922 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 1] = 43690 * n4 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 2] = n4 + n >> 1;
                    ADPCM.pcmBuffer[n2 + 3] = 21845 * n4 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 4] = 10922 * n4 + 54613 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 5] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (54613 * n5 + 10922 * n >> 16) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (43690 * n5 + 21845 * n >> 16) * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (n5 + n >> 1) * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (21845 * n5 + 43690 * n >> 16) * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (10922 * n5 + 54613 * n >> 16) * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 5] >> 14;
                    pcmPanLeft = (n3 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 6;
            }
        }
        ,
        PIP_MONO_LINEAR_4{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = 3 * n4 + n >> 2;
                    ADPCM.pcmBuffer[n2 + 1] = n4 + n >> 1;
                    ADPCM.pcmBuffer[n2 + 2] = n4 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n2 + 3] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (3 * n5 + n >> 2) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (n5 + n >> 1) * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (n5 + 3 * n >> 2) * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 3] >> 14;
                    pcmPanLeft = (n3 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 4;
            }
        }
        ,
        PIP_MONO_LINEAR_3{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = 43690 * n4 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 1] = 21845 * n4 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n2 + 2] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (43690 * n5 + 21845 * n >> 16) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (21845 * n5 + 43690 * n >> 16) * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 2] >> 14;
                    pcmPanLeft = (n3 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 3;
            }
        }
        ,
        PIP_MONO_LINEAR_2{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = n4 + n >> 1;
                    ADPCM.pcmBuffer[n2 + 1] = n;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    int n5 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n2] = (n5 + n >> 1) * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3 + 1] >> 14;
                    pcmPanLeft = (n3 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 2;
            }
        }
        ,
        PIP_MONO_HERMITE_16{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -225 * n3 + 8115 * n4 + 317 * n5 - 15 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 1] = -49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 2] = -507 * n3 + 7553 * n4 + 1263 * n5 - 117 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 3] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 4] = -605 * n3 + 6567 * n4 + 2505 * n5 - 275 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 5] = -75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 6] = -567 * n3 + 5301 * n4 + 3899 * n5 - 441 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 7] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 8] = -441 * n3 + 3899 * n4 + 5301 * n5 - 567 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 9] = -45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 10] = -275 * n3 + 2505 * n4 + 6567 * n5 - 605 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 11] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 12] = -117 * n3 + 1263 * n4 + 7553 * n5 - 507 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 13] = -7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 14] = -15 * n3 + 317 * n4 + 8115 * n5 - 225 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 15] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-225 * n3 + 8115 * n4 + 317 * n5 - 15 * n >> 13) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (-49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-507 * n3 + 7553 * n4 + 1263 * n5 - 117 * n >> 13) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-605 * n3 + 6567 * n4 + 2505 * n5 - 275 * n >> 13) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (-567 * n3 + 5301 * n4 + 3899 * n5 - 441 * n >> 13) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (-441 * n3 + 3899 * n4 + 5301 * n5 - 567 * n >> 13) * pcmAttackCurve[n6 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (-45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10) * pcmAttackCurve[n6 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (-275 * n3 + 2505 * n4 + 6567 * n5 - 605 * n >> 13) * pcmAttackCurve[n6 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = (-117 * n3 + 1263 * n4 + 7553 * n5 - 507 * n >> 13) * pcmAttackCurve[n6 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = (-7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10) * pcmAttackCurve[n6 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = (-15 * n3 + 317 * n4 + 8115 * n5 - 225 * n >> 13) * pcmAttackCurve[n6 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n5 * pcmAttackCurve[n6 + 15] >> 14;
                    pcmPanLeft = (n6 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 16;
            }
        }
        ,
        PIP_MONO_HERMITE_12{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = (int)((long)(-121 * n3 + 3399 * n4 + 189 * n5 - 11 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 2] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 4] = (int)((long)(-245 * n3 + 2331 * n4 + 1545 * n5 - 175 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 5] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 6] = (int)((long)(-175 * n3 + 1545 * n4 + 2331 * n5 - 245 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 7] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 8] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 9] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 10] = (int)((long)(-11 * n3 + 189 * n4 + 3399 * n5 - 121 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 11] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (int)((long)(-121 * n3 + 3399 * n4 + 189 * n5 - 11 * n) * 1242757L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (int)((long)(-245 * n3 + 2331 * n4 + 1545 * n5 - 175 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (int)((long)(-175 * n3 + 1545 * n4 + 2331 * n5 - 245 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (int)((long)(-11 * n3 + 189 * n4 + 3399 * n5 - 121 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n5 * pcmAttackCurve[n6 + 11] >> 14;
                    pcmPanLeft = (n6 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 12;
            }
        }
        ,
        PIP_MONO_HERMITE_8{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 1] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 2] = -75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 3] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 4] = -45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 5] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 6] = -7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (-7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n5 * pcmAttackCurve[n6 + 7] >> 14;
                    pcmPanLeft = (n6 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 8;
            }
        }
        ,
        PIP_MONO_HERMITE_6{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 2] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 4] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n5 * pcmAttackCurve[n6 + 5] >> 14;
                    pcmPanLeft = (n6 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 6;
            }
        }
        ,
        PIP_MONO_HERMITE_4{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 1] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 2] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n5 * pcmAttackCurve[n6 + 3] >> 14;
                    pcmPanLeft = (n6 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 4;
            }
        }
        ,
        PIP_MONO_HERMITE_3{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 2] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n5 * pcmAttackCurve[n6 + 2] >> 14;
                    pcmPanLeft = (n6 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 3;
            }
        }
        ,
        PIP_MONO_HERMITE_2{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 1] = n5 * pcmAttackCurve[n6 + 1] >> 14;
                    pcmPanLeft = (n6 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 2;
            }
        }
        ,
        PIP_STEREO_CONSTANT_16{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 30] = n4;
                    ADPCM.pcmBuffer[n2 + 28] = n4;
                    ADPCM.pcmBuffer[n2 + 26] = n4;
                    ADPCM.pcmBuffer[n2 + 24] = n4;
                    ADPCM.pcmBuffer[n2 + 22] = n4;
                    ADPCM.pcmBuffer[n2 + 20] = n4;
                    ADPCM.pcmBuffer[n2 + 18] = n4;
                    ADPCM.pcmBuffer[n2 + 16] = n4;
                    ADPCM.pcmBuffer[n2 + 14] = n4;
                    ADPCM.pcmBuffer[n2 + 12] = n4;
                    ADPCM.pcmBuffer[n2 + 10] = n4;
                    ADPCM.pcmBuffer[n2 + 8] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = n * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 16] = n * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 18] = n * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 20] = n * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 22] = n * pcmAttackCurve[n3 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 24] = n * pcmAttackCurve[n3 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 26] = n * pcmAttackCurve[n3 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 28] = n * pcmAttackCurve[n3 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 30] = n * pcmAttackCurve[n3 + 15] >> 14;
                    pcmPanLeft = (n3 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 30] = 0;
                    ADPCM.pcmBuffer[n2 + 28] = 0;
                    ADPCM.pcmBuffer[n2 + 26] = 0;
                    ADPCM.pcmBuffer[n2 + 24] = 0;
                    ADPCM.pcmBuffer[n2 + 22] = 0;
                    ADPCM.pcmBuffer[n2 + 20] = 0;
                    ADPCM.pcmBuffer[n2 + 18] = 0;
                    ADPCM.pcmBuffer[n2 + 16] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 31] = n5;
                    ADPCM.pcmBuffer[n2 + 29] = n5;
                    ADPCM.pcmBuffer[n2 + 27] = n5;
                    ADPCM.pcmBuffer[n2 + 25] = n5;
                    ADPCM.pcmBuffer[n2 + 23] = n5;
                    ADPCM.pcmBuffer[n2 + 21] = n5;
                    ADPCM.pcmBuffer[n2 + 19] = n5;
                    ADPCM.pcmBuffer[n2 + 17] = n5;
                    ADPCM.pcmBuffer[n2 + 15] = n5;
                    ADPCM.pcmBuffer[n2 + 13] = n5;
                    ADPCM.pcmBuffer[n2 + 11] = n5;
                    ADPCM.pcmBuffer[n2 + 9] = n5;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 17] = n * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 19] = n * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 21] = n * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 23] = n * pcmAttackCurve[n3 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 25] = n * pcmAttackCurve[n3 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 27] = n * pcmAttackCurve[n3 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 29] = n * pcmAttackCurve[n3 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 31] = n * pcmAttackCurve[n3 + 15] >> 14;
                    pcmPanRight = (n3 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 31] = 0;
                    ADPCM.pcmBuffer[n2 + 29] = 0;
                    ADPCM.pcmBuffer[n2 + 27] = 0;
                    ADPCM.pcmBuffer[n2 + 25] = 0;
                    ADPCM.pcmBuffer[n2 + 23] = 0;
                    ADPCM.pcmBuffer[n2 + 21] = 0;
                    ADPCM.pcmBuffer[n2 + 19] = 0;
                    ADPCM.pcmBuffer[n2 + 17] = 0;
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 32;
            }
        }
        ,
        PIP_STEREO_CONSTANT_12{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 22] = n4;
                    ADPCM.pcmBuffer[n2 + 20] = n4;
                    ADPCM.pcmBuffer[n2 + 18] = n4;
                    ADPCM.pcmBuffer[n2 + 16] = n4;
                    ADPCM.pcmBuffer[n2 + 14] = n4;
                    ADPCM.pcmBuffer[n2 + 12] = n4;
                    ADPCM.pcmBuffer[n2 + 10] = n4;
                    ADPCM.pcmBuffer[n2 + 8] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = n * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 16] = n * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 18] = n * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 20] = n * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 22] = n * pcmAttackCurve[n3 + 11] >> 14;
                    pcmPanLeft = (n3 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 22] = 0;
                    ADPCM.pcmBuffer[n2 + 20] = 0;
                    ADPCM.pcmBuffer[n2 + 18] = 0;
                    ADPCM.pcmBuffer[n2 + 16] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 23] = n5;
                    ADPCM.pcmBuffer[n2 + 21] = n5;
                    ADPCM.pcmBuffer[n2 + 19] = n5;
                    ADPCM.pcmBuffer[n2 + 17] = n5;
                    ADPCM.pcmBuffer[n2 + 15] = n5;
                    ADPCM.pcmBuffer[n2 + 13] = n5;
                    ADPCM.pcmBuffer[n2 + 11] = n5;
                    ADPCM.pcmBuffer[n2 + 9] = n5;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n * pcmAttackCurve[n3 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 17] = n * pcmAttackCurve[n3 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 19] = n * pcmAttackCurve[n3 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 21] = n * pcmAttackCurve[n3 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 23] = n * pcmAttackCurve[n3 + 11] >> 14;
                    pcmPanRight = (n3 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 23] = 0;
                    ADPCM.pcmBuffer[n2 + 21] = 0;
                    ADPCM.pcmBuffer[n2 + 19] = 0;
                    ADPCM.pcmBuffer[n2 + 17] = 0;
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 24;
            }
        }
        ,
        PIP_STEREO_CONSTANT_8{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 14] = n4;
                    ADPCM.pcmBuffer[n2 + 12] = n4;
                    ADPCM.pcmBuffer[n2 + 10] = n4;
                    ADPCM.pcmBuffer[n2 + 8] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = n * pcmAttackCurve[n3 + 7] >> 14;
                    pcmPanLeft = (n3 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 15] = n5;
                    ADPCM.pcmBuffer[n2 + 13] = n5;
                    ADPCM.pcmBuffer[n2 + 11] = n5;
                    ADPCM.pcmBuffer[n2 + 9] = n5;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = n * pcmAttackCurve[n3 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n * pcmAttackCurve[n3 + 7] >> 14;
                    pcmPanRight = (n3 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 16;
            }
        }
        ,
        PIP_STEREO_CONSTANT_6{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 10] = n4;
                    ADPCM.pcmBuffer[n2 + 8] = n4;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n * pcmAttackCurve[n3 + 5] >> 14;
                    pcmPanLeft = (n3 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 11] = n5;
                    ADPCM.pcmBuffer[n2 + 9] = n5;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = n * pcmAttackCurve[n3 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n * pcmAttackCurve[n3 + 5] >> 14;
                    pcmPanRight = (n3 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 12;
            }
        }
        ,
        PIP_STEREO_CONSTANT_4{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 6] = n4;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n * pcmAttackCurve[n3 + 3] >> 14;
                    pcmPanLeft = (n3 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n * pcmAttackCurve[n3 + 3] >> 14;
                    pcmPanRight = (n3 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 8;
            }
        }
        ,
        PIP_STEREO_CONSTANT_3{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 4] = n4;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n * pcmAttackCurve[n3 + 2] >> 14;
                    pcmPanLeft = (n3 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n * pcmAttackCurve[n3 + 2] >> 14;
                    pcmPanRight = (n3 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 6;
            }
        }
        ,
        PIP_STEREO_CONSTANT_2{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmPanLeft;
                if (n3 > 0) {
                    int n4 = n;
                    ADPCM.pcmBuffer[n2 + 2] = n4;
                    ADPCM.pcmBuffer[n2] = n4;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n * pcmAttackCurve[n3 + 1] >> 14;
                    pcmPanLeft = (n3 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n3 = pcmPanRight;
                if (n3 > 0) {
                    int n5 = n;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                    ADPCM.pcmBuffer[n2 + 1] = n5;
                } else if (n3 < 0) {
                    n3 = (char)n3;
                    ADPCM.pcmBuffer[n2 + 1] = n * pcmAttackCurve[n3] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n * pcmAttackCurve[n3 + 1] >> 14;
                    pcmPanRight = (n3 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n3 : n3 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n2 + 4;
            }
        }
        ,
        PIP_STEREO_LINEAR_16{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = 15 * n2 + n >> 4;
                    ADPCM.pcmBuffer[n3 + 2] = 7 * n2 + n >> 3;
                    ADPCM.pcmBuffer[n3 + 4] = 13 * n2 + 3 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 6] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 8] = 11 * n2 + 5 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 10] = 5 * n2 + 3 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 12] = 9 * n2 + 7 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 14] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 16] = 7 * n2 + 9 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 18] = 3 * n2 + 5 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 20] = 5 * n2 + 11 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 22] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 24] = 3 * n2 + 13 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 26] = n2 + 7 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 28] = n2 + 15 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 30] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (15 * n2 + n >> 4) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = (7 * n2 + n >> 3) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 4] = (13 * n2 + 3 * n >> 4) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 6] = (3 * n2 + n >> 2) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 8] = (11 * n2 + 5 * n >> 4) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 10] = (5 * n2 + 3 * n >> 3) * pcmAttackCurve[n4 + 5] >> 14;
                    ADPCM.pcmBuffer[n3 + 12] = (9 * n2 + 7 * n >> 4) * pcmAttackCurve[n4 + 6] >> 14;
                    ADPCM.pcmBuffer[n3 + 14] = (n2 + n >> 1) * pcmAttackCurve[n4 + 7] >> 14;
                    ADPCM.pcmBuffer[n3 + 16] = (7 * n2 + 9 * n >> 4) * pcmAttackCurve[n4 + 8] >> 14;
                    ADPCM.pcmBuffer[n3 + 18] = (3 * n2 + 5 * n >> 3) * pcmAttackCurve[n4 + 9] >> 14;
                    ADPCM.pcmBuffer[n3 + 20] = (5 * n2 + 11 * n >> 4) * pcmAttackCurve[n4 + 10] >> 14;
                    ADPCM.pcmBuffer[n3 + 22] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 11] >> 14;
                    ADPCM.pcmBuffer[n3 + 24] = (3 * n2 + 13 * n >> 4) * pcmAttackCurve[n4 + 12] >> 14;
                    ADPCM.pcmBuffer[n3 + 26] = (n2 + 7 * n >> 3) * pcmAttackCurve[n4 + 13] >> 14;
                    ADPCM.pcmBuffer[n3 + 28] = (n2 + 15 * n >> 4) * pcmAttackCurve[n4 + 14] >> 14;
                    ADPCM.pcmBuffer[n3 + 30] = n * pcmAttackCurve[n4 + 15] >> 14;
                    pcmPanLeft = (n4 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 30] = 0;
                    ADPCM.pcmBuffer[n3 + 28] = 0;
                    ADPCM.pcmBuffer[n3 + 26] = 0;
                    ADPCM.pcmBuffer[n3 + 24] = 0;
                    ADPCM.pcmBuffer[n3 + 22] = 0;
                    ADPCM.pcmBuffer[n3 + 20] = 0;
                    ADPCM.pcmBuffer[n3 + 18] = 0;
                    ADPCM.pcmBuffer[n3 + 16] = 0;
                    ADPCM.pcmBuffer[n3 + 14] = 0;
                    ADPCM.pcmBuffer[n3 + 12] = 0;
                    ADPCM.pcmBuffer[n3 + 10] = 0;
                    ADPCM.pcmBuffer[n3 + 8] = 0;
                    ADPCM.pcmBuffer[n3 + 6] = 0;
                    ADPCM.pcmBuffer[n3 + 4] = 0;
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = 15 * n2 + n >> 4;
                    ADPCM.pcmBuffer[n3 + 3] = 7 * n2 + n >> 3;
                    ADPCM.pcmBuffer[n3 + 5] = 13 * n2 + 3 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 7] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 9] = 11 * n2 + 5 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 11] = 5 * n2 + 3 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 13] = 9 * n2 + 7 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 15] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 17] = 7 * n2 + 9 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 19] = 3 * n2 + 5 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 21] = 5 * n2 + 11 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 23] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 25] = 3 * n2 + 13 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 27] = n2 + 7 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 29] = n2 + 15 * n >> 4;
                    ADPCM.pcmBuffer[n3 + 31] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (15 * n2 + n >> 4) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = (7 * n2 + n >> 3) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 5] = (13 * n2 + 3 * n >> 4) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 7] = (3 * n2 + n >> 2) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 9] = (11 * n2 + 5 * n >> 4) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 11] = (5 * n2 + 3 * n >> 3) * pcmAttackCurve[n4 + 5] >> 14;
                    ADPCM.pcmBuffer[n3 + 13] = (9 * n2 + 7 * n >> 4) * pcmAttackCurve[n4 + 6] >> 14;
                    ADPCM.pcmBuffer[n3 + 15] = (n2 + n >> 1) * pcmAttackCurve[n4 + 7] >> 14;
                    ADPCM.pcmBuffer[n3 + 17] = (7 * n2 + 9 * n >> 4) * pcmAttackCurve[n4 + 8] >> 14;
                    ADPCM.pcmBuffer[n3 + 19] = (3 * n2 + 5 * n >> 3) * pcmAttackCurve[n4 + 9] >> 14;
                    ADPCM.pcmBuffer[n3 + 21] = (5 * n2 + 11 * n >> 4) * pcmAttackCurve[n4 + 10] >> 14;
                    ADPCM.pcmBuffer[n3 + 23] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 11] >> 14;
                    ADPCM.pcmBuffer[n3 + 25] = (3 * n2 + 13 * n >> 4) * pcmAttackCurve[n4 + 12] >> 14;
                    ADPCM.pcmBuffer[n3 + 27] = (n2 + 7 * n >> 3) * pcmAttackCurve[n4 + 13] >> 14;
                    ADPCM.pcmBuffer[n3 + 29] = (n2 + 15 * n >> 4) * pcmAttackCurve[n4 + 14] >> 14;
                    ADPCM.pcmBuffer[n3 + 31] = n * pcmAttackCurve[n4 + 15] >> 14;
                    pcmPanRight = (n4 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 31] = 0;
                    ADPCM.pcmBuffer[n3 + 29] = 0;
                    ADPCM.pcmBuffer[n3 + 27] = 0;
                    ADPCM.pcmBuffer[n3 + 25] = 0;
                    ADPCM.pcmBuffer[n3 + 23] = 0;
                    ADPCM.pcmBuffer[n3 + 21] = 0;
                    ADPCM.pcmBuffer[n3 + 19] = 0;
                    ADPCM.pcmBuffer[n3 + 17] = 0;
                    ADPCM.pcmBuffer[n3 + 15] = 0;
                    ADPCM.pcmBuffer[n3 + 13] = 0;
                    ADPCM.pcmBuffer[n3 + 11] = 0;
                    ADPCM.pcmBuffer[n3 + 9] = 0;
                    ADPCM.pcmBuffer[n3 + 7] = 0;
                    ADPCM.pcmBuffer[n3 + 5] = 0;
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 32;
            }
        }
        ,
        PIP_STEREO_LINEAR_12{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = 60074 * n2 + 5461 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 2] = 54613 * n2 + 10922 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 4] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 6] = 43690 * n2 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 8] = 38229 * n2 + 27306 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 10] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 12] = 27306 * n2 + 38229 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 14] = 21845 * n2 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 16] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 18] = 10922 * n2 + 54613 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 20] = 5461 * n2 + 60074 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 22] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (60074 * n2 + 5461 * n >> 16) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = (54613 * n2 + 10922 * n >> 16) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 4] = (3 * n2 + n >> 2) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 6] = (43690 * n2 + 21845 * n >> 16) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 8] = (38229 * n2 + 27306 * n >> 16) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 10] = (n2 + n >> 1) * pcmAttackCurve[n4 + 5] >> 14;
                    ADPCM.pcmBuffer[n3 + 12] = (27306 * n2 + 38229 * n >> 16) * pcmAttackCurve[n4 + 6] >> 14;
                    ADPCM.pcmBuffer[n3 + 14] = (21845 * n2 + 43690 * n >> 16) * pcmAttackCurve[n4 + 7] >> 14;
                    ADPCM.pcmBuffer[n3 + 16] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 8] >> 14;
                    ADPCM.pcmBuffer[n3 + 18] = (10922 * n2 + 54613 * n >> 16) * pcmAttackCurve[n4 + 9] >> 14;
                    ADPCM.pcmBuffer[n3 + 20] = (5461 * n2 + 60074 * n >> 16) * pcmAttackCurve[n4 + 10] >> 14;
                    ADPCM.pcmBuffer[n3 + 22] = n * pcmAttackCurve[n4 + 11] >> 14;
                    pcmPanLeft = (n4 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 22] = 0;
                    ADPCM.pcmBuffer[n3 + 20] = 0;
                    ADPCM.pcmBuffer[n3 + 18] = 0;
                    ADPCM.pcmBuffer[n3 + 16] = 0;
                    ADPCM.pcmBuffer[n3 + 14] = 0;
                    ADPCM.pcmBuffer[n3 + 12] = 0;
                    ADPCM.pcmBuffer[n3 + 10] = 0;
                    ADPCM.pcmBuffer[n3 + 8] = 0;
                    ADPCM.pcmBuffer[n3 + 6] = 0;
                    ADPCM.pcmBuffer[n3 + 4] = 0;
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = 60074 * n2 + 5461 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 3] = 54613 * n2 + 10922 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 5] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 7] = 43690 * n2 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 9] = 38229 * n2 + 27306 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 11] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 13] = 27306 * n2 + 38229 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 15] = 21845 * n2 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 17] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 19] = 10922 * n2 + 54613 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 21] = 5461 * n2 + 60074 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 23] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (60074 * n2 + 5461 * n >> 16) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = (54613 * n2 + 10922 * n >> 16) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 5] = (3 * n2 + n >> 2) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 7] = (43690 * n2 + 21845 * n >> 16) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 9] = (38229 * n2 + 27306 * n >> 16) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 11] = (n2 + n >> 1) * pcmAttackCurve[n4 + 5] >> 14;
                    ADPCM.pcmBuffer[n3 + 13] = (27306 * n2 + 38229 * n >> 16) * pcmAttackCurve[n4 + 6] >> 14;
                    ADPCM.pcmBuffer[n3 + 15] = (21845 * n2 + 43690 * n >> 16) * pcmAttackCurve[n4 + 7] >> 14;
                    ADPCM.pcmBuffer[n3 + 17] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 8] >> 14;
                    ADPCM.pcmBuffer[n3 + 19] = (10922 * n2 + 54613 * n >> 16) * pcmAttackCurve[n4 + 9] >> 14;
                    ADPCM.pcmBuffer[n3 + 21] = (5461 * n2 + 60074 * n >> 16) * pcmAttackCurve[n4 + 10] >> 14;
                    ADPCM.pcmBuffer[n3 + 23] = n * pcmAttackCurve[n4 + 11] >> 14;
                    pcmPanRight = (n4 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 23] = 0;
                    ADPCM.pcmBuffer[n3 + 21] = 0;
                    ADPCM.pcmBuffer[n3 + 19] = 0;
                    ADPCM.pcmBuffer[n3 + 17] = 0;
                    ADPCM.pcmBuffer[n3 + 15] = 0;
                    ADPCM.pcmBuffer[n3 + 13] = 0;
                    ADPCM.pcmBuffer[n3 + 11] = 0;
                    ADPCM.pcmBuffer[n3 + 9] = 0;
                    ADPCM.pcmBuffer[n3 + 7] = 0;
                    ADPCM.pcmBuffer[n3 + 5] = 0;
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 24;
            }
        }
        ,
        PIP_STEREO_LINEAR_8{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = 7 * n2 + n >> 3;
                    ADPCM.pcmBuffer[n3 + 2] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 4] = 5 * n2 + 3 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 6] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 8] = 3 * n2 + 5 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 10] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 12] = n2 + 7 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 14] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (7 * n2 + n >> 3) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = (3 * n2 + n >> 2) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 4] = (5 * n2 + 3 * n >> 3) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 6] = (n2 + n >> 1) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 8] = (3 * n2 + 5 * n >> 3) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 10] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 5] >> 14;
                    ADPCM.pcmBuffer[n3 + 12] = (n2 + 7 * n >> 3) * pcmAttackCurve[n4 + 6] >> 14;
                    ADPCM.pcmBuffer[n3 + 14] = n * pcmAttackCurve[n4 + 7] >> 14;
                    pcmPanLeft = (n4 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 14] = 0;
                    ADPCM.pcmBuffer[n3 + 12] = 0;
                    ADPCM.pcmBuffer[n3 + 10] = 0;
                    ADPCM.pcmBuffer[n3 + 8] = 0;
                    ADPCM.pcmBuffer[n3 + 6] = 0;
                    ADPCM.pcmBuffer[n3 + 4] = 0;
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = 7 * n2 + n >> 3;
                    ADPCM.pcmBuffer[n3 + 3] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 5] = 5 * n2 + 3 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 7] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 9] = 3 * n2 + 5 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 11] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 13] = n2 + 7 * n >> 3;
                    ADPCM.pcmBuffer[n3 + 15] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (7 * n2 + n >> 3) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = (3 * n2 + n >> 2) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 5] = (5 * n2 + 3 * n >> 3) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 7] = (n2 + n >> 1) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 9] = (3 * n2 + 5 * n >> 3) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 11] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 5] >> 14;
                    ADPCM.pcmBuffer[n3 + 13] = (n2 + 7 * n >> 3) * pcmAttackCurve[n4 + 6] >> 14;
                    ADPCM.pcmBuffer[n3 + 15] = n * pcmAttackCurve[n4 + 7] >> 14;
                    pcmPanRight = (n4 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 15] = 0;
                    ADPCM.pcmBuffer[n3 + 13] = 0;
                    ADPCM.pcmBuffer[n3 + 11] = 0;
                    ADPCM.pcmBuffer[n3 + 9] = 0;
                    ADPCM.pcmBuffer[n3 + 7] = 0;
                    ADPCM.pcmBuffer[n3 + 5] = 0;
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 16;
            }
        }
        ,
        PIP_STEREO_LINEAR_6{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = 54613 * n2 + 10922 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 2] = 43690 * n2 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 4] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 6] = 21845 * n2 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 8] = 10922 * n2 + 54613 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 10] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (54613 * n2 + 10922 * n >> 16) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = (43690 * n2 + 21845 * n >> 16) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 4] = (n2 + n >> 1) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 6] = (21845 * n2 + 43690 * n >> 16) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 8] = (10922 * n2 + 54613 * n >> 16) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 10] = n * pcmAttackCurve[n4 + 5] >> 14;
                    pcmPanLeft = (n4 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 10] = 0;
                    ADPCM.pcmBuffer[n3 + 8] = 0;
                    ADPCM.pcmBuffer[n3 + 6] = 0;
                    ADPCM.pcmBuffer[n3 + 4] = 0;
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = 54613 * n2 + 10922 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 3] = 43690 * n2 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 5] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 7] = 21845 * n2 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 9] = 10922 * n2 + 54613 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 11] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (54613 * n2 + 10922 * n >> 16) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = (43690 * n2 + 21845 * n >> 16) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 5] = (n2 + n >> 1) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 7] = (21845 * n2 + 43690 * n >> 16) * pcmAttackCurve[n4 + 3] >> 14;
                    ADPCM.pcmBuffer[n3 + 9] = (10922 * n2 + 54613 * n >> 16) * pcmAttackCurve[n4 + 4] >> 14;
                    ADPCM.pcmBuffer[n3 + 11] = n * pcmAttackCurve[n4 + 5] >> 14;
                    pcmPanRight = (n4 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 11] = 0;
                    ADPCM.pcmBuffer[n3 + 9] = 0;
                    ADPCM.pcmBuffer[n3 + 7] = 0;
                    ADPCM.pcmBuffer[n3 + 5] = 0;
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 12;
            }
        }
        ,
        PIP_STEREO_LINEAR_4{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 2] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 4] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 6] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (3 * n2 + n >> 2) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = (n2 + n >> 1) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 4] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 6] = n * pcmAttackCurve[n4 + 3] >> 14;
                    pcmPanLeft = (n4 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 6] = 0;
                    ADPCM.pcmBuffer[n3 + 4] = 0;
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = 3 * n2 + n >> 2;
                    ADPCM.pcmBuffer[n3 + 3] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 5] = n2 + 3 * n >> 2;
                    ADPCM.pcmBuffer[n3 + 7] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (3 * n2 + n >> 2) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = (n2 + n >> 1) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 5] = (n2 + 3 * n >> 2) * pcmAttackCurve[n4 + 2] >> 14;
                    ADPCM.pcmBuffer[n3 + 7] = n * pcmAttackCurve[n4 + 3] >> 14;
                    pcmPanRight = (n4 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 7] = 0;
                    ADPCM.pcmBuffer[n3 + 5] = 0;
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 8;
            }
        }
        ,
        PIP_STEREO_LINEAR_3{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = 43690 * n2 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 2] = 21845 * n2 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 4] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (43690 * n2 + 21845 * n >> 16) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = (21845 * n2 + 43690 * n >> 16) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 4] = n * pcmAttackCurve[n4 + 2] >> 14;
                    pcmPanLeft = (n4 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 4] = 0;
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = 43690 * n2 + 21845 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 3] = 21845 * n2 + 43690 * n >> 16;
                    ADPCM.pcmBuffer[n3 + 5] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (43690 * n2 + 21845 * n >> 16) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = (21845 * n2 + 43690 * n >> 16) * pcmAttackCurve[n4 + 1] >> 14;
                    ADPCM.pcmBuffer[n3 + 5] = n * pcmAttackCurve[n4 + 2] >> 14;
                    pcmPanRight = (n4 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 5] = 0;
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 6;
            }
        }
        ,
        PIP_STEREO_LINEAR_2{

            @Override
            public void write(int n) {
                int n2;
                int n3 = pcmPointer;
                int n4 = pcmPanLeft;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 2] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3] = (n2 + n >> 1) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 2] = n * pcmAttackCurve[n4 + 1] >> 14;
                    pcmPanLeft = (n4 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 2] = 0;
                    ADPCM.pcmBuffer[n3] = 0;
                }
                n4 = pcmPanRight;
                if (n4 > 0) {
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = n2 + n >> 1;
                    ADPCM.pcmBuffer[n3 + 3] = n;
                } else if (n4 < 0) {
                    n4 = (char)n4;
                    n2 = pcmDecodedData1;
                    ADPCM.pcmBuffer[n3 + 1] = (n2 + n >> 1) * pcmAttackCurve[n4] >> 14;
                    ADPCM.pcmBuffer[n3 + 3] = n * pcmAttackCurve[n4 + 1] >> 14;
                    pcmPanRight = (n4 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n4 : n4 >> 11;
                } else {
                    ADPCM.pcmBuffer[n3 + 3] = 0;
                    ADPCM.pcmBuffer[n3 + 1] = 0;
                }
                pcmDecodedData1 = n;
                pcmPointer = n3 + 4;
            }
        }
        ,
        PIP_STEREO_HERMITE_16{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -225 * n3 + 8115 * n4 + 317 * n5 - 15 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 2] = -49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 4] = -507 * n3 + 7553 * n4 + 1263 * n5 - 117 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 6] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 8] = -605 * n3 + 6567 * n4 + 2505 * n5 - 275 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 10] = -75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 12] = -567 * n3 + 5301 * n4 + 3899 * n5 - 441 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 14] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 16] = -441 * n3 + 3899 * n4 + 5301 * n5 - 567 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 18] = -45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 20] = -275 * n3 + 2505 * n4 + 6567 * n5 - 605 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 22] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 24] = -117 * n3 + 1263 * n4 + 7553 * n5 - 507 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 26] = -7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 28] = -15 * n3 + 317 * n4 + 8115 * n5 - 225 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 30] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-225 * n3 + 8115 * n4 + 317 * n5 - 15 * n >> 13) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-507 * n3 + 7553 * n4 + 1263 * n5 - 117 * n >> 13) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (-605 * n3 + 6567 * n4 + 2505 * n5 - 275 * n >> 13) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (-75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = (-567 * n3 + 5301 * n4 + 3899 * n5 - 441 * n >> 13) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 16] = (-441 * n3 + 3899 * n4 + 5301 * n5 - 567 * n >> 13) * pcmAttackCurve[n6 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 18] = (-45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10) * pcmAttackCurve[n6 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 20] = (-275 * n3 + 2505 * n4 + 6567 * n5 - 605 * n >> 13) * pcmAttackCurve[n6 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 22] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 24] = (-117 * n3 + 1263 * n4 + 7553 * n5 - 507 * n >> 13) * pcmAttackCurve[n6 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 26] = (-7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10) * pcmAttackCurve[n6 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 28] = (-15 * n3 + 317 * n4 + 8115 * n5 - 225 * n >> 13) * pcmAttackCurve[n6 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 30] = n5 * pcmAttackCurve[n6 + 15] >> 14;
                    pcmPanLeft = (n6 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 30] = 0;
                    ADPCM.pcmBuffer[n2 + 28] = 0;
                    ADPCM.pcmBuffer[n2 + 26] = 0;
                    ADPCM.pcmBuffer[n2 + 24] = 0;
                    ADPCM.pcmBuffer[n2 + 22] = 0;
                    ADPCM.pcmBuffer[n2 + 20] = 0;
                    ADPCM.pcmBuffer[n2 + 18] = 0;
                    ADPCM.pcmBuffer[n2 + 16] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = -225 * n3 + 8115 * n4 + 317 * n5 - 15 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 3] = -49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 5] = -507 * n3 + 7553 * n4 + 1263 * n5 - 117 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 7] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 9] = -605 * n3 + 6567 * n4 + 2505 * n5 - 275 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 11] = -75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 13] = -567 * n3 + 5301 * n4 + 3899 * n5 - 441 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 15] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 17] = -441 * n3 + 3899 * n4 + 5301 * n5 - 567 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 19] = -45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 21] = -275 * n3 + 2505 * n4 + 6567 * n5 - 605 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 23] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 25] = -117 * n3 + 1263 * n4 + 7553 * n5 - 507 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 27] = -7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 29] = -15 * n3 + 317 * n4 + 8115 * n5 - 225 * n >> 13;
                    ADPCM.pcmBuffer[n2 + 31] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (-225 * n3 + 8115 * n4 + 317 * n5 - 15 * n >> 13) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (-49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-507 * n3 + 7553 * n4 + 1263 * n5 - 117 * n >> 13) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (-605 * n3 + 6567 * n4 + 2505 * n5 - 275 * n >> 13) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = (-75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = (-567 * n3 + 5301 * n4 + 3899 * n5 - 441 * n >> 13) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 17] = (-441 * n3 + 3899 * n4 + 5301 * n5 - 567 * n >> 13) * pcmAttackCurve[n6 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 19] = (-45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10) * pcmAttackCurve[n6 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 21] = (-275 * n3 + 2505 * n4 + 6567 * n5 - 605 * n >> 13) * pcmAttackCurve[n6 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 23] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 11] >> 14;
                    ADPCM.pcmBuffer[n2 + 25] = (-117 * n3 + 1263 * n4 + 7553 * n5 - 507 * n >> 13) * pcmAttackCurve[n6 + 12] >> 14;
                    ADPCM.pcmBuffer[n2 + 27] = (-7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10) * pcmAttackCurve[n6 + 13] >> 14;
                    ADPCM.pcmBuffer[n2 + 29] = (-15 * n3 + 317 * n4 + 8115 * n5 - 225 * n >> 13) * pcmAttackCurve[n6 + 14] >> 14;
                    ADPCM.pcmBuffer[n2 + 31] = n5 * pcmAttackCurve[n6 + 15] >> 14;
                    pcmPanRight = (n6 += 16) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 31] = 0;
                    ADPCM.pcmBuffer[n2 + 29] = 0;
                    ADPCM.pcmBuffer[n2 + 27] = 0;
                    ADPCM.pcmBuffer[n2 + 25] = 0;
                    ADPCM.pcmBuffer[n2 + 23] = 0;
                    ADPCM.pcmBuffer[n2 + 21] = 0;
                    ADPCM.pcmBuffer[n2 + 19] = 0;
                    ADPCM.pcmBuffer[n2 + 17] = 0;
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 32;
            }
        }
        ,
        PIP_STEREO_HERMITE_12{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = (int)((long)(-121 * n3 + 3399 * n4 + 189 * n5 - 11 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 2] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 4] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 6] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 8] = (int)((long)(-245 * n3 + 2331 * n4 + 1545 * n5 - 175 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 10] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 12] = (int)((long)(-175 * n3 + 1545 * n4 + 2331 * n5 - 245 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 14] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 16] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 18] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 20] = (int)((long)(-11 * n3 + 189 * n4 + 3399 * n5 - 121 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 22] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (int)((long)(-121 * n3 + 3399 * n4 + 189 * n5 - 11 * n) * 1242757L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (int)((long)(-245 * n3 + 2331 * n4 + 1545 * n5 - 175 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = (int)((long)(-175 * n3 + 1545 * n4 + 2331 * n5 - 245 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 16] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 18] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 20] = (int)((long)(-11 * n3 + 189 * n4 + 3399 * n5 - 121 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 22] = n5 * pcmAttackCurve[n6 + 11] >> 14;
                    pcmPanLeft = (n6 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 22] = 0;
                    ADPCM.pcmBuffer[n2 + 20] = 0;
                    ADPCM.pcmBuffer[n2 + 18] = 0;
                    ADPCM.pcmBuffer[n2 + 16] = 0;
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-121 * n3 + 3399 * n4 + 189 * n5 - 11 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 5] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 7] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 9] = (int)((long)(-245 * n3 + 2331 * n4 + 1545 * n5 - 175 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 11] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 13] = (int)((long)(-175 * n3 + 1545 * n4 + 2331 * n5 - 245 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 15] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 17] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 19] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 21] = (int)((long)(-11 * n3 + 189 * n4 + 3399 * n5 - 121 * n) * 1242757L >> 32);
                    ADPCM.pcmBuffer[n2 + 23] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-121 * n3 + 3399 * n4 + 189 * n5 - 11 * n) * 1242757L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (int)((long)(-245 * n3 + 2331 * n4 + 1545 * n5 - 175 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = (int)((long)(-175 * n3 + 1545 * n4 + 2331 * n5 - 245 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 7] >> 14;
                    ADPCM.pcmBuffer[n2 + 17] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 8] >> 14;
                    ADPCM.pcmBuffer[n2 + 19] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 9] >> 14;
                    ADPCM.pcmBuffer[n2 + 21] = (int)((long)(-11 * n3 + 189 * n4 + 3399 * n5 - 121 * n) * 1242757L >> 32) * pcmAttackCurve[n6 + 10] >> 14;
                    ADPCM.pcmBuffer[n2 + 23] = n5 * pcmAttackCurve[n6 + 11] >> 14;
                    pcmPanRight = (n6 += 12) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 23] = 0;
                    ADPCM.pcmBuffer[n2 + 21] = 0;
                    ADPCM.pcmBuffer[n2 + 19] = 0;
                    ADPCM.pcmBuffer[n2 + 17] = 0;
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 24;
            }
        }
        ,
        PIP_STEREO_HERMITE_8{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 2] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 4] = -75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 6] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 8] = -45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 10] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 12] = -7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 14] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (-45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 12] = (-7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 14] = n5 * pcmAttackCurve[n6 + 7] >> 14;
                    pcmPanLeft = (n6 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 14] = 0;
                    ADPCM.pcmBuffer[n2 + 12] = 0;
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = -49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 3] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 5] = -75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 7] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 9] = -45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 11] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 13] = -7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10;
                    ADPCM.pcmBuffer[n2 + 15] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (-49 * n3 + 987 * n4 + 93 * n5 - 7 * n >> 10) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-75 * n3 + 745 * n4 + 399 * n5 - 45 * n >> 10) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (-45 * n3 + 399 * n4 + 745 * n5 - 75 * n >> 10) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 5] >> 14;
                    ADPCM.pcmBuffer[n2 + 13] = (-7 * n3 + 93 * n4 + 987 * n5 - 49 * n >> 10) * pcmAttackCurve[n6 + 6] >> 14;
                    ADPCM.pcmBuffer[n2 + 15] = n5 * pcmAttackCurve[n6 + 7] >> 14;
                    pcmPanRight = (n6 += 8) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 15] = 0;
                    ADPCM.pcmBuffer[n2 + 13] = 0;
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 16;
            }
        }
        ,
        PIP_STEREO_HERMITE_6{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 2] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 4] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 6] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 8] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 10] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 8] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 10] = n5 * pcmAttackCurve[n6 + 5] >> 14;
                    pcmPanLeft = (n6 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 10] = 0;
                    ADPCM.pcmBuffer[n2 + 8] = 0;
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 5] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 7] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 9] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32);
                    ADPCM.pcmBuffer[n2 + 11] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-25 * n3 + 405 * n4 + 57 * n5 - 5 * n) * 9942054L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 3] >> 14;
                    ADPCM.pcmBuffer[n2 + 9] = (int)((long)(-5 * n3 + 57 * n4 + 405 * n5 - 25 * n) * 9942054L >> 32) * pcmAttackCurve[n6 + 4] >> 14;
                    ADPCM.pcmBuffer[n2 + 11] = n5 * pcmAttackCurve[n6 + 5] >> 14;
                    pcmPanRight = (n6 += 6) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 11] = 0;
                    ADPCM.pcmBuffer[n2 + 9] = 0;
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 6;
            }
        }
        ,
        PIP_STEREO_HERMITE_4{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 2] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 4] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 6] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 6] = n5 * pcmAttackCurve[n6 + 3] >> 14;
                    pcmPanLeft = (n6 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 6] = 0;
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = -9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 3] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 5] = -3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7;
                    ADPCM.pcmBuffer[n2 + 7] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (-9 * n3 + 111 * n4 + 29 * n5 - 3 * n >> 7) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = (-3 * n3 + 29 * n4 + 111 * n5 - 9 * n >> 7) * pcmAttackCurve[n6 + 2] >> 14;
                    ADPCM.pcmBuffer[n2 + 7] = n5 * pcmAttackCurve[n6 + 3] >> 14;
                    pcmPanRight = (n6 += 4) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 7] = 0;
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 8;
            }
        }
        ,
        PIP_STEREO_HERMITE_3{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 2] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 4] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 4] = n5 * pcmAttackCurve[n6 + 2] >> 14;
                    pcmPanLeft = (n6 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 4] = 0;
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32);
                    ADPCM.pcmBuffer[n2 + 5] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (int)((long)(-2 * n3 + 21 * n4 + 9 * n5 - n) * 159072863L >> 32) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = (int)((long)(-n3 + 9 * n4 + 21 * n5 - 2 * n) * 159072863L >> 32) * pcmAttackCurve[n6 + 1] >> 14;
                    ADPCM.pcmBuffer[n2 + 5] = n5 * pcmAttackCurve[n6 + 2] >> 14;
                    pcmPanRight = (n6 += 3) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 5] = 0;
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 6;
            }
        }
        ,
        PIP_STEREO_HERMITE_2{

            @Override
            public void write(int n) {
                int n2 = pcmPointer;
                int n3 = pcmDecodedData3;
                int n4 = pcmDecodedData2;
                int n5 = pcmDecodedData1;
                int n6 = pcmPanLeft;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 2] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 2] = n5 * pcmAttackCurve[n6 + 1] >> 14;
                    pcmPanLeft = (n6 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 2] = 0;
                    ADPCM.pcmBuffer[n2] = 0;
                }
                n6 = pcmPanRight;
                if (n6 > 0) {
                    ADPCM.pcmBuffer[n2 + 1] = -n3 + 9 * (n4 + n5) - n >> 4;
                    ADPCM.pcmBuffer[n2 + 3] = n5;
                } else if (n6 < 0) {
                    n6 = (char)n6;
                    ADPCM.pcmBuffer[n2 + 1] = (-n3 + 9 * (n4 + n5) - n >> 4) * pcmAttackCurve[n6] >> 14;
                    ADPCM.pcmBuffer[n2 + 3] = n5 * pcmAttackCurve[n6 + 1] >> 14;
                    pcmPanRight = (n6 += 2) << -11 >= 0 ? Integer.MIN_VALUE + n6 : n6 >> 11;
                } else {
                    ADPCM.pcmBuffer[n2 + 3] = 0;
                    ADPCM.pcmBuffer[n2 + 1] = 0;
                }
                pcmDecodedData3 = n4;
                pcmDecodedData2 = n5;
                pcmDecodedData1 = n;
                pcmPointer = n2 + 4;
            }
        };


        public abstract void write(int var1);
    }
}

