;========================================================================================
;  flinebuserror.s
;  Copyright (C) 2003-2024 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------------------------------
;
;	flinebuserror.x
;		MC68030DOSR[_GETENVÂԍ$FF53ŌĂяoăoXG[𔭐łB
;		oXG[Ƃbus errorƁAȂΊϐpath̓e\܂B
;		MC68030ł$FF53cpRESTORE (a3)Ȃ̂ŁA$FF53s(a3)[hAa3̓eɂĂ̓oXG[܂B
;		̖肪A_GETENVVԍ$FF83ɈړȂ΂ȂȂRłƍl܂B
;
;	XV
;		2024-11-29
;			JB
;
;----------------------------------------------------------------------------------------

	.include	doscall.mac

	.text

;X[p[oCU[hɈڍs
	clr.l	-(sp)
	DOS	_SUPER
	move.l	d0,(sp)

;oXG[AhXpӂ
	movea.l	#$00E80400,a3		;a3=oXG[AhX

;X[p[oCUX^bN|C^ۑ
	movea.l	sp,a4			;a4=X[p[oCUX^bN|C^

;oXG[OxN^ۑĕύX
	move.l	$0008.w,a5		;a5=̃oXG[OxN^
	move.l	#buserror,$0008.w

;ϐpath̒lo
	lea.l	name,a0			;a0=ϐ̖O
	suba.l	a1,a1			;a1=̗̈B0͎s̃vZX
	lea.l	value,a2		;a2=ϐ̒l
	clr.b	(a2)			;ϐȂ΋Ƃ݂Ȃ
	movem.l	a0-a2,-(sp)
	DOS	_V2_GETENV		;X68030̂ƂŃoXG[
	lea.l	12(sp),sp

;oXG[OxN^𕜌
	move.l	a5,$0008.w

;ϐpath̒l\
	move.l	a0,-(sp)		;ϐ̖O
	DOS	_PRINT
	pea.l	separator		;؂
	DOS	_PRINT
	move.l	a2,-(sp)		;ϐ̒l
	DOS	_PRINT
	pea.l	crlf			;s
	DOS	_PRINT
	lea.l	16(sp),sp

	bra	user_exit

;oXG[̂Ƃ
buserror:

;X[p[oCUX^bN|C^𕜌
	movea.l	a4,sp			;̃X[p[oCUX^bN|C^

;oXG[OxN^𕜌
	move.l	a5,$0008.w		;̃oXG[OxN^

;oXG[̃bZ[W\
	pea.l	message			;'bus error'
	DOS	_PRINT
	addq.l	#4,sp

user_exit:

;[U[hɕA
	DOS	_SUPER
	addq.l	#4,sp

;I
	DOS	_EXIT

	.data

;ϐ̖O
name:
	.dc.b	'path',0

;'bus error'
message:
	.dc.b	'bus error'
;s
crlf:
	.dc.b	13,10,0
;؂
separator:
	.dc.b	'=',0

	.bss

;ϐ̒l
value:
	.ds.b	1024
