/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import xeij.ComponentFactory;
import xeij.MouseEvent2D;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollCanvas;
import xeij.SpriteScreen;
import xeij.VideoController;
import xeij.XEiJ;

public class SpritePatternViewer {
    public static final boolean SPV_ON = true;
    static final String SPV_RULER_NAME = "Dialog";
    static final int SPV_RULER_STYLE = 0;
    static final int SPV_RULER_SIZE = 18;
    static final Font SPV_RULER_FONT = new Font("Dialog", 0, 18);
    static final int SPV_RULER_WIDTH = 54;
    static final int SPV_RULER_HEIGHT = 18;
    static final int SPV_CELL_WIDTH = 36;
    static final int SPV_CELL_HEIGHT = 36;
    static final int SPV_LATTICE_WIDTH = 2;
    static final int SPV_LATTICE_HEIGHT = 2;
    static final int SPV_BACKGROUND_RGB = -11184811;
    static final int SPV_BLOCK_DOT_RGB = -1;
    static final int SPV_GRAY_LINE_RGB = -5592406;
    static final int SPV_RULER_RGB = -1;
    static final int SPV_LATTICE_RGB = -5592406;
    static int spvImageWidth;
    static int spvImageHeight;
    static BufferedImage spvBufferedImage;
    static int[] spvBitmap;
    static ScrollCanvas spvCanvas;
    static int spvBankNumber;
    static JComboBox<String> spvBankComboBox;
    static int spvCellOffset;
    static int spvCellLength;
    static int spvCols;
    static int spvRows;
    static int spvWidth;
    static int spvHeight;
    static final int[] spvLastSizeArray;
    static final int[] spvSizeArray;
    static final int SPV_DEFAULT_SIZE = 1;
    static int spvSizeNumber;
    static JComboBox<String> spvSizeComboBox;
    static final int[] spvLastBlockArray;
    static final int[] spvBlockArray;
    static final int SPV_DEFAULT_BLOCK = 1;
    static int spvBlockNumber;
    static JComboBox<String> spvBlockComboBox;
    static final int[] spvLastFlipArray;
    static final int[] spvFlipArray;
    static final int SPV_DEFAULT_FLIP = 0;
    static int spvFlipNumber;
    static JComboBox<String> spvFlipComboBox;
    static JComboBox<String> spvScaleComboBox;
    static JTextField spvTextField;
    static boolean spvTextLocked;
    static JFrame spvFrame;
    static JPopupMenu spvPopupMenu;
    static int spvOffsetToCopy;
    static int spvLengthToCopy;
    public static final int SPV_INTERVAL = 10;
    public static int spvTimer;
    static boolean spvStopped;
    static boolean spvStoppedRequest;
    static final short[] spvCopiedNum;
    static final short[] spvCopiedCol;
    static final byte[] spvCopiedPrw;
    static final boolean[] spvCopiedH;
    static final boolean[] spvCopiedV;
    static final int[] spvCopiedPat;
    static final short[] spvCopiedTNum;
    static final short[] spvCopiedTCol;
    static final boolean[] spvCopiedTH;
    static final boolean[] spvCopiedTV;
    static final int[] spvCopiedPalTbl;
    static final int[] spvCopiedPal16TS;
    static short[] spvNum;
    static short[] spvCol;
    static byte[] spvPrw;
    static boolean[] spvH;
    static boolean[] spvV;
    static int[] spvPat;
    static short[] spvTNum;
    static short[] spvTCol;
    static boolean[] spvTH;
    static boolean[] spvTV;
    static int[] spvPalTbl;
    static int[] spvPal16TS;
    static final int[] spvPal32TS;

    public static void spvInit() {
        spvImageWidth = SpritePatternViewer.spvColToX(64) - 2;
        spvImageHeight = SpritePatternViewer.spvRowToY(64) - 2;
        SpritePatternViewer.spvSetBankNumber(0);
        spvSizeNumber = -1;
        Arrays.fill(spvLastSizeArray, 1);
        spvBlockNumber = -1;
        Arrays.fill(spvLastBlockArray, 1);
        spvFlipNumber = -1;
        Arrays.fill(spvLastFlipArray, 0);
        SpritePatternViewer.spvSetStoppedOff();
        spvFrame = null;
        spvTimer = 0;
    }

    static void spvSetBankNumber(int n) {
        spvBankNumber = n;
        int n2 = spvBankNumber < 16 ? 256 * spvBankNumber : (spvCellOffset = spvBankNumber < 20 ? 1024 * (spvBankNumber - 16) : 0);
        int n3 = spvBankNumber < 16 ? 256 : (spvCellLength = spvBankNumber < 20 ? 1024 : 4096);
        spvRows = spvBankNumber < 16 ? 16 : (spvBankNumber < 20 ? 32 : 64);
        spvCols = spvRows;
        spvWidth = SpritePatternViewer.spvColToX(spvCols) - 2;
        spvHeight = SpritePatternViewer.spvRowToY(spvRows) - 2;
        if (spvCanvas != null) {
            SpritePatternViewer.spvDrawRuler();
            spvCanvas.setImage(spvWidth, spvHeight);
        }
    }

    static int spvColToX(int n) {
        return 54 + 290 * (n >> 3) + 36 * (n & 7);
    }

    static int spvXToCol(int n) {
        int n2;
        if ((n -= 54) < 0 || 290 * (spvCols >> 3) <= n) {
            return -1;
        }
        if (288 <= (n -= 290 * (n2 = n / 290))) {
            return -1;
        }
        return 8 * n2 + n / 36;
    }

    static int spvRowToY(int n) {
        return 18 + 290 * (n >> 3) + 36 * (n & 7);
    }

    static int spvYToRow(int n) {
        int n2;
        if ((n -= 18) < 0 || 290 * (spvRows >> 3) <= n) {
            return -1;
        }
        if (288 <= (n -= 290 * (n2 = n / 290))) {
            return -1;
        }
        return 8 * n2 + n / 36;
    }

    public static void spvStart() {
        if (RestorableFrame.rfmGetOpened("spv")) {
            SpritePatternViewer.spvOpen();
        }
    }

    public static void spvOpen() {
        if (spvFrame == null) {
            SpritePatternViewer.spvMakeFrame();
        } else {
            SpritePatternViewer.spvUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x800;
        XEiJ.pnlExitFullScreen(false);
        spvFrame.setVisible(true);
    }

    static void spvMakeFrame() {
        spvBufferedImage = new BufferedImage(spvImageWidth, spvImageHeight, 2);
        SpritePatternViewer.spvDrawRuler();
        spvBitmap = ((DataBufferInt)spvBufferedImage.getRaster().getDataBuffer()).getData();
        spvCanvas = new ScrollCanvas(spvBufferedImage, spvWidth, spvHeight);
        spvCanvas.setMatColor(new Color(-11184811));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Bank": {
                        SpritePatternViewer.spvSetBankNumber(spvBankComboBox.getSelectedIndex());
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Size": {
                        spvSizeNumber = spvSizeComboBox.getSelectedIndex() - 1;
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Block": {
                        spvBlockNumber = spvBlockComboBox.getSelectedIndex() - 1;
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Flip": {
                        spvFlipNumber = spvFlipComboBox.getSelectedIndex() - 1;
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Stop": {
                        spvStoppedRequest = ((JCheckBox)object).isSelected();
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Scale": {
                        spvCanvas.setScaleShift(spvScaleComboBox.getSelectedIndex() - 4);
                        break;
                    }
                    case "Copy as hexadecimal": {
                        SpritePatternViewer.spvCopyPattern();
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        spvTextField = new JTextField();
        spvTextField.setEditable(false);
        spvTextField.setHorizontalAlignment(0);
        JComponent[] jComponentArray = new JComponent[2];
        jComponentArray[0] = spvCanvas;
        Component[] componentArray = new Component[2];
        Component[] componentArray2 = new Component[10];
        componentArray2[0] = Box.createHorizontalGlue();
        componentArray2[1] = Multilingual.mlnText(ComponentFactory.createLabel("Bank "), "ja", "\u30d0\u30f3\u30af ");
        spvBankComboBox = ComponentFactory.createComboBox(spvBankNumber, "Bank", actionListener, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "0-3", "4-7", "8-11", "12-15", "0-15");
        componentArray2[2] = spvBankComboBox;
        componentArray2[3] = Multilingual.mlnText(ComponentFactory.createLabel(" Size "), "ja", " \u30b5\u30a4\u30ba ");
        spvSizeComboBox = ComponentFactory.createComboBox(spvSizeNumber + 1, "Size", actionListener, 4, Multilingual.mlnJapanese ? "\u81ea\u52d5" : "Auto", "8x8", "16x16");
        componentArray2[4] = spvSizeComboBox;
        componentArray2[5] = Multilingual.mlnText(ComponentFactory.createLabel(" Block "), "ja", " \u30d6\u30ed\u30c3\u30af ");
        spvBlockComboBox = ComponentFactory.createComboBox(spvBlockNumber + 1, "Block", actionListener, 4, Multilingual.mlnJapanese ? "\u81ea\u52d5" : "Auto", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15");
        componentArray2[6] = spvBlockComboBox;
        componentArray2[7] = Multilingual.mlnText(ComponentFactory.createLabel(" Flip "), "ja", " \u53cd\u8ee2 ");
        spvFlipComboBox = ComponentFactory.createComboBox(spvFlipNumber + 1, "Flip", actionListener, 4, Multilingual.mlnJapanese ? "\u81ea\u52d5" : "Auto", Multilingual.mlnJapanese ? "\u306a\u3057" : "-", Multilingual.mlnJapanese ? "\u5de6\u53f3" : "H", Multilingual.mlnJapanese ? "\u4e0a\u4e0b" : "V", Multilingual.mlnJapanese ? "\u4e0a\u4e0b\u5de6\u53f3" : "H&V");
        componentArray2[8] = spvFlipComboBox;
        componentArray2[9] = Box.createHorizontalGlue();
        componentArray[0] = ComponentFactory.createHorizontalBox(componentArray2);
        Component[] componentArray3 = new Component[8];
        componentArray3[0] = Box.createHorizontalStrut(10);
        componentArray3[1] = spvTextField;
        componentArray3[2] = Box.createHorizontalStrut(10);
        componentArray3[3] = Multilingual.mlnText(ComponentFactory.createCheckBox(spvStoppedRequest, "Stop", actionListener), "ja", "\u505c\u6b62");
        componentArray3[4] = Box.createHorizontalStrut(10);
        componentArray3[5] = Multilingual.mlnText(ComponentFactory.createLabel(" Scale "), "ja", " \u500d\u7387 ");
        spvScaleComboBox = ComponentFactory.createComboBox(spvCanvas.getScaleShift() + 4, "Scale", actionListener, "1/8", "1/4", "1/2", "1", "2", "4", "8", "16", "32");
        componentArray3[6] = spvScaleComboBox;
        componentArray3[7] = Box.createHorizontalStrut(10);
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray3);
        jComponentArray[1] = ComponentFactory.createVerticalBox(componentArray);
        spvFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("spv", "Sprite Pattern Viewer", null, ComponentFactory.createBorderPanel(0, 0, jComponentArray)), "ja", "\u30b9\u30d7\u30e9\u30a4\u30c8\u30d1\u30bf\u30fc\u30f3\u30d3\u30e5\u30a2");
        spvCanvas.addScaleShiftListener(new ScrollCanvas.ScaleShiftListener(){

            @Override
            public void scaleShiftChanged(int n) {
                spvScaleComboBox.setSelectedIndex(n + 4);
            }
        });
        ComponentFactory.addListener(spvFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFF7FF;
            }
        });
        spvPopupMenu = ComponentFactory.createPopupMenu(Multilingual.mlnText(ComponentFactory.createMenuItem("Copy as hexadecimal", 67, actionListener), "ja", "16\u9032\u6570\u3067\u30b3\u30d4\u30fc"));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                spvTextLocked = !spvTextLocked;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!spvTextLocked) {
                    int n;
                    MouseEvent2D mouseEvent2D = (MouseEvent2D)mouseEvent;
                    int n2 = (int)mouseEvent2D.getX2D();
                    String string = SpritePatternViewer.spvGetPixel(n2, n = (int)mouseEvent2D.getY2D());
                    spvTextField.setText(string == null ? "" : string);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SpritePatternViewer.spvShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SpritePatternViewer.spvShowPopup(mouseEvent);
            }
        };
        spvCanvas.addMouseListener(mouseAdapter);
        spvCanvas.addMouseMotionListener(mouseAdapter);
    }

    static void spvDrawRuler() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        String string;
        int n7;
        Graphics2D graphics2D = spvBufferedImage.createGraphics();
        graphics2D.setColor(new Color(-11184811));
        graphics2D.fillRect(0, 0, spvWidth, spvHeight);
        graphics2D.setColor(new Color(-5592406));
        graphics2D.fillRect(54, 18, spvWidth - 54, spvHeight - 18);
        graphics2D.setColor(new Color(-1));
        graphics2D.setFont(SPV_RULER_FONT);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        for (n7 = 0; n7 < spvCols; ++n7) {
            string = String.format("%d", n7);
            textLayout = new TextLayout(string, SPV_RULER_FONT, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            n6 = (int)Math.round(rectangle2D.getX());
            n5 = (int)Math.round(rectangle2D.getY());
            n4 = (int)Math.round(rectangle2D.getWidth());
            n3 = (int)Math.round(rectangle2D.getHeight());
            n2 = SpritePatternViewer.spvColToX(n7) + 18;
            n = SpritePatternViewer.spvRowToY(0) - 1;
            graphics2D.drawString(string, n2 - n6 - n4 / 2, n - n5 - n3);
        }
        for (n7 = 0; n7 < spvRows; ++n7) {
            string = String.format("%d", spvCellOffset + spvCols * n7);
            textLayout = new TextLayout(string, SPV_RULER_FONT, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            n6 = (int)Math.round(rectangle2D.getX());
            n5 = (int)Math.round(rectangle2D.getY());
            n4 = (int)Math.round(rectangle2D.getWidth());
            n3 = (int)Math.round(rectangle2D.getHeight());
            n2 = SpritePatternViewer.spvColToX(0) - 3;
            n = SpritePatternViewer.spvRowToY(n7) + 18;
            graphics2D.drawString(string, n2 - n6 - n4, n - n5 - n3 / 2);
        }
    }

    static void spvShowPopup(MouseEvent mouseEvent) {
        int n;
        MouseEvent2D mouseEvent2D;
        int n2;
        if (mouseEvent.isPopupTrigger() && SpritePatternViewer.spvGetPatternToCopy(n2 = (int)(mouseEvent2D = (MouseEvent2D)mouseEvent).getX2D(), n = (int)mouseEvent2D.getY2D())) {
            Point point = spvCanvas.getPopupPoint(mouseEvent2D);
            spvPopupMenu.show(spvCanvas, point.x, point.y);
        }
    }

    static boolean spvGetPatternToCopy(int n, int n2) {
        int n3 = SpritePatternViewer.spvXToCol(n);
        int n4 = SpritePatternViewer.spvYToRow(n2);
        if (0 <= n3 && 0 <= n4) {
            n -= SpritePatternViewer.spvColToX(n3);
            n2 -= SpritePatternViewer.spvRowToY(n4);
            int n5 = spvCellOffset + n3 + spvCols * n4 << 2;
            int n6 = spvSizeArray[n5 >> 2];
            if (n6 < 0) {
                n6 = spvLastSizeArray[n5 >> 2];
            }
            if (n6 == 0) {
                int n7 = n / 18;
                int n8 = n2 / 18;
                n -= 18 * n7;
                n2 -= 18 * n8;
                spvOffsetToCopy = (n5 += n8 + 2 * n7) << 3;
                spvLengthToCopy = 8;
                return true;
            }
            spvOffsetToCopy = n5 << 3;
            spvLengthToCopy = 32;
            return true;
        }
        spvOffsetToCopy = 0;
        spvLengthToCopy = 0;
        return false;
    }

    static void spvCopyPattern() {
        if (spvLengthToCopy != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < spvLengthToCopy; ++i) {
                stringBuilder.append(String.format("%08X\n", spvPat[spvOffsetToCopy + i]));
            }
            XEiJ.clpCopy(stringBuilder.toString());
        }
    }

    static String spvGetPixel(int n, int n2) {
        int n3 = SpritePatternViewer.spvXToCol(n);
        int n4 = SpritePatternViewer.spvYToRow(n2);
        if (0 <= n3 && 0 <= n4) {
            n -= SpritePatternViewer.spvColToX(n3);
            n2 -= SpritePatternViewer.spvRowToY(n4);
            int n5 = spvCellOffset + n3 + spvCols * n4 << 2;
            int n6 = spvSizeArray[n5 >> 2];
            if (n6 < 0) {
                n6 = spvLastSizeArray[n5 >> 2];
            }
            if (n6 == 0) {
                int n7 = n / 18;
                int n8 = n2 / 18;
                n -= 18 * n7;
                n2 -= 18 * n8;
                n5 += n8 + 2 * n7;
                if (0 <= --n && n < 16 && 0 <= --n2 && n2 < 16) {
                    int n9;
                    n >>= 1;
                    n2 >>= 1;
                    int n10 = spvBlockArray[n5];
                    if (n10 < 0) {
                        n10 = spvLastBlockArray[n5];
                    }
                    if ((n9 = spvFlipArray[n5]) < 0) {
                        n9 = spvLastFlipArray[n5];
                    }
                    int n11 = n9 >> 1;
                    int n12 = n9 & 1;
                    if (n12 != 0) {
                        n ^= 7;
                    }
                    if (n11 != 0) {
                        n2 ^= 7;
                    }
                    int n13 = spvPat[(n5 << 3) + n2] >> (7 - n << 2) & 0xF;
                    int n14 = n10 << 4 | n13;
                    int n15 = spvPal16TS[n14];
                    return String.format("8x8 n=%d x=%d y=%d p=0x%02X c=0x%04X(%d,%d,%d,%d)", n5, n, n2, n14, n15, n15 >> 11, n15 >> 6 & 0x1F, n15 >> 1 & 0x1F, n15 & 1);
                }
            } else if (0 <= (n -= 2) && n < 32 && 0 <= (n2 -= 2) && n2 < 32) {
                int n16;
                n >>= 1;
                n2 >>= 1;
                int n17 = spvBlockArray[n5];
                if (n17 < 0) {
                    n17 = spvLastBlockArray[n5];
                }
                if ((n16 = spvFlipArray[n5]) < 0) {
                    n16 = spvLastFlipArray[n5];
                }
                int n18 = n16 >> 1;
                int n19 = n16 & 1;
                if ((n16 & 1) != 0) {
                    n ^= 0xF;
                }
                if ((n16 & 2) != 0) {
                    n2 ^= 0xF;
                }
                int n20 = spvPat[(n5 << 3) + n2 + ((n & 8) << 1)] >> (7 - (n & 7) << 2) & 0xF;
                int n21 = n17 << 4 | n20;
                int n22 = spvPal16TS[n21];
                return String.format("16x16 n=%d x=%d y=%d p=0x%02X c=0x%04X(%d,%d,%d,%d)", n5 >> 2, n, n2, n21, n22, n22 >> 11, n22 >> 6 & 0x1F, n22 >> 1 & 0x1F, n22 & 1);
            }
        }
        return null;
    }

    static void spvUpdateFrame() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (spvFrame == null) {
            return;
        }
        if (spvStopped != spvStoppedRequest) {
            if (spvStoppedRequest) {
                SpritePatternViewer.spvSetStoppedOn();
            } else {
                SpritePatternViewer.spvSetStoppedOff();
            }
        }
        for (n8 = 0; n8 < 256; ++n8) {
            SpritePatternViewer.spvPal32TS[n8] = spvPalTbl[spvPal16TS[n8]];
        }
        Arrays.fill(spvSizeArray, spvSizeNumber);
        Arrays.fill(spvBlockArray, spvBlockNumber);
        Arrays.fill(spvFlipArray, spvFlipNumber);
        if (spvSizeNumber < 0 || spvBlockNumber < 0 || spvFlipNumber < 0) {
            for (n8 = 0; n8 < SpriteScreen.sprNumberOfSprites; ++n8) {
                if (256 <= n8 && n8 < 264 || spvPrw[n8] == 0) continue;
                n7 = spvNum[n8] << 2;
                if (spvSizeArray[n7 >> 2] < 0) {
                    SpritePatternViewer.spvLastSizeArray[n7 >> 2] = 1;
                    SpritePatternViewer.spvSizeArray[n7 >> 2] = 1;
                }
                n6 = spvCol[n8] >> 4;
                n5 = (spvV[n8] ? 2 : 0) | (spvH[n8] ? 1 : 0);
                for (n4 = 0; n4 < 4; ++n4) {
                    if (spvBlockArray[n7 + n4] < 0) {
                        int n9 = n6;
                        SpritePatternViewer.spvLastBlockArray[n7 + n4] = n9;
                        SpritePatternViewer.spvBlockArray[n7 + n4] = n9;
                    }
                    if (spvFlipArray[n7 + n4] >= 0) continue;
                    int n10 = n5;
                    SpritePatternViewer.spvLastFlipArray[n7 + n4] = n10;
                    SpritePatternViewer.spvFlipArray[n7 + n4] = n10;
                }
            }
            n8 = 0;
            if ((SpriteScreen.sprReg4BgCtrlPort & 1) != 0) {
                n8 |= 1 << (SpriteScreen.sprReg4BgCtrlPort >> 1 & 3);
            }
            if (((SpriteScreen.sprReg8ResoPort & 3) == 0 || SpriteScreen.spr512bg1) && (SpriteScreen.sprReg4BgCtrlPort & 8) != 0) {
                n8 |= 1 << (SpriteScreen.sprReg4BgCtrlPort >> 4 & 3);
            }
            if ((SpriteScreen.sprReg8ResoPort & 3) == 0) {
                for (n7 = 0; n7 < 4; ++n7) {
                    if ((n8 & 1 << n7) == 0) continue;
                    n6 = 4096 * n7;
                    for (n5 = 0; n5 < 4096; ++n5) {
                        n4 = spvTNum[n6 + n5] >> 3;
                        if (spvSizeArray[n4 >> 2] < 0) {
                            SpritePatternViewer.spvLastSizeArray[n4 >> 2] = 0;
                            SpritePatternViewer.spvSizeArray[n4 >> 2] = 0;
                        }
                        n3 = spvTCol[n6 + n5] >> 4;
                        n2 = (spvTV[n6 + n5] ? 2 : 0) | (spvTH[n6 + n5] ? 1 : 0);
                        if (spvBlockArray[n4] < 0) {
                            SpritePatternViewer.spvBlockArray[n4] = SpritePatternViewer.spvLastBlockArray[n4] = n3;
                        }
                        if (spvFlipArray[n4] >= 0) continue;
                        SpritePatternViewer.spvFlipArray[n4] = SpritePatternViewer.spvLastFlipArray[n4] = n2;
                    }
                }
            } else {
                for (n7 = 0; n7 < 4; ++n7) {
                    if ((n8 & 1 << n7) == 0) continue;
                    n6 = 4096 * n7;
                    for (n5 = 0; n5 < 4096; ++n5) {
                        n4 = spvTNum[n6 + n5] >> 1;
                        if (spvSizeArray[n4 >> 2] < 0) {
                            SpritePatternViewer.spvLastSizeArray[n4 >> 2] = 1;
                            SpritePatternViewer.spvSizeArray[n4 >> 2] = 1;
                        }
                        n3 = spvTCol[n6 + n5] >> 4;
                        n2 = (spvTV[n6 + n5] ? 2 : 0) | (spvTH[n6 + n5] ? 1 : 0);
                        for (n = 0; n < 4; ++n) {
                            if (spvBlockArray[n4 + n] < 0) {
                                int n11 = n3;
                                SpritePatternViewer.spvLastBlockArray[n4 + n] = n11;
                                SpritePatternViewer.spvBlockArray[n4 + n] = n11;
                            }
                            if (spvFlipArray[n4 + n] >= 0) continue;
                            int n12 = n2;
                            SpritePatternViewer.spvLastFlipArray[n4 + n] = n12;
                            SpritePatternViewer.spvFlipArray[n4 + n] = n12;
                        }
                    }
                }
            }
            for (n7 = 0; n7 < 4096; ++n7) {
                if (spvSizeArray[n7] >= 0) continue;
                SpritePatternViewer.spvSizeArray[n7] = spvLastSizeArray[n7];
            }
            for (n7 = 0; n7 < 16384; ++n7) {
                if (spvBlockArray[n7] < 0) {
                    SpritePatternViewer.spvBlockArray[n7] = spvLastBlockArray[n7];
                }
                if (spvFlipArray[n7] >= 0) continue;
                SpritePatternViewer.spvFlipArray[n7] = spvLastFlipArray[n7];
            }
        }
        n8 = 32 * spvCellOffset;
        for (n7 = 0; n7 < spvRows; ++n7) {
            n6 = SpritePatternViewer.spvRowToY(n7);
            for (n5 = 0; n5 < spvCols; ++n5) {
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                n4 = SpritePatternViewer.spvColToX(n5);
                n2 = n3 = n4 + spvImageWidth * n6;
                for (n = 0; n < 36; ++n) {
                    for (n20 = 0; n20 < 36; ++n20) {
                        SpritePatternViewer.spvBitmap[n2 + n20] = -11184811;
                    }
                    n2 += spvImageWidth;
                }
                n = spvCellOffset + n5 + spvCols * n7 << 2;
                if (spvSizeArray[n >> 2] == 0) {
                    for (n20 = 0; n20 < 2; ++n20) {
                        n19 = n4 + 18 * n20;
                        for (n18 = 0; n18 < 2; ++n18) {
                            int n21;
                            n17 = n6 + 18 * n18;
                            n16 = n19 + spvImageWidth * n17;
                            n15 = spvBlockArray[n];
                            int n22 = spvFlipArray[n];
                            int n23 = (n22 & 1) != 0 ? 7 : 0;
                            n14 = (n22 & 2) != 0 ? 15 : 0;
                            n2 = n16 + (n23 == 0 ? 0 + spvImageWidth * 1 : 17 + spvImageWidth * 1);
                            for (n13 = 0; n13 <= 15; ++n13) {
                                n21 = n13 ^ n14;
                                if (n21 == n15) {
                                    SpritePatternViewer.spvBitmap[n2] = -1;
                                } else if (n21 < 8) {
                                    SpritePatternViewer.spvBitmap[n2] = -5592406;
                                }
                                n2 += spvImageWidth * 1;
                            }
                            n15 <<= 4;
                            n14 >>= 1;
                            n2 = n16 + 1 + spvImageWidth * 1;
                            for (n13 = 0; n13 <= 7; ++n13) {
                                n21 = n13 ^ n14;
                                int n24 = spvPat[n8 + n21];
                                for (int i = 7; 0 <= i; --i) {
                                    int n25 = i ^ n23;
                                    int n26 = spvPal32TS[n15 + (n24 >> (n25 << 2) & 0xF)];
                                    SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = n26;
                                    SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = n26;
                                    SpritePatternViewer.spvBitmap[n2 + 1] = n26;
                                    SpritePatternViewer.spvBitmap[n2] = n26;
                                    n2 += 2;
                                }
                                n2 += spvImageWidth * 2 - 16;
                            }
                            n8 += 8;
                            ++n;
                        }
                    }
                    continue;
                }
                n20 = spvBlockArray[n];
                n19 = spvFlipArray[n];
                n18 = (n19 & 1) != 0 ? 15 : 0;
                n17 = (n19 & 2) != 0 ? 15 : 0;
                n2 = n3 + (n18 == 0 ? 0 + spvImageWidth * 2 : 34 + spvImageWidth * 2);
                for (n16 = 0; n16 <= 15; ++n16) {
                    n15 = n16 ^ n17;
                    if (n15 == n20) {
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = -1;
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = -1;
                        SpritePatternViewer.spvBitmap[n2 + 1] = -1;
                        SpritePatternViewer.spvBitmap[n2] = -1;
                    } else if (n15 < 8) {
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = -5592406;
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = -5592406;
                        SpritePatternViewer.spvBitmap[n2 + 1] = -5592406;
                        SpritePatternViewer.spvBitmap[n2] = -5592406;
                    }
                    n2 += spvImageWidth * 2;
                }
                n20 <<= 4;
                n2 = n3 + 2 + spvImageWidth * 2;
                for (n16 = 0; n16 <= 15; ++n16) {
                    n15 = n16 ^ n17;
                    long l = (long)spvPat[n8 + n15] << 32 | (long)spvPat[n8 + n15 + 16] & 0xFFFFFFFFL;
                    for (n14 = 15; 0 <= n14; --n14) {
                        n13 = n14 ^ n18;
                        int n27 = spvPal32TS[n20 + ((int)(l >> (n13 << 2)) & 0xF)];
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = n27;
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = n27;
                        SpritePatternViewer.spvBitmap[n2 + 1] = n27;
                        SpritePatternViewer.spvBitmap[n2] = n27;
                        n2 += 2;
                    }
                    n2 += spvImageWidth * 2 - 32;
                }
                n8 += 32;
            }
        }
        spvCanvas.repaint();
    }

    static void spvSetStoppedOn() {
        spvStopped = true;
        spvStoppedRequest = true;
        System.arraycopy(SpriteScreen.sprNumPort, 0, spvCopiedNum, 0, 1024);
        System.arraycopy(SpriteScreen.sprColPort, 0, spvCopiedCol, 0, 1024);
        System.arraycopy(SpriteScreen.sprPrw, 0, spvCopiedPrw, 0, 1024);
        System.arraycopy(SpriteScreen.sprH, 0, spvCopiedH, 0, 1024);
        System.arraycopy(SpriteScreen.sprV, 0, spvCopiedV, 0, 1024);
        System.arraycopy(SpriteScreen.sprPatPort, 0, spvCopiedPat, 0, 131072);
        System.arraycopy(SpriteScreen.sprTNum, 0, spvCopiedTNum, 0, 16384);
        System.arraycopy(SpriteScreen.sprTColPort, 0, spvCopiedTCol, 0, 16384);
        System.arraycopy(SpriteScreen.sprTH, 0, spvCopiedTH, 0, 16384);
        System.arraycopy(SpriteScreen.sprTV, 0, spvCopiedTV, 0, 16384);
        System.arraycopy(VideoController.vcnPalBase[45], 0, spvCopiedPalTbl, 0, 65536);
        System.arraycopy(VideoController.vcnPal16TS, 0, spvCopiedPal16TS, 0, 256);
        spvNum = spvCopiedNum;
        spvCol = spvCopiedCol;
        spvPrw = spvCopiedPrw;
        spvH = spvCopiedH;
        spvV = spvCopiedV;
        spvPat = spvCopiedPat;
        spvTNum = spvCopiedTNum;
        spvTCol = spvCopiedTCol;
        spvTH = spvCopiedTH;
        spvTV = spvCopiedTV;
        spvPalTbl = spvCopiedPalTbl;
        spvPal16TS = spvCopiedPal16TS;
    }

    static void spvSetStoppedOff() {
        spvStopped = false;
        spvStoppedRequest = false;
        spvNum = SpriteScreen.sprNumPort;
        spvCol = SpriteScreen.sprColPort;
        spvPrw = SpriteScreen.sprPrw;
        spvH = SpriteScreen.sprH;
        spvV = SpriteScreen.sprV;
        spvPat = SpriteScreen.sprPatPort;
        spvTNum = SpriteScreen.sprTNum;
        spvTCol = SpriteScreen.sprTColPort;
        spvTH = SpriteScreen.sprTH;
        spvTV = SpriteScreen.sprTV;
        spvPalTbl = VideoController.vcnPalBase[45];
        spvPal16TS = VideoController.vcnPal16TS;
    }

    static {
        spvLastSizeArray = new int[4096];
        spvSizeArray = new int[4096];
        spvLastBlockArray = new int[16384];
        spvBlockArray = new int[16384];
        spvLastFlipArray = new int[16384];
        spvFlipArray = new int[16384];
        spvCopiedNum = new short[1024];
        spvCopiedCol = new short[1024];
        spvCopiedPrw = new byte[1024];
        spvCopiedH = new boolean[1024];
        spvCopiedV = new boolean[1024];
        spvCopiedPat = new int[131072];
        spvCopiedTNum = new short[16384];
        spvCopiedTCol = new short[16384];
        spvCopiedTH = new boolean[16384];
        spvCopiedTV = new boolean[16384];
        spvCopiedPalTbl = new int[65536];
        spvCopiedPal16TS = new int[256];
        spvPal32TS = new int[256];
    }
}

