/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.MouseEvent2D;
import xeij.MouseWheelEvent2D;

public class ScrollCanvas
extends JScrollPane
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int MIN_SCALE_SHIFT = -4;
    public static final int MAX_SCALE_SHIFT = 4;
    protected BufferedImage canvasImage;
    protected int canvasWidth;
    protected int canvasHeight;
    protected int viewportWidth;
    protected int viewportHeight;
    protected int marginX;
    protected int marginY;
    protected int scaleShift;
    protected float scaleFactor;
    protected int direction;
    protected int scaledWidth;
    protected int scaledHeight;
    protected int rotatedScaledWidth;
    protected int rotatedScaledHeight;
    protected int viewWidth;
    protected int viewHeight;
    protected int originX;
    protected int originY;
    protected ArrayList<MouseListener> mouseListeners = new ArrayList();
    protected ArrayList<MouseMotionListener> mouseMotionListeners = new ArrayList();
    protected ArrayList<MouseWheelListener> mouseWheelListeners = new ArrayList();
    protected boolean dragStarted = false;
    protected int pressedX = 0;
    protected int pressedY = 0;
    protected ArrayList<ScaleShiftListener> scaleShiftListeners = new ArrayList();
    protected JPanel view;

    public ScrollCanvas() {
        this(480, 360);
    }

    public ScrollCanvas(int n, int n2) {
        this(new BufferedImage(n, n2, 2));
    }

    public ScrollCanvas(BufferedImage bufferedImage) {
        this(bufferedImage, bufferedImage == null ? 1 : bufferedImage.getWidth(), bufferedImage == null ? 1 : bufferedImage.getHeight());
    }

    public ScrollCanvas(BufferedImage bufferedImage, int n, int n2) {
        this.canvasImage = bufferedImage;
        this.canvasWidth = n;
        this.canvasHeight = n2;
        this.viewportWidth = this.canvasWidth;
        this.viewportHeight = this.canvasHeight;
        this.marginX = 0;
        this.marginY = 0;
        this.scaleShift = 0;
        this.scaleFactor = 1.0f;
        this.direction = 0;
        this.calcScaledSize();
        this.calcViewSize();
        this.view = new JPanel(this){
            final /* synthetic */ ScrollCanvas this$0;
            {
                ScrollCanvas scrollCanvas2 = scrollCanvas;
                Objects.requireNonNull(scrollCanvas2);
                this.this$0 = scrollCanvas2;
            }

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                this.this$0.paintView(graphics);
            }
        };
        this.view.setOpaque(true);
        this.view.setBackground(Color.lightGray);
        this.view.setPreferredSize(new Dimension(this.viewWidth, this.viewHeight));
        this.view.addMouseListener(this);
        this.view.addMouseMotionListener(this);
        this.view.addMouseWheelListener(this);
        this.viewport.setScrollMode(1);
        this.viewport.setPreferredSize(new Dimension(this.viewportWidth, this.viewportHeight));
        this.viewport.setMinimumSize(new Dimension(64, 64));
        this.viewport.setView(this.view);
        this.viewport.addChangeListener(new ChangeListener(this){
            final /* synthetic */ ScrollCanvas this$0;
            {
                ScrollCanvas scrollCanvas2 = scrollCanvas;
                Objects.requireNonNull(scrollCanvas2);
                this.this$0 = scrollCanvas2;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = this.this$0.viewport.getWidth();
                int n2 = this.this$0.viewport.getHeight();
                if (this.this$0.viewportWidth != n || this.this$0.viewportHeight != n2) {
                    Point2D point2D = this.this$0.getCenterPoint();
                    this.this$0.viewportWidth = n;
                    this.this$0.viewportHeight = n2;
                    this.this$0.calcViewSize();
                    this.this$0.calcAdditionalSize();
                    this.this$0.view.setPreferredSize(new Dimension(this.this$0.viewWidth, this.this$0.viewHeight));
                    this.this$0.setCenterPoint(point2D);
                }
            }
        });
        this.setWheelScrollingEnabled(false);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
    }

    protected void paintView(Graphics graphics) {
        if (this.canvasImage != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate((double)this.originX, (double)this.originY);
            if (this.direction != 0) {
                if (this.direction == 1) {
                    graphics2D.translate((double)this.rotatedScaledWidth, 0.0);
                    graphics2D.rotate(1.5707963267948966);
                } else if (this.direction == 2) {
                    graphics2D.translate((double)this.rotatedScaledWidth, (double)this.rotatedScaledHeight);
                    graphics2D.rotate(Math.PI);
                } else {
                    graphics2D.translate(0.0, (double)this.rotatedScaledHeight);
                    graphics2D.rotate(4.71238898038469);
                }
            }
            graphics2D.translate((double)(-this.originX), (double)(-this.originY));
            if (this.scaleShift == 0) {
                graphics2D.drawImage(this.canvasImage, this.originX, this.originY, this.originX + this.canvasWidth, this.originY + this.canvasHeight, 0, 0, this.canvasWidth, this.canvasHeight, null);
            } else {
                graphics2D.drawImage(this.canvasImage, this.originX, this.originY, this.originX + this.scaledWidth, this.originY + this.scaledHeight, 0, 0, this.canvasWidth, this.canvasHeight, null);
            }
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener != null && !this.mouseListeners.contains(mouseListener)) {
            this.mouseListeners.add(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListeners.remove(mouseListener);
    }

    @Override
    public MouseListener[] getMouseListeners() {
        return this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener != null && !this.mouseMotionListeners.contains(mouseMotionListener)) {
            this.mouseMotionListeners.add(mouseMotionListener);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.remove(mouseMotionListener);
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        return this.mouseMotionListeners.toArray(new MouseMotionListener[this.mouseMotionListeners.size()]);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (this.mouseWheelListeners != null && mouseWheelListener != null && !this.mouseWheelListeners.contains(mouseWheelListener)) {
            this.mouseWheelListeners.add(mouseWheelListener);
        }
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.remove(mouseWheelListener);
    }

    @Override
    public MouseWheelListener[] getMouseWheelListeners() {
        return this.mouseWheelListeners.toArray(new MouseWheelListener[this.mouseWheelListeners.size()]);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseClicked(mouseEvent2D);
        }
        if (!mouseEvent2D.isConsumed() && this.isFocusable() && !this.isFocusOwner()) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseEntered(mouseEvent2D);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseExited(mouseEvent2D);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mousePressed(mouseEvent2D);
        }
        if (!mouseEvent2D.isConsumed()) {
            this.dragStarted = true;
            this.pressedX = n;
            this.pressedY = n2;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseReleased(mouseEvent2D);
        }
        if (!mouseEvent2D.isConsumed()) {
            this.dragStarted = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
            mouseMotionListener.mouseDragged(mouseEvent2D);
        }
        if (!mouseEvent2D.isConsumed() && this.dragStarted) {
            Point point = this.viewport.getViewPosition();
            this.updateViewPosition(point.x - (n - this.pressedX), point.y - (n2 - this.pressedY));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        MouseEvent2D mouseEvent2D = this.adjustMouseEvent(mouseEvent);
        for (MouseMotionListener mouseMotionListener : this.mouseMotionListeners) {
            mouseMotionListener.mouseMoved(mouseEvent2D);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        MouseWheelEvent2D mouseWheelEvent2D = this.adjustMouseWheelEvent(mouseWheelEvent);
        for (MouseWheelListener mouseWheelListener : this.mouseWheelListeners) {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent2D);
        }
        if (!mouseWheelEvent2D.isConsumed()) {
            int n = mouseWheelEvent2D.getWheelRotation();
            if (n < 0) {
                this.setScaleShift(this.scaleShift + 1, mouseWheelEvent2D.getPoint2D());
            } else if (n > 0) {
                this.setScaleShift(this.scaleShift - 1, mouseWheelEvent2D.getPoint2D());
            }
        }
    }

    public int getCanvasWidth() {
        return this.canvasWidth;
    }

    public int getCanvasHeight() {
        return this.canvasHeight;
    }

    public BufferedImage getImage() {
        return this.canvasImage;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.setImage(bufferedImage, bufferedImage == null ? 1 : bufferedImage.getWidth(), bufferedImage == null ? 1 : bufferedImage.getHeight());
    }

    public void setImage(int n, int n2) {
        this.setImage(this.canvasImage, n, n2);
    }

    public void setImage(BufferedImage bufferedImage, int n, int n2) {
        if (n != this.canvasWidth || n2 != this.canvasHeight) {
            this.canvasImage = bufferedImage;
            this.canvasWidth = n;
            this.canvasHeight = n2;
            this.updateView();
        } else if (this.canvasImage != bufferedImage) {
            this.canvasImage = bufferedImage;
            this.view.repaint();
        }
    }

    public int getMarginX() {
        return this.marginX;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setMargin(int n, int n2) {
        if (this.marginX != n || this.marginY != n2) {
            this.marginX = n;
            this.marginY = n2;
            this.updateView();
        }
    }

    public Color getMatColor() {
        return this.view.getBackground();
    }

    public void setMatColor(Color color) {
        this.view.setBackground(color);
        this.view.repaint();
    }

    public int getScaleShift() {
        return this.scaleShift;
    }

    public void setScaleShift(int n) {
        this.setScaleShift(n, this.getCenterPoint());
    }

    public void setScaleShift(int n, Point2D point2D) {
        if (this.scaleShift != (n = Math.max(-4, Math.min(4, n)))) {
            Point2D point2D2 = this.getCenterPoint();
            double d = (point2D2.getX() - point2D.getX()) * (double)this.scaleFactor;
            double d2 = (point2D2.getY() - point2D.getY()) * (double)this.scaleFactor;
            this.scaleShift = n;
            this.scaleFactor = n >= 0 ? (float)(1 << n) : 1.0f / (float)(1 << -n);
            this.updateView();
            this.setCenterPoint(new Point2D.Double(point2D.getX() + d / (double)this.scaleFactor, point2D.getY() + d2 / (double)this.scaleFactor));
            for (ScaleShiftListener scaleShiftListener : this.scaleShiftListeners) {
                scaleShiftListener.scaleShiftChanged(this.scaleShift);
            }
        }
    }

    public void addScaleShiftListener(ScaleShiftListener scaleShiftListener) {
        if (scaleShiftListener != null) {
            this.scaleShiftListeners.add(scaleShiftListener);
        }
    }

    public void removeScaleShiftListener(ScaleShiftListener scaleShiftListener) {
        this.scaleShiftListeners.remove(scaleShiftListener);
    }

    public ScaleShiftListener[] getScaleShiftListeners() {
        return this.scaleShiftListeners.toArray(new ScaleShiftListener[this.scaleShiftListeners.size()]);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
        this.updateView();
    }

    public Point2D getCenterPoint() {
        Point point = this.viewport.getViewPosition();
        return new Point2D.Float((float)(point.x + (this.viewportWidth >> 1) - this.originX) / this.scaleFactor, (float)(point.y + (this.viewportHeight >> 1) - this.originY) / this.scaleFactor);
    }

    public void setCenterPoint(Point2D point2D) {
        this.updateViewPosition((int)(point2D.getX() * (double)this.scaleFactor) + this.originX - (this.viewportWidth >> 1), (int)(point2D.getY() * (double)this.scaleFactor) + this.originY - (this.viewportHeight >> 1));
    }

    protected MouseEvent2D adjustMouseEvent(MouseEvent mouseEvent) {
        return new MouseEvent2D((Component)this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (float)(mouseEvent.getX() - this.originX) / this.scaleFactor, (float)(mouseEvent.getY() - this.originY) / this.scaleFactor, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    protected MouseWheelEvent2D adjustMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        return new MouseWheelEvent2D((Component)this, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), (float)(mouseWheelEvent.getX() - this.originX) / this.scaleFactor, (float)(mouseWheelEvent.getY() - this.originY) / this.scaleFactor, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
    }

    public Point getPopupPoint(MouseEvent2D mouseEvent2D) {
        Point point = this.viewport.getViewPosition();
        return new Point((int)(mouseEvent2D.getX2D() * this.scaleFactor) + this.originX - point.x, (int)(mouseEvent2D.getY2D() * this.scaleFactor) + this.originY - point.y);
    }

    public Point getPopupPoint(MouseWheelEvent2D mouseWheelEvent2D) {
        Point point = this.viewport.getViewPosition();
        return new Point((int)(mouseWheelEvent2D.getX2D() * this.scaleFactor) + this.originX - point.x, (int)(mouseWheelEvent2D.getY2D() * this.scaleFactor) + this.originY - point.y);
    }

    protected void updateView() {
        this.calcScaledSize();
        this.calcViewSize();
        this.calcAdditionalSize();
        Dimension dimension = new Dimension(this.viewWidth, this.viewHeight);
        this.view.setPreferredSize(dimension);
        this.viewport.setViewSize(dimension);
        this.view.repaint();
    }

    protected final void calcScaledSize() {
        if (this.scaleShift >= 0) {
            this.scaledWidth = this.canvasWidth << this.scaleShift;
            this.scaledHeight = this.canvasHeight << this.scaleShift;
        } else {
            this.scaledWidth = this.canvasWidth >> -this.scaleShift;
            this.scaledHeight = this.canvasHeight >> -this.scaleShift;
            if (this.scaledWidth < 1) {
                this.scaledWidth = 1;
            }
            if (this.scaledHeight < 1) {
                this.scaledHeight = 1;
            }
        }
        if ((this.direction & 1) == 0) {
            this.rotatedScaledWidth = this.scaledWidth;
            this.rotatedScaledHeight = this.scaledHeight;
        } else {
            this.rotatedScaledWidth = this.scaledHeight;
            this.rotatedScaledHeight = this.scaledWidth;
        }
    }

    protected final void calcViewSize() {
        if (this.viewportWidth < (this.marginX << 1) + this.rotatedScaledWidth) {
            this.viewWidth = (this.marginX << 1) + this.rotatedScaledWidth;
            this.originX = this.marginX;
        } else {
            this.viewWidth = this.viewportWidth;
            this.originX = this.viewportWidth - this.rotatedScaledWidth >> 1;
        }
        if (this.viewportHeight < (this.marginY << 1) + this.rotatedScaledHeight) {
            this.viewHeight = (this.marginY << 1) + this.rotatedScaledHeight;
            this.originY = this.marginY;
        } else {
            this.viewHeight = this.viewportHeight;
            this.originY = this.viewportHeight - this.rotatedScaledHeight >> 1;
        }
    }

    protected void calcAdditionalSize() {
    }

    protected void updateViewPosition(int n, int n2) {
        if (this.originX > this.marginX || n < 0) {
            n = 0;
        } else if (n > (this.marginX << 1) + this.rotatedScaledWidth - this.viewportWidth) {
            n = (this.marginX << 1) + this.rotatedScaledWidth - this.viewportWidth;
        }
        if (this.originY > this.marginY || n2 < 0) {
            n2 = 0;
        } else if (n2 > (this.marginY << 1) + this.rotatedScaledHeight - this.viewportHeight) {
            n2 = (this.marginY << 1) + this.rotatedScaledHeight - this.viewportHeight;
        }
        this.viewport.setViewPosition(new Point(n, n2));
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.view != null) {
            this.view.repaint();
        }
    }

    public static class ScaleShiftListener {
        public void scaleShiftChanged(int n) {
        }
    }
}

