/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import xeij.JFileChooser2;
import xeij.Multilingual;
import xeij.XEiJ;

public class FontPage {
    public static final int FNP_COLOR_0 = 0;
    public static final int FNP_COLOR_1 = 51;
    public static final int FNP_COLOR_2 = 255;
    public static final int FNP_COLOR_3 = 255;
    public static final byte[] FNP_COLOR_BASE = new byte[]{0, 51, -1, -1};
    public static final Color[] FNP_COLOR_ARRAY = new Color[]{new Color(0, 0, 0), new Color(51, 51, 51), new Color(255, 255, 255), new Color(255, 255, 255)};
    public static final byte[][] FNP_PALET = new byte[][]{{0, 2, 8, 10, 32, 34, 40, 42, -128, -126, -120, -118, -96, -94, -88, -86}, {85, 87, 93, 95, 117, 119, 125, 127, -43, -41, -35, -33, -11, -9, -3, -1}, {5, 7, 13, 15, 37, 39, 45, 47, -123, -121, -115, -113, -91, -89, -83, -81}, {80, 82, 88, 90, 112, 114, 120, 122, -48, -46, -40, -38, -16, -14, -8, -6}};
    public static final byte[] FNP_INV_PALET = new byte[256];
    public int fnpCharacterWidth;
    public int fnpCharacterHeight;
    public String fnpNameEn;
    public String fnpNameJa;
    public String fnpFontDataFileName;
    public String fnpFontImageFileName;
    public int fnpImageCols;
    public int fnpImageRows;
    public int fnpMemoryRows;
    public byte[] fnpMemoryArray;
    public int fnpMemoryAddress;
    public char[][] fnpTableArray;
    public int fnpImageWidth;
    public int fnpImageHeight;
    public BufferedImage fnpImageObject;
    public byte[] fnpBitmapArray;
    public int fnpBitmapRasterBytes;
    public int fnpCharacterHorizontalBytes;
    public int fnpCharacterBytes;
    public int fnpBinaryBytes;
    public byte[] fnpBinaryArray;
    public int fnpMinimumFontDataFileLength;
    public int fnpMaximumFontDataFileLength;
    public int fnpMemoryBytes;
    public boolean fnpReady;
    public String fnpHostFontName;
    public JFileChooser2 fnpFontDataFileChooser;
    public String fnpExtension;
    public String fnpDescription;
    public JFileChooser2 fnpFontImageFileChooser;
    public boolean fnpEditted;

    public FontPage(int n, int n2, String string, String string2, String string3, String string4, int n3, int n4, int n5, byte[] byArray, int n6, char[][] cArray) {
        this.fnpCharacterWidth = n;
        this.fnpCharacterHeight = n2;
        this.fnpNameEn = string;
        this.fnpNameJa = string2;
        this.fnpFontDataFileName = string3;
        this.fnpFontImageFileName = string4;
        this.fnpImageCols = n3;
        this.fnpImageRows = n4;
        this.fnpMemoryRows = byArray == null ? 0 : n5;
        this.fnpMemoryArray = byArray;
        this.fnpMemoryAddress = byArray == null ? 0 : n6;
        this.fnpTableArray = cArray;
        this.fnpImageWidth = n * this.fnpImageCols;
        this.fnpImageHeight = n2 * this.fnpImageRows;
        this.fnpImageObject = new BufferedImage(this.fnpImageWidth + 3 & 0xFFFFFFFC, this.fnpImageHeight, 12, new IndexColorModel(2, 4, FNP_COLOR_BASE, FNP_COLOR_BASE, FNP_COLOR_BASE));
        this.fnpBitmapArray = ((DataBufferByte)this.fnpImageObject.getRaster().getDataBuffer()).getData();
        this.fnpBitmapRasterBytes = this.fnpImageWidth + 3 >> 2;
        this.fnpCharacterHorizontalBytes = n + 7 >> 3;
        this.fnpCharacterBytes = this.fnpCharacterHorizontalBytes * this.fnpCharacterHeight;
        this.fnpBinaryBytes = this.fnpCharacterBytes * this.fnpImageCols * this.fnpImageRows;
        this.fnpBinaryArray = new byte[this.fnpBinaryBytes];
        this.fnpMinimumFontDataFileLength = this.fnpBinaryBytes;
        this.fnpMaximumFontDataFileLength = this.fnpBinaryBytes;
        this.fnpMemoryBytes = byArray == null ? 0 : this.fnpCharacterBytes * this.fnpImageCols * this.fnpMemoryRows;
        this.fnpReady = false;
        this.fnpHostFontName = null;
        this.fnpFontDataFileChooser = null;
        this.fnpExtension = null;
        this.fnpDescription = null;
        this.fnpFontImageFileChooser = null;
        this.fnpBinaryToImage();
    }

    public boolean fnpInputMemory() {
        if (this.fnpMemoryArray == null) {
            return false;
        }
        if (this.fnpImageCols == 16 ? this.fnpIsBlankMemory(1, 4) : this.fnpImageCols == 94 && this.fnpIsBlankMemory(1, 3)) {
            return false;
        }
        this.fnpMemoryToBinary();
        this.fnpBinaryToImage();
        if (!this.fnpReady) {
            System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
            this.fnpReady = true;
        }
        return true;
    }

    public boolean fnpIsBlankMemory(int n, int n2) {
        if (this.fnpMemoryArray != null) {
            int n3 = this.fnpMemoryAddress + this.fnpCharacterBytes * (this.fnpImageCols * n2 + n);
            for (int i = 0; i < this.fnpCharacterBytes; ++i) {
                if (this.fnpMemoryArray[n3 + i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public int fnpImageRowToMemoryRow(int n) {
        return this.fnpMemoryArray == null ? -1 : (this.fnpImageCols != 94 ? n : (n <= 7 ? n : (n <= 14 ? -1 : (n <= 83 ? n - 7 : -1))));
    }

    public int fnpMemoryRowToImageRow(int n) {
        return this.fnpMemoryArray == null ? -1 : (this.fnpImageCols != 94 ? n : (n <= 7 ? n : n + 7));
    }

    public void fnpMemoryToBinary() {
        if (this.fnpMemoryArray != null) {
            for (int i = 0; i < this.fnpImageRows; ++i) {
                int n = this.fnpImageRowToMemoryRow(i);
                if (0 <= n) {
                    System.arraycopy(this.fnpMemoryArray, this.fnpMemoryAddress + this.fnpCharacterBytes * this.fnpImageCols * n, this.fnpBinaryArray, this.fnpCharacterBytes * this.fnpImageCols * i, this.fnpCharacterBytes * this.fnpImageCols);
                    continue;
                }
                Arrays.fill(this.fnpBinaryArray, this.fnpCharacterBytes * this.fnpImageCols * i, this.fnpCharacterBytes * this.fnpImageCols * (i + 1), (byte)0);
            }
        }
    }

    public void fnpBinaryToMemory() {
        if (this.fnpMemoryArray != null) {
            for (int i = 0; i < this.fnpImageRows; ++i) {
                int n = this.fnpImageRowToMemoryRow(i);
                if (0 > n) continue;
                System.arraycopy(this.fnpBinaryArray, this.fnpCharacterBytes * this.fnpImageCols * i, this.fnpMemoryArray, this.fnpMemoryAddress + this.fnpCharacterBytes * this.fnpImageCols * n, this.fnpCharacterBytes * this.fnpImageCols);
            }
        }
    }

    public final void fnpBinaryToImage() {
        byte[] byArray = this.fnpBitmapArray;
        byte[] byArray2 = this.fnpBinaryArray;
        int n = 0;
        int n2 = this.fnpBitmapRasterBytes;
        int n3 = this.fnpCharacterHeight;
        switch (this.fnpCharacterWidth) {
            case 4: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray3 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n4 = n2 * (n3 * i + k) + 1 * j;
                            byArray[n4] = byArray3[(byArray2[n] & 0xFF) >> 4];
                            ++n;
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; j += 2) {
                        byte[] byArray4 = FNP_PALET[i & 1];
                        byte[] byArray5 = FNP_PALET[2 | i & 1];
                        byte[] byArray6 = FNP_PALET[~i & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n5 = n2 * (n3 * i + k) + (6 * j >> 2);
                            int n6 = (byArray2[n] & 0xFD) << 4 | (byArray2[n + n3] & 0xFD) >> 2;
                            byArray[n5] = byArray4[n6 >> 8];
                            byArray[n5 + 1] = byArray5[n6 >> 4 & 0xF];
                            byArray[n5 + 2] = byArray6[n6 & 0xF];
                            ++n;
                        }
                        n += n3;
                    }
                }
                break;
            }
            case 8: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray7 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n7 = n2 * (n3 * i + k) + 2 * j;
                            int n8 = byArray2[n] & 0xFF;
                            byArray[n7] = byArray7[n8 >> 4];
                            byArray[n7 + 1] = byArray7[n8 & 0xF];
                            ++n;
                        }
                    }
                }
                break;
            }
            case 12: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray8 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n9 = n2 * (n3 * i + k) + 3 * j;
                            char c = (char)(byArray2[n] << 8 | byArray2[n + 1] & 0xFF);
                            byArray[n9] = byArray8[c >> 12];
                            byArray[n9 + 1] = byArray8[c >> 8 & 0xF];
                            byArray[n9 + 2] = byArray8[c >> 4 & 0xF];
                            n += 2;
                        }
                    }
                }
                break;
            }
            case 16: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray9 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n10 = n2 * (n3 * i + k) + 4 * j;
                            char c = (char)(byArray2[n] << 8 | byArray2[n + 1] & 0xFF);
                            byArray[n10] = byArray9[c >> 12];
                            byArray[n10 + 1] = byArray9[c >> 8 & 0xF];
                            byArray[n10 + 2] = byArray9[c >> 4 & 0xF];
                            byArray[n10 + 3] = byArray9[c & 0xF];
                            n += 2;
                        }
                    }
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray10 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n11 = n2 * (n3 * i + k) + 6 * j;
                            int n12 = (char)(byArray2[n] << 8 | byArray2[n + 1] & 0xFF) << 8 | byArray2[n + 2] & 0xFF;
                            byArray[n11] = byArray10[n12 >> 20];
                            byArray[n11 + 1] = byArray10[n12 >> 16 & 0xF];
                            byArray[n11 + 2] = byArray10[n12 >> 12 & 0xF];
                            byArray[n11 + 3] = byArray10[n12 >> 8 & 0xF];
                            byArray[n11 + 4] = byArray10[n12 >> 4 & 0xF];
                            byArray[n11 + 5] = byArray10[n12 & 0xF];
                            n += 3;
                        }
                    }
                }
                break;
            }
            case 32: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray11 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n13 = n2 * (n3 * i + k) + 8 * j;
                            int n14 = byArray2[n] << 24 | (byArray2[n + 1] & 0xFF) << 16 | (char)(byArray2[n + 2] << 8 | byArray2[n + 3] & 0xFF);
                            byArray[n13] = byArray11[n14 >>> 28];
                            byArray[n13 + 1] = byArray11[n14 >>> 24 & 0xF];
                            byArray[n13 + 2] = byArray11[n14 >>> 20 & 0xF];
                            byArray[n13 + 3] = byArray11[n14 >>> 16 & 0xF];
                            byArray[n13 + 4] = byArray11[n14 >>> 12 & 0xF];
                            byArray[n13 + 5] = byArray11[n14 >>> 8 & 0xF];
                            byArray[n13 + 6] = byArray11[n14 >>> 4 & 0xF];
                            byArray[n13 + 7] = byArray11[n14 & 0xF];
                            n += 4;
                        }
                    }
                }
                break;
            }
            case 48: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        byte[] byArray12 = FNP_PALET[(j ^ i) & 1];
                        for (int k = 0; k < n3; ++k) {
                            int n15 = n2 * (n3 * i + k) + 12 * j;
                            int n16 = byArray2[n] << 24 | (byArray2[n + 1] & 0xFF) << 16 | (char)(byArray2[n + 2] << 8 | byArray2[n + 3] & 0xFF);
                            byArray[n15] = byArray12[n16 >>> 28];
                            byArray[n15 + 1] = byArray12[n16 >>> 24 & 0xF];
                            byArray[n15 + 2] = byArray12[n16 >>> 20 & 0xF];
                            byArray[n15 + 3] = byArray12[n16 >>> 16 & 0xF];
                            byArray[n15 + 4] = byArray12[n16 >>> 12 & 0xF];
                            byArray[n15 + 5] = byArray12[n16 >>> 8 & 0xF];
                            byArray[n15 + 6] = byArray12[n16 >>> 4 & 0xF];
                            byArray[n15 + 7] = byArray12[n16 & 0xF];
                            n16 = (char)(byArray2[n + 4] << 8 | byArray2[n + 5] & 0xFF);
                            byArray[n15 + 8] = byArray12[n16 >>> 12 & 0xF];
                            byArray[n15 + 9] = byArray12[n16 >>> 8 & 0xF];
                            byArray[n15 + 10] = byArray12[n16 >>> 4 & 0xF];
                            byArray[n15 + 11] = byArray12[n16 & 0xF];
                            n += 6;
                        }
                    }
                }
                break;
            }
        }
    }

    public void fnpCreateImage(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        System.out.println(Multilingual.mlnJapanese ? string + " \u3092\u4f7f\u3063\u3066 " + this.fnpNameJa + " \u3092\u4f5c\u308a\u307e\u3059" : "Creating " + this.fnpNameEn + " by using " + string);
        long l = System.currentTimeMillis();
        this.fnpHostFontName = string;
        Font font = new Font(string, 0, this.fnpCharacterHeight);
        double d = this.fnpCharacterWidth;
        double d2 = this.fnpCharacterHeight;
        char[][] cArray = this.fnpTableArray;
        int n7 = cArray.length;
        int n8 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        Graphics2D graphics2D = (Graphics2D)this.fnpImageObject.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        byte[] byArray = this.fnpBitmapArray;
        Arrays.fill(byArray, 0, this.fnpBitmapRasterBytes * this.fnpImageHeight, (byte)0);
        graphics2D.setColor(FNP_COLOR_ARRAY[2]);
        graphics2D.setFont(font);
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        for (n6 = 0; n6 < this.fnpImageRows; ++n6) {
            n5 = this.fnpCharacterHeight * n6;
            block41: for (n4 = 0; n4 < this.fnpImageCols; ++n4) {
                n3 = this.fnpCharacterWidth * n4;
                graphics2D.setClip(null);
                graphics2D.clipRect(n3, n5, this.fnpCharacterWidth, this.fnpCharacterHeight);
                n2 = -1;
                block42: while (++n2 != n7) {
                    char[] cArray2 = cArray[n2];
                    int n9 = n4 + this.fnpImageCols * n6;
                    String string2 = cArray2[1] != '\u0000' ? new String(cArray2, n9, 1) : (cArray2[(n9 <<= 1) + 1] == '\u0000' ? new String(cArray2, n9, 1) : new String(cArray2, n9, 2));
                    n = string2.charAt(0);
                    switch (n) {
                        case 9585: {
                            graphics2D.setStroke(new BasicStroke());
                            graphics2D.drawLine(n3 + this.fnpCharacterWidth - 1, n5, n3, n5 + this.fnpCharacterHeight - 1);
                            continue block41;
                        }
                        case 9586: {
                            graphics2D.setStroke(new BasicStroke());
                            graphics2D.drawLine(n3, n5, n3 + this.fnpCharacterWidth - 1, n5 + this.fnpCharacterHeight - 1);
                            continue block41;
                        }
                        case 9587: {
                            graphics2D.setStroke(new BasicStroke());
                            graphics2D.drawLine(n3, n5, n3 + this.fnpCharacterWidth - 1, n5 + this.fnpCharacterHeight - 1);
                            graphics2D.drawLine(n3 + this.fnpCharacterWidth - 1, n5, n3, n5 + this.fnpCharacterHeight - 1);
                            continue block41;
                        }
                        case 9601: {
                            int n10 = this.fnpCharacterHeight + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n10, this.fnpCharacterWidth, n10);
                            continue block41;
                        }
                        case 9602: {
                            int n11 = this.fnpCharacterHeight * 2 + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n11, this.fnpCharacterWidth, n11);
                            continue block41;
                        }
                        case 9603: {
                            int n12 = this.fnpCharacterHeight * 3 + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n12, this.fnpCharacterWidth, n12);
                            continue block41;
                        }
                        case 9604: {
                            int n13 = this.fnpCharacterHeight * 4 + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n13, this.fnpCharacterWidth, n13);
                            continue block41;
                        }
                        case 9605: {
                            int n14 = this.fnpCharacterHeight * 5 + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n14, this.fnpCharacterWidth, n14);
                            continue block41;
                        }
                        case 9606: {
                            int n15 = this.fnpCharacterHeight * 6 + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n15, this.fnpCharacterWidth, n15);
                            continue block41;
                        }
                        case 9607: {
                            int n16 = this.fnpCharacterHeight * 7 + 4 >> 3;
                            graphics2D.fillRect(n3, n5 + this.fnpCharacterHeight - n16, this.fnpCharacterWidth, n16);
                            continue block41;
                        }
                        case 9608: {
                            graphics2D.fillRect(n3, n5, this.fnpCharacterWidth, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9609: {
                            int n17 = this.fnpCharacterWidth * 7 + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n17, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9610: {
                            int n18 = this.fnpCharacterWidth * 6 + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n18, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9611: {
                            int n19 = this.fnpCharacterWidth * 5 + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n19, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9612: {
                            int n20 = this.fnpCharacterWidth * 4 + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n20, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9613: {
                            int n21 = this.fnpCharacterWidth * 3 + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n21, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9614: {
                            int n22 = this.fnpCharacterWidth * 2 + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n22, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9615: {
                            int n23 = this.fnpCharacterWidth + 4 >> 3;
                            graphics2D.fillRect(n3, n5, n23, this.fnpCharacterHeight);
                            continue block41;
                        }
                        case 9619: {
                            int n24;
                            for (n24 = 0; n24 < this.fnpCharacterHeight; ++n24) {
                                for (int i = 0; i < this.fnpCharacterWidth; ++i) {
                                    if (((i ^ n24) & 1) != 0) continue;
                                    graphics2D.fillRect(n3 + i, n5 + n24, 1, 1);
                                }
                            }
                            continue block41;
                        }
                        case 9622: {
                            graphics2D.fillRect(n3, n5 + (this.fnpCharacterHeight >> 1), this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            continue block41;
                        }
                        case 9623: {
                            graphics2D.fillRect(n3 + (this.fnpCharacterWidth >> 1), n5 + (this.fnpCharacterHeight >> 1), this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            continue block41;
                        }
                        case 9624: {
                            graphics2D.fillRect(n3, n5, this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            continue block41;
                        }
                        case 9626: {
                            graphics2D.fillRect(n3, n5, this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            graphics2D.fillRect(n3 + (this.fnpCharacterWidth >> 1), n5 + (this.fnpCharacterHeight >> 1), this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            continue block41;
                        }
                        case 9629: {
                            graphics2D.fillRect(n3 + (this.fnpCharacterWidth >> 1), n5, this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            continue block41;
                        }
                        case 9630: {
                            graphics2D.fillRect(n3 + (this.fnpCharacterWidth >> 1), n5, this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            graphics2D.fillRect(n3, n5 + (this.fnpCharacterHeight >> 1), this.fnpCharacterWidth >> 1, this.fnpCharacterHeight >> 1);
                            continue block41;
                        }
                        case 9698: {
                            int n24;
                            graphics2D.setStroke(new BasicStroke());
                            if (this.fnpCharacterWidth <= this.fnpCharacterHeight) {
                                for (n24 = 0; n24 <= this.fnpCharacterHeight - 1; ++n24) {
                                    int n25 = n24 * (this.fnpCharacterWidth - 1) / (this.fnpCharacterHeight - 1);
                                    graphics2D.drawLine(n3 + this.fnpCharacterWidth - 1 - n25, n5 + n24, n3 + this.fnpCharacterWidth - 1, n5 + n24);
                                }
                                continue block41;
                            }
                            for (n24 = 0; n24 <= this.fnpCharacterWidth - 1; ++n24) {
                                int n26 = n24 * (this.fnpCharacterHeight - 1) / (this.fnpCharacterWidth - 1);
                                graphics2D.drawLine(n3 + n24, n5 + this.fnpCharacterHeight - 1 - n26, n3 + n24, n5 + this.fnpCharacterHeight - 1);
                            }
                            continue block41;
                        }
                        case 9699: {
                            int n24;
                            graphics2D.setStroke(new BasicStroke());
                            if (this.fnpCharacterWidth <= this.fnpCharacterHeight) {
                                for (n24 = 0; n24 <= this.fnpCharacterHeight - 1; ++n24) {
                                    int n27 = n24 * (this.fnpCharacterWidth - 1) / (this.fnpCharacterHeight - 1);
                                    graphics2D.drawLine(n3, n5 + n24, n3 + n27, n5 + n24);
                                }
                                continue block41;
                            }
                            for (n24 = 0; n24 <= this.fnpCharacterWidth - 1; ++n24) {
                                int n28 = n24 * (this.fnpCharacterHeight - 1) / (this.fnpCharacterWidth - 1);
                                graphics2D.drawLine(n3 + n24, n5 + n28, n3 + n24, n5 + this.fnpCharacterHeight - 1);
                            }
                            continue block41;
                        }
                        default: {
                            double d7;
                            if (n == 32 || n == 12288 || font.canDisplayUpTo(string2) != -1) continue block42;
                            if (n8 != n2) {
                                n8 = n2;
                                Rectangle2D rectangle2D = new TextLayout(cArray2[0] < '\u0080' ? "\u2588" : "\u253c", font, graphics2D.getFontRenderContext()).getBounds();
                                d3 = rectangle2D.getX();
                                d4 = rectangle2D.getY();
                                d5 = rectangle2D.getWidth();
                                d6 = rectangle2D.getHeight();
                            }
                            Rectangle2D rectangle2D = new TextLayout(string2, font, graphics2D.getFontRenderContext()).getBounds();
                            double d8 = rectangle2D.getX();
                            double d9 = rectangle2D.getY();
                            double d10 = rectangle2D.getWidth();
                            double d11 = rectangle2D.getHeight();
                            double d12 = 1.0;
                            double d13 = 1.0;
                            double d14 = 0.0;
                            double d15 = 0.0;
                            d8 -= d3;
                            d9 -= d4;
                            d14 -= d3;
                            d15 -= d4;
                            if (d5 < d10) {
                                d7 = d5 / d10;
                                d12 *= d7;
                                d14 = (d14 - d8) * d7;
                            } else if (d8 < 0.0) {
                                d14 -= d8;
                            } else if (d5 < d8 + d10) {
                                d14 -= d8 + d10 - d5;
                            }
                            if (d6 < d11) {
                                d7 = d6 / d11;
                                d13 *= d7;
                                d15 = (d15 - d9) * d7;
                            } else if (d9 < 0.0) {
                                d15 -= d9;
                            } else if (d6 < d9 + d11) {
                                d15 -= d9 + d11 - d6;
                            }
                            d7 = d / d5;
                            d12 *= d7;
                            d14 = d14 * d7 + d * (double)n4;
                            d7 = d2 / d6;
                            d15 = d15 * d7 + d2 * (double)n6;
                            graphics2D.translate(d14, d15);
                            graphics2D.scale(d12, d13 *= d7);
                            graphics2D.drawString(string2, 0, 0);
                            graphics2D.setTransform(affineTransform);
                            continue block41;
                        }
                    }
                }
            }
        }
        graphics2D.setClip(shape);
        n6 = this.fnpBitmapRasterBytes;
        n5 = this.fnpCharacterWidth;
        n4 = this.fnpCharacterHeight;
        switch (this.fnpCharacterWidth) {
            case 4: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n29 = n2 = n6 * (n4 * n3 + n) + 1 * i;
                            byArray[n29] = (byte)(byArray[n29] | by);
                        }
                    }
                }
                break;
            }
            case 6: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; i += 2) {
                        byte by = FNP_PALET[n3 & 1][0];
                        n = FNP_PALET[2 | n3 & 1][0];
                        n2 = FNP_PALET[~n3 & 1][0];
                        for (int j = 0; j < n4; ++j) {
                            int n30;
                            int n31 = n30 = n6 * (n4 * n3 + j) + (6 * i >> 2);
                            byArray[n31] = (byte)(byArray[n31] | by);
                            int n32 = n30 + 1;
                            byArray[n32] = (byte)(byArray[n32] | n);
                            int n33 = n30 + 2;
                            byArray[n33] = (byte)(byArray[n33] | n2);
                        }
                    }
                }
                break;
            }
            case 8: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n34 = n2 = n6 * (n4 * n3 + n) + 2 * i;
                            byArray[n34] = (byte)(byArray[n34] | by);
                            int n35 = n2 + 1;
                            byArray[n35] = (byte)(byArray[n35] | by);
                        }
                    }
                }
                break;
            }
            case 12: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n36 = n2 = n6 * (n4 * n3 + n) + 3 * i;
                            byArray[n36] = (byte)(byArray[n36] | by);
                            int n37 = n2 + 1;
                            byArray[n37] = (byte)(byArray[n37] | by);
                            int n38 = n2 + 2;
                            byArray[n38] = (byte)(byArray[n38] | by);
                        }
                    }
                }
                break;
            }
            case 16: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n39 = n2 = n6 * (n4 * n3 + n) + 4 * i;
                            byArray[n39] = (byte)(byArray[n39] | by);
                            int n40 = n2 + 1;
                            byArray[n40] = (byte)(byArray[n40] | by);
                            int n41 = n2 + 2;
                            byArray[n41] = (byte)(byArray[n41] | by);
                            int n42 = n2 + 3;
                            byArray[n42] = (byte)(byArray[n42] | by);
                        }
                    }
                }
                break;
            }
            case 24: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n43 = n2 = n6 * (n4 * n3 + n) + 6 * i;
                            byArray[n43] = (byte)(byArray[n43] | by);
                            int n44 = n2 + 1;
                            byArray[n44] = (byte)(byArray[n44] | by);
                            int n45 = n2 + 2;
                            byArray[n45] = (byte)(byArray[n45] | by);
                            int n46 = n2 + 3;
                            byArray[n46] = (byte)(byArray[n46] | by);
                            int n47 = n2 + 4;
                            byArray[n47] = (byte)(byArray[n47] | by);
                            int n48 = n2 + 5;
                            byArray[n48] = (byte)(byArray[n48] | by);
                        }
                    }
                }
                break;
            }
            case 32: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n49 = n2 = n6 * (n4 * n3 + n) + 8 * i;
                            byArray[n49] = (byte)(byArray[n49] | by);
                            int n50 = n2 + 1;
                            byArray[n50] = (byte)(byArray[n50] | by);
                            int n51 = n2 + 2;
                            byArray[n51] = (byte)(byArray[n51] | by);
                            int n52 = n2 + 3;
                            byArray[n52] = (byte)(byArray[n52] | by);
                            int n53 = n2 + 4;
                            byArray[n53] = (byte)(byArray[n53] | by);
                            int n54 = n2 + 5;
                            byArray[n54] = (byte)(byArray[n54] | by);
                            int n55 = n2 + 6;
                            byArray[n55] = (byte)(byArray[n55] | by);
                            int n56 = n2 + 7;
                            byArray[n56] = (byte)(byArray[n56] | by);
                        }
                    }
                }
                break;
            }
            case 36: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n57 = n2 = n6 * (n4 * n3 + n) + 9 * i;
                            byArray[n57] = (byte)(byArray[n57] | by);
                            int n58 = n2 + 1;
                            byArray[n58] = (byte)(byArray[n58] | by);
                            int n59 = n2 + 2;
                            byArray[n59] = (byte)(byArray[n59] | by);
                            int n60 = n2 + 3;
                            byArray[n60] = (byte)(byArray[n60] | by);
                            int n61 = n2 + 4;
                            byArray[n61] = (byte)(byArray[n61] | by);
                            int n62 = n2 + 5;
                            byArray[n62] = (byte)(byArray[n62] | by);
                            int n63 = n2 + 6;
                            byArray[n63] = (byte)(byArray[n63] | by);
                            int n64 = n2 + 7;
                            byArray[n64] = (byte)(byArray[n64] | by);
                            int n65 = n2 + 8;
                            byArray[n65] = (byte)(byArray[n65] | by);
                        }
                    }
                }
                break;
            }
            case 48: {
                for (n3 = 0; n3 < this.fnpImageRows; ++n3) {
                    for (int i = 0; i < this.fnpImageCols; ++i) {
                        byte by = FNP_PALET[(i ^ n3) & 1][0];
                        for (n = 0; n < n4; ++n) {
                            int n66 = n2 = n6 * (n4 * n3 + n) + 12 * i;
                            byArray[n66] = (byte)(byArray[n66] | by);
                            int n67 = n2 + 1;
                            byArray[n67] = (byte)(byArray[n67] | by);
                            int n68 = n2 + 2;
                            byArray[n68] = (byte)(byArray[n68] | by);
                            int n69 = n2 + 3;
                            byArray[n69] = (byte)(byArray[n69] | by);
                            int n70 = n2 + 4;
                            byArray[n70] = (byte)(byArray[n70] | by);
                            int n71 = n2 + 5;
                            byArray[n71] = (byte)(byArray[n71] | by);
                            int n72 = n2 + 6;
                            byArray[n72] = (byte)(byArray[n72] | by);
                            int n73 = n2 + 7;
                            byArray[n73] = (byte)(byArray[n73] | by);
                            int n74 = n2 + 8;
                            byArray[n74] = (byte)(byArray[n74] | by);
                            int n75 = n2 + 9;
                            byArray[n75] = (byte)(byArray[n75] | by);
                            int n76 = n2 + 10;
                            byArray[n76] = (byte)(byArray[n76] | by);
                            int n77 = n2 + 11;
                            byArray[n77] = (byte)(byArray[n77] | by);
                        }
                    }
                }
                break;
            }
        }
        this.fnpImageToBinary();
        this.fnpBinaryToMemory();
        long l2 = System.currentTimeMillis() - l;
        System.out.println(l2 + "ms");
        if (!this.fnpReady) {
            System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
            this.fnpReady = true;
        }
    }

    public void fnpImageToBinary() {
        byte[] byArray = this.fnpBitmapArray;
        byte[] byArray2 = this.fnpBinaryArray;
        int n = 0;
        int n2 = this.fnpBitmapRasterBytes;
        int n3 = this.fnpCharacterHeight;
        switch (this.fnpCharacterWidth) {
            case 4: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n4 = n2 * (n3 * i + k) + 1 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n4] & 0xFF] << 4);
                            ++n;
                        }
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; j += 2) {
                        for (int k = 0; k < n3; ++k) {
                            int n5 = n2 * (n3 * i + k) + (6 * j >> 2);
                            int n6 = (char)(byArray[n5] << 8 | byArray[n5 + 1] & 0xFF) << 8 | byArray[n5 + 2] & 0xFF;
                            byArray2[n] = (byte)(FNP_INV_PALET[n6 >> 16] << 4 | FNP_INV_PALET[n6 >> 8 & 0xF0]);
                            byArray2[n + n3] = (byte)(FNP_INV_PALET[n6 >> 4 & 0xFF] << 4 | FNP_INV_PALET[n6 << 4 & 0xF0]);
                            ++n;
                        }
                        n += n3;
                    }
                }
                break;
            }
            case 8: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n7 = n2 * (n3 * i + k) + 2 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n7] & 0xFF] << 4 | FNP_INV_PALET[byArray[n7 + 1] & 0xFF]);
                            ++n;
                        }
                    }
                }
                break;
            }
            case 12: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n8 = n2 * (n3 * i + k) + 3 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n8] & 0xFF] << 4 | FNP_INV_PALET[byArray[n8 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n8 + 2] & 0xFF] << 4);
                            n += 2;
                        }
                    }
                }
                break;
            }
            case 16: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n9 = n2 * (n3 * i + k) + 4 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n9] & 0xFF] << 4 | FNP_INV_PALET[byArray[n9 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n9 + 2] & 0xFF] << 4 | FNP_INV_PALET[byArray[n9 + 3] & 0xFF]);
                            n += 2;
                        }
                    }
                }
                break;
            }
            case 18: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; j += 2) {
                        for (int k = 0; k < n3; ++k) {
                            int n10 = n2 * (n3 * i + k) + (18 * j >> 2);
                            long l = (long)FNP_INV_PALET[byArray[n10] & 0xFF] << 32 | (long)FNP_INV_PALET[byArray[n10 + 1] & 0xFF] << 28 | (long)FNP_INV_PALET[byArray[n10 + 2] & 0xFF] << 24 | (long)FNP_INV_PALET[byArray[n10 + 3] & 0xFF] << 20 | (long)FNP_INV_PALET[byArray[n10 + 4] & 0xFF] << 16 | (long)FNP_INV_PALET[byArray[n10 + 5] & 0xFF] << 12 | (long)FNP_INV_PALET[byArray[n10 + 6] & 0xFF] << 8 | (long)FNP_INV_PALET[byArray[n10 + 7] & 0xFF] << 4 | (long)FNP_INV_PALET[byArray[n10 + 8] & 0xFF];
                            byArray2[n] = (byte)(l >> 28);
                            byArray2[n + 1] = (byte)(l >> 20);
                            byArray2[n + 2] = (byte)(l >> 12 & 0xC0L);
                            byArray2[n + 3 * n3] = (byte)(l >> 10);
                            byArray2[n + 3 * n3 + 1] = (byte)(l >> 2);
                            byArray2[n + 3 * n3 + 2] = (byte)(l << 6);
                            n += 3;
                        }
                        n += 3 * n3;
                    }
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n11 = n2 * (n3 * i + k) + 6 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n11] & 0xFF] << 4 | FNP_INV_PALET[byArray[n11 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n11 + 2] & 0xFF] << 4 | FNP_INV_PALET[byArray[n11 + 3] & 0xFF]);
                            byArray2[n + 2] = (byte)(FNP_INV_PALET[byArray[n11 + 4] & 0xFF] << 4 | FNP_INV_PALET[byArray[n11 + 5] & 0xFF]);
                            n += 3;
                        }
                    }
                }
                break;
            }
            case 28: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n12 = n2 * (n3 * i + k) + 7 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n12] & 0xFF] << 4 | FNP_INV_PALET[byArray[n12 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n12 + 2] & 0xFF] << 4 | FNP_INV_PALET[byArray[n12 + 3] & 0xFF]);
                            byArray2[n + 2] = (byte)(FNP_INV_PALET[byArray[n12 + 4] & 0xFF] << 4 | FNP_INV_PALET[byArray[n12 + 5] & 0xFF]);
                            byArray2[n + 3] = (byte)(FNP_INV_PALET[byArray[n12 + 6] & 0xFF] << 4);
                            n += 4;
                        }
                    }
                }
                break;
            }
            case 30: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; j += 2) {
                        for (int k = 0; k < n3; ++k) {
                            int n13 = n2 * (n3 * i + k) + (30 * j >> 2);
                            long l = (long)FNP_INV_PALET[byArray[n13] & 0xFF] << 56 | (long)FNP_INV_PALET[byArray[n13 + 1] & 0xFF] << 52 | (long)FNP_INV_PALET[byArray[n13 + 2] & 0xFF] << 48 | (long)FNP_INV_PALET[byArray[n13 + 3] & 0xFF] << 44 | (long)FNP_INV_PALET[byArray[n13 + 4] & 0xFF] << 40 | (long)FNP_INV_PALET[byArray[n13 + 5] & 0xFF] << 36 | (long)FNP_INV_PALET[byArray[n13 + 6] & 0xFF] << 32 | (long)FNP_INV_PALET[byArray[n13 + 7] & 0xFF] << 28 | (long)FNP_INV_PALET[byArray[n13 + 8] & 0xFF] << 24 | (long)FNP_INV_PALET[byArray[n13 + 9] & 0xFF] << 20 | (long)FNP_INV_PALET[byArray[n13 + 10] & 0xFF] << 16 | (long)FNP_INV_PALET[byArray[n13 + 11] & 0xFF] << 12 | (long)FNP_INV_PALET[byArray[n13 + 12] & 0xFF] << 8 | (long)FNP_INV_PALET[byArray[n13 + 13] & 0xFF] << 4 | (long)FNP_INV_PALET[byArray[n13 + 14] & 0xFF];
                            byArray2[n] = (byte)(l >> 52);
                            byArray2[n + 1] = (byte)(l >> 44);
                            byArray2[n + 2] = (byte)(l >> 36);
                            byArray2[n + 3] = (byte)(l >> 28 & 0xFCL);
                            byArray2[n + 4 * n3] = (byte)(l >> 22);
                            byArray2[n + 4 * n3 + 1] = (byte)(l >> 14);
                            byArray2[n + 4 * n3 + 2] = (byte)(l >> 6);
                            byArray2[n + 4 * n3 + 3] = (byte)(l << 2);
                            n += 4;
                        }
                        n += 4 * n3;
                    }
                }
                break;
            }
            case 32: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n14 = n2 * (n3 * i + k) + 8 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n14] & 0xFF] << 4 | FNP_INV_PALET[byArray[n14 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n14 + 2] & 0xFF] << 4 | FNP_INV_PALET[byArray[n14 + 3] & 0xFF]);
                            byArray2[n + 2] = (byte)(FNP_INV_PALET[byArray[n14 + 4] & 0xFF] << 4 | FNP_INV_PALET[byArray[n14 + 5] & 0xFF]);
                            byArray2[n + 3] = (byte)(FNP_INV_PALET[byArray[n14 + 6] & 0xFF] << 4 | FNP_INV_PALET[byArray[n14 + 7] & 0xFF]);
                            n += 4;
                        }
                    }
                }
                break;
            }
            case 36: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n15 = n2 * (n3 * i + k) + 9 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n15] & 0xFF] << 4 | FNP_INV_PALET[byArray[n15 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n15 + 2] & 0xFF] << 4 | FNP_INV_PALET[byArray[n15 + 3] & 0xFF]);
                            byArray2[n + 2] = (byte)(FNP_INV_PALET[byArray[n15 + 4] & 0xFF] << 4 | FNP_INV_PALET[byArray[n15 + 5] & 0xFF]);
                            byArray2[n + 3] = (byte)(FNP_INV_PALET[byArray[n15 + 6] & 0xFF] << 4 | FNP_INV_PALET[byArray[n15 + 7] & 0xFF]);
                            byArray2[n + 4] = (byte)(FNP_INV_PALET[byArray[n15 + 8] & 0xFF] << 4);
                            n += 5;
                        }
                    }
                }
                break;
            }
            case 48: {
                for (int i = 0; i < this.fnpImageRows; ++i) {
                    for (int j = 0; j < this.fnpImageCols; ++j) {
                        for (int k = 0; k < n3; ++k) {
                            int n16 = n2 * (n3 * i + k) + 12 * j;
                            byArray2[n] = (byte)(FNP_INV_PALET[byArray[n16] & 0xFF] << 4 | FNP_INV_PALET[byArray[n16 + 1] & 0xFF]);
                            byArray2[n + 1] = (byte)(FNP_INV_PALET[byArray[n16 + 2] & 0xFF] << 4 | FNP_INV_PALET[byArray[n16 + 3] & 0xFF]);
                            byArray2[n + 2] = (byte)(FNP_INV_PALET[byArray[n16 + 4] & 0xFF] << 4 | FNP_INV_PALET[byArray[n16 + 5] & 0xFF]);
                            byArray2[n + 3] = (byte)(FNP_INV_PALET[byArray[n16 + 6] & 0xFF] << 4 | FNP_INV_PALET[byArray[n16 + 7] & 0xFF]);
                            byArray2[n + 4] = (byte)(FNP_INV_PALET[byArray[n16 + 8] & 0xFF] << 4 | FNP_INV_PALET[byArray[n16 + 9] & 0xFF]);
                            byArray2[n + 5] = (byte)(FNP_INV_PALET[byArray[n16 + 10] & 0xFF] << 4 | FNP_INV_PALET[byArray[n16 + 11] & 0xFF]);
                            n += 6;
                        }
                    }
                }
                break;
            }
        }
    }

    public String fnpGetExtension() {
        if (this.fnpExtension == null) {
            this.fnpExtension = ".dat";
        }
        return this.fnpExtension;
    }

    public String fnpGetDescription() {
        if (this.fnpDescription == null) {
            this.fnpDescription = Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb (*" + this.fnpGetExtension() + ")" : this.fnpNameEn + " font data files (*" + this.fnpGetExtension() + ")";
        }
        return this.fnpDescription;
    }

    public void fnpMakeFontDataFileChooser() {
        if (this.fnpFontDataFileChooser == null) {
            this.fnpFontDataFileChooser = new JFileChooser2(new File(this.fnpFontDataFileName));
            this.fnpFontDataFileChooser.setMultiSelectionEnabled(false);
            this.fnpFontDataFileChooser.setFileFilter(new FileFilter(this){
                final /* synthetic */ FontPage this$0;
                {
                    FontPage fontPage2 = fontPage;
                    Objects.requireNonNull(fontPage2);
                    this.this$0 = fontPage2;
                }

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.isFile() && this.this$0.fnpIsFontDataFileLength(file.length()) && file.getName().toLowerCase().endsWith(this.this$0.fnpGetExtension());
                }

                @Override
                public String getDescription() {
                    return this.this$0.fnpGetDescription();
                }
            });
        }
    }

    public void fnpOpenLoadFontDataFileChooser() {
        File file;
        this.fnpMakeFontDataFileChooser();
        if (this.fnpFontDataFileChooser.showOpenDialog(null) == 0 && this.fnpLoadFontDataFile(file = this.fnpFontDataFileChooser.getSelectedFile())) {
            this.fnpFontDataFileName = file.getPath();
            this.fnpFontDataFileChooser.addHistory(file);
        }
    }

    public boolean fnpLoadFontDataFiles(String string) {
        boolean bl = this.fnpReady;
        this.fnpReady = false;
        for (String string2 : string.split(",")) {
            if ((string2 = string2.trim()).length() == 0 || string2.equalsIgnoreCase("none")) continue;
            this.fnpLoadFontDataFile(new File(string2));
            if (this.fnpReady) {
                if (!bl) {
                    System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
                    bl = true;
                }
                return true;
            }
            System.out.println(Multilingual.mlnJapanese ? string2 + " \u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093" : "Cannot read " + string2);
        }
        this.fnpReady = bl;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fnpLoadFontDataFile(File file) {
        if (!file.isFile()) return false;
        if ((long)this.fnpMinimumFontDataFileLength > file.length()) return false;
        if (file.length() > (long)this.fnpMaximumFontDataFileLength) return false;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            int n;
            int n2;
            byte[] byArray = new byte[this.fnpMaximumFontDataFileLength];
            for (n = 0; n < this.fnpMaximumFontDataFileLength && (n2 = bufferedInputStream.read(byArray, n, this.fnpMaximumFontDataFileLength - n)) >= 0; n += n2) {
            }
            if (!this.fnpIsFontDataFileLength(n)) return false;
            if (!this.fnpLoadFontDataArray(byArray, 0, n)) return false;
            n2 = 1;
            return n2 != 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean fnpIsFontDataFileLength(long l) {
        return l == (long)this.fnpBinaryBytes;
    }

    public boolean fnpLoadFontDataArray(byte[] byArray) {
        return this.fnpLoadFontDataArray(byArray, 0, byArray.length);
    }

    public boolean fnpLoadFontDataArray(byte[] byArray, int n, int n2) {
        if (n2 == this.fnpBinaryBytes) {
            System.arraycopy(byArray, n, this.fnpBinaryArray, 0, n2);
            this.fnpBinaryToImage();
            this.fnpBinaryToMemory();
            if (!this.fnpReady) {
                System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
                this.fnpReady = true;
            }
            return true;
        }
        return false;
    }

    public void fnpOpenSaveFontDataFileChooser() {
        File file;
        this.fnpMakeFontDataFileChooser();
        if (this.fnpFontDataFileChooser.showSaveDialog(null) == 0 && this.fnpSaveFontDataFile(file = this.fnpFontDataFileChooser.getSelectedFile())) {
            this.fnpFontDataFileName = file.getPath();
            this.fnpFontDataFileChooser.addHistory(file);
            this.fnpEditted = false;
        }
    }

    public boolean fnpSaveFontDataFile(File file) {
        String string = file.getAbsolutePath();
        file = new File(string);
        String string2 = string + ".bak";
        String string3 = string + ".tmp";
        File file2 = new File(string2);
        File file3 = new File(string3);
        if (file.exists() && JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? string + " \u306b\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f" : "Do you want to overwrite " + string + " ?", Multilingual.mlnJapanese ? "\u4e0a\u66f8\u304d\u306e\u78ba\u8a8d" : "Overwrite confirmation", 0) != 0) {
            return false;
        }
        if (file3.isFile() && !file3.delete()) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string3 + " \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093" : "Cannot delete " + string3);
            return false;
        }
        byte[] byArray = this.fnpSaveFontDataArray();
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));){
            bufferedOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string3 + " \u306b\u66f8\u304d\u51fa\u305b\u307e\u305b\u3093" : "Cannot write " + string3);
            return false;
        }
        if (file.exists()) {
            if (file2.isFile() && !file2.delete()) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string2 + " \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093" : "Cannot delete " + string2);
                return false;
            }
            if (!file.renameTo(file2)) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string + " \u3092 " + string2 + " \u306b\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093" : "Cannot rename " + string + " to " + string2);
                return false;
            }
        }
        if (!file3.renameTo(file)) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string3 + " \u3092 " + string + " \u306b\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093" : "Cannot rename " + string3 + " to " + string);
            return false;
        }
        return true;
    }

    public byte[] fnpSaveFontDataArray() {
        return this.fnpBinaryArray;
    }

    public void fnpZeroClear() {
        if (JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? this.fnpNameJa + " \u3092\u30bc\u30ed\u30af\u30ea\u30a2\u3057\u307e\u3059" : "Zero clear " + this.fnpNameEn + " ?", Multilingual.mlnJapanese ? "\u30bc\u30ed\u30af\u30ea\u30a2\u306e\u78ba\u8a8d" : "Zero clear confirmation", 2) != 0) {
            return;
        }
        Arrays.fill(this.fnpBinaryArray, 0, this.fnpBinaryBytes, (byte)0);
        this.fnpBinaryToImage();
        this.fnpBinaryToMemory();
        this.fnpReady = false;
    }

    public int fnpGetBinaryPixel(int n, int n2, int n3, int n4) {
        int n5 = this.fnpCharacterBytes * (this.fnpImageCols * n2 + n) + this.fnpCharacterHorizontalBytes * n4 + (n3 >> 3);
        int n6 = ~n3 & 7;
        return this.fnpBinaryArray[n5] >> n6 & 1;
    }

    public void fnpSetBinaryPixel(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.fnpCharacterBytes * (this.fnpImageCols * n2 + n) + this.fnpCharacterHorizontalBytes * n4 + (n3 >> 3);
        int n7 = ~n3 & 7;
        this.fnpBinaryArray[n6] = (byte)(this.fnpBinaryArray[n6] & ~(1 << n7) | (n5 & 1) << n7);
    }

    public String fnpGetStatusText(int n, int n2) {
        if (0 > n || n >= this.fnpImageWidth || 0 > n2 || n2 >= this.fnpImageHeight) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n / this.fnpCharacterWidth;
        int n4 = n2 / this.fnpCharacterHeight;
        int n5 = n - this.fnpCharacterWidth * n3;
        int n6 = n2 - this.fnpCharacterHeight * n4;
        int n7 = this.fnpImageRowToMemoryRow(n4);
        if (n7 < 0) {
            stringBuilder.append('(').append(n3).append(',').append(n4).append(')');
            stringBuilder.append(' ');
            stringBuilder.append('(').append(n5).append(',').append(n6).append(')');
        } else {
            int n8 = this.fnpMemoryAddress + this.fnpCharacterBytes * (this.fnpImageCols * n7 + n3);
            int n9 = n8 + this.fnpCharacterHorizontalBytes * n6 + (n5 >> 3);
            int n10 = ~n5 & 7;
            XEiJ.fmtHex8(stringBuilder.append('(').append(n3).append(',').append(n4).append(")=$"), n8);
            XEiJ.fmtHex8(stringBuilder.append("-$"), n8 + this.fnpCharacterBytes - 1);
            XEiJ.fmtHex8(stringBuilder.append(" (").append(n5).append(',').append(n6).append(")=$"), n9);
            stringBuilder.append(':').append(n10);
        }
        return stringBuilder.toString();
    }

    public void fnpMakeFontImageFileChooser() {
        if (this.fnpFontImageFileChooser == null) {
            this.fnpFontImageFileChooser = new JFileChooser2(new File(this.fnpFontImageFileName));
            this.fnpFontImageFileChooser.setMultiSelectionEnabled(false);
            this.fnpFontImageFileChooser.setFileFilter(new FileFilter(this){
                {
                    Objects.requireNonNull(fontPage);
                }

                @Override
                public boolean accept(File file) {
                    if (file.isFile()) {
                        String string = file.getName();
                        int n = 0;
                        int n2 = string.lastIndexOf(".");
                        if (0 <= n2) {
                            String string2 = string.substring(n2 + 1);
                            for (String string3 : ImageIO.getReaderFileSuffixes()) {
                                if (!string2.equalsIgnoreCase(string3)) continue;
                                n |= 1;
                                break;
                            }
                            for (String string3 : ImageIO.getWriterFileSuffixes()) {
                                if (!string2.equalsIgnoreCase(string3)) continue;
                                n |= 2;
                                break;
                            }
                        }
                        return n == 3;
                    }
                    return file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return Multilingual.mlnJapanese ? "\u30d5\u30a9\u30f3\u30c8\u753b\u50cf\u30d5\u30a1\u30a4\u30eb" : "Font image files";
                }
            });
        }
    }

    public void fnpOpenReadFontImageFileChooser() {
        this.fnpMakeFontImageFileChooser();
        if (this.fnpFontImageFileChooser.showOpenDialog(null) == 0) {
            File file = this.fnpFontImageFileChooser.getSelectedFile();
            if (this.fnpReadFontImageFile(file)) {
                this.fnpFontImageFileName = file.getPath();
                this.fnpFontImageFileChooser.addHistory(file);
            } else {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? "\u5931\u6557\u3057\u307e\u3057\u305f" : "failed");
            }
        }
    }

    public boolean fnpReadFontImageFile(File file) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (Exception exception) {
            return false;
        }
        return this.fnpInputImage(bufferedImage);
    }

    public boolean fnpInputImage(BufferedImage bufferedImage) {
        if (bufferedImage.getWidth() != this.fnpImageWidth || bufferedImage.getHeight() != this.fnpImageHeight) {
            return false;
        }
        int n = this.fnpBitmapRasterBytes;
        byte[] byArray = this.fnpBitmapArray;
        for (int i = 0; i < this.fnpImageHeight; ++i) {
            int n2 = 0;
            while (n2 + 3 < this.fnpImageWidth) {
                byArray[n * i + (n2 >> 2)] = (byte)(((bufferedImage.getRGB(n2, i) & 0xC0C0C0) == 0xC0C0C0 ? 128 : 0) | ((bufferedImage.getRGB(n2 + 1, i) & 0xC0C0C0) == 0xC0C0C0 ? 32 : 0) | ((bufferedImage.getRGB(n2 + 2, i) & 0xC0C0C0) == 0xC0C0C0 ? 8 : 0) | ((bufferedImage.getRGB(n2 + 3, i) & 0xC0C0C0) == 0xC0C0C0 ? 2 : 0));
                n2 += 4;
            }
            while (n2 < this.fnpImageWidth) {
                byArray[n * i + (n2 >> 2)] = (byte)(((bufferedImage.getRGB(n2, i) & 0xC0C0C0) == 0xC0C0C0 ? 128 : 0) | (n2 + 1 < this.fnpImageWidth && (bufferedImage.getRGB(n2 + 1, i) & 0xC0C0C0) == 0xC0C0C0 ? 32 : 0) | (n2 + 2 < this.fnpImageWidth && (bufferedImage.getRGB(n2 + 2, i) & 0xC0C0C0) == 0xC0C0C0 ? 8 : 0) | (n2 + 3 < this.fnpImageWidth && (bufferedImage.getRGB(n2 + 3, i) & 0xC0C0C0) == 0xC0C0C0 ? 2 : 0));
                ++n2;
            }
        }
        this.fnpImageToBinary();
        this.fnpBinaryToImage();
        this.fnpBinaryToMemory();
        if (!this.fnpReady) {
            System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
            this.fnpReady = true;
        }
        return true;
    }

    public void fnpOpenWriteFontImageFileChooser() {
        File file;
        this.fnpMakeFontImageFileChooser();
        if (this.fnpFontImageFileChooser.showSaveDialog(null) == 0 && this.fnpWriteFontImageFile(file = this.fnpFontImageFileChooser.getSelectedFile())) {
            this.fnpFontImageFileName = file.getPath();
            this.fnpFontImageFileChooser.addHistory(file);
            this.fnpEditted = false;
        }
    }

    public boolean fnpWriteFontImageFile(File file) {
        Object object;
        String string = file.getAbsolutePath();
        file = new File(string);
        String string2 = string + ".bak";
        String string3 = string + ".tmp";
        File file2 = new File(string2);
        File file3 = new File(string3);
        ImageWriter imageWriter = null;
        int n = string.lastIndexOf(".");
        if (0 <= n && (object = ImageIO.getImageWritersBySuffix(string.substring(n + 1))).hasNext()) {
            imageWriter = object.next();
        }
        if (imageWriter == null) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string + " \u306e\u5f62\u5f0f\u304c\u4e0d\u660e\u3067\u3059" : "Unknown format of " + string);
            return false;
        }
        if (file.exists() && JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? string + " \u306b\u4e0a\u66f8\u304d\u3057\u307e\u3059" : "Overwrite " + string + " ?", Multilingual.mlnJapanese ? "\u4e0a\u66f8\u304d\u306e\u78ba\u8a8d" : "Overwrite confirmation", 2) != 0) {
            return false;
        }
        if (file3.isFile() && !file3.delete()) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string3 + " \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093" : "Cannot delete " + string3);
            return false;
        }
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam.canWriteCompressed()) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(1.0f);
        }
        try {
            object = ImageIO.createImageOutputStream(file3);
            try {
                imageWriter.setOutput(object);
                imageWriter.write(null, new IIOImage(this.fnpImageObject, null, null), imageWriteParam);
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string3 + " \u306b\u66f8\u304d\u51fa\u305b\u307e\u305b\u3093" : "Cannot write " + string3);
            return false;
        }
        if (file.exists()) {
            if (file2.isFile() && !file2.delete()) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string2 + " \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093" : "Cannot delete " + string2);
                return false;
            }
            if (!file.renameTo(file2)) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string + " \u3092 " + string2 + " \u306b\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093" : "Cannot rename " + string + " to " + string2);
                return false;
            }
        }
        if (!file3.renameTo(file)) {
            JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? string3 + " \u3092 " + string + " \u306b\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093" : "Cannot rename " + string3 + " to " + string);
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            FontPage.FNP_INV_PALET[i] = (byte)(i >> 4 & 8 | i >> 3 & 4 | i >> 2 & 2 | i >> 1 & 1);
        }
    }

    public static final class Smk
    extends FontPage {
        public static final char[] HALF_BASE = "                                 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\u00a5]^_`abcdefghijklmnopqrstuvwxyz{|}                                   \uff61\uff62\uff63\uff64\uff65\uff66\uff67\uff68\uff69\uff6a\uff6b\uff6c\uff6d\uff6e\uff6f\uff70\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff9d\uff9e\uff9f\u03b1\u00e4\u03b2\u03b5\u03bc\u03b4\u03c1g  j\u033d\u00a2\u00a3\u00f1\u00f6pq\u03b8 \u03a9\u00fc\u03a3\u03c0 y   \u00f7 \u2588                \u25b6\u25c0     \u21b5    \u2264\u2265   !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[ ]^_`abcdefghijklmnopqrstuvwxyz{|}~\u2302\u0411\u0414\u0416\u0417\u0418\u0419\u041b\u041f\u0423\u0426\u0427\u0428\u0429\u042a\u042b\u042d\u03b1 \u0393\u03c0\u03a3\u03c3\u266c\u03c4\u237e\u0398\u03a9\u03b4 \u2665\u03b5  \u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u0192\u00a9\u00aa\u00ab\u042e\u042f\u00ae \u00b0\u00b1\u00b2\u00b3\u20a7\u00b5\u00b6\u00b7\u03c9\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff".toCharArray();
        public static final char[] FULL_BASE = "\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2192\u2190\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u221a\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u221e\u3000\u3000\u3000\u3000\u3000\u3000\u5343\u4e07\u5186\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u201c\u201d\u3000\u3000\u25cf\u3000\u2191\u2193\u2192\u2190\u3000\u3000\u25b2\u25bc\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\uff3c\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u266a\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u221e\u3000\u3000\u2229\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2018\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000".toCharArray();
        public static final byte[] SMK6X8_FONT = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0010\u0010\u0010\u0010\u0000\u0000\u0010\u0000(((\u0000\u0000\u0000\u0000\u0000((|(|((\u0000\u0010<P8\u0014x\u0010\u0000`d\b\u0010 L\f\u00000HP TH4\u00000\u0010 \u0000\u0000\u0000\u0000\u0000\b\u0010   \u0010\b\u0000 \u0010\b\b\b\u0010 \u0000\u0000\u0010T8T\u0010\u0000\u0000\u0000\u0010\u0010|\u0010\u0010\u0000\u0000\u0000\u0000\u0000\u00000\u0010 \u0000\u0000\u0000\u0000|\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000000\u0000\u0000\u0004\b\u0010 @\u0000\u00008DLTdD8\u0000\u00100\u0010\u0010\u0010\u00108\u00008D\u0004\b\u0010 |\u0000|\b\u0010\b\u0004D8\u0000\b\u0018(H|\b\b\u0000|@x\u0004\u0004D8\u0000\u0018 @xDD8\u0000|\u0004\b\u0010   \u00008DD8DD8\u00008DD<\u0004\b0\u0000\u000000\u000000\u0000\u0000\u000000\u00000\u0010 \u0000\b\u0010 @ \u0010\b\u0000\u0000\u0000|\u0000|\u0000\u0000\u0000 \u0010\b\u0004\b\u0010 \u00008D\u0004\b\u0010\u0000\u0010\u00008D\u00044TT8\u00008DDD|DD\u0000xDDxDDx\u00008D@@@D8\u0000pHDDDHp\u0000|@@x@@|\u0000|@@x@@@\u00008D@\\DD<\u0000DDD|DDD\u00008\u0010\u0010\u0010\u0010\u00108\u0000\u001c\b\b\b\bH0\u0000DHP`PHD\u0000@@@@@@|\u0000DlTTDDD\u0000DDdTLDD\u00008DDDDD8\u0000xDDx@@@\u00008DDDTH4\u0000xDDxPHD\u0000<@@8\u0004\u0004x\u0000|\u0010\u0010\u0010\u0010\u0010\u0010\u0000DDDDDD8\u0000DDDDD(\u0010\u0000DDDTTT(\u0000DD(\u0010(DD\u0000DDD(\u0010\u0010\u0010\u0000|\u0004\b\u0010 @|\u00008     8\u0000D(|\u0010|\u0010\u0010\u00008\b\b\b\b\b8\u0000\u0010(D\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000|\u0000 \u0010\b\u0000\u0000\u0000\u0000\u0000\u0000\u00008\u0004<D<\u0000@@XdDDx\u0000\u0000\u00008@@D8\u0000\u0004\u00044LDD<\u0000\u0000\u00008D|@8\u0000\u0018$ p   \u0000\u0000<DD<\u00048\u0000@@XdDDD\u0000\u0010\u00000\u0010\u0010\u00108\u0000\b\u0000\u0018\b\bH0\u0000@@HP`PH\u00000\u0010\u0010\u0010\u0010\u00108\u0000\u0000\u0000hTTDD\u0000\u0000\u0000XdDDD\u0000\u0000\u00008DDD8\u0000\u0000\u0000xDx@@\u0000\u0000\u00004L<\u0004\u0004\u0000\u0000\u0000Xd@@@\u0000\u0000\u00008@8\u0004x\u0000  p  $\u0018\u0000\u0000\u0000DDDL4\u0000\u0000\u0000DDD(\u0010\u0000\u0000\u0000DDTT(\u0000\u0000\u0000D(\u0010(D\u0000\u0000\u0000DD<\u00048\u0000\u0000\u0000|\b\u0010 |\u0000\b\u0010\u0010 \u0010\u0010\b\u0000\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0000 \u0010\u0010\b\u0010\u0010 \u0000\u0000\u0010\b|\b\u0010\u0000\u0000\u0000\u0010 | \u0010\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000pPp\u0000\u001c\u0010\u0010\u0010\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0010\u0010\u0010p\u0000\u0000\u0000\u0000\u0000@ \u0010\u0000\u0000\u0000\u000000\u0000\u0000\u0000\u0000|\u0004|\u0004\b\u0010\u0000\u0000\u0000|\u0004\u0018\u0010 \u0000\u0000\u0000\b\u00100P\u0010\u0000\u0000\u0000\u0010|D\u0004\u0018\u0000\u0000\u0000\u0000|\u0010\u0010|\u0000\u0000\u0000\b|\u0018(H\u0000\u0000\u0000 |$( \u0000\u0000\u0000\u00008\b\b|\u0000\u0000\u0000x\bx\bx\u0000\u0000\u0000\u0000TT\u0004\u0018\u0000\u0000\u0000\u0000|\u0000\u0000\u0000\u0000|\u0004\u0014\u0018\u0010\u0010 \u0000\u0004\b\u00100P\u0010\u0010\u0000\u0010|DD\u0004\b\u0010\u0000\u0000|\u0010\u0010\u0010\u0010|\u0000\b|\b\u0018(H\b\u0000 |$$$$H\u0000\u0010|\u0010|\u0010\u0010\u0010\u0000\u0000<$D\u0004\b0\u0000 <H\b\b\b\u0010\u0000\u0000|\u0004\u0004\u0004\u0004|\u0000(|((\b\u0010 \u0000\u0000`\u0004d\u0004\bp\u0000\u0000|\u0004\b\u0010(D\u0000 |$(  \u001c\u0000\u0000DD$\u0004\b0\u0000\u0000<$T\f\b0\u0000\bp\u0010|\u0010\u0010 \u0000\u0000TTT\u0004\b\u0010\u00008\u0000|\u0010\u0010\u0010 \u0000   0(  \u0000\u0010\u0010|\u0010\u0010 @\u0000\u00008\u0000\u0000\u0000\u0000|\u0000\u0000|\u0004(\u0010(@\u0000\u0010|\b\u00108T\u0010\u0000\b\b\b\b\b\u0010 \u0000\u0000\u0010\bDDDD\u0000@@|@@@<\u0000\u0000|\u0004\u0004\u0004\b0\u0000\u0000 P\b\u0004\u0004\u0000\u0000\u0010|\u0010\u0010TT\u0010\u0000\u0000|\u0004\u0004(\u0010\b\u0000\u00008\u00008\u00008\u0004\u0000\u0000\u0010 @D|\u0004\u0000\u0000\u0004\u0004(\u0010(@\u0000\u0000| |  \u001c\u0000  |$(  \u0000\u00008\b\b\b\b|\u0000\u0000|\u0004|\u0004\u0004|\u00008\u0000|\u0004\u0004\b\u0010\u0000HHHH\b\u0010 \u0000\u0000\u0010PPTTX\u0000\u0000@@DHP`\u0000\u0000|DDDD|\u0000\u0000|DD\u0004\b\u0010\u0000\u0000`\u0000\u0004\u0004\bp\u0000\u0010H \u0000\u0000\u0000\u0000\u0000pPp\u0000\u0000\u0000\u0000\u0000\u0000\u0000$THH4\u0000(\u00008\u0004<D<\u0000\u0000\u00008DxDx@\u0000\u00008@0D8\u0000\u0000\u0000DDDLt@\u0000\u0000<PHD8\u0000\u0000\u0000\u0018$DDx@\u0000\u0000<DDD<\u0004\u0000\u0000\u001c\u0010\u0010P \u0000\u0000\bh\b\u0000\u0000\u0000\u0000\b\u0000\u0018\b\b\b\b\b\u0000P P\u0000\u0000\u0000\u0000\u0000\u00108PT8\u0010\u0000  p p <\u00008\u0000XdDDD\u0000(\u00008DDD8\u0000\u0000\u0000XdDDx@\u00000LDD<\u0004\u0004\u00008D|DD8\u0000\u0000\u0000\u0000,Th\u0000\u0000\u0000\u00008DD(l\u0000(\u0000DDDDL4|@ \u0010 @|\u0000\u0000\u0000|(((L\u0000|\u0000D(\u0010(D\u0000\u0000\u0000DDDD<\u0004\u0000\u0004x\u0010|\u0010\u0010\u0000\u0000\u0000| <$D\u0000\u0000\u0000|T|DD\u0000\u0000\u0010\u0000|\u0000\u0010\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000||||||||\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000 08<80 \u0000\b\u00188x8\u0018\b\u0000$Hl\u0000\u0000\u0000\u0000\u0000l$H\u0000\u0000\u0000\u0000\u0000\u00108|\u0000\u00108|\u0000|8\u0010\u0000|8\u0010\u0000\u00008|||8\u0000\u0000\u0004\u0004\u0014$| \u0010\u0000\u00108T\u0010\u0010\u0010\u0010\u0000\u0010\u0010\u0010\u0010T8\u0010\u0000\u0000\u0010\b|\b\u0010\u0000\u0000\u0000\u0010 | \u0010\u0000\u0000\b\u0010 \u0010\b\u0000|\u0000 \u0010\b\u0010 \u0000|\u0000\u0000\u0010\u001088|\u0000\u0000\u0000|88\u0010\u0010\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0010\u0010\u0010\u0010\u0000\u0000\u0010\u0000(((\u0000\u0000\u0000\u0000\u0000((|(|((\u0000\u0010<P8\u0014x\u0010\u0000`d\b\u0010 L\f\u00000HP TH4\u00000\u0010 \u0000\u0000\u0000\u0000\u0000\b\u0010   \u0010\b\u0000 \u0010\b\b\b\u0010 \u0000\u0000\u0010T8T\u0010\u0000\u0000\u0000\u0010\u0010|\u0010\u0010\u0000\u0000\u0000\u0000\u0000\u00000\u0010 \u0000\u0000\u0000\u0000|\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000000\u0000\u0000\u0004\b\u0010 @\u0000\u00008DLTdD8\u0000\u00100\u0010\u0010\u0010\u00108\u00008D\u0004\b\u0010 |\u0000|\b\u0010\b\u0004D8\u0000\b\u0018(H|\b\b\u0000|@x\u0004\u0004D8\u0000\u0018 @xDD8\u0000|D\u0004\b\u0010\u0010\u0010\u00008DD8DD8\u00008DD<\u0004\b0\u0000\u000000\u000000\u0000\u0000\u000000\u00000\u0010 \u0000\b\u0010 @ \u0010\b\u0000\u0000\u0000|\u0000|\u0000\u0000\u0000 \u0010\b\u0004\b\u0010 \u00008D\u0004\b\u0010\u0000\u0010\u00008D\u00044TT8\u0000\u0010(DD|DD\u0000xDDxDDx\u00008D@@@D8\u0000pHDDDHp\u0000|@@x@@|\u0000|@@x@@@\u00008D@\\DD<\u0000DDD|DDD\u00008\u0010\u0010\u0010\u0010\u00108\u0000\u001c\b\b\b\bH0\u0000DHP`PHD\u0000@@@@@@|\u0000DlTTDDD\u0000DDdTLDD\u00008DDDDD8\u0000xDDx@@@\u00008DDDTH4\u0000xDDxPHD\u00008D@8\u0004D8\u0000|\u0010\u0010\u0010\u0010\u0010\u0010\u0000DDDDDD8\u0000DDDDD(\u0010\u0000DDDTTT(\u0000DD(\u0010(DD\u0000DDD(\u0010\u0010\u0010\u0000|\u0004\b\u0010 @|\u00008     8\u0000\u0000@ \u0010\b\u0004\u0000\u00008\b\b\b\b\b8\u0000\u0010(D\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000|\u0000 \u0010\b\u0000\u0000\u0000\u0000\u0000\u0000\u00008\u0004<D<\u0000@@XdDDx\u0000\u0000\u00008@@D8\u0000\u0004\u00044LDD<\u0000\u0000\u00008D|@8\u0000\u0018$ p   \u0000\u0000\u0000<D<\u00048\u0000@@XdDDD\u0000\u0010\u0000\u00100\u0010\u00108\u0000\b\u0000\u0018\b\bH0\u0000@@HP`PH\u00000\u0010\u0010\u0010\u0010\u00108\u0000\u0000\u0000hTTTT\u0000\u0000\u0000XdDDD\u0000\u0000\u00008DDD8\u0000\u0000\u0000xDx@@\u0000\u0000\u00004L<\u0004\u0004\u0000\u0000\u0000Xd@@@\u0000\u0000\u00008@8\u0004x\u0000  p  $\u0018\u0000\u0000\u0000DDDL4\u0000\u0000\u0000DDD(\u0010\u0000\u0000\u0000DDTT(\u0000\u0000\u0000D(\u0010(D\u0000\u0000\u0000DD<\u00048\u0000\u0000\u0000|\b\u0010 |\u0000\b\u0010\u0010 \u0010\u0010\b\u0000\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0000 \u0010\u0010\b\u0010\u0010 \u0000\u0000\u0000\u00004H\u0000\u0000\u0000\u0010(DDD|\u0000\u0000|D@xDDx<\u0014\u0014$D|DD\u0000TTT8TTT\u0000x\u0004\u0004\u0018\u0004\u0004x\u0000DDLTdDD(\u0010DDLTdD\u0000<\u0014\u0014\u0014\u0014T$\u0000|DDDDDD\u0000DDD(\u0010 @\u0000DDDDD|\u0004\u0000DDD<\u0004\u0004\u0004\u0000\u0000TTTTT|\u0000TTTTT|\u0004\u0000`  8$$8\u0000DDDdTTd\u00008D\u0014,\u0004D8\u0000\u0000\u0000$THH4\u0000\u0010\u0018\u0014\u0014\u0010pp\u0000|D@@@@@\u0000\u0000\u0000|(((L\u0000|@ \u0010 @|\u0000\u0000\u0000<HHH0\u0018\u0014\u001c\u0014\u0014tl\f\u0000\u0000\u00048P\u0010\u0010\b\u0000\u0010888|\u0010\u0000\u00008DD|DD8\u0000\u00008DDD(l\u0000\u0018$\u0010(DD8\u0000\u0000\u0000,Th\u0000\u0000\u0000\u0000(|||8\u0010\u0000\u0000\u00008@0D8\u00008DDDDDD\u0000lllllll\u0000\u0010\u0000\u0000\u0010\u0010\u0010\u0010\u0000\u00108PPT8\u0010\u0000\u0018  p $X\u0000\u0000D8(8D\u0000\u0000D(|\u0010|\u0010\u0010\u0000\u0010\u0010\u0010\u0000\u0010\u0010\u0010\u0000\u0018$\u0010(\u0010H0\u0000\b\u0014\u0010|\u0010P \u0000|DT\\TD|\u00008\u0004<D<\u0000|\u0000\u0000\u0014(P(\u0014\u0000\u0000HTTtTTH\u0000<DD<\u0014$D\u0000|DTDLT|\u0000\u0010 0\u0000\u0000\u0000\u00000HHH0\u0000\u0000\u0000\u0000\u0010\u0010|\u0010\u0010\u0000|0H\u0010 x\u0000\u0000\u0000p\b0\bp\u0000\u0000\u0000pHp@H\\H\f\u0000DDDLt@@\u0000<LL<\f\f\f\u0000\u0000\u0000\u000000\u0000\u0000\u0000\u0000\u0000(DTT( `  p\u0000\u0000\u0000\u00008DDD8\u0000|\u0000\u0000P(\u0014(P\u0000DHP(X(<\bDHP(T\u0004\b\u001c` `$l\u0014\u001c\u0004\u0000\u0010\u0000\u0010 @D8 \u0010\u0010(D|DD\b\u0010\u0010(D|DD\u0010(\u00008D|DD4H\u00008D|DD(\u0000\u0010(D|DD\u0010(\u00108D|DD\u0000\u001c0P\\pP\\8D@@D8\b\u0018 \u0010\u0000|@x@|\b\u0010\u0000|@x@|\u0010(\u0000|@x@|\u0000(\u0000|@x@| \u0010\u00008\u0010\u0010\u00108\b\u0010\u00008\u0010\u0010\u00108\u0010(\u00008\u0010\u0010\u00108\u0000(\u00008\u0010\u0010\u00108\u00008$$t$$84H\u0000DdTLD \u00108DDDD8\b\u00108DDDD8\u0010(\u00008DDD84H\u00008DDD8(\u00008DDDD8\u0000\u0000D(\u0010(D\u0000\u00008\u00108T8\u00108 \u0010DDDDD8\b\u0010DDDDD8\u0010(\u0000DDDD8(\u0000DDDDD8\b\u0010D(\u0010\u0010\u0010\u0010` 8$$8 `\u0000\u0018$$8$$X \u0010\u00008\u0004<D<\b\u0010\u00008\u0004<D<\u0010(\u00008\u0004<D<4H\u00008\u0004<D<\u0000(\u00008\u0004<D<\u0010(\u00108\u0004<D<\u0000\u0000h\u0014<PT(\u0000\u00008@D8\u00100 \u0010\u00008D|@8\b\u0010\u00008D|@8\u0010(\u00008D|@8\u0000(\u00008D|@8 \u0010\u0000\u00100\u0010\u00108\b\u0010\u0000\u00100\u0010\u00108\u0010(\u0000\u00100\u0010\u00108\u0000(\u0000\u00100\u0010\u00108\u0000P P\b<D84H\u0000XdDDD \u0010\u00008DDD8\b\u0010\u00008DDD8\u0000\u0010(\u00008DD8\u00004H\u00008DD8\u0000(\u00008DDD8\u0000\u0000\u0010\u0000|\u0000\u0010\u0000\u0000\b\u00108T8\u0010  \u0010\u0000DDDL4\b\u0010\u0000DDDL4\u0010(\u0000DDDL4\u0000(\u0000DDDL4\u0000\b\u0010DD<\u00048\u00000\u0010\u0018\u0014\u0018\u00108\u0000(\u0000DD<\u00048".getBytes(XEiJ.ISO_8859_1);

        public Smk(int n, int n2, String string, String string2, String string3, String string4) {
            super(n, n2, string, string2, string3, string4, 16, 32, 32, null, 0, new char[][]{FULL_BASE, HALF_BASE});
            this.fnpLoadFontDataArray(SMK6X8_FONT, 0, SMK6X8_FONT.length);
        }
    }

    public static final class Lcd
    extends FontPage {
        public static final byte[] LCD4X6_FONT = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000@@@\u0000@\u0000\u00a0\u00a0\u0000\u0000\u0000\u0000\u00a0\u00e0\u00a0\u00e0\u00a0\u0000`\u00c0@`\u00c0\u0000\u00a0\u00c0@`\u00a0\u0000\u00c0\u00c0@\u00a0\u00c0\u0000@@\u0000\u0000\u0000\u0000 @@@ \u0000\u0080@@@\u0080\u0000\u0000\u00a0@\u00a0\u0000\u0000\u0000@\u00e0@\u0000\u0000\u0000\u0000\u0000@@\u0000\u0000\u0000\u00e0\u0000\u0000\u0000\u0000\u0000\u0000\u0000@\u0000\u0000 @\u0080\u0000\u0000\u00e0\u00a0\u00a0\u00a0\u00e0\u0000@@@@@\u0000\u00e0 \u00e0\u0080\u00e0\u0000\u00e0 \u00e0 \u00e0\u0000\u00a0\u00a0\u00e0  \u0000\u00e0\u0080\u00e0 \u00e0\u0000\u00e0\u0080\u00e0\u00a0\u00e0\u0000\u00e0    \u0000\u00e0\u00a0\u00e0\u00a0\u00e0\u0000\u00e0\u00a0\u00e0 \u00e0\u0000\u0000@\u0000@\u0000\u0000\u0000@\u0000@@\u0000 @\u0080@ \u0000\u0000\u00e0\u0000\u00e0\u0000\u0000\u0080@ @\u0080\u0000\u00c0 @\u0000@\u0000@\u00a0\u00e0\u0080`\u0000@\u00a0\u00e0\u00a0\u00a0\u0000\u00c0\u00a0\u00c0\u00a0\u00c0\u0000`\u0080\u0080\u0080`\u0000\u00c0\u00a0\u00a0\u00a0\u00c0\u0000\u00e0\u0080\u00e0\u0080\u00e0\u0000\u00e0\u0080\u00e0\u0080\u0080\u0000`\u0080\u00a0\u00a0`\u0000\u00a0\u00a0\u00e0\u00a0\u00a0\u0000\u00e0@@@\u00e0\u0000    \u00c0\u0000\u00a0\u00a0\u00c0\u00a0\u00a0\u0000\u0080\u0080\u0080\u0080\u00e0\u0000\u00a0\u00e0\u00e0\u00a0\u00a0\u0000\u00c0\u00a0\u00a0\u00a0\u00a0\u0000@\u00a0\u00a0\u00a0@\u0000\u00c0\u00a0\u00c0\u0080\u0080\u0000@\u00a0\u00a0\u00e0`\u0000\u00c0\u00a0\u00c0\u00a0\u00a0\u0000`\u0080@ \u00c0\u0000\u00e0@@@@\u0000\u00a0\u00a0\u00a0\u00a0\u00e0\u0000\u00a0\u00a0\u00a0\u00a0@\u0000\u00a0\u00a0\u00e0\u00e0\u00a0\u0000\u00a0\u00a0@\u00a0\u00a0\u0000\u00a0\u00a0@@@\u0000\u00e0 @\u0080\u00e0\u0000`@@@`\u0000\u0000\u0080@ \u0000\u0000\u00c0@@@\u00c0\u0000@\u00a0\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00e0\u0000@ \u0000\u0000\u0000\u0000\u0000`\u00a0\u00a0`\u0000\u0080\u00c0\u00a0\u00a0\u00c0\u0000\u0000`\u0080\u0080`\u0000 `\u00a0\u00a0`\u0000\u0000`\u00a0\u00c0`\u0000`\u00e0@@@\u0000`\u00a0\u00e0 \u00c0\u0000\u0080\u00c0\u00a0\u00a0\u00a0\u0000@\u0000@@@\u0000 \u0000  \u00c0\u0000\u0080\u00a0\u00c0\u00c0\u00a0\u0000\u00c0@@@@\u0000\u0000\u00c0\u00e0\u00e0\u00a0\u0000\u0000\u00c0\u00a0\u00a0\u00a0\u0000\u0000@\u00a0\u00a0@\u0000\u0000\u00c0\u00a0\u00c0\u0080\u0000\u0000`\u00a0` \u0000\u0000`\u0080\u0080\u0080\u0000\u0000`@ \u00c0\u0000@\u00e0@@ \u0000\u0000\u00a0\u00a0\u00a0`\u0000\u0000\u00a0\u00a0\u00a0@\u0000\u0000\u00a0\u00e0\u00e0`\u0000\u0000\u00a0@@\u00a0\u0000\u0000\u00a0\u00a0@\u0080\u0000\u0000\u00e0 @\u00e0\u0000 @\u00c0@ \u0000@@\u0000@@\u0000\u0080@`@\u0080\u0000\u00e0\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
        public static final byte[] LCD6X8_FONT = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000`\u0080h(\u00f8((\u0000`\u0080h(\u00d0((\u0000\u00e0\u0080\u00e0\u00a8\u00f0((\u0000\u00e0\u0080\u00f8\u0090\u00f0\u0010\u0010\u0000\u00e0\u0080\u00d0\u00a8\u00e80\u0018\u0000@\u00a0\u00e8\u00a8\u00b0((\u0000\u00c0\u00a0\u00e0\u00a0\u00e0 8\u0000\u00c0\u00a0\u00d8\u00a0\u00d0\b0\u0000\u00a0\u00a0\u00f8\u00b0\u00b0\u0010\u0010\u0000\u0080\u0080\u00b8\u00a0\u00f8  \u0000\u00a0\u00a0\u00b8\u00b0P\u0010\u0010\u0000\u00e0\u0080\u00f8\u00a0\u00b8  \u0000`\u0080\u00b0\u00a8p((\u0000`\u0080P(\u00e8(\u0010\u0000`\u0080H(\u00c8\b\b\u0000\u00c0\u00a0\u00b8\u00a0\u00f0 8\u0000\u00c0\u00a0\u00a8\u00a8\u00c8\b\b\u0000\u00c0\u00a0\u00b8\u00a8\u00d0 8\u0000\u00c0\u00a0\u00b8\u00a8\u00d8\b8\u0000\u00c0\u00a0\u00a8\u00a8\u00d8\b\b\u0000\u00c0\u00a0\u00a0\u00a8\u00b0((\u0000`\u0080p(\u00e8((\u0000\u00e0\u0080\u00f0\u00a8\u00f0(0\u0000`\u0080\u00b0\u00a8h((\u0000\u00e0\u0080\u00e8\u00b8\u00f8((\u0000`\u0080p(\u00f0(0\u0000\u00e0\u0080\u00d8\u00a0\u00e0 \u0018\u0000\u0000 \u0010\u00f8\u0010 \u0000\u0000\u0000 @\u00f8@ \u0000\u0000 p\u00a8    \u0000    \u00a8p \u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000    \u0000\u0000 \u0000PPP\u0000\u0000\u0000\u0000\u0000PP\u00f8P\u00f8PP\u0000 x\u00a0p(\u00f0 \u0000\u00c0\u00c8\u0010 @\u0098\u0018\u0000`\u0090\u00a0@\u00a8\u0090h\u0000` @\u0000\u0000\u0000\u0000\u0000\u0010 @@@ \u0010\u0000@ \u0010\u0010\u0010 @\u0000\u0000 \u00a8p\u00a8 \u0000\u0000\u0000  \u00f8  \u0000\u0000\u0000\u0000\u0000\u0000` @\u0000\u0000\u0000\u0000\u00f8\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000``\u0000\u0000\b\u0010 @\u0080\u0000\u0000p\u0088\u0098\u00a8\u00c8\u0088p\u0000 `    p\u0000p\u0088\b\u0010 @\u00f8\u0000\u00f8\u0010 \u0010\b\u0088p\u0000\u00100P\u0090\u00f8\u0010\u0010\u0000\u00f8\u0080\u00f0\b\b\u0088p\u00000@\u0080\u00f0\u0088\u0088p\u0000\u00f8\b\u0010 @@@\u0000p\u0088\u0088p\u0088\u0088p\u0000p\u0088\u0088x\b\u0010`\u0000\u0000``\u0000``\u0000\u0000\u0000``\u0000` @\u0000\u0010 @\u0080@ \u0010\u0000\u0000\u0000\u00f8\u0000\u00f8\u0000\u0000\u0000@ \u0010\b\u0010 @\u0000p\u0088\b\u0010 \u0000 \u0000p\u0088\bh\u00a8\u00a8p\u0000p\u0088\u0088\u0088\u00f8\u0088\u0088\u0000\u00f0\u0088\u0088\u00f0\u0088\u0088\u00f0\u0000p\u0088\u0080\u0080\u0080\u0088p\u0000\u00e0\u0090\u0088\u0088\u0088\u0090\u00e0\u0000\u00f8\u0080\u0080\u00f0\u0080\u0080\u00f8\u0000\u00f8\u0080\u0080\u00f0\u0080\u0080\u0080\u0000p\u0088\u0080\u00b8\u0088\u0088x\u0000\u0088\u0088\u0088\u00f8\u0088\u0088\u0088\u0000p     p\u00008\u0010\u0010\u0010\u0010\u0090`\u0000\u0088\u0090\u00a0\u00c0\u00a0\u0090\u0088\u0000\u0080\u0080\u0080\u0080\u0080\u0080\u00f8\u0000\u0088\u00d8\u00a8\u00a8\u0088\u0088\u0088\u0000\u0088\u0088\u00c8\u00a8\u0098\u0088\u0088\u0000p\u0088\u0088\u0088\u0088\u0088p\u0000\u00f0\u0088\u0088\u00f0\u0080\u0080\u0080\u0000p\u0088\u0088\u0088\u00a8\u0090h\u0000\u00f0\u0088\u0088\u00f0\u00a0\u0090\u0088\u0000x\u0080\u0080p\b\b\u00f0\u0000\u00f8      \u0000\u0088\u0088\u0088\u0088\u0088\u0088p\u0000\u0088\u0088\u0088\u0088\u0088P \u0000\u0088\u0088\u0088\u00a8\u00a8\u00a8P\u0000\u0088\u0088P P\u0088\u0088\u0000\u0088\u0088\u0088P   \u0000\u00f8\b\u0010 @\u0080\u00f8\u0000p@@@@@p\u0000\u0088P\u00f8 \u00f8  \u0000p\u0010\u0010\u0010\u0010\u0010p\u0000 P\u0088\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00f8\u0000@ \u0010\u0000\u0000\u0000\u0000\u0000\u0000\u0000p\bx\u0088x\u0000\u0080\u0080\u00b0\u00c8\u0088\u0088\u00f0\u0000\u0000\u0000p\u0080\u0080\u0088p\u0000\b\bh\u0098\u0088\u0088x\u0000\u0000\u0000p\u0088\u00f8\u0080p\u00000H@\u00e0@@@\u0000\u0000x\u0088\u0088x\bp\u0000\u0080\u0080\u00b0\u00c8\u0088\u0088\u0088\u0000 \u0000`   p\u0000\u0010\u00000\u0010\u0010\u0090`\u0000\u0080\u0080\u0090\u00a0\u00c0\u00a0\u0090\u0000`     p\u0000\u0000\u0000\u00d0\u00a8\u00a8\u0088\u0088\u0000\u0000\u0000\u00b0\u00c8\u0088\u0088\u0088\u0000\u0000\u0000p\u0088\u0088\u0088p\u0000\u0000\u0000\u00f0\u0088\u00f0\u0080\u0080\u0000\u0000\u0000h\u0098x\b\b\u0000\u0000\u0000\u00b0\u00c8\u0080\u0080\u0080\u0000\u0000\u0000p\u0080p\b\u00f0\u0000@@\u00e0@@H0\u0000\u0000\u0000\u0088\u0088\u0088\u0098h\u0000\u0000\u0000\u0088\u0088\u0088P \u0000\u0000\u0000\u0088\u0088\u00a8\u00a8P\u0000\u0000\u0000\u0088P P\u0088\u0000\u0000\u0000\u0088\u0088x\bp\u0000\u0000\u0000\u00f8\u0010 @\u00f8\u0000\u0010  @  \u0010\u0000       \u0000@  \u0010  @\u0000\u00f8\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0080@ \u0010\b\u0000\u0000h\u0090\u0000\u0000\u0000\u0000\u0000\u0000   \u0000   \u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00e0\u00a0\u00e0\u00008   \u0000\u0000\u0000\u0000\u0000\u0000\u0000   \u00e0\u0000\u0000\u0000\u0000\u0000\u0080@ \u0000\u0000\u0000\u0000``\u0000\u0000\u0000\u0000\u00f8\b\u00f8\b\u0010 \u0000\u0000\u0000\u00f8\b0 @\u0000\u0000\u0000\u0010 `\u00a0 \u0000\u0000\u0000 \u00f8\u0088\b0\u0000\u0000\u0000\u0000\u00f8  \u00f8\u0000\u0000\u0000\u0010\u00f80P\u0090\u0000\u0000\u0000@\u00f8HP@\u0000\u0000\u0000\u0000p\u0010\u0010\u00f8\u0000\u0000\u0000\u00f0\u0010\u00f0\u0010\u00f0\u0000\u0000\u0000\u0000\u00a8\u00a8\b0\u0000\u0000\u0000\u0000\u00f8\u0000\u0000\u0000\u0000\u00f8\b(0  @\u0000\b\u0010 `\u00a0  \u0000 \u00f8\u0088\u0088\b\u0010 \u0000\u0000\u00f8    \u00f8\u0000\u0010\u00f8\u00100P\u0090\u0010\u0000@\u00f8HHHH\u0090\u0000 \u00f8 \u00f8   \u0000\u0000xH\u0088\b\u0010`\u0000@x\u0090\u0010\u0010\u0010 \u0000\u0000\u00f8\b\b\b\b\u00f8\u0000P\u00f8PP\u0010 @\u0000\u0000\u00c0\b\u00c8\b\u0010\u00e0\u0000\u0000\u00f8\b\u0010 P\u0088\u0000@\u00f8HP@@8\u0000\u0000\u0088\u0088H\b\u0010`\u0000\u0000xH\u00a8\u0018\u0010`\u0000\u0010\u00e0 \u00f8  @\u0000\u0000\u00a8\u00a8\u00a8\b\u0010 \u0000p\u0000\u00f8   @\u0000@@@`P@@\u0000  \u00f8  @\u0080\u0000\u0000p\u0000\u0000\u0000\u0000\u00f8\u0000\u0000\u00f8\bP P\u0080\u0000 \u00f8\u0010 p\u00a8 \u0000\u0010\u0010\u0010\u0010\u0010 @\u0000\u0000 \u0010\u0088\u0088\u0088\u0088\u0000\u0080\u0080\u00f8\u0080\u0080\u0080x\u0000\u0000\u00f8\b\b\b\u0010`\u0000\u0000@\u00a0\u0010\b\b\u0000\u0000 \u00f8  \u00a8\u00a8 \u0000\u0000\u00f8\b\bP \u0010\u0000\u0000p\u0000p\u0000p\b\u0000\u0000 @\u0080\u0088\u00f8\b\u0000\u0000\b\bP P\u0080\u0000\u0000\u00f8@\u00f8@@8\u0000@@\u00f8HP@@\u0000\u0000p\u0010\u0010\u0010\u0010\u00f8\u0000\u0000\u00f8\b\u00f8\b\b\u00f8\u0000p\u0000\u00f8\b\b\u0010 \u0000\u0090\u0090\u0090\u0090\u0010 @\u0000\u0000 \u00a0\u00a0\u00a8\u00a8\u00b0\u0000\u0000\u0080\u0080\u0088\u0090\u00a0\u00c0\u0000\u0000\u00f8\u0088\u0088\u0088\u0088\u00f8\u0000\u0000\u00f8\u0088\u0088\b\u0010 \u0000\u0000\u00c0\u0000\b\b\u0010\u00e0\u0000 \u0090@\u0000\u0000\u0000\u0000\u0000\u00e0\u00a0\u00e0\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);

        public Lcd(int n, int n2, String string, String string2, String string3, String string4) {
            super(n, n2, string, string2, string3, string4, 16, 16, 16, null, 0, new char[0][]);
            if (n2 == 6) {
                this.fnpLoadFontDataArray(LCD4X6_FONT, 0, LCD4X6_FONT.length);
            } else if (n2 == 8) {
                this.fnpLoadFontDataArray(LCD6X8_FONT, 0, LCD6X8_FONT.length);
            }
        }
    }

    public static final class Prn
    extends FontPage {
        public static final char[] HALF_BASE = "                                 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\u00a5]^_`abcdefghijklmnopqrstuvwxyz{|}\u00af \u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588\u258f\u258e\u258d\u258c\u258b\u258a\u2589\u2571           \u256e\u2570\u256f\u256d\u2572 \uff61\uff62\uff63\uff64\uff65\uff66\uff67\uff68\uff69\uff6a\uff6b\uff6c\uff6d\uff6e\uff6f\uff70\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff9d\uff9e\uff9f  \u2660\u2665\u2666\u2663\u25e2\u25e3\u2573       \u2593                                                !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\u00a5]^_`abcdefghijklmnopqrstuvwxyz{|}\u00af \u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588\u258f\u258e\u258d\u258c\u258b\u258a\u2589\u2571           \u256e\u2570\u256f\u256d\u2572                                                                  \u2660\u2665\u2666\u2663\u25e2\u25e3\u2573       \u2593               ".toCharArray();
        public static final char[] FULL_BASE = "\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff3b\uffe5\uff3d\uff3e\uff3f\uff40\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\uff5b\uff5c\uff5d\uffe3\u03c0\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2500\u2502\u2534\u252c\u2524\u251c\u253c\u2510\u2518\u2514\u250c\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u25cf\u25cb\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2598\u2596\u259d\u2597\u259e\u259a\u25a1\u3000\u571f\u91d1\u6728\u6c34\u706b\u6708\u65e5\u6642\u5206\u79d2\u5e74\u5186\u4eba\u751f\u3012\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff3b\uffe5\uff3d\uff3e\uff3f\uff40\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\uff5b\uff5c\uff5d\uffe3\u03c0\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2500\u2502\u2534\u252c\u2524\u251c\u253c\u2510\u2518\u2514\u250c\u3000\u3000\u3000\u3000\u3000\u3000\u3002\u300c\u300d\u3001\u30fb\u3092\u3041\u3043\u3045\u3047\u3049\u3083\u3085\u3087\u3063\u30fc\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3093\u309b\u309c\u25cf\u25cb\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2598\u2596\u259d\u2597\u259e\u259a\u25a1\u3000\u571f\u91d1\u6728\u6c34\u706b\u6708\u65e5\u6642\u5206\u79d2\u5e74\u5186\u4eba\u751f\u3012".toCharArray();

        public Prn(int n, int n2, String string, String string2, String string3, String string4) {
            super(n, n2, string, string2, string3, string4, 16, 32, 32, null, 0, new char[][]{FULL_BASE, HALF_BASE});
        }
    }

    public static final class Zen
    extends FontPage {
        public static final char[] FULL_BASE = "\u3000\u0000\u3001\u0000\u3002\u0000\uff0c\u0000\uff0e\u0000\u30fb\u0000\uff1a\u0000\uff1b\u0000\uff1f\u0000\uff01\u0000\u309b\u0000\u309c\u0000\u00b4\u0000\uff40\u0000\u00a8\u0000\uff3e\u0000\uffe3\u0000\uff3f\u0000\u30fd\u0000\u30fe\u0000\u309d\u0000\u309e\u0000\u3003\u0000\u4edd\u0000\u3005\u0000\u3006\u0000\u3007\u0000\u30fc\u0000\u2015\u0000\uff0d\u0000\uff0f\u0000\uff3c\u0000\uff5e\u0000\u2016\u0000\uff5c\u0000\u2026\u0000\u2025\u0000\u2018\u0000\u2019\u0000\u201c\u0000\u201d\u0000\uff08\u0000\uff09\u0000\u3014\u0000\u3015\u0000\uff3b\u0000\uff3d\u0000\uff5b\u0000\uff5d\u0000\u3008\u0000\u3009\u0000\u300a\u0000\u300b\u0000\u300c\u0000\u300d\u0000\u300e\u0000\u300f\u0000\u3010\u0000\u3011\u0000\uff0b\u0000\uff0d\u0000\u00b1\u0000\u00d7\u0000\u00f7\u0000\uff1d\u0000\u2260\u0000\uff1c\u0000\uff1e\u0000\u2266\u0000\u2267\u0000\u221e\u0000\u2234\u0000\u2642\u0000\u2640\u0000\u00b0\u0000\u2032\u0000\u2033\u0000\u2103\u0000\uffe5\u0000\uff04\u0000\uffe0\u0000\uffe1\u0000\uff05\u0000\uff03\u0000\uff06\u0000\uff0a\u0000\uff20\u0000\u00a7\u0000\u2606\u0000\u2605\u0000\u25cb\u0000\u25cf\u0000\u25ce\u0000\u25c7\u0000\u25c6\u0000\u25a1\u0000\u25a0\u0000\u25b3\u0000\u25b2\u0000\u25bd\u0000\u25bc\u0000\u203b\u0000\u3012\u0000\u2192\u0000\u2190\u0000\u2191\u0000\u2193\u0000\u3013\u0000\uff07\u0000\uff02\u0000\uff0d\u0000\uff5e\u0000\u3033\u0000\u3034\u0000\u3035\u0000\u303b\u0000\u303c\u0000\u30ff\u0000\u309f\u0000\u2208\u0000\u220b\u0000\u2286\u0000\u2287\u0000\u2282\u0000\u2283\u0000\u222a\u0000\u2229\u0000\u2284\u0000\u2285\u0000\u228a\u0000\u228b\u0000\u2209\u0000\u2205\u0000\u2305\u0000\u2306\u0000\u2227\u0000\u2228\u0000\uffe2\u0000\u21d2\u0000\u21d4\u0000\u2200\u0000\u2203\u0000\u2295\u0000\u2296\u0000\u2297\u0000\u2225\u0000\u2226\u0000\uff5f\u0000\uff60\u0000\u3018\u0000\u3019\u0000\u3016\u0000\u3017\u0000\u2220\u0000\u22a5\u0000\u2312\u0000\u2202\u0000\u2207\u0000\u2261\u0000\u2252\u0000\u226a\u0000\u226b\u0000\u221a\u0000\u223d\u0000\u221d\u0000\u2235\u0000\u222b\u0000\u222c\u0000\u2262\u0000\u2243\u0000\u2245\u0000\u2248\u0000\u2276\u0000\u2277\u0000\u2194\u0000\u212b\u0000\u2030\u0000\u266f\u0000\u266d\u0000\u266a\u0000\u2020\u0000\u2021\u0000\u00b6\u0000\u266e\u0000\u266b\u0000\u266c\u0000\u2669\u0000\u25ef\u0000\u25b7\u0000\u25b6\u0000\u25c1\u0000\u25c0\u0000\u2197\u0000\u2198\u0000\u2196\u0000\u2199\u0000\u21c4\u0000\u21e8\u0000\u21e6\u0000\u21e7\u0000\u21e9\u0000\u2934\u0000\u2935\u0000\uff10\u0000\uff11\u0000\uff12\u0000\uff13\u0000\uff14\u0000\uff15\u0000\uff16\u0000\uff17\u0000\uff18\u0000\uff19\u0000\u29bf\u0000\u25c9\u0000\u303d\u0000\ufe46\u0000\ufe45\u0000\u25e6\u0000\u2022\u0000\uff21\u0000\uff22\u0000\uff23\u0000\uff24\u0000\uff25\u0000\uff26\u0000\uff27\u0000\uff28\u0000\uff29\u0000\uff2a\u0000\uff2b\u0000\uff2c\u0000\uff2d\u0000\uff2e\u0000\uff2f\u0000\uff30\u0000\uff31\u0000\uff32\u0000\uff33\u0000\uff34\u0000\uff35\u0000\uff36\u0000\uff37\u0000\uff38\u0000\uff39\u0000\uff3a\u0000\u2213\u0000\u2135\u0000\u210f\u0000\u33cb\u0000\u2113\u0000\u2127\u0000\uff41\u0000\uff42\u0000\uff43\u0000\uff44\u0000\uff45\u0000\uff46\u0000\uff47\u0000\uff48\u0000\uff49\u0000\uff4a\u0000\uff4b\u0000\uff4c\u0000\uff4d\u0000\uff4e\u0000\uff4f\u0000\uff50\u0000\uff51\u0000\uff52\u0000\uff53\u0000\uff54\u0000\uff55\u0000\uff56\u0000\uff57\u0000\uff58\u0000\uff59\u0000\uff5a\u0000\u30a0\u0000\u2013\u0000\u29fa\u0000\u29fb\u0000\u3041\u0000\u3042\u0000\u3043\u0000\u3044\u0000\u3045\u0000\u3046\u0000\u3047\u0000\u3048\u0000\u3049\u0000\u304a\u0000\u304b\u0000\u304c\u0000\u304d\u0000\u304e\u0000\u304f\u0000\u3050\u0000\u3051\u0000\u3052\u0000\u3053\u0000\u3054\u0000\u3055\u0000\u3056\u0000\u3057\u0000\u3058\u0000\u3059\u0000\u305a\u0000\u305b\u0000\u305c\u0000\u305d\u0000\u305e\u0000\u305f\u0000\u3060\u0000\u3061\u0000\u3062\u0000\u3063\u0000\u3064\u0000\u3065\u0000\u3066\u0000\u3067\u0000\u3068\u0000\u3069\u0000\u306a\u0000\u306b\u0000\u306c\u0000\u306d\u0000\u306e\u0000\u306f\u0000\u3070\u0000\u3071\u0000\u3072\u0000\u3073\u0000\u3074\u0000\u3075\u0000\u3076\u0000\u3077\u0000\u3078\u0000\u3079\u0000\u307a\u0000\u307b\u0000\u307c\u0000\u307d\u0000\u307e\u0000\u307f\u0000\u3080\u0000\u3081\u0000\u3082\u0000\u3083\u0000\u3084\u0000\u3085\u0000\u3086\u0000\u3087\u0000\u3088\u0000\u3089\u0000\u308a\u0000\u308b\u0000\u308c\u0000\u308d\u0000\u308e\u0000\u308f\u0000\u3090\u0000\u3091\u0000\u3092\u0000\u3093\u0000\u3094\u0000\u3095\u0000\u3096\u0000\u304b\u309a\u304d\u309a\u304f\u309a\u3051\u309a\u3053\u309a\u3000\u0000\u3000\u0000\u3000\u0000\u30a1\u0000\u30a2\u0000\u30a3\u0000\u30a4\u0000\u30a5\u0000\u30a6\u0000\u30a7\u0000\u30a8\u0000\u30a9\u0000\u30aa\u0000\u30ab\u0000\u30ac\u0000\u30ad\u0000\u30ae\u0000\u30af\u0000\u30b0\u0000\u30b1\u0000\u30b2\u0000\u30b3\u0000\u30b4\u0000\u30b5\u0000\u30b6\u0000\u30b7\u0000\u30b8\u0000\u30b9\u0000\u30ba\u0000\u30bb\u0000\u30bc\u0000\u30bd\u0000\u30be\u0000\u30bf\u0000\u30c0\u0000\u30c1\u0000\u30c2\u0000\u30c3\u0000\u30c4\u0000\u30c5\u0000\u30c6\u0000\u30c7\u0000\u30c8\u0000\u30c9\u0000\u30ca\u0000\u30cb\u0000\u30cc\u0000\u30cd\u0000\u30ce\u0000\u30cf\u0000\u30d0\u0000\u30d1\u0000\u30d2\u0000\u30d3\u0000\u30d4\u0000\u30d5\u0000\u30d6\u0000\u30d7\u0000\u30d8\u0000\u30d9\u0000\u30da\u0000\u30db\u0000\u30dc\u0000\u30dd\u0000\u30de\u0000\u30df\u0000\u30e0\u0000\u30e1\u0000\u30e2\u0000\u30e3\u0000\u30e4\u0000\u30e5\u0000\u30e6\u0000\u30e7\u0000\u30e8\u0000\u30e9\u0000\u30ea\u0000\u30eb\u0000\u30ec\u0000\u30ed\u0000\u30ee\u0000\u30ef\u0000\u30f0\u0000\u30f1\u0000\u30f2\u0000\u30f3\u0000\u30f4\u0000\u30f5\u0000\u30f6\u0000\u30ab\u309a\u30ad\u309a\u30af\u309a\u30b1\u309a\u30b3\u309a\u30bb\u309a\u30c4\u309a\u30c8\u309a\u0391\u0000\u0392\u0000\u0393\u0000\u0394\u0000\u0395\u0000\u0396\u0000\u0397\u0000\u0398\u0000\u0399\u0000\u039a\u0000\u039b\u0000\u039c\u0000\u039d\u0000\u039e\u0000\u039f\u0000\u03a0\u0000\u03a1\u0000\u03a3\u0000\u03a4\u0000\u03a5\u0000\u03a6\u0000\u03a7\u0000\u03a8\u0000\u03a9\u0000\u2664\u0000\u2660\u0000\u2662\u0000\u2666\u0000\u2661\u0000\u2665\u0000\u2667\u0000\u2663\u0000\u03b1\u0000\u03b2\u0000\u03b3\u0000\u03b4\u0000\u03b5\u0000\u03b6\u0000\u03b7\u0000\u03b8\u0000\u03b9\u0000\u03ba\u0000\u03bb\u0000\u03bc\u0000\u03bd\u0000\u03be\u0000\u03bf\u0000\u03c0\u0000\u03c1\u0000\u03c3\u0000\u03c4\u0000\u03c5\u0000\u03c6\u0000\u03c7\u0000\u03c8\u0000\u03c9\u0000\u03c2\u0000\u24f5\u0000\u24f6\u0000\u24f7\u0000\u24f8\u0000\u24f9\u0000\u24fa\u0000\u24fb\u0000\u24fc\u0000\u24fd\u0000\u24fe\u0000\u2616\u0000\u2617\u0000\u3020\u0000\u260e\u0000\u2600\u0000\u2601\u0000\u2602\u0000\u2603\u0000\u2668\u0000\u25b1\u0000\u31f0\u0000\u31f1\u0000\u31f2\u0000\u31f3\u0000\u31f4\u0000\u31f5\u0000\u31f6\u0000\u31f7\u0000\u31f8\u0000\u31f9\u0000\u31f7\u309a\u31fa\u0000\u31fb\u0000\u31fc\u0000\u31fd\u0000\u31fe\u0000\u31ff\u0000\u0410\u0000\u0411\u0000\u0412\u0000\u0413\u0000\u0414\u0000\u0415\u0000\u0401\u0000\u0416\u0000\u0417\u0000\u0418\u0000\u0419\u0000\u041a\u0000\u041b\u0000\u041c\u0000\u041d\u0000\u041e\u0000\u041f\u0000\u0420\u0000\u0421\u0000\u0422\u0000\u0423\u0000\u0424\u0000\u0425\u0000\u0426\u0000\u0427\u0000\u0428\u0000\u0429\u0000\u042a\u0000\u042b\u0000\u042c\u0000\u042d\u0000\u042e\u0000\u042f\u0000\u23be\u0000\u23bf\u0000\u23c0\u0000\u23c1\u0000\u23c2\u0000\u23c3\u0000\u23c4\u0000\u23c5\u0000\u23c6\u0000\u23c7\u0000\u23c8\u0000\u23c9\u0000\u23ca\u0000\u23cb\u0000\u23cc\u0000\u0430\u0000\u0431\u0000\u0432\u0000\u0433\u0000\u0434\u0000\u0435\u0000\u0451\u0000\u0436\u0000\u0437\u0000\u0438\u0000\u0439\u0000\u043a\u0000\u043b\u0000\u043c\u0000\u043d\u0000\u043e\u0000\u043f\u0000\u0440\u0000\u0441\u0000\u0442\u0000\u0443\u0000\u0444\u0000\u0445\u0000\u0446\u0000\u0447\u0000\u0448\u0000\u0449\u0000\u044a\u0000\u044b\u0000\u044c\u0000\u044d\u0000\u044e\u0000\u044f\u0000\u30f7\u0000\u30f8\u0000\u30f9\u0000\u30fa\u0000\u22da\u0000\u22db\u0000\u2153\u0000\u2154\u0000\u2155\u0000\u2713\u0000\u2318\u0000\u2423\u0000\u23ce\u0000\u2500\u0000\u2502\u0000\u250c\u0000\u2510\u0000\u2518\u0000\u2514\u0000\u251c\u0000\u252c\u0000\u2524\u0000\u2534\u0000\u253c\u0000\u2501\u0000\u2503\u0000\u250f\u0000\u2513\u0000\u251b\u0000\u2517\u0000\u2523\u0000\u2533\u0000\u252b\u0000\u253b\u0000\u254b\u0000\u2520\u0000\u252f\u0000\u2528\u0000\u2537\u0000\u253f\u0000\u251d\u0000\u2530\u0000\u2525\u0000\u2538\u0000\u2542\u0000\u3251\u0000\u3252\u0000\u3253\u0000\u3254\u0000\u3255\u0000\u3256\u0000\u3257\u0000\u3258\u0000\u3259\u0000\u325a\u0000\u325b\u0000\u325c\u0000\u325d\u0000\u325e\u0000\u325f\u0000\u32b1\u0000\u32b2\u0000\u32b3\u0000\u32b4\u0000\u32b5\u0000\u32b6\u0000\u32b7\u0000\u32b8\u0000\u32b9\u0000\u32ba\u0000\u32bb\u0000\u32bc\u0000\u32bd\u0000\u32be\u0000\u32bf\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u25d0\u0000\u25d1\u0000\u25d2\u0000\u25d3\u0000\u203c\u0000\u2047\u0000\u2048\u0000\u2049\u0000\u01cd\u0000\u01ce\u0000\u01d0\u0000\u1e3e\u0000\u1e3f\u0000\u01f8\u0000\u01f9\u0000\u01d1\u0000\u01d2\u0000\u01d4\u0000\u01d6\u0000\u01d8\u0000\u01da\u0000\u01dc\u0000\u3000\u0000\u3000\u0000\u20ac\u0000\u00a0\u0000\u00a1\u0000\u00a4\u0000\u00a6\u0000\u00a9\u0000\u00aa\u0000\u00ab\u0000\u00ad\u0000\u00ae\u0000\u00af\u0000\u00b2\u0000\u00b3\u0000\u00b7\u0000\u00b8\u0000\u00b9\u0000\u00ba\u0000\u00bb\u0000\u00bc\u0000\u00bd\u0000\u00be\u0000\u00bf\u0000\u00c0\u0000\u00c1\u0000\u00c2\u0000\u00c3\u0000\u00c4\u0000\u00c5\u0000\u00c6\u0000\u00c7\u0000\u00c8\u0000\u00c9\u0000\u00ca\u0000\u00cb\u0000\u00cc\u0000\u00cd\u0000\u00ce\u0000\u00cf\u0000\u00d0\u0000\u00d1\u0000\u00d2\u0000\u00d3\u0000\u00d4\u0000\u00d5\u0000\u00d6\u0000\u00d8\u0000\u00d9\u0000\u00da\u0000\u00db\u0000\u00dc\u0000\u00dd\u0000\u00de\u0000\u00df\u0000\u00e0\u0000\u00e1\u0000\u00e2\u0000\u00e3\u0000\u00e4\u0000\u00e5\u0000\u00e6\u0000\u00e7\u0000\u00e8\u0000\u00e9\u0000\u00ea\u0000\u00eb\u0000\u00ec\u0000\u00ed\u0000\u00ee\u0000\u00ef\u0000\u00f0\u0000\u00f1\u0000\u00f2\u0000\u00f3\u0000\u00f4\u0000\u00f5\u0000\u00f6\u0000\u00f8\u0000\u00f9\u0000\u00fa\u0000\u00fb\u0000\u00fc\u0000\u00fd\u0000\u00fe\u0000\u00ff\u0000\u0100\u0000\u012a\u0000\u016a\u0000\u0112\u0000\u014c\u0000\u0101\u0000\u012b\u0000\u016b\u0000\u0113\u0000\u014d\u0000\u0104\u0000\u02d8\u0000\u0141\u0000\u013d\u0000\u015a\u0000\u0160\u0000\u015e\u0000\u0164\u0000\u0179\u0000\u017d\u0000\u017b\u0000\u0105\u0000\u02db\u0000\u0142\u0000\u013e\u0000\u015b\u0000\u02c7\u0000\u0161\u0000\u015f\u0000\u0165\u0000\u017a\u0000\u02dd\u0000\u017e\u0000\u017c\u0000\u0154\u0000\u0102\u0000\u0139\u0000\u0106\u0000\u010c\u0000\u0118\u0000\u011a\u0000\u010e\u0000\u0143\u0000\u0147\u0000\u0150\u0000\u0158\u0000\u016e\u0000\u0170\u0000\u0162\u0000\u0155\u0000\u0103\u0000\u013a\u0000\u0107\u0000\u010d\u0000\u0119\u0000\u011b\u0000\u010f\u0000\u0111\u0000\u0144\u0000\u0148\u0000\u0151\u0000\u0159\u0000\u016f\u0000\u0171\u0000\u0163\u0000\u02d9\u0000\u0108\u0000\u011c\u0000\u0124\u0000\u0134\u0000\u015c\u0000\u016c\u0000\u0109\u0000\u011d\u0000\u0125\u0000\u0135\u0000\u015d\u0000\u016d\u0000\u0271\u0000\u028b\u0000\u027e\u0000\u0283\u0000\u0292\u0000\u026c\u0000\u026e\u0000\u0279\u0000\u0288\u0000\u0256\u0000\u0273\u0000\u027d\u0000\u0282\u0000\u0290\u0000\u027b\u0000\u026d\u0000\u025f\u0000\u0272\u0000\u029d\u0000\u028e\u0000\u0261\u0000\u014b\u0000\u0270\u0000\u0281\u0000\u0127\u0000\u0295\u0000\u0294\u0000\u0266\u0000\u0298\u0000\u01c2\u0000\u0253\u0000\u0257\u0000\u0284\u0000\u0260\u0000\u0193\u0000\u0153\u0000\u0152\u0000\u0268\u0000\u0289\u0000\u0258\u0000\u0275\u0000\u0259\u0000\u025c\u0000\u025e\u0000\u0250\u0000\u026f\u0000\u028a\u0000\u0264\u0000\u028c\u0000\u0254\u0000\u0251\u0000\u0252\u0000\u028d\u0000\u0265\u0000\u02a2\u0000\u02a1\u0000\u0255\u0000\u0291\u0000\u027a\u0000\u0267\u0000\u025a\u0000\u00e6\u0300\u01fd\u0000\u1f70\u0000\u1f71\u0000\u0254\u0300\u0254\u0301\u028c\u0300\u028c\u0301\u0259\u0300\u0259\u0301\u025a\u0300\u025a\u0301\u1f72\u0000\u1f73\u0000\u0361\u0000\u02c8\u0000\u02cc\u0000\u02d0\u0000\u02d1\u0000\u0306\u0000\u203f\u0000\u030b\u0000\u0301\u0000\u0304\u0000\u0300\u0000\u030f\u0000\u030c\u0000\u0302\u0000\u02e5\u0000\u02e6\u0000\u02e7\u0000\u02e8\u0000\u02e9\u0000\u02e9\u02e5\u02e5\u02e9\u0325\u0000\u032c\u0000\u0339\u0000\u031c\u0000\u031f\u0000\u0320\u0000\u0308\u0000\u033d\u0000\u0329\u0000\u032f\u0000\u02de\u0000\u0324\u0000\u0330\u0000\u033c\u0000\u0334\u0000\u031d\u0000\u031e\u0000\u0318\u0000\u0319\u0000\u032a\u0000\u033a\u0000\u033b\u0000\u0303\u0000\u031a\u0000\u2776\u0000\u2777\u0000\u2778\u0000\u2779\u0000\u277a\u0000\u277b\u0000\u277c\u0000\u277d\u0000\u277e\u0000\u277f\u0000\u24eb\u0000\u24ec\u0000\u24ed\u0000\u24ee\u0000\u24ef\u0000\u24f0\u0000\u24f1\u0000\u24f2\u0000\u24f3\u0000\u24f4\u0000\u2170\u0000\u2171\u0000\u2172\u0000\u2173\u0000\u2174\u0000\u2175\u0000\u2176\u0000\u2177\u0000\u2178\u0000\u2179\u0000\u217a\u0000\u217b\u0000\u24d0\u0000\u24d1\u0000\u24d2\u0000\u24d3\u0000\u24d4\u0000\u24d5\u0000\u24d6\u0000\u24d7\u0000\u24d8\u0000\u24d9\u0000\u24da\u0000\u24db\u0000\u24dc\u0000\u24dd\u0000\u24de\u0000\u24df\u0000\u24e0\u0000\u24e1\u0000\u24e2\u0000\u24e3\u0000\u24e4\u0000\u24e5\u0000\u24e6\u0000\u24e7\u0000\u24e8\u0000\u24e9\u0000\u32d0\u0000\u32d1\u0000\u32d2\u0000\u32d3\u0000\u32d4\u0000\u32d5\u0000\u32d6\u0000\u32d7\u0000\u32d8\u0000\u32d9\u0000\u32da\u0000\u32db\u0000\u32dc\u0000\u32dd\u0000\u32de\u0000\u32df\u0000\u32e0\u0000\u32e1\u0000\u32e2\u0000\u32e3\u0000\u32fa\u0000\u32e9\u0000\u32e5\u0000\u32ed\u0000\u32ec\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u2051\u0000\u2042\u0000\u2460\u0000\u2461\u0000\u2462\u0000\u2463\u0000\u2464\u0000\u2465\u0000\u2466\u0000\u2467\u0000\u2468\u0000\u2469\u0000\u246a\u0000\u246b\u0000\u246c\u0000\u246d\u0000\u246e\u0000\u246f\u0000\u2470\u0000\u2471\u0000\u2472\u0000\u2473\u0000\u2160\u0000\u2161\u0000\u2162\u0000\u2163\u0000\u2164\u0000\u2165\u0000\u2166\u0000\u2167\u0000\u2168\u0000\u2169\u0000\u216a\u0000\u3349\u0000\u3314\u0000\u3322\u0000\u334d\u0000\u3318\u0000\u3327\u0000\u3303\u0000\u3336\u0000\u3351\u0000\u3357\u0000\u330d\u0000\u3326\u0000\u3323\u0000\u332b\u0000\u334a\u0000\u333b\u0000\u339c\u0000\u339d\u0000\u339e\u0000\u338e\u0000\u338f\u0000\u33c4\u0000\u33a1\u0000\u216b\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u337b\u0000\u301d\u0000\u301f\u0000\u2116\u0000\u33cd\u0000\u2121\u0000\u32a4\u0000\u32a5\u0000\u32a6\u0000\u32a7\u0000\u32a8\u0000\u3231\u0000\u3232\u0000\u3239\u0000\u337e\u0000\u337d\u0000\u337c\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u222e\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u221f\u0000\u22bf\u0000\u3000\u0000\u3000\u0000\u3000\u0000\u2756\u0000\u261e\u0000\u4ff1\u0000v\u000b\u3402\u0000\u4e28\u0000\u4e2f\u0000\u4e30\u0000\u4e8d\u0000\u4ee1\u0000\u4efd\u0000\u4eff\u0000\u4f03\u0000\u4f0b\u0000\u4f60\u0000\u4f48\u0000\u4f49\u0000\u4f56\u0000\u4f5f\u0000\u4f6a\u0000\u4f6c\u0000\u4f7e\u0000\u4f8a\u0000\u4f94\u0000\u4f97\u0000\ufa30\u0000\u4fc9\u0000\u4fe0\u0000\u5001\u0000\u5002\u0000\u500e\u0000\u5018\u0000\u5027\u0000\u502e\u0000\u5040\u0000\u503b\u0000\u5041\u0000\u5094\u0000\u50cc\u0000\u50f2\u0000\u50d0\u0000\u50e6\u0000\ufa31\u0000\u5106\u0000\u5103\u0000\u510b\u0000\u511e\u0000\u5135\u0000\u514a\u0000\ufa32\u0000\u5155\u0000\u5157\u0000\u34b5\u0000\u519d\u0000\u51c3\u0000\u51ca\u0000\u51de\u0000\u51e2\u0000\u51ee\u0000\u5201\u0000\u34db\u0000\u5213\u0000\u5215\u0000\u5249\u0000\u5257\u0000\u5261\u0000\u5293\u0000\u52c8\u0000\ufa33\u0000\u52cc\u0000\u52d0\u0000\u52d6\u0000\u52db\u0000\ufa34\u0000\u52f0\u0000\u52fb\u0000\u5300\u0000\u5307\u0000\u531c\u0000\ufa35\u0000\u5361\u0000\u5363\u0000\u537d\u0000\u5393\u0000\u539d\u0000\u53b2\u0000\u5412\u0000\u5427\u0000\u544d\u0000\u549c\u0000\u546b\u0000\u5474\u0000\u547f\u0000\u5488\u0000\u5496\u0000\u54a1\u0000\u54a9\u0000\u54c6\u0000\u54ff\u0000\u550e\u0000\u552b\u0000\u5535\u0000\u5550\u0000\u555e\u0000\u5581\u0000\u5586\u0000\u558e\u0000\ufa36\u0000\u55ad\u0000\u55ce\u0000\ufa37\u0000\u5608\u0000\u560e\u0000\u563b\u0000\u5649\u0000\u5676\u0000\u5666\u0000\ufa38\u0000\u566f\u0000\u5671\u0000\u5672\u0000\u5699\u0000\u569e\u0000\u56a9\u0000\u56ac\u0000\u56b3\u0000\u56c9\u0000\u56ca\u0000\u570a\u0000z\u023d\u5721\u0000\u572f\u0000\u5733\u0000\u5734\u0000\u5770\u0000\u5777\u0000\u577c\u0000\u579c\u0000\ufa0f\u0000z\u031b\u57b8\u0000\u57c7\u0000\u57c8\u0000\u57cf\u0000\u57e4\u0000\u57ed\u0000\u57f5\u0000\u57f6\u0000\u57ff\u0000\u5809\u0000\ufa10\u0000\u5861\u0000\u5864\u0000\ufa39\u0000\u587c\u0000\u5889\u0000\u589e\u0000\ufa3a\u0000\u58a9\u0000{n\u58d2\u0000\u58ce\u0000\u58d4\u0000\u58da\u0000\u58e0\u0000\u58e9\u0000\u590c\u0000\u8641\u0000\u595d\u0000\u596d\u0000\u598b\u0000\u5992\u0000\u59a4\u0000\u59c3\u0000\u59d2\u0000\u59dd\u0000\u5a13\u0000\u5a23\u0000\u5a67\u0000\u5a6d\u0000\u5a77\u0000\u5a7e\u0000\u5a84\u0000\u5a9e\u0000\u5aa7\u0000\u5ac4\u0000|\u00bd\u5b19\u0000\u5b25\u0000\u525d\u0000\u4e9c\u0000\u5516\u0000\u5a03\u0000\u963f\u0000\u54c0\u0000\u611b\u0000\u6328\u0000\u59f6\u0000\u9022\u0000\u8475\u0000\u831c\u0000\u7a50\u0000\u60aa\u0000\u63e1\u0000\u6e25\u0000\u65ed\u0000\u8466\u0000\u82a6\u0000\u9bf5\u0000\u6893\u0000\u5727\u0000\u65a1\u0000\u6271\u0000\u5b9b\u0000\u59d0\u0000\u867b\u0000\u98f4\u0000\u7d62\u0000\u7dbe\u0000\u9b8e\u0000\u6216\u0000\u7c9f\u0000\u88b7\u0000\u5b89\u0000\u5eb5\u0000\u6309\u0000\u6697\u0000\u6848\u0000\u95c7\u0000\u978d\u0000\u674f\u0000\u4ee5\u0000\u4f0a\u0000\u4f4d\u0000\u4f9d\u0000\u5049\u0000\u56f2\u0000\u5937\u0000\u59d4\u0000\u5a01\u0000\u5c09\u0000\u60df\u0000\u610f\u0000\u6170\u0000\u6613\u0000\u6905\u0000\u70ba\u0000\u754f\u0000\u7570\u0000\u79fb\u0000\u7dad\u0000\u7def\u0000\u80c3\u0000\u840e\u0000\u8863\u0000\u8b02\u0000\u9055\u0000\u907a\u0000\u533b\u0000\u4e95\u0000\u4ea5\u0000\u57df\u0000\u80b2\u0000\u90c1\u0000\u78ef\u0000\u4e00\u0000\u58f1\u0000\u6ea2\u0000\u9038\u0000\u7a32\u0000\u8328\u0000\u828b\u0000\u9c2f\u0000\u5141\u0000\u5370\u0000\u54bd\u0000\u54e1\u0000\u56e0\u0000\u59fb\u0000\u5f15\u0000\u98f2\u0000\u6deb\u0000\u80e4\u0000\u852d\u0000\u9662\u0000\u9670\u0000\u96a0\u0000\u97fb\u0000\u540b\u0000\u53f3\u0000\u5b87\u0000\u70cf\u0000\u7fbd\u0000\u8fc2\u0000\u96e8\u0000\u536f\u0000\u9d5c\u0000\u7aba\u0000\u4e11\u0000\u7893\u0000\u81fc\u0000\u6e26\u0000\u5618\u0000\u5504\u0000\u6b1d\u0000\u851a\u0000\u9c3b\u0000\u59e5\u0000\u53a9\u0000\u6d66\u0000\u74dc\u0000\u958f\u0000\u5642\u0000\u4e91\u0000\u904b\u0000\u96f2\u0000\u834f\u0000\u990c\u0000\u53e1\u0000\u55b6\u0000\u5b30\u0000\u5f71\u0000\u6620\u0000\u66f3\u0000\u6804\u0000\u6c38\u0000\u6cf3\u0000\u6d29\u0000\u745b\u0000\u76c8\u0000\u7a4e\u0000\u9834\u0000\u82f1\u0000\u885b\u0000\u8a60\u0000\u92ed\u0000\u6db2\u0000\u75ab\u0000\u76ca\u0000\u99c5\u0000\u60a6\u0000\u8b01\u0000\u8d8a\u0000\u95b2\u0000\u698e\u0000\u53ad\u0000\u5186\u0000\u5712\u0000\u5830\u0000\u5944\u0000\u5bb4\u0000\u5ef6\u0000\u6028\u0000\u63a9\u0000\u63f4\u0000\u6cbf\u0000\u6f14\u0000\u708e\u0000\u7114\u0000\u7159\u0000\u71d5\u0000\u733f\u0000\u7e01\u0000\u8276\u0000\u82d1\u0000\u8597\u0000\u9060\u0000\u925b\u0000\u9d1b\u0000\u5869\u0000\u65bc\u0000\u6c5a\u0000\u7525\u0000\u51f9\u0000\u592e\u0000\u5965\u0000\u5f80\u0000\u5fdc\u0000\u62bc\u0000\u65fa\u0000\u6a2a\u0000\u6b27\u0000\u6bb4\u0000\u738b\u0000\u7fc1\u0000\u8956\u0000\u9d2c\u0000\u9d0e\u0000\u9ec4\u0000\u5ca1\u0000\u6c96\u0000\u837b\u0000\u5104\u0000\u5c4b\u0000\u61b6\u0000\u81c6\u0000\u6876\u0000\u7261\u0000\u4e59\u0000\u4ffa\u0000\u5378\u0000\u6069\u0000\u6e29\u0000\u7a4f\u0000\u97f3\u0000\u4e0b\u0000\u5316\u0000\u4eee\u0000\u4f55\u0000\u4f3d\u0000\u4fa1\u0000\u4f73\u0000\u52a0\u0000\u53ef\u0000\u5609\u0000\u590f\u0000\u5ac1\u0000\u5bb6\u0000\u5be1\u0000\u79d1\u0000\u6687\u0000\u679c\u0000\u67b6\u0000\u6b4c\u0000\u6cb3\u0000\u706b\u0000\u73c2\u0000\u798d\u0000\u79be\u0000\u7a3c\u0000\u7b87\u0000\u82b1\u0000\u82db\u0000\u8304\u0000\u8377\u0000\u83ef\u0000\u83d3\u0000\u8766\u0000\u8ab2\u0000\u5629\u0000\u8ca8\u0000\u8fe6\u0000\u904e\u0000\u971e\u0000\u868a\u0000\u4fc4\u0000\u5ce8\u0000\u6211\u0000\u7259\u0000\u753b\u0000\u81e5\u0000\u82bd\u0000\u86fe\u0000\u8cc0\u0000\u96c5\u0000\u9913\u0000\u99d5\u0000\u4ecb\u0000\u4f1a\u0000\u89e3\u0000\u56de\u0000\u584a\u0000\u58ca\u0000\u5efb\u0000\u5feb\u0000\u602a\u0000\u6094\u0000\u6062\u0000\u61d0\u0000\u6212\u0000\u62d0\u0000\u6539\u0000\u9b41\u0000\u6666\u0000\u68b0\u0000\u6d77\u0000\u7070\u0000\u754c\u0000\u7686\u0000\u7d75\u0000\u82a5\u0000\u87f9\u0000\u958b\u0000\u968e\u0000\u8c9d\u0000\u51f1\u0000\u52be\u0000\u5916\u0000\u54b3\u0000\u5bb3\u0000\u5d16\u0000\u6168\u0000\u6982\u0000\u6daf\u0000\u788d\u0000\u84cb\u0000\u8857\u0000\u8a72\u0000\u93a7\u0000\u9ab8\u0000\u6d6c\u0000\u99a8\u0000\u86d9\u0000\u57a3\u0000\u67ff\u0000\u86ce\u0000\u920e\u0000\u5283\u0000\u5687\u0000\u5404\u0000\u5ed3\u0000\u62e1\u0000\u64b9\u0000\u683c\u0000\u6838\u0000\u6bbb\u0000\u7372\u0000\u78ba\u0000\u7a6b\u0000\u899a\u0000\u89d2\u0000\u8d6b\u0000\u8f03\u0000\u90ed\u0000\u95a3\u0000\u9694\u0000\u9769\u0000\u5b66\u0000\u5cb3\u0000\u697d\u0000\u984d\u0000\u984e\u0000\u639b\u0000\u7b20\u0000\u6a2b\u0000\u6a7f\u0000\u68b6\u0000\u9c0d\u0000\u6f5f\u0000\u5272\u0000\u559d\u0000\u6070\u0000\u62ec\u0000\u6d3b\u0000\u6e07\u0000\u6ed1\u0000\u845b\u0000\u8910\u0000\u8f44\u0000\u4e14\u0000\u9c39\u0000\u53f6\u0000\u691b\u0000\u6a3a\u0000\u9784\u0000\u682a\u0000\u515c\u0000\u7ac3\u0000\u84b2\u0000\u91dc\u0000\u938c\u0000\u565b\u0000\u9d28\u0000\u6822\u0000\u8305\u0000\u8431\u0000\u7ca5\u0000\u5208\u0000\u82c5\u0000\u74e6\u0000\u4e7e\u0000\u4f83\u0000\u51a0\u0000\u5bd2\u0000\u520a\u0000\u52d8\u0000\u52e7\u0000\u5dfb\u0000\u559a\u0000\u582a\u0000\u59e6\u0000\u5b8c\u0000\u5b98\u0000\u5bdb\u0000\u5e72\u0000\u5e79\u0000\u60a3\u0000\u611f\u0000\u6163\u0000\u61be\u0000\u63db\u0000\u6562\u0000\u67d1\u0000\u6853\u0000\u68fa\u0000\u6b3e\u0000\u6b53\u0000\u6c57\u0000\u6f22\u0000\u6f97\u0000\u6f45\u0000\u74b0\u0000\u7518\u0000\u76e3\u0000\u770b\u0000\u7aff\u0000\u7ba1\u0000\u7c21\u0000\u7de9\u0000\u7f36\u0000\u7ff0\u0000\u809d\u0000\u8266\u0000\u839e\u0000\u89b3\u0000\u8acc\u0000\u8cab\u0000\u9084\u0000\u9451\u0000\u9593\u0000\u9591\u0000\u95a2\u0000\u9665\u0000\u97d3\u0000\u9928\u0000\u8218\u0000\u4e38\u0000\u542b\u0000\u5cb8\u0000\u5dcc\u0000\u73a9\u0000\u764c\u0000\u773c\u0000\u5ca9\u0000\u7feb\u0000\u8d0b\u0000\u96c1\u0000\u9811\u0000\u9854\u0000\u9858\u0000\u4f01\u0000\u4f0e\u0000\u5371\u0000\u559c\u0000\u5668\u0000\u57fa\u0000\u5947\u0000\u5b09\u0000\u5bc4\u0000\u5c90\u0000\u5e0c\u0000\u5e7e\u0000\u5fcc\u0000\u63ee\u0000\u673a\u0000\u65d7\u0000\u65e2\u0000\u671f\u0000\u68cb\u0000\u68c4\u0000\u6a5f\u0000\u5e30\u0000\u6bc5\u0000\u6c17\u0000\u6c7d\u0000\u757f\u0000\u7948\u0000\u5b63\u0000\u7a00\u0000\u7d00\u0000\u5fbd\u0000\u898f\u0000\u8a18\u0000\u8cb4\u0000\u8d77\u0000\u8ecc\u0000\u8f1d\u0000\u98e2\u0000\u9a0e\u0000\u9b3c\u0000\u4e80\u0000\u507d\u0000\u5100\u0000\u5993\u0000\u5b9c\u0000\u622f\u0000\u6280\u0000\u64ec\u0000\u6b3a\u0000\u72a0\u0000\u7591\u0000\u7947\u0000\u7fa9\u0000\u87fb\u0000\u8abc\u0000\u8b70\u0000\u63ac\u0000\u83ca\u0000\u97a0\u0000\u5409\u0000\u5403\u0000\u55ab\u0000\u6854\u0000\u6a58\u0000\u8a70\u0000\u7827\u0000\u6775\u0000\u9ecd\u0000\u5374\u0000\u5ba2\u0000\u811a\u0000\u8650\u0000\u9006\u0000\u4e18\u0000\u4e45\u0000\u4ec7\u0000\u4f11\u0000\u53ca\u0000\u5438\u0000\u5bae\u0000\u5f13\u0000\u6025\u0000\u6551\u0000\u673d\u0000\u6c42\u0000\u6c72\u0000\u6ce3\u0000\u7078\u0000\u7403\u0000\u7a76\u0000\u7aae\u0000\u7b08\u0000\u7d1a\u0000\u7cfe\u0000\u7d66\u0000\u65e7\u0000\u725b\u0000\u53bb\u0000\u5c45\u0000\u5de8\u0000\u62d2\u0000\u62e0\u0000\u6319\u0000\u6e20\u0000\u865a\u0000\u8a31\u0000\u8ddd\u0000\u92f8\u0000\u6f01\u0000\u79a6\u0000\u9b5a\u0000\u4ea8\u0000\u4eab\u0000\u4eac\u0000\u4f9b\u0000\u4fa0\u0000\u50d1\u0000\u5147\u0000\u7af6\u0000\u5171\u0000\u51f6\u0000\u5354\u0000\u5321\u0000\u537f\u0000\u53eb\u0000\u55ac\u0000\u5883\u0000\u5ce1\u0000\u5f37\u0000\u5f4a\u0000\u602f\u0000\u6050\u0000\u606d\u0000\u631f\u0000\u6559\u0000\u6a4b\u0000\u6cc1\u0000\u72c2\u0000\u72ed\u0000\u77ef\u0000\u80f8\u0000\u8105\u0000\u8208\u0000\u854e\u0000\u90f7\u0000\u93e1\u0000\u97ff\u0000\u9957\u0000\u9a5a\u0000\u4ef0\u0000\u51dd\u0000\u5c2d\u0000\u6681\u0000\u696d\u0000\u5c40\u0000\u66f2\u0000\u6975\u0000\u7389\u0000\u6850\u0000\u7c81\u0000\u50c5\u0000\u52e4\u0000\u5747\u0000\u5dfe\u0000\u9326\u0000\u65a4\u0000\u6b23\u0000\u6b3d\u0000\u7434\u0000\u7981\u0000\u79bd\u0000\u7b4b\u0000\u7dca\u0000\u82b9\u0000\u83cc\u0000\u887f\u0000\u895f\u0000\u8b39\u0000\u8fd1\u0000\u91d1\u0000\u541f\u0000\u9280\u0000\u4e5d\u0000\u5036\u0000\u53e5\u0000\u533a\u0000\u72d7\u0000\u7396\u0000\u77e9\u0000\u82e6\u0000\u8eaf\u0000\u99c6\u0000\u99c8\u0000\u99d2\u0000\u5177\u0000\u611a\u0000\u865e\u0000\u55b0\u0000\u7a7a\u0000\u5076\u0000\u5bd3\u0000\u9047\u0000\u9685\u0000\u4e32\u0000\u6adb\u0000\u91e7\u0000\u5c51\u0000\u5c48\u0000\u6398\u0000\u7a9f\u0000\u6c93\u0000\u9774\u0000\u8f61\u0000\u7aaa\u0000\u718a\u0000\u9688\u0000\u7c82\u0000\u6817\u0000\u7e70\u0000\u6851\u0000\u936c\u0000\u52f2\u0000\u541b\u0000\u85ab\u0000\u8a13\u0000\u7fa4\u0000\u8ecd\u0000\u90e1\u0000\u5366\u0000\u8888\u0000\u7941\u0000\u4fc2\u0000\u50be\u0000\u5211\u0000\u5144\u0000\u5553\u0000\u572d\u0000\u73ea\u0000\u578b\u0000\u5951\u0000\u5f62\u0000\u5f84\u0000\u6075\u0000\u6176\u0000\u6167\u0000\u61a9\u0000\u63b2\u0000\u643a\u0000\u656c\u0000\u666f\u0000\u6842\u0000\u6e13\u0000\u7566\u0000\u7a3d\u0000\u7cfb\u0000\u7d4c\u0000\u7d99\u0000\u7e4b\u0000\u7f6b\u0000\u830e\u0000\u834a\u0000\u86cd\u0000\u8a08\u0000\u8a63\u0000\u8b66\u0000\u8efd\u0000\u981a\u0000\u9d8f\u0000\u82b8\u0000\u8fce\u0000\u9be8\u0000\u5287\u0000\u621f\u0000\u6483\u0000\u6fc0\u0000\u9699\u0000\u6841\u0000\u5091\u0000\u6b20\u0000\u6c7a\u0000\u6f54\u0000\u7a74\u0000\u7d50\u0000\u8840\u0000\u8a23\u0000\u6708\u0000\u4ef6\u0000\u5039\u0000\u5026\u0000\u5065\u0000\u517c\u0000\u5238\u0000\u5263\u0000\u55a7\u0000\u570f\u0000\u5805\u0000\u5acc\u0000\u5efa\u0000\u61b2\u0000\u61f8\u0000\u62f3\u0000\u6372\u0000\u691c\u0000\u6a29\u0000\u727d\u0000\u72ac\u0000\u732e\u0000\u7814\u0000\u786f\u0000\u7d79\u0000\u770c\u0000\u80a9\u0000\u898b\u0000\u8b19\u0000\u8ce2\u0000\u8ed2\u0000\u9063\u0000\u9375\u0000\u967a\u0000\u9855\u0000\u9a13\u0000\u9e78\u0000\u5143\u0000\u539f\u0000\u53b3\u0000\u5e7b\u0000\u5f26\u0000\u6e1b\u0000\u6e90\u0000\u7384\u0000\u73fe\u0000\u7d43\u0000\u8237\u0000\u8a00\u0000\u8afa\u0000\u9650\u0000\u4e4e\u0000\u500b\u0000\u53e4\u0000\u547c\u0000\u56fa\u0000\u59d1\u0000\u5b64\u0000\u5df1\u0000\u5eab\u0000\u5f27\u0000\u6238\u0000\u6545\u0000\u67af\u0000\u6e56\u0000\u72d0\u0000\u7cca\u0000\u88b4\u0000\u80a1\u0000\u80e1\u0000\u83f0\u0000\u864e\u0000\u8a87\u0000\u8de8\u0000\u9237\u0000\u96c7\u0000\u9867\u0000\u9f13\u0000\u4e94\u0000\u4e92\u0000\u4f0d\u0000\u5348\u0000\u5449\u0000\u543e\u0000\u5a2f\u0000\u5f8c\u0000\u5fa1\u0000\u609f\u0000\u68a7\u0000\u6a8e\u0000\u745a\u0000\u7881\u0000\u8a9e\u0000\u8aa4\u0000\u8b77\u0000\u9190\u0000\u4e5e\u0000\u9bc9\u0000\u4ea4\u0000\u4f7c\u0000\u4faf\u0000\u5019\u0000\u5016\u0000\u5149\u0000\u516c\u0000\u529f\u0000\u52b9\u0000\u52fe\u0000\u539a\u0000\u53e3\u0000\u5411\u0000\u540e\u0000\u5589\u0000\u5751\u0000\u57a2\u0000\u597d\u0000\u5b54\u0000\u5b5d\u0000\u5b8f\u0000\u5de5\u0000\u5de7\u0000\u5df7\u0000\u5e78\u0000\u5e83\u0000\u5e9a\u0000\u5eb7\u0000\u5f18\u0000\u6052\u0000\u614c\u0000\u6297\u0000\u62d8\u0000\u63a7\u0000\u653b\u0000\u6602\u0000\u6643\u0000\u66f4\u0000\u676d\u0000\u6821\u0000\u6897\u0000\u69cb\u0000\u6c5f\u0000\u6d2a\u0000\u6d69\u0000\u6e2f\u0000\u6e9d\u0000\u7532\u0000\u7687\u0000\u786c\u0000\u7a3f\u0000\u7ce0\u0000\u7d05\u0000\u7d18\u0000\u7d5e\u0000\u7db1\u0000\u8015\u0000\u8003\u0000\u80af\u0000\u80b1\u0000\u8154\u0000\u818f\u0000\u822a\u0000\u8352\u0000\u884c\u0000\u8861\u0000\u8b1b\u0000\u8ca2\u0000\u8cfc\u0000\u90ca\u0000\u9175\u0000\u9271\u0000\u783f\u0000\u92fc\u0000\u95a4\u0000\u964d\u0000\u9805\u0000\u9999\u0000\u9ad8\u0000\u9d3b\u0000\u525b\u0000\u52ab\u0000\u53f7\u0000\u5408\u0000\u58d5\u0000\u62f7\u0000\u6fe0\u0000\u8c6a\u0000\u8f5f\u0000\u9eb9\u0000\u514b\u0000\u523b\u0000\u544a\u0000\u56fd\u0000\u7a40\u0000\u9177\u0000\u9d60\u0000\u9ed2\u0000\u7344\u0000\u6f09\u0000\u8170\u0000\u7511\u0000\u5ffd\u0000\u60da\u0000\u9aa8\u0000\u72db\u0000\u8fbc\u0000\u6b64\u0000\u9803\u0000\u4eca\u0000\u56f0\u0000\u5764\u0000\u58be\u0000\u5a5a\u0000\u6068\u0000\u61c7\u0000\u660f\u0000\u6606\u0000\u6839\u0000\u68b1\u0000\u6df7\u0000\u75d5\u0000\u7d3a\u0000\u826e\u0000\u9b42\u0000\u4e9b\u0000\u4f50\u0000\u53c9\u0000\u5506\u0000\u5d6f\u0000\u5de6\u0000\u5dee\u0000\u67fb\u0000\u6c99\u0000\u7473\u0000\u7802\u0000\u8a50\u0000\u9396\u0000\u88df\u0000\u5750\u0000\u5ea7\u0000\u632b\u0000\u50b5\u0000\u50ac\u0000\u518d\u0000\u6700\u0000\u54c9\u0000\u585e\u0000\u59bb\u0000\u5bb0\u0000\u5f69\u0000\u624d\u0000\u63a1\u0000\u683d\u0000\u6b73\u0000\u6e08\u0000\u707d\u0000\u91c7\u0000\u7280\u0000\u7815\u0000\u7826\u0000\u796d\u0000\u658e\u0000\u7d30\u0000\u83dc\u0000\u88c1\u0000\u8f09\u0000\u969b\u0000\u5264\u0000\u5728\u0000\u6750\u0000\u7f6a\u0000\u8ca1\u0000\u51b4\u0000\u5742\u0000\u962a\u0000\u583a\u0000\u698a\u0000\u80b4\u0000\u54b2\u0000\u5d0e\u0000\u57fc\u0000\u7895\u0000\u9dfa\u0000\u4f5c\u0000\u524a\u0000\u548b\u0000\u643e\u0000\u6628\u0000\u6714\u0000\u67f5\u0000\u7a84\u0000\u7b56\u0000\u7d22\u0000\u932f\u0000\u685c\u0000\u9bad\u0000\u7b39\u0000\u5319\u0000\u518a\u0000\u5237\u0000\u5bdf\u0000\u62f6\u0000\u64ae\u0000\u64e6\u0000\u672d\u0000\u6bba\u0000\u85a9\u0000\u96d1\u0000\u7690\u0000\u9bd6\u0000\u634c\u0000\u9306\u0000\u9bab\u0000\u76bf\u0000\u6652\u0000\u4e09\u0000\u5098\u0000\u53c2\u0000\u5c71\u0000\u60e8\u0000\u6492\u0000\u6563\u0000\u685f\u0000\u71e6\u0000\u73ca\u0000\u7523\u0000\u7b97\u0000\u7e82\u0000\u8695\u0000\u8b83\u0000\u8cdb\u0000\u9178\u0000\u9910\u0000\u65ac\u0000\u66ab\u0000\u6b8b\u0000\u4ed5\u0000\u4ed4\u0000\u4f3a\u0000\u4f7f\u0000\u523a\u0000\u53f8\u0000\u53f2\u0000\u55e3\u0000\u56db\u0000\u58eb\u0000\u59cb\u0000\u59c9\u0000\u59ff\u0000\u5b50\u0000\u5c4d\u0000\u5e02\u0000\u5e2b\u0000\u5fd7\u0000\u601d\u0000\u6307\u0000\u652f\u0000\u5b5c\u0000\u65af\u0000\u65bd\u0000\u65e8\u0000\u679d\u0000\u6b62\u0000\u6b7b\u0000\u6c0f\u0000\u7345\u0000\u7949\u0000\u79c1\u0000\u7cf8\u0000\u7d19\u0000\u7d2b\u0000\u80a2\u0000\u8102\u0000\u81f3\u0000\u8996\u0000\u8a5e\u0000\u8a69\u0000\u8a66\u0000\u8a8c\u0000\u8aee\u0000\u8cc7\u0000\u8cdc\u0000\u96cc\u0000\u98fc\u0000\u6b6f\u0000\u4e8b\u0000\u4f3c\u0000\u4f8d\u0000\u5150\u0000\u5b57\u0000\u5bfa\u0000\u6148\u0000\u6301\u0000\u6642\u0000\u6b21\u0000\u6ecb\u0000\u6cbb\u0000\u723e\u0000\u74bd\u0000\u75d4\u0000\u78c1\u0000\u793a\u0000\u800c\u0000\u8033\u0000\u81ea\u0000\u8494\u0000\u8f9e\u0000\u6c50\u0000\u9e7f\u0000\u5f0f\u0000\u8b58\u0000\u9d2b\u0000\u7afa\u0000\u8ef8\u0000\u5b8d\u0000\u96eb\u0000\u4e03\u0000\u53f1\u0000\u57f7\u0000\u5931\u0000\u5ac9\u0000\u5ba4\u0000\u6089\u0000\u6e7f\u0000\u6f06\u0000\u75be\u0000\u8cea\u0000\u5b9f\u0000\u8500\u0000\u7be0\u0000\u5072\u0000\u67f4\u0000\u829d\u0000\u5c61\u0000\u854a\u0000\u7e1e\u0000\u820e\u0000\u5199\u0000\u5c04\u0000\u6368\u0000\u8d66\u0000\u659c\u0000\u716e\u0000\u793e\u0000\u7d17\u0000\u8005\u0000\u8b1d\u0000\u8eca\u0000\u906e\u0000\u86c7\u0000\u90aa\u0000\u501f\u0000\u52fa\u0000\u5c3a\u0000\u6753\u0000\u707c\u0000\u7235\u0000\u914c\u0000\u91c8\u0000\u932b\u0000\u82e5\u0000\u5bc2\u0000\u5f31\u0000\u60f9\u0000\u4e3b\u0000\u53d6\u0000\u5b88\u0000\u624b\u0000\u6731\u0000\u6b8a\u0000\u72e9\u0000\u73e0\u0000\u7a2e\u0000\u816b\u0000\u8da3\u0000\u9152\u0000\u9996\u0000\u5112\u0000\u53d7\u0000\u546a\u0000\u5bff\u0000\u6388\u0000\u6a39\u0000\u7dac\u0000\u9700\u0000\u56da\u0000\u53ce\u0000\u5468\u0000\u5b97\u0000\u5c31\u0000\u5dde\u0000\u4fee\u0000\u6101\u0000\u62fe\u0000\u6d32\u0000\u79c0\u0000\u79cb\u0000\u7d42\u0000\u7e4d\u0000\u7fd2\u0000\u81ed\u0000\u821f\u0000\u8490\u0000\u8846\u0000\u8972\u0000\u8b90\u0000\u8e74\u0000\u8f2f\u0000\u9031\u0000\u914b\u0000\u916c\u0000\u96c6\u0000\u919c\u0000\u4ec0\u0000\u4f4f\u0000\u5145\u0000\u5341\u0000\u5f93\u0000\u620e\u0000\u67d4\u0000\u6c41\u0000\u6e0b\u0000\u7363\u0000\u7e26\u0000\u91cd\u0000\u9283\u0000\u53d4\u0000\u5919\u0000\u5bbf\u0000\u6dd1\u0000\u795d\u0000\u7e2e\u0000\u7c9b\u0000\u587e\u0000\u719f\u0000\u51fa\u0000\u8853\u0000\u8ff0\u0000\u4fca\u0000\u5cfb\u0000\u6625\u0000\u77ac\u0000\u7ae3\u0000\u821c\u0000\u99ff\u0000\u51c6\u0000\u5faa\u0000\u65ec\u0000\u696f\u0000\u6b89\u0000\u6df3\u0000\u6e96\u0000\u6f64\u0000\u76fe\u0000\u7d14\u0000\u5de1\u0000\u9075\u0000\u9187\u0000\u9806\u0000\u51e6\u0000\u521d\u0000\u6240\u0000\u6691\u0000\u66d9\u0000\u6e1a\u0000\u5eb6\u0000\u7dd2\u0000\u7f72\u0000\u66f8\u0000\u85af\u0000\u85f7\u0000\u8af8\u0000\u52a9\u0000\u53d9\u0000\u5973\u0000\u5e8f\u0000\u5f90\u0000\u6055\u0000\u92e4\u0000\u9664\u0000\u50b7\u0000\u511f\u0000\u52dd\u0000\u5320\u0000\u5347\u0000\u53ec\u0000\u54e8\u0000\u5546\u0000\u5531\u0000\u5617\u0000\u5968\u0000\u59be\u0000\u5a3c\u0000\u5bb5\u0000\u5c06\u0000\u5c0f\u0000\u5c11\u0000\u5c1a\u0000\u5e84\u0000\u5e8a\u0000\u5ee0\u0000\u5f70\u0000\u627f\u0000\u6284\u0000\u62db\u0000\u638c\u0000\u6377\u0000\u6607\u0000\u660c\u0000\u662d\u0000\u6676\u0000\u677e\u0000\u68a2\u0000\u6a1f\u0000\u6a35\u0000\u6cbc\u0000\u6d88\u0000\u6e09\u0000\u6e58\u0000\u713c\u0000\u7126\u0000\u7167\u0000\u75c7\u0000\u7701\u0000\u785d\u0000\u7901\u0000\u7965\u0000\u79f0\u0000\u7ae0\u0000\u7b11\u0000\u7ca7\u0000\u7d39\u0000\u8096\u0000\u83d6\u0000\u848b\u0000\u8549\u0000\u885d\u0000\u88f3\u0000\u8a1f\u0000\u8a3c\u0000\u8a54\u0000\u8a73\u0000\u8c61\u0000\u8cde\u0000\u91a4\u0000\u9266\u0000\u937e\u0000\u9418\u0000\u969c\u0000\u9798\u0000\u4e0a\u0000\u4e08\u0000\u4e1e\u0000\u4e57\u0000\u5197\u0000\u5270\u0000\u57ce\u0000\u5834\u0000\u58cc\u0000\u5b22\u0000\u5e38\u0000\u60c5\u0000\u64fe\u0000\u6761\u0000\u6756\u0000\u6d44\u0000\u72b6\u0000\u7573\u0000\u7a63\u0000\u84b8\u0000\u8b72\u0000\u91b8\u0000\u9320\u0000\u5631\u0000\u57f4\u0000\u98fe\u0000\u62ed\u0000\u690d\u0000\u6b96\u0000\u71ed\u0000\u7e54\u0000\u8077\u0000\u8272\u0000\u89e6\u0000\u98df\u0000\u8755\u0000\u8fb1\u0000\u5c3b\u0000\u4f38\u0000\u4fe1\u0000\u4fb5\u0000\u5507\u0000\u5a20\u0000\u5bdd\u0000\u5be9\u0000\u5fc3\u0000\u614e\u0000\u632f\u0000\u65b0\u0000\u664b\u0000\u68ee\u0000\u699b\u0000\u6d78\u0000\u6df1\u0000\u7533\u0000\u75b9\u0000\u771f\u0000\u795e\u0000\u79e6\u0000\u7d33\u0000\u81e3\u0000\u82af\u0000\u85aa\u0000\u89aa\u0000\u8a3a\u0000\u8eab\u0000\u8f9b\u0000\u9032\u0000\u91dd\u0000\u9707\u0000\u4eba\u0000\u4ec1\u0000\u5203\u0000\u5875\u0000\u58ec\u0000\u5c0b\u0000\u751a\u0000\u5c3d\u0000\u814e\u0000\u8a0a\u0000\u8fc5\u0000\u9663\u0000\u976d\u0000\u7b25\u0000\u8acf\u0000\u9808\u0000\u9162\u0000\u56f3\u0000\u53a8\u0000\u9017\u0000\u5439\u0000\u5782\u0000\u5e25\u0000\u63a8\u0000\u6c34\u0000\u708a\u0000\u7761\u0000\u7c8b\u0000\u7fe0\u0000\u8870\u0000\u9042\u0000\u9154\u0000\u9310\u0000\u9318\u0000\u968f\u0000\u745e\u0000\u9ac4\u0000\u5d07\u0000\u5d69\u0000\u6570\u0000\u67a2\u0000\u8da8\u0000\u96db\u0000\u636e\u0000\u6749\u0000\u6919\u0000\u83c5\u0000\u9817\u0000\u96c0\u0000\u88fe\u0000\u6f84\u0000\u647a\u0000\u5bf8\u0000\u4e16\u0000\u702c\u0000\u755d\u0000\u662f\u0000\u51c4\u0000\u5236\u0000\u52e2\u0000\u59d3\u0000\u5f81\u0000\u6027\u0000\u6210\u0000\u653f\u0000\u6574\u0000\u661f\u0000\u6674\u0000\u68f2\u0000\u6816\u0000\u6b63\u0000\u6e05\u0000\u7272\u0000\u751f\u0000\u76db\u0000\u7cbe\u0000\u8056\u0000\u58f0\u0000\u88fd\u0000\u897f\u0000\u8aa0\u0000\u8a93\u0000\u8acb\u0000\u901d\u0000\u9192\u0000\u9752\u0000\u9759\u0000\u6589\u0000\u7a0e\u0000\u8106\u0000\u96bb\u0000\u5e2d\u0000\u60dc\u0000\u621a\u0000\u65a5\u0000\u6614\u0000\u6790\u0000\u77f3\u0000\u7a4d\u0000\u7c4d\u0000\u7e3e\u0000\u810a\u0000\u8cac\u0000\u8d64\u0000\u8de1\u0000\u8e5f\u0000\u78a9\u0000\u5207\u0000\u62d9\u0000\u63a5\u0000\u6442\u0000\u6298\u0000\u8a2d\u0000\u7a83\u0000\u7bc0\u0000\u8aac\u0000\u96ea\u0000\u7d76\u0000\u820c\u0000\u8749\u0000\u4ed9\u0000\u5148\u0000\u5343\u0000\u5360\u0000\u5ba3\u0000\u5c02\u0000\u5c16\u0000\u5ddd\u0000\u6226\u0000\u6247\u0000\u64b0\u0000\u6813\u0000\u6834\u0000\u6cc9\u0000\u6d45\u0000\u6d17\u0000\u67d3\u0000\u6f5c\u0000\u714e\u0000\u717d\u0000\u65cb\u0000\u7a7f\u0000\u7bad\u0000\u7dda\u0000\u7e4a\u0000\u7fa8\u0000\u817a\u0000\u821b\u0000\u8239\u0000\u85a6\u0000\u8a6e\u0000\u8cce\u0000\u8df5\u0000\u9078\u0000\u9077\u0000\u92ad\u0000\u9291\u0000\u9583\u0000\u9bae\u0000\u524d\u0000\u5584\u0000\u6f38\u0000\u7136\u0000\u5168\u0000\u7985\u0000\u7e55\u0000\u81b3\u0000\u7cce\u0000\u564c\u0000\u5851\u0000\u5ca8\u0000\u63aa\u0000\u66fe\u0000\u66fd\u0000\u695a\u0000\u72d9\u0000\u758f\u0000\u758e\u0000\u790e\u0000\u7956\u0000\u79df\u0000\u7c97\u0000\u7d20\u0000\u7d44\u0000\u8607\u0000\u8a34\u0000\u963b\u0000\u9061\u0000\u9f20\u0000\u50e7\u0000\u5275\u0000\u53cc\u0000\u53e2\u0000\u5009\u0000\u55aa\u0000\u58ee\u0000\u594f\u0000\u723d\u0000\u5b8b\u0000\u5c64\u0000\u531d\u0000\u60e3\u0000\u60f3\u0000\u635c\u0000\u6383\u0000\u633f\u0000\u63bb\u0000\u64cd\u0000\u65e9\u0000\u66f9\u0000\u5de3\u0000\u69cd\u0000\u69fd\u0000\u6f15\u0000\u71e5\u0000\u4e89\u0000\u75e9\u0000\u76f8\u0000\u7a93\u0000\u7cdf\u0000\u7dcf\u0000\u7d9c\u0000\u8061\u0000\u8349\u0000\u8358\u0000\u846c\u0000\u84bc\u0000\u85fb\u0000\u88c5\u0000\u8d70\u0000\u9001\u0000\u906d\u0000\u9397\u0000\u971c\u0000\u9a12\u0000\u50cf\u0000\u5897\u0000\u618e\u0000\u81d3\u0000\u8535\u0000\u8d08\u0000\u9020\u0000\u4fc3\u0000\u5074\u0000\u5247\u0000\u5373\u0000\u606f\u0000\u6349\u0000\u675f\u0000\u6e2c\u0000\u8db3\u0000\u901f\u0000\u4fd7\u0000\u5c5e\u0000\u8cca\u0000\u65cf\u0000\u7d9a\u0000\u5352\u0000\u8896\u0000\u5176\u0000\u63c3\u0000\u5b58\u0000\u5b6b\u0000\u5c0a\u0000\u640d\u0000\u6751\u0000\u905c\u0000\u4ed6\u0000\u591a\u0000\u592a\u0000\u6c70\u0000\u8a51\u0000\u553e\u0000\u5815\u0000\u59a5\u0000\u60f0\u0000\u6253\u0000\u67c1\u0000\u8235\u0000\u6955\u0000\u9640\u0000\u99c4\u0000\u9a28\u0000\u4f53\u0000\u5806\u0000\u5bfe\u0000\u8010\u0000\u5cb1\u0000\u5e2f\u0000\u5f85\u0000\u6020\u0000\u614b\u0000\u6234\u0000\u66ff\u0000\u6cf0\u0000\u6ede\u0000\u80ce\u0000\u817f\u0000\u82d4\u0000\u888b\u0000\u8cb8\u0000\u9000\u0000\u902e\u0000\u968a\u0000\u9edb\u0000\u9bdb\u0000\u4ee3\u0000\u53f0\u0000\u5927\u0000\u7b2c\u0000\u918d\u0000\u984c\u0000\u9df9\u0000\u6edd\u0000\u7027\u0000\u5353\u0000\u5544\u0000\u5b85\u0000\u6258\u0000\u629e\u0000\u62d3\u0000\u6ca2\u0000\u6fef\u0000\u7422\u0000\u8a17\u0000\u9438\u0000\u6fc1\u0000\u8afe\u0000\u8338\u0000\u51e7\u0000\u86f8\u0000\u53ea\u0000\u53e9\u0000\u4f46\u0000\u9054\u0000\u8fb0\u0000\u596a\u0000\u8131\u0000\u5dfd\u0000\u7aea\u0000\u8fbf\u0000\u68da\u0000\u8c37\u0000\u72f8\u0000\u9c48\u0000\u6a3d\u0000\u8ab0\u0000\u4e39\u0000\u5358\u0000\u5606\u0000\u5766\u0000\u62c5\u0000\u63a2\u0000\u65e6\u0000\u6b4e\u0000\u6de1\u0000\u6e5b\u0000\u70ad\u0000\u77ed\u0000\u7aef\u0000\u7baa\u0000\u7dbb\u0000\u803d\u0000\u80c6\u0000\u86cb\u0000\u8a95\u0000\u935b\u0000\u56e3\u0000\u58c7\u0000\u5f3e\u0000\u65ad\u0000\u6696\u0000\u6a80\u0000\u6bb5\u0000\u7537\u0000\u8ac7\u0000\u5024\u0000\u77e5\u0000\u5730\u0000\u5f1b\u0000\u6065\u0000\u667a\u0000\u6c60\u0000\u75f4\u0000\u7a1a\u0000\u7f6e\u0000\u81f4\u0000\u8718\u0000\u9045\u0000\u99b3\u0000\u7bc9\u0000\u755c\u0000\u7af9\u0000\u7b51\u0000\u84c4\u0000\u9010\u0000\u79e9\u0000\u7a92\u0000\u8336\u0000\u5ae1\u0000\u7740\u0000\u4e2d\u0000\u4ef2\u0000\u5b99\u0000\u5fe0\u0000\u62bd\u0000\u663c\u0000\u67f1\u0000\u6ce8\u0000\u866b\u0000\u8877\u0000\u8a3b\u0000\u914e\u0000\u92f3\u0000\u99d0\u0000\u6a17\u0000\u7026\u0000\u732a\u0000\u82e7\u0000\u8457\u0000\u8caf\u0000\u4e01\u0000\u5146\u0000\u51cb\u0000\u558b\u0000\u5bf5\u0000\u5e16\u0000\u5e33\u0000\u5e81\u0000\u5f14\u0000\u5f35\u0000\u5f6b\u0000\u5fb4\u0000\u61f2\u0000\u6311\u0000\u66a2\u0000\u671d\u0000\u6f6e\u0000\u7252\u0000\u753a\u0000\u773a\u0000\u8074\u0000\u8139\u0000\u8178\u0000\u8776\u0000\u8abf\u0000\u8adc\u0000\u8d85\u0000\u8df3\u0000\u929a\u0000\u9577\u0000\u9802\u0000\u9ce5\u0000\u52c5\u0000\u6357\u0000\u76f4\u0000\u6715\u0000\u6c88\u0000\u73cd\u0000\u8cc3\u0000\u93ae\u0000\u9673\u0000\u6d25\u0000\u589c\u0000\u690e\u0000\u69cc\u0000\u8ffd\u0000\u939a\u0000\u75db\u0000\u901a\u0000\u585a\u0000\u6802\u0000\u63b4\u0000\u69fb\u0000\u4f43\u0000\u6f2c\u0000\u67d8\u0000\u8fbb\u0000\u8526\u0000\u7db4\u0000\u9354\u0000\u693f\u0000\u6f70\u0000\u576a\u0000\u58f7\u0000\u5b2c\u0000\u7d2c\u0000\u722a\u0000\u540a\u0000\u91e3\u0000\u9db4\u0000\u4ead\u0000\u4f4e\u0000\u505c\u0000\u5075\u0000\u5243\u0000\u8c9e\u0000\u5448\u0000\u5824\u0000\u5b9a\u0000\u5e1d\u0000\u5e95\u0000\u5ead\u0000\u5ef7\u0000\u5f1f\u0000\u608c\u0000\u62b5\u0000\u633a\u0000\u63d0\u0000\u68af\u0000\u6c40\u0000\u7887\u0000\u798e\u0000\u7a0b\u0000\u7de0\u0000\u8247\u0000\u8a02\u0000\u8ae6\u0000\u8e44\u0000\u9013\u0000\u90b8\u0000\u912d\u0000\u91d8\u0000\u9f0e\u0000\u6ce5\u0000\u6458\u0000\u64e2\u0000\u6575\u0000\u6ef4\u0000\u7684\u0000\u7b1b\u0000\u9069\u0000\u93d1\u0000\u6eba\u0000\u54f2\u0000\u5fb9\u0000\u64a4\u0000\u8f4d\u0000\u8fed\u0000\u9244\u0000\u5178\u0000\u586b\u0000\u5929\u0000\u5c55\u0000\u5e97\u0000\u6dfb\u0000\u7e8f\u0000\u751c\u0000\u8cbc\u0000\u8ee2\u0000\u985b\u0000\u70b9\u0000\u4f1d\u0000\u6bbf\u0000\u6fb1\u0000\u7530\u0000\u96fb\u0000\u514e\u0000\u5410\u0000\u5835\u0000\u5857\u0000\u59ac\u0000\u5c60\u0000\u5f92\u0000\u6597\u0000\u675c\u0000\u6e21\u0000\u767b\u0000\u83df\u0000\u8ced\u0000\u9014\u0000\u90fd\u0000\u934d\u0000\u7825\u0000\u783a\u0000\u52aa\u0000\u5ea6\u0000\u571f\u0000\u5974\u0000\u6012\u0000\u5012\u0000\u515a\u0000\u51ac\u0000\u51cd\u0000\u5200\u0000\u5510\u0000\u5854\u0000\u5858\u0000\u5957\u0000\u5b95\u0000\u5cf6\u0000\u5d8b\u0000\u60bc\u0000\u6295\u0000\u642d\u0000\u6771\u0000\u6843\u0000\u68bc\u0000\u68df\u0000\u76d7\u0000\u6dd8\u0000\u6e6f\u0000\u6d9b\u0000\u706f\u0000\u71c8\u0000\u5f53\u0000\u75d8\u0000\u7977\u0000\u7b49\u0000\u7b54\u0000\u7b52\u0000\u7cd6\u0000\u7d71\u0000\u5230\u0000\u8463\u0000\u8569\u0000\u85e4\u0000\u8a0e\u0000\u8b04\u0000\u8c46\u0000\u8e0f\u0000\u9003\u0000\u900f\u0000\u9419\u0000\u9676\u0000\u982d\u0000\u9a30\u0000\u95d8\u0000\u50cd\u0000\u52d5\u0000\u540c\u0000\u5802\u0000\u5c0e\u0000\u61a7\u0000\u649e\u0000\u6d1e\u0000\u77b3\u0000\u7ae5\u0000\u80f4\u0000\u8404\u0000\u9053\u0000\u9285\u0000\u5ce0\u0000\u9d07\u0000\u533f\u0000\u5f97\u0000\u5fb3\u0000\u6d9c\u0000\u7279\u0000\u7763\u0000\u79bf\u0000\u7be4\u0000\u6bd2\u0000\u72ec\u0000\u8aad\u0000\u6803\u0000\u6a61\u0000\u51f8\u0000\u7a81\u0000\u6934\u0000\u5c4a\u0000\u9cf6\u0000\u82eb\u0000\u5bc5\u0000\u9149\u0000\u701e\u0000\u5678\u0000\u5c6f\u0000\u60c7\u0000\u6566\u0000\u6c8c\u0000\u8c5a\u0000\u9041\u0000\u9813\u0000\u5451\u0000\u66c7\u0000\u920d\u0000\u5948\u0000\u90a3\u0000\u5185\u0000\u4e4d\u0000\u51ea\u0000\u8599\u0000\u8b0e\u0000\u7058\u0000\u637a\u0000\u934b\u0000\u6962\u0000\u99b4\u0000\u7e04\u0000\u7577\u0000\u5357\u0000\u6960\u0000\u8edf\u0000\u96e3\u0000\u6c5d\u0000\u4e8c\u0000\u5c3c\u0000\u5f10\u0000\u8fe9\u0000\u5302\u0000\u8cd1\u0000\u8089\u0000\u8679\u0000\u5eff\u0000\u65e5\u0000\u4e73\u0000\u5165\u0000\u5982\u0000\u5c3f\u0000\u97ee\u0000\u4efb\u0000\u598a\u0000\u5fcd\u0000\u8a8d\u0000\u6fe1\u0000\u79b0\u0000\u7962\u0000\u5be7\u0000\u8471\u0000\u732b\u0000\u71b1\u0000\u5e74\u0000\u5ff5\u0000\u637b\u0000\u649a\u0000\u71c3\u0000\u7c98\u0000\u4e43\u0000\u5efc\u0000\u4e4b\u0000\u57dc\u0000\u56a2\u0000\u60a9\u0000\u6fc3\u0000\u7d0d\u0000\u80fd\u0000\u8133\u0000\u81bf\u0000\u8fb2\u0000\u8997\u0000\u86a4\u0000\u5df4\u0000\u628a\u0000\u64ad\u0000\u8987\u0000\u6777\u0000\u6ce2\u0000\u6d3e\u0000\u7436\u0000\u7834\u0000\u5a46\u0000\u7f75\u0000\u82ad\u0000\u99ac\u0000\u4ff3\u0000\u5ec3\u0000\u62dd\u0000\u6392\u0000\u6557\u0000\u676f\u0000\u76c3\u0000\u724c\u0000\u80cc\u0000\u80ba\u0000\u8f29\u0000\u914d\u0000\u500d\u0000\u57f9\u0000\u5a92\u0000\u6885\u0000\u6973\u0000\u7164\u0000\u72fd\u0000\u8cb7\u0000\u58f2\u0000\u8ce0\u0000\u966a\u0000\u9019\u0000\u877f\u0000\u79e4\u0000\u77e7\u0000\u8429\u0000\u4f2f\u0000\u5265\u0000\u535a\u0000\u62cd\u0000\u67cf\u0000\u6cca\u0000\u767d\u0000\u7b94\u0000\u7c95\u0000\u8236\u0000\u8584\u0000\u8feb\u0000\u66dd\u0000\u6f20\u0000\u7206\u0000\u7e1b\u0000\u83ab\u0000\u99c1\u0000\u9ea6\u0000\u51fd\u0000\u7bb1\u0000\u7872\u0000\u7bb8\u0000\u8087\u0000\u7b48\u0000\u6ae8\u0000\u5e61\u0000\u808c\u0000\u7551\u0000\u7560\u0000\u516b\u0000\u9262\u0000\u6e8c\u0000\u767a\u0000\u9197\u0000\u9aea\u0000\u4f10\u0000\u7f70\u0000\u629c\u0000\u7b4f\u0000\u95a5\u0000\u9ce9\u0000\u567a\u0000\u5859\u0000\u86e4\u0000\u96bc\u0000\u4f34\u0000\u5224\u0000\u534a\u0000\u53cd\u0000\u53db\u0000\u5e06\u0000\u642c\u0000\u6591\u0000\u677f\u0000\u6c3e\u0000\u6c4e\u0000\u7248\u0000\u72af\u0000\u73ed\u0000\u7554\u0000\u7e41\u0000\u822c\u0000\u85e9\u0000\u8ca9\u0000\u7bc4\u0000\u91c6\u0000\u7169\u0000\u9812\u0000\u98ef\u0000\u633d\u0000\u6669\u0000\u756a\u0000\u76e4\u0000\u78d0\u0000\u8543\u0000\u86ee\u0000\u532a\u0000\u5351\u0000\u5426\u0000\u5983\u0000\u5e87\u0000\u5f7c\u0000\u60b2\u0000\u6249\u0000\u6279\u0000\u62ab\u0000\u6590\u0000\u6bd4\u0000\u6ccc\u0000\u75b2\u0000\u76ae\u0000\u7891\u0000\u79d8\u0000\u7dcb\u0000\u7f77\u0000\u80a5\u0000\u88ab\u0000\u8ab9\u0000\u8cbb\u0000\u907f\u0000\u975e\u0000\u98db\u0000\u6a0b\u0000\u7c38\u0000\u5099\u0000\u5c3e\u0000\u5fae\u0000\u6787\u0000\u6bd8\u0000\u7435\u0000\u7709\u0000\u7f8e\u0000\u9f3b\u0000\u67ca\u0000\u7a17\u0000\u5339\u0000\u758b\u0000\u9aed\u0000\u5f66\u0000\u819d\u0000\u83f1\u0000\u8098\u0000\u5f3c\u0000\u5fc5\u0000\u7562\u0000\u7b46\u0000\u903c\u0000\u6867\u0000\u59eb\u0000\u5a9b\u0000\u7d10\u0000\u767e\u0000\u8b2c\u0000\u4ff5\u0000\u5f6a\u0000\u6a19\u0000\u6c37\u0000\u6f02\u0000\u74e2\u0000\u7968\u0000\u8868\u0000\u8a55\u0000\u8c79\u0000\u5edf\u0000\u63cf\u0000\u75c5\u0000\u79d2\u0000\u82d7\u0000\u9328\u0000\u92f2\u0000\u849c\u0000\u86ed\u0000\u9c2d\u0000\u54c1\u0000\u5f6c\u0000\u658c\u0000\u6d5c\u0000\u7015\u0000\u8ca7\u0000\u8cd3\u0000\u983b\u0000\u654f\u0000\u74f6\u0000\u4e0d\u0000\u4ed8\u0000\u57e0\u0000\u592b\u0000\u5a66\u0000\u5bcc\u0000\u51a8\u0000\u5e03\u0000\u5e9c\u0000\u6016\u0000\u6276\u0000\u6577\u0000\u65a7\u0000\u666e\u0000\u6d6e\u0000\u7236\u0000\u7b26\u0000\u8150\u0000\u819a\u0000\u8299\u0000\u8b5c\u0000\u8ca0\u0000\u8ce6\u0000\u8d74\u0000\u961c\u0000\u9644\u0000\u4fae\u0000\u64ab\u0000\u6b66\u0000\u821e\u0000\u8461\u0000\u856a\u0000\u90e8\u0000\u5c01\u0000\u6953\u0000\u98a8\u0000\u847a\u0000\u8557\u0000\u4f0f\u0000\u526f\u0000\u5fa9\u0000\u5e45\u0000\u670d\u0000\u798f\u0000\u8179\u0000\u8907\u0000\u8986\u0000\u6df5\u0000\u5f17\u0000\u6255\u0000\u6cb8\u0000\u4ecf\u0000\u7269\u0000\u9b92\u0000\u5206\u0000\u543b\u0000\u5674\u0000\u58b3\u0000\u61a4\u0000\u626e\u0000\u711a\u0000\u596e\u0000\u7c89\u0000\u7cde\u0000\u7d1b\u0000\u96f0\u0000\u6587\u0000\u805e\u0000\u4e19\u0000\u4f75\u0000\u5175\u0000\u5840\u0000\u5e63\u0000\u5e73\u0000\u5f0a\u0000\u67c4\u0000\u4e26\u0000\u853d\u0000\u9589\u0000\u965b\u0000\u7c73\u0000\u9801\u0000\u50fb\u0000\u58c1\u0000\u7656\u0000\u78a7\u0000\u5225\u0000\u77a5\u0000\u8511\u0000\u7b86\u0000\u504f\u0000\u5909\u0000\u7247\u0000\u7bc7\u0000\u7de8\u0000\u8fba\u0000\u8fd4\u0000\u904d\u0000\u4fbf\u0000\u52c9\u0000\u5a29\u0000\u5f01\u0000\u97ad\u0000\u4fdd\u0000\u8217\u0000\u92ea\u0000\u5703\u0000\u6355\u0000\u6b69\u0000\u752b\u0000\u88dc\u0000\u8f14\u0000\u7a42\u0000\u52df\u0000\u5893\u0000\u6155\u0000\u620a\u0000\u66ae\u0000\u6bcd\u0000\u7c3f\u0000\u83e9\u0000\u5023\u0000\u4ff8\u0000\u5305\u0000\u5446\u0000\u5831\u0000\u5949\u0000\u5b9d\u0000\u5cf0\u0000\u5cef\u0000\u5d29\u0000\u5e96\u0000\u62b1\u0000\u6367\u0000\u653e\u0000\u65b9\u0000\u670b\u0000\u6cd5\u0000\u6ce1\u0000\u70f9\u0000\u7832\u0000\u7e2b\u0000\u80de\u0000\u82b3\u0000\u840c\u0000\u84ec\u0000\u8702\u0000\u8912\u0000\u8a2a\u0000\u8c4a\u0000\u90a6\u0000\u92d2\u0000\u98fd\u0000\u9cf3\u0000\u9d6c\u0000\u4e4f\u0000\u4ea1\u0000\u508d\u0000\u5256\u0000\u574a\u0000\u59a8\u0000\u5e3d\u0000\u5fd8\u0000\u5fd9\u0000\u623f\u0000\u66b4\u0000\u671b\u0000\u67d0\u0000\u68d2\u0000\u5192\u0000\u7d21\u0000\u80aa\u0000\u81a8\u0000\u8b00\u0000\u8c8c\u0000\u8cbf\u0000\u927e\u0000\u9632\u0000\u5420\u0000\u982c\u0000\u5317\u0000\u50d5\u0000\u535c\u0000\u58a8\u0000\u64b2\u0000\u6734\u0000\u7267\u0000\u7766\u0000\u7a46\u0000\u91e6\u0000\u52c3\u0000\u6ca1\u0000\u6b86\u0000\u5800\u0000\u5e4c\u0000\u5954\u0000\u672c\u0000\u7ffb\u0000\u51e1\u0000\u76c6\u0000\u6469\u0000\u78e8\u0000\u9b54\u0000\u9ebb\u0000\u57cb\u0000\u59b9\u0000\u6627\u0000\u679a\u0000\u6bce\u0000\u54e9\u0000\u69d9\u0000\u5e55\u0000\u819c\u0000\u6795\u0000\u9baa\u0000\u67fe\u0000\u9c52\u0000\u685d\u0000\u4ea6\u0000\u4fe3\u0000\u53c8\u0000\u62b9\u0000\u672b\u0000\u6cab\u0000\u8fc4\u0000\u4fad\u0000\u7e6d\u0000\u9ebf\u0000\u4e07\u0000\u6162\u0000\u6e80\u0000\u6f2b\u0000\u8513\u0000\u5473\u0000\u672a\u0000\u9b45\u0000\u5df3\u0000\u7b95\u0000\u5cac\u0000\u5bc6\u0000\u871c\u0000\u6e4a\u0000\u84d1\u0000\u7a14\u0000\u8108\u0000\u5999\u0000\u7c8d\u0000\u6c11\u0000\u7720\u0000\u52d9\u0000\u5922\u0000\u7121\u0000\u725f\u0000\u77db\u0000\u9727\u0000\u9d61\u0000\u690b\u0000\u5a7f\u0000\u5a18\u0000\u51a5\u0000\u540d\u0000\u547d\u0000\u660e\u0000\u76df\u0000\u8ff7\u0000\u9298\u0000\u9cf4\u0000\u59ea\u0000\u725d\u0000\u6ec5\u0000\u514d\u0000\u68c9\u0000\u7dbf\u0000\u7dec\u0000\u9762\u0000\u9eba\u0000\u6478\u0000\u6a21\u0000\u8302\u0000\u5984\u0000\u5b5f\u0000\u6bdb\u0000\u731b\u0000\u76f2\u0000\u7db2\u0000\u8017\u0000\u8499\u0000\u5132\u0000\u6728\u0000\u9ed9\u0000\u76ee\u0000\u6762\u0000\u52ff\u0000\u9905\u0000\u5c24\u0000\u623b\u0000\u7c7e\u0000\u8cb0\u0000\u554f\u0000\u60b6\u0000\u7d0b\u0000\u9580\u0000\u5301\u0000\u4e5f\u0000\u51b6\u0000\u591c\u0000\u723a\u0000\u8036\u0000\u91ce\u0000\u5f25\u0000\u77e2\u0000\u5384\u0000\u5f79\u0000\u7d04\u0000\u85ac\u0000\u8a33\u0000\u8e8d\u0000\u9756\u0000\u67f3\u0000\u85ae\u0000\u9453\u0000\u6109\u0000\u6108\u0000\u6cb9\u0000\u7652\u0000\u8aed\u0000\u8f38\u0000\u552f\u0000\u4f51\u0000\u512a\u0000\u52c7\u0000\u53cb\u0000\u5ba5\u0000\u5e7d\u0000\u60a0\u0000\u6182\u0000\u63d6\u0000\u6709\u0000\u67da\u0000\u6e67\u0000\u6d8c\u0000\u7336\u0000\u7337\u0000\u7531\u0000\u7950\u0000\u88d5\u0000\u8a98\u0000\u904a\u0000\u9091\u0000\u90f5\u0000\u96c4\u0000\u878d\u0000\u5915\u0000\u4e88\u0000\u4f59\u0000\u4e0e\u0000\u8a89\u0000\u8f3f\u0000\u9810\u0000\u50ad\u0000\u5e7c\u0000\u5996\u0000\u5bb9\u0000\u5eb8\u0000\u63da\u0000\u63fa\u0000\u64c1\u0000\u66dc\u0000\u694a\u0000\u69d8\u0000\u6d0b\u0000\u6eb6\u0000\u7194\u0000\u7528\u0000\u7aaf\u0000\u7f8a\u0000\u8000\u0000\u8449\u0000\u84c9\u0000\u8981\u0000\u8b21\u0000\u8e0a\u0000\u9065\u0000\u967d\u0000\u990a\u0000\u617e\u0000\u6291\u0000\u6b32\u0000\u6c83\u0000\u6d74\u0000\u7fcc\u0000\u7ffc\u0000\u6dc0\u0000\u7f85\u0000\u87ba\u0000\u88f8\u0000\u6765\u0000\u83b1\u0000\u983c\u0000\u96f7\u0000\u6d1b\u0000\u7d61\u0000\u843d\u0000\u916a\u0000\u4e71\u0000\u5375\u0000\u5d50\u0000\u6b04\u0000\u6feb\u0000\u85cd\u0000\u862d\u0000\u89a7\u0000\u5229\u0000\u540f\u0000\u5c65\u0000\u674e\u0000\u68a8\u0000\u7406\u0000\u7483\u0000\u75e2\u0000\u88cf\u0000\u88e1\u0000\u91cc\u0000\u96e2\u0000\u9678\u0000\u5f8b\u0000\u7387\u0000\u7acb\u0000\u844e\u0000\u63a0\u0000\u7565\u0000\u5289\u0000\u6d41\u0000\u6e9c\u0000\u7409\u0000\u7559\u0000\u786b\u0000\u7c92\u0000\u9686\u0000\u7adc\u0000\u9f8d\u0000\u4fb6\u0000\u616e\u0000\u65c5\u0000\u865c\u0000\u4e86\u0000\u4eae\u0000\u50da\u0000\u4e21\u0000\u51cc\u0000\u5bee\u0000\u6599\u0000\u6881\u0000\u6dbc\u0000\u731f\u0000\u7642\u0000\u77ad\u0000\u7a1c\u0000\u7ce7\u0000\u826f\u0000\u8ad2\u0000\u907c\u0000\u91cf\u0000\u9675\u0000\u9818\u0000\u529b\u0000\u7dd1\u0000\u502b\u0000\u5398\u0000\u6797\u0000\u6dcb\u0000\u71d0\u0000\u7433\u0000\u81e8\u0000\u8f2a\u0000\u96a3\u0000\u9c57\u0000\u9e9f\u0000\u7460\u0000\u5841\u0000\u6d99\u0000\u7d2f\u0000\u985e\u0000\u4ee4\u0000\u4f36\u0000\u4f8b\u0000\u51b7\u0000\u52b1\u0000\u5dba\u0000\u601c\u0000\u73b2\u0000\u793c\u0000\u82d3\u0000\u9234\u0000\u96b7\u0000\u96f6\u0000\u970a\u0000\u9e97\u0000\u9f62\u0000\u66a6\u0000\u6b74\u0000\u5217\u0000\u52a3\u0000\u70c8\u0000\u88c2\u0000\u5ec9\u0000\u604b\u0000\u6190\u0000\u6f23\u0000\u7149\u0000\u7c3e\u0000\u7df4\u0000\u806f\u0000\u84ee\u0000\u9023\u0000\u932c\u0000\u5442\u0000\u9b6f\u0000\u6ad3\u0000\u7089\u0000\u8cc2\u0000\u8def\u0000\u9732\u0000\u52b4\u0000\u5a41\u0000\u5eca\u0000\u5f04\u0000\u6717\u0000\u697c\u0000\u6994\u0000\u6d6a\u0000\u6f0f\u0000\u7262\u0000\u72fc\u0000\u7bed\u0000\u8001\u0000\u807e\u0000\u874b\u0000\u90ce\u0000\u516d\u0000\u9e93\u0000\u7984\u0000\u808b\u0000\u9332\u0000\u8ad6\u0000\u502d\u0000\u548c\u0000\u8a71\u0000\u6b6a\u0000\u8cc4\u0000\u8107\u0000\u60d1\u0000\u67a0\u0000\u9df2\u0000\u4e99\u0000\u4e98\u0000\u9c10\u0000\u8a6b\u0000\u85c1\u0000\u8568\u0000\u6900\u0000\u6e7e\u0000\u7897\u0000\u8155\u0000x\u039f\u5b41\u0000\u5b56\u0000\u5b7d\u0000\u5b93\u0000\u5bd8\u0000\u5bec\u0000\u5c12\u0000\u5c1e\u0000\u5c23\u0000\u5c2b\u0000\u378d\u0000\u5c62\u0000\ufa3b\u0000\ufa3c\u0000{\u02b4\u5c7a\u0000\u5c8f\u0000\u5c9f\u0000\u5ca3\u0000\u5caa\u0000\u5cba\u0000\u5ccb\u0000\u5cd0\u0000\u5cd2\u0000\u5cf4\u0000}\u0234\u37e2\u0000\u5d0d\u0000\u5d27\u0000\ufa11\u0000\u5d46\u0000\u5d47\u0000\u5d53\u0000\u5d4a\u0000\u5d6d\u0000\u5d81\u0000\u5da0\u0000\u5da4\u0000\u5da7\u0000\u5db8\u0000\u5dcb\u0000\u541e\u0000\u5f0c\u0000\u4e10\u0000\u4e15\u0000\u4e2a\u0000\u4e31\u0000\u4e36\u0000\u4e3c\u0000\u4e3f\u0000\u4e42\u0000\u4e56\u0000\u4e58\u0000\u4e82\u0000\u4e85\u0000\u8c6b\u0000\u4e8a\u0000\u8212\u0000\u5f0d\u0000\u4e8e\u0000\u4e9e\u0000\u4e9f\u0000\u4ea0\u0000\u4ea2\u0000\u4eb0\u0000\u4eb3\u0000\u4eb6\u0000\u4ece\u0000\u4ecd\u0000\u4ec4\u0000\u4ec6\u0000\u4ec2\u0000\u4ed7\u0000\u4ede\u0000\u4eed\u0000\u4edf\u0000\u4ef7\u0000\u4f09\u0000\u4f5a\u0000\u4f30\u0000\u4f5b\u0000\u4f5d\u0000\u4f57\u0000\u4f47\u0000\u4f76\u0000\u4f88\u0000\u4f8f\u0000\u4f98\u0000\u4f7b\u0000\u4f69\u0000\u4f70\u0000\u4f91\u0000\u4f6f\u0000\u4f86\u0000\u4f96\u0000\u5118\u0000\u4fd4\u0000\u4fdf\u0000\u4fce\u0000\u4fd8\u0000\u4fdb\u0000\u4fd1\u0000\u4fda\u0000\u4fd0\u0000\u4fe4\u0000\u4fe5\u0000\u501a\u0000\u5028\u0000\u5014\u0000\u502a\u0000\u5025\u0000\u5005\u0000\u4f1c\u0000\u4ff6\u0000\u5021\u0000\u5029\u0000\u502c\u0000\u4ffe\u0000\u4fef\u0000\u5011\u0000\u5006\u0000\u5043\u0000\u5047\u0000\u6703\u0000\u5055\u0000\u5050\u0000\u5048\u0000\u505a\u0000\u5056\u0000\u506c\u0000\u5078\u0000\u5080\u0000\u509a\u0000\u5085\u0000\u50b4\u0000\u50b2\u0000\u50c9\u0000\u50ca\u0000\u50b3\u0000\u50c2\u0000\u50d6\u0000\u50de\u0000\u50e5\u0000\u50ed\u0000\u50e3\u0000\u50ee\u0000\u50f9\u0000\u50f5\u0000\u5109\u0000\u5101\u0000\u5102\u0000\u5116\u0000\u5115\u0000\u5114\u0000\u511a\u0000\u5121\u0000\u513a\u0000\u5137\u0000\u513c\u0000\u513b\u0000\u513f\u0000\u5140\u0000\u5152\u0000\u514c\u0000\u5154\u0000\u5162\u0000\u7af8\u0000\u5169\u0000\u516a\u0000\u516e\u0000\u5180\u0000\u5182\u0000\u56d8\u0000\u518c\u0000\u5189\u0000\u518f\u0000\u5191\u0000\u5193\u0000\u5195\u0000\u5196\u0000\u51a4\u0000\u51a6\u0000\u51a2\u0000\u51a9\u0000\u51aa\u0000\u51ab\u0000\u51b3\u0000\u51b1\u0000\u51b2\u0000\u51b0\u0000\u51b5\u0000\u51bd\u0000\u51c5\u0000\u51c9\u0000\u51db\u0000\u51e0\u0000\u8655\u0000\u51e9\u0000\u51ed\u0000\u51f0\u0000\u51f5\u0000\u51fe\u0000\u5204\u0000\u520b\u0000\u5214\u0000\u520e\u0000\u5227\u0000\u522a\u0000\u522e\u0000\u5233\u0000\u5239\u0000\u524f\u0000\u5244\u0000\u524b\u0000\u524c\u0000\u525e\u0000\u5254\u0000\u526a\u0000\u5274\u0000\u5269\u0000\u5273\u0000\u527f\u0000\u527d\u0000\u528d\u0000\u5294\u0000\u5292\u0000\u5271\u0000\u5288\u0000\u5291\u0000\u8fa8\u0000\u8fa7\u0000\u52ac\u0000\u52ad\u0000\u52bc\u0000\u52b5\u0000\u52c1\u0000\u52cd\u0000\u52d7\u0000\u52de\u0000\u52e3\u0000\u52e6\u0000\u98ed\u0000\u52e0\u0000\u52f3\u0000\u52f5\u0000\u52f8\u0000\u52f9\u0000\u5306\u0000\u5308\u0000\u7538\u0000\u530d\u0000\u5310\u0000\u530f\u0000\u5315\u0000\u531a\u0000\u5323\u0000\u532f\u0000\u5331\u0000\u5333\u0000\u5338\u0000\u5340\u0000\u5346\u0000\u5345\u0000\u4e17\u0000\u5349\u0000\u534d\u0000\u51d6\u0000\u535e\u0000\u5369\u0000\u536e\u0000\u5918\u0000\u537b\u0000\u5377\u0000\u5382\u0000\u5396\u0000\u53a0\u0000\u53a6\u0000\u53a5\u0000\u53ae\u0000\u53b0\u0000\u53b6\u0000\u53c3\u0000\u7c12\u0000\u96d9\u0000\u53df\u0000\u66fc\u0000\u71ee\u0000\u53ee\u0000\u53e8\u0000\u53ed\u0000\u53fa\u0000\u5401\u0000\u543d\u0000\u5440\u0000\u542c\u0000\u542d\u0000\u543c\u0000\u542e\u0000\u5436\u0000\u5429\u0000\u541d\u0000\u544e\u0000\u548f\u0000\u5475\u0000\u548e\u0000\u545f\u0000\u5471\u0000\u5477\u0000\u5470\u0000\u5492\u0000\u547b\u0000\u5480\u0000\u5476\u0000\u5484\u0000\u5490\u0000\u5486\u0000\u54c7\u0000\u54a2\u0000\u54b8\u0000\u54a5\u0000\u54ac\u0000\u54c4\u0000\u54c8\u0000\u54a8\u0000\u54ab\u0000\u54c2\u0000\u54a4\u0000\u54be\u0000\u54bc\u0000\u54d8\u0000\u54e5\u0000\u54e6\u0000\u550f\u0000\u5514\u0000\u54fd\u0000\u54ee\u0000\u54ed\u0000\u54fa\u0000\u54e2\u0000\u5539\u0000\u5540\u0000\u5563\u0000\u554c\u0000\u552e\u0000\u555c\u0000\u5545\u0000\u5556\u0000\u5557\u0000\u5538\u0000\u5533\u0000\u555d\u0000\u5599\u0000\u5580\u0000\u54af\u0000\u558a\u0000\u559f\u0000\u557b\u0000\u557e\u0000\u5598\u0000\u559e\u0000\u55ae\u0000\u557c\u0000\u5583\u0000\u55a9\u0000\u5587\u0000\u55a8\u0000\u55da\u0000\u55c5\u0000\u55df\u0000\u55c4\u0000\u55dc\u0000\u55e4\u0000\u55d4\u0000\u5614\u0000\u55f7\u0000\u5616\u0000\u55fe\u0000\u55fd\u0000\u561b\u0000\u55f9\u0000\u564e\u0000\u5650\u0000\u71df\u0000\u5634\u0000\u5636\u0000\u5632\u0000\u5638\u0000\u566b\u0000\u5664\u0000\u562f\u0000\u566c\u0000\u566a\u0000\u5686\u0000\u5680\u0000\u568a\u0000\u56a0\u0000\u5694\u0000\u568f\u0000\u56a5\u0000\u56ae\u0000\u56b6\u0000\u56b4\u0000\u56c2\u0000\u56bc\u0000\u56c1\u0000\u56c3\u0000\u56c0\u0000\u56c8\u0000\u56ce\u0000\u56d1\u0000\u56d3\u0000\u56d7\u0000\u56ee\u0000\u56f9\u0000\u5700\u0000\u56ff\u0000\u5704\u0000\u5709\u0000\u5708\u0000\u570b\u0000\u570d\u0000\u5713\u0000\u5718\u0000\u5716\u0000\u55c7\u0000\u571c\u0000\u5726\u0000\u5737\u0000\u5738\u0000\u574e\u0000\u573b\u0000\u5740\u0000\u574f\u0000\u5769\u0000\u57c0\u0000\u5788\u0000\u5761\u0000\u577f\u0000\u5789\u0000\u5793\u0000\u57a0\u0000\u57b3\u0000\u57a4\u0000\u57aa\u0000\u57b0\u0000\u57c3\u0000\u57c6\u0000\u57d4\u0000\u57d2\u0000\u57d3\u0000\u580a\u0000\u57d6\u0000\u57e3\u0000\u580b\u0000\u5819\u0000\u581d\u0000\u5872\u0000\u5821\u0000\u5862\u0000\u584b\u0000\u5870\u0000\u6bc0\u0000\u5852\u0000\u583d\u0000\u5879\u0000\u5885\u0000\u58b9\u0000\u589f\u0000\u58ab\u0000\u58ba\u0000\u58de\u0000\u58bb\u0000\u58b8\u0000\u58ae\u0000\u58c5\u0000\u58d3\u0000\u58d1\u0000\u58d7\u0000\u58d9\u0000\u58d8\u0000\u58e5\u0000\u58dc\u0000\u58e4\u0000\u58df\u0000\u58ef\u0000\u58fa\u0000\u58f9\u0000\u58fb\u0000\u58fc\u0000\u58fd\u0000\u5902\u0000\u590a\u0000\u5910\u0000\u591b\u0000\u68a6\u0000\u5925\u0000\u592c\u0000\u592d\u0000\u5932\u0000\u5938\u0000\u593e\u0000\u7ad2\u0000\u5955\u0000\u5950\u0000\u594e\u0000\u595a\u0000\u5958\u0000\u5962\u0000\u5960\u0000\u5967\u0000\u596c\u0000\u5969\u0000\u5978\u0000\u5981\u0000\u599d\u0000\u4f5e\u0000\u4fab\u0000\u59a3\u0000\u59b2\u0000\u59c6\u0000\u59e8\u0000\u59dc\u0000\u598d\u0000\u59d9\u0000\u59da\u0000\u5a25\u0000\u5a1f\u0000\u5a11\u0000\u5a1c\u0000\u5a09\u0000\u5a1a\u0000\u5a40\u0000\u5a6c\u0000\u5a49\u0000\u5a35\u0000\u5a36\u0000\u5a62\u0000\u5a6a\u0000\u5a9a\u0000\u5abc\u0000\u5abe\u0000\u5acb\u0000\u5ac2\u0000\u5abd\u0000\u5ae3\u0000\u5ad7\u0000\u5ae6\u0000\u5ae9\u0000\u5ad6\u0000\u5afa\u0000\u5afb\u0000\u5b0c\u0000\u5b0b\u0000\u5b16\u0000\u5b32\u0000\u5ad0\u0000\u5b2a\u0000\u5b36\u0000\u5b3e\u0000\u5b43\u0000\u5b45\u0000\u5b40\u0000\u5b51\u0000\u5b55\u0000\u5b5a\u0000\u5b5b\u0000\u5b65\u0000\u5b69\u0000\u5b70\u0000\u5b73\u0000\u5b75\u0000\u5b78\u0000\u6588\u0000\u5b7a\u0000\u5b80\u0000\u5b83\u0000\u5ba6\u0000\u5bb8\u0000\u5bc3\u0000\u5bc7\u0000\u5bc9\u0000\u5bd4\u0000\u5bd0\u0000\u5be4\u0000\u5be6\u0000\u5be2\u0000\u5bde\u0000\u5be5\u0000\u5beb\u0000\u5bf0\u0000\u5bf6\u0000\u5bf3\u0000\u5c05\u0000\u5c07\u0000\u5c08\u0000\u5c0d\u0000\u5c13\u0000\u5c20\u0000\u5c22\u0000\u5c28\u0000\u5c38\u0000\u5c39\u0000\u5c41\u0000\u5c46\u0000\u5c4e\u0000\u5c53\u0000\u5c50\u0000\u5c4f\u0000\u5b71\u0000\u5c6c\u0000\u5c6e\u0000\u4e62\u0000\u5c76\u0000\u5c79\u0000\u5c8c\u0000\u5c91\u0000\u5c94\u0000\u599b\u0000\u5cab\u0000\u5cbb\u0000\u5cb6\u0000\u5cbc\u0000\u5cb7\u0000\u5cc5\u0000\u5cbe\u0000\u5cc7\u0000\u5cd9\u0000\u5ce9\u0000\u5cfd\u0000\u5cfa\u0000\u5ced\u0000\u5d8c\u0000\u5cea\u0000\u5d0b\u0000\u5d15\u0000\u5d17\u0000\u5d5c\u0000\u5d1f\u0000\u5d1b\u0000\u5d11\u0000\u5d14\u0000\u5d22\u0000\u5d1a\u0000\u5d19\u0000\u5d18\u0000\u5d4c\u0000\u5d52\u0000\u5d4e\u0000\u5d4b\u0000\u5d6c\u0000\u5d73\u0000\u5d76\u0000\u5d87\u0000\u5d84\u0000\u5d82\u0000\u5da2\u0000\u5d9d\u0000\u5dac\u0000\u5dae\u0000\u5dbd\u0000\u5d90\u0000\u5db7\u0000\u5dbc\u0000\u5dc9\u0000\u5dcd\u0000\u5dd3\u0000\u5dd2\u0000\u5dd6\u0000\u5ddb\u0000\u5deb\u0000\u5df2\u0000\u5df5\u0000\u5e0b\u0000\u5e1a\u0000\u5e19\u0000\u5e11\u0000\u5e1b\u0000\u5e36\u0000\u5e37\u0000\u5e44\u0000\u5e43\u0000\u5e40\u0000\u5e4e\u0000\u5e57\u0000\u5e54\u0000\u5e5f\u0000\u5e62\u0000\u5e64\u0000\u5e47\u0000\u5e75\u0000\u5e76\u0000\u5e7a\u0000\u9ebc\u0000\u5e7f\u0000\u5ea0\u0000\u5ec1\u0000\u5ec2\u0000\u5ec8\u0000\u5ed0\u0000\u5ecf\u0000\u5ed6\u0000\u5ee3\u0000\u5edd\u0000\u5eda\u0000\u5edb\u0000\u5ee2\u0000\u5ee1\u0000\u5ee8\u0000\u5ee9\u0000\u5eec\u0000\u5ef1\u0000\u5ef3\u0000\u5ef0\u0000\u5ef4\u0000\u5ef8\u0000\u5efe\u0000\u5f03\u0000\u5f09\u0000\u5f5d\u0000\u5f5c\u0000\u5f0b\u0000\u5f11\u0000\u5f16\u0000\u5f29\u0000\u5f2d\u0000\u5f38\u0000\u5f41\u0000\u5f48\u0000\u5f4c\u0000\u5f4e\u0000\u5f2f\u0000\u5f51\u0000\u5f56\u0000\u5f57\u0000\u5f59\u0000\u5f61\u0000\u5f6d\u0000\u5f73\u0000\u5f77\u0000\u5f83\u0000\u5f82\u0000\u5f7f\u0000\u5f8a\u0000\u5f88\u0000\u5f91\u0000\u5f87\u0000\u5f9e\u0000\u5f99\u0000\u5f98\u0000\u5fa0\u0000\u5fa8\u0000\u5fad\u0000\u5fbc\u0000\u5fd6\u0000\u5ffb\u0000\u5fe4\u0000\u5ff8\u0000\u5ff1\u0000\u5fdd\u0000\u60b3\u0000\u5fff\u0000\u6021\u0000\u6060\u0000\u6019\u0000\u6010\u0000\u6029\u0000\u600e\u0000\u6031\u0000\u601b\u0000\u6015\u0000\u602b\u0000\u6026\u0000\u600f\u0000\u603a\u0000\u605a\u0000\u6041\u0000\u606a\u0000\u6077\u0000\u605f\u0000\u604a\u0000\u6046\u0000\u604d\u0000\u6063\u0000\u6043\u0000\u6064\u0000\u6042\u0000\u606c\u0000\u606b\u0000\u6059\u0000\u6081\u0000\u608d\u0000\u60e7\u0000\u6083\u0000\u609a\u0000\u6084\u0000\u609b\u0000\u6096\u0000\u6097\u0000\u6092\u0000\u60a7\u0000\u608b\u0000\u60e1\u0000\u60b8\u0000\u60e0\u0000\u60d3\u0000\u60b4\u0000\u5ff0\u0000\u60bd\u0000\u60c6\u0000\u60b5\u0000\u60d8\u0000\u614d\u0000\u6115\u0000\u6106\u0000\u60f6\u0000\u60f7\u0000\u6100\u0000\u60f4\u0000\u60fa\u0000\u6103\u0000\u6121\u0000\u60fb\u0000\u60f1\u0000\u610d\u0000\u610e\u0000\u6147\u0000\u613e\u0000\u6128\u0000\u6127\u0000\u614a\u0000\u613f\u0000\u613c\u0000\u612c\u0000\u6134\u0000\u613d\u0000\u6142\u0000\u6144\u0000\u6173\u0000\u6177\u0000\u6158\u0000\u6159\u0000\u615a\u0000\u616b\u0000\u6174\u0000\u616f\u0000\u6165\u0000\u6171\u0000\u615f\u0000\u615d\u0000\u6153\u0000\u6175\u0000\u6199\u0000\u6196\u0000\u6187\u0000\u61ac\u0000\u6194\u0000\u619a\u0000\u618a\u0000\u6191\u0000\u61ab\u0000\u61ae\u0000\u61cc\u0000\u61ca\u0000\u61c9\u0000\u61f7\u0000\u61c8\u0000\u61c3\u0000\u61c6\u0000\u61ba\u0000\u61cb\u0000\u7f79\u0000\u61cd\u0000\u61e6\u0000\u61e3\u0000\u61f6\u0000\u61fa\u0000\u61f4\u0000\u61ff\u0000\u61fd\u0000\u61fc\u0000\u61fe\u0000\u6200\u0000\u6208\u0000\u6209\u0000\u620d\u0000\u620c\u0000\u6214\u0000\u621b\u0000\u621e\u0000\u6221\u0000\u622a\u0000\u622e\u0000\u6230\u0000\u6232\u0000\u6233\u0000\u6241\u0000\u624e\u0000\u625e\u0000\u6263\u0000\u625b\u0000\u6260\u0000\u6268\u0000\u627c\u0000\u6282\u0000\u6289\u0000\u627e\u0000\u6292\u0000\u6293\u0000\u6296\u0000\u62d4\u0000\u6283\u0000\u6294\u0000\u62d7\u0000\u62d1\u0000\u62bb\u0000\u62cf\u0000\u62ff\u0000\u62c6\u0000\u64d4\u0000\u62c8\u0000\u62dc\u0000\u62cc\u0000\u62ca\u0000\u62c2\u0000\u62c7\u0000\u629b\u0000\u62c9\u0000\u630c\u0000\u62ee\u0000\u62f1\u0000\u6327\u0000\u6302\u0000\u6308\u0000\u62ef\u0000\u62f5\u0000\u6350\u0000\u633e\u0000\u634d\u0000\u641c\u0000\u634f\u0000\u6396\u0000\u638e\u0000\u6380\u0000\u63ab\u0000\u6376\u0000\u63a3\u0000\u638f\u0000\u6389\u0000\u639f\u0000\u63b5\u0000\u636b\u0000\u6369\u0000\u63be\u0000\u63e9\u0000\u63c0\u0000\u63c6\u0000\u63e3\u0000\u63c9\u0000\u63d2\u0000\u63f6\u0000\u63c4\u0000\u6416\u0000\u6434\u0000\u6406\u0000\u6413\u0000\u6426\u0000\u6436\u0000\u651d\u0000\u6417\u0000\u6428\u0000\u640f\u0000\u6467\u0000\u646f\u0000\u6476\u0000\u644e\u0000\u652a\u0000\u6495\u0000\u6493\u0000\u64a5\u0000\u64a9\u0000\u6488\u0000\u64bc\u0000\u64da\u0000\u64d2\u0000\u64c5\u0000\u64c7\u0000\u64bb\u0000\u64d8\u0000\u64c2\u0000\u64f1\u0000\u64e7\u0000\u8209\u0000\u64e0\u0000\u64e1\u0000\u62ac\u0000\u64e3\u0000\u64ef\u0000\u652c\u0000\u64f6\u0000\u64f4\u0000\u64f2\u0000\u64fa\u0000\u6500\u0000\u64fd\u0000\u6518\u0000\u651c\u0000\u6505\u0000\u6524\u0000\u6523\u0000\u652b\u0000\u6534\u0000\u6535\u0000\u6537\u0000\u6536\u0000\u6538\u0000\u754b\u0000\u6548\u0000\u6556\u0000\u6555\u0000\u654d\u0000\u6558\u0000\u655e\u0000\u655d\u0000\u6572\u0000\u6578\u0000\u6582\u0000\u6583\u0000\u8b8a\u0000\u659b\u0000\u659f\u0000\u65ab\u0000\u65b7\u0000\u65c3\u0000\u65c6\u0000\u65c1\u0000\u65c4\u0000\u65cc\u0000\u65d2\u0000\u65db\u0000\u65d9\u0000\u65e0\u0000\u65e1\u0000\u65f1\u0000\u6772\u0000\u660a\u0000\u6603\u0000\u65fb\u0000\u6773\u0000\u6635\u0000\u6636\u0000\u6634\u0000\u661c\u0000\u664f\u0000\u6644\u0000\u6649\u0000\u6641\u0000\u665e\u0000\u665d\u0000\u6664\u0000\u6667\u0000\u6668\u0000\u665f\u0000\u6662\u0000\u6670\u0000\u6683\u0000\u6688\u0000\u668e\u0000\u6689\u0000\u6684\u0000\u6698\u0000\u669d\u0000\u66c1\u0000\u66b9\u0000\u66c9\u0000\u66be\u0000\u66bc\u0000\u66c4\u0000\u66b8\u0000\u66d6\u0000\u66da\u0000\u66e0\u0000\u663f\u0000\u66e6\u0000\u66e9\u0000\u66f0\u0000\u66f5\u0000\u66f7\u0000\u670f\u0000\u6716\u0000\u671e\u0000\u6726\u0000\u6727\u0000\u9738\u0000\u672e\u0000\u673f\u0000\u6736\u0000\u6741\u0000\u6738\u0000\u6737\u0000\u6746\u0000\u675e\u0000\u6760\u0000\u6759\u0000\u6763\u0000\u6764\u0000\u6789\u0000\u6770\u0000\u67a9\u0000\u677c\u0000\u676a\u0000\u678c\u0000\u678b\u0000\u67a6\u0000\u67a1\u0000\u6785\u0000\u67b7\u0000\u67ef\u0000\u67b4\u0000\u67ec\u0000\u67b3\u0000\u67e9\u0000\u67b8\u0000\u67e4\u0000\u67de\u0000\u67dd\u0000\u67e2\u0000\u67ee\u0000\u67b9\u0000\u67ce\u0000\u67c6\u0000\u67e7\u0000\u6a9c\u0000\u681e\u0000\u6846\u0000\u6829\u0000\u6840\u0000\u684d\u0000\u6832\u0000\u684e\u0000\u68b3\u0000\u682b\u0000\u6859\u0000\u6863\u0000\u6877\u0000\u687f\u0000\u689f\u0000\u688f\u0000\u68ad\u0000\u6894\u0000\u689d\u0000\u689b\u0000\u6883\u0000\u6aae\u0000\u68b9\u0000\u6874\u0000\u68b5\u0000\u68a0\u0000\u68ba\u0000\u690f\u0000\u688d\u0000\u687e\u0000\u6901\u0000\u68ca\u0000\u6908\u0000\u68d8\u0000\u6922\u0000\u6926\u0000\u68e1\u0000\u690c\u0000\u68cd\u0000\u68d4\u0000\u68e7\u0000\u68d5\u0000\u6936\u0000\u6912\u0000\u6904\u0000\u68d7\u0000\u68e3\u0000\u6925\u0000\u68f9\u0000\u68e0\u0000\u68ef\u0000\u6928\u0000\u692a\u0000\u691a\u0000\u6923\u0000\u6921\u0000\u68c6\u0000\u6979\u0000\u6977\u0000\u695c\u0000\u6978\u0000\u696b\u0000\u6954\u0000\u697e\u0000\u696e\u0000\u6939\u0000\u6974\u0000\u693d\u0000\u6959\u0000\u6930\u0000\u6961\u0000\u695e\u0000\u695d\u0000\u6981\u0000\u696a\u0000\u69b2\u0000\u69ae\u0000\u69d0\u0000\u69bf\u0000\u69c1\u0000\u69d3\u0000\u69be\u0000\u69ce\u0000\u5be8\u0000\u69ca\u0000\u69dd\u0000\u69bb\u0000\u69c3\u0000\u69a7\u0000\u6a2e\u0000\u6991\u0000\u69a0\u0000\u699c\u0000\u6995\u0000\u69b4\u0000\u69de\u0000\u69e8\u0000\u6a02\u0000\u6a1b\u0000\u69ff\u0000\u6b0a\u0000\u69f9\u0000\u69f2\u0000\u69e7\u0000\u6a05\u0000\u69b1\u0000\u6a1e\u0000\u69ed\u0000\u6a14\u0000\u69eb\u0000\u6a0a\u0000\u6a12\u0000\u6ac1\u0000\u6a23\u0000\u6a13\u0000\u6a44\u0000\u6a0c\u0000\u6a72\u0000\u6a36\u0000\u6a78\u0000\u6a47\u0000\u6a62\u0000\u6a59\u0000\u6a66\u0000\u6a48\u0000\u6a38\u0000\u6a22\u0000\u6a90\u0000\u6a8d\u0000\u6aa0\u0000\u6a84\u0000\u6aa2\u0000\u6aa3\u0000\u6a97\u0000\u8617\u0000\u6abb\u0000\u6ac3\u0000\u6ac2\u0000\u6ab8\u0000\u6ab3\u0000\u6aac\u0000\u6ade\u0000\u6ad1\u0000\u6adf\u0000\u6aaa\u0000\u6ada\u0000\u6aea\u0000\u6afb\u0000\u6b05\u0000\u8616\u0000\u6afa\u0000\u6b12\u0000\u6b16\u0000\u9b31\u0000\u6b1f\u0000\u6b38\u0000\u6b37\u0000\u76dc\u0000\u6b39\u0000\u98ee\u0000\u6b47\u0000\u6b43\u0000\u6b49\u0000\u6b50\u0000\u6b59\u0000\u6b54\u0000\u6b5b\u0000\u6b5f\u0000\u6b61\u0000\u6b78\u0000\u6b79\u0000\u6b7f\u0000\u6b80\u0000\u6b84\u0000\u6b83\u0000\u6b8d\u0000\u6b98\u0000\u6b95\u0000\u6b9e\u0000\u6ba4\u0000\u6baa\u0000\u6bab\u0000\u6baf\u0000\u6bb2\u0000\u6bb1\u0000\u6bb3\u0000\u6bb7\u0000\u6bbc\u0000\u6bc6\u0000\u6bcb\u0000\u6bd3\u0000\u6bdf\u0000\u6bec\u0000\u6beb\u0000\u6bf3\u0000\u6bef\u0000\u9ebe\u0000\u6c08\u0000\u6c13\u0000\u6c14\u0000\u6c1b\u0000\u6c24\u0000\u6c23\u0000\u6c5e\u0000\u6c55\u0000\u6c62\u0000\u6c6a\u0000\u6c82\u0000\u6c8d\u0000\u6c9a\u0000\u6c81\u0000\u6c9b\u0000\u6c7e\u0000\u6c68\u0000\u6c73\u0000\u6c92\u0000\u6c90\u0000\u6cc4\u0000\u6cf1\u0000\u6cd3\u0000\u6cbd\u0000\u6cd7\u0000\u6cc5\u0000\u6cdd\u0000\u6cae\u0000\u6cb1\u0000\u6cbe\u0000\u6cba\u0000\u6cdb\u0000\u6cef\u0000\u6cd9\u0000\u6cea\u0000\u6d1f\u0000\u884d\u0000\u6d36\u0000\u6d2b\u0000\u6d3d\u0000\u6d38\u0000\u6d19\u0000\u6d35\u0000\u6d33\u0000\u6d12\u0000\u6d0c\u0000\u6d63\u0000\u6d93\u0000\u6d64\u0000\u6d5a\u0000\u6d79\u0000\u6d59\u0000\u6d8e\u0000\u6d95\u0000\u6fe4\u0000\u6d85\u0000\u6df9\u0000\u6e15\u0000\u6e0a\u0000\u6db5\u0000\u6dc7\u0000\u6de6\u0000\u6db8\u0000\u6dc6\u0000\u6dec\u0000\u6dde\u0000\u6dcc\u0000\u6de8\u0000\u6dd2\u0000\u6dc5\u0000\u6dfa\u0000\u6dd9\u0000\u6de4\u0000\u6dd5\u0000\u6dea\u0000\u6dee\u0000\u6e2d\u0000\u6e6e\u0000\u6e2e\u0000\u6e19\u0000\u6e72\u0000\u6e5f\u0000\u6e3e\u0000\u6e23\u0000\u6e6b\u0000\u6e2b\u0000\u6e76\u0000\u6e4d\u0000\u6e1f\u0000\u6e43\u0000\u6e3a\u0000\u6e4e\u0000\u6e24\u0000\u6eff\u0000\u6e1d\u0000\u6e38\u0000\u6e82\u0000\u6eaa\u0000\u6e98\u0000\u6ec9\u0000\u6eb7\u0000\u6ed3\u0000\u6ebd\u0000\u6eaf\u0000\u6ec4\u0000\u6eb2\u0000\u6ed4\u0000\u6ed5\u0000\u6e8f\u0000\u6ea5\u0000\u6ec2\u0000\u6e9f\u0000\u6f41\u0000\u6f11\u0000\u704c\u0000\u6eec\u0000\u6ef8\u0000\u6efe\u0000\u6f3f\u0000\u6ef2\u0000\u6f31\u0000\u6eef\u0000\u6f32\u0000\u6ecc\u0000\u6f3e\u0000\u6f13\u0000\u6ef7\u0000\u6f86\u0000\u6f7a\u0000\u6f78\u0000\u6f81\u0000\u6f80\u0000\u6f6f\u0000\u6f5b\u0000\u6ff3\u0000\u6f6d\u0000\u6f82\u0000\u6f7c\u0000\u6f58\u0000\u6f8e\u0000\u6f91\u0000\u6fc2\u0000\u6f66\u0000\u6fb3\u0000\u6fa3\u0000\u6fa1\u0000\u6fa4\u0000\u6fb9\u0000\u6fc6\u0000\u6faa\u0000\u6fdf\u0000\u6fd5\u0000\u6fec\u0000\u6fd4\u0000\u6fd8\u0000\u6ff1\u0000\u6fee\u0000\u6fdb\u0000\u7009\u0000\u700b\u0000\u6ffa\u0000\u7011\u0000\u7001\u0000\u700f\u0000\u6ffe\u0000\u701b\u0000\u701a\u0000\u6f74\u0000\u701d\u0000\u7018\u0000\u701f\u0000\u7030\u0000\u703e\u0000\u7032\u0000\u7051\u0000\u7063\u0000\u7099\u0000\u7092\u0000\u70af\u0000\u70f1\u0000\u70ac\u0000\u70b8\u0000\u70b3\u0000\u70ae\u0000\u70df\u0000\u70cb\u0000\u70dd\u0000\u70d9\u0000\u7109\u0000\u70fd\u0000\u711c\u0000\u7119\u0000\u7165\u0000\u7155\u0000\u7188\u0000\u7166\u0000\u7162\u0000\u714c\u0000\u7156\u0000\u716c\u0000\u718f\u0000\u71fb\u0000\u7184\u0000\u7195\u0000\u71a8\u0000\u71ac\u0000\u71d7\u0000\u71b9\u0000\u71be\u0000\u71d2\u0000\u71c9\u0000\u71d4\u0000\u71ce\u0000\u71e0\u0000\u71ec\u0000\u71e7\u0000\u71f5\u0000\u71fc\u0000\u71f9\u0000\u71ff\u0000\u720d\u0000\u7210\u0000\u721b\u0000\u7228\u0000\u722d\u0000\u722c\u0000\u7230\u0000\u7232\u0000\u723b\u0000\u723c\u0000\u723f\u0000\u7240\u0000\u7246\u0000\u724b\u0000\u7258\u0000\u7274\u0000\u727e\u0000\u7282\u0000\u7281\u0000\u7287\u0000\u7292\u0000\u7296\u0000\u72a2\u0000\u72a7\u0000\u72b9\u0000\u72b2\u0000\u72c3\u0000\u72c6\u0000\u72c4\u0000\u72ce\u0000\u72d2\u0000\u72e2\u0000\u72e0\u0000\u72e1\u0000\u72f9\u0000\u72f7\u0000\u500f\u0000\u7317\u0000\u730a\u0000\u731c\u0000\u7316\u0000\u731d\u0000\u7334\u0000\u732f\u0000\u7329\u0000\u7325\u0000\u733e\u0000\u734e\u0000\u734f\u0000\u9ed8\u0000\u7357\u0000\u736a\u0000\u7368\u0000\u7370\u0000\u7378\u0000\u7375\u0000\u737b\u0000\u737a\u0000\u73c8\u0000\u73b3\u0000\u73ce\u0000\u73bb\u0000\u73c0\u0000\u73e5\u0000\u73ee\u0000\u73de\u0000\u74a2\u0000\u7405\u0000\u746f\u0000\u7425\u0000\u73f8\u0000\u7432\u0000\u743a\u0000\u7455\u0000\u743f\u0000\u745f\u0000\u7459\u0000\u7441\u0000\u745c\u0000\u7469\u0000\u7470\u0000\u7463\u0000\u746a\u0000\u7476\u0000\u747e\u0000\u748b\u0000\u749e\u0000\u74a7\u0000\u74ca\u0000\u74cf\u0000\u74d4\u0000\u73f1\u0000\u74e0\u0000\u74e3\u0000\u74e7\u0000\u74e9\u0000\u74ee\u0000\u74f2\u0000\u74f0\u0000\u74f1\u0000\u74f8\u0000\u74f7\u0000\u7504\u0000\u7503\u0000\u7505\u0000\u750c\u0000\u750e\u0000\u750d\u0000\u7515\u0000\u7513\u0000\u751e\u0000\u7526\u0000\u752c\u0000\u753c\u0000\u7544\u0000\u754d\u0000\u754a\u0000\u7549\u0000\u755b\u0000\u7546\u0000\u755a\u0000\u7569\u0000\u7564\u0000\u7567\u0000\u756b\u0000\u756d\u0000\u7578\u0000\u7576\u0000\u7586\u0000\u7587\u0000\u7574\u0000\u758a\u0000\u7589\u0000\u7582\u0000\u7594\u0000\u759a\u0000\u759d\u0000\u75a5\u0000\u75a3\u0000\u75c2\u0000\u75b3\u0000\u75c3\u0000\u75b5\u0000\u75bd\u0000\u75b8\u0000\u75bc\u0000\u75b1\u0000\u75cd\u0000\u75ca\u0000\u75d2\u0000\u75d9\u0000\u75e3\u0000\u75de\u0000\u75fe\u0000\u75ff\u0000\u75fc\u0000\u7601\u0000\u75f0\u0000\u75fa\u0000\u75f2\u0000\u75f3\u0000\u760b\u0000\u760d\u0000\u7609\u0000\u761f\u0000\u7627\u0000\u7620\u0000\u7621\u0000\u7622\u0000\u7624\u0000\u7634\u0000\u7630\u0000\u763b\u0000\u7647\u0000\u7648\u0000\u7646\u0000\u765c\u0000\u7658\u0000\u7661\u0000\u7662\u0000\u7668\u0000\u7669\u0000\u766a\u0000\u7667\u0000\u766c\u0000\u7670\u0000\u7672\u0000\u7676\u0000\u7678\u0000\u767c\u0000\u7680\u0000\u7683\u0000\u7688\u0000\u768b\u0000\u768e\u0000\u7696\u0000\u7693\u0000\u7699\u0000\u769a\u0000\u76b0\u0000\u76b4\u0000\u76b8\u0000\u76b9\u0000\u76ba\u0000\u76c2\u0000\u76cd\u0000\u76d6\u0000\u76d2\u0000\u76de\u0000\u76e1\u0000\u76e5\u0000\u76e7\u0000\u76ea\u0000\u862f\u0000\u76fb\u0000\u7708\u0000\u7707\u0000\u7704\u0000\u7729\u0000\u7724\u0000\u771e\u0000\u7725\u0000\u7726\u0000\u771b\u0000\u7737\u0000\u7738\u0000\u7747\u0000\u775a\u0000\u7768\u0000\u776b\u0000\u775b\u0000\u7765\u0000\u777f\u0000\u777e\u0000\u7779\u0000\u778e\u0000\u778b\u0000\u7791\u0000\u77a0\u0000\u779e\u0000\u77b0\u0000\u77b6\u0000\u77b9\u0000\u77bf\u0000\u77bc\u0000\u77bd\u0000\u77bb\u0000\u77c7\u0000\u77cd\u0000\u77d7\u0000\u77da\u0000\u77dc\u0000\u77e3\u0000\u77ee\u0000\u77fc\u0000\u780c\u0000\u7812\u0000\u7926\u0000\u7820\u0000\u792a\u0000\u7845\u0000\u788e\u0000\u7874\u0000\u7886\u0000\u787c\u0000\u789a\u0000\u788c\u0000\u78a3\u0000\u78b5\u0000\u78aa\u0000\u78af\u0000\u78d1\u0000\u78c6\u0000\u78cb\u0000\u78d4\u0000\u78be\u0000\u78bc\u0000\u78c5\u0000\u78ca\u0000\u78ec\u0000\u78e7\u0000\u78da\u0000\u78fd\u0000\u78f4\u0000\u7907\u0000\u7912\u0000\u7911\u0000\u7919\u0000\u792c\u0000\u792b\u0000\u7940\u0000\u7960\u0000\u7957\u0000\u795f\u0000\u795a\u0000\u7955\u0000\u7953\u0000\u797a\u0000\u797f\u0000\u798a\u0000\u799d\u0000\u79a7\u0000\u9f4b\u0000\u79aa\u0000\u79ae\u0000\u79b3\u0000\u79b9\u0000\u79ba\u0000\u79c9\u0000\u79d5\u0000\u79e7\u0000\u79ec\u0000\u79e1\u0000\u79e3\u0000\u7a08\u0000\u7a0d\u0000\u7a18\u0000\u7a19\u0000\u7a20\u0000\u7a1f\u0000\u7980\u0000\u7a31\u0000\u7a3b\u0000\u7a3e\u0000\u7a37\u0000\u7a43\u0000\u7a57\u0000\u7a49\u0000\u7a61\u0000\u7a62\u0000\u7a69\u0000\u9f9d\u0000\u7a70\u0000\u7a79\u0000\u7a7d\u0000\u7a88\u0000\u7a97\u0000\u7a95\u0000\u7a98\u0000\u7a96\u0000\u7aa9\u0000\u7ac8\u0000\u7ab0\u0000\u7ab6\u0000\u7ac5\u0000\u7ac4\u0000\u7abf\u0000\u9083\u0000\u7ac7\u0000\u7aca\u0000\u7acd\u0000\u7acf\u0000\u7ad5\u0000\u7ad3\u0000\u7ad9\u0000\u7ada\u0000\u7add\u0000\u7ae1\u0000\u7ae2\u0000\u7ae6\u0000\u7aed\u0000\u7af0\u0000\u7b02\u0000\u7b0f\u0000\u7b0a\u0000\u7b06\u0000\u7b33\u0000\u7b18\u0000\u7b19\u0000\u7b1e\u0000\u7b35\u0000\u7b28\u0000\u7b36\u0000\u7b50\u0000\u7b7a\u0000\u7b04\u0000\u7b4d\u0000\u7b0b\u0000\u7b4c\u0000\u7b45\u0000\u7b75\u0000\u7b65\u0000\u7b74\u0000\u7b67\u0000\u7b70\u0000\u7b71\u0000\u7b6c\u0000\u7b6e\u0000\u7b9d\u0000\u7b98\u0000\u7b9f\u0000\u7b8d\u0000\u7b9c\u0000\u7b9a\u0000\u7b8b\u0000\u7b92\u0000\u7b8f\u0000\u7b5d\u0000\u7b99\u0000\u7bcb\u0000\u7bc1\u0000\u7bcc\u0000\u7bcf\u0000\u7bb4\u0000\u7bc6\u0000\u7bdd\u0000\u7be9\u0000\u7c11\u0000\u7c14\u0000\u7be6\u0000\u7be5\u0000\u7c60\u0000\u7c00\u0000\u7c07\u0000\u7c13\u0000\u7bf3\u0000\u7bf7\u0000\u7c17\u0000\u7c0d\u0000\u7bf6\u0000\u7c23\u0000\u7c27\u0000\u7c2a\u0000\u7c1f\u0000\u7c37\u0000\u7c2b\u0000\u7c3d\u0000\u7c4c\u0000\u7c43\u0000\u7c54\u0000\u7c4f\u0000\u7c40\u0000\u7c50\u0000\u7c58\u0000\u7c5f\u0000\u7c64\u0000\u7c56\u0000\u7c65\u0000\u7c6c\u0000\u7c75\u0000\u7c83\u0000\u7c90\u0000\u7ca4\u0000\u7cad\u0000\u7ca2\u0000\u7cab\u0000\u7ca1\u0000\u7ca8\u0000\u7cb3\u0000\u7cb2\u0000\u7cb1\u0000\u7cae\u0000\u7cb9\u0000\u7cbd\u0000\u7cc0\u0000\u7cc5\u0000\u7cc2\u0000\u7cd8\u0000\u7cd2\u0000\u7cdc\u0000\u7ce2\u0000\u9b3b\u0000\u7cef\u0000\u7cf2\u0000\u7cf4\u0000\u7cf6\u0000\u7cfa\u0000\u7d06\u0000\u7d02\u0000\u7d1c\u0000\u7d15\u0000\u7d0a\u0000\u7d45\u0000\u7d4b\u0000\u7d2e\u0000\u7d32\u0000\u7d3f\u0000\u7d35\u0000\u7d46\u0000\u7d73\u0000\u7d56\u0000\u7d4e\u0000\u7d72\u0000\u7d68\u0000\u7d6e\u0000\u7d4f\u0000\u7d63\u0000\u7d93\u0000\u7d89\u0000\u7d5b\u0000\u7d8f\u0000\u7d7d\u0000\u7d9b\u0000\u7dba\u0000\u7dae\u0000\u7da3\u0000\u7db5\u0000\u7dc7\u0000\u7dbd\u0000\u7dab\u0000\u7e3d\u0000\u7da2\u0000\u7daf\u0000\u7ddc\u0000\u7db8\u0000\u7d9f\u0000\u7db0\u0000\u7dd8\u0000\u7ddd\u0000\u7de4\u0000\u7dde\u0000\u7dfb\u0000\u7df2\u0000\u7de1\u0000\u7e05\u0000\u7e0a\u0000\u7e23\u0000\u7e21\u0000\u7e12\u0000\u7e31\u0000\u7e1f\u0000\u7e09\u0000\u7e0b\u0000\u7e22\u0000\u7e46\u0000\u7e66\u0000\u7e3b\u0000\u7e35\u0000\u7e39\u0000\u7e43\u0000\u7e37\u0000\u7e32\u0000\u7e3a\u0000\u7e67\u0000\u7e5d\u0000\u7e56\u0000\u7e5e\u0000\u7e59\u0000\u7e5a\u0000\u7e79\u0000\u7e6a\u0000\u7e69\u0000\u7e7c\u0000\u7e7b\u0000\u7e83\u0000\u7dd5\u0000\u7e7d\u0000\u8fae\u0000\u7e7f\u0000\u7e88\u0000\u7e89\u0000\u7e8c\u0000\u7e92\u0000\u7e90\u0000\u7e93\u0000\u7e94\u0000\u7e96\u0000\u7e8e\u0000\u7e9b\u0000\u7e9c\u0000\u7f38\u0000\u7f3a\u0000\u7f45\u0000\u7f4c\u0000\u7f4d\u0000\u7f4e\u0000\u7f50\u0000\u7f51\u0000\u7f55\u0000\u7f54\u0000\u7f58\u0000\u7f5f\u0000\u7f60\u0000\u7f68\u0000\u7f69\u0000\u7f67\u0000\u7f78\u0000\u7f82\u0000\u7f86\u0000\u7f83\u0000\u7f88\u0000\u7f87\u0000\u7f8c\u0000\u7f94\u0000\u7f9e\u0000\u7f9d\u0000\u7f9a\u0000\u7fa3\u0000\u7faf\u0000\u7fb2\u0000\u7fb9\u0000\u7fae\u0000\u7fb6\u0000\u7fb8\u0000\u8b71\u0000\u7fc5\u0000\u7fc6\u0000\u7fca\u0000\u7fd5\u0000\u7fd4\u0000\u7fe1\u0000\u7fe6\u0000\u7fe9\u0000\u7ff3\u0000\u7ff9\u0000\u98dc\u0000\u8006\u0000\u8004\u0000\u800b\u0000\u8012\u0000\u8018\u0000\u8019\u0000\u801c\u0000\u8021\u0000\u8028\u0000\u803f\u0000\u803b\u0000\u804a\u0000\u8046\u0000\u8052\u0000\u8058\u0000\u805a\u0000\u805f\u0000\u8062\u0000\u8068\u0000\u8073\u0000\u8072\u0000\u8070\u0000\u8076\u0000\u8079\u0000\u807d\u0000\u807f\u0000\u8084\u0000\u8086\u0000\u8085\u0000\u809b\u0000\u8093\u0000\u809a\u0000\u80ad\u0000\u5190\u0000\u80ac\u0000\u80db\u0000\u80e5\u0000\u80d9\u0000\u80dd\u0000\u80c4\u0000\u80da\u0000\u80d6\u0000\u8109\u0000\u80ef\u0000\u80f1\u0000\u811b\u0000\u8129\u0000\u8123\u0000\u812f\u0000\u814b\u0000\u968b\u0000\u8146\u0000\u813e\u0000\u8153\u0000\u8151\u0000\u80fc\u0000\u8171\u0000\u816e\u0000\u8165\u0000\u8166\u0000\u8174\u0000\u8183\u0000\u8188\u0000\u818a\u0000\u8180\u0000\u8182\u0000\u81a0\u0000\u8195\u0000\u81a4\u0000\u81a3\u0000\u815f\u0000\u8193\u0000\u81a9\u0000\u81b0\u0000\u81b5\u0000\u81be\u0000\u81b8\u0000\u81bd\u0000\u81c0\u0000\u81c2\u0000\u81ba\u0000\u81c9\u0000\u81cd\u0000\u81d1\u0000\u81d9\u0000\u81d8\u0000\u81c8\u0000\u81da\u0000\u81df\u0000\u81e0\u0000\u81e7\u0000\u81fa\u0000\u81fb\u0000\u81fe\u0000\u8201\u0000\u8202\u0000\u8205\u0000\u8207\u0000\u820a\u0000\u820d\u0000\u8210\u0000\u8216\u0000\u8229\u0000\u822b\u0000\u8238\u0000\u8233\u0000\u8240\u0000\u8259\u0000\u8258\u0000\u825d\u0000\u825a\u0000\u825f\u0000\u8264\u0000\u8262\u0000\u8268\u0000\u826a\u0000\u826b\u0000\u822e\u0000\u8271\u0000\u8277\u0000\u8278\u0000\u827e\u0000\u828d\u0000\u8292\u0000\u82ab\u0000\u829f\u0000\u82bb\u0000\u82ac\u0000\u82e1\u0000\u82e3\u0000\u82df\u0000\u82d2\u0000\u82f4\u0000\u82f3\u0000\u82fa\u0000\u8393\u0000\u8303\u0000\u82fb\u0000\u82f9\u0000\u82de\u0000\u8306\u0000\u82dc\u0000\u8309\u0000\u82d9\u0000\u8335\u0000\u8334\u0000\u8316\u0000\u8332\u0000\u8331\u0000\u8340\u0000\u8339\u0000\u8350\u0000\u8345\u0000\u832f\u0000\u832b\u0000\u8317\u0000\u8318\u0000\u8385\u0000\u839a\u0000\u83aa\u0000\u839f\u0000\u83a2\u0000\u8396\u0000\u8323\u0000\u838e\u0000\u8387\u0000\u838a\u0000\u837c\u0000\u83b5\u0000\u8373\u0000\u8375\u0000\u83a0\u0000\u8389\u0000\u83a8\u0000\u83f4\u0000\u8413\u0000\u83eb\u0000\u83ce\u0000\u83fd\u0000\u8403\u0000\u83d8\u0000\u840b\u0000\u83c1\u0000\u83f7\u0000\u8407\u0000\u83e0\u0000\u83f2\u0000\u840d\u0000\u8422\u0000\u8420\u0000\u83bd\u0000\u8438\u0000\u8506\u0000\u83fb\u0000\u846d\u0000\u842a\u0000\u843c\u0000\u855a\u0000\u8484\u0000\u8477\u0000\u846b\u0000\u84ad\u0000\u846e\u0000\u8482\u0000\u8469\u0000\u8446\u0000\u842c\u0000\u846f\u0000\u8479\u0000\u8435\u0000\u84ca\u0000\u8462\u0000\u84b9\u0000\u84bf\u0000\u849f\u0000\u84d9\u0000\u84cd\u0000\u84bb\u0000\u84da\u0000\u84d0\u0000\u84c1\u0000\u84c6\u0000\u84d6\u0000\u84a1\u0000\u8521\u0000\u84ff\u0000\u84f4\u0000\u8517\u0000\u8518\u0000\u852c\u0000\u851f\u0000\u8515\u0000\u8514\u0000\u84fc\u0000\u8540\u0000\u8563\u0000\u8558\u0000\u8548\u0000\u8541\u0000\u8602\u0000\u854b\u0000\u8555\u0000\u8580\u0000\u85a4\u0000\u8588\u0000\u8591\u0000\u858a\u0000\u85a8\u0000\u856d\u0000\u8594\u0000\u859b\u0000\u85ea\u0000\u8587\u0000\u859c\u0000\u8577\u0000\u857e\u0000\u8590\u0000\u85c9\u0000\u85ba\u0000\u85cf\u0000\u85b9\u0000\u85d0\u0000\u85d5\u0000\u85dd\u0000\u85e5\u0000\u85dc\u0000\u85f9\u0000\u860a\u0000\u8613\u0000\u860b\u0000\u85fe\u0000\u85fa\u0000\u8606\u0000\u8622\u0000\u861a\u0000\u8630\u0000\u863f\u0000\u864d\u0000\u4e55\u0000\u8654\u0000\u865f\u0000\u8667\u0000\u8671\u0000\u8693\u0000\u86a3\u0000\u86a9\u0000\u86aa\u0000\u868b\u0000\u868c\u0000\u86b6\u0000\u86af\u0000\u86c4\u0000\u86c6\u0000\u86b0\u0000\u86c9\u0000\u8823\u0000\u86ab\u0000\u86d4\u0000\u86de\u0000\u86e9\u0000\u86ec\u0000\u86df\u0000\u86db\u0000\u86ef\u0000\u8712\u0000\u8706\u0000\u8708\u0000\u8700\u0000\u8703\u0000\u86fb\u0000\u8711\u0000\u8709\u0000\u870d\u0000\u86f9\u0000\u870a\u0000\u8734\u0000\u873f\u0000\u8737\u0000\u873b\u0000\u8725\u0000\u8729\u0000\u871a\u0000\u8760\u0000\u875f\u0000\u8778\u0000\u874c\u0000\u874e\u0000\u8774\u0000\u8757\u0000\u8768\u0000\u876e\u0000\u8759\u0000\u8753\u0000\u8763\u0000\u876a\u0000\u8805\u0000\u87a2\u0000\u879f\u0000\u8782\u0000\u87af\u0000\u87cb\u0000\u87bd\u0000\u87c0\u0000\u87d0\u0000\u96d6\u0000\u87ab\u0000\u87c4\u0000\u87b3\u0000\u87c7\u0000\u87c6\u0000\u87bb\u0000\u87ef\u0000\u87f2\u0000\u87e0\u0000\u880f\u0000\u880d\u0000\u87fe\u0000\u87f6\u0000\u87f7\u0000\u880e\u0000\u87d2\u0000\u8811\u0000\u8816\u0000\u8815\u0000\u8822\u0000\u8821\u0000\u8831\u0000\u8836\u0000\u8839\u0000\u8827\u0000\u883b\u0000\u8844\u0000\u8842\u0000\u8852\u0000\u8859\u0000\u885e\u0000\u8862\u0000\u886b\u0000\u8881\u0000\u887e\u0000\u889e\u0000\u8875\u0000\u887d\u0000\u88b5\u0000\u8872\u0000\u8882\u0000\u8897\u0000\u8892\u0000\u88ae\u0000\u8899\u0000\u88a2\u0000\u888d\u0000\u88a4\u0000\u88b0\u0000\u88bf\u0000\u88b1\u0000\u88c3\u0000\u88c4\u0000\u88d4\u0000\u88d8\u0000\u88d9\u0000\u88dd\u0000\u88f9\u0000\u8902\u0000\u88fc\u0000\u88f4\u0000\u88e8\u0000\u88f2\u0000\u8904\u0000\u890c\u0000\u890a\u0000\u8913\u0000\u8943\u0000\u891e\u0000\u8925\u0000\u892a\u0000\u892b\u0000\u8941\u0000\u8944\u0000\u893b\u0000\u8936\u0000\u8938\u0000\u894c\u0000\u891d\u0000\u8960\u0000\u895e\u0000\u8966\u0000\u8964\u0000\u896d\u0000\u896a\u0000\u896f\u0000\u8974\u0000\u8977\u0000\u897e\u0000\u8983\u0000\u8988\u0000\u898a\u0000\u8993\u0000\u8998\u0000\u89a1\u0000\u89a9\u0000\u89a6\u0000\u89ac\u0000\u89af\u0000\u89b2\u0000\u89ba\u0000\u89bd\u0000\u89bf\u0000\u89c0\u0000\u89da\u0000\u89dc\u0000\u89dd\u0000\u89e7\u0000\u89f4\u0000\u89f8\u0000\u8a03\u0000\u8a16\u0000\u8a10\u0000\u8a0c\u0000\u8a1b\u0000\u8a1d\u0000\u8a25\u0000\u8a36\u0000\u8a41\u0000\u8a5b\u0000\u8a52\u0000\u8a46\u0000\u8a48\u0000\u8a7c\u0000\u8a6d\u0000\u8a6c\u0000\u8a62\u0000\u8a85\u0000\u8a82\u0000\u8a84\u0000\u8aa8\u0000\u8aa1\u0000\u8a91\u0000\u8aa5\u0000\u8aa6\u0000\u8a9a\u0000\u8aa3\u0000\u8ac4\u0000\u8acd\u0000\u8ac2\u0000\u8ada\u0000\u8aeb\u0000\u8af3\u0000\u8ae7\u0000\u8ae4\u0000\u8af1\u0000\u8b14\u0000\u8ae0\u0000\u8ae2\u0000\u8af7\u0000\u8ade\u0000\u8adb\u0000\u8b0c\u0000\u8b07\u0000\u8b1a\u0000\u8ae1\u0000\u8b16\u0000\u8b10\u0000\u8b17\u0000\u8b20\u0000\u8b33\u0000\u97ab\u0000\u8b26\u0000\u8b2b\u0000\u8b3e\u0000\u8b28\u0000\u8b41\u0000\u8b4c\u0000\u8b4f\u0000\u8b4e\u0000\u8b49\u0000\u8b56\u0000\u8b5b\u0000\u8b5a\u0000\u8b6b\u0000\u8b5f\u0000\u8b6c\u0000\u8b6f\u0000\u8b74\u0000\u8b7d\u0000\u8b80\u0000\u8b8c\u0000\u8b8e\u0000\u8b92\u0000\u8b93\u0000\u8b96\u0000\u8b99\u0000\u8b9a\u0000\u8c3a\u0000\u8c41\u0000\u8c3f\u0000\u8c48\u0000\u8c4c\u0000\u8c4e\u0000\u8c50\u0000\u8c55\u0000\u8c62\u0000\u8c6c\u0000\u8c78\u0000\u8c7a\u0000\u8c82\u0000\u8c89\u0000\u8c85\u0000\u8c8a\u0000\u8c8d\u0000\u8c8e\u0000\u8c94\u0000\u8c7c\u0000\u8c98\u0000\u621d\u0000\u8cad\u0000\u8caa\u0000\u8cbd\u0000\u8cb2\u0000\u8cb3\u0000\u8cae\u0000\u8cb6\u0000\u8cc8\u0000\u8cc1\u0000\u8ce4\u0000\u8ce3\u0000\u8cda\u0000\u8cfd\u0000\u8cfa\u0000\u8cfb\u0000\u8d04\u0000\u8d05\u0000\u8d0a\u0000\u8d07\u0000\u8d0f\u0000\u8d0d\u0000\u8d10\u0000\u9f4e\u0000\u8d13\u0000\u8ccd\u0000\u8d14\u0000\u8d16\u0000\u8d67\u0000\u8d6d\u0000\u8d71\u0000\u8d73\u0000\u8d81\u0000\u8d99\u0000\u8dc2\u0000\u8dbe\u0000\u8dba\u0000\u8dcf\u0000\u8dda\u0000\u8dd6\u0000\u8dcc\u0000\u8ddb\u0000\u8dcb\u0000\u8dea\u0000\u8deb\u0000\u8ddf\u0000\u8de3\u0000\u8dfc\u0000\u8e08\u0000\u8e09\u0000\u8dff\u0000\u8e1d\u0000\u8e1e\u0000\u8e10\u0000\u8e1f\u0000\u8e42\u0000\u8e35\u0000\u8e30\u0000\u8e34\u0000\u8e4a\u0000\u8e47\u0000\u8e49\u0000\u8e4c\u0000\u8e50\u0000\u8e48\u0000\u8e59\u0000\u8e64\u0000\u8e60\u0000\u8e2a\u0000\u8e63\u0000\u8e55\u0000\u8e76\u0000\u8e72\u0000\u8e7c\u0000\u8e81\u0000\u8e87\u0000\u8e85\u0000\u8e84\u0000\u8e8b\u0000\u8e8a\u0000\u8e93\u0000\u8e91\u0000\u8e94\u0000\u8e99\u0000\u8eaa\u0000\u8ea1\u0000\u8eac\u0000\u8eb0\u0000\u8ec6\u0000\u8eb1\u0000\u8ebe\u0000\u8ec5\u0000\u8ec8\u0000\u8ecb\u0000\u8edb\u0000\u8ee3\u0000\u8efc\u0000\u8efb\u0000\u8eeb\u0000\u8efe\u0000\u8f0a\u0000\u8f05\u0000\u8f15\u0000\u8f12\u0000\u8f19\u0000\u8f13\u0000\u8f1c\u0000\u8f1f\u0000\u8f1b\u0000\u8f0c\u0000\u8f26\u0000\u8f33\u0000\u8f3b\u0000\u8f39\u0000\u8f45\u0000\u8f42\u0000\u8f3e\u0000\u8f4c\u0000\u8f49\u0000\u8f46\u0000\u8f4e\u0000\u8f57\u0000\u8f5c\u0000\u8f62\u0000\u8f63\u0000\u8f64\u0000\u8f9c\u0000\u8f9f\u0000\u8fa3\u0000\u8fad\u0000\u8faf\u0000\u8fb7\u0000\u8fda\u0000\u8fe5\u0000\u8fe2\u0000\u8fea\u0000\u8fef\u0000\u9087\u0000\u8ff4\u0000\u9005\u0000\u8ff9\u0000\u8ffa\u0000\u9011\u0000\u9015\u0000\u9021\u0000\u900d\u0000\u901e\u0000\u9016\u0000\u900b\u0000\u9027\u0000\u9036\u0000\u9035\u0000\u9039\u0000\u8ff8\u0000\u904f\u0000\u9050\u0000\u9051\u0000\u9052\u0000\u900e\u0000\u9049\u0000\u903e\u0000\u9056\u0000\u9058\u0000\u905e\u0000\u9068\u0000\u906f\u0000\u9076\u0000\u96a8\u0000\u9072\u0000\u9082\u0000\u907d\u0000\u9081\u0000\u9080\u0000\u908a\u0000\u9089\u0000\u908f\u0000\u90a8\u0000\u90af\u0000\u90b1\u0000\u90b5\u0000\u90e2\u0000\u90e4\u0000\u6248\u0000\u90db\u0000\u9102\u0000\u9112\u0000\u9119\u0000\u9132\u0000\u9130\u0000\u914a\u0000\u9156\u0000\u9158\u0000\u9163\u0000\u9165\u0000\u9169\u0000\u9173\u0000\u9172\u0000\u918b\u0000\u9189\u0000\u9182\u0000\u91a2\u0000\u91ab\u0000\u91af\u0000\u91aa\u0000\u91b5\u0000\u91b4\u0000\u91ba\u0000\u91c0\u0000\u91c1\u0000\u91c9\u0000\u91cb\u0000\u91d0\u0000\u91d6\u0000\u91df\u0000\u91e1\u0000\u91db\u0000\u91fc\u0000\u91f5\u0000\u91f6\u0000\u921e\u0000\u91ff\u0000\u9214\u0000\u922c\u0000\u9215\u0000\u9211\u0000\u925e\u0000\u9257\u0000\u9245\u0000\u9249\u0000\u9264\u0000\u9248\u0000\u9295\u0000\u923f\u0000\u924b\u0000\u9250\u0000\u929c\u0000\u9296\u0000\u9293\u0000\u929b\u0000\u925a\u0000\u92cf\u0000\u92b9\u0000\u92b7\u0000\u92e9\u0000\u930f\u0000\u92fa\u0000\u9344\u0000\u932e\u0000\u9319\u0000\u9322\u0000\u931a\u0000\u9323\u0000\u933a\u0000\u9335\u0000\u933b\u0000\u935c\u0000\u9360\u0000\u937c\u0000\u936e\u0000\u9356\u0000\u93b0\u0000\u93ac\u0000\u93ad\u0000\u9394\u0000\u93b9\u0000\u93d6\u0000\u93d7\u0000\u93e8\u0000\u93e5\u0000\u93d8\u0000\u93c3\u0000\u93dd\u0000\u93d0\u0000\u93c8\u0000\u93e4\u0000\u941a\u0000\u9414\u0000\u9413\u0000\u9403\u0000\u9407\u0000\u9410\u0000\u9436\u0000\u942b\u0000\u9435\u0000\u9421\u0000\u943a\u0000\u9441\u0000\u9452\u0000\u9444\u0000\u945b\u0000\u9460\u0000\u9462\u0000\u945e\u0000\u946a\u0000\u9229\u0000\u9470\u0000\u9475\u0000\u9477\u0000\u947d\u0000\u945a\u0000\u947c\u0000\u947e\u0000\u9481\u0000\u947f\u0000\u9582\u0000\u9587\u0000\u958a\u0000\u9594\u0000\u9596\u0000\u9598\u0000\u9599\u0000\u95a0\u0000\u95a8\u0000\u95a7\u0000\u95ad\u0000\u95bc\u0000\u95bb\u0000\u95b9\u0000\u95be\u0000\u95ca\u0000\u6ff6\u0000\u95c3\u0000\u95cd\u0000\u95cc\u0000\u95d5\u0000\u95d4\u0000\u95d6\u0000\u95dc\u0000\u95e1\u0000\u95e5\u0000\u95e2\u0000\u9621\u0000\u9628\u0000\u962e\u0000\u962f\u0000\u9642\u0000\u964c\u0000\u964f\u0000\u964b\u0000\u9677\u0000\u965c\u0000\u965e\u0000\u965d\u0000\u965f\u0000\u9666\u0000\u9672\u0000\u966c\u0000\u968d\u0000\u9698\u0000\u9695\u0000\u9697\u0000\u96aa\u0000\u96a7\u0000\u96b1\u0000\u96b2\u0000\u96b0\u0000\u96b4\u0000\u96b6\u0000\u96b8\u0000\u96b9\u0000\u96ce\u0000\u96cb\u0000\u96c9\u0000\u96cd\u0000\u894d\u0000\u96dc\u0000\u970d\u0000\u96d5\u0000\u96f9\u0000\u9704\u0000\u9706\u0000\u9708\u0000\u9713\u0000\u970e\u0000\u9711\u0000\u970f\u0000\u9716\u0000\u9719\u0000\u9724\u0000\u972a\u0000\u9730\u0000\u9739\u0000\u973d\u0000\u973e\u0000\u9744\u0000\u9746\u0000\u9748\u0000\u9742\u0000\u9749\u0000\u975c\u0000\u9760\u0000\u9764\u0000\u9766\u0000\u9768\u0000\u52d2\u0000\u976b\u0000\u9771\u0000\u9779\u0000\u9785\u0000\u977c\u0000\u9781\u0000\u977a\u0000\u9786\u0000\u978b\u0000\u978f\u0000\u9790\u0000\u979c\u0000\u97a8\u0000\u97a6\u0000\u97a3\u0000\u97b3\u0000\u97b4\u0000\u97c3\u0000\u97c6\u0000\u97c8\u0000\u97cb\u0000\u97dc\u0000\u97ed\u0000\u9f4f\u0000\u97f2\u0000\u7adf\u0000\u97f6\u0000\u97f5\u0000\u980f\u0000\u980c\u0000\u9838\u0000\u9824\u0000\u9821\u0000\u9837\u0000\u983d\u0000\u9846\u0000\u984f\u0000\u984b\u0000\u986b\u0000\u986f\u0000\u9870\u0000\u9871\u0000\u9874\u0000\u9873\u0000\u98aa\u0000\u98af\u0000\u98b1\u0000\u98b6\u0000\u98c4\u0000\u98c3\u0000\u98c6\u0000\u98e9\u0000\u98eb\u0000\u9903\u0000\u9909\u0000\u9912\u0000\u9914\u0000\u9918\u0000\u9921\u0000\u991d\u0000\u991e\u0000\u9924\u0000\u9920\u0000\u992c\u0000\u992e\u0000\u993d\u0000\u993e\u0000\u9942\u0000\u9949\u0000\u9945\u0000\u9950\u0000\u994b\u0000\u9951\u0000\u9952\u0000\u994c\u0000\u9955\u0000\u9997\u0000\u9998\u0000\u99a5\u0000\u99ad\u0000\u99ae\u0000\u99bc\u0000\u99df\u0000\u99db\u0000\u99dd\u0000\u99d8\u0000\u99d1\u0000\u99ed\u0000\u99ee\u0000\u99f1\u0000\u99f2\u0000\u99fb\u0000\u99f8\u0000\u9a01\u0000\u9a0f\u0000\u9a05\u0000\u99e2\u0000\u9a19\u0000\u9a2b\u0000\u9a37\u0000\u9a45\u0000\u9a42\u0000\u9a40\u0000\u9a43\u0000\u9a3e\u0000\u9a55\u0000\u9a4d\u0000\u9a5b\u0000\u9a57\u0000\u9a5f\u0000\u9a62\u0000\u9a65\u0000\u9a64\u0000\u9a69\u0000\u9a6b\u0000\u9a6a\u0000\u9aad\u0000\u9ab0\u0000\u9abc\u0000\u9ac0\u0000\u9acf\u0000\u9ad1\u0000\u9ad3\u0000\u9ad4\u0000\u9ade\u0000\u9adf\u0000\u9ae2\u0000\u9ae3\u0000\u9ae6\u0000\u9aef\u0000\u9aeb\u0000\u9aee\u0000\u9af4\u0000\u9af1\u0000\u9af7\u0000\u9afb\u0000\u9b06\u0000\u9b18\u0000\u9b1a\u0000\u9b1f\u0000\u9b22\u0000\u9b23\u0000\u9b25\u0000\u9b27\u0000\u9b28\u0000\u9b29\u0000\u9b2a\u0000\u9b2e\u0000\u9b2f\u0000\u9b32\u0000\u9b44\u0000\u9b43\u0000\u9b4f\u0000\u9b4d\u0000\u9b4e\u0000\u9b51\u0000\u9b58\u0000\u9b74\u0000\u9b93\u0000\u9b83\u0000\u9b91\u0000\u9b96\u0000\u9b97\u0000\u9b9f\u0000\u9ba0\u0000\u9ba8\u0000\u9bb4\u0000\u9bc0\u0000\u9bca\u0000\u9bb9\u0000\u9bc6\u0000\u9bcf\u0000\u9bd1\u0000\u9bd2\u0000\u9be3\u0000\u9be2\u0000\u9be4\u0000\u9bd4\u0000\u9be1\u0000\u9c3a\u0000\u9bf2\u0000\u9bf1\u0000\u9bf0\u0000\u9c15\u0000\u9c14\u0000\u9c09\u0000\u9c13\u0000\u9c0c\u0000\u9c06\u0000\u9c08\u0000\u9c12\u0000\u9c0a\u0000\u9c04\u0000\u9c2e\u0000\u9c1b\u0000\u9c25\u0000\u9c24\u0000\u9c21\u0000\u9c30\u0000\u9c47\u0000\u9c32\u0000\u9c46\u0000\u9c3e\u0000\u9c5a\u0000\u9c60\u0000\u9c67\u0000\u9c76\u0000\u9c78\u0000\u9ce7\u0000\u9cec\u0000\u9cf0\u0000\u9d09\u0000\u9d08\u0000\u9ceb\u0000\u9d03\u0000\u9d06\u0000\u9d2a\u0000\u9d26\u0000\u9daf\u0000\u9d23\u0000\u9d1f\u0000\u9d44\u0000\u9d15\u0000\u9d12\u0000\u9d41\u0000\u9d3f\u0000\u9d3e\u0000\u9d46\u0000\u9d48\u0000\u9d5d\u0000\u9d5e\u0000\u9d64\u0000\u9d51\u0000\u9d50\u0000\u9d59\u0000\u9d72\u0000\u9d89\u0000\u9d87\u0000\u9dab\u0000\u9d6f\u0000\u9d7a\u0000\u9d9a\u0000\u9da4\u0000\u9da9\u0000\u9db2\u0000\u9dc4\u0000\u9dc1\u0000\u9dbb\u0000\u9db8\u0000\u9dba\u0000\u9dc6\u0000\u9dcf\u0000\u9dc2\u0000\u9dd9\u0000\u9dd3\u0000\u9df8\u0000\u9de6\u0000\u9ded\u0000\u9def\u0000\u9dfd\u0000\u9e1a\u0000\u9e1b\u0000\u9e1e\u0000\u9e75\u0000\u9e79\u0000\u9e7d\u0000\u9e81\u0000\u9e88\u0000\u9e8b\u0000\u9e8c\u0000\u9e92\u0000\u9e95\u0000\u9e91\u0000\u9e9d\u0000\u9ea5\u0000\u9ea9\u0000\u9eb8\u0000\u9eaa\u0000\u9ead\u0000\u9761\u0000\u9ecc\u0000\u9ece\u0000\u9ecf\u0000\u9ed0\u0000\u9ed4\u0000\u9edc\u0000\u9ede\u0000\u9edd\u0000\u9ee0\u0000\u9ee5\u0000\u9ee8\u0000\u9eef\u0000\u9ef4\u0000\u9ef6\u0000\u9ef7\u0000\u9ef9\u0000\u9efb\u0000\u9efc\u0000\u9efd\u0000\u9f07\u0000\u9f08\u0000\u76b7\u0000\u9f15\u0000\u9f21\u0000\u9f2c\u0000\u9f3e\u0000\u9f4a\u0000\u9f52\u0000\u9f54\u0000\u9f63\u0000\u9f5f\u0000\u9f60\u0000\u9f61\u0000\u9f66\u0000\u9f67\u0000\u9f6c\u0000\u9f6a\u0000\u9f77\u0000\u9f72\u0000\u9f76\u0000\u9f95\u0000\u9f9c\u0000\u9fa0\u0000\u582f\u0000\u69c7\u0000\u9059\u0000\u7464\u0000\u51dc\u0000\u7199\u0000\u5653\u0000\u5de2\u0000\u5e14\u0000\u5e18\u0000\u5e58\u0000\u5e5e\u0000\u5ebe\u0000\uf928\u0000\u5ecb\u0000\u5ef9\u0000\u5f00\u0000\u5f02\u0000\u5f07\u0000\u5f1d\u0000\u5f23\u0000\u5f34\u0000\u5f36\u0000\u5f3d\u0000\u5f40\u0000\u5f45\u0000\u5f54\u0000\u5f58\u0000\u5f64\u0000\u5f67\u0000\u5f7d\u0000\u5f89\u0000\u5f9c\u0000\u5fa7\u0000\u5faf\u0000\u5fb5\u0000\u5fb7\u0000\u5fc9\u0000\u5fde\u0000\u5fe1\u0000\u5fe9\u0000\u600d\u0000\u6014\u0000\u6018\u0000\u6033\u0000\u6035\u0000\u6047\u0000\ufa3d\u0000\u609d\u0000\u609e\u0000\u60cb\u0000\u60d4\u0000\u60d5\u0000\u60dd\u0000\u60f8\u0000\u611c\u0000\u612b\u0000\u6130\u0000\u6137\u0000\ufa3e\u0000\u618d\u0000\ufa3f\u0000\u61bc\u0000\u61b9\u0000\ufa40\u0000\u6222\u0000\u623e\u0000\u6243\u0000\u6256\u0000\u625a\u0000\u626f\u0000\u6285\u0000\u62c4\u0000\u62d6\u0000\u62fc\u0000\u630a\u0000\u6318\u0000\u6339\u0000\u6343\u0000\u6365\u0000\u637c\u0000\u63e5\u0000\u63ed\u0000\u63f5\u0000\u6410\u0000\u6414\u0000\u6422\u0000\u6479\u0000\u6451\u0000\u6460\u0000\u646d\u0000\u64ce\u0000\u64be\u0000\u64bf\u0000\u64c4\u0000\u64ca\u0000\u64d0\u0000\u64f7\u0000\u64fb\u0000\u6522\u0000\u6529\u0000\ufa41\u0000\u6567\u0000\u659d\u0000\ufa42\u0000\u6600\u0000\u6609\u0000\u6615\u0000\u661e\u0000\u663a\u0000\u6622\u0000\u6624\u0000\u662b\u0000\u6630\u0000\u6631\u0000\u6633\u0000\u66fb\u0000\u6648\u0000\u664c\u0000\u0082\u01c4\u6659\u0000\u665a\u0000\u6661\u0000\u6665\u0000\u6673\u0000\u6677\u0000\u6678\u0000\u668d\u0000\ufa43\u0000\u66a0\u0000\u66b2\u0000\u66bb\u0000\u66c6\u0000\u66c8\u0000\u3b22\u0000\u66db\u0000\u66e8\u0000\u66fa\u0000\u6713\u0000\uf929\u0000\u6733\u0000\u6766\u0000\u6747\u0000\u6748\u0000\u677b\u0000\u6781\u0000\u6793\u0000\u6798\u0000\u679b\u0000\u67bb\u0000\u67f9\u0000\u67c0\u0000\u67d7\u0000\u67fc\u0000\u6801\u0000\u6852\u0000\u681d\u0000\u682c\u0000\u6831\u0000\u685b\u0000\u6872\u0000\u6875\u0000\ufa44\u0000\u68a3\u0000\u68a5\u0000\u68b2\u0000\u68c8\u0000\u68d0\u0000\u68e8\u0000\u68ed\u0000\u68f0\u0000\u68f1\u0000\u68fc\u0000\u690a\u0000\u6949\u0000\u0083\u01c4\u6935\u0000\u6942\u0000\u6957\u0000\u6963\u0000\u6964\u0000\u6968\u0000\u6980\u0000\ufa14\u0000\u69a5\u0000\u69ad\u0000\u69cf\u0000\u3bb6\u0000\u3bc3\u0000\u69e2\u0000\u69e9\u0000\u69ea\u0000\u69f5\u0000\u69f6\u0000\u6a0f\u0000\u6a15\u0000\u0083\u033f\u6a3b\u0000\u6a3e\u0000\u6a45\u0000\u6a50\u0000\u6a56\u0000\u6a5b\u0000\u6a6b\u0000\u6a73\u0000\u0083\u0363\u6a89\u0000\u6a94\u0000\u6a9d\u0000\u6a9e\u0000\u6aa5\u0000\u6ae4\u0000\u6ae7\u0000\u3c0f\u0000\uf91d\u0000\u6b1b\u0000\u6b1e\u0000\u6b2c\u0000\u6b35\u0000\u6b46\u0000\u6b56\u0000\u6b60\u0000\u6b65\u0000\u6b67\u0000\u6b77\u0000\u6b82\u0000\u6ba9\u0000\u6bad\u0000\uf970\u0000\u6bcf\u0000\u6bd6\u0000\u6bd7\u0000\u6bff\u0000\u6c05\u0000\u6c10\u0000\u6c33\u0000\u6c59\u0000\u6c5c\u0000\u6caa\u0000\u6c74\u0000\u6c76\u0000\u6c85\u0000\u6c86\u0000\u6c98\u0000\u6c9c\u0000\u6cfb\u0000\u6cc6\u0000\u6cd4\u0000\u6ce0\u0000\u6ceb\u0000\u6cee\u0000\u0085\u00fe\u6d04\u0000\u6d0e\u0000\u6d2e\u0000\u6d31\u0000\u6d39\u0000\u6d3f\u0000\u6d58\u0000\u6d65\u0000\ufa45\u0000\u6d82\u0000\u6d87\u0000\u6d89\u0000\u6d94\u0000\u6daa\u0000\u6dac\u0000\u6dbf\u0000\u6dc4\u0000\u6dd6\u0000\u6dda\u0000\u6ddb\u0000\u6ddd\u0000\u6dfc\u0000\ufa46\u0000\u6e34\u0000\u6e44\u0000\u6e5c\u0000\u6e5e\u0000\u6eab\u0000\u6eb1\u0000\u6ec1\u0000\u6ec7\u0000\u6ece\u0000\u6f10\u0000\u6f1a\u0000\ufa47\u0000\u6f2a\u0000\u6f2f\u0000\u6f33\u0000\u6f51\u0000\u6f59\u0000\u6f5e\u0000\u6f61\u0000\u6f62\u0000\u6f7e\u0000\u6f88\u0000\u6f8c\u0000\u6f8d\u0000\u6f94\u0000\u6fa0\u0000\u6fa7\u0000\u6fb6\u0000\u6fbc\u0000\u6fc7\u0000\u6fca\u0000\u6ff9\u0000\u6ff0\u0000\u6ff5\u0000\u7005\u0000\u7006\u0000\u7028\u0000\u704a\u0000\u705d\u0000\u705e\u0000\u704e\u0000\u7064\u0000\u7075\u0000\u7085\u0000\u70a4\u0000\u70ab\u0000\u70b7\u0000\u70d4\u0000\u70d8\u0000\u70e4\u0000\u710f\u0000\u712b\u0000\u711e\u0000\u7120\u0000\u712e\u0000\u7130\u0000\u7146\u0000\u7147\u0000\u7151\u0000\ufa48\u0000\u7152\u0000\u715c\u0000\u7160\u0000\u7168\u0000\ufa15\u0000\u7185\u0000\u7187\u0000\u7192\u0000\u71c1\u0000\u71ba\u0000\u71c4\u0000\u71fe\u0000\u7200\u0000\u7215\u0000\u7255\u0000\u7256\u0000\u3e3f\u0000\u728d\u0000\u729b\u0000\u72be\u0000\u72c0\u0000\u72fb\u0000\u0087\u03f1\u7327\u0000\u7328\u0000\ufa16\u0000\u7350\u0000\u7366\u0000\u737c\u0000\u7395\u0000\u739f\u0000\u73a0\u0000\u73a2\u0000\u73a6\u0000\u73ab\u0000\u73c9\u0000\u73cf\u0000\u73d6\u0000\u73d9\u0000\u73e3\u0000\u73e9\u0000\u7407\u0000\u740a\u0000\u741a\u0000\u741b\u0000\ufa4a\u0000\u7426\u0000\u7428\u0000\u742a\u0000\u742b\u0000\u742c\u0000\u742e\u0000\u742f\u0000\u7430\u0000\u7444\u0000\u7446\u0000\u7447\u0000\u744b\u0000\u7457\u0000\u7462\u0000\u746b\u0000\u746d\u0000\u7486\u0000\u7487\u0000\u7489\u0000\u7498\u0000\u749c\u0000\u749f\u0000\u74a3\u0000\u7490\u0000\u74a6\u0000\u74a8\u0000\u74a9\u0000\u74b5\u0000\u74bf\u0000\u74c8\u0000\u74c9\u0000\u74da\u0000\u74ff\u0000\u7501\u0000\u7517\u0000\u752f\u0000\u756f\u0000\u7579\u0000\u7592\u0000\u3f72\u0000\u75ce\u0000\u75e4\u0000\u7600\u0000\u7602\u0000\u7608\u0000\u7615\u0000\u7616\u0000\u7619\u0000\u761e\u0000\u762d\u0000\u7635\u0000\u7643\u0000\u764b\u0000\u7664\u0000\u7665\u0000\u766d\u0000\u766f\u0000\u7671\u0000\u7681\u0000\u769b\u0000\u769d\u0000\u769e\u0000\u76a6\u0000\u76aa\u0000\u76b6\u0000\u76c5\u0000\u76cc\u0000\u76ce\u0000\u76d4\u0000\u76e6\u0000\u76f1\u0000\u76fc\u0000\u770a\u0000\u7719\u0000\u7734\u0000\u7736\u0000\u7746\u0000\u774d\u0000\u774e\u0000\u775c\u0000\u775f\u0000\u7762\u0000\u777a\u0000\u7780\u0000\u7794\u0000\u77aa\u0000\u77e0\u0000\u782d\u0000\u008b\u008e\u7843\u0000\u784e\u0000\u784f\u0000\u7851\u0000\u7868\u0000\u786e\u0000\ufa4b\u0000\u78b0\u0000\u008b\u010e\u78ad\u0000\u78e4\u0000\u78f2\u0000\u7900\u0000\u78f7\u0000\u791c\u0000\u792e\u0000\u7931\u0000\u7934\u0000\ufa4c\u0000\ufa4d\u0000\u7945\u0000\u7946\u0000\ufa4e\u0000\ufa4f\u0000\ufa50\u0000\u795c\u0000\ufa51\u0000\ufa19\u0000\ufa1a\u0000\u7979\u0000\ufa52\u0000\ufa53\u0000\ufa1b\u0000\u7998\u0000\u79b1\u0000\u79b8\u0000\u79c8\u0000\u79ca\u0000\u008b\u0371\u79d4\u0000\u79de\u0000\u79eb\u0000\u79ed\u0000\u7a03\u0000\ufa54\u0000\u7a39\u0000\u7a5d\u0000\u7a6d\u0000\ufa55\u0000\u7a85\u0000\u7aa0\u0000\u008c\u01c4\u7ab3\u0000\u7abb\u0000\u7ace\u0000\u7aeb\u0000\u7afd\u0000\u7b12\u0000\u7b2d\u0000\u7b3b\u0000\u7b47\u0000\u7b4e\u0000\u7b60\u0000\u7b6d\u0000\u7b6f\u0000\u7b72\u0000\u7b9e\u0000\ufa56\u0000\u7bd7\u0000\u7bd9\u0000\u7c01\u0000\u7c31\u0000\u7c1e\u0000\u7c20\u0000\u7c33\u0000\u7c36\u0000\u4264\u0000\u008d\u01a1\u7c59\u0000\u7c6d\u0000\u7c79\u0000\u7c8f\u0000\u7c94\u0000\u7ca0\u0000\u7cbc\u0000\u7cd5\u0000\u7cd9\u0000\u7cdd\u0000\u7d07\u0000\u7d08\u0000\u7d13\u0000\u7d1d\u0000\u7d23\u0000\u7d31\u0000\u7d41\u0000\u7d48\u0000\u7d53\u0000\u7d5c\u0000\u7d7a\u0000\u7d83\u0000\u7d8b\u0000\u7da0\u0000\u7da6\u0000\u7dc2\u0000\u7dcc\u0000\u7dd6\u0000\u7de3\u0000\ufa57\u0000\u7e28\u0000\u7e08\u0000\u7e11\u0000\u7e15\u0000\ufa59\u0000\u7e47\u0000\u7e52\u0000\u7e61\u0000\u7e8a\u0000\u7e8d\u0000\u7f47\u0000\ufa5a\u0000\u7f91\u0000\u7f97\u0000\u7fbf\u0000\u7fce\u0000\u7fdb\u0000\u7fdf\u0000\u7fec\u0000\u7fee\u0000\u7ffa\u0000\ufa5b\u0000\u8014\u0000\u8026\u0000\u8035\u0000\u8037\u0000\u803c\u0000\u80ca\u0000\u80d7\u0000\u80e0\u0000\u80f3\u0000\u8118\u0000\u814a\u0000\u8160\u0000\u8167\u0000\u8168\u0000\u816d\u0000\u81bb\u0000\u81ca\u0000\u81cf\u0000\u81d7\u0000\ufa5c\u0000\u4453\u0000\u445b\u0000\u8260\u0000\u8274\u0000\u0090\u02ff\u828e\u0000\u82a1\u0000\u82a3\u0000\u82a4\u0000\u82a9\u0000\u82ae\u0000\u82b7\u0000\u82be\u0000\u82bf\u0000\u82c6\u0000\u82d5\u0000\u82fd\u0000\u82fe\u0000\u8300\u0000\u8301\u0000\u8362\u0000\u8322\u0000\u832d\u0000\u833a\u0000\u8343\u0000\u8347\u0000\u8351\u0000\u8355\u0000\u837d\u0000\u8386\u0000\u8392\u0000\u8398\u0000\u83a7\u0000\u83a9\u0000\u83bf\u0000\u83c0\u0000\u83c7\u0000\u83cf\u0000\u83d1\u0000\u83e1\u0000\u83ea\u0000\u8401\u0000\u8406\u0000\u840a\u0000\ufa5f\u0000\u8448\u0000\u845f\u0000\u8470\u0000\u8473\u0000\u8485\u0000\u849e\u0000\u84af\u0000\u84b4\u0000\u84ba\u0000\u84c0\u0000\u84c2\u0000\u0091\u0240\u8532\u0000\u851e\u0000\u8523\u0000\u852f\u0000\u8559\u0000\u8564\u0000\ufa1f\u0000\u85ad\u0000\u857a\u0000\u858c\u0000\u858f\u0000\u85a2\u0000\u85b0\u0000\u85cb\u0000\u85ce\u0000\u85ed\u0000\u8612\u0000\u85ff\u0000\u8604\u0000\u8605\u0000\u8610\u0000\u0092\u00f4\u8618\u0000\u8629\u0000\u8638\u0000\u8657\u0000\u865b\u0000\uf936\u0000\u8662\u0000\u459d\u0000\u866c\u0000\u8675\u0000\u8698\u0000\u86b8\u0000\u86fa\u0000\u86fc\u0000\u86fd\u0000\u870b\u0000\u8771\u0000\u8787\u0000\u8788\u0000\u87ac\u0000\u87ad\u0000\u87b5\u0000\u45ea\u0000\u87d6\u0000\u87ec\u0000\u8806\u0000\u880a\u0000\u8810\u0000\u8814\u0000\u881f\u0000\u8898\u0000\u88aa\u0000\u88ca\u0000\u88ce\u0000\u0093\u0284\u88f5\u0000\u891c\u0000\ufa60\u0000\u8918\u0000\u8919\u0000\u891a\u0000\u8927\u0000\u8930\u0000\u8932\u0000\u8939\u0000\u8940\u0000\u8994\u0000\ufa61\u0000\u89d4\u0000\u89e5\u0000\u89f6\u0000\u8a12\u0000\u8a15\u0000\u8a22\u0000\u8a37\u0000\u8a47\u0000\u8a4e\u0000\u8a5d\u0000\u8a61\u0000\u8a75\u0000\u8a79\u0000\u8aa7\u0000\u8ad0\u0000\u8adf\u0000\u8af4\u0000\u8af6\u0000\ufa22\u0000\ufa62\u0000\ufa63\u0000\u8b46\u0000\u8b54\u0000\u8b59\u0000\u8b69\u0000\u8b9d\u0000\u8c49\u0000\u8c68\u0000\ufa64\u0000\u8ce1\u0000\u8cf4\u0000\u8cf8\u0000\u8cfe\u0000\ufa65\u0000\u8d12\u0000\u8d1b\u0000\u8daf\u0000\u8dce\u0000\u8dd1\u0000\u8dd7\u0000\u8e20\u0000\u8e23\u0000\u8e3d\u0000\u8e70\u0000\u8e7b\u0000\u0096\u0277\u8ec0\u0000\u4844\u0000\u8efa\u0000\u8f1e\u0000\u8f2d\u0000\u8f36\u0000\u8f54\u0000\u0096\u03cd\u8fa6\u0000\u8fb5\u0000\u8fe4\u0000\u8fe8\u0000\u8fee\u0000\u9008\u0000\u902d\u0000\ufa67\u0000\u9088\u0000\u9095\u0000\u9097\u0000\u9099\u0000\u909b\u0000\u90a2\u0000\u90b3\u0000\u90be\u0000\u90c4\u0000\u90c5\u0000\u90c7\u0000\u90d7\u0000\u90dd\u0000\u90de\u0000\u90ef\u0000\u90f4\u0000\ufa26\u0000\u9114\u0000\u9115\u0000\u9116\u0000\u9122\u0000\u9123\u0000\u9127\u0000\u912f\u0000\u9131\u0000\u9134\u0000\u913d\u0000\u9148\u0000\u915b\u0000\u9183\u0000\u919e\u0000\u91ac\u0000\u91b1\u0000\u91bc\u0000\u91d7\u0000\u91fb\u0000\u91e4\u0000\u91e5\u0000\u91ed\u0000\u91f1\u0000\u9207\u0000\u9210\u0000\u9238\u0000\u9239\u0000\u923a\u0000\u923c\u0000\u9240\u0000\u9243\u0000\u924f\u0000\u9278\u0000\u9288\u0000\u92c2\u0000\u92cb\u0000\u92cc\u0000\u92d3\u0000\u92e0\u0000\u92ff\u0000\u9304\u0000\u931f\u0000\u9321\u0000\u9325\u0000\u9348\u0000\u9349\u0000\u934a\u0000\u9364\u0000\u9365\u0000\u936a\u0000\u9370\u0000\u939b\u0000\u93a3\u0000\u93ba\u0000\u93c6\u0000\u93de\u0000\u93df\u0000\u9404\u0000\u93fd\u0000\u9433\u0000\u944a\u0000\u9463\u0000\u946b\u0000\u9471\u0000\u9472\u0000\u958e\u0000\u959f\u0000\u95a6\u0000\u95a9\u0000\u95ac\u0000\u95b6\u0000\u95bd\u0000\u95cb\u0000\u95d0\u0000\u95d3\u0000\u49b0\u0000\u95da\u0000\u95de\u0000\u9658\u0000\u9684\u0000\uf9dc\u0000\u969d\u0000\u96a4\u0000\u96a5\u0000\u96d2\u0000\u96de\u0000\ufa68\u0000\u96e9\u0000\u96ef\u0000\u9733\u0000\u973b\u0000\u974d\u0000\u974e\u0000\u974f\u0000\u975a\u0000\u976e\u0000\u9773\u0000\u9795\u0000\u97ae\u0000\u97ba\u0000\u97c1\u0000\u97c9\u0000\u97de\u0000\u97db\u0000\u97f4\u0000\ufa69\u0000\u980a\u0000\u981e\u0000\u982b\u0000\u9830\u0000\ufa6a\u0000\u9852\u0000\u9853\u0000\u9856\u0000\u9857\u0000\u9859\u0000\u985a\u0000\uf9d0\u0000\u9865\u0000\u986c\u0000\u98ba\u0000\u98c8\u0000\u98e7\u0000\u9958\u0000\u999e\u0000\u9a02\u0000\u9a03\u0000\u9a24\u0000\u9a2d\u0000\u9a2e\u0000\u9a38\u0000\u9a4a\u0000\u9a4e\u0000\u9a52\u0000\u9ab6\u0000\u9ac1\u0000\u9ac3\u0000\u9ace\u0000\u9ad6\u0000\u9af9\u0000\u9b02\u0000\u9b08\u0000\u9b20\u0000\u4c17\u0000\u9b2d\u0000\u9b5e\u0000\u9b79\u0000\u9b66\u0000\u9b72\u0000\u9b75\u0000\u9b84\u0000\u9b8a\u0000\u9b8f\u0000\u9b9e\u0000\u9ba7\u0000\u9bc1\u0000\u9bce\u0000\u9be5\u0000\u9bf8\u0000\u9bfd\u0000\u9c00\u0000\u9c23\u0000\u9c41\u0000\u9c4f\u0000\u9c50\u0000\u9c53\u0000\u9c63\u0000\u9c65\u0000\u9c77\u0000\u9d1d\u0000\u9d1e\u0000\u9d43\u0000\u9d47\u0000\u9d52\u0000\u9d63\u0000\u9d70\u0000\u9d7c\u0000\u9d8a\u0000\u9d96\u0000\u9dc0\u0000\u9dac\u0000\u9dbc\u0000\u9dd7\u0000\u009e\u0190\u9de7\u0000\u9e07\u0000\u9e15\u0000\u9e7c\u0000\u9e9e\u0000\u9ea4\u0000\u9eac\u0000\u9eaf\u0000\u9eb4\u0000\u9eb5\u0000\u9ec3\u0000\u9ed1\u0000\u9f10\u0000\u9f39\u0000\u9f57\u0000\u9f90\u0000\u9f94\u0000\u9f97\u0000\u9fa2\u0000\u59f8\u0000\u5c5b\u0000\u5e77\u0000\u7626\u0000\u7e6b\u0000".toCharArray();
        public Han fnpHanPage;

        public Zen(int n, int n2, String string, String string2, String string3, String string4) {
            this(n, n2, string, string2, string3, string4, null, 0);
        }

        public Zen(int n, int n2, String string, String string2, String string3, String string4, byte[] byArray, int n3) {
            super(n, n2, string, string2, string3, string4, 94, 94, 77, byArray, n3, new char[][]{FULL_BASE});
        }

        public void setHanPage(Han han) {
            this.fnpHanPage = han;
            this.fnpMaximumFontDataFileLength = han.fnpBinaryBytes + this.fnpBinaryBytes;
        }

        @Override
        public boolean fnpIsFontDataFileLength(long l) {
            return l == (long)this.fnpBinaryBytes || l == (long)(this.fnpHanPage.fnpBinaryBytes + this.fnpBinaryBytes);
        }

        @Override
        public boolean fnpLoadFontDataArray(byte[] byArray, int n, int n2) {
            if (n2 == this.fnpCharacterBytes * 94 * 77) {
                System.arraycopy(byArray, n, this.fnpBinaryArray, 0, this.fnpCharacterBytes * 94 * 8);
                Arrays.fill(this.fnpBinaryArray, this.fnpCharacterBytes * 94 * 8, this.fnpCharacterBytes * 94 * 15, (byte)0);
                System.arraycopy(byArray, n + this.fnpCharacterBytes * 94 * 8, this.fnpBinaryArray, this.fnpCharacterBytes * 94 * 15, this.fnpCharacterBytes * 94 * 69);
                Arrays.fill(this.fnpBinaryArray, this.fnpCharacterBytes * 94 * 84, this.fnpCharacterBytes * 94 * 94, (byte)0);
            } else if (n2 == this.fnpBinaryBytes) {
                System.arraycopy(byArray, n, this.fnpBinaryArray, 0, this.fnpBinaryBytes);
            } else if (n2 == this.fnpHanPage.fnpBinaryBytes + this.fnpBinaryBytes) {
                System.arraycopy(byArray, n + this.fnpHanPage.fnpBinaryBytes, this.fnpBinaryArray, 0, this.fnpBinaryBytes);
            } else {
                return false;
            }
            this.fnpBinaryToMemory();
            this.fnpBinaryToImage();
            if (!this.fnpReady) {
                System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
                this.fnpReady = true;
            }
            return true;
        }

        @Override
        public byte[] fnpSaveFontDataArray() {
            byte[] byArray = new byte[this.fnpHanPage.fnpBinaryBytes + this.fnpBinaryBytes];
            System.arraycopy(this.fnpHanPage.fnpBinaryArray, 0, byArray, 0, this.fnpHanPage.fnpBinaryBytes);
            System.arraycopy(this.fnpBinaryArray, 0, byArray, this.fnpHanPage.fnpBinaryBytes, this.fnpBinaryBytes);
            return byArray;
        }

        @Override
        public String fnpGetExtension() {
            if (this.fnpExtension == null) {
                this.fnpExtension = this.fnpCharacterHeight == 16 ? ".fon" : ".f" + this.fnpCharacterHeight;
            }
            return this.fnpExtension;
        }

        @Override
        public boolean fnpInputImage(BufferedImage bufferedImage) {
            if (bufferedImage.getWidth() == this.fnpImageWidth && bufferedImage.getHeight() == this.fnpCharacterHeight * 77) {
                Raster raster = bufferedImage.getData(new Rectangle(0, 0, this.fnpImageWidth, this.fnpCharacterHeight * 8));
                Raster raster2 = bufferedImage.getData(new Rectangle(0, this.fnpCharacterHeight * 8, this.fnpImageWidth, this.fnpCharacterHeight * 69));
                raster2 = raster2.createTranslatedChild(0, this.fnpCharacterHeight * 15);
                BufferedImage bufferedImage2 = new BufferedImage(this.fnpImageWidth, this.fnpImageHeight, 1);
                bufferedImage2.setData(raster);
                bufferedImage2.setData(raster2);
                bufferedImage = bufferedImage2;
            }
            return super.fnpInputImage(bufferedImage);
        }
    }

    public static final class Han
    extends FontPage {
        public static final char[] HALF_BASE = "                                 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\u00a5]^_`abcdefghijklmnopqrstuvwxyz{|}   ~\u00a6                              \uff61\uff62\uff63\uff64\uff65\uff66\uff67\uff68\uff69\uff6a\uff6b\uff6c\uff6d\uff6e\uff6f\uff70\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff9d\uff9e\uff9f                                ".toCharArray();
        public static final char[] FULL_BASE = "\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2192\u2190\u2191\u2193\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\uffe3\u3000\uff3c\u3000\u3000\u3000\u3000\u3000\u3092\u3041\u3043\u3045\u3047\u3049\u3083\u3085\u3087\u3063\u3000\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3093\u3000\u3000".toCharArray();
        public Zen fnpZenPage;

        public Han(int n, int n2, String string, String string2, String string3, String string4) {
            this(n, n2, string, string2, string3, string4, null, 0);
        }

        public Han(int n, int n2, String string, String string2, String string3, String string4, byte[] byArray, int n3) {
            super(n, n2, string, string2, string3, string4, 16, 16, 16, byArray, n3, new char[][]{HALF_BASE, FULL_BASE});
        }

        public void setZenPage(Zen zen) {
            this.fnpZenPage = zen;
            this.fnpMaximumFontDataFileLength = this.fnpBinaryBytes + zen.fnpBinaryBytes;
        }

        @Override
        public boolean fnpIsFontDataFileLength(long l) {
            return l == (long)this.fnpBinaryBytes || l == (long)(this.fnpBinaryBytes + this.fnpZenPage.fnpBinaryBytes);
        }

        @Override
        public boolean fnpLoadFontDataArray(byte[] byArray, int n, int n2) {
            if (n2 == this.fnpBinaryBytes || n2 == this.fnpBinaryBytes + this.fnpZenPage.fnpBinaryBytes) {
                System.arraycopy(byArray, n, this.fnpBinaryArray, 0, this.fnpBinaryBytes);
                this.fnpBinaryToMemory();
                this.fnpBinaryToImage();
                if (!this.fnpReady) {
                    System.out.println(Multilingual.mlnJapanese ? this.fnpNameJa + " \u30d5\u30a9\u30f3\u30c8\u306e\u6e96\u5099\u304c\u3067\u304d\u307e\u3057\u305f" : this.fnpNameEn + " font is ready");
                    this.fnpReady = true;
                }
                return true;
            }
            return false;
        }

        @Override
        public String fnpGetExtension() {
            if (this.fnpExtension == null) {
                this.fnpExtension = this.fnpCharacterHeight == 16 ? ".fon" : ".f" + this.fnpCharacterHeight;
            }
            return this.fnpExtension;
        }
    }

    public static final class Yon
    extends FontPage {
        public static final char[] FULL_BASE = "\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u2192\u2190\u2191\u2193\u3000\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff3b\uffe5\uff3d\uff3e\uff3f\uff40\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\uff5b\uff5c\uff5d\uffe3\u3000\uff3c\uff5e\uffe4\u3000\u3000\u3000\u3092\u3041\u3043\u3045\u3047\u3049\u3083\u3085\u3087\u3063\u3000\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u3000\u3002\u300c\u300d\u3001\u30fb\u30f2\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3\u30fc\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3\u309b\u309c\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3093\u3000\u3000".toCharArray();

        public Yon(int n, int n2, String string, String string2, String string3, String string4) {
            this(n, n2, string, string2, string3, string4, null, 0);
        }

        public Yon(int n, int n2, String string, String string2, String string3, String string4, byte[] byArray, int n3) {
            super(n, n2, string, string2, string3, string4, 16, 16, 16, byArray, n3, new char[][]{FULL_BASE});
        }
    }
}

