/*
 * Decompiled with CFR 0.152.
 */
package xeij;

public class TickerQueue {
    public static final boolean TKQ_USE_TICKER0 = true;
    public static final int TKQ_MASK = 255;
    public static final Ticker[] tkqArray = new Ticker[256];
    public static int tkqHead;
    public static int tkqTail;
    public static Ticker tkqTicker0;
    public static long tkqTime0;

    public static void tkqInit() {
        tkqHead = 0;
        tkqTail = 0;
        tkqTicker0 = TickerQueue.tkqArray[0] = new Ticker();
        TickerQueue.tkqTicker0.time = Long.MAX_VALUE;
        tkqTime0 = Long.MAX_VALUE;
    }

    public static void tkqRun(long l) {
        while (tkqTime0 <= l) {
            Ticker ticker = tkqTicker0;
            tkqHead = tkqHead + 1 & 0xFF;
            tkqTicker0 = tkqArray[tkqHead];
            tkqTime0 = TickerQueue.tkqTicker0.time;
            ticker.time = Long.MAX_VALUE;
            ticker.tick();
        }
    }

    public static void tkqAdd(Ticker ticker, long l) {
        int n;
        if (ticker.time != Long.MAX_VALUE) {
            TickerQueue.tkqRemove(ticker);
        }
        ticker.time = l;
        int n2 = tkqTail - tkqHead & 0xFF;
        if (n2 == 255) {
            throw new Error("tkqAdd: overflow");
        }
        if (n2 == 0 || l < tkqTime0) {
            tkqHead = tkqHead - 1 & 0xFF;
            TickerQueue.tkqArray[TickerQueue.tkqHead] = ticker;
            tkqTicker0 = TickerQueue.tkqArray[TickerQueue.tkqHead];
            tkqTime0 = l;
            return;
        }
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3 + n4 >> 1;
            if (TickerQueue.tkqArray[n + TickerQueue.tkqHead & 0xFF].time <= l) {
                n3 = n + 1;
                continue;
            }
            n4 = n;
        }
        if (n3 << 1 < n2) {
            n3 = n3 - 1 + tkqHead & 0xFF;
            n4 = tkqHead = tkqHead - 1 & 0xFF;
            while (n3 != n4) {
                n = n4 + 1 & 0xFF;
                TickerQueue.tkqArray[n4] = tkqArray[n];
                n4 = n;
            }
        } else {
            n3 = n3 + tkqHead & 0xFF;
            n4 = tkqTail = tkqTail + 1 & 0xFF;
            while (n3 != n4) {
                n = n4 - 1 & 0xFF;
                TickerQueue.tkqArray[n4] = tkqArray[n];
                n4 = n;
            }
        }
        TickerQueue.tkqArray[n3] = ticker;
    }

    public static void tkqRemove(Ticker ticker) {
        int n;
        long l = ticker.time;
        if (l == Long.MAX_VALUE) {
            return;
        }
        ticker.time = Long.MAX_VALUE;
        if (tkqHead == tkqTail) {
            return;
        }
        if (tkqTicker0 == ticker) {
            tkqHead = tkqHead + 1 & 0xFF;
            tkqTicker0 = tkqArray[tkqHead];
            tkqTime0 = TickerQueue.tkqTicker0.time;
            return;
        }
        int n2 = tkqTail - tkqHead & 0xFF;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3 + n4 >> 1;
            if (TickerQueue.tkqArray[n + TickerQueue.tkqHead & 0xFF].time < l) {
                n3 = n + 1;
                continue;
            }
            n4 = n;
        }
        while (n3 < n2 && tkqArray[n3 + tkqHead & 0xFF] != ticker) {
            ++n3;
        }
        if (n3 == n2) {
            return;
        }
        if (n3 << 1 < n2) {
            n4 = n3 + tkqHead & 0xFF;
            n3 = tkqHead & 0xFF;
            tkqHead = tkqHead + 1 & 0xFF;
            while (n3 != n4) {
                n = n4 - 1 & 0xFF;
                TickerQueue.tkqArray[n4] = tkqArray[n];
                n4 = n;
            }
        } else {
            n4 = n3 + tkqHead & 0xFF;
            n3 = tkqTail & 0xFF;
            tkqTail = tkqTail - 1 & 0xFF;
            while (n3 != n4) {
                n = n4 + 1 & 0xFF;
                TickerQueue.tkqArray[n4] = tkqArray[n];
                n4 = n;
            }
        }
    }

    public static void tkqRemoveAll() {
        while (tkqHead != tkqTail) {
            TickerQueue.tkqRemove(tkqTicker0);
        }
    }

    public static void tkqTest() {
        int n;
        int n2;
        TickerQueue.tkqInit();
        TestTicker[] testTickerArray = new TestTicker[100];
        for (n2 = 0; n2 < 100; ++n2) {
            testTickerArray[n2] = new TestTicker(n2);
        }
        System.out.println("test 1");
        for (n2 = 0; n2 < 100; ++n2) {
            TickerQueue.tkqAdd(testTickerArray[n2], n2);
        }
        TickerQueue.tkqRun(100L);
        System.out.println();
        System.out.println("test 2");
        for (n2 = 99; n2 >= 0; --n2) {
            TickerQueue.tkqAdd(testTickerArray[n2], n2);
        }
        TickerQueue.tkqRun(100L);
        System.out.println();
        System.out.println("test 3");
        for (n2 = 0; n2 < 100; ++n2) {
            TickerQueue.tkqAdd(testTickerArray[n2], (int)(Math.random() * 100.0));
        }
        TickerQueue.tkqRun(100L);
        System.out.println();
        System.out.println("test 4");
        for (n2 = 0; n2 < 100; ++n2) {
            TickerQueue.tkqAdd(testTickerArray[n2], n2);
        }
        for (n2 = 0; n2 < 100; n2 += 2) {
            TickerQueue.tkqRemove(testTickerArray[n2]);
        }
        TickerQueue.tkqRun(100L);
        System.out.println();
        System.out.println("test 5");
        for (n2 = 0; n2 < 100; ++n2) {
            TickerQueue.tkqAdd(testTickerArray[n2], n2);
        }
        for (n2 = 1; n2 < 100; n2 += 2) {
            TickerQueue.tkqRemove(testTickerArray[n2]);
        }
        TickerQueue.tkqRun(100L);
        System.out.println();
        System.out.println("test 6");
        n2 = 0;
        for (n = 0; n < 50; ++n) {
            TickerQueue.tkqAdd(testTickerArray[n], n2++);
        }
        for (n = 0; n < 5; ++n) {
            int n3;
            for (n3 = 0; n3 < 50; ++n3) {
                TickerQueue.tkqAdd(testTickerArray[50 + n3], n2++);
            }
            TickerQueue.tkqRun(n2 - 50 - 1);
            System.out.println();
            for (n3 = 0; n3 < 50; ++n3) {
                TickerQueue.tkqAdd(testTickerArray[n3], n2++);
            }
            TickerQueue.tkqRun(n2 - 50 - 1);
            System.out.println();
        }
    }

    public static class Ticker {
        protected long time = Long.MAX_VALUE;

        protected void tick() {
        }
    }

    public static class TestTicker
    extends Ticker {
        private int value;

        private TestTicker(int n) {
            this.value = n;
        }

        @Override
        protected void tick() {
            System.out.print(this.time);
            System.out.print('(');
            System.out.print(this.value);
            System.out.print(')');
            System.out.print(' ');
        }
    }
}

