/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import xeij.BranchLog;
import xeij.ComponentFactory;
import xeij.DisassembleList;
import xeij.Indicator;
import xeij.LnF;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.XEiJ;

public class ProgramFlowVisualizer {
    public static final boolean PFV_ON = true;
    public static final int PFV_LOG2_BYTES_PER_CELL = 5;
    public static final int PFV_LOG2_CELLS_PER_LINE = 8;
    public static final int PFV_LOG2_BYTES_PER_LINE = 13;
    public static final int PFV_LOG2_TOTAL_LINES = 19;
    public static final int PFV_BYTES_PER_CELL = 32;
    public static final int PFV_CELLS_PER_LINE = 256;
    public static final int PFV_BYTES_PER_LINE = 8192;
    public static final int PFV_TOTAL_LINES = 524288;
    public static final int PFV_MARGIN_LEFT = 2;
    public static final int PFV_ADDRESS1_WIDTH = 34;
    public static final int PFV_BAR_WIDTH = 10;
    public static final int PFV_FUNNEL_WIDTH = 8;
    public static final int PFV_ADDRESS2_WIDTH = 34;
    public static final int PFV_MAP_WIDTH = 512;
    public static final int PFV_MARGIN_RIGHT = 2;
    public static final int PFV_ADDRESS1_X0 = 2;
    public static final int PFV_BAR_X0 = 36;
    public static final int PFV_FUNNEL_X0 = 46;
    public static final int PFV_ADDRESS2_X0 = 54;
    public static final int PFV_MAP_X0 = 88;
    public static final int PFV_PANEL_WIDTH = 602;
    public static final int PFV_MARGIN_TOP = 2;
    public static final int PFV_OFFSET_HEIGHT = 8;
    public static final int PFV_MAP_MIN_HEIGHT = 128;
    public static final int PFV_MAP_DEFAULT_HEIGHT = 256;
    public static final int PFV_MARGIN_BOTTOM = 2;
    public static final int PFV_OFFSET_Y0 = 2;
    public static final int PFV_MAP_Y0 = 10;
    public static final int PFV_PANEL_MIN_HEIGHT = 140;
    public static final int PFV_PANEL_DEFAULT_HEIGHT = 268;
    public static final int PFV_PANEL_MAX_HEIGHT = 1024;
    public static int pfvPanelHeight;
    public static int pfvMapHeight;
    public static int pfvMapY1;
    public static int pfvLines;
    public static int pfvLine0;
    public static int pfvLine1;
    public static int pfvAddress0;
    public static int pfvAddress1;
    public static int pfvFunnelY0;
    public static int pfvFunnelY1;
    public static int pfvPressedX;
    public static int pfvPressedY;
    public static int pfvPressedLine0;
    public static int pfvSpan;
    public static final float PFV_COLOR_H0 = 0.6666667f;
    public static final float PFV_COLOR_H1 = 1.1666666f;
    public static final float PFV_COLOR_S0 = 1.0f;
    public static final float PFV_COLOR_S1 = 1.0f;
    public static final float PFV_COLOR_B0 = 0.2f;
    public static final float PFV_COLOR_B1 = 1.0f;
    public static final int PFV_ADDRESS_PALET = 240;
    public static final int PFV_FUNNEL_PALET = 240;
    public static BufferedImage pfvImage;
    public static byte[] pfvBitmap;
    public static JPanel pfvPanel;
    public static JFrame pfvFrame;
    public static final int PFV_INTERVAL = 10;
    public static int pfvTimer;

    public static void pfvInit() {
        pfvPanelHeight = 268;
        pfvMapHeight = 256;
        pfvMapY1 = 9 + pfvMapHeight;
        pfvLines = pfvMapHeight + 1 >>> 1;
        pfvLine0 = 0;
        pfvLine1 = pfvLine0 + pfvLines - 1;
        pfvAddress0 = pfvLine0 << 13;
        pfvAddress1 = (pfvLine1 + 1 << 13) - 2;
        pfvFunnelY0 = 10 + (int)((long)pfvMapHeight * (long)pfvLine0 / 524288L);
        pfvFunnelY1 = 10 + (int)((long)pfvMapHeight * (long)pfvLine1 / 524288L);
        pfvPressedX = -1;
        pfvSpan = 8;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int n = Color.HSBtoRGB(0.6666667f + (float)i * 0.0019531248f, 1.0f + (float)i * 0.0f, 0.2f + (float)i * 0.003125f);
            byArray[i] = (byte)(n >>> 16);
            byArray2[i] = (byte)(n >>> 8);
            byArray3[i] = (byte)n;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        pfvImage = new BufferedImage(602, 1024, 13, indexColorModel);
        pfvBitmap = ((DataBufferByte)pfvImage.getRaster().getDataBuffer()).getData();
        pfvPanel = null;
        pfvFrame = null;
        pfvTimer = 0;
    }

    public static void pfvStart() {
        if (RestorableFrame.rfmGetOpened("pfv")) {
            ProgramFlowVisualizer.pfvOpen();
        }
    }

    public static void pfvOpen() {
        if (pfvFrame == null) {
            ProgramFlowVisualizer.pfvMakeFrame();
        }
        XEiJ.dbgVisibleMask |= 0x10;
        if (XEiJ.mpuTask == null) {
            ProgramFlowVisualizer.pfvUpdate();
        }
        XEiJ.pnlExitFullScreen(false);
        pfvFrame.setVisible(true);
    }

    public static void pfvMakeFrame() {
        pfvPanel = ComponentFactory.setMinimumSize(ComponentFactory.setPreferredSize(ComponentFactory.setMaximumSize(new JPanel(){

            @Override
            public void paint(Graphics graphics) {
                graphics.drawImage(pfvImage, 0, 0, null);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
            }

            @Override
            protected void paintBorder(Graphics graphics) {
            }

            @Override
            protected void paintChildren(Graphics graphics) {
            }

            @Override
            public void update(Graphics graphics) {
            }
        }, 602, 1024), 602, 268), 602, 140);
        ComponentFactory.addListener(pfvPanel, new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                pfvPanelHeight = Math.max(140, Math.min(1024, pfvPanel.getHeight()));
                pfvMapHeight = pfvPanelHeight - 4;
                pfvMapY1 = 9 + pfvMapHeight;
                pfvLines = pfvMapHeight + 1 >> 1;
                pfvLine0 = Math.max(0, Math.min(524288 - pfvLines, pfvLine0 + pfvLine1 + 1 - pfvLines >> 1));
                pfvLine1 = pfvLine0 + pfvLines - 1;
                pfvAddress0 = pfvLine0 << 13;
                pfvAddress1 = (pfvLine1 + 1 << 13) - 2;
                pfvFunnelY0 = 10 + (int)((long)pfvMapHeight * (long)pfvLine0 / 524288L);
                pfvFunnelY1 = 10 + (int)((long)pfvMapHeight * (long)pfvLine1 / 524288L);
                if (XEiJ.mpuTask == null) {
                    ProgramFlowVisualizer.pfvUpdate();
                }
            }
        });
        pfvPanel.setFocusable(true);
        ComponentFactory.addListener(pfvPanel, new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        n = pfvLine0 - 16;
                        break;
                    }
                    case 40: {
                        n = pfvLine0 + 16;
                        break;
                    }
                    case 33: {
                        n = pfvLine0 - (pfvLines * 15 >> 4);
                        break;
                    }
                    case 34: {
                        n = pfvLine0 + (pfvLines * 15 >> 4);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                pfvLine0 = Math.max(0, Math.min(524288 - pfvLines, n));
                pfvLine1 = pfvLine0 + pfvLines - 1;
                pfvAddress0 = pfvLine0 << 13;
                pfvAddress1 = (pfvLine1 + 1 << 13) - 2;
                pfvFunnelY0 = 10 + (int)((long)pfvMapHeight * (long)pfvLine0 / 524288L);
                pfvFunnelY1 = 10 + (int)((long)pfvMapHeight * (long)pfvLine1 / 524288L);
                if (XEiJ.mpuTask == null) {
                    ProgramFlowVisualizer.pfvUpdate();
                }
            }
        });
        ComponentFactory.addListener(pfvPanel, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (88 <= n && n < 600 && 10 <= n2 && n2 <= pfvMapY1) {
                    DisassembleList.ddpOpen(pfvAddress0 + (n - 88 >> 1 << 5) + (n2 - 10 >> 1 << 13), XEiJ.regSRS, false);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                pfvPressedX = -1;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (36 <= n && n < 54) {
                    pfvLine0 = Math.max(0, Math.min(524288 - pfvLines, (int)(524288L * (long)(n2 - 10) / (long)pfvMapHeight) - (pfvLines >> 1)));
                    pfvLine1 = pfvLine0 + pfvLines - 1;
                    pfvAddress0 = pfvLine0 << 13;
                    pfvAddress1 = (pfvLine1 + 1 << 13) - 2;
                    pfvFunnelY0 = 10 + (int)((long)pfvMapHeight * (long)pfvLine0 / 524288L);
                    pfvFunnelY1 = 10 + (int)((long)pfvMapHeight * (long)pfvLine1 / 524288L);
                    if (XEiJ.mpuTask == null) {
                        ProgramFlowVisualizer.pfvUpdate();
                    }
                }
                pfvPressedX = n;
                pfvPressedY = n2;
                pfvPressedLine0 = pfvLine0;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                pfvPressedX = -1;
            }
        });
        ComponentFactory.addListener(pfvPanel, new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (pfvPressedX >= 0) {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    pfvLine0 = Math.max(0, Math.min(524288 - pfvLines, 36 <= n && pfvPressedX < 54 ? (int)(524288L * (long)(n2 - 10) / (long)pfvMapHeight) - (pfvLines >> 1) : pfvPressedLine0 - (n2 - pfvPressedY >> 1)));
                    pfvLine1 = pfvLine0 + pfvLines - 1;
                    pfvAddress0 = pfvLine0 << 13;
                    pfvAddress1 = (pfvLine1 + 1 << 13) - 2;
                    pfvFunnelY0 = 10 + (int)((long)pfvMapHeight * (long)pfvLine0 / 524288L);
                    pfvFunnelY1 = 10 + (int)((long)pfvMapHeight * (long)pfvLine1 / 524288L);
                    if (XEiJ.mpuTask == null) {
                        ProgramFlowVisualizer.pfvUpdate();
                    }
                }
            }
        });
        ComponentFactory.addListener(pfvPanel, new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                pfvLine0 = Math.max(0, Math.min(524288 - pfvLines, pfvLine0 + (mouseWheelEvent.getWheelRotation() << 4)));
                pfvLine1 = pfvLine0 + pfvLines - 1;
                pfvAddress0 = pfvLine0 << 13;
                pfvAddress1 = (pfvLine1 + 1 << 13) - 2;
                pfvFunnelY0 = 10 + (int)((long)pfvMapHeight * (long)pfvLine0 / 524288L);
                pfvFunnelY1 = 10 + (int)((long)pfvMapHeight * (long)pfvLine1 / 524288L);
                if (XEiJ.mpuTask == null) {
                    ProgramFlowVisualizer.pfvUpdate();
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Clear": {
                        if (XEiJ.mpuTask != null) break;
                        BranchLog.blgReset();
                        BranchLog.blgArray[0] = XEiJ.regPC | XEiJ.regSRS >>> 13;
                        BranchLog.blgArray[1] = XEiJ.regPC | (XEiJ.mpuISR == 0 ? 0 : 1);
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "256 records": {
                        pfvSpan = 0;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "512 records": {
                        pfvSpan = 1;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "1024 records": {
                        pfvSpan = 2;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "2048 records": {
                        pfvSpan = 3;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "4096 records": {
                        pfvSpan = 4;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "8192 records": {
                        pfvSpan = 5;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "16384 records": {
                        pfvSpan = 6;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "32768 records": {
                        pfvSpan = 7;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                        break;
                    }
                    case "65536 records": {
                        pfvSpan = 8;
                        if (XEiJ.mpuTask != null) break;
                        ProgramFlowVisualizer.pfvUpdate();
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        pfvFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("pfv", "Program flow visualizer", null, ComponentFactory.createBorderPanel(pfvPanel, ComponentFactory.createHorizontalBox(XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_CLEAR_IMAGE, LnF.LNF_CLEAR_DISABLED_IMAGE, "Clear", actionListener), "ja", "\u30af\u30ea\u30a2")), Box.createHorizontalGlue(), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 0, LnF.LNF_NUMBER_IMAGE_ARRAY[0], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[0], "256 records", actionListener), "ja", "256 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 1, LnF.LNF_NUMBER_IMAGE_ARRAY[1], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[1], "512 records", actionListener), "ja", "512 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 2, LnF.LNF_NUMBER_IMAGE_ARRAY[2], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[2], "1024 records", actionListener), "ja", "1024 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 3, LnF.LNF_NUMBER_IMAGE_ARRAY[3], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[3], "2048 records", actionListener), "ja", "2048 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 4, LnF.LNF_NUMBER_IMAGE_ARRAY[4], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[4], "4096 records", actionListener), "ja", "4096 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 5, LnF.LNF_NUMBER_IMAGE_ARRAY[5], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[5], "8192 records", actionListener), "ja", "8192 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 6, LnF.LNF_NUMBER_IMAGE_ARRAY[6], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[6], "16384 records", actionListener), "ja", "16384 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 7, LnF.LNF_NUMBER_IMAGE_ARRAY[7], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[7], "32768 records", actionListener), "ja", "32768 \u30ec\u30b3\u30fc\u30c9"), Multilingual.mlnToolTipText(ComponentFactory.createIconRadioButton(buttonGroup, pfvSpan == 8, LnF.LNF_NUMBER_IMAGE_ARRAY[8], LnF.LNF_NUMBER_SELECTED_IMAGE_ARRAY[8], "65536 records", actionListener), "ja", "65536 \u30ec\u30b3\u30fc\u30c9"), Box.createHorizontalGlue(), XEiJ.mpuMakeBreakButton(), XEiJ.mpuMakeTraceButton(), XEiJ.mpuMakeTrace10Button(), XEiJ.mpuMakeTrace100Button(), XEiJ.mpuMakeStepButton(), XEiJ.mpuMakeStep10Button(), XEiJ.mpuMakeStep100Button(), XEiJ.mpuMakeReturnButton(), XEiJ.mpuMakeRunButton()))), "ja", "\u30d7\u30ed\u30b0\u30e9\u30e0\u30d5\u30ed\u30fc\u30d3\u30b8\u30e5\u30a2\u30e9\u30a4\u30b6");
        ComponentFactory.addListener(pfvFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFEF;
            }
        });
    }

    public static void pfvUpdate() {
        int n;
        int n2;
        int n3;
        int n4;
        if (BranchLog.blgLock) {
            return;
        }
        BranchLog.blgLock = true;
        BranchLog.blgStop();
        Arrays.fill(pfvBitmap, 0, 602 * pfvPanelHeight, (byte)0);
        int n5 = 5 + Integer.numberOfLeadingZeros(pfvMapHeight);
        int n6 = 1 << 32 - n5;
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = n4 << n5;
            n2 = 4818 + 602 * (int)((long)pfvMapHeight * ((long)n3 & 0xFFFFFFFFL) >>> 32);
            n = n3 >>> 28;
            ProgramFlowVisualizer.pfvPutc(n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 24 & 0xF;
            ProgramFlowVisualizer.pfvPutc(4 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 20 & 0xF;
            ProgramFlowVisualizer.pfvPutc(8 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 16 & 0xF;
            ProgramFlowVisualizer.pfvPutc(12 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = (char)n3 >>> 12;
            ProgramFlowVisualizer.pfvPutc(16 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 8 & 0xF;
            ProgramFlowVisualizer.pfvPutc(20 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 4 & 0xF;
            ProgramFlowVisualizer.pfvPutc(24 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 & 0xF;
            ProgramFlowVisualizer.pfvPutc(28 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
        }
        n5 = 6070;
        ProgramFlowVisualizer.pfvBitmap[n5 + 3] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 + 2] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 + 1] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5] = -16;
        for (n6 = 10; n6 < pfvFunnelY0; ++n6) {
            ProgramFlowVisualizer.pfvBitmap[n5] = -16;
            n5 += 602;
        }
        ProgramFlowVisualizer.pfvBitmap[n5] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 - 1] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 - 2] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 - 3] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 += 602 * (ProgramFlowVisualizer.pfvFunnelY1 - ProgramFlowVisualizer.pfvFunnelY0)] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 - 1] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 - 2] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 - 3] = -16;
        for (n6 = pfvFunnelY1; n6 < pfvMapY1; ++n6) {
            ProgramFlowVisualizer.pfvBitmap[n5] = -16;
            n5 += 602;
        }
        ProgramFlowVisualizer.pfvBitmap[n5 + 3] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 + 2] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5 + 1] = -16;
        ProgramFlowVisualizer.pfvBitmap[n5] = -16;
        n5 = pfvAddress0 + 65536 - 1 & 0xFFFF0000;
        n6 = pfvAddress1 - n5;
        for (n4 = 0; n4 <= n6; n4 += 65536) {
            n3 = n5 + n4;
            n2 = 4870 + 602 * (n3 - pfvAddress0 >>> 12);
            n = n3 >>> 28;
            ProgramFlowVisualizer.pfvPutc(n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 24 & 0xF;
            ProgramFlowVisualizer.pfvPutc(4 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 20 & 0xF;
            ProgramFlowVisualizer.pfvPutc(8 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 16 & 0xF;
            ProgramFlowVisualizer.pfvPutc(12 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = (char)n3 >>> 12;
            ProgramFlowVisualizer.pfvPutc(16 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 8 & 0xF;
            ProgramFlowVisualizer.pfvPutc(20 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 >>> 4 & 0xF;
            ProgramFlowVisualizer.pfvPutc(24 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
            n = n3 & 0xF;
            ProgramFlowVisualizer.pfvPutc(28 + n2, (9 - n >> 4 & 7 | 0x30) + n, 240);
        }
        n5 = 4;
        for (n6 = 0; n6 < 8192; n6 += 256) {
            n5 = 6 - n5;
            if (n6 < 16) {
                n4 = 602 * n5 + 88 - 1 + (n6 >>> 4);
                ProgramFlowVisualizer.pfvPutc(n4, (9 - n6 >> 4 & 7 | 0x30) + n6, 240);
                continue;
            }
            if (n6 < 256) {
                n4 = 602 * n5 + 88 - 3 + (n6 >>> 4);
                n3 = n6 >>> 4 & 0xF;
                ProgramFlowVisualizer.pfvPutc(n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
                n3 = n6 & 0xF;
                ProgramFlowVisualizer.pfvPutc(4 + n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
                continue;
            }
            if (n6 < 4096) {
                n4 = 602 * n5 + 88 - 5 + (n6 >>> 4);
                n3 = n6 >>> 8 & 0xF;
                ProgramFlowVisualizer.pfvPutc(n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
                n3 = n6 >>> 4 & 0xF;
                ProgramFlowVisualizer.pfvPutc(4 + n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
                n3 = n6 & 0xF;
                ProgramFlowVisualizer.pfvPutc(8 + n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
                continue;
            }
            n4 = 602 * n5 + 88 - 7 + (n6 >>> 4);
            n3 = n6 >>> 12 & 0xF;
            ProgramFlowVisualizer.pfvPutc(n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
            n3 = n6 >>> 8 & 0xF;
            ProgramFlowVisualizer.pfvPutc(4 + n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
            n3 = n6 >>> 4 & 0xF;
            ProgramFlowVisualizer.pfvPutc(8 + n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
            n3 = n6 & 0xF;
            ProgramFlowVisualizer.pfvPutc(12 + n4, (9 - n3 >> 4 & 7 | 0x30) + n3, 240);
        }
        long l = BranchLog.blgNewestRecord;
        long l2 = Math.max(0L, BranchLog.blgNewestRecord - 65535L);
        for (long i = l2 = l - (long)Math.min((256 << pfvSpan) - 1, (int)(l - l2)); i <= l; ++i) {
            int n7;
            int n8 = 255 - ((int)(l - i) >>> pfvSpan);
            int n9 = (char)i << 1;
            int n10 = BranchLog.blgArray[n9] & 0xFFFFFFFE;
            int n11 = BranchLog.blgArray[n9 + 1] & 0xFFFFFFFE;
            n9 = (int)((long)pfvMapHeight * ((long)n10 & 0xFFFFFFFFL) >>> 32);
            int n12 = (int)((long)pfvMapHeight * ((long)n11 & 0xFFFFFFFFL) >>> 32);
            int n13 = 6056 + 602 * n9;
            for (n7 = n9; n7 <= n12; ++n7) {
                byte by = (byte)n8;
                ProgramFlowVisualizer.pfvBitmap[n13 + 7] = by;
                ProgramFlowVisualizer.pfvBitmap[n13 + 6] = by;
                ProgramFlowVisualizer.pfvBitmap[n13 + 5] = by;
                ProgramFlowVisualizer.pfvBitmap[n13 + 4] = by;
                ProgramFlowVisualizer.pfvBitmap[n13 + 3] = by;
                ProgramFlowVisualizer.pfvBitmap[n13 + 2] = by;
                ProgramFlowVisualizer.pfvBitmap[n13 + 1] = by;
                ProgramFlowVisualizer.pfvBitmap[n13] = by;
                n13 += 602;
            }
            if (((long)n10 & 0xFFFFFFFFL) > ((long)pfvAddress1 & 0xFFFFFFFFL) || ((long)pfvAddress0 & 0xFFFFFFFFL) > ((long)n11 & 0xFFFFFFFFL)) continue;
            if (((long)n10 & 0xFFFFFFFFL) < ((long)pfvAddress0 & 0xFFFFFFFFL)) {
                n10 = pfvAddress0;
            }
            if (((long)n11 & 0xFFFFFFFFL) > ((long)pfvAddress1 & 0xFFFFFFFFL)) {
                n11 = pfvAddress1;
            }
            n12 = n11 >>> 13;
            n13 = 6108 + 602 * (n9 - pfvLine0 << 1);
            n7 = n13 + ((n10 & 0x1FFE) >>> 4 & 0xFFFFFFFE);
            for (n9 = n10 >>> 13; n9 <= n12; ++n9) {
                int n14 = n13 + (n9 < n12 ? 510 : (n11 & 0x1FFE) >>> 4 & 0xFFFFFFFE);
                while (n7 <= n14) {
                    byte by = (byte)n8;
                    ProgramFlowVisualizer.pfvBitmap[n7 + 603] = by;
                    ProgramFlowVisualizer.pfvBitmap[n7 + 602] = by;
                    ProgramFlowVisualizer.pfvBitmap[n7 + 1] = by;
                    ProgramFlowVisualizer.pfvBitmap[n7] = by;
                    n7 += 2;
                }
                n7 = n13 += 1204;
            }
        }
        pfvPanel.repaint();
        pfvTimer = 10;
        BranchLog.blgLock = false;
    }

    public static void pfvPutc(int n, int n2, int n3) {
        char c = Indicator.IND_ASCII_3X5[n2];
        if (c << 17 < 0) {
            ProgramFlowVisualizer.pfvBitmap[n] = (byte)n3;
        }
        if (c << 18 < 0) {
            ProgramFlowVisualizer.pfvBitmap[1 + n] = (byte)n3;
        }
        if (c << 19 < 0) {
            ProgramFlowVisualizer.pfvBitmap[2 + n] = (byte)n3;
        }
        if (c << 20 < 0) {
            ProgramFlowVisualizer.pfvBitmap[602 + n] = (byte)n3;
        }
        if (c << 21 < 0) {
            ProgramFlowVisualizer.pfvBitmap[603 + n] = (byte)n3;
        }
        if (c << 22 < 0) {
            ProgramFlowVisualizer.pfvBitmap[604 + n] = (byte)n3;
        }
        if (c << 23 < 0) {
            ProgramFlowVisualizer.pfvBitmap[1204 + n] = (byte)n3;
        }
        if ((byte)c < 0) {
            ProgramFlowVisualizer.pfvBitmap[1205 + n] = (byte)n3;
        }
        if (c << 25 < 0) {
            ProgramFlowVisualizer.pfvBitmap[1206 + n] = (byte)n3;
        }
        if (c << 26 < 0) {
            ProgramFlowVisualizer.pfvBitmap[1806 + n] = (byte)n3;
        }
        if (c << 27 < 0) {
            ProgramFlowVisualizer.pfvBitmap[1807 + n] = (byte)n3;
        }
        if (c << 28 < 0) {
            ProgramFlowVisualizer.pfvBitmap[1808 + n] = (byte)n3;
        }
        if (c << 29 < 0) {
            ProgramFlowVisualizer.pfvBitmap[2408 + n] = (byte)n3;
        }
        if ((c & 2) != 0) {
            ProgramFlowVisualizer.pfvBitmap[2409 + n] = (byte)n3;
        }
        if ((c & '\u0001') != 0) {
            ProgramFlowVisualizer.pfvBitmap[2410 + n] = (byte)n3;
        }
    }
}

