/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.nio.ByteBuffer;
import java.util.Arrays;
import xeij.CharacterCode;
import xeij.FEFunction;
import xeij.MC68060;
import xeij.MemoryMappedDevice;
import xeij.Multilingual;
import xeij.Settings;
import xeij.XEiJ;

public class MainMemory {
    public static final boolean MMR_USE_BYTE_BUFFER = false;
    public static final byte[] mmrM8 = new byte[0x1000000];
    public static ByteBuffer mmrBuffer;
    public static int mmrHumanVersion;
    public static boolean mmrFEfuncActivated;
    public static int mmrTwentyOneOptionAddress;
    public static int mmrMemorySizeRequest;
    public static int mmrMemorySizeCurrent;
    public static boolean mmrMemorySaveOn;

    public static void mmrInit() {
        int n = Settings.sgsGetInt("memory");
        mmrMemorySizeCurrent = mmrMemorySizeRequest = n == 1 || n == 2 || n == 4 || n == 6 || n == 8 || n == 10 || n == 12 ? n << 20 : 0xC00000;
        System.out.printf(Multilingual.mlnJapanese ? "\u30e1\u30a4\u30f3\u30e1\u30e2\u30ea\u306e\u30b5\u30a4\u30ba\u306f %dMB \u3067\u3059\n" : "Main memory size is %dMB\n", mmrMemorySizeCurrent >>> 20);
        mmrMemorySaveOn = Settings.sgsGetOnOff("memorysave");
        byte[] byArray = Settings.sgsGetData("memorydata");
        if (byArray.length != 0) {
            System.out.println(Multilingual.mlnJapanese ? "\u30e1\u30a4\u30f3\u30e1\u30e2\u30ea\u306e\u30c7\u30fc\u30bf\u3092\u5fa9\u5143\u3057\u307e\u3059" : "Main memory data is restored");
            System.arraycopy(byArray, 0, mmrM8, 0, Math.min(byArray.length, mmrMemorySizeCurrent));
            if (byArray.length < mmrMemorySizeCurrent) {
                Arrays.fill(mmrM8, byArray.length, mmrMemorySizeCurrent, (byte)0);
            }
        } else {
            System.out.println(Multilingual.mlnJapanese ? "\u30e1\u30a4\u30f3\u30e1\u30e2\u30ea\u3092\u30bc\u30ed\u30af\u30ea\u30a2\u3057\u307e\u3059" : "Main memory is zero-cleared");
            Arrays.fill(mmrM8, 0, mmrMemorySizeCurrent, (byte)0);
        }
        mmrHumanVersion = 0;
        mmrFEfuncActivated = false;
    }

    public static void mmrReset() {
        mmrMemorySizeCurrent = mmrMemorySizeRequest;
        mmrHumanVersion = 0;
        mmrFEfuncActivated = false;
        XEiJ.busSuper(MemoryMappedDevice.MMD_MMR, 0, 8192);
        XEiJ.busUser(MemoryMappedDevice.MMD_MMR, 8192, mmrMemorySizeCurrent);
        if (mmrMemorySizeCurrent < 0x200000) {
            XEiJ.busUser(MemoryMappedDevice.MMD_MM1, mmrMemorySizeCurrent, 0x200000);
            XEiJ.busSuper(MemoryMappedDevice.MMD_NUL, 0x200000, 0xC00000);
        } else {
            XEiJ.busSuper(MemoryMappedDevice.MMD_NUL, mmrMemorySizeCurrent, 0xC00000);
        }
        MainMemory.mmrSetSupervisorArea(0);
    }

    public static void mmrSetSupervisorArea(int n) {
        int n2 = (n & 0xFF) + 1 << 13;
        if (mmrMemorySizeCurrent < 0x200000) {
            if (n2 < 0x100000) {
                XEiJ.busSuper(MemoryMappedDevice.MMD_MMR, 0, n2);
                XEiJ.busUser(MemoryMappedDevice.MMD_MMR, n2, 0x100000);
                XEiJ.busUser(MemoryMappedDevice.MMD_MM1, 0x100000, 0x200000);
            } else {
                XEiJ.busSuper(MemoryMappedDevice.MMD_MMR, 0, 0x100000);
                XEiJ.busSuper(MemoryMappedDevice.MMD_MM1, 0x100000, n2);
                XEiJ.busUser(MemoryMappedDevice.MMD_MM1, n2, 0x200000);
            }
        } else {
            XEiJ.busSuper(MemoryMappedDevice.MMD_MMR, 0, n2);
            XEiJ.busUser(MemoryMappedDevice.MMD_MMR, n2, 0x200000);
        }
    }

    public static byte mmrRbs(int n) {
        return mmrM8[n & 0xFFFFFF];
    }

    public static int mmrRbz(int n) {
        return mmrM8[n & 0xFFFFFF] & 0xFF;
    }

    public static int mmrRws(int n) {
        return mmrM8[n & 0xFFFFFF] << 8 | mmrM8[n + 1 & 0xFFFFFF] & 0xFF;
    }

    public static int mmrRwz(int n) {
        return (char)(mmrM8[n & 0xFFFFFF] << 8 | mmrM8[n + 1 & 0xFFFFFF] & 0xFF);
    }

    public static int mmrRls(int n) {
        return mmrM8[n & 0xFFFFFF] << 24 | (mmrM8[n + 1 & 0xFFFFFF] & 0xFF) << 16 | (char)(mmrM8[n + 2 & 0xFFFFFF] << 8 | mmrM8[n + 3 & 0xFFFFFF] & 0xFF);
    }

    public static long mmrRqs(int n) {
        return (long)(mmrM8[n & 0xFFFFFF] << 24 | mmrM8[n + 1 & 0xFFFFFF] << 16 & 0xFF0000 | mmrM8[n + 2 & 0xFFFFFF] << 8 & 0xFF00 | mmrM8[n + 3 & 0xFFFFFF] & 0xFF) << 32 | (long)(mmrM8[n + 4 & 0xFFFFFF] << 24 | mmrM8[n + 5 & 0xFFFFFF] << 16 & 0xFF0000 | mmrM8[n + 6 & 0xFFFFFF] << 8 & 0xFF00 | mmrM8[n + 7 & 0xFFFFFF] & 0xFF) & 0xFFFFFFFFL;
    }

    public static void mmrWb(int n, int n2) {
        MainMemory.mmrM8[n & 0xFFFFFF] = (byte)n2;
    }

    public static void mmrWw(int n, int n2) {
        MainMemory.mmrM8[n & 0xFFFFFF] = (byte)(n2 >> 8);
        MainMemory.mmrM8[n + 1 & 0xFFFFFF] = (byte)n2;
    }

    public static void mmrWl(int n, int n2) {
        MainMemory.mmrM8[n & 0xFFFFFF] = (byte)(n2 >> 24);
        MainMemory.mmrM8[n + 1 & 0xFFFFFF] = (byte)(n2 >> 16);
        MainMemory.mmrM8[n + 2 & 0xFFFFFF] = (byte)(n2 >> 8);
        MainMemory.mmrM8[n + 3 & 0xFFFFFF] = (byte)n2;
    }

    public static void mmrWq(int n, long l) {
        MainMemory.mmrM8[n & 0xFFFFFF] = (byte)(l >> 56);
        MainMemory.mmrM8[n + 1 & 0xFFFFFF] = (byte)(l >> 48);
        MainMemory.mmrM8[n + 2 & 0xFFFFFF] = (byte)(l >> 40);
        MainMemory.mmrM8[n + 3 & 0xFFFFFF] = (byte)(l >> 32);
        MainMemory.mmrM8[n + 4 & 0xFFFFFF] = (byte)(l >> 24);
        MainMemory.mmrM8[n + 5 & 0xFFFFFF] = (byte)(l >> 16);
        MainMemory.mmrM8[n + 6 & 0xFFFFFF] = (byte)(l >> 8);
        MainMemory.mmrM8[n + 7 & 0xFFFFFF] = (byte)l;
    }

    public static void mmrWba(int n, int ... nArray) {
        for (int n2 : nArray) {
            MainMemory.mmrWb(n, n2);
            ++n;
        }
    }

    public static void mmrWwa(int n, int ... nArray) {
        for (int n2 : nArray) {
            MainMemory.mmrWw(n, n2);
            n += 2;
        }
    }

    public static void mmrWla(int n, int ... nArray) {
        for (int n2 : nArray) {
            MainMemory.mmrWl(n, n2);
            n += 4;
        }
    }

    public static int mmrStrlen(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (mmrM8[n + i] != 0) continue;
            return i;
        }
        return n2;
    }

    public static String mmrRstr(int n, int n2) {
        return MainMemory.mmrRstr(new StringBuilder(), n, n2).toString();
    }

    public static StringBuilder mmrRstr(StringBuilder stringBuilder, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = MainMemory.mmrRbz(n + i);
            if (129 <= n4 && n4 <= 159 || 224 <= n4 && n4 <= 239) {
                int n5;
                int n6 = n5 = i + 1 < n2 ? MainMemory.mmrRbz(n + i + 1) : 0;
                if (64 <= n5 && n5 != 127 && n5 <= 252) {
                    n3 = CharacterCode.chrSJISToChar[n4 << 8 | n5];
                    if (n3 == 0) {
                        n3 = 8251;
                    }
                    ++i;
                } else {
                    n3 = 46;
                }
            } else {
                n3 = CharacterCode.chrSJISToChar[n4];
                if (n3 < 32 || n3 == 127) {
                    n3 = 46;
                }
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder;
    }

    public static void mmrWstr(int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = CharacterCode.chrCharToSJIS[string.charAt(i)];
            if (c == '\u0000' && string.charAt(i) != '\u0000') {
                MainMemory.mmrWw(n, 33190);
                n += 2;
                continue;
            }
            if (c <= '\u00ff') {
                MainMemory.mmrWb(n, c);
                ++n;
                continue;
            }
            MainMemory.mmrWw(n, c);
            n += 2;
        }
    }

    public static int mmrHumanTop() {
        return mmrHumanVersion == 770 || mmrHumanVersion == 607 ? 33650 : (mmrHumanVersion == 769 ? 33488 : (mmrHumanVersion == 527 ? 33820 : (mmrHumanVersion == 515 ? 32080 : (mmrHumanVersion == 514 ? 32206 : (mmrHumanVersion == 513 ? 32174 : (mmrHumanVersion == 512 ? 32174 : (mmrHumanVersion == 257 ? 68122 : (mmrHumanVersion == 256 ? 68112 : -1))))))));
    }

    public static int mmrHumanBtm() {
        return mmrHumanVersion > 0 ? MC68060.mmuPeekLongData(7168, 1) : -1;
    }

    public static int mmrHumanPmm() {
        return mmrHumanVersion == 770 || mmrHumanVersion == 607 ? MC68060.mmuPeekLongData(81162, 1) : (mmrHumanVersion == 769 ? MC68060.mmuPeekLongData(80884, 1) : (mmrHumanVersion == 527 ? MC68060.mmuPeekLongData(81052, 1) : (mmrHumanVersion == 515 ? MC68060.mmuPeekLongData(76628, 1) : (mmrHumanVersion == 514 ? MC68060.mmuPeekLongData(77256, 1) : (mmrHumanVersion == 513 ? MC68060.mmuPeekLongData(77192, 1) : (mmrHumanVersion == 512 ? MC68060.mmuPeekLongData(77192, 1) : (mmrHumanVersion == 257 ? MC68060.mmuPeekLongData(35474, 1) : (mmrHumanVersion == 256 ? MC68060.mmuPeekLongData(35480, 1) : -1))))))));
    }

    public static int mmrHumanNul() {
        int n = mmrHumanVersion == 770 || mmrHumanVersion == 607 ? 64080 : (mmrHumanVersion == 769 ? 63802 : (mmrHumanVersion == 527 ? 64004 : (mmrHumanVersion == 515 ? 60098 : (mmrHumanVersion == 514 ? 60726 : (mmrHumanVersion == 513 ? 60646 : (mmrHumanVersion == 512 ? 60646 : (mmrHumanVersion == 257 ? 47180 : (mmrHumanVersion == 256 ? 47166 : -1))))))));
        return n >= 0 && MC68060.mmuPeekLongData(n + 14, 1) == 1314212896 && MC68060.mmuPeekLongData(n + 18, 1) == 0x20202020 ? n : -1;
    }

    public static int mmrHumanDev(int n, int n2) {
        int n3 = -1;
        int n4 = MainMemory.mmrHumanNul();
        for (int i = 0; n4 >= 0 && i < 100; ++i) {
            if (MC68060.mmuPeekLongData(n4 + 14, 1) == n && MC68060.mmuPeekLongData(n4 + 18, 1) == n2) {
                n3 = n4;
            }
            n4 = MC68060.mmuPeekLongData(n4, 1);
        }
        return n3;
    }

    public static void mmrCheckHuman() {
        if (mmrHumanVersion != 0) {
            return;
        }
        if (MC68060.mmuPeekLongData(7168, 1) == 0 || MC68060.mmuPeekLongData(7196, 1) != 0) {
            return;
        }
        int n = MC68060.mmuPeekWordZeroData(42164, 1) == 770 ? 770 : (MC68060.mmuPeekWordZeroData(42164, 1) == 607 ? 607 : (MC68060.mmuPeekWordZeroData(41934, 1) == 769 ? 769 : (MC68060.mmuPeekWordZeroData(42242, 1) == 527 ? 527 : (MC68060.mmuPeekWordZeroData(40326, 1) == 515 ? 515 : (MC68060.mmuPeekWordZeroData(40670, 1) == 514 ? 514 : (MC68060.mmuPeekWordZeroData(40684, 1) == 513 ? 513 : (MC68060.mmuPeekWordZeroData(40684, 1) == 512 ? 512 : (MC68060.mmuPeekWordZeroData(39670, 1) == 257 ? 257 : (mmrHumanVersion = MC68060.mmuPeekWordZeroData(39660, 1) == 256 ? 256 : -1)))))))));
        if (mmrHumanVersion < 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        switch (mmrHumanVersion) {
            case 533: {
                if (MC68060.mmuPeekLongData(34540, 1) == 1316618242) {
                    MC68060.mmuPokeLongData(34540, 788623875, 1);
                    MC68060.mmuPokeLongData(34544, 1890340431, 1);
                    MC68060.mmuPokeLongData(34548, 572465224, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekLongData(39514, 1) == 0x8010001) {
                    MC68060.mmuPokeByteData(39517, 0, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(48194, 1) == 20936) {
                    MC68060.mmuPokeByteData(48195, 201, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(55368, 1) == 28759) {
                    MC68060.mmuPokeByteData(55369, 70, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(68328, 1) == 28683) {
                    MC68060.mmuPokeByteData(68329, 15, 1);
                    ++n2;
                    break;
                }
                ++n3;
                break;
            }
            case 769: {
                if (MC68060.mmuPeekLongData(34232, 1) == 1316618242) {
                    MC68060.mmuPokeLongData(34232, 788623875, 1);
                    MC68060.mmuPokeLongData(34236, 1890340431, 1);
                    MC68060.mmuPokeLongData(34240, 572465224, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(39208, 1) == 1) {
                    MC68060.mmuPokeByteData(39209, 0, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(68130, 1) == 28683) {
                    MC68060.mmuPokeByteData(68131, 15, 1);
                    ++n2;
                    break;
                }
                ++n3;
                break;
            }
            case 607: 
            case 770: {
                if (MC68060.mmuPeekLongData(28992, 1) == 461111318) {
                    MC68060.mmuPokeLongData(28992, 1308893705, 1);
                    MC68060.mmuPokeLongData(28996, 448528406, 1);
                    MC68060.mmuPokeLongData(29000, 1374486530, 1);
                    MC68060.mmuPokeLongData(29032, 1627418000, 1);
                    MC68060.mmuPokeLongData(29036, 1308905077, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekLongData(34394, 1) == 1316618242) {
                    MC68060.mmuPokeLongData(34394, 788623875, 1);
                    MC68060.mmuPokeLongData(34398, 1890340431, 1);
                    MC68060.mmuPokeLongData(34402, 572465224, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekLongData(38686, 1) == 726138908) {
                    MC68060.mmuPokeWordData(38686, 18669, 1);
                    MC68060.mmuPokeLongData(38688, 520093724, 1);
                    MC68060.mmuPokeLongData(38692, 537676353, 1);
                    MC68060.mmuPokeLongData(38696, 1711341104, 1);
                    MC68060.mmuPokeLongData(38700, 1308909578, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (XEiJ.currentMPU < 8) {
                    if (MC68060.mmuPeekWordZeroData(39366, 1) == 1) {
                        MC68060.mmuPokeByteData(39367, 0, 1);
                        ++n2;
                    } else {
                        ++n3;
                    }
                }
                if (MC68060.mmuPeekWordZeroData(41100, 1) == 26372 && MC68060.mmuPeekLongData(41102, 1) == 1060896768) {
                    MC68060.mmuPokeLongData(41100, 1728201319, 1);
                    MC68060.mmuPokeWordData(41104, 19972, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(45802, 1) == 12876) {
                    MC68060.mmuPokeByteData(45802, 34, 1);
                    ++n2;
                } else {
                    ++n3;
                }
                if (MC68060.mmuPeekWordZeroData(68408, 1) == 28683) {
                    MC68060.mmuPokeByteData(68409, 15, 1);
                    ++n2;
                    break;
                }
                ++n3;
            }
        }
        if (FEFunction.fpkRejectFloatOn) {
            int n4;
            int n5 = mmrHumanVersion == 770 || mmrHumanVersion == 607 ? 34200 : (mmrHumanVersion == 769 ? 34038 : (mmrHumanVersion == 527 ? 34370 : (mmrHumanVersion == 515 ? 32600 : (mmrHumanVersion == 514 ? 32726 : (mmrHumanVersion == 513 ? 32694 : (n4 = mmrHumanVersion == 512 ? 32694 : -1))))));
            if (n4 > 0) {
                if (MC68060.mmuPeekWordZeroData(-42 + n4, 1) == 26150 && MC68060.mmuPeekLongData(-8 + n4, 1) == -16164721 && MC68060.mmuPeekLongData(-4 + n4, 1) == 1619984128) {
                    MC68060.mmuPokeWordData(-42 + n4, 26146, 1);
                    MC68060.mmuPokeLongData(-8 + n4, 1619984128, 1);
                    MC68060.mmuPokeLongData(-4 + n4, 1178953326, 1);
                    ++n2;
                } else {
                    ++n3;
                }
            }
        }
        System.out.println("Human68k version " + (char)(48 + (mmrHumanVersion >> 8) % 10) + '.' + (char)(48 + (mmrHumanVersion & 0xFF) / 10) + (char)(48 + (mmrHumanVersion & 0xFF) % 10) + (Multilingual.mlnJapanese ? " \u306b\u30d1\u30c3\u30c1\u3092\u3042\u3066\u307e\u3057\u305f (" : " was patched (") + n2 + '/' + (n2 + n3) + ')');
        mmrFEfuncActivated = FEFunction.fpkOn;
        if (mmrFEfuncActivated) {
            System.out.println(Multilingual.mlnJapanese ? "FE \u30d5\u30a1\u30f3\u30af\u30b7\u30e7\u30f3\u547d\u4ee4\u304c\u6709\u52b9\u306b\u306a\u308a\u307e\u3057\u305f" : "FE function instruction has been activated");
        }
    }

    public static int mmrGetLevelZeroPC() {
        int n;
        if (527 <= mmrHumanVersion && (n = MC68060.mmuPeekWordZeroData(7176, XEiJ.regSRS)) != 0) {
            int n2 = MC68060.mmuPeekLongData(7260, XEiJ.regSRS);
            int n3 = MC68060.mmuPeekLongData(n2 + 58, XEiJ.regSRS);
            return n3;
        }
        return 0;
    }
}

