/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import xeij.BranchLog;
import xeij.CharacterCode;
import xeij.DataBreakPoint;
import xeij.FEFunction;
import xeij.HD63450;
import xeij.HFS;
import xeij.IOInterrupt;
import xeij.InstructionBreakPoint;
import xeij.M68kException;
import xeij.MC68901;
import xeij.MainMemory;
import xeij.MemoryMappedDevice;
import xeij.QFP;
import xeij.RootPointerList;
import xeij.TickerQueue;
import xeij.WaitInstruction;
import xeij.XEiJ;
import xeij.Z8530;

public class MC68060 {
    public static final byte[] FP_OFFSET_TO_NUMBER = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u000006453211\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
    static final long MEM_MASK = 0xFFFFFFFFFFF0000L;
    static final long MLT_MASK = 0x3FFFFFFFFFF0000L;
    static final long CNT_MASK = 0xFFFFF0000FF0000L;
    static final long CLT_MASK = 0x3FFFF0000FF0000L;
    public static final boolean MMU_DEBUG_COMMAND = false;
    public static final boolean MMU_DEBUG_TRANSLATION = false;
    public static final boolean MMU_NOT_ALLOCATE_CACHE = false;
    public static final int MMU_ROOT_INDEX_BIT0 = 25;
    public static final int MMU_POINTER_INDEX_BIT0 = 18;
    public static final int MMU_PAGE_INDEX_BIT0_4KB = 12;
    public static final int MMU_PAGE_INDEX_BIT0_8KB = 13;
    public static final int MMU_PAGE_SIZE_4KB = 4096;
    public static final int MMU_PAGE_SIZE_8KB = 8192;
    public static final int MMU_ROOT_INDEX_MASK = -33554432;
    public static final int MMU_POINTER_INDEX_MASK = 33292288;
    public static final int MMU_PAGE_INDEX_MASK_4KB = 258048;
    public static final int MMU_PAGE_INDEX_MASK_8KB = 253952;
    public static final int MMU_PAGE_OFFSET_MASK_4KB = 4095;
    public static final int MMU_PAGE_OFFSET_MASK_8KB = 8191;
    public static final int MMU_PAGE_ADDRESS_MASK_4KB = -4096;
    public static final int MMU_PAGE_ADDRESS_MASK_8KB = -8192;
    public static final int MMU_TTR_BASE = -16777216;
    public static final int MMU_TTR_MASK = 0xFF0000;
    public static final int MMU_TTR_ENABLE = 32768;
    public static final int MMU_TTR_IGNORE_FC2 = 16384;
    public static final int MMU_TTR_USER_SUPERVISOR = 8192;
    public static final int MMU_TTR_US_USER = 0;
    public static final int MMU_TTR_US_SUPERVISOR = 8192;
    public static final int MMU_TTR_WRITE_PROTECT = 4;
    public static int mmuDTT0;
    public static int mmuDTT1;
    public static int mmuITT0;
    public static int mmuITT1;
    public static int[] mmuUserDataTransparent;
    public static int[] mmuUserCodeTransparent;
    public static int[] mmuSuperDataTransparent;
    public static int[] mmuSuperCodeTransparent;
    public static int[] mmuUserDataDifference;
    public static int[] mmuUserCodeDifference;
    public static int[] mmuSuperDataDifference;
    public static int[] mmuSuperCodeDifference;
    public static final int MMU_TCR_ENABLE = 32768;
    public static final int MMU_TCR_PAGE_SIZE = 16384;
    public static final int MMU_TCR_P_4KB = 0;
    public static final int MMU_TCR_P_8KB = 16384;
    public static final int MMU_TCR_NAD = 8192;
    public static final int MMU_TCR_NAI = 4096;
    public static final int MMU_TCR_FOTC = 2048;
    public static final int MMU_TCR_FITC = 1024;
    public static final int MMU_TCR_DCO = 768;
    public static final int MMU_TCR_DUO = 192;
    public static final int MMU_TCR_DWO = 32;
    public static final int MMU_TCR_DCI = 24;
    public static final int MMU_TCR_DUI = 6;
    public static int mmuTCR;
    public static boolean mmuEnabled;
    public static boolean mmu4KB;
    public static boolean mmuNotAllocateData;
    public static boolean mmuNotAllocateCode;
    public static int mmuPageSize;
    public static int mmuPageAddressMask;
    public static int mmuPageOffsetMask;
    public static int mmuPageIndexMask;
    public static int mmuPageIndexBit2;
    public static int mmuPageTableMask;
    public static int mmuURP;
    public static int mmuSRP;
    public static final int MMU_DESCRIPTOR_POINTER_TABLE_ADDRESS = -512;
    public static final int MMU_DESCRIPTOR_PAGE_TABLE_ADDRESS_4KB = -64;
    public static final int MMU_DESCRIPTOR_PAGE_TABLE_ADDRESS_8KB = -32;
    public static final int MMU_DESCRIPTOR_GLOBAL = 1024;
    public static final int MMU_DESCRIPTOR_SUPERVISOR_PROTECTED = 128;
    public static final int MMU_DESCRIPTOR_MODIFIED = 16;
    public static final int MMU_DESCRIPTOR_USED = 8;
    public static final int MMU_DESCRIPTOR_WRITE_PROTECTED = 4;
    public static final int MMU_DESCRIPTOR_UDT = 2;
    public static final int MMU_DESCRIPTOR_PDT = 3;
    public static final int MMU_DESCRIPTOR_TYPE_INVALID = 0;
    public static final int MMU_DESCRIPTOR_TYPE_INDIRECT = 2;
    public static final int MMU_DESCRIPTOR_INDIRECT_ADDRESS = -4;
    public static final int MMU_HASH_BITS = 6;
    public static final int MMU_HASH_SIZE = 64;
    public static final int MMU_HASH_COEFF = 1593577535;
    public static final int MMU_CACHE_WAYS = 1;
    public static final int[] mmuUserDataCache;
    public static final int[] mmuUserCodeCache;
    public static final int[] mmuSuperDataCache;
    public static final int[] mmuSuperCodeCache;
    public static int mmuPeekFlags;
    private static int m60Address;
    private static long m60Incremented;
    private static final int M60_FSLW_MISALIGNED = 0x8000000;
    private static final int M60_FSLW_LOCKED = 0x2000000;
    private static final int M60_FSLW_READ_AND_WRITE = 0x1800000;
    private static final int M60_FSLW_RW_WRITE = 0x800000;
    private static final int M60_FSLW_RW_READ = 0x1000000;
    private static final int M60_FSLW_RW_MODIFY = 0x1800000;
    private static final int M60_FSLW_TRANSFER_SIZE = 0x600000;
    private static final int M60_FSLW_SIZE_LONG = 0;
    private static final int M60_FSLW_SIZE_BYTE = 0x200000;
    private static final int M60_FSLW_SIZE_WORD = 0x400000;
    private static final int M60_FSLW_SIZE_QUAD = 0x600000;
    private static final int M60_FSLW_TRANSFER_TYPE = 0x180000;
    private static final int M60_FSLW_TT_NORMAL = 0;
    private static final int M60_FSLW_TT_MOVE16 = 524288;
    private static final int M60_FSLW_TT_ALTERNATE = 0x100000;
    private static final int M60_FSLW_TT_ACKNOWLEDGE = 0x180000;
    private static final int M60_FSLW_TRANSFER_MODIFIER = 458752;
    private static final int M60_FSLW_TM_CACHE_PUSH = 0;
    private static final int M60_FSLW_TM_USER_DATA = 65536;
    private static final int M60_FSLW_TM_USER_CODE = 131072;
    private static final int M60_FSLW_TM_MMU_DATA = 196608;
    private static final int M60_FSLW_TM_MMU_CODE = 262144;
    private static final int M60_FSLW_TM_SUPER_DATA = 327680;
    private static final int M60_FSLW_TM_SUPER_CODE = 393216;
    private static final int M60_FSLW_TM_DATA = 65536;
    private static final int M60_FSLW_TM_CODE = 131072;
    private static final int M60_FSLW_TM_SUPERVISOR = 262144;
    private static final int M60_FSLW_INSTRUCTION = 32768;
    private static final int M60_FSLW_IOMA_FIRST = 0;
    private static final int M60_FSLW_IOMA_SECOND = 0x8000000;
    private static final int M60_FSLW_IOMA_OPWORD = 32768;
    private static final int M60_FSLW_IOMA_EXWORD = 0x8008000;
    private static final int M60_FSLW_PUSH_BUFFER = 16384;
    private static final int M60_FSLW_STORE_BUFFER = 8192;
    private static final int M60_FSLW_ROOT_DESCRIPTOR = 4096;
    private static final int M60_FSLW_POINTER_DESCRIPTOR = 2048;
    private static final int M60_FSLW_INDIRECT_LEVEL = 1024;
    private static final int M60_FSLW_PAGE_FAULT = 512;
    private static final int M60_FSLW_SUPERVISOR_PROTECT = 256;
    private static final int M60_FSLW_WRITE_PROTECT = 128;
    private static final int M60_FSLW_TABLE_SEARCH = 64;
    private static final int M60_FSLW_BUS_ERROR_ON_READ = 32;
    private static final int M60_FSLW_BUS_ERROR_ON_WRITE = 16;
    private static final int M60_FSLW_TRANSPARENT = 8;
    private static final int M60_FSLW_BRANCH_PREDICTION = 4;
    private static final int M60_FSLW_SOFTWARE_EMULATION = 1;
    private static int m60FSLW;
    private static final String[] M60_FSLW_TEXT_IOMA;
    private static final String[] M60_FSLW_TEXT_LK;
    private static final String[] M60_FSLW_TEXT_RW;
    private static final String[] M60_FSLW_TEXT_SIZE;
    private static final String[] M60_FSLW_TEXT_TT;
    private static final String[] M60_FSLW_TEXT_TM;
    private static final String[] M60_FSLW_TEXT_CAUSE;

    public static void mpuCore() {
        while (XEiJ.mpuClockTime < XEiJ.mpuClockLimit) {
            try {
                while (XEiJ.mpuClockTime < XEiJ.mpuClockLimit) {
                    m60Incremented = 0L;
                    XEiJ.mpuTraceFlag = XEiJ.regSRT1;
                    XEiJ.mpuCycleCount = 0;
                    int n = m60Address = XEiJ.regPC;
                    XEiJ.regPC0 = m60Address;
                    XEiJ.regPC = n + 2;
                    if (XEiJ.regSRS != 0) {
                        m60FSLW = 21397504;
                        n = MC68060.mmuTranslateReadSuperCode(n);
                        XEiJ.regOC = InstructionBreakPoint.ibpOp1SuperMap[n >>> 12].mmdRwz(n);
                    } else {
                        m60FSLW = 21135360;
                        n = MC68060.mmuTranslateReadUserCode(n);
                        XEiJ.regOC = InstructionBreakPoint.ibpOp1UserMap[n >>> 12].mmdRwz(n);
                    }
                    block2 : switch (XEiJ.regOC >>> 6) {
                        case 0: {
                            MC68060.irpOriByte();
                            break;
                        }
                        case 1: {
                            MC68060.irpOriWord();
                            break;
                        }
                        case 2: {
                            MC68060.irpOriLong();
                            break;
                        }
                        case 3: {
                            MC68060.irpCmp2Chk2Byte();
                            break;
                        }
                        case 4: 
                        case 12: 
                        case 20: 
                        case 28: 
                        case 36: 
                        case 44: 
                        case 52: 
                        case 60: {
                            MC68060.irpBtstReg();
                            break;
                        }
                        case 5: 
                        case 13: 
                        case 21: 
                        case 29: 
                        case 37: 
                        case 45: 
                        case 53: 
                        case 61: {
                            MC68060.irpBchgReg();
                            break;
                        }
                        case 6: 
                        case 14: 
                        case 22: 
                        case 30: 
                        case 38: 
                        case 46: 
                        case 54: 
                        case 62: {
                            MC68060.irpBclrReg();
                            break;
                        }
                        case 7: 
                        case 15: 
                        case 23: 
                        case 31: 
                        case 39: 
                        case 47: 
                        case 55: 
                        case 63: {
                            MC68060.irpBsetReg();
                            break;
                        }
                        case 8: {
                            MC68060.irpAndiByte();
                            break;
                        }
                        case 9: {
                            MC68060.irpAndiWord();
                            break;
                        }
                        case 10: {
                            MC68060.irpAndiLong();
                            break;
                        }
                        case 11: {
                            MC68060.irpCmp2Chk2Word();
                            break;
                        }
                        case 16: {
                            MC68060.irpSubiByte();
                            break;
                        }
                        case 17: {
                            MC68060.irpSubiWord();
                            break;
                        }
                        case 18: {
                            MC68060.irpSubiLong();
                            break;
                        }
                        case 19: {
                            MC68060.irpCmp2Chk2Long();
                            break;
                        }
                        case 24: {
                            MC68060.irpAddiByte();
                            break;
                        }
                        case 25: {
                            MC68060.irpAddiWord();
                            break;
                        }
                        case 26: {
                            MC68060.irpAddiLong();
                            break;
                        }
                        case 32: {
                            MC68060.irpBtstImm();
                            break;
                        }
                        case 33: {
                            MC68060.irpBchgImm();
                            break;
                        }
                        case 34: {
                            MC68060.irpBclrImm();
                            break;
                        }
                        case 35: {
                            MC68060.irpBsetImm();
                            break;
                        }
                        case 40: {
                            MC68060.irpEoriByte();
                            break;
                        }
                        case 41: {
                            MC68060.irpEoriWord();
                            break;
                        }
                        case 42: {
                            MC68060.irpEoriLong();
                            break;
                        }
                        case 43: {
                            MC68060.irpCasByte();
                            break;
                        }
                        case 48: {
                            MC68060.irpCmpiByte();
                            break;
                        }
                        case 49: {
                            MC68060.irpCmpiWord();
                            break;
                        }
                        case 50: {
                            MC68060.irpCmpiLong();
                            break;
                        }
                        case 51: {
                            MC68060.irpCasWord();
                            break;
                        }
                        case 56: {
                            MC68060.irpMovesByte();
                            break;
                        }
                        case 57: {
                            MC68060.irpMovesWord();
                            break;
                        }
                        case 58: {
                            MC68060.irpMovesLong();
                            break;
                        }
                        case 59: {
                            MC68060.irpCasLong();
                            break;
                        }
                        case 64: 
                        case 72: 
                        case 80: 
                        case 88: 
                        case 96: 
                        case 104: 
                        case 112: 
                        case 120: {
                            MC68060.irpMoveToDRByte();
                            break;
                        }
                        case 66: 
                        case 74: 
                        case 82: 
                        case 90: 
                        case 98: 
                        case 106: 
                        case 114: 
                        case 122: {
                            MC68060.irpMoveToMMByte();
                            break;
                        }
                        case 67: 
                        case 75: 
                        case 83: 
                        case 91: 
                        case 99: 
                        case 107: 
                        case 115: 
                        case 123: {
                            MC68060.irpMoveToMPByte();
                            break;
                        }
                        case 68: 
                        case 76: 
                        case 84: 
                        case 92: 
                        case 100: 
                        case 108: 
                        case 116: 
                        case 124: {
                            MC68060.irpMoveToMNByte();
                            break;
                        }
                        case 69: 
                        case 77: 
                        case 85: 
                        case 93: 
                        case 101: 
                        case 109: 
                        case 117: 
                        case 125: {
                            MC68060.irpMoveToMWByte();
                            break;
                        }
                        case 70: 
                        case 78: 
                        case 86: 
                        case 94: 
                        case 102: 
                        case 110: 
                        case 118: 
                        case 126: {
                            MC68060.irpMoveToMXByte();
                            break;
                        }
                        case 71: {
                            MC68060.irpMoveToZWByte();
                            break;
                        }
                        case 79: {
                            MC68060.irpMoveToZLByte();
                            break;
                        }
                        case 128: 
                        case 136: 
                        case 144: 
                        case 152: 
                        case 160: 
                        case 168: 
                        case 176: 
                        case 184: {
                            MC68060.irpMoveToDRLong();
                            break;
                        }
                        case 129: 
                        case 137: 
                        case 145: 
                        case 153: 
                        case 161: 
                        case 169: 
                        case 177: 
                        case 185: {
                            MC68060.irpMoveaLong();
                            break;
                        }
                        case 130: 
                        case 138: 
                        case 146: 
                        case 154: 
                        case 162: 
                        case 170: 
                        case 178: 
                        case 186: {
                            MC68060.irpMoveToMMLong();
                            break;
                        }
                        case 131: 
                        case 139: 
                        case 147: 
                        case 155: 
                        case 163: 
                        case 171: 
                        case 179: 
                        case 187: {
                            MC68060.irpMoveToMPLong();
                            break;
                        }
                        case 132: 
                        case 140: 
                        case 148: 
                        case 156: 
                        case 164: 
                        case 172: 
                        case 180: 
                        case 188: {
                            MC68060.irpMoveToMNLong();
                            break;
                        }
                        case 133: 
                        case 141: 
                        case 149: 
                        case 157: 
                        case 165: 
                        case 173: 
                        case 181: 
                        case 189: {
                            MC68060.irpMoveToMWLong();
                            break;
                        }
                        case 134: 
                        case 142: 
                        case 150: 
                        case 158: 
                        case 166: 
                        case 174: 
                        case 182: 
                        case 190: {
                            MC68060.irpMoveToMXLong();
                            break;
                        }
                        case 135: {
                            MC68060.irpMoveToZWLong();
                            break;
                        }
                        case 143: {
                            MC68060.irpMoveToZLLong();
                            break;
                        }
                        case 192: 
                        case 200: 
                        case 208: 
                        case 216: 
                        case 224: 
                        case 232: 
                        case 240: 
                        case 248: {
                            MC68060.irpMoveToDRWord();
                            break;
                        }
                        case 193: 
                        case 201: 
                        case 209: 
                        case 217: 
                        case 225: 
                        case 233: 
                        case 241: 
                        case 249: {
                            MC68060.irpMoveaWord();
                            break;
                        }
                        case 194: 
                        case 202: 
                        case 210: 
                        case 218: 
                        case 226: 
                        case 234: 
                        case 242: 
                        case 250: {
                            MC68060.irpMoveToMMWord();
                            break;
                        }
                        case 195: 
                        case 203: 
                        case 211: 
                        case 219: 
                        case 227: 
                        case 235: 
                        case 243: 
                        case 251: {
                            MC68060.irpMoveToMPWord();
                            break;
                        }
                        case 196: 
                        case 204: 
                        case 212: 
                        case 220: 
                        case 228: 
                        case 236: 
                        case 244: 
                        case 252: {
                            MC68060.irpMoveToMNWord();
                            break;
                        }
                        case 197: 
                        case 205: 
                        case 213: 
                        case 221: 
                        case 229: 
                        case 237: 
                        case 245: 
                        case 253: {
                            MC68060.irpMoveToMWWord();
                            break;
                        }
                        case 198: 
                        case 206: 
                        case 214: 
                        case 222: 
                        case 230: 
                        case 238: 
                        case 246: 
                        case 254: {
                            MC68060.irpMoveToMXWord();
                            break;
                        }
                        case 199: {
                            MC68060.irpMoveToZWWord();
                            break;
                        }
                        case 207: {
                            MC68060.irpMoveToZLWord();
                            break;
                        }
                        case 256: {
                            MC68060.irpNegxByte();
                            break;
                        }
                        case 257: {
                            MC68060.irpNegxWord();
                            break;
                        }
                        case 258: {
                            MC68060.irpNegxLong();
                            break;
                        }
                        case 259: {
                            MC68060.irpMoveFromSR();
                            break;
                        }
                        case 260: 
                        case 268: 
                        case 276: 
                        case 284: 
                        case 292: 
                        case 300: 
                        case 308: 
                        case 316: {
                            MC68060.irpChkLong();
                            break;
                        }
                        case 262: 
                        case 270: 
                        case 278: 
                        case 286: 
                        case 294: 
                        case 302: 
                        case 310: 
                        case 318: {
                            MC68060.irpChkWord();
                            break;
                        }
                        case 263: 
                        case 271: 
                        case 279: 
                        case 287: 
                        case 295: 
                        case 303: 
                        case 311: 
                        case 319: {
                            MC68060.irpLea();
                            break;
                        }
                        case 264: {
                            MC68060.irpClrByte();
                            break;
                        }
                        case 265: {
                            MC68060.irpClrWord();
                            break;
                        }
                        case 266: {
                            MC68060.irpClrLong();
                            break;
                        }
                        case 267: {
                            MC68060.irpMoveFromCCR();
                            break;
                        }
                        case 272: {
                            MC68060.irpNegByte();
                            break;
                        }
                        case 273: {
                            MC68060.irpNegWord();
                            break;
                        }
                        case 274: {
                            MC68060.irpNegLong();
                            break;
                        }
                        case 275: {
                            MC68060.irpMoveToCCR();
                            break;
                        }
                        case 280: {
                            MC68060.irpNotByte();
                            break;
                        }
                        case 281: {
                            MC68060.irpNotWord();
                            break;
                        }
                        case 282: {
                            MC68060.irpNotLong();
                            break;
                        }
                        case 283: {
                            MC68060.irpMoveToSR();
                            break;
                        }
                        case 288: {
                            MC68060.irpNbcd();
                            break;
                        }
                        case 289: {
                            MC68060.irpPea();
                            break;
                        }
                        case 290: {
                            MC68060.irpMovemToMemWord();
                            break;
                        }
                        case 291: {
                            MC68060.irpMovemToMemLong();
                            break;
                        }
                        case 296: {
                            MC68060.irpTstByte();
                            break;
                        }
                        case 297: {
                            MC68060.irpTstWord();
                            break;
                        }
                        case 298: {
                            MC68060.irpTstLong();
                            break;
                        }
                        case 299: {
                            MC68060.irpTas();
                            break;
                        }
                        case 304: {
                            MC68060.irpMuluMulsLong();
                            break;
                        }
                        case 305: {
                            MC68060.irpDivuDivsLong();
                            break;
                        }
                        case 306: {
                            MC68060.irpMovemToRegWord();
                            break;
                        }
                        case 307: {
                            MC68060.irpMovemToRegLong();
                            break;
                        }
                        case 313: {
                            switch (XEiJ.regOC & 0x3F) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: {
                                    MC68060.irpTrap();
                                    break block2;
                                }
                                case 15: {
                                    MC68060.irpTrap15();
                                    break block2;
                                }
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: {
                                    MC68060.irpLinkWord();
                                    break block2;
                                }
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: {
                                    MC68060.irpUnlk();
                                    break block2;
                                }
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: {
                                    MC68060.irpMoveToUsp();
                                    break block2;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    MC68060.irpMoveFromUsp();
                                    break block2;
                                }
                                case 48: {
                                    MC68060.irpReset();
                                    break block2;
                                }
                                case 49: {
                                    MC68060.irpNop();
                                    break block2;
                                }
                                case 50: {
                                    MC68060.irpStop();
                                    break block2;
                                }
                                case 51: {
                                    MC68060.irpRte();
                                    break block2;
                                }
                                case 52: {
                                    MC68060.irpRtd();
                                    break block2;
                                }
                                case 53: {
                                    MC68060.irpRts();
                                    break block2;
                                }
                                case 54: {
                                    MC68060.irpTrapv();
                                    break block2;
                                }
                                case 55: {
                                    MC68060.irpRtr();
                                    break block2;
                                }
                                case 58: {
                                    MC68060.irpMovecFromControl();
                                    break block2;
                                }
                                case 59: {
                                    MC68060.irpMovecToControl();
                                    break block2;
                                }
                            }
                            MC68060.irpIllegal();
                            break;
                        }
                        case 314: {
                            MC68060.irpJsr();
                            break;
                        }
                        case 315: {
                            MC68060.irpJmp();
                            break;
                        }
                        case 320: 
                        case 328: 
                        case 336: 
                        case 344: 
                        case 352: 
                        case 360: 
                        case 368: 
                        case 376: {
                            MC68060.irpAddqByte();
                            break;
                        }
                        case 321: 
                        case 329: 
                        case 337: 
                        case 345: 
                        case 353: 
                        case 361: 
                        case 369: 
                        case 377: {
                            MC68060.irpAddqWord();
                            break;
                        }
                        case 322: 
                        case 330: 
                        case 338: 
                        case 346: 
                        case 354: 
                        case 362: 
                        case 370: 
                        case 378: {
                            MC68060.irpAddqLong();
                            break;
                        }
                        case 323: {
                            MC68060.irpSt();
                            break;
                        }
                        case 324: 
                        case 332: 
                        case 340: 
                        case 348: 
                        case 356: 
                        case 364: 
                        case 372: 
                        case 380: {
                            MC68060.irpSubqByte();
                            break;
                        }
                        case 325: 
                        case 333: 
                        case 341: 
                        case 349: 
                        case 357: 
                        case 365: 
                        case 373: 
                        case 381: {
                            MC68060.irpSubqWord();
                            break;
                        }
                        case 326: 
                        case 334: 
                        case 342: 
                        case 350: 
                        case 358: 
                        case 366: 
                        case 374: 
                        case 382: {
                            MC68060.irpSubqLong();
                            break;
                        }
                        case 327: {
                            MC68060.irpSf();
                            break;
                        }
                        case 331: {
                            MC68060.irpShi();
                            break;
                        }
                        case 335: {
                            MC68060.irpSls();
                            break;
                        }
                        case 339: {
                            MC68060.irpShs();
                            break;
                        }
                        case 343: {
                            MC68060.irpSlo();
                            break;
                        }
                        case 347: {
                            MC68060.irpSne();
                            break;
                        }
                        case 351: {
                            MC68060.irpSeq();
                            break;
                        }
                        case 355: {
                            MC68060.irpSvc();
                            break;
                        }
                        case 359: {
                            MC68060.irpSvs();
                            break;
                        }
                        case 363: {
                            MC68060.irpSpl();
                            break;
                        }
                        case 367: {
                            MC68060.irpSmi();
                            break;
                        }
                        case 371: {
                            MC68060.irpSge();
                            break;
                        }
                        case 375: {
                            MC68060.irpSlt();
                            break;
                        }
                        case 379: {
                            MC68060.irpSgt();
                            break;
                        }
                        case 383: {
                            MC68060.irpSle();
                            break;
                        }
                        case 384: {
                            MC68060.irpBrasw();
                            break;
                        }
                        case 385: 
                        case 386: {
                            MC68060.irpBras();
                            break;
                        }
                        case 387: {
                            MC68060.irpBrasl();
                            break;
                        }
                        case 388: {
                            MC68060.irpBsrsw();
                            break;
                        }
                        case 389: 
                        case 390: {
                            MC68060.irpBsrs();
                            break;
                        }
                        case 391: {
                            MC68060.irpBsrsl();
                            break;
                        }
                        case 392: {
                            MC68060.irpBhisw();
                            break;
                        }
                        case 393: 
                        case 394: {
                            MC68060.irpBhis();
                            break;
                        }
                        case 395: {
                            MC68060.irpBhisl();
                            break;
                        }
                        case 396: {
                            MC68060.irpBlssw();
                            break;
                        }
                        case 397: 
                        case 398: {
                            MC68060.irpBlss();
                            break;
                        }
                        case 399: {
                            MC68060.irpBlssl();
                            break;
                        }
                        case 400: {
                            MC68060.irpBhssw();
                            break;
                        }
                        case 401: 
                        case 402: {
                            MC68060.irpBhss();
                            break;
                        }
                        case 403: {
                            MC68060.irpBhssl();
                            break;
                        }
                        case 404: {
                            MC68060.irpBlosw();
                            break;
                        }
                        case 405: 
                        case 406: {
                            MC68060.irpBlos();
                            break;
                        }
                        case 407: {
                            MC68060.irpBlosl();
                            break;
                        }
                        case 408: {
                            MC68060.irpBnesw();
                            break;
                        }
                        case 409: 
                        case 410: {
                            MC68060.irpBnes();
                            break;
                        }
                        case 411: {
                            MC68060.irpBnesl();
                            break;
                        }
                        case 412: {
                            MC68060.irpBeqsw();
                            break;
                        }
                        case 413: 
                        case 414: {
                            MC68060.irpBeqs();
                            break;
                        }
                        case 415: {
                            MC68060.irpBeqsl();
                            break;
                        }
                        case 416: {
                            MC68060.irpBvcsw();
                            break;
                        }
                        case 417: 
                        case 418: {
                            MC68060.irpBvcs();
                            break;
                        }
                        case 419: {
                            MC68060.irpBvcsl();
                            break;
                        }
                        case 420: {
                            MC68060.irpBvssw();
                            break;
                        }
                        case 421: 
                        case 422: {
                            MC68060.irpBvss();
                            break;
                        }
                        case 423: {
                            MC68060.irpBvssl();
                            break;
                        }
                        case 424: {
                            MC68060.irpBplsw();
                            break;
                        }
                        case 425: 
                        case 426: {
                            MC68060.irpBpls();
                            break;
                        }
                        case 427: {
                            MC68060.irpBplsl();
                            break;
                        }
                        case 428: {
                            MC68060.irpBmisw();
                            break;
                        }
                        case 429: 
                        case 430: {
                            MC68060.irpBmis();
                            break;
                        }
                        case 431: {
                            MC68060.irpBmisl();
                            break;
                        }
                        case 432: {
                            MC68060.irpBgesw();
                            break;
                        }
                        case 433: 
                        case 434: {
                            MC68060.irpBges();
                            break;
                        }
                        case 435: {
                            MC68060.irpBgesl();
                            break;
                        }
                        case 436: {
                            MC68060.irpBltsw();
                            break;
                        }
                        case 437: 
                        case 438: {
                            MC68060.irpBlts();
                            break;
                        }
                        case 439: {
                            MC68060.irpBltsl();
                            break;
                        }
                        case 440: {
                            MC68060.irpBgtsw();
                            break;
                        }
                        case 441: 
                        case 442: {
                            MC68060.irpBgts();
                            break;
                        }
                        case 443: {
                            MC68060.irpBgtsl();
                            break;
                        }
                        case 444: {
                            MC68060.irpBlesw();
                            break;
                        }
                        case 445: 
                        case 446: {
                            MC68060.irpBles();
                            break;
                        }
                        case 447: {
                            MC68060.irpBlesl();
                            break;
                        }
                        case 448: 
                        case 449: 
                        case 450: 
                        case 451: 
                        case 456: 
                        case 457: 
                        case 458: 
                        case 459: 
                        case 464: 
                        case 465: 
                        case 466: 
                        case 467: 
                        case 472: 
                        case 473: 
                        case 474: 
                        case 475: 
                        case 480: 
                        case 481: 
                        case 482: 
                        case 483: 
                        case 488: 
                        case 489: 
                        case 490: 
                        case 491: 
                        case 496: 
                        case 497: 
                        case 498: 
                        case 499: 
                        case 504: 
                        case 505: 
                        case 506: 
                        case 507: {
                            MC68060.irpMoveq();
                            break;
                        }
                        case 452: 
                        case 460: 
                        case 468: 
                        case 476: 
                        case 484: 
                        case 492: 
                        case 500: 
                        case 508: {
                            MC68060.irpMvsByte();
                            break;
                        }
                        case 453: 
                        case 461: 
                        case 469: 
                        case 477: 
                        case 485: 
                        case 493: 
                        case 501: 
                        case 509: {
                            MC68060.irpMvsWord();
                            break;
                        }
                        case 454: 
                        case 462: 
                        case 470: 
                        case 478: 
                        case 486: 
                        case 494: 
                        case 502: 
                        case 510: {
                            MC68060.irpMvzByte();
                            break;
                        }
                        case 455: 
                        case 463: 
                        case 471: 
                        case 479: 
                        case 487: 
                        case 495: 
                        case 503: 
                        case 511: {
                            MC68060.irpMvzWord();
                            break;
                        }
                        case 512: 
                        case 520: 
                        case 528: 
                        case 536: 
                        case 544: 
                        case 552: 
                        case 560: 
                        case 568: {
                            MC68060.irpOrToRegByte();
                            break;
                        }
                        case 513: 
                        case 521: 
                        case 529: 
                        case 537: 
                        case 545: 
                        case 553: 
                        case 561: 
                        case 569: {
                            MC68060.irpOrToRegWord();
                            break;
                        }
                        case 514: 
                        case 522: 
                        case 530: 
                        case 538: 
                        case 546: 
                        case 554: 
                        case 562: 
                        case 570: {
                            MC68060.irpOrToRegLong();
                            break;
                        }
                        case 515: 
                        case 523: 
                        case 531: 
                        case 539: 
                        case 547: 
                        case 555: 
                        case 563: 
                        case 571: {
                            MC68060.irpDivuWord();
                            break;
                        }
                        case 516: 
                        case 524: 
                        case 532: 
                        case 540: 
                        case 548: 
                        case 556: 
                        case 564: 
                        case 572: {
                            MC68060.irpOrToMemByte();
                            break;
                        }
                        case 517: 
                        case 525: 
                        case 533: 
                        case 541: 
                        case 549: 
                        case 557: 
                        case 565: 
                        case 573: {
                            MC68060.irpOrToMemWord();
                            break;
                        }
                        case 518: 
                        case 526: 
                        case 534: 
                        case 542: 
                        case 550: 
                        case 558: 
                        case 566: 
                        case 574: {
                            MC68060.irpOrToMemLong();
                            break;
                        }
                        case 519: 
                        case 527: 
                        case 535: 
                        case 543: 
                        case 551: 
                        case 559: 
                        case 567: 
                        case 575: {
                            MC68060.irpDivsWord();
                            break;
                        }
                        case 576: 
                        case 584: 
                        case 592: 
                        case 600: 
                        case 608: 
                        case 616: 
                        case 624: 
                        case 632: {
                            MC68060.irpSubToRegByte();
                            break;
                        }
                        case 577: 
                        case 585: 
                        case 593: 
                        case 601: 
                        case 609: 
                        case 617: 
                        case 625: 
                        case 633: {
                            MC68060.irpSubToRegWord();
                            break;
                        }
                        case 578: 
                        case 586: 
                        case 594: 
                        case 602: 
                        case 610: 
                        case 618: 
                        case 626: 
                        case 634: {
                            MC68060.irpSubToRegLong();
                            break;
                        }
                        case 579: 
                        case 587: 
                        case 595: 
                        case 603: 
                        case 611: 
                        case 619: 
                        case 627: 
                        case 635: {
                            MC68060.irpSubaWord();
                            break;
                        }
                        case 580: 
                        case 588: 
                        case 596: 
                        case 604: 
                        case 612: 
                        case 620: 
                        case 628: 
                        case 636: {
                            MC68060.irpSubToMemByte();
                            break;
                        }
                        case 581: 
                        case 589: 
                        case 597: 
                        case 605: 
                        case 613: 
                        case 621: 
                        case 629: 
                        case 637: {
                            MC68060.irpSubToMemWord();
                            break;
                        }
                        case 582: 
                        case 590: 
                        case 598: 
                        case 606: 
                        case 614: 
                        case 622: 
                        case 630: 
                        case 638: {
                            MC68060.irpSubToMemLong();
                            break;
                        }
                        case 583: 
                        case 591: 
                        case 599: 
                        case 607: 
                        case 615: 
                        case 623: 
                        case 631: 
                        case 639: {
                            MC68060.irpSubaLong();
                            break;
                        }
                        case 640: 
                        case 641: 
                        case 642: 
                        case 643: 
                        case 644: 
                        case 645: 
                        case 646: 
                        case 647: 
                        case 648: 
                        case 649: 
                        case 650: 
                        case 651: 
                        case 652: 
                        case 653: 
                        case 654: 
                        case 655: 
                        case 656: 
                        case 657: 
                        case 658: 
                        case 659: 
                        case 660: 
                        case 661: 
                        case 662: 
                        case 663: 
                        case 664: 
                        case 665: 
                        case 666: 
                        case 667: 
                        case 668: 
                        case 669: 
                        case 670: 
                        case 671: 
                        case 672: 
                        case 673: 
                        case 674: 
                        case 675: 
                        case 676: 
                        case 677: 
                        case 678: 
                        case 679: 
                        case 680: 
                        case 681: 
                        case 682: 
                        case 683: 
                        case 684: 
                        case 685: 
                        case 686: 
                        case 687: 
                        case 688: 
                        case 689: 
                        case 690: 
                        case 691: 
                        case 692: 
                        case 693: 
                        case 694: 
                        case 695: 
                        case 696: 
                        case 697: 
                        case 698: 
                        case 699: 
                        case 700: 
                        case 701: 
                        case 702: 
                        case 703: {
                            MC68060.irpAline();
                            break;
                        }
                        case 704: 
                        case 712: 
                        case 720: 
                        case 728: 
                        case 736: 
                        case 744: 
                        case 752: 
                        case 760: {
                            MC68060.irpCmpByte();
                            break;
                        }
                        case 705: 
                        case 713: 
                        case 721: 
                        case 729: 
                        case 737: 
                        case 745: 
                        case 753: 
                        case 761: {
                            MC68060.irpCmpWord();
                            break;
                        }
                        case 706: 
                        case 714: 
                        case 722: 
                        case 730: 
                        case 738: 
                        case 746: 
                        case 754: 
                        case 762: {
                            MC68060.irpCmpLong();
                            break;
                        }
                        case 707: 
                        case 715: 
                        case 723: 
                        case 731: 
                        case 739: 
                        case 747: 
                        case 755: 
                        case 763: {
                            MC68060.irpCmpaWord();
                            break;
                        }
                        case 708: 
                        case 716: 
                        case 724: 
                        case 732: 
                        case 740: 
                        case 748: 
                        case 756: 
                        case 764: {
                            MC68060.irpEorByte();
                            break;
                        }
                        case 709: 
                        case 717: 
                        case 725: 
                        case 733: 
                        case 741: 
                        case 749: 
                        case 757: 
                        case 765: {
                            MC68060.irpEorWord();
                            break;
                        }
                        case 710: 
                        case 718: 
                        case 726: 
                        case 734: 
                        case 742: 
                        case 750: 
                        case 758: 
                        case 766: {
                            MC68060.irpEorLong();
                            break;
                        }
                        case 711: 
                        case 719: 
                        case 727: 
                        case 735: 
                        case 743: 
                        case 751: 
                        case 759: 
                        case 767: {
                            MC68060.irpCmpaLong();
                            break;
                        }
                        case 768: 
                        case 776: 
                        case 784: 
                        case 792: 
                        case 800: 
                        case 808: 
                        case 816: 
                        case 824: {
                            MC68060.irpAndToRegByte();
                            break;
                        }
                        case 769: 
                        case 777: 
                        case 785: 
                        case 793: 
                        case 801: 
                        case 809: 
                        case 817: 
                        case 825: {
                            MC68060.irpAndToRegWord();
                            break;
                        }
                        case 770: 
                        case 778: 
                        case 786: 
                        case 794: 
                        case 802: 
                        case 810: 
                        case 818: 
                        case 826: {
                            MC68060.irpAndToRegLong();
                            break;
                        }
                        case 771: 
                        case 779: 
                        case 787: 
                        case 795: 
                        case 803: 
                        case 811: 
                        case 819: 
                        case 827: {
                            MC68060.irpMuluWord();
                            break;
                        }
                        case 772: 
                        case 780: 
                        case 788: 
                        case 796: 
                        case 804: 
                        case 812: 
                        case 820: 
                        case 828: {
                            MC68060.irpAndToMemByte();
                            break;
                        }
                        case 773: 
                        case 781: 
                        case 789: 
                        case 797: 
                        case 805: 
                        case 813: 
                        case 821: 
                        case 829: {
                            MC68060.irpAndToMemWord();
                            break;
                        }
                        case 774: 
                        case 782: 
                        case 790: 
                        case 798: 
                        case 806: 
                        case 814: 
                        case 822: 
                        case 830: {
                            MC68060.irpAndToMemLong();
                            break;
                        }
                        case 775: 
                        case 783: 
                        case 791: 
                        case 799: 
                        case 807: 
                        case 815: 
                        case 823: 
                        case 831: {
                            MC68060.irpMulsWord();
                            break;
                        }
                        case 832: 
                        case 840: 
                        case 848: 
                        case 856: 
                        case 864: 
                        case 872: 
                        case 880: 
                        case 888: {
                            MC68060.irpAddToRegByte();
                            break;
                        }
                        case 833: 
                        case 841: 
                        case 849: 
                        case 857: 
                        case 865: 
                        case 873: 
                        case 881: 
                        case 889: {
                            MC68060.irpAddToRegWord();
                            break;
                        }
                        case 834: 
                        case 842: 
                        case 850: 
                        case 858: 
                        case 866: 
                        case 874: 
                        case 882: 
                        case 890: {
                            MC68060.irpAddToRegLong();
                            break;
                        }
                        case 835: 
                        case 843: 
                        case 851: 
                        case 859: 
                        case 867: 
                        case 875: 
                        case 883: 
                        case 891: {
                            MC68060.irpAddaWord();
                            break;
                        }
                        case 836: 
                        case 844: 
                        case 852: 
                        case 860: 
                        case 868: 
                        case 876: 
                        case 884: 
                        case 892: {
                            MC68060.irpAddToMemByte();
                            break;
                        }
                        case 837: 
                        case 845: 
                        case 853: 
                        case 861: 
                        case 869: 
                        case 877: 
                        case 885: 
                        case 893: {
                            MC68060.irpAddToMemWord();
                            break;
                        }
                        case 838: 
                        case 846: 
                        case 854: 
                        case 862: 
                        case 870: 
                        case 878: 
                        case 886: 
                        case 894: {
                            MC68060.irpAddToMemLong();
                            break;
                        }
                        case 839: 
                        case 847: 
                        case 855: 
                        case 863: 
                        case 871: 
                        case 879: 
                        case 887: 
                        case 895: {
                            MC68060.irpAddaLong();
                            break;
                        }
                        case 896: 
                        case 904: 
                        case 912: 
                        case 920: 
                        case 928: 
                        case 936: 
                        case 944: 
                        case 952: {
                            MC68060.irpXxrToRegByte();
                            break;
                        }
                        case 897: 
                        case 905: 
                        case 913: 
                        case 921: 
                        case 929: 
                        case 937: 
                        case 945: 
                        case 953: {
                            MC68060.irpXxrToRegWord();
                            break;
                        }
                        case 898: 
                        case 906: 
                        case 914: 
                        case 922: 
                        case 930: 
                        case 938: 
                        case 946: 
                        case 954: {
                            MC68060.irpXxrToRegLong();
                            break;
                        }
                        case 899: {
                            MC68060.irpAsrToMem();
                            break;
                        }
                        case 900: 
                        case 908: 
                        case 916: 
                        case 924: 
                        case 932: 
                        case 940: 
                        case 948: 
                        case 956: {
                            MC68060.irpXxlToRegByte();
                            break;
                        }
                        case 901: 
                        case 909: 
                        case 917: 
                        case 925: 
                        case 933: 
                        case 941: 
                        case 949: 
                        case 957: {
                            MC68060.irpXxlToRegWord();
                            break;
                        }
                        case 902: 
                        case 910: 
                        case 918: 
                        case 926: 
                        case 934: 
                        case 942: 
                        case 950: 
                        case 958: {
                            MC68060.irpXxlToRegLong();
                            break;
                        }
                        case 903: {
                            MC68060.irpAslToMem();
                            break;
                        }
                        case 907: {
                            MC68060.irpLsrToMem();
                            break;
                        }
                        case 911: {
                            MC68060.irpLslToMem();
                            break;
                        }
                        case 915: {
                            MC68060.irpRoxrToMem();
                            break;
                        }
                        case 919: {
                            MC68060.irpRoxlToMem();
                            break;
                        }
                        case 923: {
                            MC68060.irpRorToMem();
                            break;
                        }
                        case 927: {
                            MC68060.irpRolToMem();
                            break;
                        }
                        case 931: {
                            MC68060.irpBftst();
                            break;
                        }
                        case 935: {
                            MC68060.irpBfextu();
                            break;
                        }
                        case 939: {
                            MC68060.irpBfchg();
                            break;
                        }
                        case 943: {
                            MC68060.irpBfexts();
                            break;
                        }
                        case 947: {
                            MC68060.irpBfclr();
                            break;
                        }
                        case 951: {
                            MC68060.irpBfffo();
                            break;
                        }
                        case 955: {
                            MC68060.irpBfset();
                            break;
                        }
                        case 959: {
                            MC68060.irpBfins();
                            break;
                        }
                        case 968: {
                            MC68060.irpFgen();
                            break;
                        }
                        case 969: {
                            MC68060.irpFscc();
                            break;
                        }
                        case 970: {
                            MC68060.irpFbccWord();
                            break;
                        }
                        case 971: {
                            MC68060.irpFbccLong();
                            break;
                        }
                        case 972: {
                            MC68060.irpFsave();
                            break;
                        }
                        case 973: {
                            MC68060.irpFrestore();
                            break;
                        }
                        case 976: {
                            MC68060.irpCinvCpushNC();
                            break;
                        }
                        case 977: {
                            MC68060.irpCinvCpushDC();
                            break;
                        }
                        case 978: {
                            MC68060.irpCinvCpushIC();
                            break;
                        }
                        case 979: {
                            MC68060.irpCinvCpushBC();
                            break;
                        }
                        case 980: {
                            MC68060.irpPflush();
                            break;
                        }
                        case 982: {
                            MC68060.irpPlpaw();
                            break;
                        }
                        case 983: {
                            MC68060.irpPlpar();
                            break;
                        }
                        case 984: {
                            MC68060.irpMove16();
                            break;
                        }
                        case 992: {
                            MC68060.irpLpstop();
                            break;
                        }
                        case 1016: 
                        case 1017: 
                        case 1018: 
                        case 1019: {
                            MC68060.irpFpack();
                            break;
                        }
                        case 960: 
                        case 961: 
                        case 962: 
                        case 963: 
                        case 964: 
                        case 965: 
                        case 966: 
                        case 967: 
                        case 974: 
                        case 975: 
                        case 981: 
                        case 985: 
                        case 986: 
                        case 987: 
                        case 988: 
                        case 989: 
                        case 990: 
                        case 991: 
                        case 993: 
                        case 994: 
                        case 995: 
                        case 996: 
                        case 997: 
                        case 998: 
                        case 999: 
                        case 1000: 
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1004: 
                        case 1005: 
                        case 1006: 
                        case 1007: 
                        case 1008: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 1012: 
                        case 1013: 
                        case 1014: 
                        case 1015: 
                        case 1020: 
                        case 1021: 
                        case 1022: 
                        case 1023: {
                            MC68060.irpFline();
                            break;
                        }
                        case 312: {
                            MC68060.irpEmx();
                            break;
                        }
                        default: {
                            MC68060.irpIllegal();
                        }
                    }
                    if (XEiJ.mpuTraceFlag != 0) {
                        MC68060.irpExceptionFormat2(36, XEiJ.regPC, XEiJ.regPC0);
                    }
                    TickerQueue.tkqRun(XEiJ.mpuClockTime += XEiJ.mpuModifiedUnit * (long)XEiJ.mpuCycleCount);
                    n = XEiJ.mpuIMR & XEiJ.mpuIRR;
                    if (n != 0) {
                        switch (n) {
                            case 1: 
                            case 3: 
                            case 5: 
                            case 7: 
                            case 9: 
                            case 11: 
                            case 13: 
                            case 15: 
                            case 17: 
                            case 19: 
                            case 21: 
                            case 23: 
                            case 25: 
                            case 27: 
                            case 29: 
                            case 31: 
                            case 33: 
                            case 35: 
                            case 37: 
                            case 39: 
                            case 41: 
                            case 43: 
                            case 45: 
                            case 47: 
                            case 49: 
                            case 51: 
                            case 53: 
                            case 55: 
                            case 57: 
                            case 59: 
                            case 61: 
                            case 63: 
                            case 65: 
                            case 67: 
                            case 69: 
                            case 71: 
                            case 73: 
                            case 75: 
                            case 77: 
                            case 79: 
                            case 81: 
                            case 83: 
                            case 85: 
                            case 87: 
                            case 89: 
                            case 91: 
                            case 93: 
                            case 95: 
                            case 97: 
                            case 99: 
                            case 101: 
                            case 103: 
                            case 105: 
                            case 107: 
                            case 109: 
                            case 111: 
                            case 113: 
                            case 115: 
                            case 117: 
                            case 119: 
                            case 121: 
                            case 123: 
                            case 125: 
                            case 127: 
                            case 129: 
                            case 131: 
                            case 133: 
                            case 135: 
                            case 137: 
                            case 139: 
                            case 141: 
                            case 143: 
                            case 145: 
                            case 147: 
                            case 149: 
                            case 151: 
                            case 153: 
                            case 155: 
                            case 157: 
                            case 159: 
                            case 161: 
                            case 163: 
                            case 165: 
                            case 167: 
                            case 169: 
                            case 171: 
                            case 173: 
                            case 175: 
                            case 177: 
                            case 179: 
                            case 181: 
                            case 183: 
                            case 185: 
                            case 187: 
                            case 189: 
                            case 191: 
                            case 193: 
                            case 195: 
                            case 197: 
                            case 199: 
                            case 201: 
                            case 203: 
                            case 205: 
                            case 207: 
                            case 209: 
                            case 211: 
                            case 213: 
                            case 215: 
                            case 217: 
                            case 219: 
                            case 221: 
                            case 223: 
                            case 225: 
                            case 227: 
                            case 229: 
                            case 231: 
                            case 233: 
                            case 235: 
                            case 237: 
                            case 239: 
                            case 241: 
                            case 243: 
                            case 245: 
                            case 247: 
                            case 249: 
                            case 251: 
                            case 253: 
                            case 255: {
                                XEiJ.mpuIRR &= 0xFFFFFFFE;
                                n = XEiJ.sysAcknowledge();
                                if (n == 0) break;
                                MC68060.irpInterrupt(n << 2, 7);
                                break;
                            }
                            case 2: 
                            case 6: 
                            case 10: 
                            case 14: 
                            case 18: 
                            case 22: 
                            case 26: 
                            case 30: 
                            case 34: 
                            case 38: 
                            case 42: 
                            case 46: 
                            case 50: 
                            case 54: 
                            case 58: 
                            case 62: 
                            case 66: 
                            case 70: 
                            case 74: 
                            case 78: 
                            case 82: 
                            case 86: 
                            case 90: 
                            case 94: 
                            case 98: 
                            case 102: 
                            case 106: 
                            case 110: 
                            case 114: 
                            case 118: 
                            case 122: 
                            case 126: 
                            case 130: 
                            case 134: 
                            case 138: 
                            case 142: 
                            case 146: 
                            case 150: 
                            case 154: 
                            case 158: 
                            case 162: 
                            case 166: 
                            case 170: 
                            case 174: 
                            case 178: 
                            case 182: 
                            case 186: 
                            case 190: 
                            case 194: 
                            case 198: 
                            case 202: 
                            case 206: 
                            case 210: 
                            case 214: 
                            case 218: 
                            case 222: 
                            case 226: 
                            case 230: 
                            case 234: 
                            case 238: 
                            case 242: 
                            case 246: 
                            case 250: 
                            case 254: {
                                XEiJ.mpuIRR &= 0xFFFFFFFD;
                                n = MC68901.mfpAcknowledge();
                                if (n == 0) break;
                                MC68060.irpInterrupt(n << 2, 6);
                                break;
                            }
                            case 4: 
                            case 12: 
                            case 20: 
                            case 28: 
                            case 36: 
                            case 44: 
                            case 52: 
                            case 60: 
                            case 68: 
                            case 76: 
                            case 84: 
                            case 92: 
                            case 100: 
                            case 108: 
                            case 116: 
                            case 124: 
                            case 132: 
                            case 140: 
                            case 148: 
                            case 156: 
                            case 164: 
                            case 172: 
                            case 180: 
                            case 188: 
                            case 196: 
                            case 204: 
                            case 212: 
                            case 220: 
                            case 228: 
                            case 236: 
                            case 244: 
                            case 252: {
                                XEiJ.mpuIRR &= 0xFFFFFFFB;
                                n = Z8530.sccAcknowledge();
                                if (n == 0) break;
                                MC68060.irpInterrupt(n << 2, 5);
                                break;
                            }
                            case 16: 
                            case 48: 
                            case 80: 
                            case 112: 
                            case 144: 
                            case 176: 
                            case 208: 
                            case 240: {
                                XEiJ.mpuIRR &= 0xFFFFFFEF;
                                n = HD63450.dmaAcknowledge();
                                if (n == 0) break;
                                MC68060.irpInterrupt(n << 2, 3);
                                break;
                            }
                            case 32: 
                            case 96: 
                            case 160: 
                            case 224: {
                                XEiJ.mpuIRR &= 0xFFFFFFDF;
                                n = XEiJ.eb2Acknowledge();
                                if (n == 0) break;
                                MC68060.irpInterrupt(n << 2, 2);
                                break;
                            }
                            case 64: 
                            case 192: {
                                XEiJ.mpuIRR &= 0xFFFFFFBF;
                                n = IOInterrupt.ioiAcknowledge();
                                if (n == 0) break;
                                MC68060.irpInterrupt(n << 2, 1);
                            }
                        }
                    }
                    XEiJ.mpuIRR |= XEiJ.mpuDIRR;
                    XEiJ.mpuDIRR = 0;
                }
            }
            catch (M68kException m68kException) {
                int n;
                if (M68kException.m6eNumber == -2) {
                    if (!MC68060.irpWaitException()) break;
                    continue;
                }
                if (M68kException.m6eNumber == -1) {
                    XEiJ.regPC = XEiJ.regPC0;
                    XEiJ.mpuStop1(null);
                    break;
                }
                if (4085327811978493964L << M68kException.m6eNumber < 0L) {
                    XEiJ.regPC = XEiJ.regPC0;
                    n = 8;
                    while (m60Incremented != 0L) {
                        int n2 = n++;
                        XEiJ.regRn[n2] = XEiJ.regRn[n2] - (byte)m60Incremented;
                        m60Incremented = m60Incremented + 128L >> 8;
                    }
                }
                if ((m60FSLW & 0x30) != 0) {
                    if (((m60FSLW & 0x40000) != 0 ? ((m60FSLW & 0x20000) != 0 ? mmuSuperCodeTransparent : mmuSuperDataTransparent) : ((m60FSLW & 0x20000) != 0 ? mmuUserCodeTransparent : mmuUserDataTransparent))[m60Address >>> 24] != 0) {
                        m60FSLW |= 8;
                    }
                }
                try {
                    int n3;
                    n = XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
                    XEiJ.mpuTraceFlag = 0;
                    XEiJ.regSRT1 = 0;
                    if (XEiJ.regSRS != 0) {
                        n3 = XEiJ.regRn[15];
                    } else {
                        XEiJ.regSRS = 8192;
                        XEiJ.mpuUSP = XEiJ.regRn[15];
                        n3 = XEiJ.mpuISP;
                        DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
                        InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
                    }
                    XEiJ.mpuClockTime += XEiJ.mpuModifiedUnit * 19L;
                    if (M68kException.m6eNumber == 2) {
                        HFS.hfsState = 0;
                        XEiJ.regRn[15] = n3 -= 16;
                        MC68060.mmuWriteLongData(n3 + 12, m60FSLW, 1);
                        MC68060.mmuWriteLongData(n3 + 8, m60Address, 1);
                        MC68060.mmuWriteWordData(n3 + 6, 16392, 1);
                    } else if (1675339061381824512L << M68kException.m6eNumber < 0L) {
                        XEiJ.regRn[15] = n3 -= 12;
                        MC68060.mmuWriteLongData(n3 + 8, m60Address, 1);
                        MC68060.mmuWriteWordData(n3 + 6, 0x2000 | M68kException.m6eNumber << 2, 1);
                    } else {
                        XEiJ.regRn[15] = n3 -= 8;
                        MC68060.mmuWriteWordData(n3 + 6, M68kException.m6eNumber << 2, 1);
                    }
                    MC68060.mmuWriteLongData(n3 + 2, XEiJ.regPC, 1);
                    MC68060.mmuWriteWordData(n3, n, 1);
                    MC68060.irpSetPC(MC68060.mmuReadLongFour(XEiJ.mpuVBR + (M68kException.m6eNumber << 2), 1));
                    if (!XEiJ.dbgStopOnError || !XEiJ.dbgDoStopOnError()) continue;
                }
                catch (M68kException m68kException2) {
                    XEiJ.dbgDoubleBusFault();
                }
                break;
            }
        }
        BranchLog.blgStop();
    }

    public static boolean irpWaitException() {
        XEiJ.regPC = XEiJ.regPC0;
        int n = 8 + (XEiJ.regOC & 7);
        XEiJ.regRn[n] = XEiJ.regRn[n] + WaitInstruction.REWIND_AR[XEiJ.regOC >> 3];
        try {
            if (XEiJ.mpuTraceFlag != 0) {
                MC68060.irpExceptionFormat2(36, XEiJ.regPC, XEiJ.regPC0);
            }
            TickerQueue.tkqRun(XEiJ.mpuClockTime);
            int n2 = XEiJ.mpuIMR & XEiJ.mpuIRR;
            if (n2 != 0) {
                if ((n2 &= -n2) == 2) {
                    XEiJ.mpuIRR &= 0xFFFFFFFD;
                    n2 = MC68901.mfpAcknowledge();
                    if (n2 != 0) {
                        MC68060.irpInterrupt(n2 << 2, 6);
                    }
                } else if (n2 == 16) {
                    XEiJ.mpuIRR &= 0xFFFFFFEF;
                    n2 = HD63450.dmaAcknowledge();
                    if (n2 != 0) {
                        MC68060.irpInterrupt(n2 << 2, 3);
                    }
                } else if (n2 == 4) {
                    XEiJ.mpuIRR &= 0xFFFFFFFB;
                    n2 = Z8530.sccAcknowledge();
                    if (n2 != 0) {
                        MC68060.irpInterrupt(n2 << 2, 5);
                    }
                } else if (n2 == 64) {
                    XEiJ.mpuIRR &= 0xFFFFFFBF;
                    n2 = IOInterrupt.ioiAcknowledge();
                    if (n2 != 0) {
                        MC68060.irpInterrupt(n2 << 2, 1);
                    }
                } else if (n2 == 32) {
                    XEiJ.mpuIRR &= 0xFFFFFFDF;
                    n2 = XEiJ.eb2Acknowledge();
                    if (n2 != 0) {
                        MC68060.irpInterrupt(n2 << 2, 2);
                    }
                } else if (n2 == 1) {
                    XEiJ.mpuIRR &= 0xFFFFFFFE;
                    n2 = XEiJ.sysAcknowledge();
                    if (n2 != 0) {
                        MC68060.irpInterrupt(n2 << 2, 7);
                    }
                }
            }
            XEiJ.mpuIRR |= XEiJ.mpuDIRR;
            XEiJ.mpuDIRR = 0;
        }
        catch (M68kException m68kException) {
            XEiJ.dbgDoubleBusFault();
            return false;
        }
        return true;
    }

    public static void irpOriByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n < 8) {
            if (n2 == 0 && n == 0 && XEiJ.dbgOriByteZeroD0) {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] | 0xFF & n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        } else if (n == 60) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR |= 0x1F & n2;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n);
            MC68060.mmuWriteByteData(n5, n2 |= MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS), XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        }
    }

    public static void irpOriWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] | (char)n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
        } else if (n == 60) {
            if (XEiJ.regSRS == 0) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 5;
            MC68060.irpSetSR(XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR | MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, 1));
        } else {
            int n5 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltWord(n);
            MC68060.mmuWriteWordData(n6, n5 |= MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS), XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n5 - '\u0001' >> 31 & 4 | ((short)n5 < 0 ? 8 : 0);
        }
    }

    public static void irpOriLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] | n3;
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltLong(n2);
            n = MC68060.mmuModifyLongData(n6, XEiJ.regSRS) | n3;
            MC68060.mmuWriteLongData(n6, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpCmp2Chk2Byte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
        } else {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n2 = XEiJ.regRn[n];
        XEiJ.regRn[n] = XEiJ.MPU_BITREV_TABLE_0[n2 & 0x7FF] | XEiJ.MPU_BITREV_TABLE_1[n2 << 10 >>> 21] | XEiJ.MPU_BITREV_TABLE_2[n2 >>> 22];
    }

    public static void irpBtstReg() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9;
        if (n >> 3 == 1) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n3 = XEiJ.regRn[n2];
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~XEiJ.regRn[n] >>> n3 & 1) << 2;
        } else {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~(n == 60 ? MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS)) >>> (n3 & 7) & 1) << 2;
        }
    }

    public static void irpBchgReg() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9;
        if (n2 >> 3 == 1) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n4 = XEiJ.regRn[n3];
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            n4 = 1 << n4;
            XEiJ.regRn[n2] = n ^ n4;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS);
            n = by;
            n4 = 1 << (n4 & 7);
            MC68060.mmuWriteByteData(n5, by ^ n4, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n4) - 1 >>> 31 << 2;
    }

    public static void irpBclrReg() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9];
        if (n2 >> 3 == 1) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n & ~n3;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by;
            n3 = 1 << (n3 & 7);
            MC68060.mmuWriteByteData(n4, by & ~n3, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpBsetReg() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9];
        if (n2 >> 3 == 1) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n | n3;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by;
            n3 = 1 << (n3 & 7);
            MC68060.mmuWriteByteData(n4, by | n3, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpAndiByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] & (0xFFFFFF00 | n2);
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        } else if (n == 60) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR &= n2;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n);
            MC68060.mmuWriteByteData(n5, n2 &= MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS), XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        }
    }

    public static void irpAndiWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] & (0xFFFF0000 | n2);
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
        } else if (n == 60) {
            if (XEiJ.regSRS == 0) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 12;
            MC68060.irpSetSR((XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR) & MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, 1));
        } else {
            int n5 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltWord(n);
            MC68060.mmuWriteWordData(n6, n5 &= MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS), XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n5 - '\u0001' >> 31 & 4 | ((short)n5 < 0 ? 8 : 0);
        }
    }

    public static void irpAndiLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] & n3;
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltLong(n2);
            n = MC68060.mmuModifyLongData(n6, XEiJ.regSRS) & n3;
            MC68060.mmuWriteLongData(n6, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpCmp2Chk2Word() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
        } else {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        XEiJ.regRn[n] = Integer.reverseBytes(XEiJ.regRn[n]);
    }

    public static void irpSubiByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        byte by2 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            byte by3 = (byte)n;
            n = by3;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n3 | 0xFF & by3 - by2;
            by = (byte)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by4 = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by4;
            by = (byte)(by4 - by2);
            MC68060.mmuWriteByteData(n4, by, XEiJ.regSRS);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | ((n ^ by2) & (n ^ by)) >>> 31 << 1 | (n & (by2 ^ by) ^ (by2 | by)) >> 31 & 0x11;
    }

    public static void irpSubiWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)(s2 - n3);
            s = (short)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltWord(n2);
            n = MC68060.mmuModifyWordSignData(n5, XEiJ.regSRS);
            s = (short)(n - n3);
            MC68060.mmuWriteWordData(n5, s, XEiJ.regSRS);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | ((n ^ n3) & (n ^ s)) >>> 31 << 1 | (n & (n3 ^ s) ^ (n3 | s)) >> 31 & 0x11;
    }

    public static void irpSubiLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        if (n3 < 8) {
            ++XEiJ.mpuCycleCount;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = n2 - n4;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltLong(n3);
            n2 = MC68060.mmuModifyLongData(n5, XEiJ.regSRS);
            n = n2 - n4;
            MC68060.mmuWriteLongData(n5, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n2 ^ n4) & (n2 ^ n)) >>> 31 << 1 | (n2 & (n4 ^ n) ^ (n4 | n)) >> 31 & 0x11;
    }

    public static void irpCmp2Chk2Long() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
        } else {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n2 = XEiJ.regRn[n];
        XEiJ.regRn[n] = Integer.numberOfLeadingZeros(n2);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpAddiByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        byte by2 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            byte by3 = (byte)n;
            n = by3;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n3 | 0xFF & by3 + by2;
            by = (byte)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by4 = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by4;
            by = (byte)(by4 + by2);
            MC68060.mmuWriteByteData(n4, by, XEiJ.regSRS);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | ((n ^ by) & (by2 ^ by)) >>> 31 << 1 | ((n | by2) ^ (n ^ by2) & by) >> 31 & 0x11;
    }

    public static void irpAddiWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)(s2 + n3);
            s = (short)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltWord(n2);
            n = MC68060.mmuModifyWordSignData(n5, XEiJ.regSRS);
            s = (short)(n + n3);
            MC68060.mmuWriteWordData(n5, s, XEiJ.regSRS);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | ((n ^ s) & (n3 ^ s)) >>> 31 << 1 | ((n | n3) ^ (n ^ n3) & s) >> 31 & 0x11;
    }

    public static void irpAddiLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        if (n3 < 8) {
            ++XEiJ.mpuCycleCount;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = n2 + n4;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltLong(n3);
            n2 = MC68060.mmuModifyLongData(n5, XEiJ.regSRS);
            n = n2 + n4;
            MC68060.mmuWriteLongData(n5, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n2 ^ n) & (n4 ^ n)) >>> 31 << 1 | ((n2 | n4) ^ (n2 ^ n4) & n) >> 31 & 0x11;
    }

    public static void irpBtstImm() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        byte by = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~XEiJ.regRn[n] >>> by & 1) << 2;
        } else {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR = XEiJ.regCCR & 0x1B | (~MC68060.mmuReadByteSignData(MC68060.efaMemByte(n), XEiJ.regSRS) >>> (by & 7) & 1) << 2;
        }
    }

    public static void irpBchgImm() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n ^ n3;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by;
            n3 = 1 << (n3 & 7);
            MC68060.mmuWriteByteData(n4, by ^ n3, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpBclrImm() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n & ~n3;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by;
            n3 = 1 << (n3 & 7);
            MC68060.mmuWriteByteData(n4, by & ~n3, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpBsetImm() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            n3 = 1 << n3;
            XEiJ.regRn[n2] = n | n3;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by;
            n3 = 1 << (n3 & 7);
            MC68060.mmuWriteByteData(n4, by | n3, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x1B | (n & n3) - 1 >>> 31 << 2;
    }

    public static void irpEoriByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] ^ 0xFF & n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        } else if (n == 60) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regCCR ^= 0x1F & n2;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n);
            MC68060.mmuWriteByteData(n5, n2 ^= MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS), XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
        }
    }

    public static void irpEoriWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            int n4 = XEiJ.regRn[n3] ^ (char)n2;
            XEiJ.regRn[n3] = n4;
            n2 = n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
        } else if (n == 60) {
            if (XEiJ.regSRS == 0) {
                M68kException.m6eNumber = 8;
                throw M68kException.m6eSignal;
            }
            XEiJ.mpuCycleCount += 12;
            MC68060.irpSetSR((XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR) ^ MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, 1));
        } else {
            int n5 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltWord(n);
            MC68060.mmuWriteWordData(n6, n5 ^= MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS), XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n5 - '\u0001' >> 31 & 4 | ((short)n5 < 0 ? 8 : 0);
        }
    }

    public static void irpEoriLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] ^ n3;
            XEiJ.regRn[n4] = n5;
            n = n5;
        } else {
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltLong(n2);
            n = MC68060.mmuModifyLongData(n6, XEiJ.regSRS) ^ n3;
            MC68060.mmuWriteLongData(n6, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpCasByte() throws M68kException {
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n & 0xFFFFFE38) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n2 = n & 7;
        byte by = (byte)XEiJ.regRn[n2];
        int n3 = MC68060.efaMltByte(XEiJ.regOC & 0x3F);
        byte by2 = MC68060.mmuReadByteSignData(n3, XEiJ.regSRS);
        byte by3 = (byte)(by2 - by);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (by3 < 0 ? 8 : 0) | (by3 == 0 ? 4 : 0) | ((by2 ^ by) & (by2 ^ by3)) >>> 31 << 1 | (by2 & (by ^ by3) ^ (by | by3)) >>> 31;
        if (by3 == 0) {
            XEiJ.mpuCycleCount += 19;
            MC68060.mmuWriteByteData(n3, XEiJ.regRn[n >> 6], XEiJ.regSRS);
        } else {
            XEiJ.mpuCycleCount += 19;
            XEiJ.regRn[n2] = 0xFFFFFF00 & XEiJ.regRn[n2] | 0xFF & by2;
        }
    }

    public static void irpCmpiByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        byte by = MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS);
        byte by2 = n < 8 ? (byte)XEiJ.regRn[n] : MC68060.mmuReadByteSignData(MC68060.efaMemByte(n), XEiJ.regSRS);
        byte by3 = (byte)(by2 - by);
        XEiJ.regCCR = by3 >> 28 & 8 | (by3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((by2 ^ by) & (by2 ^ by3)) >>> 31 << 1 | (by2 & (by ^ by3) ^ (by | by3)) >>> 31;
    }

    public static void irpCmpiWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        short s = n < 8 ? (short)XEiJ.regRn[n] : (short)MC68060.mmuReadWordSignData(MC68060.efaMemWord(n), XEiJ.regSRS);
        short s2 = (short)(s - n2);
        XEiJ.regCCR = s2 >> 28 & 8 | (s2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((s ^ n2) & (s ^ s2)) >>> 31 << 1 | (s & (n2 ^ s2) ^ (n2 | s2)) >>> 31;
    }

    public static void irpCmpiLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        int n4 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        if (n3 < 8) {
            ++XEiJ.mpuCycleCount;
            n2 = XEiJ.regRn[n3];
            n = n2 - n4;
        } else {
            ++XEiJ.mpuCycleCount;
            n2 = MC68060.mmuReadLongData(MC68060.efaMemLong(n3), XEiJ.regSRS);
            n = n2 - n4;
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n2 ^ n4) & (n2 ^ n)) >>> 31 << 1 | (n2 & (n4 ^ n) ^ (n4 | n)) >>> 31;
    }

    public static void irpCasWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n == 60) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFFFE38) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = MC68060.efaMltWord(n);
        if ((n3 & 1) != 0) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n4 = n2 & 7;
        short s = (short)XEiJ.regRn[n4];
        int n5 = MC68060.mmuReadWordSignData(n3, XEiJ.regSRS);
        short s2 = (short)(n5 - s);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s2 < 0 ? 8 : 0) | (s2 == 0 ? 4 : 0) | ((n5 ^ s) & (n5 ^ s2)) >>> 31 << 1 | (n5 & (s ^ s2) ^ (s | s2)) >>> 31;
        if (s2 == 0) {
            XEiJ.mpuCycleCount += 19;
            MC68060.mmuWriteWordData(n3, XEiJ.regRn[n2 >> 6], XEiJ.regSRS);
        } else {
            XEiJ.mpuCycleCount += 19;
            XEiJ.regRn[n4] = 0xFFFF0000 & XEiJ.regRn[n4] | (char)n5;
        }
    }

    public static void irpMovesByte() throws M68kException {
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if (n << -11 != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
        int n2 = MC68060.efaMltByte(XEiJ.regOC & 0x3F);
        int n3 = n >>> 12;
        if (n << 20 >= 0) {
            int n4;
            MemoryMappedDevice[] memoryMappedDeviceArray;
            boolean bl = -1627389952 << XEiJ.mpuSFC < 0;
            boolean bl2 = 0x2A000000 << XEiJ.mpuSFC < 0;
            MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = bl ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
            if (0x66000000 << XEiJ.mpuSFC < 0) {
                m60FSLW = 0x1200000 | XEiJ.mpuSFC << 16;
                int n5 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2) : MC68060.mmuTranslateReadSuperData(n2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2) : MC68060.mmuTranslateReadUserData(n2));
                n4 = memoryMappedDeviceArray[n5 >>> 12].mmdRbz(n5);
            } else if (XEiJ.mpuSFC != 7) {
                m60FSLW = 0x1200000 | XEiJ.mpuSFC << 16;
                n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2);
            } else if (139264 <= n2 && n2 <= 139295) {
                n4 = XEiJ.fpuMotherboardCoprocessor.cirReadByteZero(n2);
            } else {
                m60FSLW = 0x1200000 | XEiJ.mpuSFC << 16 | 0x20;
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 1;
                M68kException.m6eSize = 0;
                throw M68kException.m6eSignal;
            }
            XEiJ.regRn[n3] = n3 < 8 ? XEiJ.regRn[n3] & 0xFFFFFF00 | n4 : (int)((byte)n4);
        } else {
            boolean bl = -1627389952 << XEiJ.mpuDFC < 0;
            boolean bl3 = 0x2A000000 << XEiJ.mpuDFC < 0;
            MemoryMappedDevice[] memoryMappedDeviceArray = bl ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
            int n6 = XEiJ.regRn[n3];
            if (0x66000000 << XEiJ.mpuDFC < 0) {
                m60FSLW = 0xA00000 | XEiJ.mpuDFC << 16;
                int n7 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2) : MC68060.mmuTranslateWriteSuperData(n2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2) : MC68060.mmuTranslateWriteUserData(n2));
                memoryMappedDeviceArray[n7 >>> 12].mmdWb(n7, n6);
            } else if (XEiJ.mpuDFC != 7) {
                m60FSLW = 0xA00000 | XEiJ.mpuDFC << 16;
                memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n6);
            } else if (139264 <= n2 && n2 <= 139295) {
                XEiJ.fpuMotherboardCoprocessor.cirWriteByte(n2, n6);
            } else {
                m60FSLW = 0xA00000 | XEiJ.mpuDFC << 16 | 0x10;
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 0;
                M68kException.m6eSize = 0;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpMovesWord() throws M68kException {
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if (n << -11 != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
        int n2 = MC68060.efaMltWord(XEiJ.regOC & 0x3F);
        int n3 = n >>> 12;
        if (n << 20 >= 0) {
            int n4;
            MemoryMappedDevice[] memoryMappedDeviceArray;
            boolean bl = -1627389952 << XEiJ.mpuSFC < 0;
            boolean bl2 = 0x2A000000 << XEiJ.mpuSFC < 0;
            MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = bl ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
            if (0x66000000 << XEiJ.mpuSFC < 0) {
                if ((n2 & 1) == 0) {
                    m60FSLW = 0x1400000 | XEiJ.mpuSFC << 16;
                    int n5 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2) : MC68060.mmuTranslateReadSuperData(n2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2) : MC68060.mmuTranslateReadUserData(n2));
                    n4 = memoryMappedDeviceArray[n5 >>> 12].mmdRwz(n5);
                } else {
                    m60FSLW = 0x1400000 | XEiJ.mpuSFC << 16;
                    int n6 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2) : MC68060.mmuTranslateReadSuperData(n2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2) : MC68060.mmuTranslateReadUserData(n2));
                    n4 = memoryMappedDeviceArray[n6 >>> 12].mmdRbz(n6) << 8;
                    m60FSLW ^= 0x8000000;
                    n6 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2 + 1) : MC68060.mmuTranslateReadSuperData(n2 + 1)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2 + 1) : MC68060.mmuTranslateReadUserData(n2 + 1));
                    n4 |= memoryMappedDeviceArray[n6 >>> 12].mmdRbz(n6);
                }
            } else if (XEiJ.mpuSFC != 7) {
                if ((n2 & 1) == 0) {
                    m60FSLW = 0x1400000 | XEiJ.mpuSFC << 16;
                    n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRwz(n2);
                } else {
                    m60FSLW = 0x1400000 | XEiJ.mpuSFC << 16;
                    n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRbz(n2) << 8;
                    m60FSLW ^= 0x8000000;
                    n4 |= memoryMappedDeviceArray[++n2 >>> 12].mmdRbz(n2);
                }
            } else if (139264 <= n2 && n2 <= 139295) {
                n4 = XEiJ.fpuMotherboardCoprocessor.cirReadWordZero(n2);
            } else {
                m60FSLW = 0x1400000 | XEiJ.mpuSFC << 16 | 0x20;
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 1;
                M68kException.m6eSize = 1;
                throw M68kException.m6eSignal;
            }
            XEiJ.regRn[n3] = n3 < 8 ? XEiJ.regRn[n3] & 0xFFFF0000 | n4 : (int)((short)n4);
        } else {
            boolean bl = -1627389952 << XEiJ.mpuDFC < 0;
            boolean bl3 = 0x2A000000 << XEiJ.mpuDFC < 0;
            MemoryMappedDevice[] memoryMappedDeviceArray = bl ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
            int n7 = XEiJ.regRn[n3];
            if (0x66000000 << XEiJ.mpuDFC < 0) {
                if ((n2 & 1) == 0) {
                    m60FSLW = 0xC00000 | XEiJ.mpuDFC << 16;
                    int n8 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2) : MC68060.mmuTranslateWriteSuperData(n2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2) : MC68060.mmuTranslateWriteUserData(n2));
                    memoryMappedDeviceArray[n8 >>> 12].mmdWw(n8, n7);
                } else {
                    m60FSLW = 0xC00000 | XEiJ.mpuDFC << 16;
                    int n9 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2) : MC68060.mmuTranslateWriteSuperData(n2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2) : MC68060.mmuTranslateWriteUserData(n2));
                    memoryMappedDeviceArray[n9 >>> 12].mmdWb(n9, n7 >> 8);
                    m60FSLW ^= 0x8000000;
                    n9 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2 + 1) : MC68060.mmuTranslateWriteSuperData(n2 + 1)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2 + 1) : MC68060.mmuTranslateWriteUserData(n2 + 1));
                    memoryMappedDeviceArray[n9 >>> 12].mmdWb(n9, n7);
                }
            } else if (XEiJ.mpuDFC != 7) {
                if ((n2 & 1) == 0) {
                    m60FSLW = 0xC00000 | XEiJ.mpuDFC << 16;
                    memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n7);
                } else {
                    m60FSLW = 0xC00000 | XEiJ.mpuDFC << 16;
                    memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n7 >> 8);
                    m60FSLW ^= 0x8000000;
                    memoryMappedDeviceArray[++n2 >>> 12].mmdWb(n2, n7);
                }
            } else if (139264 <= n2 && n2 <= 139295) {
                XEiJ.fpuMotherboardCoprocessor.cirWriteWord(n2, n7);
            } else {
                m60FSLW = 0xC00000 | XEiJ.mpuDFC << 16 | 0x10;
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 0;
                M68kException.m6eSize = 1;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpMovesLong() throws M68kException {
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if (n << -11 != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
        int n2 = MC68060.efaMltLong(XEiJ.regOC & 0x3F);
        int n3 = n >>> 12;
        if (n << 20 >= 0) {
            int n4;
            MemoryMappedDevice[] memoryMappedDeviceArray;
            boolean bl = -1627389952 << XEiJ.mpuSFC < 0;
            boolean bl2 = 0x2A000000 << XEiJ.mpuSFC < 0;
            MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = bl ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
            if (0x66000000 << XEiJ.mpuSFC < 0) {
                if ((n2 & 3) == 0) {
                    m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16;
                    int n5 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2) : MC68060.mmuTranslateReadSuperData(n2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2) : MC68060.mmuTranslateReadUserData(n2));
                    n4 = memoryMappedDeviceArray[n5 >>> 12].mmdRls(n5);
                } else if ((n2 & 1) == 0) {
                    m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16;
                    int n6 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2) : MC68060.mmuTranslateReadSuperData(n2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2) : MC68060.mmuTranslateReadUserData(n2));
                    n4 = memoryMappedDeviceArray[n6 >>> 12].mmdRws(n6) << 16;
                    m60FSLW ^= 0x8000000;
                    n6 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2 + 2) : MC68060.mmuTranslateReadSuperData(n2 + 2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2 + 2) : MC68060.mmuTranslateReadUserData(n2 + 2));
                    n4 |= memoryMappedDeviceArray[n6 >>> 12].mmdRwz(n6);
                } else {
                    m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16;
                    int n7 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2) : MC68060.mmuTranslateReadSuperData(n2)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2) : MC68060.mmuTranslateReadUserData(n2));
                    n4 = memoryMappedDeviceArray[n7 >>> 12].mmdRbs(n7) << 24;
                    m60FSLW ^= 0x8000000;
                    n7 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2 + 1) : MC68060.mmuTranslateReadSuperData(n2 + 1)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2 + 1) : MC68060.mmuTranslateReadUserData(n2 + 1));
                    n4 |= memoryMappedDeviceArray[n7 >>> 12].mmdRwz(n7) << 8;
                    n7 = bl ? (bl2 ? MC68060.mmuTranslateReadSuperCode(n2 + 3) : MC68060.mmuTranslateReadSuperData(n2 + 3)) : (bl2 ? MC68060.mmuTranslateReadUserCode(n2 + 3) : MC68060.mmuTranslateReadUserData(n2 + 3));
                    n4 |= memoryMappedDeviceArray[n7 >>> 12].mmdRbz(n7);
                }
            } else if (XEiJ.mpuSFC != 7) {
                if ((n2 & 3) == 0) {
                    m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16;
                    n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRls(n2);
                } else if ((n2 & 1) == 0) {
                    m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16;
                    n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRws(n2) << 16;
                    m60FSLW ^= 0x8000000;
                    n4 |= memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdRwz(n2);
                } else {
                    m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16;
                    n4 = memoryMappedDeviceArray[n2 >>> 12].mmdRbs(n2) << 24;
                    m60FSLW ^= 0x8000000;
                    n4 |= memoryMappedDeviceArray[++n2 >>> 12].mmdRwz(n2) << 8;
                    n4 |= memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdRbz(n2);
                }
            } else if (139264 <= n2 && n2 <= 139295) {
                n4 = XEiJ.fpuMotherboardCoprocessor.cirReadLong(n2);
            } else {
                m60FSLW = 0x1000000 | XEiJ.mpuSFC << 16 | 0x20;
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 1;
                M68kException.m6eSize = 2;
                throw M68kException.m6eSignal;
            }
            XEiJ.regRn[n3] = n4;
        } else {
            boolean bl = -1627389952 << XEiJ.mpuDFC < 0;
            boolean bl3 = 0x2A000000 << XEiJ.mpuDFC < 0;
            MemoryMappedDevice[] memoryMappedDeviceArray = bl ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
            int n8 = XEiJ.regRn[n3];
            if (0x66000000 << XEiJ.mpuDFC < 0) {
                if ((n2 & 3) == 0) {
                    m60FSLW = 0x800000 | XEiJ.mpuDFC << 16;
                    int n9 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2) : MC68060.mmuTranslateWriteSuperData(n2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2) : MC68060.mmuTranslateWriteUserData(n2));
                    memoryMappedDeviceArray[n9 >>> 12].mmdWl(n9, n8);
                } else if ((n2 & 1) == 0) {
                    m60FSLW = 0x800000 | XEiJ.mpuDFC << 16;
                    int n10 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2) : MC68060.mmuTranslateWriteSuperData(n2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2) : MC68060.mmuTranslateWriteUserData(n2));
                    memoryMappedDeviceArray[n10 >>> 12].mmdWw(n10, n8 >> 16);
                    m60FSLW ^= 0x8000000;
                    n10 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2 + 2) : MC68060.mmuTranslateWriteSuperData(n2 + 2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2 + 2) : MC68060.mmuTranslateWriteUserData(n2 + 2));
                    memoryMappedDeviceArray[n10 >>> 12].mmdWw(n10, n8);
                } else {
                    m60FSLW = 0x800000 | XEiJ.mpuDFC << 16;
                    int n11 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2) : MC68060.mmuTranslateWriteSuperData(n2)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2) : MC68060.mmuTranslateWriteUserData(n2));
                    memoryMappedDeviceArray[n11 >>> 12].mmdWb(n11, n8 >> 24);
                    m60FSLW ^= 0x8000000;
                    n11 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2 + 1) : MC68060.mmuTranslateWriteSuperData(n2 + 1)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2 + 1) : MC68060.mmuTranslateWriteUserData(n2 + 1));
                    memoryMappedDeviceArray[n11 >>> 12].mmdWw(n11, n8 >> 8);
                    n11 = bl ? (bl3 ? MC68060.mmuTranslateWriteSuperCode(n2 + 3) : MC68060.mmuTranslateWriteSuperData(n2 + 3)) : (bl3 ? MC68060.mmuTranslateWriteUserCode(n2 + 3) : MC68060.mmuTranslateWriteUserData(n2 + 3));
                    memoryMappedDeviceArray[n11 >>> 12].mmdWb(n11, n8);
                }
            } else if (XEiJ.mpuDFC != 7) {
                if ((n2 & 3) == 0) {
                    m60FSLW = 0x800000 | XEiJ.mpuDFC << 16;
                    memoryMappedDeviceArray[n2 >>> 12].mmdWl(n2, n8);
                } else if ((n2 & 1) == 0) {
                    m60FSLW = 0x800000 | XEiJ.mpuDFC << 16;
                    memoryMappedDeviceArray[n2 >>> 12].mmdWw(n2, n8 >> 16);
                    m60FSLW ^= 0x8000000;
                    memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdWw(n2, n8);
                } else {
                    m60FSLW = 0x800000 | XEiJ.mpuDFC << 16;
                    memoryMappedDeviceArray[n2 >>> 12].mmdWb(n2, n8 >> 24);
                    m60FSLW ^= 0x8000000;
                    memoryMappedDeviceArray[++n2 >>> 12].mmdWw(n2, n8 >> 8);
                    memoryMappedDeviceArray[(n2 += 2) >>> 12].mmdWb(n2, n8);
                }
            } else if (139264 <= n2 && n2 <= 139295) {
                XEiJ.fpuMotherboardCoprocessor.cirWriteLong(n2, n8);
            } else {
                m60FSLW = 0x800000 | XEiJ.mpuDFC << 16 | 0x10;
                M68kException.m6eNumber = 2;
                M68kException.m6eAddress = n2;
                M68kException.m6eDirection = 0;
                M68kException.m6eSize = 2;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpCasLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n == 60) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFFFE38) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = MC68060.efaMltLong(n);
        if ((n3 & 1) != 0) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n4 = n2 & 7;
        int n5 = XEiJ.regRn[n4];
        int n6 = MC68060.mmuReadLongData(n3, XEiJ.regSRS);
        int n7 = n6 - n5;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n7 < 0 ? 8 : 0) | (n7 == 0 ? 4 : 0) | ((n6 ^ n5) & (n6 ^ n7)) >>> 31 << 1 | (n6 & (n5 ^ n7) ^ (n5 | n7)) >>> 31;
        if (n7 == 0) {
            XEiJ.mpuCycleCount += 19;
            MC68060.mmuWriteLongData(n3, XEiJ.regRn[n2 >> 6], XEiJ.regSRS);
        } else {
            XEiJ.mpuCycleCount += 19;
            XEiJ.regRn[n4] = n6;
        }
    }

    public static void irpMoveToDRByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        XEiJ.regRn[n2] = 0xFFFFFF00 & XEiJ.regRn[n2] | 0xFF & n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpMoveToMMByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 0;
        int n4 = m60Address = XEiJ.regRn[n3];
        MC68060.mmuWriteByteData(n4, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToMPByte() throws M68kException {
        int n;
        ++XEiJ.mpuCycleCount;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = n2 < 8 ? XEiJ.regRn[n2] : (n2 == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n2), XEiJ.regSRS));
        int n4 = (XEiJ.regOC >> 9) - 0;
        if (n4 < 15) {
            m60Incremented += 1L << (n4 << 3);
            int n5 = n4;
            int n6 = XEiJ.regRn[n5];
            XEiJ.regRn[n5] = n6 + 1;
            m60Address = n6;
            n = n6;
        } else {
            m60Incremented += 0x200000000000000L;
            XEiJ.regRn[15] = XEiJ.regRn[15] + 2;
            n = m60Address = XEiJ.regRn[15] - 2;
        }
        MC68060.mmuWriteByteData(n, n3, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpMoveToMNByte() throws M68kException {
        int n;
        ++XEiJ.mpuCycleCount;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = n2 < 8 ? XEiJ.regRn[n2] : (n2 == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n2), XEiJ.regSRS));
        int n4 = (XEiJ.regOC >> 9) - 0;
        if (n4 < 15) {
            m60Incremented -= 1L << (n4 << 3);
            int n5 = n4;
            int n6 = XEiJ.regRn[n5] - 1;
            XEiJ.regRn[n5] = n6;
            m60Address = n6;
            n = n6;
        } else {
            m60Incremented -= 0x200000000000000L;
            m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 2;
            n = XEiJ.regRn[15];
        }
        MC68060.mmuWriteByteData(n, n3, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpMoveToMWByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 0;
        int n4 = XEiJ.regRn[n3];
        int n5 = m60Address = n4 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        MC68060.mmuWriteByteData(n5, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToMXByte() throws M68kException {
        int n;
        ++XEiJ.mpuCycleCount;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = n2 < 8 ? XEiJ.regRn[n2] : (n2 == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n2), XEiJ.regSRS));
        int n4 = (XEiJ.regOC >> 9) - 0;
        int n5 = XEiJ.regRn[n4];
        int n6 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((0x100 & n6) == 0) {
            n = m60Address = n5 + (byte)n6 + (((0x800 & n6) == 0 ? (int)XEiJ.regRn[n6 >> 12] : XEiJ.regRn[n6 >> 12]) << ((0x600 & n6) >> 9));
        } else {
            int n7;
            int n8;
            XEiJ.mpuCycleCount += (3 & n6) == 0 ? 1 : 3;
            n5 = ((0x80 & n6) != 0 ? 0 : n5) + ((0x20 & n6) == 0 ? 0 : ((0x10 & n6) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
            int n9 = (0x40 & n6) != 0 ? 0 : (n8 = ((0x800 & n6) == 0 ? (int)XEiJ.regRn[n6 >> 12] : XEiJ.regRn[n6 >> 12]) << ((0x600 & n6) >> 9));
            if ((3 & n6) == 0) {
                n7 = n5 + n8;
            } else {
                int n10;
                if ((4 & n6) == 0) {
                    m60Address = n5 + n8;
                    n10 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                } else {
                    m60Address = n5;
                    n10 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                }
                n7 = n10 + ((2 & n6) == 0 ? 0 : ((1 & n6) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
            }
            m60Address = n7;
            n = n7;
        }
        MC68060.mmuWriteByteData(n, n3, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpMoveToZWByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        int n3 = m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        MC68060.mmuWriteByteData(n3, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToZLByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        int n3 = m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        MC68060.mmuWriteByteData(n3, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n2];
    }

    public static void irpMoveToDRLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = n2;
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveaLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regRn[(XEiJ.regOC >> 9) - 8] = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
    }

    public static void irpMoveToMMLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 8;
        int n4 = m60Address = XEiJ.regRn[n3];
        MC68060.mmuWriteLongData(n4, n2, XEiJ.regSRS);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMPLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 8;
        m60Incremented += 4L << (n3 << 3);
        int n4 = n3;
        int n5 = XEiJ.regRn[n4] + 4;
        XEiJ.regRn[n4] = n5;
        int n6 = m60Address = n5 - 4;
        MC68060.mmuWriteLongData(n6, n2, XEiJ.regSRS);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMNLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 8;
        m60Incremented -= 4L << (n3 << 3);
        int n4 = n3;
        int n5 = XEiJ.regRn[n4] - 4;
        XEiJ.regRn[n4] = n5;
        m60Address = n5;
        int n6 = n5;
        MC68060.mmuWriteLongData(n6, n2, XEiJ.regSRS);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMWLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 8;
        int n4 = XEiJ.regRn[n3];
        int n5 = m60Address = n4 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        MC68060.mmuWriteLongData(n5, n2, XEiJ.regSRS);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToMXLong() throws M68kException {
        int n;
        ++XEiJ.mpuCycleCount;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = n2 < 16 ? XEiJ.regRn[n2] : (n2 == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n2), XEiJ.regSRS));
        int n4 = (XEiJ.regOC >> 9) - 8;
        int n5 = XEiJ.regRn[n4];
        int n6 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((0x100 & n6) == 0) {
            n = m60Address = n5 + (byte)n6 + (((0x800 & n6) == 0 ? (int)XEiJ.regRn[n6 >> 12] : XEiJ.regRn[n6 >> 12]) << ((0x600 & n6) >> 9));
        } else {
            int n7;
            int n8;
            XEiJ.mpuCycleCount += (3 & n6) == 0 ? 1 : 3;
            n5 = ((0x80 & n6) != 0 ? 0 : n5) + ((0x20 & n6) == 0 ? 0 : ((0x10 & n6) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
            int n9 = (0x40 & n6) != 0 ? 0 : (n8 = ((0x800 & n6) == 0 ? (int)XEiJ.regRn[n6 >> 12] : XEiJ.regRn[n6 >> 12]) << ((0x600 & n6) >> 9));
            if ((3 & n6) == 0) {
                n7 = n5 + n8;
            } else {
                int n10;
                if ((4 & n6) == 0) {
                    m60Address = n5 + n8;
                    n10 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                } else {
                    m60Address = n5;
                    n10 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                }
                n7 = n10 + ((2 & n6) == 0 ? 0 : ((1 & n6) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
            }
            m60Address = n7;
            n = n7;
        }
        MC68060.mmuWriteLongData(n, n3, XEiJ.regSRS);
        XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToZWLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        MC68060.mmuWriteLongData(n3, n2, XEiJ.regSRS);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToZLLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        MC68060.mmuWriteLongData(n3, n2, XEiJ.regSRS);
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToDRWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        XEiJ.regRn[n2] = 0xFFFF0000 & XEiJ.regRn[n2] | (char)n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n3 - '\u0001' >> 31 & 4 | ((short)n3 < 0 ? 8 : 0);
    }

    public static void irpMoveaWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regRn[XEiJ.regOC >> 9 & 0xF] = n < 16 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
    }

    public static void irpMoveToMMWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 16;
        int n4 = m60Address = XEiJ.regRn[n3];
        MC68060.mmuWriteWordData(n4, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMPWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 16;
        m60Incremented += 2L << (n3 << 3);
        int n4 = n3;
        int n5 = XEiJ.regRn[n4] + 2;
        XEiJ.regRn[n4] = n5;
        int n6 = m60Address = n5 - 2;
        MC68060.mmuWriteWordData(n6, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMNWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 16;
        m60Incremented -= 2L << (n3 << 3);
        int n4 = n3;
        int n5 = XEiJ.regRn[n4] - 2;
        XEiJ.regRn[n4] = n5;
        m60Address = n5;
        int n6 = n5;
        MC68060.mmuWriteWordData(n6, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMWWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = (XEiJ.regOC >> 9) - 16;
        int n4 = XEiJ.regRn[n3];
        int n5 = m60Address = n4 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        MC68060.mmuWriteWordData(n5, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToMXWord() throws M68kException {
        int n;
        ++XEiJ.mpuCycleCount;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = n2 < 16 ? XEiJ.regRn[n2] : (n2 == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n2), XEiJ.regSRS));
        int n4 = (XEiJ.regOC >> 9) - 16;
        int n5 = XEiJ.regRn[n4];
        int n6 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((0x100 & n6) == 0) {
            n = m60Address = n5 + (byte)n6 + (((0x800 & n6) == 0 ? (int)XEiJ.regRn[n6 >> 12] : XEiJ.regRn[n6 >> 12]) << ((0x600 & n6) >> 9));
        } else {
            int n7;
            int n8;
            XEiJ.mpuCycleCount += (3 & n6) == 0 ? 1 : 3;
            n5 = ((0x80 & n6) != 0 ? 0 : n5) + ((0x20 & n6) == 0 ? 0 : ((0x10 & n6) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
            int n9 = (0x40 & n6) != 0 ? 0 : (n8 = ((0x800 & n6) == 0 ? (int)XEiJ.regRn[n6 >> 12] : XEiJ.regRn[n6 >> 12]) << ((0x600 & n6) >> 9));
            if ((3 & n6) == 0) {
                n7 = n5 + n8;
            } else {
                int n10;
                if ((4 & n6) == 0) {
                    m60Address = n5 + n8;
                    n10 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                } else {
                    m60Address = n5;
                    n10 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                }
                n7 = n10 + ((2 & n6) == 0 ? 0 : ((1 & n6) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
            }
            m60Address = n7;
            n = n7;
        }
        MC68060.mmuWriteWordData(n, n3, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n3 - '\u0001' >> 31 & 4 | ((short)n3 < 0 ? 8 : 0);
    }

    public static void irpMoveToZWWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        MC68060.mmuWriteWordData(n3, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpMoveToZLWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        MC68060.mmuWriteWordData(n3, n2, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpNegxByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n3 | 0xFF & -by2 - (XEiJ.regCCR >> 4);
            by = (byte)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by3 = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by3;
            by = (byte)(-by3 - (XEiJ.regCCR >> 4));
            MC68060.mmuWriteByteData(n4, by, XEiJ.regSRS);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 4 : 0) | (n & by) >>> 31 << 1 | (n | by) >> 31 & 0x11;
    }

    public static void irpNegxWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n3 | (char)(-s2 - (XEiJ.regCCR >> 4));
            s = (short)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltWord(n2);
            n = MC68060.mmuModifyWordSignData(n4, XEiJ.regSRS);
            s = (short)(-n - (XEiJ.regCCR >> 4));
            MC68060.mmuWriteWordData(n4, s, XEiJ.regSRS);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 4 : 0) | (n & s) >>> 31 << 1 | (n | s) >> 31 & 0x11;
    }

    public static void irpNegxLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        if (n3 < 8) {
            ++XEiJ.mpuCycleCount;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = -n2 - (XEiJ.regCCR >> 4);
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltLong(n3);
            n2 = MC68060.mmuModifyLongData(n4, XEiJ.regSRS);
            n = -n2 - (XEiJ.regCCR >> 4);
            MC68060.mmuWriteLongData(n4, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 4 : 0) | (n2 & n) >>> 31 << 1 | (n2 | n) >> 31 & 0x11;
    }

    public static void irpMoveFromSR() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[n] = 0xFFFF0000 & XEiJ.regRn[n] | XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteWordData(MC68060.efaMltWord(n), XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR, 1);
        }
    }

    public static void irpChkLong() throws M68kException {
        XEiJ.mpuCycleCount += 2;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        int n4 = n2 - n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x17 | (n3 < 0 ? 8 : 0);
        if (n3 < 0 || n2 < n3) {
            ++XEiJ.mpuCycleCount;
            m60Address = XEiJ.regPC0;
            M68kException.m6eNumber = 6;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpChkWord() throws M68kException {
        XEiJ.mpuCycleCount += 2;
        int n = XEiJ.regOC & 0x3F;
        short s = n < 8 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        short s2 = (short)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        short s3 = (short)(s - s2);
        XEiJ.regCCR = XEiJ.regCCR & 0x17 | (s2 < 0 ? 8 : 0);
        if (s2 < 0 || s < s2) {
            ++XEiJ.mpuCycleCount;
            m60Address = XEiJ.regPC0;
            M68kException.m6eNumber = 6;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpLea() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            byte by = (byte)XEiJ.regRn[n];
            XEiJ.regRn[n] = by;
            XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[(XEiJ.regOC >> 9) - 24] = MC68060.efaLeaPea(n);
        }
    }

    public static void irpClrByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] & 0xFFFFFF00;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4;
    }

    public static void irpClrWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] & 0xFFFF0000;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteWordData(MC68060.efaMltWord(n), 0, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4;
    }

    public static void irpClrLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[n] = 0;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteLongData(MC68060.efaMltLong(n), 0, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | 4;
    }

    public static void irpMoveFromCCR() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[n] = 0xFFFF0000 & XEiJ.regRn[n] | XEiJ.regCCR;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteWordData(MC68060.efaMltWord(n), XEiJ.regCCR, XEiJ.regSRS);
        }
    }

    public static void irpNegByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n3 | 0xFF & -by2;
            by = (byte)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltByte(n2);
            byte by3 = MC68060.mmuModifyByteSignData(n4, XEiJ.regSRS);
            n = by3;
            by = -by3;
            MC68060.mmuWriteByteData(n4, by, XEiJ.regSRS);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (n & by) >>> 31 << 1 | (n | by) >> 31 & 0x11;
    }

    public static void irpNegWord() throws M68kException {
        short s;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            n = n3;
            short s2 = (short)n;
            n = s2;
            XEiJ.regRn[n2] = 0xFFFF0000 & n3 | (char)(-s2);
            s = (short)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltWord(n2);
            n = MC68060.mmuModifyWordSignData(n4, XEiJ.regSRS);
            s = (short)(-n);
            MC68060.mmuWriteWordData(n4, s, XEiJ.regSRS);
        }
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (n & s) >>> 31 << 1 | (n | s) >> 31 & 0x11;
    }

    public static void irpNegLong() throws M68kException {
        int n;
        int n2;
        int n3 = XEiJ.regOC & 0x3F;
        if (n3 < 8) {
            ++XEiJ.mpuCycleCount;
            n2 = XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n = -n2;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltLong(n3);
            n2 = MC68060.mmuModifyLongData(n4, XEiJ.regSRS);
            n = -n2;
            MC68060.mmuWriteLongData(n4, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | (n2 & n) >>> 31 << 1 | (n2 | n) >> 31 & 0x11;
    }

    public static void irpMoveToCCR() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regCCR = 0x1F & (n < 8 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS)));
    }

    public static void irpNotByte() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = n2;
            int n4 = XEiJ.regRn[n3] ^ 0xFF;
            XEiJ.regRn[n3] = n4;
            n = n4;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n2);
            n = ~MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS);
            MC68060.mmuWriteByteData(n5, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n];
    }

    public static void irpNotWord() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = n2;
            int n4 = XEiJ.regRn[n3] ^ 0xFFFF;
            XEiJ.regRn[n3] = n4;
            n = n4;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltWord(n2);
            n = ~MC68060.mmuModifyWordSignData(n5, XEiJ.regSRS);
            MC68060.mmuWriteWordData(n5, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n - '\u0001' >> 31 & 4 | ((short)n < 0 ? 8 : 0);
    }

    public static void irpNotLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n3 = n2;
            int n4 = ~XEiJ.regRn[n3];
            XEiJ.regRn[n3] = n4;
            n = n4;
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltLong(n2);
            n = ~MC68060.mmuModifyLongData(n5, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n5, n, XEiJ.regSRS);
        }
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMoveToSR() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 12;
        int n = XEiJ.regOC & 0x3F;
        MC68060.irpSetSR(n < 8 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, 1) : MC68060.mmuReadWordZeroData(MC68060.efaAnyWord(n), 1)));
    }

    public static void irpNbcd() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[n] = 0xFFFFFF00 & XEiJ.regRn[n] | MC68060.irpSbcd(0, XEiJ.regRn[n]);
        } else if (n < 16) {
            XEiJ.mpuCycleCount += 2;
            int n2 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            int n3 = XEiJ.regOC - 18432;
            int n4 = XEiJ.regRn[n3];
            m60Incremented -= 0x400000000000000L;
            m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
            int n5 = XEiJ.regRn[15];
            MC68060.mmuWriteLongData(n5, n4, XEiJ.regSRS);
            XEiJ.regRn[n3] = n5;
            XEiJ.regRn[15] = n5 + n2;
        } else {
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltByte(n);
            MC68060.mmuWriteByteData(n6, MC68060.irpSbcd(0, MC68060.mmuModifyByteSignData(n6, XEiJ.regSRS)), XEiJ.regSRS);
        }
    }

    public static void irpPea() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            int n2;
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n];
            XEiJ.regRn[n] = n2 = n3 << 16 | n3 >>> 16;
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaLeaPea(n);
            m60Incremented -= 0x400000000000000L;
            m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
            int n5 = XEiJ.regRn[15];
            MC68060.mmuWriteLongData(n5, n4, XEiJ.regSRS);
        }
    }

    public static void irpMovemToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n2 = XEiJ.regRn[n];
            int n3 = n2;
            byte by = (byte)n3;
            n3 = by;
            XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)by;
            XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n4 = MC68060.mmuReadWordZeroExword(XEiJ.regPC, XEiJ.regSRS);
            XEiJ.regPC += 2;
            if (n >> 3 == 4) {
                int n5 = n - 24;
                m60Incremented -= 2L << (n5 << 3);
                int n6 = m60Address = XEiJ.regRn[n5];
                XEiJ.regRn[n5] = n6 - 2;
                int n7 = n6;
                int n8 = 15;
                while (n4 != 0) {
                    if ((n4 & 1) != 0) {
                        m60Address = n6 -= 2;
                        MC68060.mmuWriteWordData(m60Address, XEiJ.regRn[n8], XEiJ.regSRS);
                    }
                    --n8;
                    n4 >>>= 1;
                }
                m60Incremented += 2L << (n5 << 3);
                XEiJ.regRn[n5] = n6;
                XEiJ.mpuCycleCount += n7 - n6 >> 1;
            } else {
                int n9;
                int n10 = n9 = MC68060.efaCltWord(n);
                int n11 = 0;
                while (n4 != 0) {
                    if ((n4 & 1) != 0) {
                        m60Address = n9;
                        MC68060.mmuWriteWordData(m60Address, XEiJ.regRn[n11], XEiJ.regSRS);
                        n9 += 2;
                    }
                    ++n11;
                    n4 >>>= 1;
                }
                XEiJ.mpuCycleCount += n9 - n10 >> 1;
            }
        }
    }

    public static void irpMovemToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            short s = (short)XEiJ.regRn[n];
            XEiJ.regRn[n] = s;
            XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n2 = MC68060.mmuReadWordZeroExword(XEiJ.regPC, XEiJ.regSRS);
            XEiJ.regPC += 2;
            if (n >> 3 == 4) {
                int n3 = n - 24;
                m60Incremented -= 4L << (n3 << 3);
                int n4 = m60Address = XEiJ.regRn[n3];
                XEiJ.regRn[n3] = n4 - 4;
                int n5 = n4;
                int n6 = 15;
                while (n2 != 0) {
                    if ((n2 & 1) != 0) {
                        m60Address = n4 -= 4;
                        MC68060.mmuWriteLongData(m60Address, XEiJ.regRn[n6], XEiJ.regSRS);
                    }
                    --n6;
                    n2 >>>= 1;
                }
                m60Incremented += 4L << (n3 << 3);
                XEiJ.regRn[n3] = n4;
                XEiJ.mpuCycleCount += n5 - n4 >> 2;
            } else {
                int n7;
                int n8 = n7 = MC68060.efaCltLong(n);
                int n9 = 0;
                while (n2 != 0) {
                    if ((n2 & 1) != 0) {
                        m60Address = n7;
                        MC68060.mmuWriteLongData(m60Address, XEiJ.regRn[n9], XEiJ.regSRS);
                        n7 += 4;
                    }
                    ++n9;
                    n2 >>>= 1;
                }
                XEiJ.mpuCycleCount += n7 - n8 >> 2;
            }
        }
    }

    public static void irpTstByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & (n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS)))];
    }

    public static void irpTstWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n2 - '\u0001' >> 31 & 4 | ((short)n2 < 0 ? 8 : 0);
    }

    public static void irpTstLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpTas() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            n = XEiJ.regRn[n2];
            XEiJ.regRn[n2] = 0x80 | n;
        } else {
            XEiJ.mpuCycleCount += 17;
            int n3 = MC68060.efaMltByte(n2);
            byte by = MC68060.mmuModifyByteSignData(n3, XEiJ.regSRS);
            n = by;
            MC68060.mmuWriteByteData(n3, 0x80 | by, XEiJ.regSRS);
        }
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n];
    }

    public static void irpMuluMulsLong() throws M68kException {
        long l;
        int n;
        long l2;
        int n2;
        int n3 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n3 & 0xFFFF83F8) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if ((n3 & 0x400) != 0) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n4 = n3 & 0x800;
        int n5 = n3 >> 12;
        XEiJ.mpuCycleCount += 2;
        int n6 = XEiJ.regOC & 0x3F;
        long l3 = n6 < 8 ? XEiJ.regRn[n6] : (n6 == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n6), XEiJ.regSRS));
        long l4 = XEiJ.regRn[n5];
        XEiJ.regCCR = n4 == 0 ? n2 >> 28 & 8 | ((n2 = (XEiJ.regRn[n5] = (int)(l2 = (0xFFFFFFFFL & l4) * (0xFFFFFFFFL & l3)))) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | (l2 >>> 32 != 0L ? 2 : 0) : n >> 28 & 8 | ((n = (XEiJ.regRn[n5] = (int)(l = l4 * l3))) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((long)n != l ? 2 : 0);
    }

    public static void irpDivuDivsLong() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFF83F8) != 0) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        if ((n2 & 0x400) != 0) {
            M68kException.m6eNumber = 61;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 & 0x800;
        int n4 = n2 & 7;
        int n5 = n2 >> 12;
        int n6 = XEiJ.regOC & 0x3F;
        int n7 = n6 < 8 ? XEiJ.regRn[n6] : (n = n6 == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n6), XEiJ.regSRS));
        if (n3 == 0) {
            XEiJ.mpuCycleCount += 38;
            long l = (long)n & 0xFFFFFFFFL;
            if (n == 0) {
                XEiJ.regCCR &= 0x1E;
                XEiJ.mpuCycleCount += 4;
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 5;
                throw M68kException.m6eSignal;
            }
            long l2 = (long)XEiJ.regRn[n5] & 0xFFFFFFFFL;
            long l3 = (long)((double)l2 / (double)l);
            int n8 = XEiJ.regRn[n5] = (int)l3;
            if (n4 != n5) {
                XEiJ.regRn[n4] = (int)(l2 - l * l3);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n8 < 0 ? 8 : 0) | (n8 == 0 ? 4 : 0);
        } else {
            XEiJ.mpuCycleCount += 38;
            long l = n;
            if (n == 0) {
                XEiJ.regCCR &= 0x1E;
                XEiJ.mpuCycleCount += 4;
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 5;
                throw M68kException.m6eSignal;
            }
            long l4 = XEiJ.regRn[n5];
            long l5 = l4 / l;
            if ((long)((int)l5) != l5) {
                XEiJ.regCCR = XEiJ.regCCR & 0x1C | 2;
            } else {
                int n9 = XEiJ.regRn[n5] = (int)l5;
                if (n4 != n5) {
                    XEiJ.regRn[n4] = (int)(l4 - l * l5);
                }
                XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n9 < 0 ? 8 : 0) | (n9 == 0 ? 4 : 0);
            }
        }
    }

    public static void irpMovemToRegWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n2 = XEiJ.regRn[n];
            if ((XEiJ.regCCR & 2) != 0) {
                XEiJ.regRn[n] = n2 = n2 >> 31 ^ Integer.MIN_VALUE;
            }
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else {
            int n3;
            int n4 = MC68060.mmuReadWordZeroExword(XEiJ.regPC, XEiJ.regSRS);
            XEiJ.regPC += 2;
            if (n >> 3 == 3) {
                var2_3 = n - 16;
                n3 = m60Address = XEiJ.regRn[var2_3];
            } else {
                var2_3 = 16;
                n3 = MC68060.efaCntWord(n);
            }
            int n5 = n3;
            int n6 = 0;
            while (n4 != 0) {
                if ((n4 & 1) != 0) {
                    m60Address = n3;
                    XEiJ.regRn[n6] = MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS);
                    n3 += 2;
                }
                ++n6;
                n4 >>>= 1;
            }
            XEiJ.regRn[var2_3] = n3;
            XEiJ.mpuCycleCount += n3 - n5 >> 1;
        }
    }

    public static void irpMovemToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = MC68060.mmuReadWordZeroExword(XEiJ.regPC, XEiJ.regSRS);
        XEiJ.regPC += 2;
        if (n2 >> 3 == 3) {
            var2_2 = n2 - 16;
            n = m60Address = XEiJ.regRn[var2_2];
        } else {
            var2_2 = 16;
            n = MC68060.efaCntLong(n2);
        }
        int n4 = n;
        int n5 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                m60Address = n;
                XEiJ.regRn[n5] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                n += 4;
            }
            ++n5;
            n3 >>>= 1;
        }
        XEiJ.regRn[var2_2] = n;
        XEiJ.mpuCycleCount += n - n4 >> 2;
    }

    public static void irpTrap() throws M68kException {
        MC68060.irpExceptionFormat0(XEiJ.regOC - 20000 << 2, XEiJ.regPC);
    }

    public static void irpTrap15() throws M68kException {
        if ((XEiJ.regRn[0] & 0xFF) == 142) {
            MainMemory.mmrCheckHuman();
        }
        MC68060.irpExceptionFormat0(188, XEiJ.regPC);
    }

    public static void irpLinkWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        int n2 = XEiJ.regOC - 20040;
        int n3 = XEiJ.regRn[n2];
        m60Incremented -= 0x400000000000000L;
        m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        int n4 = XEiJ.regRn[15];
        MC68060.mmuWriteLongData(n4, n3, XEiJ.regSRS);
        XEiJ.regRn[n2] = n4;
        XEiJ.regRn[15] = n4 + n;
    }

    public static void irpUnlk() throws M68kException {
        XEiJ.mpuCycleCount += 2;
        int n = XEiJ.regOC - 20048;
        int n2 = XEiJ.regRn[n];
        m60Incremented += 0x400000000000000L;
        XEiJ.regRn[15] = n2 + 4;
        m60Address = n2;
        XEiJ.regRn[n] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
    }

    public static void irpMoveToUsp() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 2;
        XEiJ.mpuUSP = XEiJ.regRn[XEiJ.regOC - 20056];
    }

    public static void irpMoveFromUsp() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
        XEiJ.regRn[XEiJ.regOC - 20064] = XEiJ.mpuUSP;
    }

    public static void irpReset() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 45;
        XEiJ.irpReset();
    }

    public static void irpNop() throws M68kException {
        XEiJ.mpuCycleCount += 9;
    }

    public static void irpStop() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
        MC68060.irpSetSR(MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, 1));
        if (XEiJ.mpuTraceFlag == 0) {
            XEiJ.regPC = XEiJ.regPC0;
            XEiJ.mpuClockTime += 4000000L;
            XEiJ.mpuLastNano += 4000L;
        }
    }

    public static void irpRte() throws M68kException {
        int n;
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 17;
        m60Address = n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadWordZeroData(m60Address, 1);
        m60Address = n + 2;
        int n3 = MC68060.mmuReadLongData(m60Address, 1);
        m60Address = n + 6;
        int n4 = MC68060.mmuReadWordZeroData(m60Address, 1) >> 12;
        if (n4 == 0) {
            m60Incremented += 0x800000000000000L;
            XEiJ.regRn[15] = n + 8;
        } else if (n4 == 2 || n4 == 3) {
            m60Incremented += 0xC00000000000000L;
            XEiJ.regRn[15] = n + 12;
        } else if (n4 == 4) {
            m60Incremented += 0x1000000000000000L;
            XEiJ.regRn[15] = n + 16;
        } else {
            M68kException.m6eNumber = 14;
            throw M68kException.m6eSignal;
        }
        MC68060.irpSetSR(n2);
        MC68060.irpSetPC(n3);
    }

    public static void irpRtd() throws M68kException {
        XEiJ.mpuCycleCount += 7;
        int n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        m60Address = n;
        MC68060.irpSetPC(MC68060.mmuReadLongData(m60Address, XEiJ.regSRS));
        m60Incremented += 0x400000000000000L;
        XEiJ.regRn[15] = n + 4 + n2;
    }

    public static void irpRts() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 7;
        m60Address = n = XEiJ.regRn[15];
        MC68060.irpSetPC(MC68060.mmuReadLongData(m60Address, XEiJ.regSRS));
        m60Incremented += 0x400000000000000L;
        XEiJ.regRn[15] = n + 4;
    }

    public static void irpTrapv() throws M68kException {
        if ((XEiJ.regCCR & 2) == 0) {
            ++XEiJ.mpuCycleCount;
        } else {
            m60Address = XEiJ.regPC0;
            M68kException.m6eNumber = 7;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpRtr() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 8;
        m60Address = n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadWordZeroData(m60Address, XEiJ.regSRS);
        m60Address = n + 2;
        MC68060.irpSetPC(MC68060.mmuReadLongData(m60Address, XEiJ.regSRS));
        XEiJ.regCCR = 0x1F & n2;
        m60Incremented += 0x600000000000000L;
        XEiJ.regRn[15] = n + 6;
    }

    public static void irpMovecFromControl() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, 1);
        switch (n & 0xFFF) {
            case 0: {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regRn[n >> 12] = XEiJ.mpuSFC;
                break;
            }
            case 1: {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regRn[n >> 12] = XEiJ.mpuDFC;
                break;
            }
            case 2: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = XEiJ.mpuCACR & 0xF880E000;
                break;
            }
            case 3: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetTCR();
                break;
            }
            case 4: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetITT0();
                break;
            }
            case 5: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetITT1();
                break;
            }
            case 6: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetDTT0();
                break;
            }
            case 7: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetDTT1();
                break;
            }
            case 8: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = XEiJ.mpuBUSCR;
                break;
            }
            case 2048: {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regRn[n >> 12] = XEiJ.mpuUSP;
                break;
            }
            case 2049: {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regRn[n >> 12] = XEiJ.mpuVBR;
                break;
            }
            case 2054: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetURP();
                break;
            }
            case 2055: {
                XEiJ.mpuCycleCount += 15;
                XEiJ.regRn[n >> 12] = MC68060.mmuGetSRP();
                break;
            }
            case 2056: {
                XEiJ.mpuCycleCount += 12;
                XEiJ.regRn[n >> 12] = XEiJ.mpuPCR;
                break;
            }
            default: {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpMovecToControl() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, 1);
        int n2 = XEiJ.regRn[n >> 12];
        switch (n & 0xFFF) {
            case 0: {
                XEiJ.mpuCycleCount += 11;
                XEiJ.mpuSFC = n2 & 7;
                break;
            }
            case 1: {
                XEiJ.mpuCycleCount += 11;
                XEiJ.mpuDFC = n2 & 7;
                break;
            }
            case 2: {
                boolean bl;
                XEiJ.mpuCycleCount += 14;
                XEiJ.mpuCACR = n2 & 0xF8E0E000;
                boolean bl2 = bl = (XEiJ.mpuCACR & 0x80008000) != 0;
                if (XEiJ.mpuCacheOn == bl) break;
                XEiJ.mpuCacheOn = bl;
                XEiJ.mpuSetWait();
                break;
            }
            case 3: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetTCR(n2);
                break;
            }
            case 4: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetITT0(n2);
                break;
            }
            case 5: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetITT1(n2);
                break;
            }
            case 6: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetDTT0(n2);
                break;
            }
            case 7: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetDTT1(n2);
                break;
            }
            case 8: {
                XEiJ.mpuCycleCount += 14;
                XEiJ.mpuBUSCR = n2 & 0xF0000000;
                break;
            }
            case 2048: {
                XEiJ.mpuCycleCount += 11;
                XEiJ.mpuUSP = n2;
                break;
            }
            case 2049: {
                XEiJ.mpuCycleCount += 11;
                XEiJ.mpuVBR = n2 & 0xFFFFFFFC;
                break;
            }
            case 2054: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetURP(n2);
                break;
            }
            case 2055: {
                XEiJ.mpuCycleCount += 14;
                MC68060.mmuSetSRP(n2);
                break;
            }
            case 2056: {
                XEiJ.mpuCycleCount += 11;
                XEiJ.mpuPCR = 0x4300700 | n2 & 0x83;
                break;
            }
            default: {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpJsr() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = MC68060.efaJmpJsr(XEiJ.regOC & 0x3F);
        m60Incremented -= 0x400000000000000L;
        m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        int n2 = XEiJ.regRn[15];
        MC68060.mmuWriteLongData(n2, XEiJ.regPC, XEiJ.regSRS);
        MC68060.irpSetPC(n);
    }

    public static void irpJmp() throws M68kException {
        ++XEiJ.mpuCycleCount;
        MC68060.irpSetPC(MC68060.efaJmpJsr(XEiJ.regOC & 0x3F));
    }

    public static void irpAddqByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & by2 + n3;
            by = (byte)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n2);
            byte by3 = MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS);
            n = by3;
            by = (byte)(by3 + n3);
            MC68060.mmuWriteByteData(n5, by, XEiJ.regSRS);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (~n & by) >>> 31 << 1 | (n & ~by) >> 31 & 0x11;
    }

    public static void irpAddqWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
        } else {
            short s;
            int n4;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                int n5 = XEiJ.regRn[n];
                n4 = n5;
                short s2 = (short)n4;
                n4 = s2;
                XEiJ.regRn[n] = 0xFFFF0000 & n5 | (char)(s2 + n2);
                s = (short)XEiJ.regRn[n];
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = MC68060.efaMltWord(n);
                n4 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS);
                s = (short)(n4 + n2);
                MC68060.mmuWriteWordData(n6, s, XEiJ.regSRS);
            }
            XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (~n4 & s) >>> 31 << 1 | (n4 & ~s) >> 31 & 0x11;
        }
    }

    public static void irpAddqLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
        } else {
            int n4;
            int n5;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                n5 = XEiJ.regRn[n];
                XEiJ.regRn[n] = n4 = n5 + n2;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = MC68060.efaMltLong(n);
                n5 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n4 = n5 + n2;
                MC68060.mmuWriteLongData(n6, n4, XEiJ.regSRS);
            }
            XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? 4 : 0) | (~n5 & n4) >>> 31 << 1 | (n5 & ~n4) >> 31 & 0x11;
        }
    }

    public static void irpSt() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] | 0xFF;
        } else if (n < 16) {
            int n3 = XEiJ.regPC;
            XEiJ.regPC = n3 + 2;
            if (((n3 += MC68060.mmuReadWordSignExword(n3, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n3);
            }
            XEiJ.mpuCycleCount += 2;
        } else {
            if (56L << n < 0L) {
                if (n == 58) {
                    MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                } else if (n == 59) {
                    MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                }
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 255, XEiJ.regSRS);
        }
    }

    public static void irpSubqByte() throws M68kException {
        byte by;
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n2 < 8) {
            ++XEiJ.mpuCycleCount;
            int n4 = XEiJ.regRn[n2];
            n = n4;
            byte by2 = (byte)n;
            n = by2;
            XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & by2 - n3;
            by = (byte)XEiJ.regRn[n2];
        } else {
            ++XEiJ.mpuCycleCount;
            int n5 = MC68060.efaMltByte(n2);
            byte by3 = MC68060.mmuModifyByteSignData(n5, XEiJ.regSRS);
            n = by3;
            by = (byte)(by3 - n3);
            MC68060.mmuWriteByteData(n5, by, XEiJ.regSRS);
        }
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (n & ~by) >>> 31 << 1 | (~n & by) >> 31 & 0x11;
    }

    public static void irpSubqWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
        } else {
            short s;
            int n4;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                int n5 = XEiJ.regRn[n];
                n4 = n5;
                short s2 = (short)n4;
                n4 = s2;
                XEiJ.regRn[n] = 0xFFFF0000 & n5 | (char)(s2 - n2);
                s = (short)XEiJ.regRn[n];
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = MC68060.efaMltWord(n);
                n4 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS);
                s = (short)(n4 - n2);
                MC68060.mmuWriteWordData(n6, s, XEiJ.regSRS);
            }
            XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (n4 & ~s) >>> 31 << 1 | (~n4 & s) >> 31 & 0x11;
        }
    }

    public static void irpSubqLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = ((XEiJ.regOC >> 9) - 1 & 7) + 1;
        if (n >> 3 == 1) {
            ++XEiJ.mpuCycleCount;
            int n3 = n;
            XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
        } else {
            int n4;
            int n5;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                n5 = XEiJ.regRn[n];
                XEiJ.regRn[n] = n4 = n5 - n2;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = MC68060.efaMltLong(n);
                n5 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n4 = n5 - n2;
                MC68060.mmuWriteLongData(n6, n4, XEiJ.regSRS);
            }
            XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? 4 : 0) | (n5 & ~n4) >>> 31 << 1 | (~n5 & n4) >> 31 & 0x11;
        }
    }

    public static void irpSf() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 8) {
            ++XEiJ.mpuCycleCount;
            int n2 = n;
            XEiJ.regRn[n2] = XEiJ.regRn[n2] & 0xFFFFFF00;
        } else if (n < 16) {
            int n3;
            int n4;
            int n5 = XEiJ.regPC;
            XEiJ.regPC = n5 + 2;
            if (((n5 += MC68060.mmuReadWordSignExword(n5, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n5);
            }
            if ((short)(n4 = XEiJ.regRn[n3 = XEiJ.regOC & 7]) == 0) {
                XEiJ.mpuCycleCount += 2;
                XEiJ.regRn[n3] = n4 + 65535;
            } else {
                ++XEiJ.mpuCycleCount;
                XEiJ.regRn[n3] = n4 - 1;
                MC68060.irpSetPC(n5);
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0, XEiJ.regSRS);
        }
    }

    public static void irpShi() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-1600085856 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-1600085856 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-1600085856 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -1600085856 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSls() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0x5F5F5F5F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0x5F5F5F5F << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0x5F5F5F5F << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0x5F5F5F5F << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpShs() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-1431655766 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-1431655766 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-1431655766 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -1431655766 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSlo() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0x55555555 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0x55555555 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0x55555555 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0x55555555 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSne() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-252645136 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-252645136 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-252645136 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -252645136 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSeq() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0xF0F0F0F << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0xF0F0F0F << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0xF0F0F0F << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0xF0F0F0F << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSvc() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-858993460 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-858993460 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-858993460 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -858993460 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSvs() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0x33333333 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0x33333333 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0x33333333 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0x33333333 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSpl() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-16711936 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-16711936 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-16711936 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -16711936 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSmi() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0xFF00FF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0xFF00FF << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0xFF00FF << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0xFF00FF << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSge() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-869020621 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-869020621 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-869020621 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -869020621 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSlt() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0x33CC33CC << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0x33CC33CC << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0x33CC33CC << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0x33CC33CC << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSgt() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (-1070546896 << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (-1070546896 << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (-1070546896 << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), -1070546896 << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpSle() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            if (((n2 += MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS)) & 1) != 0) {
                MC68060.irpBccAddressError(n2);
            }
            if (0x3FCF3FCF << XEiJ.regCCR < 0) {
                XEiJ.mpuCycleCount += 2;
            } else {
                int n3 = XEiJ.regOC & 7;
                int n4 = XEiJ.regRn[n3];
                if ((short)n4 == 0) {
                    XEiJ.mpuCycleCount += 2;
                    XEiJ.regRn[n3] = n4 + 65535;
                } else {
                    ++XEiJ.mpuCycleCount;
                    XEiJ.regRn[n3] = n4 - 1;
                    MC68060.irpSetPC(n2);
                }
            }
        } else if (n < 8) {
            if (0x3FCF3FCF << XEiJ.regCCR < 0) {
                ++XEiJ.mpuCycleCount;
                int n5 = n;
                XEiJ.regRn[n5] = XEiJ.regRn[n5] | 0xFF;
            } else {
                ++XEiJ.mpuCycleCount;
                int n6 = n;
                XEiJ.regRn[n6] = XEiJ.regRn[n6] & 0xFFFFFF00;
            }
        } else if (56L << n < 0L) {
            if (n == 58) {
                MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            } else if (n == 59) {
                MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
            }
            if (0x3FCF3FCF << XEiJ.regCCR < 0) {
                m60Address = XEiJ.regPC0;
                M68kException.m6eNumber = 7;
                throw M68kException.m6eSignal;
            }
            ++XEiJ.mpuCycleCount;
        } else {
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(MC68060.efaMltByte(n), 0x3FCF3FCF << XEiJ.regCCR >> 31, XEiJ.regSRS);
        }
    }

    public static void irpBrasw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        MC68060.irpSetPC(n + n2);
    }

    public static void irpBras() throws M68kException {
        ++XEiJ.mpuCycleCount;
        MC68060.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
    }

    public static void irpBrasl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        MC68060.irpSetPC(n + n2);
    }

    public static void irpBsrsw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        m60Incremented -= 0x400000000000000L;
        m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        int n3 = XEiJ.regRn[15];
        MC68060.mmuWriteLongData(n3, XEiJ.regPC, XEiJ.regSRS);
        MC68060.irpSetPC(n + n2);
    }

    public static void irpBsrs() throws M68kException {
        ++XEiJ.mpuCycleCount;
        m60Incremented -= 0x400000000000000L;
        m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        int n = XEiJ.regRn[15];
        MC68060.mmuWriteLongData(n, XEiJ.regPC, XEiJ.regSRS);
        MC68060.irpSetPC(XEiJ.regPC + (byte)XEiJ.regOC);
    }

    public static void irpBsrsl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        m60Incremented -= 0x400000000000000L;
        m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 4;
        int n3 = XEiJ.regRn[15];
        MC68060.mmuWriteLongData(n3, XEiJ.regPC, XEiJ.regSRS);
        MC68060.irpSetPC(n + n2);
    }

    public static void irpBccAddressError(int n) throws M68kException {
        M68kException.m6eNumber = 3;
        m60Address = n & 0xFFFFFFFE;
        M68kException.m6eDirection = 1;
        M68kException.m6eSize = 1;
        throw M68kException.m6eSignal;
    }

    public static void irpBhisw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1600085856 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBhis() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1600085856 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBhisl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1600085856 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlssw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x5F5F5F5F << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlss() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x5F5F5F5F << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlssl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x5F5F5F5F << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBhssw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1431655766 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBhss() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1431655766 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBhssl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1431655766 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlosw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x55555555 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlos() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x55555555 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlosl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x55555555 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBnesw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-252645136 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBnes() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-252645136 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBnesl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-252645136 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBeqsw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0xF0F0F0F << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBeqs() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0xF0F0F0F << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBeqsl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0xF0F0F0F << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBvcsw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-858993460 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBvcs() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-858993460 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBvcsl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-858993460 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBvssw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x33333333 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBvss() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x33333333 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBvssl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x33333333 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBplsw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-16711936 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBpls() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-16711936 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBplsl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-16711936 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBmisw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0xFF00FF << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBmis() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0xFF00FF << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBmisl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0xFF00FF << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBgesw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-869020621 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBges() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-869020621 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBgesl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-869020621 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBltsw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x33CC33CC << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlts() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x33CC33CC << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBltsl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x33CC33CC << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBgtsw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1070546896 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBgts() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1070546896 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBgtsl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (-1070546896 << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlesw() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == 0) {
            XEiJ.regPC = n + 2;
            n2 = MC68060.mmuReadWordSignExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x3FCF3FCF << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBles() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        byte by = (byte)XEiJ.regOC;
        if (((n += by) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x3FCF3FCF << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpBlesl() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        int n2 = XEiJ.regOC;
        if (n2 == -1) {
            XEiJ.regPC = n + 4;
            n2 = MC68060.mmuReadLongExword(n, XEiJ.regSRS);
        }
        if (((n += n2) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (0x3FCF3FCF << XEiJ.regCCR < 0) {
            MC68060.irpSetPC(n);
        }
    }

    public static void irpMoveq() throws M68kException {
        ++XEiJ.mpuCycleCount;
        byte by = (byte)XEiJ.regOC;
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = by;
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMvsByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        byte by = n < 8 ? (byte)XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = by;
        XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMvsWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        short s = n < 8 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = s;
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMvzByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 8 ? 0xFF & XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadByteZeroExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : MC68060.mmuReadByteZeroData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = n2;
        XEiJ.regCCR = 0x10 & XEiJ.regCCR | (n2 == 0 ? 4 : 0);
    }

    public static void irpMvzWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        char c = n < 8 ? (char)XEiJ.regRn[n] : (n == 60 ? (char)MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (char)MC68060.mmuReadWordZeroData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        XEiJ.regRn[XEiJ.regOC >> 9 & 7] = c;
        XEiJ.regCCR = 0x10 & XEiJ.regCCR | (c == '\u0000' ? 4 : 0);
    }

    public static void irpOrToRegByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] | 0xFF & (n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS)));
        XEiJ.regRn[n2] = n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpOrToRegWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] | (n < 8 ? (char)XEiJ.regRn[n] : (n == 60 ? (char)MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (char)MC68060.mmuReadWordZeroData(MC68060.efaAnyWord(n), XEiJ.regSRS)));
        XEiJ.regRn[n2] = n3;
        short s = (short)n3;
        XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpOrToRegLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] | (n < 8 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS)));
        XEiJ.regRn[n2] = n3;
        int n4 = n3;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpDivuWord() throws M68kException {
        XEiJ.mpuCycleCount += 22;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        char c = n < 8 ? (char)XEiJ.regRn[n] : (n == 60 ? (char)MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (char)MC68060.mmuReadWordZeroData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = XEiJ.regRn[n2];
        if (c == '\u0000') {
            XEiJ.regCCR &= 0x1E;
            m60Address = XEiJ.regPC0;
            M68kException.m6eNumber = 5;
            throw M68kException.m6eSignal;
        }
        int n4 = (int)((double)((long)n3 & 0xFFFFFFFFL) / (double)c);
        if (n4 >>> 16 != 0) {
            XEiJ.regCCR = XEiJ.regCCR & 0x1C | 2;
        } else {
            XEiJ.regRn[n2] = n3 - c * n4 << 16 | n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | ((n4 = (int)((short)n4)) < 0 ? 8 : 0) | (n4 == 0 ? 4 : 0);
        }
    }

    public static void irpOrToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            ++XEiJ.mpuCycleCount;
            int n2 = MC68060.efaMltByte(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] | MC68060.mmuReadByteSignData(n2, XEiJ.regSRS);
            MC68060.mmuWriteByteData(n2, n3, XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
        } else if (n < 8) {
            int n4 = XEiJ.regOC >> 9 & 7;
            ++XEiJ.mpuCycleCount;
            int n5 = XEiJ.regRn[n4];
            XEiJ.regRn[n4] = 0xFFFFFF00 & n5 | MC68060.irpSbcd(n5, XEiJ.regRn[n]);
        } else {
            XEiJ.mpuCycleCount += 2;
            m60Incremented -= 1L << (n << 3);
            int n6 = n;
            int n7 = XEiJ.regRn[n6] - 1;
            XEiJ.regRn[n6] = n7;
            m60Address = n7;
            int n8 = n7;
            int n9 = MC68060.mmuReadByteZeroData(n8, XEiJ.regSRS);
            int n10 = (XEiJ.regOC >> 9) - 56;
            m60Incremented -= 1L << (n10 << 3);
            int n11 = n10;
            int n12 = XEiJ.regRn[n11] - 1;
            XEiJ.regRn[n11] = n12;
            m60Address = n12;
            n8 = n12;
            MC68060.mmuWriteByteData(n8, MC68060.irpSbcd(MC68060.mmuModifyByteZeroData(n8, XEiJ.regSRS), n9), XEiJ.regSRS);
        }
    }

    public static void irpOrToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            ++XEiJ.mpuCycleCount;
            int n2 = MC68060.efaMltWord(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] | MC68060.mmuModifyWordSignData(n2, XEiJ.regSRS);
            MC68060.mmuWriteWordData(n2, n3, XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n3 - '\u0001' >> 31 & 4 | ((short)n3 < 0 ? 8 : 0);
        } else if (n < 8) {
            XEiJ.mpuCycleCount += 2;
            int n4 = XEiJ.regOC >> 9 & 7;
            int n5 = XEiJ.regRn[n] + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            XEiJ.regRn[n4] = 0xFFFFFF00 & XEiJ.regRn[n4] | n5 >> 4 & 0xF0 | n5 & 0xF;
        } else {
            int n6 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            m60Incremented -= 2L << (n << 3);
            int n7 = n;
            int n8 = XEiJ.regRn[n7] - 2;
            XEiJ.regRn[n7] = n8;
            m60Address = n8;
            int n9 = n8;
            int n10 = MC68060.mmuReadWordSignData(n9, XEiJ.regSRS) + n6;
            int n11 = (XEiJ.regOC >> 9) - 56;
            m60Incremented -= 1L << (n11 << 3);
            int n12 = n11;
            int n13 = XEiJ.regRn[n12] - 1;
            XEiJ.regRn[n12] = n13;
            m60Address = n13;
            n9 = n13;
            MC68060.mmuWriteByteData(n9, n10 >> 4 & 0xF0 | n10 & 0xF, XEiJ.regSRS);
        }
    }

    public static void irpOrToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            ++XEiJ.mpuCycleCount;
            int n2 = MC68060.efaMltLong(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] | MC68060.mmuModifyLongData(n2, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n2, n3, XEiJ.regSRS);
            XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        } else if (n < 8) {
            int n4 = XEiJ.regOC >> 9 & 7;
            int n5 = XEiJ.regRn[n];
            XEiJ.regRn[n4] = 0xFFFF0000 & XEiJ.regRn[n4] | (char)((n5 << 4 & 0xF00 | n5 & 0xF) + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS));
        } else {
            int n6 = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
            m60Incremented -= 1L << (n << 3);
            int n7 = n;
            int n8 = XEiJ.regRn[n7] - 1;
            XEiJ.regRn[n7] = n8;
            m60Address = n8;
            int n9 = n8;
            byte by = MC68060.mmuReadByteSignData(n9, XEiJ.regSRS);
            int n10 = (XEiJ.regOC >> 9) - 56;
            m60Incremented -= 2L << (n10 << 3);
            int n11 = n10;
            int n12 = XEiJ.regRn[n11] - 2;
            XEiJ.regRn[n11] = n12;
            m60Address = n12;
            n9 = n12;
            MC68060.mmuWriteWordData(n9, (by << 4 & 0xF00 | by & 0xF) + n6, XEiJ.regSRS);
        }
    }

    public static void irpDivsWord() throws M68kException {
        XEiJ.mpuCycleCount += 22;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        short s = n < 8 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n3 = XEiJ.regRn[n2];
        if (s == 0) {
            XEiJ.regCCR &= 0x1E;
            m60Address = XEiJ.regPC0;
            M68kException.m6eNumber = 5;
            throw M68kException.m6eSignal;
        }
        int n4 = n3 / s;
        if ((short)n4 != n4) {
            XEiJ.regCCR = XEiJ.regCCR & 0x1C | 2;
        } else {
            XEiJ.regRn[n2] = n3 - s * n4 << 16 | (char)n4;
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n4 < 0 ? 8 : 0) | (n4 == 0 ? 4 : 0);
        }
    }

    public static void irpSubToRegByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 - n3;
        XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & n5;
        XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n5] | ((n4 ^ n3) & (n4 ^ n5)) >> 6 & 2 | (byte)(n4 & (n3 ^ n5) ^ (n3 | n5)) >> 7 & 0x11;
    }

    public static void irpSubToRegWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 - n3;
        XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)n5;
        XEiJ.regCCR = n5 >> 12 & 8 | (char)n5 - '\u0001' >> 14 & 4 | ((n4 ^ n3) & (n4 ^ n5)) >> 14 & 2 | (short)(n4 & (n3 ^ n5) ^ (n3 | n5)) >> 15 & 0x11;
    }

    public static void irpSubToRegLong() throws M68kException {
        int n;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        ++XEiJ.mpuCycleCount;
        int n4 = n2 < 16 ? XEiJ.regRn[n2] : (n2 == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n2), XEiJ.regSRS));
        int n5 = XEiJ.regRn[n3];
        XEiJ.regRn[n3] = n = n5 - n4;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n5 ^ n4) & (n5 ^ n)) >> 30 & 2 | (n5 & (n4 ^ n) ^ (n4 | n)) >> 31 & 0x11;
    }

    public static void irpSubaWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        short s = n < 16 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n2 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n2] = XEiJ.regRn[n2] - s;
    }

    public static void irpSubToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                ++XEiJ.mpuCycleCount;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFFFF00 & n3 | 0xFF & n2;
            } else {
                XEiJ.mpuCycleCount += 2;
                m60Incremented -= 1L << (n << 3);
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 1;
                XEiJ.regRn[n6] = n7;
                m60Address = n7;
                int n8 = n7;
                n4 = MC68060.mmuReadByteSignData(n8, XEiJ.regSRS);
                int n9 = XEiJ.regOC >> 9 & 0xF;
                m60Incremented -= 1L << (n9 << 3);
                int n10 = n9;
                int n11 = XEiJ.regRn[n10] - 1;
                XEiJ.regRn[n10] = n11;
                m60Address = n11;
                n8 = n11;
                n3 = MC68060.mmuModifyByteSignData(n8, XEiJ.regSRS);
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                MC68060.mmuWriteByteData(n8, n2, XEiJ.regSRS);
            }
            XEiJ.regCCR = n2 >> 4 & 8 | (0xFF & n2) - 1 >> 6 & XEiJ.regCCR & 4 | ((n3 ^ n4) & (n3 ^ n2)) >> 6 & 2 | (byte)(n3 & (n4 ^ n2) ^ (n4 | n2)) >> 7 & 0x11;
        } else {
            ++XEiJ.mpuCycleCount;
            int n12 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n13 = MC68060.efaMltByte(n);
            byte by = MC68060.mmuModifyByteSignData(n13, XEiJ.regSRS);
            int n14 = by - n12;
            MC68060.mmuWriteByteData(n13, n14, XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n14] | ((by ^ n12) & (by ^ n14)) >> 6 & 2 | (byte)(by & (n12 ^ n14) ^ (n12 | n14)) >> 7 & 0x11;
        }
    }

    public static void irpSubToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                ++XEiJ.mpuCycleCount;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFF0000 & n3 | (char)n2;
            } else {
                XEiJ.mpuCycleCount += 2;
                m60Incremented -= 2L << (n << 3);
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 2;
                XEiJ.regRn[n6] = n7;
                m60Address = n7;
                int n8 = n7;
                n4 = MC68060.mmuReadWordSignData(n8, XEiJ.regSRS);
                int n9 = XEiJ.regOC >> 9 & 0xF;
                m60Incremented -= 2L << (n9 << 3);
                int n10 = n9;
                int n11 = XEiJ.regRn[n10] - 2;
                XEiJ.regRn[n10] = n11;
                m60Address = n11;
                n8 = n11;
                n3 = MC68060.mmuModifyWordSignData(n8, XEiJ.regSRS);
                n2 = n3 - n4 - (XEiJ.regCCR >> 4);
                MC68060.mmuWriteWordData(n8, n2, XEiJ.regSRS);
            }
            XEiJ.regCCR = n2 >> 12 & 8 | (char)n2 - '\u0001' >> 14 & XEiJ.regCCR & 4 | ((n3 ^ n4) & (n3 ^ n2)) >> 14 & 2 | (short)(n3 & (n4 ^ n2) ^ (n4 | n2)) >> 15 & 0x11;
        } else {
            ++XEiJ.mpuCycleCount;
            short s = (short)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n12 = MC68060.efaMltWord(n);
            int n13 = MC68060.mmuModifyWordSignData(n12, XEiJ.regSRS);
            int n14 = n13 - s;
            MC68060.mmuWriteWordData(n12, n14, XEiJ.regSRS);
            XEiJ.regCCR = n14 >> 12 & 8 | (char)n14 - '\u0001' >> 14 & 4 | ((n13 ^ s) & (n13 ^ n14)) >> 14 & 2 | (short)(n13 & (s ^ n14) ^ (s | n14)) >> 15 & 0x11;
        }
    }

    public static void irpSubToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                ++XEiJ.mpuCycleCount;
                n4 = XEiJ.regRn[n5];
                n3 = XEiJ.regRn[n];
                XEiJ.regRn[n5] = n2 = n4 - n3 - (XEiJ.regCCR >> 4);
            } else {
                XEiJ.mpuCycleCount += 2;
                m60Incremented -= 4L << (n << 3);
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 4;
                XEiJ.regRn[n6] = n7;
                m60Address = n7;
                int n8 = n7;
                n3 = MC68060.mmuReadLongData(n8, XEiJ.regSRS);
                int n9 = XEiJ.regOC >> 9 & 0xF;
                m60Incremented -= 4L << (n9 << 3);
                int n10 = n9;
                int n11 = XEiJ.regRn[n10] - 4;
                XEiJ.regRn[n10] = n11;
                m60Address = n11;
                n8 = n11;
                n4 = MC68060.mmuModifyLongData(n8, XEiJ.regSRS);
                n2 = n4 - n3 - (XEiJ.regCCR >> 4);
                MC68060.mmuWriteLongData(n8, n2, XEiJ.regSRS);
            }
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 4 : 0) | ((n4 ^ n3) & (n4 ^ n2)) >>> 31 << 1 | (n4 & (n3 ^ n2) ^ (n3 | n2)) >> 31 & 0x11;
        } else {
            ++XEiJ.mpuCycleCount;
            int n12 = MC68060.efaMltLong(n);
            int n13 = MC68060.mmuModifyLongData(n12, XEiJ.regSRS);
            int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n15 = n13 - n14;
            MC68060.mmuWriteLongData(n12, n15, XEiJ.regSRS);
            XEiJ.regCCR = n15 >> 28 & 8 | (n15 == 0 ? 4 : 0) | ((n13 ^ n14) & (n13 ^ n15)) >>> 31 << 1 | (n13 & (n14 ^ n15) ^ (n14 | n15)) >> 31 & 0x11;
        }
    }

    public static void irpSubaLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        ++XEiJ.mpuCycleCount;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n3] = XEiJ.regRn[n3] - n2;
    }

    public static void irpAline() throws M68kException {
        MC68060.irpExceptionFormat0(40, XEiJ.regPC0);
    }

    public static void irpCmpByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        byte by = (byte)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        byte by2 = n < 8 ? (byte)XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        byte by3 = (byte)(by - by2);
        XEiJ.regCCR = by3 >> 28 & 8 | (by3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((by ^ by2) & (by ^ by3)) >>> 31 << 1 | (by & (by2 ^ by3) ^ (by2 | by3)) >>> 31;
    }

    public static void irpCmpWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        short s = (short)XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        short s2 = n < 16 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        short s3 = (short)(s - s2);
        XEiJ.regCCR = s3 >> 28 & 8 | (s3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((s ^ s2) & (s ^ s3)) >>> 31 << 1 | (s & (s2 ^ s3) ^ (s2 | s3)) >>> 31;
    }

    public static void irpCmpLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
        int n3 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n4 = n2 - n3;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n2 ^ n3) & (n2 ^ n4)) >>> 31 << 1 | (n2 & (n3 ^ n4) ^ (n3 | n4)) >>> 31;
    }

    public static void irpCmpaWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        short s = n < 16 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n2 = XEiJ.regRn[XEiJ.regOC >> 9 & 0xF];
        int n3 = n2 - s;
        XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n2 ^ s) & (n2 ^ n3)) >>> 31 << 1 | (n2 & (s ^ n3) ^ (s | n3)) >>> 31;
    }

    public static void irpEorByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            byte by;
            XEiJ.mpuCycleCount += 2;
            m60Incremented += 1L << (n << 3);
            int n2 = n;
            int n3 = XEiJ.regRn[n2];
            XEiJ.regRn[n2] = n3 + 1;
            m60Address = n3;
            int n4 = n3;
            byte by2 = MC68060.mmuReadByteSignData(n4, XEiJ.regSRS);
            int n5 = XEiJ.regOC >> 9 & 0xF;
            m60Incremented += 1L << (n5 << 3);
            int n6 = n5;
            int n7 = XEiJ.regRn[n6];
            XEiJ.regRn[n6] = n7 + 1;
            m60Address = n7;
            n4 = n7;
            byte by3 = MC68060.mmuReadByteSignData(n4, XEiJ.regSRS);
            XEiJ.regCCR = by >> 28 & 8 | ((by = (byte)(by3 - by2)) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((by3 ^ by2) & (by3 ^ by)) >>> 31 << 1 | (by3 & (by2 ^ by) ^ (by2 | by)) >>> 31;
        } else {
            int n8;
            int n9 = XEiJ.regOC >> 9 & 7;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                int n10 = n;
                int n11 = XEiJ.regRn[n10] ^ 0xFF & XEiJ.regRn[n9];
                XEiJ.regRn[n10] = n11;
                n8 = n11;
            } else {
                ++XEiJ.mpuCycleCount;
                int n12 = MC68060.efaMltByte(n);
                n8 = XEiJ.regRn[n9] ^ MC68060.mmuModifyByteSignData(n12, XEiJ.regSRS);
                MC68060.mmuWriteByteData(n12, n8, XEiJ.regSRS);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n8];
        }
    }

    public static void irpEorWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC & 7;
        int n3 = n >> 3;
        if (n3 == 1) {
            short s;
            XEiJ.mpuCycleCount += 2;
            m60Incremented += 2L << (n << 3);
            int n4 = n;
            int n5 = XEiJ.regRn[n4] + 2;
            XEiJ.regRn[n4] = n5;
            int n6 = m60Address = n5 - 2;
            int n7 = MC68060.mmuReadWordSignData(n6, XEiJ.regSRS);
            int n8 = XEiJ.regOC >> 9 & 0xF;
            m60Incremented += 2L << (n8 << 3);
            int n9 = n8;
            int n10 = XEiJ.regRn[n9] + 2;
            XEiJ.regRn[n9] = n10;
            m60Address = n10 - 2;
            n6 = m60Address;
            int n11 = MC68060.mmuReadWordSignData(n6, XEiJ.regSRS);
            XEiJ.regCCR = s >> 28 & 8 | ((s = (short)(n11 - n7)) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n11 ^ n7) & (n11 ^ s)) >>> 31 << 1 | (n11 & (n7 ^ s) ^ (n7 | s)) >>> 31;
        } else {
            int n12;
            int n13 = XEiJ.regOC >> 9 & 7;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                int n14 = n2;
                int n15 = XEiJ.regRn[n14] ^ (char)XEiJ.regRn[n13];
                XEiJ.regRn[n14] = n15;
                n12 = n15;
            } else {
                ++XEiJ.mpuCycleCount;
                int n16 = MC68060.efaMltWord(n);
                n12 = XEiJ.regRn[n13] ^ MC68060.mmuModifyWordSignData(n16, XEiJ.regSRS);
                MC68060.mmuWriteWordData(n16, n12, XEiJ.regSRS);
            }
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n12 - '\u0001' >> 31 & 4 | ((short)n12 < 0 ? 8 : 0);
        }
    }

    public static void irpEorLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >> 3 == 1) {
            int n2;
            XEiJ.mpuCycleCount += 2;
            m60Incremented += 4L << (n << 3);
            int n3 = n;
            int n4 = XEiJ.regRn[n3] + 4;
            XEiJ.regRn[n3] = n4;
            int n5 = m60Address = n4 - 4;
            int n6 = MC68060.mmuReadLongData(n5, XEiJ.regSRS);
            int n7 = XEiJ.regOC >> 9 & 0xF;
            m60Incremented += 4L << (n7 << 3);
            int n8 = n7;
            int n9 = XEiJ.regRn[n8] + 4;
            XEiJ.regRn[n8] = n9;
            m60Address = n9 - 4;
            n5 = m60Address;
            int n10 = MC68060.mmuReadLongData(n5, XEiJ.regSRS);
            XEiJ.regCCR = n2 >> 28 & 8 | ((n2 = n10 - n6) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n10 ^ n6) & (n10 ^ n2)) >>> 31 << 1 | (n10 & (n6 ^ n2) ^ (n6 | n2)) >>> 31;
        } else {
            int n11;
            int n12 = XEiJ.regOC >> 9 & 7;
            if (n < 8) {
                ++XEiJ.mpuCycleCount;
                XEiJ.regRn[n] = n11 = XEiJ.regRn[n] ^ XEiJ.regRn[n12];
            } else {
                ++XEiJ.mpuCycleCount;
                int n13 = MC68060.efaMltLong(n);
                n11 = MC68060.mmuModifyLongData(n13, XEiJ.regSRS) ^ XEiJ.regRn[n12];
                MC68060.mmuWriteLongData(n13, n11, XEiJ.regSRS);
            }
            XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        }
    }

    public static void irpCmpaLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 0xF];
        int n4 = n3 - n2;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | ((n3 ^ n2) & (n3 ^ n4)) >>> 31 << 1 | (n3 & (n2 ^ n4) ^ (n2 | n4)) >>> 31;
    }

    public static void irpAndToRegByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] & (0xFFFFFF00 | (n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS))));
        XEiJ.regRn[n2] = n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
    }

    public static void irpAndToRegWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] & (0xFFFF0000 | (n < 8 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS))));
        XEiJ.regRn[n2] = n3;
        int n4 = n3;
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n4 - '\u0001' >> 31 & 4 | ((short)n4 < 0 ? 8 : 0);
    }

    public static void irpAndToRegLong() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = XEiJ.regRn[n2] & (n < 8 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS)));
        XEiJ.regRn[n2] = n3;
        int n4 = n3;
        XEiJ.regCCR = n4 >> 28 & 8 | (n4 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpMuluWord() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 2;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        char c = n2 < 8 ? (char)XEiJ.regRn[n2] : (n2 == 60 ? (char)MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (char)MC68060.mmuReadWordZeroData(MC68060.efaAnyWord(n2), XEiJ.regSRS));
        XEiJ.regRn[n3] = n = (char)XEiJ.regRn[n3] * c;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpAndToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n >= 16) {
            ++XEiJ.mpuCycleCount;
            int n2 = MC68060.efaMltByte(n);
            int n3 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & MC68060.mmuModifyByteSignData(n2, XEiJ.regSRS);
            MC68060.mmuWriteByteData(n2, n3, XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | XEiJ.MPU_TSTB_TABLE[0xFF & n3];
        } else if (n < 8) {
            int n4 = XEiJ.regOC >> 9 & 7;
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[n4] = 0xFFFFFF00 & XEiJ.regRn[n4] | MC68060.irpAbcd(XEiJ.regRn[n4], XEiJ.regRn[n]);
        } else {
            XEiJ.mpuCycleCount += 2;
            m60Incremented -= 1L << (n << 3);
            int n5 = n;
            int n6 = XEiJ.regRn[n5] - 1;
            XEiJ.regRn[n5] = n6;
            m60Address = n6;
            int n7 = n6;
            int n8 = MC68060.mmuReadByteZeroData(n7, XEiJ.regSRS);
            int n9 = (XEiJ.regOC >> 9) - 88;
            m60Incremented -= 1L << (n9 << 3);
            int n10 = n9;
            int n11 = XEiJ.regRn[n10] - 1;
            XEiJ.regRn[n10] = n11;
            m60Address = n11;
            n7 = n11;
            MC68060.mmuWriteByteData(n7, MC68060.irpAbcd(MC68060.mmuModifyByteZeroData(n7, XEiJ.regSRS), n8), XEiJ.regSRS);
        }
    }

    public static void irpAndToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            ++XEiJ.mpuCycleCount;
            if (n < 8) {
                int n2 = XEiJ.regOC >> 9 & 7;
                int n3 = XEiJ.regRn[n2];
                XEiJ.regRn[n2] = XEiJ.regRn[n];
                XEiJ.regRn[n] = n3;
            } else {
                int n4 = (XEiJ.regOC >> 9) - 88;
                int n5 = XEiJ.regRn[n4];
                XEiJ.regRn[n4] = XEiJ.regRn[n];
                XEiJ.regRn[n] = n5;
            }
        } else {
            ++XEiJ.mpuCycleCount;
            int n6 = MC68060.efaMltWord(n);
            int n7 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS);
            MC68060.mmuWriteWordData(n6, n7, XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.regCCR & 0x10 | (char)n7 - '\u0001' >> 31 & 4 | ((short)n7 < 0 ? 8 : 0);
        }
    }

    public static void irpAndToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        if (n >> 3 == 1) {
            ++XEiJ.mpuCycleCount;
            int n3 = XEiJ.regRn[n2];
            XEiJ.regRn[n2] = XEiJ.regRn[n];
            XEiJ.regRn[n] = n3;
        } else {
            ++XEiJ.mpuCycleCount;
            int n4 = MC68060.efaMltLong(n);
            int n5 = MC68060.mmuModifyLongData(n4, XEiJ.regSRS) & XEiJ.regRn[n2];
            MC68060.mmuWriteLongData(n4, n5, XEiJ.regSRS);
            XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
        }
    }

    public static void irpMulsWord() throws M68kException {
        int n;
        XEiJ.mpuCycleCount += 2;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        short s = n2 < 8 ? (short)XEiJ.regRn[n2] : (n2 == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n2), XEiJ.regSRS));
        XEiJ.regRn[n3] = n = (short)XEiJ.regRn[n3] * s;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpAddToRegByte() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 8 ? XEiJ.regRn[n] : (n == 60 ? (int)MC68060.mmuReadByteSignExword((XEiJ.regPC += 2) - 1, XEiJ.regSRS) : (int)MC68060.mmuReadByteSignData(MC68060.efaAnyByte(n), XEiJ.regSRS));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 + n3;
        XEiJ.regRn[n2] = 0xFFFFFF00 & n4 | 0xFF & n5;
        XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n5] | ((n4 ^ n5) & (n3 ^ n5)) >> 6 & 2 | (byte)((n4 | n3) ^ (n4 ^ n3) & n5) >> 7 & 0x11;
    }

    public static void irpAddToRegWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = XEiJ.regOC >> 9 & 7;
        int n3 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n4 = XEiJ.regRn[n2];
        int n5 = n4 + n3;
        XEiJ.regRn[n2] = 0xFFFF0000 & n4 | (char)n5;
        XEiJ.regCCR = n5 >> 12 & 8 | (char)n5 - '\u0001' >> 14 & 4 | ((n4 ^ n5) & (n3 ^ n5)) >> 14 & 2 | (short)((n4 | n3) ^ (n4 ^ n3) & n5) >> 15 & 0x11;
    }

    public static void irpAddToRegLong() throws M68kException {
        int n;
        ++XEiJ.mpuCycleCount;
        int n2 = XEiJ.regOC & 0x3F;
        int n3 = XEiJ.regOC >> 9 & 7;
        int n4 = n2 < 16 ? XEiJ.regRn[n2] : (n2 == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n2), XEiJ.regSRS));
        int n5 = XEiJ.regRn[n3];
        XEiJ.regRn[n3] = n = n5 + n4;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? 4 : 0) | ((n5 ^ n) & (n4 ^ n)) >> 30 & 2 | ((n5 | n4) ^ (n5 ^ n4) & n) >> 31 & 0x11;
    }

    public static void irpAddaWord() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        short s = n < 16 ? (short)XEiJ.regRn[n] : (n == 60 ? (short)MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : (short)MC68060.mmuReadWordSignData(MC68060.efaAnyWord(n), XEiJ.regSRS));
        int n2 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n2] = XEiJ.regRn[n2] + s;
    }

    public static void irpAddToMemByte() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                ++XEiJ.mpuCycleCount;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFFFF00 & n3 | 0xFF & n2;
            } else {
                XEiJ.mpuCycleCount += 2;
                m60Incremented -= 1L << (n << 3);
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 1;
                XEiJ.regRn[n6] = n7;
                m60Address = n7;
                int n8 = n7;
                n4 = MC68060.mmuReadByteSignData(n8, XEiJ.regSRS);
                int n9 = XEiJ.regOC >> 9 & 0xF;
                m60Incremented -= 1L << (n9 << 3);
                int n10 = n9;
                int n11 = XEiJ.regRn[n10] - 1;
                XEiJ.regRn[n10] = n11;
                m60Address = n11;
                n8 = n11;
                n3 = MC68060.mmuModifyByteSignData(n8, XEiJ.regSRS);
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                MC68060.mmuWriteByteData(n8, n2, XEiJ.regSRS);
            }
            XEiJ.regCCR = n2 >> 4 & 8 | (0xFF & n2) - 1 >> 6 & XEiJ.regCCR & 4 | ((n3 ^ n2) & (n4 ^ n2)) >> 6 & 2 | (byte)((n3 | n4) ^ (n3 ^ n4) & n2) >> 7 & 0x11;
        } else {
            ++XEiJ.mpuCycleCount;
            int n12 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n13 = MC68060.efaMltByte(n);
            byte by = MC68060.mmuModifyByteSignData(n13, XEiJ.regSRS);
            int n14 = by + n12;
            MC68060.mmuWriteByteData(n13, n14, XEiJ.regSRS);
            XEiJ.regCCR = XEiJ.MPU_TSTB_TABLE[0xFF & n14] | ((by ^ n14) & (n12 ^ n14)) >> 6 & 2 | (byte)((by | n12) ^ (by ^ n12) & n14) >> 7 & 0x11;
        }
    }

    public static void irpAddToMemWord() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                ++XEiJ.mpuCycleCount;
                n4 = XEiJ.regRn[n];
                n3 = XEiJ.regRn[n5];
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                XEiJ.regRn[n5] = 0xFFFF0000 & n3 | (char)n2;
            } else {
                XEiJ.mpuCycleCount += 2;
                m60Incremented -= 2L << (n << 3);
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 2;
                XEiJ.regRn[n6] = n7;
                m60Address = n7;
                int n8 = n7;
                n4 = MC68060.mmuReadWordSignData(n8, XEiJ.regSRS);
                int n9 = XEiJ.regOC >> 9 & 0xF;
                m60Incremented -= 2L << (n9 << 3);
                int n10 = n9;
                int n11 = XEiJ.regRn[n10] - 2;
                XEiJ.regRn[n10] = n11;
                m60Address = n11;
                n8 = n11;
                n3 = MC68060.mmuModifyWordSignData(n8, XEiJ.regSRS);
                n2 = n3 + n4 + (XEiJ.regCCR >> 4);
                MC68060.mmuWriteWordData(n8, n2, XEiJ.regSRS);
            }
            XEiJ.regCCR = n2 >> 12 & 8 | (char)n2 - '\u0001' >> 14 & XEiJ.regCCR & 4 | ((n3 ^ n2) & (n4 ^ n2)) >> 14 & 2 | (short)((n3 | n4) ^ (n3 ^ n4) & n2) >> 15 & 0x11;
        } else {
            ++XEiJ.mpuCycleCount;
            int n12 = MC68060.efaMltWord(n);
            int n13 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n14 = MC68060.mmuModifyWordSignData(n12, XEiJ.regSRS);
            int n15 = n14 + n13;
            MC68060.mmuWriteWordData(n12, n15, XEiJ.regSRS);
            XEiJ.regCCR = n15 >> 12 & 8 | (char)n15 - '\u0001' >> 14 & 4 | ((n14 ^ n15) & (n13 ^ n15)) >> 14 & 2 | (short)((n14 | n13) ^ (n14 ^ n13) & n15) >> 15 & 0x11;
        }
    }

    public static void irpAddToMemLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        if (n < 16) {
            int n2;
            int n3;
            int n4;
            if (n < 8) {
                int n5 = XEiJ.regOC >> 9 & 7;
                ++XEiJ.mpuCycleCount;
                n4 = XEiJ.regRn[n5];
                n3 = XEiJ.regRn[n];
                XEiJ.regRn[n5] = n2 = n4 + n3 + (XEiJ.regCCR >> 4);
            } else {
                XEiJ.mpuCycleCount += 2;
                m60Incremented -= 4L << (n << 3);
                int n6 = n;
                int n7 = XEiJ.regRn[n6] - 4;
                XEiJ.regRn[n6] = n7;
                m60Address = n7;
                int n8 = n7;
                n3 = MC68060.mmuReadLongData(n8, XEiJ.regSRS);
                int n9 = XEiJ.regOC >> 9 & 0xF;
                m60Incremented -= 4L << (n9 << 3);
                int n10 = n9;
                int n11 = XEiJ.regRn[n10] - 4;
                XEiJ.regRn[n10] = n11;
                m60Address = n11;
                n8 = n11;
                n4 = MC68060.mmuModifyLongData(n8, XEiJ.regSRS);
                n2 = n4 + n3 + (XEiJ.regCCR >> 4);
                MC68060.mmuWriteLongData(n8, n2, XEiJ.regSRS);
            }
            XEiJ.regCCR = n2 >> 28 & 8 | (n2 == 0 ? XEiJ.regCCR & 4 : 0) | ((n4 ^ n2) & (n3 ^ n2)) >>> 31 << 1 | ((n4 | n3) ^ (n4 ^ n3) & n2) >> 31 & 0x11;
        } else {
            ++XEiJ.mpuCycleCount;
            int n12 = MC68060.efaMltLong(n);
            int n13 = MC68060.mmuModifyLongData(n12, XEiJ.regSRS);
            int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7];
            int n15 = n13 + n14;
            MC68060.mmuWriteLongData(n12, n15, XEiJ.regSRS);
            XEiJ.regCCR = n15 >> 28 & 8 | (n15 == 0 ? 4 : 0) | ((n13 ^ n15) & (n14 ^ n15)) >>> 31 << 1 | ((n13 | n14) ^ (n13 ^ n14) & n15) >> 31 & 0x11;
        }
    }

    public static void irpAddaLong() throws M68kException {
        int n = XEiJ.regOC & 0x3F;
        ++XEiJ.mpuCycleCount;
        int n2 = n < 16 ? XEiJ.regRn[n] : (n == 60 ? MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) : MC68060.mmuReadLongData(MC68060.efaAnyLong(n), XEiJ.regSRS));
        int n3 = XEiJ.regOC >> 9 & 0xF;
        XEiJ.regRn[n3] = XEiJ.regRn[n3] + n2;
    }

    public static void irpXxrToRegByte() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        ++XEiJ.mpuCycleCount;
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                int n4 = (byte)n2 >> n3;
                int n5 = n4 >> 1;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & n5;
                XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? 4 : 0) | -(n4 & 1) & 0x11;
                break;
            }
            case 1: {
                int n6 = (XEiJ.regOC >> 9) - 1 & 7;
                int n7 = (0xFF & n2) >>> n6;
                int n8 = n7 >>> 1;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | n8;
                XEiJ.regCCR = (n8 == 0 ? 4 : 0) | -(n7 & 1) & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                int n11 = (XEiJ.regCCR & 0x10) << 3 | (0xFF & n2) >>> 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 >>> n10 - 1;
                    n11 = n2 << 8 - n10 | n9 >>> 1;
                }
                byte by = (byte)n11;
                n11 = by;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | -(n9 & 1) & 0x11;
                break;
            }
            case 3: {
                int n12 = XEiJ.regOC >> 9 & 7;
                byte by = (byte)(n2 << 8 - n12 | (0xFF & n2) >>> n12);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | by >>> 7 & 1;
                break;
            }
            case 4: {
                int n13;
                int n14;
                int n15 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n15 == 0) {
                    n14 = n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = (byte)n2 >> (n15 <= 8 ? n15 - 1 : 7);
                    n14 = n13 >> 1;
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & n14;
                    n13 = -(n13 & 1) & 0x11;
                }
                XEiJ.regCCR = n14 >> 28 & 8 | (n14 == 0 ? 4 : 0) | n13;
                break;
            }
            case 5: {
                int n16 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n16 == 0) {
                    byte by = (byte)n2;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (by < 0 ? 8 : (by == 0 ? 4 : 0));
                    break;
                }
                int n17 = n16 <= 8 ? (0xFF & n2) >>> n16 - 1 : 0;
                int n18 = n17 >>> 1;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | n18;
                XEiJ.regCCR = (n18 == 0 ? 4 : 0) | -(n17 & 1) & 0x11;
                break;
            }
            case 6: {
                int n19;
                int n20;
                int n21 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                n21 = (n21 & 7) - (n21 >> 3);
                n21 += n21 >> 3 & 9;
                if (n21 == 0) {
                    n20 = n2;
                    n19 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n20 = (XEiJ.regCCR & 0x10) << 3 | (0xFF & n2) >>> 1;
                    if (n21 == 1) {
                        n19 = n2;
                    } else {
                        n19 = n20 >>> n21 - 2;
                        n20 = n2 << 9 - n21 | n19 >>> 1;
                    }
                    byte by = (byte)n20;
                    n20 = by;
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n19 = -(n19 & 1) & 0x11;
                }
                XEiJ.regCCR = n20 >> 28 & 8 | (n20 == 0 ? 4 : 0) | n19;
                break;
            }
            default: {
                int n22;
                byte by;
                int n23 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n23 == 0) {
                    by = (byte)n2;
                    n22 = 0;
                } else {
                    by = (byte)(n2 << 8 - (n23 &= 7) | (0xFF & n2) >>> n23);
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n22 = by >>> 7 & 1;
                }
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n22;
            }
        }
    }

    public static void irpXxrToRegWord() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        ++XEiJ.mpuCycleCount;
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                int n4 = (short)n2 >> n3;
                int n5 = n4 >> 1;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)n5;
                XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? 4 : 0) | -(n4 & 1) & 0x11;
                break;
            }
            case 1: {
                int n6 = (XEiJ.regOC >> 9) - 1 & 7;
                int n7 = (char)n2 >>> n6;
                int n8 = n7 >>> 1;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | n8;
                XEiJ.regCCR = (n8 == 0 ? 4 : 0) | -(n7 & 1) & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                int n11 = (XEiJ.regCCR & 0x10) << 11 | (char)n2 >>> 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 >>> n10 - 1;
                    n11 = n2 << 16 - n10 | n9 >>> 1;
                }
                short s = (short)n11;
                n11 = s;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | -(n9 & 1) & 0x11;
                break;
            }
            case 3: {
                int n12 = (XEiJ.regOC >> 9) - 1 & 7;
                short s = (short)(n2 << 15 - n12 | (char)n2 >>> n12 + 1);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | s >>> 15 & 1;
                break;
            }
            case 4: {
                int n13;
                int n14;
                int n15 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n15 == 0) {
                    n14 = n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = (short)n2 >> (n15 <= 16 ? n15 - 1 : 15);
                    n14 = n13 >> 1;
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)n14;
                    n13 = -(n13 & 1) & 0x11;
                }
                XEiJ.regCCR = n14 >> 28 & 8 | (n14 == 0 ? 4 : 0) | n13;
                break;
            }
            case 5: {
                int n16 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n16 == 0) {
                    short s = (short)n2;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : (s == 0 ? 4 : 0));
                    break;
                }
                int n17 = n16 <= 16 ? (char)n2 >>> n16 - 1 : 0;
                int n18 = n17 >>> 1;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | n18;
                XEiJ.regCCR = (n18 == 0 ? 4 : 0) | -(n17 & 1) & 0x11;
                break;
            }
            case 6: {
                int n19;
                int n20;
                int n21 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                n21 = (n21 & 0xF) - (n21 >> 4);
                n21 += n21 >> 4 & 0x11;
                if (n21 == 0) {
                    n20 = n2;
                    n19 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n20 = (XEiJ.regCCR & 0x10) << 11 | (char)n2 >>> 1;
                    if (n21 == 1) {
                        n19 = n2;
                    } else {
                        n19 = n20 >>> n21 - 2;
                        n20 = n2 << 17 - n21 | n19 >>> 1;
                    }
                    short s = (short)n20;
                    n20 = s;
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n19 = -(n19 & 1) & 0x11;
                }
                XEiJ.regCCR = n20 >> 28 & 8 | (n20 == 0 ? 4 : 0) | n19;
                break;
            }
            default: {
                int n22;
                short s;
                int n23 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n23 == 0) {
                    s = (short)n2;
                    n22 = 0;
                } else {
                    s = (short)(n2 << 16 - (n23 &= 0xF) | (char)n2 >>> n23);
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n22 = s >>> 15 & 1;
                }
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n22;
            }
        }
    }

    public static void irpXxrToRegLong() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        ++XEiJ.mpuCycleCount;
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3;
                int n4 = (XEiJ.regOC >> 9) - 1 & 7;
                int n5 = n2 >> n4;
                XEiJ.regRn[n] = n3 = n5 >> 1;
                XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? 4 : 0) | -(n5 & 1) & 0x11;
                break;
            }
            case 1: {
                int n6;
                int n7 = (XEiJ.regOC >> 9) - 1 & 7;
                int n8 = n2 >>> n7;
                XEiJ.regRn[n] = n6 = n8 >>> 1;
                XEiJ.regCCR = (n6 == 0 ? 4 : 0) | -(n8 & 1) & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                int n11 = (XEiJ.regCCR & 0x10) << 27 | n2 >>> 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 >>> n10 - 1;
                    n11 = n2 << -n10 | n9 >>> 1;
                }
                XEiJ.regRn[n] = n11;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | -(n9 & 1) & 0x11;
                break;
            }
            case 3: {
                int n12;
                int n13 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.regRn[n] = n12 = n2 << ~n13 | n2 >>> n13 + 1;
                XEiJ.regCCR = n12 >> 28 & 8 | (n12 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n12 >>> 31;
                break;
            }
            case 4: {
                int n14;
                int n15;
                int n16 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n16 == 0) {
                    n15 = n2;
                    n14 = XEiJ.regCCR & 0x10;
                } else {
                    n14 = n2 >> (n16 <= 32 ? n16 - 1 : 31);
                    XEiJ.regRn[n] = n15 = n14 >> 1;
                    n14 = -(n14 & 1) & 0x11;
                }
                XEiJ.regCCR = n15 >> 28 & 8 | (n15 == 0 ? 4 : 0) | n14;
                break;
            }
            case 5: {
                int n17;
                int n18 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n18 == 0) {
                    int n19 = n2;
                    XEiJ.regCCR = XEiJ.regCCR & 0x10 | (n19 < 0 ? 8 : (n19 == 0 ? 4 : 0));
                    break;
                }
                int n20 = n18 <= 32 ? n2 >>> n18 - 1 : 0;
                XEiJ.regRn[n] = n17 = n20 >>> 1;
                XEiJ.regCCR = (n17 == 0 ? 4 : 0) | -(n20 & 1) & 0x11;
                break;
            }
            case 6: {
                int n21;
                int n22;
                int n23 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                n23 -= 32 - n23 >> 6 & 0x21;
                if (n23 == 0) {
                    n22 = n2;
                    n21 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n22 = (XEiJ.regCCR & 0x10) << 27 | n2 >>> 1;
                    if (n23 == 1) {
                        n21 = n2;
                    } else {
                        n21 = n22 >>> n23 - 2;
                        n22 = n2 << 33 - n23 | n21 >>> 1;
                    }
                    XEiJ.regRn[n] = n22;
                    n21 = -(n21 & 1) & 0x11;
                }
                XEiJ.regCCR = n22 >> 28 & 8 | (n22 == 0 ? 4 : 0) | n21;
                break;
            }
            default: {
                int n24;
                int n25;
                int n26 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n26 == 0) {
                    n25 = n2;
                    n24 = 0;
                } else {
                    XEiJ.regRn[n] = n25 = n2 << -(n26 &= 0x1F) | n2 >>> n26;
                    n24 = n25 >>> 31;
                }
                XEiJ.regCCR = n25 >> 28 & 8 | (n25 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n24;
            }
        }
    }

    public static void irpAsrToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordSignData(n2, XEiJ.regSRS);
        int n4 = n3 >> 1;
        MC68060.mmuWriteWordData(n2, n4, XEiJ.regSRS);
        XEiJ.regCCR = (n4 < 0 ? 8 : 0) | (n4 == 0 ? 4 : 0) | -(n3 & 1) & 0x11;
    }

    public static void irpXxlToRegByte() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        ++XEiJ.mpuCycleCount;
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                int n4 = n2 << n3;
                byte by = (byte)(n4 << 1);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (by >> n3 + 1 != (byte)n2 ? 2 : 0) | (byte)n4 >> 7 & 0x11;
                break;
            }
            case 1: {
                int n5 = (XEiJ.regOC >> 9) - 1 & 7;
                int n6 = n2 << n5;
                byte by = (byte)(n6 << 1);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | (byte)n6 >> 7 & 0x11;
                break;
            }
            case 2: {
                int n7;
                int n8 = (XEiJ.regOC >> 9) - 1 & 7;
                int n9 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                if (n8 == 0) {
                    n7 = n2;
                } else {
                    n7 = n9 << n8 - 1;
                    n9 = n7 << 1 | (0xFF & n2) >>> 8 - n8;
                }
                byte by = (byte)n9;
                n9 = by;
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = n9 >> 28 & 8 | (n9 == 0 ? 4 : 0) | (byte)n7 >> 7 & 0x11;
                break;
            }
            case 3: {
                int n10 = XEiJ.regOC >> 9 & 7;
                byte by = (byte)(n2 << n10 | (0xFF & n2) >>> 8 - n10);
                XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | by & 1;
                break;
            }
            case 4: {
                int n11 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n11 <= 7) {
                    int n12;
                    byte by;
                    if (n11 == 0) {
                        by = (byte)n2;
                        n12 = XEiJ.regCCR & 0x10;
                    } else {
                        n12 = n2 << n11 - 1;
                        by = (byte)(n12 << 1);
                        XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                        n12 = (by >> n11 != (byte)n2 ? 2 : 0) | (byte)n12 >> 7 & 0x11;
                    }
                    XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | n12;
                    break;
                }
                XEiJ.regRn[n] = 0xFFFFFF00 & n2;
                XEiJ.regCCR = 4 | ((byte)n2 != 0 ? 2 : 0) | (n11 == 8 ? -(n2 & 1) & 0x11 : 0);
                break;
            }
            case 5: {
                int n13;
                byte by;
                int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n14 == 0) {
                    by = (byte)n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = n14 <= 8 ? n2 << n14 - 1 : 0;
                    by = (byte)(n13 << 1);
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n13 = (byte)n13 >> 7 & 0x11;
                }
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? 4 : 0) | n13;
                break;
            }
            case 6: {
                int n15;
                int n16;
                int n17 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                n17 = (n17 & 7) - (n17 >> 3);
                n17 += n17 >> 3 & 9;
                if (n17 == 0) {
                    n16 = n2;
                    n15 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n16 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                    if (n17 == 1) {
                        n15 = n2;
                    } else {
                        n15 = n16 << n17 - 2;
                        n16 = n15 << 1 | (0xFF & n2) >>> 9 - n17;
                    }
                    byte by = (byte)n16;
                    n16 = by;
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n15 = (byte)n15 >> 7 & 0x11;
                }
                XEiJ.regCCR = n16 >> 28 & 8 | (n16 == 0 ? 4 : 0) | n15;
                break;
            }
            default: {
                int n18;
                byte by;
                int n19 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n19 == 0) {
                    by = (byte)n2;
                    n18 = 0;
                } else {
                    by = (byte)(n2 << (n19 &= 7) | (0xFF & n2) >>> 8 - n19);
                    XEiJ.regRn[n] = 0xFFFFFF00 & n2 | 0xFF & by;
                    n18 = by & 1;
                }
                XEiJ.regCCR = by >> 28 & 8 | (by == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n18;
            }
        }
    }

    public static void irpXxlToRegWord() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        ++XEiJ.mpuCycleCount;
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3 = (XEiJ.regOC >> 9) - 1 & 7;
                int n4 = n2 << n3;
                short s = (short)(n4 << 1);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (s >> n3 + 1 != (short)n2 ? 2 : 0) | (short)n4 >> 15 & 0x11;
                break;
            }
            case 1: {
                int n5 = (XEiJ.regOC >> 9) - 1 & 7;
                int n6 = n2 << n5;
                short s = (short)(n6 << 1);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | (short)n6 >> 15 & 0x11;
                break;
            }
            case 2: {
                int n7;
                int n8 = (XEiJ.regOC >> 9) - 1 & 7;
                int n9 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                if (n8 == 0) {
                    n7 = n2;
                } else {
                    n7 = n9 << n8 - 1;
                    n9 = n7 << 1 | (char)n2 >>> 16 - n8;
                }
                short s = (short)n9;
                n9 = s;
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = n9 >> 28 & 8 | (n9 == 0 ? 4 : 0) | (short)n7 >> 15 & 0x11;
                break;
            }
            case 3: {
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                short s = (short)(n2 << n10 + 1 | (char)n2 >>> 15 - n10);
                XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | s & 1;
                break;
            }
            case 4: {
                int n11 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n11 <= 15) {
                    int n12;
                    short s;
                    if (n11 == 0) {
                        s = (short)n2;
                        n12 = XEiJ.regCCR & 0x10;
                    } else {
                        n12 = n2 << n11 - 1;
                        s = (short)(n12 << 1);
                        XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                        n12 = (s >> n11 != (short)n2 ? 2 : 0) | (short)n12 >> 15 & 0x11;
                    }
                    XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | n12;
                    break;
                }
                XEiJ.regRn[n] = 0xFFFF0000 & n2;
                XEiJ.regCCR = 4 | ((short)n2 != 0 ? 2 : 0) | (n11 == 16 ? -(n2 & 1) & 0x11 : 0);
                break;
            }
            case 5: {
                int n13;
                short s;
                int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n14 == 0) {
                    s = (short)n2;
                    n13 = XEiJ.regCCR & 0x10;
                } else {
                    n13 = n14 <= 16 ? n2 << n14 - 1 : 0;
                    s = (short)(n13 << 1);
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n13 = (short)n13 >> 15 & 0x11;
                }
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? 4 : 0) | n13;
                break;
            }
            case 6: {
                int n15;
                int n16;
                int n17 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                n17 = (n17 & 0xF) - (n17 >> 4);
                n17 += n17 >> 4 & 0x11;
                if (n17 == 0) {
                    n16 = n2;
                    n15 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n16 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                    if (n17 == 1) {
                        n15 = n2;
                    } else {
                        n15 = n16 << n17 - 2;
                        n16 = n15 << 1 | (char)n2 >>> 17 - n17;
                    }
                    short s = (short)n16;
                    n16 = s;
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n15 = (short)n15 >> 15 & 0x11;
                }
                XEiJ.regCCR = n16 >> 28 & 8 | (n16 == 0 ? 4 : 0) | n15;
                break;
            }
            default: {
                int n18;
                short s;
                int n19 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n19 == 0) {
                    s = (short)n2;
                    n18 = 0;
                } else {
                    s = (short)(n2 << (n19 &= 0xF) | (char)n2 >>> 16 - n19);
                    XEiJ.regRn[n] = 0xFFFF0000 & n2 | (char)s;
                    n18 = s & 1;
                }
                XEiJ.regCCR = s >> 28 & 8 | (s == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n18;
            }
        }
    }

    public static void irpXxlToRegLong() throws M68kException {
        int n = XEiJ.regOC & 7;
        int n2 = XEiJ.regRn[n];
        ++XEiJ.mpuCycleCount;
        switch (XEiJ.regOC >> 3 & 7) {
            case 0: {
                int n3;
                int n4 = (XEiJ.regOC >> 9) - 1 & 7;
                int n5 = n2 << n4;
                XEiJ.regRn[n] = n3 = n5 << 1;
                XEiJ.regCCR = n3 >> 28 & 8 | (n3 == 0 ? 4 : 0) | (n3 >> n4 + 1 != n2 ? 2 : 0) | n5 >> 31 & 0x11;
                break;
            }
            case 1: {
                int n6;
                int n7 = (XEiJ.regOC >> 9) - 1 & 7;
                int n8 = n2 << n7;
                XEiJ.regRn[n] = n6 = n8 << 1;
                XEiJ.regCCR = n6 >> 28 & 8 | (n6 == 0 ? 4 : 0) | n8 >> 31 & 0x11;
                break;
            }
            case 2: {
                int n9;
                int n10 = (XEiJ.regOC >> 9) - 1 & 7;
                int n11 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                if (n10 == 0) {
                    n9 = n2;
                } else {
                    n9 = n11 << n10 - 1;
                    n11 = n9 << 1 | n2 >>> -n10;
                }
                XEiJ.regRn[n] = n11;
                XEiJ.regCCR = n11 >> 28 & 8 | (n11 == 0 ? 4 : 0) | n9 >> 31 & 0x11;
                break;
            }
            case 3: {
                int n12;
                int n13 = (XEiJ.regOC >> 9) - 1 & 7;
                XEiJ.regRn[n] = n12 = n2 << n13 + 1 | n2 >>> ~n13;
                XEiJ.regCCR = n12 >> 28 & 8 | (n12 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n12 & 1;
                break;
            }
            case 4: {
                int n14 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n14 <= 31) {
                    int n15;
                    int n16;
                    if (n14 == 0) {
                        n16 = n2;
                        n15 = XEiJ.regCCR & 0x10;
                    } else {
                        n15 = n2 << n14 - 1;
                        XEiJ.regRn[n] = n16 = n15 << 1;
                        n15 = (n16 >> n14 != n2 ? 2 : 0) | n15 >> 31 & 0x11;
                    }
                    XEiJ.regCCR = n16 >> 28 & 8 | (n16 == 0 ? 4 : 0) | n15;
                    break;
                }
                XEiJ.regRn[n] = 0;
                XEiJ.regCCR = 4 | (n2 != 0 ? 2 : 0) | (n14 == 32 ? -(n2 & 1) & 0x11 : 0);
                break;
            }
            case 5: {
                int n17;
                int n18;
                int n19 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n19 == 0) {
                    n18 = n2;
                    n17 = XEiJ.regCCR & 0x10;
                } else {
                    n17 = n19 <= 32 ? n2 << n19 - 1 : 0;
                    XEiJ.regRn[n] = n18 = n17 << 1;
                    n17 = n17 >> 31 & 0x11;
                }
                XEiJ.regCCR = n18 >> 28 & 8 | (n18 == 0 ? 4 : 0) | n17;
                break;
            }
            case 6: {
                int n20;
                int n21;
                int n22 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                n22 -= 32 - n22 >> 6 & 0x21;
                if (n22 == 0) {
                    n21 = n2;
                    n20 = -(XEiJ.regCCR >> 4 & 1) & 0x11;
                } else {
                    n21 = n2 << 1 | XEiJ.regCCR >> 4 & 1;
                    if (n22 == 1) {
                        n20 = n2;
                    } else {
                        n20 = n21 << n22 - 2;
                        n21 = n20 << 1 | n2 >>> 33 - n22;
                    }
                    XEiJ.regRn[n] = n21;
                    n20 = n20 >> 31 & 0x11;
                }
                XEiJ.regCCR = n21 >> 28 & 8 | (n21 == 0 ? 4 : 0) | n20;
                break;
            }
            default: {
                int n23;
                int n24;
                int n25 = XEiJ.regRn[XEiJ.regOC >> 9 & 7] & 0x3F;
                if (n25 == 0) {
                    n24 = n2;
                    n23 = 0;
                } else {
                    XEiJ.regRn[n] = n24 = n2 << n25 | n2 >>> -n25;
                    n23 = n24 & 1;
                }
                XEiJ.regCCR = n24 >> 28 & 8 | (n24 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10) | n23;
            }
        }
    }

    public static void irpAslToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordSignData(n2, XEiJ.regSRS);
        short s = (short)(n3 << 1);
        MC68060.mmuWriteWordData(n2, s, XEiJ.regSRS);
        XEiJ.regCCR = (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | (n3 ^ s) >>> 31 << 1 | n3 >> 15 & 0x11;
    }

    public static void irpLsrToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordZeroData(n2, XEiJ.regSRS);
        int n4 = n3 >>> 1;
        MC68060.mmuWriteWordData(n2, n4, XEiJ.regSRS);
        XEiJ.regCCR = (n4 == 0 ? 4 : 0) | -(n3 & 1) & 0x11;
    }

    public static void irpLslToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordSignData(n2, XEiJ.regSRS);
        short s = (short)(n3 << 1);
        MC68060.mmuWriteWordData(n2, s, XEiJ.regSRS);
        XEiJ.regCCR = (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | n3 >> 15 & 0x11;
    }

    public static void irpRoxrToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordZeroData(n2, XEiJ.regSRS);
        int n4 = -(XEiJ.regCCR & 0x10) << 11 | n3 >>> 1;
        MC68060.mmuWriteWordData(n2, n4, XEiJ.regSRS);
        XEiJ.regCCR = (n4 < 0 ? 8 : 0) | (n4 == 0 ? 4 : 0) | -(n3 & 1) & 0x11;
    }

    public static void irpRoxlToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordSignData(n2, XEiJ.regSRS);
        short s = (short)(n3 << 1 | XEiJ.regCCR >> 4 & 1);
        MC68060.mmuWriteWordData(n2, s, XEiJ.regSRS);
        XEiJ.regCCR = (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | n3 >> 15 & 0x11;
    }

    public static void irpRorToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordZeroData(n2, XEiJ.regSRS);
        short s = (short)(n3 << 15 | n3 >>> 1);
        MC68060.mmuWriteWordData(n2, s, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | s >>> 31;
    }

    public static void irpRolToMem() throws M68kException {
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regOC & 0x3F;
        int n2 = MC68060.efaMltWord(n);
        int n3 = MC68060.mmuModifyWordZeroData(n2, XEiJ.regSRS);
        short s = (short)(n3 << 1 | n3 >>> 15);
        MC68060.mmuWriteWordData(n2, s, XEiJ.regSRS);
        XEiJ.regCCR = XEiJ.regCCR & 0x10 | (s < 0 ? 8 : 0) | (s == 0 ? 4 : 0) | s & 1;
    }

    public static void irpBftst() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 6;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
        } else {
            int n5;
            int n6 = MC68060.efaCntLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                m60Address = n6;
                n5 = MC68060.mmuReadByteSignData(m60Address, XEiJ.regSRS) << 24 + n3;
            } else if (n == 1) {
                m60Address = n6;
                n5 = MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 16 + n3;
            } else if (n == 2) {
                m60Address = n6;
                n5 = (MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 8 | MC68060.mmuReadByteZeroData(n6 + 2, XEiJ.regSRS)) << 8 + n3;
            } else if (n == 3) {
                m60Address = n6;
                n5 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) << n3;
            } else {
                int n7 = n6;
                m60Address = n7;
                m60Address = n6 + 4;
                n5 = MC68060.mmuReadLongData(n7, XEiJ.regSRS) << n3 | MC68060.mmuReadByteZeroData(m60Address, XEiJ.regSRS) >>> 8 - n3;
            }
            n = n5;
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfextu() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & Short.MIN_VALUE) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 6;
        int n5 = XEiJ.regOC & 0x3F;
        if (n5 < 8) {
            n = XEiJ.regRn[n5];
            n = n << n4 | n >>> -n4;
        } else {
            int n6;
            int n7 = MC68060.efaCntLong(n5) + (n4 >> 3);
            n = 31 - n2 + (n4 &= 7) >> 3;
            if (n == 0) {
                m60Address = n7;
                n6 = MC68060.mmuReadByteSignData(m60Address, XEiJ.regSRS) << 24 + n4;
            } else if (n == 1) {
                m60Address = n7;
                n6 = MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 16 + n4;
            } else if (n == 2) {
                m60Address = n7;
                n6 = (MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 8 | MC68060.mmuReadByteZeroData(n7 + 2, XEiJ.regSRS)) << 8 + n4;
            } else if (n == 3) {
                m60Address = n7;
                n6 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) << n4;
            } else {
                int n8 = n7;
                m60Address = n8;
                m60Address = n7 + 4;
                n6 = MC68060.mmuReadLongData(n8, XEiJ.regSRS) << n4 | MC68060.mmuReadByteZeroData(m60Address, XEiJ.regSRS) >>> 8 - n4;
            }
            n = n6;
        }
        XEiJ.regRn[n3] = n >>> n2;
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfchg() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 8;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
            int n5 = n ^ -1 << n2;
            XEiJ.regRn[n4] = n5 << -n3 | n5 >>> n3;
        } else {
            int n6 = MC68060.efaCltLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                int n7 = MC68060.mmuModifyByteSignData(n6, XEiJ.regSRS) << 24;
                n = n7 << n3;
                MC68060.mmuWriteByteData(n6, (n7 ^ -1 << n2 >>> n3) >>> 24, XEiJ.regSRS);
            } else if (n == 1) {
                int n8 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS) << 16;
                n = n8 << n3;
                MC68060.mmuWriteWordData(n6, (n8 ^ -1 << n2 >>> n3) >>> 16, XEiJ.regSRS);
            } else if (n == 2) {
                int n9 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS) << 16 | MC68060.mmuModifyByteZeroData(n6 + 2, XEiJ.regSRS) << 8;
                n = n9 << n3;
                MC68060.mmuWriteWordData(n6, (n9 ^= -1 << n2 >>> n3) >>> 16, XEiJ.regSRS);
                MC68060.mmuWriteByteData(n6 + 2, n9 >>> 8, XEiJ.regSRS);
            } else if (n == 3) {
                int n10 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n = n10 << n3;
                MC68060.mmuWriteLongData(n6, n10 ^ -1 << n2 >>> n3, XEiJ.regSRS);
            } else {
                int n11 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n = n11 << n3;
                MC68060.mmuWriteLongData(n6, n11 ^ -1 >>> n3, XEiJ.regSRS);
                n11 = MC68060.mmuModifyByteZeroData(n6 + 4, XEiJ.regSRS);
                n |= n11 >>> 8 - n3;
                MC68060.mmuWriteByteData(n6 + 4, n11 ^ -1 << 8 - n3 + n2, XEiJ.regSRS);
            }
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfexts() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & Short.MIN_VALUE) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 6;
        int n5 = XEiJ.regOC & 0x3F;
        if (n5 < 8) {
            n = XEiJ.regRn[n5];
            n = n << n4 | n >>> -n4;
        } else {
            int n6;
            int n7 = MC68060.efaCntLong(n5) + (n4 >> 3);
            n = 31 - n2 + (n4 &= 7) >> 3;
            if (n == 0) {
                m60Address = n7;
                n6 = MC68060.mmuReadByteSignData(m60Address, XEiJ.regSRS) << 24 + n4;
            } else if (n == 1) {
                m60Address = n7;
                n6 = MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 16 + n4;
            } else if (n == 2) {
                m60Address = n7;
                n6 = (MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 8 | MC68060.mmuReadByteZeroData(n7 + 2, XEiJ.regSRS)) << 8 + n4;
            } else if (n == 3) {
                m60Address = n7;
                n6 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) << n4;
            } else {
                int n8 = n7;
                m60Address = n8;
                m60Address = n7 + 4;
                n6 = MC68060.mmuReadLongData(n8, XEiJ.regSRS) << n4 | MC68060.mmuReadByteZeroData(m60Address, XEiJ.regSRS) >>> 8 - n4;
            }
            n = n6;
        }
        XEiJ.regRn[n3] = n >>= n2;
        XEiJ.regCCR = n >> 28 & 8 | (n == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfclr() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 8;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
            int n5 = n & ~(-1 << n2);
            XEiJ.regRn[n4] = n5 << -n3 | n5 >>> n3;
        } else {
            int n6 = MC68060.efaCltLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                int n7 = MC68060.mmuModifyByteSignData(n6, XEiJ.regSRS) << 24;
                n = n7 << n3;
                MC68060.mmuWriteByteData(n6, (n7 & ~(-1 << n2 >>> n3)) >>> 24, XEiJ.regSRS);
            } else if (n == 1) {
                int n8 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS) << 16;
                n = n8 << n3;
                MC68060.mmuWriteWordData(n6, (n8 & ~(-1 << n2 >>> n3)) >>> 16, XEiJ.regSRS);
            } else if (n == 2) {
                int n9 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS) << 16 | MC68060.mmuModifyByteZeroData(n6 + 2, XEiJ.regSRS) << 8;
                n = n9 << n3;
                MC68060.mmuWriteWordData(n6, (n9 &= ~(-1 << n2 >>> n3)) >>> 16, XEiJ.regSRS);
                MC68060.mmuWriteByteData(n6 + 2, n9 >>> 8, XEiJ.regSRS);
            } else if (n == 3) {
                int n10 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n = n10 << n3;
                MC68060.mmuWriteLongData(n6, n10 & ~(-1 << n2 >>> n3), XEiJ.regSRS);
            } else {
                int n11 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n = n11 << n3;
                MC68060.mmuWriteLongData(n6, n11 & ~(-1 >>> n3), XEiJ.regSRS);
                n11 = MC68060.mmuModifyByteZeroData(n6 + 4, XEiJ.regSRS);
                n |= n11 >>> 8 - n3;
                MC68060.mmuWriteByteData(n6 + 4, n11 & ~(-1 << 8 - n3 + n2), XEiJ.regSRS);
            }
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfffo() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & Short.MIN_VALUE) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 >> 12;
        int n4 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 9;
        int n5 = XEiJ.regOC & 0x3F;
        if (n5 < 8) {
            n = XEiJ.regRn[n5];
            n = n << n4 | n >>> -n4;
        } else {
            int n6;
            int n7 = MC68060.efaCntLong(n5) + (n4 >> 3);
            int n8 = n4 & 7;
            n = 31 - n2 + n8 >> 3;
            if (n == 0) {
                m60Address = n7;
                n6 = MC68060.mmuReadByteSignData(m60Address, XEiJ.regSRS) << 24 + n8;
            } else if (n == 1) {
                m60Address = n7;
                n6 = MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 16 + n8;
            } else if (n == 2) {
                m60Address = n7;
                n6 = (MC68060.mmuReadWordSignData(m60Address, XEiJ.regSRS) << 8 | MC68060.mmuReadByteZeroData(n7 + 2, XEiJ.regSRS)) << 8 + n8;
            } else if (n == 3) {
                m60Address = n7;
                n6 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) << n8;
            } else {
                int n9 = n7;
                m60Address = n9;
                m60Address = n7 + 4;
                n6 = MC68060.mmuReadLongData(n9, XEiJ.regSRS) << n8 | MC68060.mmuReadByteZeroData(m60Address, XEiJ.regSRS) >>> 8 - n8;
            }
            n = n6;
        }
        XEiJ.regRn[n3] = Integer.numberOfLeadingZeros(n >>> n2) - n2 + n4;
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfset() throws M68kException {
        int n;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0xFFFFF000) != 0 || (n2 & 0xFC0) > 2496 || (n2 & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n3 = n2 << 20 >= 0 ? n2 >> 6 & 0x1F : XEiJ.regRn[n2 >> 6 & 7];
        n2 = -(n2 << 26 >= 0 ? n2 : XEiJ.regRn[n2 & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 8;
        int n4 = XEiJ.regOC & 0x3F;
        if (n4 < 8) {
            n = XEiJ.regRn[n4];
            n = n << n3 | n >>> -n3;
            int n5 = n | -1 << n2;
            XEiJ.regRn[n4] = n5 << -n3 | n5 >>> n3;
        } else {
            int n6 = MC68060.efaCltLong(n4) + (n3 >> 3);
            n = 31 - n2 + (n3 &= 7) >> 3;
            if (n == 0) {
                int n7 = MC68060.mmuModifyByteSignData(n6, XEiJ.regSRS) << 24;
                n = n7 << n3;
                MC68060.mmuWriteByteData(n6, (n7 | -1 << n2 >>> n3) >>> 24, XEiJ.regSRS);
            } else if (n == 1) {
                int n8 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS) << 16;
                n = n8 << n3;
                MC68060.mmuWriteWordData(n6, (n8 | -1 << n2 >>> n3) >>> 16, XEiJ.regSRS);
            } else if (n == 2) {
                int n9 = MC68060.mmuModifyWordSignData(n6, XEiJ.regSRS) << 16 | MC68060.mmuModifyByteZeroData(n6 + 2, XEiJ.regSRS) << 8;
                n = n9 << n3;
                MC68060.mmuWriteWordData(n6, (n9 |= -1 << n2 >>> n3) >>> 16, XEiJ.regSRS);
                MC68060.mmuWriteByteData(n6 + 2, n9 >>> 8, XEiJ.regSRS);
            } else if (n == 3) {
                int n10 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n = n10 << n3;
                MC68060.mmuWriteLongData(n6, n10 | -1 << n2 >>> n3, XEiJ.regSRS);
            } else {
                int n11 = MC68060.mmuModifyLongData(n6, XEiJ.regSRS);
                n = n11 << n3;
                MC68060.mmuWriteLongData(n6, n11 | -1 >>> n3, XEiJ.regSRS);
                n11 = MC68060.mmuModifyByteZeroData(n6 + 4, XEiJ.regSRS);
                n |= n11 >>> 8 - n3;
                MC68060.mmuWriteByteData(n6 + 4, n11 | -1 << 8 - n3 + n2, XEiJ.regSRS);
            }
        }
        XEiJ.regCCR = n >> 28 & 8 | ((n >>= n2) == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpBfins() throws M68kException {
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n & Short.MIN_VALUE) != 0 || (n & 0xFC0) > 2496 || (n & 0x3F) > 39) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n2 = n >> 12;
        int n3 = n << 20 >= 0 ? n >> 6 & 0x1F : XEiJ.regRn[n >> 6 & 7];
        n = -(n << 26 >= 0 ? n : XEiJ.regRn[n & 7]) & 0x1F;
        XEiJ.mpuCycleCount += 6;
        int n4 = XEiJ.regOC & 0x3F;
        int n5 = XEiJ.regRn[n2] << n;
        if (n4 < 8) {
            int n6 = XEiJ.regRn[n4];
            n6 = (n6 << n3 | n6 >>> -n3) & ~(-1 << n) | n5;
            XEiJ.regRn[n4] = n6 << -n3 | n6 >>> n3;
        } else {
            int n7 = MC68060.efaCltLong(n4) + (n3 >> 3);
            n2 = 31 - n + (n3 &= 7) >> 3;
            if (n2 == 0) {
                MC68060.mmuWriteByteData(n7, (MC68060.mmuModifyByteSignData(n7, XEiJ.regSRS) << 24 & ~(-1 << n >>> n3) | n5 >>> n3) >>> 24, XEiJ.regSRS);
            } else if (n2 == 1) {
                MC68060.mmuWriteWordData(n7, (MC68060.mmuModifyWordSignData(n7, XEiJ.regSRS) << 16 & ~(-1 << n >>> n3) | n5 >>> n3) >>> 16, XEiJ.regSRS);
            } else if (n2 == 2) {
                int n8 = (MC68060.mmuModifyWordSignData(n7, XEiJ.regSRS) << 16 | MC68060.mmuModifyByteZeroData(n7 + 2, XEiJ.regSRS) << 8) & ~(-1 << n >>> n3) | n5 >>> n3;
                MC68060.mmuWriteWordData(n7, n8 >>> 16, XEiJ.regSRS);
                MC68060.mmuWriteByteData(n7 + 2, n8 >>> 8, XEiJ.regSRS);
            } else if (n2 == 3) {
                MC68060.mmuWriteLongData(n7, MC68060.mmuModifyLongData(n7, XEiJ.regSRS) & ~(-1 << n >>> n3) | n5 >>> n3, XEiJ.regSRS);
            } else {
                MC68060.mmuWriteLongData(n7, MC68060.mmuModifyLongData(n7, XEiJ.regSRS) & ~(-1 >>> n3) | n5 >>> n3, XEiJ.regSRS);
                MC68060.mmuWriteByteData(n7 + 4, MC68060.mmuModifyByteZeroData(n7 + 4, XEiJ.regSRS) & ~(-1 << 8 - n3 + n) | n5 << 8 - n3, XEiJ.regSRS);
            }
        }
        XEiJ.regCCR = n5 >> 28 & 8 | (n5 == 0 ? XEiJ.regCCR & 0x10 | 4 : XEiJ.regCCR & 0x10);
    }

    public static void irpFgen() throws M68kException {
        if ((7 & XEiJ.currentOnchipFPU) == 0) {
            MC68060.irpFline();
        } else {
            ++XEiJ.mpuCycleCount;
            int n = XEiJ.regOC & 0x3F;
            int n2 = XEiJ.regPC;
            XEiJ.regPC = n2 + 2;
            int n3 = MC68060.mmuReadWordZeroExword(n2, XEiJ.regSRS);
            int n4 = n3 >> 10 & 7;
            int n5 = n3 >> 7 & 7;
            int n6 = n3 & 0x7F;
            XEiJ.fpuBox.epbSetRoundingPrec(XEiJ.fpuBox.epbFpcr >> 6 & 3);
            XEiJ.fpuBox.epbSetRoundingMode(XEiJ.fpuBox.epbFpcr >> 4 & 3);
            n2 = 0;
            block0 : switch (n3 >> 13) {
                case 2: {
                    XEiJ.fpuBox.epbFpsr &= 0xFF00FF;
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    switch (n4) {
                        case 0: {
                            int n7;
                            XEiJ.mpuCycleCount += 3;
                            if (n < 8) {
                                XEiJ.mpuCycleCount += 2;
                                n7 = XEiJ.regRn[n];
                            } else if (n == 60) {
                                n2 = XEiJ.regPC;
                                XEiJ.regPC = n2 + 4;
                                n7 = MC68060.mmuReadLongExword(n2, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaAnyLong(n);
                                n7 = MC68060.mmuReadLongData(n2, XEiJ.regSRS);
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].seti(n7);
                            break;
                        }
                        case 1: {
                            int n8;
                            if (n < 8) {
                                XEiJ.mpuCycleCount += 2;
                                n8 = XEiJ.regRn[n];
                            } else if (n == 60) {
                                n2 = XEiJ.regPC;
                                XEiJ.regPC = n2 + 4;
                                n8 = MC68060.mmuReadLongExword(n2, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaAnyLong(n);
                                n8 = MC68060.mmuReadLongData(n2, XEiJ.regSRS);
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].setf0(n8);
                            break;
                        }
                        case 2: {
                            int[] nArray = new int[3];
                            if (n == 60) {
                                if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                    MC68060.irpExceptionFormat0(240, XEiJ.regPC0);
                                    break block0;
                                }
                                n2 = (XEiJ.regPC += 12) - 12;
                                nArray[0] = MC68060.mmuReadLongExword(n2, XEiJ.regSRS);
                                nArray[1] = MC68060.mmuReadLongExword(n2 + 4, XEiJ.regSRS);
                                nArray[2] = MC68060.mmuReadLongExword(n2 + 8, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaMemExtd(n);
                                if ((n & 0x38) == 32) {
                                    m60Address = n2 + 8;
                                    nArray[2] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2 + 4;
                                    nArray[1] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2;
                                    nArray[0] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                } else {
                                    m60Address = n2;
                                    nArray[0] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2 + 4;
                                    nArray[1] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2 + 8;
                                    nArray[2] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                }
                            }
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                n4 = 8;
                                XEiJ.fpuFPn[8].sety012(nArray, 0);
                                break;
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].setx012(nArray, 0);
                            break;
                        }
                        case 3: {
                            int[] nArray = new int[3];
                            if (n == 60) {
                                if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                    MC68060.irpExceptionFormat0(240, XEiJ.regPC0);
                                    break block0;
                                }
                                n2 = (XEiJ.regPC += 12) - 12;
                                nArray[0] = MC68060.mmuReadLongExword(n2, XEiJ.regSRS);
                                nArray[1] = MC68060.mmuReadLongExword(n2 + 4, XEiJ.regSRS);
                                nArray[2] = MC68060.mmuReadLongExword(n2 + 8, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaMemExtd(n);
                                if ((n & 0x38) == 32) {
                                    m60Address = n2 + 8;
                                    nArray[2] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2 + 4;
                                    nArray[1] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2;
                                    nArray[0] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                } else {
                                    m60Address = n2;
                                    nArray[0] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2 + 4;
                                    nArray[1] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                    m60Address = n2 + 8;
                                    nArray[2] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                                }
                            }
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.fpuBox.epbExceptionStatusWord = 57351;
                                MC68060.irpExceptionFormat2(220, XEiJ.regPC, n2);
                                break block0;
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].setp012(nArray, 0);
                            break;
                        }
                        case 4: {
                            int n9;
                            XEiJ.mpuCycleCount += 3;
                            if (n < 8) {
                                XEiJ.mpuCycleCount += 2;
                                n9 = XEiJ.regRn[n];
                            } else if (n == 60) {
                                n2 = XEiJ.regPC;
                                XEiJ.regPC = n2 + 2;
                                n9 = MC68060.mmuReadWordSignExword(n2, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaAnyWord(n);
                                n9 = MC68060.mmuReadWordSignData(n2, XEiJ.regSRS);
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].seti(n9);
                            break;
                        }
                        case 5: {
                            long l;
                            if (n == 60) {
                                n2 = XEiJ.regPC;
                                XEiJ.regPC = n2 + 8;
                                l = MC68060.mmuReadQuadExword(n2, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaAnyQuad(n);
                                l = MC68060.mmuReadQuadData(n2, XEiJ.regSRS);
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].setd01(l);
                            break;
                        }
                        case 6: {
                            byte by;
                            XEiJ.mpuCycleCount += 3;
                            if (n < 8) {
                                XEiJ.mpuCycleCount += 2;
                                by = (byte)XEiJ.regRn[n];
                            } else if (n == 60) {
                                n2 = XEiJ.regPC;
                                XEiJ.regPC = n2 + 2;
                                by = MC68060.mmuReadByteSignExword(n2 + 1, XEiJ.regSRS);
                            } else {
                                n2 = MC68060.efaAnyByte(n);
                                by = MC68060.mmuReadByteSignData(n2, XEiJ.regSRS);
                            }
                            n4 = 8;
                            XEiJ.fpuFPn[8].seti(by);
                            break;
                        }
                        default: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, 44);
                                break block0;
                            }
                            if (64 <= n6) {
                                XEiJ.regPC = XEiJ.regPC0 + 2;
                                MC68060.irpFline();
                                break block0;
                            }
                            XEiJ.fpuBox.epbFmovecr(XEiJ.fpuFPn[n5], n6);
                            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
                            if (!MC68060.irpFPPostInstruction(n2)) break block0;
                            break block0;
                        }
                    }
                    if (MC68060.irpFPPreInstruction()) break;
                }
                case 0: {
                    if (n3 >> 13 == 0) {
                        XEiJ.fpuBox.epbFpsr &= 0xFF00FF;
                    }
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    switch (n6) {
                        case 0: {
                            XEiJ.fpuFPn[n5].sete(XEiJ.fpuFPn[n4]).finish();
                            break;
                        }
                        case 1: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(0);
                            XEiJ.fpuFPn[n5].round(XEiJ.fpuFPn[n4], XEiJ.fpuBox.epbRoundingMode);
                            break;
                        }
                        case 2: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].sinh(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 3: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(0);
                            XEiJ.fpuFPn[n5].trunc(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 4: 
                        case 5: {
                            XEiJ.mpuCycleCount += 67;
                            XEiJ.fpuFPn[n5].sqrt(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 6: 
                        case 7: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].log1p(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 8: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].expm1(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 9: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].tanh(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 10: 
                        case 11: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].atan(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 12: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].asin(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 13: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].atanh(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 14: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].sin(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 15: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].tan(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 16: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].exp(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 17: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].exp2(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 18: 
                        case 19: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].exp10(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 20: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].log(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 21: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].log10(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 22: 
                        case 23: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].log2(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 24: {
                            XEiJ.fpuFPn[n5].abs(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 25: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].cosh(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 26: 
                        case 27: {
                            XEiJ.fpuFPn[n5].neg(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 28: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].acos(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 29: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].cos(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 30: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].getexp(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 31: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].getman(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 32: {
                            XEiJ.mpuCycleCount += 36;
                            XEiJ.fpuFPn[n5].div(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 33: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].rem(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 34: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuFPn[n5].add(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 35: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuFPn[n5].mul(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 36: {
                            XEiJ.mpuCycleCount += 36;
                            XEiJ.fpuBox.epbSetRoundingPrec(5);
                            XEiJ.fpuFPn[n5].div(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 37: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].ieeerem(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 38: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[n5].scale(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 39: {
                            XEiJ.mpuCycleCount += 2;
                            int n10 = XEiJ.fpuBox.epbFpsr;
                            XEiJ.fpuFPn[8].roundmanf(XEiJ.fpuFPn[n4], 1);
                            XEiJ.fpuFPn[9].roundmanf(XEiJ.fpuFPn[n5], 1);
                            XEiJ.fpuBox.epbFpsr = n10;
                            XEiJ.fpuBox.epbSetRoundingPrec(5);
                            XEiJ.fpuFPn[n5].mul(XEiJ.fpuFPn[9], XEiJ.fpuFPn[8]);
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuFPn[n5].sub(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n2);
                                break block0;
                            }
                            XEiJ.fpuFPn[8].sete(XEiJ.fpuFPn[n4]);
                            XEiJ.fpuFPn[n6 &= 7].cos(XEiJ.fpuFPn[8]);
                            XEiJ.fpuFPn[n5].sin(XEiJ.fpuFPn[8]);
                            break;
                        }
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: {
                            int n11 = XEiJ.fpuFPn[n5].flg;
                            int n12 = XEiJ.fpuFPn[n4].flg;
                            if ((n11 | n12) << 3 < 0) {
                                XEiJ.fpuFPn[9].flg = 0x10000000;
                            } else {
                                int n13;
                                int n14 = n13 = (n11 & n12) << 1 < 0 ? 0 : XEiJ.fpuFPn[n5].compareTo(XEiJ.fpuFPn[n4]);
                                if (n13 == 0) {
                                    XEiJ.fpuFPn[9].flg = n11 < 0 ? -1073741824 : 0x40000000;
                                } else if (n13 < 0) {
                                    XEiJ.fpuFPn[9].negset1();
                                } else {
                                    XEiJ.fpuFPn[9].set1();
                                }
                            }
                            n5 = 9;
                            break;
                        }
                        case 58: 
                        case 59: 
                        case 62: 
                        case 63: {
                            XEiJ.fpuFPn[9].sete(XEiJ.fpuFPn[n4]);
                            n5 = 9;
                            break;
                        }
                        case 64: {
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].sete(XEiJ.fpuFPn[n4]).finish();
                            break;
                        }
                        case 65: {
                            XEiJ.mpuCycleCount += 67;
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].sqrt(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 68: {
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].sete(XEiJ.fpuFPn[n4]).finish();
                            break;
                        }
                        case 69: {
                            XEiJ.mpuCycleCount += 67;
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].sqrt(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 88: {
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].abs(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 90: {
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].neg(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 92: {
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].abs(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 94: {
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].neg(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 96: {
                            XEiJ.mpuCycleCount += 36;
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].div(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 98: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].add(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 99: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].mul(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 100: {
                            XEiJ.mpuCycleCount += 36;
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].div(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 102: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].add(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 103: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].mul(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 104: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(1);
                            XEiJ.fpuFPn[n5].sub(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 108: {
                            XEiJ.mpuCycleCount += 2;
                            XEiJ.fpuBox.epbSetRoundingPrec(2);
                            XEiJ.fpuFPn[n5].sub(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 112: {
                            XEiJ.fpuFPn[n5].lgamma(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        case 113: {
                            XEiJ.fpuFPn[n5].tgamma(XEiJ.fpuFPn[n4]);
                            break;
                        }
                        default: {
                            XEiJ.regPC = XEiJ.regPC0 + 2;
                            MC68060.irpFline();
                            break block0;
                        }
                    }
                    XEiJ.fpuBox.epbFpsr |= XEiJ.fpuFPn[n5].flg >>> 4;
                    XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
                    if (!MC68060.irpFPPostInstruction(n2)) break;
                    break;
                }
                case 3: {
                    XEiJ.fpuBox.epbFpsr &= 0xFFFF00FF;
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    switch (n4) {
                        case 0: {
                            int n15 = XEiJ.fpuFPn[n5].geti(XEiJ.fpuBox.epbRoundingMode);
                            if (n < 8) {
                                XEiJ.regRn[n] = n15;
                                break;
                            }
                            n2 = MC68060.efaMltLong(n);
                            MC68060.mmuWriteLongData(n2, n15, XEiJ.regSRS);
                            break;
                        }
                        case 1: {
                            int n16 = XEiJ.fpuFPn[n5].getf0(XEiJ.fpuBox.epbRoundingMode);
                            if (n < 8) {
                                XEiJ.regRn[n] = n16;
                                break;
                            }
                            n2 = MC68060.efaMltLong(n);
                            MC68060.mmuWriteLongData(n2, n16, XEiJ.regSRS);
                            break;
                        }
                        case 2: {
                            int[] nArray = new int[3];
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                XEiJ.fpuFPn[n5].gety012(nArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            } else {
                                XEiJ.fpuFPn[n5].getx012(nArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            }
                            n2 = MC68060.efaMltExtd(n);
                            if ((n & 0x38) == 32) {
                                m60Address = n2 + 8;
                                MC68060.mmuWriteLongData(m60Address, nArray[2], XEiJ.regSRS);
                                m60Address = n2 + 4;
                                MC68060.mmuWriteLongData(m60Address, nArray[1], XEiJ.regSRS);
                                m60Address = n2;
                                MC68060.mmuWriteLongData(m60Address, nArray[0], XEiJ.regSRS);
                                break;
                            }
                            m60Address = n2;
                            MC68060.mmuWriteLongData(m60Address, nArray[0], XEiJ.regSRS);
                            m60Address = n2 + 4;
                            MC68060.mmuWriteLongData(m60Address, nArray[1], XEiJ.regSRS);
                            m60Address = n2 + 8;
                            MC68060.mmuWriteLongData(m60Address, nArray[2], XEiJ.regSRS);
                            break;
                        }
                        case 3: {
                            n2 = MC68060.efaMltExtd(n);
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.fpuBox.epbExceptionStatusWord = 57351;
                                MC68060.irpExceptionFormat3(220, XEiJ.regPC, n2);
                                break block0;
                            }
                            int[] nArray = new int[3];
                            XEiJ.fpuFPn[n5].getp012(nArray, 0, n3);
                            if ((n & 0x38) == 32) {
                                m60Address = n2 + 8;
                                MC68060.mmuWriteLongData(m60Address, nArray[2], XEiJ.regSRS);
                                m60Address = n2 + 4;
                                MC68060.mmuWriteLongData(m60Address, nArray[1], XEiJ.regSRS);
                                m60Address = n2;
                                MC68060.mmuWriteLongData(m60Address, nArray[0], XEiJ.regSRS);
                                break;
                            }
                            m60Address = n2;
                            MC68060.mmuWriteLongData(m60Address, nArray[0], XEiJ.regSRS);
                            m60Address = n2 + 4;
                            MC68060.mmuWriteLongData(m60Address, nArray[1], XEiJ.regSRS);
                            m60Address = n2 + 8;
                            MC68060.mmuWriteLongData(m60Address, nArray[2], XEiJ.regSRS);
                            break;
                        }
                        case 4: {
                            int n17 = XEiJ.fpuFPn[n5].gets(XEiJ.fpuBox.epbRoundingMode);
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.regRn[n] & 0xFFFF0000 | (char)n17;
                                break;
                            }
                            n2 = MC68060.efaMltWord(n);
                            MC68060.mmuWriteWordData(n2, n17, XEiJ.regSRS);
                            break;
                        }
                        case 5: {
                            long l = XEiJ.fpuFPn[n5].getd01(XEiJ.fpuBox.epbRoundingMode);
                            n2 = MC68060.efaMltQuad(n);
                            MC68060.mmuWriteQuadData(n2, l, XEiJ.regSRS);
                            break;
                        }
                        case 6: {
                            int n18 = XEiJ.fpuFPn[n5].getb(XEiJ.fpuBox.epbRoundingMode);
                            if (n < 8) {
                                XEiJ.regRn[n] = XEiJ.regRn[n] & 0xFFFFFF00 | n18 & 0xFF;
                                break;
                            }
                            n2 = MC68060.efaMltByte(n);
                            MC68060.mmuWriteByteData(n2, n18, XEiJ.regSRS);
                            break;
                        }
                        default: {
                            n2 = MC68060.efaMltExtd(n);
                            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                                XEiJ.fpuBox.epbExceptionStatusWord = 57351;
                                MC68060.irpExceptionFormat3(220, XEiJ.regPC, n2);
                                break block0;
                            }
                            byte[] byArray = new byte[12];
                            XEiJ.fpuFPn[n5].getp012(byArray, 0, XEiJ.regRn[n3 >> 4 & 7]);
                            if (n >> 3 == 4) {
                                MC68060.mmuWriteByteArrayDecrement(n2, byArray, 0, 12, XEiJ.regSRS);
                                break;
                            }
                            MC68060.mmuWriteByteArray(n2, byArray, 0, 12, XEiJ.regSRS);
                        }
                    }
                    XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
                    if (!MC68060.irpFPPostInstruction(n2)) break;
                    break;
                }
                case 4: {
                    int n19;
                    XEiJ.mpuCycleCount += 6;
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    int n20 = n4 == 7 ? 12 : (n19 = n4 == 6 || n4 == 5 || n4 == 3 ? 8 : 4);
                    if ((n & 0x38) == 0) {
                        if (4 < n19) {
                            M68kException.m6eNumber = 4;
                            throw M68kException.m6eSignal;
                        }
                    } else if ((n & 0x38) == 8) {
                        if (n4 != 1) {
                            M68kException.m6eNumber = 4;
                            throw M68kException.m6eSignal;
                        }
                    } else if ((n & 0x38) == 24) {
                        n2 = XEiJ.regRn[n - 16];
                    } else if ((n & 0x38) == 32) {
                        m60Incremented -= (long)n19 << (n << 3);
                        int n21 = n - 24;
                        int n22 = XEiJ.regRn[n21] - n19;
                        XEiJ.regRn[n21] = n22;
                        n2 = n22;
                    } else if (n == 60) {
                        if (4 < n19 && !XEiJ.fpuBox.epbIsFullSpec()) {
                            MC68060.irpExceptionFormat0(240, XEiJ.regPC0);
                            break;
                        }
                    } else {
                        n2 = MC68060.efaMemLong(n);
                    }
                    for (int i = 4; 1 <= i; i >>= 1) {
                        int n23;
                        if ((n4 & i) == 0) continue;
                        if (n < 16) {
                            v4 = XEiJ.regRn[n];
                        } else if (n == 60) {
                            v4 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                        } else {
                            m60Address = n2;
                            v4 = n23 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                        }
                        if (i == 4) {
                            XEiJ.fpuBox.epbFpcr = n23 & 0xFFF0;
                        } else if (i == 2) {
                            XEiJ.fpuBox.epbFpsr = n23 & 0xFFFFFF8;
                        } else {
                            XEiJ.fpuBox.epbFpiar = n23;
                        }
                        n2 += 4;
                    }
                    if ((n & 0x38) != 24) break;
                    m60Incremented += (long)n19 << (n << 3);
                    int n24 = n - 24;
                    XEiJ.regRn[n24] = XEiJ.regRn[n24] + n19;
                    break;
                }
                case 5: {
                    int n25;
                    XEiJ.mpuCycleCount += 4;
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    int n26 = n4 == 7 ? 12 : (n25 = n4 == 6 || n4 == 5 || n4 == 3 ? 8 : 4);
                    if ((n & 0x38) == 0) {
                        if (4 < n25) {
                            M68kException.m6eNumber = 4;
                            throw M68kException.m6eSignal;
                        }
                    } else if ((n & 0x38) == 8) {
                        if (n4 != 1) {
                            M68kException.m6eNumber = 4;
                            throw M68kException.m6eSignal;
                        }
                    } else if ((n & 0x38) == 24) {
                        n2 = XEiJ.regRn[n - 16];
                    } else if ((n & 0x38) == 32) {
                        m60Incremented -= (long)n25 << (n << 3);
                        int n27 = n - 24;
                        int n28 = XEiJ.regRn[n27] - n25;
                        XEiJ.regRn[n27] = n28;
                        n2 = n28;
                    } else {
                        n2 = MC68060.efaMltLong(n);
                    }
                    for (int i = 4; 1 <= i; i >>= 1) {
                        int n29;
                        if ((n4 & i) == 0) continue;
                        int n30 = i == 4 ? XEiJ.fpuBox.epbFpcr : (n29 = i == 2 ? XEiJ.fpuBox.epbFpsr : XEiJ.fpuBox.epbFpiar);
                        if (n < 16) {
                            XEiJ.regRn[n] = n29;
                        } else {
                            m60Address = n2;
                            MC68060.mmuWriteLongData(m60Address, n29, XEiJ.regSRS);
                        }
                        n2 += 4;
                    }
                    if ((n & 0x38) != 24) break;
                    m60Incremented += (long)n25 << (n << 3);
                    int n31 = n - 24;
                    XEiJ.regRn[n31] = XEiJ.regRn[n31] + n25;
                    break;
                }
                case 6: {
                    if ((n4 & 2) != 0 && !XEiJ.fpuBox.epbIsFullSpec()) {
                        MC68060.irpExceptionFormat0(240, XEiJ.regPC0);
                        break;
                    }
                    int n32 = 0xFF & ((n4 & 2) == 0 ? n3 : XEiJ.regRn[(0x70 & n3) >> 4]);
                    int[] nArray = new int[3];
                    if ((n & 0x38) == 24) {
                        int n33 = n - 16;
                        n2 = XEiJ.regRn[n33];
                        for (n5 = 0; n5 <= 7; ++n5) {
                            if ((n32 & 128 >> n5) == 0) continue;
                            XEiJ.mpuCycleCount += 3;
                            m60Address = n2;
                            nArray[0] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                            m60Address = n2 + 4;
                            nArray[1] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                            m60Address = n2 + 8;
                            nArray[2] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                XEiJ.fpuFPn[n5].sety012(nArray, 0);
                            } else {
                                XEiJ.fpuFPn[n5].setx012(nArray, 0);
                            }
                            n2 += 12;
                        }
                        m60Incremented += (long)(n2 - XEiJ.regRn[n33]) << (n33 << 3);
                        XEiJ.regRn[n33] = n2;
                        break;
                    }
                    n2 = MC68060.efaCntLong(n);
                    for (n5 = 0; n5 <= 7; ++n5) {
                        if ((n32 & 128 >> n5) == 0) continue;
                        XEiJ.mpuCycleCount += 3;
                        m60Address = n2;
                        nArray[0] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                        m60Address = n2 + 4;
                        nArray[1] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                        m60Address = n2 + 8;
                        nArray[2] = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                        if (XEiJ.fpuBox.epbIsTriple()) {
                            XEiJ.fpuFPn[n5].sety012(nArray, 0);
                        } else {
                            XEiJ.fpuFPn[n5].setx012(nArray, 0);
                        }
                        n2 += 12;
                    }
                    break;
                }
                case 7: {
                    if ((n4 & 2) != 0 && !XEiJ.fpuBox.epbIsFullSpec()) {
                        MC68060.irpExceptionFormat0(240, XEiJ.regPC0);
                        break;
                    }
                    int n34 = 0xFF & ((n4 & 2) == 0 ? n3 : XEiJ.regRn[(0x70 & n3) >> 4]);
                    int[] nArray = new int[3];
                    if ((n & 0x38) == 32) {
                        int n35 = n - 24;
                        n2 = XEiJ.regRn[n35];
                        for (n5 = 7; 0 <= n5; --n5) {
                            if ((n34 & 1 << n5) == 0) continue;
                            XEiJ.mpuCycleCount += 3;
                            n2 -= 12;
                            if (XEiJ.fpuBox.epbIsTriple()) {
                                XEiJ.fpuFPn[n5].gety012(nArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            } else {
                                XEiJ.fpuFPn[n5].getx012(nArray, 0, XEiJ.fpuBox.epbRoundingMode);
                            }
                            m60Address = n2 + 8;
                            MC68060.mmuWriteLongData(m60Address, nArray[2], XEiJ.regSRS);
                            m60Address = n2 + 4;
                            MC68060.mmuWriteLongData(m60Address, nArray[1], XEiJ.regSRS);
                            m60Address = n2;
                            MC68060.mmuWriteLongData(m60Address, nArray[0], XEiJ.regSRS);
                        }
                        m60Incremented -= (long)(XEiJ.regRn[n35] - n2) << (n35 << 3);
                        XEiJ.regRn[n35] = n2;
                        break;
                    }
                    n2 = MC68060.efaCntLong(n);
                    for (n5 = 0; n5 <= 7; ++n5) {
                        if ((n34 & 128 >> n5) == 0) continue;
                        XEiJ.mpuCycleCount += 3;
                        if (XEiJ.fpuBox.epbIsTriple()) {
                            XEiJ.fpuFPn[n5].gety012(nArray, 0, XEiJ.fpuBox.epbRoundingMode);
                        } else {
                            XEiJ.fpuFPn[n5].getx012(nArray, 0, XEiJ.fpuBox.epbRoundingMode);
                        }
                        m60Address = n2;
                        MC68060.mmuWriteLongData(m60Address, nArray[0], XEiJ.regSRS);
                        m60Address = n2 + 4;
                        MC68060.mmuWriteLongData(m60Address, nArray[1], XEiJ.regSRS);
                        m60Address = n2 + 8;
                        MC68060.mmuWriteLongData(m60Address, nArray[2], XEiJ.regSRS);
                        n2 += 12;
                    }
                    break;
                }
                default: {
                    XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
                    XEiJ.regPC = XEiJ.regPC0 + 2;
                    MC68060.irpFline();
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpFscc() throws M68kException {
        int n;
        if ((7 & XEiJ.currentOnchipFPU) == 0) {
            MC68060.irpFline();
            return;
        }
        XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
        int n2 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n2 & 0x10) != 0 && (XEiJ.fpuBox.epbFpsr & 0x1000000) != 0) {
            XEiJ.fpuBox.epbFpsr |= 0x8000;
            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
            if ((XEiJ.fpuBox.epbFpcr & 0x8000) != 0) {
                XEiJ.fpuBox.epbExceptionStatusWord = 57344;
                MC68060.irpExceptionFormat0(192, XEiJ.regPC0);
                return;
            }
        }
        if ((n = XEiJ.regOC & 0x3F) < 8) {
            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                MC68060.irpExceptionFormat2(44, XEiJ.regPC, 0);
                return;
            }
            if (XEiJ.FPU_CCMAP_060[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
                ++XEiJ.mpuCycleCount;
                int n3 = n;
                XEiJ.regRn[n3] = XEiJ.regRn[n3] | 0xFF;
                return;
            }
            ++XEiJ.mpuCycleCount;
            int n4 = n;
            XEiJ.regRn[n4] = XEiJ.regRn[n4] & 0xFFFFFF00;
            return;
        }
        if (n < 16) {
            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                MC68060.irpExceptionFormat2(44, XEiJ.regPC += 2, 0);
                return;
            }
            if (XEiJ.FPU_CCMAP_060[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
                XEiJ.mpuCycleCount += 2;
                XEiJ.regPC += 2;
                return;
            }
            int n5 = XEiJ.regOC & 7;
            int n6 = XEiJ.regRn[n5];
            if ((short)n6 == 0) {
                XEiJ.mpuCycleCount += 2;
                XEiJ.regRn[n5] = n6 + 65535;
                XEiJ.regPC += 2;
                return;
            }
            ++XEiJ.mpuCycleCount;
            XEiJ.regRn[n5] = n6 - 1;
            MC68060.irpSetPC(XEiJ.regPC + MC68060.mmuReadWordSignExword(XEiJ.regPC, XEiJ.regSRS));
            return;
        }
        if (n < 58) {
            int n7 = MC68060.efaMltByte(n);
            if (!XEiJ.fpuBox.epbIsFullSpec()) {
                MC68060.irpExceptionFormat2(44, XEiJ.regPC, n7);
                return;
            }
            ++XEiJ.mpuCycleCount;
            MC68060.mmuWriteByteData(n7, XEiJ.FPU_CCMAP_060[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF] ? 255 : 0, XEiJ.regSRS);
            return;
        }
        if (n > 60) {
            XEiJ.regPC = XEiJ.regPC0 + 2;
            MC68060.irpFline();
            return;
        }
        if (n == 58) {
            MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        } else if (n == 59) {
            MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
        }
        if (!XEiJ.fpuBox.epbIsFullSpec()) {
            MC68060.irpExceptionFormat2(44, XEiJ.regPC, 0);
            return;
        }
        if (!XEiJ.FPU_CCMAP_060[(n2 & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) {
            XEiJ.mpuCycleCount += 2;
            return;
        }
        m60Address = XEiJ.regPC0;
        M68kException.m6eNumber = 7;
        throw M68kException.m6eSignal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpFbccWord() throws M68kException {
        if ((7 & XEiJ.currentOnchipFPU) == 0) {
            MC68060.irpFline();
            return;
        }
        XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
        if ((XEiJ.regOC & 0x10) != 0 && (XEiJ.fpuBox.epbFpsr & 0x1000000) != 0) {
            XEiJ.fpuBox.epbFpsr |= 0x8000;
            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
            if ((XEiJ.fpuBox.epbFpcr & 0x8000) != 0) {
                XEiJ.fpuBox.epbExceptionStatusWord = 57344;
                MC68060.irpExceptionFormat0(192, XEiJ.regPC0);
                return;
            }
        }
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 2;
        if (((n += MC68060.mmuReadWordSignExword(n, XEiJ.regSRS)) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (!XEiJ.FPU_CCMAP_060[(XEiJ.regOC & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) return;
        MC68060.irpSetPC(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpFbccLong() throws M68kException {
        if ((7 & XEiJ.currentOnchipFPU) == 0) {
            MC68060.irpFline();
            return;
        }
        XEiJ.fpuBox.epbFpiar = XEiJ.regPC0;
        if ((XEiJ.regOC & 0x10) != 0 && (XEiJ.fpuBox.epbFpsr & 0x1000000) != 0) {
            XEiJ.fpuBox.epbFpsr |= 0x8000;
            XEiJ.fpuBox.epbFpsr |= XEiJ.FPU_FPSR_EXC_TO_AEXC[XEiJ.fpuBox.epbFpsr >> 8 & 0xFF];
            if ((XEiJ.fpuBox.epbFpcr & 0x8000) != 0) {
                XEiJ.fpuBox.epbExceptionStatusWord = 57344;
                MC68060.irpExceptionFormat0(192, XEiJ.regPC0);
                return;
            }
        }
        ++XEiJ.mpuCycleCount;
        int n = XEiJ.regPC;
        XEiJ.regPC = n + 4;
        if (((n += MC68060.mmuReadLongExword(n, XEiJ.regSRS)) & 1) != 0) {
            MC68060.irpBccAddressError(n);
        }
        if (!XEiJ.FPU_CCMAP_060[(XEiJ.regOC & 0x3F) << 4 | XEiJ.fpuBox.epbFpsr >> 24 & 0xF]) return;
        MC68060.irpSetPC(n);
    }

    public static void irpFsave() throws M68kException {
        int n;
        if ((7 & XEiJ.currentOnchipFPU) == 0) {
            MC68060.irpFline();
            return;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 3;
        int n2 = XEiJ.regOC & 0x3F;
        if (n2 >> 3 == 4) {
            int n3 = XEiJ.regOC & 7 | 8;
            m60Incremented -= 12L << (n3 << 3);
            int n4 = n3;
            int n5 = XEiJ.regRn[n4] - 12;
            XEiJ.regRn[n4] = n5;
            m60Address = n5;
            n = n5;
        } else {
            n = MC68060.efaCltWord(n2);
        }
        if (XEiJ.fpuBox.epbExceptionStatusWord == 0) {
            MC68060.mmuWriteLongData(n, 24576, 1);
            MC68060.mmuWriteQuadSecond(n + 4, 0L, 1);
        } else {
            MC68060.mmuWriteLongData(n, XEiJ.fpuBox.epbExceptionOperandExponent | XEiJ.fpuBox.epbExceptionStatusWord, 1);
            MC68060.mmuWriteQuadSecond(n + 4, XEiJ.fpuBox.epbExceptionOperandMantissa, 1);
            XEiJ.fpuBox.epbExceptionStatusWord = 0;
        }
    }

    public static void irpFrestore() throws M68kException {
        int n;
        int n2;
        if ((7 & XEiJ.currentOnchipFPU) == 0) {
            MC68060.irpFline();
            return;
        }
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 6;
        int n3 = XEiJ.regOC & 0x3F;
        if (n3 >> 3 == 3) {
            n2 = XEiJ.regOC & 7 | 8;
            m60Incremented += 12L << (n2 << 3);
            int n4 = n2;
            int n5 = XEiJ.regRn[n4] + 12;
            XEiJ.regRn[n4] = n5;
            n = m60Address = n5 - 12;
        } else {
            n = MC68060.efaCntWord(n3);
        }
        n2 = MC68060.mmuReadLongData(n, 1);
        long l = MC68060.mmuReadQuadData(n + 4, 1);
        if ((n2 & 0xFF00) == 57344) {
            XEiJ.fpuBox.epbExceptionStatusWord = (char)n2;
            XEiJ.fpuBox.epbExceptionOperandExponent = n2 & 0xFFFF0000;
            XEiJ.fpuBox.epbExceptionOperandMantissa = l;
        } else {
            XEiJ.fpuBox.epbExceptionStatusWord = 0;
            XEiJ.fpuBox.epbExceptionOperandExponent = 0;
            XEiJ.fpuBox.epbExceptionOperandMantissa = 0L;
        }
        XEiJ.fpuBox.epbFpsr = 0;
        XEiJ.fpuBox.epbFpiar = 0;
    }

    public static boolean irpFPPreInstruction() throws M68kException {
        int n = XEiJ.fpuBox.epbFpcr & XEiJ.fpuBox.epbFpsr & 0xFF00;
        if (n == 0) {
            return false;
        }
        byte by = FP_OFFSET_TO_NUMBER[Integer.numberOfLeadingZeros(n)];
        XEiJ.fpuBox.epbExceptionStatusWord = 0xE000 | by & 7;
        MC68060.irpExceptionFormat0(by << 2, XEiJ.regPC0);
        return true;
    }

    public static boolean irpFPPostInstruction(int n) throws M68kException {
        int n2 = XEiJ.fpuBox.epbFpcr & XEiJ.fpuBox.epbFpsr & 0xFF00;
        if (n2 == 0) {
            return false;
        }
        byte by = FP_OFFSET_TO_NUMBER[Integer.numberOfLeadingZeros(n2)];
        XEiJ.fpuBox.epbExceptionStatusWord = 0xE000 | by & 7;
        MC68060.irpExceptionFormat3(by << 2, XEiJ.regPC, n);
        return true;
    }

    public static void irpCinvCpushNC() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
    }

    public static void irpCinvCpushDC() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
    }

    public static void irpCinvCpushIC() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
    }

    public static void irpCinvCpushBC() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        ++XEiJ.mpuCycleCount;
    }

    public static void irpPflush() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        if (XEiJ.regOC <= 62727) {
            XEiJ.mpuCycleCount += 18;
            MC68060.mmuInvalidateNonGlobalCache(XEiJ.regRn[XEiJ.regOC - 62712]);
        } else if (XEiJ.regOC <= 62735) {
            XEiJ.mpuCycleCount += 18;
            MC68060.mmuInvalidateCache(XEiJ.regRn[XEiJ.regOC - 62720]);
        } else if (XEiJ.regOC == 62736) {
            XEiJ.mpuCycleCount += 33;
            MC68060.mmuInvalidateAllNonGlobalCache();
        } else if (XEiJ.regOC == 62744) {
            XEiJ.mpuCycleCount += 33;
            MC68060.mmuInvalidateAllCache();
        } else {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpPlpaw() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 15;
        int n = XEiJ.regOC - 62848;
        XEiJ.regRn[n] = MC68060.mmuLoadPhysicalAddressWrite(XEiJ.regRn[n]);
    }

    public static void irpPlpar() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
        XEiJ.mpuCycleCount += 15;
        int n = XEiJ.regOC - 62912;
        XEiJ.regRn[n] = MC68060.mmuLoadPhysicalAddressRead(XEiJ.regRn[n]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void irpMove16() throws M68kException {
        if (XEiJ.regOC <= 63007) {
            XEiJ.mpuCycleCount += 18;
            int n = XEiJ.regOC - 62968;
            int n2 = XEiJ.regRn[n] & 0xFFFFFFF0;
            int n3 = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS) & 0xFFFFFFF0;
            if ((XEiJ.regOC & 8) == 0) {
                m60Address = n2;
                long l = MC68060.mmuReadQuadData(m60Address, XEiJ.regSRS);
                long l2 = MC68060.mmuReadQuadSecond(n2 + 8, XEiJ.regSRS);
                m60Address = n3;
                MC68060.mmuWriteQuadData(m60Address, l, XEiJ.regSRS);
                MC68060.mmuWriteQuadSecond(n3 + 8, l2, XEiJ.regSRS);
            } else {
                m60Address = n3;
                long l = MC68060.mmuReadQuadData(m60Address, XEiJ.regSRS);
                long l3 = MC68060.mmuReadQuadSecond(n3 + 8, XEiJ.regSRS);
                m60Address = n2;
                MC68060.mmuWriteQuadData(m60Address, l, XEiJ.regSRS);
                MC68060.mmuWriteQuadSecond(n2 + 8, l3, XEiJ.regSRS);
            }
            if ((XEiJ.regOC & 0x10) != 0) return;
            int n4 = n;
            XEiJ.regRn[n4] = XEiJ.regRn[n4] + 16;
            return;
        }
        if (XEiJ.regOC > 63015) {
            M68kException.m6eNumber = 4;
            throw M68kException.m6eSignal;
        }
        int n = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
        if ((n & 0x8FFF) == 32768) {
            XEiJ.mpuCycleCount += 18;
            int n5 = XEiJ.regOC - 63000;
            int n6 = XEiJ.regRn[n5] & 0xFFFFFFF0;
            int n7 = n >> 12;
            int n8 = XEiJ.regRn[n7] & 0xFFFFFFF0;
            m60Address = n6;
            long l = MC68060.mmuReadQuadData(m60Address, XEiJ.regSRS);
            long l4 = MC68060.mmuReadQuadSecond(n6 + 8, XEiJ.regSRS);
            m60Address = n8;
            MC68060.mmuWriteQuadData(m60Address, l, XEiJ.regSRS);
            MC68060.mmuWriteQuadSecond(n8 + 8, l4, XEiJ.regSRS);
            int n9 = n5;
            XEiJ.regRn[n9] = XEiJ.regRn[n9] + 16;
            if (n5 == n7) return;
            int n10 = n7;
            XEiJ.regRn[n10] = XEiJ.regRn[n10] + 16;
            return;
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static void irpLpstop() throws M68kException {
        if (XEiJ.regSRS == 0) {
            M68kException.m6eNumber = 8;
            throw M68kException.m6eSignal;
        }
    }

    public static void irpFpack() throws M68kException {
        if (!MainMemory.mmrFEfuncActivated) {
            MC68060.irpFline();
            return;
        }
        XEiJ.mpuCycleCount += 80;
        switch (XEiJ.regOC & 0xFF) {
            case 0: {
                FEFunction.fpkLMUL();
                break;
            }
            case 1: {
                FEFunction.fpkLDIV();
                break;
            }
            case 2: {
                FEFunction.fpkLMOD();
                break;
            }
            case 4: {
                FEFunction.fpkUMUL();
                break;
            }
            case 5: {
                FEFunction.fpkUDIV();
                break;
            }
            case 6: {
                FEFunction.fpkUMOD();
                break;
            }
            case 8: {
                FEFunction.fpkIMUL();
                break;
            }
            case 9: {
                FEFunction.fpkIDIV();
                break;
            }
            case 12: {
                FEFunction.fpkRANDOMIZE();
                break;
            }
            case 13: {
                FEFunction.fpkSRAND();
                break;
            }
            case 14: {
                FEFunction.fpkRAND();
                break;
            }
            case 16: {
                MC68060.fpkSTOL();
                break;
            }
            case 17: {
                MC68060.fpkLTOS();
                break;
            }
            case 18: {
                MC68060.fpkSTOH();
                break;
            }
            case 19: {
                MC68060.fpkHTOS();
                break;
            }
            case 20: {
                MC68060.fpkSTOO();
                break;
            }
            case 21: {
                MC68060.fpkOTOS();
                break;
            }
            case 22: {
                MC68060.fpkSTOB();
                break;
            }
            case 23: {
                MC68060.fpkBTOS();
                break;
            }
            case 24: {
                MC68060.fpkIUSING();
                break;
            }
            case 26: {
                FEFunction.fpkLTOD();
                break;
            }
            case 27: {
                FEFunction.fpkDTOL();
                break;
            }
            case 28: {
                FEFunction.fpkLTOF();
                break;
            }
            case 29: {
                FEFunction.fpkFTOL();
                break;
            }
            case 30: {
                FEFunction.fpkFTOD();
                break;
            }
            case 31: {
                FEFunction.fpkDTOF();
                break;
            }
            case 32: {
                MC68060.fpkVAL();
                break;
            }
            case 33: {
                MC68060.fpkUSING();
                break;
            }
            case 34: {
                MC68060.fpkSTOD();
                break;
            }
            case 35: {
                MC68060.fpkDTOS();
                break;
            }
            case 36: {
                MC68060.fpkECVT();
                break;
            }
            case 37: {
                MC68060.fpkFCVT();
                break;
            }
            case 38: {
                MC68060.fpkGCVT();
                break;
            }
            case 40: {
                FEFunction.fpkDTST();
                break;
            }
            case 41: {
                FEFunction.fpkDCMP();
                break;
            }
            case 42: {
                FEFunction.fpkDNEG();
                break;
            }
            case 43: {
                FEFunction.fpkDADD();
                break;
            }
            case 44: {
                FEFunction.fpkDSUB();
                break;
            }
            case 45: {
                FEFunction.fpkDMUL();
                break;
            }
            case 46: {
                FEFunction.fpkDDIV();
                break;
            }
            case 47: {
                FEFunction.fpkDMOD();
                break;
            }
            case 48: {
                FEFunction.fpkDABS();
                break;
            }
            case 49: {
                FEFunction.fpkDCEIL();
                break;
            }
            case 50: {
                FEFunction.fpkDFIX();
                break;
            }
            case 51: {
                FEFunction.fpkDFLOOR();
                break;
            }
            case 52: {
                FEFunction.fpkDFRAC();
                break;
            }
            case 53: {
                FEFunction.fpkDSGN();
                break;
            }
            case 54: {
                FEFunction.fpkSIN();
                break;
            }
            case 55: {
                FEFunction.fpkCOS();
                break;
            }
            case 56: {
                FEFunction.fpkTAN();
                break;
            }
            case 57: {
                FEFunction.fpkATAN();
                break;
            }
            case 58: {
                FEFunction.fpkLOG();
                break;
            }
            case 59: {
                FEFunction.fpkEXP();
                break;
            }
            case 60: {
                FEFunction.fpkSQR();
                break;
            }
            case 61: {
                FEFunction.fpkPI();
                break;
            }
            case 62: {
                FEFunction.fpkNPI();
                break;
            }
            case 63: {
                FEFunction.fpkPOWER();
                break;
            }
            case 64: {
                FEFunction.fpkRND();
                break;
            }
            case 65: {
                FEFunction.fpkSINH();
                break;
            }
            case 66: {
                FEFunction.fpkCOSH();
                break;
            }
            case 67: {
                FEFunction.fpkTANH();
                break;
            }
            case 68: {
                FEFunction.fpkATANH();
                break;
            }
            case 69: {
                FEFunction.fpkASIN();
                break;
            }
            case 70: {
                FEFunction.fpkACOS();
                break;
            }
            case 71: {
                FEFunction.fpkLOG10();
                break;
            }
            case 72: {
                FEFunction.fpkLOG2();
                break;
            }
            case 73: {
                FEFunction.fpkDFREXP();
                break;
            }
            case 74: {
                FEFunction.fpkDLDEXP();
                break;
            }
            case 75: {
                FEFunction.fpkDADDONE();
                break;
            }
            case 76: {
                FEFunction.fpkDSUBONE();
                break;
            }
            case 77: {
                FEFunction.fpkDDIVTWO();
                break;
            }
            case 78: {
                FEFunction.fpkDIEECNV();
                break;
            }
            case 79: {
                FEFunction.fpkIEEDCNV();
                break;
            }
            case 80: {
                MC68060.fpkFVAL();
                break;
            }
            case 81: {
                FEFunction.fpkFUSING();
                break;
            }
            case 82: {
                FEFunction.fpkSTOF();
                break;
            }
            case 83: {
                FEFunction.fpkFTOS();
                break;
            }
            case 84: {
                FEFunction.fpkFECVT();
                break;
            }
            case 85: {
                FEFunction.fpkFFCVT();
                break;
            }
            case 86: {
                FEFunction.fpkFGCVT();
                break;
            }
            case 88: {
                FEFunction.fpkFTST();
                break;
            }
            case 89: {
                FEFunction.fpkFCMP();
                break;
            }
            case 90: {
                FEFunction.fpkFNEG();
                break;
            }
            case 91: {
                FEFunction.fpkFADD();
                break;
            }
            case 92: {
                FEFunction.fpkFSUB();
                break;
            }
            case 93: {
                FEFunction.fpkFMUL();
                break;
            }
            case 94: {
                FEFunction.fpkFDIV();
                break;
            }
            case 95: {
                FEFunction.fpkFMOD();
                break;
            }
            case 96: {
                FEFunction.fpkFABS();
                break;
            }
            case 97: {
                FEFunction.fpkFCEIL();
                break;
            }
            case 98: {
                FEFunction.fpkFFIX();
                break;
            }
            case 99: {
                FEFunction.fpkFFLOOR();
                break;
            }
            case 100: {
                FEFunction.fpkFFRAC();
                break;
            }
            case 101: {
                FEFunction.fpkFSGN();
                break;
            }
            case 102: {
                FEFunction.fpkFSIN();
                break;
            }
            case 103: {
                FEFunction.fpkFCOS();
                break;
            }
            case 104: {
                FEFunction.fpkFTAN();
                break;
            }
            case 105: {
                FEFunction.fpkFATAN();
                break;
            }
            case 106: {
                FEFunction.fpkFLOG();
                break;
            }
            case 107: {
                FEFunction.fpkFEXP();
                break;
            }
            case 108: {
                FEFunction.fpkFSQR();
                break;
            }
            case 109: {
                FEFunction.fpkFPI();
                break;
            }
            case 110: {
                FEFunction.fpkFNPI();
                break;
            }
            case 111: {
                FEFunction.fpkFPOWER();
                break;
            }
            case 112: {
                FEFunction.fpkFRND();
                break;
            }
            case 113: {
                FEFunction.fpkFSINH();
                break;
            }
            case 114: {
                FEFunction.fpkFCOSH();
                break;
            }
            case 115: {
                FEFunction.fpkFTANH();
                break;
            }
            case 116: {
                FEFunction.fpkFATANH();
                break;
            }
            case 117: {
                FEFunction.fpkFASIN();
                break;
            }
            case 118: {
                FEFunction.fpkFACOS();
                break;
            }
            case 119: {
                FEFunction.fpkFLOG10();
                break;
            }
            case 120: {
                FEFunction.fpkFLOG2();
                break;
            }
            case 121: {
                FEFunction.fpkFFREXP();
                break;
            }
            case 122: {
                FEFunction.fpkFLDEXP();
                break;
            }
            case 123: {
                FEFunction.fpkFADDONE();
                break;
            }
            case 124: {
                FEFunction.fpkFSUBONE();
                break;
            }
            case 125: {
                FEFunction.fpkFDIVTWO();
                break;
            }
            case 126: {
                FEFunction.fpkFIEECNV();
                break;
            }
            case 127: {
                FEFunction.fpkIEEFCNV();
                break;
            }
            case 224: {
                MC68060.fpkCLMUL();
                break;
            }
            case 225: {
                MC68060.fpkCLDIV();
                break;
            }
            case 226: {
                MC68060.fpkCLMOD();
                break;
            }
            case 227: {
                MC68060.fpkCUMUL();
                break;
            }
            case 228: {
                MC68060.fpkCUDIV();
                break;
            }
            case 229: {
                MC68060.fpkCUMOD();
                break;
            }
            case 230: {
                MC68060.fpkCLTOD();
                break;
            }
            case 231: {
                MC68060.fpkCDTOL();
                break;
            }
            case 232: {
                MC68060.fpkCLTOF();
                break;
            }
            case 233: {
                MC68060.fpkCFTOL();
                break;
            }
            case 234: {
                MC68060.fpkCFTOD();
                break;
            }
            case 235: {
                MC68060.fpkCDTOF();
                break;
            }
            case 236: {
                MC68060.fpkCDCMP();
                break;
            }
            case 237: {
                MC68060.fpkCDADD();
                break;
            }
            case 238: {
                MC68060.fpkCDSUB();
                break;
            }
            case 239: {
                MC68060.fpkCDMUL();
                break;
            }
            case 240: {
                MC68060.fpkCDDIV();
                break;
            }
            case 241: {
                MC68060.fpkCDMOD();
                break;
            }
            case 242: {
                MC68060.fpkCFCMP();
                break;
            }
            case 243: {
                MC68060.fpkCFADD();
                break;
            }
            case 244: {
                MC68060.fpkCFSUB();
                break;
            }
            case 245: {
                MC68060.fpkCFMUL();
                break;
            }
            case 246: {
                MC68060.fpkCFDIV();
                break;
            }
            case 247: {
                MC68060.fpkCFMOD();
                break;
            }
            case 248: {
                MC68060.fpkCDTST();
                break;
            }
            case 249: {
                MC68060.fpkCFTST();
                break;
            }
            case 250: {
                MC68060.fpkCDINC();
                break;
            }
            case 251: {
                MC68060.fpkCFINC();
                break;
            }
            case 252: {
                MC68060.fpkCDDEC();
                break;
            }
            case 253: {
                MC68060.fpkCFDEC();
                break;
            }
            case 254: {
                FEFunction.fpkFEVARG();
                break;
            }
            default: {
                XEiJ.mpuCycleCount -= 80;
                MC68060.irpFline();
            }
        }
    }

    public static void irpFline() throws M68kException {
        MC68060.irpExceptionFormat0(44, XEiJ.regPC0);
    }

    public static void irpIllegal() throws M68kException {
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int irpAbcd(int n, int n2) {
        int n3;
        int n4 = XEiJ.regCCR >> 4;
        int n5 = n3 = (n & 0xFF) + (n2 & 0xFF) + n4;
        if (10 <= (n & 0xF) + (n2 & 0xF) + n4) {
            n5 += 6;
        }
        if (160 <= n5) {
            n5 += 96;
            XEiJ.regCCR |= 0x11;
        } else {
            XEiJ.regCCR &= 0xFFFFFFEE;
        }
        if ((n5 &= 0xFF) != 0) {
            XEiJ.regCCR &= 0xFFFFFFFB;
        }
        return n5;
    }

    public static int irpSbcd(int n, int n2) {
        int n3;
        int n4 = XEiJ.regCCR >> 4;
        int n5 = n3 = (n & 0xFF) - (n2 & 0xFF) - n4;
        if ((n & 0xF) - (n2 & 0xF) - n4 < 0) {
            n5 -= 6;
        }
        if (n5 < 0) {
            if (n3 < 0) {
                n5 -= 96;
            }
            XEiJ.regCCR |= 0x11;
        } else {
            XEiJ.regCCR &= 0xFFFFFFEE;
        }
        if ((n5 &= 0xFF) != 0) {
            XEiJ.regCCR &= 0xFFFFFFFB;
        }
        return n5;
    }

    public static void irpEmx() throws M68kException {
        switch (XEiJ.regOC & 0x3F) {
            case 0: {
                XEiJ.mpuCycleCount += 19;
                if (!HFS.hfsIPLBoot()) break;
                MC68060.irpSetPC(26624);
                break;
            }
            case 1: {
                XEiJ.mpuCycleCount += 19;
                HFS.hfsInstall();
                break;
            }
            case 2: {
                XEiJ.mpuCycleCount += 19;
                HFS.hfsStrategy();
                break;
            }
            case 3: {
                XEiJ.mpuCycleCount += 19;
                if (!HFS.hfsInterrupt()) break;
                XEiJ.mpuTraceFlag = 0;
                XEiJ.regPC = XEiJ.regPC0;
                XEiJ.mpuClockTime += 4000000L;
                XEiJ.mpuLastNano += 4000L;
                break;
            }
            case 4: {
                XEiJ.emxNop();
                break;
            }
            case 5: {
                WaitInstruction.execute();
                break;
            }
            default: {
                M68kException.m6eNumber = 4;
                throw M68kException.m6eSignal;
            }
        }
    }

    public static void irpSetPC(int n) throws M68kException {
        if ((n & 1) != 0) {
            M68kException.m6eNumber = 3;
            m60Address = n & 0xFFFFFFFE;
            M68kException.m6eDirection = 1;
            M68kException.m6eSize = 2;
            throw M68kException.m6eSignal;
        }
        BranchLog.blgJump(n);
    }

    public static void irpSetSR(int n) {
        int n2;
        XEiJ.regSRT1 = 0x8000 & n;
        XEiJ.regSRM = 0x1000 & n;
        XEiJ.regSRS = 0x2000 & n;
        if (XEiJ.regSRS == 0) {
            XEiJ.mpuISP = XEiJ.regRn[15];
            XEiJ.regRn[15] = XEiJ.mpuUSP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpUserMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1UserMap;
        }
        if ((n2 = (XEiJ.mpuIMR = 127 >> ((XEiJ.regSRI = 0x700 & n) >> 8)) & XEiJ.mpuISR) != 0) {
            XEiJ.mpuISR ^= n2;
            if (n2 == 2) {
                MC68901.mfpDone();
            } else if (n2 == 16) {
                HD63450.dmaDone();
            } else if (n2 == 4) {
                Z8530.sccDone();
            } else if (n2 == 64) {
                IOInterrupt.ioiDone();
            } else if (n2 == 32) {
                XEiJ.eb2Done();
            } else {
                if ((n2 & 2) != 0) {
                    MC68901.mfpDone();
                }
                if (n2 << 27 < 0) {
                    HD63450.dmaDone();
                }
                if (n2 << 29 < 0) {
                    Z8530.sccDone();
                }
                if (n2 << 25 < 0) {
                    IOInterrupt.ioiDone();
                }
                if (n2 << 26 < 0) {
                    XEiJ.eb2Done();
                }
                if ((n2 & 1) != 0) {
                    XEiJ.sysDone();
                }
            }
        }
        XEiJ.mpuIMR |= ~XEiJ.mpuISR & 1;
        XEiJ.regCCR = 0x1F & n;
    }

    public static void irpInterrupt(int n, int n2) throws M68kException {
        int n3;
        if (XEiJ.regOC == 20082) {
            XEiJ.regPC = XEiJ.regPC0 + 4;
        }
        XEiJ.mpuClockTime += XEiJ.mpuModifiedUnit * 19L;
        int n4 = XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        XEiJ.regSRI = n2 << 8;
        XEiJ.mpuIMR = 127 >> n2;
        XEiJ.mpuISR |= 128 >> n2;
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS != 0) {
            n3 = XEiJ.regRn[15];
        } else {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = XEiJ.regRn[15];
            n3 = XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n3 -= 8;
        MC68060.mmuWriteWordData(n3 + 6, n, 1);
        MC68060.mmuWriteLongData(n3 + 2, XEiJ.regPC, 1);
        MC68060.mmuWriteWordData(n3, n4, 1);
        XEiJ.regSRM = 0;
        XEiJ.regPC0 = XEiJ.regPC;
        MC68060.irpSetPC(MC68060.mmuReadLongFour(XEiJ.mpuVBR + n, 1));
    }

    public static void irpExceptionFormat0(int n, int n2) throws M68kException {
        int n3;
        XEiJ.mpuCycleCount += 19;
        int n4 = XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS != 0) {
            n3 = XEiJ.regRn[15];
        } else {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = XEiJ.regRn[15];
            n3 = XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n3 -= 8;
        MC68060.mmuWriteWordData(n3 + 6, n, 1);
        MC68060.mmuWriteLongData(n3 + 2, n2, 1);
        MC68060.mmuWriteWordData(n3, n4, 1);
        MC68060.irpSetPC(MC68060.mmuReadLongFour(XEiJ.mpuVBR + n, 1));
    }

    public static void irpExceptionFormat2(int n, int n2, int n3) throws M68kException {
        int n4;
        XEiJ.mpuCycleCount += 19;
        int n5 = XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS != 0) {
            n4 = XEiJ.regRn[15];
        } else {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = XEiJ.regRn[15];
            n4 = XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n4 -= 12;
        MC68060.mmuWriteLongData(n4 + 8, n3, 1);
        MC68060.mmuWriteWordData(n4 + 6, 0x2000 | n, 1);
        MC68060.mmuWriteLongData(n4 + 2, n2, 1);
        MC68060.mmuWriteWordData(n4, n5, 1);
        MC68060.irpSetPC(MC68060.mmuReadLongFour(XEiJ.mpuVBR + n, 1));
    }

    public static void irpExceptionFormat3(int n, int n2, int n3) throws M68kException {
        int n4;
        XEiJ.mpuCycleCount += 19;
        int n5 = XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRM | XEiJ.regSRI | XEiJ.regCCR;
        XEiJ.mpuTraceFlag = 0;
        XEiJ.regSRT1 = 0;
        if (XEiJ.regSRS != 0) {
            n4 = XEiJ.regRn[15];
        } else {
            XEiJ.regSRS = 8192;
            XEiJ.mpuUSP = XEiJ.regRn[15];
            n4 = XEiJ.mpuISP;
            DataBreakPoint.dbpMemoryMap = DataBreakPoint.dbpSuperMap;
            InstructionBreakPoint.ibpOp1MemoryMap = InstructionBreakPoint.ibpOp1SuperMap;
        }
        XEiJ.regRn[15] = n4 -= 12;
        MC68060.mmuWriteLongData(n4 + 8, n3, 1);
        MC68060.mmuWriteWordData(n4 + 6, 0x3000 | n, 1);
        MC68060.mmuWriteLongData(n4 + 2, n2, 1);
        MC68060.mmuWriteWordData(n4, n5, 1);
        MC68060.irpSetPC(MC68060.mmuReadLongFour(XEiJ.mpuVBR + n, 1));
    }

    public static int efaMemByte(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                m60Address = XEiJ.regRn[n - 8];
                return m60Address;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                m60Incremented += 1L << (n - 24 << 3);
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2];
                XEiJ.regRn[n2] = n3 + 1;
                m60Address = n3;
                return n3;
            }
            case 31: {
                m60Incremented += 0x200000000000000L;
                XEiJ.regRn[15] = XEiJ.regRn[15] + 2;
                m60Address = XEiJ.regRn[15] - 2;
                return m60Address;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                m60Incremented -= 1L << (n - 32 << 3);
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 1;
                XEiJ.regRn[n4] = n5;
                m60Address = n5;
                return n5;
            }
            case 39: {
                m60Incremented -= 0x200000000000000L;
                m60Address = XEiJ.regRn[15] = XEiJ.regRn[15] - 2;
                return XEiJ.regRn[15];
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: {
                int n6 = n == 58 ? XEiJ.regPC : XEiJ.regRn[n - 32];
                m60Address = n6 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: {
                int n7;
                int n8;
                int n9 = n == 59 ? XEiJ.regPC : XEiJ.regRn[n - 40];
                int n10 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                if ((0x100 & n10) == 0) {
                    m60Address = n9 + (byte)n10 + (((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                    return m60Address;
                }
                XEiJ.mpuCycleCount += (3 & n10) == 0 ? 1 : 3;
                n9 = ((0x80 & n10) != 0 ? 0 : n9) + ((0x20 & n10) == 0 ? 0 : ((0x10 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                int n11 = (0x40 & n10) != 0 ? 0 : (n8 = ((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                if ((3 & n10) == 0) {
                    n7 = n9 + n8;
                } else {
                    int n12;
                    if ((4 & n10) == 0) {
                        m60Address = n9 + n8;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                    } else {
                        m60Address = n9;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                    }
                    n7 = n12 + ((2 & n10) == 0 ? 0 : ((1 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                }
                m60Address = n7;
                return n7;
            }
            case 56: {
                m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 57: {
                m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                return m60Address;
            }
            case 60: {
                Thread.dumpStack();
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemWord(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                m60Address = XEiJ.regRn[n - 8];
                return m60Address;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                m60Incremented += 2L << (n - 24 << 3);
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 2;
                XEiJ.regRn[n2] = n3;
                m60Address = n3 - 2;
                return m60Address;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                m60Incremented -= 2L << (n - 32 << 3);
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 2;
                XEiJ.regRn[n4] = n5;
                m60Address = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: {
                int n6 = n == 58 ? XEiJ.regPC : XEiJ.regRn[n - 32];
                m60Address = n6 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: {
                int n7;
                int n8;
                int n9 = n == 59 ? XEiJ.regPC : XEiJ.regRn[n - 40];
                int n10 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                if ((0x100 & n10) == 0) {
                    m60Address = n9 + (byte)n10 + (((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                    return m60Address;
                }
                XEiJ.mpuCycleCount += (3 & n10) == 0 ? 1 : 3;
                n9 = ((0x80 & n10) != 0 ? 0 : n9) + ((0x20 & n10) == 0 ? 0 : ((0x10 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                int n11 = (0x40 & n10) != 0 ? 0 : (n8 = ((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                if ((3 & n10) == 0) {
                    n7 = n9 + n8;
                } else {
                    int n12;
                    if ((4 & n10) == 0) {
                        m60Address = n9 + n8;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                    } else {
                        m60Address = n9;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                    }
                    n7 = n12 + ((2 & n10) == 0 ? 0 : ((1 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                }
                m60Address = n7;
                return n7;
            }
            case 56: {
                m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 57: {
                m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                return m60Address;
            }
            case 60: {
                Thread.dumpStack();
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemLong(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                m60Address = XEiJ.regRn[n - 8];
                return m60Address;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                m60Incremented += 4L << (n - 24 << 3);
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 4;
                XEiJ.regRn[n2] = n3;
                m60Address = n3 - 4;
                return m60Address;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                m60Incremented -= 4L << (n - 32 << 3);
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 4;
                XEiJ.regRn[n4] = n5;
                m60Address = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: {
                int n6 = n == 58 ? XEiJ.regPC : XEiJ.regRn[n - 32];
                m60Address = n6 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: {
                int n7;
                int n8;
                int n9 = n == 59 ? XEiJ.regPC : XEiJ.regRn[n - 40];
                int n10 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                if ((0x100 & n10) == 0) {
                    m60Address = n9 + (byte)n10 + (((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                    return m60Address;
                }
                XEiJ.mpuCycleCount += (3 & n10) == 0 ? 1 : 3;
                n9 = ((0x80 & n10) != 0 ? 0 : n9) + ((0x20 & n10) == 0 ? 0 : ((0x10 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                int n11 = (0x40 & n10) != 0 ? 0 : (n8 = ((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                if ((3 & n10) == 0) {
                    n7 = n9 + n8;
                } else {
                    int n12;
                    if ((4 & n10) == 0) {
                        m60Address = n9 + n8;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                    } else {
                        m60Address = n9;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                    }
                    n7 = n12 + ((2 & n10) == 0 ? 0 : ((1 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                }
                m60Address = n7;
                return n7;
            }
            case 56: {
                m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 57: {
                m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                return m60Address;
            }
            case 60: {
                Thread.dumpStack();
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemQuad(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                m60Address = XEiJ.regRn[n - 8];
                return m60Address;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                m60Incremented += 8L << (n - 24 << 3);
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 8;
                XEiJ.regRn[n2] = n3;
                m60Address = n3 - 8;
                return m60Address;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                m60Incremented -= 8L << (n - 32 << 3);
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 8;
                XEiJ.regRn[n4] = n5;
                m60Address = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: {
                int n6 = n == 58 ? XEiJ.regPC : XEiJ.regRn[n - 32];
                m60Address = n6 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: {
                int n7;
                int n8;
                int n9 = n == 59 ? XEiJ.regPC : XEiJ.regRn[n - 40];
                int n10 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                if ((0x100 & n10) == 0) {
                    m60Address = n9 + (byte)n10 + (((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                    return m60Address;
                }
                XEiJ.mpuCycleCount += (3 & n10) == 0 ? 1 : 3;
                n9 = ((0x80 & n10) != 0 ? 0 : n9) + ((0x20 & n10) == 0 ? 0 : ((0x10 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                int n11 = (0x40 & n10) != 0 ? 0 : (n8 = ((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                if ((3 & n10) == 0) {
                    n7 = n9 + n8;
                } else {
                    int n12;
                    if ((4 & n10) == 0) {
                        m60Address = n9 + n8;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                    } else {
                        m60Address = n9;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                    }
                    n7 = n12 + ((2 & n10) == 0 ? 0 : ((1 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                }
                m60Address = n7;
                return n7;
            }
            case 56: {
                m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 57: {
                m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                return m60Address;
            }
            case 60: {
                Thread.dumpStack();
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMemExtd(int n) throws M68kException {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                m60Address = XEiJ.regRn[n - 8];
                return m60Address;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                m60Incremented += 12L << (n - 24 << 3);
                int n2 = n - 16;
                int n3 = XEiJ.regRn[n2] + 12;
                XEiJ.regRn[n2] = n3;
                m60Address = n3 - 12;
                return m60Address;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                m60Incremented -= 12L << (n - 32 << 3);
                int n4 = n - 24;
                int n5 = XEiJ.regRn[n4] - 12;
                XEiJ.regRn[n4] = n5;
                m60Address = n5;
                return n5;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: {
                int n6 = n == 58 ? XEiJ.regPC : XEiJ.regRn[n - 32];
                m60Address = n6 + MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: {
                int n7;
                int n8;
                int n9 = n == 59 ? XEiJ.regPC : XEiJ.regRn[n - 40];
                int n10 = MC68060.mmuReadWordZeroExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                if ((0x100 & n10) == 0) {
                    m60Address = n9 + (byte)n10 + (((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                    return m60Address;
                }
                XEiJ.mpuCycleCount += (3 & n10) == 0 ? 1 : 3;
                n9 = ((0x80 & n10) != 0 ? 0 : n9) + ((0x20 & n10) == 0 ? 0 : ((0x10 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                int n11 = (0x40 & n10) != 0 ? 0 : (n8 = ((0x800 & n10) == 0 ? (int)XEiJ.regRn[n10 >> 12] : XEiJ.regRn[n10 >> 12]) << ((0x600 & n10) >> 9));
                if ((3 & n10) == 0) {
                    n7 = n9 + n8;
                } else {
                    int n12;
                    if ((4 & n10) == 0) {
                        m60Address = n9 + n8;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS);
                    } else {
                        m60Address = n9;
                        n12 = MC68060.mmuReadLongData(m60Address, XEiJ.regSRS) + n8;
                    }
                    n7 = n12 + ((2 & n10) == 0 ? 0 : ((1 & n10) == 0 ? MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS) : MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS)));
                }
                m60Address = n7;
                return n7;
            }
            case 56: {
                m60Address = MC68060.mmuReadWordSignExword((XEiJ.regPC += 2) - 2, XEiJ.regSRS);
                return m60Address;
            }
            case 57: {
                m60Address = MC68060.mmuReadLongExword((XEiJ.regPC += 4) - 4, XEiJ.regSRS);
                return m60Address;
            }
            case 60: {
                Thread.dumpStack();
            }
        }
        M68kException.m6eNumber = 4;
        throw M68kException.m6eSignal;
    }

    public static int efaMltByte(int n) throws M68kException {
        return MC68060.efaMemByte((0x3FFFFFFFFFF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaMltWord(int n) throws M68kException {
        return MC68060.efaMemWord((0x3FFFFFFFFFF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaMltLong(int n) throws M68kException {
        return MC68060.efaMemLong((0x3FFFFFFFFFF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaMltQuad(int n) throws M68kException {
        return MC68060.efaMemQuad((0x3FFFFFFFFFF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaMltExtd(int n) throws M68kException {
        return MC68060.efaMemExtd((0x3FFFFFFFFFF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCntByte(int n) throws M68kException {
        return MC68060.efaMemByte((0xFFFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCntWord(int n) throws M68kException {
        return MC68060.efaMemWord((0xFFFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCntLong(int n) throws M68kException {
        return MC68060.efaMemLong((0xFFFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCntQuad(int n) throws M68kException {
        return MC68060.efaMemQuad((0xFFFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCntExtd(int n) throws M68kException {
        return MC68060.efaMemExtd((0xFFFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCltByte(int n) throws M68kException {
        return MC68060.efaMemByte((0x3FFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCltWord(int n) throws M68kException {
        return MC68060.efaMemWord((0x3FFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCltLong(int n) throws M68kException {
        return MC68060.efaMemLong((0x3FFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCltQuad(int n) throws M68kException {
        return MC68060.efaMemQuad((0x3FFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaCltExtd(int n) throws M68kException {
        return MC68060.efaMemExtd((0x3FFFF0000FF0000L & 1L << n) == 0L ? 0 : n);
    }

    public static int efaAnyByte(int n) throws M68kException {
        return MC68060.efaMemByte(n);
    }

    public static int efaAnyWord(int n) throws M68kException {
        return MC68060.efaMemWord(n);
    }

    public static int efaAnyLong(int n) throws M68kException {
        return MC68060.efaMemLong(n);
    }

    public static int efaAnyQuad(int n) throws M68kException {
        return MC68060.efaMemQuad(n);
    }

    public static int efaAnyExtd(int n) throws M68kException {
        return MC68060.efaMemExtd(n);
    }

    public static int efaLeaPea(int n) throws M68kException {
        return MC68060.efaCntLong(n);
    }

    public static int efaJmpJsr(int n) throws M68kException {
        return MC68060.efaCntLong(n);
    }

    public static void fpkSTOL() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteZeroData(n, 1);
        while (n2 == 32 || n2 == 9) {
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        }
        int n3 = 55;
        if (n2 == 45) {
            n3 = 56;
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        } else if (n2 == 43) {
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        }
        if (48 > n2 || n2 > 57) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n4 = n2 - 48;
        n2 = MC68060.mmuReadByteZeroData(++n, 1);
        while (48 <= n2 && n2 <= 57) {
            if (0xCCCCCCC < n4 || n4 == 0xCCCCCCC && n3 < n2) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n4 = n4 * 10 + (n2 - 48);
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        }
        if (n3 != 55) {
            n4 = -n4;
        }
        XEiJ.regRn[0] = n4;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkLTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8];
        if (n < 0) {
            MC68060.mmuWriteByteData(n2++, 45, 1);
            n = -n;
        }
        long l = XEiJ.fmtBcd12(0xFFFFFFFFL & (long)n);
        XEiJ.regRn[8] = n2 += Math.max(1, 67 - Long.numberOfLeadingZeros(l) >> 2);
        MC68060.mmuWriteByteData(n2, 0, 1);
        do {
            MC68060.mmuWriteByteData(--n2, 0x30 | (int)l & 0xF, 1);
        } while ((l >>>= 4) != 0L);
    }

    public static void fpkSTOH() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteZeroData(n, 1);
        if (!(48 <= n2 && n2 <= 57 || 65 <= n2 && n2 <= 70 || 97 <= n2 && n2 <= 102)) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n3 = n2 <= 57 ? n2 - 48 : (n2 <= 70 ? n2 - 55 : n2 - 87);
        n2 = MC68060.mmuReadByteZeroData(++n, 1);
        while (48 <= n2 && n2 <= 57 || 65 <= n2 && n2 <= 70 || 97 <= n2 && n2 <= 102) {
            if (0xFFFFFFF < n3) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n3 = n3 << 4 | (n2 <= 57 ? n2 - 48 : (n2 <= 70 ? n2 - 55 : n2 - 87));
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        }
        XEiJ.regRn[0] = n3;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkHTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8] = XEiJ.regRn[8] + Math.max(1, 35 - Integer.numberOfLeadingZeros(n) >> 2);
        MC68060.mmuWriteByteData(n2, 0, 1);
        do {
            int n3 = n & 0xF;
            MC68060.mmuWriteByteData(--n2, (9 - n3 >> 4 & 7 | 0x30) + n3, 1);
        } while ((n >>>= 4) != 0);
    }

    public static void fpkSTOO() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteZeroData(n, 1);
        if (48 > n2 || n2 > 55) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n3 = n2 - 48;
        n2 = MC68060.mmuReadByteZeroData(++n, 1);
        while (48 <= n2 && n2 <= 55) {
            if (0x1FFFFFFF < n3) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n3 = n3 << 3 | n2 & 7;
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        }
        XEiJ.regRn[0] = n3;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkOTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8] = XEiJ.regRn[8] + Math.max(1, (34 - Integer.numberOfLeadingZeros(n)) * 43 >>> 7);
        MC68060.mmuWriteByteData(n2, 0, 1);
        do {
            MC68060.mmuWriteByteData(--n2, 0x30 | n & 7, 1);
        } while ((n >>>= 3) != 0);
    }

    public static void fpkSTOB() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteZeroData(n, 1);
        if (48 > n2 || n2 > 49) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return;
        }
        int n3 = n2 - 48;
        n2 = MC68060.mmuReadByteZeroData(++n, 1);
        while (48 <= n2 && n2 <= 49) {
            if (n3 < 0) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 3;
                return;
            }
            n3 = n3 << 1 | n2 & 1;
            n2 = MC68060.mmuReadByteZeroData(++n, 1);
        }
        XEiJ.regRn[0] = n3;
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
    }

    public static void fpkBTOS() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = XEiJ.regRn[8] = XEiJ.regRn[8] + Math.max(1, 32 - Integer.numberOfLeadingZeros(n));
        MC68060.mmuWriteByteData(n2, 0, 1);
        do {
            MC68060.mmuWriteByteData(--n2, 0x30 | n & 1, 1);
        } while ((n >>>= 1) != 0);
    }

    public static void fpkIUSING() throws M68kException {
        int n = XEiJ.regRn[0];
        int n2 = 0;
        if (n < 0) {
            n2 = 1;
            n = -n;
        }
        long l = XEiJ.fmtBcd12(0xFFFFFFFFL & (long)n);
        int n3 = n2 + Math.max(1, 67 - Long.numberOfLeadingZeros(l) >> 2);
        int n4 = XEiJ.regRn[8];
        for (int i = (XEiJ.regRn[1] & 0xFF) - n3; i > 0; --i) {
            MC68060.mmuWriteByteData(n4++, 32, 1);
        }
        XEiJ.regRn[8] = n4 += n3;
        MC68060.mmuWriteByteData(n4, 0, 1);
        do {
            MC68060.mmuWriteByteData(--n4, 0x30 | (int)l & 0xF, 1);
        } while ((l >>>= 4) != 0L);
        if (n2 != 0) {
            MC68060.mmuWriteByteData(--n4, 45, 1);
        }
    }

    public static void fpkVAL() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteSignData(n++, 1);
        while (n2 == 32 || n2 == 9) {
            n2 = MC68060.mmuReadByteSignData(n++, 1);
        }
        if (n2 == 38) {
            n2 = MC68060.mmuReadByteSignData(n++, 1) & 0xDF;
            XEiJ.regRn[8] = n;
            if (n2 == 66) {
                MC68060.fpkSTOB();
                FEFunction.fpkLTOD();
            } else if (n2 == 79) {
                MC68060.fpkSTOO();
                FEFunction.fpkLTOD();
            } else if (n2 == 72) {
                MC68060.fpkSTOH();
                FEFunction.fpkLTOD();
            } else {
                XEiJ.regCCR = 9;
            }
        } else {
            MC68060.fpkSTOD();
        }
    }

    public static void fpkUSING() throws M68kException {
        MC68060.fpkUSINGSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkUSINGSub(long l) throws M68kException {
        int n;
        int n2;
        int n3;
        int n4 = Math.max(0, XEiJ.regRn[2]);
        int n5 = Math.max(0, XEiJ.regRn[3]);
        int n6 = XEiJ.regRn[4];
        int n7 = XEiJ.regRn[8];
        boolean bl = (n6 & 8) != 0;
        int n8 = (n6 & 1) != 0 ? 42 : 32;
        int n9 = (n6 & 2) != 0 ? 92 : 0;
        int n10 = !bl && (n6 & 4) != 0 ? 44 : 0;
        int n11 = 0;
        int n12 = 0;
        if (l < 0L) {
            if ((n6 & 0x60) == 0) {
                n11 = 45;
            } else {
                n12 = 45;
            }
            l &= Long.MAX_VALUE;
        } else if ((n6 & 0x10) != 0) {
            n11 = 43;
        } else if ((n6 & 0x30) == 32) {
            n12 = 43;
        } else if ((n6 & 0x70) == 64) {
            n12 = 32;
        }
        double d = Double.longBitsToDouble(l);
        int n13 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n13 == -1023) {
            if (l == 0L) {
                for (int i = n4 - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + 1); 0 < i; --i) {
                    MC68060.mmuWriteByteData(n7++, n8, 1);
                }
                if (n11 != 0) {
                    MC68060.mmuWriteByteData(n7++, n11, 1);
                }
                if (n9 != 0) {
                    MC68060.mmuWriteByteData(n7++, n9, 1);
                }
                if (0 < n4) {
                    MC68060.mmuWriteByteData(n7++, 48, 1);
                }
                MC68060.mmuWriteByteData(n7++, 46, 1);
                while (0 < n5) {
                    MC68060.mmuWriteByteData(n7++, 48, 1);
                    --n5;
                }
                MC68060.mmuWriteByteData(n7, 0, 1);
                return;
            }
            n13 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n13 == 1024) {
            for (int i = n4 + 1 + n5 + (bl ? 5 : 0) - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + 4); 0 < i; --i) {
                MC68060.mmuWriteByteData(n7++, n8, 1);
            }
            if (n11 != 0) {
                MC68060.mmuWriteByteData(n7++, n11, 1);
            }
            if (n9 != 0) {
                MC68060.mmuWriteByteData(n7++, n9, 1);
            }
            MC68060.mmuWriteByteData(n7++, 35, 1);
            if (l == 0L) {
                MC68060.mmuWriteByteData(n7++, 73, 1);
                MC68060.mmuWriteByteData(n7++, 78, 1);
                MC68060.mmuWriteByteData(n7++, 70, 1);
            } else {
                MC68060.mmuWriteByteData(n7++, 78, 1);
                MC68060.mmuWriteByteData(n7++, 65, 1);
                MC68060.mmuWriteByteData(n7++, 78, 1);
            }
            MC68060.mmuWriteByteData(n7, 0, 1);
            return;
        }
        n13 = (int)Math.floor((double)n13 * 0.3010299956639812);
        if (0 < n13) {
            d *= FEFunction.FPK_TEN_M16QR[n13 & 0xF];
            if (16 <= n13) {
                d *= FEFunction.FPK_TEN_M16QR[16 + (n13 >> 4 & 0xF)];
                if (256 <= n13) {
                    d *= FEFunction.FPK_TEN_M16QR[33];
                }
            }
        } else if (n13 < 0) {
            d *= FEFunction.FPK_TEN_P16QR[-n13 & 0xF];
            if (n13 <= -16) {
                d *= FEFunction.FPK_TEN_P16QR[16 + (-n13 >> 4 & 0xF)];
                if (n13 <= -256) {
                    d *= FEFunction.FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n14 = (int)d;
        int n15 = XEiJ.FMT_BCD4[n14];
        nArray[0] = n15 >> 4;
        nArray[1] = n15 & 0xF;
        for (n3 = 2; n3 < 18; n3 += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n14) * 10000.0 + (d - d2) * 10000.0;
            n14 = (int)d;
            n15 = XEiJ.FMT_BCD4[n14];
            nArray[n3] = n15 >> 12;
            nArray[n3 + 1] = n15 >> 8 & 0xF;
            nArray[n3 + 2] = n15 >> 4 & 0xF;
            nArray[n3 + 3] = n15 & 0xF;
        }
        n14 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n15 = n14 + 14;
        if (5 <= nArray[n15]) {
            n3 = n15;
            while (true) {
                int n16 = --n3;
                nArray[n16] = nArray[n16] + 1;
                if (10 > nArray[n16]) break;
                nArray[n3] = 0;
            }
            if (n3 < n14) {
                --n14;
                --n15;
            }
        }
        if ((n2 = n14 + (n3 = !bl ? (n13 -= n14 - 1) : Math.max(0, n11 != 0 || n12 != 0 ? n4 : n4 - 1) - 1) + 1 + n5) < n15 && 0 <= (n15 = n2) && 5 <= nArray[n15]) {
            n = n15;
            while (true) {
                int n17 = --n;
                nArray[n17] = nArray[n17] + 1;
                if (10 > nArray[n17]) break;
                nArray[n] = 0;
            }
            if (n < n14) {
                --n14;
                if (!bl) {
                    ++n3;
                } else {
                    ++n13;
                    --n15;
                }
            }
        }
        if (0 <= n3) {
            for (n = n4 - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + (n10 != 0 ? n3 / 3 : 0) + n3 + 1); 0 < n; --n) {
                MC68060.mmuWriteByteData(n7++, n8, 1);
            }
            if (n11 != 0) {
                MC68060.mmuWriteByteData(n7++, n11, 1);
            }
            if (n9 != 0) {
                MC68060.mmuWriteByteData(n7++, n9, 1);
            }
            for (n = n3; 0 <= n; --n) {
                MC68060.mmuWriteByteData(n7++, n14 < n15 ? 48 + nArray[n14] : 48, 1);
                ++n14;
                if (n10 == 0 || 0 >= n || n % 3 != 0) continue;
                MC68060.mmuWriteByteData(n7++, n10, 1);
            }
            MC68060.mmuWriteByteData(n7++, 46, 1);
            while (0 < n5) {
                MC68060.mmuWriteByteData(n7++, n14 < n15 ? 48 + nArray[n14] : 48, 1);
                ++n14;
                --n5;
            }
        } else {
            for (n = n4 - ((n11 != 0 ? 1 : 0) + (n9 != 0 ? 1 : 0) + 1); 0 < n; --n) {
                MC68060.mmuWriteByteData(n7++, n8, 1);
            }
            if (n11 != 0) {
                MC68060.mmuWriteByteData(n7++, n11, 1);
            }
            if (n9 != 0) {
                MC68060.mmuWriteByteData(n7++, n9, 1);
            }
            if (0 < n4) {
                MC68060.mmuWriteByteData(n7++, 48, 1);
            }
            MC68060.mmuWriteByteData(n7++, 46, 1);
            for (n = -1 - n3; 0 < n5 && 0 < n; --n5, --n) {
                MC68060.mmuWriteByteData(n7++, 48, 1);
            }
            while (0 < n5) {
                MC68060.mmuWriteByteData(n7++, n14 < n15 ? 48 + nArray[n14] : 48, 1);
                ++n14;
                --n5;
            }
        }
        if (bl) {
            MC68060.mmuWriteByteData(n7++, 69, 1);
            if (0 <= (n13 -= n3)) {
                MC68060.mmuWriteByteData(n7++, 43, 1);
            } else {
                MC68060.mmuWriteByteData(n7++, 45, 1);
                n13 = -n13;
            }
            n13 = XEiJ.FMT_BCD4[n13];
            MC68060.mmuWriteByteData(n7++, 48 + (n13 >> 8), 1);
            MC68060.mmuWriteByteData(n7++, 48 + (n13 >> 4 & 0xF), 1);
            MC68060.mmuWriteByteData(n7++, 48 + (n13 & 0xF), 1);
        }
        if (n12 != 0) {
            MC68060.mmuWriteByteData(n7++, n12, 1);
        }
        MC68060.mmuWriteByteData(n7, 0, 1);
    }

    public static void fpkSTOD() throws M68kException {
        long l = Double.doubleToLongBits(MC68060.fpkSTODSub());
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        XEiJ.regRn[0] = (int)(l >> 32);
        XEiJ.regRn[1] = (int)l;
    }

    public static double fpkSTODSub() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteSignData(n, 1);
        while (n2 == 32 || n2 == 9) {
            n2 = MC68060.mmuReadByteSignData(++n, 1);
        }
        double d = 1.0;
        if (n2 == 43) {
            n2 = MC68060.mmuReadByteSignData(++n, 1);
        } else if (n2 == 45) {
            d = -d;
            n2 = MC68060.mmuReadByteSignData(++n, 1);
        }
        if (n2 == 35) {
            n2 = MC68060.mmuReadByteSignData(n + 1, 1);
            if (!(n2 != 78 && n2 != 73 || (n2 = n2 << 8 | MC68060.mmuReadByteZeroData(n + 2, 1)) != 20033 && n2 != 18766 || (n2 = n2 << 8 | MC68060.mmuReadByteZeroData(n + 3, 1)) != 0x4E414E && n2 != 4804166)) {
                XEiJ.regRn[2] = 0;
                XEiJ.regRn[3] = 0;
                XEiJ.regRn[8] = n + 4;
                XEiJ.regCCR = 0;
                return n2 == 0x4E414E ? Double.NaN : d * Double.POSITIVE_INFINITY;
            }
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return 0.0;
        }
        long l = 0L;
        int n3 = 0;
        int n4 = 1;
        if (n2 == 46) {
            n4 = 0;
            n2 = MC68060.mmuReadByteSignData(++n, 1);
        }
        if (n2 < 48 || 57 < n2) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 9;
            return 0.0;
        }
        double d2 = 0.0;
        do {
            if (0 < n3 || 48 < n2) {
                ++n3;
            }
            if (n4 <= 0 && n3 <= 18) {
                --n4;
            }
            if (0 < n3 && n3 <= 18) {
                l = l * 10L + (long)(n2 - 48);
            }
            n2 = MC68060.mmuReadByteSignData(++n, 1);
            if (0 >= n4 || n2 != 46) continue;
            n4 = 0;
            n2 = MC68060.mmuReadByteSignData(++n, 1);
        } while (48 <= n2 && n2 <= 57);
        if (0 < n4) {
            int n5 = n4 = 18 < n3 ? n3 - 18 : 0;
        }
        if (n2 == 69 || n2 == 101) {
            n2 = MC68060.mmuReadByteSignData(++n, 1);
            int n6 = 1;
            if (n2 == 43) {
                n2 = MC68060.mmuReadByteSignData(++n, 1);
            } else if (n2 == 45) {
                n6 = -n6;
                n2 = MC68060.mmuReadByteSignData(++n, 1);
            }
            if (n2 < 48 || 57 < n2) {
                XEiJ.regRn[8] = n;
                XEiJ.regCCR = 9;
                return 0.0;
            }
            while (n2 == 48) {
                n2 = MC68060.mmuReadByteSignData(++n, 1);
            }
            int n7 = 0;
            for (int i = 0; 48 <= n2 && n2 <= 57 && i < 9; ++i) {
                n7 = n7 * 10 + (n2 - 48);
                n2 = MC68060.mmuReadByteSignData(++n, 1);
            }
            n4 += n6 * n7;
        }
        if (n4 < -350) {
            XEiJ.regRn[2] = 65535;
            XEiJ.regRn[3] = 0;
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 0;
            return d < 0.0 ? -0.0 : 0.0;
        }
        if (350 < n4) {
            XEiJ.regRn[2] = 0;
            XEiJ.regRn[3] = 0;
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 3;
            return d * Double.POSITIVE_INFINITY;
        }
        QFP qFP = new QFP(d < 0.0 ? -l : l);
        if (0 < n4) {
            qFP.mul(QFP.QFP_TEN_P16QR[n4 & 0xF]);
            if (16 <= n4) {
                qFP.mul(QFP.QFP_TEN_P16QR[16 + (n4 >> 4 & 0xF)]);
                if (256 <= n4) {
                    qFP.mul(QFP.QFP_TEN_P16QR[33]);
                }
            }
        } else if (n4 < 0) {
            qFP.mul(QFP.QFP_TEN_M16QR[-n4 & 0xF]);
            if (n4 <= -16) {
                qFP.mul(QFP.QFP_TEN_M16QR[16 + (-n4 >> 4 & 0xF)]);
                if (n4 <= -256) {
                    qFP.mul(QFP.QFP_TEN_M16QR[33]);
                }
            }
        }
        if (Double.isInfinite(d2 = qFP.getd())) {
            XEiJ.regRn[8] = n;
            XEiJ.regCCR = 3;
            return d2;
        }
        if (d2 == (double)((int)d2)) {
            XEiJ.regRn[2] = 65535;
            XEiJ.regRn[3] = (int)d2;
        } else {
            XEiJ.regRn[2] = 0;
            XEiJ.regRn[3] = 0;
        }
        XEiJ.regRn[8] = n;
        XEiJ.regCCR = 0;
        return d2;
    }

    public static void fpkDTOS() throws M68kException {
        MC68060.fpkDTOSSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkDTOSSub(long l) throws M68kException {
        int n;
        int n2 = XEiJ.regRn[8];
        if (l < 0L) {
            MC68060.mmuWriteByteData(n2++, 45, 1);
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n3 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n3 == -1023) {
            if (l == 0L) {
                MC68060.mmuWriteByteData(n2++, 48, 1);
                MC68060.mmuWriteByteData(n2, 0, 1);
                XEiJ.regRn[8] = n2;
                return;
            }
            n3 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n3 == 1024) {
            MC68060.mmuWriteByteData(n2++, 35, 1);
            if (l == 0L) {
                MC68060.mmuWriteByteData(n2++, 73, 1);
                MC68060.mmuWriteByteData(n2++, 78, 1);
                MC68060.mmuWriteByteData(n2++, 70, 1);
            } else {
                MC68060.mmuWriteByteData(n2++, 78, 1);
                MC68060.mmuWriteByteData(n2++, 65, 1);
                MC68060.mmuWriteByteData(n2++, 78, 1);
            }
            MC68060.mmuWriteByteData(n2, 0, 1);
            XEiJ.regRn[8] = n2;
            return;
        }
        n3 = (int)Math.floor((double)n3 * 0.3010299956639812);
        if (0 < n3) {
            d *= FEFunction.FPK_TEN_M16QR[n3 & 0xF];
            if (16 <= n3) {
                d *= FEFunction.FPK_TEN_M16QR[16 + (n3 >> 4 & 0xF)];
                if (256 <= n3) {
                    d *= FEFunction.FPK_TEN_M16QR[33];
                }
            }
        } else if (n3 < 0) {
            d *= FEFunction.FPK_TEN_P16QR[-n3 & 0xF];
            if (n3 <= -16) {
                d *= FEFunction.FPK_TEN_P16QR[16 + (-n3 >> 4 & 0xF)];
                if (n3 <= -256) {
                    d *= FEFunction.FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n4 = (int)d;
        int n5 = XEiJ.FMT_BCD4[n4];
        nArray[0] = n5 >> 4;
        nArray[1] = n5 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n4) * 10000.0 + (d - d2) * 10000.0;
            n4 = (int)d;
            n5 = XEiJ.FMT_BCD4[n4];
            nArray[n] = n5 >> 12;
            nArray[n + 1] = n5 >> 8 & 0xF;
            nArray[n + 2] = n5 >> 4 & 0xF;
            nArray[n + 3] = n5 & 0xF;
        }
        n4 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n5 = n4 + 14;
        if (5 <= nArray[n5]) {
            n = n5;
            while (true) {
                int n6 = --n;
                nArray[n6] = nArray[n6] + 1;
                if (10 > nArray[n6]) break;
                nArray[n] = 0;
            }
            if (n < n4) {
                --n4;
                --n5;
            }
        }
        n3 -= n4 - 1;
        while (nArray[n5 - 1] == 0) {
            --n5;
        }
        if (0 <= n3 && n3 < 14) {
            do {
                MC68060.mmuWriteByteData(n2++, 48 + nArray[n4++], 1);
            } while (0 <= --n3);
            if (n4 < n5) {
                MC68060.mmuWriteByteData(n2++, 46, 1);
                do {
                    MC68060.mmuWriteByteData(n2++, 48 + nArray[n4++], 1);
                } while (n4 < n5);
            }
        } else if (-4 <= n3 && n3 < 0) {
            MC68060.mmuWriteByteData(n2++, 48, 1);
            MC68060.mmuWriteByteData(n2++, 46, 1);
            while (++n3 < 0) {
                MC68060.mmuWriteByteData(n2++, 48, 1);
            }
            do {
                MC68060.mmuWriteByteData(n2++, 48 + nArray[n4++], 1);
            } while (n4 < n5);
        } else {
            MC68060.mmuWriteByteData(n2++, 48 + nArray[n4++], 1);
            if (n4 < n5) {
                MC68060.mmuWriteByteData(n2++, 46, 1);
                do {
                    MC68060.mmuWriteByteData(n2++, 48 + nArray[n4++], 1);
                } while (n4 < n5);
            }
            MC68060.mmuWriteByteData(n2++, 69, 1);
            if (0 <= n3) {
                MC68060.mmuWriteByteData(n2++, 43, 1);
            } else {
                MC68060.mmuWriteByteData(n2++, 45, 1);
                n3 = -n3;
            }
            n3 = XEiJ.FMT_BCD4[n3];
            MC68060.mmuWriteByteData(n2++, 48 + (n3 >> 8), 1);
            MC68060.mmuWriteByteData(n2++, 48 + (n3 >> 4 & 0xF), 1);
            MC68060.mmuWriteByteData(n2++, 48 + (n3 & 0xF), 1);
        }
        MC68060.mmuWriteByteData(n2, 0, 1);
        XEiJ.regRn[8] = n2;
    }

    public static void fpkECVT() throws M68kException {
        MC68060.fpkECVTSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkECVTSub(long l) throws M68kException {
        int n;
        int n2 = Math.max(0, XEiJ.regRn[2]);
        int n3 = XEiJ.regRn[8];
        int n4 = n3 + n2;
        if (0L <= l) {
            XEiJ.regRn[1] = 0;
        } else {
            XEiJ.regRn[1] = 1;
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n5 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n5 == -1023) {
            if (l == 0L) {
                while (n3 < n4) {
                    MC68060.mmuWriteByteData(n3++, 48, 1);
                }
                MC68060.mmuWriteByteData(n3, 0, 1);
                XEiJ.regRn[0] = 1;
                return;
            }
            n5 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n5 == 1024) {
            int n6;
            int n7 = n6 = l != 0L ? 1312902691 : 1179535651;
            while (n3 < n4 && n6 != 0) {
                MC68060.mmuWriteByteData(n3++, n6, 1);
                n6 >>>= 8;
            }
            while (n3 < n4) {
                MC68060.mmuWriteByteData(n3++, 0, 1);
            }
            MC68060.mmuWriteByteData(n3, 0, 1);
            XEiJ.regRn[0] = 4;
            return;
        }
        n5 = (int)Math.floor((double)n5 * 0.3010299956639812);
        if (0 < n5) {
            d *= FEFunction.FPK_TEN_M16QR[n5 & 0xF];
            if (16 <= n5) {
                d *= FEFunction.FPK_TEN_M16QR[16 + (n5 >> 4 & 0xF)];
                if (256 <= n5) {
                    d *= FEFunction.FPK_TEN_M16QR[33];
                }
            }
        } else if (n5 < 0) {
            d *= FEFunction.FPK_TEN_P16QR[-n5 & 0xF];
            if (n5 <= -16) {
                d *= FEFunction.FPK_TEN_P16QR[16 + (-n5 >> 4 & 0xF)];
                if (n5 <= -256) {
                    d *= FEFunction.FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n8 = (int)d;
        int n9 = XEiJ.FMT_BCD4[n8];
        nArray[0] = n9 >> 4;
        nArray[1] = n9 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n8) * 10000.0 + (d - d2) * 10000.0;
            n8 = (int)d;
            n9 = XEiJ.FMT_BCD4[n8];
            nArray[n] = n9 >> 12;
            nArray[n + 1] = n9 >> 8 & 0xF;
            nArray[n + 2] = n9 >> 4 & 0xF;
            nArray[n + 3] = n9 & 0xF;
        }
        n8 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n9 = n8 + 14;
        if (5 <= nArray[n9]) {
            n = n9;
            while (true) {
                int n10 = --n;
                nArray[n10] = nArray[n10] + 1;
                if (10 > nArray[n10]) break;
                nArray[n] = 0;
            }
            if (n < n8) {
                --n8;
                --n9;
            }
        }
        n5 -= n8 - 1;
        n = n8 + n2;
        if (n < n9 && 0 <= (n9 = n) && 5 <= nArray[n9]) {
            int n11 = n9;
            while (true) {
                int n12 = --n11;
                nArray[n12] = nArray[n12] + 1;
                if (10 > nArray[n12]) break;
                nArray[n11] = 0;
            }
            if (n11 < n8) {
                --n8;
                --n9;
                ++n5;
            }
        }
        while (n3 < n4 && n8 < n9) {
            MC68060.mmuWriteByteData(n3++, 48 + nArray[n8++], 1);
        }
        while (n3 < n4) {
            MC68060.mmuWriteByteData(n3++, 48, 1);
        }
        MC68060.mmuWriteByteData(n3, 0, 1);
        XEiJ.regRn[0] = n5 + 1;
    }

    public static void fpkFCVT() throws M68kException {
        MC68060.fpkFCVTSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkFCVTSub(long l) throws M68kException {
        int n;
        int n2 = Math.max(0, XEiJ.regRn[2]);
        int n3 = XEiJ.regRn[8];
        if (0L <= l) {
            XEiJ.regRn[1] = 0;
        } else {
            XEiJ.regRn[1] = 1;
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n4 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n4 == -1023) {
            if (l == 0L) {
                while (n2-- > 0) {
                    MC68060.mmuWriteByteData(n3++, 48, 1);
                }
                MC68060.mmuWriteByteData(n3, 0, 1);
                XEiJ.regRn[0] = 0;
                return;
            }
            n4 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n4 == 1024) {
            MC68060.mmuWriteByteData(n3++, 35, 1);
            if (l == 0L) {
                MC68060.mmuWriteByteData(n3++, 73, 1);
                MC68060.mmuWriteByteData(n3++, 78, 1);
                MC68060.mmuWriteByteData(n3++, 70, 1);
            } else {
                MC68060.mmuWriteByteData(n3++, 78, 1);
                MC68060.mmuWriteByteData(n3++, 65, 1);
                MC68060.mmuWriteByteData(n3++, 78, 1);
            }
            MC68060.mmuWriteByteData(n3, 0, 1);
            XEiJ.regRn[0] = 4;
            return;
        }
        n4 = (int)Math.floor((double)n4 * 0.3010299956639812);
        if (0 < n4) {
            d *= FEFunction.FPK_TEN_M16QR[n4 & 0xF];
            if (16 <= n4) {
                d *= FEFunction.FPK_TEN_M16QR[16 + (n4 >> 4 & 0xF)];
                if (256 <= n4) {
                    d *= FEFunction.FPK_TEN_M16QR[33];
                }
            }
        } else if (n4 < 0) {
            d *= FEFunction.FPK_TEN_P16QR[-n4 & 0xF];
            if (n4 <= -16) {
                d *= FEFunction.FPK_TEN_P16QR[16 + (-n4 >> 4 & 0xF)];
                if (n4 <= -256) {
                    d *= FEFunction.FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n5 = (int)d;
        int n6 = XEiJ.FMT_BCD4[n5];
        nArray[0] = n6 >> 4;
        nArray[1] = n6 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n5) * 10000.0 + (d - d2) * 10000.0;
            n5 = (int)d;
            n6 = XEiJ.FMT_BCD4[n5];
            nArray[n] = n6 >> 12;
            nArray[n + 1] = n6 >> 8 & 0xF;
            nArray[n + 2] = n6 >> 4 & 0xF;
            nArray[n + 3] = n6 & 0xF;
        }
        n5 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n6 = n5 + 14;
        if (5 <= nArray[n6]) {
            n = n6;
            while (true) {
                int n7 = --n;
                nArray[n7] = nArray[n7] + 1;
                if (10 > nArray[n7]) break;
                nArray[n] = 0;
            }
            if (n < n5) {
                --n5;
                --n6;
            }
        }
        if ((n = n5 + (n4 -= n5 - 1) + 1 + n2) < n6 && 0 <= (n6 = n) && 5 <= nArray[n6]) {
            int n8 = n6;
            while (true) {
                int n9 = --n8;
                nArray[n9] = nArray[n9] + 1;
                if (10 > nArray[n9]) break;
                nArray[n8] = 0;
            }
            if (n8 < n5) {
                --n5;
                --n6;
                ++n4;
            }
        }
        while (n5 < n6) {
            MC68060.mmuWriteByteData(n3++, 48 + nArray[n5++], 1);
        }
        while (n5++ < n) {
            MC68060.mmuWriteByteData(n3++, 48, 1);
        }
        MC68060.mmuWriteByteData(n3, 0, 1);
        XEiJ.regRn[0] = n4 + 1;
    }

    public static void fpkGCVT() throws M68kException {
        MC68060.fpkGCVTSub((long)XEiJ.regRn[0] << 32 | 0xFFFFFFFFL & (long)XEiJ.regRn[1]);
    }

    public static void fpkGCVTSub(long l) throws M68kException {
        int n;
        int n2 = Math.max(0, XEiJ.regRn[2]);
        int n3 = XEiJ.regRn[8];
        if (l < 0L) {
            MC68060.mmuWriteByteData(n3++, 45, 1);
            l &= Long.MAX_VALUE;
        }
        double d = Double.longBitsToDouble(l);
        int n4 = (int)(l >>> 52) - 1023;
        l &= 0xFFFFFFFFFFFFFL;
        if (n4 == -1023) {
            if (l == 0L) {
                MC68060.mmuWriteByteData(n3++, 48, 1);
                MC68060.mmuWriteByteData(n3++, 46, 1);
                MC68060.mmuWriteByteData(n3, 0, 1);
                XEiJ.regRn[8] = n3;
                return;
            }
            n4 -= Long.numberOfLeadingZeros(l) - 12;
        } else if (n4 == 1024) {
            MC68060.mmuWriteByteData(n3++, 35, 1);
            if (l == 0L) {
                MC68060.mmuWriteByteData(n3++, 73, 1);
                MC68060.mmuWriteByteData(n3++, 78, 1);
                MC68060.mmuWriteByteData(n3++, 70, 1);
            } else {
                MC68060.mmuWriteByteData(n3++, 78, 1);
                MC68060.mmuWriteByteData(n3++, 65, 1);
                MC68060.mmuWriteByteData(n3++, 78, 1);
            }
            MC68060.mmuWriteByteData(n3, 0, 1);
            XEiJ.regRn[8] = n3;
            return;
        }
        n4 = (int)Math.floor((double)n4 * 0.3010299956639812);
        if (0 < n4) {
            d *= FEFunction.FPK_TEN_M16QR[n4 & 0xF];
            if (16 <= n4) {
                d *= FEFunction.FPK_TEN_M16QR[16 + (n4 >> 4 & 0xF)];
                if (256 <= n4) {
                    d *= FEFunction.FPK_TEN_M16QR[33];
                }
            }
        } else if (n4 < 0) {
            d *= FEFunction.FPK_TEN_P16QR[-n4 & 0xF];
            if (n4 <= -16) {
                d *= FEFunction.FPK_TEN_P16QR[16 + (-n4 >> 4 & 0xF)];
                if (n4 <= -256) {
                    d *= FEFunction.FPK_TEN_P16QR[33];
                }
            }
        }
        int[] nArray = new int[18];
        int n5 = (int)d;
        int n6 = XEiJ.FMT_BCD4[n5];
        nArray[0] = n6 >> 4;
        nArray[1] = n6 & 0xF;
        for (n = 2; n < 18; n += 4) {
            double d2 = d * 1.34217729E8;
            d2 += d - d2;
            d = (d2 - (double)n5) * 10000.0 + (d - d2) * 10000.0;
            n5 = (int)d;
            n6 = XEiJ.FMT_BCD4[n5];
            nArray[n] = n6 >> 12;
            nArray[n + 1] = n6 >> 8 & 0xF;
            nArray[n + 2] = n6 >> 4 & 0xF;
            nArray[n + 3] = n6 & 0xF;
        }
        n5 = nArray[0] != 0 ? 0 : (nArray[1] != 0 ? 1 : 2);
        n6 = n5 + 14;
        if (5 <= nArray[n6]) {
            n = n6;
            while (true) {
                int n7 = --n;
                nArray[n7] = nArray[n7] + 1;
                if (10 > nArray[n7]) break;
                nArray[n] = 0;
            }
            if (n < n5) {
                --n5;
                --n6;
            }
        }
        n4 -= n5 - 1;
        n = n5 + n2;
        if (n < n6 && 0 <= (n6 = n) && 5 <= nArray[n6]) {
            int n8 = n6;
            while (true) {
                int n9 = --n8;
                nArray[n9] = nArray[n9] + 1;
                if (10 > nArray[n9]) break;
                nArray[n8] = 0;
            }
            if (n8 < n5) {
                --n5;
                --n6;
                ++n4;
            }
        }
        while (nArray[n6 - 1] == 0) {
            --n6;
        }
        if (0 <= n4 && n4 < n2) {
            do {
                MC68060.mmuWriteByteData(n3++, 48 + nArray[n5++], 1);
            } while (0 <= --n4);
            MC68060.mmuWriteByteData(n3++, 46, 1);
            while (n5 < n6) {
                MC68060.mmuWriteByteData(n3++, 48 + nArray[n5++], 1);
            }
        } else if (-4 <= n4 && n4 < 0) {
            MC68060.mmuWriteByteData(n3++, 48, 1);
            MC68060.mmuWriteByteData(n3++, 46, 1);
            while (++n4 < 0) {
                MC68060.mmuWriteByteData(n3++, 48, 1);
            }
            while (n5 < n6) {
                MC68060.mmuWriteByteData(n3++, 48 + nArray[n5++], 1);
            }
        } else {
            MC68060.mmuWriteByteData(n3++, 48 + nArray[n5++], 1);
            MC68060.mmuWriteByteData(n3++, 46, 1);
            while (n5 < n6) {
                MC68060.mmuWriteByteData(n3++, 48 + nArray[n5++], 1);
            }
            MC68060.mmuWriteByteData(n3++, 69, 1);
            if (0 <= n4) {
                MC68060.mmuWriteByteData(n3++, 43, 1);
            } else {
                MC68060.mmuWriteByteData(n3++, 45, 1);
                n4 = -n4;
            }
            n4 = XEiJ.FMT_BCD4[n4];
            MC68060.mmuWriteByteData(n3++, 48 + (n4 >> 8), 1);
            MC68060.mmuWriteByteData(n3++, 48 + (n4 >> 4 & 0xF), 1);
            MC68060.mmuWriteByteData(n3++, 48 + (n4 & 0xF), 1);
        }
        MC68060.mmuWriteByteData(n3, 0, 1);
        XEiJ.regRn[8] = n3;
    }

    public static void fpkFVAL() throws M68kException {
        int n = XEiJ.regRn[8];
        int n2 = MC68060.mmuReadByteSignData(n++, 1);
        while (n2 == 32 || n2 == 9) {
            n2 = MC68060.mmuReadByteSignData(n++, 1);
        }
        if (n2 == 38) {
            n2 = MC68060.mmuReadByteSignData(n++, 1) & 0xDF;
            XEiJ.regRn[8] = n;
            if (n2 == 66) {
                MC68060.fpkSTOB();
                FEFunction.fpkLTOF();
            } else if (n2 == 79) {
                MC68060.fpkSTOO();
                FEFunction.fpkLTOF();
            } else if (n2 == 72) {
                MC68060.fpkSTOH();
                FEFunction.fpkLTOF();
            } else {
                XEiJ.regCCR = 9;
            }
        } else {
            FEFunction.fpkSTOF();
        }
    }

    public static void fpkCLMUL() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = (long)MC68060.mmuReadLongData(n, 1) * (long)MC68060.mmuReadLongData(n + 4, 1);
        int n2 = (int)l;
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = (long)n2 == l ? 0 : 1;
    }

    public static void fpkCLDIV() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadLongData(n + 4, 1);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            MC68060.mmuWriteLongData(n, MC68060.mmuReadLongData(n, 1) / n2, 1);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCLMOD() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadLongData(n + 4, 1);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            MC68060.mmuWriteLongData(n, MC68060.mmuReadLongData(n, 1) % n2, 1);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCUMUL() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = (0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n, 1)) * (0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        int n2 = (int)l;
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = (0xFFFFFFFFL & (long)n2) == l ? 0 : 1;
    }

    public static void fpkCUDIV() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadLongData(n + 4, 1);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            MC68060.mmuWriteLongData(n, (int)((0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n, 1)) / (0xFFFFFFFFL & (long)n2)), 1);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCUMOD() throws M68kException {
        int n = XEiJ.regRn[15];
        int n2 = MC68060.mmuReadLongData(n + 4, 1);
        if (n2 == 0) {
            XEiJ.regCCR = 1;
        } else {
            MC68060.mmuWriteLongData(n, (int)((0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n, 1)) % (0xFFFFFFFFL & (long)n2)), 1);
            XEiJ.regCCR = 0;
        }
    }

    public static void fpkCLTOD() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = Double.doubleToLongBits(MC68060.mmuReadLongData(n, 1));
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
    }

    public static void fpkCDTOL() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        MC68060.mmuWriteLongData(n, (int)d, 1);
        XEiJ.regCCR = -2.147483649E9 < d && d < 2.147483648E9 ? 0 : 1;
    }

    public static void fpkCLTOF() throws M68kException {
        int n = XEiJ.regRn[15];
        MC68060.mmuWriteLongData(n, Float.floatToIntBits(MC68060.mmuReadLongData(n, 1)), 1);
    }

    public static void fpkCFTOL() throws M68kException {
        int n = XEiJ.regRn[15];
        float f = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        MC68060.mmuWriteLongData(n, (int)f, 1);
        XEiJ.regCCR = -2.1474836E9f < f && f < 2.1474836E9f ? 0 : 1;
    }

    public static void fpkCFTOD() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = Double.doubleToLongBits(Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1)));
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
    }

    public static void fpkCDTOF() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        int n2 = Float.floatToIntBits((float)d);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Double.isNaN(d) || Double.isInfinite(d) || Math.abs(d) < 3.4028234663852886E38 + 0.5 * (double)Math.ulp(Float.MAX_VALUE) ? 0 : 1;
    }

    public static void fpkCDCMP() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        XEiJ.regCCR = d2 < (d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n + 8, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 12, 1))) ? 9 : (d2 == d ? 4 : 0);
    }

    public static void fpkCDADD() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d3 = d2 + (d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n + 8, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 12, 1)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkCDSUB() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d3 = d2 - (d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n + 8, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 12, 1)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkCDMUL() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d3 = d2 * (d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n + 8, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 12, 1)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0)));
    }

    public static void fpkCDDIV() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d3 = d2 / (d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n + 8, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 12, 1)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (d == 0.0 ? 5 : (Double.isInfinite(d3) ? 3 : 0))));
    }

    public static void fpkCDMOD() throws M68kException {
        double d;
        int n = XEiJ.regRn[15];
        double d2 = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d3 = d2 % (d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n + 8, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 12, 1)));
        long l = Double.doubleToLongBits(d3);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isNaN(d2) || Double.isNaN(d) ? 0 : (d == 0.0 ? 5 : (Double.isNaN(d3) ? 1 : (Double.isInfinite(d2) || Double.isInfinite(d) ? 0 : (Double.isInfinite(d3) ? 3 : 0))));
    }

    public static void fpkCFCMP() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        XEiJ.regCCR = f2 < (f = Float.intBitsToFloat(MC68060.mmuReadLongData(n + 4, 1))) ? 9 : (f2 == f ? 4 : 0);
    }

    public static void fpkCFADD() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f3 = f2 + (f = Float.intBitsToFloat(MC68060.mmuReadLongData(n + 4, 1)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkCFSUB() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f3 = f2 - (f = Float.intBitsToFloat(MC68060.mmuReadLongData(n + 4, 1)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkCFMUL() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f3 = f2 * (f = Float.intBitsToFloat(MC68060.mmuReadLongData(n + 4, 1)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0)));
    }

    public static void fpkCFDIV() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f3 = f2 / (f = Float.intBitsToFloat(MC68060.mmuReadLongData(n + 4, 1)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (f == 0.0f ? 5 : (Float.isInfinite(f3) ? 3 : 0))));
    }

    public static void fpkCFMOD() throws M68kException {
        float f;
        int n = XEiJ.regRn[15];
        float f2 = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f3 = f2 % (f = Float.intBitsToFloat(MC68060.mmuReadLongData(n + 4, 1)));
        int n2 = Float.floatToIntBits(f3);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Float.isNaN(f2) || Float.isNaN(f) ? 0 : (f == 0.0f ? 5 : (Float.isNaN(f3) ? 1 : (Float.isInfinite(f2) || Float.isInfinite(f) ? 0 : (Float.isInfinite(f3) ? 3 : 0))));
    }

    public static void fpkCDTST() throws M68kException {
        int n = XEiJ.regRn[15];
        long l = (long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1);
        XEiJ.regCCR = l << 1 == 0L ? 4 : (0L <= l ? 0 : 8);
    }

    public static void fpkCFTST() throws M68kException {
        int n = MC68060.mmuReadLongData(XEiJ.regRn[15], 1);
        XEiJ.regCCR = n << 1 == 0 ? 4 : (0 <= n ? 0 : 8);
    }

    public static void fpkCDINC() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d2 = d + 1.0;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isInfinite(d2) && !Double.isInfinite(d) ? 3 : 0;
    }

    public static void fpkCFINC() throws M68kException {
        int n = XEiJ.regRn[15];
        float f = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f2 = f + 1.0f;
        int n2 = Float.floatToIntBits(f2);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Double.isInfinite(f2) && !Float.isInfinite(f) ? 3 : 0;
    }

    public static void fpkCDDEC() throws M68kException {
        int n = XEiJ.regRn[15];
        double d = Double.longBitsToDouble((long)MC68060.mmuReadLongData(n, 1) << 32 | 0xFFFFFFFFL & (long)MC68060.mmuReadLongData(n + 4, 1));
        double d2 = d - 1.0;
        long l = Double.doubleToLongBits(d2);
        if (l == 9221120237041090560L) {
            l = Long.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, (int)(l >>> 32), 1);
        MC68060.mmuWriteLongData(n + 4, (int)l, 1);
        XEiJ.regCCR = Double.isInfinite(d2) && !Double.isInfinite(d) ? 3 : 0;
    }

    public static void fpkCFDEC() throws M68kException {
        int n = XEiJ.regRn[15];
        float f = Float.intBitsToFloat(MC68060.mmuReadLongData(n, 1));
        float f2 = f - 1.0f;
        int n2 = Float.floatToIntBits(f2);
        if (n2 == 2143289344) {
            n2 = Integer.MAX_VALUE;
        }
        MC68060.mmuWriteLongData(n, n2, 1);
        XEiJ.regCCR = Double.isInfinite(f2) && !Float.isInfinite(f) ? 3 : 0;
    }

    public static int mmuGetDTT0() {
        return mmuDTT0;
    }

    public static int mmuGetDTT1() {
        return mmuDTT1;
    }

    public static int mmuGetITT0() {
        return mmuITT0;
    }

    public static int mmuGetITT1() {
        return mmuITT1;
    }

    public static void mmuSetDTT0(int n) {
        MC68060.mmuSetDataTransparent(n, mmuDTT1);
    }

    public static void mmuSetDTT1(int n) {
        MC68060.mmuSetDataTransparent(mmuDTT0, n);
    }

    public static void mmuSetDataTransparent(int n, int n2) {
        int n3;
        int n4;
        int n5;
        mmuDTT0 = n & 0xFFFFE364;
        mmuDTT1 = n2 & 0xFFFFE364;
        int[] nArray = mmuUserDataDifference;
        mmuUserDataDifference = mmuUserDataTransparent;
        mmuUserDataTransparent = nArray;
        nArray = mmuSuperDataDifference;
        mmuSuperDataDifference = mmuSuperDataTransparent;
        mmuSuperDataTransparent = nArray;
        Arrays.fill(mmuUserDataTransparent, 0);
        Arrays.fill(mmuSuperDataTransparent, 0);
        if ((short)mmuDTT1 < 0) {
            int n6 = ~mmuDTT1 >>> 16 & 0xFF;
            n5 = mmuDTT1 >>> 24 & n6;
            int n7 = n4 = (mmuDTT1 & 4) != 0 ? -1 : 1;
            if ((mmuDTT1 & 0x4000) != 0 || (mmuDTT1 & 0x2000) == 0) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n6) != n5) continue;
                    MC68060.mmuUserDataTransparent[n3] = n4;
                }
            }
            if ((mmuDTT1 & 0x4000) != 0 || (mmuDTT1 & 0x2000) == 8192) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n6) != n5) continue;
                    MC68060.mmuSuperDataTransparent[n3] = n4;
                }
            }
        }
        if ((short)mmuDTT0 < 0) {
            int n8 = ~mmuDTT0 >>> 16 & 0xFF;
            n5 = mmuDTT0 >>> 24 & n8;
            int n9 = n4 = (mmuDTT0 & 4) != 0 ? -1 : 1;
            if ((mmuDTT0 & 0x4000) != 0 || (mmuDTT0 & 0x2000) == 0) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n8) != n5) continue;
                    MC68060.mmuUserDataTransparent[n3] = n4;
                }
            }
            if ((mmuDTT0 & 0x4000) != 0 || (mmuDTT0 & 0x2000) == 8192) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n8) != n5) continue;
                    MC68060.mmuSuperDataTransparent[n3] = n4;
                }
            }
        }
        int n10 = 0;
        for (n5 = 0; n5 < 256; ++n5) {
            int n11 = n5;
            int n12 = mmuUserDataDifference[n11] - mmuUserDataTransparent[n5];
            mmuUserDataDifference[n11] = n12;
            n10 |= n12;
            int n13 = n5;
            int n14 = mmuSuperDataDifference[n13] - mmuSuperDataTransparent[n5];
            mmuSuperDataDifference[n13] = n14;
            n10 |= n14;
        }
        if (n10 != 0) {
            for (n5 = 0; n5 < 256; n5 += 4) {
                n4 = mmuUserDataCache[n5];
                if (n4 != 1 && mmuUserDataDifference[n4 >>> 24] != 0) {
                    MC68060.mmuUserDataCache[n5 + 3] = 1;
                    MC68060.mmuUserDataCache[n5 + 2] = 1;
                    MC68060.mmuUserDataCache[n5 + 1] = 1;
                    MC68060.mmuUserDataCache[n5] = 1;
                }
                if ((n4 = mmuSuperDataCache[n5]) == 1 || mmuSuperDataDifference[n4 >>> 24] == 0) continue;
                MC68060.mmuSuperDataCache[n5 + 3] = 1;
                MC68060.mmuSuperDataCache[n5 + 2] = 1;
                MC68060.mmuSuperDataCache[n5 + 1] = 1;
                MC68060.mmuSuperDataCache[n5] = 1;
            }
        }
    }

    public static void mmuSetITT0(int n) {
        MC68060.mmuSetCodeTransparent(n, mmuITT1);
    }

    public static void mmuSetITT1(int n) {
        MC68060.mmuSetCodeTransparent(mmuITT0, n);
    }

    public static void mmuSetCodeTransparent(int n, int n2) {
        int n3;
        int n4;
        int n5;
        mmuITT0 = n & 0xFFFFE364;
        mmuITT1 = n2 & 0xFFFFE364;
        int[] nArray = mmuUserCodeDifference;
        mmuUserCodeDifference = mmuUserCodeTransparent;
        mmuUserCodeTransparent = nArray;
        nArray = mmuSuperCodeDifference;
        mmuSuperCodeDifference = mmuSuperCodeTransparent;
        mmuSuperCodeTransparent = nArray;
        Arrays.fill(mmuUserCodeTransparent, 0);
        Arrays.fill(mmuSuperCodeTransparent, 0);
        if ((short)mmuITT1 < 0) {
            int n6 = ~mmuITT1 >>> 16 & 0xFF;
            n5 = mmuITT1 >>> 24 & n6;
            int n7 = n4 = (mmuITT1 & 4) != 0 ? -1 : 1;
            if ((mmuITT1 & 0x4000) != 0 || (mmuITT1 & 0x2000) == 0) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n6) != n5) continue;
                    MC68060.mmuUserCodeTransparent[n3] = n4;
                }
            }
            if ((mmuITT1 & 0x4000) != 0 || (mmuITT1 & 0x2000) == 8192) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n6) != n5) continue;
                    MC68060.mmuSuperCodeTransparent[n3] = n4;
                }
            }
        }
        if ((short)mmuITT0 < 0) {
            int n8 = ~mmuITT0 >>> 16 & 0xFF;
            n5 = mmuITT0 >>> 24 & n8;
            int n9 = n4 = (mmuITT0 & 4) != 0 ? -1 : 1;
            if ((mmuITT0 & 0x4000) != 0 || (mmuITT0 & 0x2000) == 0) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n8) != n5) continue;
                    MC68060.mmuUserCodeTransparent[n3] = n4;
                }
            }
            if ((mmuITT0 & 0x4000) != 0 || (mmuITT0 & 0x2000) == 8192) {
                for (n3 = 0; n3 < 256; ++n3) {
                    if ((n3 & n8) != n5) continue;
                    MC68060.mmuSuperCodeTransparent[n3] = n4;
                }
            }
        }
        int n10 = 0;
        for (n5 = 0; n5 < 256; ++n5) {
            int n11 = n5;
            int n12 = mmuUserCodeDifference[n11] - mmuUserCodeTransparent[n5];
            mmuUserCodeDifference[n11] = n12;
            n10 |= n12;
            int n13 = n5;
            int n14 = mmuSuperCodeDifference[n13] - mmuSuperCodeTransparent[n5];
            mmuSuperCodeDifference[n13] = n14;
            n10 |= n14;
        }
        if (n10 != 0) {
            for (n5 = 0; n5 < 256; n5 += 4) {
                n4 = mmuUserCodeCache[n5];
                if (n4 != 1 && mmuUserCodeDifference[n4 >>> 24] != 0) {
                    MC68060.mmuUserCodeCache[n5 + 3] = 1;
                    MC68060.mmuUserCodeCache[n5 + 2] = 1;
                    MC68060.mmuUserCodeCache[n5 + 1] = 1;
                    MC68060.mmuUserCodeCache[n5] = 1;
                }
                if ((n4 = mmuSuperCodeCache[n5]) == 1 || mmuSuperCodeDifference[n4 >>> 24] == 0) continue;
                MC68060.mmuSuperCodeCache[n5 + 3] = 1;
                MC68060.mmuSuperCodeCache[n5 + 2] = 1;
                MC68060.mmuSuperCodeCache[n5 + 1] = 1;
                MC68060.mmuSuperCodeCache[n5] = 1;
            }
        }
    }

    public static int mmuGetTCR() {
        return mmuTCR;
    }

    public static void mmuSetTCR(int n) {
        MC68060.mmuInvalidateAllCache();
        mmuTCR = n & 0xFFFE;
        mmuEnabled = (short)n < 0;
        mmu4KB = (n & 0x4000) == 0;
        mmuNotAllocateData = (n & 0x2000) != 0;
        boolean bl = mmuNotAllocateCode = (n & 0x1000) != 0;
        if (mmu4KB) {
            mmuPageSize = 4096;
            mmuPageAddressMask = -4096;
            mmuPageOffsetMask = 4095;
            mmuPageIndexMask = 258048;
            mmuPageIndexBit2 = 10;
            mmuPageTableMask = -64;
        } else {
            mmuPageSize = 8192;
            mmuPageAddressMask = -8192;
            mmuPageOffsetMask = 8191;
            mmuPageIndexMask = 253952;
            mmuPageIndexBit2 = 11;
            mmuPageTableMask = -32;
        }
    }

    public static int mmuGetURP() {
        return mmuURP;
    }

    public static int mmuGetSRP() {
        return mmuSRP;
    }

    public static void mmuSetURP(int n) throws M68kException {
        mmuURP = n &= 0xFFFFFE00;
        Arrays.fill(mmuUserDataCache, 1);
        Arrays.fill(mmuUserCodeCache, 1);
        RootPointerList.rtlSetRootPointer(n, false);
    }

    public static void mmuSetSRP(int n) {
        mmuSRP = n &= 0xFFFFFE00;
        Arrays.fill(mmuSuperDataCache, 1);
        Arrays.fill(mmuSuperCodeCache, 1);
        RootPointerList.rtlSetRootPointer(n, true);
    }

    public static void mmuInvalidateAllCache() {
        Arrays.fill(mmuUserDataCache, 1);
        Arrays.fill(mmuUserCodeCache, 1);
        Arrays.fill(mmuSuperDataCache, 1);
        Arrays.fill(mmuSuperCodeCache, 1);
    }

    public static void mmuInvalidateAllNonGlobalCache() {
        for (int i = 0; i < 256; i += 4) {
            if (mmuUserDataCache[i + 3] == 0) {
                MC68060.mmuUserDataCache[i + 3] = 1;
                MC68060.mmuUserDataCache[i + 2] = 1;
                MC68060.mmuUserDataCache[i + 1] = 1;
                MC68060.mmuUserDataCache[i] = 1;
            }
            if (mmuUserCodeCache[i + 3] == 0) {
                MC68060.mmuUserCodeCache[i + 3] = 1;
                MC68060.mmuUserCodeCache[i + 2] = 1;
                MC68060.mmuUserCodeCache[i + 1] = 1;
                MC68060.mmuUserCodeCache[i] = 1;
            }
            if (mmuSuperDataCache[i + 3] == 0) {
                MC68060.mmuSuperDataCache[i + 3] = 1;
                MC68060.mmuSuperDataCache[i + 2] = 1;
                MC68060.mmuSuperDataCache[i + 1] = 1;
                MC68060.mmuSuperDataCache[i] = 1;
            }
            if (mmuSuperCodeCache[i + 3] != 0) continue;
            MC68060.mmuSuperCodeCache[i + 3] = 1;
            MC68060.mmuSuperCodeCache[i + 2] = 1;
            MC68060.mmuSuperCodeCache[i + 1] = 1;
            MC68060.mmuSuperCodeCache[i] = 1;
        }
    }

    public static void mmuInvalidateCache(int n) {
        boolean bl;
        int n2 = n & mmuPageAddressMask;
        boolean bl2 = -1627389952 << XEiJ.mpuDFC < 0;
        boolean bl3 = bl = 0x2A000000 << XEiJ.mpuDFC < 0;
        int[] nArray = bl2 ? (bl ? mmuSuperCodeCache : mmuSuperDataCache) : (bl ? mmuUserCodeCache : mmuUserDataCache);
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (nArray[n3] == n2) {
            nArray[n3 + 3] = 1;
            nArray[n3 + 2] = 1;
            nArray[n3 + 1] = 1;
            nArray[n3] = 1;
            return;
        }
    }

    public static void mmuInvalidateNonGlobalCache(int n) {
        boolean bl;
        int n2 = n & mmuPageAddressMask;
        boolean bl2 = -1627389952 << XEiJ.mpuDFC < 0;
        boolean bl3 = bl = 0x2A000000 << XEiJ.mpuDFC < 0;
        int[] nArray = bl2 ? (bl ? mmuSuperCodeCache : mmuSuperDataCache) : (bl ? mmuUserCodeCache : mmuUserDataCache);
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (nArray[n3] == n2) {
            if (nArray[n3 + 3] == 0) {
                nArray[n3 + 3] = 1;
                nArray[n3 + 2] = 1;
                nArray[n3 + 1] = 1;
                nArray[n3] = 1;
            }
            return;
        }
    }

    public static void mmuInit() {
        mmuUserDataTransparent = new int[256];
        mmuUserCodeTransparent = new int[256];
        mmuSuperDataTransparent = new int[256];
        mmuSuperCodeTransparent = new int[256];
        mmuUserDataDifference = new int[256];
        mmuUserCodeDifference = new int[256];
        mmuSuperDataDifference = new int[256];
        mmuSuperCodeDifference = new int[256];
        MC68060.mmuReset();
    }

    public static void mmuReset() {
        MC68060.mmuSetDataTransparent(0, 0);
        MC68060.mmuSetCodeTransparent(0, 0);
        MC68060.mmuSetTCR(0);
    }

    public static byte mmuPeekByteSign(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n2 = n2 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n2 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n2 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n2 < 0) {
            int n3 = MC68060.mmuTranslatePeek(n, n2 & 4, n2 & 2);
            return (n ^ n3) != 1 ? memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3) : (byte)-1;
        }
        if (n2 != 7) {
            return memoryMappedDeviceArray[n >>> 12].mmdPbs(n);
        }
        return -1;
    }

    public static int mmuPeekByteZero(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n2 = n2 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n2 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n2 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n2 < 0) {
            int n3 = MC68060.mmuTranslatePeek(n, n2 & 4, n2 & 2);
            return (n ^ n3) != 1 ? memoryMappedDeviceArray[n3 >>> 12].mmdPbz(n3) : 255;
        }
        if (n2 != 7) {
            return memoryMappedDeviceArray[n >>> 12].mmdPbz(n);
        }
        return 255;
    }

    public static byte mmuPeekByteSignData(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        return (n ^ n3) == 1 ? (byte)-1 : memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3);
    }

    public static byte mmuPeekByteSignCode(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 1);
        return (n ^ n3) == 1 ? (byte)-1 : memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3);
    }

    public static int mmuPeekByteZeroData(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        return (n ^ n3) == 1 ? 255 : memoryMappedDeviceArray[n3 >>> 12].mmdPbz(n3);
    }

    public static int mmuPeekByteZeroCode(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 1);
        return (n ^ n3) == 1 ? 255 : memoryMappedDeviceArray[n3 >>> 12].mmdPbz(n3);
    }

    public static int mmuPeekWordSign(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n2 = n2 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n2 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n2 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n2 < 0) {
            int n3 = MC68060.mmuTranslatePeek(n, n2 & 4, n2 & 2);
            if ((n & 1) == 0) {
                return (n ^ n3) != 1 ? memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3) : -1;
            }
            int n4 = MC68060.mmuTranslatePeek(n + 1, n2 & 4, n2 & 2);
            return ((n ^ n3) != 1 ? (int)memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3) : -1) << 8 | ((n + 1 ^ n4) != 1 ? memoryMappedDeviceArray[n4 >>> 12].mmdPbz(n4) : 255);
        }
        if (n2 != 7) {
            if ((n & 1) == 0) {
                return memoryMappedDeviceArray[n >>> 12].mmdPws(n);
            }
            return memoryMappedDeviceArray[n >>> 12].mmdPbs(n) << 8 | memoryMappedDeviceArray[n + 1 >>> 12].mmdPbz(n + 1);
        }
        return -1;
    }

    public static int mmuPeekWordSignData(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n & 1) == 0) {
            return (n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3);
        }
        int n4 = MC68060.mmuTranslatePeek(n + 1, n2, 0);
        return ((n3 & 1) == 0 ? -1 : (int)memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3)) << 8 | ((n4 & 1) != 0 ? 255 : memoryMappedDeviceArray[n4 >>> 12].mmdPbz(n4));
    }

    public static int mmuPeekWordSignEven(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        n = MC68060.mmuTranslatePeek(n, n2, 0);
        return (n & 1) != 0 ? -1 : memoryMappedDeviceArray[n >>> 12].mmdPws(n);
    }

    public static int mmuPeekWordSignCode(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        n = MC68060.mmuTranslatePeek(n, n2, 1);
        return (n & 1) != 0 ? -1 : memoryMappedDeviceArray[n >>> 12].mmdPws(n);
    }

    public static int mmuPeekWordZeroData(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n & 1) == 0) {
            return (n3 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n3 >>> 12].mmdPwz(n3);
        }
        int n4 = MC68060.mmuTranslatePeek(n + 1, n2, 0);
        return ((n3 & 1) == 0 ? 255 : memoryMappedDeviceArray[n3 >>> 12].mmdPbz(n3)) << 8 | ((n4 & 1) != 0 ? 255 : memoryMappedDeviceArray[n4 >>> 12].mmdPbz(n4));
    }

    public static int mmuPeekWordZeroEven(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        n = MC68060.mmuTranslatePeek(n, n2, 0);
        return (n & 1) != 0 ? 65535 : memoryMappedDeviceArray[n >>> 12].mmdPwz(n);
    }

    public static int mmuPeekWordZeroCode(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        n = MC68060.mmuTranslatePeek(n, n2, 1);
        return (n & 1) != 0 ? 65535 : memoryMappedDeviceArray[n >>> 12].mmdPwz(n);
    }

    public static int mmuPeekLong(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n2 = n2 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n2 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n2 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n2 < 0) {
            int n3 = MC68060.mmuTranslatePeek(n, n2 & 4, n2 & 2);
            if ((n & 3) == 0) {
                return (n ^ n3) != 1 ? memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3) : -1;
            }
            if ((n & 1) == 0) {
                int n4 = MC68060.mmuTranslatePeek(n + 2, n2 & 4, n2 & 2);
                return ((n ^ n3) != 1 ? memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3) : -1) << 16 | ((n + 2 ^ n4) != 1 ? memoryMappedDeviceArray[n4 >>> 12].mmdPwz(n4) : 65535);
            }
            int n5 = MC68060.mmuTranslatePeek(n + 1, n2 & 4, n2 & 2);
            int n6 = MC68060.mmuTranslatePeek(n + 3, n2 & 4, n2 & 2);
            return ((n ^ n3) != 1 ? (int)memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3) : -1) << 24 | ((n + 1 ^ n5) != 1 ? memoryMappedDeviceArray[n5 >>> 12].mmdPwz(n5) : 65535) << 8 | ((n + 3 ^ n6) != 1 ? memoryMappedDeviceArray[n6 >>> 12].mmdPbz(n6) : 255);
        }
        if (n2 != 7) {
            if ((n & 3) == 0) {
                return memoryMappedDeviceArray[n >>> 12].mmdPls(n);
            }
            if ((n & 1) == 0) {
                return memoryMappedDeviceArray[n >>> 12].mmdPws(n) << 16 | memoryMappedDeviceArray[n + 2 >>> 12].mmdPwz(n + 2);
            }
            return memoryMappedDeviceArray[n >>> 12].mmdPbs(n) << 24 | memoryMappedDeviceArray[n + 1 >>> 12].mmdPwz(n + 1) << 8 | memoryMappedDeviceArray[n + 3 >>> 12].mmdPbz(n + 3);
        }
        return -1;
    }

    public static int mmuPeekLongData(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n & 3) == 0) {
            return (n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3);
        }
        if ((n & 1) == 0) {
            int n4 = MC68060.mmuTranslatePeek(n + 2, n2, 0);
            return ((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3)) << 16 | ((n4 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n4 >>> 12].mmdPwz(n4));
        }
        int n5 = MC68060.mmuTranslatePeek(n + 1, n2, 0);
        int n6 = MC68060.mmuTranslatePeek(n + 3, n2, 0);
        return ((n3 & 1) == 0 ? -1 : (int)memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3)) << 24 | ((n5 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n5 >>> 12].mmdPwz(n5)) << 16 | ((n6 & 1) != 0 ? 255 : memoryMappedDeviceArray[n6 >>> 12].mmdPbz(n6));
    }

    public static int mmuPeekLongEven(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n & 2) == 0) {
            return (n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3);
        }
        int n4 = MC68060.mmuTranslatePeek(n + 2, n2, 0);
        return ((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3)) << 16 | ((n4 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n4 >>> 12].mmdPwz(n4));
    }

    public static int mmuPeekLongFour(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        n = MC68060.mmuTranslatePeek(n, n2, 0);
        return (n & 1) != 0 ? -1 : memoryMappedDeviceArray[n >>> 12].mmdPls(n);
    }

    public static int mmuPeekLongCode(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 1);
        if ((n & 2) == 0) {
            return (n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3);
        }
        int n4 = MC68060.mmuTranslatePeek(n + 2, n2, 1);
        return ((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3)) << 16 | ((n4 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n4 >>> 12].mmdPwz(n4));
    }

    public static long mmuPeekQuad(int n, int n2) {
        return (long)MC68060.mmuPeekLong(n, n2) << 32 | (long)MC68060.mmuPeekLong(n + 4, n2) & 0xFFFFFFFFL;
    }

    public static long mmuPeekQuadData(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n & 3) == 0) {
            int n4 = MC68060.mmuTranslatePeek(n + 4, n2, 0);
            return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3)) << 32 | (long)((n4 & 1) != 0 ? -1 : memoryMappedDeviceArray[n4 >>> 12].mmdPls(n4)) & 0xFFFFFFFFL;
        }
        if ((n & 1) == 0) {
            int n5 = MC68060.mmuTranslatePeek(n + 2, n2, 0);
            int n6 = MC68060.mmuTranslatePeek(n + 6, n2, 0);
            return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3)) << 48 | (long)((n5 & 1) != 0 ? -1 : memoryMappedDeviceArray[n5 >>> 12].mmdPls(n5)) << 16 & 0xFFFFFFFF0000L | (long)((n6 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n6 >>> 12].mmdPwz(n6));
        }
        if ((n & 3) == 1) {
            int n7 = MC68060.mmuTranslatePeek(n + 1, n2, 0);
            int n8 = MC68060.mmuTranslatePeek(n + 3, n2, 0);
            int n9 = MC68060.mmuTranslatePeek(n + 7, n2, 0);
            return (long)((n3 & 1) != 0 ? -1 : (int)memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3)) << 56 | (long)((n7 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n7 >>> 12].mmdPwz(n7)) << 40 | (long)((n8 & 1) != 0 ? -1 : memoryMappedDeviceArray[n8 >>> 12].mmdPls(n8)) << 8 & 0xFFFFFFFF00L | (long)((n9 & 1) != 0 ? 255 : memoryMappedDeviceArray[n9 >>> 12].mmdPbz(n9));
        }
        int n10 = MC68060.mmuTranslatePeek(n + 1, n2, 0);
        int n11 = MC68060.mmuTranslatePeek(n + 5, n2, 0);
        int n12 = MC68060.mmuTranslatePeek(n + 7, n2, 0);
        return (long)((n3 & 1) != 0 ? -1 : (int)memoryMappedDeviceArray[n3 >>> 12].mmdPbs(n3)) << 56 | (long)((n10 & 1) != 0 ? -1 : memoryMappedDeviceArray[n10 >>> 12].mmdPls(n10)) << 24 & 0xFFFFFFFF000000L | (long)((n11 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n11 >>> 12].mmdPwz(n11)) << 8 | (long)((n12 & 1) != 0 ? 255 : memoryMappedDeviceArray[n12 >>> 12].mmdPbz(n12));
    }

    public static long mmuPeekQuadEven(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        if ((n & 2) == 0) {
            int n4 = MC68060.mmuTranslatePeek(n + 4, n2, 0);
            return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3)) << 32 | (long)((n4 & 1) != 0 ? -1 : memoryMappedDeviceArray[n4 >>> 12].mmdPls(n4)) & 0xFFFFFFFFL;
        }
        int n5 = MC68060.mmuTranslatePeek(n + 2, n2, 0);
        int n6 = MC68060.mmuTranslatePeek(n + 6, n2, 0);
        return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3)) << 48 | (long)((n5 & 1) != 0 ? -1 : memoryMappedDeviceArray[n5 >>> 12].mmdPls(n5)) << 16 & 0xFFFFFFFF0000L | (long)((n6 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n6 >>> 12].mmdPwz(n6));
    }

    public static long mmuPeekQuadFour(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 0);
        int n4 = MC68060.mmuTranslatePeek(n + 4, n2, 0);
        return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3)) << 32 | (long)((n4 & 1) != 0 ? -1 : memoryMappedDeviceArray[n4 >>> 12].mmdPls(n4)) & 0xFFFFFFFFL;
    }

    public static long mmuPeekQuadCode(int n, int n2) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n2 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n3 = MC68060.mmuTranslatePeek(n, n2, 1);
        if ((n & 2) == 0) {
            int n4 = MC68060.mmuTranslatePeek(n + 4, n2, 1);
            return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPls(n3)) << 32 | (long)((n4 & 1) != 0 ? -1 : memoryMappedDeviceArray[n4 >>> 12].mmdPls(n4)) & 0xFFFFFFFFL;
        }
        int n5 = MC68060.mmuTranslatePeek(n + 2, n2, 1);
        int n6 = MC68060.mmuTranslatePeek(n + 6, n2, 1);
        return (long)((n3 & 1) != 0 ? -1 : memoryMappedDeviceArray[n3 >>> 12].mmdPws(n3)) << 48 | (long)((n5 & 1) != 0 ? -1 : memoryMappedDeviceArray[n5 >>> 12].mmdPls(n5)) << 16 & 0xFFFFFFFF0000L | (long)((n6 & 1) != 0 ? 65535 : memoryMappedDeviceArray[n6 >>> 12].mmdPwz(n6));
    }

    public static void mmuPeekExtended(int n, byte[] byArray, int n2) {
        for (int i = 0; i < 12; ++i) {
            byArray[i] = MC68060.mmuPeekByteSign(n + i, n2);
        }
    }

    public static int mmuPeekStrlen(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            if (MC68060.mmuPeekByteZeroData(n + i, n3) != 0) continue;
            return i;
        }
        return n2;
    }

    public static boolean mmuPeekEquals(int n, String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = string.charAt(i);
            if (n4 == 92) {
                int n5 = n3 = i + 1 < n2 ? (int)string.charAt(i + 1) : -1;
                if ((n3 & 0xFFFFFFFC) == 48) {
                    n4 = n3 & 7;
                    int n6 = n3 = i + 2 < n2 ? (int)string.charAt(i + 2) : -1;
                    if ((n3 & 0xFFFFFFF8) == 48) {
                        n4 = n4 << 3 | n3 & 7;
                        int n7 = n3 = i + 3 < n2 ? (int)string.charAt(i + 3) : -1;
                        if ((n3 & 0xFFFFFFF8) == 48) {
                            n4 = n4 << 3 | n3 & 7;
                            ++i;
                        }
                        ++i;
                    }
                    ++i;
                } else if ((n3 & 0xFFFFFFFC) == 52) {
                    n4 = n3 & 7;
                    int n8 = n3 = i + 2 < n2 ? (int)string.charAt(i + 2) : -1;
                    if ((n3 & 0xFFFFFFF8) == 48) {
                        n4 = n4 << 3 | n3 & 7;
                        ++i;
                    }
                    ++i;
                } else if (n3 == 98) {
                    n4 = 8;
                    ++i;
                } else if (n3 == 116) {
                    n4 = 9;
                    ++i;
                } else if (n3 == 110) {
                    n4 = 10;
                    ++i;
                } else if (n3 == 118) {
                    n4 = 11;
                    ++i;
                } else if (n3 == 102) {
                    n4 = 12;
                    ++i;
                } else if (n3 == 114) {
                    n4 = 13;
                    ++i;
                } else if (n3 == 120 && i + 3 < n2 && CharacterCode.chrIsXdigit(string.charAt(i + 2)) && CharacterCode.chrIsXdigit(string.charAt(i + 3))) {
                    n4 = CharacterCode.chrDigit(string.charAt(i + 2)) << 4 | CharacterCode.chrDigit(string.charAt(i + 3));
                    i += 3;
                } else if (33 <= n3 && n3 <= 126) {
                    n4 = n3;
                    ++i;
                }
                if (MC68060.mmuPeekByteZeroData(n++, 1) == n4) continue;
                return false;
            }
            n3 = CharacterCode.chrCharToSJIS[n4];
            if (n3 == 0 && n4 != 0) {
                n3 = 33190;
            }
            if (n3 >> 8 != 0 && MC68060.mmuPeekByteZeroData(n++, 1) != n3 >> 8) {
                return false;
            }
            if (MC68060.mmuPeekByteZeroData(n++, 1) == (n3 & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public static String mmuPeekStringL(int n, int n2, int n3) {
        return MC68060.mmuPeekStringL(new StringBuilder(), n, n2, n3).toString();
    }

    public static StringBuilder mmuPeekStringL(StringBuilder stringBuilder, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = MC68060.mmuPeekByteZeroData(n + i, n3);
            if (129 <= n5 && n5 <= 159 || 224 <= n5 && n5 <= 239) {
                int n6;
                int n7 = n6 = i + 1 < n2 ? MC68060.mmuPeekByteZeroData(n + i + 1, n3) : 0;
                if (64 <= n6 && n6 != 127 && n6 <= 252) {
                    n4 = CharacterCode.chrSJISToChar[n5 << 8 | n6];
                    if (n4 == 0) {
                        n4 = 8251;
                    }
                    ++i;
                } else {
                    n4 = 46;
                }
            } else {
                n4 = CharacterCode.chrSJISToChar[n5];
                if (n4 < 32 || n4 == 127) {
                    n4 = 46;
                }
            }
            stringBuilder.append((char)n4);
        }
        return stringBuilder;
    }

    public static String mmuPeekStringZ(int n, int n2) {
        return MC68060.mmuPeekStringZ(new StringBuilder(), n, n2).toString();
    }

    public static StringBuilder mmuPeekStringZ(StringBuilder stringBuilder, int n, int n2) {
        int n3;
        while ((n3 = MC68060.mmuPeekByteSign(n++, n2) & 0xFF) != 0) {
            int n4;
            if (129 <= n3 && n3 <= 159 || 224 <= n3 && n3 <= 239) {
                int n5;
                if ((n5 = MC68060.mmuPeekByteSign(n++, n2) & 0xFF) == 0) {
                    stringBuilder.append('\ufffd');
                    break;
                }
                if (64 <= n5 && n5 != 127 && n5 <= 252) {
                    n4 = CharacterCode.chrSJISToChar[n5 |= n3 << 8];
                    if (n4 == 0) {
                        n4 = 65533;
                    }
                } else {
                    n4 = 65533;
                }
            } else {
                n4 = CharacterCode.chrSJISToChar[n3];
                if (n4 == 0) {
                    n4 = 65533;
                }
            }
            stringBuilder.append((char)n4);
        }
        return stringBuilder;
    }

    public static byte mmuReadByteSignData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 19202048;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
        }
        m60FSLW = 0x1210000;
        int n4 = MC68060.mmuTranslateReadUserData(n);
        return DataBreakPoint.dbpUserMap[n4 >>> 12].mmdRbs(n4);
    }

    public static int mmuReadByteZeroData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 19202048;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbz(n3);
        }
        m60FSLW = 0x1210000;
        int n4 = MC68060.mmuTranslateReadUserData(n);
        return DataBreakPoint.dbpUserMap[n4 >>> 12].mmdRbz(n4);
    }

    public static byte mmuReadByteSignExword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 153518080;
            int n3 = MC68060.mmuTranslateReadSuperCode(n);
            return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
        }
        m60FSLW = 153255936;
        int n4 = MC68060.mmuTranslateReadUserCode(n);
        return DataBreakPoint.dbpUserMap[n4 >>> 12].mmdRbs(n4);
    }

    public static int mmuReadByteZeroExword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 153518080;
            int n3 = MC68060.mmuTranslateReadSuperCode(n);
            return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbz(n3);
        }
        m60FSLW = 153255936;
        int n4 = MC68060.mmuTranslateReadUserCode(n);
        return DataBreakPoint.dbpUserMap[n4 >>> 12].mmdRbz(n4);
    }

    public static int mmuReadWordSignData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 21299200;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 1) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3);
            }
            byte by = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
            m60FSLW ^= 0x8000000;
            int n4 = MC68060.mmuTranslateReadSuperData(n + 1);
            return by << 8 | DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdRbz(n4);
        }
        m60FSLW = 0x1410000;
        int n5 = MC68060.mmuTranslateReadUserData(n);
        if ((n & 1) == 0) {
            return DataBreakPoint.dbpUserMap[n5 >>> 12].mmdRws(n5);
        }
        byte by = DataBreakPoint.dbpUserMap[n5 >>> 12].mmdRbs(n5);
        m60FSLW ^= 0x8000000;
        int n6 = MC68060.mmuTranslateReadUserData(n + 1);
        return by << 8 | DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRbz(n6);
    }

    public static int mmuReadWordZeroData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 21299200;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 1) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRwz(n3);
            }
            int n4 = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbz(n3);
            m60FSLW ^= 0x8000000;
            int n5 = MC68060.mmuTranslateReadSuperData(n + 1);
            return n4 << 8 | DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRbz(n5);
        }
        m60FSLW = 0x1410000;
        int n6 = MC68060.mmuTranslateReadUserData(n);
        if ((n & 1) == 0) {
            return DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRwz(n6);
        }
        int n7 = DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRbz(n6);
        m60FSLW ^= 0x8000000;
        int n8 = MC68060.mmuTranslateReadUserData(n + 1);
        return n7 << 8 | DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRbz(n8);
    }

    public static int mmuReadWordSignEven(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 21299200;
            n = MC68060.mmuTranslateReadSuperData(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRws(n);
        }
        m60FSLW = 0x1410000;
        n = MC68060.mmuTranslateReadUserData(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRws(n);
    }

    public static int mmuReadWordZeroEven(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 21299200;
            n = MC68060.mmuTranslateReadSuperData(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRwz(n);
        }
        m60FSLW = 0x1410000;
        n = MC68060.mmuTranslateReadUserData(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRwz(n);
    }

    public static int mmuReadWordSignExword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 155615232;
            n = MC68060.mmuTranslateReadSuperCode(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRws(n);
        }
        m60FSLW = 155353088;
        n = MC68060.mmuTranslateReadUserCode(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRws(n);
    }

    public static int mmuReadWordZeroExword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 155615232;
            n = MC68060.mmuTranslateReadSuperCode(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRwz(n);
        }
        m60FSLW = 155353088;
        n = MC68060.mmuTranslateReadUserCode(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRwz(n);
    }

    public static int mmuReadWordSignOpword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 21397504;
            n = MC68060.mmuTranslateReadSuperCode(n);
            return InstructionBreakPoint.ibpOp1SuperMap[n >>> 12].mmdRws(n);
        }
        m60FSLW = 21135360;
        n = MC68060.mmuTranslateReadUserCode(n);
        return InstructionBreakPoint.ibpOp1UserMap[n >>> 12].mmdRws(n);
    }

    public static int mmuReadWordZeroOpword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 21397504;
            n = MC68060.mmuTranslateReadSuperCode(n);
            return InstructionBreakPoint.ibpOp1SuperMap[n >>> 12].mmdRwz(n);
        }
        m60FSLW = 21135360;
        n = MC68060.mmuTranslateReadUserCode(n);
        return InstructionBreakPoint.ibpOp1UserMap[n >>> 12].mmdRwz(n);
    }

    public static int mmuReadLongData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 0x1050000;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 3) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRls(n3);
            }
            if ((n & 1) == 0) {
                int n4 = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3);
                m60FSLW ^= 0x8000000;
                int n5 = MC68060.mmuTranslateReadSuperData(n + 2);
                return n4 << 16 | DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRwz(n5);
            }
            byte by = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
            m60FSLW ^= 0x8000000;
            int n6 = MC68060.mmuTranslateReadSuperData(n + 1);
            int n7 = MC68060.mmuTranslateReadSuperData(n + 3);
            return by << 24 | DataBreakPoint.dbpSuperMap[n6 >>> 12].mmdRwz(n6) << 8 | DataBreakPoint.dbpSuperMap[n7 >>> 12].mmdRbz(n7);
        }
        m60FSLW = 0x1010000;
        int n8 = MC68060.mmuTranslateReadUserData(n);
        if ((n & 3) == 0) {
            return DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRls(n8);
        }
        if ((n & 1) == 0) {
            int n9 = DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRws(n8);
            m60FSLW ^= 0x8000000;
            int n10 = MC68060.mmuTranslateReadUserData(n + 2);
            return n9 << 16 | DataBreakPoint.dbpUserMap[n10 >>> 12].mmdRwz(n10);
        }
        byte by = DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRbs(n8);
        m60FSLW ^= 0x8000000;
        int n11 = MC68060.mmuTranslateReadUserData(n + 1);
        int n12 = MC68060.mmuTranslateReadUserData(n + 3);
        return by << 24 | DataBreakPoint.dbpUserMap[n11 >>> 12].mmdRwz(n11) << 8 | DataBreakPoint.dbpUserMap[n12 >>> 12].mmdRbz(n12);
    }

    public static int mmuReadLongEven(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 0x1050000;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 2) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRls(n3);
            }
            int n4 = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3);
            m60FSLW ^= 0x8000000;
            int n5 = MC68060.mmuTranslateReadSuperData(n + 2);
            return n4 << 16 | DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRwz(n5);
        }
        m60FSLW = 0x1010000;
        int n6 = MC68060.mmuTranslateReadUserData(n);
        if ((n & 2) == 0) {
            return DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRls(n6);
        }
        int n7 = DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRws(n6);
        m60FSLW ^= 0x8000000;
        int n8 = MC68060.mmuTranslateReadUserData(n + 2);
        return n7 << 16 | DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRwz(n8);
    }

    public static int mmuReadLongExword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 151420928;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 2) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRls(n3);
            }
            int n4 = MC68060.mmuTranslateReadSuperData(n + 2);
            return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3) << 16 | DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdRwz(n4);
        }
        m60FSLW = 151158784;
        int n5 = MC68060.mmuTranslateReadUserData(n);
        if ((n & 2) == 0) {
            return DataBreakPoint.dbpUserMap[n5 >>> 12].mmdRls(n5);
        }
        int n6 = MC68060.mmuTranslateReadUserData(n + 2);
        return DataBreakPoint.dbpUserMap[n5 >>> 12].mmdRws(n5) << 16 | DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRwz(n6);
    }

    public static int mmuReadLongFour(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 0x1050000;
            n = MC68060.mmuTranslateReadSuperData(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRls(n);
        }
        m60FSLW = 0x1010000;
        n = MC68060.mmuTranslateReadUserData(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRls(n);
    }

    public static long mmuReadQuadData(int n, int n2) throws M68kException {
        long l;
        if (n2 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            m60FSLW = 23396352;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 3) == 0) {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 4);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
            } else if ((n & 1) == 0) {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRws(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 2);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 6);
                l = l << 16 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRwz(n3);
            } else if ((n & 3) == 1) {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRbs(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 1);
                l = l << 16 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRwz(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 3);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRbz(n3);
            } else {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRbs(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 1);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 5);
                l = l << 16 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRwz(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRbz(n3);
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            m60FSLW = 0x1610000;
            int n4 = MC68060.mmuTranslateReadUserData(n);
            if ((n & 3) == 0) {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 4);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
            } else if ((n & 1) == 0) {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRws(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 2);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 6);
                l = l << 16 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRwz(n4);
            } else if ((n & 3) == 1) {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRbs(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 1);
                l = l << 16 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRwz(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 3);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRbz(n4);
            } else {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRbs(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 1);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 5);
                l = l << 16 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRwz(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRbz(n4);
            }
        }
        return l;
    }

    public static long mmuReadQuadSecond(int n, int n2) throws M68kException {
        long l;
        if (n2 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            m60FSLW = 157614080;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 3) == 0) {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 4);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
            } else if ((n & 1) == 0) {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRws(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 2);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 6);
                l = l << 16 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRwz(n3);
            } else if ((n & 3) == 1) {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRbs(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 1);
                l = l << 16 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRwz(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 3);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRbz(n3);
            } else {
                l = memoryMappedDeviceArray[n3 >>> 12].mmdRbs(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 1);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n3 >>> 12].mmdRls(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 5);
                l = l << 16 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRwz(n3);
                m60FSLW = 157614080;
                n3 = MC68060.mmuTranslateReadSuperData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n3 >>> 12].mmdRbz(n3);
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            m60FSLW = 157351936;
            int n4 = MC68060.mmuTranslateReadUserData(n);
            if ((n & 3) == 0) {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 4);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
            } else if ((n & 1) == 0) {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRws(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 2);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 6);
                l = l << 16 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRwz(n4);
            } else if ((n & 3) == 1) {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRbs(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 1);
                l = l << 16 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRwz(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 3);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRbz(n4);
            } else {
                l = memoryMappedDeviceArray[n4 >>> 12].mmdRbs(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 1);
                l = l << 32 | 0xFFFFFFFFL & (long)memoryMappedDeviceArray[n4 >>> 12].mmdRls(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 5);
                l = l << 16 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRwz(n4);
                m60FSLW = 157351936;
                n4 = MC68060.mmuTranslateReadUserData(n + 7);
                l = l << 8 | (long)memoryMappedDeviceArray[n4 >>> 12].mmdRbz(n4);
            }
        }
        return l;
    }

    public static long mmuReadQuadExword(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 157712384;
            int n3 = MC68060.mmuTranslateReadSuperData(n);
            if ((n & 2) == 0) {
                int n4 = MC68060.mmuTranslateReadSuperData(n + 4);
                return (long)DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRls(n3) << 32 | (long)DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdRls(n4) & 0xFFFFFFFFL;
            }
            int n5 = MC68060.mmuTranslateReadSuperData(n + 2);
            int n6 = MC68060.mmuTranslateReadSuperData(n + 6);
            return (long)DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3) << 48 | (long)DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRls(n5) << 16 & 0xFFFFFFFF0000L | (long)DataBreakPoint.dbpSuperMap[n6 >>> 12].mmdRwz(n6);
        }
        m60FSLW = 157450240;
        int n7 = MC68060.mmuTranslateReadUserData(n);
        if ((n & 2) == 0) {
            int n8 = MC68060.mmuTranslateReadUserData(n + 4);
            return (long)DataBreakPoint.dbpUserMap[n7 >>> 12].mmdRls(n7) << 32 | (long)DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRls(n8) & 0xFFFFFFFFL;
        }
        int n9 = MC68060.mmuTranslateReadUserData(n + 2);
        int n10 = MC68060.mmuTranslateReadUserData(n + 6);
        return (long)DataBreakPoint.dbpUserMap[n7 >>> 12].mmdRws(n7) << 48 | (long)DataBreakPoint.dbpUserMap[n9 >>> 12].mmdRls(n9) << 16 & 0xFFFFFFFF0000L | (long)DataBreakPoint.dbpUserMap[n10 >>> 12].mmdRwz(n10);
    }

    public static byte mmuModifyByteSignData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 27590656;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            return (n ^ n3) == 1 ? (byte)-1 : DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
        }
        m60FSLW = 0x1A10000;
        int n4 = MC68060.mmuTranslateWriteUserData(n);
        return (n ^ n4) == 1 ? (byte)-1 : DataBreakPoint.dbpUserMap[n4 >>> 12].mmdRbs(n4);
    }

    public static int mmuModifyByteZeroData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 27590656;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            return (n ^ n3) == 1 ? 255 : DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbz(n3);
        }
        m60FSLW = 0x1A10000;
        int n4 = MC68060.mmuTranslateWriteUserData(n);
        return (n ^ n4) == 1 ? 255 : DataBreakPoint.dbpUserMap[n4 >>> 12].mmdRbz(n4);
    }

    public static int mmuModifyWordSignData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 29687808;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 1) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3);
            }
            byte by = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
            m60FSLW ^= 0x8000000;
            int n4 = MC68060.mmuTranslateWriteSuperData(n + 1);
            return by << 8 | DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdRbz(n4);
        }
        m60FSLW = 0x1C10000;
        int n5 = MC68060.mmuTranslateWriteUserData(n);
        if ((n & 1) == 0) {
            return DataBreakPoint.dbpUserMap[n5 >>> 12].mmdRws(n5);
        }
        byte by = DataBreakPoint.dbpUserMap[n5 >>> 12].mmdRbs(n5);
        m60FSLW ^= 0x8000000;
        int n6 = MC68060.mmuTranslateWriteUserData(n + 1);
        return by << 8 | DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRbz(n6);
    }

    public static int mmuModifyWordZeroData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 29687808;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 1) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRwz(n3);
            }
            int n4 = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbz(n3);
            m60FSLW ^= 0x8000000;
            int n5 = MC68060.mmuTranslateWriteSuperData(n + 1);
            return n4 << 8 | DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRbz(n5);
        }
        m60FSLW = 0x1C10000;
        int n6 = MC68060.mmuTranslateWriteUserData(n);
        if ((n & 1) == 0) {
            return DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRwz(n6);
        }
        int n7 = DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRbz(n6);
        m60FSLW ^= 0x8000000;
        int n8 = MC68060.mmuTranslateWriteUserData(n + 1);
        return n7 << 8 | DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRbz(n8);
    }

    public static int mmuModifyWordSignEven(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 29687808;
            n = MC68060.mmuTranslateWriteSuperData(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRws(n);
        }
        m60FSLW = 0x1C10000;
        n = MC68060.mmuTranslateWriteUserData(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRws(n);
    }

    public static int mmuModifyWordZeroEven(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 29687808;
            n = MC68060.mmuTranslateWriteSuperData(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRwz(n);
        }
        m60FSLW = 0x1C10000;
        n = MC68060.mmuTranslateWriteUserData(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRwz(n);
    }

    public static int mmuModifyLongData(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 25493504;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 3) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRls(n3);
            }
            if ((n & 1) == 0) {
                int n4 = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3);
                m60FSLW ^= 0x8000000;
                int n5 = MC68060.mmuTranslateWriteSuperData(n + 2);
                return n4 << 16 | DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRwz(n5);
            }
            byte by = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRbs(n3);
            m60FSLW ^= 0x8000000;
            int n6 = MC68060.mmuTranslateWriteSuperData(n + 1);
            int n7 = MC68060.mmuTranslateWriteSuperData(n + 3);
            return by << 24 | DataBreakPoint.dbpSuperMap[n6 >>> 12].mmdRwz(n6) << 8 | DataBreakPoint.dbpSuperMap[n7 >>> 12].mmdRbz(n7);
        }
        m60FSLW = 0x1810000;
        int n8 = MC68060.mmuTranslateWriteUserData(n);
        if ((n & 3) == 0) {
            return DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRls(n8);
        }
        if ((n & 1) == 0) {
            int n9 = DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRws(n8);
            m60FSLW ^= 0x8000000;
            int n10 = MC68060.mmuTranslateWriteUserData(n + 2);
            return n9 << 16 | DataBreakPoint.dbpUserMap[n10 >>> 12].mmdRwz(n10);
        }
        byte by = DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRbs(n8);
        m60FSLW ^= 0x8000000;
        int n11 = MC68060.mmuTranslateWriteUserData(n + 1);
        int n12 = MC68060.mmuTranslateWriteUserData(n + 3);
        return by << 24 | DataBreakPoint.dbpUserMap[n11 >>> 12].mmdRwz(n11) << 8 | DataBreakPoint.dbpUserMap[n12 >>> 12].mmdRbz(n12);
    }

    public static int mmuModifyLongEven(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 25493504;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 2) == 0) {
                return DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRls(n3);
            }
            int n4 = DataBreakPoint.dbpSuperMap[n3 >>> 12].mmdRws(n3);
            m60FSLW ^= 0x8000000;
            int n5 = MC68060.mmuTranslateWriteSuperData(n + 2);
            return n4 << 16 | DataBreakPoint.dbpSuperMap[n5 >>> 12].mmdRwz(n5);
        }
        m60FSLW = 0x1810000;
        int n6 = MC68060.mmuTranslateWriteUserData(n);
        if ((n & 2) == 0) {
            return DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRls(n6);
        }
        int n7 = DataBreakPoint.dbpUserMap[n6 >>> 12].mmdRws(n6);
        m60FSLW ^= 0x8000000;
        int n8 = MC68060.mmuTranslateWriteUserData(n + 2);
        return n7 << 16 | DataBreakPoint.dbpUserMap[n8 >>> 12].mmdRwz(n8);
    }

    public static int mmuModifyLongFour(int n, int n2) throws M68kException {
        if (n2 != 0) {
            m60FSLW = 25493504;
            n = MC68060.mmuTranslateWriteSuperData(n);
            return DataBreakPoint.dbpSuperMap[n >>> 12].mmdRls(n);
        }
        m60FSLW = 0x1810000;
        n = MC68060.mmuTranslateWriteUserData(n);
        return DataBreakPoint.dbpUserMap[n >>> 12].mmdRls(n);
    }

    public static void mmuPokeByte(int n, int n2, int n3) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n3 = n3 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n3 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n3 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n3 < 0) {
            int n4 = MC68060.mmuTranslatePeek(n, n3 & 4, n3 & 2);
            if ((n ^ n4) != 1) {
                memoryMappedDeviceArray[n4 >>> 12].mmdVb(n4, n2);
            }
        } else if (n3 != 7) {
            memoryMappedDeviceArray[n >>> 12].mmdVb(n, n2);
        }
    }

    public static void mmuPokeByteData(int n, int n2, int n3) {
        MemoryMappedDevice[] memoryMappedDeviceArray = n3 != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        int n4 = MC68060.mmuTranslatePeek(n, n3, 0);
        if ((n ^ n4) != 1) {
            XEiJ.busVb(n4, n2);
        }
    }

    public static void mmuPokeWord(int n, int n2, int n3) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n3 = n3 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n3 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n3 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n3 < 0) {
            int n4 = MC68060.mmuTranslatePeek(n, n3 & 4, n3 & 2);
            if ((n & 1) == 0) {
                if ((n ^ n4) != 1) {
                    memoryMappedDeviceArray[n4 >>> 12].mmdVw(n4, n2);
                }
            } else {
                int n5 = MC68060.mmuTranslatePeek(n + 1, n3 & 4, n3 & 2);
                if ((n ^ n4) != 1) {
                    memoryMappedDeviceArray[n4 >>> 12].mmdVb(n4, n2 >> 8);
                }
                if ((n + 1 ^ n5) != 1) {
                    memoryMappedDeviceArray[n5 >>> 12].mmdVb(n5, n2);
                }
            }
        } else if (n3 != 7) {
            if ((n & 1) == 0) {
                memoryMappedDeviceArray[n >>> 12].mmdVw(n, n2);
            } else {
                memoryMappedDeviceArray[n >>> 12].mmdVb(n, n2 >> 8);
                memoryMappedDeviceArray[n + 1 >>> 12].mmdVb(n + 1, n2);
            }
        }
    }

    public static void mmuPokeWordData(int n, int n2, int n3) {
        MC68060.mmuPokeByteData(n, n2 >> 8, n3);
        MC68060.mmuPokeByteData(n + 1, n2, n3);
    }

    public static void mmuPokeLong(int n, int n2, int n3) {
        MemoryMappedDevice[] memoryMappedDeviceArray;
        n3 = n3 == -1 ? (XEiJ.regSRS != 0 ? 5 : 1) : n3 & 7;
        MemoryMappedDevice[] memoryMappedDeviceArray2 = memoryMappedDeviceArray = (n3 & 4) != 0 ? DataBreakPoint.dbpSuperMap : DataBreakPoint.dbpUserMap;
        if (0x66000000 << n3 < 0) {
            int n4 = MC68060.mmuTranslatePeek(n, n3 & 4, n3 & 2);
            if ((n & 3) == 0) {
                if ((n ^ n4) != 1) {
                    memoryMappedDeviceArray[n4 >>> 12].mmdVl(n4, n2);
                }
            } else if ((n & 1) == 0) {
                int n5 = MC68060.mmuTranslatePeek(n + 2, n3 & 4, n3 & 2);
                if ((n ^ n4) != 1) {
                    memoryMappedDeviceArray[n4 >>> 12].mmdVw(n4, n2 >> 16);
                }
                if ((n + 2 ^ n5) != 1) {
                    memoryMappedDeviceArray[n5 >>> 12].mmdVw(n5, n2);
                }
            } else {
                int n6 = MC68060.mmuTranslatePeek(n + 1, n3 & 4, n3 & 2);
                int n7 = MC68060.mmuTranslatePeek(n + 3, n3 & 4, n3 & 2);
                if ((n ^ n4) != 1) {
                    memoryMappedDeviceArray[n4 >>> 12].mmdVb(n4, n2 >> 24);
                }
                if ((n + 1 ^ n6) != 1) {
                    memoryMappedDeviceArray[n6 >>> 12].mmdVw(n6, n2 >> 8);
                }
                if ((n + 3 ^ n7) != 1) {
                    memoryMappedDeviceArray[n7 >>> 12].mmdVb(n7, n2);
                }
            }
        } else if (n3 != 7) {
            if ((n & 3) == 0) {
                memoryMappedDeviceArray[n >>> 12].mmdVl(n, n2);
            } else if ((n & 1) == 0) {
                memoryMappedDeviceArray[n >>> 12].mmdVw(n, n2 >> 16);
                memoryMappedDeviceArray[n + 2 >>> 12].mmdVw(n + 2, n2);
            } else {
                memoryMappedDeviceArray[n >>> 12].mmdVb(n, n2 >> 24);
                memoryMappedDeviceArray[n + 1 >>> 12].mmdVw(n + 1, n2 >> 8);
                memoryMappedDeviceArray[n + 3 >>> 12].mmdVb(n + 3, n2);
            }
        }
    }

    public static void mmuPokeLongData(int n, int n2, int n3) {
        MC68060.mmuPokeByteData(n, n2 >> 24, n3);
        MC68060.mmuPokeByteData(n + 1, n2 >> 16, n3);
        MC68060.mmuPokeByteData(n + 2, n2 >> 8, n3);
        MC68060.mmuPokeByteData(n + 3, n2, n3);
    }

    public static void mmuPokeQuad(int n, long l, int n2) {
        MC68060.mmuPokeLong(n, (int)(l >> 32), n2);
        MC68060.mmuPokeLong(n + 4, (int)l, n2);
    }

    public static void mmuPokeExtended(int n, byte[] byArray, int n2) {
        for (int i = 0; i < 12; ++i) {
            MC68060.mmuPokeByte(n + i, byArray[i], n2);
        }
    }

    public static String mmuPokeStringZ(int n, String string, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = string.length();
        for (int i = 0; i < n4 && (n3 = string.charAt(i)) != 0; ++i) {
            int n5 = CharacterCode.chrCharToSJIS[n3];
            if (n5 == 0) {
                n5 = 33190;
            }
            if (n5 >> 8 != 0) {
                MC68060.mmuPokeByte(n++, n5 >> 8, n2);
            }
            MC68060.mmuPokeByte(n++, n5, n2);
            n3 = CharacterCode.chrSJISToChar[n5];
            if (n3 == 0) {
                n3 = 65533;
            }
            stringBuilder.append((char)n3);
        }
        MC68060.mmuPokeByte(n, 0, n2);
        return stringBuilder.toString();
    }

    public static void mmuWriteByteData(int n, int n2, int n3) throws M68kException {
        if (n3 != 0) {
            m60FSLW = 0xA50000;
            int n4 = MC68060.mmuTranslateWriteSuperData(n);
            DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWb(n4, n2);
        } else {
            m60FSLW = 0xA10000;
            int n5 = MC68060.mmuTranslateWriteUserData(n);
            DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWb(n5, n2);
        }
    }

    public static void mmuWriteWordData(int n, int n2, int n3) throws M68kException {
        if (n3 != 0) {
            m60FSLW = 0xC50000;
            int n4 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 1) == 0) {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWw(n4, n2);
            } else {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWb(n4, n2 >> 8);
                m60FSLW ^= 0x8000000;
                n4 = MC68060.mmuTranslateWriteSuperData(n + 1);
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWb(n4, n2);
            }
        } else {
            m60FSLW = 0xC10000;
            int n5 = MC68060.mmuTranslateWriteUserData(n);
            if ((n & 1) == 0) {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWw(n5, n2);
            } else {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWb(n5, n2 >> 8);
                m60FSLW ^= 0x8000000;
                n5 = MC68060.mmuTranslateWriteUserData(n + 1);
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWb(n5, n2);
            }
        }
    }

    public static void mmuWriteWordEven(int n, int n2, int n3) throws M68kException {
        if (n3 != 0) {
            m60FSLW = 0xC50000;
            n = MC68060.mmuTranslateWriteSuperData(n);
            DataBreakPoint.dbpSuperMap[n >>> 12].mmdWw(n, n2);
        } else {
            m60FSLW = 0xC10000;
            n = MC68060.mmuTranslateWriteUserData(n);
            DataBreakPoint.dbpUserMap[n >>> 12].mmdWw(n, n2);
        }
    }

    public static void mmuWriteLongData(int n, int n2, int n3) throws M68kException {
        if (n3 != 0) {
            m60FSLW = 0x850000;
            int n4 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 3) == 0) {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWl(n4, n2);
            } else if ((n & 1) == 0) {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWw(n4, n2 >> 16);
                m60FSLW ^= 0x8000000;
                n4 = MC68060.mmuTranslateWriteSuperData(n + 2);
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWw(n4, n2);
            } else {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWb(n4, n2 >> 24);
                m60FSLW ^= 0x8000000;
                n4 = MC68060.mmuTranslateWriteSuperData(n + 1);
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWw(n4, n2 >> 8);
                n4 = MC68060.mmuTranslateWriteSuperData(n + 3);
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWb(n4, n2);
            }
        } else {
            m60FSLW = 0x810000;
            int n5 = MC68060.mmuTranslateWriteUserData(n);
            if ((n & 3) == 0) {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWl(n5, n2);
            } else if ((n & 1) == 0) {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWw(n5, n2 >> 16);
                m60FSLW ^= 0x8000000;
                n5 = MC68060.mmuTranslateWriteUserData(n + 2);
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWw(n5, n2);
            } else {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWb(n5, n2 >> 24);
                m60FSLW ^= 0x8000000;
                n5 = MC68060.mmuTranslateWriteUserData(n + 1);
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWw(n5, n2 >> 8);
                n5 = MC68060.mmuTranslateWriteUserData(n + 3);
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWb(n5, n2);
            }
        }
    }

    public static void mmuWriteLongEven(int n, int n2, int n3) throws M68kException {
        if (n3 != 0) {
            m60FSLW = 0x850000;
            int n4 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 2) == 0) {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWl(n4, n2);
            } else {
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWw(n4, n2 >> 16);
                m60FSLW ^= 0x8000000;
                n4 = MC68060.mmuTranslateWriteSuperData(n + 2);
                DataBreakPoint.dbpSuperMap[n4 >>> 12].mmdWw(n4, n2);
            }
        } else {
            m60FSLW = 0x810000;
            int n5 = MC68060.mmuTranslateWriteUserData(n);
            if ((n & 2) == 0) {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWl(n5, n2);
            } else {
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWw(n5, n2 >> 16);
                m60FSLW ^= 0x8000000;
                n5 = MC68060.mmuTranslateWriteUserData(n + 2);
                DataBreakPoint.dbpUserMap[n5 >>> 12].mmdWw(n5, n2);
            }
        }
    }

    public static void mmuWriteLongFour(int n, int n2, int n3) throws M68kException {
        if (n3 != 0) {
            m60FSLW = 0x850000;
            n = MC68060.mmuTranslateWriteSuperData(n);
            DataBreakPoint.dbpSuperMap[n >>> 12].mmdWl(n, n2);
        } else {
            m60FSLW = 0x810000;
            n = MC68060.mmuTranslateWriteUserData(n);
            DataBreakPoint.dbpUserMap[n >>> 12].mmdWl(n, n2);
        }
    }

    public static void mmuWriteQuadData(int n, long l, int n2) throws M68kException {
        if (n2 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            m60FSLW = 0xE50000;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 3) == 0) {
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 32));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 4);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)l);
            } else if ((n & 1) == 0) {
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)(l >> 48));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 2);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 16));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 6);
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)l);
            } else if ((n & 3) == 1) {
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)(l >> 56));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 1);
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)(l >> 40));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 3);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 8));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 7);
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)l);
            } else {
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)(l >> 56));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 1);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 24));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 5);
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)(l >> 8));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 7);
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)l);
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            m60FSLW = 0xE10000;
            int n4 = MC68060.mmuTranslateWriteUserData(n);
            if ((n & 3) == 0) {
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 32));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 4);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)l);
            } else if ((n & 1) == 0) {
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)(l >> 48));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 2);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 16));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 6);
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)l);
            } else if ((n & 3) == 1) {
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)(l >> 56));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 1);
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)(l >> 40));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 3);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 8));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 7);
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)l);
            } else {
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)(l >> 56));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 1);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 24));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 5);
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)(l >> 8));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 7);
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)l);
            }
        }
    }

    public static void mmuWriteQuadSecond(int n, long l, int n2) throws M68kException {
        if (n2 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            m60FSLW = 149225472;
            int n3 = MC68060.mmuTranslateWriteSuperData(n);
            if ((n & 3) == 0) {
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 32));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 4);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)l);
            } else if ((n & 1) == 0) {
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)(l >> 48));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 2);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 16));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 6);
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)l);
            } else if ((n & 3) == 1) {
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)(l >> 56));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 1);
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)(l >> 40));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 3);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 8));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 7);
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)l);
            } else {
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)(l >> 56));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 1);
                memoryMappedDeviceArray[n3 >>> 12].mmdWl(n3, (int)(l >> 24));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 5);
                memoryMappedDeviceArray[n3 >>> 12].mmdWw(n3, (int)(l >> 8));
                m60FSLW = 149225472;
                n3 = MC68060.mmuTranslateWriteSuperData(n + 7);
                memoryMappedDeviceArray[n3 >>> 12].mmdWb(n3, (int)l);
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            m60FSLW = 148963328;
            int n4 = MC68060.mmuTranslateWriteUserData(n);
            if ((n & 3) == 0) {
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 32));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 4);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)l);
            } else if ((n & 1) == 0) {
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)(l >> 48));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 2);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 16));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 6);
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)l);
            } else if ((n & 3) == 1) {
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)(l >> 56));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 1);
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)(l >> 40));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 3);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 8));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 7);
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)l);
            } else {
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)(l >> 56));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 1);
                memoryMappedDeviceArray[n4 >>> 12].mmdWl(n4, (int)(l >> 24));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 5);
                memoryMappedDeviceArray[n4 >>> 12].mmdWw(n4, (int)(l >> 8));
                m60FSLW = 148963328;
                n4 = MC68060.mmuTranslateWriteUserData(n + 7);
                memoryMappedDeviceArray[n4 >>> 12].mmdWb(n4, (int)l);
            }
        }
    }

    public static void mmuReadByteArray(int n, byte[] byArray, int n2, int n3, int n4) throws M68kException {
        n3 += n2;
        int n5 = Math.min(4096, mmuPageSize) - 1;
        if (n4 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            int n6 = 0;
            MemoryMappedDevice memoryMappedDevice = null;
            while (n2 < n3) {
                int n7;
                if ((n & n5) == 0) {
                    memoryMappedDevice = null;
                }
                if ((n & 3) == 0 && n2 + 4 <= n3) {
                    m60FSLW = 0x1050000;
                    if (memoryMappedDevice == null) {
                        n6 = MC68060.mmuTranslateReadSuperData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                    }
                    n7 = memoryMappedDevice.mmdRls(n6);
                    byArray[n2] = (byte)(n7 >> 24);
                    byArray[n2 + 1] = (byte)(n7 >> 16);
                    byArray[n2 + 2] = (byte)(n7 >> 8);
                    byArray[n2 + 3] = (byte)n7;
                    n += 4;
                    n6 += 4;
                    n2 += 4;
                    continue;
                }
                if ((n & 1) == 0 && n2 + 2 <= n3) {
                    m60FSLW = 21299200;
                    if (memoryMappedDevice == null) {
                        n6 = MC68060.mmuTranslateReadSuperData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                    }
                    n7 = memoryMappedDevice.mmdRws(n6);
                    byArray[n2] = (byte)(n7 >> 8);
                    byArray[n2 + 1] = (byte)n7;
                    n += 2;
                    n6 += 2;
                    n2 += 2;
                    continue;
                }
                m60FSLW = 19202048;
                if (memoryMappedDevice == null) {
                    n6 = MC68060.mmuTranslateReadSuperData(n);
                    memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                }
                byArray[n2] = memoryMappedDevice.mmdRbs(n6);
                ++n;
                ++n6;
                ++n2;
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            int n8 = 0;
            MemoryMappedDevice memoryMappedDevice = null;
            while (n2 < n3) {
                int n9;
                if ((n & n5) == 0) {
                    memoryMappedDevice = null;
                }
                if ((n & 3) == 0 && n2 + 4 <= n3) {
                    m60FSLW = 0x1010000;
                    if (memoryMappedDevice == null) {
                        n8 = MC68060.mmuTranslateReadUserData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n8 >>> 12];
                    }
                    n9 = memoryMappedDevice.mmdRls(n8);
                    byArray[n2] = (byte)(n9 >> 24);
                    byArray[n2 + 1] = (byte)(n9 >> 16);
                    byArray[n2 + 2] = (byte)(n9 >> 8);
                    byArray[n2 + 3] = (byte)n9;
                    n += 4;
                    n8 += 4;
                    n2 += 4;
                    continue;
                }
                if ((n & 1) == 0 && n2 + 2 <= n3) {
                    m60FSLW = 0x1410000;
                    if (memoryMappedDevice == null) {
                        n8 = MC68060.mmuTranslateReadUserData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n8 >>> 12];
                    }
                    n9 = memoryMappedDevice.mmdRws(n8);
                    byArray[n2] = (byte)(n9 >> 8);
                    byArray[n2 + 1] = (byte)n9;
                    n += 2;
                    n8 += 2;
                    n2 += 2;
                    continue;
                }
                m60FSLW = 0x1210000;
                if (memoryMappedDevice == null) {
                    n8 = MC68060.mmuTranslateReadUserData(n);
                    memoryMappedDevice = memoryMappedDeviceArray[n8 >>> 12];
                }
                byArray[n2] = memoryMappedDevice.mmdRbs(n8);
                ++n;
                ++n8;
                ++n2;
            }
        }
    }

    public static void mmuWriteByteArray(int n, byte[] byArray, int n2, int n3, int n4) throws M68kException {
        n3 += n2;
        int n5 = Math.min(4096, mmuPageSize) - 1;
        if (n4 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            int n6 = 0;
            MemoryMappedDevice memoryMappedDevice = null;
            while (n2 < n3) {
                if ((n & n5) == 0) {
                    memoryMappedDevice = null;
                }
                if ((n & 3) == 0 && n2 + 4 <= n3) {
                    m60FSLW = 0x850000;
                    if (memoryMappedDevice == null) {
                        n6 = MC68060.mmuTranslateWriteSuperData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                    }
                    memoryMappedDevice.mmdWl(n6, byArray[n2] << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3]);
                    n += 4;
                    n6 += 4;
                    n2 += 4;
                    continue;
                }
                if ((n & 1) == 0 && n2 + 2 <= n3) {
                    m60FSLW = 0xC50000;
                    if (memoryMappedDevice == null) {
                        n6 = MC68060.mmuTranslateWriteSuperData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                    }
                    memoryMappedDevice.mmdWw(n6, byArray[n2] << 8 | 0xFF & byArray[n2 + 1]);
                    n += 2;
                    n6 += 2;
                    n2 += 2;
                    continue;
                }
                m60FSLW = 0xA50000;
                if (memoryMappedDevice == null) {
                    n6 = MC68060.mmuTranslateWriteSuperData(n);
                    memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                }
                memoryMappedDevice.mmdWb(n6, byArray[n2]);
                ++n;
                ++n6;
                ++n2;
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            int n7 = 0;
            MemoryMappedDevice memoryMappedDevice = null;
            while (n2 < n3) {
                if ((n & n5) == 0) {
                    memoryMappedDevice = null;
                }
                if ((n & 3) == 0 && n2 + 4 <= n3) {
                    m60FSLW = 0x810000;
                    if (memoryMappedDevice == null) {
                        n7 = MC68060.mmuTranslateWriteUserData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n7 >>> 12];
                    }
                    memoryMappedDevice.mmdWl(n7, byArray[n2] << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3]);
                    n += 4;
                    n7 += 4;
                    n2 += 4;
                    continue;
                }
                if ((n & 1) == 0 && n2 + 2 <= n3) {
                    m60FSLW = 0xC10000;
                    if (memoryMappedDevice == null) {
                        n7 = MC68060.mmuTranslateWriteUserData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n7 >>> 12];
                    }
                    memoryMappedDevice.mmdWw(n7, byArray[n2] << 8 | 0xFF & byArray[n2 + 1]);
                    n += 2;
                    n7 += 2;
                    n2 += 2;
                    continue;
                }
                m60FSLW = 0xA10000;
                if (memoryMappedDevice == null) {
                    n7 = MC68060.mmuTranslateWriteUserData(n);
                    memoryMappedDevice = memoryMappedDeviceArray[n7 >>> 12];
                }
                memoryMappedDevice.mmdWb(n7, byArray[n2]);
                ++n;
                ++n7;
                ++n2;
            }
        }
    }

    public static void mmuWriteByteArrayDecrement(int n, byte[] byArray, int n2, int n3, int n4) throws M68kException {
        n += n3;
        n2 += n3;
        n3 = n2 - n3;
        int n5 = Math.min(4096, mmuPageSize) - 1;
        if (n4 != 0) {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpSuperMap;
            int n6 = 0;
            MemoryMappedDevice memoryMappedDevice = null;
            while (n3 < n2) {
                if ((n & n5) == 0) {
                    memoryMappedDevice = null;
                }
                if ((n & 3) == 0 && n3 <= n2 - 4) {
                    m60FSLW = 0x850000;
                    n -= 4;
                    n6 -= 4;
                    n2 -= 4;
                    if (memoryMappedDevice == null) {
                        n6 = MC68060.mmuTranslateWriteSuperData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                    }
                    memoryMappedDevice.mmdWl(n6, byArray[n2] << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3]);
                    continue;
                }
                if ((n & 1) == 0 && n3 <= n2 - 2) {
                    m60FSLW = 0xC50000;
                    n -= 2;
                    n6 -= 2;
                    n2 -= 2;
                    if (memoryMappedDevice == null) {
                        n6 = MC68060.mmuTranslateWriteSuperData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                    }
                    memoryMappedDevice.mmdWw(n6, byArray[n2] << 8 | 0xFF & byArray[n2 + 1]);
                    continue;
                }
                m60FSLW = 0xA50000;
                --n;
                --n6;
                --n2;
                if (memoryMappedDevice == null) {
                    n6 = MC68060.mmuTranslateWriteSuperData(n);
                    memoryMappedDevice = memoryMappedDeviceArray[n6 >>> 12];
                }
                memoryMappedDevice.mmdWb(n6, byArray[n2]);
            }
        } else {
            MemoryMappedDevice[] memoryMappedDeviceArray = DataBreakPoint.dbpUserMap;
            int n7 = 0;
            MemoryMappedDevice memoryMappedDevice = null;
            while (n3 < n2) {
                if ((n & n5) == 0) {
                    memoryMappedDevice = null;
                }
                if ((n & 3) == 0 && n3 <= n2 - 4) {
                    m60FSLW = 0x810000;
                    n -= 4;
                    n7 -= 4;
                    n2 -= 4;
                    if (memoryMappedDevice == null) {
                        n7 = MC68060.mmuTranslateWriteUserData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n7 >>> 12];
                    }
                    memoryMappedDevice.mmdWl(n7, byArray[n2] << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3]);
                    continue;
                }
                if ((n & 1) == 0 && n3 <= n2 - 2) {
                    m60FSLW = 0xC10000;
                    n -= 2;
                    n7 -= 2;
                    n2 -= 2;
                    if (memoryMappedDevice == null) {
                        n7 = MC68060.mmuTranslateWriteUserData(n);
                        memoryMappedDevice = memoryMappedDeviceArray[n7 >>> 12];
                    }
                    memoryMappedDevice.mmdWw(n7, byArray[n2] << 8 | 0xFF & byArray[n2 + 1]);
                    continue;
                }
                m60FSLW = 0xA10000;
                --n;
                --n7;
                --n2;
                if (memoryMappedDevice == null) {
                    n7 = MC68060.mmuTranslateWriteUserData(n);
                    memoryMappedDevice = memoryMappedDeviceArray[n7 >>> 12];
                }
                memoryMappedDevice.mmdWb(n7, byArray[n2]);
            }
        }
    }

    public static int mmuLoadPhysicalAddressRead(int n) throws M68kException {
        m60FSLW = 0x1200000 | XEiJ.mpuDFC << 16;
        return -1627389952 << XEiJ.mpuDFC < 0 ? (0x2A000000 << XEiJ.mpuDFC < 0 ? MC68060.mmuTranslateReadSuperCode(n) : MC68060.mmuTranslateReadSuperData(n)) : (0x2A000000 << XEiJ.mpuDFC < 0 ? MC68060.mmuTranslateReadUserCode(n) : MC68060.mmuTranslateReadUserData(n));
    }

    public static int mmuLoadPhysicalAddressWrite(int n) throws M68kException {
        m60FSLW = 0xA00000 | XEiJ.mpuDFC << 16;
        return -1627389952 << XEiJ.mpuDFC < 0 ? (0x2A000000 << XEiJ.mpuDFC < 0 ? MC68060.mmuTranslateWriteSuperCode(n) : MC68060.mmuTranslateWriteSuperData(n)) : (0x2A000000 << XEiJ.mpuDFC < 0 ? MC68060.mmuTranslateWriteUserCode(n) : MC68060.mmuTranslateWriteUserData(n));
    }

    public static int mmuTranslateReadUserData(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuUserDataCache[n3] == n2) {
            return mmuUserDataCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, false, false, false);
    }

    public static int mmuTranslateReadUserCode(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuUserCodeCache[n3] == n2) {
            return mmuUserCodeCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, false, false, true);
    }

    public static int mmuTranslateReadSuperData(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuSuperDataCache[n3] == n2) {
            return mmuSuperDataCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, false, true, false);
    }

    public static int mmuTranslateReadSuperCode(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuSuperCodeCache[n3] == n2) {
            return mmuSuperCodeCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, false, true, true);
    }

    public static int mmuTranslateWriteUserData(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuUserDataCache[n3 + 1] == n2) {
            return mmuUserDataCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, true, false, false);
    }

    public static int mmuTranslateWriteUserCode(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuUserCodeCache[n3 + 1] == n2) {
            return mmuUserCodeCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, true, false, true);
    }

    public static int mmuTranslateWriteSuperData(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuSuperDataCache[n3 + 1] == n2) {
            return mmuSuperDataCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, true, true, false);
    }

    public static int mmuTranslateWriteSuperCode(int n) throws M68kException {
        int n2 = n & mmuPageAddressMask;
        int n3 = (n2 * 1593577535 >>> -6) * 4;
        if (mmuSuperCodeCache[n3 + 1] == n2) {
            return mmuSuperCodeCache[n3 + 2] | n & mmuPageOffsetMask;
        }
        return MC68060.mmuTranslateCommon(n, true, true, true);
    }

    public static int mmuTranslateCommon(int n, boolean bl, boolean bl2, boolean bl3) throws M68kException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n & mmuPageAddressMask;
        int n7 = (bl2 ? (bl3 ? mmuSuperCodeTransparent : mmuSuperDataTransparent) : (bl3 ? mmuUserCodeTransparent : mmuUserDataTransparent))[n >>> 24];
        if (n7 != 0) {
            m60FSLW |= 8;
            if (bl && n7 < 0) {
                m60FSLW |= 0x80;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            n5 = n6;
            n4 = n6;
            n3 = -1;
            n2 = n;
        } else if (mmuEnabled) {
            int n8;
            MemoryMappedDevice memoryMappedDevice;
            int n9;
            int n10;
            MemoryMappedDevice memoryMappedDevice2;
            int n11;
            m60FSLW |= 0x40;
            int n12 = (bl2 ? mmuSRP : mmuURP) + ((n & 0xFE000000) >>> 23);
            MemoryMappedDevice memoryMappedDevice3 = DataBreakPoint.dbpSuperMap[n12 >>> 12];
            int n13 = memoryMappedDevice3.mmdRls(n12);
            if ((n13 & 2) == 0) {
                m60FSLW ^= 0x1040;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if (bl && (n13 & 4) != 0) {
                m60FSLW ^= 0xC0;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if ((n13 & 8) == 0) {
                memoryMappedDevice3.mmdWl(n12, n13 |= 8);
            }
            if (((n11 = (memoryMappedDevice2 = DataBreakPoint.dbpSuperMap[(n10 = (n13 & 0xFFFFFE00) + ((n & 0x1FC0000) >>> 16)) >>> 12]).mmdRls(n10)) & 2) == 0) {
                m60FSLW ^= 0x840;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if (bl && (n11 & 4) != 0) {
                m60FSLW ^= 0xC0;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if ((n11 & 8) == 0) {
                memoryMappedDevice2.mmdWl(n10, n11 |= 8);
            }
            if (((n9 = (memoryMappedDevice = DataBreakPoint.dbpSuperMap[(n8 = (n11 & mmuPageTableMask) + ((n & mmuPageIndexMask) >>> mmuPageIndexBit2)) >>> 12]).mmdRls(n8)) & 3) == 0) {
                m60FSLW ^= 0x240;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if ((n9 & 3) == 2) {
                n8 = n9 & 0xFFFFFFFC;
                memoryMappedDevice = DataBreakPoint.dbpSuperMap[n8 >>> 12];
                if (((n9 = memoryMappedDevice.mmdRls(n8)) & 3) == 0) {
                    m60FSLW ^= 0x240;
                    M68kException.m6eNumber = 2;
                    throw M68kException.m6eSignal;
                }
                if ((n9 & 3) == 2) {
                    m60FSLW ^= 0x440;
                    M68kException.m6eNumber = 2;
                    throw M68kException.m6eSignal;
                }
            }
            if (!bl2 && (n9 & 0x80) != 0) {
                m60FSLW ^= 0x140;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if (bl && (n9 & 4) != 0) {
                m60FSLW ^= 0xC0;
                M68kException.m6eNumber = 2;
                throw M68kException.m6eSignal;
            }
            if ((n9 & 8) == 0) {
                memoryMappedDevice.mmdWl(n8, n9 |= 8);
            }
            if (bl && (n9 & 0x10) == 0) {
                memoryMappedDevice.mmdWl(n8, n9 |= 0x10);
            }
            m60FSLW &= 0xFFFFFFBF;
            n5 = (n9 & 4) == 0 ? n6 : 1;
            n4 = n9 & mmuPageAddressMask;
            n3 = (n9 & 0x400) != 0 ? -1 : 0;
            n2 = n4 | n & mmuPageOffsetMask;
        } else {
            n5 = n6;
            n4 = n6;
            n3 = -1;
            n2 = n;
        }
        if (!(!bl3 ? mmuNotAllocateData : mmuNotAllocateCode)) {
            int[] nArray = bl2 ? (bl3 ? mmuSuperCodeCache : mmuSuperDataCache) : (bl3 ? mmuUserCodeCache : mmuUserDataCache);
            int n14 = (n6 * 1593577535 >>> -6) * 4;
            nArray[n14] = n6;
            nArray[n14 + 1] = n5;
            nArray[n14 + 2] = n4;
            nArray[n14 + 3] = n3;
        }
        return n2;
    }

    public static int mmuTranslatePeek(int n, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = new int[2];
        if (n3 != 0) {
            nArray[0] = mmuITT0;
            nArray[1] = mmuITT1;
        } else {
            nArray[0] = mmuDTT0;
            nArray[1] = mmuDTT1;
        }
        for (n5 = 0; n5 < 2; ++n5) {
            n4 = nArray[n5];
            if ((n4 & 0x8000) == 0 || (n4 & 0x4000) == 0 && (n4 & 0x2000) != 0 != (n2 != 0) || ((n ^ n4) & ~n4 << 8) >>> 24 != 0) continue;
            mmuPeekFlags = n4 & 4;
            return n;
        }
        if (!mmuEnabled) {
            mmuPeekFlags = 0;
            return n;
        }
        int n6 = n & mmuPageAddressMask;
        n5 = (n2 != 0 ? mmuSRP : mmuURP) + ((n & 0xFE000000) >>> 23);
        n4 = XEiJ.busPlsf(n5);
        if ((n4 & 2) == 0) {
            return n ^ 1;
        }
        int n7 = (n4 & 0xFFFFFE00) + ((n & 0x1FC0000) >>> 16);
        int n8 = XEiJ.busPlsf(n7);
        if ((n8 & 2) == 0) {
            return n ^ 1;
        }
        int n9 = (n8 & mmuPageTableMask) + ((n & mmuPageIndexMask) >>> mmuPageIndexBit2);
        int n10 = XEiJ.busPlsf(n9);
        if ((n10 & 3) == 0) {
            return n ^ 1;
        }
        if ((n10 & 3) == 2) {
            n9 = n10 & 0xFFFFFFFC;
            if (((n10 = XEiJ.busPlsf(n9)) & 3) == 0) {
                return n ^ 1;
            }
            if ((n10 & 3) == 2) {
                return n ^ 1;
            }
        }
        if (n2 == 0 && (n10 & 0x80) != 0) {
            return n ^ 1;
        }
        int n11 = n10 & mmuPageAddressMask;
        mmuPeekFlags = n10 & 0x9C;
        return n11 | n & mmuPageOffsetMask;
    }

    public static void m60BusErrorOnRead() {
        m60FSLW |= 0x20;
    }

    public static void m60BusErrorOnWrite() {
        m60FSLW |= 0x10;
    }

    private static String m60ErrorToString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = m60FSLW & 0x40000;
        int n2 = m60FSLW & 0x20000;
        if (0 <= M68kException.m6eNumber && M68kException.m6eNumber < M68kException.M6E_ERROR_NAME.length) {
            stringBuilder.append(M68kException.M6E_ERROR_NAME[M68kException.m6eNumber]);
        } else {
            stringBuilder.append("undefined exception #").append(M68kException.m6eNumber);
        }
        XEiJ.fmtHex8(stringBuilder.append(" at PC=$"), XEiJ.regPC0).append("($");
        int n3 = MC68060.mmuTranslatePeek(XEiJ.regPC0, n, 1);
        if ((XEiJ.regPC0 ^ n3) == 1) {
            stringBuilder.append("????????");
        } else {
            XEiJ.fmtHex8(stringBuilder, n3);
        }
        XEiJ.fmtHex4(stringBuilder.append("), SR=$"), XEiJ.regSRT1 | XEiJ.regSRS | XEiJ.regSRI | XEiJ.regCCR);
        if (3981182070595518464L << M68kException.m6eNumber < 0L) {
            XEiJ.fmtHex8(stringBuilder.append("\n  Fault or effective address is EA=$"), m60Address).append("($");
            n3 = MC68060.mmuTranslatePeek(m60Address, n, n2);
            if ((m60Address ^ n3) == 1) {
                stringBuilder.append("????????");
            } else {
                XEiJ.fmtHex8(stringBuilder, n3);
            }
            stringBuilder.append(')');
        }
        if (M68kException.m6eNumber == 2) {
            XEiJ.fmtHex8(stringBuilder.append("\n  Fault status long word is FSLW=$"), m60FSLW);
            stringBuilder.append("\n  Fault was caused by:");
            for (int i = 14; i >= 0; --i) {
                if ((m60FSLW & 1 << i) == 0) continue;
                stringBuilder.append("\n    ").append(M60_FSLW_TEXT_CAUSE[i]);
            }
            stringBuilder.append("\n  Fault occured on:\n    ").append(M60_FSLW_TEXT_IOMA[(m60FSLW & 0x8000) >>> 14 | (m60FSLW & 0x8000000) >>> 27]).append("\n    ").append(M60_FSLW_TEXT_LK[(m60FSLW & 0x2000000) >>> 25]).append("\n    ").append(M60_FSLW_TEXT_RW[(m60FSLW & 0x1800000) >>> 23]).append("\n    ").append(M60_FSLW_TEXT_SIZE[(m60FSLW & 0x600000) >>> 21]).append("\n    ").append(M60_FSLW_TEXT_TT[(m60FSLW & 0x180000) >>> 19]).append("\n    ").append(M60_FSLW_TEXT_TM[(m60FSLW & 0x70000) >>> 16]);
        }
        return stringBuilder.toString();
    }

    static {
        mmuUserDataCache = new int[256];
        mmuUserCodeCache = new int[256];
        mmuSuperDataCache = new int[256];
        mmuSuperCodeCache = new int[256];
        M60_FSLW_TEXT_IOMA = new String[]{"IO=0,MA=0  First access of a misaligned transfer or only access of an aligned transfer", "IO=0,MA=1  Second or later access of a misaligned transfer", "IO=1,MA=0  Instruction opword fetch", "IO=1,MA=1  Fetch of an extension word"};
        M60_FSLW_TEXT_LK = new String[]{"LK=0       Not locked", "LK=1       Locked"};
        M60_FSLW_TEXT_RW = new String[]{"RW=0       Undefined, reserved", "RW=1       Write", "RW=2       Read", "RW=3       Read-Modify-Write"};
        M60_FSLW_TEXT_SIZE = new String[]{"SIZE=0     Byte", "SIZE=1     Word", "SIZE=2     Long", "SIZE=3     Double precision or MOVE16"};
        M60_FSLW_TEXT_TT = new String[]{"TT=0       Normal access", "TT=1       MOVE16 access", "TT=2       Alternate or debug access", "TT=3       Acknowledge or LPSTOP broadcast"};
        M60_FSLW_TEXT_TM = new String[]{"TM=0       Data cache push access", "TM=1       User data or MOVE16 access", "TM=2       User code access", "TM=3       MMU table search data access", "TM=4       MMU table search code access", "TM=5       Supervisor data access", "TM=6       Supervisor code access", "TM=7       Reserved"};
        M60_FSLW_TEXT_CAUSE = new String[]{"SEE=1      Software emulation error", "", "BPE=1      Branch prediction error", "TTR=1      TTR hit", "WE=1       Bus error on write", "RE=1       Bus error on read", "TWE=1      Bus error on table search", "WP=1       Write protect", "SP=1       Supervisor protect", "PF=1       Page fault", "IL=1       Indirect level fault", "PTB=1      Pointer B fault", "PTA=1      Pointer A fault", "SBE=1      Store buffer bus error", "PBE=1      Push buffer bus error"};
    }
}

