/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import xeij.CharacterCode;
import xeij.ComponentFactory;
import xeij.Keyboard;
import xeij.MC68060;
import xeij.MainMemory;
import xeij.Multilingual;
import xeij.NamedPipeInputStream;
import xeij.Settings;
import xeij.XEiJ;

public class CONDevice {
    public static final long CON_PASTE_DELAY = 10L;
    public static final long CON_PASTE_INTERVAL = 10L;
    public static final String CON_PASTE_PIPE_NAME = "XEiJPaste";
    public static final String CON_CONTROL_PIPE_NAME = "XEiJControl";
    public static final int CON_PIPE_SJIS = 0;
    public static final int CON_PIPE_UTF8 = 1;
    public static int conPipeEncoding;
    public static final int CON_PIPE_INSTANCES_WIN = 4;
    public static final int CON_PIPE_INSTANCES_GEN = 2;
    public static int conPipeInstances;
    public static final String[] CON_KEY_BASE;
    public static boolean conPipeOn;
    public static JMenu conSettingsMenu;
    public static JCheckBoxMenuItem conPipeCheckBox;
    public static boolean conCleanupFlag;
    public static int conCON;
    public static CONPasteTask conPasteTask;
    public static LinkedBlockingQueue<String> conPasteQueue;
    public static CONPasteQueueThread conPasteQueueThread;
    public static HashMap<String, Integer> conKeyMap;
    public static LinkedBlockingQueue<String> conControlQueue;
    public static CONControlQueueThread conControlQueueThread;
    public static CONPipeThread[] conPipeThreadArray;

    public static void conInit() {
        conPipeOn = Settings.sgsGetOnOff("pastepipe");
        Object object = Settings.sgsGetString("pipeencoding").toLowerCase();
        conPipeEncoding = ((String)object).equals("utf8") ? 1 : 0;
        conPipeInstances = XEiJ.prgIsWindows ? 4 : 2;
        object = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Stop paste": {
                        CONDevice.conStopPaste();
                        break;
                    }
                    case "Paste and control pipe": {
                        CONDevice.conSetPipeOn(((JCheckBoxMenuItem)object).isSelected());
                        break;
                    }
                    case "SJIS": {
                        conPipeEncoding = 0;
                        break;
                    }
                    case "UTF-8": {
                        conPipeEncoding = 1;
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        JComponent[] jComponentArray = new JComponent[5];
        jComponentArray[0] = Multilingual.mlnText(ComponentFactory.createMenuItem("Stop paste", (ActionListener)object), "ja", "\u8cbc\u308a\u4ed8\u3051\u4e2d\u6b62");
        jComponentArray[1] = ComponentFactory.createHorizontalSeparator();
        conPipeCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(conPipeOn, "Paste and control pipe", (ActionListener)object), "ja", "\u8cbc\u308a\u4ed8\u3051\u304a\u3088\u3073\u5236\u5fa1\u30d1\u30a4\u30d7");
        jComponentArray[2] = conPipeCheckBox;
        jComponentArray[3] = ComponentFactory.createRadioButtonMenuItem(buttonGroup, conPipeEncoding == 0, "SJIS", (ActionListener)object);
        jComponentArray[4] = ComponentFactory.createRadioButtonMenuItem(buttonGroup, conPipeEncoding == 1, "UTF-8", (ActionListener)object);
        conSettingsMenu = Multilingual.mlnText(ComponentFactory.createMenu("Pipe settings", jComponentArray), "ja", "\u30d1\u30a4\u30d7\u8a2d\u5b9a");
        conCleanupFlag = false;
        conCON = 0;
        conPasteTask = null;
        conPasteQueue = new LinkedBlockingQueue();
        conPasteQueueThread = new CONPasteQueueThread();
        conPasteQueueThread.start();
        conKeyMap = new HashMap();
        int n = 0;
        while (n + 1 < CON_KEY_BASE.length) {
            conKeyMap.put(CON_KEY_BASE[n], Integer.parseInt(CON_KEY_BASE[n + 1], 10));
            n += 2;
        }
        conControlQueue = new LinkedBlockingQueue();
        conControlQueueThread = new CONControlQueueThread();
        conControlQueueThread.start();
        conPipeThreadArray = new CONPipeThread[conPipeInstances];
        for (n = 0; n < conPipeInstances; ++n) {
            if (conPipeOn) {
                CONDevice.conPipeThreadArray[n] = new CONPipeThread((n & 1) != 0);
                if (conPipeThreadArray[n].getPipeStream() == null) continue;
                conPipeThreadArray[n].start();
                continue;
            }
            CONDevice.conPipeThreadArray[n] = null;
        }
    }

    public static void conTini() {
        CONPasteTask cONPasteTask;
        Settings.sgsPutOnOff("pastepipe", conPipeOn);
        Settings.sgsPutString("pipeencoding", conPipeEncoding == 1 ? "utf8" : "sjis");
        conCleanupFlag = true;
        if (conPasteQueueThread != null) {
            conPasteQueueThread.interrupt();
            try {
                conPasteQueueThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            conPasteQueueThread = null;
        }
        if ((cONPasteTask = conPasteTask) != null) {
            cONPasteTask.cancel();
            conPasteTask = null;
        }
        if (conControlQueueThread != null) {
            conControlQueueThread.interrupt();
            try {
                conControlQueueThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            conControlQueueThread = null;
        }
        for (int i = 0; i < conPipeInstances; ++i) {
            if (conPipeThreadArray[i] == null) continue;
            conPipeThreadArray[i].closePipe();
            try {
                conPipeThreadArray[i].join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            CONDevice.conPipeThreadArray[i] = null;
        }
    }

    public static void conReset() {
        conCON = 0;
    }

    public static void conDoPaste() {
        if (XEiJ.clpClipboard == null) {
            return;
        }
        String string = null;
        try {
            string = (String)XEiJ.clpClipboard.getData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return;
        }
        if (string == null || string.equals("")) {
            return;
        }
        conPasteQueue.add(string);
    }

    public static void conStopPaste() {
        conPasteQueue.clear();
        CONPasteTask cONPasteTask = conPasteTask;
        if (cONPasteTask != null) {
            cONPasteTask.stopPaste();
        }
    }

    public static void conSetPipeOn(boolean bl) {
        block6: {
            if (conPipeOn == bl) break block6;
            conPipeOn = bl;
            conPipeCheckBox.setSelected(bl);
            if (bl) {
                for (int i = 0; i < conPipeInstances; ++i) {
                    if (conPipeThreadArray[i] != null) continue;
                    CONDevice.conPipeThreadArray[i] = new CONPipeThread((i & 1) != 0);
                    if (conPipeThreadArray[i].getPipeStream() == null) continue;
                    conPipeThreadArray[i].start();
                }
            } else {
                for (int i = 0; i < conPipeInstances; ++i) {
                    if (conPipeThreadArray[i] == null) continue;
                    conPipeThreadArray[i].closePipe();
                    try {
                        conPipeThreadArray[i].join(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CONDevice.conPipeThreadArray[i] = null;
                }
            }
        }
    }

    public static void conCommand(String string) {
        if ((string = string.trim().toLowerCase(Locale.ROOT)).length() == 0) {
            return;
        }
        String[] stringArray = string.split("[\\x00-\\x20]+");
        switch (stringArray[0]) {
            case "interrupt": {
                XEiJ.sysInterrupt();
                return;
            }
            case "presskey": {
                CONDevice.conPressKey(stringArray);
                return;
            }
            case "releasekey": {
                CONDevice.conReleaseKey(stringArray);
                return;
            }
            case "typekey": {
                CONDevice.conPressKey(stringArray);
                CONDevice.conReleaseKey(stringArray);
                return;
            }
            case "opt1reset": {
                XEiJ.mpuReset(0, -1);
                return;
            }
            case "reset": {
                XEiJ.mpuReset(-1, -1);
                return;
            }
        }
        System.out.println("unknown command " + stringArray[0]);
    }

    public static void conPressKey(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!conKeyMap.containsKey(string)) {
                System.out.println("unknown key " + string);
                return;
            }
            Keyboard.kbdCommandPress(conKeyMap.get(string));
        }
    }

    public static void conReleaseKey(String[] stringArray) {
        for (int i = stringArray.length - 1; 1 <= i; --i) {
            String string = stringArray[i];
            if (!conKeyMap.containsKey(string)) {
                System.out.println("unknown key " + string);
                return;
            }
            Keyboard.kbdCommandRelease(conKeyMap.get(string));
        }
    }

    static {
        CON_KEY_BASE = "esc,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,0,11,minus,12,caret,13,yen,14,bs,15,tab,16,q,17,w,18,e,19,r,20,t,21,y,22,u,23,i,24,o,25,p,26,at,27,leftbracket,28,return,29,a,30,s,31,d,32,f,33,g,34,h,35,j,36,k,37,l,38,semicolon,39,colon,40,rightbracket,41,z,42,x,43,c,44,v,45,b,46,n,47,m,48,comma,49,period,50,slash,51,underline,52,space,53,home,54,del,55,rollup,56,rolldown,57,undo,58,left,59,up,60,right,61,down,62,clr,63,tenkeyslash,64,tenkeyasterisk,65,tenkeyminus,66,tenkey7,67,tenkey8,68,tenkey9,69,tenkeyplus,70,tenkey4,71,tenkey5,72,tenkey6,73,tenkeyequal,74,tenkey1,75,tenkey2,76,tenkey3,77,enter,78,tenkey0,79,tenkeycomma,80,tenkeyperiod,81,kigou,82,touroku,83,help,84,xf1,85,xf2,86,xf3,87,xf4,88,xf5,89,kana,90,roma,91,code,92,caps,93,ins,94,hiragana,95,zenkaku,96,break,97,copy,98,f1,99,f2,100,f3,101,f4,102,f5,103,f6,104,f7,105,f8,106,f9,107,f10,108,shift,112,ctrl,113,opt1,114,opt2,115,num,116,".split(",");
    }

    public static class CONPasteTask
    extends TimerTask {
        public String string;
        public int length;
        public int index;
        public boolean stopFlag;

        public CONPasteTask(String string) {
            this.string = string;
            this.length = string.length();
            this.index = 0;
            this.stopFlag = false;
        }

        public void start() {
            XEiJ.tmrTimer.schedule((TimerTask)conPasteTask, 10L, 10L);
        }

        public void stopPaste() {
            this.stopFlag = true;
        }

        @Override
        public void run() {
            int n = conCON;
            if (n == 0 && 0 <= (n = MainMemory.mmrHumanDev(1129270816, 0x20202020)) && MC68060.mmuPeekLongData(n + 384, 1) == 545415298 && MC68060.mmuPeekLongData(n + 388, 1) == 1921149570 && MC68060.mmuPeekLongData(n + 392, 1) == 1434605442 && MC68060.mmuPeekLongData(n + 396, 1) == 1780508271 && MC68060.mmuPeekLongData(n + 400, 1) == 1914722358 && MC68060.mmuPeekLongData(n + 404, 1) == 0x38303030 && MC68060.mmuPeekLongData(n + 408, 1) == 544630130 && MC68060.mmuPeekLongData(n + 412, 1) == 1936289646 && MC68060.mmuPeekLongData(n + 416, 1) == 540225072 && MC68060.mmuPeekLongData(n + 420, 1) == 839715395) {
                conCON = n;
            }
            if (n == 0 || this.stopFlag) {
                conPasteQueue.clear();
                this.cancel();
                conPasteTask = null;
                return;
            }
            int n2 = MC68060.mmuPeekLongData(n + 58464, 1);
            int n3 = MC68060.mmuPeekLongData(n + 58468, 1);
            if (n3 != n2) {
                return;
            }
            int n4 = n + 66820;
            int n5 = n4 + 200;
            while (this.index < this.length) {
                int n6 = CharacterCode.chrCharToSJIS[this.string.charAt(this.index)];
                if (n6 != 0) {
                    if (n6 == 13 && this.index + 1 < this.length && this.string.charAt(this.index + 1) == '\n') {
                        ++this.index;
                    } else if (n6 == 10) {
                        n6 = 13;
                    }
                    if (n6 >= 32 || n6 == 9 || n6 == 13 || n6 == 27) {
                        int n7;
                        int n8 = n3 + 1 == n5 ? n4 : n3 + 1;
                        int n9 = n8 + 1 == n5 ? n4 : n8 + 1;
                        int n10 = n7 = n9 + 1 == n5 ? n4 : n9 + 1;
                        if (n8 == n2 || n9 == n2 || n7 == n2 || n7 == n2) break;
                        if (n6 < 256) {
                            MC68060.mmuPokeByteData(n8, n6, 1);
                            n3 = n8;
                        } else {
                            MC68060.mmuPokeByteData(n8, n6 >> 8, 1);
                            MC68060.mmuPokeByteData(n9, n6, 1);
                            n3 = n9;
                        }
                    }
                }
                ++this.index;
            }
            MC68060.mmuPokeLongData(n + 58468, n3, 1);
            if (this.index == this.length) {
                this.cancel();
                conPasteTask = null;
                return;
            }
        }
    }

    public static class CONPasteQueueThread
    extends Thread {
        @Override
        public void run() {
            while (!conCleanupFlag) {
                if (conPasteTask == null) {
                    String string = null;
                    try {
                        string = conPasteQueue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (conCleanupFlag) {
                        return;
                    }
                    if (string != null && !string.equals("")) {
                        conPasteTask = new CONPasteTask(string);
                        conPasteTask.start();
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    }

    public static class CONControlQueueThread
    extends Thread {
        @Override
        public void run() {
            StringBuilder stringBuilder = new StringBuilder();
            while (!conCleanupFlag) {
                String string = null;
                try {
                    string = conControlQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (conCleanupFlag) {
                    return;
                }
                if (string != null && !string.equals("")) {
                    stringBuilder.append(string);
                    while (true) {
                        char c;
                        int n;
                        int n2;
                        int n3 = stringBuilder.length();
                        for (n2 = 0; n2 < n3 && ((n = stringBuilder.charAt(n2)) == 10 || n == 13 || n == 58); ++n2) {
                        }
                        if (n3 <= n2) break;
                        for (n = n2; n < n3 && (c = stringBuilder.charAt(n)) != '\n' && c != '\r' && c != ':'; ++n) {
                        }
                        if (n3 <= n) break;
                        String string2 = stringBuilder.substring(n2, n);
                        stringBuilder.delete(0, n);
                        CONDevice.conCommand(string2);
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    }

    public static class CONPipeThread
    extends Thread {
        public boolean isControlPipe;
        public NamedPipeInputStream pipeStream;
        public boolean closeFlag;

        public CONPipeThread(boolean bl) {
            this.isControlPipe = bl;
            this.pipeStream = null;
            this.closeFlag = false;
            try {
                this.pipeStream = NamedPipeInputStream.create(bl ? CONDevice.CON_CONTROL_PIPE_NAME : CONDevice.CON_PASTE_PIPE_NAME);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public NamedPipeInputStream getPipeStream() {
            return this.pipeStream;
        }

        public void closePipe() {
            this.closeFlag = true;
            if (this.pipeStream != null) {
                this.pipeStream.close();
            }
        }

        @Override
        public void run() {
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                int n2;
                while (!conCleanupFlag && !this.closeFlag && this.pipeStream != null && (n2 = this.pipeStream.read(byArray)) != -1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (conPipeEncoding == 1) {
                        for (var5_6 = 0; var5_6 < n2; ++var5_6) {
                            var6_7 = n << 8 | 0xFF & byArray[var5_6];
                            if ((var6_7 & 0xFFFFFFE0) == 192 || (var6_7 & 0xFFFFFFF0) == 224 || (var6_7 & 0xFFFFF0C0) == 57472 || (var6_7 & 0xFFFFFFF8) == 240 || (var6_7 & 0xFFFFF8C0) == 61568 || (var6_7 & 0xFFF8C0C0) == 0xF08080) {
                                n = var6_7;
                                continue;
                            }
                            n = 0;
                            if ((var6_7 & 0xFFFFFF80) != 0) {
                                if ((var6_7 & 0xFFFFE0C0) == 49280) {
                                    var6_7 = (var6_7 & 0x1F00) >> 2 | var6_7 & 0x3F;
                                } else if ((var6_7 & 0xFFF0C0C0) == 0xE08080) {
                                    var6_7 = (var6_7 & 0xF0000) >> 4 | (var6_7 & 0x3F00) >> 2 | var6_7 & 0x3F;
                                } else if ((var6_7 & 0xF8C0C0C0) == -260013952) {
                                    if (0x10FFFF < (var6_7 = (var6_7 & 0x7000000) >> 6 | (var6_7 & 0x3F0000) >> 4 | (var6_7 & 0x3F00) >> 2 | var6_7 & 0x3F)) {
                                        var6_7 = 8251;
                                    } else if (65535 < var6_7) {
                                        var6_7 = 8251;
                                    }
                                } else {
                                    var6_7 = 8251;
                                }
                            }
                            stringBuilder.append((char)var6_7);
                        }
                    } else {
                        for (var5_6 = 0; var5_6 < n2; ++var5_6) {
                            var6_7 = n << 8 | 0xFF & byArray[var5_6];
                            if (128 <= var6_7 && var6_7 <= 159 || 224 <= var6_7 && var6_7 <= 255) {
                                n = var6_7;
                                continue;
                            }
                            n = 0;
                            int n3 = CharacterCode.chrSJISToChar[var6_7];
                            if (n3 == 0 && var6_7 != 0) {
                                n3 = 65533;
                            }
                            stringBuilder.append((char)n3);
                        }
                    }
                    (this.isControlPipe ? conControlQueue : conPasteQueue).add(stringBuilder.toString());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

