//========================================================================================
//  DrawingMode.java
//    en:Drawing mode -- It superimposes a raster of the sprite screen, the text screen and the graphic screen according to the drawing mode.
//    ja:描画モード -- 描画モードに従って1ラスタ分のスプライト画面、テキスト画面およびグラフィック画面を重ね合わせます。
//  Copyright (C) 2003-2025 Makoto Kamada
//
//  This file is part of the XEiJ (X68000 Emulator in Java).
//  You can use, modify and redistribute the XEiJ if the conditions are met.
//  Read the XEiJ License for more details.
//  https://stdkmd.net/xeij/
//========================================================================================

package xeij;

public enum DrawingMode {

  //================================================================================
  //
  //  表示できる画面モード
  //       1. N
  //       2. N_XWC → N
  //       3. N_XWP → N
  //       4. N_XHC → N
  //       5. N_XHCT → N
  //       6. N_XHCG → N
  //       7. N_XHCGT → N
  //       8. N_XHPT → N
  //       9. N_XHPG → N
  //      10. N_XHPGT → N
  //      11. N_A → N
  //      12. S
  //      13. S_XWC → S
  //      14. S_XWP → S
  //      15. S_XHC → S
  //      16. S_XHCT → S
  //      17. S_XHCG → S
  //      18. S_XHCGT → S
  //      19. S_XHPT → S
  //      20. S_XHPG → S
  //      21. S_XHPGT → S
  //      22. S_A → N
  //      23. T
  //      24. T_XWC → T
  //      25. T_XWP → T
  //      26. T_XHC → T
  //      27. T_XHCT → T
  //      28. T_XHCG → T
  //      29. T_XHCGT → T
  //      30. T_XHPT → T
  //      31. T_XHPG → T
  //      32. T_XHPGT → T
  //      33. T_A → N
  //      34. ST
  //      35. ST_XWC → ST
  //      36. ST_XWP → ST
  //      37. ST_XHC → ST
  //      38. ST_XHCT → ST
  //      39. ST_XHCG → ST
  //      40. ST_XHCGT → ST
  //      41. ST_XHPT → ST
  //      42. ST_XHPG → ST
  //      43. ST_XHPGT → ST
  //      44. ST_A → N
  //      45. TS
  //      46. TS_XWC → TS
  //      47. TS_XWP → TS
  //      48. TS_XHC → TS
  //      49. TS_XHCT → TS
  //      50. TS_XHCG → TS
  //      51. TS_XHCGT → TS
  //      52. TS_XHPT → TS
  //      53. TS_XHPG → TS
  //      54. TS_XHPGT → TS
  //      55. TS_A → N
  //      56. E1
  //      57. E1_XWC → E1
  //      58. E1_XWP
  //      59. E1_XHC → E1
  //      60. E1_XHCT
  //      61. E1_XHCG
  //      62. E1_XHCGT
  //      63. E1_XHPT
  //      64. E1_XHPG
  //      65. E1_XHPGT
  //      66. E1_A
  //      67. E2
  //      68. E2_XWC → E2
  //      69. E2_XWP
  //      70. E2_XHC → E2
  //      71. E2_XHCT
  //      72. E2_XHCG
  //      73. E2_XHCGT
  //      74. E2_XHPT
  //      75. E2_XHPG
  //      76. E2_XHPGT
  //      77. E2_A
  //      78. E3
  //      79. E3_XWC → E3
  //      80. E3_XWP
  //      81. E3_XHC → E3
  //      82. E3_XHCT
  //      83. E3_XHCG
  //      84. E3_XHCGT
  //      85. E3_XHPT
  //      86. E3_XHPG
  //      87. E3_XHPGT
  //      88. E3_A
  //      89. E4
  //      90. E4_XWC → E4
  //      91. E4_XWP
  //      92. E4_XHC → E4
  //      93. E4_XHCT
  //      94. E4_XHCG
  //      95. E4_XHCGT
  //      96. E4_XHPT
  //      97. E4_XHPG
  //      98. E4_XHPGT
  //      99. E4_A
  //     100. F1
  //     101. F1_XWC → F1
  //     102. F1_XWP
  //     103. F1_XHC → F1
  //     104. F1_XHCT
  //     105. F1_XHCG
  //     106. F1_XHCGT
  //     107. F1_XHPT
  //     108. F1_XHPG
  //     109. F1_XHPGT
  //     110. F1_A
  //     111. F2
  //     112. F2_XWC → F2
  //     113. F2_XWP
  //     114. F2_XHC → F2
  //     115. F2_XHCT
  //     116. F2_XHCG
  //     117. F2_XHCGT
  //     118. F2_XHPT
  //     119. F2_XHPG
  //     120. F2_XHPGT
  //     121. F2_A
  //     122. G
  //     123. G_XWC → G
  //     124. G_XWP
  //     125. G_XHC → G
  //     126. G_XHCT
  //     127. G_XHPT
  //     128. G_A
  //     129. H
  //     130. H_XWC → H
  //     131. H_XWP
  //     132. H_XHC → H
  //     133. H_XHCT
  //     134. H_XHPT
  //     135. H_A
  //     136. I
  //     137. I_XWC → I
  //     138. I_XWP
  //     139. I_XHC → I
  //     140. I_XHCT
  //     141. I_XHPT
  //     142. I_A
  //     143. J
  //     144. J_XWC → J
  //     145. J_XWP
  //     146. J_XHC → J
  //     147. J_XHCT
  //     148. J_XHPT
  //     149. J_A
  //     150. E1S
  //     151. E1S_XWC
  //     152. E1S_XWP
  //     153. E1S_XHC → E1S
  //     154. E1S_XHCT
  //     155. E1S_XHCG
  //     156. E1S_XHCGT
  //     157. E1S_XHPT
  //     158. E1S_XHPG
  //     159. E1S_XHPGT
  //     160. E1S_A → E1_A
  //     161. E2S
  //     162. E2S_XWC
  //     163. E2S_XWP
  //     164. E2S_XHC → E2S
  //     165. E2S_XHCT
  //     166. E2S_XHCG
  //     167. E2S_XHCGT
  //     168. E2S_XHPT
  //     169. E2S_XHPG
  //     170. E2S_XHPGT
  //     171. E2S_A → E2_A
  //     172. E3S
  //     173. E3S_XWC
  //     174. E3S_XWP
  //     175. E3S_XHC → E3S
  //     176. E3S_XHCT
  //     177. E3S_XHCG
  //     178. E3S_XHCGT
  //     179. E3S_XHPT
  //     180. E3S_XHPG
  //     181. E3S_XHPGT
  //     182. E3S_A → E3_A
  //     183. E4S
  //     184. E4S_XWC
  //     185. E4S_XWP
  //     186. E4S_XHC → E4S
  //     187. E4S_XHCT
  //     188. E4S_XHCG
  //     189. E4S_XHCGT
  //     190. E4S_XHPT
  //     191. E4S_XHPG
  //     192. E4S_XHPGT
  //     193. E4S_A → E4_A
  //     194. F1S
  //     195. F1S_XWC
  //     196. F1S_XWP
  //     197. F1S_XHC → F1S
  //     198. F1S_XHCT
  //     199. F1S_XHCG
  //     200. F1S_XHCGT
  //     201. F1S_XHPT
  //     202. F1S_XHPG
  //     203. F1S_XHPGT
  //     204. F1S_A → F1_A
  //     205. F2S
  //     206. F2S_XWC
  //     207. F2S_XWP
  //     208. F2S_XHC → F2S
  //     209. F2S_XHCT
  //     210. F2S_XHCG
  //     211. F2S_XHCGT
  //     212. F2S_XHPT
  //     213. F2S_XHPG
  //     214. F2S_XHPGT
  //     215. F2S_A → F2_A
  //     216. GS
  //     217. GS_XWC
  //     218. GS_XWP
  //     219. GS_XHC → GS
  //     220. GS_XHCT
  //     221. GS_XHPT
  //     222. GS_A → G_A
  //     223. HS
  //     224. HS_XWC
  //     225. HS_XWP
  //     226. HS_XHC → HS
  //     227. HS_XHCT
  //     228. HS_XHPT
  //     229. HS_A → H_A
  //     230. IS
  //     231. IS_XWC
  //     232. IS_XWP
  //     233. IS_XHC → IS
  //     234. IS_XHCT
  //     235. IS_XHPT
  //     236. IS_A → I_A
  //     237. JS
  //     238. JS_XWC
  //     239. JS_XWP
  //     240. JS_XHC → JS
  //     241. JS_XHCT
  //     242. JS_XHPT
  //     243. JS_A → J_A
  //     244. SE1
  //     245. SE1_XWC
  //     246. SE1_XWP
  //     247. SE1_XHC → SE1
  //     248. SE1_XHCT
  //     249. SE1_XHCG
  //     250. SE1_XHCGT
  //     251. SE1_XHPT
  //     252. SE1_XHPG
  //     253. SE1_XHPGT
  //     254. SE1_A → E1_A
  //     255. SE2
  //     256. SE2_XWC
  //     257. SE2_XWP
  //     258. SE2_XHC → SE2
  //     259. SE2_XHCT
  //     260. SE2_XHCG
  //     261. SE2_XHCGT
  //     262. SE2_XHPT
  //     263. SE2_XHPG
  //     264. SE2_XHPGT
  //     265. SE2_A → E2_A
  //     266. SE3
  //     267. SE3_XWC
  //     268. SE3_XWP
  //     269. SE3_XHC → SE3
  //     270. SE3_XHCT
  //     271. SE3_XHCG
  //     272. SE3_XHCGT
  //     273. SE3_XHPT
  //     274. SE3_XHPG
  //     275. SE3_XHPGT
  //     276. SE3_A → E3_A
  //     277. SE4
  //     278. SE4_XWC
  //     279. SE4_XWP
  //     280. SE4_XHC → SE4
  //     281. SE4_XHCT
  //     282. SE4_XHCG
  //     283. SE4_XHCGT
  //     284. SE4_XHPT
  //     285. SE4_XHPG
  //     286. SE4_XHPGT
  //     287. SE4_A → E4_A
  //     288. SF1
  //     289. SF1_XWC
  //     290. SF1_XWP
  //     291. SF1_XHC → SF1
  //     292. SF1_XHCT
  //     293. SF1_XHCG
  //     294. SF1_XHCGT
  //     295. SF1_XHPT
  //     296. SF1_XHPG
  //     297. SF1_XHPGT
  //     298. SF1_A → F1_A
  //     299. SF2
  //     300. SF2_XWC
  //     301. SF2_XWP
  //     302. SF2_XHC → SF2
  //     303. SF2_XHCT
  //     304. SF2_XHCG
  //     305. SF2_XHCGT
  //     306. SF2_XHPT
  //     307. SF2_XHPG
  //     308. SF2_XHPGT
  //     309. SF2_A → F2_A
  //     310. SG
  //     311. SG_XWC
  //     312. SG_XWP
  //     313. SG_XHC → SG
  //     314. SG_XHCT
  //     315. SG_XHPT
  //     316. SG_A → G_A
  //     317. SH
  //     318. SH_XWC
  //     319. SH_XWP
  //     320. SH_XHC → SH
  //     321. SH_XHCT
  //     322. SH_XHPT
  //     323. SH_A → H_A
  //     324. SI
  //     325. SI_XWC
  //     326. SI_XWP
  //     327. SI_XHC → SI
  //     328. SI_XHCT
  //     329. SI_XHPT
  //     330. SI_A → I_A
  //     331. SJ
  //     332. SJ_XWC
  //     333. SJ_XWP
  //     334. SJ_XHC → SJ
  //     335. SJ_XHCT
  //     336. SJ_XHPT
  //     337. SJ_A → J_A
  //     338. E1T
  //     339. E1T_XWC
  //     340. E1T_XWP
  //     341. E1T_XHC → E1T
  //     342. E1T_XHCT
  //     343. E1T_XHCG
  //     344. E1T_XHCGT
  //     345. E1T_XHPT
  //     346. E1T_XHPG
  //     347. E1T_XHPGT
  //     348. E1T_A → E1_A
  //     349. E2T
  //     350. E2T_XWC
  //     351. E2T_XWP
  //     352. E2T_XHC → E2T
  //     353. E2T_XHCT
  //     354. E2T_XHCG
  //     355. E2T_XHCGT
  //     356. E2T_XHPT
  //     357. E2T_XHPG
  //     358. E2T_XHPGT
  //     359. E2T_A → E2_A
  //     360. E3T
  //     361. E3T_XWC
  //     362. E3T_XWP
  //     363. E3T_XHC → E3T
  //     364. E3T_XHCT
  //     365. E3T_XHCG
  //     366. E3T_XHCGT
  //     367. E3T_XHPT
  //     368. E3T_XHPG
  //     369. E3T_XHPGT
  //     370. E3T_A → E3_A
  //     371. E4T
  //     372. E4T_XWC
  //     373. E4T_XWP
  //     374. E4T_XHC → E4T
  //     375. E4T_XHCT
  //     376. E4T_XHCG
  //     377. E4T_XHCGT
  //     378. E4T_XHPT
  //     379. E4T_XHPG
  //     380. E4T_XHPGT
  //     381. E4T_A → E4_A
  //     382. F1T
  //     383. F1T_XWC
  //     384. F1T_XWP
  //     385. F1T_XHC → F1T
  //     386. F1T_XHCT
  //     387. F1T_XHCG
  //     388. F1T_XHCGT
  //     389. F1T_XHPT
  //     390. F1T_XHPG
  //     391. F1T_XHPGT
  //     392. F1T_A → F1_A
  //     393. F2T
  //     394. F2T_XWC
  //     395. F2T_XWP
  //     396. F2T_XHC → F2T
  //     397. F2T_XHCT
  //     398. F2T_XHCG
  //     399. F2T_XHCGT
  //     400. F2T_XHPT
  //     401. F2T_XHPG
  //     402. F2T_XHPGT
  //     403. F2T_A → F2_A
  //     404. GT
  //     405. GT_XWC
  //     406. GT_XWP
  //     407. GT_XHC → GT
  //     408. GT_XHCT
  //     409. GT_XHPT
  //     410. GT_A → G_A
  //     411. HT
  //     412. HT_XWC
  //     413. HT_XWP
  //     414. HT_XHC → HT
  //     415. HT_XHCT
  //     416. HT_XHPT
  //     417. HT_A → H_A
  //     418. IT
  //     419. IT_XWC
  //     420. IT_XWP
  //     421. IT_XHC → IT
  //     422. IT_XHCT
  //     423. IT_XHPT
  //     424. IT_A → I_A
  //     425. JT
  //     426. JT_XWC
  //     427. JT_XWP
  //     428. JT_XHC → JT
  //     429. JT_XHCT
  //     430. JT_XHPT
  //     431. JT_A → J_A
  //     432. E1t
  //     433. E1t_XWC → E1t
  //     434. E1t_XWP
  //     435. E1t_XHC → E1t
  //     436. E1t_XHCT
  //     437. E1t_XHCG
  //     438. E1t_XHCGT
  //     439. E1t_XHPT
  //     440. E1t_XHPG
  //     441. E1t_XHPGT
  //     442. E1t_A
  //     443. E2t
  //     444. E2t_XWC → E2t
  //     445. E2t_XWP
  //     446. E2t_XHC → E2t
  //     447. E2t_XHCT
  //     448. E2t_XHCG
  //     449. E2t_XHCGT
  //     450. E2t_XHPT
  //     451. E2t_XHPG
  //     452. E2t_XHPGT
  //     453. E2t_A
  //     454. E3t
  //     455. E3t_XWC → E3t
  //     456. E3t_XWP
  //     457. E3t_XHC → E3t
  //     458. E3t_XHCT
  //     459. E3t_XHCG
  //     460. E3t_XHCGT
  //     461. E3t_XHPT
  //     462. E3t_XHPG
  //     463. E3t_XHPGT
  //     464. E3t_A
  //     465. E4t
  //     466. E4t_XWC → E4t
  //     467. E4t_XWP
  //     468. E4t_XHC → E4t
  //     469. E4t_XHCT
  //     470. E4t_XHCG
  //     471. E4t_XHCGT
  //     472. E4t_XHPT
  //     473. E4t_XHPG
  //     474. E4t_XHPGT
  //     475. E4t_A
  //     476. F1t
  //     477. F1t_XWC → F1t
  //     478. F1t_XWP
  //     479. F1t_XHC → F1t
  //     480. F1t_XHCT
  //     481. F1t_XHCG
  //     482. F1t_XHCGT
  //     483. F1t_XHPT
  //     484. F1t_XHPG
  //     485. F1t_XHPGT
  //     486. F1t_A
  //     487. F2t
  //     488. F2t_XWC → F2t
  //     489. F2t_XWP
  //     490. F2t_XHC → F2t
  //     491. F2t_XHCT
  //     492. F2t_XHCG
  //     493. F2t_XHCGT
  //     494. F2t_XHPT
  //     495. F2t_XHPG
  //     496. F2t_XHPGT
  //     497. F2t_A
  //     498. Gt
  //     499. Gt_XWC → Gt
  //     500. Gt_XWP
  //     501. Gt_XHC → Gt
  //     502. Gt_XHCT
  //     503. Gt_XHPT
  //     504. Gt_A
  //     505. Ht
  //     506. Ht_XWC → Ht
  //     507. Ht_XWP
  //     508. Ht_XHC → Ht
  //     509. Ht_XHCT
  //     510. Ht_XHPT
  //     511. Ht_A
  //     512. It
  //     513. It_XWC → It
  //     514. It_XWP
  //     515. It_XHC → It
  //     516. It_XHCT
  //     517. It_XHPT
  //     518. It_A
  //     519. Jt
  //     520. Jt_XWC → Jt
  //     521. Jt_XWP
  //     522. Jt_XHC → Jt
  //     523. Jt_XHCT
  //     524. Jt_XHPT
  //     525. Jt_A
  //     526. TE1
  //     527. TE1_XWC
  //     528. TE1_XWP
  //     529. TE1_XHC → TE1
  //     530. TE1_XHCT
  //     531. TE1_XHCG
  //     532. TE1_XHCGT
  //     533. TE1_XHPT
  //     534. TE1_XHPG
  //     535. TE1_XHPGT
  //     536. TE1_A → E1_A
  //     537. TE2
  //     538. TE2_XWC
  //     539. TE2_XWP
  //     540. TE2_XHC → TE2
  //     541. TE2_XHCT
  //     542. TE2_XHCG
  //     543. TE2_XHCGT
  //     544. TE2_XHPT
  //     545. TE2_XHPG
  //     546. TE2_XHPGT
  //     547. TE2_A → E2_A
  //     548. TE3
  //     549. TE3_XWC
  //     550. TE3_XWP
  //     551. TE3_XHC → TE3
  //     552. TE3_XHCT
  //     553. TE3_XHCG
  //     554. TE3_XHCGT
  //     555. TE3_XHPT
  //     556. TE3_XHPG
  //     557. TE3_XHPGT
  //     558. TE3_A → E3_A
  //     559. TE4
  //     560. TE4_XWC
  //     561. TE4_XWP
  //     562. TE4_XHC → TE4
  //     563. TE4_XHCT
  //     564. TE4_XHCG
  //     565. TE4_XHCGT
  //     566. TE4_XHPT
  //     567. TE4_XHPG
  //     568. TE4_XHPGT
  //     569. TE4_A → E4_A
  //     570. TF1
  //     571. TF1_XWC
  //     572. TF1_XWP
  //     573. TF1_XHC → TF1
  //     574. TF1_XHCT
  //     575. TF1_XHCG
  //     576. TF1_XHCGT
  //     577. TF1_XHPT
  //     578. TF1_XHPG
  //     579. TF1_XHPGT
  //     580. TF1_A → F1_A
  //     581. TF2
  //     582. TF2_XWC
  //     583. TF2_XWP
  //     584. TF2_XHC → TF2
  //     585. TF2_XHCT
  //     586. TF2_XHCG
  //     587. TF2_XHCGT
  //     588. TF2_XHPT
  //     589. TF2_XHPG
  //     590. TF2_XHPGT
  //     591. TF2_A → F2_A
  //     592. TG
  //     593. TG_XWC
  //     594. TG_XWP
  //     595. TG_XHC → TG
  //     596. TG_XHCT
  //     597. TG_XHPT
  //     598. TG_A → G_A
  //     599. TH
  //     600. TH_XWC
  //     601. TH_XWP
  //     602. TH_XHC → TH
  //     603. TH_XHCT
  //     604. TH_XHPT
  //     605. TH_A → H_A
  //     606. TI
  //     607. TI_XWC
  //     608. TI_XWP
  //     609. TI_XHC → TI
  //     610. TI_XHCT
  //     611. TI_XHPT
  //     612. TI_A → I_A
  //     613. TJ
  //     614. TJ_XWC
  //     615. TJ_XWP
  //     616. TJ_XHC → TJ
  //     617. TJ_XHCT
  //     618. TJ_XHPT
  //     619. TJ_A → J_A
  //     620. E1ST
  //     621. E1ST_XWC
  //     622. E1ST_XWP
  //     623. E1ST_XHC → E1ST
  //     624. E1ST_XHCT
  //     625. E1ST_XHCG
  //     626. E1ST_XHCGT
  //     627. E1ST_XHPT
  //     628. E1ST_XHPG
  //     629. E1ST_XHPGT
  //     630. E1ST_A → E1_A
  //     631. E2ST
  //     632. E2ST_XWC
  //     633. E2ST_XWP
  //     634. E2ST_XHC → E2ST
  //     635. E2ST_XHCT
  //     636. E2ST_XHCG
  //     637. E2ST_XHCGT
  //     638. E2ST_XHPT
  //     639. E2ST_XHPG
  //     640. E2ST_XHPGT
  //     641. E2ST_A → E2_A
  //     642. E3ST
  //     643. E3ST_XWC
  //     644. E3ST_XWP
  //     645. E3ST_XHC → E3ST
  //     646. E3ST_XHCT
  //     647. E3ST_XHCG
  //     648. E3ST_XHCGT
  //     649. E3ST_XHPT
  //     650. E3ST_XHPG
  //     651. E3ST_XHPGT
  //     652. E3ST_A → E3_A
  //     653. E4ST
  //     654. E4ST_XWC
  //     655. E4ST_XWP
  //     656. E4ST_XHC → E4ST
  //     657. E4ST_XHCT
  //     658. E4ST_XHCG
  //     659. E4ST_XHCGT
  //     660. E4ST_XHPT
  //     661. E4ST_XHPG
  //     662. E4ST_XHPGT
  //     663. E4ST_A → E4_A
  //     664. F1ST
  //     665. F1ST_XWC
  //     666. F1ST_XWP
  //     667. F1ST_XHC → F1ST
  //     668. F1ST_XHCT
  //     669. F1ST_XHCG
  //     670. F1ST_XHCGT
  //     671. F1ST_XHPT
  //     672. F1ST_XHPG
  //     673. F1ST_XHPGT
  //     674. F1ST_A → F1_A
  //     675. F2ST
  //     676. F2ST_XWC
  //     677. F2ST_XWP
  //     678. F2ST_XHC → F2ST
  //     679. F2ST_XHCT
  //     680. F2ST_XHCG
  //     681. F2ST_XHCGT
  //     682. F2ST_XHPT
  //     683. F2ST_XHPG
  //     684. F2ST_XHPGT
  //     685. F2ST_A → F2_A
  //     686. GST
  //     687. GST_XWC
  //     688. GST_XWP
  //     689. GST_XHC → GST
  //     690. GST_XHCT
  //     691. GST_XHPT
  //     692. GST_A → G_A
  //     693. HST
  //     694. HST_XWC
  //     695. HST_XWP
  //     696. HST_XHC → HST
  //     697. HST_XHCT
  //     698. HST_XHPT
  //     699. HST_A → H_A
  //     700. IST
  //     701. IST_XWC
  //     702. IST_XWP
  //     703. IST_XHC → IST
  //     704. IST_XHCT
  //     705. IST_XHPT
  //     706. IST_A → I_A
  //     707. JST
  //     708. JST_XWC
  //     709. JST_XWP
  //     710. JST_XHC → JST
  //     711. JST_XHCT
  //     712. JST_XHPT
  //     713. JST_A → J_A
  //     714. SE1T
  //     715. SE1T_XWC
  //     716. SE1T_XWP
  //     717. SE1T_XHC → SE1T
  //     718. SE1T_XHCT
  //     719. SE1T_XHCG
  //     720. SE1T_XHCGT
  //     721. SE1T_XHPT
  //     722. SE1T_XHPG
  //     723. SE1T_XHPGT
  //     724. SE1T_A → E1_A
  //     725. SE2T
  //     726. SE2T_XWC
  //     727. SE2T_XWP
  //     728. SE2T_XHC → SE2T
  //     729. SE2T_XHCT
  //     730. SE2T_XHCG
  //     731. SE2T_XHCGT
  //     732. SE2T_XHPT
  //     733. SE2T_XHPG
  //     734. SE2T_XHPGT
  //     735. SE2T_A → E2_A
  //     736. SE3T
  //     737. SE3T_XWC
  //     738. SE3T_XWP
  //     739. SE3T_XHC → SE3T
  //     740. SE3T_XHCT
  //     741. SE3T_XHCG
  //     742. SE3T_XHCGT
  //     743. SE3T_XHPT
  //     744. SE3T_XHPG
  //     745. SE3T_XHPGT
  //     746. SE3T_A → E3_A
  //     747. SE4T
  //     748. SE4T_XWC
  //     749. SE4T_XWP
  //     750. SE4T_XHC → SE4T
  //     751. SE4T_XHCT
  //     752. SE4T_XHCG
  //     753. SE4T_XHCGT
  //     754. SE4T_XHPT
  //     755. SE4T_XHPG
  //     756. SE4T_XHPGT
  //     757. SE4T_A → E4_A
  //     758. SF1T
  //     759. SF1T_XWC
  //     760. SF1T_XWP
  //     761. SF1T_XHC → SF1T
  //     762. SF1T_XHCT
  //     763. SF1T_XHCG
  //     764. SF1T_XHCGT
  //     765. SF1T_XHPT
  //     766. SF1T_XHPG
  //     767. SF1T_XHPGT
  //     768. SF1T_A → F1_A
  //     769. SF2T
  //     770. SF2T_XWC
  //     771. SF2T_XWP
  //     772. SF2T_XHC → SF2T
  //     773. SF2T_XHCT
  //     774. SF2T_XHCG
  //     775. SF2T_XHCGT
  //     776. SF2T_XHPT
  //     777. SF2T_XHPG
  //     778. SF2T_XHPGT
  //     779. SF2T_A → F2_A
  //     780. SGT
  //     781. SGT_XWC
  //     782. SGT_XWP
  //     783. SGT_XHC → SGT
  //     784. SGT_XHCT
  //     785. SGT_XHPT
  //     786. SGT_A → G_A
  //     787. SHT
  //     788. SHT_XWC
  //     789. SHT_XWP
  //     790. SHT_XHC → SHT
  //     791. SHT_XHCT
  //     792. SHT_XHPT
  //     793. SHT_A → H_A
  //     794. SIT
  //     795. SIT_XWC
  //     796. SIT_XWP
  //     797. SIT_XHC → SIT
  //     798. SIT_XHCT
  //     799. SIT_XHPT
  //     800. SIT_A → I_A
  //     801. SJT
  //     802. SJT_XWC
  //     803. SJT_XWP
  //     804. SJT_XHC → SJT
  //     805. SJT_XHCT
  //     806. SJT_XHPT
  //     807. SJT_A → J_A
  //     808. SE1t
  //     809. SE1t_XWC
  //     810. SE1t_XWP
  //     811. SE1t_XHC → SE1t
  //     812. SE1t_XHCT
  //     813. SE1t_XHCG
  //     814. SE1t_XHCGT
  //     815. SE1t_XHPT
  //     816. SE1t_XHPG
  //     817. SE1t_XHPGT
  //     818. SE1t_A → E1_A
  //     819. SE2t
  //     820. SE2t_XWC
  //     821. SE2t_XWP
  //     822. SE2t_XHC → SE2t
  //     823. SE2t_XHCT
  //     824. SE2t_XHCG
  //     825. SE2t_XHCGT
  //     826. SE2t_XHPT
  //     827. SE2t_XHPG
  //     828. SE2t_XHPGT
  //     829. SE2t_A → E2_A
  //     830. SE3t
  //     831. SE3t_XWC
  //     832. SE3t_XWP
  //     833. SE3t_XHC → SE3t
  //     834. SE3t_XHCT
  //     835. SE3t_XHCG
  //     836. SE3t_XHCGT
  //     837. SE3t_XHPT
  //     838. SE3t_XHPG
  //     839. SE3t_XHPGT
  //     840. SE3t_A → E3_A
  //     841. SE4t
  //     842. SE4t_XWC
  //     843. SE4t_XWP
  //     844. SE4t_XHC → SE4t
  //     845. SE4t_XHCT
  //     846. SE4t_XHCG
  //     847. SE4t_XHCGT
  //     848. SE4t_XHPT
  //     849. SE4t_XHPG
  //     850. SE4t_XHPGT
  //     851. SE4t_A → E4_A
  //     852. SF1t
  //     853. SF1t_XWC
  //     854. SF1t_XWP
  //     855. SF1t_XHC → SF1t
  //     856. SF1t_XHCT
  //     857. SF1t_XHCG
  //     858. SF1t_XHCGT
  //     859. SF1t_XHPT
  //     860. SF1t_XHPG
  //     861. SF1t_XHPGT
  //     862. SF1t_A → F1_A
  //     863. SF2t
  //     864. SF2t_XWC
  //     865. SF2t_XWP
  //     866. SF2t_XHC → SF2t
  //     867. SF2t_XHCT
  //     868. SF2t_XHCG
  //     869. SF2t_XHCGT
  //     870. SF2t_XHPT
  //     871. SF2t_XHPG
  //     872. SF2t_XHPGT
  //     873. SF2t_A → F2_A
  //     874. SGt
  //     875. SGt_XWC
  //     876. SGt_XWP
  //     877. SGt_XHC → SGt
  //     878. SGt_XHCT
  //     879. SGt_XHPT
  //     880. SGt_A → G_A
  //     881. SHt
  //     882. SHt_XWC
  //     883. SHt_XWP
  //     884. SHt_XHC → SHt
  //     885. SHt_XHCT
  //     886. SHt_XHPT
  //     887. SHt_A → H_A
  //     888. SIt
  //     889. SIt_XWC
  //     890. SIt_XWP
  //     891. SIt_XHC → SIt
  //     892. SIt_XHCT
  //     893. SIt_XHPT
  //     894. SIt_A → I_A
  //     895. SJt
  //     896. SJt_XWC
  //     897. SJt_XWP
  //     898. SJt_XHC → SJt
  //     899. SJt_XHCT
  //     900. SJt_XHPT
  //     901. SJt_A → J_A
  //     902. STE1
  //     903. STE1_XWC
  //     904. STE1_XWP
  //     905. STE1_XHC → STE1
  //     906. STE1_XHCT
  //     907. STE1_XHCG
  //     908. STE1_XHCGT
  //     909. STE1_XHPT
  //     910. STE1_XHPG
  //     911. STE1_XHPGT
  //     912. STE1_A → E1_A
  //     913. STE2
  //     914. STE2_XWC
  //     915. STE2_XWP
  //     916. STE2_XHC → STE2
  //     917. STE2_XHCT
  //     918. STE2_XHCG
  //     919. STE2_XHCGT
  //     920. STE2_XHPT
  //     921. STE2_XHPG
  //     922. STE2_XHPGT
  //     923. STE2_A → E2_A
  //     924. STE3
  //     925. STE3_XWC
  //     926. STE3_XWP
  //     927. STE3_XHC → STE3
  //     928. STE3_XHCT
  //     929. STE3_XHCG
  //     930. STE3_XHCGT
  //     931. STE3_XHPT
  //     932. STE3_XHPG
  //     933. STE3_XHPGT
  //     934. STE3_A → E3_A
  //     935. STE4
  //     936. STE4_XWC
  //     937. STE4_XWP
  //     938. STE4_XHC → STE4
  //     939. STE4_XHCT
  //     940. STE4_XHCG
  //     941. STE4_XHCGT
  //     942. STE4_XHPT
  //     943. STE4_XHPG
  //     944. STE4_XHPGT
  //     945. STE4_A → E4_A
  //     946. STF1
  //     947. STF1_XWC
  //     948. STF1_XWP
  //     949. STF1_XHC → STF1
  //     950. STF1_XHCT
  //     951. STF1_XHCG
  //     952. STF1_XHCGT
  //     953. STF1_XHPT
  //     954. STF1_XHPG
  //     955. STF1_XHPGT
  //     956. STF1_A → F1_A
  //     957. STF2
  //     958. STF2_XWC
  //     959. STF2_XWP
  //     960. STF2_XHC → STF2
  //     961. STF2_XHCT
  //     962. STF2_XHCG
  //     963. STF2_XHCGT
  //     964. STF2_XHPT
  //     965. STF2_XHPG
  //     966. STF2_XHPGT
  //     967. STF2_A → F2_A
  //     968. STG
  //     969. STG_XWC
  //     970. STG_XWP
  //     971. STG_XHC → STG
  //     972. STG_XHCT
  //     973. STG_XHPT
  //     974. STG_A → G_A
  //     975. STH
  //     976. STH_XWC
  //     977. STH_XWP
  //     978. STH_XHC → STH
  //     979. STH_XHCT
  //     980. STH_XHPT
  //     981. STH_A → H_A
  //     982. STI
  //     983. STI_XWC
  //     984. STI_XWP
  //     985. STI_XHC → STI
  //     986. STI_XHCT
  //     987. STI_XHPT
  //     988. STI_A → I_A
  //     989. STJ
  //     990. STJ_XWC
  //     991. STJ_XWP
  //     992. STJ_XHC → STJ
  //     993. STJ_XHCT
  //     994. STJ_XHPT
  //     995. STJ_A → J_A
  //     996. E1TS
  //     997. E1TS_XWC
  //     998. E1TS_XWP
  //     999. E1TS_XHC → E1TS
  //    1000. E1TS_XHCT
  //    1001. E1TS_XHCG
  //    1002. E1TS_XHCGT
  //    1003. E1TS_XHPT
  //    1004. E1TS_XHPG
  //    1005. E1TS_XHPGT
  //    1006. E1TS_A → E1_A
  //    1007. E2TS
  //    1008. E2TS_XWC
  //    1009. E2TS_XWP
  //    1010. E2TS_XHC → E2TS
  //    1011. E2TS_XHCT
  //    1012. E2TS_XHCG
  //    1013. E2TS_XHCGT
  //    1014. E2TS_XHPT
  //    1015. E2TS_XHPG
  //    1016. E2TS_XHPGT
  //    1017. E2TS_A → E2_A
  //    1018. E3TS
  //    1019. E3TS_XWC
  //    1020. E3TS_XWP
  //    1021. E3TS_XHC → E3TS
  //    1022. E3TS_XHCT
  //    1023. E3TS_XHCG
  //    1024. E3TS_XHCGT
  //    1025. E3TS_XHPT
  //    1026. E3TS_XHPG
  //    1027. E3TS_XHPGT
  //    1028. E3TS_A → E3_A
  //    1029. E4TS
  //    1030. E4TS_XWC
  //    1031. E4TS_XWP
  //    1032. E4TS_XHC → E4TS
  //    1033. E4TS_XHCT
  //    1034. E4TS_XHCG
  //    1035. E4TS_XHCGT
  //    1036. E4TS_XHPT
  //    1037. E4TS_XHPG
  //    1038. E4TS_XHPGT
  //    1039. E4TS_A → E4_A
  //    1040. F1TS
  //    1041. F1TS_XWC
  //    1042. F1TS_XWP
  //    1043. F1TS_XHC → F1TS
  //    1044. F1TS_XHCT
  //    1045. F1TS_XHCG
  //    1046. F1TS_XHCGT
  //    1047. F1TS_XHPT
  //    1048. F1TS_XHPG
  //    1049. F1TS_XHPGT
  //    1050. F1TS_A → F1_A
  //    1051. F2TS
  //    1052. F2TS_XWC
  //    1053. F2TS_XWP
  //    1054. F2TS_XHC → F2TS
  //    1055. F2TS_XHCT
  //    1056. F2TS_XHCG
  //    1057. F2TS_XHCGT
  //    1058. F2TS_XHPT
  //    1059. F2TS_XHPG
  //    1060. F2TS_XHPGT
  //    1061. F2TS_A → F2_A
  //    1062. GTS
  //    1063. GTS_XWC
  //    1064. GTS_XWP
  //    1065. GTS_XHC → GTS
  //    1066. GTS_XHCT
  //    1067. GTS_XHPT
  //    1068. GTS_A → G_A
  //    1069. HTS
  //    1070. HTS_XWC
  //    1071. HTS_XWP
  //    1072. HTS_XHC → HTS
  //    1073. HTS_XHCT
  //    1074. HTS_XHPT
  //    1075. HTS_A → H_A
  //    1076. ITS
  //    1077. ITS_XWC
  //    1078. ITS_XWP
  //    1079. ITS_XHC → ITS
  //    1080. ITS_XHCT
  //    1081. ITS_XHPT
  //    1082. ITS_A → I_A
  //    1083. JTS
  //    1084. JTS_XWC
  //    1085. JTS_XWP
  //    1086. JTS_XHC → JTS
  //    1087. JTS_XHCT
  //    1088. JTS_XHPT
  //    1089. JTS_A → J_A
  //    1090. TE1S
  //    1091. TE1S_XWC
  //    1092. TE1S_XWP
  //    1093. TE1S_XHC → TE1S
  //    1094. TE1S_XHCT
  //    1095. TE1S_XHCG
  //    1096. TE1S_XHCGT
  //    1097. TE1S_XHPT
  //    1098. TE1S_XHPG
  //    1099. TE1S_XHPGT
  //    1100. TE1S_A → E1_A
  //    1101. TE2S
  //    1102. TE2S_XWC
  //    1103. TE2S_XWP
  //    1104. TE2S_XHC → TE2S
  //    1105. TE2S_XHCT
  //    1106. TE2S_XHCG
  //    1107. TE2S_XHCGT
  //    1108. TE2S_XHPT
  //    1109. TE2S_XHPG
  //    1110. TE2S_XHPGT
  //    1111. TE2S_A → E2_A
  //    1112. TE3S
  //    1113. TE3S_XWC
  //    1114. TE3S_XWP
  //    1115. TE3S_XHC → TE3S
  //    1116. TE3S_XHCT
  //    1117. TE3S_XHCG
  //    1118. TE3S_XHCGT
  //    1119. TE3S_XHPT
  //    1120. TE3S_XHPG
  //    1121. TE3S_XHPGT
  //    1122. TE3S_A → E3_A
  //    1123. TE4S
  //    1124. TE4S_XWC
  //    1125. TE4S_XWP
  //    1126. TE4S_XHC → TE4S
  //    1127. TE4S_XHCT
  //    1128. TE4S_XHCG
  //    1129. TE4S_XHCGT
  //    1130. TE4S_XHPT
  //    1131. TE4S_XHPG
  //    1132. TE4S_XHPGT
  //    1133. TE4S_A → E4_A
  //    1134. TF1S
  //    1135. TF1S_XWC
  //    1136. TF1S_XWP
  //    1137. TF1S_XHC → TF1S
  //    1138. TF1S_XHCT
  //    1139. TF1S_XHCG
  //    1140. TF1S_XHCGT
  //    1141. TF1S_XHPT
  //    1142. TF1S_XHPG
  //    1143. TF1S_XHPGT
  //    1144. TF1S_A → F1_A
  //    1145. TF2S
  //    1146. TF2S_XWC
  //    1147. TF2S_XWP
  //    1148. TF2S_XHC → TF2S
  //    1149. TF2S_XHCT
  //    1150. TF2S_XHCG
  //    1151. TF2S_XHCGT
  //    1152. TF2S_XHPT
  //    1153. TF2S_XHPG
  //    1154. TF2S_XHPGT
  //    1155. TF2S_A → F2_A
  //    1156. TGS
  //    1157. TGS_XWC
  //    1158. TGS_XWP
  //    1159. TGS_XHC → TGS
  //    1160. TGS_XHCT
  //    1161. TGS_XHPT
  //    1162. TGS_A → G_A
  //    1163. THS
  //    1164. THS_XWC
  //    1165. THS_XWP
  //    1166. THS_XHC → THS
  //    1167. THS_XHCT
  //    1168. THS_XHPT
  //    1169. THS_A → H_A
  //    1170. TIS
  //    1171. TIS_XWC
  //    1172. TIS_XWP
  //    1173. TIS_XHC → TIS
  //    1174. TIS_XHCT
  //    1175. TIS_XHPT
  //    1176. TIS_A → I_A
  //    1177. TJS
  //    1178. TJS_XWC
  //    1179. TJS_XWP
  //    1180. TJS_XHC → TJS
  //    1181. TJS_XHCT
  //    1182. TJS_XHPT
  //    1183. TJS_A → J_A
  //    1184. TE1s
  //    1185. TE1s_XWC
  //    1186. TE1s_XWP
  //    1187. TE1s_XHC → TE1s
  //    1188. TE1s_XHCT
  //    1189. TE1s_XHCG
  //    1190. TE1s_XHCGT
  //    1191. TE1s_XHPT
  //    1192. TE1s_XHPG
  //    1193. TE1s_XHPGT
  //    1194. TE1s_A → E1_A
  //    1195. TE2s
  //    1196. TE2s_XWC
  //    1197. TE2s_XWP
  //    1198. TE2s_XHC → TE2s
  //    1199. TE2s_XHCT
  //    1200. TE2s_XHCG
  //    1201. TE2s_XHCGT
  //    1202. TE2s_XHPT
  //    1203. TE2s_XHPG
  //    1204. TE2s_XHPGT
  //    1205. TE2s_A → E2_A
  //    1206. TE3s
  //    1207. TE3s_XWC
  //    1208. TE3s_XWP
  //    1209. TE3s_XHC → TE3s
  //    1210. TE3s_XHCT
  //    1211. TE3s_XHCG
  //    1212. TE3s_XHCGT
  //    1213. TE3s_XHPT
  //    1214. TE3s_XHPG
  //    1215. TE3s_XHPGT
  //    1216. TE3s_A → E3_A
  //    1217. TE4s
  //    1218. TE4s_XWC
  //    1219. TE4s_XWP
  //    1220. TE4s_XHC → TE4s
  //    1221. TE4s_XHCT
  //    1222. TE4s_XHCG
  //    1223. TE4s_XHCGT
  //    1224. TE4s_XHPT
  //    1225. TE4s_XHPG
  //    1226. TE4s_XHPGT
  //    1227. TE4s_A → E4_A
  //    1228. TF1s
  //    1229. TF1s_XWC
  //    1230. TF1s_XWP
  //    1231. TF1s_XHC → TF1s
  //    1232. TF1s_XHCT
  //    1233. TF1s_XHCG
  //    1234. TF1s_XHCGT
  //    1235. TF1s_XHPT
  //    1236. TF1s_XHPG
  //    1237. TF1s_XHPGT
  //    1238. TF1s_A → F1_A
  //    1239. TF2s
  //    1240. TF2s_XWC
  //    1241. TF2s_XWP
  //    1242. TF2s_XHC → TF2s
  //    1243. TF2s_XHCT
  //    1244. TF2s_XHCG
  //    1245. TF2s_XHCGT
  //    1246. TF2s_XHPT
  //    1247. TF2s_XHPG
  //    1248. TF2s_XHPGT
  //    1249. TF2s_A → F2_A
  //    1250. TGs
  //    1251. TGs_XWC
  //    1252. TGs_XWP
  //    1253. TGs_XHC → TGs
  //    1254. TGs_XHCT
  //    1255. TGs_XHPT
  //    1256. TGs_A → G_A
  //    1257. THs
  //    1258. THs_XWC
  //    1259. THs_XWP
  //    1260. THs_XHC → THs
  //    1261. THs_XHCT
  //    1262. THs_XHPT
  //    1263. THs_A → H_A
  //    1264. TIs
  //    1265. TIs_XWC
  //    1266. TIs_XWP
  //    1267. TIs_XHC → TIs
  //    1268. TIs_XHCT
  //    1269. TIs_XHPT
  //    1270. TIs_A → I_A
  //    1271. TJs
  //    1272. TJs_XWC
  //    1273. TJs_XWP
  //    1274. TJs_XHC → TJs
  //    1275. TJs_XHCT
  //    1276. TJs_XHPT
  //    1277. TJs_A → J_A
  //    1278. TSE1
  //    1279. TSE1_XWC
  //    1280. TSE1_XWP
  //    1281. TSE1_XHC → TSE1
  //    1282. TSE1_XHCT
  //    1283. TSE1_XHCG
  //    1284. TSE1_XHCGT
  //    1285. TSE1_XHPT
  //    1286. TSE1_XHPG
  //    1287. TSE1_XHPGT
  //    1288. TSE1_A → E1_A
  //    1289. TSE2
  //    1290. TSE2_XWC
  //    1291. TSE2_XWP
  //    1292. TSE2_XHC → TSE2
  //    1293. TSE2_XHCT
  //    1294. TSE2_XHCG
  //    1295. TSE2_XHCGT
  //    1296. TSE2_XHPT
  //    1297. TSE2_XHPG
  //    1298. TSE2_XHPGT
  //    1299. TSE2_A → E2_A
  //    1300. TSE3
  //    1301. TSE3_XWC
  //    1302. TSE3_XWP
  //    1303. TSE3_XHC → TSE3
  //    1304. TSE3_XHCT
  //    1305. TSE3_XHCG
  //    1306. TSE3_XHCGT
  //    1307. TSE3_XHPT
  //    1308. TSE3_XHPG
  //    1309. TSE3_XHPGT
  //    1310. TSE3_A → E3_A
  //    1311. TSE4
  //    1312. TSE4_XWC
  //    1313. TSE4_XWP
  //    1314. TSE4_XHC → TSE4
  //    1315. TSE4_XHCT
  //    1316. TSE4_XHCG
  //    1317. TSE4_XHCGT
  //    1318. TSE4_XHPT
  //    1319. TSE4_XHPG
  //    1320. TSE4_XHPGT
  //    1321. TSE4_A → E4_A
  //    1322. TSF1
  //    1323. TSF1_XWC
  //    1324. TSF1_XWP
  //    1325. TSF1_XHC → TSF1
  //    1326. TSF1_XHCT
  //    1327. TSF1_XHCG
  //    1328. TSF1_XHCGT
  //    1329. TSF1_XHPT
  //    1330. TSF1_XHPG
  //    1331. TSF1_XHPGT
  //    1332. TSF1_A → F1_A
  //    1333. TSF2
  //    1334. TSF2_XWC
  //    1335. TSF2_XWP
  //    1336. TSF2_XHC → TSF2
  //    1337. TSF2_XHCT
  //    1338. TSF2_XHCG
  //    1339. TSF2_XHCGT
  //    1340. TSF2_XHPT
  //    1341. TSF2_XHPG
  //    1342. TSF2_XHPGT
  //    1343. TSF2_A → F2_A
  //    1344. TSG
  //    1345. TSG_XWC
  //    1346. TSG_XWP
  //    1347. TSG_XHC → TSG
  //    1348. TSG_XHCT
  //    1349. TSG_XHPT
  //    1350. TSG_A → G_A
  //    1351. TSH
  //    1352. TSH_XWC
  //    1353. TSH_XWP
  //    1354. TSH_XHC → TSH
  //    1355. TSH_XHCT
  //    1356. TSH_XHPT
  //    1357. TSH_A → H_A
  //    1358. TSI
  //    1359. TSI_XWC
  //    1360. TSI_XWP
  //    1361. TSI_XHC → TSI
  //    1362. TSI_XHCT
  //    1363. TSI_XHPT
  //    1364. TSI_A → I_A
  //    1365. TSJ
  //    1366. TSJ_XWC
  //    1367. TSJ_XWP
  //    1368. TSJ_XHC → TSJ
  //    1369. TSJ_XHCT
  //    1370. TSJ_XHPT
  //    1371. TSJ_A → J_A

  //================================================================================
  //N ($0000,$06xx,$0000)
  //  概要
  //    N  表示画面なし
  //    拡張なし
  //  手順
  //    カラー0(黒)
  //  中間コード1
  //    0
  //  中間コード2
  //    0
  //  中間コード3
  //    0
  //  中間コード4
  //    0
  //  中間コード5
  //    0
  //  中間コード6
  //    cto(0)
  N {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        da += half;
      }
      while (da < db) {
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[0]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[0]);
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //N

  //================================================================================
  //XN
  //  概要
  //    N  表示画面なし
  //    拡張あり
  XN {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //N_XWC
      case 0b00010001:  //N_XWC
      case 0b00010010:  //N_XWC
      case 0b00010011:  //N_XWC
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //N_XWP
      case 0b00010101:  //N_XWP
      case 0b00010110:  //N_XWP
      case 0b00010111:  //N_XWP
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //N_XHC
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //N_XHCT
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //N_XHCG
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //N_XHCGT
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //N_XHPT
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //N_XHPG
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //N_XHPGT
        N.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //N_A
      case 0b01000001:  //N_A
      case 0b01000010:  //N_A
      case 0b01000011:  //N_A
      case 0b01000100:  //N_A
      case 0b01000101:  //N_A
      case 0b01000110:  //N_A
      case 0b01000111:  //N_A
      case 0b01001000:  //N_A
      case 0b01001001:  //N_A
      case 0b01001010:  //N_A
      case 0b01001011:  //N_A
      case 0b01001100:  //N_A
      case 0b01001101:  //N_A
      case 0b01001110:  //N_A
      case 0b01001111:  //N_A
      case 0b01010000:  //N_A
      case 0b01010001:  //N_A
      case 0b01010010:  //N_A
      case 0b01010011:  //N_A
      case 0b01010100:  //N_A
      case 0b01010101:  //N_A
      case 0b01010110:  //N_A
      case 0b01010111:  //N_A
      case 0b01011000:  //N_A
      case 0b01011001:  //N_A
      case 0b01011010:  //N_A
      case 0b01011011:  //N_A
      case 0b01011100:  //N_A
      case 0b01011101:  //N_A
      case 0b01011110:  //N_A
      case 0b01011111:  //N_A
        N.drawRaster (src, dst, rh);
        break;
      default:
        N.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XN);
      }  //switch
    }  //drawRaster
  },  //XN

  //================================================================================
  //S ($0000,$06xx,$0040)
  //  概要
  //    S  スプライト
  //    拡張なし
  //  手順
  //    スプライトカラー(0は黒)
  //  中間コード1
  //    spc(spp())
  //  中間コード2
  //    spc(spp())
  //  中間コード3
  //    spc(spp())
  //  中間コード4
  //    spc(spp())
  //  中間コード5
  //    spc(spp())
  //  中間コード6
  //    spo(spp())
  S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        da += half;
      }
      while (da < db) {
        XEiJ.pnlBM[da] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //S

  //================================================================================
  //XS
  //  概要
  //    S  スプライト
  //    拡張あり
  XS {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //S_XWC
      case 0b00010001:  //S_XWC
      case 0b00010010:  //S_XWC
      case 0b00010011:  //S_XWC
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //S_XWP
      case 0b00010101:  //S_XWP
      case 0b00010110:  //S_XWP
      case 0b00010111:  //S_XWP
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //S_XHC
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //S_XHCT
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //S_XHCG
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //S_XHCGT
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //S_XHPT
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //S_XHPG
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //S_XHPGT
        S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //S_A
      case 0b01000001:  //S_A
      case 0b01000010:  //S_A
      case 0b01000011:  //S_A
      case 0b01000100:  //S_A
      case 0b01000101:  //S_A
      case 0b01000110:  //S_A
      case 0b01000111:  //S_A
      case 0b01001000:  //S_A
      case 0b01001001:  //S_A
      case 0b01001010:  //S_A
      case 0b01001011:  //S_A
      case 0b01001100:  //S_A
      case 0b01001101:  //S_A
      case 0b01001110:  //S_A
      case 0b01001111:  //S_A
      case 0b01010000:  //S_A
      case 0b01010001:  //S_A
      case 0b01010010:  //S_A
      case 0b01010011:  //S_A
      case 0b01010100:  //S_A
      case 0b01010101:  //S_A
      case 0b01010110:  //S_A
      case 0b01010111:  //S_A
      case 0b01011000:  //S_A
      case 0b01011001:  //S_A
      case 0b01011010:  //S_A
      case 0b01011011:  //S_A
      case 0b01011100:  //S_A
      case 0b01011101:  //S_A
      case 0b01011110:  //S_A
      case 0b01011111:  //S_A
        N.drawRaster (src, dst, rh);
        break;
      default:
        S.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XS);
      }  //switch
    }  //drawRaster
  },  //XS

  //================================================================================
  //T ($0000,$06xx,$0020)
  //  概要
  //    T  テキスト
  //    拡張なし
  //  手順
  //    テキストカラー(0は黒)
  //  中間コード1
  //    tpc(txp())
  //  中間コード2
  //    tpc(txp())
  //  中間コード3
  //    tpc(txp())
  //  中間コード4
  //    tpc(txp())
  //  中間コード5
  //    tpc(txp())
  //  中間コード6
  //    tpo(txp())
  T {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int ty = CRTC.crtR11TxYZero + src & 1023;  //ラスタ
      int tc = (ty & CRTC.crtMask3) << 7 | CRTC.crtR10TxXCurr >> 3;  //テキスト桁位置
      int ta0 = 0x00e00000 + ((ty & CRTC.crtMaskMinus4) << 7);  //ラスタブロックアドレス
      int ta1 = 0x00020000 + ta0;
      int ta2 = 0x00040000 + ta0;
      int ta3 = 0x00060000 + ta0;
      int ts = CRTC.crtR10TxXCurr & 7;  //テキスト桁境界からのずれ
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        tc = tc + (half >> 3) & CRTC.crtMask511;
        da += half;
      }
      if (ts == 0) {  //テキスト桁境界に合っているとき
        while (da < db) {
          int tp = (VideoController.VCN_TXP3[MainMemory.mmrM8[ta3 + tc] & 255] |
                    VideoController.VCN_TXP2[MainMemory.mmrM8[ta2 + tc] & 255] |
                    VideoController.VCN_TXP1[MainMemory.mmrM8[ta1 + tc] & 255] |
                    VideoController.VCN_TXP0[MainMemory.mmrM8[ta0 + tc] & 255]);
          tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
          XEiJ.pnlBM[da] = (VideoController.vcnPal32TS[tp >>> 28]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32TS[tp >>> 24 & 15]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32TS[tp >>> 20 & 15]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32TS[tp >>> 16 & 15]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32TS[tp >>> 12 & 15]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32TS[tp >>> 8 & 15]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32TS[tp >>> 4 & 15]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32TS[tp & 15]);
          da += 8;
        }  //while da<db
      } else {  //テキスト桁境界に合っていないとき
        //                                                             ts=1のとき
        int tt = ts + 8;                                             //tt=9
        ts += 16;                                                    //ts=17
        //                                                             ........ ........ ........ 01234567  m8[ta0+tc]
        int p0 = MainMemory.mmrM8[ta0 + tc] << ts;                   //.......0 1234567_ ________ ________  p0=m8[ta0+tc]<<ts
        int p1 = MainMemory.mmrM8[ta1 + tc] << ts;
        int p2 = MainMemory.mmrM8[ta2 + tc] << ts;
        int p3 = MainMemory.mmrM8[ta3 + tc] << ts;
        tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
        while (da < db) {
          //                                                           ........ ........ .1234567 ________  p0>>tt
          //                                                           ........ ........ .1234567 89abcdef  p0>>tt|m8[ta0+tc]&255
          p0 = (p0 >> tt | MainMemory.mmrM8[ta0 + tc] & 255) << ts;  //12345678 9abcdef_ ________ ________  p0=(p0>>tt|m8[ta0+tc]&255)<<ts
          p1 = (p1 >> tt | MainMemory.mmrM8[ta1 + tc] & 255) << ts;  //~~~~~~~~
          p2 = (p2 >> tt | MainMemory.mmrM8[ta2 + tc] & 255) << ts;  //ここを使う
          p3 = (p3 >> tt | MainMemory.mmrM8[ta3 + tc] & 255) << ts;
          int tp = (VideoController.VCN_TXP3[p3 >>> 24] |
                    VideoController.VCN_TXP2[p2 >>> 24] |
                    VideoController.VCN_TXP1[p1 >>> 24] |
                    VideoController.VCN_TXP0[p0 >>> 24]);  //符号なし右シフトで&255を省略
          tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
          XEiJ.pnlBM[da] = (VideoController.vcnPal32TS[tp >>> 28]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32TS[tp >>> 24 & 15]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32TS[tp >>> 20 & 15]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32TS[tp >>> 16 & 15]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32TS[tp >>> 12 & 15]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32TS[tp >>> 8 & 15]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32TS[tp >>> 4 & 15]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32TS[tp & 15]);
          da += 8;
        }  //while da<db
      }  //if ts==0
    }  //drawRaster
  },  //T

  //================================================================================
  //XT
  //  概要
  //    T  テキスト
  //    拡張あり
  XT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //T_XWC
      case 0b00010001:  //T_XWC
      case 0b00010010:  //T_XWC
      case 0b00010011:  //T_XWC
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //T_XWP
      case 0b00010101:  //T_XWP
      case 0b00010110:  //T_XWP
      case 0b00010111:  //T_XWP
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //T_XHC
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //T_XHCT
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //T_XHCG
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //T_XHCGT
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //T_XHPT
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //T_XHPG
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //T_XHPGT
        T.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //T_A
      case 0b01000001:  //T_A
      case 0b01000010:  //T_A
      case 0b01000011:  //T_A
      case 0b01000100:  //T_A
      case 0b01000101:  //T_A
      case 0b01000110:  //T_A
      case 0b01000111:  //T_A
      case 0b01001000:  //T_A
      case 0b01001001:  //T_A
      case 0b01001010:  //T_A
      case 0b01001011:  //T_A
      case 0b01001100:  //T_A
      case 0b01001101:  //T_A
      case 0b01001110:  //T_A
      case 0b01001111:  //T_A
      case 0b01010000:  //T_A
      case 0b01010001:  //T_A
      case 0b01010010:  //T_A
      case 0b01010011:  //T_A
      case 0b01010100:  //T_A
      case 0b01010101:  //T_A
      case 0b01010110:  //T_A
      case 0b01010111:  //T_A
      case 0b01011000:  //T_A
      case 0b01011001:  //T_A
      case 0b01011010:  //T_A
      case 0b01011011:  //T_A
      case 0b01011100:  //T_A
      case 0b01011101:  //T_A
      case 0b01011110:  //T_A
      case 0b01011111:  //T_A
        N.drawRaster (src, dst, rh);
        break;
      default:
        T.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XT);
      }  //switch
    }  //drawRaster
  },  //XT

  //================================================================================
  //ST ($0000,$06xx,$0060)
  //  概要
  //    ST  スプライト＞テキスト
  //    拡張なし
  //  手順
  //    スプライトパレットの下位4bitが0でないまたはテキストパレットが0のとき
  //      スプライトカラー(0は黒)
  //    さもなくば(スプライトパレットの下位4bitが0かつテキストパレットが0でないとき)
  //      テキストカラー(0は黒)
  //  中間コード1
  //    (ls4(spp())!=0||txp()==0?spc(spp()):tpc(txp()))
  //  中間コード2
  //    ls4(spp())!=0||txp()==0?spc(spp()):tpc(txp())
  //  中間コード3
  //    ls4(v1=spp())!=0||(v2=txp())==0?spc(v1):tpc(v2)
  //  中間コード4
  //    ls4(p=spp())!=0||(q=txp())==0?spc(p):tpc(q)
  //  中間コード5
  //    ((p=spp())&15)!=0||(q=txp())==0?spc(p):tpc(q)
  //  中間コード6
  //    ((p=spp())&15)!=0||(q=txp())==0?spo(p):tpo(q)
  ST {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int ty = CRTC.crtR11TxYZero + src & 1023;  //ラスタ
      int tc = (ty & CRTC.crtMask3) << 7 | CRTC.crtR10TxXCurr >> 3;  //テキスト桁位置
      int ta0 = 0x00e00000 + ((ty & CRTC.crtMaskMinus4) << 7);  //ラスタブロックアドレス
      int ta1 = 0x00020000 + ta0;
      int ta2 = 0x00040000 + ta0;
      int ta3 = 0x00060000 + ta0;
      int ts = CRTC.crtR10TxXCurr & 7;  //テキスト桁境界からのずれ
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        tc = tc + (half >> 3) & CRTC.crtMask511;
        da += half;
      }
      if (ts == 0) {  //テキスト桁境界に合っているとき
        while (da < db) {
          int tp = (VideoController.VCN_TXP3[MainMemory.mmrM8[ta3 + tc] & 255] |
                    VideoController.VCN_TXP2[MainMemory.mmrM8[ta2 + tc] & 255] |
                    VideoController.VCN_TXP1[MainMemory.mmrM8[ta1 + tc] & 255] |
                    VideoController.VCN_TXP0[MainMemory.mmrM8[ta0 + tc] & 255]);
          tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
          int p, q;
          XEiJ.pnlBM[da] = (((p = SpriteScreen.sprBuffer[sx]) & 15) != 0 || (q = tp >>> 28) == 0 ?
                            VideoController.vcnPal32TS[p] :
                            VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 1] = (((p = SpriteScreen.sprBuffer[sx + 1]) & 15) != 0 || (q = tp >>> 24 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 2] = (((p = SpriteScreen.sprBuffer[sx + 2]) & 15) != 0 || (q = tp >>> 20 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 3] = (((p = SpriteScreen.sprBuffer[sx + 3]) & 15) != 0 || (q = tp >>> 16 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 4] = (((p = SpriteScreen.sprBuffer[sx + 4]) & 15) != 0 || (q = tp >>> 12 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 5] = (((p = SpriteScreen.sprBuffer[sx + 5]) & 15) != 0 || (q = tp >>> 8 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 6] = (((p = SpriteScreen.sprBuffer[sx + 6]) & 15) != 0 || (q = tp >>> 4 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 7] = (((p = SpriteScreen.sprBuffer[sx + 7]) & 15) != 0 || (q = tp & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          sx += 8;
          da += 8;
        }  //while da<db
      } else {  //テキスト桁境界に合っていないとき
        //                                                             ts=1のとき
        int tt = ts + 8;                                             //tt=9
        ts += 16;                                                    //ts=17
        //                                                             ........ ........ ........ 01234567  m8[ta0+tc]
        int p0 = MainMemory.mmrM8[ta0 + tc] << ts;                   //.......0 1234567_ ________ ________  p0=m8[ta0+tc]<<ts
        int p1 = MainMemory.mmrM8[ta1 + tc] << ts;
        int p2 = MainMemory.mmrM8[ta2 + tc] << ts;
        int p3 = MainMemory.mmrM8[ta3 + tc] << ts;
        tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
        while (da < db) {
          //                                                           ........ ........ .1234567 ________  p0>>tt
          //                                                           ........ ........ .1234567 89abcdef  p0>>tt|m8[ta0+tc]&255
          p0 = (p0 >> tt | MainMemory.mmrM8[ta0 + tc] & 255) << ts;  //12345678 9abcdef_ ________ ________  p0=(p0>>tt|m8[ta0+tc]&255)<<ts
          p1 = (p1 >> tt | MainMemory.mmrM8[ta1 + tc] & 255) << ts;  //~~~~~~~~
          p2 = (p2 >> tt | MainMemory.mmrM8[ta2 + tc] & 255) << ts;  //ここを使う
          p3 = (p3 >> tt | MainMemory.mmrM8[ta3 + tc] & 255) << ts;
          int tp = (VideoController.VCN_TXP3[p3 >>> 24] |
                    VideoController.VCN_TXP2[p2 >>> 24] |
                    VideoController.VCN_TXP1[p1 >>> 24] |
                    VideoController.VCN_TXP0[p0 >>> 24]);  //符号なし右シフトで&255を省略
          tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
          int p, q;
          XEiJ.pnlBM[da] = (((p = SpriteScreen.sprBuffer[sx]) & 15) != 0 || (q = tp >>> 28) == 0 ?
                            VideoController.vcnPal32TS[p] :
                            VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 1] = (((p = SpriteScreen.sprBuffer[sx + 1]) & 15) != 0 || (q = tp >>> 24 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 2] = (((p = SpriteScreen.sprBuffer[sx + 2]) & 15) != 0 || (q = tp >>> 20 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 3] = (((p = SpriteScreen.sprBuffer[sx + 3]) & 15) != 0 || (q = tp >>> 16 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 4] = (((p = SpriteScreen.sprBuffer[sx + 4]) & 15) != 0 || (q = tp >>> 12 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 5] = (((p = SpriteScreen.sprBuffer[sx + 5]) & 15) != 0 || (q = tp >>> 8 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 6] = (((p = SpriteScreen.sprBuffer[sx + 6]) & 15) != 0 || (q = tp >>> 4 & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          XEiJ.pnlBM[da + 7] = (((p = SpriteScreen.sprBuffer[sx + 7]) & 15) != 0 || (q = tp & 15) == 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[q]);
          sx += 8;
          da += 8;
        }  //while da<db
      }  //if ts==0
    }  //drawRaster
  },  //ST

  //================================================================================
  //XST
  //  概要
  //    ST  スプライト＞テキスト
  //    拡張あり
  XST {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //ST_XWC
      case 0b00010001:  //ST_XWC
      case 0b00010010:  //ST_XWC
      case 0b00010011:  //ST_XWC
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //ST_XWP
      case 0b00010101:  //ST_XWP
      case 0b00010110:  //ST_XWP
      case 0b00010111:  //ST_XWP
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //ST_XHC
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //ST_XHCT
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //ST_XHCG
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //ST_XHCGT
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //ST_XHPT
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //ST_XHPG
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //ST_XHPGT
        ST.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //ST_A
      case 0b01000001:  //ST_A
      case 0b01000010:  //ST_A
      case 0b01000011:  //ST_A
      case 0b01000100:  //ST_A
      case 0b01000101:  //ST_A
      case 0b01000110:  //ST_A
      case 0b01000111:  //ST_A
      case 0b01001000:  //ST_A
      case 0b01001001:  //ST_A
      case 0b01001010:  //ST_A
      case 0b01001011:  //ST_A
      case 0b01001100:  //ST_A
      case 0b01001101:  //ST_A
      case 0b01001110:  //ST_A
      case 0b01001111:  //ST_A
      case 0b01010000:  //ST_A
      case 0b01010001:  //ST_A
      case 0b01010010:  //ST_A
      case 0b01010011:  //ST_A
      case 0b01010100:  //ST_A
      case 0b01010101:  //ST_A
      case 0b01010110:  //ST_A
      case 0b01010111:  //ST_A
      case 0b01011000:  //ST_A
      case 0b01011001:  //ST_A
      case 0b01011010:  //ST_A
      case 0b01011011:  //ST_A
      case 0b01011100:  //ST_A
      case 0b01011101:  //ST_A
      case 0b01011110:  //ST_A
      case 0b01011111:  //ST_A
        N.drawRaster (src, dst, rh);
        break;
      default:
        ST.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XST);
      }  //switch
    }  //drawRaster
  },  //XST

  //================================================================================
  //TS ($0000,$12xx,$0060)
  //  概要
  //    TS  テキスト＞スプライト
  //    拡張なし
  //  手順
  //    テキストパレットが0でないとき
  //      テキストカラー(0は黒)
  //    さもなくば(テキストパレットが0のとき)
  //      スプライトカラー(0は黒)
  //  中間コード1
  //    (txp()!=0?tpc(txp()):spc(spp()))
  //  中間コード2
  //    txp()!=0?tpc(txp()):spc(spp())
  //  中間コード3
  //    (v0=txp())!=0?tpc(v0):spc(spp())
  //  中間コード4
  //    (p=txp())!=0?tpc(p):spc(spp())
  //  中間コード5
  //    (p=txp())!=0?tpc(p):spc(spp())
  //  中間コード6
  //    (p=txp())!=0?tpo(p):spo(spp())
  TS {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int ty = CRTC.crtR11TxYZero + src & 1023;  //ラスタ
      int tc = (ty & CRTC.crtMask3) << 7 | CRTC.crtR10TxXCurr >> 3;  //テキスト桁位置
      int ta0 = 0x00e00000 + ((ty & CRTC.crtMaskMinus4) << 7);  //ラスタブロックアドレス
      int ta1 = 0x00020000 + ta0;
      int ta2 = 0x00040000 + ta0;
      int ta3 = 0x00060000 + ta0;
      int ts = CRTC.crtR10TxXCurr & 7;  //テキスト桁境界からのずれ
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        tc = tc + (half >> 3) & CRTC.crtMask511;
        da += half;
      }
      if (ts == 0) {  //テキスト桁境界に合っているとき
        while (da < db) {
          int tp = (VideoController.VCN_TXP3[MainMemory.mmrM8[ta3 + tc] & 255] |
                    VideoController.VCN_TXP2[MainMemory.mmrM8[ta2 + tc] & 255] |
                    VideoController.VCN_TXP1[MainMemory.mmrM8[ta1 + tc] & 255] |
                    VideoController.VCN_TXP0[MainMemory.mmrM8[ta0 + tc] & 255]);
          tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
          int p;
          XEiJ.pnlBM[da] = ((p = tp >>> 28) != 0 ?
                            VideoController.vcnPal32TS[p] :
                            VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
          XEiJ.pnlBM[da + 1] = ((p = tp >>> 24 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
          XEiJ.pnlBM[da + 2] = ((p = tp >>> 20 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
          XEiJ.pnlBM[da + 3] = ((p = tp >>> 16 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
          XEiJ.pnlBM[da + 4] = ((p = tp >>> 12 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
          XEiJ.pnlBM[da + 5] = ((p = tp >>> 8 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
          XEiJ.pnlBM[da + 6] = ((p = tp >>> 4 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
          XEiJ.pnlBM[da + 7] = ((p = tp & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
          sx += 8;
          da += 8;
        }  //while da<db
      } else {  //テキスト桁境界に合っていないとき
        //                                                             ts=1のとき
        int tt = ts + 8;                                             //tt=9
        ts += 16;                                                    //ts=17
        //                                                             ........ ........ ........ 01234567  m8[ta0+tc]
        int p0 = MainMemory.mmrM8[ta0 + tc] << ts;                   //.......0 1234567_ ________ ________  p0=m8[ta0+tc]<<ts
        int p1 = MainMemory.mmrM8[ta1 + tc] << ts;
        int p2 = MainMemory.mmrM8[ta2 + tc] << ts;
        int p3 = MainMemory.mmrM8[ta3 + tc] << ts;
        tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
        while (da < db) {
          //                                                           ........ ........ .1234567 ________  p0>>tt
          //                                                           ........ ........ .1234567 89abcdef  p0>>tt|m8[ta0+tc]&255
          p0 = (p0 >> tt | MainMemory.mmrM8[ta0 + tc] & 255) << ts;  //12345678 9abcdef_ ________ ________  p0=(p0>>tt|m8[ta0+tc]&255)<<ts
          p1 = (p1 >> tt | MainMemory.mmrM8[ta1 + tc] & 255) << ts;  //~~~~~~~~
          p2 = (p2 >> tt | MainMemory.mmrM8[ta2 + tc] & 255) << ts;  //ここを使う
          p3 = (p3 >> tt | MainMemory.mmrM8[ta3 + tc] & 255) << ts;
          int tp = (VideoController.VCN_TXP3[p3 >>> 24] |
                    VideoController.VCN_TXP2[p2 >>> 24] |
                    VideoController.VCN_TXP1[p1 >>> 24] |
                    VideoController.VCN_TXP0[p0 >>> 24]);  //符号なし右シフトで&255を省略
          tc = tc + 1 & CRTC.crtMask511;  //次回のテキスト桁位置
          int p;
          XEiJ.pnlBM[da] = ((p = tp >>> 28) != 0 ?
                            VideoController.vcnPal32TS[p] :
                            VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
          XEiJ.pnlBM[da + 1] = ((p = tp >>> 24 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
          XEiJ.pnlBM[da + 2] = ((p = tp >>> 20 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
          XEiJ.pnlBM[da + 3] = ((p = tp >>> 16 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
          XEiJ.pnlBM[da + 4] = ((p = tp >>> 12 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
          XEiJ.pnlBM[da + 5] = ((p = tp >>> 8 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
          XEiJ.pnlBM[da + 6] = ((p = tp >>> 4 & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
          XEiJ.pnlBM[da + 7] = ((p = tp & 15) != 0 ?
                                VideoController.vcnPal32TS[p] :
                                VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
          sx += 8;
          da += 8;
        }  //while da<db
      }  //if ts==0
    }  //drawRaster
  },  //TS

  //================================================================================
  //XTS
  //  概要
  //    TS  テキスト＞スプライト
  //    拡張あり
  XTS {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //TS_XWC
      case 0b00010001:  //TS_XWC
      case 0b00010010:  //TS_XWC
      case 0b00010011:  //TS_XWC
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //TS_XWP
      case 0b00010101:  //TS_XWP
      case 0b00010110:  //TS_XWP
      case 0b00010111:  //TS_XWP
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //TS_XHC
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //TS_XHCT
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //TS_XHCG
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //TS_XHCGT
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //TS_XHPT
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //TS_XHPG
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //TS_XHPGT
        TS.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //TS_A
      case 0b01000001:  //TS_A
      case 0b01000010:  //TS_A
      case 0b01000011:  //TS_A
      case 0b01000100:  //TS_A
      case 0b01000101:  //TS_A
      case 0b01000110:  //TS_A
      case 0b01000111:  //TS_A
      case 0b01001000:  //TS_A
      case 0b01001001:  //TS_A
      case 0b01001010:  //TS_A
      case 0b01001011:  //TS_A
      case 0b01001100:  //TS_A
      case 0b01001101:  //TS_A
      case 0b01001110:  //TS_A
      case 0b01001111:  //TS_A
      case 0b01010000:  //TS_A
      case 0b01010001:  //TS_A
      case 0b01010010:  //TS_A
      case 0b01010011:  //TS_A
      case 0b01010100:  //TS_A
      case 0b01010101:  //TS_A
      case 0b01010110:  //TS_A
      case 0b01010111:  //TS_A
      case 0b01011000:  //TS_A
      case 0b01011001:  //TS_A
      case 0b01011010:  //TS_A
      case 0b01011011:  //TS_A
      case 0b01011100:  //TS_A
      case 0b01011101:  //TS_A
      case 0b01011110:  //TS_A
      case 0b01011111:  //TS_A
        N.drawRaster (src, dst, rh);
        break;
      default:
        TS.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XTS);
      }  //switch
    }  //drawRaster
  },  //XTS

  //================================================================================
  //E1 ($0000,$06xx,$0001)
  //  概要
  //    E1  512ドット16色1プレーン
  //    拡張なし
  //  手順
  //    1番目のカラー(0は黒)
  //  中間コード1
  //    epc(e1p())
  //  中間コード2
  //    epc(e1p())
  //  中間コード3
  //    epc(e1p())
  //  中間コード4
  //    epc(e1p())
  //  中間コード5
  //    epc(e1p())
  //  中間コード6
  //    epo(e1p())
  E1 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        XEiJ.pnlBM[da] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st & 511]]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 1 & 511]]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 2 & 511]]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 3 & 511]]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 4 & 511]]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 5 & 511]]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 6 & 511]]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32G8[GraphicScreen.graM4[gy1st | gx1st + 7 & 511]]);
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1

  //================================================================================
  //XE1
  //  概要
  //    E1  512ドット16色1プレーン
  //    拡張あり
  XE1 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E1_XWC
      case 0b00010001:  //E1_XWC
      case 0b00010010:  //E1_XWC
      case 0b00010011:  //E1_XWC
        E1.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E1_XWP
      case 0b00010101:  //E1_XWP
      case 0b00010110:  //E1_XWP
      case 0b00010111:  //E1_XWP
        E1_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E1_XHC
        E1.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E1_XHCT
        E1_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E1_XHCG
        E1_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E1_XHCGT
        E1_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E1_XHPT
        E1_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E1_XHPG
        E1_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E1_XHPGT
        E1_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E1_A
      case 0b01000001:  //E1_A
      case 0b01000010:  //E1_A
      case 0b01000011:  //E1_A
      case 0b01000100:  //E1_A
      case 0b01000101:  //E1_A
      case 0b01000110:  //E1_A
      case 0b01000111:  //E1_A
      case 0b01001000:  //E1_A
      case 0b01001001:  //E1_A
      case 0b01001010:  //E1_A
      case 0b01001011:  //E1_A
      case 0b01001100:  //E1_A
      case 0b01001101:  //E1_A
      case 0b01001110:  //E1_A
      case 0b01001111:  //E1_A
      case 0b01010000:  //E1_A
      case 0b01010001:  //E1_A
      case 0b01010010:  //E1_A
      case 0b01010011:  //E1_A
      case 0b01010100:  //E1_A
      case 0b01010101:  //E1_A
      case 0b01010110:  //E1_A
      case 0b01010111:  //E1_A
      case 0b01011000:  //E1_A
      case 0b01011001:  //E1_A
      case 0b01011010:  //E1_A
      case 0b01011011:  //E1_A
      case 0b01011100:  //E1_A
      case 0b01011101:  //E1_A
      case 0b01011110:  //E1_A
      case 0b01011111:  //E1_A
        E1_A.drawRaster (src, dst, rh);
        break;
      default:
        E1.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE1);
      }  //switch
    }  //drawRaster
  },  //XE1

  //================================================================================
  //E1_XWP ($0000,$06xx,$1401)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p())))
  //  中間コード2
  //    e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())<=1?epc(0):ls1(v0)==0?epc(v0):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())<=1?epc(0):ls1(p)==0?epc(p):epc(tev(p))
  //  中間コード5
  //    (p=e1p())<=1?epc(0):(p&1)==0?epc(p):epc(p&-2)
  //  中間コード6
  //    (p=e1p())<=1?epo(0):(p&1)==0?epo(p):epo(p&-2)
  E1_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XWP

  //================================================================================
  //E1_XHCT ($0000,$06xx,$1901)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p()))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p())
  //  中間コード3
  //    ls1(epc(tev(v3=e1p())))!=0?mix(epc(v3),0):epc(v3)
  //  中間コード4
  //    ls1(epc(tev(p=e1p())))!=0?mix(epc(p),0):epc(p)
  //  中間コード5
  //    (epc((p=e1p())&-2)&1)!=0?mix(epc(p),0):epc(p)
  //  中間コード6
  //    (epc((p=e1p())&-2)&1)!=0?cto(mix(epc(p),0)):epo(p)
  E1_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 1] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 2] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 3] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 4] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 5] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 6] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 7] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XHCT

  //================================================================================
  //E1_XHCG ($0000,$06xx,$1A01)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のパレットが奇数のとき
  //        2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //      さもなくば(1番目のパレットが偶数のとき)
  //        1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p())))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p())
  //  中間コード3
  //    ls1(v1=epc(tev(v3=e1p())))!=0?mix(v1,epc(tod(e2q()))):ls1(v3)!=0?epc(tod(e2q())):epc(v3)
  //  中間コード4
  //    ls1(p=epc(tev(q=e1p())))!=0?mix(p,epc(tod(e2q()))):ls1(q)!=0?epc(tod(e2q())):epc(q)
  //  中間コード5
  //    ((p=epc((q=e1p())&-2))&1)!=0?mix(p,epc(e2q()|1)):(q&1)!=0?epc(e2q()|1):epc(q)
  //  中間コード6
  //    ((p=epc((q=e1p())&-2))&1)!=0?cto(mix(p,epc(e2q()|1))):(q&1)!=0?epo(e2q()|1):epo(q)
  E1_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XHCG

  //================================================================================
  //E1_XHCGT ($0000,$06xx,$1B01)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のパレットが奇数のとき
  //        2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //      さもなくば(1番目のパレットが偶数のとき)
  //        1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p())))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p())
  //  中間コード3
  //    ls1(v1=epc(tev(v3=e1p())))!=0?mix(mix(v1,epc(tod(e2q()))),0):ls1(v3)!=0?epc(tod(e2q())):epc(v3)
  //  中間コード4
  //    ls1(p=epc(tev(q=e1p())))!=0?mix(mix(p,epc(tod(e2q()))),0):ls1(q)!=0?epc(tod(e2q())):epc(q)
  //  中間コード5
  //    ((p=epc((q=e1p())&-2))&1)!=0?mix(mix(p,epc(e2q()|1)),0):(q&1)!=0?epc(e2q()|1):epc(q)
  //  中間コード6
  //    ((p=epc((q=e1p())&-2))&1)!=0?cto(mix(mix(p,epc(e2q()|1)),0)):(q&1)!=0?epo(e2q()|1):epo(q)
  E1_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XHCGT

  //================================================================================
  //E1_XHPT ($0000,$06xx,$1D01)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0))
  //  中間コード2
  //    e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0)
  //  中間コード3
  //    (v0=e1p())<=1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),0)
  //  中間コード4
  //    (p=e1p())<=1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),0)
  //  中間コード5
  //    (p=e1p())<=1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),0)
  //  中間コード6
  //    (p=e1p())<=1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),0))
  E1_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XHPT

  //================================================================================
  //E1_XHPG ($0000,$06xx,$1E01)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2q()))))
  //  中間コード2
  //    e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2q())))
  //  中間コード3
  //    (v0=e1p())<=1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),epc(tod(e2q())))
  //  中間コード4
  //    (p=e1p())<=1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),epc(tod(e2q())))
  //  中間コード5
  //    (p=e1p())<=1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),epc(e2q()|1))
  //  中間コード6
  //    (p=e1p())<=1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),epc(e2q()|1)))
  E1_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XHPG

  //================================================================================
  //E1_XHPGT ($0000,$06xx,$1F01)
  //  概要
  //    E1  512ドット16色1プレーン
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0))
  //  中間コード2
  //    e1p()<=1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0)
  //  中間コード3
  //    (v0=e1p())<=1?epc(0):ls1(v0)==0?epc(v0):mix(mix(epc(tev(v0)),epc(tod(e2q()))),0)
  //  中間コード4
  //    (p=e1p())<=1?epc(0):ls1(p)==0?epc(p):mix(mix(epc(tev(p)),epc(tod(e2q()))),0)
  //  中間コード5
  //    (p=e1p())<=1?epc(0):(p&1)==0?epc(p):mix(mix(epc(p&-2),epc(e2q()|1)),0)
  //  中間コード6
  //    (p=e1p())<=1?epo(0):(p&1)==0?epo(p):cto(mix(mix(epc(p&-2),epc(e2q()|1)),0))
  E1_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_XHPGT

  //================================================================================
  //E1_A ($0000,$06xx,$4001)
  //  概要
  //    E1  512ドット16色1プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    mix(epc(e1p()),tpc(0))
  //  中間コード2
  //    mix(epc(e1p()),tpc(0))
  //  中間コード3
  //    mix(epc(e1p()),tpc(0))
  //  中間コード4
  //    mix(epc(e1p()),tpc(0))
  //  中間コード5
  //    mix(epc(e1p()),tpc(0))
  //  中間コード6
  //    cto(mix(epc(e1p()),tpc(0)))
  E1_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st & 511]],
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 1 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 2 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 3 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 4 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 5 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 6 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 7 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1_A

  //================================================================================
  //E2 ($0000,$06xx,$0003)
  //  概要
  //    E2  512ドット16色2プレーン
  //    拡張なし
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?epc(e1p()):epc(e2p()))
  //  中間コード2
  //    e1p()!=0?epc(e1p()):epc(e2p())
  //  中間コード3
  //    (v0=e1p())!=0?epc(v0):epc(e2p())
  //  中間コード4
  //    (p=e1p())!=0?epc(p):epc(e2p())
  //  中間コード5
  //    (p=e1p())!=0?epc(p):epc(e2p())
  //  中間コード6
  //    (p=e1p())!=0?epo(p):epo(e2p())
  E2 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd & 511]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2

  //================================================================================
  //XE2
  //  概要
  //    E2  512ドット16色2プレーン
  //    拡張あり
  XE2 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E2_XWC
      case 0b00010001:  //E2_XWC
      case 0b00010010:  //E2_XWC
      case 0b00010011:  //E2_XWC
        E2.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E2_XWP
      case 0b00010101:  //E2_XWP
      case 0b00010110:  //E2_XWP
      case 0b00010111:  //E2_XWP
        E2_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E2_XHC
        E2.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E2_XHCT
        E2_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E2_XHCG
        E2_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E2_XHCGT
        E2_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E2_XHPT
        E2_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E2_XHPG
        E2_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E2_XHPGT
        E2_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E2_A
      case 0b01000001:  //E2_A
      case 0b01000010:  //E2_A
      case 0b01000011:  //E2_A
      case 0b01000100:  //E2_A
      case 0b01000101:  //E2_A
      case 0b01000110:  //E2_A
      case 0b01000111:  //E2_A
      case 0b01001000:  //E2_A
      case 0b01001001:  //E2_A
      case 0b01001010:  //E2_A
      case 0b01001011:  //E2_A
      case 0b01001100:  //E2_A
      case 0b01001101:  //E2_A
      case 0b01001110:  //E2_A
      case 0b01001111:  //E2_A
      case 0b01010000:  //E2_A
      case 0b01010001:  //E2_A
      case 0b01010010:  //E2_A
      case 0b01010011:  //E2_A
      case 0b01010100:  //E2_A
      case 0b01010101:  //E2_A
      case 0b01010110:  //E2_A
      case 0b01010111:  //E2_A
      case 0b01011000:  //E2_A
      case 0b01011001:  //E2_A
      case 0b01011010:  //E2_A
      case 0b01011011:  //E2_A
      case 0b01011100:  //E2_A
      case 0b01011101:  //E2_A
      case 0b01011110:  //E2_A
      case 0b01011111:  //E2_A
        E2_A.drawRaster (src, dst, rh);
        break;
      default:
        E2.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE2);
      }  //switch
    }  //drawRaster
  },  //XE2

  //================================================================================
  //E2_XWP ($0000,$06xx,$1403)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p())))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())==0?epc(tev(e2p())):v0==1?epc(0):ls1(v0)==0?epc(v0):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())==0?epc(tev(e2p())):p==1?epc(0):ls1(p)==0?epc(p):epc(tev(p))
  //  中間コード5
  //    (p=e1p())==0?epc(e2p()&-2):p==1?epc(0):(p&1)==0?epc(p):epc(p&-2)
  //  中間コード6
  //    (p=e1p())==0?epo(e2p()&-2):p==1?epo(0):(p&1)==0?epo(p):epo(p&-2)
  E2_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XWP

  //================================================================================
  //E2_XHCT ($0000,$06xx,$1903)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のカラーとカラー0を混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p())):(ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),0):epc(e2p())))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p()):ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),0):epc(e2p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?mix(epc(v0),0):epc(v0):ls1(epc(tev(v10=e2p())))!=0?mix(epc(v10),0):epc(v10)
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),0):epc(p):ls1(epc(tev(p=e2p())))!=0?mix(epc(p),0):epc(p)
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),0):epc(p):(epc((p=e2p())&-2)&1)!=0?mix(epc(p),0):epc(p)
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),0)):epo(p):(epc((p=e2p())&-2)&1)!=0?cto(mix(epc(p),0)):epo(p)
  E2_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XHCT

  //================================================================================
  //E2_XHCG ($0000,$06xx,$1A03)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()))):(ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p())))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()):ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(v2,epc(tod(e2q()))):ls1(v0)!=0?epc(tod(e2q())):epc(v0):ls1(v14=epc(tev(v16=e2p())))!=0?mix(v14,epc(tod(e2q()))):epc(v16)
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(tod(e2q()))):ls1(p)!=0?epc(tod(e2q())):epc(p):ls1(p=epc(tev(q=e2p())))!=0?mix(p,epc(tod(e2q()))):epc(q)
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(e2q()|1)):(p&1)!=0?epc(e2q()|1):epc(p):((p=epc((q=e2p())&-2))&1)!=0?mix(p,epc(e2q()|1)):epc(q)
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(e2q()|1))):(p&1)!=0?epo(e2q()|1):epo(p):((p=epc((q=e2p())&-2))&1)!=0?cto(mix(p,epc(e2q()|1))):epo(q)
  E2_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XHCG

  //================================================================================
  //E2_XHCGT ($0000,$06xx,$1B03)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()))):(ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),0):epc(e2p())))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()):ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),0):epc(e2p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(mix(v2,epc(tod(e2q()))),0):ls1(v0)!=0?epc(tod(e2q())):epc(v0):ls1(v15=epc(tev(v17=e2p())))!=0?mix(mix(v15,epc(tod(e2q()))),0):epc(v17)
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(tod(e2q()))),0):ls1(p)!=0?epc(tod(e2q())):epc(p):ls1(p=epc(tev(q=e2p())))!=0?mix(mix(p,epc(tod(e2q()))),0):epc(q)
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(e2q()|1)),0):(p&1)!=0?epc(e2q()|1):epc(p):((p=epc((q=e2p())&-2))&1)!=0?mix(mix(p,epc(e2q()|1)),0):epc(q)
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(e2q()|1)),0)):(p&1)!=0?epo(e2q()|1):epo(p):((p=epc((q=e2p())&-2))&1)!=0?cto(mix(mix(p,epc(e2q()|1)),0)):epo(q)
  E2_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XHCGT

  //================================================================================
  //E2_XHPT ($0000,$06xx,$1D03)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0)
  //  中間コード3
  //    (v0=e1p())==0?epc(tev(e2p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),0)
  //  中間コード4
  //    (p=e1p())==0?epc(tev(e2p())):p==1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),0)
  //  中間コード5
  //    (p=e1p())==0?epc(e2p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),0)
  //  中間コード6
  //    (p=e1p())==0?epo(e2p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),0))
  E2_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XHPT

  //================================================================================
  //E2_XHPG ($0000,$06xx,$1E03)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2p()))))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2p())))
  //  中間コード3
  //    (v0=e1p())==0?epc(tev(e2p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),epc(tod(e2p())))
  //  中間コード4
  //    (p=e1p())==0?epc(tev(e2p())):p==1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),epc(tod(e2p())))
  //  中間コード5
  //    (p=e1p())==0?epc(e2p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),epc(e2p()|1))
  //  中間コード6
  //    (p=e1p())==0?epo(e2p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),epc(e2p()|1)))
  E2_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] | 1])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] | 1])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] | 1])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] | 1])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] | 1])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] | 1])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] | 1])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] | 1])]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XHPG

  //================================================================================
  //E2_XHPGT ($0000,$06xx,$1F03)
  //  概要
  //    E2  512ドット16色2プレーン
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2p()))),0))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2p()))),0)
  //  中間コード3
  //    (v0=e1p())==0?epc(tev(e2p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(mix(epc(tev(v0)),epc(tod(e2p()))),0)
  //  中間コード4
  //    (p=e1p())==0?epc(tev(e2p())):p==1?epc(0):ls1(p)==0?epc(p):mix(mix(epc(tev(p)),epc(tod(e2p()))),0)
  //  中間コード5
  //    (p=e1p())==0?epc(e2p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(mix(epc(p&-2),epc(e2p()|1)),0)
  //  中間コード6
  //    (p=e1p())==0?epo(e2p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(mix(epc(p&-2),epc(e2p()|1)),0))
  E2_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] | 1]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] | 1]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_XHPGT

  //================================================================================
  //E2_A ($0000,$06xx,$4003)
  //  概要
  //    E2  512ドット16色2プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?mix(epc(e1p()),tpc(0)):mix(epc(e2p()),tpc(0)))
  //  中間コード2
  //    e1p()!=0?mix(epc(e1p()),tpc(0)):mix(epc(e2p()),tpc(0))
  //  中間コード3
  //    (v0=e1p())!=0?mix(epc(v0),tpc(0)):mix(epc(e2p()),tpc(0))
  //  中間コード4
  //    (p=e1p())!=0?mix(epc(p),tpc(0)):mix(epc(e2p()),tpc(0))
  //  中間コード5
  //    (p=e1p())!=0?mix(epc(p),tpc(0)):mix(epc(e2p()),tpc(0))
  //  中間コード6
  //    cto((p=e1p())!=0?mix(epc(p),tpc(0)):mix(epc(e2p()),tpc(0)))
  E2_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            (p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511]],
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2_A

  //================================================================================
  //E3 ($0000,$06xx,$0007)
  //  概要
  //    E3  512ドット16色3プレーン
  //    拡張なし
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?epc(e1p()):(e2p()!=0?epc(e2p()):epc(e3p())))
  //  中間コード2
  //    e1p()!=0?epc(e1p()):e2p()!=0?epc(e2p()):epc(e3p())
  //  中間コード3
  //    (v0=e1p())!=0?epc(v0):(v2=e2p())!=0?epc(v2):epc(e3p())
  //  中間コード4
  //    (p=e1p())!=0?epc(p):(p=e2p())!=0?epc(p):epc(e3p())
  //  中間コード5
  //    (p=e1p())!=0?epc(p):(p=e2p())!=0?epc(p):epc(e3p())
  //  中間コード6
  //    (p=e1p())!=0?epo(p):(p=e2p())!=0?epo(p):epo(e3p())
  E3 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd & 511]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3

  //================================================================================
  //XE3
  //  概要
  //    E3  512ドット16色3プレーン
  //    拡張あり
  XE3 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E3_XWC
      case 0b00010001:  //E3_XWC
      case 0b00010010:  //E3_XWC
      case 0b00010011:  //E3_XWC
        E3.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E3_XWP
      case 0b00010101:  //E3_XWP
      case 0b00010110:  //E3_XWP
      case 0b00010111:  //E3_XWP
        E3_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E3_XHC
        E3.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E3_XHCT
        E3_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E3_XHCG
        E3_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E3_XHCGT
        E3_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E3_XHPT
        E3_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E3_XHPG
        E3_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E3_XHPGT
        E3_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E3_A
      case 0b01000001:  //E3_A
      case 0b01000010:  //E3_A
      case 0b01000011:  //E3_A
      case 0b01000100:  //E3_A
      case 0b01000101:  //E3_A
      case 0b01000110:  //E3_A
      case 0b01000111:  //E3_A
      case 0b01001000:  //E3_A
      case 0b01001001:  //E3_A
      case 0b01001010:  //E3_A
      case 0b01001011:  //E3_A
      case 0b01001100:  //E3_A
      case 0b01001101:  //E3_A
      case 0b01001110:  //E3_A
      case 0b01001111:  //E3_A
      case 0b01010000:  //E3_A
      case 0b01010001:  //E3_A
      case 0b01010010:  //E3_A
      case 0b01010011:  //E3_A
      case 0b01010100:  //E3_A
      case 0b01010101:  //E3_A
      case 0b01010110:  //E3_A
      case 0b01010111:  //E3_A
      case 0b01011000:  //E3_A
      case 0b01011001:  //E3_A
      case 0b01011010:  //E3_A
      case 0b01011011:  //E3_A
      case 0b01011100:  //E3_A
      case 0b01011101:  //E3_A
      case 0b01011110:  //E3_A
      case 0b01011111:  //E3_A
        E3_A.drawRaster (src, dst, rh);
        break;
      default:
        E3.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE3);
      }  //switch
    }  //drawRaster
  },  //XE3

  //================================================================================
  //E3_XWP ($0000,$06xx,$1407)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):epc(tev(e3p()))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p())))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):epc(tev(e3p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):epc(tev(e3p())):v0==1?epc(0):ls1(v0)==0?epc(v0):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):epc(tev(e3p())):p==1?epc(0):ls1(p)==0?epc(p):epc(tev(p))
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):epc(e3p()&-2):p==1?epc(0):(p&1)==0?epc(p):epc(p&-2)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):epo(e3p()&-2):p==1?epo(0):(p&1)==0?epo(p):epo(p&-2)
  E3_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XWP

  //================================================================================
  //E3_XHCT ($0000,$06xx,$1907)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のカラーとカラー0を混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          3番目のカラーとカラー0を混ぜたカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          3番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p())):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),0):epc(e2p())):(ls1(epc(tev(e3p())))!=0?mix(epc(e3p()),0):epc(e3p()))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),0):epc(e2p()):ls1(epc(tev(e3p())))!=0?mix(epc(e3p()),0):epc(e3p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?mix(epc(v0),0):epc(v0):(v7=e2p())!=0?ls1(epc(tev(v7)))!=0?mix(epc(v7),0):epc(v7):ls1(epc(tev(v17=e3p())))!=0?mix(epc(v17),0):epc(v17)
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),0):epc(p):(p=e2p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),0):epc(p):ls1(epc(tev(p=e3p())))!=0?mix(epc(p),0):epc(p)
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),0):epc(p):(p=e2p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),0):epc(p):(epc((p=e3p())&-2)&1)!=0?mix(epc(p),0):epc(p)
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),0)):epo(p):(p=e2p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),0)):epo(p):(epc((p=e3p())&-2)&1)!=0?cto(mix(epc(p),0)):epo(p)
  E3_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XHCT

  //================================================================================
  //E3_XHCG ($0000,$06xx,$1A07)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          3番目のパレットが奇数のとき
  //            パレット1のカラー(0は黒)
  //          さもなくば(3番目のパレットが偶数のとき)
  //            3番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()))):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p())):(ls1(epc(tev(e3p())))!=0?mix(epc(tev(e3p())),epc(1)):(ls1(e3p())!=0?epc(1):epc(e3p())))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p()):ls1(epc(tev(e3p())))!=0?mix(epc(tev(e3p())),epc(1)):ls1(e3p())!=0?epc(1):epc(e3p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(v2,epc(tod(e2q()))):ls1(v0)!=0?epc(tod(e2q())):epc(v0):(v13=e2p())!=0?ls1(v15=epc(tev(v13)))!=0?mix(v15,epc(tod(e2q()))):epc(v13):ls1(v23=epc(tev(v25=e3p())))!=0?mix(v23,epc(1)):ls1(v25)!=0?epc(1):epc(v25)
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(tod(e2q()))):ls1(p)!=0?epc(tod(e2q())):epc(p):(p=e2p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(tod(e2q()))):epc(p):ls1(p=epc(tev(q=e3p())))!=0?mix(p,epc(1)):ls1(q)!=0?epc(1):epc(q)
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(e2q()|1)):(p&1)!=0?epc(e2q()|1):epc(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(e2q()|1)):epc(p):((p=epc((q=e3p())&-2))&1)!=0?mix(p,epc(1)):(q&1)!=0?epc(1):epc(q)
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(e2q()|1))):(p&1)!=0?epo(e2q()|1):epo(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(e2q()|1))):epo(p):((p=epc((q=e3p())&-2))&1)!=0?cto(mix(p,epc(1))):(q&1)!=0?epo(1):epo(q)
  E3_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[1])] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XHCG

  //================================================================================
  //E3_XHCGT ($0000,$06xx,$1B07)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          3番目のパレットが奇数のとき
  //            パレット1のカラー(0は黒)
  //          さもなくば(3番目のパレットが偶数のとき)
  //            3番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()))):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),0):epc(e2p())):(ls1(epc(tev(e3p())))!=0?mix(mix(epc(tev(e3p())),epc(1)),0):(ls1(e3p())!=0?epc(1):epc(e3p())))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),0):epc(e2p()):ls1(epc(tev(e3p())))!=0?mix(mix(epc(tev(e3p())),epc(1)),0):ls1(e3p())!=0?epc(1):epc(e3p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(mix(v2,epc(tod(e2q()))),0):ls1(v0)!=0?epc(tod(e2q())):epc(v0):(v14=e2p())!=0?ls1(v16=epc(tev(v14)))!=0?mix(mix(v16,epc(tod(e2q()))),0):epc(v14):ls1(v25=epc(tev(v27=e3p())))!=0?mix(mix(v25,epc(1)),0):ls1(v27)!=0?epc(1):epc(v27)
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(tod(e2q()))),0):ls1(p)!=0?epc(tod(e2q())):epc(p):(p=e2p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(tod(e2q()))),0):epc(p):ls1(p=epc(tev(q=e3p())))!=0?mix(mix(p,epc(1)),0):ls1(q)!=0?epc(1):epc(q)
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(e2q()|1)),0):(p&1)!=0?epc(e2q()|1):epc(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(e2q()|1)),0):epc(p):((p=epc((q=e3p())&-2))&1)!=0?mix(mix(p,epc(1)),0):(q&1)!=0?epc(1):epc(q)
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(e2q()|1)),0)):(p&1)!=0?epo(e2q()|1):epo(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(e2q()|1)),0)):epo(p):((p=epc((q=e3p())&-2))&1)!=0?cto(mix(mix(p,epc(1)),0)):(q&1)!=0?epo(1):epo(q)
  E3_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[1]),
                              0)] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XHCGT

  //================================================================================
  //E3_XHPT ($0000,$06xx,$1D07)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):epc(tev(e3p()))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):epc(tev(e3p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0)
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):epc(tev(e3p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),0)
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):epc(tev(e3p())):p==1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),0)
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):epc(e3p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),0)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):epo(e3p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),0))
  E3_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XHPT

  //================================================================================
  //E3_XHPG ($0000,$06xx,$1E07)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):epc(tev(e3p()))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2q()))))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):epc(tev(e3p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2q())))
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):epc(tev(e3p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),epc(tod(e2q())))
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):epc(tev(e3p())):p==1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),epc(tod(e2q())))
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):epc(e3p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),epc(e2q()|1))
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):epo(e3p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),epc(e2q()|1)))
  E3_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XHPG

  //================================================================================
  //E3_XHPGT ($0000,$06xx,$1F07)
  //  概要
  //    E3  512ドット16色3プレーン
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):epc(tev(e3p()))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):epc(tev(e3p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0)
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):epc(tev(e3p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(mix(epc(tev(v0)),epc(tod(e2q()))),0)
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):epc(tev(e3p())):p==1?epc(0):ls1(p)==0?epc(p):mix(mix(epc(tev(p)),epc(tod(e2q()))),0)
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):epc(e3p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(mix(epc(p&-2),epc(e2q()|1)),0)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):epo(e3p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(mix(epc(p&-2),epc(e2q()|1)),0))
  E3_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_XHPGT

  //================================================================================
  //E3_A ($0000,$06xx,$4007)
  //  概要
  //    E3  512ドット16色3プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?mix(epc(e1p()),tpc(0)):(e2p()!=0?mix(epc(e2p()),tpc(0)):mix(epc(e3p()),tpc(0))))
  //  中間コード2
  //    e1p()!=0?mix(epc(e1p()),tpc(0)):e2p()!=0?mix(epc(e2p()),tpc(0)):mix(epc(e3p()),tpc(0))
  //  中間コード3
  //    (v0=e1p())!=0?mix(epc(v0),tpc(0)):(v4=e2p())!=0?mix(epc(v4),tpc(0)):mix(epc(e3p()),tpc(0))
  //  中間コード4
  //    (p=e1p())!=0?mix(epc(p),tpc(0)):(p=e2p())!=0?mix(epc(p),tpc(0)):mix(epc(e3p()),tpc(0))
  //  中間コード5
  //    (p=e1p())!=0?mix(epc(p),tpc(0)):(p=e2p())!=0?mix(epc(p),tpc(0)):mix(epc(e3p()),tpc(0))
  //  中間コード6
  //    cto((p=e1p())!=0?mix(epc(p),tpc(0)):(p=e2p())!=0?mix(epc(p),tpc(0)):mix(epc(e3p()),tpc(0)))
  E3_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            (p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd & 511]],
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3_A

  //================================================================================
  //E4 ($0000,$06xx,$000F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    拡張なし
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットが0でないとき
  //          3番目のカラー(0は黒)
  //        さもなくば(3番目のパレットが0のとき)
  //          4番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?epc(e1p()):(e2p()!=0?epc(e2p()):(e3p()!=0?epc(e3p()):epc(e4p()))))
  //  中間コード2
  //    e1p()!=0?epc(e1p()):e2p()!=0?epc(e2p()):e3p()!=0?epc(e3p()):epc(e4p())
  //  中間コード3
  //    (v0=e1p())!=0?epc(v0):(v2=e2p())!=0?epc(v2):(v4=e3p())!=0?epc(v4):epc(e4p())
  //  中間コード4
  //    (p=e1p())!=0?epc(p):(p=e2p())!=0?epc(p):(p=e3p())!=0?epc(p):epc(e4p())
  //  中間コード5
  //    (p=e1p())!=0?epc(p):(p=e2p())!=0?epc(p):(p=e3p())!=0?epc(p):epc(e4p())
  //  中間コード6
  //    (p=e1p())!=0?epo(p):(p=e2p())!=0?epo(p):(p=e3p())!=0?epo(p):epo(e4p())
  E4 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th & 511]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 1 & 511]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 2 & 511]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 3 & 511]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 4 & 511]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 5 & 511]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 6 & 511]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 7 & 511]]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4

  //================================================================================
  //XE4
  //  概要
  //    E4  512ドット16色4プレーン
  //    拡張あり
  XE4 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E4_XWC
      case 0b00010001:  //E4_XWC
      case 0b00010010:  //E4_XWC
      case 0b00010011:  //E4_XWC
        E4.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E4_XWP
      case 0b00010101:  //E4_XWP
      case 0b00010110:  //E4_XWP
      case 0b00010111:  //E4_XWP
        E4_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E4_XHC
        E4.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E4_XHCT
        E4_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E4_XHCG
        E4_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E4_XHCGT
        E4_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E4_XHPT
        E4_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E4_XHPG
        E4_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E4_XHPGT
        E4_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E4_A
      case 0b01000001:  //E4_A
      case 0b01000010:  //E4_A
      case 0b01000011:  //E4_A
      case 0b01000100:  //E4_A
      case 0b01000101:  //E4_A
      case 0b01000110:  //E4_A
      case 0b01000111:  //E4_A
      case 0b01001000:  //E4_A
      case 0b01001001:  //E4_A
      case 0b01001010:  //E4_A
      case 0b01001011:  //E4_A
      case 0b01001100:  //E4_A
      case 0b01001101:  //E4_A
      case 0b01001110:  //E4_A
      case 0b01001111:  //E4_A
      case 0b01010000:  //E4_A
      case 0b01010001:  //E4_A
      case 0b01010010:  //E4_A
      case 0b01010011:  //E4_A
      case 0b01010100:  //E4_A
      case 0b01010101:  //E4_A
      case 0b01010110:  //E4_A
      case 0b01010111:  //E4_A
      case 0b01011000:  //E4_A
      case 0b01011001:  //E4_A
      case 0b01011010:  //E4_A
      case 0b01011011:  //E4_A
      case 0b01011100:  //E4_A
      case 0b01011101:  //E4_A
      case 0b01011110:  //E4_A
      case 0b01011111:  //E4_A
        E4_A.drawRaster (src, dst, rh);
        break;
      default:
        E4.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE4);
      }  //switch
    }  //drawRaster
  },  //XE4

  //================================================================================
  //E4_XWP ($0000,$06xx,$140F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):((tev(e3p()))!=0?epc(tev(e3p())):epc(tev(e4p())))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p())))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):tev(e3p())!=0?epc(tev(e3p())):epc(tev(e4p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):(v4=tev(e3p()))!=0?epc(v4):epc(tev(e4p())):v0==1?epc(0):ls1(v0)==0?epc(v0):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):(p=tev(e3p()))!=0?epc(p):epc(tev(e4p())):p==1?epc(0):ls1(p)==0?epc(p):epc(tev(p))
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):(p=e3p()&-2)!=0?epc(p):epc(e4p()&-2):p==1?epc(0):(p&1)==0?epc(p):epc(p&-2)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):(p=e3p()&-2)!=0?epo(p):epo(e4p()&-2):p==1?epo(0):(p&1)==0?epo(p):epo(p&-2)
  E4_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XWP

  //================================================================================
  //E4_XHCT ($0000,$06xx,$190F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のカラーとカラー0を混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //            3番目のカラーとカラー0を混ぜたカラー(0は黒)
  //          さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //            3番目のカラー(0は黒)
  //        さもなくば(3番目のパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラーが奇数のとき
  //            4番目のカラーとカラー0を混ぜたカラー(0は黒)
  //          さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //            4番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p())):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),0):epc(e2p())):(e3p()!=0?(ls1(epc(tev(e3p())))!=0?mix(epc(e3p()),0):epc(e3p())):(ls1(epc(tev(e4p())))!=0?mix(epc(e4p()),0):epc(e4p())))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),0):epc(e1p()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),0):epc(e2p()):e3p()!=0?ls1(epc(tev(e3p())))!=0?mix(epc(e3p()),0):epc(e3p()):ls1(epc(tev(e4p())))!=0?mix(epc(e4p()),0):epc(e4p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?mix(epc(v0),0):epc(v0):(v7=e2p())!=0?ls1(epc(tev(v7)))!=0?mix(epc(v7),0):epc(v7):(v14=e3p())!=0?ls1(epc(tev(v14)))!=0?mix(epc(v14),0):epc(v14):ls1(epc(tev(v24=e4p())))!=0?mix(epc(v24),0):epc(v24)
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),0):epc(p):(p=e2p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),0):epc(p):(p=e3p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),0):epc(p):ls1(epc(tev(p=e4p())))!=0?mix(epc(p),0):epc(p)
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),0):epc(p):(p=e2p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),0):epc(p):(p=e3p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),0):epc(p):(epc((p=e4p())&-2)&1)!=0?mix(epc(p),0):epc(p)
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),0)):epo(p):(p=e2p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),0)):epo(p):(p=e3p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),0)):epo(p):(epc((p=e4p())&-2)&1)!=0?cto(mix(epc(p),0)):epo(p)
  E4_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy4th | gx4th + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XHCT

  //================================================================================
  //E4_XHCG ($0000,$06xx,$1A0F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //            3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
  //          さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //            3番目のパレットが奇数のとき
  //              パレット1のカラー(0は黒)
  //            さもなくば(3番目のパレットが偶数のとき)
  //              3番目のカラー(0は黒)
  //        さもなくば(3番目のパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラーが奇数のとき
  //            4番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラー(0は黒)
  //          さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //            4番目のパレットが奇数のとき
  //              パレット1のカラー(0は黒)
  //            さもなくば(4番目のパレットが偶数のとき)
  //              4番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()))):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p())):(e3p()!=0?(ls1(epc(tev(e3p())))!=0?mix(epc(tev(e3p())),epc(1)):(ls1(e3p())!=0?epc(1):epc(e3p()))):(ls1(epc(tev(e4p())))!=0?mix(epc(tev(e4p())),epc(1)):(ls1(e4p())!=0?epc(1):epc(e4p()))))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p()):e3p()!=0?ls1(epc(tev(e3p())))!=0?mix(epc(tev(e3p())),epc(1)):ls1(e3p())!=0?epc(1):epc(e3p()):ls1(epc(tev(e4p())))!=0?mix(epc(tev(e4p())),epc(1)):ls1(e4p())!=0?epc(1):epc(e4p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(v2,epc(tod(e2q()))):ls1(v0)!=0?epc(tod(e2q())):epc(v0):(v13=e2p())!=0?ls1(v15=epc(tev(v13)))!=0?mix(v15,epc(tod(e2q()))):epc(v13):(v22=e3p())!=0?ls1(v24=epc(tev(v22)))!=0?mix(v24,epc(1)):ls1(v22)!=0?epc(1):epc(v22):ls1(v32=epc(tev(v34=e4p())))!=0?mix(v32,epc(1)):ls1(v34)!=0?epc(1):epc(v34)
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(tod(e2q()))):ls1(p)!=0?epc(tod(e2q())):epc(p):(p=e2p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(tod(e2q()))):epc(p):(p=e3p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(1)):ls1(p)!=0?epc(1):epc(p):ls1(p=epc(tev(q=e4p())))!=0?mix(p,epc(1)):ls1(q)!=0?epc(1):epc(q)
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(e2q()|1)):(p&1)!=0?epc(e2q()|1):epc(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(e2q()|1)):epc(p):(p=e3p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(1)):(p&1)!=0?epc(1):epc(p):((p=epc((q=e4p())&-2))&1)!=0?mix(p,epc(1)):(q&1)!=0?epc(1):epc(q)
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(e2q()|1))):(p&1)!=0?epo(e2q()|1):epo(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(e2q()|1))):epo(p):(p=e3p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(1))):(p&1)!=0?epo(1):epo(p):((p=epc((q=e4p())&-2))&1)!=0?cto(mix(p,epc(1))):(q&1)!=0?epo(1):epo(q)
  E4_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[1])] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[1] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[1])] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XHCG

  //================================================================================
  //E4_XHCGT ($0000,$06xx,$1B0F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //            3番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //          さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //            3番目のパレットが奇数のとき
  //              パレット1のカラー(0は黒)
  //            さもなくば(3番目のパレットが偶数のとき)
  //              3番目のカラー(0は黒)
  //        さもなくば(3番目のパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラーが奇数のとき
  //            4番目のパレットを偶数化したパレットのカラーとパレット1のカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //          さもなくば(4番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //            4番目のパレットが奇数のとき
  //              パレット1のカラー(0は黒)
  //            さもなくば(4番目のパレットが偶数のとき)
  //              4番目のカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):(ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()))):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),0):epc(e2p())):(e3p()!=0?(ls1(epc(tev(e3p())))!=0?mix(mix(epc(tev(e3p())),epc(1)),0):(ls1(e3p())!=0?epc(1):epc(e3p()))):(ls1(epc(tev(e4p())))!=0?mix(mix(epc(tev(e4p())),epc(1)),0):(ls1(e4p())!=0?epc(1):epc(e4p()))))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0):ls1(e1p())!=0?epc(tod(e2q())):epc(e1p()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),0):epc(e2p()):e3p()!=0?ls1(epc(tev(e3p())))!=0?mix(mix(epc(tev(e3p())),epc(1)),0):ls1(e3p())!=0?epc(1):epc(e3p()):ls1(epc(tev(e4p())))!=0?mix(mix(epc(tev(e4p())),epc(1)),0):ls1(e4p())!=0?epc(1):epc(e4p())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(mix(v2,epc(tod(e2q()))),0):ls1(v0)!=0?epc(tod(e2q())):epc(v0):(v14=e2p())!=0?ls1(v16=epc(tev(v14)))!=0?mix(mix(v16,epc(tod(e2q()))),0):epc(v14):(v24=e3p())!=0?ls1(v26=epc(tev(v24)))!=0?mix(mix(v26,epc(1)),0):ls1(v24)!=0?epc(1):epc(v24):ls1(v35=epc(tev(v37=e4p())))!=0?mix(mix(v35,epc(1)),0):ls1(v37)!=0?epc(1):epc(v37)
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(tod(e2q()))),0):ls1(p)!=0?epc(tod(e2q())):epc(p):(p=e2p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(tod(e2q()))),0):epc(p):(p=e3p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(1)),0):ls1(p)!=0?epc(1):epc(p):ls1(p=epc(tev(q=e4p())))!=0?mix(mix(p,epc(1)),0):ls1(q)!=0?epc(1):epc(q)
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(e2q()|1)),0):(p&1)!=0?epc(e2q()|1):epc(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(e2q()|1)),0):epc(p):(p=e3p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(1)),0):(p&1)!=0?epc(1):epc(p):((p=epc((q=e4p())&-2))&1)!=0?mix(mix(p,epc(1)),0):(q&1)!=0?epc(1):epc(q)
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(e2q()|1)),0)):(p&1)!=0?epo(e2q()|1):epo(p):(p=e2p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(e2q()|1)),0)):epo(p):(p=e3p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(1)),0)):(p&1)!=0?epo(1):epo(p):((p=epc((q=e4p())&-2))&1)!=0?cto(mix(mix(p,epc(1)),0)):(q&1)!=0?epo(1):epo(q)
  E4_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[1]),
                              0)] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[1] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[1]),
                              0)] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy4th | gx4th + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XHCGT

  //================================================================================
  //E4_XHPT ($0000,$06xx,$1D0F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):((tev(e3p()))!=0?epc(tev(e3p())):epc(tev(e4p())))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):tev(e3p())!=0?epc(tev(e3p())):epc(tev(e4p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),0)
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):(v4=tev(e3p()))!=0?epc(v4):epc(tev(e4p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),0)
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):(p=tev(e3p()))!=0?epc(p):epc(tev(e4p())):p==1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),0)
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):(p=e3p()&-2)!=0?epc(p):epc(e4p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),0)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):(p=e3p()&-2)!=0?epo(p):epo(e4p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),0))
  E4_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XHPT

  //================================================================================
  //E4_XHPG ($0000,$06xx,$1E0F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):((tev(e3p()))!=0?epc(tev(e3p())):epc(tev(e4p())))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2q()))))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):tev(e3p())!=0?epc(tev(e3p())):epc(tev(e4p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(epc(tev(e1p())),epc(tod(e2q())))
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):(v4=tev(e3p()))!=0?epc(v4):epc(tev(e4p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(epc(tev(v0)),epc(tod(e2q())))
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):(p=tev(e3p()))!=0?epc(p):epc(tev(e4p())):p==1?epc(0):ls1(p)==0?epc(p):mix(epc(tev(p)),epc(tod(e2q())))
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):(p=e3p()&-2)!=0?epc(p):epc(e4p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(epc(p&-2),epc(e2q()|1))
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):(p=e3p()&-2)!=0?epo(p):epo(e4p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(epc(p&-2),epc(e2q()|1)))
  E4_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XHPG

  //================================================================================
  //E4_XHPGT ($0000,$06xx,$1F0F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットが0でないとき
  //          3番目のパレットを偶数化したパレットのカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットが0のとき)
  //          4番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?epc(tev(e2p())):((tev(e3p()))!=0?epc(tev(e3p())):epc(tev(e4p())))):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p())):tev(e3p())!=0?epc(tev(e3p())):epc(tev(e4p())):e1p()==1?epc(0):ls1(e1p())==0?epc(e1p()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),0)
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?epc(v1):(v4=tev(e3p()))!=0?epc(v4):epc(tev(e4p())):v0==1?epc(0):ls1(v0)==0?epc(v0):mix(mix(epc(tev(v0)),epc(tod(e2q()))),0)
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?epc(p):(p=tev(e3p()))!=0?epc(p):epc(tev(e4p())):p==1?epc(0):ls1(p)==0?epc(p):mix(mix(epc(tev(p)),epc(tod(e2q()))),0)
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epc(p):(p=e3p()&-2)!=0?epc(p):epc(e4p()&-2):p==1?epc(0):(p&1)==0?epc(p):mix(mix(epc(p&-2),epc(e2q()|1)),0)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?epo(p):(p=e3p()&-2)!=0?epo(p):epo(e4p()&-2):p==1?epo(0):(p&1)==0?epo(p):cto(mix(mix(epc(p&-2),epc(e2q()|1)),0))
  E4_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (p = GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th & 511] & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 1 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 2 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 3 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 4 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 5 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 6 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[GraphicScreen.graM4[gy4th | gx4th + 7 & 511] & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_XHPGT

  //================================================================================
  //E4_A ($0000,$06xx,$400F)
  //  概要
  //    E4  512ドット16色4プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットが0でないとき
  //          3番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //        さもなくば(3番目のパレットが0のとき)
  //          4番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?mix(epc(e1p()),tpc(0)):(e2p()!=0?mix(epc(e2p()),tpc(0)):(e3p()!=0?mix(epc(e3p()),tpc(0)):mix(epc(e4p()),tpc(0)))))
  //  中間コード2
  //    e1p()!=0?mix(epc(e1p()),tpc(0)):e2p()!=0?mix(epc(e2p()),tpc(0)):e3p()!=0?mix(epc(e3p()),tpc(0)):mix(epc(e4p()),tpc(0))
  //  中間コード3
  //    (v0=e1p())!=0?mix(epc(v0),tpc(0)):(v4=e2p())!=0?mix(epc(v4),tpc(0)):(v8=e3p())!=0?mix(epc(v8),tpc(0)):mix(epc(e4p()),tpc(0))
  //  中間コード4
  //    (p=e1p())!=0?mix(epc(p),tpc(0)):(p=e2p())!=0?mix(epc(p),tpc(0)):(p=e3p())!=0?mix(epc(p),tpc(0)):mix(epc(e4p()),tpc(0))
  //  中間コード5
  //    (p=e1p())!=0?mix(epc(p),tpc(0)):(p=e2p())!=0?mix(epc(p),tpc(0)):(p=e3p())!=0?mix(epc(p),tpc(0)):mix(epc(e4p()),tpc(0))
  //  中間コード6
  //    cto((p=e1p())!=0?mix(epc(p),tpc(0)):(p=e2p())!=0?mix(epc(p),tpc(0)):(p=e3p())!=0?mix(epc(p),tpc(0)):mix(epc(e4p()),tpc(0)))
  E4_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //4番目のパレットのGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            (p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            (p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th & 511]],
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 1 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 2 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 3 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 4 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 5 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 6 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                (p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                (p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gy4th | gx4th + 7 & 511]],
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E4_A

  //================================================================================
  //F1 ($0001,$06xx,$0003)
  //  概要
  //    F1  512ドット256色1プレーン
  //    拡張なし
  //  手順
  //    1番目のカラー(0は黒)
  //  中間コード1
  //    fpc(f1p())
  //  中間コード2
  //    fpc(f1p())
  //  中間コード3
  //    fpc(f1p())
  //  中間コード4
  //    fpc(f1p())
  //  中間コード5
  //    fpc(f1p())
  //  中間コード6
  //    fpo(f1p())
  F1 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        XEiJ.pnlBM[da] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                      GraphicScreen.graM4[gy1st | gx1st & 511])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 1 & 511])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 2 & 511])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 3 & 511])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 4 & 511])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 5 & 511])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 6 & 511])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st + 7 & 511])]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1

  //================================================================================
  //XF1
  //  概要
  //    F1  512ドット256色1プレーン
  //    拡張あり
  XF1 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //F1_XWC
      case 0b00010001:  //F1_XWC
      case 0b00010010:  //F1_XWC
      case 0b00010011:  //F1_XWC
        F1.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //F1_XWP
      case 0b00010101:  //F1_XWP
      case 0b00010110:  //F1_XWP
      case 0b00010111:  //F1_XWP
        F1_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //F1_XHC
        F1.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //F1_XHCT
        F1_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //F1_XHCG
        F1_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //F1_XHCGT
        F1_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //F1_XHPT
        F1_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //F1_XHPG
        F1_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //F1_XHPGT
        F1_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //F1_A
      case 0b01000001:  //F1_A
      case 0b01000010:  //F1_A
      case 0b01000011:  //F1_A
      case 0b01000100:  //F1_A
      case 0b01000101:  //F1_A
      case 0b01000110:  //F1_A
      case 0b01000111:  //F1_A
      case 0b01001000:  //F1_A
      case 0b01001001:  //F1_A
      case 0b01001010:  //F1_A
      case 0b01001011:  //F1_A
      case 0b01001100:  //F1_A
      case 0b01001101:  //F1_A
      case 0b01001110:  //F1_A
      case 0b01001111:  //F1_A
      case 0b01010000:  //F1_A
      case 0b01010001:  //F1_A
      case 0b01010010:  //F1_A
      case 0b01010011:  //F1_A
      case 0b01010100:  //F1_A
      case 0b01010101:  //F1_A
      case 0b01010110:  //F1_A
      case 0b01010111:  //F1_A
      case 0b01011000:  //F1_A
      case 0b01011001:  //F1_A
      case 0b01011010:  //F1_A
      case 0b01011011:  //F1_A
      case 0b01011100:  //F1_A
      case 0b01011101:  //F1_A
      case 0b01011110:  //F1_A
      case 0b01011111:  //F1_A
        F1_A.drawRaster (src, dst, rh);
        break;
      default:
        F1.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XF1);
      }  //switch
    }  //drawRaster
  },  //XF1

  //================================================================================
  //F1_XWP ($0001,$06xx,$1403)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):fpc(tev(f1p())))
  //  中間コード2
  //    f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):fpc(tev(f1p()))
  //  中間コード3
  //    (v0=f1p())<=1?fpc(0):ls1(v0)==0?fpc(v0):fpc(tev(v0))
  //  中間コード4
  //    (p=f1p())<=1?fpc(0):ls1(p)==0?fpc(p):fpc(tev(p))
  //  中間コード5
  //    (p=f1p())<=1?fpc(0):(p&1)==0?fpc(p):fpc(p&-2)
  //  中間コード6
  //    (p=f1p())<=1?fpo(0):(p&1)==0?fpo(p):fpo(p&-2)
  F1_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XWP

  //================================================================================
  //F1_XHCT ($0001,$06xx,$1903)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(fpc(tev(f1p())))!=0?mix(fpc(f1p()),0):fpc(f1p()))
  //  中間コード2
  //    ls1(fpc(tev(f1p())))!=0?mix(fpc(f1p()),0):fpc(f1p())
  //  中間コード3
  //    ls1(fpc(tev(v3=f1p())))!=0?mix(fpc(v3),0):fpc(v3)
  //  中間コード4
  //    ls1(fpc(tev(p=f1p())))!=0?mix(fpc(p),0):fpc(p)
  //  中間コード5
  //    (fpc((p=f1p())&-2)&1)!=0?mix(fpc(p),0):fpc(p)
  //  中間コード6
  //    (fpc((p=f1p())&-2)&1)!=0?cto(mix(fpc(p),0)):fpo(p)
  F1_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                            GraphicScreen.graM4[gy1st | gx1st & 511])) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 1] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 2] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 3] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 4] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 5] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 6] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 7] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XHCT

  //================================================================================
  //F1_XHCG ($0001,$06xx,$1A03)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のパレットが奇数のとき
  //        2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //      さもなくば(1番目のパレットが偶数のとき)
  //        1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(fpc(tev(f1p())))!=0?mix(fpc(tev(f1p())),fpc(tod(f2q()))):(ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p())))
  //  中間コード2
  //    ls1(fpc(tev(f1p())))!=0?mix(fpc(tev(f1p())),fpc(tod(f2q()))):ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p())
  //  中間コード3
  //    ls1(v1=fpc(tev(v3=f1p())))!=0?mix(v1,fpc(tod(f2q()))):ls1(v3)!=0?fpc(tod(f2q())):fpc(v3)
  //  中間コード4
  //    ls1(p=fpc(tev(q=f1p())))!=0?mix(p,fpc(tod(f2q()))):ls1(q)!=0?fpc(tod(f2q())):fpc(q)
  //  中間コード5
  //    ((p=fpc((q=f1p())&-2))&1)!=0?mix(p,fpc(f2q()|1)):(q&1)!=0?fpc(f2q()|1):fpc(q)
  //  中間コード6
  //    ((p=fpc((q=f1p())&-2))&1)!=0?cto(mix(p,fpc(f2q()|1))):(q&1)!=0?fpo(f2q()|1):fpo(q)
  F1_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gz3rd = VideoController.vcnHidden3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gz4th = VideoController.vcnHidden4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                                 GraphicScreen.graM4[gy1st | gx1st & 511])) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1])] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1])] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XHCG

  //================================================================================
  //F1_XHCGT ($0001,$06xx,$1B03)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のパレットが奇数のとき
  //        2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //      さもなくば(1番目のパレットが偶数のとき)
  //        1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(fpc(tev(f1p())))!=0?mix(mix(fpc(tev(f1p())),fpc(tod(f2q()))),0):(ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p())))
  //  中間コード2
  //    ls1(fpc(tev(f1p())))!=0?mix(mix(fpc(tev(f1p())),fpc(tod(f2q()))),0):ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p())
  //  中間コード3
  //    ls1(v1=fpc(tev(v3=f1p())))!=0?mix(mix(v1,fpc(tod(f2q()))),0):ls1(v3)!=0?fpc(tod(f2q())):fpc(v3)
  //  中間コード4
  //    ls1(p=fpc(tev(q=f1p())))!=0?mix(mix(p,fpc(tod(f2q()))),0):ls1(q)!=0?fpc(tod(f2q())):fpc(q)
  //  中間コード5
  //    ((p=fpc((q=f1p())&-2))&1)!=0?mix(mix(p,fpc(f2q()|1)),0):(q&1)!=0?fpc(f2q()|1):fpc(q)
  //  中間コード6
  //    ((p=fpc((q=f1p())&-2))&1)!=0?cto(mix(mix(p,fpc(f2q()|1)),0)):(q&1)!=0?fpo(f2q()|1):fpo(q)
  F1_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gz3rd = VideoController.vcnHidden3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gz4th = VideoController.vcnHidden4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                                 GraphicScreen.graM4[gy1st | gx1st & 511])) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                            GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1]),
                              0)] :
                          (q & 1) != 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = (((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1]),
                                  0)] :
                              (q & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XHCGT

  //================================================================================
  //F1_XHPT ($0001,$06xx,$1D03)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),0))
  //  中間コード2
  //    f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),0)
  //  中間コード3
  //    (v0=f1p())<=1?fpc(0):ls1(v0)==0?fpc(v0):mix(fpc(tev(v0)),0)
  //  中間コード4
  //    (p=f1p())<=1?fpc(0):ls1(p)==0?fpc(p):mix(fpc(tev(p)),0)
  //  中間コード5
  //    (p=f1p())<=1?fpc(0):(p&1)==0?fpc(p):mix(fpc(p&-2),0)
  //  中間コード6
  //    (p=f1p())<=1?fpo(0):(p&1)==0?fpo(p):cto(mix(fpc(p&-2),0))
  F1_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XHPT

  //================================================================================
  //F1_XHPG ($0001,$06xx,$1E03)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),fpc(tod(f2q()))))
  //  中間コード2
  //    f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),fpc(tod(f2q())))
  //  中間コード3
  //    (v0=f1p())<=1?fpc(0):ls1(v0)==0?fpc(v0):mix(fpc(tev(v0)),fpc(tod(f2q())))
  //  中間コード4
  //    (p=f1p())<=1?fpc(0):ls1(p)==0?fpc(p):mix(fpc(tev(p)),fpc(tod(f2q())))
  //  中間コード5
  //    (p=f1p())<=1?fpc(0):(p&1)==0?fpc(p):mix(fpc(p&-2),fpc(f2q()|1))
  //  中間コード6
  //    (p=f1p())<=1?fpo(0):(p&1)==0?fpo(p):cto(mix(fpc(p&-2),fpc(f2q()|1)))
  F1_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gz3rd = VideoController.vcnHidden3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gz4th = VideoController.vcnHidden4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1])]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1])]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1])]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1])]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1])]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1])]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1])]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XHPG

  //================================================================================
  //F1_XHPGT ($0001,$06xx,$1F03)
  //  概要
  //    F1  512ドット256色1プレーン
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(mix(fpc(tev(f1p())),fpc(tod(f2q()))),0))
  //  中間コード2
  //    f1p()<=1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(mix(fpc(tev(f1p())),fpc(tod(f2q()))),0)
  //  中間コード3
  //    (v0=f1p())<=1?fpc(0):ls1(v0)==0?fpc(v0):mix(mix(fpc(tev(v0)),fpc(tod(f2q()))),0)
  //  中間コード4
  //    (p=f1p())<=1?fpc(0):ls1(p)==0?fpc(p):mix(mix(fpc(tev(p)),fpc(tod(f2q()))),0)
  //  中間コード5
  //    (p=f1p())<=1?fpc(0):(p&1)==0?fpc(p):mix(mix(fpc(p&-2),fpc(f2q()|1)),0)
  //  中間コード6
  //    (p=f1p())<=1?fpo(0):(p&1)==0?fpo(p):cto(mix(mix(fpc(p&-2),fpc(f2q()|1)),0))
  F1_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gz3rd = VideoController.vcnHidden3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gz4th = VideoController.vcnHidden4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) <= 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                            GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_XHPGT

  //================================================================================
  //F1_A ($0001,$06xx,$4003)
  //  概要
  //    F1  512ドット256色1プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    mix(fpc(f1p()),tpc(0))
  //  中間コード2
  //    mix(fpc(f1p()),tpc(0))
  //  中間コード3
  //    mix(fpc(f1p()),tpc(0))
  //  中間コード4
  //    mix(fpc(f1p()),tpc(0))
  //  中間コード5
  //    mix(fpc(f1p()),tpc(0))
  //  中間コード6
  //    cto(mix(fpc(f1p()),tpc(0)))
  F1_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                          GraphicScreen.graM4[gy1st | gx1st & 511])],
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 1 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 2 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 3 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 4 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 5 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 6 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st + 7 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F1_A

  //================================================================================
  //F2 ($0001,$06xx,$000F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    拡張なし
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のカラー(0は黒)
  //  中間コード1
  //    (f1p()!=0?fpc(f1p()):fpc(f2p()))
  //  中間コード2
  //    f1p()!=0?fpc(f1p()):fpc(f2p())
  //  中間コード3
  //    (v0=f1p())!=0?fpc(v0):fpc(f2p())
  //  中間コード4
  //    (p=f1p())!=0?fpc(p):fpc(f2p())
  //  中間コード5
  //    (p=f1p())!=0?fpc(p):fpc(f2p())
  //  中間コード6
  //    (p=f1p())!=0?fpo(p):fpo(f2p())
  F2 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gy3rd | gx3rd & 511])]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511])]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511])]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511])]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511])]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511])]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511])]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2

  //================================================================================
  //XF2
  //  概要
  //    F2  512ドット256色2プレーン
  //    拡張あり
  XF2 {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //F2_XWC
      case 0b00010001:  //F2_XWC
      case 0b00010010:  //F2_XWC
      case 0b00010011:  //F2_XWC
        F2.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //F2_XWP
      case 0b00010101:  //F2_XWP
      case 0b00010110:  //F2_XWP
      case 0b00010111:  //F2_XWP
        F2_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //F2_XHC
        F2.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //F2_XHCT
        F2_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //F2_XHCG
        F2_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //F2_XHCGT
        F2_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //F2_XHPT
        F2_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //F2_XHPG
        F2_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //F2_XHPGT
        F2_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //F2_A
      case 0b01000001:  //F2_A
      case 0b01000010:  //F2_A
      case 0b01000011:  //F2_A
      case 0b01000100:  //F2_A
      case 0b01000101:  //F2_A
      case 0b01000110:  //F2_A
      case 0b01000111:  //F2_A
      case 0b01001000:  //F2_A
      case 0b01001001:  //F2_A
      case 0b01001010:  //F2_A
      case 0b01001011:  //F2_A
      case 0b01001100:  //F2_A
      case 0b01001101:  //F2_A
      case 0b01001110:  //F2_A
      case 0b01001111:  //F2_A
      case 0b01010000:  //F2_A
      case 0b01010001:  //F2_A
      case 0b01010010:  //F2_A
      case 0b01010011:  //F2_A
      case 0b01010100:  //F2_A
      case 0b01010101:  //F2_A
      case 0b01010110:  //F2_A
      case 0b01010111:  //F2_A
      case 0b01011000:  //F2_A
      case 0b01011001:  //F2_A
      case 0b01011010:  //F2_A
      case 0b01011011:  //F2_A
      case 0b01011100:  //F2_A
      case 0b01011101:  //F2_A
      case 0b01011110:  //F2_A
      case 0b01011111:  //F2_A
        F2_A.drawRaster (src, dst, rh);
        break;
      default:
        F2.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XF2);
      }  //switch
    }  //drawRaster
  },  //XF2

  //================================================================================
  //F2_XWP ($0001,$06xx,$140F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):fpc(tev(f1p())))
  //  中間コード2
  //    f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):fpc(tev(f1p()))
  //  中間コード3
  //    (v0=f1p())==0?fpc(tev(f2p())):v0==1?fpc(0):ls1(v0)==0?fpc(v0):fpc(tev(v0))
  //  中間コード4
  //    (p=f1p())==0?fpc(tev(f2p())):p==1?fpc(0):ls1(p)==0?fpc(p):fpc(tev(p))
  //  中間コード5
  //    (p=f1p())==0?fpc(f2p()&-2):p==1?fpc(0):(p&1)==0?fpc(p):fpc(p&-2)
  //  中間コード6
  //    (p=f1p())==0?fpo(f2p()&-2):p==1?fpo(0):(p&1)==0?fpo(p):fpo(p&-2)
  F2_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) == 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XWP

  //================================================================================
  //F2_XHCT ($0001,$06xx,$190F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のカラーとカラー0を混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラー(0は黒)
  //  中間コード1
  //    (f1p()!=0?(ls1(fpc(tev(f1p())))!=0?mix(fpc(f1p()),0):fpc(f1p())):(ls1(fpc(tev(f2p())))!=0?mix(fpc(f2p()),0):fpc(f2p())))
  //  中間コード2
  //    f1p()!=0?ls1(fpc(tev(f1p())))!=0?mix(fpc(f1p()),0):fpc(f1p()):ls1(fpc(tev(f2p())))!=0?mix(fpc(f2p()),0):fpc(f2p())
  //  中間コード3
  //    (v0=f1p())!=0?ls1(fpc(tev(v0)))!=0?mix(fpc(v0),0):fpc(v0):ls1(fpc(tev(v10=f2p())))!=0?mix(fpc(v10),0):fpc(v10)
  //  中間コード4
  //    (p=f1p())!=0?ls1(fpc(tev(p)))!=0?mix(fpc(p),0):fpc(p):ls1(fpc(tev(p=f2p())))!=0?mix(fpc(p),0):fpc(p)
  //  中間コード5
  //    (p=f1p())!=0?(fpc(p&-2)&1)!=0?mix(fpc(p),0):fpc(p):(fpc((p=f2p())&-2)&1)!=0?mix(fpc(p),0):fpc(p)
  //  中間コード6
  //    (p=f1p())!=0?(fpc(p&-2)&1)!=0?cto(mix(fpc(p),0)):fpo(p):(fpc((p=f2p())&-2)&1)!=0?cto(mix(fpc(p),0)):fpo(p)
  F2_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p] :
                          (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                            GraphicScreen.graM4[gy3rd | gx3rd & 511])) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              0)] :
                          VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p] :
                              (VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XHCT

  //================================================================================
  //F2_XHCG ($0001,$06xx,$1A0F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラー(0は黒)
  //  中間コード1
  //    (f1p()!=0?(ls1(fpc(tev(f1p())))!=0?mix(fpc(tev(f1p())),fpc(tod(f2q()))):(ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p()))):(ls1(fpc(tev(f2p())))!=0?mix(fpc(tev(f2p())),fpc(tod(f2q()))):fpc(f2p())))
  //  中間コード2
  //    f1p()!=0?ls1(fpc(tev(f1p())))!=0?mix(fpc(tev(f1p())),fpc(tod(f2q()))):ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p()):ls1(fpc(tev(f2p())))!=0?mix(fpc(tev(f2p())),fpc(tod(f2q()))):fpc(f2p())
  //  中間コード3
  //    (v0=f1p())!=0?ls1(v2=fpc(tev(v0)))!=0?mix(v2,fpc(tod(f2q()))):ls1(v0)!=0?fpc(tod(f2q())):fpc(v0):ls1(v14=fpc(tev(v16=f2p())))!=0?mix(v14,fpc(tod(f2q()))):fpc(v16)
  //  中間コード4
  //    (p=f1p())!=0?ls1(q=fpc(tev(p)))!=0?mix(q,fpc(tod(f2q()))):ls1(p)!=0?fpc(tod(f2q())):fpc(p):ls1(p=fpc(tev(q=f2p())))!=0?mix(p,fpc(tod(f2q()))):fpc(q)
  //  中間コード5
  //    (p=f1p())!=0?((q=fpc(p&-2))&1)!=0?mix(q,fpc(f2q()|1)):(p&1)!=0?fpc(f2q()|1):fpc(p):((p=fpc((q=f2p())&-2))&1)!=0?mix(p,fpc(f2q()|1)):fpc(q)
  //  中間コード6
  //    (p=f1p())!=0?((q=fpc(p&-2))&1)!=0?cto(mix(q,fpc(f2q()|1))):(p&1)!=0?fpo(f2q()|1):fpo(p):((p=fpc((q=f2p())&-2))&1)!=0?cto(mix(p,fpc(f2q()|1))):fpo(q)
  F2_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz3rd = VideoController.vcnHidden3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz4th = VideoController.vcnHidden4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1])] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                                 GraphicScreen.graM4[gy3rd | gx3rd & 511])) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1])] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1])] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1])] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XHCG

  //================================================================================
  //F2_XHCGT ($0001,$06xx,$1B0F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラー(0は黒)
  //  中間コード1
  //    (f1p()!=0?(ls1(fpc(tev(f1p())))!=0?mix(mix(fpc(tev(f1p())),fpc(tod(f2q()))),0):(ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p()))):(ls1(fpc(tev(f2p())))!=0?mix(mix(fpc(tev(f2p())),fpc(tod(f2q()))),0):fpc(f2p())))
  //  中間コード2
  //    f1p()!=0?ls1(fpc(tev(f1p())))!=0?mix(mix(fpc(tev(f1p())),fpc(tod(f2q()))),0):ls1(f1p())!=0?fpc(tod(f2q())):fpc(f1p()):ls1(fpc(tev(f2p())))!=0?mix(mix(fpc(tev(f2p())),fpc(tod(f2q()))),0):fpc(f2p())
  //  中間コード3
  //    (v0=f1p())!=0?ls1(v2=fpc(tev(v0)))!=0?mix(mix(v2,fpc(tod(f2q()))),0):ls1(v0)!=0?fpc(tod(f2q())):fpc(v0):ls1(v15=fpc(tev(v17=f2p())))!=0?mix(mix(v15,fpc(tod(f2q()))),0):fpc(v17)
  //  中間コード4
  //    (p=f1p())!=0?ls1(q=fpc(tev(p)))!=0?mix(mix(q,fpc(tod(f2q()))),0):ls1(p)!=0?fpc(tod(f2q())):fpc(p):ls1(p=fpc(tev(q=f2p())))!=0?mix(mix(p,fpc(tod(f2q()))),0):fpc(q)
  //  中間コード5
  //    (p=f1p())!=0?((q=fpc(p&-2))&1)!=0?mix(mix(q,fpc(f2q()|1)),0):(p&1)!=0?fpc(f2q()|1):fpc(p):((p=fpc((q=f2p())&-2))&1)!=0?mix(mix(p,fpc(f2q()|1)),0):fpc(q)
  //  中間コード6
  //    (p=f1p())!=0?((q=fpc(p&-2))&1)!=0?cto(mix(mix(q,fpc(f2q()|1)),0)):(p&1)!=0?fpo(f2q()|1):fpo(p):((p=fpc((q=f2p())&-2))&1)!=0?cto(mix(mix(p,fpc(f2q()|1)),0)):fpo(q)
  F2_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz3rd = VideoController.vcnHidden3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz4th = VideoController.vcnHidden4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                            GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1]),
                              0)] :
                          (p & 1) != 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1] :
                          VideoController.vcnPal32G8[p] :
                          ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                                 GraphicScreen.graM4[gy3rd | gx3rd & 511])) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th & 511] << 4 |
                                                            GraphicScreen.graM4[gz3rd | gx3rd & 511]) | 1]),
                              0)] :
                          VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 1 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 2 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 3 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 4 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 5 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 6 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1]),
                                  0)] :
                              (p & 1) != 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1] :
                              VideoController.vcnPal32G8[p] :
                              ((p = VideoController.vcnPal16G8[(q = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511])) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gz4th | gx4th + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gz3rd | gx3rd + 7 & 511]) | 1]),
                                  0)] :
                              VideoController.vcnPal32G8[q]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XHCGT

  //================================================================================
  //F2_XHPT ($0001,$06xx,$1D0F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),0))
  //  中間コード2
  //    f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),0)
  //  中間コード3
  //    (v0=f1p())==0?fpc(tev(f2p())):v0==1?fpc(0):ls1(v0)==0?fpc(v0):mix(fpc(tev(v0)),0)
  //  中間コード4
  //    (p=f1p())==0?fpc(tev(f2p())):p==1?fpc(0):ls1(p)==0?fpc(p):mix(fpc(tev(p)),0)
  //  中間コード5
  //    (p=f1p())==0?fpc(f2p()&-2):p==1?fpc(0):(p&1)==0?fpc(p):mix(fpc(p&-2),0)
  //  中間コード6
  //    (p=f1p())==0?fpo(f2p()&-2):p==1?fpo(0):(p&1)==0?fpo(p):cto(mix(fpc(p&-2),0))
  F2_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) == 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XHPT

  //================================================================================
  //F2_XHPG ($0001,$06xx,$1E0F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),fpc(tod(f2p()))))
  //  中間コード2
  //    f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(fpc(tev(f1p())),fpc(tod(f2p())))
  //  中間コード3
  //    (v0=f1p())==0?fpc(tev(f2p())):v0==1?fpc(0):ls1(v0)==0?fpc(v0):mix(fpc(tev(v0)),fpc(tod(f2p())))
  //  中間コード4
  //    (p=f1p())==0?fpc(tev(f2p())):p==1?fpc(0):ls1(p)==0?fpc(p):mix(fpc(tev(p)),fpc(tod(f2p())))
  //  中間コード5
  //    (p=f1p())==0?fpc(f2p()&-2):p==1?fpc(0):(p&1)==0?fpc(p):mix(fpc(p&-2),fpc(f2p()|1))
  //  中間コード6
  //    (p=f1p())==0?fpo(f2p()&-2):p==1?fpo(0):(p&1)==0?fpo(p):cto(mix(fpc(p&-2),fpc(f2p()|1)))
  F2_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) == 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd & 511]) | 1])]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) | 1])]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) | 1])]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) | 1])]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) | 1])]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) | 1])]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) | 1])]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) | 1])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XHPG

  //================================================================================
  //F2_XHPGT ($0001,$06xx,$1F0F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらにカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(mix(fpc(tev(f1p())),fpc(tod(f2p()))),0))
  //  中間コード2
  //    f1p()==0?fpc(tev(f2p())):f1p()==1?fpc(0):ls1(f1p())==0?fpc(f1p()):mix(mix(fpc(tev(f1p())),fpc(tod(f2p()))),0)
  //  中間コード3
  //    (v0=f1p())==0?fpc(tev(f2p())):v0==1?fpc(0):ls1(v0)==0?fpc(v0):mix(mix(fpc(tev(v0)),fpc(tod(f2p()))),0)
  //  中間コード4
  //    (p=f1p())==0?fpc(tev(f2p())):p==1?fpc(0):ls1(p)==0?fpc(p):mix(mix(fpc(tev(p)),fpc(tod(f2p()))),0)
  //  中間コード5
  //    (p=f1p())==0?fpc(f2p()&-2):p==1?fpc(0):(p&1)==0?fpc(p):mix(mix(fpc(p&-2),fpc(f2p()|1)),0)
  //  中間コード6
  //    (p=f1p())==0?fpo(f2p()&-2):p==1?fpo(0):(p&1)==0?fpo(p):cto(mix(mix(fpc(p&-2),fpc(f2p()|1)),0))
  F2_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) == 0 ?
                          VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                      GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2] :
                          p == 1 ?
                          VideoController.vcnPal32G8[0] :
                          (p & 1) == 0 ?
                          VideoController.vcnPal32G8[p] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                            GraphicScreen.graM4[gy3rd | gx3rd & 511]) | 1]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) | 1]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) == 0 ?
                              VideoController.vcnPal32G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2] :
                              p == 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                                GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) | 1]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_XHPGT

  //================================================================================
  //F2_A ($0001,$06xx,$400F)
  //  概要
  //    F2  512ドット256色2プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    (f1p()!=0?mix(fpc(f1p()),tpc(0)):mix(fpc(f2p()),tpc(0)))
  //  中間コード2
  //    f1p()!=0?mix(fpc(f1p()),tpc(0)):mix(fpc(f2p()),tpc(0))
  //  中間コード3
  //    (v0=f1p())!=0?mix(fpc(v0),tpc(0)):mix(fpc(f2p()),tpc(0))
  //  中間コード4
  //    (p=f1p())!=0?mix(fpc(p),tpc(0)):mix(fpc(f2p()),tpc(0))
  //  中間コード5
  //    (p=f1p())!=0?mix(fpc(p),tpc(0)):mix(fpc(f2p()),tpc(0))
  //  中間コード6
  //    cto((p=f1p())!=0?mix(fpc(p),tpc(0)):mix(fpc(f2p()),tpc(0)))
  F2_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //2番目のパレットのbit3-0のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //2番目のパレットのbit7-4のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = VideoController.vcnVisible4th + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            (p = (GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                  GraphicScreen.graM4[gy1st | gx1st & 511])) != 0 ?
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[0]) :
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th & 511] << 4 |
                                                          GraphicScreen.graM4[gy3rd | gx3rd & 511])],
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                (p = (GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                      GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) != 0 ?
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[0]) :
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 4 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511])],
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //F2_A

  //================================================================================
  //G ($0003,$06xx,$000F)
  //  概要
  //    G  512ドット65536色1プレーン
  //    拡張なし
  //  手順
  //    1番目のカラー(0は黒)
  //  中間コード1
  //    gpc(g1p(),g1p())
  //  中間コード2
  //    gpc(g1p(),g1p())
  //  中間コード3
  //    gpc(v1=g1p(),v1)
  //  中間コード4
  //    gpc(p=g1p(),p)
  //  中間コード5
  //    gpc(p=g1p(),p)
  //  中間コード6
  //    gpo(p=g1p(),p)
  G {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //1番目のパレットのbit11-8のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //1番目のパレットのbit15-12のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th & 511] << 12 |
                                                              GraphicScreen.graM4[gy3rd | gx3rd & 511] << 8 |
                                                              GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                              GraphicScreen.graM4[gy1st | gx1st & 511])) >> 8] |
                            VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 12 |
                                                                  GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] << 8 |
                                                                  GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                                  GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //G

  //================================================================================
  //XG
  //  概要
  //    G  512ドット65536色1プレーン
  //    拡張あり
  XG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //G_XWC
      case 0b00010001:  //G_XWC
      case 0b00010010:  //G_XWC
      case 0b00010011:  //G_XWC
        G.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //G_XWP
      case 0b00010101:  //G_XWP
      case 0b00010110:  //G_XWP
      case 0b00010111:  //G_XWP
        G_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //G_XHC
        G.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //G_XHCT
        G_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //G_XHPT
        G_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //G_A
      case 0b01000001:  //G_A
      case 0b01000010:  //G_A
      case 0b01000011:  //G_A
      case 0b01000100:  //G_A
      case 0b01000101:  //G_A
      case 0b01000110:  //G_A
      case 0b01000111:  //G_A
      case 0b01001000:  //G_A
      case 0b01001001:  //G_A
      case 0b01001010:  //G_A
      case 0b01001011:  //G_A
      case 0b01001100:  //G_A
      case 0b01001101:  //G_A
      case 0b01001110:  //G_A
      case 0b01001111:  //G_A
      case 0b01010000:  //G_A
      case 0b01010001:  //G_A
      case 0b01010010:  //G_A
      case 0b01010011:  //G_A
      case 0b01010100:  //G_A
      case 0b01010101:  //G_A
      case 0b01010110:  //G_A
      case 0b01010111:  //G_A
      case 0b01011000:  //G_A
      case 0b01011001:  //G_A
      case 0b01011010:  //G_A
      case 0b01011011:  //G_A
      case 0b01011100:  //G_A
      case 0b01011101:  //G_A
      case 0b01011110:  //G_A
      case 0b01011111:  //G_A
        G_A.drawRaster (src, dst, rh);
        break;
      default:
        G.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XG);
      }  //switch
    }  //drawRaster
  },  //XG

  //================================================================================
  //G_XWP ($0003,$06xx,$140F)
  //  概要
  //    G  512ドット65536色1プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (g1p()<=1?gpc(0,0):ls1(g1p())==0?gpc(g1p(),g1p()):gpc(tev(g1p()),tev(g1p())))
  //  中間コード2
  //    g1p()<=1?gpc(0,0):ls1(g1p())==0?gpc(g1p(),g1p()):gpc(tev(g1p()),tev(g1p()))
  //  中間コード3
  //    (v0=g1p())<=1?gpc(0,0):ls1(v0)==0?gpc(v0,v0):gpc(v5=tev(v0),v5)
  //  中間コード4
  //    (p=g1p())<=1?gpc(0,0):ls1(p)==0?gpc(p,p):gpc(q=tev(p),q)
  //  中間コード5
  //    (p=g1p())<=1?gpc(0,0):(p&1)==0?gpc(p,p):gpc(q=p&-2,q)
  //  中間コード6
  //    (p=g1p())<=1?gpo(0,0):(p&1)==0?gpo(p,p):gpo(q=p&-2,q)
  G_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //1番目のパレットのbit11-8のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //1番目のパレットのbit15-12のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy4th | gx4th & 511] << 12 |
                                GraphicScreen.graM4[gy3rd | gx3rd & 511] << 8 |
                                GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) <= 1 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[0 >> 8] |
                            VideoController.vcnPal8G16L[0 & 255]] :
                          (p & 1) == 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[p >> 8] |
                            VideoController.vcnPal8G16L[p & 255]] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                            VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //G_XWP

  //================================================================================
  //G_XHCT ($0003,$06xx,$190F)
  //  概要
  //    G  512ドット65536色1プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを奇数化したパレットのカラーが奇数のとき
  //      1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを奇数化したパレットのカラーが偶数のとき)
  //      1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(gpc(tod(g1p()),tod(g1p())))!=0?mix(gpc(g1p(),g1p()),0):gpc(g1p(),g1p()))
  //  中間コード2
  //    ls1(gpc(tod(g1p()),tod(g1p())))!=0?mix(gpc(g1p(),g1p()),0):gpc(g1p(),g1p())
  //  中間コード3
  //    ls1(gpc(v2=tod(v3=g1p()),v2))!=0?mix(gpc(v3,v3),0):gpc(v3,v3)
  //  中間コード4
  //    ls1(gpc(p=tod(q=g1p()),p))!=0?mix(gpc(q,q),0):gpc(q,q)
  //  中間コード5
  //    (gpc(p=(q=g1p())|1,p)&1)!=0?mix(gpc(q,q),0):gpc(q,q)
  //  中間コード6
  //    (gpc(p=(q=g1p())|1,p)&1)!=0?cto(mix(gpc(q,q),0)):gpo(q,q)
  G_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //1番目のパレットのbit11-8のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //1番目のパレットのbit15-12のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th & 511] << 12 |
                                                                   GraphicScreen.graM4[gy3rd | gx3rd & 511] << 8 |
                                                                   GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                                   GraphicScreen.graM4[gy1st | gx1st & 511])) | 1) >> 8] |
                            VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              (VideoController.vcnPal8G16H[q >> 8] |
                               VideoController.vcnPal8G16L[q & 255]),
                              0)] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[q >> 8] |
                            VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 1] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 2] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 3] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 4] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 5] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 6] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        XEiJ.pnlBM[da + 7] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 12 |
                                                                       GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] << 8 |
                                                                       GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                                       GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //G_XHCT

  //================================================================================
  //G_XHPT ($0003,$06xx,$1D0F)
  //  概要
  //    G  512ドット65536色1プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (g1p()<=1?gpc(0,0):ls1(g1p())==0?gpc(g1p(),g1p()):mix(gpc(tev(g1p()),tev(g1p())),0))
  //  中間コード2
  //    g1p()<=1?gpc(0,0):ls1(g1p())==0?gpc(g1p(),g1p()):mix(gpc(tev(g1p()),tev(g1p())),0)
  //  中間コード3
  //    (v0=g1p())<=1?gpc(0,0):ls1(v0)==0?gpc(v0,v0):mix(gpc(v6=tev(v0),v6),0)
  //  中間コード4
  //    (p=g1p())<=1?gpc(0,0):ls1(p)==0?gpc(p,p):mix(gpc(q=tev(p),q),0)
  //  中間コード5
  //    (p=g1p())<=1?gpc(0,0):(p&1)==0?gpc(p,p):mix(gpc(q=p&-2,q),0)
  //  中間コード6
  //    (p=g1p())<=1?gpo(0,0):(p&1)==0?gpo(p,p):cto(mix(gpc(q=p&-2,q),0))
  G_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //1番目のパレットのbit11-8のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //1番目のパレットのbit15-12のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[gy4th | gx4th & 511] << 12 |
                                GraphicScreen.graM4[gy3rd | gx3rd & 511] << 8 |
                                GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                GraphicScreen.graM4[gy1st | gx1st & 511])) <= 1 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[0 >> 8] |
                            VideoController.vcnPal8G16L[0 & 255]] :
                          (p & 1) == 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnPal8G16H[p >> 8] |
                            VideoController.vcnPal8G16L[p & 255]] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                               VideoController.vcnPal8G16L[q & 255]),
                              0)]);
        XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 12 |
                                    GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] << 8 |
                                    GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                    GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //G_XHPT

  //================================================================================
  //G_A ($0003,$06xx,$400F)
  //  概要
  //    G  512ドット65536色1プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    mix(gpc(g1p(),g1p()),tpc(0))
  //  中間コード2
  //    mix(gpc(g1p(),g1p()),tpc(0))
  //  中間コード3
  //    mix(gpc(v2=g1p(),v2),tpc(0))
  //  中間コード4
  //    mix(gpc(p=g1p(),p),tpc(0))
  //  中間コード5
  //    mix(gpc(p=g1p(),p),tpc(0))
  //  中間コード6
  //    cto(mix(gpc(p=g1p(),p),tpc(0)))
  G_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのbit3-0のGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //1番目のパレットのbit7-4のGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //1番目のパレットのbit11-8のGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 6 & 3;  //1番目のパレットのbit15-12のGVRAMページ番号
      int gx4th = CRTC.crtR12GrXCurr[pn];
      int gy4th = (pn << 18) + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        gx4th += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th & 511] << 12 |
                                                                 GraphicScreen.graM4[gy3rd | gx3rd & 511] << 8 |
                                                                 GraphicScreen.graM4[gy2nd | gx2nd & 511] << 4 |
                                                                 GraphicScreen.graM4[gy1st | gx1st & 511])) >> 8] |
                               VideoController.vcnPal8G16L[p & 255]),
                              VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 1 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 1 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 2 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 2 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 3 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 3 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 4 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 4 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 5 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 5 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 6 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 6 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[gy4th | gx4th + 7 & 511] << 12 |
                                                                     GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] << 8 |
                                                                     GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] << 4 |
                                                                     GraphicScreen.graM4[gy1st | gx1st + 7 & 511])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        gx4th += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //G_A

  //================================================================================
  //H ($0004,$06xx,$0010)
  //  概要
  //    H  1024ドット16色1プレーン
  //    拡張なし
  //  手順
  //    1番目のカラー(0は黒)
  //  中間コード1
  //    hpc(h1p())
  //  中間コード2
  //    hpc(h1p())
  //  中間コード3
  //    hpc(h1p())
  //  中間コード4
  //    hpc(h1p())
  //  中間コード5
  //    hpc(h1p())
  //  中間コード6
  //    hpo(h1p())
  H {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          XEiJ.pnlBM[da] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga]]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 1]]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 2]]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 3]]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 4]]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 5]]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 6]]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga + 7]]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            XEiJ.pnlBM[da] = (VideoController.vcnPal32G8[GraphicScreen.graM4[ga]]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //H

  //================================================================================
  //XH
  //  概要
  //    H  1024ドット16色1プレーン
  //    拡張あり
  XH {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //H_XWC
      case 0b00010001:  //H_XWC
      case 0b00010010:  //H_XWC
      case 0b00010011:  //H_XWC
        H.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //H_XWP
      case 0b00010101:  //H_XWP
      case 0b00010110:  //H_XWP
      case 0b00010111:  //H_XWP
        H_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //H_XHC
        H.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //H_XHCT
        H_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //H_XHPT
        H_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //H_A
      case 0b01000001:  //H_A
      case 0b01000010:  //H_A
      case 0b01000011:  //H_A
      case 0b01000100:  //H_A
      case 0b01000101:  //H_A
      case 0b01000110:  //H_A
      case 0b01000111:  //H_A
      case 0b01001000:  //H_A
      case 0b01001001:  //H_A
      case 0b01001010:  //H_A
      case 0b01001011:  //H_A
      case 0b01001100:  //H_A
      case 0b01001101:  //H_A
      case 0b01001110:  //H_A
      case 0b01001111:  //H_A
      case 0b01010000:  //H_A
      case 0b01010001:  //H_A
      case 0b01010010:  //H_A
      case 0b01010011:  //H_A
      case 0b01010100:  //H_A
      case 0b01010101:  //H_A
      case 0b01010110:  //H_A
      case 0b01010111:  //H_A
      case 0b01011000:  //H_A
      case 0b01011001:  //H_A
      case 0b01011010:  //H_A
      case 0b01011011:  //H_A
      case 0b01011100:  //H_A
      case 0b01011101:  //H_A
      case 0b01011110:  //H_A
      case 0b01011111:  //H_A
        H_A.drawRaster (src, dst, rh);
        break;
      default:
        H.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XH);
      }  //switch
    }  //drawRaster
  },  //XH

  //================================================================================
  //H_XWP ($0004,$06xx,$1410)
  //  概要
  //    H  1024ドット16色1プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (h1p()<=1?hpc(0):ls1(h1p())==0?hpc(h1p()):hpc(tev(h1p())))
  //  中間コード2
  //    h1p()<=1?hpc(0):ls1(h1p())==0?hpc(h1p()):hpc(tev(h1p()))
  //  中間コード3
  //    (v0=h1p())<=1?hpc(0):ls1(v0)==0?hpc(v0):hpc(tev(v0))
  //  中間コード4
  //    (p=h1p())<=1?hpc(0):ls1(p)==0?hpc(p):hpc(tev(p))
  //  中間コード5
  //    (p=h1p())<=1?hpc(0):(p&1)==0?hpc(p):hpc(p&-2)
  //  中間コード6
  //    (p=h1p())<=1?hpo(0):(p&1)==0?hpo(p):hpo(p&-2)
  H_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[ga]) <= 1 ?
                            VideoController.vcnPal32G8[0] :
                            (p & 1) == 0 ?
                            VideoController.vcnPal32G8[p] :
                            VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[ga + 1]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[ga + 2]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[ga + 3]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[ga + 4]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[ga + 5]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[ga + 6]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[ga + 7]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[ga]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //H_XWP

  //================================================================================
  //H_XHCT ($0004,$06xx,$1910)
  //  概要
  //    H  1024ドット16色1プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(hpc(tev(h1p())))!=0?mix(hpc(h1p()),0):hpc(h1p()))
  //  中間コード2
  //    ls1(hpc(tev(h1p())))!=0?mix(hpc(h1p()),0):hpc(h1p())
  //  中間コード3
  //    ls1(hpc(tev(v3=h1p())))!=0?mix(hpc(v3),0):hpc(v3)
  //  中間コード4
  //    ls1(hpc(tev(p=h1p())))!=0?mix(hpc(p),0):hpc(p)
  //  中間コード5
  //    (hpc((p=h1p())&-2)&1)!=0?mix(hpc(p),0):hpc(p)
  //  中間コード6
  //    (hpc((p=h1p())&-2)&1)!=0?cto(mix(hpc(p),0)):hpo(p)
  H_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga]) & -2] & 1) != 0 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p],
                                0)] :
                            VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 1] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 1]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 2] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 2]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 3] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 3]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 4] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 4]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 5] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 5]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 6] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 6]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 7] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga + 7]) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[ga]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //H_XHCT

  //================================================================================
  //H_XHPT ($0004,$06xx,$1D10)
  //  概要
  //    H  1024ドット16色1プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (h1p()<=1?hpc(0):ls1(h1p())==0?hpc(h1p()):mix(hpc(tev(h1p())),0))
  //  中間コード2
  //    h1p()<=1?hpc(0):ls1(h1p())==0?hpc(h1p()):mix(hpc(tev(h1p())),0)
  //  中間コード3
  //    (v0=h1p())<=1?hpc(0):ls1(v0)==0?hpc(v0):mix(hpc(tev(v0)),0)
  //  中間コード4
  //    (p=h1p())<=1?hpc(0):ls1(p)==0?hpc(p):mix(hpc(tev(p)),0)
  //  中間コード5
  //    (p=h1p())<=1?hpc(0):(p&1)==0?hpc(p):mix(hpc(p&-2),0)
  //  中間コード6
  //    (p=h1p())<=1?hpo(0):(p&1)==0?hpo(p):cto(mix(hpc(p&-2),0))
  H_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[ga]) <= 1 ?
                            VideoController.vcnPal32G8[0] :
                            (p & 1) == 0 ?
                            VideoController.vcnPal32G8[p] :
                            VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                0)]);
          XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[ga + 1]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[ga + 2]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[ga + 3]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[ga + 4]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[ga + 5]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[ga + 6]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[ga + 7]) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[ga]) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //H_XHPT

  //================================================================================
  //H_A ($0004,$06xx,$4010)
  //  概要
  //    H  1024ドット16色1プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    mix(hpc(h1p()),tpc(0))
  //  中間コード2
  //    mix(hpc(h1p()),tpc(0))
  //  中間コード3
  //    mix(hpc(h1p()),tpc(0))
  //  中間コード4
  //    mix(hpc(h1p()),tpc(0))
  //  中間コード5
  //    mix(hpc(h1p()),tpc(0))
  //  中間コード6
  //    cto(mix(hpc(h1p()),tpc(0)))
  H_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[GraphicScreen.graM4[ga]],
                                VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 1]],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 2]],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 3]],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 4]],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 5]],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 6]],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[ga + 7]],
                                    VideoController.vcnPal16TS[0])]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[ga]],
                                  VideoController.vcnPal16TS[0])]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //H_A

  //================================================================================
  //I ($0005,$06xx,$0010)
  //  概要
  //    I  1024ドット256色1プレーン
  //    拡張なし
  //  手順
  //    1番目のカラー(0は黒)
  //  中間コード1
  //    ipc(i1p())
  //  中間コード2
  //    ipc(i1p())
  //  中間コード3
  //    ipc(i1p())
  //  中間コード4
  //    ipc(i1p())
  //  中間コード5
  //    ipc(i1p())
  //  中間コード6
  //    ipo(i1p())
  I {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          XEiJ.pnlBM[da] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048576] << 4 |
                                                        GraphicScreen.graM4[ga])]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048577] << 4 |
                                                            GraphicScreen.graM4[ga + 1])]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048578] << 4 |
                                                            GraphicScreen.graM4[ga + 2])]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048579] << 4 |
                                                            GraphicScreen.graM4[ga + 3])]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048580] << 4 |
                                                            GraphicScreen.graM4[ga + 4])]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048581] << 4 |
                                                            GraphicScreen.graM4[ga + 5])]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048582] << 4 |
                                                            GraphicScreen.graM4[ga + 6])]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048583] << 4 |
                                                            GraphicScreen.graM4[ga + 7])]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            XEiJ.pnlBM[da] = (VideoController.vcnPal32G8[(GraphicScreen.graM4[ga + 1048576] << 4 |
                                                          GraphicScreen.graM4[ga])]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //I

  //================================================================================
  //XI
  //  概要
  //    I  1024ドット256色1プレーン
  //    拡張あり
  XI {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //I_XWC
      case 0b00010001:  //I_XWC
      case 0b00010010:  //I_XWC
      case 0b00010011:  //I_XWC
        I.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //I_XWP
      case 0b00010101:  //I_XWP
      case 0b00010110:  //I_XWP
      case 0b00010111:  //I_XWP
        I_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //I_XHC
        I.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //I_XHCT
        I_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //I_XHPT
        I_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //I_A
      case 0b01000001:  //I_A
      case 0b01000010:  //I_A
      case 0b01000011:  //I_A
      case 0b01000100:  //I_A
      case 0b01000101:  //I_A
      case 0b01000110:  //I_A
      case 0b01000111:  //I_A
      case 0b01001000:  //I_A
      case 0b01001001:  //I_A
      case 0b01001010:  //I_A
      case 0b01001011:  //I_A
      case 0b01001100:  //I_A
      case 0b01001101:  //I_A
      case 0b01001110:  //I_A
      case 0b01001111:  //I_A
      case 0b01010000:  //I_A
      case 0b01010001:  //I_A
      case 0b01010010:  //I_A
      case 0b01010011:  //I_A
      case 0b01010100:  //I_A
      case 0b01010101:  //I_A
      case 0b01010110:  //I_A
      case 0b01010111:  //I_A
      case 0b01011000:  //I_A
      case 0b01011001:  //I_A
      case 0b01011010:  //I_A
      case 0b01011011:  //I_A
      case 0b01011100:  //I_A
      case 0b01011101:  //I_A
      case 0b01011110:  //I_A
      case 0b01011111:  //I_A
        I_A.drawRaster (src, dst, rh);
        break;
      default:
        I.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XI);
      }  //switch
    }  //drawRaster
  },  //XI

  //================================================================================
  //I_XWP ($0005,$06xx,$1410)
  //  概要
  //    I  1024ドット256色1プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (i1p()<=1?ipc(0):ls1(i1p())==0?ipc(i1p()):ipc(tev(i1p())))
  //  中間コード2
  //    i1p()<=1?ipc(0):ls1(i1p())==0?ipc(i1p()):ipc(tev(i1p()))
  //  中間コード3
  //    (v0=i1p())<=1?ipc(0):ls1(v0)==0?ipc(v0):ipc(tev(v0))
  //  中間コード4
  //    (p=i1p())<=1?ipc(0):ls1(p)==0?ipc(p):ipc(tev(p))
  //  中間コード5
  //    (p=i1p())<=1?ipc(0):(p&1)==0?ipc(p):ipc(p&-2)
  //  中間コード6
  //    (p=i1p())<=1?ipo(0):(p&1)==0?ipo(p):ipo(p&-2)
  I_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 1048576] << 4 |
                                  GraphicScreen.graM4[ga])) <= 1 ?
                            VideoController.vcnPal32G8[0] :
                            (p & 1) == 0 ?
                            VideoController.vcnPal32G8[p] :
                            VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[ga + 1048577] << 4 |
                                      GraphicScreen.graM4[ga + 1])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[ga + 1048578] << 4 |
                                      GraphicScreen.graM4[ga + 2])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[ga + 1048579] << 4 |
                                      GraphicScreen.graM4[ga + 3])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[ga + 1048580] << 4 |
                                      GraphicScreen.graM4[ga + 4])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[ga + 1048581] << 4 |
                                      GraphicScreen.graM4[ga + 5])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[ga + 1048582] << 4 |
                                      GraphicScreen.graM4[ga + 6])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[ga + 1048583] << 4 |
                                      GraphicScreen.graM4[ga + 7])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPal32G8[p & -2]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 1048576] << 4 |
                                    GraphicScreen.graM4[ga])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPal32G8[p & -2]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //I_XWP

  //================================================================================
  //I_XHCT ($0005,$06xx,$1910)
  //  概要
  //    I  1024ドット256色1プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(ipc(tev(i1p())))!=0?mix(ipc(i1p()),0):ipc(i1p()))
  //  中間コード2
  //    ls1(ipc(tev(i1p())))!=0?mix(ipc(i1p()),0):ipc(i1p())
  //  中間コード3
  //    ls1(ipc(tev(v3=i1p())))!=0?mix(ipc(v3),0):ipc(v3)
  //  中間コード4
  //    ls1(ipc(tev(p=i1p())))!=0?mix(ipc(p),0):ipc(p)
  //  中間コード5
  //    (ipc((p=i1p())&-2)&1)!=0?mix(ipc(p),0):ipc(p)
  //  中間コード6
  //    (ipc((p=i1p())&-2)&1)!=0?cto(mix(ipc(p),0)):ipo(p)
  I_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048576] << 4 |
                                                              GraphicScreen.graM4[ga])) & -2] & 1) != 0 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p],
                                0)] :
                            VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 1] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048577] << 4 |
                                                                  GraphicScreen.graM4[ga + 1])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 2] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048578] << 4 |
                                                                  GraphicScreen.graM4[ga + 2])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 3] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048579] << 4 |
                                                                  GraphicScreen.graM4[ga + 3])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 4] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048580] << 4 |
                                                                  GraphicScreen.graM4[ga + 4])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 5] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048581] << 4 |
                                                                  GraphicScreen.graM4[ga + 5])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 6] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048582] << 4 |
                                                                  GraphicScreen.graM4[ga + 6])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          XEiJ.pnlBM[da + 7] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048583] << 4 |
                                                                  GraphicScreen.graM4[ga + 7])) & -2] & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p],
                                    0)] :
                                VideoController.vcnPal32G8[p]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = (GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                GraphicScreen.graM4[ga])) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  0)] :
                              VideoController.vcnPal32G8[p]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //I_XHCT

  //================================================================================
  //I_XHPT ($0005,$06xx,$1D10)
  //  概要
  //    I  1024ドット256色1プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (i1p()<=1?ipc(0):ls1(i1p())==0?ipc(i1p()):mix(ipc(tev(i1p())),0))
  //  中間コード2
  //    i1p()<=1?ipc(0):ls1(i1p())==0?ipc(i1p()):mix(ipc(tev(i1p())),0)
  //  中間コード3
  //    (v0=i1p())<=1?ipc(0):ls1(v0)==0?ipc(v0):mix(ipc(tev(v0)),0)
  //  中間コード4
  //    (p=i1p())<=1?ipc(0):ls1(p)==0?ipc(p):mix(ipc(tev(p)),0)
  //  中間コード5
  //    (p=i1p())<=1?ipc(0):(p&1)==0?ipc(p):mix(ipc(p&-2),0)
  //  中間コード6
  //    (p=i1p())<=1?ipo(0):(p&1)==0?ipo(p):cto(mix(ipc(p&-2),0))
  I_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 1048576] << 4 |
                                  GraphicScreen.graM4[ga])) <= 1 ?
                            VideoController.vcnPal32G8[0] :
                            (p & 1) == 0 ?
                            VideoController.vcnPal32G8[p] :
                            VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                0)]);
          XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[ga + 1048577] << 4 |
                                      GraphicScreen.graM4[ga + 1])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[ga + 1048578] << 4 |
                                      GraphicScreen.graM4[ga + 2])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[ga + 1048579] << 4 |
                                      GraphicScreen.graM4[ga + 3])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[ga + 1048580] << 4 |
                                      GraphicScreen.graM4[ga + 4])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[ga + 1048581] << 4 |
                                      GraphicScreen.graM4[ga + 5])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[ga + 1048582] << 4 |
                                      GraphicScreen.graM4[ga + 6])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[ga + 1048583] << 4 |
                                      GraphicScreen.graM4[ga + 7])) <= 1 ?
                                VideoController.vcnPal32G8[0] :
                                (p & 1) == 0 ?
                                VideoController.vcnPal32G8[p] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    0)]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 1048576] << 4 |
                                    GraphicScreen.graM4[ga])) <= 1 ?
                              VideoController.vcnPal32G8[0] :
                              (p & 1) == 0 ?
                              VideoController.vcnPal32G8[p] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  0)]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //I_XHPT

  //================================================================================
  //I_A ($0005,$06xx,$4010)
  //  概要
  //    I  1024ドット256色1プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    mix(ipc(i1p()),tpc(0))
  //  中間コード2
  //    mix(ipc(i1p()),tpc(0))
  //  中間コード3
  //    mix(ipc(i1p()),tpc(0))
  //  中間コード4
  //    mix(ipc(i1p()),tpc(0))
  //  中間コード5
  //    mix(ipc(i1p()),tpc(0))
  //  中間コード6
  //    cto(mix(ipc(i1p()),tpc(0)))
  I_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048576] << 4 |
                                                            GraphicScreen.graM4[ga])],
                                VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048577] << 4 |
                                                                GraphicScreen.graM4[ga + 1])],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048578] << 4 |
                                                                GraphicScreen.graM4[ga + 2])],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048579] << 4 |
                                                                GraphicScreen.graM4[ga + 3])],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048580] << 4 |
                                                                GraphicScreen.graM4[ga + 4])],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048581] << 4 |
                                                                GraphicScreen.graM4[ga + 5])],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048582] << 4 |
                                                                GraphicScreen.graM4[ga + 6])],
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048583] << 4 |
                                                                GraphicScreen.graM4[ga + 7])],
                                    VideoController.vcnPal16TS[0])]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[(GraphicScreen.graM4[ga + 1048576] << 4 |
                                                              GraphicScreen.graM4[ga])],
                                  VideoController.vcnPal16TS[0])]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //I_A

  //================================================================================
  //J ($0007,$06xx,$0010)
  //  概要
  //    J  1024ドット65536色1プレーン
  //    拡張なし
  //  手順
  //    1番目のカラー(0は黒)
  //  中間コード1
  //    jpc(j1p(),j1p())
  //  中間コード2
  //    jpc(j1p(),j1p())
  //  中間コード3
  //    jpc(v1=j1p(),v1)
  //  中間コード4
  //    jpc(p=j1p(),p)
  //  中間コード5
  //    jpc(p=j1p(),p)
  //  中間コード6
  //    jpo(p=j1p(),p)
  J {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                                                GraphicScreen.graM4[ga + 2097152] << 8 |
                                                                GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                GraphicScreen.graM4[ga])) >> 8] |
                              VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145729] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097153] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048577] << 4 |
                                                                    GraphicScreen.graM4[ga + 1])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145730] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097154] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048578] << 4 |
                                                                    GraphicScreen.graM4[ga + 2])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145731] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097155] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048579] << 4 |
                                                                    GraphicScreen.graM4[ga + 3])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145732] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097156] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048580] << 4 |
                                                                    GraphicScreen.graM4[ga + 4])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145733] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097157] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048581] << 4 |
                                                                    GraphicScreen.graM4[ga + 5])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145734] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097158] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048582] << 4 |
                                                                    GraphicScreen.graM4[ga + 6])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145735] << 12 |
                                                                    GraphicScreen.graM4[ga + 2097159] << 8 |
                                                                    GraphicScreen.graM4[ga + 1048583] << 4 |
                                                                    GraphicScreen.graM4[ga + 7])) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                                                  GraphicScreen.graM4[ga + 2097152] << 8 |
                                                                  GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                  GraphicScreen.graM4[ga])) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //J

  //================================================================================
  //XJ
  //  概要
  //    J  1024ドット65536色1プレーン
  //    拡張あり
  XJ {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //J_XWC
      case 0b00010001:  //J_XWC
      case 0b00010010:  //J_XWC
      case 0b00010011:  //J_XWC
        J.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //J_XWP
      case 0b00010101:  //J_XWP
      case 0b00010110:  //J_XWP
      case 0b00010111:  //J_XWP
        J_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //J_XHC
        J.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //J_XHCT
        J_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //J_XHPT
        J_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //J_A
      case 0b01000001:  //J_A
      case 0b01000010:  //J_A
      case 0b01000011:  //J_A
      case 0b01000100:  //J_A
      case 0b01000101:  //J_A
      case 0b01000110:  //J_A
      case 0b01000111:  //J_A
      case 0b01001000:  //J_A
      case 0b01001001:  //J_A
      case 0b01001010:  //J_A
      case 0b01001011:  //J_A
      case 0b01001100:  //J_A
      case 0b01001101:  //J_A
      case 0b01001110:  //J_A
      case 0b01001111:  //J_A
      case 0b01010000:  //J_A
      case 0b01010001:  //J_A
      case 0b01010010:  //J_A
      case 0b01010011:  //J_A
      case 0b01010100:  //J_A
      case 0b01010101:  //J_A
      case 0b01010110:  //J_A
      case 0b01010111:  //J_A
      case 0b01011000:  //J_A
      case 0b01011001:  //J_A
      case 0b01011010:  //J_A
      case 0b01011011:  //J_A
      case 0b01011100:  //J_A
      case 0b01011101:  //J_A
      case 0b01011110:  //J_A
      case 0b01011111:  //J_A
        J_A.drawRaster (src, dst, rh);
        break;
      default:
        J.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XJ);
      }  //switch
    }  //drawRaster
  },  //XJ

  //================================================================================
  //J_XWP ($0007,$06xx,$1410)
  //  概要
  //    J  1024ドット65536色1プレーン
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (j1p()<=1?jpc(0,0):ls1(j1p())==0?jpc(j1p(),j1p()):jpc(tev(j1p()),tev(j1p())))
  //  中間コード2
  //    j1p()<=1?jpc(0,0):ls1(j1p())==0?jpc(j1p(),j1p()):jpc(tev(j1p()),tev(j1p()))
  //  中間コード3
  //    (v0=j1p())<=1?jpc(0,0):ls1(v0)==0?jpc(v0,v0):jpc(v5=tev(v0),v5)
  //  中間コード4
  //    (p=j1p())<=1?jpc(0,0):ls1(p)==0?jpc(p,p):jpc(q=tev(p),q)
  //  中間コード5
  //    (p=j1p())<=1?jpc(0,0):(p&1)==0?jpc(p,p):jpc(q=p&-2,q)
  //  中間コード6
  //    (p=j1p())<=1?jpo(0,0):(p&1)==0?jpo(p,p):jpo(q=p&-2,q)
  J_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p, q;
          XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                  GraphicScreen.graM4[ga + 2097152] << 8 |
                                  GraphicScreen.graM4[ga + 1048576] << 4 |
                                  GraphicScreen.graM4[ga])) <= 1 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[0 >> 8] |
                              VideoController.vcnPal8G16L[0 & 255]] :
                            (p & 1) == 0 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[p >> 8] |
                              VideoController.vcnPal8G16L[p & 255]] :
                            VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                              VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[ga + 3145729] << 12 |
                                      GraphicScreen.graM4[ga + 2097153] << 8 |
                                      GraphicScreen.graM4[ga + 1048577] << 4 |
                                      GraphicScreen.graM4[ga + 1])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[ga + 3145730] << 12 |
                                      GraphicScreen.graM4[ga + 2097154] << 8 |
                                      GraphicScreen.graM4[ga + 1048578] << 4 |
                                      GraphicScreen.graM4[ga + 2])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[ga + 3145731] << 12 |
                                      GraphicScreen.graM4[ga + 2097155] << 8 |
                                      GraphicScreen.graM4[ga + 1048579] << 4 |
                                      GraphicScreen.graM4[ga + 3])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[ga + 3145732] << 12 |
                                      GraphicScreen.graM4[ga + 2097156] << 8 |
                                      GraphicScreen.graM4[ga + 1048580] << 4 |
                                      GraphicScreen.graM4[ga + 4])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[ga + 3145733] << 12 |
                                      GraphicScreen.graM4[ga + 2097157] << 8 |
                                      GraphicScreen.graM4[ga + 1048581] << 4 |
                                      GraphicScreen.graM4[ga + 5])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[ga + 3145734] << 12 |
                                      GraphicScreen.graM4[ga + 2097158] << 8 |
                                      GraphicScreen.graM4[ga + 1048582] << 4 |
                                      GraphicScreen.graM4[ga + 6])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[ga + 3145735] << 12 |
                                      GraphicScreen.graM4[ga + 2097159] << 8 |
                                      GraphicScreen.graM4[ga + 1048583] << 4 |
                                      GraphicScreen.graM4[ga + 7])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p, q;
            XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                    GraphicScreen.graM4[ga + 2097152] << 8 |
                                    GraphicScreen.graM4[ga + 1048576] << 4 |
                                    GraphicScreen.graM4[ga])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //J_XWP

  //================================================================================
  //J_XHCT ($0007,$06xx,$1910)
  //  概要
  //    J  1024ドット65536色1プレーン
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを奇数化したパレットのカラーが奇数のとき
  //      1番目のカラーとカラー0を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを奇数化したパレットのカラーが偶数のとき)
  //      1番目のカラー(0は黒)
  //  中間コード1
  //    (ls1(jpc(tod(j1p()),tod(j1p())))!=0?mix(jpc(j1p(),j1p()),0):jpc(j1p(),j1p()))
  //  中間コード2
  //    ls1(jpc(tod(j1p()),tod(j1p())))!=0?mix(jpc(j1p(),j1p()),0):jpc(j1p(),j1p())
  //  中間コード3
  //    ls1(jpc(v2=tod(v3=j1p()),v2))!=0?mix(jpc(v3,v3),0):jpc(v3,v3)
  //  中間コード4
  //    ls1(jpc(p=tod(q=j1p()),p))!=0?mix(jpc(q,q),0):jpc(q,q)
  //  中間コード5
  //    (jpc(p=(q=j1p())|1,p)&1)!=0?mix(jpc(q,q),0):jpc(q,q)
  //  中間コード6
  //    (jpc(p=(q=j1p())|1,p)&1)!=0?cto(mix(jpc(q,q),0)):jpo(q,q)
  J_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p, q;
          XEiJ.pnlBM[da] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                                                     GraphicScreen.graM4[ga + 2097152] << 8 |
                                                                     GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                     GraphicScreen.graM4[ga])) | 1) >> 8] |
                              VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                (VideoController.vcnPal8G16H[q >> 8] |
                                 VideoController.vcnPal8G16L[q & 255]),
                                0)] :
                            VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[q >> 8] |
                              VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 1] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145729] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097153] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048577] << 4 |
                                                                         GraphicScreen.graM4[ga + 1])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 2] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145730] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097154] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048578] << 4 |
                                                                         GraphicScreen.graM4[ga + 2])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 3] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145731] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097155] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048579] << 4 |
                                                                         GraphicScreen.graM4[ga + 3])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 4] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145732] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097156] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048580] << 4 |
                                                                         GraphicScreen.graM4[ga + 4])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 5] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145733] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097157] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048581] << 4 |
                                                                         GraphicScreen.graM4[ga + 5])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 6] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145734] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097158] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048582] << 4 |
                                                                         GraphicScreen.graM4[ga + 6])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          XEiJ.pnlBM[da + 7] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145735] << 12 |
                                                                         GraphicScreen.graM4[ga + 2097159] << 8 |
                                                                         GraphicScreen.graM4[ga + 1048583] << 4 |
                                                                         GraphicScreen.graM4[ga + 7])) | 1) >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[q >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[q >> 8] |
                                  VideoController.vcnPal8G16L[q & 255]]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p, q;
            XEiJ.pnlBM[da] = (((VideoController.vcnPal8G16H[(p = (q = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097152] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                       GraphicScreen.graM4[ga])) | 1) >> 8] |
                                VideoController.vcnPal8G16L[p & 255]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[q >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[q >> 8] |
                                VideoController.vcnPal8G16L[q & 255]]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //J_XHCT

  //================================================================================
  //J_XHPT ($0007,$06xx,$1D10)
  //  概要
  //    J  1024ドット65536色1プレーン
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーとカラー0を混ぜたカラー(0は黒)
  //  中間コード1
  //    (j1p()<=1?jpc(0,0):ls1(j1p())==0?jpc(j1p(),j1p()):mix(jpc(tev(j1p()),tev(j1p())),0))
  //  中間コード2
  //    j1p()<=1?jpc(0,0):ls1(j1p())==0?jpc(j1p(),j1p()):mix(jpc(tev(j1p()),tev(j1p())),0)
  //  中間コード3
  //    (v0=j1p())<=1?jpc(0,0):ls1(v0)==0?jpc(v0,v0):mix(jpc(v6=tev(v0),v6),0)
  //  中間コード4
  //    (p=j1p())<=1?jpc(0,0):ls1(p)==0?jpc(p,p):mix(jpc(q=tev(p),q),0)
  //  中間コード5
  //    (p=j1p())<=1?jpc(0,0):(p&1)==0?jpc(p,p):mix(jpc(q=p&-2,q),0)
  //  中間コード6
  //    (p=j1p())<=1?jpo(0,0):(p&1)==0?jpo(p,p):cto(mix(jpc(q=p&-2,q),0))
  J_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p, q;
          XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                  GraphicScreen.graM4[ga + 2097152] << 8 |
                                  GraphicScreen.graM4[ga + 1048576] << 4 |
                                  GraphicScreen.graM4[ga])) <= 1 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[0 >> 8] |
                              VideoController.vcnPal8G16L[0 & 255]] :
                            (p & 1) == 0 ?
                            VideoController.vcnPalTbl[
                              VideoController.vcnPal8G16H[p >> 8] |
                              VideoController.vcnPal8G16L[p & 255]] :
                            VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                 VideoController.vcnPal8G16L[q & 255]),
                                0)]);
          XEiJ.pnlBM[da + 1] = ((p = (GraphicScreen.graM4[ga + 3145729] << 12 |
                                      GraphicScreen.graM4[ga + 2097153] << 8 |
                                      GraphicScreen.graM4[ga + 1048577] << 4 |
                                      GraphicScreen.graM4[ga + 1])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          XEiJ.pnlBM[da + 2] = ((p = (GraphicScreen.graM4[ga + 3145730] << 12 |
                                      GraphicScreen.graM4[ga + 2097154] << 8 |
                                      GraphicScreen.graM4[ga + 1048578] << 4 |
                                      GraphicScreen.graM4[ga + 2])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          XEiJ.pnlBM[da + 3] = ((p = (GraphicScreen.graM4[ga + 3145731] << 12 |
                                      GraphicScreen.graM4[ga + 2097155] << 8 |
                                      GraphicScreen.graM4[ga + 1048579] << 4 |
                                      GraphicScreen.graM4[ga + 3])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          XEiJ.pnlBM[da + 4] = ((p = (GraphicScreen.graM4[ga + 3145732] << 12 |
                                      GraphicScreen.graM4[ga + 2097156] << 8 |
                                      GraphicScreen.graM4[ga + 1048580] << 4 |
                                      GraphicScreen.graM4[ga + 4])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          XEiJ.pnlBM[da + 5] = ((p = (GraphicScreen.graM4[ga + 3145733] << 12 |
                                      GraphicScreen.graM4[ga + 2097157] << 8 |
                                      GraphicScreen.graM4[ga + 1048581] << 4 |
                                      GraphicScreen.graM4[ga + 5])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          XEiJ.pnlBM[da + 6] = ((p = (GraphicScreen.graM4[ga + 3145734] << 12 |
                                      GraphicScreen.graM4[ga + 2097158] << 8 |
                                      GraphicScreen.graM4[ga + 1048582] << 4 |
                                      GraphicScreen.graM4[ga + 6])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          XEiJ.pnlBM[da + 7] = ((p = (GraphicScreen.graM4[ga + 3145735] << 12 |
                                      GraphicScreen.graM4[ga + 2097159] << 8 |
                                      GraphicScreen.graM4[ga + 1048583] << 4 |
                                      GraphicScreen.graM4[ga + 7])) <= 1 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[0 >> 8] |
                                  VideoController.vcnPal8G16L[0 & 255]] :
                                (p & 1) == 0 ?
                                VideoController.vcnPalTbl[
                                  VideoController.vcnPal8G16H[p >> 8] |
                                  VideoController.vcnPal8G16L[p & 255]] :
                                VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                     VideoController.vcnPal8G16L[q & 255]),
                                    0)]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p, q;
            XEiJ.pnlBM[da] = ((p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                    GraphicScreen.graM4[ga + 2097152] << 8 |
                                    GraphicScreen.graM4[ga + 1048576] << 4 |
                                    GraphicScreen.graM4[ga])) <= 1 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[0 >> 8] |
                                VideoController.vcnPal8G16L[0 & 255]] :
                              (p & 1) == 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnPal8G16H[p >> 8] |
                                VideoController.vcnPal8G16L[p & 255]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(q = p & -2) >> 8] |
                                   VideoController.vcnPal8G16L[q & 255]),
                                  0)]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //J_XHPT

  //================================================================================
  //J_A ($0007,$06xx,$4010)
  //  概要
  //    J  1024ドット65536色1プレーン
  //    A  グラフィックカラーとテキストパレット0のカラーを混ぜる
  //  手順
  //    1番目のカラーとテキストパレット0のカラーを混ぜたカラー(0は黒)
  //  中間コード1
  //    mix(jpc(j1p(),j1p()),tpc(0))
  //  中間コード2
  //    mix(jpc(j1p(),j1p()),tpc(0))
  //  中間コード3
  //    mix(jpc(v2=j1p(),v2),tpc(0))
  //  中間コード4
  //    mix(jpc(p=j1p(),p),tpc(0))
  //  中間コード5
  //    mix(jpc(p=j1p(),p),tpc(0))
  //  中間コード6
  //    cto(mix(jpc(p=j1p(),p),tpc(0)))
  J_A {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      int gx = CRTC.crtR12GrXCurr[0];  //1024ドットx座標。溢れは無視する
      int gy = CRTC.crtR13GrYZero[0] + src;  //1024ドットy座標。溢れは無視する
      int ga0 = ((gy & 511) << 9);  //x=0,y&=511の1024ドットアドレス
      int gt = VideoController.vcnReg2Curr >> (gy >> 7 & 4);  //y<512?G2nd|G1st:G4th|G3rd
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        gx += half;
        da += half;
      }
      int ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18) + (gx & 511);  //1024ドットアドレス
      while (da < db) {
        int dw = Math.min (db - da, (512 - (gx & 511)) & -8);  //今回の幅。8の倍数
        gx += dw;  //次回の1024ドットx座標
        int dc = da + dw;  //今回のARGB出力インデックスの終了位置
        while (da < dc) {
          int p;
          XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                              VideoController.vcnMix2 (
                                (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                                                   GraphicScreen.graM4[ga + 2097152] << 8 |
                                                                   GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                   GraphicScreen.graM4[ga])) >> 8] |
                                 VideoController.vcnPal8G16L[p & 255]),
                                VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 1] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145729] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097153] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048577] << 4 |
                                                                       GraphicScreen.graM4[ga + 1])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 2] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145730] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097154] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048578] << 4 |
                                                                       GraphicScreen.graM4[ga + 2])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 3] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145731] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097155] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048579] << 4 |
                                                                       GraphicScreen.graM4[ga + 3])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 4] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145732] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097156] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048580] << 4 |
                                                                       GraphicScreen.graM4[ga + 4])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 5] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145733] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097157] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048581] << 4 |
                                                                       GraphicScreen.graM4[ga + 5])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 6] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145734] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097158] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048582] << 4 |
                                                                       GraphicScreen.graM4[ga + 6])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          XEiJ.pnlBM[da + 7] = (VideoController.vcnPalTbl[
                                  VideoController.vcnMix2 (
                                    (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145735] << 12 |
                                                                       GraphicScreen.graM4[ga + 2097159] << 8 |
                                                                       GraphicScreen.graM4[ga + 1048583] << 4 |
                                                                       GraphicScreen.graM4[ga + 7])) >> 8] |
                                     VideoController.vcnPal8G16L[p & 255]),
                                    VideoController.vcnPal16TS[0])]);
          ga += 8;
          da += 8;
        }  //while da<dc
        if (da < db) {
          for (int k = 0; k < 8; k++) {
            if ((gx & 511) == 0) {  //gxが512の倍数のとき
              ga = ga0 + ((gt >> (gx >> 8 & 2) & 3) << 18);  //gaを再計算する
            }
            gx++;
            int p;
            XEiJ.pnlBM[da] = (VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  (VideoController.vcnPal8G16H[(p = (GraphicScreen.graM4[ga + 3145728] << 12 |
                                                                     GraphicScreen.graM4[ga + 2097152] << 8 |
                                                                     GraphicScreen.graM4[ga + 1048576] << 4 |
                                                                     GraphicScreen.graM4[ga])) >> 8] |
                                   VideoController.vcnPal8G16L[p & 255]),
                                  VideoController.vcnPal16TS[0])]);
            ga++;
            da++;
          }  //for k
        }  //if da<db
      }  //while da<db
    }  //drawRaster
  },  //J_A

  //================================================================================
  //E1S ($0000,$18xx,$0041)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    拡張なし
  //  手順
  //    1番目のカラーが0でないとき
  //      1番目のカラー
  //    さもなくば(1番目のカラーが0のとき)
  //      スプライトカラー(0は黒)
  //  中間コード1
  //    (epc(e1p())!=0?epc(e1p()):spc(spp()))
  //  中間コード2
  //    epc(e1p())!=0?epc(e1p()):spc(spp())
  //  中間コード3
  //    (v0=epc(e1p()))!=0?v0:spc(spp())
  //  中間コード4
  //    (p=epc(e1p()))!=0?p:spc(spp())
  //  中間コード5
  //    (p=epc(e1p()))!=0?p:spc(spp())
  //  中間コード6
  //    (p=epc(e1p()))!=0?cto(p):spo(spp())
  E1S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p;
        XEiJ.pnlBM[da] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st & 511]]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 1 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 2 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 3 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 4 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 5 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 6 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy1st | gx1st + 7 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S

  //================================================================================
  //XE1S
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    拡張あり
  XE1S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E1S_XWC
      case 0b00010001:  //E1S_XWC
      case 0b00010010:  //E1S_XWC
      case 0b00010011:  //E1S_XWC
        E1S_XWC.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E1S_XWP
      case 0b00010101:  //E1S_XWP
      case 0b00010110:  //E1S_XWP
      case 0b00010111:  //E1S_XWP
        E1S_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E1S_XHC
        E1S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E1S_XHCT
        E1S_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E1S_XHCG
        E1S_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E1S_XHCGT
        E1S_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E1S_XHPT
        E1S_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E1S_XHPG
        E1S_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E1S_XHPGT
        E1S_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E1S_A
      case 0b01000001:  //E1S_A
      case 0b01000010:  //E1S_A
      case 0b01000011:  //E1S_A
      case 0b01000100:  //E1S_A
      case 0b01000101:  //E1S_A
      case 0b01000110:  //E1S_A
      case 0b01000111:  //E1S_A
      case 0b01001000:  //E1S_A
      case 0b01001001:  //E1S_A
      case 0b01001010:  //E1S_A
      case 0b01001011:  //E1S_A
      case 0b01001100:  //E1S_A
      case 0b01001101:  //E1S_A
      case 0b01001110:  //E1S_A
      case 0b01001111:  //E1S_A
      case 0b01010000:  //E1S_A
      case 0b01010001:  //E1S_A
      case 0b01010010:  //E1S_A
      case 0b01010011:  //E1S_A
      case 0b01010100:  //E1S_A
      case 0b01010101:  //E1S_A
      case 0b01010110:  //E1S_A
      case 0b01010111:  //E1S_A
      case 0b01011000:  //E1S_A
      case 0b01011001:  //E1S_A
      case 0b01011010:  //E1S_A
      case 0b01011011:  //E1S_A
      case 0b01011100:  //E1S_A
      case 0b01011101:  //E1S_A
      case 0b01011110:  //E1S_A
      case 0b01011111:  //E1S_A
        E1_A.drawRaster (src, dst, rh);
        break;
      default:
        E1S.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE1S);
      }  //switch
    }  //drawRaster
  },  //XE1S

  //================================================================================
  //E1S_XWC ($0000,$18xx,$1041)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XWC  優先順位に関わらず0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?epc(e1p()):(epc(e1p())!=0?epc(e1p()):spc(spp())))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?epc(e1p()):epc(e1p())!=0?epc(e1p()):spc(spp())
  //  中間コード3
  //    ls1(epc(tev(v3=e1p())))!=0?epc(v3):(v5=epc(v3))!=0?v5:spc(spp())
  //  中間コード4
  //    ls1(epc(tev(p=e1p())))!=0?epc(p):(q=epc(p))!=0?q:spc(spp())
  //  中間コード5
  //    (epc((p=e1p())&-2)&1)!=0?epc(p):(q=epc(p))!=0?q:spc(spp())
  //  中間コード6
  //    (epc((p=e1p())&-2)&1)!=0?epo(p):(q=epc(p))!=0?cto(q):spo(spp())
  E1S_XWC {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XWC

  //================================================================================
  //E1S_XWP ($0000,$18xx,$1441)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):epc(tev(e1p())))
  //  中間コード2
  //    e1p()<=1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())<=1?(v1=epc(0))!=0?v1:spc(spp()):ls1(v0)==0?(v5=epc(v0))!=0?v5:spc(spp()):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):epc(tev(p))
  //  中間コード5
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):epc(p&-2)
  //  中間コード6
  //    (p=e1p())<=1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):epo(p&-2)
  E1S_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPal32G8[p & -2]);
        sx += 8;
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XWP

  //================================================================================
  //E1S_XHCT ($0000,$18xx,$1941)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のカラーと
  //        スプライトカラー(0は黒)
  //      を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp())))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),spc(spp())):epc(e1p())!=0?epc(e1p()):spc(spp())
  //  中間コード3
  //    ls1(epc(tev(v3=e1p())))!=0?mix(epc(v3),spc(spp())):(v8=epc(v3))!=0?v8:spc(spp())
  //  中間コード4
  //    ls1(epc(tev(p=e1p())))!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp())
  //  中間コード5
  //    (epc((p=e1p())&-2)&1)!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp())
  //  中間コード6
  //    (epc((p=e1p())&-2)&1)!=0?cto(mix(epc(p),spc(spp()))):(q=epc(p))!=0?cto(q):spo(spp())
  E1S_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XHCT

  //================================================================================
  //E1S_XHCG ($0000,$18xx,$1A41)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のパレットが奇数のとき
  //        2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0でないとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー
  //        さもなくば(2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0のとき)
  //          スプライトカラー(0は黒)
  //      さもなくば(1番目のパレットが偶数のとき)
  //        1番目のカラーが0でないとき
  //          1番目のカラー
  //        さもなくば(1番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):(ls1(e1p())!=0?(epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp()))))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):ls1(e1p())!=0?epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp()):epc(e1p())!=0?epc(e1p()):spc(spp())
  //  中間コード3
  //    ls1(v1=epc(tev(v3=e1p())))!=0?mix(v1,epc(tod(e2q()))):ls1(v3)!=0?(v9=epc(tod(e2q())))!=0?v9:spc(spp()):(v14=epc(v3))!=0?v14:spc(spp())
  //  中間コード4
  //    ls1(p=epc(tev(q=e1p())))!=0?mix(p,epc(tod(e2q()))):ls1(q)!=0?(p=epc(tod(e2q())))!=0?p:spc(spp()):(p=epc(q))!=0?p:spc(spp())
  //  中間コード5
  //    ((p=epc((q=e1p())&-2))&1)!=0?mix(p,epc(e2q()|1)):(q&1)!=0?(p=epc(e2q()|1))!=0?p:spc(spp()):(p=epc(q))!=0?p:spc(spp())
  //  中間コード6
  //    ((p=epc((q=e1p())&-2))&1)!=0?cto(mix(p,epc(e2q()|1))):(q&1)!=0?(p=epc(e2q()|1))!=0?cto(p):spo(spp()):(p=epc(q))!=0?cto(p):spo(spp())
  E1S_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (q & 1) != 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = VideoController.vcnPal16G8[q]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XHCG

  //================================================================================
  //E1S_XHCGT ($0000,$18xx,$1B41)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //      1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
  //        スプライトカラー(0は黒)
  //      を混ぜたカラー(0は黒)
  //    さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //      1番目のパレットが奇数のとき
  //        2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0でないとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラー
  //        さもなくば(2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0のとき)
  //          スプライトカラー(0は黒)
  //      さもなくば(1番目のパレットが偶数のとき)
  //        1番目のカラーが0でないとき
  //          1番目のカラー
  //        さもなくば(1番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),spc(spp())):(ls1(e1p())!=0?(epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp()))))
  //  中間コード2
  //    ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),spc(spp())):ls1(e1p())!=0?epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp()):epc(e1p())!=0?epc(e1p()):spc(spp())
  //  中間コード3
  //    ls1(v1=epc(tev(v3=e1p())))!=0?mix(mix(v1,epc(tod(e2q()))),spc(spp())):ls1(v3)!=0?(v12=epc(tod(e2q())))!=0?v12:spc(spp()):(v17=epc(v3))!=0?v17:spc(spp())
  //  中間コード4
  //    ls1(p=epc(tev(q=e1p())))!=0?mix(mix(p,epc(tod(e2q()))),spc(spp())):ls1(q)!=0?(p=epc(tod(e2q())))!=0?p:spc(spp()):(p=epc(q))!=0?p:spc(spp())
  //  中間コード5
  //    ((p=epc((q=e1p())&-2))&1)!=0?mix(mix(p,epc(e2q()|1)),spc(spp())):(q&1)!=0?(p=epc(e2q()|1))!=0?p:spc(spp()):(p=epc(q))!=0?p:spc(spp())
  //  中間コード6
  //    ((p=epc((q=e1p())&-2))&1)!=0?cto(mix(mix(p,epc(e2q()|1)),spc(spp()))):(q&1)!=0?(p=epc(e2q()|1))!=0?cto(p):spo(spp()):(p=epc(q))!=0?cto(p):spo(spp())
  E1S_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (q & 1) != 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = VideoController.vcnPal16G8[q]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = (((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])] :
                              (q & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XHCGT

  //================================================================================
  //E1S_XHPT ($0000,$18xx,$1D41)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと
  //        スプライトカラー(0は黒)
  //      を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):mix(epc(tev(e1p())),spc(spp())))
  //  中間コード2
  //    e1p()<=1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):mix(epc(tev(e1p())),spc(spp()))
  //  中間コード3
  //    (v0=e1p())<=1?(v1=epc(0))!=0?v1:spc(spp()):ls1(v0)==0?(v5=epc(v0))!=0?v5:spc(spp()):mix(epc(tev(v0)),spc(spp()))
  //  中間コード4
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):mix(epc(tev(p)),spc(spp()))
  //  中間コード5
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):mix(epc(p&-2),spc(spp()))
  //  中間コード6
  //    (p=e1p())<=1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):cto(mix(epc(p&-2),spc(spp())))
  E1S_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])]);
        sx += 8;
        gx1st += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XHPT

  //================================================================================
  //E1S_XHPG ($0000,$18xx,$1E41)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーが0でないとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーが0のとき)
  //        スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):(mix(epc(tev(e1p())),epc(tod(e2q())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):spc(spp())))
  //  中間コード2
  //    e1p()<=1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):mix(epc(tev(e1p())),epc(tod(e2q())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):spc(spp())
  //  中間コード3
  //    (v0=e1p())<=1?(v1=epc(0))!=0?v1:spc(spp()):ls1(v0)==0?(v5=epc(v0))!=0?v5:spc(spp()):(v8=mix(epc(tev(v0)),epc(tod(e2q()))))!=0?v8:spc(spp())
  //  中間コード4
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):(q=mix(epc(tev(p)),epc(tod(e2q()))))!=0?q:spc(spp())
  //  中間コード5
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):(q=mix(epc(p&-2),epc(e2q()|1)))!=0?q:spc(spp())
  //  中間コード6
  //    (p=e1p())<=1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):(q=mix(epc(p&-2),epc(e2q()|1)))!=0?cto(q):spo(spp())
  E1S_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (q = VideoController.vcnMix2 (
                             VideoController.vcnPal16G8[p & -2],
                             VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XHPG

  //================================================================================
  //E1S_XHPGT ($0000,$18xx,$1F41)
  //  概要
  //    E1S  512ドット16色1プレーン＞スプライト
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが1以下のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
  //        スプライトカラー(0は黒)
  //      を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()<=1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),spc(spp())))
  //  中間コード2
  //    e1p()<=1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):mix(mix(epc(tev(e1p())),epc(tod(e2q()))),spc(spp()))
  //  中間コード3
  //    (v0=e1p())<=1?(v1=epc(0))!=0?v1:spc(spp()):ls1(v0)==0?(v5=epc(v0))!=0?v5:spc(spp()):mix(mix(epc(tev(v0)),epc(tod(e2q()))),spc(spp()))
  //  中間コード4
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):mix(mix(epc(tev(p)),epc(tod(e2q()))),spc(spp()))
  //  中間コード5
  //    (p=e1p())<=1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):mix(mix(epc(p&-2),epc(e2q()|1)),spc(spp()))
  //  中間コード6
  //    (p=e1p())<=1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):cto(mix(mix(epc(p&-2),epc(e2q()|1)),spc(spp())))
  E1S_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) <= 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) <= 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E1S_XHPGT

  //================================================================================
  //E2S ($0000,$18xx,$0043)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    拡張なし
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のカラーが0でないとき
  //        2番目のカラー
  //      さもなくば(2番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(epc(e1p())!=0?epc(e1p()):spc(spp())):(epc(e2p())!=0?epc(e2p()):spc(spp())))
  //  中間コード2
  //    e1p()!=0?epc(e1p())!=0?epc(e1p()):spc(spp()):epc(e2p())!=0?epc(e2p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?(v1=epc(v0))!=0?v1:spc(spp()):(v4=epc(e2p()))!=0?v4:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?(q=epc(p))!=0?q:spc(spp()):(p=epc(e2p()))!=0?p:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?(q=epc(p))!=0?q:spc(spp()):(p=epc(e2p()))!=0?p:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?(q=epc(p))!=0?cto(q):spo(spp()):(p=epc(e2p()))!=0?cto(p):spo(spp())
  E2S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511]]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S

  //================================================================================
  //XE2S
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    拡張あり
  XE2S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E2S_XWC
      case 0b00010001:  //E2S_XWC
      case 0b00010010:  //E2S_XWC
      case 0b00010011:  //E2S_XWC
        E2S_XWC.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E2S_XWP
      case 0b00010101:  //E2S_XWP
      case 0b00010110:  //E2S_XWP
      case 0b00010111:  //E2S_XWP
        E2S_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E2S_XHC
        E2S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E2S_XHCT
        E2S_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E2S_XHCG
        E2S_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E2S_XHCGT
        E2S_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E2S_XHPT
        E2S_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E2S_XHPG
        E2S_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E2S_XHPGT
        E2S_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E2S_A
      case 0b01000001:  //E2S_A
      case 0b01000010:  //E2S_A
      case 0b01000011:  //E2S_A
      case 0b01000100:  //E2S_A
      case 0b01000101:  //E2S_A
      case 0b01000110:  //E2S_A
      case 0b01000111:  //E2S_A
      case 0b01001000:  //E2S_A
      case 0b01001001:  //E2S_A
      case 0b01001010:  //E2S_A
      case 0b01001011:  //E2S_A
      case 0b01001100:  //E2S_A
      case 0b01001101:  //E2S_A
      case 0b01001110:  //E2S_A
      case 0b01001111:  //E2S_A
      case 0b01010000:  //E2S_A
      case 0b01010001:  //E2S_A
      case 0b01010010:  //E2S_A
      case 0b01010011:  //E2S_A
      case 0b01010100:  //E2S_A
      case 0b01010101:  //E2S_A
      case 0b01010110:  //E2S_A
      case 0b01010111:  //E2S_A
      case 0b01011000:  //E2S_A
      case 0b01011001:  //E2S_A
      case 0b01011010:  //E2S_A
      case 0b01011011:  //E2S_A
      case 0b01011100:  //E2S_A
      case 0b01011101:  //E2S_A
      case 0b01011110:  //E2S_A
      case 0b01011111:  //E2S_A
        E2_A.drawRaster (src, dst, rh);
        break;
      default:
        E2S.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE2S);
      }  //switch
    }  //drawRaster
  },  //XE2S

  //================================================================================
  //E2S_XWC ($0000,$18xx,$1043)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XWC  優先順位に関わらず0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラーが0でないとき
  //          1番目のカラー
  //        さもなくば(1番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラーが0でないとき
  //          2番目のカラー
  //        さもなくば(2番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?epc(e1p()):(epc(e1p())!=0?epc(e1p()):spc(spp()))):(ls1(epc(tev(e2p())))!=0?epc(e2p()):(epc(e2p())!=0?epc(e2p()):spc(spp()))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?epc(e1p()):epc(e1p())!=0?epc(e1p()):spc(spp()):ls1(epc(tev(e2p())))!=0?epc(e2p()):epc(e2p())!=0?epc(e2p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?epc(v0):(v5=epc(v0))!=0?v5:spc(spp()):ls1(epc(tev(v11=e2p())))!=0?epc(v11):(v13=epc(v11))!=0?v13:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?epc(p):(q=epc(p))!=0?q:spc(spp()):ls1(epc(tev(p=e2p())))!=0?epc(p):(q=epc(p))!=0?q:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?epc(p):(q=epc(p))!=0?q:spc(spp()):(epc((p=e2p())&-2)&1)!=0?epc(p):(q=epc(p))!=0?q:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?epo(p):(q=epc(p))!=0?cto(q):spo(spp()):(epc((p=e2p())&-2)&1)!=0?epo(p):(q=epc(p))!=0?cto(q):spo(spp())
  E2S_XWC {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XWC

  //================================================================================
  //E2S_XWP ($0000,$18xx,$1443)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラーが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?(epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp())):e1p()==1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):epc(tev(e1p())))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp()):e1p()==1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())==0?(v1=epc(tev(e2p())))!=0?v1:spc(spp()):v0==1?(v6=epc(0))!=0?v6:spc(spp()):ls1(v0)==0?(v10=epc(v0))!=0?v10:spc(spp()):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())==0?(p=epc(tev(e2p())))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):epc(tev(p))
  //  中間コード5
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):epc(p&-2)
  //  中間コード6
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?cto(p):spo(spp()):p==1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):epo(p&-2)
  E2S_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          p == 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPal32G8[p & -2]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XWP

  //================================================================================
  //E2S_XHCT ($0000,$18xx,$1943)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラーと
  //          スプライトカラー(0は黒)
  //        を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラーが0でないとき
  //          1番目のカラー
  //        さもなくば(1番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のカラーと
  //          スプライトカラー(0は黒)
  //        を混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラーが0でないとき
  //          2番目のカラー
  //        さもなくば(2番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp()))):(ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),spc(spp())):(epc(e2p())!=0?epc(e2p()):spc(spp()))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),spc(spp())):epc(e1p())!=0?epc(e1p()):spc(spp()):ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),spc(spp())):epc(e2p())!=0?epc(e2p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?mix(epc(v0),spc(spp())):(v8=epc(v0))!=0?v8:spc(spp()):ls1(epc(tev(v14=e2p())))!=0?mix(epc(v14),spc(spp())):(v19=epc(v14))!=0?v19:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp()):ls1(epc(tev(p=e2p())))!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp()):(epc((p=e2p())&-2)&1)!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),spc(spp()))):(q=epc(p))!=0?cto(q):spo(spp()):(epc((p=e2p())&-2)&1)!=0?cto(mix(epc(p),spc(spp()))):(q=epc(p))!=0?cto(q):spo(spp())
  E2S_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XHCT

  //================================================================================
  //E2S_XHCG ($0000,$18xx,$1A43)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XHCG  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0でないとき
  //            2番目(ONとみなす)のパレットを奇数化したパレットのカラー
  //          さもなくば(2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0のとき)
  //            スプライトカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラーが0でないとき
  //            1番目のカラー
  //          さもなくば(1番目のカラーが0のとき)
  //            スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラーが0でないとき
  //          2番目のカラー
  //        さもなくば(2番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):(ls1(e1p())!=0?(epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp())))):(ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):(epc(e2p())!=0?epc(e2p()):spc(spp()))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(tev(e1p())),epc(tod(e2q()))):ls1(e1p())!=0?epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp()):epc(e1p())!=0?epc(e1p()):spc(spp()):ls1(epc(tev(e2p())))!=0?mix(epc(tev(e2p())),epc(tod(e2q()))):epc(e2p())!=0?epc(e2p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(v2,epc(tod(e2q()))):ls1(v0)!=0?(v9=epc(tod(e2q())))!=0?v9:spc(spp()):(v14=epc(v0))!=0?v14:spc(spp()):ls1(v18=epc(tev(v20=e2p())))!=0?mix(v18,epc(tod(e2q()))):(v25=epc(v20))!=0?v25:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(q,epc(tod(e2q()))):ls1(p)!=0?(p=epc(tod(e2q())))!=0?p:spc(spp()):(q=epc(p))!=0?q:spc(spp()):ls1(p=epc(tev(q=e2p())))!=0?mix(p,epc(tod(e2q()))):(p=epc(q))!=0?p:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(q,epc(e2q()|1)):(p&1)!=0?(p=epc(e2q()|1))!=0?p:spc(spp()):(q=epc(p))!=0?q:spc(spp()):((p=epc((q=e2p())&-2))&1)!=0?mix(p,epc(e2q()|1)):(p=epc(q))!=0?p:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(q,epc(e2q()|1))):(p&1)!=0?(p=epc(e2q()|1))!=0?cto(p):spo(spp()):(q=epc(p))!=0?cto(q):spo(spp()):((p=epc((q=e2p())&-2))&1)!=0?cto(mix(p,epc(e2q()|1))):(p=epc(q))!=0?cto(p):spo(spp())
  E2S_XHCG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              q,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (p & 1) != 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              p,
                              VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1])] :
                          (p = VideoController.vcnPal16G8[q]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  q,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  p,
                                  VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XHCG

  //================================================================================
  //E2S_XHCGT ($0000,$18xx,$1B43)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XHCGT  0でない1番目のパレットを偶数化したパレットのカラーが奇数のときそれと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
  //          スプライトカラー(0は黒)
  //        を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のパレットが奇数のとき
  //          2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0でないとき
  //            2番目(ONとみなす)のパレットを奇数化したパレットのカラー
  //          さもなくば(2番目(ONとみなす)のパレットを奇数化したパレットのカラーが0のとき)
  //            スプライトカラー(0は黒)
  //        さもなくば(1番目のパレットが偶数のとき)
  //          1番目のカラーが0でないとき
  //            1番目のカラー
  //          さもなくば(1番目のカラーが0のとき)
  //            スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        2番目のパレットを偶数化したパレットのカラーと2番目(ONとみなす)のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
  //          スプライトカラー(0は黒)
  //        を混ぜたカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        2番目のカラーが0でないとき
  //          2番目のカラー
  //        さもなくば(2番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),spc(spp())):(ls1(e1p())!=0?(epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp())))):(ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),spc(spp())):(epc(e2p())!=0?epc(e2p()):spc(spp()))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(mix(epc(tev(e1p())),epc(tod(e2q()))),spc(spp())):ls1(e1p())!=0?epc(tod(e2q()))!=0?epc(tod(e2q())):spc(spp()):epc(e1p())!=0?epc(e1p()):spc(spp()):ls1(epc(tev(e2p())))!=0?mix(mix(epc(tev(e2p())),epc(tod(e2q()))),spc(spp())):epc(e2p())!=0?epc(e2p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(v2=epc(tev(v0)))!=0?mix(mix(v2,epc(tod(e2q()))),spc(spp())):ls1(v0)!=0?(v12=epc(tod(e2q())))!=0?v12:spc(spp()):(v17=epc(v0))!=0?v17:spc(spp()):ls1(v21=epc(tev(v23=e2p())))!=0?mix(mix(v21,epc(tod(e2q()))),spc(spp())):(v31=epc(v23))!=0?v31:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?ls1(q=epc(tev(p)))!=0?mix(mix(q,epc(tod(e2q()))),spc(spp())):ls1(p)!=0?(p=epc(tod(e2q())))!=0?p:spc(spp()):(q=epc(p))!=0?q:spc(spp()):ls1(p=epc(tev(q=e2p())))!=0?mix(mix(p,epc(tod(e2q()))),spc(spp())):(p=epc(q))!=0?p:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?mix(mix(q,epc(e2q()|1)),spc(spp())):(p&1)!=0?(p=epc(e2q()|1))!=0?p:spc(spp()):(q=epc(p))!=0?q:spc(spp()):((p=epc((q=e2p())&-2))&1)!=0?mix(mix(p,epc(e2q()|1)),spc(spp())):(p=epc(q))!=0?p:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?((q=epc(p&-2))&1)!=0?cto(mix(mix(q,epc(e2q()|1)),spc(spp()))):(p&1)!=0?(p=epc(e2q()|1))!=0?cto(p):spo(spp()):(q=epc(p))!=0?cto(q):spo(spp()):((p=epc((q=e2p())&-2))&1)!=0?cto(mix(mix(p,epc(e2q()|1)),spc(spp()))):(p=epc(q))!=0?cto(p):spo(spp())
  E2S_XHCGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int gz2nd = VideoController.vcnHidden2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);  //ONとみなす
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                q,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (p & 1) != 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd & 511]) & -2]) & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                p,
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd & 511] | 1]),
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (p = VideoController.vcnPal16G8[q]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 1 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 2 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 3 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 4 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 5 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 6 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              ((q = VideoController.vcnPal16G8[p & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    q,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])] :
                              (p & 1) != 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              ((p = VideoController.vcnPal16G8[(q = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) & -2]) & 1) != 0 ?
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    p,
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gz2nd | gx2nd + 7 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])] :
                              (p = VideoController.vcnPal16G8[q]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XHCGT

  //================================================================================
  //E2S_XHPT ($0000,$18xx,$1D43)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XHPT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラーが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと
  //        スプライトカラー(0は黒)
  //      を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?(epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp())):e1p()==1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):mix(epc(tev(e1p())),spc(spp())))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp()):e1p()==1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):mix(epc(tev(e1p())),spc(spp()))
  //  中間コード3
  //    (v0=e1p())==0?(v1=epc(tev(e2p())))!=0?v1:spc(spp()):v0==1?(v6=epc(0))!=0?v6:spc(spp()):ls1(v0)==0?(v10=epc(v0))!=0?v10:spc(spp()):mix(epc(tev(v0)),spc(spp()))
  //  中間コード4
  //    (p=e1p())==0?(p=epc(tev(e2p())))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):mix(epc(tev(p)),spc(spp()))
  //  中間コード5
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):mix(epc(p&-2),spc(spp()))
  //  中間コード6
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?cto(p):spo(spp()):p==1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):cto(mix(epc(p&-2),spc(spp())))
  E2S_XHPT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          p == 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p & -2],
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnPal16G8[p & -2],
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XHPT

  //================================================================================
  //E2S_XHPG ($0000,$18xx,$1E43)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XHPG  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラーが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーが0でないとき
  //        1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラー
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーが0のとき)
  //        スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?(epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp())):e1p()==1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):(mix(epc(tev(e1p())),epc(tod(e2p())))!=0?mix(epc(tev(e1p())),epc(tod(e2p()))):spc(spp())))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp()):e1p()==1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):mix(epc(tev(e1p())),epc(tod(e2p())))!=0?mix(epc(tev(e1p())),epc(tod(e2p()))):spc(spp())
  //  中間コード3
  //    (v0=e1p())==0?(v1=epc(tev(e2p())))!=0?v1:spc(spp()):v0==1?(v6=epc(0))!=0?v6:spc(spp()):ls1(v0)==0?(v10=epc(v0))!=0?v10:spc(spp()):(v13=mix(epc(tev(v0)),epc(tod(e2p()))))!=0?v13:spc(spp())
  //  中間コード4
  //    (p=e1p())==0?(p=epc(tev(e2p())))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):(q=mix(epc(tev(p)),epc(tod(e2p()))))!=0?q:spc(spp())
  //  中間コード5
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):(q=mix(epc(p&-2),epc(e2p()|1)))!=0?q:spc(spp())
  //  中間コード6
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?cto(p):spo(spp()):p==1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):(q=mix(epc(p&-2),epc(e2p()|1)))!=0?cto(q):spo(spp())
  E2S_XHPG {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          p == 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (q = VideoController.vcnMix2 (
                             VideoController.vcnPal16G8[p & -2],
                             VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] | 1])) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (q = VideoController.vcnMix2 (
                                 VideoController.vcnPal16G8[p & -2],
                                 VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] | 1])) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XHPG

  //================================================================================
  //E2S_XHPGT ($0000,$18xx,$1F43)
  //  概要
  //    E2S  512ドット16色2プレーン＞スプライト
  //    XHPGT  1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜてさらに奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットのカラーが0でないとき
  //        2番目のパレットを偶数化したパレットのカラー
  //      さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラーと2番目のパレットを奇数化したパレットのカラーを混ぜたカラーにさらに
  //        スプライトカラー(0は黒)
  //      を混ぜたカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?(epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp())):e1p()==1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):mix(mix(epc(tev(e1p())),epc(tod(e2p()))),spc(spp())))
  //  中間コード2
  //    e1p()==0?epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp()):e1p()==1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):mix(mix(epc(tev(e1p())),epc(tod(e2p()))),spc(spp()))
  //  中間コード3
  //    (v0=e1p())==0?(v1=epc(tev(e2p())))!=0?v1:spc(spp()):v0==1?(v6=epc(0))!=0?v6:spc(spp()):ls1(v0)==0?(v10=epc(v0))!=0?v10:spc(spp()):mix(mix(epc(tev(v0)),epc(tod(e2p()))),spc(spp()))
  //  中間コード4
  //    (p=e1p())==0?(p=epc(tev(e2p())))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):mix(mix(epc(tev(p)),epc(tod(e2p()))),spc(spp()))
  //  中間コード5
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):mix(mix(epc(p&-2),epc(e2p()|1)),spc(spp()))
  //  中間コード6
  //    (p=e1p())==0?(p=epc(e2p()&-2))!=0?cto(p):spo(spp()):p==1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):cto(mix(mix(epc(p&-2),epc(e2p()|1)),spc(spp())))
  E2S_XHPGT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          p == 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnMix2 (
                                VideoController.vcnPal16G8[p & -2],
                                VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd & 511] | 1]),
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 1]])]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 2]])]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 3]])]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 4]])]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 5]])]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 6]])]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPalTbl[
                                VideoController.vcnMix2 (
                                  VideoController.vcnMix2 (
                                    VideoController.vcnPal16G8[p & -2],
                                    VideoController.vcnPal16G8[GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] | 1]),
                                  VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx + 7]])]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E2S_XHPGT

  //================================================================================
  //E3S ($0000,$18xx,$0047)
  //  概要
  //    E3S  512ドット16色3プレーン＞スプライト
  //    拡張なし
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のカラーが0でないとき
  //          2番目のカラー
  //        さもなくば(2番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のカラーが0でないとき
  //          3番目のカラー
  //        さもなくば(3番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(epc(e1p())!=0?epc(e1p()):spc(spp())):(e2p()!=0?(epc(e2p())!=0?epc(e2p()):spc(spp())):(epc(e3p())!=0?epc(e3p()):spc(spp()))))
  //  中間コード2
  //    e1p()!=0?epc(e1p())!=0?epc(e1p()):spc(spp()):e2p()!=0?epc(e2p())!=0?epc(e2p()):spc(spp()):epc(e3p())!=0?epc(e3p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?(v1=epc(v0))!=0?v1:spc(spp()):(v4=e2p())!=0?(v5=epc(v4))!=0?v5:spc(spp()):(v8=epc(e3p()))!=0?v8:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?(q=epc(p))!=0?q:spc(spp()):(p=e2p())!=0?(q=epc(p))!=0?q:spc(spp()):(p=epc(e3p()))!=0?p:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?(q=epc(p))!=0?q:spc(spp()):(p=e2p())!=0?(q=epc(p))!=0?q:spc(spp()):(p=epc(e3p()))!=0?p:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?(q=epc(p))!=0?cto(q):spo(spp()):(p=e2p())!=0?(q=epc(p))!=0?cto(q):spo(spp()):(p=epc(e3p()))!=0?cto(p):spo(spp())
  E3S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd & 511]]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3S

  //================================================================================
  //XE3S
  //  概要
  //    E3S  512ドット16色3プレーン＞スプライト
  //    拡張あり
  XE3S {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      switch (VideoController.vcnReg3Curr >>> 8 & 0b01011111) {
        //   .A.XHPGT
      case 0b00010000:  //E3S_XWC
      case 0b00010001:  //E3S_XWC
      case 0b00010010:  //E3S_XWC
      case 0b00010011:  //E3S_XWC
        E3S_XWC.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00010100:  //E3S_XWP
      case 0b00010101:  //E3S_XWP
      case 0b00010110:  //E3S_XWP
      case 0b00010111:  //E3S_XWP
        E3S_XWP.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011000:  //E3S_XHC
        E3S.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011001:  //E3S_XHCT
        E3S_XHCT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011010:  //E3S_XHCG
        E3S_XHCG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011011:  //E3S_XHCGT
        E3S_XHCGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011101:  //E3S_XHPT
        E3S_XHPT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011110:  //E3S_XHPG
        E3S_XHPG.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b00011111:  //E3S_XHPGT
        E3S_XHPGT.drawRaster (src, dst, rh);
        break;
        //   .A.XHPGT
      case 0b01000000:  //E3S_A
      case 0b01000001:  //E3S_A
      case 0b01000010:  //E3S_A
      case 0b01000011:  //E3S_A
      case 0b01000100:  //E3S_A
      case 0b01000101:  //E3S_A
      case 0b01000110:  //E3S_A
      case 0b01000111:  //E3S_A
      case 0b01001000:  //E3S_A
      case 0b01001001:  //E3S_A
      case 0b01001010:  //E3S_A
      case 0b01001011:  //E3S_A
      case 0b01001100:  //E3S_A
      case 0b01001101:  //E3S_A
      case 0b01001110:  //E3S_A
      case 0b01001111:  //E3S_A
      case 0b01010000:  //E3S_A
      case 0b01010001:  //E3S_A
      case 0b01010010:  //E3S_A
      case 0b01010011:  //E3S_A
      case 0b01010100:  //E3S_A
      case 0b01010101:  //E3S_A
      case 0b01010110:  //E3S_A
      case 0b01010111:  //E3S_A
      case 0b01011000:  //E3S_A
      case 0b01011001:  //E3S_A
      case 0b01011010:  //E3S_A
      case 0b01011011:  //E3S_A
      case 0b01011100:  //E3S_A
      case 0b01011101:  //E3S_A
      case 0b01011110:  //E3S_A
      case 0b01011111:  //E3S_A
        E3_A.drawRaster (src, dst, rh);
        break;
      default:
        E3S.drawRaster (src, dst, rh);
        VideoController.vcnReportUnimplemented (XE3S);
      }  //switch
    }  //drawRaster
  },  //XE3S

  //================================================================================
  //E3S_XWC ($0000,$18xx,$1047)
  //  概要
  //    E3S  512ドット16色3プレーン＞スプライト
  //    XWC  優先順位に関わらず0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラーが0でないとき
  //          1番目のカラー
  //        さもなくば(1番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラーが0でないとき
  //            2番目のカラー
  //          さもなくば(2番目のカラーが0のとき)
  //            スプライトカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          3番目のカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          3番目のカラーが0でないとき
  //            3番目のカラー
  //          さもなくば(3番目のカラーが0のとき)
  //            スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?epc(e1p()):(epc(e1p())!=0?epc(e1p()):spc(spp()))):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?epc(e2p()):(epc(e2p())!=0?epc(e2p()):spc(spp()))):(ls1(epc(tev(e3p())))!=0?epc(e3p()):(epc(e3p())!=0?epc(e3p()):spc(spp())))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?epc(e1p()):epc(e1p())!=0?epc(e1p()):spc(spp()):e2p()!=0?ls1(epc(tev(e2p())))!=0?epc(e2p()):epc(e2p())!=0?epc(e2p()):spc(spp()):ls1(epc(tev(e3p())))!=0?epc(e3p()):epc(e3p())!=0?epc(e3p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?epc(v0):(v5=epc(v0))!=0?v5:spc(spp()):(v8=e2p())!=0?ls1(epc(tev(v8)))!=0?epc(v8):(v13=epc(v8))!=0?v13:spc(spp()):ls1(epc(tev(v19=e3p())))!=0?epc(v19):(v21=epc(v19))!=0?v21:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?epc(p):(q=epc(p))!=0?q:spc(spp()):(p=e2p())!=0?ls1(epc(tev(p)))!=0?epc(p):(q=epc(p))!=0?q:spc(spp()):ls1(epc(tev(p=e3p())))!=0?epc(p):(q=epc(p))!=0?q:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?epc(p):(q=epc(p))!=0?q:spc(spp()):(p=e2p())!=0?(epc(p&-2)&1)!=0?epc(p):(q=epc(p))!=0?q:spc(spp()):(epc((p=e3p())&-2)&1)!=0?epc(p):(q=epc(p))!=0?q:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?epo(p):(q=epc(p))!=0?cto(q):spo(spp()):(p=e2p())!=0?(epc(p&-2)&1)!=0?epo(p):(q=epc(p))!=0?cto(q):spo(spp()):(epc((p=e3p())&-2)&1)!=0?epo(p):(q=epc(p))!=0?cto(q):spo(spp())
  E3S_XWC {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd & 511]) & -2] & 1) != 0 ?
                          VideoController.vcnPal32G8[p] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511]) != 0 ?
                              (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (VideoController.vcnPal16G8[(p = GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511]) & -2] & 1) != 0 ?
                              VideoController.vcnPal32G8[p] :
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3S_XWC

  //================================================================================
  //E3S_XWP ($0000,$18xx,$1447)
  //  概要
  //    E3S  512ドット16色3プレーン＞スプライト
  //    XWP  優先順位に関わらず1番目のパレットが3以上の奇数のときそれを偶数化したパレットのカラーだけ表示する
  //  手順
  //    1番目のパレットが0のとき
  //      2番目のパレットを偶数化したパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが0でないとき
  //          2番目のパレットを偶数化したパレットのカラー
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが0のとき)
  //          スプライトカラー(0は黒)
  //      さもなくば(2番目のパレットを偶数化したパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラーが0でないとき
  //          3番目のパレットを偶数化したパレットのカラー
  //        さもなくば(3番目のパレットを偶数化したパレットのカラーが0のとき)
  //          スプライトカラー(0は黒)
  //    1番目のパレットが1のとき
  //      グラフィックパレット0のカラーが0でないとき
  //        グラフィックパレット0のカラー
  //      さもなくば(グラフィックパレット0のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    1番目のパレットが2以上の偶数のとき
  //      1番目のカラーが0でないとき
  //        1番目のカラー
  //      さもなくば(1番目のカラーが0のとき)
  //        スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが3以上の奇数のとき)
  //      1番目のパレットを偶数化したパレットのカラー(0は黒)
  //  中間コード1
  //    (e1p()==0?((tev(e2p()))!=0?(epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp())):(epc(tev(e3p()))!=0?epc(tev(e3p())):spc(spp()))):e1p()==1?(epc(0)!=0?epc(0):spc(spp())):ls1(e1p())==0?(epc(e1p())!=0?epc(e1p()):spc(spp())):epc(tev(e1p())))
  //  中間コード2
  //    e1p()==0?tev(e2p())!=0?epc(tev(e2p()))!=0?epc(tev(e2p())):spc(spp()):epc(tev(e3p()))!=0?epc(tev(e3p())):spc(spp()):e1p()==1?epc(0)!=0?epc(0):spc(spp()):ls1(e1p())==0?epc(e1p())!=0?epc(e1p()):spc(spp()):epc(tev(e1p()))
  //  中間コード3
  //    (v0=e1p())==0?(v1=tev(e2p()))!=0?(v3=epc(v1))!=0?v3:spc(spp()):(v6=epc(tev(e3p())))!=0?v6:spc(spp()):v0==1?(v11=epc(0))!=0?v11:spc(spp()):ls1(v0)==0?(v15=epc(v0))!=0?v15:spc(spp()):epc(tev(v0))
  //  中間コード4
  //    (p=e1p())==0?(p=tev(e2p()))!=0?(q=epc(p))!=0?q:spc(spp()):(p=epc(tev(e3p())))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):ls1(p)==0?(q=epc(p))!=0?q:spc(spp()):epc(tev(p))
  //  中間コード5
  //    (p=e1p())==0?(p=e2p()&-2)!=0?(q=epc(p))!=0?q:spc(spp()):(p=epc(e3p()&-2))!=0?p:spc(spp()):p==1?(p=epc(0))!=0?p:spc(spp()):(p&1)==0?(q=epc(p))!=0?q:spc(spp()):epc(p&-2)
  //  中間コード6
  //    (p=e1p())==0?(p=e2p()&-2)!=0?(q=epc(p))!=0?cto(q):spo(spp()):(p=epc(e3p()&-2))!=0?cto(p):spo(spp()):p==1?(p=epc(0))!=0?cto(p):spo(spp()):(p&1)==0?(q=epc(p))!=0?cto(q):spo(spp()):epo(p&-2)
  E3S_XWP {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) == 0 ?
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511] & -2) != 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd & 511] & -2]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          p == 1 ?
                          (p = VideoController.vcnPal16G8[0]) != 0 ?
                          VideoController.vcnPalTbl[p] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p & 1) == 0 ?
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 1] = ((p = GraphicScreen.graM4[gy1st | gx1st + 1 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 1 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 1 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 1]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 2] = ((p = GraphicScreen.graM4[gy1st | gx1st + 2 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 2 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 2 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 2]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 3] = ((p = GraphicScreen.graM4[gy1st | gx1st + 3 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 3 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 3 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 3]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 4] = ((p = GraphicScreen.graM4[gy1st | gx1st + 4 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 4 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 4 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 4]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 5] = ((p = GraphicScreen.graM4[gy1st | gx1st + 5 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 5 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 5 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 5]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 6] = ((p = GraphicScreen.graM4[gy1st | gx1st + 6 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 6 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 6 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 6]] :
                              VideoController.vcnPal32G8[p & -2]);
        XEiJ.pnlBM[da + 7] = ((p = GraphicScreen.graM4[gy1st | gx1st + 7 & 511]) == 0 ?
                              (p = GraphicScreen.graM4[gy2nd | gx2nd + 7 & 511] & -2) != 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p = VideoController.vcnPal16G8[GraphicScreen.graM4[gy3rd | gx3rd + 7 & 511] & -2]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              p == 1 ?
                              (p = VideoController.vcnPal16G8[0]) != 0 ?
                              VideoController.vcnPalTbl[p] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              (p & 1) == 0 ?
                              (q = VideoController.vcnPal16G8[p]) != 0 ?
                              VideoController.vcnPalTbl[q] :
                              VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx + 7]] :
                              VideoController.vcnPal32G8[p & -2]);
        sx += 8;
        gx1st += 8;
        gx2nd += 8;
        gx3rd += 8;
        da += 8;
      }  //while da<db
    }  //drawRaster
  },  //E3S_XWP

  //================================================================================
  //E3S_XHCT ($0000,$18xx,$1947)
  //  概要
  //    E3S  512ドット16色3プレーン＞スプライト
  //    XHCT  0でない1番目のパレットを偶数化(65536色は奇数化)したパレットのカラーが奇数のとき0でない1番目のカラーと奥のスプライト・テキストのカラーを混ぜる
  //  手順
  //    1番目のパレットが0でないとき
  //      1番目のパレットを偶数化したパレットのカラーが奇数のとき
  //        1番目のカラーと
  //          スプライトカラー(0は黒)
  //        を混ぜたカラー(0は黒)
  //      さもなくば(1番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //        1番目のカラーが0でないとき
  //          1番目のカラー
  //        さもなくば(1番目のカラーが0のとき)
  //          スプライトカラー(0は黒)
  //    さもなくば(1番目のパレットが0のとき)
  //      2番目のパレットが0でないとき
  //        2番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          2番目のカラーと
  //            スプライトカラー(0は黒)
  //          を混ぜたカラー(0は黒)
  //        さもなくば(2番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          2番目のカラーが0でないとき
  //            2番目のカラー
  //          さもなくば(2番目のカラーが0のとき)
  //            スプライトカラー(0は黒)
  //      さもなくば(2番目のパレットが0のとき)
  //        3番目のパレットを偶数化したパレットのカラーが奇数のとき
  //          3番目のカラーと
  //            スプライトカラー(0は黒)
  //          を混ぜたカラー(0は黒)
  //        さもなくば(3番目のパレットを偶数化したパレットのカラーが偶数のとき)
  //          3番目のカラーが0でないとき
  //            3番目のカラー
  //          さもなくば(3番目のカラーが0のとき)
  //            スプライトカラー(0は黒)
  //  中間コード1
  //    (e1p()!=0?(ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),spc(spp())):(epc(e1p())!=0?epc(e1p()):spc(spp()))):(e2p()!=0?(ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),spc(spp())):(epc(e2p())!=0?epc(e2p()):spc(spp()))):(ls1(epc(tev(e3p())))!=0?mix(epc(e3p()),spc(spp())):(epc(e3p())!=0?epc(e3p()):spc(spp())))))
  //  中間コード2
  //    e1p()!=0?ls1(epc(tev(e1p())))!=0?mix(epc(e1p()),spc(spp())):epc(e1p())!=0?epc(e1p()):spc(spp()):e2p()!=0?ls1(epc(tev(e2p())))!=0?mix(epc(e2p()),spc(spp())):epc(e2p())!=0?epc(e2p()):spc(spp()):ls1(epc(tev(e3p())))!=0?mix(epc(e3p()),spc(spp())):epc(e3p())!=0?epc(e3p()):spc(spp())
  //  中間コード3
  //    (v0=e1p())!=0?ls1(epc(tev(v0)))!=0?mix(epc(v0),spc(spp())):(v8=epc(v0))!=0?v8:spc(spp()):(v11=e2p())!=0?ls1(epc(tev(v11)))!=0?mix(epc(v11),spc(spp())):(v19=epc(v11))!=0?v19:spc(spp()):ls1(epc(tev(v25=e3p())))!=0?mix(epc(v25),spc(spp())):(v30=epc(v25))!=0?v30:spc(spp())
  //  中間コード4
  //    (p=e1p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp()):(p=e2p())!=0?ls1(epc(tev(p)))!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp()):ls1(epc(tev(p=e3p())))!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp())
  //  中間コード5
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp()):(p=e2p())!=0?(epc(p&-2)&1)!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp()):(epc((p=e3p())&-2)&1)!=0?mix(epc(p),spc(spp())):(q=epc(p))!=0?q:spc(spp())
  //  中間コード6
  //    (p=e1p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),spc(spp()))):(q=epc(p))!=0?cto(q):spo(spp()):(p=e2p())!=0?(epc(p&-2)&1)!=0?cto(mix(epc(p),spc(spp()))):(q=epc(p))!=0?cto(q):spo(spp()):(epc((p=e3p())&-2)&1)!=0?cto(mix(epc(p),spc(spp()))):(q=epc(p))!=0?cto(q):spo(spp())
  E3S_XHCT {
    @Override public void drawRaster (int src, int dst, boolean rh) {
      SpriteScreen.sprStep3 ();
      int sx = 16;  //スプライトx座標
      int pn = VideoController.vcnReg2Curr & 3;  //1番目のパレットのGVRAMページ番号
      int gx1st = CRTC.crtR12GrXCurr[pn];
      int gy1st = VideoController.vcnVisible1st + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 2 & 3;  //2番目のパレットのGVRAMページ番号
      int gx2nd = CRTC.crtR12GrXCurr[pn];
      int gy2nd = VideoController.vcnVisible2nd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      pn = VideoController.vcnReg2Curr >> 4 & 3;  //3番目のパレットのGVRAMページ番号
      int gx3rd = CRTC.crtR12GrXCurr[pn];
      int gy3rd = VideoController.vcnVisible3rd + ((CRTC.crtR13GrYZero[pn] + src & 511) << 9);
      int da = dst << XEiJ.PNL_BM_OFFSET_BITS;  //ARGB出力インデックス
      int db = da + XEiJ.pnlScreenWidth;  //ARGB出力インデックスの終了位置
      if (rh) {
        int half = XEiJ.pnlScreenWidth >> 4 << 3;
        sx += half;
        gx1st += half;
        gx2nd += half;
        gx3rd += half;
        da += half;
      }
      while (da < db) {
        int p, q;
        XEiJ.pnlBM[da] = ((p = GraphicScreen.graM4[gy1st | gx1st & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
                            VideoController.vcnMix2 (
                              VideoController.vcnPal16G8[p],
                              VideoController.vcnPal16TS[SpriteScreen.sprBuffer[sx]])] :
                          (q = VideoController.vcnPal16G8[p]) != 0 ?
                          VideoController.vcnPalTbl[q] :
                          VideoController.vcnPal32TS[SpriteScreen.sprBuffer[sx]] :
                          (p = GraphicScreen.graM4[gy2nd | gx2nd & 511]) != 0 ?
                          (VideoController.vcnPal16G8[p & -2] & 1) != 0 ?
                          VideoController.vcnPalTbl[
       