	.include	t00iocs.equ
	.include	t01dos.equ
	.include	t02const.equ

	.cpu	68060

;----------------------------------------------------------------
;foCXwb_
deviceHeader::
	.dc.l	-1
	.dc.w	$0000
	.dc.l	strategyRoutine
	.dc.l	interruptRoutine
	.dc.b	1,'RAMDISK'

requestHeader:
	.ds.l	1

deviceJumpTable::
	.dc.l	deviceInitialize	;
	.dc.l	deviceCheck		;fBA`FbN
	.dc.l	noError
	.dc.l	commandError
	.dc.l	deviceInput		;
	.dc.l	deviceSense		;Ԏ擾
	.dc.l	noError
	.dc.l	noError
	.dc.l	deviceOutput		;o
	.dc.l	deviceOutput		;o
	.dc.l	noError
	.dc.l	noError
	.dc.l	commandError

;XgeW[`
strategyRoutine:
	move.l	a5,requestHeader
	rts

;C^vg[`
interruptRoutine:
	move.l	a5,-(sp)
	move.l	d0,-(sp)
	movea.l	requestHeader,a5
	moveq.l	#0,d0
	move.b	(2,a5),d0		;R}hR[h
	lsl.l	#2,d0
	pea.l	(@f,pc)
	move.l	(deviceJumpTable,pc,d0.l),-(sp)
	rts				;R}h̏Ă
@@:	move.b	d0,(3,a5)		;G[R[h()
	lsr.w	#8,d0
	move.b	d0,(4,a5)		;G[R[h()
	move.l	(sp)+,d0
	movea.l	(sp)+,a5
	rts

noError:
	moveq.l	#0,d0
	rts

commandError:
	move.w	#$5003,d0
	rts

;----------------------------------------------------------------
;xN^e[u
	.align	4,$2048
vectorTable::
vectorInfoAccessError::	.dc.l	ACCESS_ERROR
vectorOldAccessError::	.dc.l	0
vectorAccessError::	.dc.l	accessError

vectorInfoPRIVILEGE::	.dc.l	PRIVILEGE
vectorOldPRIVILEGE::	.dc.l	0
vectorPRIVILEGE::	.dc.l	_060_fpsp_fline		;privilegeViolation

vectorInfoFLINE::	.dc.l	FLINE
vectorOldFLINE::	.dc.l	0
vectorFLINE::		.dc.l	_060_fpsp_fline

vectorInfoBSUN::	.dc.l	BSUN
vectorOldBSUN::		.dc.l	0
vectorBSUN::		.dc.l	_060_real_bsun

vectorInfoINEX::	.dc.l	INEX
vectorOldINEX::		.dc.l	0
vectorINEX::		.dc.l	_fpsp_inex
				;_060FPSP_TABLE+$000019D4
				;_060FPSP_TABLE+$28
				;$80000000+_060FPSP_TABLE+$28+2

vectorInfoDZ::		.dc.l	DZ
vectorOldDZ::		.dc.l	0
vectorDZ::		.dc.l	_fpsp_dz
				;_060FPSP_TABLE+$00001B32
				;_060FPSP_TABLE+$20
				;$80000000+_060FPSP_TABLE+$20+2

vectorInfoUNFL::	.dc.l	UNFL
vectorOldUNFL::		.dc.l	0
vectorUNFL::		.dc.l	_fpsp_unfl
				;_060FPSP_TABLE+$0000048A
				;_060FPSP_TABLE+$18
				;$80000000+_060FPSP_TABLE+$18+2

vectorInfoOPERR::	.dc.l	OPERR
vectorOldOPERR::	.dc.l	0
vectorOPERR::		.dc.l	_fpsp_operr
				;_060FPSP_TABLE+$000015FE
				;_060FPSP_TABLE+$08
				;$80000000+_060FPSP_TABLE+$08+2

vectorInfoOVFL::	.dc.l	OVFL
vectorOldOVFL::		.dc.l	0
vectorOVFL::		.dc.l	_fpsp_ovfl
				;_060FPSP_TABLE+$000002C8
				;_060FPSP_TABLE+$10
				;$80000000+_060FPSP_TABLE+$10+2

vectorInfoSNAN::	.dc.l	SNAN
vectorOldSNAN::		.dc.l	0
vectorSNAN::		.dc.l	_fpsp_snan
				;_060FPSP_TABLE+$00001742
				;_060FPSP_TABLE+$00
				;$80000000+_060FPSP_TABLE+$00+2

vectorInfoUNSUPP::	.dc.l	UNSUPP
vectorOldUNSUPP::	.dc.l	0
vectorUNSUPP::		.dc.l	_fpsp_unsupp
				;_060FPSP_TABLE+$00000668
				;_060FPSP_TABLE+$38
				;$80000000+_060FPSP_TABLE+$38+2

vectorInfoEFFADD::	.dc.l	EFFADD
vectorOldEFFADD::	.dc.l	0
vectorEFFADD::		.dc.l	_fpsp_effadd
				;_060FPSP_TABLE+$0000106E
				;_060FPSP_TABLE+$40
				;$80000000+_060FPSP_TABLE+$40+2

vectorInfoUNINT::	.dc.l	UNINT
vectorOldUNINT::	.dc.l	0
vectorUNINT::		.dc.l	_060_isp_unint

vectorInfoIocsAdpcmout::	.dc.l	$0400+_ADPCMOUT*4
vectorOldIocsAdpcmout::	.dc.l	0
vectorIocsAdpcmout::	.dc.l	iocsAdpcmout

vectorInfoIocsAdpcminp::	.dc.l	$0400+_ADPCMINP*4
vectorOldIocsAdpcminp::	.dc.l	0
vectorIocsAdpcminp::	.dc.l	iocsAdpcminp

vectorInfoIocsAdpcmaot::	.dc.l	$0400+_ADPCMAOT*4
vectorOldIocsAdpcmaot::	.dc.l	0
vectorIocsAdpcmaot::	.dc.l	iocsAdpcmaot

vectorInfoIocsAdpcmain::	.dc.l	$0400+_ADPCMAIN*4
vectorOldIocsAdpcmain::	.dc.l	0
vectorIocsAdpcmain::	.dc.l	iocsAdpcmain

vectorInfoIocsAdpcmlot::	.dc.l	$0400+_ADPCMLOT*4
vectorOldIocsAdpcmlot::	.dc.l	0
vectorIocsAdpcmlot::	.dc.l	iocsAdpcmlot

vectorInfoIocsAdpcmlin::	.dc.l	$0400+_ADPCMLIN*4
vectorOldIocsAdpcmlin::	.dc.l	0
vectorIocsAdpcmlin::	.dc.l	iocsAdpcmlin

vectorInfoIocsAdpcmsns::	.dc.l	$0400+_ADPCMSNS*4
vectorOldIocsAdpcmsns::	.dc.l	0
vectorIocsAdpcmsns::	.dc.l	iocsAdpcmsns

vectorInfoIocsAdpcmmod::	.dc.l	$0400+_ADPCMMOD*4
vectorOldIocsAdpcmmod::	.dc.l	0
vectorIocsAdpcmmod::	.dc.l	iocsAdpcmmod

vectorInfoIocsDmamove::	.dc.l	$0400+_DMAMOVE*4
vectorOldIocsDmamove::	.dc.l	0
vectorIocsDmamove::	.dc.l	iocsDmamove

vectorInfoIocsDmamovA::	.dc.l	$0400+_DMAMOV_A*4
vectorOldIocsDmamovA::	.dc.l	0
vectorIocsDmamovA::	.dc.l	iocsDmamovA

vectorInfoIocsDmamovL::	.dc.l	$0400+_DMAMOV_L*4
vectorOldIocsDmamovL::	.dc.l	0
vectorIocsDmamovL::	.dc.l	iocsDmamovL

vectorInfoIocsDmamode::	.dc.l	$0400+_DMAMODE*4
vectorOldIocsDmamode::	.dc.l	0
vectorIocsDmamode::	.dc.l	iocsDmamode

vectorInfoIocsSysStat::	.dc.l	$0400+_SYS_STAT*4
vectorOldIocsSysStat::	.dc.l	0
vectorIocsSysStat::	.dc.l	iocsSysStat

vectorInfoIocsScsidrv::	.dc.l	$0400+_SCSIDRV*4
vectorOldIocsScsidrv::	.dc.l	0
vectorIocsScsidrv::	.dc.l	iocsScsidrv

vectorInfoIocsPrnintst::	.dc.l	$0400+_PRNINTST*4
vectorOldIocsPrnintst::	.dc.l	0
vectorIocsPrnintst::	.dc.l	iocsPrnintst

vectorInfoPrnint::	.dc.l	PRNINT
vectorOldPrnint::	.dc.l	0
vectorPrnint::		.dc.l	((PRNINT>>2)<<24)+defaultPrnint

vectorInfoIocsHimem::	.dc.l	$0400+_HIMEM*4
vectorOldIocsHimem::	.dc.l	0
vectorIocsHimem::	.dc.l	iocsHimem

vectorInfoDosExit::	.dc.l	$1800+(_EXIT-$FF00)*4
vectorOldDosExit::	.dc.l	0
vectorDosExit::		.dc.l	dosExit

vectorInfoDosKeeppr::	.dc.l	$1800+(_KEEPPR-$FF00)*4
vectorOldDosKeeppr::	.dc.l	0
vectorDosKeeppr::	.dc.l	dosKeeppr

vectorInfoDosMalloc::	.dc.l	$1800+(_MALLOC-$FF00)*4
vectorOldDosMalloc::	.dc.l	0
vectorDosMalloc::	.dc.l	dosMalloc

vectorInfoDosMfree::	.dc.l	$1800+(_MFREE-$FF00)*4
vectorOldDosMfree::	.dc.l	0
vectorDosMfree::	.dc.l	dosMfree

vectorInfoDosSetblock::	.dc.l	$1800+(_SETBLOCK-$FF00)*4
vectorOldDosSetblock::	.dc.l	0
vectorDosSetblock::	.dc.l	dosSetblock

vectorInfoDosExec::	.dc.l	$1800+(_EXEC-$FF00)*4
vectorOldDosExec::	.dc.l	0
vectorDosExec::		.dc.l	dosExec

vectorInfoDosExit2::	.dc.l	$1800+(_EXIT2-$FF00)*4
vectorOldDosExit2::	.dc.l	0
vectorDosExit2::	.dc.l	dosExit2

vectorInfoDos0Malloc2::	.dc.l	$1800+(~0~_MALLOC2-$FF00)*4
vectorOldDos0Malloc2::	.dc.l	0
vectorDos0Malloc2::	.dc.l	dosMalloc2

vectorInfoDos0Malloc3::	.dc.l	$1800+(~0~_MALLOC3-$FF00)*4
vectorOldDos0Malloc3::	.dc.l	0
vectorDos0Malloc3::	.dc.l	dosMalloc3

vectorInfoDos0Setblock2::	.dc.l	$1800+(~0~_SETBLOCK2-$FF00)*4
vectorOldDos0Setblock2::	.dc.l	0
vectorDos0SetBlock2::	.dc.l	dosSetblock2

vectorInfoDos0Malloc4::	.dc.l	$1800+(~0~_MALLOC4-$FF00)*4
vectorOldDos0Malloc4::	.dc.l	0
vectorDos0Malloc4::	.dc.l	dosMalloc4

vectorInfoDos0SMalloc2::	.dc.l	$1800+(~0~_S_MALLOC2-$FF00)*4
vectorOldDos0SMalloc2::	.dc.l	0
vectorDos0SMalloc2::	.dc.l	dosSMalloc2

vectorInfoDos0SMalloc::	.dc.l	$1800+(~0~_S_MALLOC-$FF00)*4
vectorOldDos0SMalloc::	.dc.l	0
vectorDos0SMalloc::	.dc.l	dosSMalloc

vectorInfoDos0SMfree::	.dc.l	$1800+(~0~_S_MFREE-$FF00)*4
vectorOldDos0SMfree::	.dc.l	0
vectorDos0SMfree::	.dc.l	dosSMfree

vectorInfoDos0SProcess::	.dc.l	$1800+(~0~_S_PROCESS-$FF00)*4
vectorOldDos0SProcess::	.dc.l	0
vectorDos0SProcess::	.dc.l	dosSProcess

vectorInfoDosMalloc2::	.dc.l	$1800+(_MALLOC2-$FF00)*4
vectorOldDosMalloc2::	.dc.l	0
vectorDosMalloc2::	.dc.l	dosMalloc2

vectorInfoDosMalloc3::	.dc.l	$1800+(_MALLOC3-$FF00)*4
vectorOldDosMalloc3::	.dc.l	0
vectorDosMalloc3::	.dc.l	dosMalloc3

vectorInfoDosSetblock2::	.dc.l	$1800+(_SETBLOCK2-$FF00)*4
vectorOldDosSetblock2::	.dc.l	0
vectorDosSetBlock2::	.dc.l	dosSetblock2

vectorInfoDosMalloc4::	.dc.l	$1800+(_MALLOC4-$FF00)*4
vectorOldDosMalloc4::	.dc.l	0
vectorDosMalloc4::	.dc.l	dosMalloc4

vectorInfoDosSMalloc2::	.dc.l	$1800+(_S_MALLOC2-$FF00)*4
vectorOldDosSMalloc2::	.dc.l	0
vectorDosSMalloc2::	.dc.l	dosSMalloc2

vectorInfoDosSMalloc::	.dc.l	$1800+(_S_MALLOC-$FF00)*4
vectorOldDosSMalloc::	.dc.l	0
vectorDosSMalloc::	.dc.l	dosSMalloc

vectorInfoDosSMfree::	.dc.l	$1800+(_S_MFREE-$FF00)*4
vectorOldDosSMfree::	.dc.l	0
vectorDosSMfree::	.dc.l	dosSMfree

vectorInfoDosSProcess::	.dc.l	$1800+(_S_PROCESS-$FF00)*4
vectorOldDosSProcess::	.dc.l	0
vectorDosSProcess::	.dc.l	dosSProcess

vectorInfoDosOpenPr::	.dc.l	$1800+(_OPEN_PR-$FF00)*4
vectorOldDosOpenPr::	.dc.l	0
vectorDosOpenPr::	.dc.l	dosOpenPr

vectorInfoDosKillPr::	.dc.l	$1800+(_KILL_PR-$FF00)*4
vectorOldDosKillPr::	.dc.l	0
vectorDosKillPr::	.dc.l	dosKillPr

vectorInfoDosChangePr::	.dc.l	$1800+(_CHANGE_PR-$FF00)*4
vectorOldDosChangePr::	.dc.l	0
vectorDosChangePr::	.dc.l	dosChangePr

vectorInfoHumanTrap10::	.dc.l	$1C6A
vectorOldHumanTrap10::	.dc.l	0
vectorHumanTrap10::	.dc.l	humanTrap10

			.dc.l	0


;----------------------------------------------------------------
;
;	Ǘ͈̈̔
;
;----------------------------------------------------------------
	.align	4,$2048
mainLowerStart::
	.dc.l	0
mainLowerEnd::
	.dc.l	0
mainUpperStart::
	.dc.l	0
mainUpperEnd::
	.dc.l	0
localLowerStart::
	.dc.l	0
localLowerEnd::
	.dc.l	0
localUpperStart::
	.dc.l	0
localUpperEnd::
	.dc.l	0

;----------------------------------------------------------------
;
;	oXG[`FbN[`̃[N
;
;----------------------------------------------------------------
	.align	4,$2048
dosBusErrVbr::
	.dc.l	0			;oXG[`FbNp̉̃xN^e[ũAhX
dosBusErrSsp::
	.dc.l	0			;oXG[`FbNp̉̃X[p[oCUX^bN

;----------------------------------------------------------------
;
;	etO,JE^
;
;----------------------------------------------------------------
localRomArea::
	.dc.b	0			;-1=ROM[JɃRs[Ďg
localSystemArea::
	.dc.b	0			;-1=xN^Human܂łƃhCo{̂,
					;[JɃRs[Ďg
localAreaDescriptor::
	.dc.b	0			;-1=fXNv^̗̈[Jɔzu
patchIocsScsi::
	.dc.b	0			;-1=_SCSIDRVɃpb`Ă
forceSoftScsi::
	.dc.b	0			;-1=SCSIIɃ\tg]ɂ
patchDevice::
	.dc.b	0			;-1=foCXhCõANZXɃpb`Ă
deviceCacheNoPush::
	.dc.b	0			;-1=ȊÕfoCXĂяoŃLbVvbVȂ
useIocsHimem::
	.dc.b	-1			;-1=_HIMEMg
unitCounter::
	.dc.b	0			;RAMDISK̃jbg
useExtendedMode::
	.dc.b	0			;-1=g[hg
extendedMode::
	.dc.b	0			;-1=݊g[hɂȂĂ
useJointMode::
	.dc.b	0			;-1=[hg
jointMode::
	.dc.b	0			;-1=݌[hɂȂĂ
mainMemoryCacheMode::
	.dc.b	0			;C̃LbV[h
localMemoryCacheMode::
	.dc.b	0			;[J̃LbV[h
softwareIocsDma::
	.dc.b	0			;-1=IOCSɂDMA]\tg]ɂ
patchIocsAdpcm::
	.dc.b	0			;-1=ADPCM֌WIOCSR[Ƀpb`Ă
forceNoSimm::
	.dc.b	0			;-1=SIMMĂĂgȂƂɂ
noTranslation::
	.dc.b	0			;-1=AhXϊsȂ

	.even
scsiRevisionCode::
	.dc.w	0			;SCSI _S_REVISIOŇ
					;$000AȏSRAM̃\tg]tOɑΉĂ

;----------------------------------------------------------------
;
;	[JɒuROM̈
;
;----------------------------------------------------------------
	.align	4,$2048
localRomStart::
	.dc.l	0
localRomEnd::
	.dc.l	0

;----------------------------------------------------------------
;
;	[JɒuVXë
;
;----------------------------------------------------------------
	.align	4,$2048
localSystemStart::
	.dc.l	0
localSystemEnd::
	.dc.l	0

;----------------------------------------------------------------
;
;	fXNv^̗̈
;
;----------------------------------------------------------------
	.align	4,$2048
;y[WCfbNXtB[h̃rbgɉĕωl
pageIndexWidth::			;y[WCfbNXtB[h̃rbg(5`6)
	.dc.l	PAGE_INDEX_WIDTH	;	5
pageIndexSize::				;y[We[u1Ɋ܂܂y[WfXNv^̌
	.dc.l	PAGE_INDEX_SIZE		;	32
pageIndexMask::				;y[WCfbNXtB[h̃}XN
	.dc.l	PAGE_INDEX_MASK		;	31

pageOffsetWidth::			;y[WItZbg̃rbg(12`13)
	.dc.l	PAGE_OFFSET_WIDTH	;	13=8KB/page
pageOffsetSize::			;1y[W̃TCY
	.dc.l	PAGE_OFFSET_SIZE	;	$00002000=8KB/page
pageOffsetMask::			;y[WItZbg̃}XN
	.dc.l	PAGE_OFFSET_MASK	;	$00001FFF

pageMask::				;y[W̐擪AhX̃}XN
	.dc.l	PAGE_MASK		;	$3FFFE000

pageDescSize::				;y[We[u1̃TCY
	.dc.l	PAGE_DESC_SIZE		;	$00000080
pageDescMask::				;y[We[u̐擪̃AhX̃}XN
	.dc.l	PAGE_DESC_MASK		;	$3FFFFF80

;fXNv^̗̈͏movesŃANZX̂ŕi͌ȂĂ悢
descAreaStart::
	.dc.l	0			;fXNv^̗̈̐擪(y[W̐擪)
descAreaEnd::
	.dc.l	0			;fXNv^̗̖̈+1(y[W̖+1)
descAreaSize::
	.dc.l	0			;fXNv^̗̈̃TCY(y[WTCY̔{Ƃ͌Ȃ)

;fXNv^̗̈
descHead::				;[gfXNv^̐擪
rootDescHead::				;fXNv^̗̈̐擪
	.dc.l	0
rootDescTail::				;[gfXNv^̖
pointerDescHead::			;|C^fXNv^̐擪
	.dc.l	0
pointerDescTail::			;|C^fXNv^̖igpĂ镔̖,ρj
	.dc.l	0
pageDescHead::				;y[WfXNv^̐擪igpĂ镔̐擪,ρj
	.dc.l	0
pageDescTail::				;y[WfXNv^̖
pointerCounterHead::			;|C^fXNv^e[u̎QƐJE^e[u̐擪
	.dc.l	0
pageCounterTail::			;y[WfXNv^e[u̎QƐJE^e[u̖
descTail::				;fXNv^̗̖̈
	.dc.l	0

;----------------------------------------------------------------
;
;	foCXhCo̓]obt@
;
;----------------------------------------------------------------
	.align	4,$2048
tempBufferStart::
	.dc.l	0			;]obt@̐擪
tempBufferEnd::
	.dc.l	0			;]obt@̖+1
tempBufferSize::
	.dc.l	0			;]obt@̃oCg(1024̔{)


;----------------------------------------------------------------
;
;	ADPCM֌W̃[N
;
;----------------------------------------------------------------
	.align	4,$2048
adpcmBufferStart::
	.dc.l	0			;ADPCM]obt@̐擪
adpcmBufferEnd::
	.dc.l	0			;ADPCM]obt@̖
adpcmBufferSize::
	.dc.l	ADPCM_SPLIT_SIZE	;TCY
adpcmLeftSize::
	.dc.l	0			;܂obt@ɃRs[ĂȂTCY
adpcmDataPtr::
	.dc.l	0			;܂obt@ɃRs[ĂȂf[^
adpcmBufferPtr0::
	.dc.l	0			;obt@0ւ̃|C^
adpcmBufferPtr1::
	.dc.l	0			;obt@1ւ̃|C^

;----------------------------------------------------------------
;
;	[J
;
;----------------------------------------------------------------
	.align	4,$2048
localMemoryStart::
	.dc.l	0			;[J̐擪
localMemoryEnd::
	.dc.l	0			;[J̖+1
localMemorySize::
	.dc.l	0			;[J̃TCY(0=݂Ȃ)

himemAreaStart::
	.dc.l	0			;_HIMEMŃANZX͈͂̐擪
himemAreaEnd::
	.dc.l	0			;_HIMEMŃANZX͈̖͂+1
himemAreaSize::
	.dc.l	0			;_HIMEMŃANZX͈͂̃TCY

;----------------------------------------------------------------
;
;	g[h
;
;----------------------------------------------------------------
	.align	4,$2048
mainMemorySize::
	.dc.l	-1			;C̃TCY

;----------------------------------------------------------------
;
;	[h
;
;----------------------------------------------------------------
	.align	4,$2048
jointBlockHeader::
	.dc.l	0			;ubÑwb_(0=g[h֎~)
jointBlockSize::
	.dc.l	DEFAULT_JOIN_SIZE	;ubÑTCY(wb_܂܂Ȃ)

;----------------------------------------------------------------
;
;	Xbh̔r֌W̃[N
;
;----------------------------------------------------------------
backgroundFlag::
	.ds.b	1		;-1=XbhԂ̔rs

	.align	4,$2048
exclusiveStart::
	.ds.l	1		;CXbhȊO̔r̐擪
				;CXbhȊO̔r,
				;1xSize2oCg($1C58.w).wKv
exclusiveEnd::
	.ds.l	1		;CXbhȊO̔r̖+1

;rւ̃|C^̃e[u
;-1͔r񂪑݂Ȃ(ĂȂ)Ƃ
	.align	4,$2048
xTable::
	.dc.l	mainExclusive
	.dcb.l	32-1,-1

;CXbh̔r
mainExclusive::
	.ds.b	xSize		;hCuǗe[u͊ɑ݂̂ŕsv

	.even
currentThreadId::
	.dc.w	0		;݂̃Xbhԍ

;----------------------------------------------------------------
;
;	t@C
;
;----------------------------------------------------------------
	.align	4
fileInfoHeapStart::
	.ds.l	1		;t@C̗̈(q[vǗ)̐擪
fileInfoHeapEnd::
	.ds.l	1		;t@C̗̈(q[vǗ)̖
fileInfoHashTablePtr::
	.ds.l	1		;nbVe[uւ̃|C^(4*256oCg)
				;e̓t@Cւ̃nh

;----------------------------------------------------------------
;
;	loadhigh֘Ã[N
;
;----------------------------------------------------------------
	.align	4,$2048
userAreaWork::
	.dc.l	0			;[U[h̃[NGA
					;(R}hCȂǂnƂgp)
execLoadHigh::
	.dc.b	0			;_EXEC_MALLOCƂloadhigh邩(-1=yes)

defaultLoadArea::
	.dc.b	0			;[ḧ̏
					;	0	ʂ̂
					;	1	ʂ̂
					;	2	eƓ̂
					;	3	eƔΑ̂
					;	4	Ȃ,ʗD
					;	5	Ȃ,ʗD
					;	6	Ȃ,eƓD
					;	7	Ȃ,eƔΑD
					;	8	Ȃ,DȂ
defaultAllocArea::
	.dc.b	0			;AP[g̈̏
					;	0	ʂ̂
					;	1	ʂ̂
					;	2	eƓ̂
					;	3	eƔΑ̂
					;	4	Ȃ,ʗD
					;	5	Ȃ,ʗD
					;	6	Ȃ,eƓD
					;	7	Ȃ,eƔΑD
					;	8	Ȃ,DȂ

;----------------------------------------------------------------
;
;	Humaño[WɈˑ萔̃[N
;
;----------------------------------------------------------------
	.align	4,$2048
killPrEntry::
	.dc.l	$0000E60C		;_KILL_PR̊Jnʒu
stdHdlDup0::
	.dc.l	$00013D1A		;Wnhϊe[u
stdHdlToFcb::
	.dc.l	$00013D24		;nhԍ=0`5̃nhFCBϊe[u
stdFcbTable::
	.dc.l	$00013D30		;FCBԍ=0`5FCBe[u

;----------------------------------------------------------------
;
;	RAMDISK֌W̃[N
;
;----------------------------------------------------------------
;----------------------------------------------------------------
;[JRAMDISK݂͈̑
;	RAMDISK̗̈ɊYy[W̓X[p[oCUی삳
	.align	4,$2048
localRamdiskAreaStart::
	.dc.l	0			;擪
localRamdiskAreaEnd::
	.dc.l	0			;+1
localRamdiskAreaSize::
	.dc.l	0			;TCY(y[WTCY̔{)

;----------------------------------------------------------------
;CRAMDISK݂͈̑
;	RAMDISK̗̈ɊYy[W̓X[p[oCUی삳
	.align	4,$2048
mainRamdiskAreaStart::
	.dc.l	0			;擪
mainRamdiskAreaEnd::
	.dc.l	0			;+1
mainRamdiskAreaSize::
	.dc.l	0			;TCY(y[WTCY̔{)

;----------------------------------------------------------------
;BPBe[ũAhX
	.align	4,$2048
bpbTablePointer::
d = 0
  .rept MAXIMUM_UNIT
	.dc.l	bpbTable+d
d = d+28
  .endm

;----------------------------------------------------------------
;BPBe[u
	.align	4,$2048
bpbTable::
  .rept MAXIMUM_UNIT
	.dc.w	1024		;+0	1ZN^̃oCg
	.dc.b	1		;+2	1NX^̃ZN^
	.dc.b	1		;+3	FAT̈̌
				;	bit7=1̂Ƃ2oCgFAT̏㉺̃oCgꊷ
	.dc.w	0		;+4	FAT̐擪ZN^ԍ
	.dc.w	ROOT_ENTRY	;+6	[gfBNgɓGg
	.dc.w	0		;+8	(S̈̃ZN^)
	.dc.b	$F9		;+10	fBAoCg
	.dc.b	1		;+11	1FAT̈ɎgpZN^
	.dc.l	DEFAULT_SIZE	;+12	S̈̃ZN^
	.dc.l	0		;+16	擪AhX(0=̃jbg݂͑Ȃ)
	.dc.l	0		;+20	AhX+1
	.dc.b	0		;+24	ANZXvgǂ
	.ds.b	3		;+25
				;+28
  .endm

;----------------------------------------------------------------
;
;	fobOpTu[`
;
;----------------------------------------------------------------
;l16i8ŕ\
;<d0.l:l
	.align	4,$2048
debugHex8::
	move.w	ccr,-(sp)
	swap.w	d0
	bsr	debugHex4
	swap.w	d0
	bsr	debugHex4
	move.w	(sp)+,ccr
	rts

;l16i4ŕ\
;<d0.w:l
	.align	4,$2048
debugHex4::
	move.w	ccr,-(sp)
	rol.w	#8,d0
	bsr	debugHex2
	rol.w	#8,d0
	bsr	debugHex2
	move.w	(sp)+,ccr
	rts

;l16i2ŕ\
;<d0.b:l
	.align	4,$2048
debugHex2::
	move.w	ccr,-(sp)
	movem.l	d1-d2,-(sp)
	moveq.l	#2-1,d2
@@:	rol.b	#4,d0
	moveq.l	#$0F,d1
	and.l	d0,d1
	move.b	(hexchar,pc,d1.l),d1
	bsr	debugPutc
	dbra	d2,@b
	movem.l	(sp)+,d1-d2
	move.w	(sp)+,ccr
	rts

hexchar:
	.dc.b	'0123456789ABCDEF'

;\
;<a1.l:̃AhX
	.align	4,$2048
debugPrint::
	move.w	ccr,-(sp)
	movem.l	d0/a1,-(sp)
	moveq.l	#$21,d0
	trap	#15
	movem.l	(sp)+,d0/a1
	move.w	(sp)+,ccr
	rts

;1\
;<d1.w:R[h
	.align	4,$2048
debugPutc::
	move.w	ccr,-(sp)
	movem.l	d0-d1,-(sp)
	moveq.l	#$20,d0
	trap	#15
	movem.l	(sp)+,d0-d1
	move.w	(sp)+,ccr
	rts

;1L[͑҂
	.align	4,$2048
debugKeyinp::
	move.w	ccr,-(sp)
	move.l	d0,-(sp)
	bra	2f
1:	moveq.l	#0,d0
	trap	#15
2:	moveq.l	#1,d0
	trap	#15
	tst.b	d0
	bne	1b
3:	moveq.l	#0,d0
	trap	#15
	tst.b	d0
	beq	3b
	move.l	(sp)+,d0
	move.w	(sp)+,ccr
	rts
