/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import javax.swing.JMenu;
import xeij.CRTC;
import xeij.MC68060;
import xeij.MainMemory;
import xeij.Mouse;
import xeij.RS232CTerminal;
import xeij.Settings;
import xeij.XEiJ;

public class Z8530 {
    public static final boolean SCC_DEBUG_ON = false;
    public static int sccDebugOn;
    public static JMenu sccDebugMenu;
    public static double sccFreq;
    public static final int SCC_0B_COMMAND = 15302657;
    public static final int SCC_0B_DATA = 15302659;
    public static final int SCC_1A_COMMAND = 15302661;
    public static final int SCC_1A_DATA = 15302663;
    public static int sccInterruptVector;
    public static int sccVectorInclude;
    public static final int SCC_0B_RECEIVE_VECTOR = 2;
    public static final int SCC_0B_RECEIVE_MASK = 4;
    public static int scc0bReceiveMask;
    public static int scc0bReceiveRR3;
    public static int scc0bReceiveRequest;
    public static int scc0bReceiveVector;
    public static final int SCC_1A_RECEIVE_VECTOR = 6;
    public static final int SCC_1A_RECEIVE_MASK = 32;
    public static int scc1aReceiveMask;
    public static int scc1aReceiveRR3;
    public static int scc1aReceiveRequest;
    public static int scc1aReceiveVector;
    public static final int SCC_1A_SEND_VECTOR = 4;
    public static final int SCC_1A_SEND_MASK = 16;
    public static int scc1aSendMask;
    public static int scc1aSendRR3;
    public static int scc1aSendRequest;
    public static int scc1aSendVector;
    public static int scc0bRegisterNumber;
    public static int scc0bRts;
    public static int scc0bBaudRateGen;
    public static int scc0bInputCounter;
    public static int scc0bData1;
    public static int scc0bData2;
    public static final boolean SCC_FSX_MOUSE = true;
    public static int sccFSXMouseHook;
    public static int sccFSXMouseWork;
    public static final int SCC_1A_INPUT_BITS = 16;
    public static final int SCC_1A_INPUT_SIZE = 65536;
    public static final int SCC_1A_INPUT_MASK = 65535;
    public static int scc1aRegisterNumber;
    public static final int[] scc1aInputBuffer;
    public static int scc1aInputRead;
    public static int scc1aInputWrite;
    public static int scc1aBRGEnable;
    public static int scc1aClockModeShift;
    public static int scc1aBaudRateGen;
    public static long scc1aInterval;
    public static int scc1aRxBits;
    public static int scc1aRxEnable;
    public static int scc1aStop;
    public static int scc1aParity;
    public static int scc1aTxBits;
    public static int scc1aTxEnable;

    public static void sccInit() {
        sccFreq = 5000000 < Settings.sgsGetInt("sccfreq") ? 7372800.0 : 5000000.0;
        Z8530.sccReset();
    }

    public static void sccTini() {
        Settings.sgsPutInt("sccfreq", (int)sccFreq);
    }

    public static void sccReset() {
        sccInterruptVector = 0;
        sccVectorInclude = 0;
        scc0bReceiveMask = 0;
        scc0bReceiveRR3 = 0;
        scc0bReceiveRequest = 0;
        scc0bReceiveVector = 0;
        scc1aReceiveMask = 0;
        scc1aReceiveRR3 = 0;
        scc1aReceiveRequest = 0;
        scc1aReceiveVector = 0;
        scc1aSendMask = 0;
        scc1aSendRR3 = 0;
        scc1aSendRequest = 0;
        scc1aSendVector = 0;
        scc0bRegisterNumber = 0;
        scc0bRts = 0;
        scc0bBaudRateGen = 31;
        scc0bInputCounter = 0;
        scc0bData1 = 0;
        scc0bData2 = 0;
        sccFSXMouseHook = 0;
        sccFSXMouseWork = 0;
        scc1aRegisterNumber = 0;
        Arrays.fill(scc1aInputBuffer, 0);
        scc1aInputRead = 0;
        scc1aInputWrite = 0;
        scc1aRxBits = 3;
        scc1aRxEnable = 0;
        scc1aStop = 1;
        scc1aParity = 0;
        scc1aTxBits = 3;
        scc1aTxEnable = 0;
        scc1aBRGEnable = 0;
        scc1aClockModeShift = 4;
        scc1aBaudRateGen = 14;
        double d = sccFreq / (double)(scc1aBaudRateGen + 2 << scc1aClockModeShift + 1);
        double d2 = 1.0 + (scc1aRxBits == 0 ? 5.0 : (scc1aRxBits == 1 ? 7.0 : (scc1aRxBits == 2 ? 6.0 : 8.0))) + ((scc1aParity & 1) == 0 ? 0.0 : 1.0) + (scc1aStop == 0 ? 0.0 : (scc1aStop == 1 ? 1.0 : (scc1aStop == 2 ? 1.5 : 2.0)));
        double d3 = d2 / d;
        scc1aInterval = Math.round(d3 * 1.0E12);
        RS232CTerminal.trmAUXReset();
    }

    public static int sccAcknowledge() {
        int n = 0;
        if (scc1aReceiveRequest != 0) {
            scc1aReceiveRequest = 0;
            n = scc1aReceiveVector;
        } else if (scc1aSendRequest != 0) {
            scc1aSendRequest = 0;
            n = scc1aSendVector;
        } else if (scc0bReceiveRequest != 0) {
            scc0bReceiveRequest = 0;
            n = scc0bReceiveVector;
        }
        return n;
    }

    public static void sccDone() {
        if ((scc1aReceiveRequest | scc1aSendRequest | scc0bReceiveRequest) != 0) {
            XEiJ.mpuIRR |= 4;
        }
    }

    public static void sccUpdateVector() {
        if (sccVectorInclude == 0) {
            scc0bReceiveVector = sccInterruptVector;
            scc1aReceiveVector = sccInterruptVector;
            scc1aSendVector = sccInterruptVector;
        } else if (sccVectorInclude == 1) {
            int n = sccInterruptVector & 0xF1;
            scc0bReceiveVector = n | 4;
            scc1aReceiveVector = n | 0xC;
            scc1aSendVector = n | 8;
        } else {
            int n = sccInterruptVector & 0x8F;
            scc0bReceiveVector = n | 0x20;
            scc1aReceiveVector = n | 0x60;
            scc1aSendVector = n | 0x40;
        }
    }

    public static int sccReadByte(int n, boolean bl) {
        XEiJ.mpuClockTime += XEiJ.busWaitTime.scc;
        int n2 = 0;
        switch (n & 7) {
            case 1: {
                switch (scc0bRegisterNumber) {
                    case 0: {
                        n2 = scc0bInputCounter < 3 ? 37 : 36;
                        break;
                    }
                    case 2: {
                        n2 = scc1aReceiveRequest != 0 ? scc1aReceiveVector : (scc1aSendRequest != 0 ? scc1aSendVector : (scc0bReceiveRequest != 0 ? scc0bReceiveVector : sccInterruptVector));
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 12: {
                        n2 = scc0bBaudRateGen & 0xFF;
                        break;
                    }
                    case 13: {
                        n2 = scc0bBaudRateGen >> 8 & 0xFF;
                        break;
                    }
                }
                if (bl) break;
                scc0bRegisterNumber = 0;
                break;
            }
            case 3: {
                if (scc0bInputCounter == 0) {
                    n2 = Mouse.musExtraData;
                    if (XEiJ.mpuClockTime < Mouse.musWheelReleaseTime) {
                        n2 |= Mouse.musWheelButton;
                    }
                    if (bl) break;
                    Mouse.musExtraData = Mouse.musData;
                    if (!Mouse.musOnScreen) {
                        if (Mouse.musCursorNumber != 1 && Mouse.musCursorAvailable) {
                            Mouse.musCursorNumber = 1;
                            XEiJ.pnlPanel.setCursor(Mouse.musCursorArray[1]);
                        }
                        scc0bData2 = 0;
                        scc0bData1 = 0;
                    } else if (Mouse.musSeamlessOn) {
                        int n3;
                        int n4;
                        byte by;
                        int n5 = 256;
                        if (XEiJ.currentMPU < 6) {
                            if (sccFSXMouseHook != 0 && MainMemory.mmrRls(2360) == sccFSXMouseHook) {
                                by = MainMemory.mmrRws(sccFSXMouseWork + 46) == 0 ? (byte)1 : 0;
                                int n6 = MainMemory.mmrRls(sccFSXMouseWork + 10);
                                n4 = (n6 >> 16) - CRTC.crtR10TxXPort;
                                n3 = (short)n6 - CRTC.crtR11TxYPort;
                                n5 = MainMemory.mmrRwz(sccFSXMouseWork + 4);
                            } else {
                                by = MainMemory.mmrRbs(2722);
                                int n7 = MainMemory.mmrRls(2766);
                                n4 = n7 >> 16;
                                n3 = n7;
                                if (Mouse.musFollowScrollOn) {
                                    n4 -= CRTC.crtR10TxXPort;
                                    n3 -= CRTC.crtR11TxYPort;
                                }
                            }
                        } else if (sccFSXMouseHook != 0 && MC68060.mmuPeekLongData(2360, 1) == sccFSXMouseHook) {
                            by = MC68060.mmuPeekWordSignData(sccFSXMouseWork + 46, 1) == 0 ? (byte)1 : 0;
                            int n8 = MC68060.mmuPeekLongData(sccFSXMouseWork + 10, 1);
                            n4 = (n8 >> 16) - CRTC.crtR10TxXPort;
                            n3 = (short)n8 - CRTC.crtR11TxYPort;
                            n5 = MC68060.mmuPeekWordZeroData(sccFSXMouseWork + 4, 1);
                        } else {
                            by = MC68060.mmuPeekByteSignData(2722, 1);
                            int n9 = MC68060.mmuPeekLongData(2766, 1);
                            n4 = n9 >> 16;
                            n3 = (short)n9;
                            if (Mouse.musFollowScrollOn) {
                                n4 -= CRTC.crtR10TxXPort;
                                n3 -= CRTC.crtR11TxYPort;
                            }
                        }
                        n4 = Mouse.musScreenX - n4;
                        n3 = Mouse.musScreenY - n3;
                        if (Mouse.musEdgeAccelerationOn) {
                            if (Mouse.musScreenX < 10) {
                                n4 = -10;
                            } else if (XEiJ.pnlScreenWidth - 10 <= Mouse.musScreenX) {
                                n4 = 10;
                            }
                            if (Mouse.musScreenY < 10) {
                                n3 = -10;
                            } else if (XEiJ.pnlScreenHeight - 10 <= Mouse.musScreenY) {
                                n3 = 10;
                            }
                        }
                        if (by != 0) {
                            if (Mouse.musCursorNumber != 0 && Mouse.musCursorAvailable) {
                                Mouse.musCursorNumber = 0;
                                XEiJ.pnlPanel.setCursor(Mouse.musCursorArray[0]);
                            }
                        } else if (Mouse.musCursorNumber != 1 && Mouse.musCursorAvailable) {
                            Mouse.musCursorNumber = 1;
                            XEiJ.pnlPanel.setCursor(Mouse.musCursorArray[1]);
                        }
                        if (n5 != 256 && n5 != 0) {
                            n4 = (n4 << 8) / n5;
                            n3 = (n3 << 8) / n5;
                        }
                        int n10 = n4 == 0 ? 0 : (scc0bData1 = n4 >= 0 ? Mouse.MUS_DEACCELERATION_TABLE[Math.min(1024, n4)] : -Mouse.MUS_DEACCELERATION_TABLE[Math.min(1024, -n4)] & 0xFF);
                        scc0bData2 = n3 == 0 ? 0 : (n3 >= 0 ? Mouse.MUS_DEACCELERATION_TABLE[Math.min(1024, n3)] : -Mouse.MUS_DEACCELERATION_TABLE[Math.min(1024, -n3)] & 0xFF);
                    } else if (!XEiJ.frmIsActive) {
                        if (Mouse.musCursorNumber != 1 && Mouse.musCursorAvailable) {
                            Mouse.musCursorNumber = 1;
                            XEiJ.pnlPanel.setCursor(Mouse.musCursorArray[1]);
                        }
                        scc0bData2 = 0;
                        scc0bData1 = 0;
                        Mouse.musExclusiveStart = true;
                    } else {
                        int n11;
                        int n12;
                        if (Mouse.musCursorNumber != 0 && Mouse.musCursorAvailable) {
                            Mouse.musCursorNumber = 0;
                            XEiJ.pnlPanel.setCursor(Mouse.musCursorArray[0]);
                        }
                        if (XEiJ.PNL_ROTATION_ON) {
                            int n13 = XEiJ.pnlScreenX1 + XEiJ.pnlScreenX2 >> 1;
                            int n14 = XEiJ.pnlScreenY1 + XEiJ.pnlScreenY2 >> 1;
                            int n15 = Mouse.musPanelX - n13;
                            int n16 = Mouse.musPanelY - n14;
                            XEiJ.rbtRobot.mouseMove(XEiJ.pnlGlobalX + n13, XEiJ.pnlGlobalY + n14);
                            n12 = (int)Math.round(XEiJ.pnlInverseL00 * (double)n15 + XEiJ.pnlInverseL01 * (double)n16);
                            n11 = (int)Math.round(XEiJ.pnlInverseL10 * (double)n15 + XEiJ.pnlInverseL11 * (double)n16);
                        } else {
                            int n17 = XEiJ.pnlScreenX1 + (XEiJ.pnlZoomWidth >> 1);
                            int n18 = XEiJ.pnlScreenY1 + (XEiJ.pnlZoomHeight >> 1);
                            XEiJ.rbtRobot.mouseMove(XEiJ.pnlGlobalX + n17, XEiJ.pnlGlobalY + n18);
                            n12 = Mouse.musPanelX - n17;
                            n11 = Mouse.musPanelY - n18;
                        }
                        if (Mouse.musExclusiveStart) {
                            n12 = 0;
                            n11 = 0;
                            Mouse.musExclusiveStart = false;
                        }
                        if (n12 != 0) {
                            if (n12 >= 0) {
                                if (127 < (n12 = n12 * Mouse.musSpeedRatioX >> 16)) {
                                    n2 |= 0x10;
                                    n12 = 127;
                                }
                            } else {
                                if ((n12 = -(-n12 * Mouse.musSpeedRatioX >> 16)) < -128) {
                                    n2 |= 0x20;
                                    n12 = -128;
                                }
                                n12 &= 0xFF;
                            }
                        }
                        if (n11 != 0) {
                            if (n11 >= 0) {
                                if (127 < (n11 = n11 * Mouse.musSpeedRatioY >> 16)) {
                                    n2 |= 0x40;
                                    n11 = 127;
                                }
                            } else {
                                if ((n11 = -(-n11 * Mouse.musSpeedRatioY >> 16)) < -128) {
                                    n2 |= 0x80;
                                    n11 = -128;
                                }
                                n11 &= 0xFF;
                            }
                        }
                        scc0bData1 = n12;
                        scc0bData2 = n11;
                    }
                    scc0bInputCounter = 1;
                    break;
                }
                if (scc0bInputCounter == 1) {
                    n2 = scc0bData1;
                    if (bl) break;
                    scc0bInputCounter = 2;
                    break;
                }
                if (scc0bInputCounter != 2) break;
                n2 = scc0bData2;
                if (bl) break;
                scc0bInputCounter = 3;
                break;
            }
            case 5: {
                switch (scc1aRegisterNumber) {
                    case 0: {
                        n2 = RS232CTerminal.trmAUXReadCommand();
                        break;
                    }
                    case 2: {
                        n2 = sccInterruptVector;
                        break;
                    }
                    case 3: {
                        n2 = scc1aReceiveRR3 | scc1aSendRR3 | scc0bReceiveRR3;
                        break;
                    }
                    case 12: {
                        n2 = scc1aBaudRateGen & 0xFF;
                        break;
                    }
                    case 13: {
                        n2 = scc1aBaudRateGen >> 8 & 0xFF;
                        break;
                    }
                }
                if (bl) break;
                scc1aRegisterNumber = 0;
                break;
            }
            case 7: {
                n2 = RS232CTerminal.trmAUXReadData();
                break;
            }
            default: {
                n2 = 255;
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void sccWriteByte(int n, int n2) {
        XEiJ.mpuClockTime += XEiJ.busWaitTime.scc;
        n2 &= 0xFF;
        switch (n & 7) {
            case 1: {
                switch (scc0bRegisterNumber) {
                    case 0: {
                        if ((n2 & 0xF0) == 0) {
                            scc0bRegisterNumber = n2;
                            return;
                        }
                        if (n2 == 56) {
                            if (scc0bReceiveRR3 == 0) return;
                            scc0bReceiveRR3 = 0;
                            if (scc0bInputCounter >= 3) return;
                            if (scc0bReceiveMask == 0) return;
                            scc0bReceiveRR3 = 4;
                            scc0bReceiveRequest = 4;
                            XEiJ.mpuIRR |= 4;
                            return;
                        }
                        if (n2 == 16) {
                            return;
                        }
                        if (n2 == 48) {
                            return;
                        }
                        if (n2 != 128) return;
                        return;
                    }
                    case 1: {
                        int n3 = scc0bReceiveMask = (n2 & 0x18) != 0 ? 4 : 0;
                        if ((n2 & 0xEC) == 0) break;
                        break;
                    }
                    case 2: {
                        sccInterruptVector = n2;
                        Z8530.sccUpdateVector();
                        break;
                    }
                    case 3: {
                        if (n2 == 192 || n2 != 193) break;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        int n4 = n2 >> 1 & 1;
                        if ((~scc0bRts & n4) != 0) {
                            scc0bInputCounter = 0;
                            if (scc0bReceiveMask != 0) {
                                scc0bReceiveRR3 = 4;
                                scc0bReceiveRequest = 4;
                                XEiJ.mpuIRR |= 4;
                            }
                        }
                        scc0bRts = n4;
                        if ((n2 & 0x75) == 96) break;
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 9: {
                        if ((n2 & 0xC0) == 64) {
                            scc0bRts = 0;
                        } else if ((n2 & 0xC0) != 128 && (n2 & 0xC0) == 192) {
                            scc0bRts = 0;
                        }
                        sccVectorInclude = n2 & 0x11;
                        Z8530.sccUpdateVector();
                        if ((n2 & 0x26) == 0) break;
                        break;
                    }
                    case 10: {
                        if (n2 != 0) break;
                        break;
                    }
                    case 11: {
                        if (n2 == 80 || n2 != 86) break;
                        break;
                    }
                    case 12: {
                        scc0bBaudRateGen = scc0bBaudRateGen & 0xFFFFFF00 | n2;
                        break;
                    }
                    case 13: {
                        scc0bBaudRateGen = n2 << 8 | scc0bBaudRateGen & 0xFF;
                        break;
                    }
                    case 14: {
                        if (n2 == 2 || n2 != 3) break;
                        break;
                    }
                    case 15: {
                        if (n2 == 0 || n2 == 128 || n2 != 136) break;
                        break;
                    }
                }
                scc0bRegisterNumber = 0;
                return;
            }
            case 3: {
                return;
            }
            case 5: {
                switch (scc1aRegisterNumber) {
                    case 0: {
                        if ((n2 & 0xF0) == 0) {
                            scc1aRegisterNumber = n2;
                            return;
                        }
                        if (n2 == 56) {
                            scc1aReceiveRR3 = 0;
                            return;
                        }
                        if (n2 == 16) {
                            return;
                        }
                        if (n2 == 48) {
                            return;
                        }
                        if (n2 != 128) return;
                        return;
                    }
                    case 1: {
                        scc1aReceiveMask = (n2 & 0x18) != 0 ? 32 : 0;
                        int n5 = scc1aSendMask = (n2 & 2) != 0 ? 16 : 0;
                        if ((n2 & 0xE3) == 0) break;
                        break;
                    }
                    case 2: {
                        sccInterruptVector = n2;
                        Z8530.sccUpdateVector();
                        break;
                    }
                    case 3: {
                        if ((n2 & 0x3E) != 0) break;
                        scc1aRxBits = n2 >> 6;
                        break;
                    }
                    case 4: {
                        scc1aClockModeShift = n2 >> 6 == 0 ? 0 : (n2 >> 6) + 3;
                        scc1aStop = n2 >> 2 & 3;
                        scc1aParity = n2 & 3;
                        break;
                    }
                    case 5: {
                        if ((n2 & 0x15) != 0) break;
                        RS232CTerminal.trmAUXSetNotReceiving((n2 & 2) == 0);
                        scc1aTxBits = n2 >> 5 & 3;
                        scc1aTxEnable = n2 >> 3 & 1;
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 9: {
                        if ((n2 & 0xC0) == 64) {
                            scc0bRts = 0;
                        } else if ((n2 & 0xC0) == 128) {
                            scc1aBRGEnable = 0;
                            scc1aRxEnable = 0;
                            scc1aTxEnable = 0;
                            RS232CTerminal.trmAUXReset();
                        } else if ((n2 & 0xC0) == 192) {
                            scc0bRts = 0;
                            scc1aBRGEnable = 0;
                            scc1aRxEnable = 0;
                            scc1aTxEnable = 0;
                            RS232CTerminal.trmAUXReset();
                        }
                        sccVectorInclude = n2 & 0x11;
                        Z8530.sccUpdateVector();
                        if ((n2 & 0x2E) == 8) break;
                        break;
                    }
                    case 10: {
                        if (n2 != 0) break;
                        break;
                    }
                    case 11: {
                        if (n2 == 80 || n2 != 86) break;
                        break;
                    }
                    case 12: {
                        scc1aBaudRateGen = scc1aBaudRateGen & 0xFFFFFF00 | n2;
                        break;
                    }
                    case 13: {
                        scc1aBaudRateGen = n2 << 8 | scc1aBaudRateGen & 0xFF;
                        break;
                    }
                    case 14: {
                        if ((n2 & 0xFE) != 2 || (scc1aBRGEnable = n2 & 1) == 0) break;
                        RS232CTerminal.trmReflectSettings(1);
                        break;
                    }
                    case 15: {
                        if (n2 == 0 || n2 == 128 || n2 != 136) break;
                        break;
                    }
                }
                scc1aRegisterNumber = 0;
                return;
            }
            case 7: {
                RS232CTerminal.trmAUXWriteData(n2);
                return;
            }
        }
    }

    static {
        sccFreq = 5000000.0;
        scc1aInputBuffer = new int[65536];
    }
}

