/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;

public class YM2151 {
    public static final int OUTPUTS = 2;
    public static final int CHANNELS = 8;
    public static final int ALL_CHANNELS = 255;
    public static final int OPERATORS = 32;
    public static final int WAVEFORMS = 1;
    public static final int REGISTERS = 256;
    public static final int DEFAULT_PRESCALE = 2;
    public static final int EG_CLOCK_DIVIDER = 3;
    public static final int CSM_TRIGGER_MASK = 255;
    public static final int REG_MODE = 20;
    public static final int STATUS_TIMERA = 1;
    public static final int STATUS_TIMERB = 2;
    public static final int STATUS_BUSY = 128;
    public static final int STATUS_IRQ = 0;
    public static final int EG_ATTACK = 1;
    public static final int EG_DECAY = 2;
    public static final int EG_SUSTAIN = 3;
    public static final int EG_RELEASE = 4;
    public static final int EG_STATES = 6;
    public static final int WAVEFORM_LENGTH = 1024;
    public static final int PHASE_STEP_DYNAMIC = 1;
    public static final int EG_QUIET = 896;
    public static final int[] s_sin_table = new int[]{2137, 1731, 1543, 1419, 1326, 1252, 1190, 1137, 1091, 1050, 1013, 979, 949, 920, 894, 869, 846, 825, 804, 785, 767, 749, 732, 717, 701, 687, 672, 659, 646, 633, 621, 609, 598, 587, 576, 566, 556, 546, 536, 527, 518, 509, 501, 492, 484, 476, 468, 461, 453, 446, 439, 432, 425, 418, 411, 405, 399, 392, 386, 380, 375, 369, 363, 358, 352, 347, 341, 336, 331, 326, 321, 316, 311, 307, 302, 297, 293, 289, 284, 280, 276, 271, 267, 263, 259, 255, 251, 248, 244, 240, 236, 233, 229, 226, 222, 219, 215, 212, 209, 205, 202, 199, 196, 193, 190, 187, 184, 181, 178, 175, 172, 169, 167, 164, 161, 159, 156, 153, 151, 148, 146, 143, 141, 138, 136, 134, 131, 129, 127, 125, 122, 120, 118, 116, 114, 112, 110, 108, 106, 104, 102, 100, 98, 96, 94, 92, 91, 89, 87, 85, 83, 82, 80, 78, 77, 75, 74, 72, 70, 69, 67, 66, 64, 63, 62, 60, 59, 57, 56, 55, 53, 52, 51, 49, 48, 47, 46, 45, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 23, 22, 21, 20, 20, 19, 18, 17, 17, 16, 15, 15, 14, 13, 13, 12, 12, 11, 10, 10, 9, 9, 8, 8, 7, 7, 7, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] s_power_table = new int[]{YM2151.X(1018), YM2151.X(1013), YM2151.X(1007), YM2151.X(1002), YM2151.X(996), YM2151.X(991), YM2151.X(986), YM2151.X(980), YM2151.X(975), YM2151.X(969), YM2151.X(964), YM2151.X(959), YM2151.X(953), YM2151.X(948), YM2151.X(942), YM2151.X(937), YM2151.X(932), YM2151.X(927), YM2151.X(921), YM2151.X(916), YM2151.X(911), YM2151.X(906), YM2151.X(900), YM2151.X(895), YM2151.X(890), YM2151.X(885), YM2151.X(880), YM2151.X(874), YM2151.X(869), YM2151.X(864), YM2151.X(859), YM2151.X(854), YM2151.X(849), YM2151.X(844), YM2151.X(839), YM2151.X(834), YM2151.X(829), YM2151.X(824), YM2151.X(819), YM2151.X(814), YM2151.X(809), YM2151.X(804), YM2151.X(799), YM2151.X(794), YM2151.X(789), YM2151.X(784), YM2151.X(779), YM2151.X(774), YM2151.X(770), YM2151.X(765), YM2151.X(760), YM2151.X(755), YM2151.X(750), YM2151.X(745), YM2151.X(741), YM2151.X(736), YM2151.X(731), YM2151.X(726), YM2151.X(722), YM2151.X(717), YM2151.X(712), YM2151.X(708), YM2151.X(703), YM2151.X(698), YM2151.X(693), YM2151.X(689), YM2151.X(684), YM2151.X(680), YM2151.X(675), YM2151.X(670), YM2151.X(666), YM2151.X(661), YM2151.X(657), YM2151.X(652), YM2151.X(648), YM2151.X(643), YM2151.X(639), YM2151.X(634), YM2151.X(630), YM2151.X(625), YM2151.X(621), YM2151.X(616), YM2151.X(612), YM2151.X(607), YM2151.X(603), YM2151.X(599), YM2151.X(594), YM2151.X(590), YM2151.X(585), YM2151.X(581), YM2151.X(577), YM2151.X(572), YM2151.X(568), YM2151.X(564), YM2151.X(560), YM2151.X(555), YM2151.X(551), YM2151.X(547), YM2151.X(542), YM2151.X(538), YM2151.X(534), YM2151.X(530), YM2151.X(526), YM2151.X(521), YM2151.X(517), YM2151.X(513), YM2151.X(509), YM2151.X(505), YM2151.X(501), YM2151.X(496), YM2151.X(492), YM2151.X(488), YM2151.X(484), YM2151.X(480), YM2151.X(476), YM2151.X(472), YM2151.X(468), YM2151.X(464), YM2151.X(460), YM2151.X(456), YM2151.X(452), YM2151.X(448), YM2151.X(444), YM2151.X(440), YM2151.X(436), YM2151.X(432), YM2151.X(428), YM2151.X(424), YM2151.X(420), YM2151.X(416), YM2151.X(412), YM2151.X(409), YM2151.X(405), YM2151.X(401), YM2151.X(397), YM2151.X(393), YM2151.X(389), YM2151.X(385), YM2151.X(382), YM2151.X(378), YM2151.X(374), YM2151.X(370), YM2151.X(367), YM2151.X(363), YM2151.X(359), YM2151.X(355), YM2151.X(352), YM2151.X(348), YM2151.X(344), YM2151.X(340), YM2151.X(337), YM2151.X(333), YM2151.X(329), YM2151.X(326), YM2151.X(322), YM2151.X(318), YM2151.X(315), YM2151.X(311), YM2151.X(308), YM2151.X(304), YM2151.X(300), YM2151.X(297), YM2151.X(293), YM2151.X(290), YM2151.X(286), YM2151.X(283), YM2151.X(279), YM2151.X(276), YM2151.X(272), YM2151.X(268), YM2151.X(265), YM2151.X(262), YM2151.X(258), YM2151.X(255), YM2151.X(251), YM2151.X(248), YM2151.X(244), YM2151.X(241), YM2151.X(237), YM2151.X(234), YM2151.X(231), YM2151.X(227), YM2151.X(224), YM2151.X(220), YM2151.X(217), YM2151.X(214), YM2151.X(210), YM2151.X(207), YM2151.X(204), YM2151.X(200), YM2151.X(197), YM2151.X(194), YM2151.X(190), YM2151.X(187), YM2151.X(184), YM2151.X(181), YM2151.X(177), YM2151.X(174), YM2151.X(171), YM2151.X(168), YM2151.X(164), YM2151.X(161), YM2151.X(158), YM2151.X(155), YM2151.X(152), YM2151.X(148), YM2151.X(145), YM2151.X(142), YM2151.X(139), YM2151.X(136), YM2151.X(133), YM2151.X(130), YM2151.X(126), YM2151.X(123), YM2151.X(120), YM2151.X(117), YM2151.X(114), YM2151.X(111), YM2151.X(108), YM2151.X(105), YM2151.X(102), YM2151.X(99), YM2151.X(96), YM2151.X(93), YM2151.X(90), YM2151.X(87), YM2151.X(84), YM2151.X(81), YM2151.X(78), YM2151.X(75), YM2151.X(72), YM2151.X(69), YM2151.X(66), YM2151.X(63), YM2151.X(60), YM2151.X(57), YM2151.X(54), YM2151.X(51), YM2151.X(48), YM2151.X(45), YM2151.X(42), YM2151.X(40), YM2151.X(37), YM2151.X(34), YM2151.X(31), YM2151.X(28), YM2151.X(25), YM2151.X(22), YM2151.X(20), YM2151.X(17), YM2151.X(14), YM2151.X(11), YM2151.X(8), YM2151.X(6), YM2151.X(3), YM2151.X(0)};
    public static final int[] s_increment_table = new int[]{0, 0, 0x10101010, 0x10101010, 0x10101010, 0x10101010, 0x11101110, 0x11101110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x10101010, 0x10111010, 0x11101110, 0x11111110, 0x11111111, 0x21112111, 0x21212121, 0x22212221, 0x22222222, 0x42224222, 0x42424242, 0x44424442, 0x44444444, -2075884476, -2071690108, -2004580220, -2004318072, -2004318072, -2004318072, -2004318072};
    public static final int[] s_detune_adjustment = new int[]{0, 0, 1, 2, 0, 0, 1, 2, 0, 0, 1, 2, 0, 0, 1, 2, 0, 1, 2, 2, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 4, 0, 1, 3, 4, 0, 1, 3, 4, 0, 1, 3, 5, 0, 2, 4, 5, 0, 2, 4, 6, 0, 2, 4, 6, 0, 2, 5, 7, 0, 2, 5, 8, 0, 3, 6, 8, 0, 3, 6, 9, 0, 3, 7, 10, 0, 4, 8, 11, 0, 4, 8, 12, 0, 4, 9, 13, 0, 5, 10, 14, 0, 5, 11, 16, 0, 6, 12, 17, 0, 6, 13, 19, 0, 7, 14, 20, 0, 8, 16, 22, 0, 8, 16, 22, 0, 8, 16, 22, 0, 8, 16, 22};
    public static final int[] s_phase_step = new int[]{41568, 41600, 41632, 41664, 41696, 41728, 41760, 41792, 41856, 41888, 41920, 41952, 42016, 42048, 42080, 42112, 42176, 42208, 42240, 42272, 42304, 42336, 42368, 42400, 42464, 42496, 42528, 42560, 42624, 42656, 42688, 42720, 42784, 42816, 42848, 42880, 42912, 42944, 42976, 43008, 43072, 43104, 43136, 43168, 43232, 43264, 43296, 43328, 43392, 43424, 43456, 43488, 43552, 43584, 43616, 43648, 43712, 43744, 43776, 43808, 43872, 43904, 43936, 43968, 44032, 44064, 44096, 44128, 44192, 44224, 44256, 44288, 44352, 44384, 44416, 44448, 44512, 44544, 44576, 44608, 44672, 44704, 44736, 44768, 44832, 44864, 44896, 44928, 44992, 45024, 45056, 45088, 45152, 45184, 45216, 45248, 45312, 45344, 45376, 45408, 45472, 45504, 45536, 45568, 45632, 45664, 45728, 45760, 45792, 45824, 45888, 45920, 45984, 46016, 46048, 46080, 46144, 46176, 46208, 46240, 46304, 46336, 46368, 46400, 46464, 46496, 46528, 46560, 46656, 46688, 46720, 46752, 46816, 46848, 46880, 46912, 46976, 47008, 47072, 47104, 47136, 47168, 47232, 47264, 47328, 47360, 47392, 47424, 47488, 47520, 47552, 47584, 47648, 47680, 47744, 47776, 47808, 47840, 47904, 47936, 48032, 48064, 48096, 48128, 48192, 48224, 48288, 48320, 48384, 48416, 48448, 48480, 48544, 48576, 48640, 48672, 48736, 48768, 48800, 48832, 48896, 48928, 48992, 49024, 49088, 49120, 49152, 49184, 49248, 49280, 49344, 49376, 49440, 49472, 49504, 49536, 49600, 49632, 49696, 49728, 49792, 49824, 49856, 49888, 49952, 49984, 50048, 50080, 50144, 50176, 50208, 50240, 50304, 50336, 50400, 50432, 50496, 50528, 50560, 50592, 50656, 50688, 50752, 50784, 50880, 50912, 50944, 50976, 51040, 51072, 51136, 51168, 51232, 51264, 51328, 51360, 51424, 51456, 51488, 51520, 51616, 51648, 51680, 51712, 51776, 51808, 51872, 51904, 51968, 52000, 52064, 52096, 52160, 52192, 52224, 52256, 52384, 52416, 52448, 52480, 52544, 52576, 52640, 52672, 52736, 52768, 52832, 52864, 52928, 52960, 52992, 53024, 53120, 53152, 53216, 53248, 53312, 53344, 53408, 53440, 53504, 53536, 53600, 53632, 53696, 53728, 53792, 53824, 53920, 53952, 54016, 54048, 54112, 54144, 54208, 54240, 54304, 54336, 54400, 54432, 54496, 54528, 54592, 54624, 54688, 54720, 54784, 54816, 54880, 54912, 54976, 55008, 55072, 55104, 55168, 55200, 55264, 55296, 55360, 55392, 55488, 55520, 55584, 55616, 55680, 55712, 55776, 55808, 55872, 55936, 55968, 56032, 56064, 56128, 56160, 56224, 56288, 56320, 56384, 56416, 56480, 56512, 56576, 56608, 56672, 56736, 56768, 56832, 56864, 56928, 56960, 57024, 57120, 57152, 57216, 57248, 57312, 57376, 57408, 57472, 57536, 57568, 57632, 57664, 57728, 57792, 57824, 57888, 57952, 57984, 58048, 58080, 58144, 58208, 58240, 58304, 58368, 58400, 58464, 58496, 58560, 58624, 58656, 58720, 58784, 58816, 58880, 58912, 58976, 59040, 59072, 59136, 59200, 59232, 59296, 59328, 59392, 59456, 59488, 59552, 59648, 59680, 59744, 59776, 59840, 59904, 59936, 60000, 60064, 60128, 60160, 60224, 60288, 60320, 60384, 60416, 60512, 60544, 60608, 60640, 60704, 60768, 60800, 60864, 60928, 60992, 61024, 61088, 61152, 61184, 61248, 61280, 61376, 61408, 61472, 61536, 61600, 61632, 61696, 61760, 61824, 61856, 61920, 61984, 62048, 62080, 62144, 62208, 62272, 62304, 62368, 62432, 62496, 62528, 62592, 62656, 62720, 62752, 62816, 62880, 62944, 62976, 63040, 63104, 63200, 63232, 63296, 63360, 63424, 63456, 63520, 63584, 63648, 63680, 63744, 63808, 63872, 63904, 63968, 64032, 64096, 64128, 64192, 64256, 64320, 64352, 64416, 64480, 64544, 64608, 64672, 64704, 64768, 64832, 64896, 64928, 65024, 65056, 65120, 65184, 65248, 65312, 65376, 65408, 65504, 65536, 65600, 65664, 65728, 65792, 65856, 65888, 65984, 66016, 66080, 66144, 66208, 66272, 66336, 66368, 66464, 66496, 66560, 66624, 66688, 66752, 66816, 66848, 66944, 66976, 67040, 67104, 67168, 67232, 67296, 67328, 67424, 67456, 67520, 67584, 67648, 67712, 67776, 67808, 67904, 67936, 68000, 68064, 68128, 68192, 68256, 68288, 68384, 68448, 68512, 68544, 68640, 68672, 68736, 68800, 68896, 68928, 68992, 69056, 69120, 69184, 69248, 69280, 69376, 69440, 69504, 69536, 69632, 69664, 69728, 69792, 69920, 69952, 70016, 70080, 70144, 70208, 70272, 70304, 70400, 70464, 70528, 70560, 70656, 70688, 70752, 70816, 70912, 70976, 71040, 71104, 71136, 71232, 71264, 71360, 71424, 71488, 71552, 71616, 71648, 71744, 71776, 71872, 71968, 72032, 72096, 72160, 72192, 72288, 72320, 72416, 72480, 72544, 72608, 72672, 72704, 72800, 72832, 72928, 72992, 73056, 73120, 73184, 73216, 73312, 73344, 73440, 73504, 73568, 73632, 73696, 73728, 73824, 73856, 73952, 74080, 74144, 74208, 74272, 74304, 74400, 74432, 74528, 74592, 74656, 74720, 74784, 74816, 74912, 74944, 75040, 75136, 75200, 75264, 75328, 75360, 75456, 75488, 75584, 75648, 75712, 75776, 75840, 75872, 75968, 76000, 76096, 76224, 76288, 76352, 76416, 76448, 76544, 76576, 76672, 76736, 76800, 76864, 76928, 77024, 77120, 77152, 77248, 77344, 77408, 77472, 77536, 77568, 77664, 77696, 77792, 77856, 77920, 77984, 78048, 78144, 78240, 78272, 78368, 78464, 78528, 78592, 78656, 78688, 78784, 78816, 78912, 78976, 79040, 79104, 79168, 79264, 79360, 79392, 79488, 79616, 79680, 79744, 79808, 79840, 79936, 79968, 80064, 80128, 80192, 80256, 80320, 80416, 80512, 80544, 80640, 80768, 80832, 80896, 80960, 80992, 81088, 81120, 81216, 81280, 81344, 81408, 81472, 81568, 81664, 81696, 81792, 81952, 82016, 82080, 82144, 82176, 82272, 82304, 82400, 82464, 82528, 82592, 82656, 82752, 82848, 82880, 82976};
    public static final int[] s_lfo_pm_shifts = new int[]{119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 114, 114, 114, 114, 119, 119, 119, 114, 114, 114, 23, 23, 119, 119, 114, 114, 23, 23, 18, 18, 119, 119, 114, 23, 23, 23, 18, 7, 119, 119, 23, 18, 7, 7, 2, 1, 119, 119, 23, 18, 7, 7, 2, 1, 119, 119, 23, 18, 7, 7, 2, 1};
    public static final int LFO_WAVEFORM_LENGTH = 256;
    public static final int[] s_fixed_map = new int[]{YM2151.operator_list(0, 16, 8, 24), YM2151.operator_list(1, 17, 9, 25), YM2151.operator_list(2, 18, 10, 26), YM2151.operator_list(3, 19, 11, 27), YM2151.operator_list(4, 20, 12, 28), YM2151.operator_list(5, 21, 13, 29), YM2151.operator_list(6, 22, 14, 30), YM2151.operator_list(7, 23, 15, 31)};
    public static final int[] s_algorithm_ops = new int[]{YM2151.ALGORITHM(1, 2, 3, 0, 0, 0), YM2151.ALGORITHM(0, 5, 3, 0, 0, 0), YM2151.ALGORITHM(0, 2, 6, 0, 0, 0), YM2151.ALGORITHM(1, 0, 7, 0, 0, 0), YM2151.ALGORITHM(1, 0, 3, 0, 1, 0), YM2151.ALGORITHM(1, 1, 1, 0, 1, 1), YM2151.ALGORITHM(1, 0, 0, 0, 1, 1), YM2151.ALGORITHM(0, 0, 0, 1, 1, 1), YM2151.ALGORITHM(1, 2, 3, 0, 0, 0), YM2151.ALGORITHM(0, 2, 3, 1, 0, 0), YM2151.ALGORITHM(1, 0, 3, 0, 1, 0), YM2151.ALGORITHM(0, 2, 0, 1, 0, 1)};
    public static final int[] s_detune2_delta = new int[]{0, 384, 500, 608};
    public static final int KEYON_NORMAL = 0;
    public static final int KEYON_RHYTHM = 1;
    public static final int KEYON_CSM = 2;
    private int m_address;
    private int m_env_counter = 0;
    private int m_status;
    private int m_clock_prescale;
    private int m_irq_mask;
    private boolean m_irq_state = false;
    private boolean[] m_timer_running;
    private int m_total_clocks;
    private int m_active_channels = 255;
    private int m_modified_channels = 255;
    private int m_prepare_count = 0;
    public fm_channel[] m_channel = new fm_channel[8];
    private fm_operator[] m_operator = new fm_operator[32];
    protected int m_lfo_counter;
    protected int m_noise_lfsr;
    protected int m_noise_counter;
    protected int m_noise_state;
    protected int m_noise_lfo;
    protected int m_lfo_am;
    protected int[] m_regdata;
    protected int[] m_lfo_waveform;
    protected int[] m_waveform;
    private Listener listener;
    private int[] buffer;
    private int pointer;
    private int channelMask;

    public static int sint8(int n) {
        return (byte)n;
    }

    public static int sint16(int n) {
        return (short)n;
    }

    public static int uint8(int n) {
        return 0xFF & n;
    }

    public static int uint16(int n) {
        return (char)n;
    }

    public static int umin32(int n, int n2) {
        return Integer.compareUnsigned(n, n2) < 0 ? n : n2;
    }

    public static int bitfield(int n, int n2) {
        return n >>> n2 & 1;
    }

    public static int bitfield(int n, int n2, int n3) {
        return n >>> n2 & (1 << n3) - 1;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static int count_leading_zeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        while (n >= 0) {
            n <<= 1;
            ++n2;
        }
        return n2;
    }

    public static int roundtrip_fp(int n) {
        if (n < Short.MIN_VALUE) {
            return YM2151.sint16(Short.MIN_VALUE);
        }
        if (n > Short.MAX_VALUE) {
            return YM2151.sint16(Short.MAX_VALUE);
        }
        int n2 = n ^ n >> 31;
        int n3 = 7 - YM2151.count_leading_zeros(n2 << 17);
        n3 = Math.max(n3, 1);
        return YM2151.sint16(n >> --n3 << n3);
    }

    private static int X(int n) {
        return (n | 0x400) << 2;
    }

    private static int operator_list(int n, int n2, int n3, int n4) {
        return n | n2 << 8 | n3 << 16 | n4 << 24;
    }

    private static int ALGORITHM(int n, int n2, int n3, int n4, int n5, int n6) {
        return n | n2 << 1 | n3 << 4 | n4 << 7 | n5 << 8 | n6 << 9;
    }

    public static int abs_sin_attenuation(int n) {
        if (YM2151.bitfield(n, 8) != 0) {
            n ^= 0xFFFFFFFF;
        }
        return s_sin_table[n & 0xFF];
    }

    public static int attenuation_to_volume(int n) {
        return s_power_table[n & 0xFF] >>> (n >>> 8);
    }

    public static int attenuation_increment(int n, int n2) {
        return YM2151.bitfield(s_increment_table[n], 4 * n2, 4);
    }

    public static int detune_adjustment(int n, int n2) {
        int n3 = s_detune_adjustment[4 * n2 + (n & 3)];
        return YM2151.bitfield(n, 2) != 0 ? -n3 : n3;
    }

    public static int opm_key_code_to_phase_step(int n, int n2) {
        int n3 = YM2151.bitfield(n, 10, 3);
        int n4 = YM2151.bitfield(n, 6, 4) - YM2151.bitfield(n, 8, 2);
        int n5 = n4 << 6 | YM2151.bitfield(n, 0, 6);
        if (Integer.compareUnsigned(n5 += n2, 768) >= 0) {
            if (n5 < 0) {
                n5 += 768;
                if (n3-- == 0) {
                    return s_phase_step[0] >>> 7;
                }
            } else {
                if ((n5 -= 768) >= 768) {
                    n5 -= 768;
                }
                int n6 = ++n3;
                ++n3;
                if (n6 >= 7) {
                    return s_phase_step[767];
                }
            }
        }
        return s_phase_step[n5] >>> (n3 ^ 7);
    }

    public static int opn_lfo_pm_phase_adjustment(int n, int n2, int n3) {
        int n4 = n3 < 0 ? -n3 : n3;
        int n5 = s_lfo_pm_shifts[8 * n2 + YM2151.bitfield(n4, 0, 3)];
        int n6 = (n >>> YM2151.bitfield(n5, 0, 4)) + (n >>> YM2151.bitfield(n5, 4, 4));
        if (n2 > 5) {
            n6 <<= n2 - 5;
        }
        return n3 < 0 ? -n6 : (n6 >>= 2);
    }

    protected static int effective_rate(int n, int n2) {
        return n == 0 ? 0 : YM2151.umin32(n + n2, 63);
    }

    public YM2151() {
        int n;
        int n2;
        int n3;
        this.m_address = YM2151.uint8(0);
        this.m_status = YM2151.uint8(0);
        this.m_clock_prescale = YM2151.uint8(2);
        this.m_irq_mask = YM2151.uint8(3);
        this.m_timer_running = new boolean[]{false, false};
        for (n3 = 0; n3 < 8; ++n3) {
            this.m_channel[n3] = new fm_channel(YM2151.channel_offset(n3));
        }
        for (n3 = 0; n3 < 32; ++n3) {
            this.m_operator[n3] = new fm_operator(YM2151.operator_offset(n3));
        }
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                n = YM2151.bitfield(s_fixed_map[n3], 8 * n2, 8);
                this.m_channel[n3].assign(n2, this.m_operator[n]);
            }
        }
        this.m_lfo_counter = 0;
        this.m_noise_lfsr = 1;
        this.m_noise_counter = YM2151.uint8(0);
        this.m_noise_state = YM2151.uint8(0);
        this.m_noise_lfo = YM2151.uint8(0);
        this.m_lfo_am = YM2151.uint8(0);
        this.m_regdata = new int[256];
        this.m_lfo_waveform = new int[1024];
        this.m_waveform = new int[1024];
        for (n3 = 0; n3 < 1024; ++n3) {
            this.m_waveform[0 + n3] = YM2151.uint16(YM2151.abs_sin_attenuation(n3) | YM2151.bitfield(n3, 9) << 15);
        }
        for (n3 = 0; n3 < 256; ++n3) {
            n2 = YM2151.uint8(n3 ^ 0xFF);
            n = YM2151.sint8(n3);
            this.m_lfo_waveform[0 + n3] = YM2151.sint16(n2 | n << 8);
            n2 = YM2151.uint8(YM2151.bitfield(n3, 7) != 0 ? 0 : 255);
            n = YM2151.sint8(n2 ^ 0x80);
            this.m_lfo_waveform[256 + n3] = YM2151.sint16(n2 | n << 8);
            n2 = YM2151.uint8(YM2151.bitfield(n3, 7) != 0 ? n3 << 1 : (n3 ^ 0xFF) << 1);
            n = YM2151.sint8(YM2151.bitfield(n3, 6) != 0 ? n2 : ~n2);
            this.m_lfo_waveform[512 + n3] = YM2151.sint16(n2 | n << 8);
            this.m_lfo_waveform[768 + n3] = YM2151.sint16(0);
        }
        this.init2();
    }

    public void reset() {
        this.set_reset_status(0, 255);
        Arrays.fill(this.m_regdata, 0, 256, YM2151.uint8(0));
        this.m_regdata[34] = this.m_regdata[35] = YM2151.uint8(192);
        this.m_regdata[33] = this.m_regdata[35];
        this.m_regdata[32] = this.m_regdata[35];
        this.m_regdata[38] = this.m_regdata[39] = YM2151.uint8(192);
        this.m_regdata[37] = this.m_regdata[39];
        this.m_regdata[36] = this.m_regdata[39];
        this.writeAddress(20);
        this.writeData(0);
        for (fm_channel object : this.m_channel) {
            object.reset();
        }
        for (fm_operator fm_operator2 : this.m_operator) {
            fm_operator2.reset();
        }
    }

    public int readStatus() {
        int n = YM2151.uint8(this.status());
        if (this.listener != null && this.listener.isBusy()) {
            n = YM2151.uint8(n | 0x80);
        }
        return YM2151.uint8(n);
    }

    public void writeAddress(int n) {
        this.m_address = n &= 0xFF;
    }

    public void writeData(int n) {
        n &= 0xFF;
        if (this.listener != null) {
            this.listener.written(this.pointer, this.m_address, n);
        }
        if (this.m_address == 20) {
            this.engine_mode_write(n);
            return;
        }
        this.m_modified_channels = 255;
        this.regs_write(this.m_address, n);
        if (this.m_address == 8) {
            int n2 = YM2151.bitfield(n, 0, 3);
            int n3 = YM2151.bitfield(n, 3, 4);
            if (n2 < 8) {
                this.m_channel[n2].keyonoff(n3, 0, n2);
            }
        }
        if (this.m_address == 27 && this.listener != null) {
            this.listener.control(n >>> 6 & 3);
        }
        this.listener.busy(32 * this.clock_prescale());
    }

    public void generate(int n) {
        while (this.pointer < n) {
            int n2;
            int n3;
            this.m_total_clocks = YM2151.uint8(this.m_total_clocks + 1);
            if (this.m_modified_channels != 0 || Integer.compareUnsigned(this.m_prepare_count++, 4096) >= 0) {
                this.m_active_channels = 0;
                for (n3 = 0; n3 < 8; ++n3) {
                    if (!this.m_channel[n3].prepare()) continue;
                    this.m_active_channels |= 1 << n3;
                }
                this.m_prepare_count = 0;
                this.m_modified_channels = 0;
            }
            if (YM2151.bitfield(++this.m_env_counter, 0, 2) == 3) {
                ++this.m_env_counter;
            }
            n3 = this.clock_noise_and_lfo();
            for (n2 = 0; n2 < 8; ++n2) {
                this.m_channel[n2].clock(this.m_env_counter, n3);
            }
            this.buffer[this.pointer] = 0;
            this.buffer[this.pointer + 1] = 0;
            n2 = this.channelMask;
            n2 &= this.m_active_channels;
            for (int i = 0; i < 8; ++i) {
                if (YM2151.bitfield(n2, i) == 0) continue;
                this.m_channel[i].output_4op(0, Short.MAX_VALUE);
            }
            this.buffer[this.pointer] = YM2151.roundtrip_fp(this.buffer[this.pointer]);
            this.buffer[this.pointer + 1] = YM2151.roundtrip_fp(this.buffer[this.pointer + 1]);
            this.pointer += 2;
        }
    }

    public int status() {
        return YM2151.uint8(this.m_status & 0xFFFFFF7F);
    }

    public int set_reset_status(int n, int n2) {
        this.m_status = YM2151.uint8((this.m_status | n) & ~(n2 | 0x80));
        this.engine_check_interrupts();
        return YM2151.uint8(this.m_status);
    }

    public void set_irq_mask(int n) {
        this.m_irq_mask = YM2151.uint8(n);
        this.engine_check_interrupts();
    }

    public int clock_prescale() {
        return this.m_clock_prescale;
    }

    public void set_clock_prescale(int n) {
        this.m_clock_prescale = YM2151.uint8(n);
    }

    public void engine_timer_expired(int n) {
        if (n == 0 && this.enable_timer_a() != 0) {
            this.set_reset_status(1, 0);
        } else if (n == 1 && this.enable_timer_b() != 0) {
            this.set_reset_status(2, 0);
        }
        if (n == 0 && this.csm() != 0) {
            for (int i = 0; i < 8; ++i) {
                if (YM2151.bitfield(255, i) == 0) continue;
                this.m_channel[i].keyonoff(1, 2, i);
                this.m_modified_channels |= 1 << i;
            }
        }
        this.m_timer_running[n] = false;
        this.update_timer(n, 1, 0);
    }

    public void engine_check_interrupts() {
        boolean bl = this.m_irq_state;
        this.m_irq_state = (this.m_status & this.m_irq_mask) != 0;
        this.m_status = this.m_irq_state ? YM2151.uint8(this.m_status | 0) : YM2151.uint8(this.m_status & 0xFFFFFFFF);
        if (bl != this.m_irq_state) {
            this.listener.irq(this.m_irq_state);
        }
    }

    public void engine_mode_write(int n) {
        this.m_modified_channels = 255;
        this.regs_write(20, n);
        int n2 = 0;
        if (this.reset_timer_b() != 0) {
            n2 = YM2151.uint8(n2 | 2);
        }
        if (this.reset_timer_a() != 0) {
            n2 = YM2151.uint8(n2 | 1);
        }
        this.set_reset_status(0, n2);
        this.updateTimerB(this.load_timer_b(), -(this.m_total_clocks & 0xF));
        this.updateTimerA(this.load_timer_a(), 0);
    }

    protected void updateTimerA(int n, int n2) {
        this.update_timer(0, n, n2);
    }

    protected void updateTimerB(int n, int n2) {
        this.update_timer(1, n, n2);
    }

    protected void update_timer(int n, int n2, int n3) {
        if (n2 != 0 && !this.m_timer_running[n]) {
            int n4 = n == 0 ? 1024 - this.timer_a_value() : 16 * (256 - this.timer_b_value());
            n4 += n3;
            if (n == 0) {
                this.listener.timerA(n4 * 32 * this.m_clock_prescale);
            } else {
                this.listener.timerB(n4 * 32 * this.m_clock_prescale);
            }
            this.m_timer_running[n] = true;
        } else if (n2 == 0) {
            if (n == 0) {
                this.listener.timerA(-1);
            } else {
                this.listener.timerB(-1);
            }
            this.m_timer_running[n] = false;
        }
    }

    public static int channel_offset(int n) {
        return n;
    }

    public static int operator_offset(int n) {
        return n;
    }

    public void regs_write(int n, int n2) {
        if (n == 25) {
            this.m_regdata[n + YM2151.bitfield((int)n2, (int)7)] = YM2151.uint8(n2);
        } else if (n != 26) {
            this.m_regdata[n] = YM2151.uint8(n2);
        }
    }

    public int clock_noise_and_lfo() {
        int n;
        int n2 = this.noise_frequency();
        for (n = 0; n < 2; ++n) {
            this.m_noise_lfsr <<= 1;
            this.m_noise_lfsr |= YM2151.bitfield(this.m_noise_lfsr, 17) ^ YM2151.bitfield(this.m_noise_lfsr, 14) ^ 1;
            this.m_noise_counter = YM2151.uint8(this.m_noise_counter + 1);
            if (Integer.compareUnsigned(this.m_noise_counter, n2) < 0) continue;
            this.m_noise_counter = YM2151.uint8(0);
            this.m_noise_state = YM2151.uint8(YM2151.bitfield(this.m_noise_lfsr, 17));
        }
        n = this.lfo_rate();
        this.m_lfo_counter += (0x10 | YM2151.bitfield(n, 0, 4)) << YM2151.bitfield(n, 4, 4);
        if (this.lfo_reset() != 0) {
            this.m_lfo_counter = 0;
        }
        int n3 = YM2151.bitfield(this.m_lfo_counter, 22, 8);
        int n4 = YM2151.bitfield(this.m_noise_lfsr, 17, 8);
        this.m_lfo_waveform[768 + (n3 + 1 & 0xFF)] = YM2151.sint16(n4 | n4 << 8);
        int n5 = this.m_lfo_waveform[256 * this.lfo_waveform() + n3];
        this.m_lfo_am = YM2151.uint8((n5 & 0xFF) * this.lfo_am_depth() >>> 7);
        return (n5 >> 8) * this.lfo_pm_depth() >> 7;
    }

    public int lfo_am_offset(int n) {
        int n2 = this.ch_lfo_am_sens(n);
        if (n2 == 0) {
            return 0;
        }
        return this.m_lfo_am << n2 - 1;
    }

    public int noise_state() {
        return this.m_noise_state;
    }

    public void cache_operator_data(int n, int n2, opdata_cache opdata_cache2) {
        opdata_cache2.waveform = this.m_waveform;
        int n3 = opdata_cache2.block_freq = this.ch_block_freq(n);
        int n4 = YM2151.bitfield(n3, 8, 5);
        opdata_cache2.detune = YM2151.detune_adjustment(this.op_detune(n2), n4);
        opdata_cache2.multiple = this.op_multiple(n2) * 2;
        if (opdata_cache2.multiple == 0) {
            opdata_cache2.multiple = 1;
        }
        opdata_cache2.phase_step = this.lfo_pm_depth() == 0 || this.ch_lfo_pm_sens(n) == 0 ? this.compute_phase_step(n, n2, opdata_cache2, 0) : 1;
        opdata_cache2.total_level = this.op_total_level(n2) << 3;
        opdata_cache2.eg_sustain = this.op_sustain_level(n2);
        opdata_cache2.eg_sustain |= opdata_cache2.eg_sustain + 1 & 0x10;
        opdata_cache2.eg_sustain <<= 5;
        int n5 = n4 >>> (this.op_ksr(n2) ^ 3);
        opdata_cache2.eg_rate[1] = YM2151.uint8(YM2151.effective_rate(this.op_attack_rate(n2) * 2, n5));
        opdata_cache2.eg_rate[2] = YM2151.uint8(YM2151.effective_rate(this.op_decay_rate(n2) * 2, n5));
        opdata_cache2.eg_rate[3] = YM2151.uint8(YM2151.effective_rate(this.op_sustain_rate(n2) * 2, n5));
        opdata_cache2.eg_rate[4] = YM2151.uint8(YM2151.effective_rate(this.op_release_rate(n2) * 4 + 2, n5));
    }

    public int compute_phase_step(int n, int n2, opdata_cache opdata_cache2, int n3) {
        int n4 = s_detune2_delta[this.op_detune2(n2)];
        int n5 = this.ch_lfo_pm_sens(n);
        if (n5 != 0) {
            n4 = n5 < 6 ? (n4 += n3 >> 6 - n5) : (n4 += n3 << n5 - 5);
        }
        int n6 = YM2151.opm_key_code_to_phase_step(opdata_cache2.block_freq, n4);
        return (n6 += opdata_cache2.detune) * opdata_cache2.multiple >>> 1;
    }

    private int regbyte(int n, int n2, int n3) {
        return YM2151.bitfield(this.m_regdata[n + 0], n2, n3);
    }

    private int regbyte(int n, int n2, int n3, int n4) {
        return YM2151.bitfield(this.m_regdata[n + n4], n2, n3);
    }

    private int regword(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.regbyte(n, n2, n3, 0) << n6 | this.regbyte(n4, n5, n6, 0);
    }

    private int regword(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.regbyte(n, n2, n3, n7) << n6 | this.regbyte(n4, n5, n6, n7);
    }

    public int test() {
        return this.regbyte(1, 0, 8);
    }

    public int lfo_reset() {
        return this.regbyte(1, 1, 1);
    }

    public int noise_frequency() {
        return this.regbyte(15, 0, 5) ^ 0x1F;
    }

    public int noise_enable() {
        return this.regbyte(15, 7, 1);
    }

    public int timer_a_value() {
        return this.regword(16, 0, 8, 17, 0, 2);
    }

    public int timer_b_value() {
        return this.regbyte(18, 0, 8);
    }

    public int csm() {
        return this.regbyte(20, 7, 1);
    }

    public int reset_timer_b() {
        return this.regbyte(20, 5, 1);
    }

    public int reset_timer_a() {
        return this.regbyte(20, 4, 1);
    }

    public int enable_timer_b() {
        return this.regbyte(20, 3, 1);
    }

    public int enable_timer_a() {
        return this.regbyte(20, 2, 1);
    }

    public int load_timer_b() {
        return this.regbyte(20, 1, 1);
    }

    public int load_timer_a() {
        return this.regbyte(20, 0, 1);
    }

    public int lfo_rate() {
        return this.regbyte(24, 0, 8);
    }

    public int lfo_am_depth() {
        return this.regbyte(25, 0, 7);
    }

    public int lfo_pm_depth() {
        return this.regbyte(26, 0, 7);
    }

    public int output_bits() {
        return this.regbyte(27, 6, 2);
    }

    public int lfo_waveform() {
        return this.regbyte(27, 0, 2);
    }

    public int ch_output_any(int n) {
        return this.regbyte(32, 6, 2, n);
    }

    public int ch_output_0(int n) {
        return this.regbyte(32, 6, 1, n);
    }

    public int ch_output_1(int n) {
        return this.regbyte(32, 7, 1, n);
    }

    public int ch_feedback(int n) {
        return this.regbyte(32, 3, 3, n);
    }

    public int ch_algorithm(int n) {
        return this.regbyte(32, 0, 3, n);
    }

    public int ch_block_freq(int n) {
        return this.regword(40, 0, 7, 48, 2, 6, n);
    }

    public int ch_lfo_pm_sens(int n) {
        return this.regbyte(56, 4, 3, n);
    }

    public int ch_lfo_am_sens(int n) {
        return this.regbyte(56, 0, 2, n);
    }

    public int op_detune(int n) {
        return this.regbyte(64, 4, 3, n);
    }

    public int op_multiple(int n) {
        return this.regbyte(64, 0, 4, n);
    }

    public int op_total_level(int n) {
        return this.regbyte(96, 0, 7, n);
    }

    public int op_ksr(int n) {
        return this.regbyte(128, 6, 2, n);
    }

    public int op_attack_rate(int n) {
        return this.regbyte(128, 0, 5, n);
    }

    public int op_lfo_am_enable(int n) {
        return this.regbyte(160, 7, 1, n);
    }

    public int op_decay_rate(int n) {
        return this.regbyte(160, 0, 5, n);
    }

    public int op_detune2(int n) {
        return this.regbyte(192, 6, 2, n);
    }

    public int op_sustain_rate(int n) {
        return this.regbyte(192, 0, 5, n);
    }

    public int op_sustain_level(int n) {
        return this.regbyte(224, 4, 4, n);
    }

    public int op_release_rate(int n) {
        return this.regbyte(224, 0, 4, n);
    }

    private void init2() {
        this.listener = null;
        this.buffer = new int[625000];
        this.pointer = 0;
        this.channelMask = 255;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void allocate(int n) {
        this.buffer = new int[n];
        Arrays.fill(this.buffer, 0);
        this.pointer = 0;
    }

    public void clear() {
        Arrays.fill(this.buffer, 0);
        this.pointer = 0;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }

    public void fill() {
        this.generate(this.buffer.length);
    }

    public void setChannelMask(int n) {
        this.channelMask = n;
    }

    public void timerAExpired() {
        this.engine_timer_expired(0);
    }

    public void timerBExpired() {
        this.engine_timer_expired(1);
    }

    class fm_channel {
        private int m_choffs;
        private int m_feedback_0;
        private int m_feedback_1;
        private int m_feedback_in;
        public fm_operator[] m_op;

        public fm_channel(int n) {
            this.m_choffs = n;
            this.m_feedback_0 = this.m_feedback_1 = YM2151.sint16(0);
            this.m_feedback_in = YM2151.sint16(0);
            this.m_op = new fm_operator[4];
        }

        public void reset() {
            this.m_feedback_0 = this.m_feedback_1 = YM2151.sint16(0);
            this.m_feedback_in = YM2151.sint16(0);
        }

        public void assign(int n, fm_operator fm_operator2) {
            this.m_op[n] = fm_operator2;
            fm_operator2.set_choffs(this.m_choffs);
        }

        public void keyonoff(int n, int n2, int n3) {
            for (int i = 0; i < 4; ++i) {
                this.m_op[i].keyonoff(YM2151.bitfield(n, i), n2);
            }
        }

        public boolean prepare() {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                if (!this.m_op[i].prepare()) continue;
                n |= 1 << i;
            }
            return n != 0;
        }

        public void clock(int n, int n2) {
            this.m_feedback_0 = YM2151.sint16(this.m_feedback_1);
            this.m_feedback_1 = YM2151.sint16(this.m_feedback_in);
            for (int i = 0; i < 4; ++i) {
                this.m_op[i].clock(n, n2);
            }
        }

        public void output_4op(int n, int n2) {
            int n3;
            int n4 = YM2151.this.lfo_am_offset(this.m_choffs);
            int n5 = 0;
            int n6 = YM2151.this.ch_feedback(this.m_choffs);
            if (n6 != 0) {
                n5 = this.m_feedback_0 + this.m_feedback_1 >> 10 - n6;
            }
            int n7 = this.m_feedback_in = YM2151.sint16(this.m_op[0].compute_volume(this.m_op[0].phase() + n5, n4));
            if (YM2151.this.ch_output_any(this.m_choffs) == 0) {
                return;
            }
            int n8 = s_algorithm_ops[YM2151.this.ch_algorithm(this.m_choffs)];
            int[] nArray = new int[8];
            nArray[0] = YM2151.sint16(0);
            nArray[1] = YM2151.sint16(n7);
            n5 = nArray[YM2151.bitfield(n8, 0, 1)] >> 1;
            nArray[2] = YM2151.sint16(this.m_op[1].compute_volume(this.m_op[1].phase() + n5, n4));
            nArray[5] = YM2151.sint16(nArray[1] + nArray[2]);
            n5 = nArray[YM2151.bitfield(n8, 1, 3)] >> 1;
            nArray[3] = YM2151.sint16(this.m_op[2].compute_volume(this.m_op[2].phase() + n5, n4));
            nArray[6] = YM2151.sint16(nArray[1] + nArray[3]);
            nArray[7] = YM2151.sint16(nArray[2] + nArray[3]);
            if (YM2151.this.noise_enable() != 0 && this.m_choffs == 7) {
                n3 = this.m_op[3].compute_noise_volume(n4);
            } else {
                n5 = nArray[YM2151.bitfield(n8, 4, 3)] >> 1;
                n3 = this.m_op[3].compute_volume(this.m_op[3].phase() + n5, n4);
            }
            n3 >>= n;
            int n9 = -n2 - 1;
            if (YM2151.bitfield(n8, 7) != 0) {
                n3 = YM2151.clamp(n3 + (nArray[1] >> n), n9, n2);
            }
            if (YM2151.bitfield(n8, 8) != 0) {
                n3 = YM2151.clamp(n3 + (nArray[2] >> n), n9, n2);
            }
            if (YM2151.bitfield(n8, 9) != 0) {
                n3 = YM2151.clamp(n3 + (nArray[3] >> n), n9, n2);
            }
            if (YM2151.this.ch_output_0(this.m_choffs) != 0) {
                int n10 = YM2151.this.pointer;
                YM2151.this.buffer[n10] = YM2151.this.buffer[n10] + n3;
            }
            if (YM2151.this.ch_output_1(this.m_choffs) != 0) {
                int n11 = YM2151.this.pointer + 1;
                YM2151.this.buffer[n11] = YM2151.this.buffer[n11] + n3;
            }
        }
    }

    class fm_operator {
        private int m_choffs = 0;
        private int m_opoffs;
        private int m_phase;
        public int m_env_attenuation;
        public int m_env_state;
        private int m_key_state;
        private int m_keyon_live;
        private opdata_cache m_cache;

        public fm_operator(int n) {
            this.m_opoffs = n;
            this.m_phase = 0;
            this.m_env_attenuation = YM2151.uint16(1023);
            this.m_env_state = 4;
            this.m_key_state = YM2151.uint8(0);
            this.m_keyon_live = YM2151.uint8(0);
            this.m_cache = new opdata_cache(YM2151.this);
        }

        public void reset() {
            this.m_phase = 0;
            this.m_env_attenuation = YM2151.uint16(1023);
            this.m_env_state = 4;
            this.m_key_state = YM2151.uint8(0);
            this.m_keyon_live = YM2151.uint8(0);
        }

        public void set_choffs(int n) {
            this.m_choffs = n;
        }

        public boolean prepare() {
            YM2151.this.cache_operator_data(this.m_choffs, this.m_opoffs, this.m_cache);
            this.clock_keystate(this.m_keyon_live != 0 ? 1 : 0);
            this.m_keyon_live = YM2151.uint8(this.m_keyon_live & 0xFFFFFFFB);
            return this.m_env_state != 4 || Integer.compareUnsigned(this.m_env_attenuation, 896) < 0;
        }

        public void clock(int n, int n2) {
            int n3;
            if (YM2151.bitfield(n, 0, 2) == 0) {
                this.clock_envelope(n >>> 2);
            }
            if ((n3 = this.m_cache.phase_step) == 1) {
                n3 = YM2151.this.compute_phase_step(this.m_choffs, this.m_opoffs, this.m_cache, n2);
            }
            this.m_phase += n3;
        }

        public int phase() {
            return this.m_phase >>> 10;
        }

        public int compute_volume(int n, int n2) {
            if (Integer.compareUnsigned(this.m_env_attenuation, 896) > 0) {
                return 0;
            }
            int n3 = this.m_cache.waveform[n & 0x3FF];
            int n4 = this.envelope_attenuation(n2) << 2;
            int n5 = YM2151.attenuation_to_volume((n3 & Short.MAX_VALUE) + n4);
            return YM2151.bitfield(n3, 15) != 0 ? -n5 : n5;
        }

        public int compute_noise_volume(int n) {
            int n2 = (this.envelope_attenuation(n) ^ 0x3FF) << 1;
            return YM2151.bitfield(YM2151.this.noise_state(), 0) != 0 ? -n2 : n2;
        }

        public void keyonoff(int n, int n2) {
            this.m_keyon_live = YM2151.uint8(this.m_keyon_live & ~(1 << n2) | YM2151.bitfield(n, 0) << n2);
        }

        private void start_attack() {
            this.start_attack(false);
        }

        private void start_attack(boolean bl) {
            if (this.m_env_state == 1) {
                return;
            }
            this.m_env_state = 1;
            if (!bl) {
                this.m_phase = 0;
            }
            if (Integer.compareUnsigned(this.m_cache.eg_rate[1], 62) >= 0) {
                this.m_env_attenuation = YM2151.uint16(0);
            }
        }

        private void start_release() {
            if (this.m_env_state >= 4) {
                return;
            }
            this.m_env_state = 4;
        }

        private void clock_keystate(int n) {
            if ((n ^ this.m_key_state) != 0) {
                this.m_key_state = YM2151.uint8(n);
                if (n != 0) {
                    this.start_attack();
                } else {
                    this.start_release();
                }
            }
        }

        private void clock_envelope(int n) {
            int n2;
            int n3;
            if (this.m_env_state == 1 && this.m_env_attenuation == 0) {
                this.m_env_state = 2;
            }
            if (this.m_env_state == 2 && Integer.compareUnsigned(this.m_env_attenuation, this.m_cache.eg_sustain) >= 0) {
                this.m_env_state = 3;
            }
            if (YM2151.bitfield(n <<= (n3 = (n2 = this.m_cache.eg_rate[this.m_env_state]) >>> 2), 0, 11) != 0) {
                return;
            }
            int n4 = YM2151.bitfield(n, n3 <= 11 ? 11 : n3, 3);
            int n5 = YM2151.attenuation_increment(n2, n4);
            if (this.m_env_state == 1) {
                if (n2 < 62) {
                    this.m_env_attenuation = YM2151.uint16(this.m_env_attenuation + (~this.m_env_attenuation * n5 >>> 4));
                }
            } else {
                this.m_env_attenuation = YM2151.uint16(this.m_env_attenuation + n5);
                if (Integer.compareUnsigned(this.m_env_attenuation, 1024) >= 0) {
                    this.m_env_attenuation = YM2151.uint16(1023);
                }
            }
        }

        private int envelope_attenuation(int n) {
            int n2 = this.m_env_attenuation >>> this.m_cache.eg_shift;
            if (YM2151.this.op_lfo_am_enable(this.m_opoffs) != 0) {
                n2 += n;
            }
            return YM2151.umin32(n2 += this.m_cache.total_level, 1023);
        }
    }

    static interface Listener {
        public void timerA(int var1);

        public void timerB(int var1);

        public void busy(int var1);

        public boolean isBusy();

        public void irq(boolean var1);

        public void control(int var1);

        public void written(int var1, int var2, int var3);
    }

    class opdata_cache {
        int[] waveform;
        int phase_step;
        int total_level;
        int block_freq;
        int detune;
        int multiple;
        int eg_sustain;
        int[] eg_rate = new int[6];
        int eg_shift = 0;

        public opdata_cache(YM2151 yM2151) {
        }
    }
}

