/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import xeij.LnF;

public class ScrollTextArea
extends JScrollPane {
    private boolean opaqueOn = true;
    private boolean gridOn = true;
    private boolean highlightCursorOn = false;
    private boolean underlineCursorOn = false;
    private Color foregroundColor = new Color(LnF.lnfRGB[14]);
    private Color backgroundColor = new Color(LnF.lnfRGB[0]);
    private Color rowGridColor = new Color(LnF.lnfRGB[2]);
    private Color columnGridColor = new Color(LnF.lnfRGB[1]);
    private Color tabColumnGridColor = new Color(LnF.lnfRGB[2]);
    private Color highlightAreaColor = new Color(LnF.lnfRGB[3]);
    private Color highlightCursorColor = new Color(LnF.lnfRGB[6]);
    private Color underlineCursorColor = new Color(LnF.lnfRGB[10]);
    private Paint gridPaint = this.backgroundColor;
    private int highlightAreaStart = -1;
    private int highlightAreaEnd = -1;
    private Stroke underlineCursorStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{0.0f, 2.0f}, 0.0f);
    private JTextArea textArea = new JTextArea(){

        @Override
        public void paintComponent(Graphics graphics) {
            Cloneable cloneable;
            Rectangle rectangle;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (ScrollTextArea.this.opaqueOn) {
                graphics2D.setPaint(ScrollTextArea.this.gridOn ? ScrollTextArea.this.gridPaint : ScrollTextArea.this.backgroundColor);
                graphics2D.fillRect(0, 0, n, n2);
            }
            ScrollTextArea.this.paintAfterBackground(this, graphics2D);
            if (0 <= ScrollTextArea.this.highlightAreaEnd) {
                try {
                    rectangle = this.modelToView2D(ScrollTextArea.this.highlightAreaStart).getBounds();
                    cloneable = this.modelToView2D(ScrollTextArea.this.highlightAreaEnd).getBounds();
                    Insets insets = this.getMargin();
                    graphics2D.setPaint(ScrollTextArea.this.highlightAreaColor);
                    graphics2D.fillRect(insets.left, rectangle.y, n - insets.left - insets.right, ((Rectangle)cloneable).y - rectangle.y + ((Rectangle)cloneable).height);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (ScrollTextArea.this.highlightCursorOn || ScrollTextArea.this.underlineCursorOn) {
                try {
                    rectangle = this.modelToView2D(this.getCaretPosition()).getBounds();
                    cloneable = this.getMargin();
                    if (ScrollTextArea.this.highlightCursorOn) {
                        graphics2D.setPaint(ScrollTextArea.this.highlightCursorColor);
                        graphics2D.fillRect(cloneable.left, rectangle.y, n - cloneable.left - cloneable.right, rectangle.height);
                    }
                    if (ScrollTextArea.this.underlineCursorOn) {
                        graphics2D.setPaint(ScrollTextArea.this.underlineCursorColor);
                        graphics2D.setStroke(ScrollTextArea.this.underlineCursorStroke);
                        graphics2D.drawLine(cloneable.left, rectangle.y + rectangle.height - 1, n - cloneable.right - 1, rectangle.y + rectangle.height - 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            super.paintComponent(graphics);
            ScrollTextArea.this.paintAfterText(this, graphics2D);
        }
    };
    private int fontWidth;
    private int fontHeight;
    private int marginTop;
    private int marginLeft;
    private DefaultCaret caret;

    public ScrollTextArea() {
        this.textArea.setOpaque(false);
        super.setOpaque(false);
        this.textArea.setForeground(this.foregroundColor);
        this.textArea.setSelectionColor(new Color(LnF.lnfRGB[7]));
        Font font = this.textArea.getFont();
        this.fontWidth = font.getSize() + 1 >> 1;
        this.fontHeight = this.textArea.getFontMetrics(font).getHeight();
        Insets insets = this.textArea.getMargin();
        this.marginTop = insets.top;
        this.marginLeft = insets.left;
        this.createGrid();
        this.caret = new DefaultCaret(){

            @Override
            protected void damage(Rectangle rectangle) {
                if (rectangle != null) {
                    if (ScrollTextArea.this.highlightCursorOn || ScrollTextArea.this.underlineCursorOn) {
                        this.x = 0;
                        this.y = rectangle.y;
                        this.width = ScrollTextArea.this.textArea.getWidth();
                        this.height = rectangle.height;
                        ScrollTextArea.this.textArea.repaint();
                    } else {
                        super.damage(rectangle);
                    }
                }
            }
        };
        this.caret.setBlinkRate(500);
        this.textArea.setCaret(this.caret);
        this.getViewport().setView(this.textArea);
    }

    public void paintAfterBackground(JTextArea jTextArea, Graphics2D graphics2D) {
    }

    public void paintAfterText(JTextArea jTextArea, Graphics2D graphics2D) {
    }

    private void createGrid() {
        int n = this.backgroundColor.getRGB();
        int n2 = this.rowGridColor.getRGB();
        int n3 = this.columnGridColor.getRGB();
        int n4 = this.tabColumnGridColor.getRGB();
        int n5 = this.fontWidth * 8;
        BufferedImage bufferedImage = new BufferedImage(n5, this.fontHeight, 1);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < this.fontHeight; ++i) {
            for (int j = 0; j < n5; ++j) {
                nArray[(this.marginLeft + j) % n5 + n5 * ((this.marginTop + i) % this.fontHeight)] = ((i ^ this.fontHeight) & 1) == 0 ? n : (i == this.fontHeight - 1 ? (((j % this.fontWidth ^ this.fontWidth) & 1) != 0 ? n2 : n) : (j == n5 - 1 ? n4 : (j % this.fontWidth == this.fontWidth - 1 ? n3 : n)));
            }
        }
        this.gridPaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, n5, this.fontHeight));
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        super.setMaximumSize(dimension);
        this.getViewport().setMaximumSize(dimension);
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
        this.getViewport().setMinimumSize(dimension);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.getViewport().setPreferredSize(dimension);
    }

    public Insets getMargin() {
        return this.textArea.getMargin();
    }

    public void setMargin(Insets insets) {
        this.textArea.setMargin(insets);
        int n = insets.top;
        int n2 = insets.left;
        if (this.marginTop != n || this.marginLeft != n2) {
            this.marginTop = n;
            this.marginLeft = n2;
            this.createGrid();
        }
    }

    @Override
    public boolean isOpaque() {
        return this.opaqueOn;
    }

    @Override
    public void setOpaque(boolean bl) {
        this.opaqueOn = bl;
    }

    @Override
    public Color getForeground() {
        return this.foregroundColor;
    }

    @Override
    public void setForeground(Color color) {
        this.foregroundColor = color;
        if (this.textArea != null) {
            this.textArea.setForeground(color);
        }
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
        if (this.textArea != null) {
            this.createGrid();
        }
    }

    @Override
    public Font getFont() {
        if (this.textArea != null) {
            return this.textArea.getFont();
        }
        return super.getFont();
    }

    @Override
    public void setFont(Font font) {
        if (this.textArea != null) {
            this.textArea.setFont(font);
            int n = font.getSize() + 1 >> 1;
            int n2 = this.textArea.getFontMetrics(font).getHeight();
            if (this.fontWidth != n || this.fontHeight != n2) {
                this.fontWidth = n;
                this.fontHeight = n2;
                this.createGrid();
            }
        }
    }

    public void addCaretListener(CaretListener caretListener) {
        this.textArea.addCaretListener(caretListener);
    }

    public void removeCaretListener(CaretListener caretListener) {
        this.textArea.removeCaretListener(caretListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.textArea.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.textArea.removeKeyListener(keyListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.textArea.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.textArea.removeMouseListener(mouseListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.textArea.addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.textArea.removeFocusListener(focusListener);
    }

    public boolean getLineWrap() {
        return this.textArea.getLineWrap();
    }

    public void setLineWrap(boolean bl) {
        this.textArea.setLineWrap(bl);
    }

    public Color getCaretColor() {
        return this.textArea.getCaretColor();
    }

    public void setCaretColor(Color color) {
        this.textArea.setCaretColor(color);
    }

    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this.textArea.setCaretPosition(n);
    }

    public boolean isCaretVisible() {
        return this.caret.isVisible();
    }

    public void setCaretVisible(boolean bl) {
        this.caret.setVisible(bl);
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String string) {
        this.highlightAreaEnd = -1;
        this.textArea.setText(string);
    }

    public void append(String string) {
        this.highlightAreaEnd = -1;
        this.textArea.append(string);
    }

    public void insert(String string, int n) {
        this.highlightAreaEnd = -1;
        this.textArea.insert(string, n);
    }

    public void replaceRange(String string, int n, int n2) {
        this.highlightAreaEnd = -1;
        this.textArea.replaceRange(string, n, n2);
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    public int getSelectionStart() {
        return this.textArea.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textArea.getSelectionEnd();
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public boolean isGridOn() {
        return this.gridOn;
    }

    public void setGridOn(boolean bl) {
        this.gridOn = bl;
    }

    public Color getRowGridColor() {
        return this.rowGridColor;
    }

    public void setRowGridColor(Color color) {
        this.rowGridColor = color;
        this.createGrid();
    }

    public Color getColumnGridColor() {
        return this.columnGridColor;
    }

    public void setColumnGridColor(Color color) {
        this.columnGridColor = color;
        this.createGrid();
    }

    public Color getTabColumnGridColor() {
        return this.tabColumnGridColor;
    }

    public void setTabColumnGridColor(Color color) {
        this.tabColumnGridColor = color;
        this.createGrid();
    }

    public void setHighlightArea(int n, int n2) {
        this.highlightAreaStart = n;
        this.highlightAreaEnd = n2;
    }

    public boolean isHighlightCursorOn() {
        return this.highlightCursorOn;
    }

    public void setHighlightCursorOn(boolean bl) {
        this.highlightCursorOn = bl;
    }

    public Color getHighlightCursorColor() {
        return this.highlightCursorColor;
    }

    public void setHighlightCursorColor(Color color) {
        this.highlightCursorColor = color;
    }

    public boolean isUnderlineCursorOn() {
        return this.underlineCursorOn;
    }

    public void setUnderlineCursorOn(boolean bl) {
        this.underlineCursorOn = bl;
    }

    public Color getUnderlineCursorColor() {
        return this.underlineCursorColor;
    }

    public void setUnderlineCursorColor(Color color) {
        this.underlineCursorColor = color;
    }
}

