/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.CRTC;
import xeij.ComponentFactory;
import xeij.DecimalSpinner;
import xeij.LnF;
import xeij.Multilingual;
import xeij.RasterBreakPoint;
import xeij.RestorableFrame;
import xeij.SpriteScreen;
import xeij.VideoController;
import xeij.XEiJ;

public class ScreenModeTest {
    public static final boolean SMT_ON = true;
    public static final int SMT_MARGIN = 4;
    public static final int SMT_ITEM_GAP = 4;
    public static final int SMT_ITEM_GAP_2 = 8;
    public static final int SMT_ITEM_GAP_3 = 12;
    public static JFrame smtFrame;
    public static JTextField smtFreqTextField;
    public static String smtFreqLastText;
    public static JTextField smtModeTextField;
    public static final int SMT_MODE_LIMIT = 6;
    public static final int SMT_MODE_SPAN = 5;
    public static final String[] smtModeName;
    public static final long[] smtModeTime;
    public static int smtModeCount;
    public static boolean smtPatternTestOn;
    public static boolean smtPatternTestSpriteOn;
    public static SMTItem[] smtItemArray;
    public static SMTGroup smtCRTItemGroup1;
    public static SMTItem smtItemCrtHFEd;
    public static SMTItem smtItemCrtHSEd;
    public static SMTItem smtItemCrtHBEd;
    public static SMTItem smtItemCrtHDEd;
    public static SMTItem smtItemCrtVFEd;
    public static SMTItem smtItemCrtVSEd;
    public static SMTItem smtItemCrtVBEd;
    public static SMTItem smtItemCrtVDEd;
    public static SMTGroup smtCRTItemGroup2;
    public static SMTItem smtItemCrtIRQ;
    public static SMTItem smtItemCrtTxX;
    public static SMTItem smtItemCrtTxY;
    public static SMTItem smtItemCrtGrMM;
    public static SMTItem smtItemCrtHigh;
    public static SMTItem smtItemCrtVRes;
    public static SMTItem smtItemCrtHRes;
    public static SMTItem smtItemSysHRL;
    public static SMTItem smtItemSysCont;
    public static SMTGroup smtCRTItemGroup3;
    public static SMTItem smtItemCrtGr0X;
    public static SMTItem smtItemCrtGr0Y;
    public static SMTItem smtItemCrtGr1X;
    public static SMTItem smtItemCrtGr1Y;
    public static SMTItem smtItemCrtGr2X;
    public static SMTItem smtItemCrtGr2Y;
    public static SMTItem smtItemCrtGr3X;
    public static SMTItem smtItemCrtGr3Y;
    public static SMTGroup smtVcnItemGroup1;
    public static SMTItem smtItemVcnGrMM;
    public static SMTItem smtItemVcnSpPr;
    public static SMTItem smtItemVcnTxPr;
    public static SMTItem smtItemVcnGrPr;
    public static SMTItem smtItemVcnG4th;
    public static SMTItem smtItemVcnG3rd;
    public static SMTItem smtItemVcnG2nd;
    public static SMTItem smtItemVcnG1st;
    public static SMTGroup smtVcnItemGroup2;
    public static SMTItem smtItemVcnAHOn;
    public static SMTItem smtItemVcnExOn;
    public static SMTItem smtItemVcnHalf;
    public static SMTItem smtItemVcnPLSB;
    public static SMTItem smtItemVcnGrGr;
    public static SMTItem smtItemVcnGrST;
    public static SMTItem smtItemVcnSpOn;
    public static SMTItem smtItemVcnTxOn;
    public static SMTItem smtItemVcnGxOn;
    public static SMTItem smtItemVcnG4On;
    public static SMTItem smtItemVcnG3On;
    public static SMTItem smtItemVcnG2On;
    public static SMTItem smtItemVcnG1On;
    public static SMTGroup smtSprItemGroup1;
    public static SMTItem smtItemSprBg0X;
    public static SMTItem smtItemSprBg0Y;
    public static SMTItem smtItemSprBg1X;
    public static SMTItem smtItemSprBg1Y;
    public static SMTItem smtItemSprDisp;
    public static SMTItem smtItemSprB1Tx;
    public static SMTItem smtItemSprB1On;
    public static SMTItem smtItemSprB0Tx;
    public static SMTItem smtItemSprB0On;
    public static SMTGroup smtSprItemGroup2;
    public static SMTItem smtItemSprHFEd;
    public static SMTItem smtItemSprHBEd;
    public static SMTItem smtItemSprVBEd;
    public static SMTItem smtItemSprHigh;
    public static SMTItem smtItemSprVRes;
    public static SMTItem smtItemSprHRes;
    public static final int SMT_INTERVAL = 10;
    public static int smtTimer;

    public static void smtInit() {
        smtFrame = null;
        smtFreqLastText = "";
        smtModeCount = 0;
        smtPatternTestOn = false;
        smtPatternTestSpriteOn = false;
        smtTimer = 0;
    }

    public static void smtStart() {
        if (RestorableFrame.rfmGetOpened("smt")) {
            ScreenModeTest.smtOpen();
        }
    }

    public static void smtOpen() {
        if (smtFrame == null) {
            ScreenModeTest.smtMakeFrame();
        } else {
            ScreenModeTest.smtUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x80;
        XEiJ.pnlExitFullScreen(false);
        smtFrame.setVisible(true);
    }

    public static void smtMakeFrame() {
        smtItemCrtHFEd = new SMTItem_CrtHFEd();
        smtItemCrtHSEd = new SMTItem_CrtHSEd();
        smtItemCrtHBEd = new SMTItem_CrtHBEd();
        smtItemCrtHDEd = new SMTItem_CrtHDEd();
        smtItemCrtVFEd = new SMTItem_CrtVFEd();
        smtItemCrtVSEd = new SMTItem_CrtVSEd();
        smtItemCrtVBEd = new SMTItem_CrtVBEd();
        smtItemCrtVDEd = new SMTItem_CrtVDEd();
        smtItemCrtIRQ = new SMTItem_CrtIRQ();
        smtItemCrtTxX = new SMTItem_CrtTxX();
        smtItemCrtTxY = new SMTItem_CrtTxY();
        smtItemCrtGrMM = new SMTItem_CrtGrMM();
        smtItemCrtHigh = new SMTItem_CrtHigh();
        smtItemCrtVRes = new SMTItem_CrtVRes();
        smtItemCrtHRes = new SMTItem_CrtHRes();
        smtItemSysHRL = new SMTItem_SysHRL();
        smtItemSysCont = new SMTItem_SysCont();
        smtItemCrtGr0X = new SMTItem_CrtGr0X();
        smtItemCrtGr0Y = new SMTItem_CrtGr0Y();
        smtItemCrtGr1X = new SMTItem_CrtGr1X();
        smtItemCrtGr1Y = new SMTItem_CrtGr1Y();
        smtItemCrtGr2X = new SMTItem_CrtGr2X();
        smtItemCrtGr2Y = new SMTItem_CrtGr2Y();
        smtItemCrtGr3X = new SMTItem_CrtGr3X();
        smtItemCrtGr3Y = new SMTItem_CrtGr3Y();
        smtItemVcnGrMM = new SMTItem_VcnGrMM();
        smtItemVcnSpPr = new SMTItem_VcnSpPr();
        smtItemVcnTxPr = new SMTItem_VcnTxPr();
        smtItemVcnGrPr = new SMTItem_VcnGrPr();
        smtItemVcnG4th = new SMTItem_VcnG4th();
        smtItemVcnG3rd = new SMTItem_VcnG3rd();
        smtItemVcnG2nd = new SMTItem_VcnG2nd();
        smtItemVcnG1st = new SMTItem_VcnG1st();
        smtItemVcnAHOn = new SMTItem_VcnAHOn();
        smtItemVcnExOn = new SMTItem_VcnExOn();
        smtItemVcnHalf = new SMTItem_VcnHalf();
        smtItemVcnPLSB = new SMTItem_VcnPLSB();
        smtItemVcnGrGr = new SMTItem_VcnGrGr();
        smtItemVcnGrST = new SMTItem_VcnGrST();
        smtItemVcnSpOn = new SMTItem_VcnSpOn();
        smtItemVcnTxOn = new SMTItem_VcnTxOn();
        smtItemVcnGxOn = new SMTItem_VcnGxOn();
        smtItemVcnG4On = new SMTItem_VcnG4On();
        smtItemVcnG3On = new SMTItem_VcnG3On();
        smtItemVcnG2On = new SMTItem_VcnG2On();
        smtItemVcnG1On = new SMTItem_VcnG1On();
        smtItemSprBg0X = new SMTItem_SprBg0X();
        smtItemSprBg0Y = new SMTItem_SprBg0Y();
        smtItemSprBg1X = new SMTItem_SprBg1X();
        smtItemSprBg1Y = new SMTItem_SprBg1Y();
        smtItemSprDisp = new SMTItem_SprDisp();
        smtItemSprB1Tx = new SMTItem_SprB1Tx();
        smtItemSprB1On = new SMTItem_SprB1On();
        smtItemSprB0Tx = new SMTItem_SprB0Tx();
        smtItemSprB0On = new SMTItem_SprB0On();
        smtItemSprHFEd = new SMTItem_SprHFEd();
        smtItemSprHBEd = new SMTItem_SprHBEd();
        smtItemSprVBEd = new SMTItem_SprVBEd();
        smtItemSprHigh = new SMTItem_SprHigh();
        smtItemSprVRes = new SMTItem_SprVRes();
        smtItemSprHRes = new SMTItem_SprHRes();
        smtItemArray = new SMTItem[]{smtItemCrtHFEd, smtItemCrtHSEd, smtItemCrtHBEd, smtItemCrtHDEd, smtItemCrtVFEd, smtItemCrtVSEd, smtItemCrtVBEd, smtItemCrtVDEd, smtItemCrtIRQ, smtItemCrtTxX, smtItemCrtTxY, smtItemCrtGrMM, smtItemCrtHigh, smtItemCrtVRes, smtItemCrtHRes, smtItemSysHRL, smtItemSysCont, smtItemCrtGr0X, smtItemCrtGr0Y, smtItemCrtGr1X, smtItemCrtGr1Y, smtItemCrtGr2X, smtItemCrtGr2Y, smtItemCrtGr3X, smtItemCrtGr3Y, smtItemVcnGrMM, smtItemVcnSpPr, smtItemVcnTxPr, smtItemVcnGrPr, smtItemVcnG4th, smtItemVcnG3rd, smtItemVcnG2nd, smtItemVcnG1st, smtItemVcnAHOn, smtItemVcnExOn, smtItemVcnHalf, smtItemVcnPLSB, smtItemVcnGrGr, smtItemVcnGrST, smtItemVcnSpOn, smtItemVcnTxOn, smtItemVcnGxOn, smtItemVcnG4On, smtItemVcnG3On, smtItemVcnG2On, smtItemVcnG1On, smtItemSprBg0X, smtItemSprBg0Y, smtItemSprBg1X, smtItemSprBg1Y, smtItemSprDisp, smtItemSprB1Tx, smtItemSprB1On, smtItemSprB0Tx, smtItemSprB0On, smtItemSprHFEd, smtItemSprHBEd, smtItemSprVBEd, smtItemSprHigh, smtItemSprVRes, smtItemSprHRes};
        smtCRTItemGroup1 = new SMTGroup(smtItemCrtHFEd, smtItemCrtHSEd, smtItemCrtHBEd, smtItemCrtHDEd, smtItemCrtVFEd, smtItemCrtVSEd, smtItemCrtVBEd, smtItemCrtVDEd);
        smtCRTItemGroup2 = new SMTGroup(smtItemCrtIRQ, smtItemCrtTxX, smtItemCrtTxY, smtItemCrtGrMM, smtItemCrtHigh, smtItemCrtVRes, smtItemCrtHRes, smtItemSysHRL, smtItemSysCont);
        smtCRTItemGroup3 = new SMTGroup(smtItemCrtGr0X, smtItemCrtGr0Y, smtItemCrtGr1X, smtItemCrtGr1Y, smtItemCrtGr2X, smtItemCrtGr2Y, smtItemCrtGr3X, smtItemCrtGr3Y);
        smtVcnItemGroup1 = new SMTGroup(smtItemVcnGrMM, smtItemVcnSpPr, smtItemVcnTxPr, smtItemVcnGrPr, smtItemVcnG4th, smtItemVcnG3rd, smtItemVcnG2nd, smtItemVcnG1st);
        smtVcnItemGroup2 = new SMTGroup(smtItemVcnAHOn, smtItemVcnExOn, smtItemVcnHalf, smtItemVcnPLSB, smtItemVcnGrGr, smtItemVcnGrST, smtItemVcnSpOn, smtItemVcnTxOn, smtItemVcnGxOn, smtItemVcnG4On, smtItemVcnG3On, smtItemVcnG2On, smtItemVcnG1On);
        smtSprItemGroup1 = new SMTGroup(smtItemSprBg0X, smtItemSprBg0Y, smtItemSprBg1X, smtItemSprBg1Y, smtItemSprDisp, smtItemSprB1Tx, smtItemSprB1On, smtItemSprB0Tx, smtItemSprB0On);
        smtSprItemGroup2 = new SMTGroup(smtItemSprHFEd, smtItemSprHBEd, smtItemSprVBEd, smtItemSprHigh, smtItemSprVRes, smtItemSprHRes);
        Component[] componentArray = new Component[5];
        componentArray[0] = Box.createVerticalStrut(4);
        Component[] componentArray2 = new Component[3];
        componentArray2[0] = Box.createHorizontalStrut(4);
        Component[] componentArray3 = new Component[4];
        Component[] componentArray4 = new Component[1];
        smtFreqTextField = ComponentFactory.setEditable(ComponentFactory.setHorizontalAlignment(ComponentFactory.createTextField("", 30), 0), false);
        componentArray4[0] = smtFreqTextField;
        componentArray3[0] = ComponentFactory.createHorizontalBox(componentArray4);
        componentArray3[1] = ComponentFactory.createHorizontalBox(ScreenModeTest.smtCRTItemGroup1.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemCrtHFEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtHSEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtHBEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtHDEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtVFEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtVSEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtVBEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtVDEd.smiBox, Box.createHorizontalGlue());
        componentArray3[2] = ComponentFactory.createHorizontalBox(ScreenModeTest.smtCRTItemGroup2.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemCrtIRQ.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtTxX.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtTxY.smiBox, Box.createHorizontalStrut(12), ScreenModeTest.smtItemCrtGrMM.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtHigh.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtVRes.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtHRes.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSysHRL.smiBox, Box.createHorizontalStrut(12), ScreenModeTest.smtItemSysCont.smiBox, Box.createHorizontalGlue());
        componentArray3[3] = ComponentFactory.createHorizontalBox(ScreenModeTest.smtCRTItemGroup3.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemCrtGr0X.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr0Y.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr1X.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr1Y.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr2X.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr2Y.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr3X.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemCrtGr3Y.smiBox, Box.createHorizontalGlue());
        componentArray2[1] = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createVerticalBox(componentArray3), "CRTC / System port"), "ja", "CRTC / \u30b7\u30b9\u30c6\u30e0\u30dd\u30fc\u30c8");
        componentArray2[2] = Box.createHorizontalStrut(4);
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
        Component[] componentArray5 = new Component[3];
        componentArray5[0] = Box.createHorizontalStrut(4);
        Component[] componentArray6 = new Component[3];
        Component[] componentArray7 = new Component[1];
        smtModeTextField = ComponentFactory.setEditable(ComponentFactory.setHorizontalAlignment(ComponentFactory.createTextField("", 30), 0), false);
        componentArray7[0] = smtModeTextField;
        componentArray6[0] = ComponentFactory.createHorizontalBox(componentArray7);
        componentArray6[1] = ComponentFactory.createHorizontalBox(ScreenModeTest.smtVcnItemGroup1.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemVcnGrMM.smiBox, Box.createHorizontalStrut(12), ScreenModeTest.smtItemVcnSpPr.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnTxPr.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnGrPr.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG4th.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG3rd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG2nd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG1st.smiBox, Box.createHorizontalGlue());
        componentArray6[2] = ComponentFactory.createHorizontalBox(ScreenModeTest.smtVcnItemGroup2.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemVcnAHOn.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnExOn.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnHalf.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnPLSB.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnGrGr.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnGrST.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnSpOn.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnTxOn.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnGxOn.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG4On.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG3On.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG2On.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemVcnG1On.smiBox, Box.createHorizontalGlue());
        componentArray5[1] = Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createVerticalBox(componentArray6), "Video Controller"), "ja", "\u30d3\u30c7\u30aa\u30b3\u30f3\u30c8\u30ed\u30fc\u30e9");
        componentArray5[2] = Box.createHorizontalStrut(4);
        componentArray[2] = ComponentFactory.createHorizontalBox(componentArray5);
        componentArray[3] = ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(4), Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createVerticalBox(ComponentFactory.createHorizontalBox(ScreenModeTest.smtSprItemGroup1.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemSprBg0X.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprBg0Y.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprBg1X.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprBg1Y.smiBox, Box.createHorizontalStrut(12), ScreenModeTest.smtItemSprDisp.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprB1Tx.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprB1On.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprB0Tx.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprB0On.smiBox, Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(ScreenModeTest.smtSprItemGroup2.smgBox, Box.createHorizontalStrut(8), ScreenModeTest.smtItemSprHFEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprHBEd.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprVBEd.smiBox, Box.createHorizontalStrut(12), ScreenModeTest.smtItemSprHigh.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprVRes.smiBox, Box.createHorizontalStrut(4), ScreenModeTest.smtItemSprHRes.smiBox, Box.createHorizontalGlue(), ComponentFactory.createVerticalBox(Box.createVerticalGlue(), ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createCheckBox(smtPatternTestOn, "Pattern Test", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScreenModeTest.smtSetPatternTestOn(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        }), "ja", "\u30d1\u30bf\u30fc\u30f3\u30c6\u30b9\u30c8")), ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createCheckBox(smtPatternTestSpriteOn, "Sprite Number", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScreenModeTest.smtSetPatternTestSpriteOn(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        }), "ja", "\u30b9\u30d7\u30e9\u30a4\u30c8\u756a\u53f7")), Box.createVerticalGlue()))), "Sprite Controller"), "ja", "\u30b9\u30d7\u30e9\u30a4\u30c8\u30b3\u30f3\u30c8\u30ed\u30fc\u30e9"), Box.createHorizontalStrut(4));
        componentArray[4] = Box.createVerticalStrut(4);
        smtFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("smt", "Screen Mode Test", null, ComponentFactory.createVerticalBox(componentArray)), "ja", "\u8868\u793a\u30e2\u30fc\u30c9\u30c6\u30b9\u30c8");
        ComponentFactory.addListener(smtFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFF7F;
            }
        });
    }

    public static void smtSetPatternTestOn(boolean bl) {
        if (smtPatternTestOn != bl) {
            smtPatternTestOn = bl;
            if (bl) {
                SpriteScreen.sprPatCurr = SpriteScreen.sprPatTest;
                SpriteScreen.sprColCurr = SpriteScreen.sprColTest;
                SpriteScreen.sprTColCurr = SpriteScreen.sprTColTest;
                VideoController.vcnPal16TS = VideoController.vcnPal16TSTest;
            } else {
                SpriteScreen.sprPatCurr = SpriteScreen.sprPatPort;
                SpriteScreen.sprColCurr = SpriteScreen.sprColPort;
                SpriteScreen.sprTColCurr = SpriteScreen.sprTColPort;
                VideoController.vcnPal16TS = VideoController.vcnPal16TSPort;
            }
            for (int i = 0; i < 256; ++i) {
                VideoController.vcnPal32TS[i] = VideoController.vcnPalTbl[VideoController.vcnPal16TS[i]];
            }
            CRTC.crtAllStamp += 2;
            if (XEiJ.mpuTask == null) {
                CRTC.crtRepaint();
            }
        }
    }

    public static void smtSetPatternTestSpriteOn(boolean bl) {
        if (smtPatternTestSpriteOn != bl) {
            smtPatternTestSpriteOn = bl;
            SpriteScreen.sprNumCurr = bl ? SpriteScreen.sprNumTest : SpriteScreen.sprNumPort;
            CRTC.crtAllStamp += 2;
            if (XEiJ.mpuTask == null) {
                CRTC.crtRepaint();
            }
        }
    }

    public static void smtUpdateFrame() {
        if (smtFrame == null) {
            return;
        }
        ScreenModeTest.smtUpdateFreq();
        ScreenModeTest.smtUpdateMode();
        smtItemCrtHFEd.smiSetPortValue(CRTC.crtR00HFrontEndPort);
        smtItemCrtHSEd.smiSetPortValue(CRTC.crtR01HSyncEndPort);
        smtItemCrtHBEd.smiSetPortValue(CRTC.crtR02HBackEndPort);
        smtItemCrtHDEd.smiSetPortValue(CRTC.crtR03HDispEndPort);
        smtItemCrtVFEd.smiSetPortValue(CRTC.crtR04VFrontEndPort);
        smtItemCrtVSEd.smiSetPortValue(CRTC.crtR05VSyncEndPort);
        smtItemCrtVBEd.smiSetPortValue(CRTC.crtR06VBackEndPort);
        smtItemCrtVDEd.smiSetPortValue(CRTC.crtR07VDispEndPort);
        smtItemCrtIRQ.smiSetPortValue(CRTC.crtR09IRQRasterPort);
        smtItemCrtTxX.smiSetPortValue(CRTC.crtR10TxXPort);
        smtItemCrtTxY.smiSetPortValue(CRTC.crtR11TxYPort);
        smtItemCrtGrMM.smiSetPortValue(CRTC.crtMemoryModePort);
        smtItemCrtHigh.smiSetPortValue(CRTC.crtHighResoPort);
        smtItemCrtVRes.smiSetPortValue(CRTC.crtVResoPort);
        smtItemCrtHRes.smiSetPortValue(CRTC.crtHResoPort);
        smtItemSysHRL.smiSetPortValue(CRTC.crtHRLPort);
        smtItemSysCont.smiSetPortValue(VideoController.vcnTargetContrastPort);
        smtItemCrtGr0X.smiSetPortValue(CRTC.crtR12GrXPort[0]);
        smtItemCrtGr0Y.smiSetPortValue(CRTC.crtR13GrYPort[0]);
        smtItemCrtGr1X.smiSetPortValue(CRTC.crtR12GrXPort[1]);
        smtItemCrtGr1Y.smiSetPortValue(CRTC.crtR13GrYPort[1]);
        smtItemCrtGr2X.smiSetPortValue(CRTC.crtR12GrXPort[2]);
        smtItemCrtGr2Y.smiSetPortValue(CRTC.crtR13GrYPort[2]);
        smtItemCrtGr3X.smiSetPortValue(CRTC.crtR12GrXPort[3]);
        smtItemCrtGr3Y.smiSetPortValue(CRTC.crtR13GrYPort[3]);
        smtItemVcnGrMM.smiSetPortValue(VideoController.vcnReg1Port);
        smtItemVcnSpPr.smiSetPortValue(VideoController.vcnReg2Port >> 12);
        smtItemVcnTxPr.smiSetPortValue(VideoController.vcnReg2Port >> 10);
        smtItemVcnGrPr.smiSetPortValue(VideoController.vcnReg2Port >> 8);
        smtItemVcnG4th.smiSetPortValue(VideoController.vcnReg2Port >> 6);
        smtItemVcnG3rd.smiSetPortValue(VideoController.vcnReg2Port >> 4);
        smtItemVcnG2nd.smiSetPortValue(VideoController.vcnReg2Port >> 2);
        smtItemVcnG1st.smiSetPortValue(VideoController.vcnReg2Port);
        smtItemVcnAHOn.smiSetPortValue(VideoController.vcnReg3Port >> 14);
        smtItemVcnExOn.smiSetPortValue(VideoController.vcnReg3Port >> 12);
        smtItemVcnHalf.smiSetPortValue(VideoController.vcnReg3Port >> 11);
        smtItemVcnPLSB.smiSetPortValue(VideoController.vcnReg3Port >> 10);
        smtItemVcnGrGr.smiSetPortValue(VideoController.vcnReg3Port >> 9);
        smtItemVcnGrST.smiSetPortValue(VideoController.vcnReg3Port >> 8);
        smtItemVcnSpOn.smiSetPortValue(VideoController.vcnReg3Port >> 6);
        smtItemVcnTxOn.smiSetPortValue(VideoController.vcnReg3Port >> 5);
        smtItemVcnGxOn.smiSetPortValue(VideoController.vcnReg3Port >> 4);
        smtItemVcnG4On.smiSetPortValue(VideoController.vcnReg3Port >> 3);
        smtItemVcnG3On.smiSetPortValue(VideoController.vcnReg3Port >> 2);
        smtItemVcnG2On.smiSetPortValue(VideoController.vcnReg3Port >> 1);
        smtItemVcnG1On.smiSetPortValue(VideoController.vcnReg3Port);
        smtItemSprBg0X.smiSetPortValue(SpriteScreen.sprReg0Bg0XPort);
        smtItemSprBg0Y.smiSetPortValue(SpriteScreen.sprReg1Bg0YPort);
        smtItemSprBg1X.smiSetPortValue(SpriteScreen.sprReg2Bg1XPort);
        smtItemSprBg1Y.smiSetPortValue(SpriteScreen.sprReg3Bg1YPort);
        smtItemSprDisp.smiSetPortValue(SpriteScreen.sprReg4BgCtrlPort >> 9);
        smtItemSprB1Tx.smiSetPortValue(SpriteScreen.sprReg4BgCtrlPort >> 4);
        smtItemSprB1On.smiSetPortValue(SpriteScreen.sprReg4BgCtrlPort >> 3);
        smtItemSprB0Tx.smiSetPortValue(SpriteScreen.sprReg4BgCtrlPort >> 1);
        smtItemSprB0On.smiSetPortValue(SpriteScreen.sprReg4BgCtrlPort);
        smtItemSprHFEd.smiSetPortValue(SpriteScreen.sprReg5HFrontEndPort);
        smtItemSprHBEd.smiSetPortValue(SpriteScreen.sprReg6HBackEndPort);
        smtItemSprVBEd.smiSetPortValue(SpriteScreen.sprReg7VBackEndPort);
        smtItemSprHigh.smiSetPortValue(SpriteScreen.sprReg8ResoPort >> 4);
        smtItemSprVRes.smiSetPortValue(SpriteScreen.sprReg8ResoPort >> 2);
        smtItemSprHRes.smiSetPortValue(SpriteScreen.sprReg8ResoPort);
        for (SMTItem sMTItem : smtItemArray) {
            if (!sMTItem.smiPending) continue;
            sMTItem.smiPending = false;
            sMTItem.smiControlled();
        }
    }

    public static void smtUpdateFreq() {
        int n = CRTC.crtR00HFrontEndCurr + 1;
        int n2 = CRTC.crtR04VFrontEndCurr + 1;
        if (0 < n && 0 < n2) {
            int n3 = CRTC.crtHRLCurr << 3 | CRTC.crtHighResoCurr << 2 | CRTC.crtHResoCurr;
            double d = (double)CRTC.crtFreqs[CRTC.CRT_OSCS[n3]] * CRTC.crtVsyncMultiplier;
            int n4 = CRTC.CRT_DIVS[n3];
            double d2 = d / (double)(n4 * n << 3);
            double d3 = d2 / (double)n2;
            int n5 = CRTC.crtR03HDispEndCurr - CRTC.crtR02HBackEndCurr << 3;
            int n6 = CRTC.crtR07VDispEndCurr - CRTC.crtR06VBackEndCurr;
            String string = "(normal)";
            if (CRTC.crtDuplication) {
                n6 >>= 1;
                string = "(double-scanning)";
            } else if (CRTC.crtInterlace) {
                n6 <<= 1;
                string = "(interlace)";
            } else if (CRTC.crtSlit) {
                string = "(slit)";
            } else if (CRTC.crtDupExceptSp) {
                n6 >>= 1;
                string = "(double-except-sp)";
            }
            String string2 = String.format("%dx%d%s, HSYNC:%.3fMHz/%d/8/%d=%.3fkHz, VSYNC:%.3fkHz/%d=%.3fHz", n5, n6, string, d * 1.0E-6, n4, n, d2 * 0.001, d2 * 0.001, n2, d3);
            if (!string2.equals(smtFreqLastText)) {
                smtFreqLastText = string2;
                smtFreqTextField.setText(string2);
            }
        }
    }

    public static void smtUpdateMode() {
        int n;
        int n2;
        String string;
        String string2 = VideoController.vcnMode.name();
        String string3 = string2.equals(string = VideoController.vcnGetName(new StringBuilder()).toString()) ? string2 : string2 + '(' + string + ')';
        long l = XEiJ.mpuClockTime;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = l - 5000000000000L;
        int n3 = 0;
        for (n2 = 0; n2 < smtModeCount; ++n2) {
            if (string3.compareTo(smtModeName[n2]) == 0) {
                bl2 = true;
                ScreenModeTest.smtModeName[n3] = string3;
                ScreenModeTest.smtModeTime[n3] = l;
                ++n3;
                continue;
            }
            if (l2 >= smtModeTime[n2]) continue;
            ScreenModeTest.smtModeName[n3] = smtModeName[n2];
            ScreenModeTest.smtModeTime[n3] = smtModeTime[n2];
            ++n3;
        }
        if (n3 < smtModeCount) {
            smtModeCount = n3;
            bl = true;
        }
        if (!bl2) {
            if (smtModeCount == 6) {
                int n4 = -1;
                long l3 = Long.MAX_VALUE;
                for (n2 = 0; n2 < smtModeCount; ++n2) {
                    if (smtModeTime[n2] >= l3) continue;
                    l3 = smtModeTime[n2];
                    n4 = n2;
                }
                for (n2 = n4 + 1; n2 < 6; ++n2) {
                    ScreenModeTest.smtModeName[n2 - 1] = smtModeName[n2];
                    ScreenModeTest.smtModeTime[n2 - 1] = smtModeTime[n2];
                }
                --smtModeCount;
            }
            int n5 = -1;
            for (n = 0; n < smtModeCount; ++n) {
                if (string3.compareTo(smtModeName[n]) >= 0) continue;
                n5 = n;
                break;
            }
            if (n5 < 0) {
                n5 = smtModeCount;
            }
            for (n = smtModeCount - 1; n5 <= n; --n) {
                ScreenModeTest.smtModeName[n + 1] = smtModeName[n];
                ScreenModeTest.smtModeTime[n + 1] = smtModeTime[n];
            }
            ScreenModeTest.smtModeName[n5] = string3;
            ScreenModeTest.smtModeTime[n5] = l;
            ++smtModeCount;
            bl = true;
        }
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < smtModeCount; ++n) {
                if (0 < n) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(smtModeName[n]);
            }
            smtModeTextField.setText(stringBuilder.toString());
        }
    }

    static {
        smtModeName = new String[6];
        smtModeTime = new long[6];
    }

    public static class SMTItem {
        public int smiBitWidth;
        public int smiBitMask;
        public int smiDigits;
        public int smiPortValue;
        public int smiMaskValue;
        public int smiTestValue;
        public boolean smiPending;
        public ButtonGroup smiButtonGroup;
        public Box smiBox;
        public JLabel smiNameLabel;
        public JRadioButton smiPortRadioButton;
        public JCheckBox smiPortCheckBox;
        public JTextField smiPortTextField;
        public JRadioButton smiTestRadioButton;
        public JCheckBox smiTestCheckBox;
        public DecimalSpinner smiTestSpinner;
        public SMTGroup smiItemGroup;

        public SMTItem(String string, int n, int n2) {
            JComponent jComponent;
            JComponent jComponent2;
            this.smiBitWidth = n2;
            this.smiBitMask = (1 << n2) - 1;
            this.smiDigits = (n2 * 77 >> 8) + 1;
            this.smiPortValue = n &= this.smiBitMask;
            this.smiMaskValue = 0;
            this.smiTestValue = n;
            this.smiPending = false;
            this.smiButtonGroup = new ButtonGroup();
            Component[] componentArray = new Component[5];
            componentArray[0] = Box.createVerticalGlue();
            Component[] componentArray2 = new Component[3];
            componentArray2[0] = Box.createHorizontalGlue();
            this.smiNameLabel = ComponentFactory.setFixedSize(ComponentFactory.createLabel(string), n2 == 1 ? LnF.lnfFontSize * 3 : 38 + LnF.lnfFontSize * 2 / 3 * Math.max(2, this.smiDigits), LnF.lnfFontSize + 4);
            componentArray2[1] = this.smiNameLabel;
            componentArray2[2] = Box.createHorizontalGlue();
            componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
            Component[] componentArray3 = new Component[4];
            componentArray3[0] = Box.createHorizontalGlue();
            this.smiPortRadioButton = ComponentFactory.setFixedSize(ComponentFactory.createRadioButton(this.smiButtonGroup, this.smiMaskValue == 0, "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.smiPortSelected();
                }
            }), 14, LnF.lnfFontSize + 4);
            componentArray3[1] = this.smiPortRadioButton;
            if (n2 == 1) {
                jComponent2 = this.smiPortCheckBox = ComponentFactory.setEnabled(ComponentFactory.setFixedSize(ComponentFactory.createCheckBox(this.smiPortValue != 0, "", null), 14, LnF.lnfFontSize + 4), false);
            } else {
                this.smiPortTextField = ComponentFactory.setFixedSize(ComponentFactory.setEditable(ComponentFactory.setHorizontalAlignment(new JTextField(String.valueOf(this.smiPortValue)), 0), false), 24 + LnF.lnfFontSize * 2 / 3 * this.smiDigits, LnF.lnfFontSize + 4);
                jComponent2 = this.smiPortTextField;
            }
            componentArray3[2] = jComponent2;
            componentArray3[3] = Box.createHorizontalGlue();
            componentArray[2] = ComponentFactory.createHorizontalBox(componentArray3);
            Component[] componentArray4 = new Component[4];
            componentArray4[0] = Box.createHorizontalGlue();
            this.smiTestRadioButton = ComponentFactory.setFixedSize(ComponentFactory.createRadioButton(this.smiButtonGroup, this.smiMaskValue != 0, "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.smiTestSelected();
                }
            }), 14, LnF.lnfFontSize + 4);
            componentArray4[1] = this.smiTestRadioButton;
            if (n2 == 1) {
                this.smiTestCheckBox = ComponentFactory.setFixedSize(ComponentFactory.createCheckBox(this.smiTestValue != 0, "", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.smiTestChanged();
                    }
                }), 14, LnF.lnfFontSize + 4);
                jComponent = this.smiTestCheckBox;
            } else {
                jComponent = this.smiTestSpinner = ComponentFactory.createDecimalSpinner(this.smiTestValue, 0, this.smiBitMask, 1, 0, new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        this.smiTestChanged();
                    }
                });
            }
            componentArray4[2] = jComponent;
            componentArray4[3] = Box.createHorizontalGlue();
            componentArray[3] = ComponentFactory.createHorizontalBox(componentArray4);
            componentArray[4] = Box.createVerticalGlue();
            this.smiBox = ComponentFactory.setFixedSize(ComponentFactory.createVerticalBox(componentArray), n2 == 1 ? LnF.lnfFontSize * 3 : 38 + LnF.lnfFontSize * 2 / 3 * Math.max(2, this.smiDigits), LnF.lnfFontSize * 3 + 12);
            this.smiItemGroup = null;
        }

        public void smiSetPortValue(int n) {
            if (this.smiPortValue != (n &= this.smiBitMask)) {
                this.smiPortValue = n;
                if (this.smiBitWidth == 1) {
                    this.smiPortCheckBox.setSelected(n != 0);
                } else {
                    this.smiPortTextField.setText(String.valueOf(n));
                }
            }
        }

        public void smiPortSelected() {
            if (this.smiMaskValue != 0) {
                this.smiMaskValue = 0;
                if (XEiJ.mpuTask == null) {
                    this.smiControlled();
                } else {
                    this.smiPending = true;
                }
                if (this.smiItemGroup != null) {
                    this.smiItemGroup.smgUpdate();
                }
            }
        }

        public void smiTestSelected() {
            if (this.smiMaskValue == 0) {
                this.smiMaskValue = -1;
                if (XEiJ.mpuTask == null) {
                    this.smiControlled();
                } else {
                    this.smiPending = true;
                }
                if (this.smiItemGroup != null) {
                    this.smiItemGroup.smgUpdate();
                }
            }
        }

        public void smiTestChanged() {
            int n;
            int n2 = this.smiBitWidth == 1 ? (this.smiTestCheckBox.isSelected() ? 1 : 0) : (n = this.smiTestSpinner.getIntValue());
            if (this.smiTestValue != n) {
                this.smiTestValue = n;
                if (XEiJ.mpuTask == null) {
                    this.smiControlled();
                } else {
                    this.smiPending = true;
                }
            }
        }

        public void smiControlled() {
        }
    }

    public static class SMTItem_CrtHFEd
    extends SMTItem {
        public SMTItem_CrtHFEd() {
            super("HFEd", CRTC.crtR00HFrontEndPort, 8);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80000.w 7-0 Horizontal front porch end column", "ja", "$E80000.w 7-0 \u6c34\u5e73\u30d5\u30ed\u30f3\u30c8\u30dd\u30fc\u30c1\u7d42\u4e86\u30ab\u30e9\u30e0");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR00HFrontEndMask = this.smiMaskValue;
            CRTC.crtR00HFrontEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR00HFrontEndMask == 0 ? CRTC.crtR00HFrontEndPort : CRTC.crtR00HFrontEndTest;
            if (CRTC.crtR00HFrontEndCurr != n) {
                CRTC.crtR00HFrontEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtHSEd
    extends SMTItem {
        public SMTItem_CrtHSEd() {
            super("HSEd", CRTC.crtR01HSyncEndPort, 8);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80002.w 7-0 Horizontal sync pulse end column", "ja", "$E80002.w 7-0 \u6c34\u5e73\u540c\u671f\u30d1\u30eb\u30b9\u7d42\u4e86\u30ab\u30e9\u30e0");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR01HSyncEndMask = this.smiMaskValue;
            CRTC.crtR01HSyncEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR01HSyncEndMask == 0 ? CRTC.crtR01HSyncEndPort : CRTC.crtR01HSyncEndTest;
            if (CRTC.crtR01HSyncEndCurr != n) {
                CRTC.crtR01HSyncEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtHBEd
    extends SMTItem {
        public SMTItem_CrtHBEd() {
            super("HBEd", CRTC.crtR02HBackEndPort, 8);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80004.w 7-0 Horizontal back porch end column -4", "ja", "$E80004.w 7-0 \u6c34\u5e73\u30d0\u30c3\u30af\u30dd\u30fc\u30c1\u7d42\u4e86\u30ab\u30e9\u30e0 -4");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR02HBackEndMask = this.smiMaskValue;
            CRTC.crtR02HBackEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR02HBackEndMask == 0 ? CRTC.crtR02HBackEndPort : CRTC.crtR02HBackEndTest;
            if (CRTC.crtR02HBackEndCurr != n) {
                CRTC.crtR02HBackEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtHDEd
    extends SMTItem {
        public SMTItem_CrtHDEd() {
            super("HDEd", CRTC.crtR03HDispEndPort, 8);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80006.w 7-0 Horizontal display period end column -4", "ja", "$E80006.w 7-0 \u6c34\u5e73\u6620\u50cf\u671f\u9593\u7d42\u4e86\u30ab\u30e9\u30e0 -4");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR03HDispEndMask = this.smiMaskValue;
            CRTC.crtR03HDispEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR03HDispEndMask == 0 ? CRTC.crtR03HDispEndPort : CRTC.crtR03HDispEndTest;
            if (CRTC.crtR03HDispEndCurr != n) {
                CRTC.crtR03HDispEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtVFEd
    extends SMTItem {
        public SMTItem_CrtVFEd() {
            super("VFEd", CRTC.crtR04VFrontEndPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80008.w 9-0 Vertical front porch end raster", "ja", "$E80008.w 9-0 \u5782\u76f4\u30d5\u30ed\u30f3\u30c8\u30dd\u30fc\u30c1\u7d42\u4e86\u30e9\u30b9\u30bf");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR04VFrontEndMask = this.smiMaskValue;
            CRTC.crtR04VFrontEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR04VFrontEndMask == 0 ? CRTC.crtR04VFrontEndPort : CRTC.crtR04VFrontEndTest;
            if (CRTC.crtR04VFrontEndCurr != n) {
                CRTC.crtR04VFrontEndCurr = n;
                CRTC.crtUpdateRasterHash();
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtVSEd
    extends SMTItem {
        public SMTItem_CrtVSEd() {
            super("VSEd", CRTC.crtR05VSyncEndPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8000A.w 9-0 Vertical sync pulse end raster", "ja", "$E8000A.w 9-0 \u5782\u76f4\u540c\u671f\u30d1\u30eb\u30b9\u7d42\u4e86\u30e9\u30b9\u30bf");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR05VSyncEndMask = this.smiMaskValue;
            CRTC.crtR05VSyncEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR05VSyncEndMask == 0 ? CRTC.crtR05VSyncEndPort : CRTC.crtR05VSyncEndTest;
            if (CRTC.crtR05VSyncEndCurr != n) {
                CRTC.crtR05VSyncEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtVBEd
    extends SMTItem {
        public SMTItem_CrtVBEd() {
            super("VBEd", CRTC.crtR06VBackEndPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8000C.w 9-0 Vertical back porch end raster", "ja", "$E8000C.w 9-0 \u5782\u76f4\u30d0\u30c3\u30af\u30dd\u30fc\u30c1\u7d42\u4e86\u30e9\u30b9\u30bf");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR06VBackEndMask = this.smiMaskValue;
            CRTC.crtR06VBackEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR06VBackEndMask == 0 ? CRTC.crtR06VBackEndPort : CRTC.crtR06VBackEndTest;
            if (CRTC.crtR06VBackEndCurr != n) {
                CRTC.crtR06VBackEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtVDEd
    extends SMTItem {
        public SMTItem_CrtVDEd() {
            super("VDEd", CRTC.crtR07VDispEndPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8000E.w 9-0 Vertical display period end raster", "ja", "$E8000E.w 9-0 \u5782\u76f4\u6620\u50cf\u671f\u9593\u7d42\u4e86\u30e9\u30b9\u30bf");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR07VDispEndMask = this.smiMaskValue;
            CRTC.crtR07VDispEndTest = this.smiTestValue;
            int n2 = n = CRTC.crtR07VDispEndMask == 0 ? CRTC.crtR07VDispEndPort : CRTC.crtR07VDispEndTest;
            if (CRTC.crtR07VDispEndCurr != n) {
                CRTC.crtR07VDispEndCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtIRQ
    extends SMTItem {
        public SMTItem_CrtIRQ() {
            super("IRQ", CRTC.crtR09IRQRasterPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80012.w 9-0 IRQ raster number", "ja", "$E80012.w 9-0 IRQ \u30e9\u30b9\u30bf\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR09IRQRasterMask = this.smiMaskValue;
            CRTC.crtR09IRQRasterTest = this.smiTestValue;
            int n2 = n = CRTC.crtR09IRQRasterMask == 0 ? CRTC.crtR09IRQRasterPort : CRTC.crtR09IRQRasterTest;
            if (CRTC.crtR09IRQRasterCurr != n) {
                CRTC.crtR09IRQRasterCurr = n;
                CRTC.crtUpdateRasterHash();
                RasterBreakPoint.rbpCheckIRQ();
            }
        }
    }

    public static class SMTItem_CrtTxX
    extends SMTItem {
        public SMTItem_CrtTxX() {
            super("TxX", CRTC.crtR10TxXPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80014.w 9-0 Text screen x-direction scroll", "ja", "$E80014.w 9-0 \u30c6\u30ad\u30b9\u30c8\u753b\u9762 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR10TxXMask = this.smiMaskValue;
            CRTC.crtR10TxXTest = this.smiTestValue;
            int n2 = n = CRTC.crtR10TxXMask == 0 ? CRTC.crtR10TxXPort : CRTC.crtR10TxXTest;
            if (CRTC.crtR10TxXCurr != n) {
                CRTC.crtR10TxXCurr = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtTxY
    extends SMTItem {
        public SMTItem_CrtTxY() {
            super("TxY", CRTC.crtR11TxYPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80016.w 9-0 Text screen y-direction scroll", "ja", "$E80016.w 9-0 \u30c6\u30ad\u30b9\u30c8\u753b\u9762 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR11TxYMask = this.smiMaskValue;
            CRTC.crtR11TxYTest = this.smiTestValue;
            int n2 = n = CRTC.crtR11TxYMask == 0 ? CRTC.crtR11TxYPort : CRTC.crtR11TxYTest;
            if (CRTC.crtR11TxYCurr != n) {
                CRTC.crtR11TxYCurr = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGrMM
    extends SMTItem {
        public SMTItem_CrtGrMM() {
            super("GrMM", CRTC.crtMemoryModePort, 3);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80028.w 10-8 Memory mode of graphic screen", "ja", "$E80028.w 10-8 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u30e1\u30e2\u30ea\u30e2\u30fc\u30c9");
        }

        @Override
        public void smiControlled() {
            CRTC.crtMemoryModeMask = this.smiMaskValue;
            CRTC.crtMemoryModeTest = this.smiTestValue;
            CRTC.crtSetMemoryMode(CRTC.crtTextStorage, CRTC.crtGraphicStorage, CRTC.crtMemoryModePort);
        }
    }

    public static class SMTItem_CrtHigh
    extends SMTItem {
        public SMTItem_CrtHigh() {
            super("High", CRTC.crtHighResoPort, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80028.w 4 High-resolution", "ja", "$E80028.w 4 \u9ad8\u89e3\u50cf\u5ea6");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtHighResoMask = this.smiMaskValue;
            CRTC.crtHighResoTest = this.smiTestValue;
            int n2 = n = CRTC.crtHighResoMask == 0 ? CRTC.crtHighResoPort : CRTC.crtHighResoTest;
            if (CRTC.crtHighResoCurr != n) {
                CRTC.crtHighResoCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtVRes
    extends SMTItem {
        public SMTItem_CrtVRes() {
            super("VRes", CRTC.crtVResoPort, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80028.w 3-2 Vertical resolution", "ja", "$E80028.w 3-2 \u5782\u76f4\u89e3\u50cf\u5ea6");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtVResoMask = this.smiMaskValue;
            CRTC.crtVResoTest = this.smiTestValue;
            int n2 = n = CRTC.crtVResoMask == 0 ? CRTC.crtVResoPort : CRTC.crtVResoTest;
            if (CRTC.crtVResoCurr != n) {
                CRTC.crtVResoCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_CrtHRes
    extends SMTItem {
        public SMTItem_CrtHRes() {
            super("HRes", CRTC.crtHResoPort, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80028.w 1-0 Horizontal resolution", "ja", "$E80028.w 1-0 \u6c34\u5e73\u89e3\u50cf\u5ea6");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtHResoMask = this.smiMaskValue;
            CRTC.crtHResoTest = this.smiTestValue;
            int n2 = n = CRTC.crtHResoMask == 0 ? CRTC.crtHResoPort : CRTC.crtHResoTest;
            if (CRTC.crtHResoCurr != n) {
                CRTC.crtHResoCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_SysHRL
    extends SMTItem {
        public SMTItem_SysHRL() {
            super("HRL", CRTC.crtHRLPort, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8E007.b 1 HRL (dot clock selection)", "ja", "$E8E007.b 1 HRL (\u30c9\u30c3\u30c8\u30af\u30ed\u30c3\u30af\u9078\u629e)");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtHRLMask = this.smiMaskValue;
            CRTC.crtHRLTest = this.smiTestValue;
            int n2 = n = CRTC.crtHRLMask == 0 ? CRTC.crtHRLPort : CRTC.crtHRLTest;
            if (CRTC.crtHRLCurr != n) {
                CRTC.crtHRLCurr = n;
                if (XEiJ.mpuTask != null) {
                    CRTC.crtRestart();
                }
            }
        }
    }

    public static class SMTItem_SysCont
    extends SMTItem {
        public SMTItem_SysCont() {
            super("Cont", VideoController.vcnTargetContrastPort, 4);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8E001.b 3-0 Contrast", "ja", "$E8E001.b 3-0 \u30b3\u30f3\u30c8\u30e9\u30b9\u30c8");
        }

        @Override
        public void smiControlled() {
            int n;
            VideoController.vcnTargetContrastMask = this.smiMaskValue;
            VideoController.vcnTargetContrastTest = this.smiTestValue;
            int n2 = n = VideoController.vcnTargetContrastMask == 0 ? VideoController.vcnTargetContrastPort : VideoController.vcnTargetContrastTest;
            if (VideoController.vcnTargetContrastCurr != n) {
                VideoController.vcnTargetContrastCurr = n;
                VideoController.vcnTargetScaledContrast = 3 * VideoController.vcnTargetContrastCurr;
                CRTC.crtContrastClock = XEiJ.mpuClockTime;
                CRTC.crtFrameTaskClock = Math.min(CRTC.crtContrastClock, CRTC.crtCaptureClock);
            }
        }
    }

    public static class SMTItem_CrtGr0X
    extends SMTItem {
        public SMTItem_CrtGr0X() {
            super("Gr0X", CRTC.crtR12GrXPort[0], 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80018.w 9-0 graphic plane 0 x-direction scroll", "ja", "$E80018.w 9-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR12GrXMask[0] = this.smiMaskValue;
            CRTC.crtR12GrXTest[0] = this.smiTestValue;
            int n2 = n = CRTC.crtR12GrXMask[0] == 0 ? CRTC.crtR12GrXPort[0] : CRTC.crtR12GrXTest[0];
            if (CRTC.crtR12GrXCurr[0] != n) {
                CRTC.crtR12GrXCurr[0] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr0Y
    extends SMTItem {
        public SMTItem_CrtGr0Y() {
            super("Gr0Y", CRTC.crtR13GrYPort[0], 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8001A.w 9-0 graphic plane 0 y-direction scroll", "ja", "$E8001A.w 9-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR13GrYMask[0] = this.smiMaskValue;
            CRTC.crtR13GrYTest[0] = this.smiTestValue;
            int n2 = n = CRTC.crtR13GrYMask[0] == 0 ? CRTC.crtR13GrYPort[0] : CRTC.crtR13GrYTest[0];
            if (CRTC.crtR13GrYCurr[0] != n) {
                CRTC.crtR13GrYCurr[0] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr1X
    extends SMTItem {
        public SMTItem_CrtGr1X() {
            super("Gr1X", CRTC.crtR12GrXPort[1], 9);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8001C.w 8-0 graphic plane 0 x-direction scroll", "ja", "$E8001C.w 8-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR12GrXMask[1] = this.smiMaskValue;
            CRTC.crtR12GrXTest[1] = this.smiTestValue;
            int n2 = n = CRTC.crtR12GrXMask[1] == 0 ? CRTC.crtR12GrXPort[1] : CRTC.crtR12GrXTest[1];
            if (CRTC.crtR12GrXCurr[1] != n) {
                CRTC.crtR12GrXCurr[1] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr1Y
    extends SMTItem {
        public SMTItem_CrtGr1Y() {
            super("Gr1Y", CRTC.crtR13GrYPort[1], 9);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E8001E.w 8-0 graphic plane 0 y-direction scroll", "ja", "$E8001E.w 8-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR13GrYMask[1] = this.smiMaskValue;
            CRTC.crtR13GrYTest[1] = this.smiTestValue;
            int n2 = n = CRTC.crtR13GrYMask[1] == 0 ? CRTC.crtR13GrYPort[1] : CRTC.crtR13GrYTest[1];
            if (CRTC.crtR13GrYCurr[1] != n) {
                CRTC.crtR13GrYCurr[1] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr2X
    extends SMTItem {
        public SMTItem_CrtGr2X() {
            super("Gr2X", CRTC.crtR12GrXPort[2], 9);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80020.w 8-0 graphic plane 0 x-direction scroll", "ja", "$E80020.w 8-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR12GrXMask[2] = this.smiMaskValue;
            CRTC.crtR12GrXTest[2] = this.smiTestValue;
            int n2 = n = CRTC.crtR12GrXMask[2] == 0 ? CRTC.crtR12GrXPort[2] : CRTC.crtR12GrXTest[2];
            if (CRTC.crtR12GrXCurr[2] != n) {
                CRTC.crtR12GrXCurr[2] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr2Y
    extends SMTItem {
        public SMTItem_CrtGr2Y() {
            super("Gr2Y", CRTC.crtR13GrYPort[2], 9);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80022.w 8-0 graphic plane 0 y-direction scroll", "ja", "$E80022.w 8-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR13GrYMask[2] = this.smiMaskValue;
            CRTC.crtR13GrYTest[2] = this.smiTestValue;
            int n2 = n = CRTC.crtR13GrYMask[2] == 0 ? CRTC.crtR13GrYPort[2] : CRTC.crtR13GrYTest[2];
            if (CRTC.crtR13GrYCurr[2] != n) {
                CRTC.crtR13GrYCurr[2] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr3X
    extends SMTItem {
        public SMTItem_CrtGr3X() {
            super("Gr3X", CRTC.crtR12GrXPort[3], 9);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80024.w 8-0 graphic plane 3 x-direction scroll", "ja", "$E80024.w 8-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 3 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR12GrXMask[3] = this.smiMaskValue;
            CRTC.crtR12GrXTest[3] = this.smiTestValue;
            int n2 = n = CRTC.crtR12GrXMask[3] == 0 ? CRTC.crtR12GrXPort[3] : CRTC.crtR12GrXTest[3];
            if (CRTC.crtR12GrXCurr[3] != n) {
                CRTC.crtR12GrXCurr[3] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_CrtGr3Y
    extends SMTItem {
        public SMTItem_CrtGr3Y() {
            super("Gr3Y", CRTC.crtR13GrYPort[3], 9);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E80026.w 8-0 graphic plane 3 y-direction scroll", "ja", "$E80026.w 8-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 3 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            CRTC.crtR13GrYMask[3] = this.smiMaskValue;
            CRTC.crtR13GrYTest[3] = this.smiTestValue;
            int n2 = n = CRTC.crtR13GrYMask[3] == 0 ? CRTC.crtR13GrYPort[3] : CRTC.crtR13GrYTest[3];
            if (CRTC.crtR13GrYCurr[3] != n) {
                CRTC.crtR13GrYCurr[3] = n;
                CRTC.crtAllStamp += 2;
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnGrMM
    extends SMTItem {
        public SMTItem_VcnGrMM() {
            super("GrMM", VideoController.vcnReg1Port, 3);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82400.w 2-0 Memory mode of graphic screen", "ja", "$E82400.w 2-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u30e1\u30e2\u30ea\u30e2\u30fc\u30c9");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg1Port & ~(VideoController.vcnReg1Mask = VideoController.vcnReg1Mask & 0xFFFFFFF8 | this.smiMaskValue & 7) | (VideoController.vcnReg1Test = VideoController.vcnReg1Test & 0xFFFFFFF8 | this.smiTestValue) & VideoController.vcnReg1Mask;
            if (VideoController.vcnReg1Curr != n) {
                VideoController.vcnReg1Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnSpPr
    extends SMTItem {
        public SMTItem_VcnSpPr() {
            super("SpPr", VideoController.vcnReg2Port >> 12, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 13-12 Precedence of sprite screen", "ja", "$E82500.w 13-12 \u30b9\u30d7\u30e9\u30a4\u30c8\u753b\u9762\u306e\u512a\u5148\u9806\u4f4d");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFCFFF | this.smiMaskValue & 0x3000) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFCFFF | this.smiTestValue << 12) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnTxPr
    extends SMTItem {
        public SMTItem_VcnTxPr() {
            super("TxPr", VideoController.vcnReg2Port >> 10, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 11-10 Precedence of text screen", "ja", "$E82500.w 11-10 \u30c6\u30ad\u30b9\u30c8\u753b\u9762\u306e\u512a\u5148\u9806\u4f4d");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFF3FF | this.smiMaskValue & 0xC00) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFF3FF | this.smiTestValue << 10) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnGrPr
    extends SMTItem {
        public SMTItem_VcnGrPr() {
            super("GrPr", VideoController.vcnReg2Port >> 8, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 9-8 Precedence of graphic screen", "ja", "$E82500.w 9-8 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u512a\u5148\u9806\u4f4d");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFFCFF | this.smiMaskValue & 0x300) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFFCFF | this.smiTestValue << 8) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG4th
    extends SMTItem {
        public SMTItem_VcnG4th() {
            super("G4th", VideoController.vcnReg2Port >> 6, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 7-6 The farthest plane number of graphic screen", "ja", "$E82500.w 7-6 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u4e00\u756a\u5965\u306e\u30d7\u30ec\u30fc\u30f3\u306e\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFFF3F | this.smiMaskValue & 0xC0) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFFF3F | this.smiTestValue << 6) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG3rd
    extends SMTItem {
        public SMTItem_VcnG3rd() {
            super("G3rd", VideoController.vcnReg2Port >> 4, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 5-4 Second-farthest plane number of graphic screen", "ja", "$E82500.w 5-4 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u5965\u304b\u3089 2 \u756a\u76ee\u306e\u30d7\u30ec\u30fc\u30f3\u306e\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFFFCF | this.smiMaskValue & 0x30) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFFFCF | this.smiTestValue << 4) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG2nd
    extends SMTItem {
        public SMTItem_VcnG2nd() {
            super("G2nd", VideoController.vcnReg2Port >> 2, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 3-2 Second-nearest plane number of graphic screen", "ja", "$E82500.w 3-2 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u624b\u524d\u304b\u3089 2 \u756a\u76ee\u306e\u30d7\u30ec\u30fc\u30f3\u306e\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFFFF3 | this.smiMaskValue & 0xC) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFFFF3 | this.smiTestValue << 2) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG1st
    extends SMTItem {
        public SMTItem_VcnG1st() {
            super("G1st", VideoController.vcnReg2Port, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82500.w 1-0 The nearest plane number of graphic screen", "ja", "$E82500.w 1-0 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u4e00\u756a\u624b\u524d\u306e\u30d7\u30ec\u30fc\u30f3\u306e\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg2Port & ~(VideoController.vcnReg2Mask = VideoController.vcnReg2Mask & 0xFFFFFFFC | this.smiMaskValue & 3) | (VideoController.vcnReg2Test = VideoController.vcnReg2Test & 0xFFFFFFFC | this.smiTestValue) & VideoController.vcnReg2Mask;
            if (VideoController.vcnReg2Curr != n) {
                VideoController.vcnReg2Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnAHOn
    extends SMTItem {
        public SMTItem_VcnAHOn() {
            super("AHOn", VideoController.vcnReg3Port >> 14, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 14 Halftone with text palet 0", "ja", "$E82600.w 14 \u30c6\u30ad\u30b9\u30c8\u30d1\u30ec\u30c3\u30c8 0 \u3068\u306e\u534a\u900f\u660e");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFBFFF | this.smiMaskValue & 0x4000) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFBFFF | this.smiTestValue << 14) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnExOn
    extends SMTItem {
        public SMTItem_VcnExOn() {
            super("ExOn", VideoController.vcnReg3Port >> 12, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 12 Extended (special priority or halftone)", "ja", "$E82600.w 12 \u62e1\u5f35 (\u7279\u6b8a\u30d7\u30e9\u30a4\u30aa\u30ea\u30c6\u30a3\u307e\u305f\u306f\u534a\u900f\u660e)");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFEFFF | this.smiMaskValue & 0x1000) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFEFFF | this.smiTestValue << 12) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnHalf
    extends SMTItem {
        public SMTItem_VcnHalf() {
            super("Half", VideoController.vcnReg3Port >> 11, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 11 Halftone", "ja", "$E82600.w 11 \u534a\u900f\u660e");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFF7FF | this.smiMaskValue & 0x800) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFF7FF | this.smiTestValue << 11) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnPLSB
    extends SMTItem {
        public SMTItem_VcnPLSB() {
            super("PLSB", VideoController.vcnReg3Port >> 10, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 10 Select area by LSB of palet code", "ja", "$E82600.w 10 \u30d1\u30ec\u30c3\u30c8\u30b3\u30fc\u30c9\u306e LSB \u3067\u7bc4\u56f2\u3092\u9078\u629e");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFBFF | this.smiMaskValue & 0x400) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFBFF | this.smiTestValue << 10) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnGrGr
    extends SMTItem {
        public SMTItem_VcnGrGr() {
            super("GrGr", VideoController.vcnReg3Port >> 9, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 9 Halftone between the nearest graphic page and second-nearest graphic page", "ja", "$E82600.w 9 \u4e00\u756a\u624b\u524d\u306e\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30da\u30fc\u30b8\u3068\u624b\u524d\u304b\u3089 2 \u756a\u76ee\u306e\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30da\u30fc\u30b8\u3068\u306e\u534a\u900f\u660e");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFDFF | this.smiMaskValue & 0x200) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFDFF | this.smiTestValue << 9) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnGrST
    extends SMTItem {
        public SMTItem_VcnGrST() {
            super("GrST", VideoController.vcnReg3Port >> 8, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 8 Halftone between the nearest graphic page and sprite/text screen in the back of graphic screen", "ja", "$E82600.w 8 \u4e00\u756a\u624b\u524d\u306e\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30da\u30fc\u30b8\u3068\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u306e\u5965\u306b\u3042\u308b\u30b9\u30d7\u30e9\u30a4\u30c8/\u30c6\u30ad\u30b9\u30c8\u753b\u9762\u3068\u306e\u534a\u900f\u660e");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFEFF | this.smiMaskValue & 0x100) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFEFF | this.smiTestValue << 8) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnSpOn
    extends SMTItem {
        public SMTItem_VcnSpOn() {
            super("SpOn", VideoController.vcnReg3Port >> 6, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 6 Sprite screen", "ja", "$E82600.w 6 \u30b9\u30d7\u30e9\u30a4\u30c8\u753b\u9762");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFBF | this.smiMaskValue & 0x40) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFBF | this.smiTestValue << 6) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnTxOn
    extends SMTItem {
        public SMTItem_VcnTxOn() {
            super("TxOn", VideoController.vcnReg3Port >> 5, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 5 Text screen", "ja", "$E82600.w 5 \u30c6\u30ad\u30b9\u30c8\u753b\u9762");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFDF | this.smiMaskValue & 0x20) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFDF | this.smiTestValue << 5) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnGxOn
    extends SMTItem {
        public SMTItem_VcnGxOn() {
            super("GxOn", VideoController.vcnReg3Port >> 4, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 4 1024x1024 graphic screen", "ja", "$E82600.w 4 1024x1024 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFEF | this.smiMaskValue & 0x10) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFEF | this.smiTestValue << 4) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG4On
    extends SMTItem {
        public SMTItem_VcnG4On() {
            super("G4On", VideoController.vcnReg3Port >> 3, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 3 512x512 graphic plane 3", "ja", "$E82600.w 3 512x512 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 3");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFF7 | this.smiMaskValue & 8) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFF7 | this.smiTestValue << 3) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG3On
    extends SMTItem {
        public SMTItem_VcnG3On() {
            super("G3On", VideoController.vcnReg3Port >> 2, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 2 512x512 graphic plane 2", "ja", "$E82600.w 2 512x512 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 2");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFFB | this.smiMaskValue & 4) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFFB | this.smiTestValue << 2) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG2On
    extends SMTItem {
        public SMTItem_VcnG2On() {
            super("G2On", VideoController.vcnReg3Port >> 1, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 1 512x512 graphic plane 1", "ja", "$E82600.w 1 512x512 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 1");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFFD | this.smiMaskValue & 2) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFFD | this.smiTestValue << 1) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_VcnG1On
    extends SMTItem {
        public SMTItem_VcnG1On() {
            super("G1On", VideoController.vcnReg3Port, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$E82600.w 0 512x512 graphic plane 0", "ja", "$E82600.w 0 512x512 \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30d7\u30ec\u30fc\u30f3 0");
        }

        @Override
        public void smiControlled() {
            int n = VideoController.vcnReg3Port & ~(VideoController.vcnReg3Mask = VideoController.vcnReg3Mask & 0xFFFFFFFE | this.smiMaskValue & 1) | (VideoController.vcnReg3Test = VideoController.vcnReg3Test & 0xFFFFFFFE | this.smiTestValue) & VideoController.vcnReg3Mask;
            if (VideoController.vcnReg3Curr != n) {
                VideoController.vcnReg3Curr = n;
                VideoController.vcnUpdateMode();
                if (XEiJ.mpuTask == null) {
                    CRTC.crtRepaint();
                }
            }
        }
    }

    public static class SMTItem_SprBg0X
    extends SMTItem {
        public SMTItem_SprBg0X() {
            super("Bg0X", SpriteScreen.sprReg0Bg0XPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0800.w 9-0 Background 0 x-direction scroll", "ja", "$EB0800.w 9-0 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 0 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg0Bg0XMask = this.smiMaskValue;
            SpriteScreen.sprReg0Bg0XTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg0Bg0XMask == 0 ? SpriteScreen.sprReg0Bg0XPort : SpriteScreen.sprReg0Bg0XTest;
            if (SpriteScreen.sprReg0Bg0XCurr != n) {
                SpriteScreen.sprReg0Bg0XCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprBg0Y
    extends SMTItem {
        public SMTItem_SprBg0Y() {
            super("Bg0Y", SpriteScreen.sprReg1Bg0YPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0802.w 9-0 Background 0 y-direction scroll", "ja", "$EB0802.w 9-0 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 0 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg1Bg0YMask = this.smiMaskValue;
            SpriteScreen.sprReg1Bg0YTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg1Bg0YMask == 0 ? SpriteScreen.sprReg1Bg0YPort : SpriteScreen.sprReg1Bg0YTest;
            if (SpriteScreen.sprReg1Bg0YCurr != n) {
                SpriteScreen.sprReg1Bg0YCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprBg1X
    extends SMTItem {
        public SMTItem_SprBg1X() {
            super("Bg1X", SpriteScreen.sprReg2Bg1XPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0804.w 9-0 Background 1 x-direction scroll", "ja", "$EB0804.w 9-0 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 1 x \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg2Bg1XMask = this.smiMaskValue;
            SpriteScreen.sprReg2Bg1XTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg2Bg1XMask == 0 ? SpriteScreen.sprReg2Bg1XPort : SpriteScreen.sprReg2Bg1XTest;
            if (SpriteScreen.sprReg2Bg1XCurr != n) {
                SpriteScreen.sprReg2Bg1XCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprBg1Y
    extends SMTItem {
        public SMTItem_SprBg1Y() {
            super("Bg1Y", SpriteScreen.sprReg3Bg1YPort, 10);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0806.w 9-0 Background 1 y-direction scroll", "ja", "$EB0806.w 9-0 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 1 y \u65b9\u5411\u30b9\u30af\u30ed\u30fc\u30eb");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg3Bg1YMask = this.smiMaskValue;
            SpriteScreen.sprReg3Bg1YTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg3Bg1YMask == 0 ? SpriteScreen.sprReg3Bg1YPort : SpriteScreen.sprReg3Bg1YTest;
            if (SpriteScreen.sprReg3Bg1YCurr != n) {
                SpriteScreen.sprReg3Bg1YCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprDisp
    extends SMTItem {
        public SMTItem_SprDisp() {
            super("Disp", SpriteScreen.sprReg4BgCtrlPort >> 9, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0808.w 9 Display sprite and background", "ja", "$EB0808.w 9 \u30b9\u30d7\u30e9\u30a4\u30c8\u3068\u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9\u3092\u8868\u793a");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg4BgCtrlPort & ~(SpriteScreen.sprReg4BgCtrlMask = SpriteScreen.sprReg4BgCtrlMask & 0xFFFFFDFF | this.smiMaskValue & 0x200) | (SpriteScreen.sprReg4BgCtrlTest = SpriteScreen.sprReg4BgCtrlTest & 0xFFFFFDFF | this.smiTestValue << 9) & SpriteScreen.sprReg4BgCtrlMask;
            if (SpriteScreen.sprReg4BgCtrlCurr != n) {
                SpriteScreen.sprReg4BgCtrlCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprB1Tx
    extends SMTItem {
        public SMTItem_SprB1Tx() {
            super("B1Tx", SpriteScreen.sprReg4BgCtrlPort >> 4, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0808.w 5-4 Text page assigned to background 1", "ja", "$EB0808.w 5-4 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 1 \u306b\u5272\u308a\u5f53\u3066\u308b\u30c6\u30ad\u30b9\u30c8\u30da\u30fc\u30b8");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg4BgCtrlPort & ~(SpriteScreen.sprReg4BgCtrlMask = SpriteScreen.sprReg4BgCtrlMask & 0xFFFFFFCF | this.smiMaskValue & 0x30) | (SpriteScreen.sprReg4BgCtrlTest = SpriteScreen.sprReg4BgCtrlTest & 0xFFFFFFCF | this.smiTestValue << 4) & SpriteScreen.sprReg4BgCtrlMask;
            if (SpriteScreen.sprReg4BgCtrlCurr != n) {
                SpriteScreen.sprReg4BgCtrlCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprB1On
    extends SMTItem {
        public SMTItem_SprB1On() {
            super("B1On", SpriteScreen.sprReg4BgCtrlPort >> 3, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0808.w 3 Background 1", "ja", "$EB0808.w 3 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 1");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg4BgCtrlPort & ~(SpriteScreen.sprReg4BgCtrlMask = SpriteScreen.sprReg4BgCtrlMask & 0xFFFFFFF7 | this.smiMaskValue & 8) | (SpriteScreen.sprReg4BgCtrlTest = SpriteScreen.sprReg4BgCtrlTest & 0xFFFFFFF7 | this.smiTestValue << 3) & SpriteScreen.sprReg4BgCtrlMask;
            if (SpriteScreen.sprReg4BgCtrlCurr != n) {
                SpriteScreen.sprReg4BgCtrlCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprB0Tx
    extends SMTItem {
        public SMTItem_SprB0Tx() {
            super("B0Tx", SpriteScreen.sprReg4BgCtrlPort >> 1, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0808.w 2-1 Text page assigned to background 0", "ja", "$EB0808.w 2-1 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 0 \u306b\u5272\u308a\u5f53\u3066\u308b\u30c6\u30ad\u30b9\u30c8\u30da\u30fc\u30b8");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg4BgCtrlPort & ~(SpriteScreen.sprReg4BgCtrlMask = SpriteScreen.sprReg4BgCtrlMask & 0xFFFFFFF9 | this.smiMaskValue & 6) | (SpriteScreen.sprReg4BgCtrlTest = SpriteScreen.sprReg4BgCtrlTest & 0xFFFFFFF9 | this.smiTestValue << 1) & SpriteScreen.sprReg4BgCtrlMask;
            if (SpriteScreen.sprReg4BgCtrlCurr != n) {
                SpriteScreen.sprReg4BgCtrlCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprB0On
    extends SMTItem {
        public SMTItem_SprB0On() {
            super("B0On", SpriteScreen.sprReg4BgCtrlPort, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0808.w 0 Background 0", "ja", "$EB0808.w 0 \u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9 0");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg4BgCtrlPort & ~(SpriteScreen.sprReg4BgCtrlMask = SpriteScreen.sprReg4BgCtrlMask & 0xFFFFFFFE | this.smiMaskValue & 1) | (SpriteScreen.sprReg4BgCtrlTest = SpriteScreen.sprReg4BgCtrlTest & 0xFFFFFFFE | this.smiTestValue) & SpriteScreen.sprReg4BgCtrlMask;
            if (SpriteScreen.sprReg4BgCtrlCurr != n) {
                SpriteScreen.sprReg4BgCtrlCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprHFEd
    extends SMTItem {
        public SMTItem_SprHFEd() {
            super("HFEd", SpriteScreen.sprReg5HFrontEndPort, 8);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB080A.w 7-0 End character number of horizontal front porch", "ja", "$EB080A.w 7-0 \u6c34\u5e73\u30d5\u30ed\u30f3\u30c8\u30dd\u30fc\u30c1\u306e\u7d42\u4e86\u30ad\u30e3\u30e9\u30af\u30bf\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg5HFrontEndMask = this.smiMaskValue;
            SpriteScreen.sprReg5HFrontEndTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg5HFrontEndMask == 0 ? SpriteScreen.sprReg5HFrontEndPort : SpriteScreen.sprReg5HFrontEndTest;
            if (SpriteScreen.sprReg5HFrontEndCurr != n) {
                SpriteScreen.sprReg5HFrontEndCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprHBEd
    extends SMTItem {
        public SMTItem_SprHBEd() {
            super("HBEd", SpriteScreen.sprReg6HBackEndPort, 6);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB080C.w 5-0 End character number of horizontal back porch", "ja", "$EB080C.w 5-0 \u6c34\u5e73\u30d0\u30c3\u30af\u30dd\u30fc\u30c1\u306e\u7d42\u4e86\u30ad\u30e3\u30e9\u30af\u30bf\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg6HBackEndMask = this.smiMaskValue;
            SpriteScreen.sprReg6HBackEndTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg6HBackEndMask == 0 ? SpriteScreen.sprReg6HBackEndPort : SpriteScreen.sprReg6HBackEndTest;
            if (SpriteScreen.sprReg6HBackEndCurr != n) {
                SpriteScreen.sprReg6HBackEndCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprVBEd
    extends SMTItem {
        public SMTItem_SprVBEd() {
            super("VBEd", SpriteScreen.sprReg7VBackEndPort, 8);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB080E.w 7-0 End raster number of vertical back porch", "ja", "$EB080E.w 7-0 \u5782\u76f4\u30d0\u30c3\u30af\u30dd\u30fc\u30c1\u306e\u7d42\u4e86\u30e9\u30b9\u30bf\u756a\u53f7");
        }

        @Override
        public void smiControlled() {
            int n;
            SpriteScreen.sprReg7VBackEndMask = this.smiMaskValue;
            SpriteScreen.sprReg7VBackEndTest = this.smiTestValue;
            int n2 = n = SpriteScreen.sprReg7VBackEndMask == 0 ? SpriteScreen.sprReg7VBackEndPort : SpriteScreen.sprReg7VBackEndTest;
            if (SpriteScreen.sprReg7VBackEndCurr != n) {
                SpriteScreen.sprReg7VBackEndCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprHigh
    extends SMTItem {
        public SMTItem_SprHigh() {
            super("High", SpriteScreen.sprReg8ResoPort >> 4, 1);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0810.w 4 High-resolution", "ja", "$EB0810.w 4 \u9ad8\u89e3\u50cf\u5ea6");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg8ResoPort & ~(SpriteScreen.sprReg8ResoMask = SpriteScreen.sprReg8ResoMask & 0xFFFFFFEF | this.smiMaskValue & 0x10) | (SpriteScreen.sprReg8ResoTest = SpriteScreen.sprReg8ResoTest & 0xFFFFFFEF | this.smiTestValue << 4) & SpriteScreen.sprReg8ResoMask;
            if (SpriteScreen.sprReg8ResoCurr != n) {
                SpriteScreen.sprReg8ResoCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprVRes
    extends SMTItem {
        public SMTItem_SprVRes() {
            super("VRes", SpriteScreen.sprReg8ResoPort >> 2, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0810.w 3-2 Vertical resolution", "ja", "$EB0810.w 3-2 \u5782\u76f4\u89e3\u50cf\u5ea6");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg8ResoPort & ~(SpriteScreen.sprReg8ResoMask = SpriteScreen.sprReg8ResoMask & 0xFFFFFFF3 | this.smiMaskValue & 0xC) | (SpriteScreen.sprReg8ResoTest = SpriteScreen.sprReg8ResoTest & 0xFFFFFFF3 | this.smiTestValue << 2) & SpriteScreen.sprReg8ResoMask;
            if (SpriteScreen.sprReg8ResoCurr != n) {
                SpriteScreen.sprReg8ResoCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTItem_SprHRes
    extends SMTItem {
        public SMTItem_SprHRes() {
            super("HRes", SpriteScreen.sprReg8ResoPort, 2);
            Multilingual.mlnToolTipText(this.smiNameLabel, "en", "$EB0810.w 1-0 Horizontal resolution", "ja", "$EB0810.w 1-0 \u6c34\u5e73\u89e3\u50cf\u5ea6");
        }

        @Override
        public void smiControlled() {
            int n = SpriteScreen.sprReg8ResoPort & ~(SpriteScreen.sprReg8ResoMask = SpriteScreen.sprReg8ResoMask & 0xFFFFFFFC | this.smiMaskValue & 3) | (SpriteScreen.sprReg8ResoTest = SpriteScreen.sprReg8ResoTest & 0xFFFFFFFC | this.smiTestValue) & SpriteScreen.sprReg8ResoMask;
            if (SpriteScreen.sprReg8ResoCurr != n) {
                SpriteScreen.sprReg8ResoCurr = n;
                if (VideoController.vcnReg3Curr << 25 < 0 && SpriteScreen.sprReg4BgCtrlCurr << 22 < 0) {
                    CRTC.crtAllStamp += 2;
                    if (XEiJ.mpuTask == null) {
                        CRTC.crtRepaint();
                    }
                }
            }
        }
    }

    public static class SMTGroup {
        public SMTItem[] smgItemArray;
        public ButtonGroup smgButtonGroup;
        public Box smgBox;
        public JRadioButton smgPortRadioButton;
        public JRadioButton smgTestRadioButton;

        public SMTGroup(SMTItem ... sMTItemArray) {
            for (SMTItem sMTItem : this.smgItemArray = sMTItemArray) {
                sMTItem.smiItemGroup = this;
            }
            this.smgButtonGroup = new ButtonGroup();
            Component[] componentArray = new Component[2];
            componentArray[0] = Box.createVerticalStrut(LnF.lnfFontSize + 4);
            Component[] componentArray2 = new Component[3];
            componentArray2[0] = ComponentFactory.createVerticalBox(Box.createVerticalGlue(), ComponentFactory.setFixedSize(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(XEiJ.createImage(14, 18, "111111111111111............11............11............11....1111....11....1..1....11....1..1....11....1..1....11....1..1....11.1111..1111.11..1......1..11...1....1...11....1..1....11.....11.....11............11............11............111111111111111", LnF.lnfRGB[0], LnF.lnfRGB[12]), "Copy port data to test data", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.smgCopyClicked();
                }
            }), "ja", "\u30dd\u30fc\u30c8\u30c7\u30fc\u30bf\u3092\u30c6\u30b9\u30c8\u30c7\u30fc\u30bf\u306b\u30b3\u30d4\u30fc\u3059\u308b"), 16, 20), Box.createVerticalGlue());
            componentArray2[1] = Box.createHorizontalStrut(2);
            Component[] componentArray3 = new Component[2];
            this.smgPortRadioButton = ComponentFactory.setFixedSize(Multilingual.mlnToolTipText(ComponentFactory.createRadioButton(this.smgButtonGroup, this.smgIsPortSelected(), "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.smgPortSelected();
                }
            }), "en", "Reflect port data", "ja", "\u30dd\u30fc\u30c8\u30c7\u30fc\u30bf\u3092\u53cd\u6620\u3055\u305b\u308b"), 14, LnF.lnfFontSize + 4);
            componentArray3[0] = this.smgPortRadioButton;
            this.smgTestRadioButton = ComponentFactory.setFixedSize(Multilingual.mlnToolTipText(ComponentFactory.createRadioButton(this.smgButtonGroup, this.smgIsTestSelected(), "", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.smgTestSelected();
                }
            }), "en", "Reflect test data", "ja", "\u30c6\u30b9\u30c8\u30c7\u30fc\u30bf\u3092\u53cd\u6620\u3055\u305b\u308b"), 14, LnF.lnfFontSize + 4);
            componentArray3[1] = this.smgTestRadioButton;
            componentArray2[2] = ComponentFactory.createVerticalBox(componentArray3);
            componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
            this.smgBox = ComponentFactory.setFixedSize(ComponentFactory.createVerticalBox(componentArray), 32, (LnF.lnfFontSize + 4) * 3);
        }

        public final boolean smgIsPortSelected() {
            for (SMTItem sMTItem : this.smgItemArray) {
                if (sMTItem.smiMaskValue == 0) continue;
                return false;
            }
            return true;
        }

        public final boolean smgIsTestSelected() {
            for (SMTItem sMTItem : this.smgItemArray) {
                if (sMTItem.smiMaskValue != 0) continue;
                return false;
            }
            return true;
        }

        public void smgCopyClicked() {
            for (SMTItem sMTItem : this.smgItemArray) {
                if (sMTItem.smiBitWidth == 1) {
                    sMTItem.smiTestCheckBox.setSelected(sMTItem.smiPortValue != 0);
                } else {
                    sMTItem.smiTestSpinner.setIntValue(sMTItem.smiPortValue);
                }
                sMTItem.smiTestChanged();
            }
        }

        public void smgPortSelected() {
            for (SMTItem sMTItem : this.smgItemArray) {
                sMTItem.smiPortRadioButton.setSelected(true);
                sMTItem.smiPortSelected();
            }
        }

        public void smgTestSelected() {
            for (SMTItem sMTItem : this.smgItemArray) {
                sMTItem.smiTestRadioButton.setSelected(true);
                sMTItem.smiTestSelected();
            }
        }

        public void smgUpdate() {
            if (this.smgIsPortSelected()) {
                this.smgPortRadioButton.setSelected(true);
            } else if (this.smgIsTestSelected()) {
                this.smgTestRadioButton.setSelected(true);
            } else {
                this.smgButtonGroup.clearSelection();
            }
        }
    }
}

