/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JFrame;

public class RestorableFrame
extends JFrame {
    static final boolean DEBUG = false;
    static HashMap<String, Info> rfmMap = new HashMap();
    Info info;

    public static void rfmSet(String string, int[] nArray, int n, boolean bl) {
        Info info = rfmMap.get(string);
        if (info == null) {
            info = new Info(string, null);
            rfmMap.put(string, info);
            info.set(nArray, n, bl);
        } else {
            info.set(nArray, n, bl);
            info.restore();
        }
    }

    public static int[] rfmGetRect(String string) {
        return rfmMap.get(string).getRect();
    }

    public static int rfmGetState(String string) {
        return rfmMap.get(string).getState();
    }

    public static boolean rfmGetOpened(String string) {
        return rfmMap.get(string).getOpened();
    }

    public RestorableFrame(String string, String string2) {
        super(string2, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        Info info = rfmMap.get(string);
        if (info == null) {
            this.info = info = new Info(string, this);
        } else {
            this.info = info;
            info.setFrame(this);
            info.restore();
        }
    }

    public static BufferedImage rfmCapture(String string) {
        return rfmMap.get(string).capture();
    }

    static class Info {
        String key;
        RestorableFrame frame;
        int x;
        int y;
        int width;
        int height;
        int state;
        boolean opened;

        Info(String string, RestorableFrame restorableFrame) {
            this.key = string;
            this.frame = restorableFrame;
        }

        void setFrame(RestorableFrame restorableFrame) {
            this.frame = restorableFrame;
        }

        void set(int[] nArray, int n, boolean bl) {
            this.x = nArray[0];
            this.y = nArray[1];
            this.width = nArray[2];
            this.height = nArray[3];
            this.state = n;
            this.opened = bl;
        }

        void restore() {
            block5: {
                Rectangle rectangle = new Rectangle(this.x, this.y, this.width, 48);
                for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                    for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                        Rectangle rectangle2 = rectangle.intersection(graphicsConfiguration.getBounds());
                        if (48 > rectangle2.width || 48 > rectangle2.height) {
                            continue;
                        }
                        break block5;
                    }
                }
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                Rectangle rectangle3 = graphicsConfiguration.getBounds();
                this.x = Math.min(this.x, rectangle3.x + rectangle3.width - 48);
                if (0 < this.width) {
                    this.x = Math.max(this.x + this.width, rectangle3.x + 48) - this.width;
                }
                this.y = Math.min(this.y, rectangle3.y + rectangle3.height - 48);
                this.y = Math.max(this.y, rectangle3.y);
            }
            this.frame.setLocation(this.x, this.y);
            if (0 < this.width && 0 < this.height) {
                this.frame.setSize(this.width, this.height);
                this.frame.setPreferredSize(new Dimension(this.width, this.height));
            }
            this.frame.setExtendedState(this.state);
            this.frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    this.record(false);
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.record(false);
                }
            });
            this.frame.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent windowEvent) {
                    this.record(false);
                }
            });
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    this.record(true);
                }

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    this.record(false);
                }
            });
        }

        void record(boolean bl) {
            if (this.frame != GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getFullScreenWindow()) {
                boolean bl2;
                boolean bl3 = bl2 = !bl && this.frame.isShowing();
                if (bl2) {
                    Point point = this.frame.getLocationOnScreen();
                    Dimension dimension = this.frame.getSize();
                    int n = this.frame.getExtendedState();
                    if ((n & 3) == 0) {
                        this.x = point.x;
                        this.width = dimension.width;
                    }
                    if ((n & 5) == 0) {
                        this.y = point.y;
                        this.height = dimension.height;
                    }
                    this.state = n;
                }
                this.opened = bl2;
            }
        }

        int[] getRect() {
            return new int[]{this.x, this.y, this.width, this.height};
        }

        int getState() {
            return this.state;
        }

        boolean getOpened() {
            return this.opened;
        }

        BufferedImage capture() {
            if (this.frame != null) {
                try {
                    Point point = this.frame.getLocationOnScreen();
                    Dimension dimension = this.frame.getSize();
                    if (0 < dimension.width && 0 < dimension.height) {
                        return new Robot().createScreenCapture(new Rectangle(point.x, point.y, dimension.width, dimension.height));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

