/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.CRC32;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import xeij.ByteQueue;
import xeij.CharacterCode;
import xeij.ComponentFactory;
import xeij.DecimalSpinner;
import xeij.DnT;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RP5C15;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.Settings;
import xeij.TickerQueue;
import xeij.XEiJ;
import xeij.Z8530;

public class RS232CTerminal {
    public static final int TRM_MAX_OUTPUT_LENGTH = 262144;
    public static final int TRM_CUT_OUTPUT_LENGTH = 278528;
    public static JFrame trmFrame;
    public static ScrollTextArea trmBoard;
    public static JPopupMenu trmPopupMenu;
    public static JMenuItem trmPopupCutMenuItem;
    public static JMenuItem trmPopupCopyMenuItem;
    public static JMenuItem trmPopupPasteMenuItem;
    public static JMenuItem trmPopupSelectAllMenuItem;
    public static JMenuItem trmPopupSendCtrlCMenuItem;
    public static StringBuilder trmOutputBuilder;
    public static int trmOutputEnd;
    public static int trmOutputSJIS1;
    public static SerialPort[] trmPortArray;
    public static int trmNumberOfPorts;
    public static int trmRows;
    public static String[] trmRowName;
    public static int[] trmRowToCol;
    public static int trmNumberOfAUXs;
    public static int trmCols;
    public static String[] trmColName;
    public static int[] trmColToRow;
    public static final String TRM_TCPIP_DEFAULT_HOST = "0.0.0.0";
    public static final int TRM_TCPIP_DEFAULT_PORT = 54321;
    public static String trmTcpipHost;
    public static int trmTcpipPort;
    public static boolean trmTcpipUTF8;
    public static DecimalSpinner trmTcpipSpinner;
    public static JCheckBox trmTcpipCheckBox;
    public static ByteBuffer trmTcpipReadBuffer;
    public static CompletionHandler<Integer, Void> trmTcpipReadHander;
    public static CompletionHandler<AsynchronousSocketChannel, Void> trmTcpipAcceptHandler;
    public static ByteQueue trmTcpipReadQueue;
    public static SocketAddress trmTcpipPortAddress;
    public static AsynchronousServerSocketChannel trmTcpipPortChannel;
    public static final int TRM_TCPIP_BUFFER_SIZE = 4096;
    public static AsynchronousSocketChannel trmTcpipSessionChannel;
    public static SocketAddress trmTcpipClientAddress;
    public static int trmTcpipToUTF8Pool;
    public static int trmTcpipToSJISPool;
    public static boolean trmAUXFlowControlRTS;
    public static boolean trmAUXFlowControlXON;
    public static boolean trmAUXNotReceiving;
    public static int trmAUXDataBuffer;
    public static boolean trmAUXDataAvailable;
    public static boolean trmAUXSendEmpty;
    public static final TickerQueue.Ticker trmAUXSendTicker;
    public static Connection trmAUXConnection;
    public static final TickerQueue.Ticker trmAUXTicker;
    public static int trmRSDRV202Head;
    public static int trmTMSIO031Head;
    public static int trmBSIO021Head;
    public static final TickerQueue.Ticker trmAUXFlowControlTicker;
    public static Connection[] trmConnectionArray;
    public static Box trmConnectionBox;
    public static ActionListener trmConnectionListener;
    public static boolean trmRefreshEnabled;
    public static JButton trmRefreshButton;
    public static boolean trmSettingsEnabled;
    public static String[] trmBaudRateArray;
    public static int trmBaudRateIndex;
    public static String[] trmDataBitsArray;
    public static int trmDataBitsIndex;
    public static String[] trmParityArray;
    public static int trmParityIndex;
    public static String[] trmStopBitsArray;
    public static int trmStopBitsIndex;
    public static String[] trmFlowControlArray;
    public static int trmFlowControlIndex;
    public static JComboBox<String> trmBaudRateComboBox;
    public static JComboBox<String> trmDataBitsComboBox;
    public static JComboBox<String> trmParityComboBox;
    public static JComboBox<String> trmStopBitsComboBox;
    public static JComboBox<String> trmFlowControlComboBox;
    public static boolean trmSendEnabled;
    public static JButton trmSendButton;
    public static JFileChooser trmSendFileChooser;
    public static JDialog trmSendDialog;
    public static SendThread trmSendThread;
    public static JTextField trmAdditionalTextField;
    public static final byte[] adotr1;
    public static final byte[] adotr2;
    public static final byte[] adotr3;

    public static void trmTcpipInit() {
        trmTcpipHost = Settings.sgsGetString("tcpiphost");
        if (trmTcpipHost.equals("")) {
            trmTcpipHost = TRM_TCPIP_DEFAULT_HOST;
        }
        if ((trmTcpipPort = Settings.sgsGetInt("tcpipport", 54321)) < 0 || 65535 < trmTcpipPort) {
            trmTcpipPort = 54321;
        }
        trmTcpipUTF8 = Settings.sgsGetOnOff("tcpiputf8");
        trmTcpipSpinner = ComponentFactory.createDecimalSpinner(trmTcpipPort, 0, 65535, 1, 0, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                trmTcpipPort = trmTcpipSpinner.getIntValue();
            }
        });
        trmTcpipCheckBox = ComponentFactory.createCheckBox(trmTcpipUTF8, "UTF-8", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                trmTcpipUTF8 = trmTcpipCheckBox.isSelected();
            }
        });
        trmTcpipReadBuffer = ByteBuffer.allocate(4096);
        trmTcpipReadHander = new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer n, Void void_) {
                int n2 = n;
                if (n2 == -1) {
                    RS232CTerminal.trmTcpipCloseSession(true);
                    return;
                }
                byte[] byArray = new byte[n2];
                int n3 = 0;
                trmTcpipReadBuffer.flip();
                trmTcpipReadBuffer.get(byArray, n3, n2);
                byte[] byArray2 = byArray;
                int n4 = n2;
                if (trmTcpipUTF8) {
                    int n5 = trmTcpipToSJISPool;
                    byArray2 = new byte[2 * n2];
                    n4 = 0;
                    for (int i = 0; i < n2; ++i) {
                        int n6;
                        int n7 = n5 << 8 | 0xFF & byArray[n3 + i];
                        if ((n7 & 0xFFFFFFE0) == 192 || (n7 & 0xFFFFFFF0) == 224 || (n7 & 0xFFFFF0C0) == 57472 || (n7 & 0xFFFFFFF8) == 240 || (n7 & 0xFFFFF8C0) == 61568 || (n7 & 0xFFF8C0C0) == 0xF08080) {
                            n5 = n7;
                            continue;
                        }
                        n5 = 0;
                        if ((n7 & 0xFFFFFF80) != 0) {
                            if ((n7 & 0xFFFFE0C0) == 49280) {
                                n7 = (n7 & 0x1F00) >> 2 | n7 & 0x3F;
                            } else if ((n7 & 0xFFF0C0C0) == 0xE08080) {
                                n7 = (n7 & 0xF0000) >> 4 | (n7 & 0x3F00) >> 2 | n7 & 0x3F;
                            } else if ((n7 & 0xF8C0C0C0) == -260013952) {
                                if (0x10FFFF < (n7 = (n7 & 0x7000000) >> 6 | (n7 & 0x3F0000) >> 4 | (n7 & 0x3F00) >> 2 | n7 & 0x3F)) {
                                    n7 = 8251;
                                } else if (65535 < n7) {
                                    n7 = 8251;
                                }
                            } else {
                                n7 = 8251;
                            }
                        }
                        if ((n6 = CharacterCode.chrCharToSJIS[n7]) == 0 && n7 != 0) {
                            n6 = 33190;
                        }
                        if (255 < n6) {
                            byArray2[n4++] = (byte)(n6 >> 8);
                        }
                        byArray2[n4++] = (byte)n6;
                    }
                    trmTcpipToSJISPool = n5;
                }
                trmTcpipReadQueue.write(byArray2, 0, n4);
                if (trmTcpipSessionChannel != null) {
                    trmTcpipReadBuffer.clear();
                    trmTcpipSessionChannel.read(trmTcpipReadBuffer, null, trmTcpipReadHander);
                }
            }

            @Override
            public void failed(Throwable throwable, Void void_) {
                String string = throwable.getMessage();
                if (string != null) {
                    System.err.println(string);
                }
                RS232CTerminal.trmTcpipCloseSession(true);
            }
        };
        trmTcpipAcceptHandler = new CompletionHandler<AsynchronousSocketChannel, Void>(){

            @Override
            public void completed(AsynchronousSocketChannel asynchronousSocketChannel, Void void_) {
                trmTcpipSessionChannel = asynchronousSocketChannel;
                trmTcpipToUTF8Pool = 0;
                trmTcpipToSJISPool = 0;
                try {
                    trmTcpipClientAddress = trmTcpipSessionChannel.getRemoteAddress();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                System.out.println(Multilingual.mlnJapanese ? String.valueOf(trmTcpipClientAddress) + " \u3068\u63a5\u7d9a\u3057\u307e\u3057\u305f" : String.valueOf(trmTcpipClientAddress) + " connected");
                if (trmTcpipSessionChannel != null) {
                    trmTcpipReadBuffer.clear();
                    trmTcpipSessionChannel.read(trmTcpipReadBuffer, null, trmTcpipReadHander);
                }
            }

            @Override
            public void failed(Throwable throwable, Void void_) {
                String string = throwable.getMessage();
                if (string != null) {
                    System.err.println(string);
                }
                RS232CTerminal.trmTcpipClosePort();
            }
        };
    }

    public static void trmTcpipTini() {
        Settings.sgsPutString("tcpiphost", trmTcpipHost);
        Settings.sgsPutInt("tcpipport", trmTcpipPort);
        Settings.sgsPutOnOff("tcpiputf8", trmTcpipUTF8);
    }

    public static boolean trmTcpipOpenPort(ByteQueue byteQueue) {
        trmTcpipReadQueue = byteQueue;
        trmTcpipPortAddress = new InetSocketAddress(trmTcpipHost, trmTcpipPort);
        try {
            trmTcpipPortChannel = AsynchronousServerSocketChannel.open().bind(trmTcpipPortAddress);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(Multilingual.mlnJapanese ? String.valueOf(trmTcpipPortAddress) + " \u3092\u958b\u3051\u307e\u305b\u3093" : String.valueOf(trmTcpipPortAddress) + " not opened");
            return false;
        }
        System.out.println(Multilingual.mlnJapanese ? String.valueOf(trmTcpipPortAddress) + " \u3092\u958b\u304d\u307e\u3057\u305f" : String.valueOf(trmTcpipPortAddress) + " opened");
        if (trmTcpipPortChannel != null) {
            trmTcpipPortChannel.accept(null, trmTcpipAcceptHandler);
        }
        return true;
    }

    public static void trmTcpipClosePort() {
        if (trmTcpipPortAddress != null) {
            System.out.println(Multilingual.mlnJapanese ? String.valueOf(trmTcpipPortAddress) + " \u3092\u9589\u3058\u307e\u3057\u305f" : String.valueOf(trmTcpipPortAddress) + " closed");
            trmTcpipPortAddress = null;
        }
        if (trmTcpipPortChannel != null && trmTcpipPortChannel.isOpen()) {
            try {
                trmTcpipPortChannel.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        trmTcpipPortChannel = null;
        RS232CTerminal.trmTcpipCloseSession(false);
    }

    public static void trmTcpipWrite(byte[] byArray, int n, int n2) {
        if (trmTcpipSessionChannel != null) {
            byte[] byArray2 = byArray;
            int n3 = n2;
            if (trmTcpipUTF8) {
                int n4 = trmTcpipToUTF8Pool;
                byArray2 = new byte[3 * n2];
                n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n5 = n4 << 8 | 0xFF & byArray[n + i];
                    if (128 <= n5 && n5 <= 159 || 224 <= n5 && n5 <= 255) {
                        n4 = n5;
                        continue;
                    }
                    n4 = 0;
                    int n6 = CharacterCode.chrSJISToChar[n5];
                    if (n6 == 0 && n5 != 0) {
                        n6 = 65533;
                    }
                    if (n6 <= 127) {
                        byArray2[n3++] = (byte)n6;
                        continue;
                    }
                    if (n6 <= 2047) {
                        byArray2[n3++] = (byte)(0xC0 | n6 >> 6);
                        byArray2[n3++] = (byte)(0x80 | n6 & 0x3F);
                        continue;
                    }
                    byArray2[n3++] = (byte)(0xE0 | n6 >> 12);
                    byArray2[n3++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                    byArray2[n3++] = (byte)(0x80 | n6 & 0x3F);
                }
                trmTcpipToUTF8Pool = n4;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
            byteBuffer.put(byArray2, 0, n3);
            byteBuffer.flip();
            try {
                trmTcpipSessionChannel.write(byteBuffer).get();
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                if (string != null) {
                    System.err.println(string);
                }
                RS232CTerminal.trmTcpipCloseSession(true);
            }
        }
    }

    public static void trmTcpipCloseSession(boolean bl) {
        if (trmTcpipSessionChannel == null) {
            return;
        }
        if (trmTcpipClientAddress != null) {
            System.out.println(Multilingual.mlnJapanese ? String.valueOf(trmTcpipClientAddress) + " \u3068\u306e\u63a5\u7d9a\u3092\u9589\u3058\u307e\u3057\u305f" : String.valueOf(trmTcpipClientAddress) + " disconnected");
            trmTcpipClientAddress = null;
        }
        try {
            trmTcpipSessionChannel.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        trmTcpipSessionChannel = null;
        if (bl && trmTcpipPortChannel != null) {
            trmTcpipPortChannel.accept(null, trmTcpipAcceptHandler);
        }
    }

    public static int trmAUXReadData() {
        trmAUXDataAvailable = false;
        return trmAUXDataBuffer;
    }

    public static void trmAUXWriteData(int n) {
        int n2 = 1;
        int n3 = trmColToRow[n2];
        if (n3 < 0) {
            return;
        }
        n &= 0xFF;
        if (trmAUXFlowControlXON) {
            if (n == 17) {
                trmAUXNotReceiving = false;
                return;
            }
            if (n == 19) {
                trmAUXNotReceiving = true;
                return;
            }
        }
        RS232CTerminal.trmConnectionArray[RS232CTerminal.trmCols * n3 + n2 - 1].col2rowQueue.write(n);
        trmAUXSendEmpty = false;
        TickerQueue.tkqAdd(trmAUXSendTicker, XEiJ.mpuClockTime + Z8530.scc1aInterval);
    }

    public static void trmAUXSetNotReceiving(boolean bl) {
        trmAUXNotReceiving = bl;
    }

    public static int trmAUXReadCommand() {
        return trmAUXConnection == null ? 0 : 0x28 | (trmAUXSendEmpty ? 4 : 0) | (trmAUXDataAvailable ? 1 : 0);
    }

    public static void trmAUXReset() {
        if (trmAUXConnection != null) {
            TickerQueue.tkqRemove(trmAUXFlowControlTicker);
            RS232CTerminal.trmAUXConnection.row2colReset = true;
            RS232CTerminal.trmAUXConnection.col2rowReset = true;
        }
    }

    public static void trmInitConnection() {
        trmBaudRateArray = new String[]{"75", "150", "300", "600", "1200", "2400", "4800", "9600", "19200", "31250", "38400", "50000", "57600", "76800", "115200", "230400"};
        trmBaudRateIndex = 10;
        trmDataBitsArray = new String[]{"B5", "B6", "B7", "B8"};
        trmDataBitsIndex = 3;
        trmParityArray = new String[]{"PN", "PO", "PE"};
        trmParityIndex = 0;
        trmStopBitsArray = new String[]{"S1", "S1.5", "S2"};
        trmStopBitsIndex = 0;
        trmFlowControlArray = new String[]{"NONE", "XON", "RTS"};
        trmFlowControlIndex = 2;
        trmBaudRateComboBox = null;
        trmDataBitsComboBox = null;
        trmParityComboBox = null;
        trmStopBitsComboBox = null;
        trmFlowControlComboBox = null;
        block4: for (String string : Settings.sgsGetString("terminalsettings").split("/")) {
            int n;
            for (n = 0; n < trmBaudRateArray.length; ++n) {
                if (!trmBaudRateArray[n].equals(string)) continue;
                trmBaudRateIndex = n;
                break;
            }
            for (n = 0; n < trmDataBitsArray.length; ++n) {
                if (!trmDataBitsArray[n].equals(string)) continue;
                trmDataBitsIndex = n;
                break;
            }
            for (n = 0; n < trmParityArray.length; ++n) {
                if (!trmParityArray[n].equals(string)) continue;
                trmParityIndex = n;
                break;
            }
            for (n = 0; n < trmStopBitsArray.length; ++n) {
                if (!trmStopBitsArray[n].equals(string)) continue;
                trmStopBitsIndex = n;
                break;
            }
            for (n = 0; n < trmFlowControlArray.length; ++n) {
                if (!trmFlowControlArray[n].equals(string)) continue;
                trmFlowControlIndex = n;
                continue block4;
            }
        }
        trmSendButton = null;
        trmSendFileChooser = null;
        trmSendDialog = null;
        trmSendThread = null;
        trmPortArray = new SerialPort[0];
        trmNumberOfPorts = 0;
        trmRows = 1;
        trmRowName = new String[1];
        RS232CTerminal.trmRowName[0] = "Terminal";
        trmRowToCol = new int[1];
        Arrays.fill(trmRowToCol, -1);
        trmNumberOfAUXs = 0;
        trmCols = 1;
        trmColName = new String[1];
        RS232CTerminal.trmColName[0] = "Terminal";
        trmColToRow = new int[1];
        Arrays.fill(trmColToRow, -1);
        Object object = Settings.sgsGetString("additionalport");
        try {
            object = URLDecoder.decode((String)object, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = "";
        }
        trmAdditionalTextField = ComponentFactory.createTextField((String)object, 30);
        RS232CTerminal.trmTcpipInit();
        trmConnectionArray = new Connection[0];
        trmConnectionBox = ComponentFactory.createVerticalBox(Box.createVerticalGlue(), ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Additional port "), "ja", "\u8ffd\u52a0\u30dd\u30fc\u30c8 "), trmAdditionalTextField, Multilingual.mlnText(ComponentFactory.createLabel(" TCP/IP port "), "ja", " TCP/IP \u30dd\u30fc\u30c8 "), trmTcpipSpinner, Box.createHorizontalStrut(5), trmTcpipCheckBox, Box.createHorizontalGlue()));
        trmConnectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                for (Connection connection : trmConnectionArray) {
                    if (!connection.text.equals(string)) continue;
                    if (connection.connected) {
                        RS232CTerminal.trmDisconnect(connection);
                        break;
                    }
                    RS232CTerminal.trmConnect(connection);
                    break;
                }
            }
        };
        trmRefreshEnabled = false;
        trmRefreshButton = null;
        trmSettingsEnabled = false;
        trmSendEnabled = false;
        RS232CTerminal.trmUpdateConnection();
        object = new HashSet();
        for (String string : Settings.sgsGetString("rs232cconnection").split("/")) {
            try {
                ((HashSet)object).add(URLDecoder.decode(string, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        for (Connection connection : trmConnectionArray) {
            if (!((HashSet)object).contains(connection.text)) continue;
            RS232CTerminal.trmConnect(connection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void trmTiniConnection() {
        void charSequence2;
        CharSequence charSequence = new StringBuilder();
        Connection[] connectionArray = trmConnectionArray;
        int n = connectionArray.length;
        boolean i = false;
        while (charSequence2 < n) {
            Connection connection = connectionArray[charSequence2];
            if (connection.connected) {
                if (((StringBuilder)charSequence).length() != 0) {
                    ((StringBuilder)charSequence).append('/');
                }
                try {
                    ((StringBuilder)charSequence).append(URLEncoder.encode(connection.text, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            ++charSequence2;
        }
        Settings.sgsPutString("rs232cconnection", ((StringBuilder)charSequence).toString());
        charSequence = trmAdditionalTextField.getText();
        try {
            charSequence = URLEncoder.encode((String)charSequence, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            charSequence = "";
        }
        Settings.sgsPutString("additionalport", (String)charSequence);
        RS232CTerminal.trmTcpipTini();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(trmBaudRateArray[trmBaudRateIndex]);
        ((StringBuilder)charSequence).append('/');
        ((StringBuilder)charSequence).append(trmDataBitsArray[trmDataBitsIndex]);
        ((StringBuilder)charSequence).append('/');
        ((StringBuilder)charSequence).append(trmParityArray[trmParityIndex]);
        ((StringBuilder)charSequence).append('/');
        ((StringBuilder)charSequence).append(trmStopBitsArray[trmStopBitsIndex]);
        ((StringBuilder)charSequence).append('/');
        ((StringBuilder)charSequence).append(trmFlowControlArray[trmFlowControlIndex]);
        Settings.sgsPutString("terminalsettings", ((StringBuilder)charSequence).toString());
        for (CharSequence charSequence3 : trmConnectionArray) {
            RS232CTerminal.trmDisconnect((Connection)((Object)charSequence3));
        }
    }

    public static boolean trmIsConnectionUpdatable() {
        for (Connection connection : trmConnectionArray) {
            if (connection.row == 0 || !connection.connected) continue;
            return false;
        }
        return true;
    }

    public static void trmUpdateConnection() {
        int n;
        if (!RS232CTerminal.trmIsConnectionUpdatable()) {
            return;
        }
        ArrayList<SerialPort> arrayList = new ArrayList<SerialPort>();
        for (SerialPort object : SerialPort.getCommPorts()) {
            int n2 = object.getVendorID();
            int n3 = object.getProductID();
            arrayList.add(object);
        }
        Object[] objectArray = trmAdditionalTextField.getText().split(",");
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object = objectArray[i];
            String string = ((String)object).trim();
            if (string.equals("")) continue;
            try {
                SerialPort serialPort = SerialPort.getCommPort(string);
                if (serialPort != null) {
                    if (serialPort == null) continue;
                    arrayList.add(serialPort);
                    continue;
                }
                System.out.println(string + " not found");
                continue;
            }
            catch (SerialPortInvalidPortException serialPortInvalidPortException) {
                System.out.println(serialPortInvalidPortException.toString());
            }
        }
        trmNumberOfPorts = arrayList.size();
        trmPortArray = arrayList.toArray(new SerialPort[trmNumberOfPorts]);
        trmRows = 1 + trmNumberOfPorts + 1;
        trmRowName = new String[trmRows];
        RS232CTerminal.trmRowName[0] = "Terminal";
        for (n = 1; n < trmRows - 1; ++n) {
            SerialPort serialPort = trmPortArray[n - 1];
            RS232CTerminal.trmRowName[n] = serialPort.getSystemPortName() + "(" + serialPort.getPortDescription() + ")";
        }
        RS232CTerminal.trmRowName[RS232CTerminal.trmRows - 1] = "TCP/IP";
        trmRowToCol = new int[trmRows];
        Arrays.fill(trmRowToCol, -1);
        trmNumberOfAUXs = 1;
        trmCols = 1 + trmNumberOfAUXs;
        trmColName = new String[trmCols];
        RS232CTerminal.trmColName[0] = "Terminal";
        for (n = 1; n < trmCols; ++n) {
            RS232CTerminal.trmColName[n] = n == 1 ? "AUX" : "AUX" + n;
        }
        trmColToRow = new int[trmCols];
        Arrays.fill(trmColToRow, -1);
        for (n = trmConnectionArray.length - 1; 0 <= n; --n) {
            trmConnectionBox.remove(n);
        }
        trmConnectionArray = new Connection[trmCols * trmRows - 1];
        for (n = 0; n < trmRows; ++n) {
            for (n4 = 0; n4 < trmCols; ++n4) {
                if (n4 == 0 && n == 0) continue;
                Connection connection = new Connection();
                connection.row = n;
                connection.col = n4;
                connection.index = trmCols * n + n4 - 1;
                connection.text = trmRowName[n] + " \u21d4 " + trmColName[n4];
                connection.connected = false;
                connection.checkBox = ComponentFactory.createCheckBox(connection.connected, connection.text, trmConnectionListener);
                connection.box = ComponentFactory.createHorizontalBox(connection.checkBox, Box.createHorizontalGlue());
                RS232CTerminal.trmConnectionArray[connection.index] = connection;
                trmConnectionBox.add((Component)connection.box, connection.index);
            }
        }
        RS232CTerminal.trmUpdateComponents();
        trmConnectionBox.validate();
    }

    public static void trmUpdateComponents() {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (Connection connection : trmConnectionArray) {
            if (connection.connected) {
                connection.checkBox.setEnabled(true);
                if (connection.row != trmRows - 1 && 0 < connection.row) {
                    bl = false;
                    if (connection.col == 0) {
                        bl2 = true;
                    }
                }
                if (connection.row != 0 && connection.col != 0) continue;
                bl3 = true;
                continue;
            }
            connection.checkBox.setEnabled(RS232CTerminal.trmIsConnectable(connection));
        }
        trmRefreshEnabled = bl;
        if (trmRefreshButton != null) {
            trmRefreshButton.setEnabled(bl);
        }
        trmSettingsEnabled = bl2;
        trmSendEnabled = bl3;
        if (trmBaudRateComboBox != null) {
            trmBaudRateComboBox.setEnabled(bl2);
            trmDataBitsComboBox.setEnabled(bl2);
            trmParityComboBox.setEnabled(bl2);
            trmStopBitsComboBox.setEnabled(bl2);
            trmFlowControlComboBox.setEnabled(bl2);
            trmSendButton.setEnabled(bl3);
        }
    }

    public static boolean trmIsConnectable(Connection connection) {
        if (!connection.connected) {
            for (Connection connection2 : trmConnectionArray) {
                if (connection == connection2 || !connection2.connected || (connection.row != 0 && connection.col != 0 || connection2.row != 0 && connection2.col != 0) && connection.row != connection2.row && connection.col != connection2.col) continue;
                return false;
            }
        }
        return true;
    }

    public static void trmConnect(Connection connection) {
        if (connection.connected || !RS232CTerminal.trmIsConnectable(connection)) {
            return;
        }
        connection.connected = true;
        connection.checkBox.setSelected(true);
        RS232CTerminal.trmRowToCol[connection.row] = connection.col;
        RS232CTerminal.trmColToRow[connection.col] = connection.row;
        RS232CTerminal.trmUpdateComponents();
        connection.row2colQueue = new ByteQueue();
        connection.col2rowQueue = new ByteQueue();
        if (connection.row == trmRows - 1) {
            if (!RS232CTerminal.trmTcpipOpenPort(connection.row2colQueue)) {
                // empty if block
            }
        } else if (0 < connection.row) {
            SerialPort serialPort = trmPortArray[connection.row - 1];
            serialPort.openPort();
            System.out.println(Multilingual.mlnJapanese ? connection.text + " \u3092\u958b\u304d\u307e\u3057\u305f" : connection.text + " opened");
            serialPort.setComPortTimeouts(272, 0, 0);
            serialPort.setFlowControl(0);
            RS232CTerminal.trmReflectSettings(connection.col);
            serialPort.addDataListener(connection);
        }
        connection.polling = true;
        Thread thread = connection.col == 0 ? connection.new Connection.TerminalThread() : (connection.row2colThread = null);
        connection.col2rowThread = connection.row == 0 ? connection.new Connection.TerminalThread() : (connection.row == trmRows - 1 ? connection.new Connection.TCPIPThread() : connection.new Connection.SerialPortThread());
        for (int i = 0; i < 2; ++i) {
            Thread thread2;
            Thread thread3 = thread2 = i == 0 ? connection.row2colThread : connection.col2rowThread;
            if (thread2 == null) continue;
            thread2.start();
        }
        if (connection.col == 1) {
            trmAUXNotReceiving = false;
            trmAUXDataBuffer = 0;
            trmAUXDataAvailable = false;
            trmAUXConnection = connection;
            TickerQueue.tkqAdd(trmAUXTicker, XEiJ.mpuClockTime + 1000000000L);
            trmAUXSendEmpty = true;
        }
    }

    public static void trmDisconnect(Connection connection) {
        if (!connection.connected) {
            return;
        }
        connection.connected = false;
        connection.checkBox.setSelected(connection.connected);
        RS232CTerminal.trmRowToCol[connection.row] = -1;
        RS232CTerminal.trmColToRow[connection.col] = -1;
        RS232CTerminal.trmUpdateComponents();
        if (trmAUXConnection != null) {
            TickerQueue.tkqRemove(trmAUXTicker);
            trmAUXConnection = null;
        }
        connection.polling = false;
        for (int i = 0; i < 2; ++i) {
            Thread thread;
            Thread thread2 = thread = i == 0 ? connection.row2colThread : connection.col2rowThread;
            if (thread == null) continue;
            connection.row2colThread = null;
            if (!thread.isAlive()) continue;
            thread.interrupt();
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (connection.col == 1) {
            TickerQueue.tkqRemove(trmAUXSendTicker);
        }
        if (connection.row == trmRows - 1) {
            RS232CTerminal.trmTcpipClosePort();
        } else if (0 < connection.row) {
            SerialPort serialPort = trmPortArray[connection.row - 1];
            serialPort.removeDataListener();
            serialPort.closePort();
            System.out.println(Multilingual.mlnJapanese ? connection.text + " \u3092\u9589\u3058\u307e\u3057\u305f" : connection.text + " closed");
        }
        connection.row2colQueue.clear();
        connection.col2rowQueue.clear();
        connection.row2colQueue = null;
        connection.col2rowQueue = null;
    }

    public static void trmSetBaudRate(int n) {
        if (0 <= n && n < trmBaudRateArray.length) {
            trmBaudRateIndex = n;
            RS232CTerminal.trmReflectSettings(0);
        }
    }

    public static void trmSetDataBits(int n) {
        if (0 <= n && n < trmDataBitsArray.length) {
            trmDataBitsIndex = n;
            RS232CTerminal.trmReflectSettings(0);
        }
    }

    public static void trmSetParity(int n) {
        if (0 <= n && n < trmParityArray.length) {
            trmParityIndex = n;
            RS232CTerminal.trmReflectSettings(0);
        }
    }

    public static void trmSetStopBits(int n) {
        if (0 <= n && n < trmStopBitsArray.length) {
            trmStopBitsIndex = n;
            RS232CTerminal.trmReflectSettings(0);
        }
    }

    public static void trmSetFlowControl(int n) {
        if (0 <= n && n < trmFlowControlArray.length) {
            trmFlowControlIndex = n;
            RS232CTerminal.trmReflectSettings(0);
        }
    }

    public static void trmReflectSettings(int n) {
        SerialPort serialPort;
        int n2 = trmColToRow[n];
        SerialPort serialPort2 = serialPort = n2 < 1 || trmNumberOfPorts < n2 ? null : trmPortArray[n2 - 1];
        if (n == 0) {
            String string = trmBaudRateArray[trmBaudRateIndex];
            String string2 = trmDataBitsArray[trmDataBitsIndex];
            String string3 = trmStopBitsArray[trmStopBitsIndex];
            String string4 = trmParityArray[trmParityIndex];
            String string5 = trmFlowControlArray[trmFlowControlIndex];
            if (serialPort != null) {
                serialPort.setComPortParameters(Integer.parseInt(string, 10), Integer.parseInt(string2.substring(1), 10), string3.equals("S1.5") ? 2 : (string3.equals("S2") ? 3 : 1), string4.equals("PO") ? 1 : (string4.equals("PE") ? 2 : 0));
                serialPort.setFlowControl(string5.equals("RTS") ? 17 : (string5.equals("XON") ? 0x110000 : 0));
            }
        } else if (n == 1) {
            double d = Z8530.sccFreq / (double)(Z8530.scc1aBaudRateGen + 2 << Z8530.scc1aClockModeShift + 1);
            double d2 = 1.0 + (Z8530.scc1aRxBits == 0 ? 5.0 : (Z8530.scc1aRxBits == 1 ? 7.0 : (Z8530.scc1aRxBits == 2 ? 6.0 : 8.0))) + ((Z8530.scc1aParity & 1) == 0 ? 0.0 : 1.0) + (Z8530.scc1aStop == 0 ? 0.0 : (Z8530.scc1aStop == 1 ? 1.0 : (Z8530.scc1aStop == 2 ? 1.5 : 2.0)));
            double d3 = d2 / d;
            Z8530.scc1aInterval = Math.round(d3 * 1.0E12);
            if (serialPort != null) {
                serialPort.setComPortParameters((int)Math.round(d), Z8530.scc1aRxBits == 0 ? 5 : (Z8530.scc1aRxBits == 1 ? 7 : (Z8530.scc1aRxBits == 2 ? 6 : 8)), Z8530.scc1aStop == 2 ? 2 : (Z8530.scc1aStop == 3 ? 3 : 1), Z8530.scc1aParity == 1 ? 1 : (Z8530.scc1aParity == 3 ? 2 : 0));
            }
            TickerQueue.tkqAdd(trmAUXFlowControlTicker, XEiJ.mpuClockTime + 500000000L);
        }
    }

    public static void trmInit() {
        trmFrame = null;
        trmBoard = null;
        trmPopupMenu = null;
        trmPopupCutMenuItem = null;
        trmPopupCopyMenuItem = null;
        trmPopupPasteMenuItem = null;
        trmPopupSelectAllMenuItem = null;
        trmPopupSendCtrlCMenuItem = null;
        trmOutputBuilder = new StringBuilder();
        trmOutputEnd = 0;
        trmOutputSJIS1 = 0;
        RS232CTerminal.trmInitConnection();
        RS232CTerminal.trmReset();
    }

    public static void trmReset() {
        trmRSDRV202Head = 0;
        trmTMSIO031Head = 0;
        trmBSIO021Head = 0;
        trmAUXFlowControlXON = false;
        trmAUXFlowControlRTS = false;
    }

    public static void trmTini() {
        RS232CTerminal.trmTiniConnection();
    }

    public static void trmMake() {
        trmBoard = ComponentFactory.createScrollTextArea(trmOutputBuilder.toString(), 650, 350, true);
        trmOutputBuilder = null;
        trmBoard.setUnderlineCursorOn(true);
        trmBoard.setLineWrap(true);
        trmBoard.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() < trmOutputEnd) {
                    trmOutputEnd += documentEvent.getLength();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() < trmOutputEnd) {
                    trmOutputEnd -= Math.min(documentEvent.getLength(), trmOutputEnd - documentEvent.getOffset());
                }
            }
        });
        trmBoard.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    keyEvent.consume();
                    RS232CTerminal.trmEnter();
                } else if (n == 19) {
                    keyEvent.consume();
                    RS232CTerminal.trmSendString("\u0003");
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (actionEvent.getActionCommand()) {
                    case "Cut": {
                        RS232CTerminal.trmCut();
                        break;
                    }
                    case "Copy": {
                        RS232CTerminal.trmCopy();
                        break;
                    }
                    case "Paste": {
                        RS232CTerminal.trmPaste();
                        break;
                    }
                    case "Select All": {
                        RS232CTerminal.trmSelectAll();
                        break;
                    }
                    case "Send ^C": {
                        RS232CTerminal.trmSendString("\u0003");
                    }
                }
            }
        };
        JComponent[] jComponentArray = new JComponent[7];
        trmPopupCutMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Cut", 84, actionListener), "ja", "\u5207\u308a\u53d6\u308a");
        jComponentArray[0] = trmPopupCutMenuItem;
        trmPopupCopyMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Copy", 67, actionListener), "ja", "\u30b3\u30d4\u30fc");
        jComponentArray[1] = trmPopupCopyMenuItem;
        trmPopupPasteMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Paste", 80, actionListener), "ja", "\u8cbc\u308a\u4ed8\u3051");
        jComponentArray[2] = trmPopupPasteMenuItem;
        jComponentArray[3] = ComponentFactory.createHorizontalSeparator();
        trmPopupSelectAllMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Select All", 65, actionListener), "ja", "\u3059\u3079\u3066\u9078\u629e");
        jComponentArray[4] = trmPopupSelectAllMenuItem;
        jComponentArray[5] = ComponentFactory.createHorizontalSeparator();
        trmPopupSendCtrlCMenuItem = Multilingual.mlnText(ComponentFactory.createMenuItem("Send ^C", actionListener), "ja", "^C \u9001\u4fe1");
        jComponentArray[6] = trmPopupSendCtrlCMenuItem;
        trmPopupMenu = ComponentFactory.createPopupMenu(jComponentArray);
        trmBoard.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RS232CTerminal.trmShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                RS232CTerminal.trmShowPopup(mouseEvent);
            }
        });
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Refresh": {
                        RS232CTerminal.trmUpdateConnection();
                        break;
                    }
                    case "Baud rate": {
                        RS232CTerminal.trmSetBaudRate(((JComboBox)object).getSelectedIndex());
                        break;
                    }
                    case "Data bits": {
                        RS232CTerminal.trmSetDataBits(((JComboBox)object).getSelectedIndex());
                        break;
                    }
                    case "Parity": {
                        RS232CTerminal.trmSetParity(((JComboBox)object).getSelectedIndex());
                        break;
                    }
                    case "Stop bits": {
                        RS232CTerminal.trmSetStopBits(((JComboBox)object).getSelectedIndex());
                        break;
                    }
                    case "Flow control": {
                        RS232CTerminal.trmSetFlowControl(((JComboBox)object).getSelectedIndex());
                        break;
                    }
                    case "Send file": {
                        RS232CTerminal.trmSendFile();
                        break;
                    }
                    case "7.3728MHz": {
                        Z8530.sccFreq = ((JCheckBox)object).isSelected() ? 7372800.0 : 5000000.0;
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        trmRefreshButton = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createButton("Refresh", actionListener2), "ja", "\u66f4\u65b0"), trmRefreshEnabled);
        trmBaudRateComboBox = ComponentFactory.setEnabled(Multilingual.mlnToolTipText(ComponentFactory.createComboBox(trmBaudRateIndex, "Baud rate", actionListener2, trmBaudRateArray), "ja", "\u30dc\u30fc\u30ec\u30fc\u30c8"), trmSettingsEnabled);
        trmDataBitsComboBox = ComponentFactory.setEnabled(Multilingual.mlnToolTipText(ComponentFactory.createComboBox(trmDataBitsIndex, "Data bits", actionListener2, trmDataBitsArray), "ja", "\u30c7\u30fc\u30bf\u30d3\u30c3\u30c8"), trmSettingsEnabled);
        trmParityComboBox = ComponentFactory.setEnabled(Multilingual.mlnToolTipText(ComponentFactory.createComboBox(trmParityIndex, "Parity", actionListener2, trmParityArray), "ja", "\u30d1\u30ea\u30c6\u30a3"), trmSettingsEnabled);
        trmStopBitsComboBox = ComponentFactory.setEnabled(Multilingual.mlnToolTipText(ComponentFactory.createComboBox(trmStopBitsIndex, "Stop bits", actionListener2, trmStopBitsArray), "ja", "\u30b9\u30c8\u30c3\u30d7\u30d3\u30c3\u30c8"), trmSettingsEnabled);
        trmFlowControlComboBox = ComponentFactory.setEnabled(Multilingual.mlnToolTipText(ComponentFactory.createComboBox(trmFlowControlIndex, "Flow control", actionListener2, trmFlowControlArray), "ja", "\u30d5\u30ed\u30fc\u5236\u5fa1"), trmSettingsEnabled);
        trmSendButton = ComponentFactory.setEnabled(Multilingual.mlnText(ComponentFactory.createButton("Send file", actionListener2), "ja", "\u30d5\u30a1\u30a4\u30eb\u9001\u4fe1"), trmSendEnabled);
        trmFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("trm", "RS-232C and terminal", null, ComponentFactory.createVerticalSplitPane(ComponentFactory.createVerticalBox(Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(5), ComponentFactory.createVerticalBox(Box.createVerticalGlue(), trmRefreshButton, Box.createVerticalGlue()), Box.createHorizontalStrut(10), trmConnectionBox, Box.createHorizontalGlue()), "Connection"), "ja", "\u63a5\u7d9a"), ComponentFactory.createHorizontalBox(Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(5), trmBaudRateComboBox, trmDataBitsComboBox, trmParityComboBox, trmStopBitsComboBox, trmFlowControlComboBox, Box.createHorizontalStrut(5)), "Communication Settings"), "ja", "\u901a\u4fe1\u8a2d\u5b9a"), Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(5), trmSendButton, Box.createHorizontalStrut(5)), "Transfer"), "ja", "\u8ee2\u9001"), Box.createHorizontalGlue(), Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(5), ComponentFactory.createCheckBox(Z8530.sccFreq == 7372800.0, "7.3728MHz", actionListener2), Box.createHorizontalStrut(5)), "Modification"), "ja", "\u6539\u9020"))), ComponentFactory.createVerticalBox(Multilingual.mlnTitledBorder(ComponentFactory.setTitledLineBorder(trmBoard, "Terminal"), "ja", "\u30bf\u30fc\u30df\u30ca\u30eb")))), "ja", "RS-232C \u3068\u30bf\u30fc\u30df\u30ca\u30eb");
    }

    public static void trmShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            boolean bl = XEiJ.clpClipboard != null && trmBoard.getSelectionStart() != trmBoard.getSelectionEnd();
            ComponentFactory.setEnabled(trmPopupCutMenuItem, bl);
            ComponentFactory.setEnabled(trmPopupCopyMenuItem, bl);
            ComponentFactory.setEnabled(trmPopupPasteMenuItem, XEiJ.clpClipboard != null && XEiJ.clpClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor));
            ComponentFactory.setEnabled(trmPopupSelectAllMenuItem, XEiJ.clpClipboard != null);
            ComponentFactory.setEnabled(trmPopupSendCtrlCMenuItem, trmRowToCol[0] == 1 || 0 < trmColToRow[0]);
            trmPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static void trmCut() {
        if (XEiJ.clpClipboard != null) {
            XEiJ.clpClipboardString = trmBoard.getSelectedText();
            try {
                XEiJ.clpClipboard.setContents(XEiJ.clpStringContents, XEiJ.clpClipboardOwner);
                XEiJ.clpIsClipboardOwner = true;
            }
            catch (Exception exception) {
                return;
            }
            trmBoard.replaceRange("", trmBoard.getSelectionStart(), trmBoard.getSelectionEnd());
        }
    }

    public static void trmCopy() {
        String string;
        if (XEiJ.clpClipboard != null && (string = trmBoard.getSelectedText()) != null) {
            XEiJ.clpClipboardString = string;
            try {
                XEiJ.clpClipboard.setContents(XEiJ.clpStringContents, XEiJ.clpClipboardOwner);
                XEiJ.clpIsClipboardOwner = true;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public static void trmPaste() {
        if (XEiJ.clpClipboard != null) {
            String string = null;
            try {
                string = (String)XEiJ.clpClipboard.getData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                return;
            }
            trmBoard.replaceRange(string, trmBoard.getSelectionStart(), trmBoard.getSelectionEnd());
        }
    }

    public static void trmSelectAll() {
        if (XEiJ.clpClipboard != null) {
            trmBoard.selectAll();
        }
    }

    public static void trmStart() {
        if (RestorableFrame.rfmGetOpened("trm")) {
            RS232CTerminal.trmOpen();
        }
    }

    public static void trmOpen() {
        if (trmFrame == null) {
            RS232CTerminal.trmMake();
        }
        XEiJ.pnlExitFullScreen(false);
        trmFrame.setVisible(true);
    }

    public static void trmPrintSJIS(int n) {
        n &= 0xFF;
        if (trmOutputSJIS1 != 0) {
            if (64 <= n && n != 127 && n <= 252) {
                char c = CharacterCode.chrSJISToChar[trmOutputSJIS1 << 8 | n];
                if (c != '\u0000') {
                    RS232CTerminal.trmPrintChar(c);
                } else {
                    RS232CTerminal.trmPrintChar(91);
                    RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(trmOutputSJIS1 >> 4));
                    RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(trmOutputSJIS1 & 0xF));
                    RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(n >> 4));
                    RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(n & 0xF));
                    RS232CTerminal.trmPrintChar(93);
                }
                trmOutputSJIS1 = 0;
                return;
            }
            RS232CTerminal.trmPrintChar(91);
            RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(trmOutputSJIS1 >> 4));
            RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(trmOutputSJIS1 & 0xF));
            RS232CTerminal.trmPrintChar(93);
            trmOutputSJIS1 = 0;
        }
        if (129 <= n && n <= 159 || 224 <= n && n <= 239) {
            trmOutputSJIS1 = n;
        } else {
            char c = CharacterCode.chrSJISToChar[n];
            if (c != '\u0000') {
                RS232CTerminal.trmPrintChar(c);
            } else {
                RS232CTerminal.trmPrintChar(91);
                RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(n >> 4));
                RS232CTerminal.trmPrintChar(XEiJ.fmtHexc(n & 0xF));
                RS232CTerminal.trmPrintChar(93);
            }
        }
    }

    public static void trmPrintChar(int n) {
        if (n == 8) {
            if (trmOutputEnd > 0) {
                if (trmBoard != null) {
                    trmBoard.replaceRange("", trmOutputEnd - 1, trmOutputEnd);
                    trmBoard.setCaretPosition(--trmOutputEnd);
                } else {
                    trmOutputBuilder.delete(trmOutputEnd - 1, trmOutputEnd);
                    --trmOutputEnd;
                }
            }
        } else if (n >= 32 && n != 127 || n == 9 || n == 10) {
            if (trmBoard != null) {
                trmBoard.insert(String.valueOf((char)n), trmOutputEnd);
                if (++trmOutputEnd >= 278528) {
                    trmBoard.replaceRange("", 0, trmOutputEnd - 262144);
                    trmOutputEnd = 262144;
                }
                trmBoard.setCaretPosition(trmOutputEnd);
            } else {
                trmOutputBuilder.append((char)n);
                if (++trmOutputEnd >= 278528) {
                    trmOutputBuilder.delete(0, trmOutputEnd - 262144);
                    trmOutputEnd = 262144;
                }
            }
        }
    }

    public static void trmPrint(String string) {
        if (string == null) {
            return;
        }
        if (trmFrame != null) {
            trmBoard.insert(string, trmOutputEnd);
            if ((trmOutputEnd += string.length()) >= 278528) {
                trmBoard.replaceRange("", 0, trmOutputEnd - 262144);
                trmOutputEnd = 262144;
            }
            trmBoard.setCaretPosition(trmOutputEnd);
        } else {
            trmOutputBuilder.append(string);
            if ((trmOutputEnd += string.length()) >= 278528) {
                trmOutputBuilder.delete(0, trmOutputEnd - 262144);
                trmOutputEnd = 262144;
            }
        }
    }

    public static void trmPrintln(String string) {
        RS232CTerminal.trmPrint(string);
        RS232CTerminal.trmPrintChar(10);
    }

    public static void trmEnter() {
        int n;
        String string = trmBoard.getText();
        int n2 = string.length();
        int n3 = string.lastIndexOf(10, trmOutputEnd - 1) + 1;
        if (n3 <= (n = string.lastIndexOf(10, trmBoard.getCaretPosition() - 1) + 1)) {
            trmBoard.replaceRange("", trmOutputEnd, n2);
            RS232CTerminal.trmSendString(string.substring(trmOutputEnd, n2) + "\r");
        } else if (n3 < trmOutputEnd) {
            String string2;
            int n4;
            String string3 = string.substring(n3, trmOutputEnd);
            int n5 = string.indexOf(10, n);
            if (n5 == -1) {
                n5 = n2;
            }
            if ((n4 = (string2 = string.substring(n, n5)).indexOf(string3)) >= 0) {
                trmOutputEnd = n2;
                if (string.charAt(trmOutputEnd - 1) != '\n') {
                    trmBoard.insert("\n", trmOutputEnd);
                    if (++trmOutputEnd >= 278528) {
                        trmBoard.replaceRange("", 0, trmOutputEnd - 262144);
                        trmOutputEnd = 262144;
                    }
                }
                trmBoard.setCaretPosition(trmOutputEnd);
                RS232CTerminal.trmSendString(string2.substring(n4 + string3.length()) + "\r");
            }
        }
    }

    public static void trmSendString(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = CharacterCode.chrCharToSJIS[string.charAt(n)];
            if ('\u00ff' < c) {
                byArray[n3++] = (byte)(c >> 8);
            }
            byArray[n3++] = (byte)c;
        }
        if (trmRowToCol[0] == 1) {
            n = 0;
            c = '\u0001';
            RS232CTerminal.trmConnectionArray[RS232CTerminal.trmCols * n + c - 1].row2colQueue.write(byArray, 0, n3);
        } else if (0 < trmColToRow[0]) {
            n = trmColToRow[0];
            c = '\u0000';
            RS232CTerminal.trmConnectionArray[RS232CTerminal.trmCols * n + c - 1].col2rowQueue.write(byArray, 0, n3);
        }
    }

    public static void trmSendFile() {
        if (trmSendDialog == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    switch (actionEvent.getActionCommand()) {
                        case "ApproveSelection": 
                        case "Send": {
                            trmSendDialog.setVisible(false);
                            File file = trmSendFileChooser.getSelectedFile();
                            if (file == null) break;
                            trmSendThread = new SendThread(file);
                            trmSendThread.start();
                            break;
                        }
                        case "CancelSelection": 
                        case "Cancel": {
                            trmSendDialog.setVisible(false);
                        }
                    }
                }
            };
            trmSendFileChooser = new JFileChooser(new File("a.txt"));
            trmSendFileChooser.setMultiSelectionEnabled(false);
            trmSendFileChooser.setControlButtonsAreShown(false);
            trmSendFileChooser.addActionListener(actionListener);
            trmSendDialog = Multilingual.mlnTitle(ComponentFactory.createModalDialog(trmFrame, "Send file", ComponentFactory.createBorderPanel(0, 0, ComponentFactory.createVerticalBox(trmSendFileChooser, ComponentFactory.createHorizontalBox(Box.createHorizontalStrut(12), Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel("Prepare COMMAND.X with CTTY AUX"), "ja", "COMMAND.X \u3092 CTTY AUX \u3067\u6e96\u5099\u3057\u3066"), Box.createHorizontalStrut(12), Multilingual.mlnText(ComponentFactory.createButton("Send", 83, actionListener), "ja", "\u9001\u4fe1"), Box.createHorizontalStrut(12), Multilingual.mlnText(ComponentFactory.createButton("Cancel", 67, actionListener), "ja", "\u30ad\u30e3\u30f3\u30bb\u30eb"), Box.createHorizontalStrut(12)), Box.createVerticalStrut(12)))), "ja", "\u30d5\u30a1\u30a4\u30eb\u9001\u4fe1");
        }
        XEiJ.pnlExitFullScreen(true);
        trmSendDialog.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] load(File file) {
        if (!file.isFile()) {
            return null;
        }
        int n = (int)file.length();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            if (bufferedInputStream.read(byArray) == n) return byArray;
            byte[] byArray2 = null;
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static byte[] compress(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = 1 << n;
        DIC[] dICArray = new DIC[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            dICArray[n4] = new DIC();
            dICArray[n4].ptr = 0;
            dICArray[n4].len = 0;
        }
        n4 = 0;
        int n6 = byArray.length;
        BitWriter bitWriter = new BitWriter();
        bitWriter.writeBits(24, n6);
        bitWriter.writeBits(4, n);
        for (int i = 0; i < n6; i += n3) {
            int n7;
            int n8 = -1;
            n2 = -1;
            n3 = 0;
            int n9 = byArray[i] & 0xFF;
            block2: for (n7 = 0; n7 < n5; ++n7) {
                int n10;
                int n11 = dICArray[n7].len;
                if (n3 >= n11 || i + n11 + 1 > n6 || n9 != (byArray[n10 = dICArray[n7].ptr] & 0xFF)) continue;
                for (int j = 1; j < n11; ++j) {
                    if (byArray[i + j] != byArray[n10 + j]) continue block2;
                }
                n8 = n7;
                n2 = n10;
                n3 = n11;
            }
            if (n3 == 0) {
                bitWriter.writeBits(1, 0);
            } else {
                bitWriter.writeBits(1, 1);
                bitWriter.writeBits(n, n8);
            }
            n7 = byArray[i + n3] & 0xFF;
            bitWriter.writeByte(n7);
            dICArray[n4].ptr = i;
            dICArray[n4].len = ++n3;
            if (++n4 != n5) continue;
            n4 = 0;
        }
        byte[] byArray2 = bitWriter.getBuffer();
        if (byArray2.length != (n2 = bitWriter.getLength())) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    public static byte[] encode(byte[] byArray) {
        byte[] byArray2;
        int n;
        int n2 = byArray.length;
        if ((n2 -= 62 * (n = n2 / 62)) != 0 && byArray.length < 62 * n + (n2 = (n2 + 2 + 3 & 0xFFFFFFFC) - 2)) {
            byArray2 = new byte[62 * n + n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        byArray2 = new byte[64 * n + (n2 == 0 ? 0 : n2 + 2)];
        int[] nArray = new int[16];
        int n3 = 0;
        while (64 * n3 < byArray2.length) {
            int n4;
            int n5 = Math.min(64, byArray2.length - 64 * n3) / 4;
            for (n4 = 0; n4 < n5 - 1; ++n4) {
                nArray[n4] = (byArray[62 * n3 + 4 * n4 + 0] & 0xFF) << 24 | (byArray[62 * n3 + 4 * n4 + 1] & 0xFF) << 16 | (byArray[62 * n3 + 4 * n4 + 2] & 0xFF) << 8 | byArray[62 * n3 + 4 * n4 + 3] & 0xFF;
            }
            nArray[n5 - 1] = (byArray[62 * n3 + 4 * (n5 - 1) + 0] & 0xFF) << 24 | (byArray[62 * n3 + 4 * (n5 - 1) + 1] & 0xFF) << 16;
            for (n4 = 0; n4 < n5; ++n4) {
                if ((nArray[n4] & Integer.MIN_VALUE) == 0) continue;
                int n6 = n4;
                nArray[n6] = nArray[n6] & Integer.MAX_VALUE;
                int n7 = n5 - 1;
                nArray[n7] = nArray[n7] | 1 << 15 - n4;
            }
            for (n4 = 0; n4 < n5; ++n4) {
                int n8 = nArray[n4];
                int n9 = n8 / 224;
                n8 -= 224 * n9;
                int n10 = n9 / 224;
                n9 -= 224 * n10;
                int n11 = n10 / 224;
                byArray2[64 * n3 + 4 * n4 + 0] = (byte)(32 + n11);
                byArray2[64 * n3 + 4 * n4 + 1] = (byte)(32 + (n10 -= 224 * n11));
                byArray2[64 * n3 + 4 * n4 + 2] = (byte)(32 + n9);
                byArray2[64 * n3 + 4 * n4 + 3] = (byte)(32 + n8);
            }
            ++n3;
        }
        return byArray2;
    }

    public static void trmSendProcess(File file) {
        byte[] byArray;
        int n;
        byte[] byArray2 = RS232CTerminal.load(file);
        if (byArray2 == null) {
            return;
        }
        if (0xFFFF00 < byArray2.length) {
            return;
        }
        byte[] byArray3 = new byte[adotr3.length + 24 + 4 + 4 + 4 + byArray2.length];
        int n2 = 0;
        System.arraycopy(adotr3, 0, byArray3, n2, adotr3.length);
        n2 += adotr3.length;
        String string = file.getName();
        byte[] byArray4 = new byte[2 * string.length()];
        int n3 = 0;
        int n4 = -1;
        for (n = 0; n < string.length(); ++n) {
            char c = CharacterCode.chrCharToSJIS[string.charAt(n)];
            if (c == '\u0000') {
                return;
            }
            if (c <= ' ' || c == ':' || c == '*' || c == '?' || c == '\\' || c == '/' || c == '-' && n3 == 0 || c == '\"' || c == '\'' || c == '+' || c == ';' || c == '<' || c == '=' || c == '>' || c == '[' || c == ']' || c == '|') {
                return;
            }
            if (c == '.') {
                if (n4 < 0) {
                    n4 = n3;
                } else {
                    return;
                }
            }
            if ('\u00ff' < c) {
                byArray4[n3++] = (byte)(c >> 8);
            }
            byArray4[n3++] = (byte)c;
            if (!(n4 < 0 ? 18 < n3 : n4 + 1 + 3 < n3)) continue;
            return;
        }
        for (n = 0; n < n3; ++n) {
            byArray3[n2++] = byArray4[n];
        }
        for (n = n3; n < 24; ++n) {
            byArray3[n2++] = 0;
        }
        long l = DnT.dntDttmCmil(file.lastModified() + RP5C15.rtcCmilGap);
        n4 = DnT.dntYearDttm(l) - 1980 << 9 | DnT.dntMontDttm(l) << 5 | DnT.dntMdayDttm(l);
        n = DnT.dntHourDttm(l) << 11 | DnT.dntMinuDttm(l) << 5 | DnT.dntSecoDttm(l) >> 1;
        byArray3[n2++] = (byte)(n4 >> 8);
        byArray3[n2++] = (byte)n4;
        byArray3[n2++] = (byte)(n >> 8);
        byArray3[n2++] = (byte)n;
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray2, 0, byArray2.length);
        n3 = (int)cRC32.getValue();
        byArray3[n2++] = (byte)(n3 >> 24);
        byArray3[n2++] = (byte)(n3 >> 16);
        byArray3[n2++] = (byte)(n3 >> 8);
        byArray3[n2++] = (byte)n3;
        int n5 = byArray2.length;
        byArray3[n2++] = (byte)(n5 >> 24);
        byArray3[n2++] = (byte)(n5 >> 16);
        byArray3[n2++] = (byte)(n5 >> 8);
        byArray3[n2++] = (byte)n5;
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        n2 += byArray2.length;
        byte[] byArray5 = null;
        n3 = 0;
        for (n4 = 8; n4 <= 10; ++n4) {
            byte[] byArray6 = RS232CTerminal.compress(byArray3, n4);
            if (byArray5 != null && byArray6.length >= byArray5.length) continue;
            byArray5 = byArray6;
            n3 = n4;
        }
        byte[] byArray7 = new byte[adotr2.length + byArray5.length];
        n = 0;
        System.arraycopy(adotr2, 0, byArray7, n, adotr2.length);
        System.arraycopy(byArray5, 0, byArray7, n += adotr2.length, byArray5.length);
        n += byArray5.length;
        byte[] byArray8 = RS232CTerminal.encode(byArray3);
        byte[] byArray9 = RS232CTerminal.encode(byArray7);
        if (byArray8.length <= byArray9.length) {
            byArray = new byte[adotr1.length + byArray8.length + 1];
            var12_19 = 0;
            System.arraycopy(adotr1, 0, byArray, var12_19, adotr1.length);
            System.arraycopy(byArray8, 0, byArray, var12_19 += adotr1.length, byArray8.length);
            var12_19 += byArray8.length;
            byArray[var12_19++] = 26;
        } else {
            byArray = new byte[adotr1.length + byArray9.length + 1];
            var12_19 = 0;
            System.arraycopy(adotr1, 0, byArray, var12_19, adotr1.length);
            System.arraycopy(byArray9, 0, byArray, var12_19 += adotr1.length, byArray9.length);
            var12_19 += byArray9.length;
            byArray[var12_19++] = 26;
        }
        RS232CTerminal.trmSendString(String.format("rem a.r/%s %d/%d %.1f%%\rcopy aux a.r\r", string, byArray.length, byArray2.length, 100.0 * (double)byArray.length / (double)byArray2.length));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (trmRowToCol[0] == 1) {
            int n6 = 0;
            int n7 = 1;
            RS232CTerminal.trmConnectionArray[RS232CTerminal.trmCols * n6 + n7 - 1].row2colQueue.write(byArray, 0, byArray.length);
        } else if (0 < trmColToRow[0]) {
            int n8 = trmColToRow[0];
            int n9 = 0;
            RS232CTerminal.trmConnectionArray[RS232CTerminal.trmCols * n8 + n9 - 1].col2rowQueue.write(byArray, 0, byArray.length);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RS232CTerminal.trmSendString("a.r\r");
    }

    static {
        trmAUXSendTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                trmAUXSendEmpty = true;
                if (Z8530.scc1aSendMask != 0) {
                    Z8530.scc1aSendRR3 = 16;
                    Z8530.scc1aSendRequest = 16;
                    XEiJ.mpuIRR |= 4;
                }
            }
        };
        trmAUXTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                long l = 1000000000L;
                ByteQueue byteQueue = RS232CTerminal.trmAUXConnection.row2colQueue;
                if (RS232CTerminal.trmAUXConnection.row2colReset) {
                    RS232CTerminal.trmAUXConnection.row2colReset = false;
                    byteQueue.clear();
                } else if (!trmAUXNotReceiving && byteQueue.used() != 0) {
                    trmAUXDataBuffer = byteQueue.read();
                    trmAUXDataAvailable = true;
                    if (Z8530.scc1aReceiveMask != 0 && Z8530.scc1aReceiveRR3 == 0) {
                        Z8530.scc1aReceiveRR3 = 32;
                        Z8530.scc1aReceiveRequest = 32;
                        XEiJ.mpuIRR |= 4;
                    }
                    l = Z8530.scc1aInterval;
                }
                TickerQueue.tkqAdd(trmAUXTicker, XEiJ.mpuClockTime + l);
            }
        };
        trmAUXFlowControlTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                SerialPort serialPort;
                boolean bl;
                int n;
                int n2 = MC68060.mmuPeekLongData(1216, 1);
                int n3 = 0xFC0000 <= n2 && n2 < 0x1000000 ? 2342 : (n2 == trmRSDRV202Head + 954 ? trmRSDRV202Head + 2738 : (n2 == trmTMSIO031Head + 528 ? trmTMSIO031Head + 2626 : (n = n2 == trmBSIO021Head + 314 ? trmBSIO021Head + 1866 : 0)));
                if (n == 0) {
                    return;
                }
                int n4 = MC68060.mmuPeekWordZeroData(n, 1);
                if (n4 == 0 || n4 == 65535) {
                    return;
                }
                boolean bl2 = (n4 & 0x80) != 0;
                boolean bl3 = bl = !bl2 && (n4 & 0x200) != 0;
                if (trmAUXFlowControlRTS == bl2 && trmAUXFlowControlXON == bl) {
                    return;
                }
                trmAUXFlowControlRTS = bl2;
                trmAUXFlowControlXON = bl;
                int n5 = trmColToRow[1];
                SerialPort serialPort2 = serialPort = n5 < 1 || trmNumberOfPorts < n5 ? null : trmPortArray[n5 - 1];
                if (serialPort != null) {
                    serialPort.setFlowControl(bl2 ? 17 : (bl ? 0x110000 : 0));
                }
            }
        };
        adotr1 = "B\u0082G\u00fb h\u00d4\u0089\u00c4|\u00ff\u00fc(B\"Kx@\u00d8\u008bB\u0080\u00d0\u008c\u0090\u0084\u0093\u0081\u00c0\u0081\u00d8\u0080$I\"<\u00df\u00df\u00df\u00e0\u00d2\u009bB\u0080v( @\u00e7\u0088\u0090\u0088\u00eb\u0088\u00e1\u0099\u00d0\u0081Q\u00c1\u0090\u0081\u00e2Kd\u00ec\"\u00c0\u00b7\u00c4e\u00da2!B\u0080\u00d2A\u00e2\u0090\u00d1\u009a\u00b5\u00c9e\u00f4\u00b7\u00cce\u00b6A\u00fa\u00ff\u00f8t\u00f8N\u00f0\" BAVAp\u00acNO".getBytes(XEiJ.ISO_8859_1);
        adotr2 = "p\u0001\u00d0\u0089\u00c0|\u00ff\u00fe\"@|\u0000~\u0000E\u00fa\u0000\u00far\u0018a\u0000\u0000\u00d2&\u0000\u00d6\u0089p\u0001\u00d0\u0083\u00c0|\u00ff\u00fe*@r\u0004a\u0000\u0000\u00beg\u0000\u0000\u00a6\u0018\u0000z\b\u00e9\u00ad\u00da\u008d\u00ff\u0081\"\u0005\u0092\u0080/\u0001/\u0000\u00ffJP\u008fJ\u0080ktp\u0000 M \u00c0 \u00c0\u00b1\u00c5e\u00f8(I,M\u00b5\u00c9dvr\u0001a\u0000\u0000\u0086f\b,\u00ccp\u0001,\u00c0`0\u0012\u0004av\u00e7\u0088 u\b\u0000 5\b\u0004gVR\u0080\"\u0000\u00d2\u008c\u00b2\u0083bL,\u00cc,\u00c0U\u0080H@H@\u0018\u00d8Q\u00c8\u00ff\u00fcH@Q\u00c8\u00ff\u00f4\u0018\u00da\u00bd\u00c5f\u0002,M\u00b9\u00c3e\u00b0p\u00faN\u00fb\u0002\u000er\u0003p\u00acNO IN\u00d0\u00ff\t\u00ff\u0000Hz\u0000\u0004`\u00f6out of memory\r\n\u0000Hz\u0000\u0004`\u00e0data error\r\n\u0000\u0000p\u0000J\u0007f\u0004\u001c\u001aP\u0007\u0014\u0001\u00b4\u0007c\u0002\u0014\u0007\u0010\u0006\u00e5\u00a8\u00e5.\u009e\u0002\u0092\u0002f\u00e4\u00e0\u0088Nu".getBytes(XEiJ.ISO_8859_1);
        adotr3 = "E\u00fa\u0001\u0002&*\u0000 G\u00ea\u0000$ \u000b\u00d0\u0083R\u0080\u00c0|\u00ff\u00fe(@K\u00ec\u0004\u0000\u00ff\u0081\"\r\u0092\u0080/\u0001/\u0000\u00ffJP\u008fJ\u0080k\u0000\u0000\u0098 Lr\u0000 \u0001t\u0007\u00e2\u0088d\u0006\n\u0080\u00ed\u00b8\u0083 Q\u00ca\u00ff\u00f4 \u00c0R\u0001d\u00e8\"Lp\u0000\"\u0003 KF\u0080`\u0012HAt\u0000\u0014\u0018\u00b1\u0002\u00e0\u0088\u00e5J$1(\u0000\u00b5\u0080Q\u00c9\u00ff\u00eeHAQ\u00c9\u00ff\u00e6F\u0080\u00b0\u00aa\u0000\u001cf`?<\u0000 /\n\u00ff<\\\u008fJ\u0080kd/\u0003/\u000b?\u0000\u00ff@\"\u0000/j\u0000\u0018\u0000\u0002\u00ff\u0087\u00ff>O\u00ef\u0000\n\u00b2\u0083g\b/\n\u00ffAX\u008f`@/\n\u00ff\tHz\u0000\u0006\u00ff\t\u00ff\u0000 created\r\n\u0000\u0000Hz\u0000\u0004`\u00eaout of memory\r\n\u0000Hz\u0000\u0004`\u00d4crc error\r\n\u0000Hz\u0000\u0004`\u00c2cannot write\r\n\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
    }

    static class Connection
    implements SerialPortDataListener {
        int row;
        int col;
        int index;
        String text;
        boolean connected;
        JCheckBox checkBox;
        Box box;
        ByteQueue row2colQueue;
        ByteQueue col2rowQueue;
        boolean row2colReset;
        boolean col2rowReset;
        boolean polling;
        Thread row2colThread;
        Thread col2rowThread;

        Connection() {
        }

        @Override
        public int getListeningEvents() {
            return 1;
        }

        @Override
        public void serialEvent(SerialPortEvent serialPortEvent) {
            int n;
            if (serialPortEvent.getEventType() != 1) {
                return;
            }
            SerialPort serialPort = serialPortEvent.getSerialPort();
            while ((n = Math.min(serialPort.bytesAvailable(), this.row2colQueue.unused())) != 0) {
                byte[] byArray = new byte[n];
                serialPort.readBytes(byArray, n);
                this.row2colQueue.write(byArray, 0, n);
            }
        }

        class TCPIPThread
        extends Thread {
            TCPIPThread() {
            }

            @Override
            public void run() {
                ByteQueue byteQueue = Connection.this.col2rowQueue;
                while (Connection.this.polling) {
                    if (Connection.this.col2rowReset) {
                        Connection.this.col2rowReset = false;
                        byteQueue.clear();
                    } else {
                        int n = byteQueue.used();
                        while (n != 0) {
                            byte[] byArray = new byte[n];
                            byteQueue.read(byArray, 0, n);
                            RS232CTerminal.trmTcpipWrite(byArray, 0, n);
                            n = byteQueue.used();
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        class SerialPortThread
        extends Thread {
            SerialPortThread() {
            }

            @Override
            public void run() {
                SerialPort serialPort = trmPortArray[Connection.this.row - 1];
                ByteQueue byteQueue = Connection.this.col2rowQueue;
                while (Connection.this.polling) {
                    if (Connection.this.col2rowReset) {
                        Connection.this.col2rowReset = false;
                        byteQueue.clear();
                        serialPort.flushIOBuffers();
                    } else {
                        int n = byteQueue.used();
                        while (n != 0) {
                            byte[] byArray = new byte[n];
                            byteQueue.read(byArray, 0, n);
                            serialPort.writeBytes(byArray, n);
                            n = byteQueue.used();
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        class TerminalThread
        extends Thread {
            TerminalThread() {
            }

            @Override
            public void run() {
                ByteQueue byteQueue;
                ByteQueue byteQueue2 = byteQueue = Connection.this.col == 0 ? Connection.this.row2colQueue : Connection.this.col2rowQueue;
                while (Connection.this.polling) {
                    if (Connection.this.col == 0 ? Connection.this.row2colReset : Connection.this.col2rowReset) {
                        if (Connection.this.col == 0) {
                            Connection.this.row2colReset = false;
                        } else {
                            Connection.this.col2rowReset = false;
                        }
                        byteQueue.clear();
                    } else {
                        int n = byteQueue.used();
                        while (n != 0) {
                            byte[] byArray = new byte[n];
                            byteQueue.read(byArray, 0, n);
                            for (int i = 0; i < n; ++i) {
                                RS232CTerminal.trmPrintSJIS(byArray[i] & 0xFF);
                            }
                            n = byteQueue.used();
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static class SendThread
    extends Thread {
        File file;

        SendThread(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            RS232CTerminal.trmSendProcess(this.file);
        }
    }

    static class DIC {
        int ptr;
        int len;

        DIC() {
        }
    }

    static class BitWriter {
        byte[] buffer = new byte[16];
        int byteIndex = 0;
        int bitIndex = -1;
        int bitCount = 0;

        BitWriter() {
        }

        void writeByte(int n) {
            if (this.byteIndex == this.buffer.length) {
                byte[] byArray = new byte[this.byteIndex * 2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.byteIndex);
                this.buffer = byArray;
            }
            this.buffer[this.byteIndex++] = (byte)n;
        }

        void writeBits(int n, int n2) {
            while (n != 0) {
                if (this.bitCount == 0) {
                    if (this.byteIndex == this.buffer.length) {
                        byte[] byArray = new byte[this.byteIndex * 2];
                        System.arraycopy(this.buffer, 0, byArray, 0, this.byteIndex);
                        this.buffer = byArray;
                    }
                    this.bitIndex = this.byteIndex;
                    this.bitCount = 8;
                    this.buffer[this.byteIndex++] = 0;
                }
                int n3 = Math.min(this.bitCount, n);
                this.bitCount -= n3;
                int n4 = this.bitIndex;
                this.buffer[n4] = (byte)(this.buffer[n4] | (byte)((n2 &= (1 << n) - 1) >>> (n -= n3) << this.bitCount));
            }
        }

        byte[] getBuffer() {
            return this.buffer;
        }

        int getLength() {
            return this.byteIndex;
        }
    }
}

