/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputContext;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import xeij.ComponentFactory;
import xeij.JFileChooser2;
import xeij.LnF;
import xeij.Multilingual;
import xeij.XEiJ;

public class KeyMapEditor
implements KeyListener {
    public static final Font FONT = new Font("SansSerif", 0, 12);
    public static final int LABEL_HEIGHT = 14;
    public static final int COL_WIDTH = 14;
    public static final int ROW_HEIGHT = 18;
    public static final int COLS = 94;
    public static final int ROWS = 25;
    public static final int PADDING_TOP = 10;
    public static final int PADDING_BOTTOM = 10;
    public static final int PADDING_LEFT = 10;
    public static final int PADDING_RIGHT = 10;
    public static final int KEYBOARD_WIDTH = 1336;
    public static final int KEYBOARD_HEIGHT = 470;
    public static final int KEYS = 113;
    public static final int BOXES = 114;
    public static final int TAB = 15;
    public static final int LEFT_SHIFT = 108;
    public static final int RIGHT_SHIFT = 113;
    public static Color backgroundColor;
    public static Color assignedColor;
    public static Color focusedColor;
    public static Color foregroundColor;
    public JPanel keyboardPanel;
    public JComponent mainPanel;
    public int[] currentMap;
    public int focusedBox;
    public JTextArea[] textAreaArray;
    public static FileFilter txtFileFilter;
    public static File lastFile;
    public static LinkedList<int[]> undoList;
    public static LinkedList<int[]> redoList;
    public static final int UNDO_LIST_MAX_LENGTH = 1000;
    public static final int[][] BOUNDS_ARRAY;
    public static final String[] TEXT_ARRAY;

    public KeyMapEditor(int[] nArray) {
        this.currentMap = nArray;
        txtFileFilter = new FileFilter(this){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                String string2 = string.toLowerCase();
                return file.isDirectory() || file.isFile() && (string2.endsWith(".csv") || string2.endsWith(".txt"));
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "CSV \u307e\u305f\u306f\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb (*.csv,*.txt)" : "CSV or text file (*.csv,*.txt)";
            }
        };
        lastFile = new File("keymap.csv").getAbsoluteFile();
        undoList = new LinkedList();
        redoList = new LinkedList();
        backgroundColor = new Color(LnF.lnfRGB[0]);
        assignedColor = new Color(LnF.lnfRGB[4]);
        focusedColor = new Color(LnF.lnfRGB[8]);
        foregroundColor = Color.white;
        this.keyboardPanel = new JPanel();
        this.keyboardPanel.setLayout(null);
        this.keyboardPanel.setPreferredSize(new Dimension(1336, 470));
        this.focusedBox = -1;
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                int n = Integer.parseInt(focusEvent.getComponent().getName());
                if (KeyMapEditor.this.focusedBox != -1) {
                    Color color = KeyMapEditor.this.currentMap[3 * n] != 0 ? assignedColor : backgroundColor;
                    KeyMapEditor.this.textAreaArray[KeyMapEditor.this.focusedBox].setBackground(color);
                    if (KeyMapEditor.this.focusedBox == 108) {
                        KeyMapEditor.this.textAreaArray[113].setBackground(color);
                    }
                }
                KeyMapEditor.this.focusedBox = n;
                KeyMapEditor.this.textAreaArray[KeyMapEditor.this.focusedBox].setBackground(focusedColor);
                if (KeyMapEditor.this.focusedBox == 108) {
                    KeyMapEditor.this.textAreaArray[113].setBackground(focusedColor);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                int n = Integer.parseInt(focusEvent.getComponent().getName());
                if (KeyMapEditor.this.focusedBox != -1) {
                    Color color = KeyMapEditor.this.currentMap[3 * n] != 0 ? assignedColor : backgroundColor;
                    KeyMapEditor.this.textAreaArray[KeyMapEditor.this.focusedBox].setBackground(color);
                    if (KeyMapEditor.this.focusedBox == 108) {
                        KeyMapEditor.this.textAreaArray[113].setBackground(color);
                    }
                    KeyMapEditor.this.focusedBox = -1;
                }
            }
        };
        this.textAreaArray = new JTextArea[114];
        for (int i = 0; i < 114; ++i) {
            JTextArea jTextArea;
            this.textAreaArray[i] = null;
            int[] nArray2 = BOUNDS_ARRAY[i];
            JLabel jLabel = ComponentFactory.createLabel(TEXT_ARRAY[i]);
            jLabel.setFont(FONT);
            jLabel.setBounds(10 + 14 * nArray2[0], 10 + 18 * nArray2[1], 14 * nArray2[2], 14);
            jLabel.setHorizontalAlignment(0);
            this.keyboardPanel.add(jLabel);
            this.textAreaArray[i] = jTextArea = new JTextArea();
            jTextArea.setFont(FONT);
            ComponentFactory.setEtchedBorder(jTextArea);
            jTextArea.setLineWrap(true);
            jTextArea.setBackground(backgroundColor);
            jTextArea.setForeground(foregroundColor);
            jTextArea.setCursor(Cursor.getPredefinedCursor(12));
            jTextArea.setName(String.valueOf(i == 113 ? 108 : i));
            jTextArea.setBounds(10 + 14 * nArray2[0], 10 + 18 * nArray2[1] + 14, 14 * nArray2[2], 18 * nArray2[3] - 14);
            if (i == 15) {
                jTextArea.setFocusTraversalKeysEnabled(false);
            } else {
                jTextArea.setFocusTraversalKeysEnabled(true);
            }
            jTextArea.addKeyListener(this);
            jTextArea.addFocusListener(focusAdapter);
            this.keyboardPanel.add(jTextArea);
        }
        this.updateTextAll();
        this.mainPanel = new JScrollPane(this.keyboardPanel);
        this.mainPanel.setPreferredSize(new Dimension(Math.min(700, 1356), 490));
    }

    public JComponent getPanel() {
        return this.mainPanel;
    }

    public void blank() {
        if (JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? "\u30ad\u30fc\u5272\u308a\u5f53\u3066\u3092\u767d\u7d19\u306b\u3057\u307e\u3059\u304b\uff1f" : "Do you want to blank the key assignments?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) != 0) {
            return;
        }
        this.beforeChange();
        Arrays.fill(this.currentMap, 0);
        this.updateTextAll();
    }

    public void reset(int[] nArray) {
        if (JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? "\u30ad\u30fc\u5272\u308a\u5f53\u3066\u3092\u521d\u671f\u5024\u306b\u623b\u3057\u307e\u3059\u304b\uff1f" : "Do you want to reset the key assignments to default?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) != 0) {
            return;
        }
        this.beforeChange();
        System.arraycopy(nArray, 0, this.currentMap, 0, this.currentMap.length);
        this.updateTextAll();
    }

    public void save() {
        JFileChooser2 jFileChooser2 = new JFileChooser2(lastFile);
        jFileChooser2.setFileFilter(txtFileFilter);
        if (jFileChooser2.showSaveDialog(null) == 0) {
            File file = jFileChooser2.getSelectedFile();
            String string = file.getPath();
            String string2 = string.toLowerCase();
            if (string2.endsWith(".csv")) {
                this.saveCSV(string);
                file = lastFile;
            } else if (string2.endsWith(".txt")) {
                this.saveText(string);
                file = lastFile;
            }
        }
    }

    public void saveCSV(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XEiJ.prgIsMac ? "X68000,keyCode,extendedKeyCode,keyLocation,keytop\r\n" : "X68000,keyCode,rawCode,keyLocation,keytop\r\n");
        for (int i = 0; i < 113; ++i) {
            int n;
            for (int j = 0; j < 3 && (n = this.currentMap[3 * i + j]) != 0; ++j) {
                stringBuilder.append(i + (i < 108 ? 1 : 4));
                stringBuilder.append(",");
                stringBuilder.append(n >> 16 & (XEiJ.prgIsMac ? 4095 : 65535));
                stringBuilder.append(",");
                stringBuilder.append(n >> 4 & (XEiJ.prgIsMac ? 0xF000FFF : 4095));
                stringBuilder.append(",");
                stringBuilder.append(n & 0xF);
                stringBuilder.append(",\u3010");
                stringBuilder.append(TEXT_ARRAY[i]);
                stringBuilder.append("\u3011\r\n");
            }
        }
        XEiJ.rscPutTextFile(string, stringBuilder.toString(), "cp932");
    }

    public void saveText(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = this.currentMap.length; 0 < n && this.currentMap[n - 1] == 0; --n) {
        }
        stringBuilder.append("keymap=-3");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(',');
            if (this.currentMap[i] == 0) continue;
            stringBuilder.append(this.currentMap[i]);
        }
        stringBuilder.append("\n");
        XEiJ.rscPutTextFile(string, stringBuilder.toString());
    }

    public void restore() {
        JFileChooser2 jFileChooser2 = new JFileChooser2(lastFile);
        jFileChooser2.setFileFilter(txtFileFilter);
        if (jFileChooser2.showOpenDialog(null) != 0) {
            return;
        }
        File file = jFileChooser2.getSelectedFile();
        String string = file.getPath();
        String string2 = string.toLowerCase();
        if (string2.endsWith(".csv")) {
            if (this.restoreCSV(string)) {
                lastFile = file;
            }
        } else if (string2.endsWith(".txt") && this.restoreText(string)) {
            lastFile = file;
        }
    }

    public boolean restoreCSV(String string) {
        String string2 = XEiJ.rscGetTextFile(string, "cp932");
        if (string2.length() == 0) {
            return false;
        }
        String[] stringArray = 0 <= string2.indexOf("\r\n") ? string2.split("\r\n") : (0 <= string2.indexOf("\n") ? string2.split("\n") : (0 <= string2.indexOf("\r") ? string2.split("\r") : new String[]{string2}));
        int n = stringArray.length;
        if (n < 1) {
            return false;
        }
        int[] nArray = new int[339];
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String[] stringArray2 = stringArray[i].split(",");
            int n2 = stringArray2.length;
            if (n2 < 4) {
                return false;
            }
            if (i == 0) {
                object2 = stringArray2[0];
                if (((String)object2).startsWith("\"") && ((String)object2).endsWith("\"")) {
                    object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                }
                if (((String)(object2 = ((String)object2).trim())).equals("X68000")) continue;
                return false;
            }
            object2 = new int[4];
            for (object = 0; object < 4; ++object) {
                String string3 = stringArray2[object];
                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                string3 = string3.trim();
                try {
                    object2[object] = Integer.parseInt(string3, 10);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            object = object2[0];
            Object object3 = object2[1];
            Object object4 = object2[2];
            Object object5 = object2[3];
            if ((1 > object || object > 108) && (112 > object || object > 116) || (object3 & (XEiJ.prgIsMac ? 4095 : 65535)) != object3 || (object4 & (XEiJ.prgIsMac ? 0xF000FFF : 4095)) != object4 || (object5 & 0xF) != object5) {
                return false;
            }
            int n3 = object3 << 16 | object4 << 4 | object5;
            if (n3 == 0) {
                return false;
            }
            int n4 = object - (object < 112 ? 1 : 4);
            if (nArray[3 * n4] == 0) {
                nArray[3 * n4] = n3;
                continue;
            }
            if (nArray[3 * n4 + 1] == 0) {
                nArray[3 * n4 + 1] = n3;
                continue;
            }
            if (nArray[3 * n4 + 2] == 0) {
                nArray[3 * n4 + 2] = n3;
                continue;
            }
            return false;
        }
        this.beforeChange();
        System.arraycopy(nArray, 0, this.currentMap, 0, nArray.length);
        this.updateTextAll();
        return true;
    }

    public boolean restoreText(String string) {
        String string2 = XEiJ.rscGetTextFile(string);
        if (string2.length() == 0) {
            return false;
        }
        String[] stringArray = string2.split("=");
        if (stringArray.length != 2) {
            return false;
        }
        String string3 = stringArray[0].trim();
        String string4 = stringArray[1].trim();
        if (!string3.equals("keymap")) {
            return false;
        }
        String[] stringArray2 = string4.split(",");
        int[] nArray = new int[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string5 = stringArray2[i].trim();
            if (string5.length() == 0) {
                nArray[i] = 0;
                continue;
            }
            try {
                nArray[i] = Integer.parseInt(string5, 10);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (nArray.length < 1 || 340 < nArray.length || nArray[0] != -3) {
            return false;
        }
        int[] nArray2 = new int[339];
        Arrays.fill(nArray2, 0);
        for (int i = 0; i < 339; ++i) {
            if (1 + i >= nArray.length) continue;
            nArray2[i] = nArray[1 + i];
        }
        this.beforeChange();
        System.arraycopy(nArray2, 0, this.currentMap, 0, nArray2.length);
        this.updateTextAll();
        return true;
    }

    public void undo() {
        if (!undoList.isEmpty()) {
            int[] nArray = new int[this.currentMap.length];
            System.arraycopy(this.currentMap, 0, nArray, 0, this.currentMap.length);
            redoList.addFirst(nArray);
            nArray = undoList.removeLast();
            System.arraycopy(nArray, 0, this.currentMap, 0, this.currentMap.length);
            this.updateTextAll();
        }
    }

    public void redo() {
        if (!redoList.isEmpty()) {
            int[] nArray = new int[this.currentMap.length];
            System.arraycopy(this.currentMap, 0, nArray, 0, this.currentMap.length);
            undoList.addLast(nArray);
            nArray = redoList.removeFirst();
            System.arraycopy(nArray, 0, this.currentMap, 0, this.currentMap.length);
            this.updateTextAll();
        }
    }

    public void beforeChange() {
        if (undoList.size() == 1000) {
            undoList.removeFirst();
        }
        redoList.clear();
        int[] nArray = new int[this.currentMap.length];
        System.arraycopy(this.currentMap, 0, nArray, 0, this.currentMap.length);
        undoList.addLast(nArray);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.closeIME(keyEvent);
        this.beforeChange();
        int n = Integer.parseInt(keyEvent.getComponent().getName());
        int n2 = keyEvent.getKeyCode();
        if (n != 0 && n2 == 27) {
            this.currentMap[3 * n] = 0;
            this.currentMap[3 * n + 1] = 0;
            this.currentMap[3 * n + 2] = 0;
            this.updateText(n);
        } else if (!(n != 108 && n2 == 16 || n != 109 && n2 == 17)) {
            int n3 = keyEvent.getKeyLocation();
            int n4 = XEiJ.prgIsMac ? keyEvent.getExtendedKeyCode() : this.getRawCode(keyEvent);
            int n5 = n2 << 16 | n4 << 4 | n3;
            if ((n2 & (XEiJ.prgIsMac ? 4095 : 65535)) != n2 || (n4 & (XEiJ.prgIsMac ? 0xF000FFF : 4095)) != n4 || (n3 & 0xF) != n3 || n5 == 0) {
                System.out.printf("KeyEvent: keyCode=0x%08x, extendedOrRaw=0x%08x, keyLocation=0x%08x\n", n2, n4, n3);
            } else if (this.currentMap[3 * n] == n5 || this.currentMap[3 * n + 1] == n5 || this.currentMap[3 * n + 2] == n5) {
                this.currentMap[3 * n] = n5;
                this.currentMap[3 * n + 1] = 0;
                this.currentMap[3 * n + 2] = 0;
                this.updateText(n);
            } else {
                if (this.currentMap[3 * n + 2] != 0) {
                    this.currentMap[3 * n] = this.currentMap[3 * n + 1];
                    this.currentMap[3 * n + 1] = this.currentMap[3 * n + 2];
                    this.currentMap[3 * n + 2] = 0;
                }
                if (this.currentMap[3 * n] == 0) {
                    this.currentMap[3 * n] = n5;
                } else if (this.currentMap[3 * n + 1] == 0) {
                    this.currentMap[3 * n + 1] = n5;
                } else {
                    this.currentMap[3 * n + 2] = n5;
                }
                this.updateText(n);
                for (int i = 0; i < 113; ++i) {
                    if (i == n) continue;
                    if (this.currentMap[3 * i] == n5) {
                        this.currentMap[3 * i] = this.currentMap[3 * i + 1];
                        this.currentMap[3 * i + 1] = this.currentMap[3 * i + 2];
                        this.currentMap[3 * i + 2] = 0;
                        this.updateText(i);
                        break;
                    }
                    if (this.currentMap[3 * i + 1] == n5) {
                        this.currentMap[3 * i + 1] = this.currentMap[3 * i + 2];
                        this.currentMap[3 * i + 2] = 0;
                        this.updateText(i);
                        break;
                    }
                    if (this.currentMap[3 * i + 2] != n5) continue;
                    this.currentMap[3 * i + 2] = 0;
                    this.updateText(i);
                    break;
                }
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.closeIME(keyEvent);
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.closeIME(keyEvent);
        keyEvent.consume();
    }

    public void closeIME(KeyEvent keyEvent) {
        JTextArea jTextArea = (JTextArea)keyEvent.getComponent();
        try {
            InputContext inputContext = jTextArea.getInputContext();
            if (inputContext != null && inputContext.isCompositionEnabled()) {
                inputContext.setCompositionEnabled(false);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void updateTextAll() {
        for (int i = 0; i < 113; ++i) {
            this.updateText(i);
        }
    }

    public void updateText(int n) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int n2 = this.currentMap[3 * n + i];
            if (n2 == 0) {
                if (i != 0) break;
                break;
            }
            if (i != 0) {
                stringBuilder.append(" ");
            }
            int n3 = n2 >> 16 & (XEiJ.prgIsMac ? 4095 : 65535);
            int n4 = n2 >> 4 & (XEiJ.prgIsMac ? 0xF000FFF : 4095);
            int n5 = n2 & 0xF;
            switch (n5) {
                case 2: {
                    stringBuilder.append(Multilingual.mlnJapanese ? "\u5de6" : "Left ");
                    break;
                }
                case 3: {
                    stringBuilder.append(Multilingual.mlnJapanese ? "\u53f3" : "Right ");
                    break;
                }
                case 4: {
                    stringBuilder.append("#");
                }
            }
            stringBuilder.append(KeyEvent.getKeyText(XEiJ.prgIsMac && n4 != 0 ? n4 : n3));
        }
        if (!(string = stringBuilder.toString()).equals(this.textAreaArray[n].getText())) {
            Color color = n == this.focusedBox ? focusedColor : (this.currentMap[3 * n] != 0 ? assignedColor : backgroundColor);
            this.textAreaArray[n].setText(string);
            this.textAreaArray[n].setBackground(color);
            if (n == 108) {
                this.textAreaArray[113].setText(string);
                this.textAreaArray[113].setBackground(color);
            }
        }
    }

    public int getRawCode(KeyEvent keyEvent) {
        int n = 0;
        String string = keyEvent.paramString();
        int n2 = string.indexOf("rawCode=");
        if (0 <= n2) {
            char c;
            n2 += 8;
            int n3 = string.length();
            while (n2 < n3 && (c = string.charAt(n2)) >= '0' && '9' >= c) {
                n = n * 10 + (c - 48);
                ++n2;
            }
        }
        return n;
    }

    static {
        BOUNDS_ARRAY = new int[][]{{0, 5, 4, 4}, {4, 5, 4, 4}, {8, 5, 4, 4}, {12, 5, 4, 4}, {16, 5, 4, 4}, {20, 5, 4, 4}, {24, 5, 4, 4}, {28, 5, 4, 4}, {32, 5, 4, 4}, {36, 5, 4, 4}, {40, 5, 4, 4}, {44, 5, 4, 4}, {48, 5, 4, 4}, {52, 5, 4, 4}, {56, 5, 6, 4}, {0, 9, 6, 4}, {6, 9, 4, 4}, {10, 9, 4, 4}, {14, 9, 4, 4}, {18, 9, 4, 4}, {22, 9, 4, 4}, {26, 9, 4, 4}, {30, 9, 4, 4}, {34, 9, 4, 4}, {38, 9, 4, 4}, {42, 9, 4, 4}, {46, 9, 4, 4}, {50, 9, 4, 4}, {55, 9, 7, 8}, {7, 13, 4, 4}, {11, 13, 4, 4}, {15, 13, 4, 4}, {19, 13, 4, 4}, {23, 13, 4, 4}, {27, 13, 4, 4}, {31, 13, 4, 4}, {35, 13, 4, 4}, {39, 13, 4, 4}, {43, 13, 4, 4}, {47, 13, 4, 4}, {51, 13, 4, 4}, {9, 17, 4, 4}, {13, 17, 4, 4}, {17, 17, 4, 4}, {21, 17, 4, 4}, {25, 17, 4, 4}, {29, 17, 4, 4}, {33, 17, 4, 4}, {37, 17, 4, 4}, {41, 17, 4, 4}, {45, 17, 4, 4}, {49, 17, 4, 4}, {21, 21, 14, 4}, {64, 5, 4, 4}, {72, 5, 4, 4}, {64, 9, 4, 4}, {68, 9, 4, 4}, {72, 9, 4, 4}, {64, 13, 4, 8}, {68, 13, 4, 4}, {72, 13, 4, 8}, {68, 17, 4, 4}, {78, 5, 4, 4}, {82, 5, 4, 4}, {86, 5, 4, 4}, {90, 5, 4, 4}, {78, 9, 4, 4}, {82, 9, 4, 4}, {86, 9, 4, 4}, {90, 9, 4, 4}, {78, 13, 4, 4}, {82, 13, 4, 4}, {86, 13, 4, 4}, {90, 13, 4, 4}, {78, 17, 4, 4}, {82, 17, 4, 4}, {86, 17, 4, 4}, {90, 17, 4, 8}, {78, 21, 4, 4}, {82, 21, 4, 4}, {86, 21, 4, 4}, {82, 0, 4, 4}, {86, 0, 4, 4}, {90, 0, 4, 4}, {11, 21, 5, 4}, {16, 21, 5, 4}, {35, 21, 6, 4}, {41, 21, 5, 4}, {46, 21, 5, 4}, {64, 0, 4, 4}, {68, 0, 4, 4}, {72, 0, 4, 4}, {78, 0, 4, 4}, {68, 5, 4, 4}, {7, 21, 4, 4}, {51, 21, 4, 4}, {0, 0, 4, 4}, {5, 0, 4, 4}, {11, 1, 5, 3}, {16, 1, 5, 3}, {21, 1, 5, 3}, {26, 1, 5, 3}, {31, 1, 5, 3}, {37, 1, 5, 3}, {42, 1, 5, 3}, {47, 1, 5, 3}, {52, 1, 5, 3}, {57, 1, 5, 3}, {0, 17, 9, 4}, {0, 13, 7, 4}, {64, 21, 6, 4}, {70, 21, 6, 4}, {0, 21, 4, 4}, {53, 17, 9, 4}};
        TEXT_ARRAY = "ESC,\uff11\uff01\u306c\u3000,\uff12\uff02\u3075\u3000,\uff13\uff03\u3042\u3041,\uff14\uff04\u3046\u3045,\uff15\uff05\u3048\u3047,\uff16\uff06\u304a\u3049,\uff17\uff07\u3084\u3083,\uff18\uff08\u3086\u3085,\uff19\uff09\u3088\u3087,\uff10\u3000\u308f\u3092,\uff0d\uff1d\u307b\u3000,\uff3e\uff5e\u3078\u3000,\uffe5\uff5c\u30fc\u3000,BS,TAB,\uff31\u3000\u305f\u3000,\uff37\u3000\u3066\u3000,\uff25\u3000\u3044\u3043,\uff32\u3000\u3059\u3000,\uff34\u3000\u304b\u3000,\uff39\u3000\u3093\u3000,\uff35\u3000\u306a\u3000,\uff29\u3000\u306b\u3000,\uff2f\u3000\u3089\u3000,\uff30\u3000\u305b\u3000,\uff20\uff40\u309b\u3000,\uff3b\uff5b\u309c\u300c,\u30ea\u30bf\u30fc\u30f3,\uff21\u3000\u3061\u3000,\uff33\u3000\u3068\u3000,\uff24\u3000\u3057\u3000,\uff26\u3000\u306f\u3000,\uff27\u3000\u304d\u3000,\uff28\u3000\u304f\u3000,\uff2a\u3000\u307e\u3000,\uff2b\u3000\u306e\u3000,\uff2c\u3000\u308a\u3000,\uff1b\uff0b\u308c\u3000,\uff1a\uff0a\u3051\u3000,\uff3d\uff5d\u3080\u300d,\uff3a\u3000\u3064\u3063,\uff38\u3000\u3055\u3000,\uff23\u3000\u305d\u3000,\uff36\u3000\u3072\u3000,\uff22\u3000\u3053\u3000,\uff2e\u3000\u307f\u3000,\uff2d\u3000\u3082\u3000,\uff0c\uff1c\u306d\u3001,\uff0e\uff1e\u308b\u3002,\uff0f\uff1f\u3081\u30fb,\u3000\uff3f\u308d\u25a1,\u30b9\u30da\u30fc\u30b9,HOME,DEL,ROLLUP,ROLLDOWN,UNDO,\u2190,\u2191,\u2192,\u2193,CLR,\uff0f,\uff0a,\uff0d,\uff17,\uff18,\uff19,\uff0b,\uff14,\uff15,\uff16,\uff1d,\uff11,\uff12,\uff13,ENTER,\uff10,\uff0c,\uff0e,\u8a18\u53f7\u5165\u529b,\u767b\u9332,HELP,XF1,XF2,XF3,XF4,XF5,\u304b\u306a,\u30ed\u30fc\u30de\u5b57,\u30b3\u30fc\u30c9\u5165\u529b,CAPS,INS,\u3072\u3089\u304c\u306a,\u5168\u89d2,BREAK,COPY,F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,SHIFT,CTRL,OPT.1,OPT.2,NUM,SHIFT".split(",");
    }
}

