/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import xeij.Multilingual;
import xeij.XEiJ;

public class JFileChooser2
extends JFileChooser {
    private static final boolean DEBUG = false;
    public static final int MAXIMUM_HISTORY_COUNT = 100;
    public static final int MAXIMUM_ROW_COUNT = 10;
    protected ArrayList<File[]> history = new ArrayList();
    protected JTextField formerTextField;
    protected JComboBox<String> comboBox;
    protected JTextField comboBoxTextField;
    protected int ignoreItemEvent;
    protected static final Pattern NAME_PATTERN = Pattern.compile("\\s*+(?:,\\s*+)*+(?:([^\",]++)|\"([^\"]++)\"?+)");

    public JFileChooser2() {
        this(new File[0]);
    }

    public JFileChooser2(File file) {
        this(new File[]{file});
    }

    public JFileChooser2(File[] fileArray) {
        JPanel jPanel;
        this.history.add(fileArray);
        this.formerTextField = null;
        this.comboBox = null;
        this.comboBoxTextField = null;
        this.ignoreItemEvent = 0;
        try {
            jPanel = (JPanel)((JPanel)this.getComponent(3)).getComponent(0);
            this.formerTextField = (JTextField)jPanel.getComponent(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.comboBox = new JComboBox<String>(new String[0]);
        this.comboBox.setEditable(true);
        this.comboBox.setMaximumRowCount(10);
        this.comboBoxTextField = (JTextField)this.comboBox.getEditor().getEditorComponent();
        this.comboBoxTextField.setColumns(this.formerTextField.getColumns());
        this.comboBoxTextField.setText(this.formerTextField.getText());
        jPanel.remove(this.formerTextField);
        jPanel.add(this.comboBox);
        jPanel.validate();
        ((AbstractDocument)this.formerTextField.getDocument()).addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (JFileChooser2.this.ignoreItemEvent == 0) {
                    ++JFileChooser2.this.ignoreItemEvent;
                    JFileChooser2.this.comboBoxTextField.setText(JFileChooser2.this.formerTextField.getText());
                    --JFileChooser2.this.ignoreItemEvent;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (JFileChooser2.this.ignoreItemEvent == 0) {
                    ++JFileChooser2.this.ignoreItemEvent;
                    JFileChooser2.this.comboBoxTextField.setText(JFileChooser2.this.formerTextField.getText());
                    --JFileChooser2.this.ignoreItemEvent;
                }
            }
        });
        ((AbstractDocument)this.comboBoxTextField.getDocument()).addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (JFileChooser2.this.ignoreItemEvent == 0) {
                    ++JFileChooser2.this.ignoreItemEvent;
                    JFileChooser2.this.setSelectedFiles(JFileChooser2.this.namesToFiles(JFileChooser2.this.comboBoxTextField.getText()));
                    --JFileChooser2.this.ignoreItemEvent;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (JFileChooser2.this.ignoreItemEvent == 0) {
                    ++JFileChooser2.this.ignoreItemEvent;
                    JFileChooser2.this.setSelectedFiles(JFileChooser2.this.namesToFiles(JFileChooser2.this.comboBoxTextField.getText()));
                    --JFileChooser2.this.ignoreItemEvent;
                }
            }
        });
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (JFileChooser2.this.ignoreItemEvent == 0) {
                    int n;
                    ++JFileChooser2.this.ignoreItemEvent;
                    if (itemEvent.getStateChange() == 1 && 0 <= (n = JFileChooser2.this.comboBox.getSelectedIndex())) {
                        if (n < JFileChooser2.this.history.size()) {
                            File[] fileArray = JFileChooser2.this.history.get(n);
                            JFileChooser2.this.history.remove(n);
                            JFileChooser2.this.history.add(0, fileArray);
                        } else {
                            JFileChooser2.this.clearHistory();
                        }
                        JFileChooser2.this.historyToComboBox();
                        JFileChooser2.this.selectLastFiles();
                    }
                    --JFileChooser2.this.ignoreItemEvent;
                }
            }
        });
        this.historyToComboBox();
        this.selectLastFiles();
    }

    public void clearHistory() {
        XEiJ.pnlExitFullScreen(true);
        if (JOptionPane.showConfirmDialog(this, Multilingual.mlnJapanese ? "\u5c65\u6b74\u3092\u6d88\u53bb\u3057\u307e\u3059\u304b\uff1f" : "Do you want to clear history?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) == 0) {
            this.history.clear();
            this.history.add(0, new File[0]);
        }
    }

    public void selectLastFiles() {
        if (this.history.size() != 0) {
            File[] fileArray = this.history.get(0);
            if (fileArray.length == 0) {
                this.setCurrentDirectory(new File(".").getAbsoluteFile().getParentFile());
            }
            this.setSelectedFiles(fileArray);
        }
    }

    @Override
    public File getSelectedFile() {
        File[] fileArray = this.getSelectedFiles();
        return fileArray.length == 0 ? null : fileArray[0];
    }

    @Override
    public File[] getSelectedFiles() {
        if (this.comboBox == null) {
            return super.getSelectedFiles();
        }
        File[] fileArray = this.namesToFiles(this.comboBoxTextField.getText());
        return fileArray;
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    @Override
    public void setSelectedFiles(File[] fileArray) {
        File[] fileArray2 = null;
        if (fileArray != null) {
            fileArray2 = new File[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                fileArray2[i] = file.isDirectory() ? new File(file, ".") : file;
            }
        }
        super.setSelectedFiles(fileArray2);
    }

    public void addHistory(File file) {
        if (file != null) {
            this.addHistory(new File[]{file});
        }
    }

    public void addHistory(String string) {
        this.addHistory(JFileChooser2.pathsToFiles(string));
    }

    public void addHistory(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (int i = 0; i < this.history.size(); ++i) {
            Object[] objectArray = this.history.get(i);
            if (objectArray.length != 0 && !Arrays.equals(fileArray, objectArray)) continue;
            this.history.remove(i);
            --i;
        }
        if (this.history.size() == 100) {
            this.history.remove(99);
        }
        this.history.add(0, fileArray);
        this.historyToComboBox();
    }

    public ArrayList<String> getHistory() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File[] fileArray : this.history) {
            arrayList.add(JFileChooser2.filesToPaths(fileArray));
        }
        return arrayList;
    }

    public void setHistory(ArrayList<String> arrayList) {
        this.history.clear();
        block0: for (String string : arrayList) {
            Object[] objectArray = JFileChooser2.pathsToFiles(string);
            if (objectArray.length == 0) continue;
            for (Object[] objectArray2 : this.history) {
                if (!Arrays.equals(objectArray, objectArray2)) continue;
                continue block0;
            }
            this.history.add((File[])objectArray);
            if (this.history.size() != 100) continue;
            break;
        }
        this.historyToComboBox();
    }

    protected void historyToComboBox() {
        ++this.ignoreItemEvent;
        this.comboBox.removeAllItems();
        for (File[] fileArray : this.history) {
            this.comboBox.addItem(this.filesToNames(fileArray));
        }
        this.comboBox.addItem(Multilingual.mlnJapanese ? "---------- \u5c65\u6b74\u3092\u6d88\u53bb\u3059\u308b ----------" : "---------- Clear history ----------");
        --this.ignoreItemEvent;
    }

    public String filesToNames(File[] fileArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = fileArray.length;
        if (n != 0) {
            if (n == 1) {
                stringBuilder.append(fileArray[0].getName());
            } else {
                for (int i = 0; i < n; ++i) {
                    if (0 < i) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append('\"').append(fileArray[i].getName()).append('\"');
                }
            }
        }
        return stringBuilder.toString();
    }

    public File[] namesToFiles(String string) {
        File file = this.getCurrentDirectory();
        ArrayList<File> arrayList = new ArrayList<File>();
        Matcher matcher = NAME_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            File file2 = new File(file, string2).getAbsoluteFile();
            if (arrayList.contains(file2)) continue;
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static String filesToPaths(File[] fileArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = fileArray.length;
        if (n != 0) {
            if (n == 1) {
                stringBuilder.append(fileArray[0].getPath());
            } else {
                for (int i = 0; i < n; ++i) {
                    if (0 < i) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append('\"').append(fileArray[i].getPath()).append('\"');
                }
            }
        }
        return stringBuilder.toString();
    }

    public static File[] pathsToFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Matcher matcher = NAME_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            File file = new File(string2).getAbsoluteFile();
            if (arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

