/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.BranchLog;
import xeij.CharacterCode;
import xeij.ComponentFactory;
import xeij.Disassembler;
import xeij.Hex8Spinner;
import xeij.InstructionBreakPoint;
import xeij.LabeledAddress;
import xeij.LnF;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ReverseLongModel;
import xeij.RotaryButton;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class DisassembleList {
    public static final int DDP_ITEM_SIZE = 2;
    public static final int DDP_PAGE_SIZE = 1024;
    public static final int DDP_ITEM_MASK = -2;
    public static final int DDP_PAGE_MASK = -1024;
    public static final int DDP_MAX_ITEMS = 514;
    public static final char[] DDP_MOVEQD0_BASE = "moveq.l #$xx,d0".toCharArray();
    public static final char[] DDP_DCW_BASE = ".dc.w   $xxxx".toCharArray();
    public static int ddpItemCount;
    public static int ddpItemIndex;
    public static int ddpItemAddress;
    public static int ddpPageAddress;
    public static final int[] ddpAddressArray;
    public static final int[] ddpSplitArray;
    public static final int[] ddpCaretArray;
    public static final boolean[] ddpDCWArray;
    public static JFrame ddpFrame;
    public static ScrollTextArea ddpBoard;
    public static JTextArea ddpTextArea;
    public static Hex8Spinner ddpSpinner;
    public static int ddpPopupAddress;
    public static boolean ddpBacktraceOn;
    public static long ddpBacktraceRecord;
    public static SpinnerNumberModel ddpBacktraceModel;
    public static JSpinner ddpBacktraceSpinner;
    public static JCheckBox ddpBacktraceCheckBox;
    public static String ddpStoppedBy;
    public static int ddpStoppedAddress;
    public static int ddpSupervisorMode;
    public static JCheckBox ddpSupervisorCheckBox;
    public static int ddpProgramMode;
    public static RotaryButton ddpProgramButton;
    public static JComboBox<String> ddpProgramBox;
    public static int ddpProgramAge;

    public static void ddpInit() {
        ddpItemCount = 0;
        ddpItemIndex = 0;
        ddpItemAddress = -1;
        ddpPageAddress = 0;
        ddpSupervisorMode = 1;
        ddpFrame = null;
    }

    public static void ddpStart() {
        if (RestorableFrame.rfmGetOpened("ddp")) {
            DisassembleList.ddpOpen(-1, -1, true);
        }
    }

    public static void ddpOpen(int n, int n2, boolean bl) {
        if (ddpFrame == null) {
            DisassembleList.ddpMake();
        }
        ddpFrame.setVisible(true);
        ddpBacktraceRecord = -1L;
        LabeledAddress.lblClear();
        DisassembleList.ddpUpdate(n, n2, bl);
        XEiJ.pnlExitFullScreen(false);
        XEiJ.dbgVisibleMask |= 2;
    }

    public static void ddpMake() {
        ddpBoard = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new ScrollTextArea(), LnF.lnfMonospacedFont), 730, 400);
        ddpBoard.setMargin(new Insets(2, 4, 2, 4));
        ddpBoard.setHighlightCursorOn(true);
        ddpTextArea = ddpBoard.getTextArea();
        ddpTextArea.setEditable(false);
        ddpTextArea.addMouseWheelListener(mouseWheelEvent -> {
            int n = mouseWheelEvent.getWheelRotation();
            JViewport jViewport = ddpBoard.getViewport();
            Point point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(point.x, Math.max(0, Math.min(DisassembleList.ddpTextArea.getSize().height - jViewport.getExtentSize().height, point.y + n * ddpTextArea.getFont().getSize() * 5))));
        });
        ddpSpinner = ComponentFactory.createHex8Spinner(ddpPageAddress, -2, true, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (XEiJ.dbgEventMask == 0) {
                    DisassembleList.ddpUpdate(ddpSpinner.getAbsoluteValue(), ddpSupervisorMode, false);
                }
            }
        });
        ComponentFactory.addListener(ddpTextArea, new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                int n;
                if (XEiJ.dbgEventMask == 0 && (n = caretEvent.getDot()) == caretEvent.getMark()) {
                    int n2 = Arrays.binarySearch(ddpSplitArray, 1, ddpItemCount, n + 1);
                    n2 = (n2 >> 31 ^ n2) - 1;
                    ddpSpinner.setHintIndex(n2);
                }
            }
        });
        ComponentFactory.addListener(ddpTextArea, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, ddpTextArea, true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, ddpTextArea, true);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Backtrace": {
                        ddpBacktraceOn = ((JCheckBox)actionEvent.getSource()).isSelected();
                        if (XEiJ.dbgEventMask != 0) break;
                        DisassembleList.ddpUpdate(ddpAddressArray[ddpItemIndex], ddpSupervisorMode, true);
                        break;
                    }
                    case "User/Supervisor": {
                        if (XEiJ.dbgEventMask != 0) break;
                        DisassembleList.ddpUpdate(ddpAddressArray[ddpItemIndex], ((JCheckBox)actionEvent.getSource()).isSelected() ? 1 : 0, true);
                        break;
                    }
                    case "Address and/or offset": {
                        ddpProgramMode = ddpProgramButton.getIndex();
                        if (XEiJ.dbgEventMask != 0) break;
                        DisassembleList.ddpUpdate(0, ddpSupervisorMode, true);
                        break;
                    }
                    case "Program name": {
                        int n = ddpProgramBox.getSelectedIndex();
                        if (0 > n) break;
                        if (n == 0) {
                            ddpSpinner.setOffset(0);
                            break;
                        }
                        if (ddpProgramAge != LabeledAddress.lblProgramAge) break;
                        ddpSpinner.setOffset(LabeledAddress.lblProgramHead[n - 1]);
                    }
                }
            }
        };
        ddpProgramMode = 0;
        ddpProgramButton = Multilingual.mlnToolTipText(ComponentFactory.createRotaryButton("Address and/or offset", actionListener, ddpProgramMode, XEiJ.createImage(20, 14, "222222222222222222222..................22........22........22......222222......22.....22222222.....22.....22.22........22.....2222222......22......2222222.....22........22.22.....22.....22222222.....22......222222......22........22........22..................222222222222222222222", LnF.lnfRGB[0], LnF.lnfRGB[6], LnF.lnfRGB[12]), XEiJ.createImage(20, 14, "222222222222222222222..................22......22..........22......22..........22......22..........22......22..........22......22..........22......22..........22......22..........22......22..........22......2222222.....22......2222222.....22..................222222222222222222222", LnF.lnfRGB[0], LnF.lnfRGB[6], LnF.lnfRGB[12]), XEiJ.createImage(20, 14, "222222222222222222222..................22....22....22......22..222222..22......22.22222222.22......22.22.22....22......22.2222222..22......22..2222222.22......22....22.22.22......22.22222222.22......22..222222..2222222.22....22....2222222.22..................222222222222222222222", LnF.lnfRGB[0], LnF.lnfRGB[6], LnF.lnfRGB[12])), "ja", "\u30a2\u30c9\u30ec\u30b9\u3068\u30aa\u30d5\u30bb\u30c3\u30c8");
        ddpProgramBox = Multilingual.mlnToolTipText(ComponentFactory.createComboBox(0, "Program name", actionListener, 16, ""), "ja", "\u30d7\u30ed\u30b0\u30e9\u30e0\u540d");
        ddpProgramBox.setMaximumRowCount(16);
        ddpProgramAge = -1;
        ddpBacktraceOn = false;
        ddpBacktraceRecord = -1L;
        ddpBacktraceModel = new ReverseLongModel(0L, 0L, 0L, 1L);
        ddpBacktraceSpinner = ComponentFactory.createNumberSpinner(ddpBacktraceModel, 10, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (XEiJ.dbgEventMask == 0 && XEiJ.mpuTask == null) {
                    long l = ddpBacktraceModel.getNumber().longValue();
                    int n = (char)l << 1;
                    if (ddpBacktraceRecord < l) {
                        ddpBacktraceRecord = l;
                        DisassembleList.ddpUpdate(BranchLog.blgArray[n] & 0xFFFFFFFE, BranchLog.blgArray[n] & 1, false);
                    } else if (l < ddpBacktraceRecord) {
                        ddpBacktraceRecord = l;
                        DisassembleList.ddpUpdate(BranchLog.blgArray[n + 1] & 0xFFFFFFFE, BranchLog.blgArray[n] & 1, false);
                    }
                }
            }
        });
        ddpBacktraceCheckBox = Multilingual.mlnToolTipText(ComponentFactory.createIconCheckBox(ddpBacktraceOn, LnF.LNF_BACK_TRACE_IMAGE, LnF.LNF_BACK_TRACE_SELECTED_IMAGE, "Backtrace", actionListener), "ja", "\u30d0\u30c3\u30af\u30c8\u30ec\u30fc\u30b9");
        ddpSupervisorCheckBox = Multilingual.mlnToolTipText(ComponentFactory.createIconCheckBox(ddpSupervisorMode != 0, LnF.LNF_USER_SELECTED_IMAGE, LnF.LNF_SUPERVISOR_SELECTED_IMAGE, "User/Supervisor", actionListener), "ja", "\u30e6\u30fc\u30b6/\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6");
        ddpFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("ddp", "Disassemble list", null, ComponentFactory.createBorderPanel(ddpBoard, ComponentFactory.createHorizontalBox(ddpProgramButton, ddpProgramBox, ddpSpinner, ddpSupervisorCheckBox, Box.createHorizontalStrut(12), ComponentFactory.createHorizontalBox(ddpBacktraceCheckBox, ddpBacktraceSpinner, Box.createHorizontalStrut(12)), Box.createHorizontalGlue(), XEiJ.mpuMakeOriIllegalCheckBox(), XEiJ.mpuMakeStopOnErrorCheckBox(), XEiJ.mpuMakeStopAtStartCheckBox(), Box.createHorizontalStrut(12), XEiJ.mpuMakeBreakButton(), XEiJ.mpuMakeTraceButton(), XEiJ.mpuMakeTrace10Button(), XEiJ.mpuMakeTrace100Button(), XEiJ.mpuMakeStepButton(), XEiJ.mpuMakeStep10Button(), XEiJ.mpuMakeStep100Button(), XEiJ.mpuMakeReturnButton(), XEiJ.mpuMakeRunButton()))), "ja", "\u9006\u30a2\u30bb\u30f3\u30d6\u30eb\u30ea\u30b9\u30c8");
        ComponentFactory.addListener(ddpFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFFD;
            }
        });
        ddpStoppedBy = null;
        ddpStoppedAddress = -1;
    }

    public static void ddpUpdate(int n, int n2, boolean bl) {
        int n3;
        int n4;
        ++XEiJ.dbgEventMask;
        if (n == -1) {
            n = ddpStoppedBy == null ? XEiJ.regPC : XEiJ.regPC0;
            ddpStoppedAddress = n;
            bl = true;
        } else if (n == 0) {
            n = ddpItemAddress;
        }
        if (n2 == -1) {
            n2 = XEiJ.regSRS;
            bl = true;
        }
        if (ddpSupervisorMode != 0 != (n2 != 0)) {
            ddpSupervisorMode = n2;
            bl = true;
            if (ddpSupervisorCheckBox.isSelected() != (n2 != 0)) {
                ddpSupervisorCheckBox.setSelected(n2 != 0);
            }
        }
        if (bl) {
            ddpItemCount = 0;
        }
        n &= 0xFFFFFFFE;
        if (XEiJ.mpuTask == null) {
            long l = BranchLog.blgNewestRecord;
            long l2 = Math.max(0L, l - 65535L);
            if (ddpBacktraceRecord < l2 || l < ddpBacktraceRecord) {
                ddpBacktraceRecord = l;
                ddpBacktraceModel.setMaximum(Long.valueOf(l));
                ddpBacktraceModel.setValue(l);
            }
            if (ddpBacktraceOn) {
                int n5 = (char)ddpBacktraceRecord << 1;
                if (n >>> 1 < BranchLog.blgArray[n5] >>> 1) {
                    if (l2 < ddpBacktraceRecord) {
                        ddpBacktraceModel.setValue(--ddpBacktraceRecord);
                        n = BranchLog.blgArray[((char)ddpBacktraceRecord << 1) + 1] & 0xFFFFFFFE;
                    }
                } else if (BranchLog.blgArray[n5 + 1] >>> 1 < n >>> 1 && ddpBacktraceRecord < l) {
                    ddpBacktraceModel.setValue(++ddpBacktraceRecord);
                    n = BranchLog.blgArray[(char)ddpBacktraceRecord << 1] & 0xFFFFFFFE;
                }
            }
        }
        if (ddpItemCount != 0) {
            int n6 = Arrays.binarySearch(ddpAddressArray, 1, ddpItemCount, n + 1);
            if (0 < (n6 = (n6 >> 31 ^ n6) - 1) && n6 < ddpItemCount - 1 && ddpAddressArray[n6] == n && !ddpDCWArray[n6]) {
                ddpItemAddress = n;
                if (ddpItemIndex != n6) {
                    ddpItemIndex = n6;
                    ddpTextArea.setCaretPosition(ddpCaretArray[n6]);
                }
                --XEiJ.dbgEventMask;
                return;
            }
        }
        ddpItemAddress = n;
        ddpPageAddress = n & 0xFFFFFC00;
        int n7 = ddpPageAddress + 1024;
        int n8 = 10;
        if (ddpProgramMode == 0) {
            n4 = 8;
            n3 = 36;
        } else if (ddpProgramMode == 1) {
            n4 = 7;
            n3 = 37;
        } else {
            n4 = 16;
            n3 = 48;
        }
        String string = new StringBuilder().append(XEiJ.DBG_SPACES, 0, n4 + 2).append("+0+1+2+3+4+5+6+7+8+9").append(XEiJ.DBG_SPACES, 0, 2 + n3 + n8 - 2).append("\u25b2\n").toString();
        String string2 = new StringBuilder().append(XEiJ.DBG_SPACES, 0, n4 + 2).append("+0+1+2+3+4+5+6+7+8+9").append(XEiJ.DBG_SPACES, 0, 2 + n3 + n8 - 2).append("\u25bc").toString();
        DisassembleList.ddpAddressArray[0] = ddpPageAddress - 2;
        DisassembleList.ddpSplitArray[0] = 0;
        DisassembleList.ddpCaretArray[0] = 0;
        StringBuilder stringBuilder = new StringBuilder(string);
        int n9 = 1;
        int n10 = ddpPageAddress;
        int n11 = n7;
        int n12 = n7;
        boolean bl2 = false;
        if (LabeledAddress.lblProgramCount == 0) {
            LabeledAddress.lblUpdateProgram();
        }
        if (ddpProgramAge != LabeledAddress.lblProgramAge) {
            ddpProgramAge = LabeledAddress.lblProgramAge;
            ddpProgramBox.removeAllItems();
            ddpProgramBox.addItem("raw address");
            for (int i = 0; i < LabeledAddress.lblProgramCount; ++i) {
                ddpProgramBox.addItem(XEiJ.fmtHex8(new StringBuilder(), LabeledAddress.lblProgramHead[i]).append(' ').append(LabeledAddress.lblProgramName[i]).toString());
            }
        }
        TreeMap<Integer, InstructionBreakPoint.InstructionBreakRecord> treeMap = InstructionBreakPoint.ibpPointTable;
        block1: do {
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            block69: {
                block67: {
                    InstructionBreakPoint.InstructionBreakRecord instructionBreakRecord;
                    block68: {
                        int n20;
                        String string3;
                        if (n11 <= n10 && n10 < n12) {
                            Disassembler.disStatus = 0;
                            n19 = MC68060.mmuPeekWordZeroCode(n10, n2);
                            if ((n19 & 0xFE00) == 28672 && MC68060.mmuPeekWordZeroCode(n10 + 2, n2) == 20047) {
                                XEiJ.fmtHex2(DDP_MOVEQD0_BASE, 10, n19);
                                string3 = String.valueOf(DDP_MOVEQD0_BASE);
                            } else {
                                XEiJ.fmtHex4(DDP_DCW_BASE, 9, n19);
                                string3 = String.valueOf(DDP_DCW_BASE);
                            }
                            n18 = n10 + 2;
                            DisassembleList.ddpDCWArray[n9] = true;
                        } else {
                            LabeledAddress.lblGetIndex(n10);
                            string3 = Disassembler.disDisassemble(new StringBuilder(), n10, n2, LabeledAddress.lblLastGetHead, LabeledAddress.lblLastGetTail, ddpProgramMode).toString();
                            for (n19 = n10 + 2; n19 < Disassembler.disPC; n19 += 2) {
                                if (n19 != n && !treeMap.containsKey(n19)) continue;
                                n11 = n10;
                                n12 = n19;
                                continue block1;
                            }
                            n18 = Disassembler.disPC;
                            DisassembleList.ddpDCWArray[n9] = false;
                        }
                        if (bl2) {
                            stringBuilder.append('\n');
                        }
                        if (n10 == n) {
                            ddpItemIndex = n9;
                        }
                        DisassembleList.ddpAddressArray[n9] = n10;
                        DisassembleList.ddpSplitArray[n9] = stringBuilder.length();
                        if (bl2) {
                            n19 = stringBuilder.length();
                            LabeledAddress.lblSearch(stringBuilder, n10);
                            if (n19 < stringBuilder.length()) {
                                stringBuilder.append('\n');
                            }
                        }
                        if (n10 == ddpStoppedAddress && ddpStoppedBy != null) {
                            stringBuilder.append(ddpStoppedBy).append('\n');
                        }
                        DisassembleList.ddpCaretArray[n9] = stringBuilder.length();
                        n19 = n10;
                        n17 = Math.min(n19 + n8, n18);
                        if (ddpProgramMode == 0 || ddpProgramMode == 2) {
                            XEiJ.fmtHex8(stringBuilder, n19);
                        }
                        if (ddpProgramMode == 1 || ddpProgramMode == 2) {
                            n20 = LabeledAddress.lblGetIndex(n19);
                            if (n20 != -1 && LabeledAddress.lblLastGetHead != 0) {
                                if (ddpProgramMode == 2) {
                                    stringBuilder.append(':');
                                }
                                XEiJ.fmtHex6(stringBuilder.append('L'), n19 - LabeledAddress.lblLastGetHead);
                            } else if (ddpProgramMode == 1) {
                                XEiJ.fmtHex8(stringBuilder, n19);
                            } else {
                                stringBuilder.append("       ");
                            }
                        }
                        stringBuilder.append("  ");
                        for (n20 = n19; n20 < n17; n20 += 2) {
                            XEiJ.fmtHex4(stringBuilder, MC68060.mmuPeekWordZeroCode(n20, n2));
                        }
                        stringBuilder.append(XEiJ.DBG_SPACES, 0, 2 * Math.max(0, n19 + n8 - n17) + 2);
                        stringBuilder.append(string3).append(XEiJ.DBG_SPACES, 0, Math.max(1, n3 - string3.length()));
                        instructionBreakRecord = treeMap.get(n10);
                        if (instructionBreakRecord == null) break block67;
                        if (instructionBreakRecord.ibrWaitInstruction != null) {
                            stringBuilder.append("----");
                        }
                        if (instructionBreakRecord.ibrThreshold >= 0) break block68;
                        stringBuilder.append("******");
                        break block69;
                    }
                    if (instructionBreakRecord.ibrThreshold == Integer.MAX_VALUE) break block69;
                    stringBuilder.append(instructionBreakRecord.ibrValue).append('/').append(instructionBreakRecord.ibrThreshold);
                    break block69;
                }
                for (n16 = n19; n16 < n17; ++n16) {
                    n15 = MC68060.mmuPeekByteZeroCode(n16, n2);
                    if (129 <= n15 && n15 <= 159 || 224 <= n15 && n15 <= 239) {
                        n14 = MC68060.mmuPeekByteZeroCode(n16 + 1, n2);
                        if (64 <= n14 && n14 != 127 && n14 <= 252) {
                            n13 = CharacterCode.chrSJISToChar[n15 << 8 | n14];
                            if (n13 == 0) {
                                n13 = 8251;
                            }
                            ++n16;
                        } else {
                            n13 = 46;
                        }
                    } else {
                        n13 = CharacterCode.chrSJISToChar[n15];
                        if (n13 < 32 || n13 == 127) {
                            n13 = 46;
                        }
                    }
                    stringBuilder.append((char)n13);
                }
            }
            stringBuilder.append('\n');
            while (n17 < n18) {
                n19 = n17;
                n17 = Math.min(n19 + n8, n18);
                if (ddpProgramMode == 0 || ddpProgramMode == 2) {
                    XEiJ.fmtHex8(stringBuilder, n19);
                }
                if (ddpProgramMode == 1 || ddpProgramMode == 2) {
                    n16 = LabeledAddress.lblGetIndex(n19);
                    if (n16 != -1 && LabeledAddress.lblLastGetHead != 0) {
                        if (ddpProgramMode == 2) {
                            stringBuilder.append(':');
                        }
                        XEiJ.fmtHex6(stringBuilder.append('L'), n19 - LabeledAddress.lblLastGetHead);
                    } else if (ddpProgramMode == 1) {
                        XEiJ.fmtHex8(stringBuilder, n19);
                    } else {
                        stringBuilder.append("       ");
                    }
                }
                stringBuilder.append("  ");
                for (n16 = n19; n16 < n17; n16 += 2) {
                    XEiJ.fmtHex4(stringBuilder, MC68060.mmuPeekWordZeroCode(n16, n2));
                }
                stringBuilder.append(XEiJ.DBG_SPACES, 0, 2 * Math.max(0, n19 + n8 - n17) + 2 + n3);
                for (n16 = n19; n16 < n17; ++n16) {
                    n15 = MC68060.mmuPeekByteZeroCode(n16, n2);
                    if (129 <= n15 && n15 <= 159 || 224 <= n15 && n15 <= 239) {
                        n14 = MC68060.mmuPeekByteZeroCode(n16 + 1, n2);
                        if (64 <= n14 && n14 != 127 && n14 <= 252) {
                            n13 = CharacterCode.chrSJISToChar[n15 << 8 | n14];
                            if (n13 == 0) {
                                n13 = 8251;
                            }
                            ++n16;
                        } else {
                            n13 = 46;
                        }
                    } else {
                        n13 = CharacterCode.chrSJISToChar[n15];
                        if (n13 < 32 || n13 == 127) {
                            n13 = 46;
                        }
                    }
                    stringBuilder.append((char)n13);
                }
                stringBuilder.append('\n');
            }
            ++n9;
            n10 = n18;
            boolean bl3 = bl2 = (Disassembler.disStatus & 1) != 0;
        } while (n10 < n7);
        DisassembleList.ddpAddressArray[n9] = n10;
        DisassembleList.ddpSplitArray[n9] = stringBuilder.length();
        DisassembleList.ddpCaretArray[n9] = stringBuilder.length();
        stringBuilder.append(string2);
        ddpItemCount = ++n9;
        ddpTextArea.setText(stringBuilder.toString());
        ddpTextArea.setCaretPosition(ddpCaretArray[ddpItemIndex]);
        ddpSpinner.setHintArray(ddpAddressArray, n9);
        ddpSpinner.setHintIndex(ddpItemIndex);
        --XEiJ.dbgEventMask;
    }

    static {
        ddpAddressArray = new int[514];
        ddpSplitArray = new int[514];
        ddpCaretArray = new int[514];
        ddpDCWArray = new boolean[514];
    }
}

