/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import xeij.GIFAnimation;
import xeij.GraphicScreen;
import xeij.MC68901;
import xeij.MainMemory;
import xeij.MemoryMappedDevice;
import xeij.Multilingual;
import xeij.RasterBreakPoint;
import xeij.Settings;
import xeij.SpriteScreen;
import xeij.TickerQueue;
import xeij.VideoController;
import xeij.XEiJ;

public class CRTC {
    public static final boolean CRT_EXTENDED_GRAPHIC = true;
    public static boolean crtExtendedGraphicRequest;
    public static boolean crtExtendedGraphicOn;
    public static final long CRT_RESTART_DELAY = 200000000000L;
    public static final int CRT_R00_H_FRONT_END = 0xE80000;
    public static final int CRT_R01_H_SYNC_END = 15204354;
    public static final int CRT_R02_H_BACK_END = 15204356;
    public static final int CRT_R03_H_DISP_END = 15204358;
    public static final int CRT_R04_V_FRONT_END = 0xE80008;
    public static final int CRT_R05_V_SYNC_END = 15204362;
    public static final int CRT_R06_V_BACK_END = 15204364;
    public static final int CRT_R07_V_DISP_END = 0xE8000E;
    public static final int CRT_R08_ADJUST = 15204368;
    public static final int CRT_R09_IRQ_RASTER = 15204370;
    public static final int CRT_R10_TX_X = 15204372;
    public static final int CRT_R11_TX_Y = 15204374;
    public static final int CRT_R12_GR_X_0 = 15204376;
    public static final int CRT_R13_GR_Y_0 = 15204378;
    public static final int CRT_R14_GR_X_1 = 15204380;
    public static final int CRT_R15_GR_Y_1 = 15204382;
    public static final int CRT_R16_GR_X_2 = 15204384;
    public static final int CRT_R17_GR_Y_2 = 15204386;
    public static final int CRT_R18_GR_X_3 = 15204388;
    public static final int CRT_R19_GR_Y_3 = 15204390;
    public static final int CRT_R20_MODE = 15204392;
    public static final int CRT_R21_SELECT = 15204394;
    public static final int CRT_R22_BLOCK = 15204396;
    public static final int CRT_R23_MASK = 15204398;
    public static final int CRT_R24 = 15204400;
    public static final int CRT_ACTION = 15205504;
    public static final int[] CRT_OSCS;
    public static final int[] CRT_DIVS;
    public static final int CRT_MIN_FREQ = 10000000;
    public static final int CRT_MAX_FREQ = 400000000;
    public static final int[] CRT_DEFAULT_FREQS;
    public static final int[] crtFreqsRequest;
    public static final int[] crtFreqs;
    public static int crtR00HFrontEndPort;
    public static int crtR00HFrontEndMask;
    public static int crtR00HFrontEndTest;
    public static int crtR00HFrontEndCurr;
    public static int crtR01HSyncEndPort;
    public static int crtR01HSyncEndMask;
    public static int crtR01HSyncEndTest;
    public static int crtR01HSyncEndCurr;
    public static int crtR02HBackEndPort;
    public static int crtR02HBackEndMask;
    public static int crtR02HBackEndTest;
    public static int crtR02HBackEndCurr;
    public static int crtR03HDispEndPort;
    public static int crtR03HDispEndMask;
    public static int crtR03HDispEndTest;
    public static int crtR03HDispEndCurr;
    public static int crtR04VFrontEndPort;
    public static int crtR04VFrontEndMask;
    public static int crtR04VFrontEndTest;
    public static int crtR04VFrontEndCurr;
    public static int crtR05VSyncEndPort;
    public static int crtR05VSyncEndMask;
    public static int crtR05VSyncEndTest;
    public static int crtR05VSyncEndCurr;
    public static int crtR06VBackEndPort;
    public static int crtR06VBackEndMask;
    public static int crtR06VBackEndTest;
    public static int crtR06VBackEndCurr;
    public static int crtVDispStart;
    public static int crtR07VDispEndPort;
    public static int crtR07VDispEndMask;
    public static int crtR07VDispEndTest;
    public static int crtR07VDispEndCurr;
    public static int crtVIdleStart;
    public static int crtR08Adjust;
    public static int crtR09IRQRasterPort;
    public static int crtR09IRQRasterMask;
    public static int crtR09IRQRasterTest;
    public static int crtR09IRQRasterCurr;
    public static int crtR10TxXPort;
    public static int crtR10TxXMask;
    public static int crtR10TxXTest;
    public static int crtR10TxXCurr;
    public static int crtR11TxYPort;
    public static int crtR11TxYMask;
    public static int crtR11TxYTest;
    public static int crtR11TxYCurr;
    public static int crtR11TxYZero;
    public static int crtR11TxYZeroLast;
    public static final int[] crtR12GrXPort;
    public static final int[] crtR12GrXMask;
    public static final int[] crtR12GrXTest;
    public static final int[] crtR12GrXCurr;
    public static final int[] crtR13GrYPort;
    public static final int[] crtR13GrYMask;
    public static final int[] crtR13GrYTest;
    public static final int[] crtR13GrYCurr;
    public static final int[] crtR13GrYZero;
    public static final int[] crtR13GrYZeroLast;
    public static int crtTextStorage;
    public static int crtGraphicStorage;
    public static int crtMemoryModePort;
    public static int crtMemoryModeMask;
    public static int crtMemoryModeTest;
    public static int crtMemoryModeCurr;
    public static int crtHighResoPort;
    public static int crtHighResoMask;
    public static int crtHighResoTest;
    public static int crtHighResoCurr;
    public static int crtVResoPort;
    public static int crtVResoMask;
    public static int crtVResoTest;
    public static int crtVResoCurr;
    public static int crtHResoPort;
    public static int crtHResoMask;
    public static int crtHResoTest;
    public static int crtHResoCurr;
    public static boolean crtCCPlane0;
    public static boolean crtCCPlane1;
    public static boolean crtCCPlane2;
    public static boolean crtCCPlane3;
    public static boolean crtSimPlane0;
    public static boolean crtSimPlane1;
    public static boolean crtSimPlane2;
    public static boolean crtSimPlane3;
    public static boolean crtSimAccess;
    public static boolean crtBitMask;
    public static int crtR22SrcBlock;
    public static int crtR22DstBlock;
    public static int crtR23Mask;
    public static boolean crtRasterCopyOn;
    public static boolean crtClearStandby;
    public static int crtClearFrames;
    public static int crtHRLPort;
    public static int crtHRLMask;
    public static int crtHRLTest;
    public static int crtHRLCurr;
    public static boolean crtDuplication;
    public static boolean crtInterlace;
    public static boolean crtSlit;
    public static boolean crtDupExceptSp;
    public static int crtHSyncColumn;
    public static int crtHBackColumn;
    public static int crtHDispColumn;
    public static int crtHFrontColumn;
    public static int crtHTotalColumn;
    public static double crtVsyncMultiplier;
    public static int crtColumnTime;
    public static int crtHSyncLength;
    public static int crtHBackLength;
    public static int crtHDispLength;
    public static int crtHFrontLength;
    public static int crtHBackDispLength;
    public static long crtTotalLength;
    public static long crtTotalLengthMNP;
    public static int crtDirtyY0;
    public static int crtDirtyY1;
    public static final int[] crtRasterStamp;
    public static int crtAllStamp;
    public static int crtBeginningAllStamp;
    public static int crtRasterNumber;
    public static int crtDataY;
    public static int crtScreenY;
    public static int crtFrameParity;
    public static final boolean CRT_RASTER_HASH_ON = true;
    public static final long CRT_RASTER_HASH_ZERO = 0L;
    public static final long CRT_RASTER_HASH_MSB = Long.MIN_VALUE;
    public static long crtRasterHashIdle;
    public static long crtRasterHashDisp;
    public static TickerQueue.Ticker crtTicker;
    public static long crtClock;
    public static long crtContrastClock;
    public static long crtCaptureClock;
    public static long crtFrameTaskClock;
    public static final boolean CRT_ENABLE_INTERMITTENT = false;
    public static int crtIntermittentInterval;
    public static int crtIntermittentCounter;
    public static ScanlineEffect crtScanlineEffect;
    public static boolean crtEleventhBitRequest;
    public static boolean crtEleventhBit;
    public static int crtVerticalMask;
    public static boolean crtSphericalScrolling;
    public static int crtMask3;
    public static int crtMaskMinus4;
    public static int crtMask511;
    public static boolean crtR00Bit0Zero;
    public static final TickerQueue.Ticker InitialStage;
    public static final TickerQueue.Ticker NormalStart;
    public static final TickerQueue.Ticker NormalDrawIdleFront;
    public static final TickerQueue.Ticker NormalDrawIdleSync;
    public static final TickerQueue.Ticker NormalDrawIdleBackDisp;
    public static final TickerQueue.Ticker NormalDrawDispFront;
    public static final TickerQueue.Ticker NormalDrawDispSync;
    public static final TickerQueue.Ticker NormalDrawDispBack;
    public static final TickerQueue.Ticker NormalDrawDispDisp;
    public static final TickerQueue.Ticker NormalOmitIdleFront;
    public static final TickerQueue.Ticker NormalOmitIdleSync;
    public static final TickerQueue.Ticker NormalOmitIdleBackDisp;
    public static final TickerQueue.Ticker NormalOmitDispFront;
    public static final TickerQueue.Ticker NormalOmitDispSync;
    public static final TickerQueue.Ticker NormalOmitDispBackDisp;
    public static final TickerQueue.Ticker DuplicationStart;
    public static final TickerQueue.Ticker DuplicationDrawIdleFront;
    public static final TickerQueue.Ticker DuplicationDrawIdleSync;
    public static final TickerQueue.Ticker DuplicationDrawIdleBackDisp;
    public static final TickerQueue.Ticker DuplicationDrawDispEvenFront;
    public static final TickerQueue.Ticker DuplicationDrawDispOddFront;
    public static final TickerQueue.Ticker DuplicationDrawDispEvenSync;
    public static final TickerQueue.Ticker DuplicationDrawDispOddSync;
    public static final TickerQueue.Ticker DuplicationDrawDispEvenBack;
    public static final TickerQueue.Ticker DuplicationDrawDispOddBack;
    public static final TickerQueue.Ticker DuplicationDrawDispEvenDisp;
    public static final TickerQueue.Ticker DuplicationDrawDispOddDisp;
    public static final TickerQueue.Ticker DuplicationOmitIdleFront;
    public static final TickerQueue.Ticker DuplicationOmitIdleSync;
    public static final TickerQueue.Ticker DuplicationOmitIdleBackDisp;
    public static final TickerQueue.Ticker DuplicationOmitDispEvenFront;
    public static final TickerQueue.Ticker DuplicationOmitDispOddFront;
    public static final TickerQueue.Ticker DuplicationOmitDispEvenSync;
    public static final TickerQueue.Ticker DuplicationOmitDispOddSync;
    public static final TickerQueue.Ticker DuplicationOmitDispEvenBackDisp;
    public static final TickerQueue.Ticker DuplicationOmitDispOddBackDisp;
    public static final TickerQueue.Ticker InterlaceStart;
    public static final TickerQueue.Ticker InterlaceDrawIdleFront;
    public static final TickerQueue.Ticker InterlaceDrawIdleSync;
    public static final TickerQueue.Ticker InterlaceDrawIdleBackDisp;
    public static final TickerQueue.Ticker InterlaceDrawDispFront;
    public static final TickerQueue.Ticker InterlaceDrawDispSync;
    public static final TickerQueue.Ticker InterlaceDrawDispBack;
    public static final TickerQueue.Ticker InterlaceDrawDispDisp;
    public static final TickerQueue.Ticker InterlaceOmitIdleFront;
    public static final TickerQueue.Ticker InterlaceOmitIdleSync;
    public static final TickerQueue.Ticker InterlaceOmitIdleBackDisp;
    public static final TickerQueue.Ticker InterlaceOmitDispFront;
    public static final TickerQueue.Ticker InterlaceOmitDispSync;
    public static final TickerQueue.Ticker InterlaceOmitDispBackDisp;
    public static final TickerQueue.Ticker SlitStart;
    public static final TickerQueue.Ticker SlitDrawIdleFront;
    public static final TickerQueue.Ticker SlitDrawIdleSync;
    public static final TickerQueue.Ticker SlitDrawIdleBackDisp;
    public static final TickerQueue.Ticker SlitDrawDispFront;
    public static final TickerQueue.Ticker SlitDrawDispSync;
    public static final TickerQueue.Ticker SlitDrawDispBack;
    public static final TickerQueue.Ticker SlitDrawDispDisp;
    public static final TickerQueue.Ticker SlitOmitIdleFront;
    public static final TickerQueue.Ticker SlitOmitIdleSync;
    public static final TickerQueue.Ticker SlitOmitIdleBackDisp;
    public static final TickerQueue.Ticker SlitOmitDispFront;
    public static final TickerQueue.Ticker SlitOmitDispSync;
    public static final TickerQueue.Ticker SlitOmitDispBackDisp;
    public static final TickerQueue.Ticker DupExceptSpStart;
    public static final TickerQueue.Ticker DupExceptSpDrawIdleFront;
    public static final TickerQueue.Ticker DupExceptSpDrawIdleSync;
    public static final TickerQueue.Ticker DupExceptSpDrawIdleBackDisp;
    public static final TickerQueue.Ticker DupExceptSpDrawDispEvenFront;
    public static final TickerQueue.Ticker DupExceptSpDrawDispOddFront;
    public static final TickerQueue.Ticker DupExceptSpDrawDispEvenSync;
    public static final TickerQueue.Ticker DupExceptSpDrawDispOddSync;
    public static final TickerQueue.Ticker DupExceptSpDrawDispEvenBack;
    public static final TickerQueue.Ticker DupExceptSpDrawDispOddBack;
    public static final TickerQueue.Ticker DupExceptSpDrawDispEvenDisp;
    public static final TickerQueue.Ticker DupExceptSpDrawDispOddDisp;
    public static final TickerQueue.Ticker DupExceptSpOmitIdleFront;
    public static final TickerQueue.Ticker DupExceptSpOmitIdleSync;
    public static final TickerQueue.Ticker DupExceptSpOmitIdleBackDisp;
    public static final TickerQueue.Ticker DupExceptSpOmitDispEvenFront;
    public static final TickerQueue.Ticker DupExceptSpOmitDispOddFront;
    public static final TickerQueue.Ticker DupExceptSpOmitDispEvenSync;
    public static final TickerQueue.Ticker DupExceptSpOmitDispOddSync;
    public static final TickerQueue.Ticker DupExceptSpOmitDispEvenBackDisp;
    public static final TickerQueue.Ticker DupExceptSpOmitDispOddBackDisp;

    public static void crtSetSphericalScrolling(boolean bl) {
        crtSphericalScrolling = bl;
        crtMask3 = bl ? 0 : 3;
        crtMaskMinus4 = ~crtMask3;
        crtMask511 = crtMask3 << 7 | 0x7F;
        crtAllStamp += 2;
    }

    public static void crtInit() {
        String[] stringArray = Settings.sgsGetString("scanline").toLowerCase();
        int n = -1;
        switch (stringArray.hashCode()) {
            case 109935: {
                if (!stringArray.equals("off")) break;
                n = 0;
                break;
            }
            case 3645304: {
                if (!stringArray.equals("weak")) break;
                n = 1;
                break;
            }
            case -1078030475: {
                if (!stringArray.equals("medium")) break;
                n = 2;
                break;
            }
            case -891980137: {
                if (!stringArray.equals("strong")) break;
                n = 3;
                break;
            }
            case 93818879: {
                if (!stringArray.equals("black")) break;
                n = 4;
            }
        }
        switch (n) {
            case 0: {
                crtScanlineEffect = ScanlineEffect.OFF;
                break;
            }
            case 1: {
                crtScanlineEffect = ScanlineEffect.WEAK;
                break;
            }
            case 2: {
                crtScanlineEffect = ScanlineEffect.MEDIUM;
                break;
            }
            case 3: {
                crtScanlineEffect = ScanlineEffect.STRONG;
                break;
            }
            case 4: {
                crtScanlineEffect = ScanlineEffect.BLACK;
            }
        }
        stringArray = (Settings.sgsGetString("dotclock") + ",,,0").split(",");
        for (n = 0; n < 3; ++n) {
            int n2 = -1;
            try {
                n2 = Integer.parseInt(stringArray[n], 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            CRTC.crtFreqsRequest[n] = 10000000 <= n2 && n2 <= 400000000 ? n2 : CRT_DEFAULT_FREQS[n];
        }
        crtEleventhBitRequest = Settings.sgsGetOnOff("eleventhbit");
        crtSphericalScrolling = Settings.sgsGetOnOff("sphericalscrolling");
        crtMask3 = 3;
        crtMaskMinus4 = -4;
        crtMask511 = 511;
        crtR00Bit0Zero = Settings.sgsGetOnOff("r00bit0zero");
        crtCCPlane0 = false;
        crtCCPlane1 = false;
        crtCCPlane2 = false;
        crtCCPlane3 = false;
        crtSimPlane0 = false;
        crtSimPlane1 = false;
        crtSimPlane2 = false;
        crtSimPlane3 = false;
        crtSimAccess = false;
        crtBitMask = false;
        CRTC.crtReset();
    }

    public static void crtTini() {
        Settings.sgsPutString("scanline", crtScanlineEffect == ScanlineEffect.OFF ? "off" : (crtScanlineEffect == ScanlineEffect.WEAK ? "weak" : (crtScanlineEffect == ScanlineEffect.MEDIUM ? "medium" : (crtScanlineEffect == ScanlineEffect.STRONG ? "strong" : (crtScanlineEffect == ScanlineEffect.BLACK ? "black" : "")))));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (0 < i) {
                stringBuilder.append(',');
            }
            if (crtFreqsRequest[i] == CRT_DEFAULT_FREQS[i]) continue;
            stringBuilder.append(crtFreqsRequest[i]);
        }
        Settings.sgsPutString("dotclock", stringBuilder.toString());
        Settings.sgsPutOnOff("eleventhbit", crtEleventhBitRequest);
        Settings.sgsPutOnOff("sphericalscrolling", crtSphericalScrolling);
        Settings.sgsPutOnOff("r00bit0zero", crtR00Bit0Zero);
    }

    public static void crtReset() {
        int n;
        crtExtendedGraphicOn = crtExtendedGraphicRequest;
        if (crtExtendedGraphicOn) {
            System.out.println(Multilingual.mlnJapanese ? "\u62e1\u5f35\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u753b\u9762\u304c\u6709\u52b9\u306b\u306a\u308a\u307e\u3057\u305f" : "Extended graphic screen has been activated");
        }
        for (n = 0; n < 3; ++n) {
            CRTC.crtFreqs[n] = crtFreqsRequest[n];
        }
        crtEleventhBit = crtEleventhBitRequest;
        crtVerticalMask = crtEleventhBit ? 2047 : 1023;
        crtR00HFrontEndPort = 0;
        crtR00HFrontEndMask = 0;
        crtR00HFrontEndTest = 0;
        crtR00HFrontEndCurr = 0;
        crtR01HSyncEndPort = 0;
        crtR01HSyncEndMask = 0;
        crtR01HSyncEndTest = 0;
        crtR01HSyncEndCurr = 0;
        crtR02HBackEndPort = 0;
        crtR02HBackEndMask = 0;
        crtR02HBackEndTest = 0;
        crtR02HBackEndCurr = 0;
        crtR03HDispEndPort = 0;
        crtR03HDispEndMask = 0;
        crtR03HDispEndTest = 0;
        crtR03HDispEndCurr = 0;
        crtR04VFrontEndPort = 0;
        crtR04VFrontEndMask = 0;
        crtR04VFrontEndTest = 0;
        crtR04VFrontEndCurr = 0;
        crtR05VSyncEndPort = 0;
        crtR05VSyncEndMask = 0;
        crtR05VSyncEndTest = 0;
        crtR05VSyncEndCurr = 0;
        crtR06VBackEndPort = 0;
        crtR06VBackEndMask = 0;
        crtR06VBackEndTest = 0;
        crtR06VBackEndCurr = 0;
        crtVDispStart = 0;
        crtR07VDispEndPort = 0;
        crtR07VDispEndMask = 0;
        crtR07VDispEndTest = 0;
        crtR07VDispEndCurr = 0;
        crtVIdleStart = 0;
        crtR08Adjust = 0;
        crtR09IRQRasterPort = 1023;
        crtR09IRQRasterMask = 0;
        crtR09IRQRasterTest = 1023;
        crtR09IRQRasterCurr = 1023;
        crtR10TxXPort = 0;
        crtR10TxXMask = 0;
        crtR10TxXTest = 0;
        crtR10TxXCurr = 0;
        crtR11TxYPort = 0;
        crtR11TxYMask = 0;
        crtR11TxYTest = 0;
        crtR11TxYCurr = 0;
        crtR11TxYZero = 0;
        crtR11TxYZeroLast = -1;
        for (n = 0; n < 4; ++n) {
            CRTC.crtR12GrXPort[n] = 0;
            CRTC.crtR12GrXMask[n] = 0;
            CRTC.crtR12GrXTest[n] = 0;
            CRTC.crtR12GrXCurr[n] = 0;
            CRTC.crtR13GrYPort[n] = 0;
            CRTC.crtR13GrYMask[n] = 0;
            CRTC.crtR13GrYTest[n] = 0;
            CRTC.crtR13GrYCurr[n] = 0;
            CRTC.crtR13GrYZero[n] = 0;
            CRTC.crtR13GrYZeroLast[n] = -1;
        }
        crtTextStorage = 0;
        crtGraphicStorage = 0;
        crtMemoryModePort = 0;
        crtMemoryModeMask = 0;
        crtMemoryModeTest = 0;
        crtMemoryModeCurr = 0;
        crtHighResoPort = 0;
        crtHighResoMask = 0;
        crtHighResoTest = 0;
        crtHighResoCurr = 0;
        crtVResoPort = 0;
        crtVResoMask = 0;
        crtVResoTest = 0;
        crtVResoCurr = 0;
        crtHResoPort = 0;
        crtHResoMask = 0;
        crtHResoTest = 0;
        crtHResoCurr = 0;
        crtR22SrcBlock = 0;
        crtR22DstBlock = 0;
        crtR23Mask = 0;
        crtRasterCopyOn = false;
        crtClearStandby = false;
        crtClearFrames = 0;
        crtHRLPort = 0;
        crtHRLMask = 0;
        crtHRLTest = 0;
        crtHRLCurr = 0;
        XEiJ.pnlStretchMode = 1.0f;
        XEiJ.pnlStereoscopicShutter = 0;
        crtDuplication = false;
        crtInterlace = false;
        crtSlit = false;
        crtDupExceptSp = false;
        crtHSyncColumn = 2;
        crtHBackColumn = 2;
        crtHDispColumn = 2;
        crtHFrontColumn = 2;
        crtHTotalColumn = 8;
        crtVsyncMultiplier = 1.0;
        crtColumnTime = 0;
        crtHSyncLength = 0;
        crtHBackLength = 0;
        crtHDispLength = 0;
        crtHFrontLength = 0;
        crtHBackDispLength = 0;
        crtTotalLength = 0L;
        crtTotalLengthMNP = 0L;
        Arrays.fill(crtRasterStamp, 0);
        crtAllStamp = 1;
        crtBeginningAllStamp = 1;
        crtRasterNumber = 0;
        crtDataY = 0;
        crtScreenY = 0;
        crtFrameParity = 0;
        crtRasterHashIdle = 0L;
        crtRasterHashDisp = 0L;
        crtContrastClock = Long.MAX_VALUE;
        crtCaptureClock = Long.MAX_VALUE;
        crtFrameTaskClock = Math.min(crtContrastClock, crtCaptureClock);
        if (crtTicker != null) {
            TickerQueue.tkqRemove(crtTicker);
            crtTicker = null;
        }
        crtClock = Long.MAX_VALUE;
    }

    public static void crtRestart() {
        if (crtTicker != null) {
            TickerQueue.tkqRemove(crtTicker);
        }
        crtTicker = InitialStage;
        crtClock = XEiJ.mpuClockTime + 200000000000L;
        TickerQueue.tkqAdd(crtTicker, crtClock);
    }

    public static void crtStereoscopicStart() {
        XEiJ.pnlBM = XEiJ.pnlStereoscopicShutter != 1 ? XEiJ.pnlBMLeftArray[XEiJ.pnlBMWrite & 3] : XEiJ.pnlBMRightArray[XEiJ.pnlBMWrite & 3];
        crtAllStamp += 2;
    }

    public static void crtStereoscopicDrawRaster(int n) {
        if (XEiJ.pnlStereoscopicShutter == 0 || XEiJ.pnlStereoscopicShutter == 3) {
            System.arraycopy(XEiJ.pnlBMLeftArray[XEiJ.pnlBMWrite & 3], n << 10, XEiJ.pnlBMRightArray[XEiJ.pnlBMWrite & 3], n << 10, XEiJ.pnlScreenWidth);
        }
    }

    public static void crtUpdateScreen() {
    }

    public static void crtRepaint() {
        crtBeginningAllStamp = crtAllStamp;
        int n = Math.max(0, Math.min(1024, crtR07VDispEndCurr - crtR06VBackEndCurr));
        if (crtDuplication) {
            for (int i = 0; i < n; i += 2) {
                SpriteScreen.sprStep1(i >> 1);
                SpriteScreen.sprStep2(i >> 1);
                VideoController.vcnMode.drawRaster(i >> 1, i, false);
                if (XEiJ.pnlStereoscopicOn) {
                    CRTC.crtStereoscopicDrawRaster(i);
                }
                System.arraycopy(XEiJ.pnlBM, i << 10, XEiJ.pnlBM, i + 1 << 10, XEiJ.pnlScreenWidth);
            }
        } else if (crtSlit) {
            for (int i = 0; i < n; i += 2) {
                SpriteScreen.sprStep1(i >> 1);
                SpriteScreen.sprStep2(i >> 1);
                VideoController.vcnMode.drawRaster(i >> 1, i, false);
                crtScanlineEffect.drawRaster(i + 1);
                if (!XEiJ.pnlStereoscopicOn) continue;
                CRTC.crtStereoscopicDrawRaster(i);
                CRTC.crtStereoscopicDrawRaster(i + 1);
            }
        } else if (crtDupExceptSp) {
            for (int i = 0; i < n; ++i) {
                SpriteScreen.sprStep1(i);
                SpriteScreen.sprStep2(i);
                VideoController.vcnMode.drawRaster(i >> 1, i, false);
                if (!XEiJ.pnlStereoscopicOn) continue;
                CRTC.crtStereoscopicDrawRaster(i);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                SpriteScreen.sprStep1(i);
                SpriteScreen.sprStep2(i);
                VideoController.vcnMode.drawRaster(i, i, false);
                if (!XEiJ.pnlStereoscopicOn) continue;
                CRTC.crtStereoscopicDrawRaster(i);
            }
        }
        XEiJ.pnlPanel.repaint(0L, XEiJ.pnlScreenX1, XEiJ.pnlScreenY1, XEiJ.pnlScreenX4 - XEiJ.pnlScreenX1, n);
        if (XEiJ.pnlStereoscopicOn && XEiJ.pnlStereoscopicMethod == 3) {
            XEiJ.pnlPanel.repaint(0L, XEiJ.pnlScreenX1, XEiJ.pnlScreenY3, XEiJ.pnlScreenX4 - XEiJ.pnlScreenX1, n);
        }
    }

    public static void crtDoFrameTask() {
        if (XEiJ.mpuClockTime >= crtContrastClock) {
            VideoController.vcnSetContrast(VideoController.vcnCurrentScaledContrast += VideoController.vcnCurrentScaledContrast < VideoController.vcnTargetScaledContrast ? 1 : -1);
            crtContrastClock = VideoController.vcnCurrentScaledContrast == VideoController.vcnTargetScaledContrast ? Long.MAX_VALUE : (crtContrastClock += 16666666666L);
        }
        if (XEiJ.mpuClockTime >= crtCaptureClock) {
            GIFAnimation.gifCaptureFrame();
        }
        crtFrameTaskClock = Math.min(crtContrastClock, crtCaptureClock);
    }

    public static void crtSetMemoryMode(int n, int n2, int n3) {
        int n4;
        boolean bl = false;
        if (crtTextStorage != (n &= 1)) {
            crtTextStorage = n;
        }
        if (crtGraphicStorage != (n2 &= 1)) {
            crtGraphicStorage = n2;
            bl = true;
        }
        crtMemoryModePort = n3 &= 7;
        int n5 = n4 = crtMemoryModeMask == 0 ? crtMemoryModePort : crtMemoryModeTest;
        if (crtMemoryModeCurr != n4) {
            crtMemoryModeCurr = n4;
            bl = true;
        }
        if (bl) {
            if (crtGraphicStorage != 0) {
                if (crtExtendedGraphicOn && (crtMemoryModeCurr == 5 || crtMemoryModeCurr == 7)) {
                    XEiJ.busSuper(MemoryMappedDevice.MMD_GJ0, 0xC00000, 0xE00000);
                } else {
                    XEiJ.busSuper(MemoryMappedDevice.MMD_GG0, 0xC00000, 0xC80000);
                    XEiJ.busSuper(MemoryMappedDevice.MMD_NUL, 0xC80000, 0xE00000);
                }
            } else {
                switch (crtMemoryModeCurr) {
                    case 0: {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GE0, 0xC00000, 0xC80000);
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GE1, 0xC80000, 0xD00000);
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GE2, 0xD00000, 0xD80000);
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GE3, 0xD80000, 0xE00000);
                        break;
                    }
                    case 1: {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GF0, 0xC00000, 0xC80000);
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GF1, 0xC80000, 0xD00000);
                        XEiJ.busSuper(MemoryMappedDevice.MMD_NUL, 0xD00000, 0xE00000);
                        break;
                    }
                    case 2: {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GM2, 0xC00000, 0xE00000);
                        break;
                    }
                    case 3: {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GG0, 0xC00000, 0xC80000);
                        XEiJ.busSuper(MemoryMappedDevice.MMD_NUL, 0xC80000, 0xE00000);
                        break;
                    }
                    case 4: {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GH0, 0xC00000, 0xE00000);
                        break;
                    }
                    case 5: {
                        if (crtExtendedGraphicOn) {
                            XEiJ.busSuper(MemoryMappedDevice.MMD_GI0, 0xC00000, 0xE00000);
                            break;
                        }
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GH0, 0xC00000, 0xE00000);
                        break;
                    }
                    case 6: {
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GH0, 0xC00000, 0xE00000);
                        break;
                    }
                    case 7: {
                        if (crtExtendedGraphicOn) {
                            XEiJ.busSuper(MemoryMappedDevice.MMD_GJ0, 0xC00000, 0xE00000);
                            break;
                        }
                        XEiJ.busSuper(MemoryMappedDevice.MMD_GH0, 0xC00000, 0xE00000);
                    }
                }
            }
        }
    }

    public static void crtUpdateRasterHash() {
        long l;
        long l2 = l = crtRasterCopyOn ? -1L : 0L;
        if (RasterBreakPoint.rbpActiveBreakRaster >= 0) {
            l |= Long.MIN_VALUE >>> RasterBreakPoint.rbpActiveBreakRaster;
        }
        if (crtR09IRQRasterCurr <= crtR04VFrontEndCurr) {
            l |= Long.MIN_VALUE >>> crtR09IRQRasterCurr | Long.MIN_VALUE >>> (crtR09IRQRasterCurr < crtR04VFrontEndCurr ? crtR09IRQRasterCurr + 1 : 0);
        }
        crtRasterHashIdle = l | Long.MIN_VALUE >>> crtVDispStart | Long.MIN_VALUE >>> crtR04VFrontEndCurr + 1;
        crtRasterHashDisp = l | Long.MIN_VALUE >>> crtVIdleStart;
    }

    public static void crtRapidClear(int n) {
        block17: {
            int n2;
            int n3;
            block15: {
                int n4;
                block16: {
                    n += crtR13GrYZero[0];
                    n3 = crtR12GrXCurr[0] & 0xFFFFFFFE;
                    n2 = 8 * crtHDispColumn;
                    if (512 <= n2) {
                        n3 = 0;
                        n2 = 512;
                    }
                    if (crtMemoryModeCurr >= 4) break block15;
                    n4 = (n & 0x1FF) << 9;
                    if (n3 + n2 > 512) break block16;
                    if (crtCCPlane0) {
                        Arrays.fill(GraphicScreen.graM4, n4 + n3, n4 + n3 + n2, (byte)0);
                    }
                    if (crtCCPlane1) {
                        Arrays.fill(GraphicScreen.graM4, 262144 + n4 + n3, 262144 + n4 + n3 + n2, (byte)0);
                    }
                    if (crtCCPlane2) {
                        Arrays.fill(GraphicScreen.graM4, 524288 + n4 + n3, 524288 + n4 + n3 + n2, (byte)0);
                    }
                    if (!crtCCPlane3) break block17;
                    Arrays.fill(GraphicScreen.graM4, 786432 + n4 + n3, 786432 + n4 + n3 + n2, (byte)0);
                    break block17;
                }
                if (crtCCPlane0) {
                    Arrays.fill(GraphicScreen.graM4, n4 + n3, n4 + 512, (byte)0);
                    Arrays.fill(GraphicScreen.graM4, n4, n4 + n3 + n2 - 512, (byte)0);
                }
                if (crtCCPlane1) {
                    Arrays.fill(GraphicScreen.graM4, 262144 + n4 + n3, 262144 + n4 + 512, (byte)0);
                    Arrays.fill(GraphicScreen.graM4, 262144 + n4, 262144 + n4 + n3 + n2 - 512, (byte)0);
                }
                if (crtCCPlane2) {
                    Arrays.fill(GraphicScreen.graM4, 524288 + n4 + n3, 524288 + n4 + 512, (byte)0);
                    Arrays.fill(GraphicScreen.graM4, 524288 + n4, 524288 + n4 + n3 + n2 - 512, (byte)0);
                }
                if (!crtCCPlane3) break block17;
                Arrays.fill(GraphicScreen.graM4, 786432 + n4 + n3, 786432 + n4 + 512, (byte)0);
                Arrays.fill(GraphicScreen.graM4, 786432 + n4, 786432 + n4 + n3 + n2 - 512, (byte)0);
                break block17;
            }
            int n5 = (n & 0x200) << 10 | (n & 0x1FF) << 9;
            if (n3 + n2 <= 512) {
                for (int i = 0; i < 2; ++i) {
                    Arrays.fill(GraphicScreen.graM4, n5 + n3, n5 + n3 + n2, (byte)0);
                    if (crtMemoryModeCurr == 5 || crtMemoryModeCurr == 7) {
                        Arrays.fill(GraphicScreen.graM4, 0x100000 + n5 + n3, 0x100000 + n5 + n3 + n2, (byte)0);
                        if (crtMemoryModeCurr == 7) {
                            Arrays.fill(GraphicScreen.graM4, 0x200000 + n5 + n3, 0x200000 + n5 + n3 + n2, (byte)0);
                            Arrays.fill(GraphicScreen.graM4, 0x300000 + n5 + n3, 0x300000 + n5 + n3 + n2, (byte)0);
                        }
                    }
                    n5 += 262144;
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    Arrays.fill(GraphicScreen.graM4, n5 + n3, n5 + 512, (byte)0);
                    Arrays.fill(GraphicScreen.graM4, n5, n5 + n3 + n2 - 512, (byte)0);
                    if (crtMemoryModeCurr == 5 || crtMemoryModeCurr == 7) {
                        Arrays.fill(GraphicScreen.graM4, 0x100000 + n5 + n3, 0x100000 + n5 + 512, (byte)0);
                        Arrays.fill(GraphicScreen.graM4, 0x100000 + n5, 0x100000 + n5 + n3 + n2 - 512, (byte)0);
                        if (crtMemoryModeCurr == 7) {
                            Arrays.fill(GraphicScreen.graM4, 0x200000 + n5 + n3, 0x200000 + n5 + 512, (byte)0);
                            Arrays.fill(GraphicScreen.graM4, 0x200000 + n5, 0x200000 + n5 + n3 + n2 - 512, (byte)0);
                            Arrays.fill(GraphicScreen.graM4, 0x300000 + n5 + n3, 0x300000 + n5 + 512, (byte)0);
                            Arrays.fill(GraphicScreen.graM4, 0x300000 + n5, 0x300000 + n5 + n3 + n2 - 512, (byte)0);
                        }
                    }
                    n5 += 262144;
                }
            }
        }
    }

    public static void crtDoRasterCopy() {
        int n = crtR22SrcBlock << 9;
        int n2 = crtR22DstBlock << 9;
        if (crtCCPlane0) {
            System.arraycopy(MainMemory.mmrM8, 0xE00000 + n, MainMemory.mmrM8, 0xE00000 + n2, 512);
        }
        if (crtCCPlane1) {
            System.arraycopy(MainMemory.mmrM8, 0xE20000 + n, MainMemory.mmrM8, 0xE20000 + n2, 512);
        }
        if (crtCCPlane2) {
            System.arraycopy(MainMemory.mmrM8, 0xE40000 + n, MainMemory.mmrM8, 0xE40000 + n2, 512);
        }
        if (crtCCPlane3) {
            System.arraycopy(MainMemory.mmrM8, 0xE60000 + n, MainMemory.mmrM8, 0xE60000 + n2, 512);
        }
        int n3 = (n2 >> 7) - crtR11TxYZero;
        CRTC.crtRasterStamp[n3 & 0x3FF] = 0;
        CRTC.crtRasterStamp[n3 + 1 & 0x3FF] = 0;
        CRTC.crtRasterStamp[n3 + 2 & 0x3FF] = 0;
        CRTC.crtRasterStamp[n3 + 3 & 0x3FF] = 0;
    }

    public static void crtUpdateLength() {
        double d;
        double d2;
        double d3;
        int n = crtHRLCurr << 3 | crtHighResoCurr << 2 | crtHResoCurr;
        double d4 = crtFreqs[CRT_OSCS[n]];
        int n2 = CRT_DIVS[n];
        int n3 = crtR04VFrontEndCurr + 1;
        double d5 = 1.0;
        if (XEiJ.pnlAdjustVsync && XEiJ.pnlFixedRate != 0.0 && (d3 = (d2 = d4 / (double)(8 * n2 * crtHTotalColumn)) / (double)n3) * 0.75 <= (d = XEiJ.pnlFixedRate) && d <= d3 * 1.25) {
            d5 = d / d3;
        }
        crtVsyncMultiplier = d5;
        crtColumnTime = (int)((double)(8000000000000L * (long)n2) / (d4 * d5) + 0.5);
        crtHSyncLength = crtColumnTime * crtHSyncColumn;
        crtHBackLength = crtColumnTime * crtHBackColumn;
        crtHDispLength = crtColumnTime * crtHDispColumn;
        crtHFrontLength = crtColumnTime * crtHFrontColumn;
        crtHBackDispLength = crtColumnTime * (crtHBackColumn + crtHDispColumn);
        long l = (long)crtColumnTime * (long)(crtHTotalColumn * n3);
        crtTotalLength = l / 1000000000L;
        crtTotalLengthMNP = l - 1000000000L * crtTotalLength;
    }

    static {
        CRT_OSCS = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 0, 0, 0, 0, 1, 1, 1, 2};
        CRT_DIVS = new int[]{8, 4, 8, 8, 6, 3, 2, 2, 8, 4, 8, 8, 8, 4, 2, 2};
        CRT_DEFAULT_FREQS = new int[]{38863632, 69551900, 50349800};
        crtFreqsRequest = new int[3];
        crtFreqs = new int[3];
        crtR12GrXPort = new int[4];
        crtR12GrXMask = new int[4];
        crtR12GrXTest = new int[4];
        crtR12GrXCurr = new int[4];
        crtR13GrYPort = new int[4];
        crtR13GrYMask = new int[4];
        crtR13GrYTest = new int[4];
        crtR13GrYCurr = new int[4];
        crtR13GrYZero = new int[4];
        crtR13GrYZeroLast = new int[4];
        crtRasterStamp = new int[1039];
        InitialStage = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtR02HBackEndCurr >= crtR03HDispEndCurr || crtR03HDispEndCurr - crtR02HBackEndCurr > 128 || crtR07VDispEndCurr >= crtR04VFrontEndCurr || crtR07VDispEndCurr - crtR06VBackEndCurr > 1024 || crtR05VSyncEndCurr >= crtR06VBackEndCurr || crtR06VBackEndCurr >= crtR07VDispEndCurr) {
                    CRTC.crtRestart();
                } else {
                    CRTC.crtUpdateRasterHash();
                    int n = crtR01HSyncEndCurr + 1;
                    int n2 = crtR02HBackEndCurr - crtR01HSyncEndCurr + 4;
                    int n3 = crtR03HDispEndCurr - crtR02HBackEndCurr;
                    int n4 = crtR00HFrontEndCurr - crtR03HDispEndCurr - 4;
                    if (n + n2 + n3 + n4 < n3 + 3) {
                        n4 = 1;
                        n2 = 1;
                        n = 1;
                    } else if (n2 <= 0) {
                        n4 -= 1 - n2;
                        n2 = 1;
                        if (n4 <= 0) {
                            n -= 1 - n4;
                            n4 = 1;
                        }
                    } else if (n4 <= 0) {
                        n2 -= 1 - n4;
                        n4 = 1;
                        if (n2 <= 0) {
                            n -= 1 - n2;
                            n2 = 1;
                        }
                    }
                    crtHSyncColumn = n;
                    crtHBackColumn = n2;
                    crtHDispColumn = n3;
                    crtHFrontColumn = n4;
                    crtHTotalColumn = n + n2 + n3 + n4;
                    CRTC.crtUpdateLength();
                    crtDuplication = crtHighResoCurr == 1 && crtVResoCurr == 0 && (SpriteScreen.sprReg8ResoCurr & 0xC) != 4;
                    crtInterlace = crtHighResoCurr + 1 <= crtVResoCurr;
                    crtSlit = crtHighResoCurr == 0 && crtVResoCurr == 0;
                    crtDupExceptSp = crtHighResoCurr == 1 && crtVResoCurr == 0 && (SpriteScreen.sprReg8ResoCurr & 0xC) == 4;
                    XEiJ.pnlUpdateArrangement();
                    crtAllStamp += 2;
                    (crtDuplication ? DuplicationStart : (crtInterlace ? InterlaceStart : (crtSlit ? SlitStart : (crtDupExceptSp ? DupExceptSpStart : NormalStart)))).tick();
                }
            }
        };
        NormalStart = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (MC68901.mfpGpipHsync != 0) {
                    MC68901.mfpHsyncFall();
                }
                int n2 = crtRasterNumber = crtVIdleStart;
                if (crtRasterCopyOn) {
                    CRTC.crtDoRasterCopy();
                }
                if (n2 == RasterBreakPoint.rbpActiveBreakRaster) {
                    RasterBreakPoint.rbpFire();
                }
                int n3 = n = n2 == crtR09IRQRasterCurr ? 0 : 64;
                if (n != MC68901.mfpGpipRint) {
                    if (n == 0) {
                        if (RasterBreakPoint.rbpIRQBreakEnabled) {
                            RasterBreakPoint.rbpFire();
                        }
                        MC68901.mfpRintFall();
                    } else {
                        MC68901.mfpRintRise();
                    }
                }
                if (MC68901.mfpGpipVdisp != 0) {
                    MC68901.mfpVdispFall();
                }
                crtClearFrames = 0;
                crtTicker = NormalDrawIdleSync;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
            }
        };
        NormalDrawIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = NormalDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtScreenY = 0;
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(1);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = NormalDrawDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = NormalDrawIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        NormalDrawIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = NormalDrawIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        NormalDrawIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = NormalDrawIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        NormalDrawDispFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        ++crtScreenY;
                        ++crtDataY;
                        crtTicker = NormalDrawDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = NormalDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        }
                    }
                    ++crtScreenY;
                    ++crtDataY;
                    crtTicker = NormalDrawDispSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        NormalDrawDispSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = NormalDrawDispBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        NormalDrawDispBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = NormalDrawDispDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        NormalDrawDispDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    CRTC.crtRasterStamp[CRTC.crtDataY] = crtAllStamp;
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtDataY + 2);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtDataY + 1);
                }
                crtTicker = NormalDrawDispFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        NormalOmitIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = NormalOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(1);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = NormalOmitDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = NormalOmitIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        NormalOmitIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = NormalOmitIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        NormalOmitIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = NormalOmitIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        NormalOmitDispFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = NormalOmitDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = NormalOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = NormalOmitDispSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        NormalOmitDispSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = NormalOmitDispBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        NormalOmitDispBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = NormalOmitDispFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DuplicationStart = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (MC68901.mfpGpipHsync != 0) {
                    MC68901.mfpHsyncFall();
                }
                int n2 = crtRasterNumber = crtVIdleStart;
                if (crtRasterCopyOn) {
                    CRTC.crtDoRasterCopy();
                }
                if (n2 == RasterBreakPoint.rbpActiveBreakRaster) {
                    RasterBreakPoint.rbpFire();
                }
                int n3 = n = n2 == crtR09IRQRasterCurr ? 0 : 64;
                if (n != MC68901.mfpGpipRint) {
                    if (n == 0) {
                        if (RasterBreakPoint.rbpIRQBreakEnabled) {
                            RasterBreakPoint.rbpFire();
                        }
                        MC68901.mfpRintFall();
                    } else {
                        MC68901.mfpRintRise();
                    }
                }
                if (MC68901.mfpGpipVdisp != 0) {
                    MC68901.mfpVdispFall();
                }
                crtClearFrames = 0;
                crtTicker = DuplicationDrawIdleSync;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
            }
        };
        DuplicationDrawIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = DuplicationDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtScreenY = 0;
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = DuplicationDrawDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DuplicationDrawIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DuplicationDrawIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DuplicationDrawIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DuplicationDrawIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DuplicationDrawIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DuplicationDrawDispEvenFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        ++crtScreenY;
                        ++crtDataY;
                        crtTicker = DuplicationDrawDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DuplicationDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        }
                    }
                    ++crtScreenY;
                    ++crtDataY;
                    crtTicker = DuplicationDrawDispEvenSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DuplicationDrawDispOddFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        ++crtScreenY;
                        crtTicker = DuplicationDrawDispOddSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DuplicationDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        }
                    }
                    ++crtScreenY;
                    crtTicker = DuplicationDrawDispOddSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DuplicationDrawDispEvenSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = DuplicationDrawDispEvenBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DuplicationDrawDispOddSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DuplicationDrawDispOddBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DuplicationDrawDispEvenBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DuplicationDrawDispEvenDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        DuplicationDrawDispOddBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DuplicationDrawDispOddDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        DuplicationDrawDispEvenDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtDataY + 1);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtDataY);
                }
                crtTicker = DuplicationDrawDispOddFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        DuplicationDrawDispOddDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    CRTC.crtRasterStamp[CRTC.crtDataY] = crtAllStamp;
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtDataY + 1);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtDataY + 1);
                }
                crtTicker = DuplicationDrawDispEvenFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        DuplicationOmitIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = DuplicationOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = DuplicationOmitDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DuplicationOmitIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DuplicationOmitIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DuplicationOmitIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DuplicationOmitIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DuplicationOmitIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DuplicationOmitDispEvenFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = DuplicationOmitDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DuplicationOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DuplicationOmitDispEvenSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DuplicationOmitDispOddFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = DuplicationOmitDispOddSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DuplicationOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DuplicationOmitDispOddSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DuplicationOmitDispEvenSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = DuplicationOmitDispEvenBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DuplicationOmitDispOddSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DuplicationOmitDispOddBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DuplicationOmitDispEvenBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DuplicationOmitDispOddFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DuplicationOmitDispOddBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DuplicationOmitDispEvenFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        InterlaceStart = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (MC68901.mfpGpipHsync != 0) {
                    MC68901.mfpHsyncFall();
                }
                int n2 = crtRasterNumber = crtVIdleStart;
                if (crtRasterCopyOn) {
                    CRTC.crtDoRasterCopy();
                }
                if (n2 == RasterBreakPoint.rbpActiveBreakRaster) {
                    RasterBreakPoint.rbpFire();
                }
                int n3 = n = n2 == crtR09IRQRasterCurr ? 0 : 64;
                if (n != MC68901.mfpGpipRint) {
                    if (n == 0) {
                        if (RasterBreakPoint.rbpIRQBreakEnabled) {
                            RasterBreakPoint.rbpFire();
                        }
                        MC68901.mfpRintFall();
                    } else {
                        MC68901.mfpRintRise();
                    }
                }
                if (MC68901.mfpGpipVdisp != 0) {
                    MC68901.mfpVdispFall();
                }
                crtFrameParity = 0;
                crtClearFrames = 0;
                crtTicker = InterlaceDrawIdleSync;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
            }
        };
        InterlaceDrawIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = InterlaceDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = crtFrameParity;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 2;
                        }
                        crtScreenY = crtFrameParity;
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(2);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = InterlaceDrawDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = InterlaceDrawIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        InterlaceDrawIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = InterlaceDrawIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        InterlaceDrawIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = InterlaceDrawIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        InterlaceDrawDispFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                                CRTC.crtStereoscopicDrawRaster(crtScreenY ^ 1);
                            }
                        }
                        crtScreenY += 2;
                        crtDataY += 2;
                        crtTicker = InterlaceDrawDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                                CRTC.crtStereoscopicDrawRaster(crtScreenY ^ 1);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        crtFrameParity ^= 1;
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = InterlaceDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            CRTC.crtStereoscopicDrawRaster(crtScreenY ^ 1);
                        }
                    }
                    crtScreenY += 2;
                    crtDataY += 2;
                    crtTicker = InterlaceDrawDispSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        InterlaceDrawDispSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = InterlaceDrawDispBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        InterlaceDrawDispBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = InterlaceDrawDispDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        InterlaceDrawDispDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    CRTC.crtRasterStamp[CRTC.crtDataY] = crtAllStamp;
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    int[] nArray = XEiJ.pnlBMLeftArray[XEiJ.pnlBMWrite - 1 & 3];
                    int n = (crtScreenY ^ 1) << 10;
                    System.arraycopy(nArray, n, XEiJ.pnlBM, n, XEiJ.pnlScreenWidth);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        CRTC.crtStereoscopicDrawRaster(crtScreenY ^ 1);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtDataY + 4);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtDataY + 2);
                }
                crtTicker = InterlaceDrawDispFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        InterlaceOmitIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = InterlaceOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = crtFrameParity;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 2;
                        }
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(2);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = InterlaceOmitDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = InterlaceOmitIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        InterlaceOmitIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = InterlaceOmitIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        InterlaceOmitIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = InterlaceOmitIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        InterlaceOmitDispFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = InterlaceOmitDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        crtFrameParity ^= 1;
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = InterlaceOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = InterlaceOmitDispSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        InterlaceOmitDispSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = InterlaceOmitDispBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        InterlaceOmitDispBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = InterlaceOmitDispFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        SlitStart = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (MC68901.mfpGpipHsync != 0) {
                    MC68901.mfpHsyncFall();
                }
                int n2 = crtRasterNumber = crtVIdleStart;
                if (crtRasterCopyOn) {
                    CRTC.crtDoRasterCopy();
                }
                if (n2 == RasterBreakPoint.rbpActiveBreakRaster) {
                    RasterBreakPoint.rbpFire();
                }
                int n3 = n = n2 == crtR09IRQRasterCurr ? 0 : 64;
                if (n != MC68901.mfpGpipRint) {
                    if (n == 0) {
                        if (RasterBreakPoint.rbpIRQBreakEnabled) {
                            RasterBreakPoint.rbpFire();
                        }
                        MC68901.mfpRintFall();
                    } else {
                        MC68901.mfpRintRise();
                    }
                }
                if (MC68901.mfpGpipVdisp != 0) {
                    MC68901.mfpVdispFall();
                }
                crtClearFrames = 0;
                crtTicker = SlitDrawIdleSync;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
            }
        };
        SlitDrawIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = SlitDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtScreenY = 0;
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(1);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = SlitDrawDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = SlitDrawIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        SlitDrawIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = SlitDrawIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        SlitDrawIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = SlitDrawIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        SlitDrawDispFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            crtScanlineEffect.drawRaster(crtScreenY + 1);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                                CRTC.crtStereoscopicDrawRaster(crtScreenY + 1);
                            }
                        }
                        crtScreenY += 2;
                        ++crtDataY;
                        crtTicker = SlitDrawDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            crtScanlineEffect.drawRaster(crtScreenY + 1);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                                CRTC.crtStereoscopicDrawRaster(crtScreenY + 1);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = SlitDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        crtScanlineEffect.drawRaster(crtScreenY + 1);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            CRTC.crtStereoscopicDrawRaster(crtScreenY + 1);
                        }
                    }
                    crtScreenY += 2;
                    ++crtDataY;
                    crtTicker = SlitDrawDispSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        SlitDrawDispSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = SlitDrawDispBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        SlitDrawDispBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = SlitDrawDispDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        SlitDrawDispDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    CRTC.crtRasterStamp[CRTC.crtDataY] = crtAllStamp;
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    crtScanlineEffect.drawRaster(crtScreenY + 1);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        CRTC.crtStereoscopicDrawRaster(crtScreenY + 1);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtDataY + 2);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtDataY + 1);
                }
                crtTicker = SlitDrawDispFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        SlitOmitIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = SlitOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(1);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = SlitOmitDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = SlitOmitIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        SlitOmitIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = SlitOmitIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        SlitOmitIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = SlitOmitIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        SlitOmitDispFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = SlitOmitDispSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = SlitOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = SlitOmitDispSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        SlitOmitDispSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = SlitOmitDispBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        SlitOmitDispBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = SlitOmitDispFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DupExceptSpStart = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (MC68901.mfpGpipHsync != 0) {
                    MC68901.mfpHsyncFall();
                }
                int n2 = crtRasterNumber = crtVIdleStart;
                if (crtRasterCopyOn) {
                    CRTC.crtDoRasterCopy();
                }
                if (n2 == RasterBreakPoint.rbpActiveBreakRaster) {
                    RasterBreakPoint.rbpFire();
                }
                int n3 = n = n2 == crtR09IRQRasterCurr ? 0 : 64;
                if (n != MC68901.mfpGpipRint) {
                    if (n == 0) {
                        if (RasterBreakPoint.rbpIRQBreakEnabled) {
                            RasterBreakPoint.rbpFire();
                        }
                        MC68901.mfpRintFall();
                    } else {
                        MC68901.mfpRintRise();
                    }
                }
                if (MC68901.mfpGpipVdisp != 0) {
                    MC68901.mfpVdispFall();
                }
                crtClearFrames = 0;
                crtTicker = DupExceptSpDrawIdleSync;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
            }
        };
        DupExceptSpDrawIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = DupExceptSpDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtScreenY = 0;
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(1);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = DupExceptSpDrawDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DupExceptSpDrawIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DupExceptSpDrawIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DupExceptSpDrawIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DupExceptSpDrawIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DupExceptSpDrawIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DupExceptSpDrawDispEvenFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        ++crtScreenY;
                        ++crtDataY;
                        crtTicker = DupExceptSpDrawDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DupExceptSpDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        }
                    }
                    ++crtScreenY;
                    ++crtDataY;
                    crtTicker = DupExceptSpDrawDispEvenSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DupExceptSpDrawDispOddFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        ++crtScreenY;
                        crtTicker = DupExceptSpDrawDispOddSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        if (crtBeginningAllStamp != crtAllStamp) {
                            VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                            if (XEiJ.pnlStereoscopicOn) {
                                CRTC.crtStereoscopicDrawRaster(crtScreenY);
                            }
                        }
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DupExceptSpDrawIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    if (crtBeginningAllStamp != crtAllStamp) {
                        VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, true);
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicDrawRaster(crtScreenY);
                        }
                    }
                    ++crtScreenY;
                    crtTicker = DupExceptSpDrawDispOddSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DupExceptSpDrawDispEvenSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = DupExceptSpDrawDispEvenBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DupExceptSpDrawDispOddSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DupExceptSpDrawDispOddBack;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DupExceptSpDrawDispEvenBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DupExceptSpDrawDispEvenDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        DupExceptSpDrawDispOddBack = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DupExceptSpDrawDispOddDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackLength);
            }
        };
        DupExceptSpDrawDispEvenDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtScreenY + 2);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtScreenY + 1);
                }
                crtTicker = DupExceptSpDrawDispOddFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        DupExceptSpDrawDispOddDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if (crtRasterStamp[crtDataY] != crtAllStamp) {
                    CRTC.crtRasterStamp[CRTC.crtDataY] = crtAllStamp;
                    crtBeginningAllStamp = crtAllStamp;
                    VideoController.vcnMode.drawRaster(crtDataY, crtScreenY, false);
                    if (XEiJ.pnlStereoscopicOn) {
                        CRTC.crtStereoscopicDrawRaster(crtScreenY);
                    }
                }
                if (SpriteScreen.sprActive) {
                    SpriteScreen.sprStep1(crtScreenY + 2);
                    SpriteScreen.sprSwap();
                    SpriteScreen.sprStep2(crtScreenY + 1);
                }
                crtTicker = DupExceptSpDrawDispEvenFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHDispLength);
            }
        };
        DupExceptSpOmitIdleFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashIdle << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtR04VFrontEndCurr < n) {
                        crtRasterNumber = 0;
                        n = 0;
                    }
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVDispStart) {
                        crtTicker = DupExceptSpOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispRise();
                        crtR11TxYZero = crtR11TxYCurr;
                        CRTC.crtR13GrYZero[0] = crtR13GrYCurr[0];
                        CRTC.crtR13GrYZero[1] = crtR13GrYCurr[1];
                        CRTC.crtR13GrYZero[2] = crtR13GrYCurr[2];
                        CRTC.crtR13GrYZero[3] = crtR13GrYCurr[3];
                        if (crtR11TxYZeroLast != crtR11TxYZero || crtR13GrYZeroLast[0] != crtR13GrYZero[0] || crtR13GrYZeroLast[1] != crtR13GrYZero[1] || crtR13GrYZeroLast[2] != crtR13GrYZero[2] || crtR13GrYZeroLast[3] != crtR13GrYZero[3]) {
                            crtR11TxYZeroLast = crtR11TxYZero;
                            CRTC.crtR13GrYZeroLast[0] = crtR13GrYZero[0];
                            CRTC.crtR13GrYZeroLast[1] = crtR13GrYZero[1];
                            CRTC.crtR13GrYZeroLast[2] = crtR13GrYZero[2];
                            CRTC.crtR13GrYZeroLast[3] = crtR13GrYZero[3];
                            crtAllStamp += 2;
                        }
                        crtDataY = 0;
                        if (crtClearStandby) {
                            crtClearStandby = false;
                            crtClearFrames = 1;
                        }
                        crtAllStamp += 2;
                        SpriteScreen.sprActive = SpriteScreen.sprLatched;
                        if (SpriteScreen.sprActive) {
                            if ((SpriteScreen.sprReg4BgCtrlCurr & 0x200) == 0) {
                                SpriteScreen.sprLatched = false;
                            }
                            SpriteScreen.sprStep1(0);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep1(1);
                            SpriteScreen.sprSwap();
                            SpriteScreen.sprStep2(0);
                        }
                        if (XEiJ.pnlStereoscopicOn) {
                            CRTC.crtStereoscopicStart();
                        }
                        crtTicker = DupExceptSpOmitDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DupExceptSpOmitIdleSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DupExceptSpOmitIdleSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DupExceptSpOmitIdleBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DupExceptSpOmitIdleBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DupExceptSpOmitIdleFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DupExceptSpOmitDispEvenFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = DupExceptSpOmitDispEvenSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DupExceptSpOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DupExceptSpOmitDispEvenSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DupExceptSpOmitDispOddFront = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                int n;
                if (crtRasterHashDisp << (n = ++crtRasterNumber) < 0L) {
                    int n2;
                    if (crtRasterCopyOn) {
                        CRTC.crtDoRasterCopy();
                    }
                    if (n == RasterBreakPoint.rbpActiveBreakRaster) {
                        RasterBreakPoint.rbpFire();
                    }
                    int n3 = n2 = n == crtR09IRQRasterCurr ? 0 : 64;
                    if (n2 != MC68901.mfpGpipRint) {
                        if (n2 == 0) {
                            if (RasterBreakPoint.rbpIRQBreakEnabled) {
                                RasterBreakPoint.rbpFire();
                            }
                            MC68901.mfpRintFall();
                        } else {
                            MC68901.mfpRintRise();
                        }
                    }
                    if (n != crtVIdleStart) {
                        crtTicker = DupExceptSpOmitDispOddSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    } else {
                        MC68901.mfpVdispFall();
                        if (crtClearFrames != 0) {
                            --crtClearFrames;
                        }
                        if (XEiJ.mpuClockTime >= crtFrameTaskClock) {
                            CRTC.crtDoFrameTask();
                        }
                        XEiJ.pnlBM = XEiJ.pnlBMLeftArray[++XEiJ.pnlBMWrite & 3];
                        crtTicker = DupExceptSpOmitIdleSync;
                        TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                    }
                } else {
                    crtTicker = DupExceptSpOmitDispOddSync;
                    TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHFrontLength);
                }
            }
        };
        DupExceptSpOmitDispEvenSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                if (crtClearFrames != 0) {
                    CRTC.crtRapidClear(crtDataY);
                    CRTC.crtRasterStamp[CRTC.crtDataY] = 0;
                }
                crtTicker = DupExceptSpOmitDispEvenBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DupExceptSpOmitDispOddSync = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncRise();
                crtTicker = DupExceptSpOmitDispOddBackDisp;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHSyncLength);
            }
        };
        DupExceptSpOmitDispEvenBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DupExceptSpOmitDispOddFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
        DupExceptSpOmitDispOddBackDisp = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                MC68901.mfpHsyncFall();
                crtTicker = DupExceptSpOmitDispEvenFront;
                TickerQueue.tkqAdd(crtTicker, crtClock += (long)crtHBackDispLength);
            }
        };
    }

    static enum ScanlineEffect {
        OFF{

            @Override
            public void drawRaster(int n) {
                int n2 = n << 10;
                System.arraycopy(XEiJ.pnlBM, n2 - 1024, XEiJ.pnlBM, n2, XEiJ.pnlScreenWidth);
            }
        }
        ,
        WEAK{

            @Override
            public void drawRaster(int n) {
                int n2;
                int n3 = n2 + XEiJ.pnlScreenWidth;
                for (n2 = n << 10; n2 < n3; n2 += 8) {
                    int n4 = XEiJ.pnlBM[n2 - 1024];
                    XEiJ.pnlBM[n2] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1023];
                    XEiJ.pnlBM[n2 + 1] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1022];
                    XEiJ.pnlBM[n2 + 2] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1021];
                    XEiJ.pnlBM[n2 + 3] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1020];
                    XEiJ.pnlBM[n2 + 4] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1019];
                    XEiJ.pnlBM[n2 + 5] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1018];
                    XEiJ.pnlBM[n2 + 6] = n4 - (n4 >> 3 & 0x1F1F1F);
                    n4 = XEiJ.pnlBM[n2 - 1017];
                    XEiJ.pnlBM[n2 + 7] = n4 - (n4 >> 3 & 0x1F1F1F);
                }
            }
        }
        ,
        MEDIUM{

            @Override
            public void drawRaster(int n) {
                int n2;
                int n3 = n2 + XEiJ.pnlScreenWidth;
                for (n2 = n << 10; n2 < n3; n2 += 8) {
                    int n4 = XEiJ.pnlBM[n2 - 1024];
                    XEiJ.pnlBM[n2] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1023];
                    XEiJ.pnlBM[n2 + 1] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1022];
                    XEiJ.pnlBM[n2 + 2] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1021];
                    XEiJ.pnlBM[n2 + 3] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1020];
                    XEiJ.pnlBM[n2 + 4] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1019];
                    XEiJ.pnlBM[n2 + 5] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1018];
                    XEiJ.pnlBM[n2 + 6] = n4 - (n4 >> 2 & 0x3F3F3F);
                    n4 = XEiJ.pnlBM[n2 - 1017];
                    XEiJ.pnlBM[n2 + 7] = n4 - (n4 >> 2 & 0x3F3F3F);
                }
            }
        }
        ,
        STRONG{

            @Override
            public void drawRaster(int n) {
                int n2;
                int n3 = n2 + XEiJ.pnlScreenWidth;
                for (n2 = n << 10; n2 < n3; n2 += 8) {
                    XEiJ.pnlBM[n2] = XEiJ.pnlBM[n2 - 1024] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 1] = XEiJ.pnlBM[n2 - 1023] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 2] = XEiJ.pnlBM[n2 - 1022] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 3] = XEiJ.pnlBM[n2 - 1021] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 4] = XEiJ.pnlBM[n2 - 1020] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 5] = XEiJ.pnlBM[n2 - 1019] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 6] = XEiJ.pnlBM[n2 - 1018] >> 1 & 0xFF7F7F7F;
                    XEiJ.pnlBM[n2 + 7] = XEiJ.pnlBM[n2 - 1017] >> 1 & 0xFF7F7F7F;
                }
            }
        }
        ,
        BLACK{

            @Override
            public void drawRaster(int n) {
                int n2 = n << 10;
                int n3 = n2 + XEiJ.pnlScreenWidth;
                Arrays.fill(XEiJ.pnlBM, n2, n3, -16777216);
            }
        };


        public abstract void drawRaster(int var1);
    }
}

